/* sj8bitChars.h v00.00.00.jmr
// Mnemonic definitions of the eight bit characters that sJIS is infamous for.
// Generated mostly by the showch8 project.
// Extracted and composed January 2001, 
// Joel Matthew Rees, 
// on the Kakogawa and Kita Kobe Dentetsu lines between Takino (Kato-gun) and 
// Shinkaichi (Kobe-shi) stations, Hyogo, Japan.
//    joel_rees@sannet.ne.jp
// This was, by the way, one of those good ideas that wasn't really.
// It was fun, but wasted a lot of time, 
// and I ended up not getting it right anyway. 
// Added ubyte casts to 8th-bit low half with search-and-replace 12th April 2001.
//
// But it does, however, suggest a good test project for the initial libraries:
// Use the library tests to generate the complete lists!
//
//
// Copyright 2001 Joel Matthew Rees.
//   All rights reserved.
//
// Assignment of Stewardship, or Terms of Use: 
//
// The author grants permission to use and/or redistribute the code in this 
// file, in either source or translated form, under the following conditions:
// 1. When redistributing the source code, the copyright notices and terms of 
//    use must be neither removed nor modified. 
// 2. When redistributing in a form not generally read by humans, the 
//    copyright notices and terms of use, with proper indication of elements 
//    covered, must be reproduced in the accompanying documentation and/or 
//    other materials provided with the redistribution. In addition, if the 
//    source includes statements designed to compile a copyright notice 
//    into the output object code, the redistributor is required to take 
//    such steps as necessary to preserve the notice in the translated 
//    object code.
// 3. Modifications must be annotated, with attribution, including the name(s) 
//    of the author(s) and the contributor(s) thereof, the conditions for 
//    distribution of the modification, and full indication of the date(s) 
//    and scope of the modification. Rights to the modification itself 
//    shall necessarily be retained by the author(s) thereof.
// 4. These grants shall not be construed as an assignment or assumption of 
//    liability of any sort or to any degree. Neither shall these grants be 
//    construed as endorsement or represented as such. Any party using this 
//    code in any way does so under the agreement to entirely indemnify the 
//    author and any contributors concerning the code and any use thereof. 
//    Specifically, THIS SOFTWARE IS PROVIDED AT NO COST, AS IT IS, WITHOUT 
//    ANY EXPRESS OR IMPLIED WARRANTY OF ANY SORT, INCLUDING, BUT NOT LIMITED 
//    TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
//    UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR 
//    ANY DAMAGES WHATSOEVER ARISING FROM ITS USE OR MISUSE, EVEN IF ADVISED 
//    OF THE EXISTENCE OF THE POSSIBILITY OF SUCH DAMAGE.
// 5. This code should not be used for any illegal or immoral purpose, 
//    including, but not limited to, the theft of property or services, 
//    deliberate communication of false information, the distribution of drugs 
//    for purposes other than medical, the distribution of pornography, the 
//    provision of illicit sexual services, the maintenance of oppressive 
//    governments or organizations, or the imposture of false religion and 
//    false science. 
//    Any illegal or immoral use incurs natural and legal penalties, which the 
//    author invokes in full force upon the heads of those who so use it.
// 6. Alternative redistribution arrangements:
//    a. If the above conditions are unacceptable, redistribution under the 
//       following commonly used public licenses is expressly permitted:
//       i.   The GNU General Public License (GPL) of the Free Software 
//            Foundation.
//       ii.  The Perl Artistic License, only as a part of Perl.
//       iii. The Apple Public Source License, only as a part of Darwin or 
//            a Macintosh Operating System using Darwin.
//    b. No other alternative redistribution arrangement is permitted.
//       (The original author reserves the right to add to this list.)
//    c. When redistributing this code under an alternative license, the 
//       specific license being invoked shall be noted immediately beneath 
//       the body of the terms of use. The terms of the license so specified 
//       shall apply only to the redistribution of the source so noted. 
// 7. In no case shall the rights of the original author to the original work 
//    be impaired by any distribution or redistribution arrangement.
//
// End of the Assignment of Stewardship, or terms of use.
//
// License invoked: Assignment of Stewardship.
// Notes concerning license:
//    Compiler directives are strongly encouraged as a means of meeting 
//    the attribution requirements in the Assignment of Stewardship.
*/


#ifndef SJ8BITCHARS_H
#define SJ8BITCHARS_H


#include "sjctypenv.h"


#define	b7_NUL	( (ubyte) '\x00' )	/* 0x00: Null character */
#define	b7_SOH	( (ubyte) '\x01' )	/* 0x01: start of heading */
#define	b7_STX	( (ubyte) '\x02' )	/* 0x02: start of text */
#define	b7_ETX	( (ubyte) '\x03' )	/* 0x03: end of text */
#define	b7_EOT	( (ubyte) '\x04' )	/* 0x04: end of transmission */
#define	b7_ENQ	( (ubyte) '\x05' )	/* 0x05: enquiry */
#define	b7_ACK	( (ubyte) '\x06' )	/* 0x06: acknowledge */
#define	b7_BEL	( (ubyte) '\x07' )	/* 0x07: ring that bell */
#define	b7_BS	( (ubyte) '\x08' )	/* 0x08: backspace, usually destructive */
#define	b7_HT	( (ubyte) '\x09' )	/* 0x09: horizontal tabulation */
#define	b7_LF	( (ubyte) '\x0a' )	/* 0x0a: line feed in output */
#define	b7_VT	( (ubyte) '\x0b' )	/* 0x0b: vertical tabulation */
#define	b7_FF	( (ubyte) '\x0c' )	/* 0x0c: form (page) feed in output */
#define	b7_CR	( (ubyte) '\x0d' )	/* 0x0d: carriage return */
#define	b7_SO	( (ubyte) '\x0e' )	/* 0x0e: shift out */
#define	b7_SI	( (ubyte) '\x0f' )	/* 0x0f: shift in */
#define	b7_DLE	( (ubyte) '\x10' )	/* 0x10: data link escape */
#define	b7_DC1	( (ubyte) '\x11' )	/* 0x11: device control 1 */
#define	b7_DC2	( (ubyte) '\x12' )	/* 0x12: device control 2 */
#define	b7_DC3	( (ubyte) '\x13' )	/* 0x13: device control 3 */
#define	b7_DC4	( (ubyte) '\x14' )	/* 0x14: device control 4 */
#define	b7_NAK	( (ubyte) '\x15' )	/* 0x15: negate acknowledge */
#define	b7_SYN	( (ubyte) '\x16' )	/* 0x16: synchronous idle */
#define	b7_ETB	( (ubyte) '\x17' )	/* 0x17: end of transmission block */
#define	b7_CAN	( (ubyte) '\x18' )	/* 0x18: cancel */
#define	b7_EM	( (ubyte) '\x19' )	/* 0x19: end of medium */
#define	b7_SUB	( (ubyte) '\x1a' )	/* 0x1a: substitute character */
#define	b7_ESC	( (ubyte) '\x1b' )	/* 0x1b: escape character */
#define	b7_FS	( (ubyte) '\x1c' )	/* 0x1c: file separator */
#define	b7_GS	( (ubyte) '\x1d' )	/* 0x1d: group separator */
#define	b7_RS	( (ubyte) '\x1e' )	/* 0x1e: record separator */
#define	b7_US	( (ubyte) '\x1f' )	/* 0x1f: unit separator */
#define	b7_SP	( (ubyte) '\x20' )	/* ' '==0x20: (for visibility) */
#define	b7_EXCLAIM	( (ubyte) '!' )
#define	b7_SECONDS	( (ubyte) '"' )	/* also inches or non-directed double-quote */
#define	b7_HASH	( (ubyte) '#' )	/* also pound or sharp */
#define	b7_DOLLAR	( (ubyte) '$' )
#define	b7_PERCENT	( (ubyte) '%' )
#define	b7_AMPERSAND	( (ubyte) '&' )
#define	b7_MINUTES	( (ubyte) '\'' )	/* also feet, or non-directed/right single-quote, or acute accent */
#define	b7_LEFTPAREN	( (ubyte) '(' )
#define	b7_RIGHTPAREN	( (ubyte) ')' )
#define	b7_ASTERISK	( (ubyte) '*' )
#define	b7_PLUS	( (ubyte) '+' )
#define	b7_COMMA	( (ubyte) ',' )
#define	b7_HYPHEN	( (ubyte) '-' )	/* also minus or dash */
#define	b7_PERIOD	( (ubyte) '.' )
#define	b7_SLASH	( (ubyte) '/' )	/* Did they call this terminus? (No, and I don't care! -- solidus) */
#define	b7_ZERO	( (ubyte) '0' )
#define	b7_ONE	( (ubyte) '1' )
#define	b7_TWO	( (ubyte) '2' )
#define	b7_THREE	( (ubyte) '3' )
#define	b7_FOUR	( (ubyte) '4' )
#define	b7_FIVE	( (ubyte) '5' )
#define	b7_SIX	( (ubyte) '6' )
#define	b7_SEVEN	( (ubyte) '7' )
#define	b7_EIGHT	( (ubyte) '8' )
#define	b7_NINE	( (ubyte) '9' )
#define	b7_COLON	( (ubyte) ':' )
#define	b7_SEMICOLON	( (ubyte) ';' )
#define	b7_LESSTHAN	( (ubyte) '<' )	/* also left angle bracket */
#define	b7_EQUAL	( (ubyte) '=' )	/* but which equal? */
#define	b7_GREATERTHAN	( (ubyte) '>' )	/* also right angle bracket */
#define	b7_QUESTIONMARK	( (ubyte) '?' )
#define	b7_ATEACH	( (ubyte) '@' )	/* at or each */
#define	b7_A	( (ubyte) 'A' )
#define	b7_B	( (ubyte) 'B' )
#define	b7_C	( (ubyte) 'C' )	/* (upper) */
#define	b7_D	( (ubyte) 'D' )
#define	b7_E	( (ubyte) 'E' )
#define	b7_F	( (ubyte) 'F' )
#define	b7_G	( (ubyte) 'G' )
#define	b7_H	( (ubyte) 'H' )
#define	b7_I	( (ubyte) 'I' )	/* (upper case i) */
#define	b7_J	( (ubyte) 'J' )
#define	b7_K	( (ubyte) 'K' )
#define	b7_L	( (ubyte) 'L' )	/* (upper case L) */
#define	b7_M	( (ubyte) 'M' )
#define	b7_N	( (ubyte) 'N' )
#define	b7_O	( (ubyte) 'O' )	/* (upper case oh) */
#define	b7_P	( (ubyte) 'P' )	/* (upper) */
#define	b7_Q	( (ubyte) 'Q' )
#define	b7_R	( (ubyte) 'R' )
#define	b7_S	( (ubyte) 'S' )	/* (upper) */
#define	b7_T	( (ubyte) 'T' )
#define	b7_U	( (ubyte) 'U' )	/* (upper) */
#define	b7_V	( (ubyte) 'V' )	/* (upper) */
#define	b7_W	( (ubyte) 'W' )	/* (upper) */
#define	b7_X	( (ubyte) 'X' )	/* (upper) */
#define	b7_Y	( (ubyte) 'Y' )	/* (upper) */
#define	b7_Z	( (ubyte) 'Z' )	/* (upper) */
#define	b7_LEFTBRACKET	( (ubyte) '[' )
#define	b7_BACKSLASH	( (ubyte) '\\' )	/* also the UNIX, C line/char escape character, Japanese yen */
#define	b7_RIGHTBRACKET	( (ubyte) ']' )
#define	b7_CARET	( (ubyte) '^' )
#define	b7_UNDERSCORE	( (ubyte) '_' )
#define	b7_ACCENTGRAVE	( (ubyte) '`' )	/* or the left single quote */
#define	b7_a	( (ubyte) 'a' )
#define	b7_b	( (ubyte) 'b' )
#define	b7_c	( (ubyte) 'c' )	/* (lower) */
#define	b7_d	( (ubyte) 'd' )
#define	b7_e	( (ubyte) 'e' )
#define	b7_f	( (ubyte) 'f' )
#define	b7_g	( (ubyte) 'g' )
#define	b7_h	( (ubyte) 'h' )
#define	b7_i	( (ubyte) 'i' )	/* (lower case i) */
#define	b7_j	( (ubyte) 'j' )
#define	b7_k	( (ubyte) 'k' )
#define	b7_l	( (ubyte) 'l' )	/* (lower case L) */
#define	b7_m	( (ubyte) 'm' )
#define	b7_n	( (ubyte) 'n' )
#define	b7_o	( (ubyte) 'o' )	/* (lower case oh) */
#define	b7_p	( (ubyte) 'p' )	/* (lower) */
#define	b7_q	( (ubyte) 'q' )
#define	b7_r	( (ubyte) 'r' )
#define	b7_s	( (ubyte) 's' )	/* (lower) */
#define	b7_t	( (ubyte) 't' )
#define	b7_u	( (ubyte) 'u' )	/* (lower) */
#define	b7_v	( (ubyte) 'v' )	/* (lower)(lower) */
#define	b7_w	( (ubyte) 'w' )
#define	b7_x	( (ubyte) 'x' )	/* (lower) */
#define	b7_y	( (ubyte) 'y' )	/* (lower) */
#define	b7_z	( (ubyte) 'z' )	/* (lower) */
#define	b7_LEFTBRACE	( (ubyte) '{' )
#define	b7_VERTICALBAR	( (ubyte) '|' )
#define	b7_RIGHTBRACE	( (ubyte) '}' )
#define	b7_TILDE	( (ubyte) '~' )	/* and sometimes IBM overscore */
#define	b7_DEL	( (ubyte) '\x7f' )	/* The infamous delete character that is not backspace. */


/* Some manufacturers put various non-standard characters in odd places in this gap.
// This file only defines the standard set. 
// Proprietary extensions should be defined elsewhere, of course
// (for company XYZ, something like xyz_x8bitChars.h?).
*/


#define b8_Kuten	( (ubyte) '\xa1' )	/* '' (like period) */
#define b8_LKagiKakko	( (ubyte) '\xa2' )	/* '' (left "key" bracket) */
#define b8_RKagiKakko	( (ubyte) '\xa3' )	/* '' (right "key" bracket) */
#define b8_ToTen	( (ubyte) '\xa4' )	/* '' (like comma) */
#define b8_ChuTen	( (ubyte) '\xa5' )	/* '' (dot, but sort of like hyphen and/or slash) */
/* */
#define b8_katakana_wo	( (ubyte) '\xa6' )	/* '' */
/* */
#define b8_katakanaSub_a	( (ubyte) '\xa7' )	/* '' (subscript) */
#define b8_katakanaSub_i	( (ubyte) '\xa8' )	/* '' (subscript) */
#define b8_katakanaSub_u	( (ubyte) '\xa9' )	/* '' (subscript) */
#define b8_katakanaSub_e	( (ubyte) '\xaa' )	/* '' (subscript) */
#define b8_katakanaSub_o	( (ubyte) '\xab' )	/* '' (subscript) */
#define b8_katakanaSub_ya	( (ubyte) '\xac' )	/* '' (subscript) */
#define b8_katakanaSub_yu	( (ubyte) '\xad' )	/* '' (subscript) */
#define b8_katakanaSub_yo	( (ubyte) '\xae' )	/* '' (subscript) */
#define b8_katakanaSub_tu	( (ubyte) '\xaf' )	/* '' (subscript) (tsu) */
/* */
#define b8_ChoOn	( (ubyte) '\xb0' )	/* '' (syllable lengthening symbol, shaped like {long} dash) */
/* */
#define b8_katakana_a	( (ubyte) '\xb1' )	/* '' "ah" */
#define b8_katakana_i	( (ubyte) '\xb2' )	/* '' "ee" */
#define b8_katakana_u	( (ubyte) '\xb3' )	/* '' "oo" */
#define b8_katakana_e	( (ubyte) '\xb4' )	/* '' "eh" */
#define b8_katakana_o	( (ubyte) '\xb5' )	/* '' "oh" */
#define b8_katakana_ka	( (ubyte) '\xb6' )	/* '' */
#define b8_katakana_ki	( (ubyte) '\xb7' )	/* '' */
#define b8_katakana_ku	( (ubyte) '\xb8' )	/* '' */
#define b8_katakana_ke	( (ubyte) '\xb9' )	/* '' */
#define b8_katakana_ko	( (ubyte) '\xba' )	/* '' */
#define b8_katakana_sa	( (ubyte) '\xbb' )	/* '' */
#define b8_katakana_si	( (ubyte) '\xbc' )	/* '' (shi) */
#define b8_katakana_su	( (ubyte) '\xbd' )	/* '' */
#define b8_katakana_se	( (ubyte) '\xbe' )	/* '' */
#define b8_katakana_so	( (ubyte) '\xbf' )	/* '' */
#define b8_katakana_ta	( (ubyte) '\xc0' )	/* '' */
#define b8_katakana_ti	( (ubyte) '\xc1' )	/* '' (chi==tyi) */
#define b8_katakana_tu	( (ubyte) '\xc2' )	/* '' (tsu) */
#define b8_katakana_te	( (ubyte) '\xc3' )	/* '' */
#define b8_katakana_to	( (ubyte) '\xc4' )	/* '' */
#define b8_katakana_na	( (ubyte) '\xc5' )	/* '' */
#define b8_katakana_ni	( (ubyte) '\xc6' )	/* '' */
#define b8_katakana_nu	( (ubyte) '\xc7' )	/* '' */
#define b8_katakana_ne	( (ubyte) '\xc8' )	/* '' */
#define b8_katakana_no	( (ubyte) '\xc9' )	/* '' */
#define b8_katakana_ha	( (ubyte) '\xca' )	/* '' */
#define b8_katakana_hi	( (ubyte) '\xcb' )	/* '' */
#define b8_katakana_hu	( (ubyte) '\xcc' )	/* '' (fu) {but bi-labial} */
#define b8_katakana_he	( (ubyte) '\xcd' )	/* '' */
#define b8_katakana_ho	( (ubyte) '\xce' )	/* '' */
#define b8_katakana_ma	( (ubyte) '\xcf' )	/* '' */
#define b8_katakana_mi	( (ubyte) '\xd0' )	/* '' */
#define b8_katakana_mu	( (ubyte) '\xd1' )	/* '' */
#define b8_katakana_me	( (ubyte) '\xd2' )	/* '' */
#define b8_katakana_mo	( (ubyte) '\xd3' )	/* '' */
#define b8_katakana_ya	( (ubyte) '\xd4' )	/* '' */
/* No "yi". */
#define b8_katakana_yu	( (ubyte) '\xd5' )	/* '' */
/* No "ye". */
#define b8_katakana_yo	( (ubyte) '\xd6' )	/* '' */
#define b8_katakana_ra	( (ubyte) '\xd7' )	/* '' (la) */
#define b8_katakana_ri	( (ubyte) '\xd8' )	/* '' (li) */
#define b8_katakana_ru	( (ubyte) '\xd9' )	/* '' (lu) */
#define b8_katakana_re	( (ubyte) '\xda' )	/* '' (le) */
#define b8_katakana_ro	( (ubyte) '\xdb' )	/* '' (lo) */
#define b8_katakana_wa	( (ubyte) '\xdc' )	/* '' */
/* There is no "wi", "wu", or "we"; "wo" is up front for some reason.  */
#define b8_katakana_ng	( (ubyte) '\xdd' )	/* '' ('n==nasal syllable) */
/* */
#define b8_DakuTen	( (ubyte) '\xde' )	/* '' (muddying==voicing symbol, shaped like double quote mark) */
#define b8_HandakuTen	( (ubyte) '\xdf' )	/* '' (half-muddying==plosive symbol, shaped like degree symbol) */


/* Some manufacturers put various non-standard characters in odd places in this gap, also.
// As noted above, this file only defines the standard set. 
*/


#endif /* ifndef SJ8BITCHARS_H */

