/* Subtraction functions for an eight-bit framework 
// for testing various arithmetic techniques.
// Written by Joel Matthew Rees
// Copyright 2013, Joel Matthew Rees
// Distribution and use permitted under terms of the GPL v. 3,
// See the included file, LICENSE.TXT,
// or on-line at <http://www.gnu.org/licenses/>. 
*/

#include <limits.h>

#include "nibBit.h"


/* Push order: left right 
// return order: lsbyte msbyte
// (most significant on bottom)
*/
void nibDSub( void )
{
   uchar_t accmLo = NIBLO( mySP[ 3 ] ) - NIBLO( mySP[ 1 ] );
   uchar_t accmHi = NIBHIDOWN( mySP[ 3 ] ) - NIBHIDOWN( mySP[ 1 ] ) 
                  - NIBCARRYBIT( accmLo );

   mySP[ 3 ] = NIBLOUP( accmHi ) | NIBLO( accmLo );
   accmLo = NIBLO( mySP[ 2 ] ) - NIBLO( mySP[ 0 ] )
          - NIBCARRYBIT( accmHi );
   accmHi = NIBHIDOWN( mySP[ 2 ] ) - NIBHIDOWN( mySP[ 0 ] ) 
          - NIBCARRYBIT( accmLo );
   mySP[ 2 ] = NIBLOUP( accmHi ) | NIBLO( accmLo );
   mySP += 2;
}


