/* Multiplication tester for an eight-bit framework 
// for testing various arithmetic techniques.
// Written by Joel Matthew Rees
// Copyright 2013, Joel Matthew Rees
// Distribution and use permitted under terms of the GPL v. 3,
// See the included file, LICENSE.TXT,
// or on-line at <http://www.gnu.org/licenses/>. 
*/


#include <stdio.h>

#include "nibBit.h"


int main( int argc, char * argv[] )
{  unsigned i, j;
   long bad = 0;
   long limit = 0xff;

   if ( argc > 1 )
   {  char * scan;
      limit = strtoul( argv[ 1 ], &scan, 0 );
   }

   initMyStack();

   mySP -= 2;
   for ( i = 0; i <= limit; ++i )
   {  for ( j = 0; j <= limit; ++j )
      {  unsigned product = i * j;
         unsigned synthetic;
         mySP[ 1 ] = i; 
         mySP[ 0 ] = j; 
         nibUMul();
         synthetic = ( mySP[ 0 ] << BYTEBITS ) | mySP[ 1 ];
         if ( product != synthetic )
         {  bad += 1;
            printf( "bad %ld(%d %d): i * j = 0x%04x, synth(i,j) = 0x%04x\n",
                    bad, i, j, product, synthetic );
         }
      }
   }
   printf( "bad count: %ld\n", bad );

   return bad;
}
