/* Addition tester for an eight-bit framework 
// for testing various arithmetic techniques.
// Written by Joel Matthew Rees
// Copyright 2013, Joel Matthew Rees
// Distribution and use permitted under terms of the GPL v. 3,
// See the included file, LICENSE.TXT,
// or on-line at <http://www.gnu.org/licenses/>. 
*/


#include <stdio.h>

#include "nibBit.h"


int main( int argc, char * argv[] )
{  unsigned i, j;
   long bad = 0;
   long rangeMiss = 0;
   long start = 0;
   long limit = 0xffff;
   /* long rangeCount = limit - start + 1; */
   long long runningCount = 0;

   if ( argc > 2 )
   {  char * scan;
      start = strtoul( argv[ 1 ], &scan, 0 );
      limit = strtoul( argv[ 2 ], &scan, 0 );
   }
   else if ( argc > 1 )
   {  char * scan;
      limit = strtoul( argv[ 1 ], &scan, 0 );
   }

   initMyStack();

   for ( i = start; i <= limit; ++i )
   {  for ( j = start; j <= limit; ++j )
      {  unsigned sum = i + j;
         unsigned synthetic;
         ( * --mySP ) = (uchar_t) i; 
         ( * --mySP ) = (uchar_t) ( i >> BYTEBITS ); 
         ( * --mySP ) = (uchar_t) j; 
         ( * --mySP ) = (uchar_t) ( j >> BYTEBITS );
         nibDAdd();
/* Why doesn't the compiler seem to understand this? 
// Intel's byte order shenanigans?
// Oh. Bit or is not a time point, and some stupid says right to left.
// Yeah, blame it on Intel's little-endian.
//         synthetic = ( ( * mySP++ ) << BYTEBITS ) | ( * mySP++ );
*/
         synthetic = ( * mySP++ ) << BYTEBITS;
         synthetic |= ( * mySP++ );
         ++runningCount;
         if ( sum != synthetic )
         {  if ( ( sum > 0xffff ) && ( ( sum & 0xffff ) == synthetic ) )
            {  rangeMiss += 1;
/*
               printf( "out-of-range(%ld): ", rangeMiss );
               printf( "%ud + %ud = %ud synth: %ud\n",
                       i, j, sum, synthetic );
               printf( "0x%05x + 0x%05x = 0x%05x synth: 0x%05x\n",
                       i, j, sum, synthetic );
*/
            }
            else
            {  bad += 1;
               printf( "*** bad(%ld): ", bad );
               printf( "%ud + %ud = %ud synth: %ud\n",
                       i, j, sum, synthetic );
               printf( "0x%05x + 0x%05x = 0x%05x synth: 0x%05x\n",
                       i, j, sum, synthetic );
            }
         }
      }
      printf( "i: %x -- Range miss: %ld, bad count: %ld (of %lld)\n",
              i, rangeMiss, bad, runningCount );
   }

   return bad;
}
