/* Multiplication functions for an eight-bit framework 
// for testing various arithmetic techniques.
// Written by Joel Matthew Rees
// Copyright 2013, Joel Matthew Rees
// Distribution and use permitted under terms of the GPL v. 3,
// See the included file, LICENSE.TXT,
// or on-line at <http://www.gnu.org/licenses/>. 
*/

#include <limits.h>

#include "nibBit.h"


/* Push order: left right 
// return order: lsbyte msbyte
// (most significant on top-of-stack -- low address)
*/
void nibUMul( void )
{
   uchar_t leftHi = NIBHIDOWN( mySP[ 1 ] ); 
   uchar_t leftLo = NIBLO( mySP[ 1 ] );
   uchar_t rightHi = NIBHIDOWN( mySP[ 0 ] );
   uchar_t rightLo = NIBLO( mySP[ 0 ] );
   uchar_t rLo = leftLo * rightLo;
   uchar_t rMid1 = leftLo * rightHi;
   uchar_t rMid2 = leftHi * rightLo;
   uchar_t accm = NIBHIDOWN( rLo ) + NIBLO( rMid1 ) + NIBLO( rMid2 );

   mySP[ 1 ] = NIBLO( rLo ) | NIBLOUP( accm );
   accm >>= NIBCT;
   mySP[ 0 ] = accm + leftHi * rightHi 
               + NIBHIDOWN( rMid1 ) + NIBHIDOWN( rMid2 );
}


