	.list ON, EXP
	
; Error handling and other message definitions for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.03.15

; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------

; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	error, code


; This list was originall borrowed from BIF,
; *** so it has some that aren't relevant! ***
;
errNONE:				.equ	0
;	FCC	"DATA STACK UNDERFLOW                                            " 1
errSTACK_UNDERFLOW:		.equ	1
;	FCC	"DICTIONARY FULL                                                 " 2
;	FCC	"ADDRESS RESOLUTION ERROR                                        " 3
;	FCC	"HIDES DEFINITION IN                                             " 4
;	FCC	"NULL VECTOR WRITTEN                                             " 5
;	FCC	"DISC RANGE?                                                     " 6
;	FCC	"DATA STACK OVERFLOW                                             " 7
;	FCC	"DISC ERROR!                                                     " 8
;	FCC	"CAN'T EXECUTE A NULL!                                           " 9
;	FCC	"CONTROL STACK UNDERFLOW                                         " 10
;	FCC	"CONTROL STACK OVERFLOW                                          " 11
;	FCC	"ARRAY REFERENCE OUT OF BOUNDS                                   " 12
;	FCC	"ARRAY DIMENSION NOT VALID                                       " 13
;	FCC	"NO PROCEDURE TO ENTER                                           " 14
;	FCC	"               ( WAS REGISTER )                                 " 15
;* SCREEN 5
;	FCC	"                                                                " 0
;	FCC	"COMPILATION ONLY, USE IN DEF                                    " 1
errCOMPILE_ONLY:			.equ	h'11
;	FCC	"EXECUTION ONLY                                                  " 2
errEXECUTE_ONLY:			.equ	h'12
;	FCC	"CONDITIONALS NOT PAIRED                                         " 3
errUNBALANCED_CONDITIONALS:	.equ	h'13
;	FCC	"DEFINITION INCOMPLETE                                           " 4
errDEFINITION_INCOMPLETE:	.equ	h'14	
;	FCC	"IN PROTECTED DICTIONARY                                         " 5
;	FCC	"USE ONLY WHEN LOADING                                           " 6
errLOADING_ONLY:			.equ	h'16
;	FCC	"OFF CURRENT EDITING SCREEN                                      " 7 
;	FCC	"DECLARE VOCABULARY                                              " 8
;	FCC	"DEFINITION NOT IN VOCABULARY                                    " 9
;	FCC	"IN FORWARD BLOCK                                                " 10
;	FCC	"ALLOCATION LIST CORRUPTED: LOST                                 " 11
;	FCC	"CAN'T REDEFINE nul!                                             " 12
;	FCC	"NOT FORWARD REFERENCE                                           " 13
;	FCC	"              ( WAS IMMEDIATE )                                 " 14
;	FCC	"                                                                " 15
;* SCREEN 6
;	FCC	"( MORE ERROR MESSAGES asm6809 )                                 " 0
;	FCC	"HAS INCORRECT ADDRESS MODE                                      " 1
;	FCC	"HAS INCORRECT INDEX MODE                                        " 2
;	FCC	"OPERAND NOT REGISTER                                            " 3
;	FCC	"HAS ILLEGAL IMMEDIATE                                           " 4
;	FCC	"PC OFFSET MUST BE ABSOLUTE                                      " 5
;	FCC	"ACCUMULATOR OFFSET REQUIRED                                     " 6
;	FCC	"ILLEGAL MEMORY INDIRECTION  (6809)                              " 7
;	FCC	"ILLEGAL INDEX BASE (6809)                                       " 8
;	FCC	"ILLEGAL TARGET SPECIFIED                                        " 9
;	FCC	"CAN'T STACK ON SELF (6809)                                      " 10
;	FCC	"DUPLICATE IN LIST                                               " 11
;	FCC	"REGISTER NOT STACK (6809)                                       " 12
;	FCC	"EMPTY REGISTER LIST (6809)                                      " 13
;	FCC	"IMMEDIATE OPERAND REQUIRED                                      " 14
;	FCC	"REQUIRES CONDITION                                              " 15
;* 
;* SCREEN 7
;	FCC	"                                                                " 0
;	FCC	"COMPILE-TIME STACK UNDERFLOW                                    " 1
;	FCC	"COMPILE-TIME STACK OVERFLOW                                     " 2


; ?ERROR  ( 0 n --- )             ( *** )
;         ( true n --- IN BLK )   ( anything *** nothing )
;         If flag is false, do nothing. 
;         If flag is true, issue error MESSAGE and QUIT or ABORT, via ERROR.
;         Leaves cursor position (IN) and currently loading block number (BLK) on stack,
;         for later analysis.
;
	HIHEADER	"?ERROR", QERR, DOCOL
	.data.l	SWAP,ZBRAN
	mTARGET QERRnone
	.data.l	ERROR,BRAN
	mTARGET	QERRleave
QERRnone:
	.data.l	DROP
QERRleave:
	.data.l	SEMIS





