	.list ON, EXP
	
; Compiling definitions and their primitives for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.03.11

; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------

; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	compiler, code


; :       ( --- )                                                 P
;         { : name sundry-stuff ; } typical input
;
;         If executing, record the data stack mark in CSP, CREATE a
;         header, compile a call to DOCOL, and set state to compile. 
;
;         The interpreter will remain in a compiling state, 
;         compiling as literals the characteristic addresses 
;         of all non-IMMEDIATE symbols (words) it scans, 
;         until it scans a terminating (IMMEDIATE) symbol such as 
;         ";" or ";CODE".
;
;         CONTEXT (interpretation) vocabulary is set to CURRENT.
;
; DOCOL   ( *** IP )
;         Characteristic of a colon (:) definition.  Begins execution of a
;         high-level definition, i. e., nests the definition and begins
;         processing icodes. 
;
;         In the low-level description, it pushes the IP
;         and loads the Parameter Field Address of the definition which
;         called it into the IP.
;
;         SEMIS un-nests out of list interpretation.
;         DOCOL nests in.
;         This is the way that lists get interpreted.
;
;         Should DOCOL have a header? 
;         -- The fig model for 6800 does not give it one.
;
;         See NEXT loop.
;
	HIHEADER	":", COLON, DOCOL, MIMM
	.data.l	QEXEC,SCSP,CURENT,AT,CONTXT,STORE
	.data.l	CREATE,RBRAK
	.data.l	PSCODE
DOCOL:
_fDOCOL:
	mov.l	fIP, @-fRP	; Remember where we were.
	mov 	fW, fIP		; fW is still pointing at the characteristic (CFA).
	rts
	add 	#NATURAL_SIZE, fIP	; bump it before we start


; ;       ( --- )                                                 P
;         { : name sundry-stuff ; } typical input
;         ERROR check data stack against mark in CSP, compile ;S, unSMUDGE
;         LATEST definition, and set state to interpretation.
;
	HIHEADER	";", SEMI, DOCOL
	.data.l	QCSP,COMPIL,SEMIS,SMUDGE,LBRAK
	.data.l	SEMIS


; CONSTANT        ( n --- )
;         { value CONSTANT name } typical input
;         CREATE a header, compile a call to DOCON, 
;         compile the constant value.
;
; DOCON   ( --- n ) 
;         Characteristic of a CONSTANT.  A CONSTANT simply loads its value
;         from its parameter field and pushes it on the stack.
;
	HIHEADER	CONSTANT, CON, DOCOL
	.data.l	CREATE,SMUDGE,COMMA,PSCODE
DOCON:
_fDOCON:
	mov.l	@(NATURAL_SIZE,fW), r0
	rts
	mov.l	r0, @-fSP


; VARIABLE        ( init --- )
;         { init VARIABLE name } typical input
;         CREATE a header, compile a call to XVAR, compile the initial
;         value init.
;
; DOVAR   ( --- vadr )    jsr <XVAR (bif.m, bifdp.a)
;         Characteristic of a VARIABLE.  A VARIABLE pushes its PFA address
;         on the stack.  The parameter field of a VARIABLE is the actual
;         allocation of the variable, so that pushing its address allows
;         its contents to be @ed (fetched).  Ordinary arrays and strings
;         that do not subscript themselves may be allocated by defining a
;         variable and immediately ALLOTting the remaining space.
;         VARIABLES are global to all users, and thus should have been
;         hidden in resource monitors, but aren't.
;
	HIHEADER	VARIABLE, VAR, DOCOL
	.data.l	CON,PSCODE
DOVAR:
_fDOVAR:
	add 	#NATURAL_SIZE, fW
	rts
	mov.l	fW, @-fSP


; USER    ( u --- )
;         { uoffset USER name } typical input
;         CREATE a header, compile a call to DOUSER, 
;         compile the unsigned offset.
;         The offset is treated by DOUSER as an offset into the 
;         per-user variable table. 
;
;         The HUMAN user is entirely responsible for maintaining allocation!
;
; DOUSER  ( --- vadr ) 
;         Characteristic of a per-USER variable. USER variables are
;         similiar to VARIABLEs, but are allocated (by hand!) in the
;         per-user table.  A USER variable's parameter field contains its
;         offset in the per-user table.
;
;         DOUSER adds the compiled offset to the base of the per-user table
;         and pushes the resulting address.
;
	HIHEADER	USER, USER, DOCOL
	.data.l	CON,PSCODE
DOUSER:
_fDOUSER:
	mov.l	@(NATURAL_SIZE,fW), r0
	add 	fUP, r0
	rts
	mov.l	r0, @-fSP	


; CURRENT  ( --- vadr )
;          NFA of LATEST definition.  Not fig.
;          Pointer to the current compiling vocabulary. 
;
;          See CONTEXT and VOC-LINK.
;
	HIHEADER	CURRENT, CURENT, DOUSER
	.data.l	XCURR


; STATE    ( --- vadr )
;          Compiler/interpreter state.
;
	HIHEADER	STATE, STATE, DOUSER
	.data.l	XSTATE	;	Non-zero if compiling, 0 if not
	

; CSP      ( --- vadr )
;          Compiler stack mark for stack check.
;          (The so-called "compiler security" feature.)
;
	HIHEADER	CSP, CSP, DOUSER
	.data.l	XCSP


; HERE   ( --- adr )
;        Get contents of DP, or the current allocation location.
;        More than a pseudo-constant.
;        Kind of like the here symbol in assemblers.
;
	HIHEADER	HERE, HERE, DOCOL
	.data.l	DP,AT
	.data.l	SEMIS


; ALLOT  ( n --- )
;        Increase/decrease heap allocation mark (add signed n to DP).
;
	HIHEADER	ALLOT, ALLOT, DOCOL
	.data.l	DP,PSTORE
	.data.l	SEMIS


; ,      ( n --- )
;        Store natural word n at DP+.
;        (Store and allocate, which is the wrong order for things.)
;
	HIHEADER	",", COMMA, DOCOL
	.data.l	HERE,STORE,NWIDTH,ALLOT
	.data.l	SEMIS



; C,     ( b --- )
;        Store byte b at DP+.
;        (Store and allocate, which is the wrong order for things.)
;
	HIHEADER	"C,", CCOMM, DOCOL
	.data.l	HERE,CSTORE,ONE,ALLOT
	.data.l	SEMIS


; !CSP    ( --- )
;         Save the parameter stack pointer in CSP for compiler checks.
	HIHEADER	"!CSP", SCSP, DOCOL
	.data.l	SPAT,CSP,STORE
	.data.l	SEMIS


; ?COMP   ( --- )                 ( *** )
;         ( --- IN BLK )          ( anything *** nothing )
;         ERROR if not compiling.
;
	HIHEADER	"?COMP", QCOMP, DOCOL
	.data.l	STATE,AT,ZEQU,LIT
	.data.l	errCOMPILE_ONLY
	.data.l	QERR
	.data.l	SEMIS


; ?PAIRS  ( n1 n2 --- )           ( *** )
;         ( n1 n2 --- IN BLK )    ( anything *** nothing )
;         ERROR if n1 and n2 are unequal.
;   
;         MESSAGE says compiled conditionals do not match.
;
	HIHEADER	"?PAIRS", QPAIRS, DOCOL
	.data.l	SUB,LIT
	.data.l	errUNBALANCED_CONDITIONALS
	.data.l	QERR
	.data.l	SEMIS


; ?CSP    ( --- )                 ( *** )
;         ( --- IN BLK )          ( anything *** nothing )
;         ERROR if parameter stack is not at same level as last !CSP.
;
;         MESSAGE says a definition has been left incomplete.
;
	HIHEADER	"?CSP", QCSP, DOCOL
	.data.l	SPAT,CSP,AT,SUB,LIT
	.data.l	errDEFINITION_INCOMPLETE
	.data.l	QERR
	.data.l	SEMIS


; COMPILE ( --- )
;         Compile an in-line literal value from the instruction stream.
;
	HIHEADER	COMPILE, COMPIL, DOCOL
	.data.l	QCOMP,FROMR,NATPLUS,DUP,TOR,AT,COMMA
	.data.l	SEMIS


COMPILE_MODE:	.equ	h'C0


; [      ( --- )                                         P
;        Clear the compile state bits (shift to interpret).
;        { : symbol compiled-stuff [ compile-time-stuff ] more-compiled-stuff ; } typical use
;
;        Sometimes you need to do something run-time at compile-time.
;        For example, you may not know a constant's actual value 
;        until the source is compiled. But it will be a real constant,
;        so you don't want to compile in the calculation.
;
;        (This is one of the killer features of FORTH.
;        It seriously reduces the burden on the optimizer, when there is one.)
;
	HIHEADER	"[", LBRAK, DOCOL, MIMM
	.data.l	ZERO,STATE,STORE
	.data.l	SEMIS


; ]       ( --- )
;         Set the compile state bits. (Shift back to compiling.)
;         See [.
;
	HIHEADER	"[", RBRAK, DOCOL
	.data.l	LIT
	.data.l	COMPILE_MODE
	.data.l	STATE,STORE
	.data.l	SEMIS


; SMUDGE  ( --- )
;         Toggle HIDDEN bit of LATEST definition header, 
;         to hide it until defined, or reveal it after definition.
;
;         It helps keep symbol table lookup simple in the compiler.
;
	HIHEADER	SMUDGE, SMUDGE, DOCOL
	.data.l	LATEST,LIT
	.data.l	MHID
	.data.l	TOGGLE
	.data.l	SEMIS



; [COMPILE]       ( --- )                                         P
;         { [COMPILE] name } typical use
;         -DFIND next WORD and COMPILE it, literally; used to compile
;         immediate definitions.
;[COMPILE]                                       p,C
;        Used in a colon-definition in form:
;                         :  xxx    [COMPILE]   FORTH   ;
;        [COMPILE] will force the compilation of an immediate definitions,
;        that would otherwise execute during compilation. The above example
;        will select the FORTH vocabulary then xxx executes, rather than at
;        compile time.
;
;

