; Memory map and other global definitions for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.02.25
; 
; Borrowing heavily from the fig FORTH 6800 model by Dave Lion, et. al.,
; and from the bif-6809 near-fig FORTH by the author of this code.
;
; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------


	.cpu	sh3

NATURAL_SIZE:	.equ	4	; 4 byte word
ALL_BITS:		.equ	H'FFFFFFFF


; The SH-3 has modern dev tools, so we don't have to pay much attention 
; to memory layout,
; but we do want to keep the following virtual map in mind:

; ------------
; low address:
; JMP to start (But, no. Handled through the reset code.)
; 
; Global constants table
;
; machine-level initialization code
;
; primatives (ROMmable), including inner interpreter
;
; utility definitions (ROMmable)
;
; normal expression use definitions (ROMmable)
;
; the outer FORTH interpreter (ROMmable)
;
; development use definitions (ROMmable)
; 
; high address of ROMmable part
; -----------------------------


; r0 must be used for many intermediate values.
; r0 -- r7 are bank-switched on interrupt.
; r8 -- r15 are not bank-switched on interrupt.
; All registers have to be explicitly saved during a full task-switch, 
; but the supervisor monitor code can keep a lot of context in the bank-switched part.

; Registers that should be in r8 -- r15 are (as much as possible)
; * temporaries that we agree to explicitly save;
; * true globals (global contant tables, global library pointers, etc.);
; * and per-task globals that have no parallel in the supervisor, if there are any.
; * And the flow-of-control stack pointer, maybe.

; For system calls, accessing the switched bank is not too hard.

; FORTH tracks the call/return sequence in a separate stack from the parameters.
fRP:	.reg	r15	; control/Return stack Pointer
fSP:	.reg	r7	; parameter Stack Pointer

; fig-FORTH has primitive multi-tasking, with a per-User table of variables
fUP:	.reg	r6	; User (task/thread/process) base Pointer

fIP:	.reg	r5	; virtual Instruction Pointer

; Defined symbols (objects/routines) are called "WORDs" in classic FORTH.
fW:		.reg	r4	; currently executing Word definition pointer
;
; By keeping the FORTH model in registers
; that the SH3 bank-switches out during interrupts, 
; we can save a lot of time during interrupt processing.


; mode flags (to go with the length byte):
MIMM	.equ H'40	; precedence is IMMEDIATE execution (in length byte -- NFA)
MHID	.equ H'20	; SMUDGEd definition (in length byte -- NFA)


_LASTNAME:	.assign	0	; allocation/dictionary link (terminated by zero)

	.macro	HEADER	name, characteristic, mode=0
; Symbol name length and mode (Too much stuff in one byte, really.)
	.data.b	(.len("\name")&H'1f)|\mode|H'80
; Symbol name
_s\characteristic:	.sdata	.substr("\name", 0, .len("\name")-1)
; Terminate the name with high bit set (bad news for multi-byte names).
	.data.b	.substr("\name", .len("\name")-1, 1)+H'80
; Symbol names float, yes this is a bit awkward.
	.align	NATURAL_SIZE
; Link to previously defined symbol's header.
	.data.l	_LASTNAME
; Use the SH-3 assembler to track the last symbol. 
; (This is not always a good idea.)
_LASTNAME:	.assign _s\characteristic
; Point to the characteristic code for this Word (symbol) to execute.
\characteristic	.equ	$
	.data.l	_p\characteristic
; Point to the "parameter" area of the symbol.
_p\characteristic	.equ $
; This area will contain executable code for primitive (leaf) definitions.
; It will contain a list of virtual instructions for non-primitive (non-leaf) definitions.
; For language global/static constants and variables, it will contain the actual value.
; For per-User constants and variables, it will contain the offset in the user table.
; And so (ahem) forth.
	.endm


; More as an example than to be actually used:
	.macro	fSAFECALL	cfa
	sts.l	pr, @-fRP
	mov.l	imm\@, fW
	jsr 	@fW
	nop
	bra 	exit\@
	nop
imm\@:
	.data.l		\cfa
exit\@:
	lds.l	@fRP+
	.endm


