# MPL Ad

Ad for Resident MPL Compiler from this [1979
Microcomputer Development Systems
Catalog](http://www.mirrorservice.org/sites/www.bitsavers.org/pdf/motorola/_catalogs/1979_microcomputer_development_systems.pdf). 

> ## M68MPLR010M Resident MPL Compiler

> MPL is an EXORciser-compatible, high-level, user-oriented
> programming language for the Motorola M6800 series Microprocessor.  The
> language is a subset of PL/I with features chosen for applicability to the
> Microprocessor environment.

> MPL was designed to simplify the translation from functional
> requirements for a microprocessor application to an operating M6800 program. 
> The MPL language and its associated compiler provide a powerful software
> tool which can significantly reduce the time and costs associated with
> microprocessor software development and maintenance.

>* EXORciser and EXORterm Resident
>* Based on PL/I, a Powerful High-Level Programming Language Widely Known and Used
>* Supports Free Format, Block Structured Input
>* Allows Embedded Assembly language

> ## System Configuration

> The minimum system configuration is:

>* An EXORciser or EXORterm 200
>* An EXORdisk II Floppy Disk System
>* 56K bytes of memory
>* An EXORciser-compatible terminal
>* Macro Assembler/Linking Loader Software
>* Editor

> ## MPL Advantages

>* Easy to Learn - The user orientation of MPL results in reduced training requirements and short project start-up times.
>* Easy to Read - The self-documenting nature of MPL simplifies software maintenance and product enhancement.
>* Easy to Write - User-oriented statement forms and free-format input simplify program writing.  The MPL block structure encourages software modularity and structured programming.
>* Easy to Debug - A high-level language permits an emphasis on debugging algorithms and design flaws rather than on the details of an assembly language implementation.
>* Easy to Optimize - Assembly language output and the use of embedded assembly language allow the optimization of certain program segments for execution speed or memory space, without writing an entire program in assembly language.  Calls to assembly laguage subroutines involve very little overhead.
>* Easy to Upgrade - Programs written in MPL for the M6800 will be translatable to future Motorla microprocessor products by recompiling, not rewriting.
>* Easy to Use
>  * Higher productivity for software development
>  * Lower software costs
>  * Shorter design cycles
>  * Easier product modification

> ## Language Features

>* Standard PL/I Statements
>  * PROCEDURE
>  * DECLARE statement with INITIAL, DEFINED, BASED attributes
>  * IF, THEN, ELSE statement
>  * DO statement with TO, BY, WHILE clauses
>  * Assignment statement
>  * GOTO
>  * Subroutine CALL
>  * RETURN
>  * BEGIN
>  * END
>* Data Types
>  * Bit
>  * Binary (1 or 2 bytes, signed or unsigned)
>  * Decimal (signed or unsigned)
>  * Character
>  * Label
>* Data Classes
>  * Multidimensional arrays
>  * Structures
>  * Scalers
>  * Pointers
>* Arithmetic, Relational, and Logical Operaitons
>  * Multiplication
>  * Division
>  * Subtraction
>  * Addition
>  * Shift
>  * Bitwise AND, OR, Exclusive OR
>  * EQ NE, LT, GT, LE, GE
>  * AND, OR, NOT
>* Extensions
>  * Address Constants
>  * Computed GOTO
>  * Embedded assembly language statements
>  * Extensions for relocatability
>  * GLOBAL and EXTERNAL variables
