
#ifndef __CCONQUESTSCENE_H__
#define __CCONQUESTSCENE_H__

#include "..\..\CommonIncludes.h"
#include "..\..\01_BaseClasses\CSceneBase.h"
#include "..\..\00_ManagementClasses\CMapCellManager.h"

class CConquestScene : public CSceneBase
{
public :
	enum ESituationType {
		BEGIN,
		ACTION,
		SWITCH_MAPCELL_FADE_OUT,
		SWITCH_MAPCELL_FADE_IN,
	};

	CConquestScene( void );
	~CConquestScene( void );
	void Run( CImageManager* arg_pinImageManager,
	          CAllKeysState* arg_pinAllKeysState );
	
	ESituationType GetSituationType( void );
	void           SetSituationType( ESituationType );

	CMapCellManager::ESwitchType GetSwitchType( void );
	void                         SetSwitchType( ESituationType );
	
private :
	enum EFadeType {
		FADE_OUT,
		FADE_IN,

		NOT_FADE,
	};

	const static int FADE_OUT_IN_COUNT_TOTAL = 6;
	const static int FADE_ALPHA[FADE_OUT_IN_COUNT_TOTAL];
	
	// Ó]tO
	EFadeType m_eFadeType;

	// Ó]Aj[Vpϐ
	int m_iFadeOutInCount;

	
	ESituationType eSituationType;
	CMapCellManager::ESwitchType eSwitchType;
	
	CMapCellManager* m_pinMapCellManager;
	std::unique_ptr<CProtagonistCharacter> m_pinProtagonistCharacter;


	void FadeOut( CImageManager* arg_pinImageManager );
	void FadeIn(  CImageManager* arg_pinImageManager );

};


#endif

