#include "stdafx.h"
#include "nlite_include.h"

namespace nlite{

Exception::Exception(){}

Exception::Exception(const char* const& errMessage):exception(errMessage){}

Exception::Exception(const wchar_t * const & errMessage,UINT_PTR in_line,LPCTSTR in_fileName,LPCTSTR in_function):
	wErrMessage(errMessage),
	line(in_line),
	function(in_function)
{
	WCHAR file[_MAX_FNAME];
	WCHAR ext[_MAX_EXT];
	_wsplitpath(in_fileName,(wchar_t*)NULL,(wchar_t*)NULL,file,ext);
	fileName = file;
	fileName += ext;

}

LPCTSTR Exception::what(){

	return wErrMessage;

}

UINT_PTR Exception::getLineNo(){

	return line;
}

LPCTSTR Exception::getFileName(){
			
	return fileName;
		
}

LPCTSTR Exception::getFunctionName(){

	return function;
}


AppInitException::AppInitException(UINT_PTR in_line,LPCTSTR in_fileName,LPCTSTR in_function):Exception(TEXT("AvP[VɎs܂"),in_line,in_fileName,in_function){}



NLIBException::NLIBException(LPCTSTR errmessage,NLIB_RESULT rslt,UINT_PTR in_line,LPCTSTR in_fileName,LPCTSTR in_function):errcode(rslt),Exception(errmessage,in_line,in_fileName,in_function){}

NLiveException::NLiveException(LPCTSTR errmessage,UINT_PTR in_line,LPCTSTR in_fileName,LPCTSTR in_function):Exception(errmessage,in_line,in_fileName,in_function){}

}