#include "stdafx.h"
#include "nlite_include.h"
using namespace std::tr1;

namespace nlite{

	static const LPCTSTR LIVEURL_PART = TEXT("http://live.nicovideo.jp/watch/");
	static const LPCTSTR ADDMYLIST_PART = TEXT("http://www.nicovideo.jp/mylist_add/video/");

	static const UINT_PTR SELL_SPACE_LENGTH = 1;
	//
	//Rgr[̃Rg[NX
	///////////////////////////////////////////////////////////////////

	CChatReadEdit::CChatReadEdit(CCommentView &m_master):m_master(m_master){


	}

	BOOL CChatReadEdit::SetWindowText(const CChatData &chat){

		BOOL rslt = FALSE;
		try{
			
			tstring viewString(regex_replace(tstring(chat.GetChatBuff()),nliteregex::TAGSTRING,nliteregex::text::NUTHINGSTRING));
			rslt = __super::SetWindowText(viewString.c_str());

			CHARFORMAT2 defaultFormat;
			this->GetDefaultCharFormat(defaultFormat);
			defaultFormat.dwMask |=  CFM_COLOR;
			if(chat.GetPremium() == 2 || chat.GetPremium() == 3){

				defaultFormat.crTextColor = m_master.viewproperty.GetOwnerStringColor();
			}
			
			else {

				defaultFormat.crTextColor = m_master.viewproperty.GetBaseStringColor();

			}

			BOOL rslt = this->SetDefaultCharFormat(defaultFormat);
			


			linkStringBeside(viewString,nliteregex::LILNKREGEX);
			
			

		} catch(std::exception &e){
			e;
			rslt =  FALSE;

		}

		return rslt;
		
	}

	VOID CChatReadEdit::linkStringBeside(const tstring &target,const nliteregex::tregex &re){

		match_results<tstring::const_iterator> regexRslt;
		tstring::const_iterator beginStr = target.begin();
		tstring::const_iterator endstr = target.end();
		CHARFORMAT2 cf;
		cf.cbSize = sizeof(cf);
		cf.dwMask = CFM_LINK;
		cf.dwEffects = CFE_LINK;
		INT_PTR basePosition = 0;
		while(regex_search(beginStr,endstr,regexRslt,re)){
			basePosition += regexRslt.position(0);
			this->SetSel(basePosition,basePosition + regexRslt.length());
			this->SetCharFormat(cf,SCF_SELECTION);
			basePosition += regexRslt.length();
				
			beginStr = regexRslt[0].second;
		}

	}

	VOID CChatReadEdit::Reset(){

		__super::SetWindowText(TEXT(""));

		return;
	}

	HWND CChatReadEdit::GeneralCreate(HWND hParent,DWORD eventMask,UINT id){


		this->Create(hParent,0,RICHEDIT_CLASS,WS_CHILD | WS_VISIBLE  | WS_CLIPCHILDREN | ES_AUTOVSCROLL | ES_MULTILINE   | ES_READONLY,0,id);
		
		DWORD dwLangOptons = this->SendMessage(EM_GETLANGOPTIONS,0,0);
		dwLangOptons &= ~IMF_DUALFONT;
		this->SendMessage(EM_SETLANGOPTIONS,0,(LPARAM)dwLangOptons);

		
		CFont defFont = ::AtlGetDefaultGuiFont();
		LOGFONT deflogFont;
		defFont.GetLogFont(&deflogFont);
		CHARFORMAT2 m_defCharFormat;
		this->GetDefaultCharFormat(m_defCharFormat);
		CDC cDC = this->GetDC();
		int picy = cDC.GetDeviceCaps(LOGPIXELSY);
		this->ReleaseDC(cDC.m_hDC);
		int point = -MulDiv(deflogFont.lfHeight,72,picy);
		int twips = point * 20;
		m_defCharFormat.yHeight = twips;
		m_defCharFormat.dwEffects ^= CFE_AUTOCOLOR;
		_tcscpy(m_defCharFormat.szFaceName,deflogFont.lfFaceName);
		this->SetEventMask(eventMask);
		
        this->SetDefaultCharFormat(m_defCharFormat);


		return *this;

	}

	CChatChildCtrls::CChatChildCtrls(CCommentView &hMaster):
	m_master(hMaster),
	chatDispCtrl(hMaster)
	{
		
		return;
	}

	

	VOID CChatChildCtrls::Create(){

		this->chatDispCtrl.GeneralCreate(m_master.m_commentListWindow,ENM_LINK  | ENM_MOUSEEVENTS,CHAT_DISPCTRL_ID);

	}

	VOID CChatChildCtrls::AdjustRect(RECT &rc){

		rc.left += SELL_SPACE_LENGTH;
		rc.top += SELL_SPACE_LENGTH;
		rc.right -= SELL_SPACE_LENGTH;
		rc.bottom -= SELL_SPACE_LENGTH;

		return;
	}

	VOID CChatChildCtrls::Hide(HDWP hdwp){

		chatDispCtrl.DeferWindowPos(hdwp,chatDispCtrl,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE | SWP_NOZORDER | SWP_HIDEWINDOW);

	}
	
	VOID CChatChildCtrls::SetCtrl(HDWP hdwp,const RECT  &rc,CCommentList::reference comment,BOOL mulutiLineFlag){

		
		chatDispCtrl.SetWindowText(comment);
		RECT chatRect = rc;
		
		
		AdjustRect(chatRect);

		COLORREF bkColor;

		if (comment.IsSelect() == TRUE)
		{
			bkColor = m_master.viewproperty.GetSelectBackColor();

		}
		else  
		{


			if(comment.GetBackColor() != CChatData::ViewData::INIT_COLOR){
			
				bkColor = comment.GetBackColor();

			}else if(comment.GetListnerData().GetBackColor() != CListenerData::INIT_COLOR){

				bkColor = comment.GetListnerData().GetBackColor();


			} else {

				bkColor = m_master.viewproperty.GetBackColor();



			}
		}


		chatDispCtrl.SetBackgroundColor(bkColor);

		chatDispCtrl.DeferWindowPos(hdwp,NULL,chatRect.left,chatRect.top,chatRect.right - chatRect.left ,chatRect.bottom - chatRect.top, SWP_NOZORDER | SWP_SHOWWINDOW);

		return;
	}

	UINT_PTR CChatChildCtrls::GetCtrlCount(){

		return 1;
	}



	///
	///RXgN^
	///
	CChatChildCtrlsList::CChatChildCtrlsList(CCommentView &hMaster):m_hMaster(hMaster){
		
		return;
	}



	///
	///Rg[\
	///
	VOID CChatChildCtrlsList::ShowCntrls(){


		

		

		if(m_hMaster.commentlist.Size() > 0){



			RECT headerRect;
			RECT tmpRect;
			RECT listRect;
			m_hMaster.m_commentListWindow.GetClientRect(&listRect);
			m_hMaster.m_header.GetItemRect(CCommentView::COMMENT,&headerRect);
			headerRect.top = 0;
			headerRect.bottom = 0;
			
			UINT_PTR counter = 0;
			INT_PTR heightSum =0;

			auto ctrlsBegin = m_list.begin();
			auto ctrlsEnd = m_list.end();
			auto chatDataBegin = m_hMaster.commentlist.GetShortCut();
			auto chatDataEnd = m_hMaster.commentlist.end();
			auto chatDataTmp = chatDataBegin;
			for(;chatDataBegin != chatDataEnd && heightSum < listRect.bottom;++chatDataBegin){
				m_hMaster.m_commentListWindow.CalcItemHeight(*chatDataBegin);
				counter++;
				heightSum += chatDataBegin->GetHeight();
			} 

			
		
			chatDataBegin = chatDataTmp;
			heightSum = 0;
			HDWP hdwp = ::BeginDeferWindowPos(CChatChildCtrls::GetCtrlCount() * (counter > m_list.size() ? counter : m_list.size()));
			for(;  chatDataBegin != chatDataEnd && counter > 0 ;++ctrlsBegin,++chatDataBegin,--counter){
			
				
				tmpRect = headerRect;
				tmpRect.top += heightSum;
				tmpRect.bottom += heightSum + chatDataBegin->GetHeight();

				if(ctrlsBegin == ctrlsEnd)ctrlsBegin = Extend();

				ctrlsBegin->SetCtrl(hdwp,tmpRect,*chatDataBegin,m_hMaster.viewproperty.IsCommentFoldingFlag());

				heightSum = tmpRect.bottom;

				
			}
		
			for(;ctrlsBegin != ctrlsEnd;++ctrlsBegin){

				ctrlsBegin->Hide(hdwp);
			}

			::EndDeferWindowPos(hdwp);
		}
		


		return;
	}



	VOID CChatChildCtrlsList::AllHide(){

		auto begin =m_list.begin();
		auto end = m_list.end();

		HDWP hdwp = ::BeginDeferWindowPos(CChatChildCtrls::GetCtrlCount() * m_list.size());
		for(;begin != end;++begin){
			begin->Hide(hdwp);
		}
		::EndDeferWindowPos(hdwp);

	}

	///
	///g
	///
	CChatChildCtrlsList::iterator CChatChildCtrlsList::Extend(){

		
		CChatChildCtrls ctrls(m_hMaster);
		
		m_list.push_back(ctrls);
		m_list.back().Create();
		auto ite = (--m_list.end());
	
		return ite;
	}


	//
	//Rgr[NX\bh
	///////////////////////////////////////////////////////

	CCommentView::CCommentView(CNicoLiveStream &stream,CNicoVideoAuth &in_refAuth):
	m_commentListWindow(*this),
	stream(stream),
	refAuth(in_refAuth)
	,chatChildCtrlsList(*this)

	{

		LOGFONT lf = {0};
		lf.lfHeight = 10;
		lf.lfCharSet = SHIFTJIS_CHARSET;


		hHeaderFontNew = CreateFontIndirect(&lf);


		return;

	}

	CCommentView::~CCommentView(){


		DeleteObject(hHeaderFontNew);

		return;
	}

	VOID CCommentView::UpDateUI(){

		this->chatChildCtrlsList.ShowCntrls();
		this->m_commentListWindow.Invalidate();
		return;
	}


	VOID CCommentView::OnConnect(){
		m_commentListWindow.SetRedraw(FALSE);
		m_commentListWindow.ResetViewSellHeight();

		chatChildCtrlsList.AllHide();


		commentlist.OnConnect();

		SCROLLINFO vScrollInfo = {0};
		vScrollInfo.cbSize = sizeof(vScrollInfo);
		vScrollInfo.fMask = SIF_ALL;

		this->SetScrollInfo(SB_VERT,&vScrollInfo,FALSE);

		m_commentListWindow.SetRedraw(TRUE);
		m_commentListWindow.Invalidate();



	}


	UINT_PTR CCommentView::GetColumnHolSizeSum(){

		INT_PTR nMin = 0;
		INT_PTR nMax = 0;
		this->GetScrollRange(SB_HORZ,&nMin,&nMax);

		return nMax;
	}

	VOID CCommentView::SetProperty(const CCommentViewProperty &setProperty,const CGeneralProperty &in_generalProperty){

		
		viewproperty = setProperty;
		generalProperty = in_generalProperty;
		m_commentListWindow.OnSetProperty();
		
		return;
	}

	CCommentViewProperty &CCommentView::GetProperty(){

		return viewproperty;

	}





	HWND CCommentView::Create(HWND hWndParent){



		HWND rslt = __super::Create(hWndParent,0,commentViewConstant::NLITE_COMMENTVIEW,WS_VISIBLE | WS_CHILD | WS_VSCROLL | WS_HSCROLL | WS_BORDER,0,commentViewConstant::MENU_OR_ID);

		PAINTSTRUCT ps;
		HDC hdc = m_header.BeginPaint(&ps);
		SIZE size;

		HFONT hOld = (HFONT)SelectObject(hdc,hHeaderFontNew);

		LPTSTR columns[] = {TEXT("R"),TEXT("[U["),TEXT("Rg"),TEXT(""),TEXT("")};
		UINT_PTR holizenSize[] = {0,0,100,0,0};

		for(UINT_PTR index = 0;index < ARRAY_LENGTH(columns) ;++index){

			GetTextExtentPoint32(hdc , columns[index] , _tcslen(columns[index]) , &size);
			UINT_PTR holsize = holizenSize[index] + size.cx + 15;
			holizenSize[index] = viewproperty.GetHeaderHolSize()[index] > 0 ? viewproperty.GetHeaderHolSize()[index] : holsize;
		}

		SelectObject(hdc,hOld);

		m_header.EndPaint(&ps);


		HEADERSINFO headersinfo = {columns,holizenSize,ARRAY_LENGTH(columns)};

		AddHeader(&headersinfo);

		m_header.SetOrderArray(viewproperty.GetHeaderOrderArrayLength(),viewproperty.GetHeaderOrderArray());

		
		

		return rslt;
	}




	LRESULT CCommentView::OnHeaderEndTrack(LPNMHDR lParam){


		if(lParam->hwndFrom == m_header.m_hWnd){


			auto begin = commentlist.begin();

			auto end = commentlist.end();

			for(;begin != end;++begin){

				begin->SetHeight(0);

			}

			m_commentListWindow.SetRedraw(FALSE);
			SCROLLINFO vScrollInfo = {0};
			vScrollInfo.fMask = SIF_PAGE | SIF_POS | SIF_RANGE;

			this->GetScrollInfo(SB_VERT,&vScrollInfo);
			vScrollInfo.nPage = m_commentListWindow.CalcScrollPage(vScrollInfo.nMax);
			vScrollInfo.fMask = SIF_PAGE;
			this->SetScrollInfo(SB_VERT,&vScrollInfo);

			BOOL scrollFlag = vScrollInfo.nPos + (int)vScrollInfo.nPage + 1>= vScrollInfo.nMax;
			UINT_PTR commentCount = commentlist.Size();
			LPNMHEADER  lpNmHdr = (LPNMHEADER )lParam;

			m_header.SetItem(lpNmHdr->iItem,lpNmHdr->pitem);







			if(scrollFlag == TRUE){

				this->m_commentListWindow.SendMessageW(WM_VSCROLL,MAKELONG(SB_BOTTOM,0),0);
			}

			INT_PTR itemCount = m_header.GetItemCount();
			RECT itemSizeRect;

			INT_PTR nMax = 0;
			for(INT_PTR itemIndex = 0;itemIndex < itemCount;itemIndex++){
				m_header.GetItemRect(itemIndex,&itemSizeRect);
				nMax += itemSizeRect.right - itemSizeRect.left;

			}
			INT_PTR nMin = 0;
			this->SetScrollRange(SB_HORZ,nMin,nMax,TRUE);
			DecisionHorzSize();


			

			m_commentListWindow.SetRedraw(TRUE);
			
			m_commentListWindow.Invalidate();
			this->m_commentListWindow.SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);

		}

		return 0;
	}

	VOID CCommentView::OnChatReceve(NicoLiveChat_P chat,UINT_PTR commnetCountSum){


		commentlist.OnChatReceve(chat,stream.GetDefaultCommunity(),commnetCountSum,this->m_commentListWindow);

		return;
	}


	VOID CCommentView::OnChatReceveSettle(UINT_PTR chatNo,UINT_PTR commentCountSum){


		SCROLLINFO vScrollInfo = {0};


		vScrollInfo.fMask = SIF_ALL;

		this->GetScrollInfo(SB_VERT,&vScrollInfo);
		BOOL scrollFlag = vScrollInfo.nPos + (int)vScrollInfo.nPage >= vScrollInfo.nMax;

		vScrollInfo.cbSize = sizeof(vScrollInfo);
		vScrollInfo.nMax = commentCountSum;
		vScrollInfo.fMask = SIF_RANGE | SIF_PAGE;
		vScrollInfo.nPage = m_commentListWindow.CalcScrollPage(vScrollInfo.nMax);


		this->SetScrollInfo(SB_VERT,&vScrollInfo,FALSE);




		if(scrollFlag == TRUE){
			this->SendMessage(WM_VSCROLL,MAKEWORD(SB_BOTTOM,0),0);
		}


		if(vScrollInfo.nPos + static_cast<INT_PTR>(vScrollInfo.nPage) >= vScrollInfo.nMax - static_cast<INT_PTR>(vScrollInfo.nPage)){
			
			this->Invalidate();
			
			this->m_commentListWindow.SendMessageW(UM_COMMENTVIEW_SETCTRL,NULL,NULL);
			this->UpdateWindow();
		}

		return;
	}

	static UCHAR getrgb(){

		UCHAR rgb = 192 + rand() % 64;
		return rgb;
	}

	LRESULT CCommentView::OnSize(UINT wParam,SIZE lParam){
		ChangeSize(lParam);

		return 0;
	}


	VOID CCommentView::ChangeSize(const SIZE& client){

		SCROLLINFO hScrollInfo = {0};
		hScrollInfo.cbSize = sizeof(hScrollInfo);
		hScrollInfo.fMask = SIF_PAGE;
		hScrollInfo.nPage = client.cx;

		this->SetScrollInfo(SB_HORZ,&hScrollInfo);
		hScrollInfo.fMask = SIF_ALL;
		this->GetScrollInfo(SB_HORZ,&hScrollInfo);


		HDWP hDwp = BeginDeferWindowPos(2);


		INT_PTR movePos =  -1 * hScrollInfo.nPos;

		m_header.DeferWindowPos(hDwp,m_header.m_hWnd,movePos,0,0,0,SWP_NOSIZE | SWP_NOZORDER);
		m_commentListWindow.DeferWindowPos(hDwp,m_commentListWindow.m_hWnd,movePos,commentViewConstant::HEADER_HAIGHT,::GetSystemMetrics(SM_CXFULLSCREEN),client.cy - commentViewConstant::HEADER_HAIGHT,SWP_NOZORDER);		

		EndDeferWindowPos(hDwp);


		RECT bkRect;
		RECT headerRectSize;
		m_header.GetWindowRect(&headerRectSize);
		bkRect.left = headerRectSize.right - headerRectSize.left - hScrollInfo.nPos;
		bkRect.top = 0;
		bkRect.right = client.cx ;
		bkRect.bottom = client.cy;


		return;
	}



	LRESULT CCommentView::OnClickChatNo(UINT uMsg,WPARAM wParam,LPARAM lParam){
		
		
		::SendMessage(::GetAncestor(*this,GA_ROOT),uMsg,wParam,lParam);
		
		return 0;
	}
		

	LRESULT CCommentView::OnClickUserName(UINT uMsg,WPARAM wParam,LPARAM lParam){
		
	
		::SendMessage(::GetAncestor(*this,GA_ROOT),uMsg,wParam,lParam);
		
		return 0;
	}

	LRESULT CCommentView::OnEraseBkgnd(HDC wParam){

		return TRUE;
	}


	VOID CCommentView::OnDestroy(){
		m_header.GetOrderArray(viewproperty.GetHeaderOrderArrayLength(),viewproperty.GetHeaderOrderArray());
		INT_PTR headerItemcount = m_header.GetItemCount();
		RECT headerItemRect;
		for(INT_PTR itemindex = 0;itemindex < headerItemcount;itemindex++){

			m_header.GetItemRect(itemindex,&headerItemRect);
			viewproperty.GetHeaderHolSize()[itemindex] = headerItemRect.right - headerItemRect.left;
		}
		commentlist.OnDestroy();
		m_header.DestroyWindow();
		m_commentListWindow.DestroyWindow();
		return;

	}

	LRESULT CCommentView::OnHeaderEndDrag(LPNMHDR lParam){

		if(lParam->hwndFrom == m_header.m_hWnd){
			
			LPNMHEADER pNMHeader = (LPNMHEADER) lParam; 
			this->m_header.SetItem(pNMHeader->iItem,pNMHeader->pitem);
			
			m_commentListWindow.Invalidate();
			this->m_commentListWindow.SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);
			

		}

		return 0;
	}

	VOID CCommentView::OnHScroll(INT_PTR loWParam,SHORT hiWParam,HWND lParam){


		INT_PTR dy;
		SCROLLINFO hScrollInfo = {0};
		hScrollInfo.cbSize = sizeof(hScrollInfo);
		hScrollInfo.fMask = SIF_ALL;
		this->GetScrollInfo(SB_HORZ,&hScrollInfo);
		switch(loWParam){

		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			dy = hiWParam - hScrollInfo.nPos;
			break;

		case SB_LINELEFT:
		case SB_PAGELEFT:

			dy = -1 * hScrollInfo.nPage;

			break;

		case SB_LINERIGHT:
		case SB_PAGERIGHT:

			dy = hScrollInfo.nPage + hScrollInfo.nPos > (UINT_PTR)hScrollInfo.nMax ? 0 :(UINT_PTR) (hScrollInfo.nMax - ( hScrollInfo.nPage + hScrollInfo.nPos)) < hScrollInfo.nPage ? (hScrollInfo.nMax - ( hScrollInfo.nPage + hScrollInfo.nPos)) : hScrollInfo.nPage;

			break;

		default:
			dy = 0;
			break;

		}

		dy = max(-1 * hScrollInfo.nPos, min(dy, hScrollInfo.nMax - hScrollInfo.nPos));


		if(dy != 0){
			hScrollInfo.nPos += dy;
			INT_PTR moveRange = -(hScrollInfo.nPos);

			HDWP hDwp = BeginDeferWindowPos(2);

			m_header.DeferWindowPos(hDwp,m_header.m_hWnd,moveRange,0,0,0,SWP_NOSIZE | SWP_NOZORDER);
			m_commentListWindow.DeferWindowPos(hDwp,m_commentListWindow.m_hWnd,moveRange,commentViewConstant::HEADER_HAIGHT,0,0,SWP_NOSIZE | SWP_NOZORDER);		

			EndDeferWindowPos(hDwp);

			this->SetScrollInfo(SB_HORZ,&hScrollInfo);
		}

		return;
	}


	VOID CCommentView::OnVScroll(INT_PTR loWParam,SHORT hiWParam,HWND lParam){

		INT_PTR dy;
		SCROLLINFO vScrollInfo = {0};
		vScrollInfo.fMask = SIF_ALL;


		this->GetScrollInfo(SB_VERT,&vScrollInfo);

		switch(loWParam){


		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:

			dy = hiWParam - vScrollInfo.nPos;

			break;

		case SB_LINEUP:

			dy = -1;
			break;

		case SB_LINEDOWN:

			dy = 1;

			break;

		case SB_PAGEUP:

			dy = -1 * vScrollInfo.nPage;

			break;

		case SB_PAGEDOWN:

			dy = vScrollInfo.nPage;

			break;


		case SB_TOP:

			dy = -vScrollInfo.nPos;

			break;

		case SB_BOTTOM:

			dy = vScrollInfo.nMax;

			break;

		default:

			dy = 0;

			break;

		}


	

		if(dy != 0){

			vScrollInfo.nPos += dy;
			this->SetScrollPos(SB_VERT,vScrollInfo.nPos);
			this->commentlist.SetShortCut(this->GetScrollPos(SB_VERT));
			this->Invalidate();
			this->UpdateWindow();
			this->m_commentListWindow.SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);	
		}



		return;
	}

	LRESULT CCommentView::OnCreate(LPCREATESTRUCT lpcs){
		m_header.Create(m_hWnd,0,WC_HEADER,WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN   | HDS_BUTTONS | HDS_HOTTRACK |HDS_DRAGDROP | HDS_FULLDRAG  ,0,commentViewConstant::HEADER_ID);
		m_commentListWindow.Create(m_hWnd,0,commentViewConstant::NLITE_COMMENTLISTWINDOW,WS_CHILD | WS_VISIBLE  | WS_CLIPCHILDREN  , 0,commentViewConstant::LISTWINDOW);

		return 0;
	}

	VOID CCommentView::AddHeader(LPHEADERSINFO infos){


		m_header.SetFont(hHeaderFontNew);

		HDITEM item;
		item.mask = HDI_FORMAT | HDI_TEXT | HDI_WIDTH;
		item.fmt = HDF_CENTER | HDF_STRING;


		for(UINT_PTR index = 0;index < infos->count ;++index){

			item.pszText = infos->columns[index];

			item.cxy =  infos->holizensize[index];
			m_header.AddItem(&item);
		}

		RECT itemRect;
		INT_PTR nMax = 0;
		UINT_PTR itemCount = m_header.GetItemCount();
		for(UINT_PTR u_index = 0;u_index < itemCount;++u_index){

			m_header.GetItemRect(u_index,&itemRect);
			nMax += itemRect.right - itemRect.left;

		}

		this->SetScrollRange(SB_HORZ,0,nMax,TRUE);

		DecisionHorzSize();
		return;
	}

	VOID CCommentView::DecisionHorzSize(){

		HDWP hWindowPosInfo = BeginDeferWindowPos(2);
		RECT bkWindowRect;
		this->GetClientRect(&bkWindowRect);
		m_header.DeferWindowPos(hWindowPosInfo,m_header.m_hWnd,0,0,::GetSystemMetrics(SM_CXFULLSCREEN),commentViewConstant::HEADER_HAIGHT,SWP_NOZORDER | SWP_NOMOVE);
		m_commentListWindow.DeferWindowPos(hWindowPosInfo,m_header.m_hWnd,0,0,::GetSystemMetrics(SM_CXFULLSCREEN),bkWindowRect.bottom - commentViewConstant::HEADER_HAIGHT,SWP_NOZORDER | SWP_NOMOVE);

		EndDeferWindowPos(hWindowPosInfo);

		return;
	}




	//
	//Rgr[NXXgNX
	////////////////////////////////////////////////////////////////////

	CCommentListWindow::CCommentListWindow(CCommentView &in_self):
	self(in_self),
	viewSellHeight(0)
	{
		CFontHandle font = ::AtlGetDefaultGuiFont();
		LOGFONT logfont;
		font.GetLogFont(&logfont);
		logfont.lfUnderline = TRUE;
		
		linkFont.CreateFontIndirect(&logfont);
	}

	CCommentListWindow::~CCommentListWindow(){
	}

	

	VOID CCommentListWindow::OnSetProperty(){

		if(IsWindow() == TRUE)this->SetRedraw(FALSE);

		if(collLinePen.IsNull() == FALSE)collLinePen.DeleteObject();
		if(normalSellLinePen.IsNull() == FALSE)normalSellLinePen.DeleteObject();
		if(normalBkBrush.IsNull() == FALSE)normalBkBrush.DeleteObject();
		if(selectSellLinePen.IsNull() ==FALSE)selectSellLinePen.DeleteObject();
		if(selectBkBrush.IsNull() == FALSE)selectBkBrush.DeleteObject();

		collLinePen.CreatePen(PS_SOLID,1,self.viewproperty.GetColLineColor());
		normalSellLinePen.CreatePen(PS_SOLID,1,self.viewproperty.GetNormalLineColor());
		normalBkBrush.CreateSolidBrush(self.viewproperty.GetBackColor());
		selectSellLinePen.CreatePen(PS_SOLID,1,self.viewproperty.GetSelectSellLineColor());
		selectBkBrush.CreateSolidBrush(self.viewproperty.GetSelectBackColor());


		if(IsWindow() == TRUE)this->SetRedraw(TRUE);
	}


	VOID CCommentListWindow::OnPaint(HDC in_hdc){

		this->self.refAuth.GetUserSession();
		RECT windowRect;
		RECT listRect = {0};
		RECT clientRect;

		self.GetClientRect(&clientRect);
		clientRect.bottom -= commentViewConstant::HEADER_HAIGHT;

		this->GetWindowRect(&windowRect);
		windowRect.right -= windowRect.left;
		windowRect.bottom -= windowRect.top;
		windowRect.left = 0;
		windowRect.top = 0;


		CPaintDC pdc(*this);

		{
			CMemoryDC mdc(pdc,windowRect);
			mdc.SelectFont(AtlGetDefaultGuiFont());


			CCommentList &commentList = self.commentlist;

			BOOL selectFlag = FALSE;
			CCommentList::iterator selectData;
			RECT selectRect = {0};
	


			if(commentList.Size() > 0){

				listRect = windowRect;
				listRect.right = self.GetColumnHolSizeSum();		

				CCommentList::iterator chatData = commentList.GetShortCut();

			
				
				
				mdc.FillRect(&listRect,this->normalBkBrush);
				
				CCommentList::iterator endData = commentList.end();
				listRect.bottom = 0;
				
				RECT headerRects[COMMENTVIEW_HEADERITEMSIZE];
				RECT colLineRects[COMMENTVIEW_HEADERITEMSIZE];
				RECT selectHeaderRects[COMMENTVIEW_HEADERITEMSIZE];
				
				self.m_header.GetItemRect(CCommentView::NO,&headerRects[CCommentView::NO]);
				self.m_header.GetItemRect(CCommentView::USERNAME,&headerRects[CCommentView::USERNAME]);
				self.m_header.GetItemRect(CCommentView::COMMENT,&headerRects[CCommentView::COMMENT]);
				self.m_header.GetItemRect(CCommentView::TIME,&headerRects[CCommentView::TIME]);
				self.m_header.GetItemRect(CCommentView::INFO,&headerRects[CCommentView::INFO]);

				memcpy(colLineRects,headerRects,sizeof(headerRects));

				
				
				
		
				headerRects[CCommentView::NO].left += SELL_SPACE_LENGTH;
				headerRects[CCommentView::USERNAME].left += SELL_SPACE_LENGTH;
				headerRects[CCommentView::COMMENT].left += SELL_SPACE_LENGTH;
				headerRects[CCommentView::TIME].left += SELL_SPACE_LENGTH;
				headerRects[CCommentView::INFO].left += SELL_SPACE_LENGTH;

				headerRects[CCommentView::NO].right -= SELL_SPACE_LENGTH;
				headerRects[CCommentView::USERNAME].right -= SELL_SPACE_LENGTH;
				headerRects[CCommentView::COMMENT].right -= SELL_SPACE_LENGTH;
				headerRects[CCommentView::TIME].right -= SELL_SPACE_LENGTH;
				headerRects[CCommentView::INFO].right -= SELL_SPACE_LENGTH;

				headerRects[CCommentView::NO].top = SELL_SPACE_LENGTH;
				headerRects[CCommentView::USERNAME].top = SELL_SPACE_LENGTH;
				headerRects[CCommentView::COMMENT].top = SELL_SPACE_LENGTH;
				headerRects[CCommentView::TIME].top = SELL_SPACE_LENGTH;
				headerRects[CCommentView::INFO].top = SELL_SPACE_LENGTH;

				headerRects[CCommentView::NO].bottom = SELL_SPACE_LENGTH;
				headerRects[CCommentView::USERNAME].bottom = SELL_SPACE_LENGTH;
				headerRects[CCommentView::COMMENT].bottom = SELL_SPACE_LENGTH;
				headerRects[CCommentView::TIME].bottom = SELL_SPACE_LENGTH;
				headerRects[CCommentView::INFO].bottom = SELL_SPACE_LENGTH;

				INT_PTR listRectTop = listRect.top;
				for(;chatData != endData && listRect.top < clientRect.bottom;++chatData){
					CalcItemHeight(*chatData);

					listRect.bottom += chatData->GetHeight();

					headerRects[CCommentView::NO].top = listRect.top + SELL_SPACE_LENGTH;
					headerRects[CCommentView::USERNAME].top = listRect.top + SELL_SPACE_LENGTH;
					headerRects[CCommentView::COMMENT].top = listRect.top + SELL_SPACE_LENGTH;
					headerRects[CCommentView::TIME].top = listRect.top + SELL_SPACE_LENGTH;
					headerRects[CCommentView::INFO].top = listRect.top + SELL_SPACE_LENGTH;

					headerRects[CCommentView::NO].bottom = listRect.bottom - SELL_SPACE_LENGTH;
					headerRects[CCommentView::USERNAME].bottom = listRect.bottom - SELL_SPACE_LENGTH;
					headerRects[CCommentView::COMMENT].bottom = listRect.bottom - SELL_SPACE_LENGTH;
					headerRects[CCommentView::TIME].bottom = listRect.bottom - SELL_SPACE_LENGTH;
					headerRects[CCommentView::INFO].bottom = listRect.bottom - SELL_SPACE_LENGTH;

					if(chatData->IsSelect() == TRUE){
						selectFlag = TRUE;
						selectData = chatData;
						selectRect = listRect;
						memcpy(selectHeaderRects,headerRects,sizeof(headerRects));
					} else {

						


						this->DrawItem(mdc,listRect,headerRects,*chatData);
					}


					listRect.top = listRect.bottom;
				}

				viewSellHeight = listRect.bottom;



				if(selectFlag == TRUE){
					this->DrawItem(mdc,selectRect,selectHeaderRects,*selectData);
				}

					//ڂ̏c`
				mdc.SelectPen(collLinePen);
				mdc.MoveTo(colLineRects[CCommentView::NO].right,listRectTop);
				mdc.LineTo(colLineRects[CCommentView::NO].right,listRect.bottom);
				mdc.MoveTo(colLineRects[CCommentView::USERNAME].right,listRectTop);
				mdc.LineTo(colLineRects[CCommentView::USERNAME].right,listRect.bottom);
				mdc.MoveTo(colLineRects[CCommentView::COMMENT].right,listRectTop);
				mdc.LineTo(colLineRects[CCommentView::COMMENT].right,listRect.bottom);
				mdc.MoveTo(colLineRects[CCommentView::TIME].right,listRectTop);
				mdc.LineTo(colLineRects[CCommentView::TIME].right,listRect.bottom);
				mdc.MoveTo(colLineRects[CCommentView::INFO].right,listRectTop);
				mdc.LineTo(colLineRects[CCommentView::INFO].right,listRect.bottom);

			}
			windowRect.left = listRect.right;
			mdc.FillRect(&windowRect,(HBRUSH)::GetStockObject(GRAY_BRUSH));




		}
		

		

		return;
	}


	LRESULT CCommentListWindow::OnSetCtrol(UINT uMsg,WPARAM wparam,LPARAM lparam){



		self.chatChildCtrlsList.ShowCntrls();



		return 0;
	}

	VOID CCommentListWindow::OnSize(UINT wParam, _WTYPES_NS::CSize &windowSize){


		SCROLLINFO vScrollInfo = {0};
		vScrollInfo.fMask = SIF_ALL;


		self.GetScrollInfo(SB_VERT,&vScrollInfo);
		BOOL scrollFlag = (UINT)(vScrollInfo.nPage + vScrollInfo.nPos + 1) >= (UINT)vScrollInfo.nMax;
		vScrollInfo.nPage = CalcScrollPage(vScrollInfo.nMax);

		vScrollInfo.fMask = SIF_PAGE;
		self.SetScrollInfo(SB_VERT,&vScrollInfo);



		if(scrollFlag == TRUE){
			self.SendMessageW(WM_VSCROLL,MAKELONG(SB_BOTTOM,0),0);
		}

		this->Invalidate();
		this->SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);

		return;
	}


	UINT_PTR CCommentListWindow::CalcScrollPage(UINT_PTR nMax){

		RECT clientRect;
		INT_PTR rslt = 0;
		LONG height = 0;
		this->GetClientRect(&clientRect);

		SCROLLINFO vScrollInfo = {0};
		if(self.commentlist.empty() != TRUE){

			CCommentList::reverse_iterator rbegin = self.commentlist.rbegein();
			CCommentList::reverse_iterator rend = self.commentlist.rend();
			for(;rbegin != rend;++rbegin){
				CalcItemHeight(*rbegin);
				height += rbegin->GetHeight();
				rslt++;
				if(height > clientRect.bottom)goto overclientrect;

			}
		}
		rslt = nMax+ 1;


overclientrect:

		return rslt;
	}

	VOID CCommentListWindow::DrawItem(CDC &dc,const RECT &rc,const RECT *headerRect,CChatData &chatData){


		RECT noViewRect = headerRect[CCommentView::NO];										//Rԕ\̈
		RECT userNameViewRect = headerRect[CCommentView::USERNAME];							//[U\̈
		RECT chatViewRect = headerRect[CCommentView::COMMENT];								//Rg\̈
		RECT timeViewRect = headerRect[CCommentView::TIME];									//ԕ\̈	
		RECT infoViewRect  = headerRect[CCommentView::INFO];								//Rg\̈


		//
		//Rgԕ\p쐬
		//
		time_t chatTime = (time_t)difftime(chatData.GetDate(),self.stream.GetStartTime());


		BOOL beforeStartFlag = chatTime < 0 ? TRUE : FALSE;
		TCHAR noString[sizeof(UINT_PTR) * 8]; 
		TCHAR dateString[LENGTH_16];
		if(chatData.GetNo() != 0)_stprintf(noString,TEXT("%u"),chatData.GetNo());
		else _tcscpy(noString,TEXT(""));
		CNLiteString timeFormat;


		if(beforeStartFlag == TRUE){

			timeFormat = TEXT("-");
			chatTime = -chatTime;
		}
		tm ct = *gmtime(&chatTime);
		if(ct.tm_hour != 0 ){

			timeFormat += TEXT("%H:%M:%S");

		} else {

			timeFormat += TEXT("%M:%S");
		}

		_tcsftime(dateString,ARRAY_LENGTH(dateString),timeFormat,&ct);


		COLORREF bkColor;													//wiF
		CPen originSellLinePen;													//g`py
		CBrush originBkBrush;														//wi`puV
		
		//IԂ`FbN
		if (chatData.IsSelect() == TRUE)
		{
			bkColor = self.viewproperty.GetSelectBackColor();
			
			dc.SelectBrush(this->selectBkBrush);
			dc.SelectPen(this->selectSellLinePen);
		}
		else  
		{

			if(chatData.GetSellLineColor() == CChatData::ViewData::INIT_COLOR){
				dc.SelectPen(this->normalSellLinePen);

			} else {

				originSellLinePen.CreatePen(PS_SOLID,1,chatData.GetSellLineColor());
				dc.SelectPen(originSellLinePen);
			}

			

			if(chatData.GetBackColor() != CChatData::ViewData::INIT_COLOR || chatData.GetListnerData().GetBackColor() != CListenerData::INIT_COLOR){
			
				if(chatData.GetBackColor() != CChatData::ViewData::INIT_COLOR){
					bkColor = chatData.GetBackColor();
					originBkBrush.CreateSolidBrush(chatData.GetBackColor());
				
				}else if(chatData.GetListnerData().GetBackColor() != CListenerData::INIT_COLOR){

					bkColor = chatData.GetListnerData().GetBackColor();
					originBkBrush.CreateSolidBrush(chatData.GetListnerData().GetBackColor());
					
				}

				dc.SelectBrush(originBkBrush);
			} else {

				bkColor = self.viewproperty.GetBackColor();
				dc.SelectBrush(this->normalBkBrush);
				dc.SelectBrush(this->normalBkBrush);


			}
		}
		
		//wiƘg`
		
		
		dc.Rectangle(rc.left,rc.top  - 1,rc.right ,rc.bottom + 1);
		dc.SetBkColor(bkColor);
		

		//`TCYvZ


		
		
		const CNLiteString &viewUserName = chatData.GetListnerData().GetName().Length() == 0 ? chatData.GetListnerData().GetUserID() : chatData.GetListnerData().GetName();
		dc.SelectFont(linkFont);
		dc.SetTextColor(chatData.GetListnerData().GetNameColor() != CListenerData::INIT_COLOR ? chatData.GetListnerData().GetNameColor() : self.viewproperty.GetLinkStringColor());
		//eLXg`
		dc.DrawTextW(noString,_tcslen(noString),&noViewRect,DT_WORD_ELLIPSIS);

		
		dc.DrawTextW(viewUserName,viewUserName.Length(),&userNameViewRect,DT_WORD_ELLIPSIS);
		dc.SelectFont(::AtlGetDefaultGuiFont());
		dc.SetTextColor(chatData.GetStringColor() == CChatData::ViewData::INIT_COLOR ? chatData.GetStringColor() :self.viewproperty.GetBaseStringColor());
		dc.DrawTextW(dateString,_tcslen(dateString),&timeViewRect,DT_WORD_ELLIPSIS);

		return;
	}

	VOID CCommentListWindow::ResetViewSellHeight(){

		viewSellHeight = 0;

		return;
	}


	VOID CCommentListWindow::ShowCurSel(){

		auto end = self.commentlist.end();
		INT_PTR cursel = self.commentlist.GetCurSelNo();
		if(cursel == -1)goto end;

		SCROLLINFO vScrollInfo;
		vScrollInfo.cbSize = sizeof(vScrollInfo);
		vScrollInfo.fMask = SIF_ALL;
		self.GetScrollInfo(SB_VERT,&vScrollInfo);
		
		if(!(cursel >= vScrollInfo.nPos + static_cast<INT_PTR>(vScrollInfo.nPage) / 2 && cursel <= vScrollInfo.nPos + static_cast<INT_PTR>(vScrollInfo.nPage) / 2)){
			self.SetScrollPos(SB_VERT,cursel - (vScrollInfo.nPage / 2));
			self.commentlist.SetShortCut(self.GetScrollPos(SB_VERT));
		}

		this->Invalidate();

		this->SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);
end:

		return;
	}



	VOID CCommentListWindow::CalcItemHeight(CChatData &chatData){
		
		
		if(chatData.GetHeight() == 0){
			RECT drowSize;
			self.m_header.GetItemRect(CCommentView::COMMENT,&drowSize);
		
			drowSize.bottom = 0;

			CChatReadEdit cedit(self);
		
			cedit.GeneralCreate(*this,ENM_REQUESTRESIZE,CALCEDIT_ID);
			cedit.Reset();
			cedit.SetWindowPos(NULL,0,0,drowSize.right - drowSize.left,drowSize.bottom - drowSize.top,SWP_NOZORDER | SWP_NOMOVE | SWP_NOREDRAW);
			cedit.SetWindowText(chatData);
			cedit.GetClientRect(&drowSize);
			cedit.DestroyWindow();
			drowSize.bottom += 12;
			if(drowSize.bottom - drowSize.top > 120)drowSize.bottom = drowSize.top + 120;
			chatData.SetHeight(drowSize.bottom - drowSize.top);
		}

		return ;
	}



	LRESULT CCommentListWindow::OnCreate(LPCREATESTRUCT lpCreateStruct){

		return 0;
	}

	CCommentList::iterator CCommentListWindow::CalcClickLine(INT_PTR height){

		INT_PTR heightSum = 0;

		CCommentList::iterator chatData = self.commentlist.GetShortCut();
		CCommentList::iterator end  = self.commentlist.end();


		
		for(; chatData != end ;(++chatData)){
			CalcItemHeight(*chatData);
			heightSum += chatData->GetHeight();

			
			if(heightSum >= height)break;
		}
		



		return chatData;
	}


	BOOL CCommentListWindow::IsOnNoOrUserName(UINT_PTR index,const POINT &point){

		RECT rc = {0};
		
		self.m_header.GetItemRect(index,&rc);
		BOOL rslt = FALSE;

		if((point.x >= rc.left && point.x <= rc.right) && (point.y < static_cast<INT_PTR>(viewSellHeight))){

			INT_PTR heightsum = 0;
			auto clickData = self.commentlist.GetShortCut();
			auto endData = self.commentlist.end();
			for(;clickData != endData;++clickData){

				heightsum += clickData->GetHeight();

				if(heightsum > point.y){
					
					CDC cdc = this->GetDC();
					
					rc.top = heightsum -= clickData->GetHeight();
					RECT calcRect = {0};
					cdc.SelectFont(linkFont);


					if(index == CCommentView::USERNAME){
						LPCTSTR viewStr = clickData->GetListnerData().GetName().Length() == 0 ? clickData->GetListnerData().GetUserID() : clickData->GetListnerData().GetName();
						cdc.DrawTextW(viewStr ,_tcslen(viewStr),&calcRect,DT_CALCRECT);
					
					} else if(index == CCommentView::NO){
						TCHAR viewStr[sizeof(UINT_PTR) * 8];
						_stprintf(viewStr,TEXT("%d"),clickData->GetNo());
						cdc.DrawTextW(viewStr,_tcslen(viewStr),&calcRect,DT_CALCRECT);

					}
					rc.bottom = rc.top +  calcRect.bottom - calcRect.top;
					rc.right = rc.right > rc.left + calcRect.right - calcRect.left ? rc.left + calcRect.right - calcRect.left : rc.right;
					
					//WNΏەɂꍇtrueݒ肷
					rslt = (point.y >= rc.top && point.y <= rc.bottom && point.x >= rc.left && point.x <= rc.right) &&
						((index ==CCommentView::NO && clickData->GetNo() != 0) ||index ==CCommentView::USERNAME);
					
					break;

				}
			}
			
		}

		return rslt;

	}


	VOID CCommentListWindow::OnDestroy(){

	}

	VOID CCommentListWindow::OnLButtonDown(UINT wParam, _WTYPES_NS::CPoint &point){



		CCommentList::iterator ite;
		this->SetFocus();
		if(point.x > (INT_PTR)self.GetColumnHolSizeSum()) goto end;

		
		if(self.commentlist.empty() == TRUE)goto end;
		
		ite = CalcClickLine(point.y);
		self.commentlist.SetCurSel(ite);
		
		if(this->IsOnNoOrUserName(CCommentView::NO,point) == TRUE){

			::SendMessage(self,UM_CLICK_CHATNO,(WPARAM)&(*ite),(LPARAM)self.m_hWnd);

		} else if(this->IsOnNoOrUserName(CCommentView::USERNAME,point) == TRUE){

			::SendMessage(self,UM_CLICK_USERNAME,(WPARAM)&(*ite),(LPARAM)self.m_hWnd);
		}


		

end:
		this->Invalidate();
		this->SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);

		return;
	}


	VOID CCommentListWindow::OnLButtonDblClk(UINT wParam, _WTYPES_NS::CPoint &point){


		if(!(point.x > (INT_PTR)self.GetColumnHolSizeSum() || self.commentlist.empty() == TRUE)){
		

			auto end  = self.commentlist.end();
			auto lineIte = CalcClickLine(point.y);
			if( lineIte == end)goto  endlabel;
		
		
			COLORREF bkColor;
			if(lineIte->GetListnerData().GetBackColor() == CListenerData::INIT_COLOR){
				CListenerColorCollector colorCollector;
				listenerList.BkColorCollect(colorCollector);
				UCHAR red;
				UCHAR green;
				UCHAR blue;

				srand((unsigned int)time(NULL));
				do{

					red = getrgb();
					green = getrgb();
					blue = getrgb();
					bkColor = PALETTERGB(red,green,blue);

				}while(colorCollector.Find(bkColor));

				
				lineIte->GetListnerData().SetBkColor(bkColor);
			} else {

				lineIte->GetListnerData().SetBkColor(CListenerData::INIT_COLOR);
				
			}
		}





endlabel:


		this->Invalidate(TRUE);

		this->SendMessage(UM_COMMENTVIEW_SETCTRL,NULL,NULL);
		return;
	}

	LRESULT CCommentListWindow::OnEraseBkGnd(HDC lparam){

		return TRUE;
	}

	VOID CCommentListWindow::OnKeyDown(TCHAR vKey,UINT loLParam,UINT hiLParam){

		INT_PTR dy = 0;
		switch(vKey){

		case VK_DOWN:
		case VK_RETURN:
			dy = 1;

			break;
		case VK_UP:

			dy = -1;
			break;
		default:
			break;


		}

		
		

		auto cursel = self.commentlist.GetCurSel();
		if((dy < 0 && cursel == self.commentlist.begin())  || dy >= static_cast<INT_PTR>(self.commentlist.Size()))goto end;

		
		std::advance(cursel,dy);
		self.commentlist.SetCurSel(cursel);

		this->ShowCurSel();
end:

					
		return;
	}

	LRESULT CCommentListWindow::OnSetCursor(HWND wparam,UINT loLparam,UINT hiLparam){

		
		POINT mousePoint = {0};
	
		GetCursorPos(&mousePoint);
		::ScreenToClient(*this,&mousePoint);
		
		if(( IsOnNoOrUserName(CCommentView::NO,mousePoint) || IsOnNoOrUserName(CCommentView::USERNAME,mousePoint))){
			
			
			::SetCursor(::LoadCursorW(NULL,IDC_HAND));

		} else {

			DefWindowProc ();

		}
		

		
	

		return FALSE;
	}

	LRESULT CCommentListWindow::OnMouseWheel(UINT loWparam,SHORT hiWparam,CPoint &point){


		self.SendMessageW(WM_VSCROLL,MAKELONG(hiWparam < 0 ? SB_PAGEDOWN : SB_PAGEUP ,0),0);


		return 0;
	}

	


	LRESULT CCommentListWindow::OnChatControlNortify(LPNMHDR lParam){

		LRESULT rslt = 0;

		switch(lParam->code){

		case EN_LINK:
			{
				ENLINK *lpenlk = (ENLINK *)lParam;
				if (lpenlk->msg == WM_LBUTTONDOWN) {
					CRichEditCtrl chatReadEdit = lpenlk->nmhdr.hwndFrom;
					chatReadEdit.SetSel(lpenlk->chrg);
					CString selTextBuf;
					chatReadEdit.GetSelText(selTextBuf);
					if(regex_match((LPCTSTR)selTextBuf,nliteregex::URL) == TRUE){

						
						

					} else if(regex_match((LPCTSTR)selTextBuf,nliteregex::VIDEOID) == TRUE){
						
						selTextBuf.Insert(0,ADDMYLIST_PART);
				
					} else if( regex_match((LPCTSTR)selTextBuf,nliteregex::LIVEID) == TRUE){
						
						selTextBuf.Insert(0,LIVEURL_PART);
						
					}
					
					OpenURL(*this,self.generalProperty,selTextBuf,SW_SHOWNORMAL);
				}
			}
			break;

		case EN_MSGFILTER:
			{
				auto pmf = (MSGFILTER *)lParam;
				if (pmf->msg == WM_LBUTTONDOWN || pmf->msg== WM_LBUTTONDBLCLK || pmf->msg == WM_MOUSEWHEEL){

					RECT  windowrect;
					::GetWindowRect(pmf->nmhdr.hwndFrom,&windowrect);
					_WTYPES_NS::CPoint point(windowrect.left +  LOWORD(pmf->lParam),windowrect.top + HIWORD(pmf->lParam));
					::ScreenToClient(*this,&point);

					switch(pmf->msg){

					case WM_LBUTTONDOWN:
						OnLButtonDown(pmf->wParam,point);
						break;

					case WM_LBUTTONDBLCLK:
						OnLButtonDblClk(pmf->wParam,point);
						break;

					case WM_MOUSEWHEEL:
						OnMouseWheel(LOWORD(pmf->wParam),HIWORD(pmf->wParam),point);
						break;

					default:

						break;
					}
					
				} 

					

				
            }
			break;


		default:

			break;

		}


		return rslt;
	}

	LRESULT CCommentListWindow::OnCalcSellSize(LPNMHDR lParam){

		auto pReqResize = reinterpret_cast <REQRESIZE *>(lParam);
		::SetWindowPos(pReqResize->nmhdr.hwndFrom,NULL,0,0,pReqResize->rc.right - pReqResize->rc.left,pReqResize->rc.bottom - pReqResize->rc.top,SWP_NOZORDER | SWP_NOMOVE | SWP_HIDEWINDOW);
		return 0;
	}

}