#include "StdAfx.h"
#include "nlib_include.h"


namespace nlib{


Exception::Exception(){}

Exception::Exception(const char* const& errMessage):exception(errMessage){}

Exception::Exception(const wchar_t * const & errMessage,UINT_PTR in_line,LPCTSTR in_fileName,LPCTSTR in_function):
	wErrMessage(errMessage),
	line(in_line),
	function(in_function)
{
	WCHAR file[_MAX_FNAME];
	WCHAR ext[_MAX_EXT];
	_wsplitpath(in_fileName,(wchar_t*)NULL,(wchar_t*)NULL,file,ext);
	fileName = file;
	fileName += ext;

}

LPCTSTR Exception::what(){

	return wErrMessage.c_str();

}

UINT_PTR Exception::getLineNo(){

	return line;
}

LPCTSTR Exception::getFileName(){
			
	return fileName.c_str();
		
}

LPCTSTR Exception::getFunctionName(){

	return function.c_str();
}






}