#pragma once


#include <windows.h>
#include <stdio.h>


#include <time.h>
#include <tchar.h>
#include <locale.h>
#include <Fcntl.h>
#include <Share.h>
#include <SYS\Stat.h>
#include <io.h>


#define DEBUGFORMAT__DEBUGER__ "\r\n###<<INFO>>[file]%s%s,[func]%s,[line]%d,[time]%d:%d:%d###\r\n"
#define DEBUG_WARNINGFORMAT__DEBUGER__	"\r\n###<<WARNING>>[file]%s%s,[func]%s,[line]%d,[time]%d:%d:%d###\r\n"
#define DEBUG_ERRFORMAT__DEBUGER__	"\r\n###<<ERROR>>[file]%s%s,[func]%s,[line]%d,[time]%d:%d:%d###\r\n"

#define NOINFOMODE__DEBUGER__	((UINT)0)
#define INFOMODE__DEBUGER__	((UINT)1)
#define WARNINGMODE__DEBUGER__	((UINT)2)
#define	ERRORMODE__DEBUGER__	((UINT)3)





#define SEPARATE__DEBUGER__	"--------------------"


#define TRACEING__DEBUGER__		(1)
#define MESSAGEBOXING__DEBUGER__	(2)
#define PRINTING__DEBUGER__		(4)
#define LOGGING__DEBUGER__			(8)
#define DUMPING__DEBUGER__			(TRACEING__DEBUGER__ | PRINTING__DEBUGER__ | LOGGING__DEBUGER__)
#define LINEFEAD__DEBUGER__		(16)
#define SEPARATEING__DEBUGER__		(32)		
#define WTEXTS__DEBUGER__(quote)		L##quote
#define WTEXT__DEBUGER__(quote)	WTEXTS__DEBUGER__(quote)
#define VARIABLE_TO_STRING__DEBUGER__(variable)	# variable

#define JOININ_DEBGER_(x,y) x ## y
#define JOIN__DEBGER__(x,y) JOININ_DEBGER_(x,y)



	

#if defined(_DEBUG) || defined(DEBUG)
// DebuĝƂ




#ifdef UNICODE

#define trace(format,...)					trace_w(format,__VA_ARGS__)


#define mb(format,...)					mb_w(format,__VA_ARGS__)



#define print(format,...)					print_w(format,__VA_ARGS__)



#define log(format,...)						log_w(format,__VA_ARGS__)



#define dump(format,...)					dump_w(format,__VA_ARGS__)


//s
#define traceline()					traceline_w()
#define printline()					printline_w()
#define logline()					logline_w()
#define dumpline()					dumpline_w()

//o͂ĉs
	
#define traceln(format,...)					traceln_w(format,__VA_ARGS__)

#define println(format,...)					println_w(format,__VA_ARGS__)

#define logln(format,...)					logln_w(format,__VA_ARGS__)

#define dumpln(format,...)					dumpln_w(format,__VA_ARGS__)


#define tracesep(format,...)				tracesep_w(format,__VA_ARGS__)




#define printsep(format,...)				printsep_w(format,__VA_ARGS__)




#define logsep(format,...)					logsep_w(format,__VA_ARGS__)



#define dumpsep(format,...)					dumpsep_w(format,__VA_ARGS__)




#define itrace(format,...)					itrace_w(format,__VA_ARGS__)



#define imb(format,...)						imb_w(format,__VA_ARGS__)


#define iprint(format,...)						iprint_w(format,__VA_ARGS__)




#define ilog(format,...)					ilog_w(format,__VA_ARGS__)





#define idump(format,...)				idump_w(format,__VA_ARGS__)





//o͂ĉs

#define itraceln(format,...)				itraceln_w(format,__VA_ARGS__)



#define iprintln(format,...)				iprintln_w(format,__VA_ARGS__)



#define ilogln(format,...)					ilogln_w(format,__VA_ARGS__)



#define idumpln(format,...)					idumpln_w(format,__VA_ARGS__)



//xEG[

#define warningprint(format,...)				waningprint_w(format,__VA_ARGS__)


#define errprint(format,...)					errprint_w(format,__VA_ARGS__)

#else //UNICODE

#define trace(format,...)					trace_mb(CP_THREAD_ACP,format,__VA_ARGS__)


#define mb(format,...)					mb_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define print(format,...)					print_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define log(format,...)						log_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define dump(format,...)					dump_mb(CP_THREAD_ACP,format,__VA_ARGS__)


//s
#define traceline()					traceline_mb()
#define printline()					printline_mb()
#define logline()					logline_mb()
#define dumpline()					dumpline_mb()

//o͂ĉs
	
#define traceln(format,...)					traceln_mb(CP_THREAD_ACP,format,__VA_ARGS__)

#define println(format,...)					println_mb(CP_THREAD_ACP,format,__VA_ARGS__)

#define logln(format,...)					logln_mb(CP_THREAD_ACP,format,__VA_ARGS__)

#define dumpln(format,...)					dumpln_mb(CP_THREAD_ACP,format,__VA_ARGS__)


#define tracesep(format,...)				tracesep_mb(CP_THREAD_ACP,format,__VA_ARGS__)




#define printsep(format,...)				printsep_mb(CP_THREAD_ACP,format,__VA_ARGS__)




#define logsep(format,...)					logsep_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define dumpsep(format,...)					dumpsep_mb(CP_THREAD_ACP,format,__VA_ARGS__)




#define itrace(format,...)					itrace_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define imb(format,...)						imb_mb(CP_THREAD_ACP,format,__VA_ARGS__)


#define iprint(format,...)						iprint_mb(CP_THREAD_ACP,format,__VA_ARGS__)




#define ilog(format,...)					ilog_mb(CP_THREAD_ACP,format,__VA_ARGS__)





#define idump(format,...)				idump_mb(CP_THREAD_ACP,format,__VA_ARGS__)





//o͂ĉs

#define itraceln(format,...)				itraceln_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define iprintln(format,...)				iprintln_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define ilogln(format,...)					ilogln_mb(CP_THREAD_ACP,format,__VA_ARGS__)



#define idumpln(format,...)					idumpln_mb(CP_THREAD_ACP,format,__VA_ARGS__)


//xEG[

#define warningprint(format,...)				waningprint_mb(CP_THREAD_ACP,format,__VA_ARGS__)


#define errprint(format,...)					errprint_mb(CP_THREAD_ACP,format,__VA_ARGS__)

#endif //UNICODE


//}`oCg


#define trace_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,TRACEING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define mb_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,MESSAGEBOXING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define print_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,PRINTING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define log_mb(cp,format,...)						DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,LOGGING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define dump_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


//s
#define traceline_mb()					traceln_mb(CP_THREAD_ACP,"")
#define printline_mb()					println_mb(CP_THREAD_ACP,"")
#define logline_mb()						logln_mb(CP_THREAD_ACP,"")
#define dumpline_mb()					dumpln_mb(CP_THREAD_ACP,"")

//o͂ĉs
	
#define traceln_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,TRACEING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define println_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,PRINTING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define logln_mb(cp,format,...)						DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,LOGGING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define dumpln_mb(cp,format,...)						DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define tracesep_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,TRACEING__DEBUGER__ |SEPARATEING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)
#define printsep_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,PRINTING__DEBUGER__ | SEPARATEING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)
#define logsep_mb(cp,format,...)						DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,LOGGING__DEBUGER__ | SEPARATEING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define dumpsep_mb(cp,format,...)				DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__ | SEPARATEING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)




#define itrace_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,TRACEING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)


#define imb_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,MESSAGEBOXING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





#define iprint_mb(cp,format,...)						DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,PRINTING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)




#define ilog_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,LOGGING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





#define idump_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





//o͂ĉs

#define itraceln_mb(cp,format,...)				DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,TRACEING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)


#define iprintln_mb(cp,format,...)				DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,PRINTING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)



#define ilogln_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,LOGGING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





#define idumpln_mb(cp,format,...)				DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)

#define waningprint_mb(cp,format,...)				DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ ,WARNINGMODE__DEBUGER__,format,__VA_ARGS__)

#define errprint_mb(cp,format,...)					DebugOutMB(cp,__FILE__,__FUNCTION__,__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ ,ERRORMODE__DEBUGER__,format,__VA_ARGS__)


//Ch

#define trace_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,TRACEING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


#define mb_w(format,...)						DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,MESSAGEBOXING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define print_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,PRINTING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define log_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,LOGGING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)



#define dump_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

//s
#define traceline_w()					traceln_w(L"")
#define printline_w()					println_w(L"")
#define logline_w()						println_w(L"")
#define dumpline_w()					dumpln_w(L"");

//o͂ĉs
	
#define traceln_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,TRACEING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


#define println_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,PRINTING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


#define logln_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,LOGGING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


#define dumpln_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define tracesep_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,TRACEING__DEBUGER__ | LINEFEAD__DEBUGER__ | SEPARATEING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


#define printsep_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,PRINTING__DEBUGER__ | LINEFEAD__DEBUGER__ | SEPARATEING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)


#define logsep_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,LOGGING__DEBUGER__ | LINEFEAD__DEBUGER__ | SEPARATEING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)

#define dumpsep_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ | SEPARATEING__DEBUGER__,NOINFOMODE__DEBUGER__,format,__VA_ARGS__)




#define itrace_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,TRACEING__DEBUGER__  ,INFOMODE__DEBUGER__,format,__VA_ARGS__)



#define imb_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,MESSAGEBOXING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





#define iprint_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,PRINTING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)




#define ilog_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,LOGGING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





#define idump_w(format,...)					DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)



#define itraceln_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,TRACEING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)


#define iprintln_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,PRINTING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)



#define ilogln_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,LOGGING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)





#define idumpln_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ ,INFOMODE__DEBUGER__,format,__VA_ARGS__)

#define waningprint_w(format,...)			DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ ,WARNINGMODE__DEBUGER__,format,__VA_ARGS__)

#define errprint_w(format,...)				DebugOutW(WTEXT__DEBUGER__(__FILE__),WTEXT__DEBUGER__(__FUNCTION__),__LINE__,DUMPING__DEBUGER__ | LINEFEAD__DEBUGER__ ,ERRORMODE__DEBUGER__,format,__VA_ARGS__)





#define vcassert(value,message) \
	if (!(value)) { \
		errprint(TEXT("AT[VG[:%s\r\n%s"),TEXT(VARIABLE_TO_STRING__DEBUGER__(value)),message);\
		DebugBreak(); \
	}
#define vcverify(value,message)   vcassert(value,message)


#define check(value,message)\
	if (!(value)) { \
		errprint(TEXT("`FbNG[:%s\r\n%s"),TEXT(VARIABLE_TO_STRING__DEBUGER__(value)),message);\
	}

#define judge(value,message)	check(value,message)


#define wincheck(value)\
	if(value != ERROR_SUCCESS){\
		LPTSTR lpMsgBuf;\
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL, value,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &lpMsgBuf,0,(va_list*)NULL);\
		errprint(TEXT("OSG[:\r\nG[R[h:0x%x\r\nG[bZ[W:%s\r\n"),value,lpMsgBuf);\
		LocalFree(lpMsgBuf);\
	}
	
#define winjudge(value)	wincheck(value)



#define timer_set(name)\
	clock_t name


#define timer_start(name)\
	dumpln(TEXT("[%s]^C}[vJn"),TEXT(#name));\
	name = clock()

#define timer_end(name)\
	dumpln(TEXT("[%s]^C}[v:%.2fb܂"),TEXT(#name),((double)(clock() - name) / CLOCKS_PER_SEC))
	










static VOID DebugOutputCommon(LPCWSTR szBuf,UINT mode,const struct tm* now);
//ChpfobO֐
static VOID DebugOutW(LPCWSTR fileName,LPCWSTR functionName,UINT lineNo,UINT mode,UINT infoFlag,LPCWSTR pszFormat, ...);

//}`oCgpfobO֐
static VOID DebugOutMB(UINT codePage,LPSTR fileName,LPSTR functionName,UINT lineNo,UINT mode,UINT infoFlag,LPCSTR pszFormat, ...);





 
static VOID DebugOutputCommon(LPCWSTR szBuf,UINT mode,const struct tm* now){


	
	LPWSTR logFileNameFormat = L"debug_%d-%d-%d.log";
	


#ifndef WINDEBUGER_NOTRACEING
	if(mode & TRACEING__DEBUGER__){
		OutputDebugStringW( szBuf);
	}
#endif

#ifndef WINDEBUGER_NOPRINTING
	if(mode & PRINTING__DEBUGER__){
		DWORD number;
		AllocConsole();
		WriteConsoleW(GetStdHandle(STD_OUTPUT_HANDLE),szBuf,wcslen(szBuf),&number,NULL);
		

	}
#endif

#ifndef WINDEBUGER_NOMESSAGEBOX
	if(mode & MESSAGEBOXING__DEBUGER__){
		MessageBoxW((HWND)NULL,szBuf,L"fobObZ[W",MB_OK);
	}
#endif

	
#ifndef WINDEBUGER_NOLOGGING
	if(mode & LOGGING__DEBUGER__){
		WCHAR logFileName[24];
		wsprintfW(logFileName,logFileNameFormat,now->tm_year + 1900,now->tm_mon + 1,now->tm_mday);


		do{
			
			OVERLAPPED ovl;
			DWORD fileSize;
			HANDLE hFile = CreateFile(logFileName, GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE ,(LPSECURITY_ATTRIBUTES)NULL, OPEN_ALWAYS, FILE_FLAG_OVERLAPPED, NULL);
			DWORD dwWritten;
			
			if(hFile == INVALID_HANDLE_VALUE){
				continue;
			}
			


			
			LockFile(hFile, 0, 0, 0xFFFFFFFF, 0xFFFFFFFF);
			
			
			fileSize = GetFileSize(hFile,(LPDWORD)NULL);
			memset(&ovl, 0, sizeof(OVERLAPPED));
			ovl.Offset = fileSize;
			
			WriteFile(hFile, szBuf, (DWORD)wcslen(szBuf) * sizeof (WCHAR), &dwWritten, &ovl);

			GetOverlappedResult(hFile,&ovl,&dwWritten,TRUE);
    
			UnlockFile(hFile, 0, 0, 0xFFFFFFFF, 0xFFFFFFFF);

			CloseHandle(hFile);
			


			



		}while(0);

	}
#endif
	return;

}





static VOID DebugOutW(LPCWSTR fileName,LPCWSTR functionName,UINT lineNo, UINT mode,UINT infoFlag,LPCWSTR pszFormat, ...){

	
	LPWSTR szFormat = mode & LINEFEAD__DEBUGER__ ?  L"%s%s%s%s\r\n" : L"%s%s%s%s";
	LPWSTR szBuf = (LPWSTR)NULL;
	LPWSTR info = (LPWSTR)NULL;
	LPWSTR body = (LPWSTR)NULL;
	SIZE_T bodyLength;
	LPWSTR sep = mode & SEPARATEING__DEBUGER__ ?  WTEXT__DEBUGER__(SEPARATE__DEBUGER__) : (LPWSTR)NULL;
	LPWSTR debugFormat = (LPWSTR)NULL;
	
	WCHAR file[_MAX_FNAME];
	WCHAR ext[_MAX_EXT];

	va_list	argp;

	




	time_t nowtime = time((time_t*)NULL);
	struct tm now;
	localtime_s(&now,&nowtime);


	

	if(infoFlag){
		
		switch(infoFlag){

		case INFOMODE__DEBUGER__:
			debugFormat = WTEXT__DEBUGER__(DEBUGFORMAT__DEBUGER__);
			break;


		case WARNINGMODE__DEBUGER__:
			debugFormat = WTEXT__DEBUGER__(DEBUG_WARNINGFORMAT__DEBUGER__);
			break;

		case ERRORMODE__DEBUGER__:
			debugFormat = WTEXT__DEBUGER__(DEBUG_ERRFORMAT__DEBUGER__);
			break;




		}
		_wsplitpath(fileName,(wchar_t*)NULL,(wchar_t*)NULL,file,ext);
		info = (LPWSTR)malloc(sizeof(WCHAR) * (_scwprintf(debugFormat,file,ext,functionName,lineNo,now.tm_hour,now.tm_min,now.tm_sec) + 1));
		wsprintfW(info,debugFormat,file,ext,functionName,lineNo,now.tm_hour,now.tm_min,now.tm_sec);

	}

	va_start(argp, pszFormat);
	bodyLength = _vscwprintf(pszFormat,argp) + 1;
	
	body = (LPWSTR)malloc(sizeof(WCHAR) * bodyLength);
	vswprintf_s(body,bodyLength,pszFormat,argp);
	va_end(argp);

	szBuf = (LPWSTR)malloc(sizeof(WCHAR)* (_scwprintf(szFormat,sep,info,body,sep) + 1));
	wsprintfW(szBuf,szFormat,sep,info,body,sep);



	DebugOutputCommon(szBuf,mode,&now);


	free(szBuf);
	free(info);
	free(body);

	return;
}


static VOID DebugOutMB(UINT codePage,LPSTR fileName,LPSTR functionName,UINT lineNo,UINT mode,UINT infoFlag,LPCSTR pszFormat, ...){


	LPSTR szFormat = mode & LINEFEAD__DEBUGER__ ?  "%s%s%s%s\r\n" : "%s%s%s%s";
	LPSTR szBuf = (LPSTR)NULL;
	LPWSTR wszBuf= (LPWSTR)NULL;
	LPSTR info = (LPSTR)NULL;
	LPSTR body = (LPSTR)NULL;
	LPSTR debugFormat = (LPSTR)NULL;
	LPSTR sep = mode & SEPARATEING__DEBUGER__ ?  SEPARATE__DEBUGER__ : "";
	CHAR file[_MAX_FNAME];
	CHAR ext[_MAX_EXT];
	SIZE_T towidelen;

	va_list	argp;






	time_t nowtime = time((time_t*)NULL);
	struct tm now;
	localtime_s(&now,&nowtime);


	

	if(infoFlag){
		



		switch(infoFlag){

		case INFOMODE__DEBUGER__:
			debugFormat = DEBUGFORMAT__DEBUGER__;
			break;


		case WARNINGMODE__DEBUGER__:
			debugFormat = DEBUG_WARNINGFORMAT__DEBUGER__;
			break;

		case ERRORMODE__DEBUGER__:
			debugFormat = DEBUG_ERRFORMAT__DEBUGER__;
			break;




		}
		_splitpath(fileName,(char*)NULL,(char*)NULL,file,ext);
		info = (LPSTR)malloc(sizeof(CHAR) * (_scprintf(debugFormat,file,ext,functionName,lineNo,now.tm_hour,now.tm_min,now.tm_sec) + 1));
		sprintf(info,debugFormat,file,ext,functionName,lineNo,now.tm_hour,now.tm_min,now.tm_sec);

	} 

	va_start(argp, pszFormat);
	body = (LPSTR)malloc((sizeof(CHAR) * (_vscprintf(pszFormat,argp) + 1)));
	vsprintf(body,pszFormat,argp);

	va_end(argp);

	szBuf = (LPSTR)malloc(sizeof(CHAR)* (_scprintf(szFormat,sep,info,body,sep) + 1));
	
	if(info != NULL){
		sprintf(szBuf,szFormat,sep,info,body,sep);
	}else {
		sprintf(szBuf,szFormat,sep,"",body,sep);
	}



	towidelen = MultiByteToWideChar(codePage,0,szBuf,-1,(LPWSTR)NULL,0);
	wszBuf = (LPWSTR)malloc(sizeof(WCHAR) * towidelen);
	MultiByteToWideChar(codePage,0,szBuf,-1,wszBuf,towidelen);
	

	DebugOutputCommon(wszBuf,mode,&now);


	free(wszBuf);
	free(szBuf);
	free(info);
	free(body);

	return;





}



#else

#define trace(format,...)					


#define mb(format,...)					



#define print(format,...)					



#define log(format,...)						



#define dump(format,...)					


//s
#define traceline()					
#define printline()					
#define logline()					
#define dumpline()					

//o͂ĉs
	
#define traceln(format,...)					

#define println(format,...)					

#define logln(format,...)					

#define dumpln(format,...)					


#define tracesep(format,...)				




#define printsep(format,...)				




#define logsep(format,...)					



#define dumpsep(format,...)					




#define itrace(format,...)					



#define imb(format,...)						


#define iprint(format,...)						




#define ilog(format,...)					





#define idump(format,...)				





//o͂ĉs

#define itraceln(format,...)				



#define iprintln(format,...)				



#define ilogln(format,...)					



#define idumpln(format,...)					



//xEG[

#define warningprint(format,...)				


#define errprint(format,...)					




//}`oCg


#define trace_mb(cp,format,...)					

#define mb_mb(cp,format,...)					

#define print_mb(cp,format,...)					

#define log_mb(cp,format,...)						

#define dump_mb(cp,format,...)					


//s
#define traceline_mb()					
#define printline_mb()					
#define logline_mb()					
#define dumpline_mb()					

//o͂ĉs
	
#define traceln_mb(cp,format,...)					
#define println_mb(cp,format,...)					

#define logln_mb(cp,format,...)						

#define dumpln_mb(cp,format,...)						

#define tracesep_mb(cp,format,...)					
#define printsep_mb(cp,format,...)					
#define logsep_mb(cp,format,...)						
#define dumpsep_mb(cp,format,...)				




#define itrace_mb(cp,format,...)					


#define imb_mb(cp,format,...)					





#define iprint_mb(cp,format,...)						




#define ilog_mb(cp,format,...)					





#define idump_mb(cp,format,...)					





//o͂ĉs

#define itraceln_mb(cp,format,...)				


#define iprintln_mb(cp,format,...)				



#define ilogln_mb(cp,format,...)					





#define idumpln_mb(cp,format,...)				
#define waningprint_mb(cp,format,...)				

#define errprint_mb(cp,format,...)					


//Ch

#define trace_w(format,...)					


#define mb_w(format,...)						

#define print_w(format,...)					

#define log_w(format,...)					



#define dump_w(format,...)					

//s
#define traceline_w()					
#define printline_w()					
#define logline_w()						
#define dumpline_w()					

//o͂ĉs
	
#define traceln_w(format,...)					


#define println_w(format,...)					


#define logln_w(format,...)					


#define dumpln_w(format,...)					

#define tracesep_w(format,...)				


#define printsep_w(format,...)				


#define logsep_w(format,...)					

#define dumpsep_w(format,...)				




#define itrace_w(format,...)				



#define imb_w(format,...)					





#define iprint_w(format,...)				




#define ilog_w(format,...)					





#define idump_w(format,...)					


#define itraceln_w(format,...)				

#define iprintln_w(format,...)				



#define ilogln_w(format,...)					





#define idumpln_w(format,...)				

#define waningprint_w(format,...)			

#define errprint_w(format,...)				




#define vcassert(value,message)

#define vcverify(value,message)  (value)


#define check(value,message)
#define judge(value,message)	(value)

#define wincheck(value)

#define winjudge(value)			(value)

#define timer_set(name)


#define timer_start(name)

#define timer_end(name)





#endif



