#pragma once

//
//CN[h
/////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <stdint.h>

//
//^`
/////////////////////////////////////////////////////////////


///
///json̓IuWFNg|C^
///
typedef struct jsonparser_t *JSONParser_P;


///
///json^
///
typedef wchar_t JSONChar;

///
///json|C^
///
typedef JSONChar *JSONChar_P;





///
///^
///
typedef intptr_t JSONInt;
typedef uintptr_t JSONUInt;

///
///^
///
typedef double JSONDouble;

///
///^U^
///
typedef JSONUInt JSONBool;



///
///json void^
///
typedef void JSONVoid;


///
///R[obNp[[^^
///
typedef JSONUInt JSONParameter;


///
///߂l
///
typedef JSONUInt JSONResult;


///
///\͎̉R[obN
///
typedef JSONVoid (*JSONStructEventHandler)(JSONVoid *,JSONUInt,JSONUInt,JSONChar_P);


///
///\̃f[^͎R[obN
///
typedef JSONVoid (*JSONDataEventHandler)(JSONVoid *,JSONUInt,JSONUInt,JSONChar_P,JSONParameter);

///
///\̏I[͎R[obN
///
typedef JSONVoid (*JSONStructEndEventHandler)(JSONVoid *,JSONUInt,JSONUInt,JSONChar_P);






//
//define
/////////////////////////////////////////////////////////////////////////

//
//G[
//

///I
#define JSON_ERR_OK										((JSONResult)0)

///w肵GR[h^Cv`ĂȂ
#define JSON_ERR_ENCODE_UNKNOWN							((JSONResult)1)

///json\G[
#define JSON_ERR_SYNTAX									((JSONResult)2)

///ϊG[
#define JSON_ERR_CONVERT								((JSONResult)3)									



///rsltĂȂ
#define JSON_ERR_NOTINIT								((JSONResult)UINTPTR_MAX)











//
//GR[h[h
//݂UTF8̂
//

#define JSON_ENCODE_UTF8		((JSONParameter)0)




//
//^Ul
//

///true
#define JSONTrue				((JSONBool)1)


///false
#define JSONFalse				((JSONBool)0)




//
//l^Cv
//
#define JSONTypeRoot			((JSONUInt)0)

///IuWFNg
#define JSONTypeObject			((JSONUInt)1)

///z
#define JSONTypeArray			((JSONUInt)2)

///^Ul
#define JSONTypeBool			((JSONUInt)3)

///
#define JSONTypeString			((JSONUInt)4)

///10i
#define JSONTypeDecimal			((JSONUInt)5)

///null
#define JSONNull				((JSONUInt)6)








//
//֐
//////////////////////////////////////////////////////////////////////////


#ifdef __cplusplus
extern "C" {
#endif


	///
	///p[TIuWFNg
	///
	extern JSONParser_P JSONParser_new();

	///
	///p[TIuWFNgj
	///
	extern JSONVoid JSONParser_delete(JSONParser_P *parser);

	///
	///\̃Cxgnh
	///
	extern JSONVoid JSONParser_setStructHandler(JSONParser_P parser,JSONStructEventHandler handler);

	///
	///IuWFNgCxgnhZbg
	///
	extern JSONVoid JSONParser_setDataEventHandler(JSONParser_P parser,JSONDataEventHandler handler);



	///
	///IuWFNgI[CxgnhZbg
	///
	extern JSONVoid JSONParser_setDataEndEventHandler(JSONParser_P parser,JSONStructEndEventHandler handler);


	///
	///IuWFNgJnEI[nhZbg
	///
	extern JSONVoid JSONParser_setEventHandler(JSONParser_P parser,JSONStructEventHandler structHandler,JSONDataEventHandler dataHandler,JSONStructEndEventHandler endHandler);


	///
	///͊Jn
	///
	extern JSONResult JSONParser_Parse(JSONParser_P parser,const JSONVoid *jsontext,JSONParameter encode,JSONVoid *option);










#ifdef __cplusplus
}
#endif