#include "stdafx.h"
#include <nlite_common\define.h>
#include "define.h"
#include "cookieGetResult.h"
#include "cookie.h"
#include "chromecookiegetter.h"
#include "firefoxcookiegetter.h"
#include "iecomponentcookiegetter.h"
#include "safaricookiegetter.h"
#include "operacookiegetter.h"
#include "iecookiegetter.h"
#include "cookieGetter.h"
#include "cookiemaster.h"
#include "unit_test.h"







#include "namespace_start.h"

class TestGetter:public CCookieGetterT<TestGetter>{};


static Void CookieManageTest(browsertype::BrowserType bt){

	CCookie cookie;
	NString domein = _T("nicovideo.jp");
	NString name = _T("user_session");
	MString cookieval;
	NString browsertypestr = CCookieMaster::BrowserTypeToString(bt);
	MString browsertypestrm;
	ToSJIS(browsertypestrm,browsertypestr);
	auto &cookiemaster = CCookieMaster::GetInstance();
	Bool result = false;
	result = cookiemaster.GetCookie(bt,domein,name,cookie);
	ToSJIS(cookieval,cookie.GetCookieValue());

	std::cout <<"browsertype:" << browsertypestrm << "result:" << result << "cookie:" <<  cookieval << std::endl;
		
	BOOST_CHECK_MESSAGE(result,"cookie܂ł");
	
}

Void UnitTest(){

	CCookieGetResult cookieResult(browsertype::UNDEFINED);
	BOOST_CHECK_MESSAGE(cookieResult.findFlag== false,"cookieResult::findFlag G[ł");
	BOOST_CHECK_MESSAGE(cookieResult.browserType == browsertype::UNDEFINED,"cookieResult::browserType G[ł");
	BOOST_CHECK_MESSAGE(cookieResult.resultCode == resultcode::UNDEFINED,"cookieResult::resultCode G[ł");

	cookieResult.SetFindFlag(true);
	cookieResult.SetBrowserType(browsertype::IE);
	cookieResult.SetResultCode(resultcode::OK);
	BOOST_CHECK_MESSAGE(cookieResult.findFlag == true,"cookieResult::SetFindFlag ZbgG[ł");
	BOOST_CHECK_MESSAGE(cookieResult.browserType == browsertype::IE,"uEU^CvZbgG[ł");
	BOOST_CHECK_MESSAGE(cookieResult.resultCode == resultcode::OK,"ʃR[hZbgG[ł");


	BOOST_CHECK_MESSAGE(cookieResult.IsFound() == true,"cookieResult::SetFindFlag QbgG[ł");
	BOOST_CHECK_MESSAGE(cookieResult.GetBrowserType() == browsertype::IE,"uEU^CvQbgG[ł");
	BOOST_CHECK_MESSAGE(cookieResult.GetResultCode() == resultcode::OK,"ʃR[hQbgG[ł");
	
	U16String cookiedomein = _T("domein");
	U16String cookiename = _T("name");
	U16String cookieValue = _T("cookieValue");
	CCookie cookie;
	cookie.domein = cookiedomein;
	cookie.name = cookiename;
	cookie.cookieValue = cookieValue;

	BOOST_CHECK_MESSAGE(cookie.domein == cookiedomein,"NbL[NX̃hC擾G[ł");
	BOOST_CHECK_MESSAGE(cookie.name == cookiename,"NbL[NX̖O擾G[ł");
	BOOST_CHECK_MESSAGE(cookie.cookieValue == cookieValue,"NbL[NX̒l擾G[ł");


	TestGetter testGetter;

	Bool exceptionflag = false;
	




	{
		CCookie cookie1;
		BOOST_CHECK_MESSAGE(!CChromeCookieGetter::CreateCookiePath().empty(),"N[̃NbL[pX擾Ɏs܂");
		CChromeCookieGetter chromeCookieGetter;
		Bool result;
		exceptionflag = false;
		NString domein = _T("nicovideo.jp");
		NString name = _T("user_session");
		try{

			result = chromeCookieGetter.GetCookie(domein,name,cookie1);

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}
	
		BOOST_CHECK_MESSAGE(exceptionflag == false,"NbL[ɗO܂");
		BOOST_CHECK_MESSAGE(result == true,"NbL[܂ł");

		exceptionflag = true;
		Bool result2 = false;
		CCookie cookie2;
		try{
			result2 = ForceSearch(chromeCookieGetter.cookieFilePath,domein,name,cookie2,CChromeCookieGetter::Fancta);
		

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}

		BOOST_CHECK_MESSAGE(result2 == true,"NbL[܂ł");

		if(result && result2){
			BOOST_CHECK_MESSAGE(cookie1.GetCookieValue() == cookie2.GetCookieValue(),"K̕@Ŏ擾NbL[ƋŎ擾NbL[Ⴂ܂");
		}
	}

	{
		CCookie cookie1;
		
		COperaCookieGetter cookieGetter;
		Bool result;
		exceptionflag = false;
		NString domein = _T("nicovideo.jp");
		NString name = _T("user_session");
		try{

			result = cookieGetter.GetCookie(domein,name,cookie1);

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}
	
		BOOST_CHECK_MESSAGE(exceptionflag == false,"NbL[ɗO܂");
		BOOST_CHECK_MESSAGE(result == true,"NbL[܂ł");
	}

	{
		CCookie cookie1;
		
		CSafariCookieGetter cookieGetter;
		Bool result;
		exceptionflag = false;
		NString domein = _T("nicovideo.jp");
		NString name = _T("user_session");
		try{

			result = cookieGetter.GetCookie(domein,name,cookie1);

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}
	
		BOOST_CHECK_MESSAGE(exceptionflag == false,"NbL[ɗO܂");
		BOOST_CHECK_MESSAGE(result == true,"NbL[܂ł");
	}
	
	{
		CCookie cookie1;
		BOOST_CHECK_MESSAGE(!CFireFoxCookieGetter::CreateCookiePath().empty(),"NbL[pX擾Ɏs܂");
		CFireFoxCookieGetter firefoxcookiegetter;
		Bool result;
		exceptionflag = false;
		NString domein = _T("nicovideo.jp");
		NString name = _T("user_session");
		try{

			result = firefoxcookiegetter.GetCookie(domein,name,cookie1);

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}
	
		BOOST_CHECK_MESSAGE(exceptionflag == false,"NbL[ɗO܂");
		BOOST_CHECK_MESSAGE(result == true,"NbL[܂ł");

		exceptionflag = true;
		Bool result2 = false;
		CCookie cookie2;
		try{
			result2 = ForceSearch(firefoxcookiegetter.cookieFilePath,domein,name,cookie2,CFireFoxCookieGetter::Fancta);
		

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}

		BOOST_CHECK_MESSAGE(result2 == true,"NbL[܂ł");

		if(result && result2){
			BOOST_CHECK_MESSAGE(cookie1.GetCookieValue() == cookie2.GetCookieValue(),"K̕@Ŏ擾NbL[ƋŎ擾NbL[Ⴂ܂");
		}
	}
	
	{
		CCookie cookie1;
		CIECookieGetter::IEIsSecurityMode();
		
		
		CIECookieGetter cookieGetters;
		Bool result;
		exceptionflag = false;
		NString domein = _T("nicovideo.jp");
		NString name = _T("user_session");
		try{

			result = cookieGetters.GetCookie(domein,name,cookie1);

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}
	
		BOOST_CHECK_MESSAGE(exceptionflag == false,"NbL[ɗO܂");
		BOOST_CHECK_MESSAGE(result == true,"NbL[܂ł");

		exceptionflag = true;
		Bool result2 = false;
		CCookie cookie2;
		try{

			CCookieGetResult result = cookieGetters.ForceSearchFiles(cookieGetters.securityCookiedir,domein,name,cookie2,CIECookieGetter::Fancta);
		
			result2 = result.IsFound();

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}

		BOOST_CHECK_MESSAGE(result2 == true,"NbL[܂ł");

		if(result && result2){
			BOOST_CHECK_MESSAGE(cookie1.GetCookieValue() == cookie2.GetCookieValue(),"K̕@Ŏ擾NbL[ƋŎ擾NbL[Ⴂ܂");
		}
		
	}


	{
		CCookie cookie1;
	
		
		CIEComponentGetter cookieGetters;
		Bool result;
		exceptionflag = false;
		NString domein = _T("nicovideo.jp");
		NString name = _T("user_session");
		try{

			result = cookieGetters.GetCookie(domein,name,cookie1);

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}
	
		BOOST_CHECK_MESSAGE(exceptionflag == false,"NbL[ɗO܂");
		BOOST_CHECK_MESSAGE(result == true,"NbL[܂ł");

		exceptionflag = true;
		Bool result2 = false;
		CCookie cookie2;
		try{

			CCookieGetResult result = cookieGetters.ForceSearchFiles(cookieGetters.normalDirectry,domein,name,cookie2,CIECookieGetter::Fancta);
		
			result2 = result.IsFound();

		} catch(Exception &e3){
			e3;
			exceptionflag = true;
		}

		BOOST_CHECK_MESSAGE(result2 == true,"NbL[܂ł");

		if(result && result2){
			BOOST_CHECK_MESSAGE(cookie1.GetCookieValue() == cookie2.GetCookieValue(),"K̕@Ŏ擾NbL[ƋŎ擾NbL[Ⴂ܂");
		}
		
	}

	CookieManageTest(browsertype::IE);
	CookieManageTest(browsertype::FIREFOX);
	CookieManageTest(browsertype::CHROME);
	CookieManageTest(browsertype::IECOMPONENT);
	CookieManageTest(browsertype::OPERA);
	CookieManageTest(browsertype::SAFARI);
	
	/*
	CCookieGetResult rslt(browsertype::UNDEFINED);

	rslt.SetResultCode(resultcode::ERR_IEAPI_SEC);
	rslt.SetHResult(-1);
	rslt.Report();
	*/
	return;
	
}



#include "namespace_end.h"