#include "stdafx.h"
#include "iecookiegetter.h"

#include "namespace_start.h"

browsertype::BrowserType CIECookieGetter::BT = browsertype::IE;


CIECookieGetter::CIECookieGetter(){

	securityCookiedir = this->normalDirectry + _T("\\Low");
}

Bool CIECookieGetter::GetCookieInternal(const NString &domein,const NString &name,CCookie &cookie){

	Bool secFlag = IEIsSecurityMode();
	CCookieGetResult result = this->GetCookieIEAPI(domein,name,cookie,secFlag);

	if(result.GetResultCode() != resultcode::OK || (!result.IsFound())){

		resultList.push_back(result);
		CCookieGetResult forceresult = CIECookieGetter::ForceSearchFiles(secFlag ? this->securityCookiedir : this->normalDirectry,domein,name,cookie,CIECookieGetter::Fancta);

		if(forceresult.GetResultCode() != resultcode::OK){

			resultList.push_back(forceresult);
		}

	}



	return result.IsFound();
}

Bool CIECookieGetter::IEIsSecurityMode(){

	CRegistryKey regkey;
	if(!regkey.OpenKey(HKEY_CURRENT_USER,_T("Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\3")).IsS_OK()){

		THROW_EXCEPTION(Exception,_T("WXgL[J܂ł"));
	}

	Int securityMode;
	if(!regkey.QueryValue(_T("2500"),securityMode).IsS_OK()){

		return false;
	}



	return securityMode == 0;
}



#include "namespace_end.h"