#include "stdafx.h"
#include <nlite_common\bugreport.h>
#include "cookieGetResult.h"
#include "cookiemaster.h"
#include <nlite_common\windowsAPI.h>

#include "namespace_start.h"

CCookieGetResult::CCookieGetResult(browsertype::BrowserType bt):
	findFlag(false),
	resultCode(resultcode::UNDEFINED),
	browserType(bt)
	
	{}

Void CCookieGetResult::Report(){

	BugTransfer bug;

	bug.function = _T("cookieGetFunction");
	bug.line = _T("0");
	bug.sourcefile = _T("cookieGetFile");
	nstringstream ns;
	NString btstr = CCookieMaster::BrowserTypeToString(this->browserType);
	NString rcstr = CCookieMaster::ResultCodeToString(this->resultCode);
	ns << _T("BT-") << btstr << _T(" RC-") << rcstr << _T(",");
	bug.windowsErrorCode = _T("0");
	bug.windowsErrorMessage =_T("`ł");
	switch(this->resultCode){


	case resultcode::ERR_SQLITE:

		ns << _T("sqliteerr:") << this->GetExtendCode().sqliteResult;

		break;

	case resultcode::ERR_IEAPI:

		ns << _T("IEnomalerr:");
		goto winerr;

	case resultcode::ERR_IEAPI_SEC:

		ns << _T("IESecerr:");
		goto winerr;

winerr:
		{
			NString winerrStr;
			
			bug.windowsErrorCode = boost::lexical_cast<NString>(this->GetExtendCode().hResult);
			GetWindowsErrorMessage(winerrStr,this->GetExtendCode().hResult);
			if(!winerrStr.empty()){
				bug.windowsErrorMessage = winerrStr;
			}
		}
		break;

	case resultcode::OK:
	case resultcode::UNDEFINED:

		break;


	}
	bug.summary = ns.str();

	auto &reporter = CBugReporter::GetInstance();
	reporter.Report(bug);

	
}


Void CCookieGetResult::SetFindFlag(Bool findFlag){

	this->findFlag = findFlag;
}

Void CCookieGetResult::SetBrowserType(browsertype::BrowserType browserType){

	this->browserType = browserType;
}

Void CCookieGetResult::SetResultCode(resultcode::ResultCode resultCode){

	this->resultCode = resultCode;

}

Void CCookieGetResult::SetHResult(HRESULT hResult){

	this->extendCode.hResult = hResult;
}

Void CCookieGetResult::SetSQLiteResult(int sqliteResult){

	this->extendCode.sqliteResult = sqliteResult;
}



Bool CCookieGetResult::IsFound()const{


	return this->findFlag;
}

browsertype::BrowserType CCookieGetResult::GetBrowserType()const{

	return this->browserType;
}

resultcode::ResultCode CCookieGetResult::GetResultCode()const{

	return this->resultCode;

}


CCookieGetResult::ExtendCode CCookieGetResult::GetExtendCode()const{

	return this->extendCode;
}



#include "namespace_end.h"