#include "stdafx.h"
#include "nexception.h"
#include "define.h"
#include "http.h"

#include "namespace_start.h"
CWinHttpClient::CWinHttpClient(){

	m_ptr.CreateInstance(WinHttp::CLSID_WinHttpRequest);

}

CHResult CWinHttpClient::Open(const NString &method,const NString &url,const _variant_t &async){

	CHResult result = m_ptr->Open(method.c_str(),url.c_str(),async);
	CHECK_HRESULT(result);
	
	return result;
}


CHResult CWinHttpClient::get_Response(IStream **ppStream){
	CComVariant var;
	CHResult result = m_ptr->get_ResponseStream(&var);
	

	if(result.IsSucceded()&& (VT_UNKNOWN == V_VT(&var) || VT_STREAM == V_VT(&var))){
		
		result = V_UNKNOWN(&var)->QueryInterface(IID_IStream,reinterpret_cast<Void**>(ppStream));


	}
	CHECK_HRESULT(result);

	return result;
}

CHResult CWinHttpClient::SetRequestHeader(const NString &headerName,const NString &headerBody){
	
	CHResult result = m_ptr->SetRequestHeader(headerName.c_str(),headerBody.c_str());
	CHECK_HRESULT(result);

	return result;
}

CHResult CWinHttpClient::SetRequestHeader(const cookie::CCookie &val){

	nstringstream ss;

	ss << val.GetName();
	ss << _T("=");
	ss << val.GetCookieValue();

	CHResult result = m_ptr->SetRequestHeader(_T("Cookie"),ss.str().c_str());

	CHECK_HRESULT(result);
	return result;
}

CHResult CWinHttpClient::Send(const _variant_t &value){

	CHResult result = m_ptr->Send(value);
	CHECK_HRESULT(result);
	return result;
}
#include "namespace_end.h"