
#include "stdafx.h"



#include "windowsAPI.h"



#include "namespace_start.h"

const static UInt BUFSIZE = 256;
typedef void (WINAPI *PGNSI)(LPSYSTEM_INFO);
typedef BOOL (WINAPI *PGPI)(DWORD, DWORD, DWORD, DWORD, PDWORD);




BOOL GetOSDisplayString( LPTSTR pszOS)
{

   OSVERSIONINFOEX osvi;
   SYSTEM_INFO si;
   PGNSI pGNSI;
   PGPI pGPI;
   BOOL bOsVersionInfoEx;
   DWORD dwType;

   ZeroMemory(&si, sizeof(SYSTEM_INFO));
   ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));

   osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
   bOsVersionInfoEx = GetVersionEx((OSVERSIONINFO*) &osvi);

   if(bOsVersionInfoEx == FALSE ) return false;

   // Call GetNativeSystemInfo if supported or GetSystemInfo otherwise.

   pGNSI = (PGNSI) GetProcAddress(
      GetModuleHandle(TEXT("kernel32.dll")), 
      "GetNativeSystemInfo");
   if(NULL != pGNSI)
      pGNSI(&si);
   else GetSystemInfo(&si);

   if ( VER_PLATFORM_WIN32_NT==osvi.dwPlatformId && 
        osvi.dwMajorVersion > 4 )
   {
      StringCchCopy(pszOS, BUFSIZE, TEXT("Microsoft "));

      // Test for the specific product.

      if ( osvi.dwMajorVersion == 6 )
      {
         if( osvi.dwMinorVersion == 0 )
         {
            if( osvi.wProductType == VER_NT_WORKSTATION )
                StringCchCat(pszOS, BUFSIZE, TEXT("Windows Vista "));
            else StringCchCat(pszOS, BUFSIZE, TEXT("Windows Server 2008 " ));
         }

         if ( osvi.dwMinorVersion == 1 )
         {
            if( osvi.wProductType == VER_NT_WORKSTATION )
                StringCchCat(pszOS, BUFSIZE, TEXT("Windows 7 "));
            else StringCchCat(pszOS, BUFSIZE, TEXT("Windows Server 2008 R2 " ));
         }
         
         pGPI = (PGPI) GetProcAddress(
            GetModuleHandle(TEXT("kernel32.dll")), 
            "GetProductInfo");

         pGPI( osvi.dwMajorVersion, osvi.dwMinorVersion, 0, 0, &dwType);

         switch( dwType )
         {
            case PRODUCT_ULTIMATE:
               StringCchCat(pszOS, BUFSIZE, TEXT("Ultimate Edition" ));
               break;
            case PRODUCT_PROFESSIONAL:
               StringCchCat(pszOS, BUFSIZE, TEXT("Professional" ));
               break;
            case PRODUCT_HOME_PREMIUM:
               StringCchCat(pszOS, BUFSIZE, TEXT("Home Premium Edition" ));
               break;
            case PRODUCT_HOME_BASIC:
               StringCchCat(pszOS, BUFSIZE, TEXT("Home Basic Edition" ));
               break;
            case PRODUCT_ENTERPRISE:
               StringCchCat(pszOS, BUFSIZE, TEXT("Enterprise Edition" ));
               break;
            case PRODUCT_BUSINESS:
               StringCchCat(pszOS, BUFSIZE, TEXT("Business Edition" ));
               break;
            case PRODUCT_STARTER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Starter Edition" ));
               break;
            case PRODUCT_CLUSTER_SERVER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Cluster Server Edition" ));
               break;
            case PRODUCT_DATACENTER_SERVER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Datacenter Edition" ));
               break;
            case PRODUCT_DATACENTER_SERVER_CORE:
               StringCchCat(pszOS, BUFSIZE, TEXT("Datacenter Edition (core installation)" ));
               break;
            case PRODUCT_ENTERPRISE_SERVER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Enterprise Edition" ));
               break;
            case PRODUCT_ENTERPRISE_SERVER_CORE:
               StringCchCat(pszOS, BUFSIZE, TEXT("Enterprise Edition (core installation)" ));
               break;
            case PRODUCT_ENTERPRISE_SERVER_IA64:
               StringCchCat(pszOS, BUFSIZE, TEXT("Enterprise Edition for Itanium-based Systems" ));
               break;
            case PRODUCT_SMALLBUSINESS_SERVER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Small Business Server" ));
               break;
            case PRODUCT_SMALLBUSINESS_SERVER_PREMIUM:
               StringCchCat(pszOS, BUFSIZE, TEXT("Small Business Server Premium Edition" ));
               break;
            case PRODUCT_STANDARD_SERVER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Standard Edition" ));
               break;
            case PRODUCT_STANDARD_SERVER_CORE:
               StringCchCat(pszOS, BUFSIZE, TEXT("Standard Edition (core installation)" ));
               break;
            case PRODUCT_WEB_SERVER:
               StringCchCat(pszOS, BUFSIZE, TEXT("Web Server Edition" ));
               break;
         }
      }

      if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 2 )
      {
         if( GetSystemMetrics(SM_SERVERR2) )
            StringCchCat(pszOS, BUFSIZE, TEXT( "Windows Server 2003 R2, "));
         else if ( osvi.wSuiteMask & VER_SUITE_STORAGE_SERVER )
            StringCchCat(pszOS, BUFSIZE, TEXT( "Windows Storage Server 2003"));
         else if ( osvi.wSuiteMask & VER_SUITE_WH_SERVER )
            StringCchCat(pszOS, BUFSIZE, TEXT( "Windows Home Server"));
         else if( osvi.wProductType == VER_NT_WORKSTATION &&
                  si.wProcessorArchitecture==PROCESSOR_ARCHITECTURE_AMD64)
         {
            StringCchCat(pszOS, BUFSIZE, TEXT( "Windows XP Professional x64 Edition"));
         }
         else StringCchCat(pszOS, BUFSIZE, TEXT("Windows Server 2003, "));

         // Test for the server type.
         if ( osvi.wProductType != VER_NT_WORKSTATION )
         {
            if ( si.wProcessorArchitecture==PROCESSOR_ARCHITECTURE_IA64 )
            {
                if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Datacenter Edition for Itanium-based Systems" ));
                else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Enterprise Edition for Itanium-based Systems" ));
            }

            else if ( si.wProcessorArchitecture==PROCESSOR_ARCHITECTURE_AMD64 )
            {
                if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Datacenter x64 Edition" ));
                else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Enterprise x64 Edition" ));
                else StringCchCat(pszOS, BUFSIZE, TEXT( "Standard x64 Edition" ));
            }

            else
            {
                if ( osvi.wSuiteMask & VER_SUITE_COMPUTE_SERVER )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Compute Cluster Edition" ));
                else if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Datacenter Edition" ));
                else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Enterprise Edition" ));
                else if ( osvi.wSuiteMask & VER_SUITE_BLADE )
                   StringCchCat(pszOS, BUFSIZE, TEXT( "Web Edition" ));
                else StringCchCat(pszOS, BUFSIZE, TEXT( "Standard Edition" ));
            }
         }
      }

      if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1 )
      {
         StringCchCat(pszOS, BUFSIZE, TEXT("Windows XP "));
         if( osvi.wSuiteMask & VER_SUITE_PERSONAL )
            StringCchCat(pszOS, BUFSIZE, TEXT( "Home Edition" ));
         else StringCchCat(pszOS, BUFSIZE, TEXT( "Professional" ));
      }

      if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0 )
      {
         StringCchCat(pszOS, BUFSIZE, TEXT("Windows 2000 "));

         if ( osvi.wProductType == VER_NT_WORKSTATION )
         {
            StringCchCat(pszOS, BUFSIZE, TEXT( "Professional" ));
         }
         else 
         {
            if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
               StringCchCat(pszOS, BUFSIZE, TEXT( "Datacenter Server" ));
            else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
               StringCchCat(pszOS, BUFSIZE, TEXT( "Advanced Server" ));
            else StringCchCat(pszOS, BUFSIZE, TEXT( "Server" ));
         }
      }

       // Include service pack (if any) and build number.

      if( _tcslen(osvi.szCSDVersion) > 0 )
      {
          StringCchCat(pszOS, BUFSIZE, TEXT(" ") );
          StringCchCat(pszOS, BUFSIZE, osvi.szCSDVersion);
      }

      TCHAR buf[80];

      StringCchPrintf( buf, 80, TEXT(" (build %d)"), osvi.dwBuildNumber);
      StringCchCat(pszOS, BUFSIZE, buf);

      if ( osvi.dwMajorVersion >= 6 )
      {
         if ( si.wProcessorArchitecture==PROCESSOR_ARCHITECTURE_AMD64 )
            StringCchCat(pszOS, BUFSIZE, TEXT( ", 64-bit" ));
         else if (si.wProcessorArchitecture==PROCESSOR_ARCHITECTURE_INTEL )
            StringCchCat(pszOS, BUFSIZE, TEXT(", 32-bit"));
      }
      
      return TRUE; 
   }

   else
   {  
     
      return FALSE;
   }
   
}

static const NChar* GetVersionStr(){

	static NChar versionString[256];
	GetOSDisplayString(versionString);
	return versionString;


}

const NString &GetWindowsVersion(){

	static NString versionString(GetVersionStr());
	return versionString;
}




//
//HRESULT ǗNX
///////////////////////////////////////////////////////////////////
CHResult::CHResult(){}

CHResult::CHResult(HRESULT hResult):m_hResult(hResult){}

HRESULT CHResult::operator=(HRESULT hResult){

	return m_hResult = hResult;

}

CHResult::operator HRESULT()const{

	return this->m_hResult;
}

Bool CHResult::IsS_OK()const{

	return m_hResult == S_OK;

}

Bool CHResult::IsSucceded()const{

	return SUCCEEDED(m_hResult);
}

Bool CHResult::IsFailed()const{

	return FAILED(m_hResult);
}


Bool operator==(const CHResult &result,HRESULT hResult){

	return result.m_hResult == hResult;

}

 Bool operator==(HRESULT hResult,const CHResult &result){

	return hResult == result.m_hResult;
}


 //
 //HKEYǗNX
 ///////////////////////////////////////////////////

 Void CRegistryKey::Dispose(){

	RegCloseKey( m_handle);
	m_handle = nullptr;
 }

 CHResult CRegistryKey::OpenKey(HKEY hkey,const NString &subKeystr,DWORD options,REGSAM samDesired){

	 return RegOpenKeyEx(hkey,subKeystr.c_str(),options,samDesired,&m_handle);
 }

 CHResult CRegistryKey::QueryValue(const NString &valueName,NString &val,LPDWORD lpType,LPDWORD lpReserved){

	 ValueList valList;
	CHResult hresult = QueryValue(valueName,valList);

	val = reinterpret_cast<const NChar*>(*valList.data());

	return hresult;


 }

CHResult CRegistryKey::QueryValue(const NString &valueName,Int &val,LPDWORD lpType,LPDWORD lpReserved){

	ValueList valList;
	CHResult hresult = QueryValue(valueName,valList);

	val = *reinterpret_cast<const Int*>(valList.data());

	return hresult;
}

 CHResult CRegistryKey::QueryValue(const NString &valueName,ValueList &valueList,LPDWORD lpType,LPDWORD lpReserved){

	 DWORD data;
	 RegQueryValueEx(m_handle,valueName.c_str(),lpReserved,lpType,nullptr,&data);


 
	 valueList.resize(data);
 
 
	 return  RegQueryValueEx(m_handle,valueName.c_str(),lpReserved,lpType,&valueList[0],&data);
 }

 CRegistryKey::operator HKEY(){

	 return m_handle;

 }


 Void CFindFirstFile::Dispose(){

	 FindClose(m_handle);
	 m_handle = nullptr;
 }

 Bool CFindFirstFile::NextFile(WIN32_FIND_DATA &findData){

	 return FindNextFile(m_handle,&findData) != FALSE;
 }

HANDLE CFindFirstFile::Find(const NString &fileName,WIN32_FIND_DATA &findData){

	if(m_handle == nullptr){

		m_handle = FindFirstFile(fileName.c_str(),&findData);
	}

	return m_handle;
}

Void GetWindowsErrorMessage(NString &buf,DWORD lastErrorCode){

	NChar *lpMsgBuf;
	NString rslt;
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL, lastErrorCode,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &lpMsgBuf,0,(va_list*)NULL);
	
	buf = lpMsgBuf != nullptr ? lpMsgBuf: _T("");
	LocalFree(lpMsgBuf);	

	return;
}


Bool NCopyFile(const NString &existingFileName, const NString &newFileName, Bool bFailIfExists){


	return ::CopyFile(existingFileName.c_str(),newFileName.c_str(),bFailIfExists) == FALSE ? false : true;
}


Bool NDeleteFile(const NString &fileName){

	return ::DeleteFile(fileName.c_str()) != FALSE;
}



static Bool GetFolderPath(Int dil,NString &dir){
	
	NChar buffer[_MAX_PATH];
	CHResult result = SHGetFolderPath(0,dil,0,SHGFP_TYPE_CURRENT,buffer);
	dir = buffer;
	return result.IsS_OK();

}

Bool GetAppLocalDataDirectry(NString &dir){
	
	return GetFolderPath(CSIDL_LOCAL_APPDATA,dir);

}
Bool GetAppDataDirectry(NString &dir){

	return GetFolderPath(CSIDL_APPDATA,dir);
}

Bool GetCookieDirectry(NString &dir){

	return GetFolderPath(CSIDL_COOKIES,dir);
}

Bool GetTempDirectry(NString &dir){

	return GetFolderPath(CSIDL_TEMPLATES,dir);
}









#include "namespace_end.h"
