#include "stdafx.h"
#include "CommandLineParser.h"

namespace FDK {
	namespace General {

CommandLineParser::CommandLineParser()
{
	this->pFirstItem = this->pLastItem = NULL;
	this->nACe = 0;
}
void CommandLineParser::Init()
{
	this->Term();
}
void CommandLineParser::Init( LPCTSTR str͂R}hC )
{
	LPCTSTR p = str͂R}hC;
	while( *p != _T('\0') )
	{
		CmdLineItem *pi;

		SKIPSP( p );

		// (1) IvV̏ꍇ
		if( *p == _T('-') )
		{
			pi = new CmdLineItem();
			
			TCHAR buf[ _MAX_PATH ];

			int i = 0;
			while( i < _MAX_PATH - 1 && *p != _T(' ') && *p != _T('\t') && *p != _T('\0') )
				buf[i++] = *p++;
			buf[i] = _T('\0');
		
			pi->strItem = buf;
		}

		// (2) _uNH[gꂽ̏ꍇ
		else if( *p == _T('\"') )
		{
			pi = new CmdLineItem();

			TCHAR buf[ _MAX_PATH ];
			p++;
			int i = 0;
			while( i < _MAX_PATH - 1 && *p != _T('\0') && *p != _T('\"') )
				buf[i++] = *p++;
			buf[i] = _T('\0');

			pi->strItem = buf;

			if( *p == _T('\"') )
				p++;
		}

		// (3) ̑̏ꍇ
		else
		{
			pi = new CmdLineItem();
			
			TCHAR buf[ _MAX_PATH ];
			int i = 0;
			while( i < _MAX_PATH - 1 && *p != _T('\0') && *p != _T(' ') && *p != _T('\t') && *p != _T('-') )
				buf[i++] = *p++;
			buf[i] = _T('\0');
			
			pi->strItem = buf;
		}

		// (1)`(3) ̂̏ꍇłXgɐڑ
		pi->prev = pi->next = NULL;
		APPENDLIST( this->pFirstItem, this->pLastItem, pi );
		this->nACe++;
	}
}
int  CommandLineParser::GetItemNum()
{
	return this->nACe;
}
LPCTSTR CommandLineParser::Get( int index )
{
	if( index < 0 || index >= this->nACe )
		return NULL;

	CmdLineItem* pc = this->pFirstItem;
	while( pc != NULL && index > 0 ) {
		pc = pc->next;
		index --;
	}
	return pc->strItem.c_str();
}
void CommandLineParser::Term()
{
	CmdLineItem *pi = this->pFirstItem;
	while( pi != NULL )
	{
		CmdLineItem* next = pi->next;
		SAFE_DELETE( pi );
		pi = next;
	}
	this->pFirstItem = this->pLastItem = NULL;
	this->nACe = 0;
}

	}//General
}//FDK