#include "stdafx.h"
#include "ActPlayAVI.h"
#include "CSurface.h"
#include "DTX.h"
#include "CStage.h"
#include "DTXViewer.h"

namespace DTXViewer {
	namespace Stage {
		namespace Play {

ActPlayAVI::ActPlayAVI()
{
	this->bFirstWork = true;
	this->bActivate = false;
}

bool ActPlayAVI::MyOneTimeSceneInit()
{
	// ɃR[hLqBAddChild() ȂǁB
	AddChild( &this->sfAVI );

	return Activity::MyOneTimeSceneInit();
}
bool ActPlayAVI::MyFinalCleanup()
{
	// ɃR[hLqB

	return Activity::MyFinalCleanup();
}
bool ActPlayAVI::MyInitDeviceObjects()
{
	// ɃR[hLqBCTexture/CSurface::InitDeviceObjects() ȂǁB
	this->sfAVI.InitDeviceObjects( _T("AVI"), BGA_W, BGA_H );

	return Activity::MyInitDeviceObjects();
}
bool ActPlayAVI::MyDeleteDeviceObjects()
{
	// ɃR[hLqB

	//  Activity::MyDeleteDeviceObjects() ł́AqeNX`EqT[tFCX Delete (CTexture/CSurface::Delete) sB
	return Activity::MyDeleteDeviceObjects();
}
bool ActPlayAVI::MyActivate()
{
	this->bFirstWork = true;
	// ɃR[hLqB
	for( int i = 0; i < MAX_AVI_LAYER; i++ )
	{
		this->structLayer[i].pAVI						= NULL;
		this->structLayer[i].dbړJnms			=INIT_TIME;
		this->structLayer[i].dwO\t[ԍ	= 0;
	}

	//  Activity::MyActivate() ł́Athis->bActivity ̃ZbgȂтɎqT[tFCXEqeNX` Restore (MyRestoreDeviceTexture/Surface) sB
	// ȂAq Activity ͍̊sȂBĩ\bh𔲂ĂsBj
	return Activity::MyActivate();
}
bool ActPlayAVI::MyUnActivate()
{
	// ɃR[hLqB

	//  Activity::MyUnActivate() ł́Athis->bActivity ̃ZbgȂтɎqT[tFCXEqeNX` Invalidate (MyInvalidateDeviceObjects) sB
	// ȂAqActivity ̔񊈐͍sȂBĩ\bh𔲂ĂsBj
	return Activity::MyUnActivate();
}
bool ActPlayAVI::MyRestoreDeviceTextures()
{
	// ɃR[hLqB

	//  Activity::MyRestoreDeviceTextures() ł́AqeNX` Restore (CTexture::Restore) sB
	return Activity::MyRestoreDeviceTextures();
}
bool ActPlayAVI::MyRestoreDeviceSurfaces()
{
	// ɃR[hLqB

	//  Activity::MyRestoreDeviceSurfaces() ł́AqT[tFCX Restore (CSurface::Restore) sB
	return Activity::MyRestoreDeviceSurfaces();
}
bool ActPlayAVI::MyInvalidateDeviceObjects()
{
	// ɃR[hLqB

	//  Activity::MyInvalidateDeviceObjects() ł́AqeNX`EqT[tFCX Invalidate (CTexture/CSurface::Invalidate) sB
	return Activity::MyRestoreDeviceSurfaces();
}
//
void ActPlayAVI::Start( int n`lԍ, DTX::AVI* pAVI, int nJnTCYW, int nJnTCYH, int nITCYW, int nITCYH, int n摜JnʒuX, int n摜JnʒuY, int n摜IʒuX, int n摜IʒuY, int n\JnʒuX, int n\JnʒuY, int n\IʒuX, int n\IʒuY, double dbړms, double dbړJnms )
{
	// `l`FbN
	if( n`lԍ != 0x54 )
		return;

	// Zɒlݒ
	int i = 0;
	this->structLayer[i].pAVI	= pAVI;
	this->structLayer[i].nJnTCYW	= nJnTCYW;
	this->structLayer[i].nJnTCYH	= nJnTCYH;
	this->structLayer[i].n摜JnʒuX	= n摜JnʒuX;
	this->structLayer[i].n摜JnʒuY	= n摜JnʒuY;
	this->structLayer[i].n\JnʒuX	= n\JnʒuX;
	this->structLayer[i].n\JnʒuY	= n\JnʒuY;
	this->structLayer[i].dbړms		= dbړms;
	this->structLayer[i].dbړJnms	= ( dbړJnms != INIT_TIME ) ? dbړJnms : g_Timer.Get();
	this->structLayer[i].dwO\t[ԍ = 0;
}
void ActPlayAVI::SkipStart( double dbړJnms )
{
	for( DTX::Chip* cell = g_DTX.pChip; cell != NULL; cell = cell->next )
	{
		// JnȂÃ`bvŒł؂B
		if( cell->dbTime > dbړJnms ) 
			break;

		// AVI, AVIPAN ȂĐw
		switch( cell->AVItype )
		{

		case AVITYPE_AVI:
			if( cell->pAVI )
				this->Start(
					cell->nChannel, cell->pAVI,
					BGA_W, BGA_H, 0, 0,			// sw, sh, ew, eh		; ̈   TCYAITCY
					0, 0, 0, 0,					// ssx, ssy, sex, sey	; 摜 ʒuAŏIʒu
					0, 0, 0, 0,					// dsx, dsy, dex, dey	; \ ʒuAŏIʒu
					0, cell->dbTime );			// len, start
			break;

		case AVITYPE_AVIPAN:
			if( cell->pAVIPan )
				this->Start(
					cell->nChannel, cell->pAVI,
					cell->pAVIPan->sw, cell->pAVIPan->sh, cell->pAVIPan->ew, cell->pAVIPan->eh,		// ̈   TCYAITCY
					cell->pAVIPan->ssx, cell->pAVIPan->ssy, cell->pAVIPan->sex, cell->pAVIPan->sey,	// 摜 ʒuAŏIʒu
					cell->pAVIPan->dsx, cell->pAVIPan->dsy, cell->pAVIPan->dex, cell->pAVIPan->dey,	// \ ʒuAŏIʒu
					cell->dbLong, cell->dbTime );													// len, start
			break;
		}
	}
}
void ActPlayAVI::Stop()
{
	for( int i = 0; i < MAX_AVI_LAYER; i++ ) {
		if( this->structLayer[i].pAVI && this->structLayer[i].pAVI->bUse )
			this->structLayer[i].dbړJnms = INIT_TIME;
	}
}
void ActPlayAVI::Cont( double dbĊJ )
{
	for( int i = 0; i < MAX_AVI_LAYER; i++ ) {
		if( this->structLayer[i].pAVI && this->structLayer[i].pAVI->bUse )
			this->structLayer[i].dbړJnms = dbĊJ;
	}
}
int  ActPlayAVI::MainWork( int x, int y )
{
	// AVI wȂȂ牽Ȃ
	if( ! g_DTX.bUseAVI )
		return 0;

	// is`
	for( int i = 0; i < MAX_AVI_LAYER; i++ )
	{
		// gpȂXLbv
		if( this->structLayer[i].dbړJnms == INIT_TIME )
			continue;
		if( ! this->structLayer[i].pAVI || ! this->structLayer[i].pAVI->bUse )
			continue;

		// p[^oEZo
		DTX::AVI*	 pAVI		= this->structLayer[i].pAVI;
		SIZE szAVITCY;		pAVI->avi._t[TCY擾( &(szAVITCY.cx), &(szAVITCY.cy) );
		SIZE szBGATCY		= { BGA_W, BGA_H };
		SIZE szJnTCY		= { this->structLayer[i].nJnTCYW, this->structLayer[i].nJnTCYH };
		SIZE szITCY		= { this->structLayer[i].nITCYW, this->structLayer[i].nITCYH };
		POINT pt摜Jnʒu	= { this->structLayer[i].n摜JnʒuX, this->structLayer[i].n摜IʒuY };
		POINT pt摜Iʒu	= { this->structLayer[i].n摜IʒuX, this->structLayer[i].n摜IʒuY };
		POINT pt\Jnʒu	= { this->structLayer[i].n\JnʒuX, this->structLayer[i].n\JnʒuY };
		POINT pt\Iʒu	= { this->structLayer[i].n\IʒuX, this->structLayer[i].n\IʒuY };
		double dbړms	= this->structLayer[i].dbړms;
		double dbړJnms	= this->structLayer[i].dbړJnms; if( g_Timer.Get() < dbړJnms ) dbړJnms = g_Timer.Get();

		double dbݎms		= ( g_Timer.Get() - dbړJnms ) * g_DTX.fSpeed;	// Jňoߎ[ms]
		DWORD  dwt[ԍ	= pAVI->avi._t[ԍԂ( dbݎms );

		// Iidbړms==0 ̂ƂAVIĐI܂Łj
		if( dbړms != 0.0 && dbړms < dbݎms )
		{
			this->structLayer[i].dbړms   = 0;
			this->structLayer[i].dbړJnms = INIT_TIME;	// ĐI
			return 0;
		}

		// ݍW̌vZGȉ̂QϐZoB
		RECT rc摜̈;		// 摜̍オ 0, 0
		RECT rc\̈;		// BGÄ̍オ 0, 0

		if( dbړms == 0.0 )
		{
			// ʒuETCYƕێ
			SetRect( &rc摜̈,
				pt摜Jnʒu.x,
				pt摜Jnʒu.y,
				pt摜Jnʒu.x + szJnTCY.cx,
				pt摜Jnʒu.y + szJnTCY.cy );
			
			SetRect( &rc\̈,
				pt\Jnʒu.x,
				pt\Jnʒu.y,
				pt\Jnʒu.x + szJnTCY.cx,
				pt\Jnʒu.y + szJnTCY.cy );
		}
		else
		{
			// db; JnI ̂Ƃ 0.0  1.0
			double db = dbݎms / dbړms;

			// ݂̃TCYi摜E\ʁj
			SIZE sz݂̃TCY = {
				szJnTCY.cx + (LONG)( ( szITCY.cx - szJnTCY.cx ) * db ),
				szJnTCY.cy + (LONG)( ( szITCY.cy - szJnTCY.cy ) * db )
			};

			// ]̈
			SetRect( &rc摜̈,
				(LONG)( ( pt摜Iʒu.x - pt摜Jnʒu.x ) * db ),
				(LONG)( ( pt摜Iʒu.y - pt摜Jnʒu.y ) * db ),
				(LONG)( ( pt摜Iʒu.x - pt摜Jnʒu.x ) * db ) + sz݂̃TCY.cx,
				(LONG)( ( pt摜Iʒu.y - pt摜Jnʒu.y ) * db ) + sz݂̃TCY.cy );

			// ]̈
			SetRect( &rc\̈,
				(LONG)( ( pt\Iʒu.x - pt\Jnʒu.x ) * db ),
				(LONG)( ( pt\Iʒu.y - pt\Jnʒu.y ) * db ),
				(LONG)( ( pt\Iʒu.x - pt\Jnʒu.x ) * db ) + sz݂̃TCY.cx,
				(LONG)( ( pt\Iʒu.y - pt\Jnʒu.y ) * db ) + sz݂̃TCY.cy );

			// ]ȂȂXLbv@ NbsOO
			if( rc摜̈.right <= 0 || rc摜̈.bottom <= 0 || rc摜̈.left >= szAVITCY.cx || rc摜̈.top >= szAVITCY.cy ) continue;
			if( rc\̈.right <= 0 || rc\̈.bottom <= 0 || rc\̈.left >= szBGATCY.cx || rc\̈.top >= szBGATCY.cy ) continue;

			// NbsO@ ]
			if( rc摜̈.left < 0 )	{ rc\̈.left += -rc摜̈.left; rc摜̈.left = 0; }
			if( rc摜̈.top  < 0 )	{ rc\̈.top  += -rc摜̈.top;  rc摜̈.top  = 0; }
			if( rc摜̈.right  > szAVITCY.cx ) { rc\̈.right  -= rc摜̈.right  - szAVITCY.cx; rc摜̈.right  = szAVITCY.cx; }
			if( rc摜̈.bottom > szAVITCY.cy ) { rc\̈.bottom -= rc摜̈.bottom - szAVITCY.cy; rc摜̈.bottom = szAVITCY.cy; }

			// NbsOA ]
			if( rc\̈.left < 0 ) { rc摜̈.left += -rc\̈.left; rc\̈.left = 0; }
			if( rc\̈.top  < 0 ) { rc摜̈.top  += -rc\̈.top;  rc\̈.top  = 0; }
			if( rc\̈.right  > szBGATCY.cx ) { rc摜̈.right  -= rc\̈.right  - szBGATCY.cx; rc\̈.right  = szBGATCY.cx; }
			if( rc\̈.bottom > szBGATCY.cy ) { rc摜̈.bottom -= rc\̈.bottom - szBGATCY.cy; rc\̈.bottom = szBGATCY.cy; }

			// ]ȂȂXLbvA NbsO
			if( rc摜̈.left >= rc摜̈.right || rc摜̈.top >= rc摜̈.bottom ) continue;
			if( rc\̈.left >= rc\̈.right || rc\̈.top >= rc\̈.bottom ) continue;
			if( rc摜̈.right < 0 || rc摜̈.bottom < 0 || rc摜̈.left > szAVITCY.cx || rc摜̈.top > szAVITCY.cy ) continue;
			if( rc\̈.right < 0 || rc\̈.bottom < 0 || rc\̈.left > szBGATCY.cx || rc\̈.top > szBGATCY.cy ) continue;
		}
	
		// `
		this->structLayer[i].dwO\t[ԍ = dwt[ԍ;

		HDC hdc;
		int ret = 0;
		
		this->sfAVI.Clear();
		
		if( SUCCEEDED( this->sfAVI.GetDC( &hdc ) ) )
		{
			ret = pAVI->avi._w莞̃t[DC֕`悷( g_App.hWnd, hdc, dbݎms, 
				rc摜̈.left, rc摜̈.top, rc摜̈.right - rc摜̈.left, rc摜̈.bottom - rc摜̈.top,
				rc\̈.left, rc\̈.top, rc\̈.right - rc\̈.left, rc\̈.bottom - rc\̈.top );
			this->sfAVI.ReleaseDC( hdc );
			this->sfAVI.Draw( x, y );
		}
		if( ret != 0 )
		{
			// Đ
			this->structLayer[i].dbړJnms = INIT_TIME;
		}
	}
	return 0;
}

		}//Play
	}//Stage
}//DTXViewer
