!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
MODULE sctk_gapeq_rhs
  !
  IMPLICIT NONE
  !
CONTAINS
!
! Make Effective interaction
!
SUBROUTINE make_effint()
  !
  USE kinds, ONLY : DP
  USE constants, ONLY : pi
  USE mp_world, ONLY : world_comm
  USE modes, ONLY : nmodes
  USE el_phon, ONLY : elph_nbnd_min, elph_nbnd_max
  USE sctk_val, ONLY : beta, bindx, effint, gg, kindx, mf, ncf, ngap1, ngap2, nmf, omg, Vc, wmf, xi
  !
  USE sctk_kernel_weight, ONLY : Kweight, calc_Kel
  USE sctk_gauss_legendre, ONLY : weightspoints_gl
  !
  IMPLICIT NONE
  !
  INTEGER :: igap, ik, ib, jgap, jk, jb, im, ngap10, ngap11
  REAL(dp) :: x, xp, om, Kph, Kel, bx, bxp, tx, txp, tom
  !
  CALL divide(world_comm, ngap1, ngap10, ngap11)
  ALLOCATE(effint(ngap2,ngap10:ngap11))
  !
  ! Set Matsubara sum
  !
  ALLOCATE(mf(nmf), wmf(nmf))
  !
  CALL weightspoints_gl(nmf,mf,wmf)
  !
  wmf(1:nmf) = 2.0_dp / (pi * (mf(1:nmf)**2 + 1.0_dp)) * wmf(1:nmf)
  mf(1:nmf) = (1.0_dp + mf(1:nmf)) / (1.0_dp - mf(1:nmf))
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(ngap10,ngap11, ngap1, ngap2, nmodes, ncf, kindx, bindx, beta, &
  !$OMP &        xi, omg, gg, Vc, effint, elph_nbnd_min, elph_nbnd_max) &
  !$OMP & PRIVATE(igap, jgap, ik, jk, ib, jb, im, x, xp, om, Kph, Kel, &
  !$OMP &         bx, bxp, tx, txp, tom)
  !
  !$OMP DO
  DO igap = ngap10, ngap11
     !
     x = xi(igap,1)
     bx = 0.5_dp * beta * x
     tx = tanh(bx)
     ik = kindx(igap,1)
     ib = bindx(igap,1)
     !
     DO jgap = 1, ngap2
        !
        xp = xi(jgap,2)
        bxp = 0.5_dp * beta * xp
        txp = tanh(bxp)
        jk = kindx(jgap,2)
        jb = bindx(jgap,2)
        !
        Kph = 0.0_dp
        !
        IF(all((/elph_nbnd_min <= ib, ib <= elph_nbnd_max, elph_nbnd_min <= jb, jb <= elph_nbnd_max/))) THEN
           !
           DO im = 1, nmodes
              !
              om = omg(im,jk,ik) * beta * 0.5_dp
              tom = tanh(om)
              !
              Kph = Kph + gg(im,jb,jk,ib,ik) * beta &
              &         * Kweight(bx, bxp, om, tx, txp, tom)
              !       
           END DO ! im
           Kph = Kph * 2.0_dp
           !
        END IF
        !
        Kel = calc_Kel(x,xp,Vc(1:ncf,jb,jk,ib,ik))
        !
        effint(jgap,igap) = Kph + Kel
        !
     END DO ! jgap
     !
  END DO ! igap
  !$OMP END DO
  !$OMP END PARALLEL
  !
  DEALLOCATE(gg, vc, omg)
  !
END SUBROUTINE make_effint
!
! Make RHS vector for linear probrem.
!
SUBROUTINE gapeq_rhs(veco)
  !
  USE kinds, ONLY : DP
  USE io_global, ONLY : stdout
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_sum
  USE sctk_val, ONLY : beta, delta, dk, effint, &
  &                     ngap, ngap1, ngap2, xi, xic, Z
  !
  !
  IMPLICIT NONE
  !
  REAL(dp),INTENT(OUT) :: veco(ngap,2)
  !
  INTEGER :: igap, ngap10, ngap11, nh
  REAL(dp) :: chi(ngap,2), dosh, Kh, dlth, xmax
  !
  CALL divide(world_comm, ngap1, ngap10, ngap11)
  !
  veco(1:ngap,1:2) = 0.0_dp
  chi(1:ngap,1:2) = 0.0_dp
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(ngap1, ngap2,ngap10,ngap11, beta, xi, delta, veco, effint, chi, dk) &
  !$OMP & PRIVATE(igap)
  !
  !$OMP DO
  DO igap =1, ngap1
     chi(igap,1) = 0.5_dp * dk(igap,1) * delta(igap,1) &
     &         * tanh(0.5_dp * beta * SQRT(xi(igap,1)**2 + delta(igap,1)**2)) &
     &         / SQRT(xi(igap,1)**2 + delta(igap,1)**2)
  END DO
  !$OMP END DO
  !
  !$OMP DO
  DO igap = 1, ngap2
     chi(igap,2) = 0.5_dp * dk(igap,2) * delta(igap,2) &
     &         * tanh(0.5_dp * beta * SQRT(xi(igap,2)**2 + delta(igap,2)**2)) &
     &         / SQRT(xi(igap,2)**2 + delta(igap,2)**2)
  END DO
  !$OMP END DO
  !$OMP END PARALLEL
  !
  CALL dgemv("T", ngap2, ngap11-ngap10+1, 1.0_dp, effint(1:ngap2,ngap10:ngap11), ngap2, &
  &    chi(1:ngap2,2), 1, 1.0_dp, veco(ngap10:ngap11,1), 1)
  !
  CALL dgemv("N", ngap2, ngap11-ngap10+1, 1.0_dp, effint(1:ngap2,ngap10:ngap11), ngap2, &
  &    chi(ngap10:ngap11,1), 1, 1.0_dp, veco(1:ngap2,2), 1)
  !
  ! High energy region
  !
  IF(xic > 0) THEN
     !
     ! 1, 
     !
     nh = count(xi(1:ngap1,1) > xic)
     dlth = SUM(delta(1:ngap1,1) / xi(1:ngap1,1), xi(1:ngap1,1) > xic) &
     &    / SUM(1.0_dp / xi(1:ngap1,1)**2,         xi(1:ngap1,1) > xic)
     !
     xmax = MAXVAL(xi(1:ngap1,1))
     dosh = SUM(dk(1:ngap1,1), xi(1:ngap1,1) > xic) / (xmax - xic)
     !
     WRITE(stdout,*) "    Extrapol 1 : ", dlth / xic * 13.6d3
     !
     !$OMP PARALLEL DEFAULT(NONE) &
     !$OMP & SHARED(veco,ngap2,effint,ngap10,ngap11,xi,xic,xmax,nh,dosh,dlth) &
     !$OMP & PRIVATE(igap,Kh)
     !$OMP DO
     DO igap = 1, ngap2
        Kh = SUM(effint(igap,ngap10:ngap11), xi(ngap10:ngap11,1) > xic) / REAL(nh, dp)
        veco(igap,2) = veco(igap,2) + 0.5_dp * dosh * Kh * dlth / xmax
     END DO
     !$OMP END DO
     !$OMP END PARALLEL
     !
     ! 2, 
     !
     nh = count(xi(1:ngap2,2) > xic)
     dlth = SUM(delta(1:ngap2,2) / xi(1:ngap2,2), xi(1:ngap2,2) > xic) &
     &    / SUM(1.0_dp / xi(1:ngap2,2)**2,         xi(1:ngap2,2) > xic)
     !
     xmax = MAXVAL(xi(1:ngap2,2))
     dosh = SUM(dk(1:ngap2,2), xi(1:ngap2,2) > xic) / (xmax - xic)
     !
     WRITE(stdout,*) "    Extrapol 2 : ", dlth / xic * 13.6d3
     !
     !$OMP PARALLEL DEFAULT(NONE) &
     !$OMP & SHARED(veco,ngap2,effint,ngap10,ngap11,xi,xic,xmax,nh,dosh,dlth) &
     !$OMP & PRIVATE(igap,Kh)
     !$OMP DO
     DO igap = ngap10, ngap11
        Kh = SUM(effint(1:ngap2,igap), xi(1:ngap2,2) > xic) / REAL(nh, dp)
        veco(igap,2) = veco(igap,2) + 0.5_dp * dosh * Kh * dlth / xmax
     END DO
     !$OMP END DO
     !$OMP END PARALLEL
     !
  END IF ! (xic > 0)
  !
  CALL mp_sum( veco, world_comm )
  !
  veco(1:ngap,1:2) = delta(1:ngap,1:2) + veco(1:ngap,1:2) / (1.0_dp + Z(1:ngap,1:2)) 
  !
END SUBROUTINE gapeq_rhs
!
! Make Kel, Kph & a part of Jacobian
!
SUBROUTINE gapeq_rhs_qpdos()
  !
  USE kinds, ONLY : DP
  USE constants, ONLY : pi
  USE io_global, ONLY : stdout
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_sum
  USE modes, ONLY : nmodes
  USE klist, ONLY : nks
  USE fermisurfer_common,   ONLY : b_low, b_high
  USE el_phon, ONLY : elph_nbnd_min, elph_nbnd_max
  USE sctk_val, ONLY : beta, bindx, delta, dk, dltF, ggf, kindx, &
  &                     mf, ncf, ngap2, nmf, nx, &
  &                     omgf, Vcf, wmf, xi, xi0, xic, ZF
  !
  USE sctk_kernel_weight, ONLY : Kweight, calc_Kel
  USE sctk_gauss_legendre, ONLY : weightspoints_gl
  !
  IMPLICIT NONE
  !
  INTEGER :: ik, ib, jgap, jk, jb, im, ix, nh, nks0, nks1
  REAL(dp) :: x, xp, om, bx, bxp, tx, txp, tom, eqp, Kph, Kel, Kave, dlth, dosh, xmax
  !
  ALLOCATE(dltF(nx,b_low:b_high,nks))
  dltF(1:nx,b_low:b_high,1:nks) = 0.0_dp
  !
  ! Set Matsubara sum
  !
  ALLOCATE(mf(nmf), wmf(nmf))
  !
  CALL weightspoints_gl(nmf,mf,wmf)
  !
  wmf(1:nmf) = 2.0_dp / (pi * (mf(1:nmf)**2 + 1.0_dp)) * wmf(1:nmf)
  mf(1:nmf) = (1.0_dp + mf(1:nmf)) / (1.0_dp - mf(1:nmf))
  !
  ! Extrapolation of high energy region
  !
  nh = count(xi(1:ngap2,2) > xic)
  dlth = SUM(delta(1:ngap2,2) / xi(1:ngap2,2), xi(1:ngap2,2) > xic) &
  &    / SUM(1.0_dp / xi(1:ngap2,2)**2,      xi(1:ngap2,2) > xic)
  !
  xmax = MAXVAL(xi(1:ngap2,2))
  dosh = SUM(dk(1:ngap2,2), xi(1:ngap2,2) > xic) / (xmax - xic)
  !
  WRITE(stdout,*) nh, dlth, xmax, dosh
  !
  CALL divide(world_comm, nks,nks0, nks1)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(xi0, nx,nks0,nks1, ngap2, b_low,b_high, nmodes, ncf, omgf, ggf, Vcf, &
  !$OMP &        xi, dk, delta, kindx, bindx, dltF, ZF, beta, elph_nbnd_min, elph_nbnd_max, &
  !$OMP &        nh, dlth, dosh, xic, xmax) &
  !$OMP & PRIVATE(ik, ib, jgap, jk, jb, im, ix, &
  !$OMP &         x, xp, om, bx, bxp, tx, txp, tom, eqp, Kph, Kel, Kave)
  !
  !$OMP DO
  DO ik = nks0, nks1
     !
     DO ib = b_low, b_high
        !
        DO ix = 1, nx 
           !
           Kave = 0.0_dp
           x = ABS(xi0(ix))
           bx = ABS(0.5_dp * beta * x)
           tx = tanh(bx)
           !
           DO jgap = 1, ngap2
              !
              xp = ABS(xi(jgap,2))
              bxp = ABS(0.5_dp * beta * xp)
              txp = tanh(bxp)
              jk = kindx(jgap,2)
              jb = bindx(jgap,2)
              !
              Kph = 0.0_dp
              !
              IF(elph_nbnd_min <= jb .AND. jb <= elph_nbnd_max) THEN
                 !
                 DO im = 1, nmodes
                    !
                    om = ABS(omgf(im,jk,ik) * 0.5_dp * beta)
                    tom = tanh(om)
                    !
                    Kph = Kph + ggf(im,jb,jk,ib,ik) &
                    &   * beta * Kweight(bx, bxp, om, tx, txp, tom)
                    !
                 END DO ! im
                 !               
                 Kph = Kph * 2.0_dp
                 !
              END IF ! (elph_nbnd_min <= jb .AND. jb <= elph_nbnd_max)
              !
              Kel = calc_Kel(x,xp,Vcf(1:ncf,jb,jk,ib,ik))
              !
              eqp = SQRT(delta(jgap,2)**2 + xp**2)
              !
              dltF(ix,ib,ik) = dltF(ix,ib,ik) &
              &                 - 0.5_dp * dk(jgap,2) * (Kph + Kel) / (1.0_dp + ZF(ix,ib,ik)) &
              &                   * delta(jgap,2) / eqp * tanh(0.5_dp * beta * eqp)
              !
              IF(xi(jgap,2) > xic) Kave = Kave + (Kph + Kel)
              !
           END DO ! jgap
           !
           IF(xic > 0) THEN
              !
              Kave = Kave / REAL(nh, dp)
              dltF(ix,ib,ik) = dltF(ix,ib,ik) - 0.5_dp * Kave / (1.0_dp + ZF(ix,ib,ik)) &
              &                          * dosh * dlth / xmax
              !
           END IF ! (xic > 0)
           !
           dltF(ix,ib,ik) = SQRT(xi0(ix)**2 + dltF(ix,ib,ik)**2)
           !
        END DO ! ix
        !
     END DO ! ib
     !
  END DO ! ik
  !$OMP END DO
  !
  !$OMP END PARALLEL
  ! 
  CALL mp_sum( dltF, world_comm )
  !
  DEALLOCATE(ggf, Vcf, omgf)
  !
END SUBROUTINE gapeq_rhs_qpdos
!
! Make Kel, Kph & a part of Jacobian
!
SUBROUTINE gapeq_rhs_f()
  !
  USE kinds, ONLY : DP
  USE constants, ONLY : pi
  USE io_global, ONLY : stdout
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_sum
  USE modes, ONLY : nmodes
  USE klist, ONLY : nks
  USE fermisurfer_common,   ONLY : b_low, b_high
  USE el_phon, ONLY : elph_nbnd_min, elph_nbnd_max
  USE sctk_val, ONLY : beta, bindx, delta, dk, dltf, ggf, kindx, &
  &                     mf, ncf, ngap2, nmf, omgf, &
  &                     vcf, wmf, xi, xic, Zf
  !
  USE sctk_kernel_weight, ONLY : Kweight_f, calc_Kel_f
  USE sctk_gauss_legendre, ONLY : weightspoints_gl
  !
  IMPLICIT NONE
  !
  INTEGER :: ik, ib, jgap, jk, jb, im, nh, nks0, nks1
  REAL(dp) :: xp, om, eqp, Kph, Kel, Kave, dlth, dosh, xmax, bxp, txp, tom
  !
  ALLOCATE(dltf(1,b_low:b_high,nks))
  dltf(1,b_low:b_high,1:nks) = 0.0_dp
  !
  ! Set Matsubara sum
  !
  ALLOCATE(mf(nmf), wmf(nmf))
  !
  CALL weightspoints_gl(nmf,mf,wmf)
  !
  wmf(1:nmf) = 2.0_dp / (pi * (mf(1:nmf)**2 + 1.0_dp)) * wmf(1:nmf)
  mf(1:nmf) = (1.0_dp + mf(1:nmf)) / (1.0_dp - mf(1:nmf))
  !
  ! Extrapolation of high energy region
  !
  nh = count(xi(1:ngap2,2) > xic)
  dlth = SUM(delta(1:ngap2,2) / xi(1:ngap2,2), xi(1:ngap2,2) > xic) &
  &    / SUM(1.0_dp / xi(1:ngap2,2)**2,        xi(1:ngap2,2) > xic)
  !
  xmax = MAXVAL(xi(1:ngap2,2))
  dosh = SUM(dk(1:ngap2,2), xi(1:ngap2,2) > xic) / (xmax - xic)
  !
  WRITE(stdout,*) dlth / xic * 13.6d3
  !
  CALL divide(world_comm, nks,nks0,nks1)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(nks0,nks1,ngap2,b_low,b_high, nmodes, ncf, omgf, ggf, vcf, &
  !$OMP &        xi, dk, delta, kindx, bindx, dltf, Zf, beta, elph_nbnd_min, elph_nbnd_max, &
  !$OMP &        nh, dlth, dosh, xic, xmax) &
  !$OMP & PRIVATE(ik, ib, jgap, jk, jb, im, bxp, txp, tom, &
  !$OMP &         xp, om, eqp, Kph, Kel, Kave)
  !
  !$OMP DO
  DO ik = nks0, nks1
     !
     DO ib = b_low, b_high
        !
        Kave = 0.0_dp
        !
        DO jgap = 1, ngap2
           !
           xp = ABS(xi(jgap,2))
           jk = kindx(jgap,2)
           jb = bindx(jgap,2)
           bxp = 0.5_dp * beta * xp
           txp = tanh(bxp)
           !
           Kph = 0.0_dp
           !
           IF(elph_nbnd_min <= jb .AND. jb <= elph_nbnd_max) THEN
              !
              DO im = 1, nmodes
                 !
                 om = ABS(0.5_dp * beta * omgf(im,jk,ik))
                 tom = tanh(om)
                 !
                 Kph = Kph + ggf(im,jb,jk,ib,ik) &
                 &   * beta * Kweight_f(bxp, om, txp, tom)
                 !
              END DO ! im
              Kph = Kph * 2.0_dp
              !
           END IF
           !
           Kel = calc_Kel_f(xp,Vcf(1:ncf,jb,jk,ib,ik))
           !
           eqp = SQRT(delta(jgap,2)**2 + xp**2)
           !
           dltf(1,ib,ik) = dltf(1,ib,ik) &
           &                 - 0.5_dp * dk(jgap,2) * (Kph + Kel) / (1.0_dp + Zf(1,ib,ik)) &
           &                   * delta(jgap,2) / eqp * tanh(0.5_dp * beta * eqp)
           !
           IF(xi(jgap,2) > xic) Kave = Kave + (Kph + Kel)
           !
        END DO ! jgap
        !
        IF(xic > 0) THEN
           !
           Kave = Kave / REAL(nh, dp)
           !
           dltf(1,ib,ik) = dltf(1,ib,ik) - 0.5_dp * Kave / (1.0_dp + Zf(1,ib,ik)) &
           &                          * dosh * dlth / xmax
           !
        END IF ! (xic > 0)
        !
     END DO ! ib
     !
  END DO ! ik
  !$OMP END DO
  !
  !$OMP END PARALLEL
  !
  CALL mp_sum( dltf, world_comm )
  !
  ! Ry -> meV
  !
  dltf(1,b_low:b_high,1:nks) = dltf(1,b_low:b_high,1:nks) * 13605.692283_dp
  !
  DEALLOCATE(ggf, vcf, omgf)
  !
END SUBROUTINE gapeq_rhs_f
!
! Calc lambda_k and mu_k
!
SUBROUTINE make_lambda_mu_f()
  !
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_sum
  USE sctk_kernel_weight, ONLY : calc_Kel_f
  USE kinds, ONLY : DP
  USE constants, ONLY : pi
  USE modes, ONLY : nmodes
  USE klist, ONLY : nks
  USE fermisurfer_common,   ONLY : b_low, b_high
  !
  USE sctk_val, ONLY : bindx, dk, ggf, kindx, ngap, omgf, ZF, dltf, Vcf, ncf, nmf, mf, wmf
  USE sctk_gauss_legendre, ONLY : weightspoints_gl
  !
  IMPLICIT NONE
  !
  INTEGER :: ik, ib, jgap, jk, jb, nks0, nks1
  !
  ALLOCATE(ZF(1,b_low:b_high,nks), dltf(1,b_low:b_high,nks)) !dltf -> mu_k
  ZF(1,b_low:b_high,1:nks) = 0.0_dp
  dltf(1,b_low:b_high,1:nks) = 0.0_dp
  !
  ! Set Matsubara sum
  !
  ALLOCATE(mf(nmf), wmf(nmf))
  !
  CALL weightspoints_gl(nmf,mf,wmf)
  !
  wmf(1:nmf) = 2.0_dp / (pi * (mf(1:nmf)**2 + 1.0_dp)) * wmf(1:nmf)
  mf(1:nmf) = (1.0_dp + mf(1:nmf)) / (1.0_dp - mf(1:nmf))
  !
  CALL divide(world_comm, nks,nks0,nks1)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(nks0,nks1,b_low,b_high,ngap,kindx,bindx,ZF,dltf,dk,ggf,omgf,Vcf,ncf,nmodes) &
  !$OMP & PRIVATE(ik,ib,jgap,jk,jb)
  !
  !$OMP DO
  DO ik = nks0, nks1
     !
     DO ib = b_low, b_high
        !
        DO jgap = 1, ngap
           !
           jk = kindx(jgap,1)
           jb = bindx(jgap,1)
           !
           ZF(1,ib,ik) = ZF(1,ib,ik) &
           &         + 2.0_dp * dk(jgap,1) * SUM(ggf(1:nmodes,jb,jk,ib,ik) / ABS(omgf(1:nmodes,jk,ik)))
           !
           dltf(1,ib,ik) = dltf(1,ib,ik) + dk(jgap,1) * calc_Kel_f(0d0,Vcf(1:ncf,jb,jk,ib,ik))
           !
        END DO ! jgap
        !
     END DO ! ib
     !
  END DO ! ik
  !$OMP END DO
  !
  !$OMP END PARALLEL
  !
  CALL mp_sum( ZF, world_comm )
  CALL mp_sum( dltf, world_comm )
  !
END SUBROUTINE make_lambda_mu_f
  !
END MODULE sctk_gapeq_rhs
