package paytonblanchard.android.MetronomePB;

import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;
import android.widget.Button;
import android.widget.TextView;
import android.widget.EditText;
import android.view.View;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
//import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class metronomepbActivity extends Activity {
    /** Called when the activity is first created. */
	
	private MediaPlayer mp;
		
	Timer timer = null;
	Button startBtn, stopBtn, recBtn, recStopBtn;
	EditText tempoBox;
	MediaRecorder recorder = null;
	
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        startBtn = (Button)findViewById(R.id.start);
        stopBtn = (Button)findViewById(R.id.stop);
        final TextView countText = (TextView)findViewById(R.id.msg_text);
        tempoBox = (EditText)findViewById(R.id.editText1);
        recBtn = (Button)findViewById(R.id.rec);
        recBtn = (Button)findViewById(R.id.recstop);
        
        tempoBox.setText("120");
        


        // MediaPlayer Setting
        mp = MediaPlayer.create(this, R.raw.tock);

        startBtn.setOnClickListener(new View.OnClickListener() {
			
			public void onClick(View v) {
				
				String strTempo = tempoBox.getText().toString();
				int tempo = Integer.valueOf(strTempo);
				int interval = 60000/tempo;
				//timerTask = new MyTimerTask();
				
				timer = new Timer(true);
				// require handler to post 'msg_text' to main thread from Timer thread
				final android.os.Handler handler = new android.os.Handler();
				
				timer.scheduleAtFixedRate(
						new TimerTask(){
							int i = 1;
							@Override
							public void run(){
								handler.post(new Runnable(){
									public void run(){
										countText.setText(Integer.toString(i));
										mp.start();
										i++;
									}
								});
							}
						}, 1000, interval);
			}
		});

        
        stopBtn.setOnClickListener(new View.OnClickListener() {
			
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if(timer != null){
					timer.cancel();
					timer = null;
				}

			}
		});

    }
        
              
    public void onClick(View v) {
    	
    	switch(v.getId()){
    	
    	case R.id.rec:
    		
    		recorder = new MediaRecorder();
	        recorder.setAudioSource(MediaRecorder.AudioSource.MIC);
	        recorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
	        recorder.setAudioEncoder(MediaRecorder.AudioEncoder.DEFAULT);
	        
	      //保存先
	        String filePath = Environment.getExternalStorageDirectory() + "/audio.3gp";
	        recorder.setOutputFile(filePath);
	        
	      //録音準備＆録音開始
	        try {
	            recorder.prepare();
	        } catch (Exception e) {
	            e.printStackTrace();
	        }
	        recorder.start();   //録音開始
	        break;
	        
    	case R.id.recstop:
    		
    		recorder.stop();
		    recorder.reset();   //オブジェクトのリセット
		    //release()前であればsetAudioSourceメソッドを呼び出すことで再利用可能
		    recorder.release(); //Recorderオブジェクトの解放
		    break;
    	}
    	        	
    }
        
}

