using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Zanetti.SystemTrading.AutoTrading;
using Zanetti.UI;

namespace Zanetti.Forms
{
	/// <summary>
	/// AutoTradingSummaryDialog ̊Tv̐łB
	/// </summary>
	internal class AutoTradingSummaryDialog : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button _copyButton;
		private System.Windows.Forms.Button _okButton;
		private System.Windows.Forms.ListView _listView;
		private System.Windows.Forms.ColumnHeader _nameColumn;
		private System.Windows.Forms.ColumnHeader _valueColumn;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		public AutoTradingSummaryDialog(AutoTradingResult sr)
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
			InitUI(sr);
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this._copyButton = new System.Windows.Forms.Button();
			this._okButton = new System.Windows.Forms.Button();
			this._listView = new System.Windows.Forms.ListView();
			this._nameColumn = new System.Windows.Forms.ColumnHeader();
			this._valueColumn = new System.Windows.Forms.ColumnHeader();
			this.SuspendLayout();
			// 
			// _copyButton
			// 
			this._copyButton.Location = new System.Drawing.Point(24, 352);
			this._copyButton.Name = "_copyButton";
			this._copyButton.TabIndex = 2;
			this._copyButton.Text = "Rs[";
			this._copyButton.Click += new System.EventHandler(this.OnCopyButton);
			this._copyButton.FlatStyle = FlatStyle.System;
			// 
			// _okButton
			// 
			this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this._okButton.Location = new System.Drawing.Point(288, 352);
			this._okButton.Name = "_okButton";
			this._okButton.TabIndex = 0;
			this._okButton.Text = "OK";
			this._okButton.FlatStyle = FlatStyle.System;
			// 
			// _listView
			// 
			this._listView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this._nameColumn,
																						this._valueColumn});
			this._listView.GridLines = true;
			this._listView.Location = new System.Drawing.Point(0, 0);
			this._listView.MultiSelect = false;
			this._listView.Name = "_listView";
			this._listView.Size = new System.Drawing.Size(376, 344);
			this._listView.TabIndex = 1;
			this._listView.View = System.Windows.Forms.View.Details;
			// 
			// _nameColumn
			// 
			this._nameColumn.Text = "";
			this._nameColumn.Width = 160;
			// 
			// _valueColumn
			// 
			this._valueColumn.Text = "l";
			this._valueColumn.Width = 208;
			// 
			// AutoTradingSummaryDialog
			// 
			this.AcceptButton = this._okButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.CancelButton = this._okButton;
			this.ClientSize = new System.Drawing.Size(376, 383);
			this.ControlBox = false;
			this.Controls.Add(this._listView);
			this.Controls.Add(this._okButton);
			this.Controls.Add(this._copyButton);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "AutoTradingSummaryDialog";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "̏Wv";
			this.ResumeLayout(false);

		}
		#endregion

		private void InitUI(AutoTradingResult sr) {
			AutoTradingResultSummary sum = sr.CreateSummary();
			AddItem("ؑΏۖ", sr.BrandDescription);
            //AddItem("VOiɎgi", );
			AddItem("؊Jn", Util.FormatFullDate(sr.StartDate));
			AddItem("؏I", Util.FormatFullDate(sr.EndDate));
			AddItem("ؓ", String.Format("{0}", sr.TotalCheckCount));
			AddItem("VOi", String.Format("{0} (ς{1:F2}ɂP)", sr.ResultCount, (double)sr.TotalCheckCount / sr.ResultCount));
			AddItem("PVOił̕σg[h", String.Format("{0:F2}", sum._avgTradeLength));
			AddItem("Pg[h̕σptH[}X", String.Format("{0:F2}%", sum._avgPerformance * 100));
			AddItem("ptH[}X̕W΍", String.Format("{0:F2}%", sum._sdTotal * 100));

			AddItem("", String.Format("{0} ({1:F2}%)", sum._exitCount, (double)sum._exitCount / sum._totalCount * 100));
			AddItem("̕ϗv", String.Format("{0:F2}%", sum._avgExit * 100));
			AddItem("̕W΍", String.Format("{0:F2}%", sum._sdExit * 100));
			AddItem("̕σg[h", String.Format("{0:F2}", sum._avgExitTradeLength));
			SignalResult t = sum._maxExit;
			if(t!=null)
				AddItem("ő嗘v", String.Format("{0:F2}% ({1}{2} {3})", t.Performance(sr.Item.TradingType)*100, t.Brand.CodeAsString, t.Brand.Name, Util.FormatShortDate(t.StartDate)));
			else
				AddItem("ő嗘v", "-");

			AddItem("s", String.Format("{0} ({1:F2}%)", sum._losscutCount, (double)sum._losscutCount / sum._totalCount * 100));
			AddItem("s̕ϑ", String.Format("{0:F2}%", sum._avgLosscut * 100));
			AddItem("s̕W΍", String.Format("{0:F2}%", sum._sdLosscut * 100));
			AddItem("s̕σg[h", String.Format("{0:F2}", sum._avgLosscutTradeLength));
			t = sum._maxLosscut;
			if(t!=null)
				AddItem("ő呹", String.Format("{0:F2}% ({1}{2} {3})", t.Performance(sr.Item.TradingType)*100, t.Brand.CodeAsString, t.Brand.Name, Util.FormatShortDate(t.StartDate)));
			else
				AddItem("ő呹", "-");

			AddItem("ʔs\ȃVOi", (sr.ResultCount - sum._exitCount - sum._losscutCount).ToString());
		}

		private void AddItem(string name, string value) {
			ListViewItem li = new ListViewItem(new string[] { name, value });
			_listView.Items.Add(li);
		}

		// Copy{^
		// ListViewUtil𗬗pAꉞ삵Ă̂̎M͂Ȃ by Yakutainashi
		private void OnCopyButton(object sender, EventArgs e) {
			ListViewUtil.CopyListViewContentToClipboard(_listView, new ListViewUtil.ItemChecker(ListViewItemChecker));
		}
		private static bool ListViewItemChecker(ListViewItem li) {
			return true;
		}
	}
}
