require_relative 'ast.rb'

module Protobuf end

class Protobuf::TypeDict
  def initialize
    @base = Hash.new
  end

  def store(type)
    @base[type.absolute_name] = type
  end

  def resolve(owner, reference_name)
    names = owner
            .enum_for(:ancestral_each)
            .reverse_each
            .select{ |item| item.is_a? Protobuf::ASTMessage }
            .map{ |item| item.name }

    until names.empty?
      key = names.join('.') + '.' + reference_name
      if @base.has_key? key
        return @base[key]
      end
      names.pop
    end

    @base[reference_name]
  end
end
