require 'test/unit'
require_relative 'typedict.rb'
require_relative 'ast.rb'

class ProtobufTypeDictTest < Test::Unit::TestCase

  def test_resolve
    dictionary = Protobuf::TypeDict.new

    message0 = Protobuf::ASTMessage.new "msg0", nil
    message1 = Protobuf::ASTMessage.new "msg1", [message0]
    message2 = Protobuf::ASTMessage.new "msg2", [message1]
    message4 = Protobuf::ASTMessage.new "msg1", nil
    message3 = Protobuf::ASTMessage.new "msg3", [message4]
    root = Protobuf::ASTRoot.new [message2, message3]

    dictionary.store message0
    dictionary.store message1
    dictionary.store message2
    dictionary.store message3
    dictionary.store message4

    assert(dictionary.resolve(message0, "msg3") == message3, 'resolve 1') { }
    assert(dictionary.resolve(message1, "msg3") == message3, 'resolve 2') { }
    assert(dictionary.resolve(message2, "msg3") == message3, 'resolve 3') { }
    assert(dictionary.resolve(message3, "msg3") == message3, 'resolve 4') { }
    assert(dictionary.resolve(message4, "msg3") == message3, 'resolve 5') { }
    assert(dictionary.resolve(message0, "msg1") == message1, 'resolve 6') { }
    assert(dictionary.resolve(message1, "msg1") == message1, 'resolve 7') { }
    assert(dictionary.resolve(message2, "msg1") == message1, 'resolve 8') { }
    assert(dictionary.resolve(message3, "msg1") == message4, 'resolve 9') { }
    assert(dictionary.resolve(message4, "msg1") == message4, 'resolve 10') { }
    assert(dictionary.resolve(message0, "msg3.msg1") == message4, 'resolve 11') { }
    assert(dictionary.resolve(message1, "msg3.msg1") == message4, 'resolve 12') { }
    assert(dictionary.resolve(message2, "msg3.msg1") == message4, 'resolve 13') { }
    assert(dictionary.resolve(message3, "msg3.msg1") == message4, 'resolve 14') { }
    assert(dictionary.resolve(message4, "msg3.msg1") == message4, 'resolve 15') { }
    assert(dictionary.resolve(message0, "msg2.msg1.msg0") == message0, 'resolve 16') { }
    assert(dictionary.resolve(message1, "msg2.msg1.msg0") == message0, 'resolve 17') { }
    assert(dictionary.resolve(message2, "msg2.msg1.msg0") == message0, 'resolve 18') { }
    assert(dictionary.resolve(message3, "msg2.msg1.msg0") == message0, 'resolve 19') { }
    assert(dictionary.resolve(message4, "msg2.msg1.msg0") == message0, 'resolve 20') { }
  end
end
