require 'erb'
require 'pathname'

module Protobuf end

class Protobuf::CGenerator
  def initialize(msg_list, type_dict)
    @msg_list = msg_list
    @type_dict= type_dict
  end

  def generate_header
    msg_list = @msg_list.map { |msg|
      Protobuf::CGenerator::Message.new msg, @type_dict
    }
    script = Pathname("../template.h.erb").expand_path(__FILE__).read()

    erb = ERB.new(script, nil, '-');
    erb.result(binding)
  end

  def generate_source(header_file_name)
    msg_list = @msg_list.map { |msg|
      Protobuf::CGenerator::Message.new msg, @type_dict
    }
    script = Pathname("../template.c.erb").expand_path(__FILE__).read()

    erb = ERB.new(script, nil, '-');
    erb.result(binding)
  end
end

class Protobuf::CGenerator::Field
  def initialize(field_node, type_dict)
    @field_node = field_node
    @type_dict = type_dict
  end

  def name
    @field_node.name
  end
  
  def to_c_type
    case @field_node.type
    when :double
      "pb_double_t"
    when :float
      "pb_float_t"
    when :int32
      "pb_int32_t"
    when :int64
      "pb_int64_t"
    when :uint32
      "pb_uint32_t"
    when :uint64
      "pb_uint64_t"
    when :sint32
      "pb_int32_t"
    when :sint64
      "pb_int64_t"
    when :fixed32
      "pb_int32_t"
    when :fixed64
      "pb_int64_t"
    when :sfixed32
      "pb_int32_t"
    when :sfixed64
      "pb_int64_t"
    when :bool
      "pb_bool_t"
    when :string
      nil
    when :bytes
      nil
    when ->t{ t.is_a? Protobuf::ASTReferenceName }
      msg = @type_dict.resolve @field_node.owner_message, @field_node.type.to_s
      Protobuf::CGenerator::Message.new(msg, @type_dict).name
    end
  end

  def c_default_value
    case @field_node.type
    when :double
      "0.0"
    when :float
      "0.0"
    when :int32
      "0"
    when :int64
      "0"
    when :uint32
      "0"
    when :uint64
      "0"
    when :sint32
      "0"
    when :sint64
      "0"
    when :fixed32
      "0"
    when :fixed64
      "0"
    when :sfixed32
      "0"
    when :sfixed64
      "0"
    when :bool
      "False"
    when :string
      ""
    when :bytes
      ""
    end
  end

  def is_singular_numeric?
    ((@field_node.rule == :required)||(@field_node.rule == :optional))&&(@field_node.type.is_a? Symbol)&&(@field_node.type != :string)&&(@field_node.type != :bytes)
  end

  def is_singular_string?
    ((@field_node.rule == :required)||(@field_node.rule == :optional))&&(@field_node.type == :string)
  end

  def is_singular_bytes?
    ((@field_node.rule == :required)||(@field_node.rule == :optional))&&(@field_node.type == :bytes)
  end

  def is_singular_embedded_message?
    ((@field_node.rule == :required)||(@field_node.rule == :optional))&&(@field_node.type.is_a? Protobuf::ASTReferenceName)
  end
end

class Protobuf::CGenerator::Message
  def initialize(msg_node, type_dict)
    @msg_node = msg_node
    @type_dict = type_dict
  end

  def name
    @msg_node.absolute_name.gsub('.', '__')
  end

  def absolute_name
    @msg_node.absolute_name
  end

  def each_field
    return to_enum(__method__) unless block_given?

    @msg_node.each_field { |field|
      yield Protobuf::CGenerator::Field.new field, @type_dict
    }
  end
end
