#include "mruby.h"

#include <bstdio.h>
#include <btron/btron.h>
#include <btron/hmi.h>

static mrb_value
mrb_opn_wnd(mrb_state *mrb, mrb_value self)
{
	PAT	bgpat = {{0, 16, 16, 0x10FFFFFF, 0x10FFFFFF, FILL100}};
	RECT r = {{0, 0, 100, 100}};
	WID wid = wopn_wnd(WA_NORMAL, 0, &r, NULL, 0, NULL, &bgpat, NULL);

	struct RClass* wid_class = mrb_class_get(mrb, "WID");
    mrb_value wid_value = mrb_obj_value(wid_class);
    mrb_value real_value = mrb_fixnum_value(wid);

	return mrb_funcall(mrb, wid_value, "new", 1, real_value);
}

static mrb_value
mrb_cls_wnd(mrb_state *mrb, mrb_value self)
{
	mrb_value s2, id_value;
	mrb_int wid;

	mrb_get_args(mrb, "o", &s2);

	id_value = mrb_funcall(mrb, s2, "id", 0);
	wid = mrb_fixnum(id_value);

	wcls_wnd(wid, CLR);
	printf("fixnum: %d\n", wid);

	return self;
}

void
mrb_mruby_btron_window_gem_init(mrb_state* mrb)
{
	struct RClass *st;
	st = mrb_define_class(mrb, "WMGR", mrb->object_class);

	mrb_define_class_method(mrb, st, "opn_wnd", mrb_opn_wnd, MRB_ARGS_NONE());
	mrb_define_class_method(mrb, st, "cls_wnd", mrb_cls_wnd, MRB_ARGS_REQ(1));
}

void
mrb_mruby_btron_window_gem_final(mrb_state* mrb)
{
}
