#include "../../../posix_include/stdio.h"
#include "../../../posix_include/math.h"
#include <bstring.h>
#include <bstdarg.h>
#include <bstdlib.h>

#include "mruby.h"

double __nan()
{
	static char nan_byte[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff};
	return *(double*)nan_byte;
}

int isnan(double x)
{
	double nan = NAN;
	return memcmp(&x, &nan, sizeof(double)) == 0;
}

int isinf(double x)
{
	double inf = INFINITY;
	double ninf = -inf;
	return (memcmp(&x, &inf, sizeof(double)) == 0) || (memcmp(&x, &ninf, sizeof(double)) == 0);
}

int isfinite(double x)
{
	return !isinf(x);
}

int signbit(double x)
{
	return x < 0.0;
}

double fmod(double x, double y)
{
	return (x - y * (double)((int)(x / y)));
}

int fprintf(FILE* stream, const char* format, ...)
{
	int ret = 0;

	if (*stream == stderr || *stream == stdout) {
		va_list list;
		va_start(list, format);
		ret = vprintf(format, list);
		va_end(list);
	}

	return ret;
}

int snprintf(char *s, size_t len, const char* format, ...)
{
	int ret = 0;
	int len0 = (len < 509) ? 509 : len;
	char *p;
	va_list list;

	p = malloc(sizeof(char)*len0*3);

	va_start(list, format);
	ret = sprintf(p, format, list);
	va_end(list);

	memcpy(s, p, ret > len ? len : ret);

	free(p);

	return ret;
}

void
mrb_mruby_brightv_posixwrapper_gem_init(mrb_state* mrb)
{
}

void
mrb_mruby_brightv_posixwrapper_gem_final(mrb_state* mrb)
{
}
