#include"common.h"

Text::Text(vector2D v,char *t)
{
	pos=v;
	for(int i=0;i<SIZE_OF_LABEL_NAME;i++) txt[i]=t[i];			//O
}

Node::Node()
{
	pos=DirectionVector[NO_DIRECTION];
	for(int i=0;i<8;i++)
	{
		branch[i].SetDeviceClass(no_device);
		branch[i].SetIndexAndSubIndex(-1,-1);
	}
	buswidth=0,path=false,Multipath=false,Short=false,AllRight=false;
}

Node::Node(int bw)
{
	pos=DirectionVector[NO_DIRECTION];
	for(int i=0;i<8;i++)
	{
		branch[i].SetDeviceClass(no_device);
		branch[i].SetIndexAndSubIndex(-1,-1);
	}
	buswidth=bw,path=false,Multipath=false,Short=false,AllRight=false;
}

Label::Label(Direction dir,int n,char *nm)
{
	d=dir;	//
	node_index=n;		//[qWێm[h̃CfbNX
	for(int i=0;i<SIZE_OF_LABEL_NAME;i++) nam[i]=nm[i];			//O
}

LabelIn::LabelIn(Direction dir,int n,char *nm,int buswidth):Label(dir,n,nm)
{
	for(int i=0;i<buswidth;i++) state.push_back(false);
}


Conductor::Conductor(int n0,int n1,Direction di)
{
	buswidth=0;
	Multipath=false;
	Short=false;
	nod[0]=n0;
	nod[1]=n1;
	d=di;
}


Conductor::Conductor(int n0,int n1,Direction di,int nWire)
{
	buswidth=nWire;
	Multipath=false;
	Short=false;
	nod[0]=n0;
	nod[1]=n1;
	d=di;
}

Gate::Gate(Operation ope,Direction dir,int out,std::vector<SourceData> &in)
{
	op=ope;
	d=dir;
	node_out=out;
	array_in=in;
}

Gate::Gate(Operation ope,Direction dir,int out,std::vector<SourceData> &in,int buswidth)
{
	op=ope;
	d=dir;
	node_out=out;
	array_in=in;
	for(int i=0;i<buswidth;i++)state.push_back(false);
}

BusIn::BusIn(Direction dir,std::vector<int> &out,SourceData in)
{
	d=dir;
	node_out=out;
	node_in=in;
}

BusIn::BusIn(Direction dir,std::vector<int> &out,SourceData in,int buswidth)
{
	d=dir;
	node_out=out;
	node_in=in;
	for(int i=0;i<buswidth;i++)state.push_back(false);
}

BusOut::BusOut(Direction dir,int out,std::vector<SourceData> &in)
{
	d=dir;
	node_out=out;
	array_in=in;
}

BusOut::BusOut(Direction dir,int out,std::vector<SourceData> &in,int buswidth)
{
	d=dir;
	node_out=out;
	array_in=in;
	for(int i=0;i<buswidth;i++)state.push_back(false);
}
