;; -*- mode: fundamental; coding: utf-8 -*-
;; Large size dictionary for SKK system
;; Copyright (C) 1988-1995, 1997, 1999-2014
;;
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Hironobu Takahashi <takahasi@tiny.or.jp>,
;; Masahiro Doteguchi, Miki Inooka,
;; Yukiyoshi Kameyama <kameyama@kuis.kyoto-u.ac.jp>,
;; Akihiko Sasaki, Dai Ando, Junichi Okukawa,
;; Katsushi Sato and Nobuhiro Yamagishi
;; NAKAJIMA Mikio <minakaji@osaka.email.ne.jp>
;; MITA Yuusuke <clefs@mail.goo.ne.jp>
;; SKK Development Team <skk@ring.gr.jp>
;;
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Version: $Id: SKK-JISYO.L,v 1.1353 2017/06/05 11:17:02 skk-cvs Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2017/06/05 11:17:02 $
;;
;; This dictionary is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.
;;
;; This dictionary is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;
;; ACKNOWLEDGEMENT
;;
;; この辞書は、SKK 原作者の佐藤雅彦先生が、第 1 版作成のために東北大学
;; 電気通信研究所佐藤研究室 (当時) の学生さん達とともに scratch から作
;; 成されたのをその起源とし、その後、無数のユーザからのユーザ辞書の提
;; 供やフォームによる追加・校閲によって今尚日々メンテナンスされている日
;; 本で最大規模の、GPL による copy free の辞書です。
;;
;; この辞書の作成にご尽力頂いた全ての方に感謝すると共に、これをお読み
;; のあなたのご協力を是非ともお待ちしております。
;;
;;   http://openlab.ring.gr.jp/skk/registdic.cgi
;;
;; にアクセスし、フォームに是非あなたの新語・誤登録指摘・コメントを書
;; いて下さい。
;;
;; また、実際に辞書の編集をしてみたいという方は、
;;
;;   http://openlab.ring.gr.jp/skk/cvs-ja.html#account
;;
;; をご覧の上、cvs account の発行申し込みをして下さい。
;;
;; 辞書の編集方針は skk/dic/READMEs/committers.txt をご参照下さい。
;; そこに記載のない事項、またその変更については、その都度 SKK Openlab
;; ML で話し合いで決められます。
;;
;; okuri-ari entries.
をs /惜/
ゐr /居/
われらg /我等/
われしr /我知/
われw /我/
われt /我/
われr /我/
われn /我/
われm /我/
われh /我/
われg /我/
わるよi /悪酔/
わるびr /悪怯/
わるだくm /悪巧/
わるすg /悪過/
わるがしこs /悪賢/
わるがしこk /悪賢/
わるがしこi /悪賢/
わるがしこg /悪賢/
わるs /悪/惡;「悪」の旧字(人名用漢字)/
わるk /悪/惡;「悪」の旧字(人名用漢字)/
わるi /悪/惡;「悪」の旧字(人名用漢字)/
わるg /悪/惡;「悪」の旧字(人名用漢字)/
わるb /悪/
わりもどs /割り戻/割戻/
わりふt /割り振/割振/
わりふr /割り振/割振/
わりふn /割り振/割振/
わりふc /割り振/割振/
わりびk /割引/割り引/
わりびi /割り引/割引/
わりつk /割り付/割付/
わりだs /割り出/割出/
わりこn /割り込/割込/
わりこm /割り込/割込/
わりきt /割り切/割切/
わりきr /割り切/割切/
わりきn /割り切/割切/
わりきc /割り切/割切/
わりいr /割り入;卵を-れる/
わりあt /割り当/割当/
わりあi /割り合/割合/
わりt /割/
わりs /割/
わりn /割;-に(合う)/
わりk /割/
わらぶk /藁葺/
わらいなk /笑い泣/
わらいとb /笑い飛/
わらいつづk /笑い続/
わらいだs /笑い出/
わらいじn /笑い死/
わらいころg /笑い転/
わらいこk /笑い転/
わらいくずr /笑い崩/
わらいかえs /笑い返/
わらw /笑/嗤;(jeer) 人の失敗を嗤う/
わらu /笑/嗤;(jeer) 人の失敗を嗤う/
わらt /笑/嗤;(jeer) 人の失敗を嗤う/
わらo /笑/嗤;(jeer) 人の失敗を嗤う/
わらk /笑/嗤/
わらi /笑/嗤;(jeer) 人の失敗を嗤う/
わらh /笑/嗤/
わらe /笑/嗤;(jeer) 人の失敗を嗤う/
わらc /笑/嗤;(jeer) 人の失敗を嗤う/
わめきちr /喚き散/
わめきたt /喚き立/
わめk /喚/叫/
わめi /喚/叫/
わびずまi /侘住/
わびしs /侘/
わびしk /侘/
わびしi /侘/
わびしg /侘/
わびs /侘/
わびr /侘/
わのr /輪乗/
わななk /戦慄/
わななi /戦慄/
わなg /輪投/
わとj /和綴/
わづらh /煩/
わだかまt /蟠/
わだかまr /蟠/
わだかまn /蟠/
わだかまc /蟠/
わたりあるk /渡り歩/
わたりあるi /渡り歩/
わたりあw /渡り合/
わたりあu /渡り合/
わたりあt /渡り合/
わたりあo /渡り合/
わたりあi /渡り合/
わたりあe /渡り合/
わたりあc /渡り合/
わたしこn /渡し込/
わたしこm /渡し込/
わたしw /私/
わたしt /私/
わたしn /私/
わたしm /私/
わたしh /私/
わたしg /私/
わたくしw /私/
わたくしt /私/
わたくしn /私/
わたくしm /私/
わたくしh /私/
わたくしg /私/
わたt /渡/亘;(範囲・期間) ５日間に亘る/亙;=亘る (人名用漢字) (NB:本来の字)/渉/航/
わたs /渡/
わたr /渡/亘;(範囲・期間) ５日間に亘る/亙;=亘る (人名用漢字) (NB:本来の字)/渉/航/
わたn /渡/亘;(範囲・期間) ５日間に亘る/亙;=亘る (人名用漢字) (NB:本来の字)/渉/航/
わたc /渡/亘;(範囲・期間) ５日間に亘る/亙;=亘る (人名用漢字) (NB:本来の字)/渉/航/
わせだどおr /早稲田通/
わずらw /煩;(煩瑣) 煩わしい作業/患;(罹患) 肺病を患う/
わずらu /患;(罹患) 肺病を患う/煩;(煩瑣) 思い煩う/
わずらt /患;(罹患) 肺病を患う/煩;(煩瑣) 思い煩う/
わずらo /患;(罹患) 肺病を患う/煩;(煩瑣) 思い煩う/
わずらi /患;(罹患) 肺病を患う/煩;(煩瑣) 思い煩う/
わずらe /患;(罹患) 肺病を患う/煩;(煩瑣) 思い煩う/
わずらc /患;(罹患) 肺病を患う/煩;(煩瑣) 思い煩う/
わずk /僅/微;NB:「かすk」と同形/纔;≒僅か/毫;<rare> ≒僅か/
わすれはt /忘れ果/
わすれさt /忘れ去/
わすれさr /忘れ去/
わすれさn /忘れ去/
わすれさc /忘れ去/
わすれがたs /忘れ難/
わすれがたk /忘れ難/
わすれがたi /忘れ難/
わすれがたg /忘れ難/
わすr /忘/
わしづかm /鷲掴/
わしw /儂/
わしt /儂/
わしn /儂/
わしm /儂/
わしh /儂/
わしg /儂/
わざわi /災/禍;(字義:落とし穴)/厄;<rare>/
わざt /態/
わけなs /訳無/
わけなk /訳無/
わけなi /訳無/
わけしr /訳知/
わけいt /分け入/
わけいr /分け入/
わけいn /分け入/
わけいc /分け入/
わけあたe /分け与/
わけあw /分け合/
わけあu /分け合/
わけあt /分け合/
わけあo /分け合/
わけあi /分け合/
わけあe /分け合/
わけあc /分け合/
わけt /分/
わけr /分/
わけn /分/
わけc /分/
わくぐm /枠組/
わぎr /輪切/
わきまe /弁/
わきでz /湧き出/涌き出/
わきでy /湧き出/涌き出/
わきでt /湧き出/涌き出/
わきでs /湧き出/涌き出/
わきでr /湧き出/涌き出/
わきでn /湧き出/涌き出/
わきでm /湧き出/涌き出/
わきでc /湧き出/涌き出/
わきづk /脇付/
わきだs /湧き出/
わきたt /沸き立;boil/湧き立;pour out/涌き立;=湧き立つ/
わきたc /沸き立;boil/湧き立;pour out/涌き立;=湧き立つ/
わきがたm /脇固/
わきかえt /沸き返/
わきかえr /沸き返/
わきかえn /沸き返/
わきかえc /沸き返/
わきおこt /沸き起/
わきおこr /沸き起/
わきおこn /沸き起/
わきおこc /沸き起/
わきおk /沸き起/湧き起/
わきあg /湧き上;(rush) 雲が湧き上がる/沸き上;風呂が沸き上がる/
わかわかs /若々/
わかりやすs /分かり易/判り易/理解り易/
わかりやすk /分かり易/判り易/理解り易/
わかりやすi /分かり易/判り易/理解り易/
わかりやすg /分かり易/判り易/理解り易/
わかりにくs /分かり難/
わかりにくk /分かり難/
わかりにくi /分かり難/
わかりにくg /分かり難/
わかりきt /分かり切/
わかりきr /分かり切/
わかりきn /分かり切/
わかりきc /分かり切/
わかづくr /若作/
わかちあw /分かち合/
わかちあu /分かち合/
わかちあt /分かち合/
わかちあo /分かち合/
わかちあi /分かち合/
わかちあe /分かち合/
わかちあc /分かち合/
わかがえt /若返/
わかがえr /若返/
わかがえn /若返/
わかがえc /若返/
わかy /若/
わかt /判;(判別) 違いが判る/分;(非正則:わk)/解;(理解) 仕組が解る/別/頒;わけ与える/觧;「解」の異体字/理解;(当て字)/
わかs /若/稚/
わかr /別;(人と) 彼氏と別れる/判;(判別) 違いが判る/解;(理解) 仕組が解る/分;(非正則:わk)/理解;(当て字)/訣;(キッパリとわかれる)/觧;「解」の異体字/
わかn /解;(理解) 仕組が解る/判;(判別) 違いが判る/分;(非正則:わk)/理解;(当て字)/觧;「解」の異体字/
わかk /若/稚/
わかi /若/稚/
わかg /若/稚/
わかc /解;(理解) 仕組が解る/判;(判別) 違いが判る/分;(非正則:わk)/理解;(当て字)/觧;「解」の異体字/
わt /割/
わs /和/
わr /割/破/
わn /割/
わk /分/湧;(spring) 泉が湧く/沸;(boil) お湯が沸く/涌;≒湧く/訳/
わi /湧;(spring) 泉が湧く/沸;(boil) お湯が沸く/涌;≒湧く/
わg /我/
わc /割/
わb /詫;謝罪する/侘;侘び寂び/
ろんz /論/
ろんj /論/
ろくがどr /録画撮/
ろくs /録;記録/
ろくn /碌/
ろうをおs /労を惜/
ろうs /労;心身を労する/弄;策を弄する/聾;耳を聾する/
れんらくいただk /連絡頂/
れんらくいただi /連絡頂/
れんらくいたs /連絡致/
れんきゅうあk /連休明/
れっs /列/
れいれいs /麗々/
れいぎただs /礼儀正/
れいn /例/
るいs /類/
りんt /凛/
りりs /凛々/凛凛/律々;=凛々しい/
りようくだs /利用下/
りようs /利用/
りょこううかがi /旅行伺/
りょうほうとt /両方取/
りょうほうとr /両方取/
りょうほうとn /両方取/
りょうほうとc /両方取/
りょうびらk /両開/
りょうひらk /両開/
りょうしょうくだs /了承下/
りょうかいs /了解/
りょうs /領/諒;諒承/
りゅうこうおくr /流行遅/
りゃくs /略/
りまわr /利回/
りばらi /利払/
りづm /理詰/
りつk /利付/
りっs /律/
りだすk /利助/
りさg /利下/
りぐi /利食/
りくつぬk /理屈抜/
りくつどおr /理屈通/
りくつづk /陸続/
りくつp /理屈/
りくあg /陸揚/
りくs /戮/
りきn /力/
りきm /力/
りかいs /理解/
りおt /利落/
りあg /利上/
りs /利/
らんぎr /乱切/
らんs /濫/
らっs /拉/
らくがk /落書/
らくs /楽/
らくn /楽/
らくd /楽/
らうs /労/
よんd /読ん;※送り位置補正/
よわりはt /弱り果/
よわりきt /弱り切/
よわりきr /弱り切/
よわりきn /弱り切/
よわりきc /弱り切/
よわよわs /弱々/
よわふくm /弱含/
よわたr /世渡/
よわすg /弱過/
よわt /弱/
よわs /弱/
よわr /弱/
よわn /弱/
よわm /弱/
よわk /弱/
よわi /弱/
よわg /弱/
よわc /弱/
よろしk /宜/
よろこんd /喜ん;※送り位置補正/
よろこびいさn /喜び勇/
よろこびいさm /喜び勇/
よろこn /喜;(字義:お祝いしてよろこぶ)/悦;(字義:心のしこりが取れる)/歓;(字義:声を上げてよろこぶ)/慶;(祝福)お慶び申し上げます (字義:お祝いを持って行く)/
よろこb /喜;(字義:お祝いしてよろこぶ)/悦;(字義:心のしこりが取れる)/歓;(字義:声を上げてよろこぶ)/慶;(祝福)「お慶び申し上げます」 (字義:お祝いを持って行く)/
よろs /宜/
よろm /蹌踉/
よるおそs /夜遅/
よるおそk /夜遅/
よるおそi /夜遅/
よるおそg /夜遅/
よりわk /選り分/
よりぬk /選り抜/
よりぬi /選り抜/
よりによt /選りに選/
よりどr /選り取/
よりつk /寄付/
よりつi /寄付/
よりだs /選り出/
よりそw /寄り添/
よりそu /寄り添/
よりそt /寄り添/
よりそo /寄り添/
よりそi /寄り添/
よりそe /寄り添/
よりそc /寄り添/
よりごのm /選り好/
よりきt /寄り切/
よりきr /寄り切/
よりきn /寄り切/
よりきc /寄り切/
よりかk /寄り掛/
よりあわs /縒り合/
よりあつm /寄り集/
よりあw /縒り合/寄り合/
よりあu /寄り合/
よりあt /寄り合/
よりあo /寄り合/
よりあi /寄り合/
よりあe /寄り合/
よりあc /寄り合/
よめとr /嫁取/
よめいr /嫁入/
よみわk /読み分/
よみやすs /読み易/
よみやすk /読み易/
よみやすi /読み易/
よみやすg /読み易/
よみまちがw /読み間違/
よみまちがu /読み間違/
よみまちがt /読み間違/
よみまちがo /読み間違/
よみまちがi /読み間違/
よみまちがe /読み間違/
よみまちがc /読み間違/
よみふけt /読み耽/
よみふけr /読み耽/
よみふけn /読み耽/
よみふけc /読み耽/
よみはじm /読み始/
よみにくs /読み難/
よみにくk /読み難/
よみにくi /読み難/
よみにくg /読み難/
よみながs /読み流/
よみなおs /読み直/
よみなr /読み慣/
よみとおs /読み通/
よみとt /読み取/読取/
よみとr /読み取/読取/
よみとn /読み取/読取/
よみとk /読み解/
よみとi /読み解/
よみとc /読み取/読取/
よみとb /読み飛/
よみづらs /読み辛/
よみづらk /読み辛/
よみづらi /読み辛/
よみづらg /読み辛/
よみつづk /読み続/
よみちがe /読み違/
よみちr /読み散/
よみだs /読み出/読出/
よみすすn /読み進/
よみすすm /読み進/
よみすごs /読み過/
よみすt /読み捨/
よみこn /読み込/読込/詠み込;詩歌の中に入れる/
よみこm /読み込/読込/詠み込;詩歌の中に入れる/
よみくらb /読み比/読み較/
よみくだs /読み下/訓み下/
よみきt /読み切/読切/
よみきr /読み切/読切/
よみきn /読み切/読切/
よみきk /読み聞/
よみきc /読み切/読切/
よみがえt /甦/蘇;=甦る/蘓;「蘇」の異体字/
よみがえr /甦/蘇;=甦る/蘓;「蘇」の異体字/
よみがえn /甦/蘇;=甦る/蘓;「蘇」の異体字/
よみがえc /甦/蘇;=甦る/蘓;「蘇」の異体字/
よみがe /蘇/蘓;「蘇」の異体字/
よみかえs /読み返/
よみかk /読み書/
よみかe /読み替/
よみおとs /読み落/
よみおw /読み終/
よみおt /読み落/
よみおe /読み終/
よみあやまt /読み誤/
よみあやまr /読み誤/
よみあやまn /読み誤/
よみあやまc /読み誤/
よみあさt /読み漁/
よみあさr /読み漁/
よみあさn /読み漁/
よみあさc /読み漁/
よみあw /読み合/
よみあk /読み飽/
よみあg /読み上/
よみs /嘉/
よみd /読み;※送り位置補正/
よまわr /夜回/
よふかs /夜更/
よふk /夜更/
よびよs /呼び寄/呼寄/
よびもどs /呼び戻/
よびならw /呼び習/
よびとm /呼び止/
よびつづk /呼び続/
よびつk /呼び付/呼付/
よびだs /呼び出/呼出/
よびたt /呼び立/
よびすt /呼び捨/
よびさm /呼び覚/
よびこn /呼び込/
よびこm /呼び込/
よびかわs /呼び交/
よびかえs /呼び返/
よびかw /呼び交/
よびかk /呼び掛/呼掛/
よびおk /呼び起/
よびあつm /呼び集/
よばi /夜這/
よにg /夜逃/
よなよn /夜な夜/
よなおs /世直/
よなr /世慣/世馴/
よなk /夜泣/
よどおs /夜通/
よどn /淀/澱;=淀む/
よどm /淀/澱;=淀む/
よとおr /四通/
よていどおr /予定通/
よづr /夜釣/
よつg /世継/
よっぱらw /酔っ払/
よっぱらu /酔っ払/
よっぱらt /酔っ払/
よっぱらo /酔っ払/
よっぱらi /酔っ払/
よっぱらe /酔っ払/
よっぱらc /酔っ払/
よってたt /拠って立/
よっかk /寄っ掛/
よっt /四/
よだt /夜立/弥立;身の毛も弥立つ/
よだc /弥立;身の毛も弥立つ/
よそよそs /余所余所/
よそほu /裝;「装」の旧字(人名用漢字)/
よそおw /装/粧/裝;「装」の旧字(人名用漢字)/
よそおu /装/粧/裝;「装」の旧字(人名用漢字)/
よそおt /装/裝;「装」の旧字(人名用漢字)/粧/
よそおo /装/粧/裝;「装」の旧字(人名用漢字)/
よそおi /装/裝;「装」の旧字(人名用漢字)/粧/
よそおh /裝;「装」の旧字(人名用漢字)/
よそおe /装/粧/裝;「装」の旧字(人名用漢字)/
よそおc /装/粧/裝;「装」の旧字(人名用漢字)/
よそうどおr /予想通/
よそうs /予想/
よそw /装/
よそu /装/
よそt /装/
よそo /装/
よそi /装/
よそh /装/
よそe /寄/比/装/
よそc /装/
よせつk /寄せ付/
よせこz /寄せ来/
よせこy /寄せ来/
よせこs /寄せ来/
よせこr /寄せ来/
よせこn /寄せ来/
よせこi /寄せ来/
よせくr /寄せ来/
よせくn /寄せ来/
よせきy /寄せ来/
よせきt /寄せ来/
よせきs /寄せ来/
よせきn /寄せ来/
よせきm /寄せ来/
よせきd /寄せ来/
よせきc /寄せ来/
よせがk /寄せ書/寄書/
よせあつm /寄せ集/
よせあw /寄せ合/
よせあu /寄せ合/
よせあt /寄せ合/
よせあo /寄せ合/
よせあi /寄せ合/
よせあe /寄せ合/
よせあc /寄せ合/
よすg /良過/
よじのぼt /攀じ上/
よじのぼr /攀じ上/
よじのぼn /攀じ上/
よじのぼc /攀じ上/
よじt /捩/
よじr /捩/
よじn /捩/
よじk /捩/
よじc /捩/
よしなs /由無/
よしなk /由無/
よしなi /由無/
よしなg /由無/
よしあs /善し悪/
よごs /汚/
よごr /汚/
よこわr /横割/
よこばしt /横走/
よこばしr /横走/
よこばしn /横走/
よこばしc /横走/
よこばi /横這/
よこならb /横並/
よこながs /横流/
よこどr /横取/
よことb /横跳/
よこづk /横付/
よこっとb /横っ飛/横っ跳/
よこだおs /横倒/
よこずk /横好/
よこすべr /横滑/
よこしまs /邪/
よこしまn /邪/
よこしまd /邪/
よこくどおr /予告通/
よこぎt /横切/
よこぎr /横切/
よこぎn /横切/
よこぎc /横切/
よこがk /横書/
よこt /横/
よこs /寄越/遣/横;-すべり/
よくぶかs /欲深/
よくぶかk /欲深/
よくぶかi /欲深/
よくぶかg /欲深/
よくばt /欲張/
よくばr /欲張/
よくばn /欲張/
よくばc /欲張/
よくs /浴;bath/
よくb /欲/
よぎなk /余儀無/
よぎt /過/
よぎr /過/
よぎn /余儀/過/
よぎc /過/
よかr /善か;※送り位置補正/
ようりょうよk /要領良/
ようよu /漸/
ようやk /漸/
ようむk /用向/
ようちあさがk /夜討ち朝駆/
ようだt /用立/
ようたs /用足/
ようずm /用済/
ようじんぶかs /用心深/
ようじんぶかk /用心深/
ようじんぶかi /用心深/
ようじんぶかg /用心深/
ようしゃねがu /容赦願/
ようしゃねがi /容赦願/
ようしゃくだs /容赦下/
よういs /用意/
よういn /容易/
よういd /容易/
ようt /夜討/杳;-として姿を見せない/
ようs /要/擁;擁護/様/
ようn /様/陽/樣;「様」の旧字(人名用漢字)/
ようh /要;-は/
ようd /様/
よいどm /酔い止/
よいつぶs /酔い潰/
よいつぶr /酔い潰/
よいっぱr /宵っ張/
よいしr /酔い痴/
よいざm /酔い覚;/酔い醒/酔醒/
よいごs /宵越/
よあるk /夜歩/
よあそb /夜遊/
よあk /夜明/
よz /攀/
よw /酔/醉;「酔」の旧字(人名用漢字)/
よu /酔/醉;「酔」の旧字(人名用漢字)/
よt /酔/四/寄/因;(原因) ガス漏れに因る/選;選りすぐり NB:「えr」「すぐr」と同形/依;(依存) 仕送りに依る/拠;(根拠) 先行論文に拠る/４/醉;「酔」の旧字(人名用漢字)/撚;こよりを撚る/縒;≒撚る/憑/
よs /寄/良/善;(性質がよい)「善い行い」/止/好;好し/酔/佳;(縁起がよい)「佳い日」 (字義:形がすっきりしている)/醉;「酔」の旧字(人名用漢字)/譱;「善」の異体字/
よr /寄/依;(依存) 仕送りに依る/拠;(根拠) 先行論文に拠る/因;(原因) ガス漏れに因る/撚;こよりを撚る/縒;≒撚る/選;選りすぐり NB:「えr」「すぐr」と同形/憑/
よp /酔/
よo /酔/醉;「酔」の旧字(人名用漢字)/
よn /読/呼/詠;和歌を詠む/訓;字の訓み(=訓読み)/世/丗;「世」の異体字/讀;「読」の旧字/寄/依;(依存) 仕送りに依る/拠;(根拠) 先行論文に拠る/因;(原因) ガス漏れに因る/撚;こよりを撚る/縒;≒撚る/選;選りすぐり NB:「えr」「すぐr」と同形/憑/喚;(声を上げて呼び寄せる)/
よm /読/詠;和歌を詠む/訓;字の訓み(=訓読み)/讀;「読」の旧字/
よk /良/善;(性質がよい)「善い行い」/除;(put aside)自分の分を除ける NB:「のk」と同形/避;(avoid)車を避ける NB:「さk」と同形/好;NB:「すk」と同形/能;柔-く剛を制す/寄;-っかかる/譱;「善」の異体字/酔/佳;(縁起がよい)「佳い日」 (字義:形がすっきりしている)/醉;「酔」の旧字(人名用漢字)/
よj /攀/
よi /良/酔/好;(このましい),「好い天気」/善;(性質がよい)「善い行い」/佳;(縁起がよい)「佳い日」 (字義:形がすっきりしている)/醉;「酔」の旧字(人名用漢字)/譱;「善」の異体字/
よg /善;(性質がよい)「善い行い」/良/酔/好;(このましい),「好い天気」/佳;(縁起がよい)「佳い日」 (字義:形がすっきりしている)/醉;「酔」の旧字(人名用漢字)/譱;「善」の異体字/
よe /酔/醉;「酔」の旧字(人名用漢字)/
よc /酔/醉;「酔」の旧字(人名用漢字)/寄/依;(依存) 仕送りに依る/拠;(根拠) 先行論文に拠る/因;(原因) ガス漏れに因る/撚;こよりを撚る/縒;≒撚る/選;選りすぐり NB:「えr」「すぐr」と同形/憑/
よb /呼/喚;(声を上げて呼び寄せる)/
よa /良/
ゆわかs /湯沸/
ゆわえつk /結わえ付/
ゆわk /湯沸/
ゆれうごk /揺れ動/
ゆれうごi /揺れ動/
ゆるしがたs /許し難/
ゆるしがたk /許し難/
ゆるしがたi /許し難/
ゆるしがたg /許し難/
ゆるしあw /許し合/
ゆるしあu /許し合/
ゆるしあt /許し合/
ゆるしあo /許し合/
ゆるしあi /許し合/
ゆるしあe /許し合/
ゆるしあc /許し合/
ゆるぎなs /揺るぎ無/
ゆるぎなk /揺るぎ無/
ゆるぎなi /揺るぎ無/
ゆるがs /忽;-せ/
ゆるy /緩/
ゆるs /許/赦;罪を赦す/聴;ききいれる/緩/
ゆるr /緩;副詞(-り)/
ゆるn /緩/弛/
ゆるm /緩/弛/
ゆるk /緩/
ゆるi /緩/揺/
ゆるg /揺/緩/
ゆるb /弛;[文語]/緩;[文語]/
ゆりもどs /揺り戻/
ゆりかえs /揺り返/
ゆりおこs /揺り起/
ゆりおt /揺り落/
ゆりおk /揺り起/
ゆりうごk /揺り動/
ゆゆs /由々/由由/忌々;≒由々しい/
ゆめみz /夢見/
ゆめみy /夢見/
ゆめみt /夢見/
ゆめみs /夢見/
ゆめみr /夢見/
ゆめみn /夢見/
ゆめみm /夢見/
ゆめみk /夢見/
ゆめみc /夢見/
ゆめn /夢/
ゆみひk /弓引/
ゆみひi /弓引/
ゆみけずr /弓削;?/
ゆびづかi /指使/
ゆびさs /指差/
ゆびおr /指折/
ゆどおs /湯通/
ゆとうよm /湯桶読/
ゆですg /茹で過/
ゆであg /茹で上/
ゆづt /讓;「譲」の旧字(人名用漢字)/
ゆづr /讓;「譲」の旧字(人名用漢字)/
ゆだt /茹/
ゆだr /茹/
ゆだn /委/茹/
ゆだc /茹/
ゆたk /豊/豐;旧字/
ゆずりわたs /譲り渡/
ゆずりうk /譲り受/
ゆずりあw /譲り合/
ゆずりあu /譲り合/
ゆずりあt /譲り合/
ゆずりあo /譲り合/
ゆずりあi /譲り合/
ゆずりあe /譲り合/
ゆずりあc /譲り合/
ゆずt /譲/讓;「譲」の旧字(人名用漢字)/
ゆずr /譲/讓;「譲」の旧字(人名用漢字)/
ゆずn /譲/讓;「譲」の旧字(人名用漢字)/
ゆずc /譲/讓;「譲」の旧字(人名用漢字)/
ゆすりとt /強請り取/
ゆすりとr /強請り取/
ゆすりとn /強請り取/
ゆすりとc /強請り取/
ゆすぶt /揺振/
ゆすぶr /揺振/
ゆすぶn /揺振/
ゆすぶc /揺振/
ゆすt /強請/揺;非正則/
ゆすr /強請/揺;非正則/
ゆすn /強請/揺;非正則/
ゆすi /濯/
ゆすg /濯/
ゆすc /強請/揺;非正則/
ゆざm /湯冷/
ゆさぶt /揺さ振/揺振/
ゆさぶr /揺さ振/揺振/
ゆさぶn /揺さ振/揺振/
ゆさぶc /揺さ振/揺振/
ゆきわたt /行き渡/
ゆきわたr /行き渡/
ゆきわたn /行き渡/
ゆきわたc /行き渡/
ゆきまつr /雪祭/
ゆきなやn /行き悩/
ゆきなやm /行き悩/
ゆきどm /行き止/
ゆきどk /雪解/
ゆきとどk /行き届/
ゆきとどi /行き届/
ゆきづm /行き詰/
ゆきつk /行き着;-く先/行き付;-けの店/
ゆきつi /行き着/
ゆきちがw /行き違/
ゆきちがu /行き違/
ゆきちがt /行き違/
ゆきちがo /行き違/
ゆきちがi /行き違/
ゆきちがe /行き違/
ゆきちがc /行き違/
ゆきだおr /行き倒/
ゆきすg /行き過/行過/
ゆききd /行き来/
ゆきがk /行き掛/
ゆきかよw /行き通/
ゆきかよu /行き通/
ゆきかよt /行き通/
ゆきかよo /行き通/
ゆきかよi /行き通/
ゆきかよe /行き通/
ゆきかよc /行き通/
ゆきかえr /行き帰/
ゆきかw /行き交/
ゆきかu /行き交/
ゆきかt /行き交/
ゆきかo /行き交/
ゆきかi /行き交/
ゆきかe /行き交/
ゆきかc /行き交/
ゆきおr /雪下/
ゆきあたt /行き当/
ゆきあたr /行き当/
ゆきあたn /行き当/
ゆきあたc /行き当/
ゆきあw /行き合/
ゆきあu /行き合/
ゆきあt /行き当/行き合/行当/
ゆきあo /行き合/
ゆきあk /雪明/
ゆきあi /行き合/
ゆきあe /行き合/
ゆきあc /行き合/
ゆがn /歪/
ゆがm /歪/
ゆがk /湯掻/
ゆがi /湯掻/
ゆかs /床;(当て字)/
ゆえなs /故無/
ゆえなk /故無/
ゆえなi /故無/
ゆえなg /故無/
ゆえn /故/
ゆうりn /有利/
ゆうやk /夕焼/
ゆうめいすg /有名過/
ゆうまぐr /夕間暮/
ゆうびんうk /郵便受/
ゆうばr /夕晴/
ゆうばe /夕映/
ゆうすずm /夕涼/
ゆうしょうあらそi /優勝争/
ゆうしゅうn /優秀/
ゆうぐr /夕暮/
ゆうきづk /勇気付/
ゆうs /有/
ゆうn /優/
ゆうb /夕/
ゆいつk /結い付/
ゆいしょただs /由緒正/
ゆいあg /結い上/
ゆあg /湯上/
ゆw /結/
ゆu /結/
ゆt /結/揺/汰;砂金を汰る/淘;≒汰る/搖;「揺」の旧字(人名用漢字)/
ゆs /揺/搖;「揺」の旧字(人名用漢字)/
ゆr /揺/汰;砂金を汰る/淘;≒汰る/搖;「揺」の旧字(人名用漢字)/
ゆo /結/
ゆn /揺/汰;砂金を汰る/淘;≒汰る/搖;「揺」の旧字(人名用漢字)/
ゆk /行/逝;(死ぬ)/往;(字義:目的地へ行く) 道を往く/征;(字義:まっすぐ遠くへ行く) 荒野を征く/徃;「往」の異体字/
ゆi /結/
ゆh /結/
ゆg /湯/
ゆe /結/
ゆd /茹/
ゆc /結/揺/汰;砂金を汰る/淘;≒汰る/搖;「揺」の旧字(人名用漢字)/
やんごとなs /止事無/
やんごとなk /止事無/
やんごとなi /止事無/
やわらかk /柔/
やわs /柔/
やわr /柔;(字義:曲げても折れないしなやかさ)/軟;(字義:手応えがない)/和;-らぐ/
やわn /柔/
やわk /柔/
やわi /柔/
やわg /柔/
やわd /柔/
やりのこs /遣り残/やり残/
やりぬk /遣り抜/やり抜/
やりぬi /遣り抜/やり抜/
やりなおs /遣り直/やり直/
やりとr /遣り取/
やりとg /遣り遂/やり遂/
やりつくs /遣り尽/
やりつk /遣り付/
やりっぱなs /遣りっ放/
やりだs /遣り出/やり出/
やりそんz /遣り損/やり損/
やりそんj /遣り損/やり損/
やりそこなw /遣り損/やり損/
やりそこなu /遣り損/やり損/
やりそこなt /遣り損/やり損/
やりそこなo /遣り損/やり損/
やりそこなi /遣り損/やり損/
やりそこなe /遣り損/やり損/
やりそこなc /遣り損/やり損/
やりそこn /遣り損/やり損/
やりすごs /遣り過/やり過/
やりすg /遣り過/やり過/
やりこなs /遣り熟/
やりこn /遣り込/やり込/
やりこm /遣り込/やり込/
やりきr /遣り切;遣り切れない/やり切/
やりかえs /遣り返/やり返/
やりおe /遣り終/やり終/
やりあw /やり合/遣り合/
やりあu /遣り合/やり合/
やりあt /やり合/遣り合/
やりあo /やり合/遣り合/
やりあi /やり合/遣り合/
やりあe /やり合/
やりあc /遣り合/やり合/
やめr /止め;※送り位置補正/
やむをえz /止むを得/
やむをえn /止むを得/
やむをえm /止むを得/
やむごとなs /止事無/
やむごとなk /止事無/
やむごとなi /止事無/
やみとりひk /闇取り引/
やみつk /病み付/
やみつi /病み付/
やみがたs /止み難/
やみがたk /止み難/
やみがたi /止み難/
やみがたg /止み難/
やみあがr /病み上/
やみあg /病み上/
やまわk /山分/
やまもr /山盛/
やまむk /山向/
やままw /山回/
やまぶかs /山深/
やまぶかk /山深/
やまぶかi /山深/
やまぶかg /山深/
やまびらk /山開/
やまのぼr /山登/
やまづm /山積/
やまぞi /山沿/
やまそだt /山育/
やまごe /山越/
やまくずs /山崩/
やまくずr /山崩/
やまあるk /山歩/
やまs /疚/疾;(字義:体調が悪い)/
やぶれr /殕/
やぶりすt /破り捨/
やぶにらm /藪睨/
やぶさk /吝/
やぶt /破/敗;競争に敗れる/
やぶr /破/敗;競争に敗れる/
やぶn /破/敗;競争に敗れる/
やぶk /破/
やぶi /破/
やぶc /破/敗;競争に敗れる/
やはr /柔/軟/和/矢張/
やはi /柔/
やにさg /脂下/
やどなs /宿無/
やどさがs /宿探/
やどかr /宿借/
やどt /宿/
やどs /宿/
やどr /宿/
やどn /宿/
やどc /宿/
やといいr /雇い入/
やとw /雇/傭;=雇う/
やとu /雇/傭;=雇う/
やとt /雇/傭;=雇う/
やとo /雇/傭;=雇う/
やとi /雇/傭;=雇う/
やとh /雇/傭/
やとe /雇/傭;=雇う/
やとc /雇/傭;=雇う/
やつざk /八つ裂/
やつあたr /八つ当/
やつs /窶/
やつr /窶/
やってのk /遣って退/
やっつk /遣っ付/
やっt /八/漸;-と(終わった)/
やせほそt /痩せ細/
やせほそr /痩せ細/
やせほそn /痩せ細/
やせほそc /痩せ細/
やせおとろe /痩せ衰/
やすものがi /安物買/
やすみあk /休み明/
やすすg /安過/
やすくにどおr /靖国通/
やすうけあi /安請け合/安請合/
やすうr /安売/
やすあがt /安上/
やすあがr /安上/
やすあがn /安上/
やすあがc /安上/
やすあg /安上/
やすu /安/易;(easy) 見易い画面/廉;(cheap) 廉い品/
やすs /安/易;(easy) 見易い画面/廉;(cheap) 廉い品/
やすr /安/
やすp /安/
やすn /休/安/
やすm /休/安/易;(easy) 見易い画面/廉;(cheap) 廉い品/
やすk /安/易;(easy) 見易い画面/廉;(cheap) 廉い品/
やすi /安/易;(easy) 見易い画面/廉;(cheap) 廉い品/
やすg /安/易;(easy) 見易い画面/廉;(cheap) 廉い品/
やじt /野次/
やじr /野次/
やじn /野次/
やじc /野次/
やしなw /養/豢;<rare>/
やしなu /養/豢;<rare>/
やしなt /養/豢;<rare>/
やしなo /養/豢;<rare>/
やしなi /養/豢;<rare>/
やしなh /養/
やしなe /養/豢;<rare>/
やしなc /養/豢;<rare>/
やさしi /優し;※送り位置補正/易し;※送り位置補正/
やさs /優;(gentle)優しい人/易;(easy)易しい問題/
やけのこt /焼け残/
やけのこr /焼け残/
やけのこn /焼け残/
やけのこc /焼け残/
やけただr /焼け爛/
やけしn /焼け死/
やけこg /焼け焦/
やけおt /焼け落/
やけおc /焼け落/
やぐらなg /櫓投/
やくわr /役割/
やくよk /厄除/
やくまわr /役回/
やくひんくさs /薬品臭/
やくひんくさk /薬品臭/
やくひんくさi /薬品臭/
やくひんくさg /薬品臭/
やくばらi /厄払/
やくはらi /厄祓/
やくはらh /厄祓/
やくにたt /役に立/
やくにたc /役に立/
やくづk /役付/
やくだt /役立/
やくだc /役立/
やくたt /役立/
やくそくどおr /約束通/
やくs /訳;(translate) 仏詩を訳す/約;(promise) 再会を約す/扼;(hold) 拠点を扼する/譯;「訳」の旧字/
やくn /役/
やきもどs /焼戻/焼き戻/
やきはらw /焼き払/
やきはらu /焼き払/
やきはらt /焼き払/
やきはらo /焼き払/
やきはらi /焼き払/
やきはらe /焼き払/
やきはらc /焼き払/
やきなまs /焼き鈍/焼鈍/
やきなおs /焼き直/焼直/
やきつくs /焼き尽;劫火が全てを-す/
やきつk /焼き付/焼き尽/焼付/
やきつi /焼き付/焼付/
やきすt /焼き捨/
やきすg /焼き過/
やきしm /焼き締/焼締/
やきころs /焼き殺/
やきこn /焼き込/
やきこm /焼き込/
やききt /焼き切/
やききr /焼き切/
やききn /焼き切/
やききc /焼き切/
やきいr /焼き入/焼入/
やきあg /焼き上/
やがt /軈/
やかまs /喧/
やうやu /漸/
やうやk /漸/
やt /遣;(do)仕事を遣る, (使役)人を遣る/演;(play)『リア王』を演る/殺;(kill)首相を殺る/八;-っつ/
やs /痩/瘠;≒痩せる/
やr /遣;(do)仕事を遣る, (使役)人を遣る/演;(play)『リア王』を演る/殺;(kill)首相を殺る/破;破れ障子/
やn /止/病/遣;(do)仕事を遣る, (使役)人を遣る/演;(play)『リア王』を演る/殺;(kill)首相を殺る/已;≒止む/熄;(字義:火が消える)/
やm /止/辞;仕事を辞める/病/已;≒止む/熄;(字義:火が消える)/罷/辭;「辞」の旧字/
やk /焼/妬;(嫉妬) やきもちを妬く/灼;灼けた砂浜/燒;「焼」の旧字(人名用漢字)/
やi /焼/妬;(嫉妬) やきもちを妬く/燒;「焼」の旧字(人名用漢字)/灼;灼けた砂浜/
やc /遣;(do)仕事を遣る, (使役)人を遣る/演;(play)『リア王』を演る/殺;(kill)首相を殺る/
もんなs /文無/
もんどりうt /翻筋斗打/
もんどりうc /翻筋斗打/
もんぜんばらi /門前払/
もんくなs /文句無/
もろもろn /諸/
もろs /脆/
もろk /脆/
もろi /脆/
もろg /脆/
もれだs /漏れ出/
もれきk /洩れ聞/漏れ聞/
もれきi /洩れ聞/漏れ聞/
もりつk /盛り付/
もりたt /守り立/
もりさg /盛り下/
もりこn /盛り込/
もりこm /盛り込/
もりかえs /盛り返/
もりあわs /盛合/
もりあがt /盛り上/
もりあがr /盛り上/
もりあがn /盛り上/
もりあがc /盛り上/
もりあw /盛り合/
もりあg /盛り上/盛上/
もりs /守/
もらいっぱなs /貰いっ放;いつも-しで/
もらいそこn /貰い損/
もらいうk /貰い受/
もらw /貰/
もらu /貰/
もらt /貰/
もらo /貰/
もらi /貰/
もらe /貰/
もらc /貰/
もよおs /催/
もようがe /模様替/
もよr /最寄/
もよi /催/
もやw /舫/
もやu /舫/
もやt /舫/
もやo /舫/
もやi /舫/
もやe /舫/
もやc /舫/
もみほぐs /揉み解/
もみつぶs /揉み潰/
もみだs /揉み出/
もみこn /揉み込/
もみこm /揉み込/
もみけs /揉み消/もみ消/
もみあw /揉み合/
もみあu /揉み合/
もみあt /揉み合/
もみあo /揉み合/
もみあi /揉み合/
もみあc /揉み合/
ものわびs /物侘/
ものわすr /物忘/
ものやわr /物柔/
ものものs /物々/物物/
ものもうs /物申/
ものもt /物持/
ものもc /物持/
ものめずらs /物珍/
ものみだかs /物見高/
ものみだかk /物見高/
ものみだかi /物見高/
ものみだかg /物見高/
ものほs /物干;-し竿/物欲;-しげな顔/
ものなr /物慣/
ものたr /物足/
ものずk /物好/
ものすごs /物凄/
ものすごk /物凄/
ものすごi /物凄/
ものすごg /物凄/
ものしずk /物静/
ものしr /物知/
ものさびs /物寂/物淋/
ものごi /物乞/
ものぐるo /物狂/
ものぐさs /懶/
ものぐさk /懶/
ものぐさi /懶/
ものぐさg /懶/
ものがなs /物悲/
ものがたt /物語/
ものがたr /物語/
ものがたn /物語/
ものがたc /物語/
ものかk /物書/
ものかi /物書/
ものおもi /物思/
ものおぼe /物覚/
ものおz /物怖/
ものおj /物怖/
ものうs /物憂/懶/
ものうk /物憂/懶/
ものうi /物憂/懶/
ものうg /物憂/懶/
ものいw /物言/
ものいu /物言/
ものいr /物入/
ものいi /物言/
ものいe /物言/
ものs /物;本を物す/
もぬk /蛻/
もどってこz /戻って来/
もどってこy /戻って来/
もどってこs /戻って来/
もどってこr /戻って来/
もどってこn /戻って来/
もどってこi /戻って来/
もどってくr /戻って来/
もどってくn /戻って来/
もどってきy /戻って来/
もどってきt /戻って来/
もどってきs /戻って来/
もどってきn /戻って来/
もどってきm /戻って来/
もどってきd /戻って来/
もどってきc /戻って来/
もどt /戻/
もどs /戻/
もどr /戻/
もどn /戻/
もどk /擬/
もどc /戻/
もとめあw /求め合/
もとめあu /求め合/
もとめあt /求め合/
もとめあo /求め合/
もとめあi /求め合/
もとめあe /求め合/
もとめあc /求め合/
もとどおr /元通/
もとづk /基/
もとづi /基/
もとうr /元売/
もとz /基;?/
もとt /悖/戻;=悖る/基;base.「実体験を-にする」/
もとr /悖/戻;=悖る/
もとn /元/基/悖/戻;=悖る/求/許;手の届く範囲。「親の-」/下;≒許 「白日の-」/
もとm /求/
もとk /元/
もとh /許;手の届く範囲。「親の-」/
もとd /基;-づく/下;-で/元/許;手の届く範囲。「親の-」/
もとc /悖/戻;=悖る/
もてはやs /持て囃/持て栄/
もてなs /持て成/
もてあまs /持て余/
もてあそn /弄/玩;=弄ぶ/翫;=弄ぶ/
もてあそb /弄/玩;=弄ぶ/翫;=弄ぶ/
もつれこn /縺れ込/
もつれこm /縺れ込/
もつれあw /縺れ合/
もつれあu /縺れ合/
もつれあt /縺れ合/
もつれあo /縺れ合/
もつれあi /縺れ合/
もつれあe /縺れ合/
もつれあc /縺れ合/
もつr /縺/
もっぱr /専/專;「専」の旧字(人名用漢字)/
もっとm /最;(most)/尤;(reasonable)「それも-もだ」 (接続詞)「-も、異論もある」/
もってまわt /持って回/
もってまわr /持って回/
もってまわn /持って回/
もってまわc /持って回/
もってこz /持って来/
もってこy /持って来/
もってこs /持って来/
もってこr /持って来/
もってこn /持って来/
もってこi /持って来/
もってくr /持って来/
もってくn /持って来/
もってきy /持って来/
もってきt /持って来/
もってきs /持って来/
もってきn /持って来/
もってきm /持って来/
もってきd /持って来/
もってきc /持って来/
もってかえt /持って帰/
もってかえr /持って帰/
もってかえn /持って帰/
もってかえc /持って帰/
もっていt /持って行/
もっていk /持って行/
もっていc /持って行/
もったいぶt /勿体振/
もったいぶr /勿体振/
もったいぶn /勿体振/
もったいぶc /勿体振/
もったいなs /勿体無/
もったいなk /勿体無/
もったいなi /勿体無/
もったいなg /勿体無/
もっt /以/
もぢr /捩/
もちよt /持ち寄/
もちよr /持ち寄/
もちよn /持ち寄/
もちよc /持ち寄/
もちまわt /持ち回/持回/
もちまわr /持ち回/持回/
もちまわn /持ち回/持回/
もちまわc /持ち回/持回/
もちはこn /持ち運/
もちはこb /持ち運/
もちにg /持逃/持ち逃/
もちなおs /持ち直/
もちつづk /持ち続/
もちだs /持ち出/持出/
もちさt /持ち去/
もちさr /持ち去/
もちさn /持ち去/
もちさc /持ち去/
もちこたe /持ち堪/
もちこs /持ち越/持越/
もちこn /持ち込/持込/
もちこm /持ち込/持込/
もちぐさr /持ち腐/
もちくずs /持ち崩/
もちきr /持ち切/
もちかえt /持ち帰/
もちかえr /持ち帰/
もちかえn /持ち帰/
もちかえc /持ち帰/
もちかk /持ち掛/
もちかe /持ち替/
もちいt /用い;※送り位置補正/
もちあわs /持ち合/持合/
もちあるk /持ち歩/
もちあるi /持ち歩/
もちあw /持ち合/
もちあu /持ち合/
もちあt /持ち合/
もちあo /持ち合/
もちあi /持ち合/持合/
もちあg /持ち上/
もちあc /持ち合/
もちw /用;-ゐる/
もちi /用/
もだs /黙/
もだe /悶/
もたれあw /凭れ合/
もたれあu /凭れ合/
もたれあt /凭れ合/
もたれあo /凭れ合/
もたれあi /凭れ合/
もたれあe /凭れ合/
もたれあc /凭れ合/
もたらs /齎/
もたr /凭/靠;≒凭れる/
もたg /擡/
もじまちがi /文字間違/
もじばk /文字化/
もじどおr /文字通/
もじおt /文字落/
もじt /捩/
もじr /捩/
もじn /捩/
もじc /捩/
もしm /若し;※送り位置補正/
もしk /若し;※送り位置補正/
もぐりこn /潜り込/
もぐりこm /潜り込/
もぐt /潜/潛;旧字1/濳;旧字2/
もぐr /潜/潛;旧字1/濳;旧字2/
もぐn /潜/潛;旧字1/濳;旧字2/
もぐc /潜/潛;旧字1/濳;旧字2/
もくろn /目論/
もくろm /目論/
もくs /黙/目/
もぎとt /もぎ取/
もぎとr /もぎ取/
もぎとn /もぎ取/
もぎとc /もぎ取/
もがr /虎落/強請/
もがk /藻掻/
もがi /藻掻/
もえひろg /燃え広/
もえでz /萌え出/
もえでy /萌え出/
もえでt /萌え出/
もえでs /萌え出/
もえでr /萌え出/
もえでn /萌え出/
もえでm /萌え出/
もえでc /萌え出/
もえつk /燃え尽/
もえだs /燃え出/萌え出/
もえたぎt /燃え滾/
もえたぎr /燃え滾/
もえたぎn /燃え滾/
もえたぎc /燃え滾/
もえたt /燃え立/萌え立;萌え立つ緑/
もえたc /燃え立/萌え立;萌え立つ緑/
もえさかt /燃え盛/
もえさかr /燃え盛/
もえさかn /燃え盛/
もえさかc /燃え盛/
もえうつt /燃え移/
もえうつr /燃え移/
もえうつn /燃え移/
もえうつc /燃え移/
もえいd /萌え出/
もえあg /燃え上/
もうしわたs /申し渡/
もうしわけなs /申し訳無/
もうしわけなk /申し訳無/
もうしわけなi /申し訳無/
もうしわk /申し分/
もうしぶんなs /申し分無/
もうしぶんなk /申し分無/
もうしぶんなi /申し分無/
もうしひらk /申し開/
もうしひらi /申し開/
もうしのb /申し述/
もうしでz /申し出/
もうしでy /申し出/
もうしでt /申し出/
もうしでs /申し出/
もうしでr /申し出/
もうしでn /申し出/
もうしでm /申し出/
もうしでc /申し出/
もうしつたe /申し伝/申伝/
もうしつk /申し付/
もうしたt /申し立/申立/
もうしそe /申し添/
もうしこs /申し越/
もうしこn /申し込/申込/
もうしこm /申し込/申込/
もうしかn /申し兼/
もうしおくt /申し送;-り事項/申送/
もうしおくr /申し遅;-れました/申し送;-り事項/申送/
もうしおくn /申し送;-り事項/申送/
もうしおくc /申し送;-り事項/申送/
もうしうk /申し受/
もうしいr /申し入/申入/
もうしあわs /申し合/
もうしあw /申し合/
もうしあg /申し上/
もうs /申/
もうk /設/儲/
もうd /詣/
もy /燃/萌/萠;「萌」の異体字(人名用漢字)/
もt /持/盛/以/保;(維持) 体が保たない NB:「たもt」と同形/漏;(字義:雨がもれる)/洩;(字義:尾を引いて少しずつもれる)/
もs /若/燃/模/
もr /盛/漏;(字義:雨がもれる)/洩;(字義:尾を引いて少しずつもれる)/守;子-り/
もn /揉/盛/漏;(字義:雨がもれる)/洩;(字義:尾を引いて少しずつもれる)/
もm /揉/
もe /燃/萌;(sprout) 芽が萌える/萠;「萌」の異体字(人名用漢字)/
もc /持/保;(維持) 体が保たない NB:「たもt」と同形/盛/漏;(字義:雨がもれる)/洩;(字義:尾を引いて少しずつもれる)/
めんぼくなs /面目無/
めんぼくなk /面目無/
めんぼくなi /面目無/
めんばs /面罵/
めんどくさs /面倒臭/
めんどくさk /面倒臭/
めんどくさi /面倒臭/
めんどくさg /面倒臭/
めんどうくさs /面倒臭/
めんどうくさk /面倒臭/
めんどうくさi /面倒臭/
めんどうくさg /面倒臭/
めんくらw /面喰/
めんくらu /面喰/
めんくらt /面喰/
めんくらo /面喰/
めんくらi /面喰/
めんくらe /面喰/
めんくらc /面喰/
めんくr /面喰/面食/
めんくi /面食/
めんきょとr /免許取/
めんz /免/
めんs /面/
めんj /免/
めりこn /めり込/減り込/
めりこm /減り込/めり込/
めもt /メモ/
めもr /メモ/
めもn /メモ/
めもc /メモ/
めめs /女々/女女/
めまぐるs /目紛/
めべr /目減/
めぶk /芽吹/
めぶi /芽吹/
めばr /目張/
めばe /芽生/
めぬきどおr /目抜き通/
めぬk /目抜/
めどおs /目通/
めとt /娶/
めとr /娶/
めとn /娶/
めとc /娶/
めでたs /目出度/
めでたk /目出度/
めでたi /目出度/
めでたg /目出度/
めでt /目出/
めづらs /珍;旧仮名/珎;旧仮名,「珍」の異体字/
めづm /目詰/
めつk /目付/眼付/
めったうt /滅多打;(当て字)/メッタ打/
めったn /滅多;(当て字)/
めっs /滅/
めだt /目立/
めだc /目立/
めずらs /珍/珎;「珍」の異体字/
めじろどおr /目白通/
めじろおs /目白押/
めしはなt /召し放/
めしはなc /召し放/
めしとt /召し捕;捕縛する/召し取;[文語]呼び寄せる/
めしとr /召し捕;捕縛する/召し取;[文語]呼び寄せる/
めしとn /召し捕;捕縛する/召し取;[文語]呼び寄せる/
めしとc /召し捕;捕縛する/召し取;[文語]呼び寄せる/
めしつかw /召し使/
めしつかu /召し使/
めしつかt /召し使/
めしつかo /召し使/
めしつかi /召し使/
めしつかe /召し使/
めしつかc /召し使/
めしだs /召し出/
めしかかe /召し抱/
めしいr /召し入/
めしあg /召し上/
めしi /盲/
めざわr /目障/
めざまs /目覚/
めざとs /目敏/
めざとk /目敏/
めざとi /目敏/
めざとg /目敏/
めざs /目指/目刺;メザシ/
めざm /目覚/目醒/
めぐろどおr /目黒通/
めぐりめぐt /巡り巡/
めぐりあw /巡り合;-わせ/巡り会/回り合/巡り逢/
めぐりあu /巡り会/巡り合/巡り逢/
めぐりあt /巡り会/巡り合/巡り逢/
めぐりあo /巡り会/巡り合/巡り逢/
めぐりあi /巡り会/巡り合/巡り逢/
めぐりあe /巡り会/巡り合/巡り逢/
めぐりあc /巡り会/巡り合/巡り逢/
めぐt /巡/廻/回/繞/繚/
めぐs /愛;[文語]「-し乙女舞い出でつ」/
めぐr /巡/廻/回/繞/繚/
めぐn /恵/惠;「恵」の旧字(人名用漢字)/巡/廻/回/繞/繚/萌;(芽生える) =芽ぐむ/
めぐm /恵/萌;(芽生える) =芽ぐむ/惠;「恵」の旧字(人名用漢字)/
めぐk /愛;[文語]「-し乙女舞い出でつ」/
めぐc /巡/廻/回/繞/繚/
めくれあg /捲れ上/
めくるめk /目眩/
めくるめi /目眩/
めくらまs /目眩/
めくらうt /盲打/
めくらm /目眩/
めくばs /目配/
めくばr /目配/
めくt /捲/
めくr /捲/
めくn /捲/
めくc /捲/
めきk /目利/
めがk /目掛/
めかしこn /粧し込/
めかしこm /粧し込/
めかくs /目隠/
めかs /粧;お粧し/
めおs /目押/
めうつr /目移/
めいわくかk /迷惑掛/
めいじどおr /明治通/
めいきゅういr /迷宮入/
めいうt /銘打/
めいうc /銘打/
めいz /命;(order) 出張を命ずる/銘;(inscript) 肝に銘ずる/
めいt /滅入/
めいs /瞑;以て瞑すべし(=安心して死になさい)/
めいr /滅入/
めいn /滅入/
めいj /命;(order)/銘;(inscript) 肝に銘じる/
めいc /滅入/
めあわs /娶/
めあたらs /目新/
めあw /妻合/
めあt /目当/
めあk /目明/
めs /召/
めr /減/
めn /目/
めg /芽/
めd /愛/賞/目/
めb /目/
むりじi /無理強/
むりp /無理/
むりn /無理/
むらなk /ムラ無/
むらg /群/叢/簇/
むねんg /無念/
むねやk /胸焼/
むねあg /棟上/
むにきs /無に帰/
むなさわg /胸騒/
むなs /虚/空/
むとどk /無届/
むづかt /憤;旧仮名/
むづかs /難/
むづかr /憤/
むづかn /憤;旧仮名/
むづかc /憤;旧仮名/
むつみあw /睦み合/
むつみあu /睦み合/
むつみあt /睦み合/
むつみあo /睦み合/
むつみあi /睦み合/
むつみあc /睦み合/
むつかs /難/
むつn /睦/
むつm /睦/
むつb /睦/
むっt /六/
むちうt /鞭打/鞭/
むちうc /鞭打/鞭/
むだなk /無駄無/
むだづかi /無駄遣/無駄使/
むだn /無駄/
むだd /無駄/
むせびなk /咽び泣/噎び泣/
むせびなi /咽び泣/噎び泣/
むせかえt /噎せ返/噎返/蒸返/
むせかえr /噎せ返/噎返/
むせかえn /噎せ返/噎返/蒸返/
むせかえc /噎せ返/噎返/蒸返/
むせp /咽/
むせn /咽/噎/
むせb /咽/噎/
むずがゆs /むず痒/
むずがゆk /むず痒/
むずがゆi /むず痒/
むずがゆg /むず痒/
むずかt /憤/
むずかs /難/
むずかr /憤/
むずかn /憤/
むずかc /憤/
むすびなおs /結び直/
むすびつk /結び付/
むすびつi /結び付/
むすn /結/掬;(手ですくう)「水を掬ぶ」/
むすb /結/掬;(手ですくう)「水を掬ぶ」/
むしりとt /毟り取/
むしりとr /毟り取/
むしりとn /毟り取/
むしりとc /毟り取/
むしよk /虫除/
むしゃぶりつk /武者振り付/
むしゃぶりつi /武者振り付/
むしゃぶr /武者振/
むしぼs /虫干/
むしふうj /虫封/
むしばn /蝕/蠹/蠧;「蠹」の異体字/
むしばm /蝕/蠹/蠧;「蠹」の異体字/
むしとr /虫取/
むしくi /虫食/
むしかえs /蒸し返/
むしあつs /蒸し暑/
むしあつk /蒸し暑/
むしあつi /蒸し暑/
むしあつg /蒸し暑/
むしt /毟;毛羽を-/
むしs /無視/
むしr /寧;(rather) -ろ/毟;毛羽を-/
むしn /毟;毛羽を-/
むしc /毟;毛羽を-/
むさぼりよn /貪り読/
むさぼりよm /貪り読/
むさぼりくw /貪り食/貪り喰/
むさぼりくu /貪り食/貪り喰/
むさぼりくt /貪り食/貪り喰/
むさぼりくo /貪り食/貪り喰/
むさぼりくi /貪り食/貪り喰/
むさぼりくe /貪り食/貪り喰/
むさぼりくc /貪り食/貪り喰/
むさぼt /貪/
むさぼr /貪/
むさぼn /貪/
むさぼc /貪/
むさくるs /むさ苦/
むごt /惨/酷/
むごs /惨/酷;NB:「ひどi」と同形/
むごk /惨/酷;NB:「ひどi」と同形/
むごi /惨/酷;NB:「ひどi」と同形/
むごg /惨/酷;NB:「ひどi」と同形/
むこu /向/向こ;※送り位置補正/
むけなおs /向け直/
むくw /報/酬/
むくu /報/酬/
むくt /報/酬/
むくr /剥/
むくo /報/酬/
むくn /浮腫/
むくm /浮腫/
むくi /報;(原義:罪人への罰)/酬;(原義:酒を勧める)/
むくe /報/酬/
むくc /報/酬/
むきなおt /向き直/
むきなおr /向き直/
むきなおn /向き直/
むきなおc /向き直/
むきとt /剥き取/
むきとr /剥き取/
むきとn /剥き取/
むきとc /剥き取/
むきだs /剥き出/
むきあw /向き合/
むきあu /向き合/
むきあt /向き合/
むきあo /向き合/
むきあi /向き合/
むきあe /向き合/
むきあc /向き合/
むかしなつk /昔懐/
むかしきk /昔聞/
むかしきi /昔聞/
むかえとt /迎え取/
むかえとr /迎え取/
むかえとn /迎え取/
むかえとc /迎え取/
むかえうt /迎え撃/
むかえうc /迎え撃/
むかえいr /迎え入/
むかいあw /向かい合/向い合/
むかいあu /向かい合/向い合/
むかいあt /向かい合/向い合/
むかいあo /向かい合/向い合/
むかいあi /向かい合/向い合/
むかいあe /向かい合/向い合/
むかいあc /向かい合/向い合/
むかw /向/対/
むかu /向/対/
むかt /向/対/
むかo /向/対/
むかi /向/向か;※送り位置補正/対/
むかh /迎/対/邀/
むかe /迎/邀;<rare>(待ち受ける)/向/対/
むかc /向/対/
むt /六/
むs /蒸/咽;煙に咽せる/噎;=咽せる/
むr /群/蒸/
むk /向/剥/
むi /向/剥/
みわたs /見渡/
みわすr /見忘/
みわk /見分/
みれんt /未練/
みれんg /未練/
みよr /身寄/
みょうs /妙/
みょうn /妙/
みょうd /妙/
みやまいr /宮参/
みやぶt /見破/
みやぶr /見破/
みやぶn /見破/
みやぶc /見破/
みやびy /雅/
みやびs /雅/
みやびn /雅/
みやびd /雅/
みやづかe /宮仕/
みやすs /見易/
みやすk /見易/
みやすi /見易/
みやすg /見易/
みやこおt /都落/
みやt /見遣/
みやr /見遣/
みやn /見遣/
みやc /見遣/
みやb /雅/
みゃくうt /脈打/脈搏/
みゃくうc /脈打/脈搏/
みもだe /身悶/
みもt /身持/
みめよs /見目好/
みめよk /見目好/
みめよi /見目好/
みめよg /見目好/
みめうるわs /見目麗/
みむk /見向/
みむi /見向/
みみよr /耳寄/
みみなr /耳慣;-れない/耳鳴;-り/耳馴;≒耳慣れない/
みみざわr /耳障/
みみざとs /耳聡/
みみざとk /耳聡/
みみざとi /耳聡/
みみざとg /耳聡/
みみかk /耳掻/
みみうt /耳打/
みみあたらs /耳新/
みまわt /見回/
みまわs /見回/
みまわr /見回/
みまわn /見回/
みまわc /見回/
みまもt /見守/
みまもr /見守/
みまもn /見守/
みまもc /見守/
みまちがw /見間違/
みまちがu /見間違/
みまちがt /見間違/
みまちがo /見間違/
みまちがi /見間違/
みまちがe /見間違/
みまちがc /見間違/
みまがw /見紛/
みまがu /見紛/
みまがt /見紛/
みまがo /見紛/
みまがi /見紛/
みまがe /見紛/
みまがc /見紛/
みまかt /身罷/薨/
みまかr /身罷/薨/
みまかn /身罷/薨/
みまかc /身罷/薨/
みまw /見舞/
みまu /見舞/
みまt /見舞/
みまo /見舞/
みまi /見舞/
みまh /見舞/
みまe /見舞/
みまc /見舞/
みぶるi /身震/
みぶr /身振/
みひらk /見開/
みひらi /見開/
みばe /見栄/見映/
みはるk /見霽/
みはらs /見晴/
みはらi /未払/
みはなs /見放/
みはっt /見張/
みはじm /見始/観始/
みはからi /見計/
みはかr /見計/
みはt /見張;-って/見果;-てぬ夢/瞠;目を瞠る妙技/
みはr /見張;-り番/見晴;-らし/瞠;目を瞠る妙技/
みはn /見張;-り番/瞠;目を瞠る妙技/
みはc /見張;-り番/瞠;目を瞠る妙技/
みのまわr /身の回/
みのこs /見残/
みのがs /見逃/
みのt /実/稔;(esp.穀物) 稲穂が稔る/
みのr /実/稔;(esp.穀物) 稲穂が稔る/
みのn /実/稔;(esp.穀物) 稲穂が稔る/
みのg /見逃/
みのc /実/稔;(esp.穀物) 稲穂が稔る/
みねうt /峰打/
みぬk /見抜/
みぬi /見抜/
みにつk /身に付/
みにつi /身に付/
みにくs /醜;(ugly) 醜い根性/見難;(hard to see) 見難い表示/儖;<rare> ≒醜い/
みにくk /醜;(ugly) 醜い根性/見難;(hard to see) 見難い表示/儖;<rare> ≒醜い/
みにくi /醜;(ugly) 醜い根性/見難;(hard to see) 見難い表示/儖;<rare> ≒醜い/
みにくg /醜;(ugly) 醜い根性/見難;(hard to see) 見難い表示/儖;<rare> ≒醜い/
みにいt /見に行/
みにいk /見に行/
みにいc /見に行/
みならw /見習/見倣/
みならu /見習/見倣/
みならt /見習/見倣/
みならo /見習/見倣/
みならi /見習/見倣/
みならe /見習/見倣/
みならc /見習/見倣/
みなみむk /南向/
みなごろs /皆殺/
みなぎt /漲/
みなぎr /漲/
みなぎn /漲/
みなぎc /漲/
みなおなz /皆同/
みなおなj /皆同/
みなおs /見直/
みなs /見做/看做/皆;-さん/
みなr /見慣/見馴/
みなg /身投/
みとめがたs /認め難/
みとめがたk /認め難/
みとめがたi /認め難/
みとめがたg /認め難/
みとめあw /認め合/
みとめあu /認め合/
みとめあt /認め合/
みとめあo /認め合/
みとめあi /認め合/
みとめあe /認め合/
みとめあc /認め合/
みとどk /見届/
みとがm /見咎/
みとおs /見通/
みとうs /見透/見通;※仮名遣い「みとお-す」/
みとt /看取;最期を看取る/見取;見取り図/
みとr /看取;最期を看取る/見惚;-れる/見取;見取り図/見蕩;≒見惚れる/
みとn /看取;最期を看取る/見取;見取り図/
みとm /認/
みとc /看取;最期を看取る/見取;見取り図/
みてとt /見て取/
みてとr /見て取/
みてとn /見て取/
みてとc /見て取/
みてこz /見て来/
みてこy /見て来/
みてこs /見て来/
みてこr /見て来/
みてこn /見て来/
みてこi /見て来/
みてくr /見て来/見て呉/
みてくn /見て来/
みてきy /見て来/
みてきt /見て来/
みてきs /見て来/
みてきn /見て来/
みてきm /見て来/
みてきd /見て来/
みてきc /見て来/
みていt /見て行/
みていk /見て行/
みていc /見て行/
みづらs /見辛/
みづらk /見辛/
みづらi /見辛/
みづらg /見辛/
みづくろi /身繕/
みづかr /自/
みつもt /見積/
みつもr /見積/
みつもn /見積/
みつもc /見積/
みつめなおs /見つめ直/見詰め直/
みつめあw /見つめ合/見詰め合/
みつめあu /見つめ合/見詰め合/
みつめあt /見つめ合/見詰め合/
みつめあo /見つめ合/見詰め合/
みつめあi /見つめ合/見詰め合/
みつめあe /見つめ合/見詰め合/
みつめあc /見つめ合/見詰め合/
みつづk /見続/
みつぞろi /三つ揃/
みつけだs /見つけ出/見付け出/
みつくろw /見繕/
みつくろu /見繕/
みつくろt /見繕/
みつくろo /見繕/
みつくろi /見繕/
みつくろh /見繕/
みつくろe /見繕/
みつくろc /見繕/
みつくs /見尽/
みつかr /見付か;※送り位置補正/
みつs /密/
みつn /密/
みつm /見積;-もる/見詰;-める/凝視;当て字,=見詰める/瞶;=見詰める/
みつk /見付/
みつi /貢/
みつg /貢/
みつd /密/
みっt /三/
みぢかn /身近/
みちゆk /道行/
みちむk /道向/
みちみt /満ち満;(夢と希望に)-ちて/
みちびきだs /導き出/
みちびk /導/
みちびi /導/
みちづr /道連/
みちたr /満ち足/
みちがw /見違/
みちがu /見違/
みちがt /見違/
みちがo /見違/
みちがi /見違/
みちがe /見違/
みちがc /見違/
みちあふr /満ち溢/
みだれとn /乱れ飛/
みだれとb /乱れ飛/
みだれうt /乱れ打/
みだしなm /身嗜/
みだs /乱/見出/紊;≒乱す 「風紀を紊す」/亂;「乱」の旧字/
みだr /乱/淫;-ら/猥;-ら,-りに/妄;-りに/濫;-りに/紊;風紀の紊れ/亂;「乱」の旧字/
みたt /見立/
みたs /満/充/
みそんj /見損/
みそづk /味噌漬/
みそこn /見損/
みそいたm /味噌炒/
みそr /見逸/
みそm /見初/
みそi /禊/
みそg /禊/
みせびらk /店開/
みせつk /見せ付/
みせじまi /店仕舞/
みせがまe /店構/
みせかk /見せ掛/
みせあw /見せ合/
みせあu /見せ合/
みせあt /見せ合/
みせあo /見せ合/
みせあi /見せ合/
みせあe /見せ合/
みせあc /見せ合/
みずわr /水割/
みずもr /水漏/
みずみずs /瑞々/瑞瑞/水々;=瑞々しい/水水/
みずまわr /水回/
みずまs /水増/
みずまk /水撒/
みずぶとr /水太/
みずびたs /水浸/
みずはk /水捌/
みずだs /水出/
みずたまr /水溜/
みずたk /水炊/
みずぜm /水攻;城の水攻め/水責;拷問./
みずくさs /水臭/
みずくさk /水臭/
みずくさi /水臭/
みずくさg /水臭/
みずきr /水切/
みずがr /水涸/
みずかr /自/
みずいr /水入/
みずあらi /水洗/
みずあそb /水遊/
みずあかとr /水垢取/
みずあg /水揚/
みずあb /水浴/
みずp /水/
みすぼr /見窄/
みすごs /見過/
みすかs /見透/
みすt /見捨/見棄/ミス;[口]-って/
みすr /ミス/
みすn /ミス/
みすk /見透/
みすg /見過/
みすe /見据/視据;<rare>/
みすc /ミス/
みじんぎr /微塵切/
みじろi /身動/
みじろg /身動/
みじかすg /短過/
みじかs /短/身近/
みじかn /身近/
みじかm /短/
みじかk /短/身近/
みじかi /短/身近/
みじかg /短/身近/
みじm /惨/慘;「惨」の旧字/
みじk /短;非正則(みじかi)/
みしりおk /見知り置;お-きを/
みしりおi /見知り置;お-きを/
みしt /見知/
みしr /見知/
みしn /見知/
みしc /見知/
みさだm /見定/
みさげはt /見下げ果/
みさg /見下/
みごろs /見殺/
みごもt /身籠/妊/
みごもr /身籠/妊/
みごもn /身籠/妊/
みごもc /身籠/妊/
みごたe /見応/
みごしらe /身拵/
みこs /見越/
みこn /見込/
みこm /見込/
みぐるs /見苦/
みくらb /見比/見較/
みくだs /見下/
みぎまわr /右回/
みぎどなr /右隣/
みぎぞろe /右揃/
みぎそろe /右揃/
みぎきk /右利/
みぎがk /右書/
みぎs /右/
みきわm /見極/
みきt /見切/
みきr /見切/
みきn /見切/
みきk /見聞/
みきc /見切/
みがわr /身代/
みがまe /身構/
みがたm /身固/
みがきぬk /磨き抜/
みがきぬi /磨き抜/
みがきたt /磨き立/
みがきあg /磨き上/
みがk /磨/研;(技を)-く/
みがi /磨/研;(技を)-く/
みかわs /見交/
みかぎt /見限/
みかぎr /見限/
みかぎn /見限/
みかぎc /見限/
みかえt /見返/
みかえs /見返/
みかえr /見返/
みかえn /見返/
みかえc /見返/
みかw /見交/
みかn /見兼/
みかk /見掛/
みおわt /見終/
みおわr /見終/
みおわn /見終/
みおわc /見終/
みおぼe /見覚/
みおとs /見落/
みおとr /見劣/
みおくt /見送/
みおくr /見送/
みおくn /見送/
みおくc /見送/
みおw /見終/
みおt /見落/
みおr /見下/
みおe /見終/観終/
みえみe /見え見/
みえっぱr /見栄っ張/
みえすk /見え透/
みえすi /見え透/
みえかくr /見え隠/
みうしなw /見失/
みうしなu /見失/
みうしなt /見失/
みうしなo /見失/
みうしなi /見失/
みうしなe /見失/
みうしなc /見失/
みうごk /身動/
みうr /身売/
みうk /見受/
みいだs /見出/
みいt /見入;(gaze) 思わず見入る/魅入;(charm,主に受け身で) 音楽に魅入られる/
みいr /見入;(gaze) 思わず見入る/魅入;(charm,主に受け身で) 音楽に魅入られる/実入;(income) 実入りが少ない/
みいn /見入;(gaze) 思わず見入る/魅入;(charm,主に受け身で) 音楽に魅入られる/
みいc /見入;(gaze) 思わず見入る/魅入;(charm,主に受け身で) 音楽に魅入られる/
みあわs /見合/
みあやまt /見誤/
みあやまr /見誤/
みあやまn /見誤/
みあやまc /見誤/
みあたt /見当/
みあたr /見当/
みあたn /見当/
みあたc /見当/
みあw /見合/
みあu /見合/
みあt /見当/見合/
みあo /見合/
みあk /見飽/
みあi /見合/
みあg /見上/
みあe /見合/
みあc /見合/
みz /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みy /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みw /見/身/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みu /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みt /満;(字義:容器を一杯にする)/充;(字義:肉付きが良い)/見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/盈;(≒満ちる) 月盈つれば欠く/三/滿;旧字/觀;「観」の旧字/
みs /見/魅;(attract)/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みr /見/観;(字義:みわたす)/視;(字義:じっとみる)/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みp /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みo /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みn /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/看;(nurse) 病母を看る/身/診;(diagnose) 患者を診る/觀;「観」の旧字/
みm /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みk /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みj /身/見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みi /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みh /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みg /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みe /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みd /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みc /見/満/滿;旧字/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みb /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
みa /見/観;(字義:みわたす) 映画を-/視;(字義:じっとみる) TVを-/診;(diagnose) 患者を診る/看;(nurse) 病母を看る/觀;「観」の旧字/
まんまるs /真ん丸/
まんまるn /真ん丸/
まんまるk /真ん丸/
まんまるi /真ん丸/
まんまるd /真ん丸/
まんがかk /漫画描/
まんz /慢/
まんj /慢/
まゐr /參/
まわりもt /回り持/
まわりまわt /回り回/
まわりこn /回り込/
まわりこm /回り込/
まわしいr /回し入/
まわt /回/廻/周;(取り巻いて)「家の周り」/囘;「回」の旧字/巡;NB:「めぐr」と同形/
まわs /回/廻/周/囘;「回」の旧字/
まわr /回/周;(取り巻いて)「家の周り」/廻/巡;NB:「めぐr」と同形/囘;「回」の旧字/
まわn /回/周;(取り巻いて)「家の周り」/廻/巡;NB:「めぐr」と同形/囘;「回」の旧字/
まわc /回/周;(取り巻いて)「家の周り」/廻/巡;NB:「めぐr」と同形/囘;「回」の旧字/
まろy /円/
まろn /転/
まろm /円;-み/丸;-み/
まろb /転/
まれs /稀/希/
まれn /稀/希/
まれd /稀/希/
まるやk /丸焼/
まるもうk /丸儲/
まるめこn /丸め込/
まるめこm /丸め込/
まるみe /丸見/
まるなg /丸投/
まるだs /丸出/
まるがかe /丸抱/
まるがr /丸刈/
まるかじr /丸齧/
まるうつs /丸写/
まるあらi /丸洗/
まるs /丸/円/圓;「円」の旧字(人名用漢字)/槫;<rare>/
まるm /丸/円/圓;「円」の旧字(人名用漢字)/槫;<rare>/
まるk /丸/円/圓;「円」の旧字(人名用漢字)/槫;<rare>/
まるi /丸/円/圓;「円」の旧字(人名用漢字)/槫;<rare>/
まよいこn /迷い込/
まよいこm /迷い込/
まよw /迷/
まよu /迷/紕;広辞苑に掲載されています/
まよt /迷/
まよo /迷/
まよk /魔除/
まよi /迷/
まよh /迷/
まよe /迷/
まよc /迷/
まやかs /瞞/
まもりぬk /守り抜/
まもりぬi /守り抜/
まもりとおs /守り通/
まもりつづk /守り続/
まもなs /間も無/
まもなk /間も無/
まもなi /間も無/
まもなg /間も無/
まもt /守;(字義:取られぬようまもる)/護;(字義:傷付かぬようまもる)/防;<rare>(字義:来るものを抑える)/
まもr /守;(字義:取られぬようまもる)/護;(字義:傷付かぬようまもる)/防;<rare>(字義:来るものを抑える)/
まもn /守;(字義:取られぬようまもる)/護;(字義:傷付かぬようまもる)/防;<rare>(字義:来るものを抑える)/
まもc /守;(字義:取られぬようまもる)/護;(字義:傷付かぬようまもる)/防;<rare>(字義:来るものを抑える)/
まめy /忠実;忠実やかな/
まむk /真向/
まみr /塗/
まみe /見/
ままn /儘/
まほうつかi /魔法使/
まぶs /眩/塗/
まびk /間引/
まびi /間引/
まばらs /疎/
まばらn /疎/
まばらd /疎/
まばゆs /目映/眩/
まばゆk /目映/眩/
まばゆi /目映/眩/
まばゆg /目映/眩/
まばたk /瞬/
まばたi /瞬/
まばr /疎/
まはs /回/廻/
まのあt /目の当/
まのb /間延/
まねきよs /招き寄/
まねきいr /招き入/
まねz /真似/
まねy /真似/
まねt /真似/
まねs /真似/
まねr /真似/
まねn /真似/
まねm /真似/
まねk /招/真似/
まねi /招/
まねc /真似/
まねb /学/
まねa /真似/
まぬがr /免/
まぬかr /免/
まぬk /間抜/
まにうk /真に受/
まにあわs /間に合/
まにあw /間に合/
まにあu /間に合/
まにあt /間に合/
まにあo /間に合/
まにあi /間に合/
まにあe /間に合/
まにあc /間に合/
まなざs /眼差/目差/
まなn /学/學;「学」の旧字/斈;「学」の異体字/
まなb /学/學;「学」の旧字/斈;「学」の異体字/
まどろn /微睡/
まどろm /微睡/
まどがk /窓掛/
まどかk /窓掛/
まどw /惑/悗;<rare> 現を抜かす/
まどu /惑/悗;<rare> 現を抜かす/
まどt /惑/悗;<rare> 現を抜かす/
まどr /間取/
まどo /惑/悗;<rare> 現を抜かす/
まどk /円/
まどi /惑/悗;<rare> 現を抜かす/
まどh /惑/
まどe /惑/悗;<rare> 現を抜かす/
まどc /惑/悗;<rare> 現を抜かす/
まとわりつk /纏わり付/
まとわりつi /纏わり付/
まとめがi /まとめ買/
まとはずr /的外/
まといつk /纏い付/
まといつi /纏い付/
まとw /纏/繚;<rare>/
まとu /纏/繚;<rare>/
まとt /纏/繚;<rare>/
まとo /纏/繚;<rare>/
まとm /纏/纒;異体字/
まとi /纏/繚;<rare>/
まとh /纏/
まとe /纏/繚;<rare>/
まとc /纏/繚;<rare>/
まづs /不味/
まづk /不味/
まづi /不味/
まづg /不味/
まつりあg /祭り上/
まつまえづk /松前漬/
まつかざr /松飾/
まつw /纏/
まつt /祭/奉;(謙譲) NB:「たてまつr」と同形/祀;(worship) 先祖を祀る/纏;纏り縫い/
まつr /祭/祀;(worship) 先祖を祀る/奉;(謙譲) NB:「たてまつr」と同形/纏;纏り縫い/
まつn /祭/祀;(worship) 先祖を祀る/奉;(謙譲) NB:「たてまつr」と同形/纏;纏り縫い/
まつh /纏/
まつc /祭/祀;(worship) 先祖を祀る/奉;(謙譲) NB:「たてまつr」と同形/纏;纏り縫い/
まっぷたt /真っ二/
まっとu /全/
まったいr /真っ平/
まったs /全/
まったk /全/
まっすg /真っ直/
まっしろs /真っ白/
まっしろk /真っ白/
まっしろi /真っ白/
まっしろg /真っ白/
まっさかr /真っ盛/
まっこうくさs /抹香臭/
まっこうくさk /抹香臭/
まっこうくさi /抹香臭/
まっこうくさg /抹香臭/
まっくろs /真っ黒/
まっくろk /真っ黒/
まっくろi /真っ黒/
まっくろg /真っ黒/
まちわb /待ち侘/
まちゆk /街行/
まちぼうk /待ち惚/
まちぶs /待ち伏/
まちはずr /街外/町外/
まちのぞn /待ち望/
まちのぞm /待ち望/
まちのr /街乗/
まちどおs /待ち遠/
まちづくr /町作/
まちこg /待ち焦/
まちくたびr /待ち草臥/
まちきr /待ち切/
まちがw /間違/
まちがu /間違/
まちがt /間違/
まちがo /間違/
まちがi /間違/
まちがe /間違/
まちがc /間違/
まちかまe /待ち構/
まちかn /待ち兼/
まちうk /待ち受/待受/
まちあわs /待合/待ち合わ;※送り位置補正/
まちあぐn /待ち倦/
まちあぐm /待ち倦/
まちあw /待ち合/待合/
まちあk /待ち明/
まちあi /待ち合/待合/
まだるs /間怠/
まだるk /間怠/
まだるi /間怠/
まだるg /間怠/
まだらs /斑/
まだらn /斑/
まだらd /斑/
まだs /未だ;※送り位置補正/
またたk /瞬/
またたi /瞬/
またぎこs /跨ぎ越/
またぎk /又聞/
またがt /跨/
またがs /又貸/
またがr /跨/又借/
またがn /跨/
またがc /跨/
またm /又/
またi /跨/
またh /又/
またg /跨/
まぜっかえs /混ぜっ返;議論を-す/
まぜこn /混ぜ込/
まぜこm /混ぜ込/
まぜがk /交ぜ書/混ぜ書/
まぜかえs /混ぜ返/雑ぜ返/
まぜあわs /混ぜ合/
まぜあw /混ぜ合/
まずs /貧/不味/マズ/
まずk /不味/マズ/
まずi /不味/マズ/
まずg /不味/マズ/
まじろi /瞬/
まじろg /瞬/
まじりあw /混じり合/
まじりあu /混じり合/
まじりあt /混じり合/
まじりあo /混じり合/
まじりあi /混じり合/
まじりあe /混じり合/
まじりあc /混じり合/
まじめすg /真面目過/
まじなi /呪/
まじきr /間仕切/
まじw /交/
まじt /混/
まじr /混/
まじn /混/
まじk /間近/
まじh /交/雑/
まじe /交/雑/
まじc /混/
ましまs /在;天に在す我らが神よ/坐;≒在す/
ましt /況し;※送り位置補正/
まざりあw /混ざり合/
まざりあu /混ざり合/
まざりあt /混ざり合/
まざりあo /混ざり合/
まざりあi /混ざり合/
まざりあe /混ざり合/
まざりあc /混ざり合/
まさぐt /弄/
まさぐr /弄/
まさぐn /弄/
まさぐc /弄/
まさt /勝;(字義:力比べで勝つ)/優;(字義:美しさで秀でる)/
まさs /正/
まさr /勝;(字義:力比べで勝つ)/優;(字義:美しさで秀でる)/
まさn /正/勝;(字義:力比べで勝つ)/優;(字義:美しさで秀でる)/
まさc /勝;(字義:力比べで勝つ)/優;(字義:美しさで秀でる)/
まごびk /孫引/
まごu /紛;-う(かたなき) (音便)/
まことs /実;-しやか/真/
まことn /誠/真;-に/実;-に/
まげのb /曲げ伸/
まけつづk /負け続/
まけこs /負け越/
まぐまだm /マグマ溜/
まぐr /紛/
まくりあg /捲り上/
まくらs /枕/
まくひk /幕引/
まくしたt /捲し立/まくし立/
まくしあg /捲し上/
まくぎr /幕切/
まくあk /幕開/
まくt /捲/
まくr /捲/
まくn /捲/
まくc /捲/
まぎれこn /紛れ込/
まぎれこm /紛れ込/
まぎr /紛/
まきわr /薪割/
まきもどs /巻き戻/巻戻/
まきなおs /蒔き直;新規-し政策(New Deal)/巻き直;ゼンマイを-/
まきつk /巻き付/巻付/
まきつi /巻き付/巻付/
まきちらs /撒き散ら;※送り位置補正/
まきちr /撒き散/
まきぞe /巻き添/
まきこn /巻き込/
まきこm /巻き込/
まきかえs /巻き返/
まきおこs /巻き起/捲き起/巻起/
まきおk /巻き起/捲き起/巻起/
まきあg /巻き上/
まがりきt /曲がり切/
まがりきr /曲がり切/
まがりきn /曲がり切/
まがりきc /曲がり切/
まがまがs /禍々/禍禍/兇々/曲々;≒禍々しい/
まがw /紛/擬;<rare>/
まがu /紛/擬;<rare>/
まがt /曲/紛/擬;<rare>/枉/彎/弯;「彎」の異体字/
まがs /間貸/
まがr /曲/間借/枉/彎/弯;「彎」の異体字/
まがo /紛/擬;<rare>/
まがn /曲/枉/彎/弯;「彎」の異体字/
まがi /紛/擬/
まがh /紛/
まがe /紛/擬;<rare>/
まがc /紛/擬;<rare>/曲/枉/彎/弯;「彎」の異体字/
まかりまちがw /罷り間違/
まかりまちがu /罷り間違/
まかりまちがt /罷り間違/
まかりまちがo /罷り間違/
まかりまちがi /罷り間違/
まかりまちがe /罷り間違/
まかりまちがc /罷り間違/
まかりなt /罷り成/
まかりなr /罷り成/
まかりなn /罷り成/
まかりなc /罷り成/
まかりとおt /罷り通/
まかりとおr /罷り通/
まかりとおn /罷り通/
まかりとおc /罷り通/
まかりでz /罷り出/
まかりでt /罷り出/
まかりでr /罷り出/
まかりでn /罷り出/
まかなw /賄/
まかなu /賄/
まかなt /賄/
まかなo /賄/
まかなi /賄/
まかなh /賄/
まかなe /賄/
まかなc /賄/
まかせっきr /任せっ切/
まかせきt /任せ切/
まかせきr /任せ切/
まかせきn /任せ切/
まかせきc /任せ切/
まかt /罷/
まかs /任;(字義:大事なものを持たせる) 「仕事を任せる」/委;(字義:力を抜いて好きにさせる) 「躰を委せる」/
まかr /罷/
まかn /罷/
まかc /罷/
まえわたs /前渡/
まえもっt /前以/
まえむk /前向/
まえぶr /前触/
まえふr /前振/
まえばらi /前払/
まえづk /前付/
まえだおs /前倒/
まえがs /前貸/
まえがr /前借/
まえがk /前書/
まえかk /前掛/
まえおk /前置/
まえおi /前置/
まえうr /前売/
まえいわi /前祝/
まうs /申/
まうk /設/儲/
まうd /詣/
まいもどt /舞い戻/
まいもどr /舞い戻/
まいもどn /舞い戻/
まいもどc /舞い戻/
まいちt /舞い散/
まいちr /舞い散/
まいちn /舞い散/
まいちc /舞い散/
まいたt /舞い立/
まいたc /舞い立/
まいこn /舞い込/
まいこm /舞い込/
まいくるw /舞い狂/
まいくるu /舞い狂/
まいくるt /舞い狂/
まいくるo /舞い狂/
まいくるi /舞い狂/
まいくるe /舞い狂/
まいくるc /舞い狂/
まいおどt /舞い踊/
まいおどr /舞い踊/
まいおどn /舞い踊/
まいおどc /舞い踊/
まいおt /舞い落/
まいおr /舞い降/
まいおc /舞い落/
まいあg /舞い上/舞上/
まいt /参/參;旧字/詣;お宮に詣る/
まいr /参/詣;お宮に詣る/參;旧字/
まいn /参/詣;お宮に詣る/參;旧字/
まいc /参/詣;お宮に詣る/參;旧字/
まあたらs /真新/
まあi /間合/
まz /混/先;-ず/交/雑/
まw /舞/
まu /舞/
まt /待/舞/俟;期待する。「河清を-」「助力に-」/
まs /増/摩;(brush) 天を摩する/益/在/坐/
まr /放/
まo /舞/
まn /間/
まk /負/巻/撒;ばら撒く,敵を撒く/蒔;(字義:植えつける)種を蒔く/播;(字義:種をばらまく)種を播く/捲;袖を捲くる/敗;-ける/卷;「巻」の旧字(人名用漢字)/
まj /混;(字義:溶け合う)/交;(字義:立ちまじる)/雑;(字義:一緒くた)/
まi /舞/巻/撒;ばら撒く,敵を撒く/蒔;(字義:植えつける)種を蒔く/散/播;(字義:種をばらまく)種を播く/卷;「巻」の旧字(人名用漢字)/
まh /舞/
まg /曲/枉/
まe /舞/
まd /未/
まc /待/舞/俟;河清を俟つ/
ぽんびk /ぽん引/
ぽしゃt /ポシャ/
ぽしゃr /ポシャ/
ぽしゃn /ポシャ/
ぽしゃc /ポシャ/
ぼんおどr /盆踊/
ぼんあk /盆明/
ぼろs /ボロ/
ぼろk /ボロ/
ぼろi /ボロ/
ぼろg /ボロ/
ぼっs /没/
ぼこt /ボコ/
ぼこr /ボコ/
ぼこn /ボコ/
ぼこc /ボコ/
ぼくw /僕/
ぼくt /僕/
ぼくs /卜;うらなう/
ぼくn /僕/
ぼくm /僕/
ぼくh /僕/
ぼくg /僕/
ぼかs /暈/
ぼうよm /棒読/
ぼうびk /棒引/
ぼうだt /棒立/
ぼうそうs /暴走/
ぼうきr /棒切/
ぼうえいs /防衛/
ぼうy /坊/
ぼs /干/乾/
ぼr /惚/掘/彫/
ぼm /誉/褒/
ぼk /呆;(字義:赤子のようにぼっとする) NB:「ほうk」と同形/惚;(字義:何かに気を取られる)/暈;ピントが暈ける/
ほんよm /本読/
ほんみょうおなz /本名同/
ほんみょうおなj /本名同/
ほんぶr /本降/
ほんどおr /本通/
ほんどm /本泊/
ほんとb /本飛;?/
ほんづかi /本使/
ほんすべr /本滑/
ほんぎm /本決/本極/
ほんw /本/
ほろよi /微酔/
ほろびゆk /滅び行/
ほろびさt /滅び去/
ほろびさr /滅び去/
ほろびさn /滅び去/
ほろびさc /滅び去/
ほろにがs /ほろ苦/
ほろにがk /ほろ苦/
ほろにがi /ほろ苦/
ほろにがg /ほろ苦/
ほろn /滅/亡/
ほろb /滅/亡/
ほれぼr /惚れ惚/
ほれなおs /惚れ直/
ほれこn /惚れ込/
ほれこm /惚れ込/
ほりぬk /掘り抜/
ほりぬi /掘り抜/
ほりだs /掘り出;掘り出し物/彫り出;木材から仏像を彫り出す/
ほりすすn /掘り進/
ほりすすm /掘り進/
ほりさg /掘り下/
ほりこn /彫り込;carve.「名を-」/掘り込;dig.「井戸を-」/掘込/彫込/
ほりこm /彫り込;carve.「名を-」/掘り込;dig.「井戸を-」/掘込/彫込/
ほりくずs /掘り崩/
ほりかえs /掘り返/
ほりおk /掘り起/
ほりあt /掘り当/
ほりあg /彫り上;(仏像|刺青)を-げる/掘り上/
ほめたたe /褒め称/誉め称/
ほめたt /誉め立/
ほめそやs /誉称/褒称/褒め称/
ほめごろs /誉め殺/褒め殺/
ほめあg /誉め上/
ほまれたかs /誉れ高/
ほまれたかk /誉れ高/
ほまれたかi /誉れ高/
ほまれたかg /誉れ高/
ほまれおおk /誉大/
ほまr /誉/譽;旧字/
ほほばt /頬張/
ほほばr /頬張/
ほほばn /頬張/
ほほばc /頬張/
ほほえみかえs /微笑み返/
ほほえn /微笑/
ほほえm /微笑/頬笑/
ほふt /屠/
ほふr /屠/
ほふn /屠/
ほふc /屠/
ほのみe /仄見;真心が-える/
ほのじろs /仄白/
ほのじろm /仄白/
ほのじろk /仄白/
ほのじろi /仄白/
ほのじろg /仄白/
ほのぐらs /仄暗/
ほのぐらk /仄暗/
ほのぐらi /仄暗/
ほのぐらg /仄暗/
ほのm /仄/
ほのk /仄/側;-か(=仄か)/
ほねやすm /骨休/
ほねばt /骨張/
ほねばr /骨張/
ほねばn /骨張/
ほねばc /骨張/
ほねぬk /骨抜/
ほねなs /骨無/
ほねつg /骨接/
ほねぐm /骨組/
ほねおt /骨折/
ほねおr /骨折/
ほねおn /骨折/
ほねおc /骨折/
ほねp /骨/
ほどよs /程良/
ほどよk /程良/
ほどよi /程良/
ほどよg /程良/
ほどとおs /程遠/
ほどとおk /程遠/
ほどとおi /程遠/
ほどとおg /程遠/
ほどちかs /程近/
ほどちかk /程近/
ほどちかi /程近/
ほどちかg /程近/
ほどこs /施/
ほどn /程/
ほどk /解;NB:「とk」と同形/
ほどi /解;NB:「とk」と同形/
ほとんd /殆/
ほとばしt /迸/
ほとばしr /迸/
ほとばしn /迸/
ほとばしc /迸/
ほとn /殆/
ほてt /火照/熱/
ほてr /火照/熱/
ほてn /火照/熱/
ほてc /火照/熱/
ほつr /解/
ほっぽりだs /ほっぽり出/
ほっつきあるk /ほっつき歩/
ほっつきあるi /ほっつき歩/
ほっs /欲/
ほだs /絆/
ほそながs /細長/
ほそながk /細長/
ほそながi /細長/
ほそながg /細長/
ほそぎr /細切/
ほそy /細/
ほそt /細/
ほそs /細/
ほそr /細/
ほそn /細/
ほそm /細/
ほそk /細/
ほそi /細/
ほそg /細/
ほそc /細/
ほじくりだs /穿り出/
ほじくりかえs /穿り返/
ほじくt /穿/
ほじくr /穿/
ほじくn /穿/
ほじくc /穿/
ほじt /穿/
ほじr /穿/
ほじn /穿/
ほじc /穿/
ほしふr /星降/
ほしうらなi /星占/
ほしいままs /恣/縦/
ほしいままn /恣/縦/
ほしいままd /恣/縦/
ほしs /欲;非正則(ほs)/
ほしk /欲;非正則(ほs)/
ほしi /欲し;※送り位置補正/欲;非正則(ほs)/
ほしg /欲;非正則(ほs)/
ほごあずかr /保護預/
ほころn /綻/
ほころb /綻/
ほこりたかs /誇り高/
ほこりたかk /誇り高/
ほこりたかi /誇り高/
ほこりたかg /誇り高/
ほこりp /埃/
ほこt /誇/
ほこr /誇/
ほこn /誇/
ほこc /誇/
ほぐs /解/
ほぐr /解/
ほがr /朗/朖;「朗」の異体字/
ほかn /他/
ほおばt /頬張/
ほおばr /頬張/
ほおばn /頬張/
ほおばc /頬張/
ほおt /放/
ほおr /放/
ほおn /放/
ほおc /放/
ほえたt /吠え立/
ほうりなg /放り投/
ほうりだs /放り出/
ほうりこn /放り込/
ほうりこm /放り込/
ほうりあg /放り上/
ほうむりさt /葬り去/
ほうむりさr /葬り去/
ほうむりさn /葬り去/
ほうむりさc /葬り去/
ほうむt /葬/
ほうむr /葬/
ほうむn /葬/
ほうむc /葬/
ほうふn /豊富/
ほうっておk /放って置/
ほうっておi /放って置/
ほうっt /放/
ほうこくいたs /報告致/
ほうz /報;急を報ずる/奉;主君を奉ずる/封;二百石に封ずる/焙;茶を焙ずる/
ほうw /方/
ほうt /放;(字義:手を離す)/抛;(字義:高く投げる)/方/
ほうs /保/焙/
ほうr /放;(字義:手を離す)/抛;(字義:高く投げる)/
ほうn /放;(字義:手を離す)/抛;(字義:高く投げる)/方/
ほうm /方/
ほうk /呆/惚/
ほうj /報/奉/焙/
ほうh /方/
ほうg /方/
ほうc /放;(字義:手を離す)/抛;(字義:高く投げる)/
ほt /掘;(dig) 穴を掘る/放/彫;(carve) 仏像を彫る/
ほs /欲/干/乾;=干す (NB:「干す」は仮借用法)/補/保/
ほr /掘;(dig) 穴を掘る/彫;(carve) 仏像を彫る/惚;女に惚れる/耄/恍/抛/放/
ほn /掘;(dig) 穴を掘る/彫;(carve) 仏像を彫る/
ほm /褒;(字義:行いを評価する)/誉;(字義:持ち上げる)/賞;(字義:褒美をあてがう)/襃;「褒」の異体字/譽;「誉」の旧字/
ほe /吠;字義:犬が鳴く/吼;字義:大きな声を出す/咆;字義:含み声でほえる/哮;<rare> ≒吼える/
ほc /掘;(dig) 穴を掘る/彫;(carve) 仏像を彫る/
べんじたt /弁じ立/
べんz /弁/
べんs /便/
べんj /弁/
べとつk /べと付/
べとつi /べと付/
べつずr /別刷/
べつうr /別売/
べつあつかi /別扱/
べつs /別/
べつn /別/
べつd /別/
べたぬr /べた塗/
べたつk /べた付/
べたつi /べた付/
べいこくぎらi /米国嫌/
べs /可/
べk /可/
べi /可/
へんにゅうs /編入/
へんそうくだs /返送下/
へんじくだs /返事下/
へんこういたs /変更致/
へんこうs /変更/
へんかんg /変換/
へんかs /変化/
へんz /変/
へんt /変/
へんs /偏;人偏/貶/変/變;「変」の旧字/
へんn /変/變;「変」の旧字/
へんj /変/
へんd /変/變;「変」の旧字/
へりくだt /謙/遜/
へりくだr /謙/遜/
へりくだn /謙/遜/
へりくだc /謙/遜/
へらs /減ら;※送り位置補正/
へめぐt /経巡/経回/歴回/
へめぐr /経巡/経回/歴回/
へめぐn /経巡/経回/歴回/
へめぐc /経巡/経回/歴回/
へぼs /ヘボ/
へぼk /ヘボ/
へぼi /ヘボ/
へぼg /ヘボ/
へばりつk /へばり付/
へばりつi /へばり付/
へつらw /諂/諛/
へつらu /諂/諛/
へつらt /諂/諛/
へつらo /諂/諛/
へつらi /諂/諛/
へつらh /諛/諂/
へつらe /諂/諛/
へつらc /諂/諛/
へだたt /隔/
へだたr /隔/
へだたn /隔/
へだたc /隔/
へだt /隔/
へたりこn /へたり込/
へたりこm /へたり込/
へたn /下手/
へそまg /臍曲/
へしおt /圧し折/へし折/
へしおr /圧し折/へし折/
へしおn /圧し折/へし折/
へしおc /圧し折/へし折/
へこn /凹;NB:「くぼm」と同形/
へこm /凹;NB:「くぼm」と同形/
へいわn /平和/
へあg /経上/
へz /経;時を経る,役員を経る/經;「経」の旧字/歴;≒経る/
へy /経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へt /減/経;時を経る,役員を経る/經;「経」の旧字/歴;≒経る/
へs /圧;押し合い-し合い/減/経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へr /減/経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へn /経;時を経る,役員を経る/經;「経」の旧字/減/歴;≒経る/
へm /経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へk /経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へj /経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へi /剥;(薄く削る)/折;≒剥ぐ/
へg /剥;(薄く削る)/折;≒剥ぐ/
へd /経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
へc /減/経;時を経る,役員を経る/歴;≒経る/經;「経」の旧字/
ぶんなぐt /打ん殴/ぶん殴/
ぶんなぐr /ぶん殴/打ん殴/
ぶんなぐn /ぶん殴/打ん殴/
ぶんなぐc /ぶん殴/打ん殴/
ぶんせつくぎr /文節区切/
ぶんかつばらi /分割払/
ぶんかつs /分割/
ぶんs /分/
ぶるi /震/
ぶりかえs /ぶり返;熱が-す/
ぶらさg /ぶら下/
ぶひんとr /部品取/
ぶばt /武張/
ぶばr /武張/
ぶばn /武張/
ぶばc /武張/
ぶどまr /歩留/
ぶどm /歩留/
ぶとt /太/
ぶとr /太/
ぶとn /太/
ぶとc /太/
ぶつぎr /ぶつ切/
ぶっとおs /ぶっ通/打っ通;<rare>/
ぶっとn /打っ飛/
ぶっとb /打っ飛/
ぶったぎt /ぶった切/ぶった斬/打っ手切/
ぶったぎr /ぶった切/ぶった斬/打っ手切/
ぶったぎn /ぶった切/ぶった斬/打っ手切/
ぶったぎc /ぶった切/ぶった斬/打っ手切/
ぶっこわs /ぶっ壊/
ぶっころs /ぶっ殺/ブッ殺/打っ殺/
ぶっこn /打っ込/ぶっ込/
ぶっこm /打っ込/ぶっ込/
ぶっかk /打っ掛/ぶっ掛/
ぶちこわs /ぶち壊/打ち壊;NB:「うちこわs」と同形/ブチ壊/
ぶちころs /打ち殺/ブチ殺/ぶち殺/
ぶちこn /打ち込;NB:「うちこm」と同形/
ぶちこm /打ち込;NB:「うちこm」と同形/
ぶちぎr /ブチ切;-れ/
ぶちきr /ブチ切;-れる/
ぶちかm /打ち噛/
ぶちあg /打ち上;NB:「うちあg」と同形/
ぶきみg /不気味/
ぶかs /深/
ぶかk /深/
ぶかi /深/
ぶかg /深/
ぶあつs /ぶ厚/分厚/部厚/
ぶあつk /ぶ厚/分厚/部厚/
ぶあつi /分厚/部厚/ぶ厚/
ぶあつg /分厚/部厚/ぶ厚/
ぶt /撲/打;NB:「うt」と同形/撃/振/
ぶs /撫/伏;(連濁)/
ぶr /振/
ぶn /振/
ぶk /拭/吹/葺/
ぶc /振/
ふんばt /踏ん張/
ふんばr /踏ん張/
ふんばn /踏ん張/
ふんばc /踏ん張/
ふんづm /糞詰/
ふんづk /踏ん付/
ふんぞりかえt /踏ん反り返/
ふんぞりかえr /踏ん反り返/
ふんぞりかえn /踏ん反り返/
ふんぞりかえc /踏ん反り返/
ふんぞt /踏ん反/
ふんぞr /踏ん反;-る,-り返る/
ふんぞn /踏ん反/
ふんぞc /踏ん反/
ふんじばt /ふん縛/
ふんじばr /ふん縛/
ふんじばn /ふん縛/
ふんじばc /ふん縛/
ふんぎt /踏ん切/
ふんぎr /踏ん切/
ふんぎn /踏ん切/
ふんぎc /踏ん切/
ふんs /扮;扮装/
ふわたr /不渡/
ふわk /腑分/
ふろあg /風呂上/
ふれまわt /触れ回/
ふれまわr /触れ回/
ふれまわn /触れ回/
ふれまわc /触れ回/
ふれこn /触れ込/
ふれこm /触れ込/
ふれあるk /触れ歩/
ふれあるi /触れ歩/
ふれあw /触れ合/触合/
ふれあu /触れ合/触合/
ふれあt /触れ合/触合/
ふれあo /触れ合/触合/
ふれあi /触れ合/触合/
ふれあe /触れ合/触合/
ふれあc /触れ合/触合/
ふるまw /振る舞/振舞/
ふるまu /振る舞/振舞/
ふるまt /振る舞/振舞/
ふるまo /振る舞/振舞/
ふるまi /振舞/振る舞/
ふるまh /振舞/
ふるまe /振舞/振る舞/
ふるまc /振る舞/振舞/
ふるぼk /古惚/
ふるすg /古過/
ふるくさs /古臭/
ふるくさk /古臭/
ふるくさi /古臭/
ふるくさg /古臭/
ふるえあg /震え上/
ふるいわk /篩い分/
ふるいたt /奮い立/奮い起/
ふるいたc /奮い立/奮い起/
ふるいおとs /篩い落/振るい落/振い落/
ふるいおこs /奮い起/
ふるいおt /振るい落/篩い落/
ふるいおk /奮い起/
ふるw /震/奮;気力を奮う/振;(generic) 刀を振う/揮;(発揮) 国力が揮う,腕を揮う/篩;(screen) 粉を篩う/
ふるu /奮;気力を奮う/振;(generic) 刀を振う/揮;(発揮) 国力が揮う,腕を揮う/震/篩;(screen) 粉を篩う/古/旧/故/舊;「旧」の旧字/
ふるt /奮;気力を奮う/振;(generic) 刀を振う/揮;(発揮) 国力が揮う,腕を揮う/震/篩;(screen) 粉を篩う/
ふるs /古/旧/故/舊;「旧」の旧字/
ふるo /奮;気力を奮う/振;(generic) 刀を振う/揮;(発揮) 国力が揮う,腕を揮う/震/篩;(screen) 粉を篩う/
ふるm /古/旧/故/舊;「旧」の旧字/
ふるk /古/旧/故/舊;「旧」の旧字/
ふるi /古/旧/震/奮;気力を奮う/振;(generic) 刀を振う/故/舊;「旧」の旧字/揮;(発揮) 国力が揮う,腕を揮う/篩;(screen) 粉を篩う/
ふるh /揮/振/震/奮/篩/
ふるg /古/旧/故/舊;「旧」の旧字/
ふるe /震/顫/奮;気力を奮う/振;(generic) 刀を振う/揮;(発揮) 国力が揮う,腕を揮う/篩;(screen) 粉を篩う/
ふるc /奮;気力を奮う/振;(generic) 刀を振う/揮;(発揮) 国力が揮う,腕を揮う/震/篩;(screen) 粉を篩う/
ふるb /古/
ふりわk /振り分/
ふりやn /降り止/
ふりやm /降り止/
ふりむk /振り向/
ふりむi /振り向/
ふりみだs /振り乱/
ふりまわs /振り回/
ふりまz /振り混/
ふりまk /振り撒/
ふりまi /振り撒/
ふりほどk /振り解/
ふりほどi /振り解/
ふりはらw /振り払/
ふりはらu /振り払/
ふりはらt /振り払/
ふりはらo /振り払/
ふりはらi /振り払/
ふりはらe /振り払/
ふりはらc /振り払/
ふりのこs /降り残;-してや光堂/
ふりぬk /振り抜/振抜/
ふりぬi /振り抜/振抜/
ふりにg /振り逃/
ふりつもt /降り積/
ふりつもr /降り積/
ふりつもn /降り積/
ふりつもc /降り積/
ふりつのt /降り募/
ふりつのr /降り募/
ふりつのn /降り募/
ふりつのc /降り募/
ふりつづk /降り続/
ふりつづi /降り続/
ふりつm /降り積/
ふりつk /振り付/振付/
ふりだs /振り出/降り出/振出/
ふりたs /振り足/
ふりそぼt /降り濡/
ふりそそi /降り注/
ふりそそg /降り注/
ふりすt /振り捨/
ふりしぼt /振り絞/
ふりしぼr /振り絞/
ふりしぼn /振り絞/
ふりしぼc /振り絞/
ふりしきt /降り頻/
ふりしきr /降り頻/
ふりしきn /降り頻/
ふりしきc /降り頻/
ふりさけみz /振り放け見;-れば春日なる/
ふりさけみy /振り放け見;-れば春日なる/
ふりさけみt /振り放け見;-れば春日なる/
ふりさけみs /振り放け見;-れば春日なる/
ふりさけみr /振り放け見;-れば春日なる/
ふりさけみn /振り放け見;-れば春日なる/
ふりさけみm /振り放け見;-れば春日なる/
ふりさけみk /振り放け見;-れば春日なる/
ふりさけみc /振り放け見;-れば春日なる/
ふりさk /振り放;-け見れば春日なる/
ふりこn /振り込/降り込;窓から雪が-む/振込/
ふりこm /振り込/振込/降り込;窓から雪が-む/降り籠;雨に-められる/
ふりきt /振り切/
ふりきr /振り切/
ふりきn /振り切/
ふりきc /振り切/
ふりかぶt /振り被/
ふりかぶr /振り被/
ふりかぶn /振り被/
ふりかぶc /振り被/
ふりかざs /振り翳/
ふりかえt /振り返/振返/
ふりかえr /振り返/振返/
ふりかえn /振り返/振返/
ふりかえc /振り返/振返/
ふりかk /降り掛;災難が-/振り掛;-け/
ふりかe /振り替/
ふりおとs /振り落/
ふりおt /振り落/
ふりあおi /振り仰/
ふりあおg /振り仰/
ふりあg /振り上/振上/
ふゆやすm /冬休/
ふゆばr /冬晴/
ふゆきとどk /不行届/
ふゆがr /冬枯/
ふやs /増や;※送り位置補正/殖や;※送り位置補正/
ふむk /不向/
ふみわk /踏み分/
ふみはずs /踏み外/
ふみぬk /踏み抜;床を-く/踏み貫;釘を-く/
ふみぬi /踏み抜;床を-く/踏み貫;釘を-く/
ふみにじt /踏み躙/
ふみにじr /踏み躙/
ふみにじn /踏み躙/
ふみにじc /踏み躙/
ふみならs /踏み均/
ふみなr /踏み鳴/
ふみとどm /踏み止/踏み留/
ふみつぶs /踏み潰/
ふみつk /踏み付/踏付/
ふみちr /踏み散/
ふみだs /踏み出/
ふみたおs /踏み倒/
ふみしm /踏み締/
ふみころs /踏み殺/
ふみこn /踏み込/踏込/
ふみこm /踏み込/踏込/
ふみこe /踏み越/
ふみきt /踏み切/
ふみきr /踏み切/
ふみきn /踏み切/
ふみきc /踏み切/
ふみかたm /踏み固/
ふみおこなw /踏み行/
ふみおこなu /踏み行/
ふみおこなt /踏み行/
ふみおこなo /踏み行/
ふみおこなi /踏み行/
ふみおこなc /踏み行/
ふみいt /踏み入/
ふみいr /踏み入/
ふみいn /踏み入/
ふみいc /踏み入/
ふみあr /踏み荒;花園を-らす/
ふまe /踏ま;※送り位置補正/
ふぶk /吹雪/乱吹;≒吹雪く/
ふぶi /吹雪/乱吹;≒吹雪く/
ふばらi /不払/
ふぬk /腑抜/
ふなよi /船酔/
ふなもr /舟盛/
ふなのr /船乗/
ふなづm /船積/
ふなr /不慣/
ふとどk /不届/
ふとt /太/肥/
ふとs /太/
ふとr /太/肥/
ふとn /太/肥/
ふとm /太/
ふとk /太/
ふとi /太/
ふとg /太/
ふとc /太/肥/
ふでづかi /筆遣/
ふでたt /筆立/
ふでおr /筆下/
ふでいr /筆入/
ふてぶてs /太々/
ふてくさt /不貞腐/ふて腐/
ふてくさr /不貞腐/ふて腐/
ふてくさn /不貞腐/ふて腐/
ふてくさc /不貞腐/ふて腐/
ふつくm /恚/慍/憤/
ふつかよi /二日酔/
ふつうn /普通/
ふつk /恚/憤/
ふっとn /吹っ飛/
ふっとb /吹っ飛/
ふってわk /降って湧/
ふってわi /降って湧/
ふっきr /吹っ切/
ふっかk /吹っ掛/
ふちどt /縁取/
ふちどr /縁取/
ふちどn /縁取/
ふちどc /縁取/
ふだんづかi /普段使/
ふたりk /二人/
ふたとおr /二通/
ふたたb /再/
ふたしk /不確/
ふたt /二/弍;「二」の異体字/
ふぞろi /不揃/
ふせi /防/拒;<rare>(寄せ付けない)/
ふせg /防/拒;<rare>(寄せ付けない)/
ふずくm /慍/憤/
ふすb /燻/
ふしまわs /節回/
ふしづk /節付/
ふしくれだt /節榑立/
ふしくれだc /節榑立/
ふしおがn /伏し拝/
ふしおがm /伏し拝/
ふしあw /不仕合/
ふざけt /巫山戯/
ふざけr /巫山戯/
ふざけn /巫山戯/
ふざけc /巫山戯/
ふさわs /相応/
ふさぎこn /塞ぎ込/鬱ぎ込/
ふさぎこm /塞ぎ込/鬱ぎ込/
ふさw /相応/
ふさu /相応/
ふさt /相応/
ふさo /相応/
ふさi /塞/相応/鬱;気が鬱ぐ/
ふさg /塞/鬱;気が鬱ぐ/
ふさc /相応/
ふけゆk /更け行/
ふけこn /老け込/
ふけこm /老け込/
ふけt /耽/
ふけr /耽/
ふけn /耽/
ふけc /耽/
ふくろばr /袋貼/
ふくろとj /袋綴/
ふくろだたk /袋叩/
ふくれあg /膨れ上/
ふくぶくs /福々/
ふくざつすg /複雑過/
ふくy /膨/脹/
ふくs /服;喪に服す/復;原状に復する/伏;権力に伏する/覆;NB:「くつがえs」と同形/
ふくr /膨/脹/
ふくn /含/
ふくm /含/
ふきわたt /吹き渡/
ふきわたr /吹き渡/
ふきわたn /吹き渡/
ふきわたc /吹き渡/
ふきよs /吹き寄/
ふきやn /吹き止/
ふきやm /吹き止/
ふきぬk /吹き抜/吹抜/
ふきながs /吹き流/
ふきなr /吹き鳴/
ふきとおs /吹き通/
ふきとt /拭き取/
ふきとr /拭き取/
ふきとn /吹き飛/拭き取/
ふきとc /拭き取/
ふきとb /吹き飛/
ふきでz /吹き出/噴き出/
ふきでy /吹き出/噴き出/
ふきでt /吹き出/噴き出/
ふきでs /吹き出/噴き出/
ふきでr /吹き出/噴き出/
ふきでn /吹き出/噴き出/
ふきでm /吹き出/噴き出/
ふきでk /吹き出/噴き出/
ふきでc /吹き出/噴き出/
ふきつづk /吹き続/
ふきつk /吹き付/
ふきちr /吹き散/
ふきだまt /吹き溜/
ふきだまr /吹き溜/
ふきだまn /吹き溜/
ふきだまc /吹き溜/
ふきだt /吹き溜/
ふきだs /吹き出/噴き出/
ふきだr /吹き溜/
ふきだn /吹き溜/
ふきだm /吹き溜/
ふきだc /吹き溜/
ふきすさn /吹き荒/
ふきすさb /吹き荒/
ふきさらs /吹き曝/
ふきさm /吹き冷/
ふきこn /吹き込/
ふきこm /吹き込/
ふきけs /吹き消;(blow out)蝋燭を吹き消す/拭き消;(wipe out)落書きを拭き消す/
ふききよm /拭き清/
ふきかえs /吹き返/
ふきかk /吹き掛;息を-ける/
ふきかe /吹替;洋画の吹替え/吹き替/葺き替;屋根を葺き替える/
ふきおr /吹き下/葺き下/
ふきあr /吹き荒/
ふきあg /吹き上/
ふがひなs /腑甲斐無/
ふがひなk /腑甲斐無/
ふがひなi /腑甲斐無/
ふがひなg /腑甲斐無/
ふがいなs /腑甲斐無/
ふがいなk /腑甲斐無/
ふがいなi /腑甲斐無/
ふがいなg /腑甲斐無/
ふかよm /深読/
ふかなさk /深情/
ふかすg /深過/
ふかおi /深追/
ふかいr /深入/
ふかs /深/蒸;芋を蒸す (NB:「むs」と同形)/更;夜を更す/潭;<rare>/
ふかm /深/潭;<rare>/
ふかk /深/潭;<rare>/
ふかi /深/潭;<rare>/
ふかg /深/潭;<rare>/
ふえふk /笛吹/
ふうじこn /封じ込/
ふうじこm /封じ込/
ふうしゃがたm /風車固/
ふうぎt /封切/
ふうがわr /風変/
ふうz /封/
ふうs /諷/風/
ふうn /風/
ふうj /封/
ふうd /風/
ふいr /不入/
ふあんていd /不安定/
ふy /増/殖;(そのもの自身を増加させる)「財を殖やす」/
ふt /振/降;雨が降る/
ふs /付/伏/臥;床に臥す/附;=付す/匐/賦/
ふr /振/触/降;雨が降る/経;我が身世に経る/觝;<rare> 法に觝れる/觸;「触」の旧字/經;「経」の旧字/狂;気が狂れる/
ふn /踏/蹈;≒踏む/履;(≒踏む) 薄氷を履む/振/降;雨が降る/践;(実践) 践み行う/
ふm /踏/履;(≒踏む) 薄氷を履む/践;(実践) 践み行う/蹈;≒踏む/
ふk /吹;笛を吹く/拭;床を拭く/噴;(burst)火を噴く/老;老けた男/更;夜が更ける/葺;屋根を葺く/深;-ける(≒更ける|老ける)/
ふi /吹;笛を吹く/拭;床を拭く/噴;(burst)火を噴く/葺;屋根を葺く/
ふe /増/殖;(procreate)「(猫|財産)が殖える」/
ふc /振/降;雨が降る/
びんぼうくさs /貧乏臭/
びんぼうくさk /貧乏臭/
びんぼうくさi /貧乏臭/
びんぼうくさg /貧乏臭/
びんじょうねあg /便乗値上/
びろs /広/
びろk /広/
びろi /広/
びろg /広/
びらk /開;海開き,俎開き,片開き/
びょうよm /秒読/
びょううt /鋲打/
びょううc /鋲打/
びみょうn /微妙/
びびt /ビビ/
びびr /ビビ/
びびn /ビビ/
びびc /ビビ/
びたt /浸/
びたr /浸/
びたn /浸/
びたc /浸/
びk /引/弾/
びi /引/弾/
ひんよk /品良/
ひんむk /引ん剥/
ひんむi /引ん剥/
ひんs /瀕;瀕死/貧/
ひわたr /火渡/
ひわr /干割/
ひろせどおr /広瀬通/
ひろすg /広過/
ひろいよm /拾い読/
ひろいだs /拾い出/
ひろいあつm /拾い集/
ひろいあg /拾い上/
ひろy /広/
ひろw /拾/広/
ひろu /拾/広/
ひろt /拾/広/
ひろs /広/廣;「広」の旧字(人名用漢字)/拾/博;知識が-い/宏/弘/
ひろo /拾/広/
ひろm /広/弘/廣;「広」の旧字(人名用漢字)/博;知識が-い/宏/
ひろk /広/宏/博;知識が-い/廣;「広」の旧字(人名用漢字)/拾/弘/
ひろi /広/拾/博;知識が-い/宏/弘/廣;「広」の旧字(人名用漢字)/
ひろg /広/拡;(enlarge)/展;(まとめてあったものをひろげる) 新聞を展げる/廣;「広」の旧字(人名用漢字)/擴;「拡」の旧字/博;知識が-い/宏/弘/拾;?/
ひろe /拾/広/
ひろc /拾/広/
ひれふs /平伏/
ひるやすm /昼休/
ひるすg /昼過/
ひるさがr /昼下/
ひるさg /昼下/
ひるがえt /翻/飜;「翻」の旧字(人名用漢字)/
ひるがえs /翻/飜;「翻」の旧字(人名用漢字)/
ひるがえr /翻/飜;「翻」の旧字(人名用漢字)/
ひるがえn /翻/飜;「翻」の旧字(人名用漢字)/
ひるがえc /翻/飜;「翻」の旧字(人名用漢字)/
ひるn /怯/
ひるm /怯/
ひりだs /放り出;NB:「ほうりだs」と同形/
ひらめk /閃/
ひらめi /閃/
ひらとj /平綴/
ひらづm /平積/
ひらきなおt /開き直/
ひらきなおr /開き直/
ひらきなおn /開き直/
ひらきなおc /開き直/
ひらあやまr /平謝/
ひらt /平/
ひらk /開/拓;処女地を拓く/啓;蒙を啓く/
ひらi /開/拓;処女地を拓く/啓;蒙を啓く/
ひらb /平;-べったい/
ひよわs /ひ弱/
ひよわk /ひ弱/
ひよわi /ひ弱/
ひよわg /ひ弱/
ひよt /日和/
ひよr /日和/
ひよn /日和/
ひよc /日和/
ひょうよm /票読/
ひょうへんs /豹変/
ひょうばんわるs /評判悪/
ひょうばんわるk /評判悪/
ひょうばんわるi /評判悪/
ひょうばんわるg /評判悪/
ひょうばんよs /評判良/
ひょうばんよk /評判良/
ひょうばんよi /評判良/
ひょうばんよg /評判良/
ひょうばんどおr /評判通/
ひょうじょうゆたk /表情豊/
ひょうじs /表示/
ひょうしぬk /拍子抜/
ひょうぐm /表組/
ひょうs /表;(manifest) 敬意を表す/評;(criticise) 作品を評す/
ひやとi /日雇/
ひやかs /素見/
ひやy /冷/
ひやs /冷/
ひやk /日焼/冷/
ひゃっぽゆずt /百歩譲/
ひゃっぽゆずr /百歩譲/
ひゃっぽゆずc /百歩譲/
ひゃくしょうよm /百姓読/
ひもとk /紐解/繙/
ひもとi /繙/紐解/
ひまつぶs /暇潰/
ひまs /日増/暇/閑/隙;(すきま)/
ひまn /閑/隙;(すきま)/
ひまd /閑/隙;(すきま)/
ひふk /火吹;-き竹,-き山/
ひびわr /罅割/ひび割/
ひびきわたt /響き渡/
ひびきわたr /響き渡/
ひびきわたn /響き渡/
ひびきわたc /響き渡/
ひびきあw /響き合/
ひびきあu /響き合/
ひびきあt /響き合/
ひびきあo /響き合/
ひびきあi /響き合/
ひびきあe /響き合/
ひびきあc /響き合/
ひびk /響/
ひびi /響/
ひのいr /日の入/
ひのb /日延/
ひねりつぶs /捻り潰/
ひねりだs /捻り出/
ひねくりまわs /捻くり回/
ひねt /捻/撚/陳;(age) 大根が陳る/拈;≒捻る/捫/
ひねr /捻/撚/陳;(age) 大根が陳る/拈;≒捻る/捫/
ひねn /捻/撚/陳;(age) 大根が陳る/拈;≒捻る/捫/
ひねk /捻/
ひねc /捻/撚/陳;(age) 大根が陳る/拈;≒捻る/捫/
ひにくt /皮肉/
ひにくr /皮肉/
ひにくn /皮肉/
ひにくc /皮肉/
ひなあそb /雛遊/
ひなb /鄙/
ひどu /酷/非道/
ひどs /酷/非道/
ひどr /日取/
ひどk /酷/非道/
ひどi /酷/非道/
ひどg /酷/非道/
ひとりよg /独り善/
ひとりだt /独り立/
ひとりじm /一人占/独り占/
ひとりごt /独り言/
ひとりごc /独り言/
ひとりぐr /一人暮/
ひとりあるk /一人歩/
ひとりあt /一人当/
ひとりk /一人/
ひとよs /人寄/
ひとよn /人呼/
ひとやすm /一休/
ひとやくかw /一役買/
ひとやくかu /一役買/
ひとやくかt /一役買/
ひとやくかo /一役買/
ひとやくかi /一役買/
ひとやくかe /一役買/
ひとやくかc /一役買/
ひとめぼr /一目惚/
ひとみしr /人見知/
ひとまわr /一回/
ひとまかs /人任/
ひとまt /人待/
ひとふでがk /一筆書/
ひとひねr /一捻/
ひとばらi /人払/
ひとはだぬi /一肌脱/
ひとはだぬg /一肌脱/
ひとはたらk /一働/
ひとはしr /一走/
ひとねむr /一眠/
ひとねいr /一寝入/
ひとにぎr /一握/
ひとなつk /人懐/
ひとなm /人並/
ひとどおr /人通/
ひととおr /一通/
ひととうr /一通;※仮名遣い「ひととお-り」/
ひとづきあi /人付き合/
ひとづかi /人使/
ひとつづk /一続/
ひとちがi /人違/
ひとだすk /人助/
ひとだかr /人集/
ひとたまr /一溜/
ひとたたk /一叩/
ひとたm /一溜/
ひとそろe /一揃/
ひとずk /人好/
ひとしr /人知/
ひとさわg /人騒;人騒がせな話/一騒;一騒ぎある/
ひとさらi /人攫/
ひとさがs /人探/人捜/
ひとごろs /人殺/
ひとごm /人込/人混/
ひとこいs /人恋/
ひとくぎr /一区切/
ひとくi /人喰/人食;-い鮫/
ひとぎらi /人嫌/
ひとぎk /人聞/
ひときr /一切/
ひとがんばr /一頑張/
ひとかかe /一抱/
ひとかi /人買/
ひとおもi /一思/
ひとえn /偏/
ひといきいr /一息入/
ひとあじちがw /一味違/
ひとあじちがu /一味違/
ひとあじちがt /一味違/
ひとあじちがo /一味違/
ひとあじちがi /一味違/
ひとあじちがe /一味違/
ひとあじちがc /一味違/
ひとあしはやk /一足早/
ひとあしはやi /一足早/
ひとあしちがi /一足違/
ひとあしおそk /一足遅/
ひとあしおそi /一足遅/
ひとあt /一当/
ひとあr /一荒/
ひとt /一/壱;「一」の大字/弌;「一」の異体字/壹;「壱」の旧字/１/1/
ひとs /等/均/斉/
ひとr /独;(字義:群れない)/孤;(字義:取り残される)/獨;「独」の旧字/
ひとm /一/
ひでt /日照/
ひでr /日照/
ひでn /日照/
ひでc /日照/
ひづk /日付/
ひつようn /必要/
ひつk /火付/
ひっぱりまわs /引っ張り回/
ひっぱりだs /引っ張り出/引っぱり出/
ひっぱりこn /引っ張り込/
ひっぱりこm /引っ張り込/
ひっぱりあg /引っ張り上/
ひっぱたk /引っ叩/
ひっぱたi /引っ叩/
ひっぱt /引っ張/引張/
ひっぱr /引っ張/引張/
ひっぱn /引っ張/引張/
ひっぱg /引っ剥;ビリッと-がす/
ひっぱc /引っ張/引張/
ひっとらe /引っ捕/
ひっつk /引っ付/
ひっつi /引っ付/
ひったくt /引っ手繰/
ひったくr /引っ手繰/
ひったくn /引っ手繰/
ひったくc /引っ手繰/
ひったt /引っ立/
ひっさらw /引っ攫/
ひっさらu /引っ攫/
ひっさらt /引っ攫/
ひっさらo /引っ攫/
ひっさらi /引っ攫/
ひっさらe /引っ攫/
ひっさらc /引っ攫/
ひっさg /提;NB:「さg」と同形/引っ提/引っ下/
ひっこぬk /引っこ抜/
ひっこぬi /引っこ抜/
ひっこしづかr /引越疲/
ひっこs /引っ越/引越/
ひっこn /引っ込/引込/
ひっこm /引っ込/引込/
ひっくるm /引っ括/
ひっくりかえt /引っくり返/ひっくり返/引っ繰り返/
ひっくりかえs /引っくり返/ひっくり返/引っ繰り返/
ひっくりかえr /引っくり返/ひっくり返/引っ繰り返/
ひっくりかえn /引っくり返/ひっくり返/引っ繰り返/
ひっくりかえc /引っくり返/ひっくり返/引っ繰り返/
ひっくくt /引っ括/
ひっくくr /引っ括/
ひっくくn /引っ括/
ひっくくc /引っ括/
ひっきりなs /引っ切り無/
ひっきt /引っ切/
ひっきr /引っ切/
ひっきn /引っ切/
ひっきc /引っ切/
ひっかぶt /引っ被/
ひっかぶr /引っ被/
ひっかぶn /引っ被/
ひっかぶc /引っ被/
ひっかかt /引掛/引っ掛/
ひっかかr /引っ掛/引掛/
ひっかかn /引っ掛/引掛/
ひっかかc /引っ掛/引掛/
ひっかえs /引っ返/
ひっかk /引っ掛/引っ掻/
ひっかi /引っ掻/
ひっかe /引っ替;取っ替え-え/
ひっs /筆/必/
ひだるs /饑/
ひだるk /饑/
ひだるi /饑/
ひだるg /饑/
ひだりよt /左四/
ひだりよr /左寄/
ひだりむk /左向/
ひだりまわr /左回/
ひだりまk /左巻/
ひだりきk /左利/
ひだりs /左/
ひだまr /日溜/
ひだt /肥立/
ひだs /養/
ひだm /日溜/
ひたはしt /直走/
ひたはしr /直走/
ひたはしn /直走/
ひたはしc /直走/
ひたかくs /直隠/
ひたt /浸/
ひたs /浸/漬/
ひたr /浸/
ひたn /浸/
ひたc /浸/
ひそy /密/秘/
ひそn /潜/潛;「潜」の旧字1/濳;「潜」の旧字2/顰;眉を顰める/
ひそm /潜/顰;眉を顰める/潛;「潜」の旧字1/濳;「潜」の旧字2/
ひそk /密/秘/祕;「秘」の旧字(人名用漢字)/
ひぜm /火攻;城を火攻めにする/火責;罪人を火責めにする/
ひずn /歪/
ひずm /歪/
ひじょうn /非常/
ひじかk /肘掛/
ひしゃi /拉/
ひしゃg /拉/
ひしめk /犇/
ひしめi /犇/
ひしm /犇/
ひしi /拉/柆;<rare> =拉ぐ/
ひしg /拉/柆;<rare> =拉ぐ/
ひざまづk /跪/
ひざまづi /跪/
ひざまずk /跪/
ひざまずi /跪/
ひざかk /膝掛/
ひざs /日射/日差/
ひさしぶr /久し振/
ひさかたぶr /久方振/
ひさs /久/尚;<rare>/
ひさi /鬻;(trade) 矛と盾を鬻ぐ/販;≒鬻ぐ/
ひさg /鬻;(trade) 矛と盾を鬻ぐ/販;≒鬻ぐ/拉;(crush) 箱が拉げる/提;≒提げる/
ひけs /火消/
ひぐr /日暮/
ひくすg /低過/
ひくs /低/
ひくm /低/
ひくk /低/
ひくi /低/
ひくg /低/
ひきわたs /引き渡/引渡/
ひきわr /碾き割/挽き割/
ひきわk /引き分/引分/
ひきよs /引き寄/
ひきもどs /引き戻/
ひきむすn /引き結/
ひきむすb /引き結/
ひきまわs /引き回/
ひきはらw /引き払/
ひきはらu /引き払/
ひきはらt /引き払/
ひきはらo /引き払/
ひきはらi /引き払/
ひきはらe /引き払/
ひきはらc /引き払/
ひきはなs /引き離/
ひきはi /引き剥/
ひきはg /引き剥/
ひきのb /引き伸/引き延/
ひきぬk /引き抜/
ひきぬi /引き抜/
ひきにg /轢き逃/
ひきなおs /引き直;風邪を-す/
ひきなr /弾き鳴/
ひきとおs /引き通/
ひきとt /引き取/引取/
ひきとr /引き取/引取/
ひきとn /引き取/引取/
ひきとm /引き止/
ひきとc /引き取/引取/
ひきつづk /引き続/引続/
ひきつづi /引き続/引続/
ひきつt /引き攣/
ひきつr /引き連/引き攣/
ひきつn /引き攣/
ひきつk /引き付/引付/
ひきつi /引き継/引継/
ひきつg /引き継/引継/
ひきつc /引き攣/
ひきちぎt /引き千切/
ひきちぎr /引き千切/
ひきちぎn /引き千切/
ひきちぎc /引き千切/
ひきちがi /引き違;-い(戸)/引違/
ひきだs /引き出/引出/弾き出/
ひきたおs /引き倒;贔屓の-し/引倒/
ひきたt /引き立/引立/
ひきたc /引き立/引立/
ひきずりまわs /引きずり回/引き摺り回/
ひきずりだs /引きずり出/引き摺り出/
ひきずりこn /引きずり込/引き摺り込/
ひきずりこm /引きずり込/引き摺り込/
ひきずりおr /引きずり下/
ひきずt /引き摺/
ひきずr /引き摺/
ひきずn /引き摺/
ひきずc /引き摺/
ひきしめr /引き締め;※送り位置補正/
ひきしぼt /引き絞/
ひきしぼr /引き絞/
ひきしぼn /引き絞/
ひきしぼc /引き絞/
ひきしm /引き締/引締/
ひきさt /引き去/
ひきさr /引き去/
ひきさn /引き去/
ひきさk /引き裂/
ひきさi /引き裂/
ひきさg /引き下/引下/
ひきさc /引き去/
ひきころs /轢き殺/
ひきこn /引き込/
ひきこm /引き込/引込/
ひきくらb /引き比/
ひきがたt /弾き語/
ひきがたr /弾き語/
ひきがたn /弾き語/
ひきがたc /弾き語/
ひきかえs /引き返/
ひきかe /引き換/引き替/引換/引替/
ひきおとs /引き落/
ひきおこs /引き起/引き起こ;※送り位置補正/
ひきおr /引き下/
ひきおk /引き起/惹き起;cause/
ひきうつs /引き写;文献を-/
ひきうk /引き受/引受/
ひきいr /引き入;仲間に-れる/
ひきあわs /引き合/
ひきあw /引き合/
ひきあu /引き合/
ひきあt /引き当/引当/引き合/
ひきあo /引き合/
ひきあi /引き合/引合/
ひきあg /引き上/引き揚/引上/
ひきあe /引き合/
ひきあc /引き合/
ひきw /率/
ひきi /率/
ひがしむk /東向/
ひがえr /日帰/
ひがw /日替/日変/
ひがn /僻/
ひがm /僻/
ひがk /日掛/
ひかりかがやk /光り輝/光輝/
ひかりかがやi /光り輝/光輝/
ひからb /干涸/乾涸/
ひかt /光/
ひかr /光/
ひかn /光/
ひかe /控/
ひかc /光/
ひえこn /冷え込/
ひえこm /冷え込/
ひえきt /冷え切/
ひえきr /冷え切/
ひえきn /冷え切/
ひえきc /冷え切/
ひいr /火入/
ひいd /秀/
ひあそb /火遊/
ひあg /干上/乾上/
ひy /冷/
ひt /引/放;屁を放る/
ひs /比/秘/引;-っさげる/
ひr /干/放;屁を放る/
ひp /引/
ひn /陳;-ねる,-ねこびた/非;似て非なる/冷;-んやり/放;屁を放る/
ひm /秘/祕;「秘」の旧字(人名用漢字)/
ひk /引/弾;ピアノを弾く/挽;コーヒー豆を挽く/退;軍を退く/碾;麦を碾く/轢;轢き殺す/曳;山車を曳く/牽;綱を牽く/索;見出しを索く/惹;(attract)心を惹かれる/魅;≒惹く/彈;「弾」の旧字(人名用漢字)/
ひi /引/弾;ピアノを弾く/挽;コーヒー豆を挽く/索;見出しを索く/彈;「弾」の旧字(人名用漢字)/退;軍を退く/碾;麦を碾く/轢;轢き殺す/曳;山車を曳く/牽;綱を牽く/惹;(attract)心を惹かれる/魅;≒惹く/
ひe /冷/
ひc /放;屁を放る/
ぱらw /払/
ぱらu /払/
ぱらt /払/
ぱらo /払/
ぱらi /払/
ぱらe /払/
ぱらc /払/
ぱにくt /パニク/
ぱにくr /パニク/
ぱにくn /パニク/
ぱにくc /パニク/
ぱにk /パニ/
ぱなs /放/
ぱしt /走/
ぱしr /走/
ぱしn /走/
ぱしc /走/
ぱくt /パク/
ぱくr /パク/
ぱくn /パク/
ぱくc /パク/
ぱt /張/
ぱr /張/
ぱn /張/
ぱc /張/
ばんごうづk /番号付/
ばんくるw /番狂/
ばれz /バレ/
ばれy /バレ/
ばれt /バレ/
ばれs /バレ/
ばれr /バレ/
ばれn /バレ/
ばれm /バレ/
ばれk /バレ/
ばれc /バレ/
ばらまk /散蒔/ばら撒/
ばらまi /ばら撒/散蒔/
ばらs /バラ/
ばらk /散/
ばらi /払/祓;悪魔祓い/拂;「払」の旧字(人名用漢字)/
ばやs /早/
ばやk /早/
ばやi /早/
ばやg /早/
ばなしs /話/
ばなr /離/
ばつぐんd /抜群/
ばっs /罰/
ばちがi /場違/
ばちあたr /罰当/
ばちあt /罰当/
ばたらk /働/
ばたくさs /バタ臭/
ばたくさk /バタ臭/
ばたくさi /バタ臭/
ばたくさg /バタ臭/
ばしt /走/
ばしr /走/
ばしn /走/
ばしc /走/
ばさn /挟/
ばさm /挟/
ばくs /縛;緊縛/
ばかよb /馬鹿呼/
ばかばかs /馬鹿馬鹿/バカバカ/
ばかたかs /馬鹿高;形容詞[φik(sg)]/バカ高/
ばかたかk /馬鹿高;形容詞[φik(sg)]/バカ高/
ばかたかi /馬鹿高;形容詞[φik(sg)]/バカ高/
ばかたかg /馬鹿高;形容詞[φik(sg)]/バカ高/
ばかくさs /馬鹿臭/
ばかくさk /馬鹿臭/
ばかくさi /馬鹿臭/
ばかくさg /馬鹿臭/
ばかt /馬鹿/
ばかs /魅/
ばかr /許/馬鹿/
ばかg /馬鹿;馬鹿げた/
ばいちかs /倍近/
ばいちかk /倍近/
ばいちかi /倍近/
ばいちかg /倍近/
ばいs /倍;double.「味方に倍する勢力」/陪;お供する。「宴席に陪する」/
ばあいわk /場合分/
ばあt /場当/
ばt /張/貼/
ばs /馳/
ばr /張/晴/貼/
ばn /張/貼/
ばk /化/
ばi /這/
ばc /張/貼/
はんびらk /半開/
はんとしちかs /半年近/
はんとしちかk /半年近/
はんとしちかi /半年近/
はんとしちかg /半年近/
はんていがt /判定勝/
はんていがc /判定勝/
はんだづk /半田付/
はんだずk /半田付/
はんそくまk /反則負/
はんごろs /半殺/
はんぐm /版組/
はんかくさs /半可臭;北海道方言/
はんかくさk /半可臭;北海道方言/
はんかくさi /半可臭;北海道方言/
はんかくさg /半可臭;北海道方言/
はんえいs /反映/
はんz /判/
はんs /反/
はんj /判/
はわたr /刃渡/
はれわたt /晴れ渡/
はれわたr /晴れ渡/
はれわたn /晴れ渡/
はれわたc /晴れ渡/
はればr /晴れ晴/
はれあg /腫れ上/
はるやすm /春休/
はるm /春/
はるk /遥/遼/遙;「遥」の旧字(人名用漢字)/
はりわたs /張り渡/
はりめぐr /張り巡/
はりまわs /張り回/
はりつけr /貼り付け;※送り位置補正/
はりつm /張り詰/
はりつk /貼り付/張り付/
はりつi /張り付/貼り付/
はりだs /張り出/貼り出/
はりたおs /張り倒/撲り倒/
はりさs /針刺/
はりさk /張り裂/
はりこn /張り込/貼り込;paste.「画像を-」/はり込/
はりこm /張り込/貼り込;paste.「画像を-」/はり込/
はりきt /張り切/
はりきr /張り切/
はりきn /張り切/
はりきc /張り切/
はりかe /貼り替/張り替/
はりあわs /貼り合/
はりあw /貼り合/張り合/
はりあu /張り合/
はりあt /張り合/
はりあo /張り合/
はりあi /張合/張り合/
はりあg /張り上/
はりあe /張り合/
はりあc /張り合/
はらへt /腹減/
はらへr /腹減/
はらへn /腹減/
はらへc /腹減/
はらばi /腹這/
はらちがi /腹違/
はらだt /腹立/
はらたt /腹立/
はらたc /腹立/
はらごしらe /腹拵/
はらぐろs /腹黒/
はらぐろk /腹黒/
はらぐろi /腹黒/
はらぐろg /腹黒/
はらきr /腹切/
はらがまe /腹構/
はらいわたs /払い渡/
はらいもどs /払い戻/払戻/
はらいのk /払い除/
はらいだs /払出/
はらいさg /払い下/払下/
はらいこn /払い込/払込/
はらいこm /払い込/払込/
はらいきよm /祓い清/
はらいs /腹癒/
はらw /払/拂;「払」の旧字(人名用漢字)/祓;悪霊を祓う/掃;ススを掃う/禳;≒祓う/
はらu /払/祓;悪霊を祓う/掃;ススを掃う/禳;≒祓う/拂;「払」の旧字(人名用漢字)/
はらt /払/拂;「払」の旧字(人名用漢字)/祓;悪霊を祓う/掃;ススを掃う/禳;≒祓う/
はらo /払/拂;「払」の旧字(人名用漢字)/祓;悪霊を祓う/掃;ススを掃う/禳;≒祓う/
はらn /孕/
はらm /孕/
はらi /払/祓;お祓い/拂;「払」の旧字(人名用漢字)/掃;ススを掃う/禳;≒祓う/
はらh /掃/払/祓/拂;「払」の旧字(人名用漢字)/
はらe /払/拂;「払」の旧字(人名用漢字)/祓;悪霊を祓う/掃;ススを掃う/禳;≒祓う/
はらc /払/祓;悪霊を祓う/掃;ススを掃う/禳;≒祓う/拂;「払」の旧字(人名用漢字)/
はよu /早/
はゆs /映/
はゆk /映/
はゆi /映/
はゆg /映/
はやりたt /逸り立/
はやだs /早出/
はやすg /早過/速過/
はやしたt /囃し立/
はやざk /早咲/
はやぐi /早食/
はやがわr /早変/
はやがえr /早帰/
はやおくr /早送/
はやおk /早起/
はやうt /早打/
はやいものがt /早い者勝/
はやt /流行/逸;気が逸る/早;≒逸る/
はやs /速;(quick)「足が速い」「速い仕事」/早;(early)「朝早い」「早い時期」/囃/疾;(矢のように速い)/捷;(動作・反応がはやい)/
はやr /流行/逸;気が逸る/早;≒逸る/
はやn /流行/逸;気が逸る/早;≒逸る/
はやm /早/速/
はやk /早;(early)「朝早い」「早い時期」/速;(quick)「足が速い」「速い仕事」/疾;(矢のように速い)/捷;(動作・反応がはやい)/
はやi /早;(early)「朝早い」「早い時期」/速;(quick)「足が速い」「速い仕事」/疾;(矢のように速い)/捷;(動作・反応がはやい)/
はやg /早;(early)「朝早い」「早い時期」/速;(quick)「足が速い」「速い仕事」/疾;(矢のように速い)/捷;(動作・反応がはやい)/
はやc /流行/逸;気が逸る/早;≒逸る/
はもt /ハモ/
はもr /ハモ/
はもn /ハモ/
はもc /ハモ/
はめこn /嵌め込/
はめこm /嵌め込/
はめz /ハメ/
はめy /ハメ/
はめt /ハメ/
はめs /ハメ/
はめr /ハメ/
はめn /ハメ/
はめm /ハメ/
はめk /ハメ/
はめc /ハメ/
はみでz /はみ出/食み出/
はみでy /はみ出/食み出/
はみでt /はみ出/食み出/
はみでs /はみ出/食み出/
はみでr /はみ出/食み出/
はみでn /はみ出/食み出/
はみでm /はみ出/食み出/
はみでk /はみ出/食み出/
はみでc /はみ出/食み出/
はみだs /はみ出/食み出/
はみがk /歯磨/
はまべちかs /浜辺近/
はまべちかk /浜辺近/
はまべちかi /浜辺近/
はまべちかg /浜辺近/
はまちかs /浜近/
はまちかk /浜近/
はまちかi /浜近/
はまちかg /浜近/
はまt /嵌/填/
はまr /嵌/填/
はまn /嵌/填/
はまc /嵌/填/
はべt /侍/
はべr /侍/
はべn /侍/
はべc /侍/
はぶr /羽振/
はぶk /省/羽振/
はぶi /省/
はふr /放/
はびこt /蔓延/
はびこr /蔓延/
はびこn /蔓延/
はびこc /蔓延/
はばよs /幅寄/
はばひろs /幅広/
はばひろk /幅広/
はばひろi /幅広/
はばひろg /幅広/
はばたk /羽搏/羽撃/
はばたi /羽搏/羽撃/
はばかt /憚/
はばかr /憚/
はばかn /憚/
はばかc /憚/
はばn /阻/難;<rare> ≒阻む/
はばm /阻/難;<rare> ≒阻む/
はねまわt /跳ね回/
はねまわr /跳ね回/
はねまわn /跳ね回/
はねまわc /跳ね回/
はねのk /撥ね除/
はねっかえr /跳ねっ返;-り娘/
はねかえt /跳ね返/
はねかえs /跳ね返/撥ね返/
はねかえr /跳ね返/
はねかえn /跳ね返/
はねかえc /跳ね返/
はねおk /跳ね起/
はねあg /跳ね上/
はぬk /歯脱/
はなればなr /離れ離/
はならb /歯並/
はなもt /鼻持/
はなびe /花冷/
はなひらk /花開/
はなひらi /花開/
はなばなs /華々/花々/華華/
はなはだs /甚/
はなはd /甚/
はなづm /鼻詰/
はなつまm /鼻抓/
はなじろn /鼻白/
はなじろm /鼻白/
はなしつづk /話し続/
はなしだs /話し出/話出/
はなしずk /話好/
はなしこn /話し込/
はなしこm /話し込/
はなしがi /放し飼/
はなしかk /話し掛/
はなしあw /話し合/
はなしあu /話し合/
はなしあt /話し合/
はなしあo /話し合/
はなしあi /話し合/
はなしあe /話し合/
はなしあc /話し合/
はなしs /話/
はなざかr /花盛/
はなさk /花咲/
はなぐもr /花曇/
はなうr /花売/
はなy /華/花/
はなt /放/
はなs /話/離;(separate) 間を離す/放;(release) 犬を放す/
はなr /離/放/
はなc /放/
はどm /歯止/
はではでs /派手派手/
はてしなs /果てし無/
はてしなk /果てし無/
はてしなi /果てし無/
はてs /果て;※送り位置補正/
はづs /外/
はづr /外/
はづn /弾;旧仮名/勢;旧仮名/彈;「弾」の旧字(人名用漢字)/
はづm /弾;旧仮名/勢;旧仮名/彈;「弾」の旧字(人名用漢字)/
はづk /辱/恥/
はつのr /初乗/
はつすべr /初滑/
はつかおあw /初顔合/
はつうr /初売/
はっぽうふさg /八方塞/
はっせいs /発生/
はっこうs /発行/
はっきs /発揮/
はっs /発/發;「発」の旧字/
はっp /葉っ;※送り位置補正/
はちきr /はち切/
はちうe /鉢植/
はちあw /鉢合/
はだざわr /肌触/
はだざむs /肌寒/
はだざむk /肌寒/
はだざむi /肌寒/
はだざむg /肌寒/
はださむs /肌寒/
はださむk /肌寒/
はださむi /肌寒/
はださむg /肌寒/
はだかk /肌掛/
はだあi /肌合/
はだk /開/
はたらきすg /働き過/
はたらきかk /働き掛/
はたらk /働/
はたらi /働/
はたふr /旗振/
はたたk /羽撃/
はたたi /羽撃/
はたけちがi /畑違/
はたきこn /叩き込/
はたきこm /叩き込/
はたあg /旗揚/
はたs /果/
はたk /叩/
はたi /叩/
はせさんz /馳せ参/
はせさんj /馳せ参/
はせいs /派生/
はずかしm /辱/
はずかs /恥/恥ずか;※送り位置補正/
はずs /外/
はずr /外/
はずn /弾/勢/彈;「弾」の旧字(人名用漢字)/
はずm /弾/勢/機/彈;「弾」の旧字(人名用漢字)/
はずk /恥/
はすむかi /斜向/
はすうきりあg /端数切上/
はじけとn /弾け飛/
はじけとb /弾け飛/
はじきとb /弾き飛/
はじきだs /弾き出/
はじきかえs /弾き返/
はじいt /恥じ入/
はじいr /恥じ入/
はじいn /恥じ入/
はじいc /恥じ入/
はじm /初;(順序,未経験)「初めてのSKK」/始;(開始)「SKKを始める」「姫始め」/創/甫/
はじk /弾/
はじi /弾/
はしをr /端折/
はしわたs /橋渡/
はしりまわt /走り回/
はしりまわr /走り回/
はしりまわn /走り回/
はしりまわc /走り回/
はしりぬk /走り抜/
はしりぬi /走り抜/
はしりつづk /走り続/
はしりだs /走り出/
はしりすg /走り過/
はしりさt /走り去/
はしりさr /走り去/
はしりさn /走り去/
はしりさc /走り去/
はしりこn /走り込/
はしりこm /走り込/
はしりがk /走り書/
はしょt /端折/
はしょr /端折/
はしょn /端折/
はしょc /端折/
はしゃi /燥/
はしゃg /燥/
はしたs /端/
はしたn /端/
はしたd /端/
はしぞm /箸初/
はしおt /端折/
はしおr /端折/
はしおn /端折/
はしおk /箸置/
はしおc /端折/
はしt /走/端;-た(金)/奔;(急いではしる)/赱;「走」の異体字/迸;(にげる)/
はしr /走/迸;(にげる)/奔;(急いではしる)/赱;「走」の異体字/
はしn /走/迸;(にげる)/奔;(急いではしる)/赱;「走」の異体字/
はしc /走/迸;(にげる)/奔;(急いではしる)/赱;「走」の異体字/
はざわr /歯触/
はさみこn /挟み込/
はさみこm /挟み込/
はさみうt /挟み撃/
はさみうc /挟み撃/
はさn /挟/夾;≒挟む/挾;旧字/剪;鋏で切ること/鋏;鋏で切ること/
はさm /挟/夾;≒挟む/剪;鋏で切ること/鋏;鋏で切ること/挾;旧字/
はごたe /歯応/
はこびだs /運び出/
はこびこn /運び込/
はこびこm /運び込/
はこいr /箱入/
はこn /運/
はこb /運/
はげましあw /励まし合/
はげましあu /励まし合/
はげましあt /励まし合/
はげましあo /励まし合/
はげましあi /励まし合/
はげましあe /励まし合/
はげましあc /励まし合/
はげまs /励ま;※送り位置補正/
はげおt /剥げ落/
はげおc /剥げ落/
はげあg /禿げ上/
はげs /激/烈/劇/
はげn /励/勵;旧字/
はげm /励/勵;旧字/
はぐくn /育/毓;「育」の異体字/
はぐくm /育/毓;「育」の異体字/
はぐr /逸/
はくおs /箔押/
はくs /博;博覧会/
はぎとt /剥ぎ取/
はぎとr /剥ぎ取/
はぎとn /剥ぎ取/
はぎとc /剥ぎ取/
はぎしr /歯軋/
はぎあわs /接ぎ合/
はぎあw /接ぎ合/
はぎr /歯切/端切/
はきもどs /吐き戻/
はきちがe /履き違/
はきちr /吐き散;西瓜の種を-らす/
はきだs /掃き出/吐き出/はき出/
はきだi /掃き出;?/
はきすt /吐き捨/
はきさしもどs /破棄差戻/
はききよm /掃き清/
はがれおt /剥がれ落/
はがれおc /剥がれ落/
はがゆs /歯痒/齒痒;旧字/
はがゆk /歯痒/齒痒;旧字/
はがゆi /歯痒/齒痒;旧字/
はがゆg /歯痒/齒痒;旧字/
はがs /剥/
はがr /剥/
はがi /羽交;-い(締め)/
はかりしr /計り知/
はかりかn /計り兼/
はかりうr /量り売/
はかまいr /墓参/
はかばかs /捗々/
はかなs /儚/果敢無/果無/
はかなn /果無/
はかなm /果無/
はかなk /儚/果敢無/果無/
はかなi /儚/果敢無/果無/
はかなg /儚/果敢無/果無/
はかどt /捗/
はかどr /捗/
はかどn /捗/
はかどc /捗/
はかt /図;和解を図る/測;距離を測る/計;時間を計る,見計らう/諮;委員会に諮る/謀;暗殺を謀る/圖;「図」の旧字/量;体重を量る/企/
はかr /図;和解を図る/測;距離を測る/計;時間を計る,見計らう/量;体重を量る/諮;委員会に諮る/謀;暗殺を謀る/企/圖;「図」の旧字/
はかn /図;和解を図る/測;距離を測る/計;時間を計る,見計らう/量;体重を量る/諮;委員会に諮る/謀;暗殺を謀る/企/圖;「図」の旧字/
はかc /図;和解を図る/測;距離を測る/計;時間を計る,見計らう/量;体重を量る/諮;委員会に諮る/謀;暗殺を謀る/企/圖;「図」の旧字/
はおt /羽織/
はおr /羽織/
はおn /羽織/
はおc /羽織/
はえぬk /生え抜/
はえそろw /生え揃/
はえそろu /生え揃/
はえそろt /生え揃/
はえそろo /生え揃/
はえそろi /生え揃/
はえそろe /生え揃/
はえそろc /生え揃/
はえかわt /生え変/
はえかわr /生え変/
はえかわn /生え変/
はえかわc /生え変/
はえかw /生え変/
はえe /早/速/
はいりこn /入り込/
はいりこm /入り込/
はいよt /這い寄/
はいよr /這い寄/
はいよn /這い寄/
はいよc /這い寄/
はいまわt /這い回/
はいまわr /這い回/
はいまわn /這い回/
はいまわc /這い回/
はいのぼt /這い上/這い登/
はいのぼr /這い上/這い登/
はいのぼn /這い上/這い登/
はいのぼc /這い上/這い登/
はいでz /這い出/
はいでy /這い出/
はいでt /這い出/
はいでs /這い出/
はいでr /這い出/
はいでn /這い出/
はいでm /這い出/
はいでc /這い出/
はいつくばt /這い蹲/
はいつくばr /這い蹲/
はいつくばn /這い蹲/
はいつくばc /這い蹲/
はいちがe /配置換/
はいだs /這い出/
はいずりまわt /這いずり回/
はいずりまわr /這いずり回/
はいずりまわn /這いずり回/
はいずりまわc /這いずり回/
はいこn /這い込/
はいこm /這い込/
はいあg /這い上/
はいt /入/這入/
はいs /排;(排除) 抵抗を排する/廃;(廃止) 制度を廃する/拝;(拝観) 仏を拝する,後塵を拝する/配;(配置) 部下を配する/
はいr /入/這入/
はいn /入/這入/
はいc /入/這入/
はあくd /把握/
はz /恥/爆/羞/耻;「恥」の異体字/
はy /生/栄;栄やす(=褒めそやす)/映;≒栄やす/早/榮;「栄」の旧字(人名用漢字)/
はw /這/歯/齒;旧字/匍/
はu /這/匍/
はt /果/貼;(paste) 糊で貼る/張;ピンと張る/這/匍/
はs /馳/派/
はr /貼;(paste) 糊で貼る。「(チラシ|レッテル|URL)を-」/張;ピンと張る。「(弓|アンテナ|リンク)を-」/晴/腫;瞼が腫れる/脹;≒腫れる/霽;≒晴れる/膨;<rare> ≒腫れる (NB:「ふくr」と同形/
はo /這/匍/
はn /跳;(自動詞)/撥;(他動詞) 泥を撥ねる/食;-んで/刎;(首を)-ねる/貼;(paste) 糊で貼る/張;ピンと張る/
はm /食/嵌/填/
はk /掃/吐/捌;在庫が捌ける/履;靴を履く/穿;ズボンを穿く/帚;≒掃く/菷;「帚」の異体字/刷;ブラシで刷く/佩;剣を佩く/着/帶;「帯」の旧字(人名用漢字)/
はj /恥;(原義:きまり悪い)/羞;(原義:身の縮む)/愧/慙/耻;「恥」の異体字/
はi /吐/履;靴を履く/這/掃/匍/穿;ズボンを穿く/帚;≒掃く/菷;「帚」の異体字/刷;ブラシで刷く/佩;剣を佩く/剥/矧;矢を矧ぐ(=作る)/
はg /剥/禿/矧;矢を矧ぐ(=作る)/
はe /生/映;(contrast)「夕陽に映える」/栄;(glory)「栄えある」 NB:「さかe」と同形/榮;「栄」の旧字(人名用漢字)/暎;「映」の異体字/這/匍/
はd /恥/愧/慙/羞/耻;「恥」の異体字/
はc /這/匍/貼;(paste) 糊で貼る/張;ピンと張る/
はb /羽/
のろけt /惚気/
のろけr /惚気/
のろけn /惚気/
のろけc /惚気/
のろくさs /鈍臭/
のろくさk /鈍臭/
のろくさi /鈍臭/
のろくさg /鈍臭/
のろw /呪/詛/咒;「呪」の異体字/
のろu /呪/詛/咒;「呪」の異体字/
のろt /呪/詛/咒;「呪」の異体字/
のろs /呪/鈍;NB:「にぶi」と同形/
のろo /呪/詛/咒;「呪」の異体字/
のろk /呪/鈍;NB:「にぶi」と同形/
のろi /呪/鈍;NB:「にぶi」と同形/詛/咒;「呪」の異体字/
のろg /呪/鈍;NB:「にぶi」と同形/
のろe /呪/詛/咒;「呪」の異体字/
のろc /呪/詛/咒;「呪」の異体字/
のりまわs /乗り回/
のりづk /糊付/
のりつぶs /乗り潰/
のりつづk /乗り続/
のりつk /乗り付/
のりつi /乗り継/
のりつg /乗り継/
のりだs /乗り出/
のりそこなw /乗り損/
のりそこなu /乗り損/
のりそこなt /乗り損/
のりそこなo /乗り損/
のりそこなi /乗り損/
のりそこなe /乗り損/
のりそこなc /乗り損/
のりすごs /乗り過/
のりすt /乗り捨/
のりこs /乗り越/
のりこn /乗り込/
のりこm /乗り込/
のりこe /乗り越/乗り超;<rare>/
のりくn /乗り組/乗組/
のりくm /乗り組/乗組/
のりきt /乗り切/
のりきr /乗り切/
のりきn /乗り切/
のりきc /乗り切/
のりかかt /乗り掛/
のりかかr /乗り掛/
のりかかn /乗り掛/
のりかかc /乗り掛/
のりかk /乗り掛/
のりかe /乗り換/乗換/乗り替/乗替/
のりおくr /乗り遅/
のりうつt /乗り移/
のりうつr /乗り移/
のりうつn /乗り移/
のりうつc /乗り移/
のりいt /乗り入/
のりいr /乗り入/乗入/
のりいn /乗り入/
のりいc /乗り入/
のりあわs /乗り合/
のりあw /乗り合/
のりあu /乗り合/
のりあt /乗り合/
のりあo /乗り合/
のりあi /乗り合/
のりあe /乗り合/
のりあc /乗り合/
のりs /糊/
のやk /野焼/
のめりこn /のめり込/
のめりこm /のめり込/
のみほs /飲み干/飲み乾/
のみはじm /飲み始/
のみなおs /飲み直/
のみつぶr /飲み潰/
のみつづk /飲み続/
のみたおs /飲み倒/
のみたr /飲み足/
のみすg /飲み過/
のみこn /飲み込/飲込/呑み込/
のみこm /飲み込/飲込/呑み込/
のみくらb /飲み比/
のみくだs /飲み下;薬を-す/
のみあるk /飲み歩/
のみあるi /飲み歩/
のみあk /飲み明;(朝まで)-かす/飲み飽;-きる/
のぼりつm /上り詰/登り詰/
のぼせあg /逆上せ上/
のぼt /登;(climb)山に登る/昇;(ascend)日が昇る/上/騰/
のぼs /上;議題に上せる/逆上;(風呂で|女に)逆上せる/上気;≒逆上せる/
のぼr /登;(climb)山に登る/上/昇;(ascend)日が昇る/騰/
のぼn /登;(climb)山に登る/上/昇;(ascend)日が昇る/騰/
のぼc /登;(climb)山に登る/上/昇;(ascend)日が昇る/騰/
のべつまくなs /のべつ幕無/
のぶとs /野太/
のぶとk /野太/
のぶとi /野太/
のぶとg /野太/
のびなやn /伸び悩/
のびなやm /伸び悩/
のびきt /伸び切/延び切/
のびきr /伸び切/延び切/
のびきn /伸び切/延び切/
のびきc /伸び切/延び切/
のびあg /伸び上/
のばなs /野放/
のばs /延/
ののしりあw /罵り合/
ののしりあu /罵り合/
ののしりあt /罵り合/
ののしりあo /罵り合/
ののしりあi /罵り合/
ののしりあe /罵り合/
ののしりあc /罵り合/
ののしt /罵/
ののしr /罵/
ののしn /罵/
ののしc /罵/
ののs /罵;非正則(ののしr)/
のづm /野積/
のっぴk /退っ引;-き(ならない)/
のっとt /乗っ取;(take over)会社を乗っ取る/則;(conform)規定に則る/
のっとr /乗っ取;(take over)会社を乗っ取る/則;(conform)規定に則る/法/
のっとn /乗っ取;(take over)会社を乗っ取る/則;(conform)規定に則る/
のっとc /乗っ取;(take over)会社を乗っ取る/則;(conform)規定に則る/
のちぞe /後添/
のちn /後/
のたれじn /野垂れ死/
のたまわk /曰/
のたまw /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたまu /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたまt /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたまo /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたまi /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたまh /宣/曰/
のたまe /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたまc /宣;(字義:広く行き渡らせる)/曰;(字義:口に出す)/
のたうちまわt /のたうち回/
のたうちまわr /のたうち回/
のたうちまわn /のたうち回/
のたうちまわc /のたうち回/
のぞみみz /望み見/
のぞみみy /望み見/
のぞみみt /望み見/
のぞみみs /望み見/
のぞみみr /望み見/
のぞみみn /望み見/
のぞみみm /望み見/
のぞみみk /望み見/
のぞみみc /望み見/
のぞきみz /覗き見/
のぞきみy /覗き見/
のぞきみt /覗き見/
のぞきみs /覗き見/
のぞきみr /覗き見/
のぞきみn /覗き見/
のぞきみm /覗き見/
のぞきみk /覗き見/
のぞきみc /覗き見/
のぞきこn /覗き込/
のぞきこm /覗き込/
のぞs /除/覗/
のぞn /望/臨;(面対する) (海|死)に臨む/
のぞm /望/臨;(面対する) (海|死)に臨む/
のぞk /除/覗/覘;≒覗く/臨;≒覗く/
のぞi /除/覗/覘;≒覗く/臨;≒覗く/
のぞg /除/覗/
のしあるk /伸し歩/
のしあるi /伸し歩/
のしあg /伸し上/
のざらs /野晒/
のこりわずk /残り僅/
のこりすくn /残り少/
のこt /残/殘;「残」の旧字/遺/
のこs /残/遺;(後世に伝える) 財産を遺す/殘;「残」の旧字/
のこr /残/遺/殘;「残」の旧字/
のこn /残/遺/殘;「残」の旧字/
のこc /残/遺/殘;「残」の旧字/
のけぞt /のけ反/仰け反/
のけぞr /仰け反/のけ反/
のけぞn /仰け反/のけ反/
のけぞc /仰け反/のけ反/
のきなm /軒並/
のがs /逃/迯;「逃」の異体字/
のがr /逃/遁;字義:隠れてのがれる/逸;字義:走ってのがれる/迯;「逃」の異体字/
のうなs /能無/
のt /乗/載;雑誌に載る/乘;「乗」の旧字(人名用漢字)/
のs /載;(物理的)机に載せる, (出版物)論文を載せる/乗/伸;餅を伸す/熨;アイロンで熨す/乘;「乗」の旧字(人名用漢字)/
のr /乗/載;雑誌|荷台に載る/伸;伸るか反るか/乘;「乗」の旧字(人名用漢字)/
のn /飲;字義:液体をのむ/呑;字義:噛まずにのみ下す/嚥/飮;「飲」の旧字/乗/載;雑誌に載る/乘;「乗」の旧字(人名用漢字)/
のm /飲;字義:液体をのむ/呑;字義:噛まずにのみ下す/嚥/飮;「飲」の旧字/
のk /退;「立ち退く」「押し退ける」 NB:「しりぞk」と同形/除;(put aside)「取り除ける」/乗/載/
のi /退;「立ち退く」「押し退ける」 NB:「しりぞk」と同形/
のg /逃/迯;「逃」の異体字/
のc /乗/載;雑誌に載る/乘;「乗」の旧字(人名用漢字)/
のb /伸/述;意見を述べる/延;(時間的)予定が延びる/陳;≒述べる/
ねんばらi /年払/
ねんごr /懇/
ねんおs /念押/
ねんいr /念入/
ねんz /念/拈;ひねる/
ねんj /念/
ねりまz /練り混/
ねりなおs /練り直/
ねりこn /練り込/
ねりこm /練り込/
ねりかたm /練り固/煉り固/
ねりあるk /練り歩/
ねりあるi /練り歩/
ねりあw /練り合/
ねらいすm /狙い澄/
ねらいうt /狙い撃/
ねらいうc /狙い撃/
ねらw /狙/
ねらu /狙/
ねらt /狙/
ねらo /狙/
ねらi /狙/
ねらe /狙/
ねらc /狙/
ねもこr /懇;「ねんごろ」の古い形/
ねめまわs /睨め回/
ねめつk /睨め付/
ねむりこn /眠り込/
ねむりこm /眠り込/
ねむt /眠/睡;(字義:瞼を垂れる)/
ねむs /眠/
ねむr /眠/睡;(字義:瞼を垂れる)/
ねむn /眠/睡;(字義:瞼を垂れる)/
ねむk /眠/
ねむi /眠/
ねむg /眠/
ねむc /眠/睡;(字義:瞼を垂れる)/
ねみだr /寝乱/
ねまわs /根回/
ねぼk /寝惚/寝呆/
ねぶかs /根深/
ねぶかk /根深/
ねぶかi /根深/
ねぶかg /根深/
ねぶt /舐;(lick) 飴を舐る/眠;sleep/
ねぶr /舐;(lick) 飴を舐る/眠;sleep/
ねぶn /舐;(lick) 飴を舐る/眠;sleep/
ねぶm /値踏/
ねぶc /舐;(lick) 飴を舐る/眠;sleep/
ねびk /値引/
ねびi /値引/
ねびe /寝冷/
ねばりぬk /粘り抜/
ねばりぬi /粘り抜/
ねばりづよs /粘り強/
ねばりづよk /粘り強/
ねばりづよi /粘り強/
ねばりづよg /粘り強/
ねばりつk /粘り着/
ねばりつi /粘り着/
ねばつk /粘着/
ねばつi /粘着/
ねばt /粘/
ねばr /粘/
ねばn /粘/
ねばk /粘/
ねばc /粘/
ねなおs /寝直/
ねなs /根無/
ねとt /寝取/
ねとr /寝取/
ねとn /寝取/
ねとm /寝泊/
ねとc /寝取/
ねづよs /根強/
ねづよk /根強/
ねづよi /根強/
ねづよg /根強/
ねづかr /寝疲/
ねづm /根詰/
ねづk /根付/
ねづi /根付/
ねつp /熱/
ねつk /寝付/
ねつi /寝付/
ねっちゅうs /熱中/
ねっしんd /熱心/
ねっs /熱/
ねっk /根っ;※送り位置補正/
ねちがe /寝違/
ねだt /強請/
ねだr /強請/
ねだn /強請/
ねだm /寝溜/
ねだc /強請/
ねたs /妬/
ねたn /妬/嫉/
ねたm /妬/嫉/
ねたk /妬/
ねたg /妬/
ねずみとr /鼠取/
ねすごs /寝過/
ねすg /寝過/
ねじまg /捻じ曲/捩じ曲/ねじ曲/
ねじふs /捻じ伏/捩じ伏/ねじ伏/
ねじこn /捩じ込/ねじ込/
ねじこm /捩じ込/ねじ込/
ねじきt /捩じ切/
ねじきr /捩じ切/
ねじきn /捩じ切/
ねじきc /捩じ切/
ねじあg /捩じ上;腕を-/
ねじt /捻/捩/
ねじr /捻/捩/
ねじn /捻/捩/
ねじk /拗/
ねじc /捻/捩/
ねしずm /寝静/
ねざs /根差/
ねざm /寝覚/
ねさg /値下/
ねころn /寝転/
ねころg /寝転/
ねころb /寝転/
ねこかわいg /猫可愛/
ねこn /寝込/
ねこm /寝込/
ねぐるs /寝苦/
ねくずr /値崩/
ねぎらw /労/犒;飲食物で将兵を慰労すること/
ねぎらu /労/犒;飲食物で将兵を慰労すること/
ねぎらt /労/犒;飲食物で将兵を慰労すること/
ねぎらo /労/犒;飲食物で将兵を慰労すること/
ねぎらi /労/犒;飲食物で将兵を慰労すること/
ねぎらe /労/犒;飲食物で将兵を慰労すること/
ねぎらc /労/犒;飲食物で将兵を慰労すること/
ねぎt /値切/
ねぎr /値切/
ねぎn /値切/
ねぎc /値切/
ねがえt /寝返/
ねがえr /寝返/
ねがえn /寝返/
ねがえc /寝返/
ねがいでz /願い出/
ねがいでy /願い出/
ねがいでt /願い出/
ねがいでs /願い出/
ねがいでr /願い出/
ねがいでn /願い出/
ねがいでm /願い出/
ねがいでk /願い出/
ねがいでc /願い出/
ねがいさg /願い下/
ねがw /願/希;(字義:めったにないものを求める)/
ねがu /願/希;(字義:めったにないものを求める)/
ねがt /願/希;(字義:めったにないものを求める)/
ねがo /願/希;(字義:めったにないものを求める)/
ねがi /願/希;(字義:めったにないものを求める)/
ねがh /願/
ねがe /願/希;(字義:めったにないものを求める)/
ねがc /願/希;(字義:めったにないものを求める)/
ねかしつk /寝かし付/
ねおk /寝起/
ねえs /姉/
ねうごk /値動/
ねうt /値打/
ねうc /値打/
ねいt /寝入/
ねいr /寝入/
ねいn /寝入/
ねいc /寝入/
ねあらi /値洗/
ねあがr /値上/根上/
ねあk /寝明/
ねあg /値上/
ねz /寝/捻/捩/寢;「寝」の旧字(人名用漢字)/
ねy /寝/寢;「寝」の旧字(人名用漢字)/
ねw /寝/寢;「寝」の旧字(人名用漢字)/
ねu /寝/寢;「寝」の旧字(人名用漢字)/
ねt /寝/練;案を練る/寢;「寝」の旧字(人名用漢字)/錬;鉄を錬る/煉;煉り羊羹/粘;NB:「ねばr」と同形/
ねs /寝/寢;「寝」の旧字(人名用漢字)/
ねr /寝/練;案を練る/錬;鉄を錬る/煉;煉り羊羹/粘;NB:「ねばr」と同形/寢;「寝」の旧字(人名用漢字)/
ねp /寝/寢;「寝」の旧字(人名用漢字)/
ねo /寝/寢;「寝」の旧字(人名用漢字)/
ねn /寝/寢;「寝」の旧字(人名用漢字)/練;案を練る/錬;鉄を錬る/煉;煉り羊羹/粘;NB:「ねばr」と同形/
ねm /寝/睨/寢;「寝」の旧字(人名用漢字)/
ねk /寝/根/寢;「寝」の旧字(人名用漢字)/
ねj /捻/捩/寝/寢;「寝」の旧字(人名用漢字)/
ねi /寝/寢;「寝」の旧字(人名用漢字)/
ねh /寝/寢;「寝」の旧字(人名用漢字)/
ねg /寝/寢;「寝」の旧字(人名用漢字)/
ねe /寝/寢;「寝」の旧字(人名用漢字)/
ねd /寝/寢;「寝」の旧字(人名用漢字)/
ねc /寝/練;案を練る/錬;鉄を錬る/煉;煉り羊羹/粘;NB:「ねばr」と同形/寢;「寝」の旧字(人名用漢字)/
ねb /寝/寢;「寝」の旧字(人名用漢字)/
ねa /寝/寢;「寝」の旧字(人名用漢字)/
ぬるs /微温/温/
ぬるn /温/
ぬるm /微温/温/
ぬるk /微温/温/
ぬるi /微温/温/
ぬるg /微温/温/
ぬりわk /塗り分/
ぬりなおs /塗り直;外壁を-す/
ぬりつぶs /塗り潰/
ぬりつk /塗り付/
ぬりこn /塗り込/
ぬりこm /塗り込/
ぬりかたm /塗り固/
ぬりかe /塗り替/塗替/
ぬめt /滑;NB:「すべr」と同形/
ぬめr /滑;NB:「すべr」と同形/
ぬめn /滑;NB:「すべr」と同形/
ぬめc /滑;NB:「すべr」と同形/
ぬのきr /布切/
ぬのうr /布売/
ぬすみみz /盗み見/
ぬすみみy /盗み見/
ぬすみみt /盗み見/
ぬすみみs /盗み見/
ぬすみみr /盗み見/
ぬすみみn /盗み見/
ぬすみみm /盗み見/
ぬすみみk /盗み見/
ぬすみみc /盗み見/
ぬすみとt /盗み取/
ぬすみとr /盗み取/
ぬすみとn /盗み取/
ぬすみとc /盗み取/
ぬすみだs /盗み出/
ぬすみぐi /盗み食/
ぬすみぎk /盗み聞/
ぬすみぎi /盗み聞/
ぬすn /盗/偸/盜;「盗」の旧字(人名用漢字)/
ぬすm /盗/偸/盜;「盗」の旧字(人名用漢字)/
ぬけでz /抜け出/
ぬけでy /抜け出/
ぬけでt /抜け出/
ぬけでs /抜け出/
ぬけでr /抜け出/
ぬけでn /抜け出/
ぬけでm /抜け出/
ぬけでc /抜け出/
ぬけだs /抜け出/脱け出/
ぬけがk /抜け駆/
ぬけおt /抜け落/
ぬけおc /抜け落/
ぬぐいさt /拭い去/
ぬぐいさr /拭い去/
ぬぐいさn /拭い去/
ぬぐいさc /拭い去/
ぬぐw /拭/
ぬぐu /拭/
ぬぐt /拭/
ぬぐo /拭/
ぬぐi /拭/
ぬぐe /拭/
ぬぐc /拭/
ぬくs /温/
ぬくn /温/
ぬくm /温/
ぬくk /温/
ぬくi /温/
ぬくg /温/
ぬぎっぱなs /脱ぎっ放/
ぬぎすt /脱ぎ捨/
ぬきんでy /抜きん出/
ぬきんでt /抜きん出/
ぬきんでr /抜きん出/
ぬきんでn /抜きん出/
ぬきんでm /抜きん出/
ぬきはなt /抜き放;腰の物を-つ/
ぬきとおs /貫き通/
ぬきとt /抜き取/
ぬきとr /抜き取/
ぬきとn /抜き取/
ぬきとc /抜き取/
ぬきでz /抜き出/
ぬきでy /抜き出/
ぬきでt /抜き出/
ぬきでs /抜き出/
ぬきでr /抜き出/
ぬきでn /抜き出/
ぬきでm /抜き出/
ぬきでk /抜き出/
ぬきでc /抜き出/
ぬきだs /抜き出/
ぬきずr /抜き刷/
ぬきさt /抜き去/
ぬきさs /抜き差/
ぬきさr /抜き去/
ぬきさn /抜き去/
ぬきさc /抜き去/
ぬきがたs /抜き難/
ぬきがたk /抜き難/
ぬきがたi /抜き難/
ぬきがたg /抜き難/
ぬきうt /抜き打/抜き撃/抜打/
ぬきあw /抜き合/
ぬきあu /抜き合/
ぬきあt /抜き合/
ぬきあo /抜き合/
ぬきあi /抜き合/
ぬきあe /抜き合/
ぬきあc /抜き合/
ぬきn /抽/擢/
ぬかるn /泥濘/
ぬかるm /泥濘/
ぬかばたらk /糠働/
ぬかずk /額突;足許に-く/
ぬかずi /額突;足許に-く/
ぬかr /泥濘/
ぬいとt /縫取/縫い取/
ぬいとr /縫取/縫い取/
ぬいとn /縫取/縫い取/
ぬいとj /縫い閉/
ぬいとc /縫取/縫い取/
ぬいつk /縫い付/
ぬいこn /縫い込/
ぬいこm /縫い込/
ぬいあわs /縫い合/
ぬいあw /縫い合/
ぬいあg /縫い上/
ぬw /抜/縫/
ぬu /縫/
ぬt /塗/縫/
ぬr /塗/濡/
ぬo /縫/
ぬn /塗/
ぬk /抜/貫;NB:「つらぬk」と同形/脱/拔;「抜」の旧字(人名用漢字)/
ぬi /抜/脱/縫/貫;NB:「つらぬk」と同形/拔;「抜」の旧字(人名用漢字)/
ぬg /脱/
ぬe /縫/
ぬc /縫/塗/
にんめいs /任命/
にんげんばなr /人間離/
にんげんくさs /人間臭/
にんげんくさk /人間臭/
にんげんくさi /人間臭/
にんげんくさg /人間臭/
にんげんぎらi /人間嫌/
にんげんr /人間/
にんきうすs /人気薄/
にんきうすk /人気薄/
にんきうすi /人気薄/
にんきうすg /人気薄/
にんz /任/
にんj /任/
にわかs /俄/
にわかn /俄/
にわかd /俄/
にわk /俄/
にらみつk /睨み付/
にらみかえs /睨み返/
にらみあw /睨み合/
にらみあu /睨み合/
にらみあt /睨み合/
にらみあo /睨み合/
にらみあi /睨み合/
にらみあe /睨み合/
にらみあc /睨み合/
にらn /睨/眈;<rare> (字義:狙ってみつめる)/
にらm /睨/眈;<rare> (字義:狙ってみつめる)/
によt /似寄/
によr /似寄/
によn /似寄/
によc /似寄/
にゅうりょくまt /入力待/
にゅうりょくまc /入力待/
にまいげr /二枚蹴/
にぼs /煮干/
にほんじんごのm /日本人好/
にほんざs /二本差/
にほんごふきかe /日本語吹替/
にほんごうt /日本語打/
にほんごうc /日本語打/
にぶt /鈍/
にぶs /鈍/
にぶr /鈍/
にぶn /鈍/
にぶk /鈍/
にぶi /鈍/
にぶg /鈍/
にぶc /鈍/
にふくm /煮含/
にばんせんj /二番煎/
にはじm /煮始/
にぬk /煮抜/
にぬi /煮抜/
になw /担/擔;「担」の旧字/
になu /担/擔;「担」の旧字/
になt /担/擔;「担」の旧字/
になo /担/擔;「担」の旧字/
になi /担/擔;「担」の旧字/
になe /担/擔;「担」の旧字/
になc /担/擔;「担」の旧字/
にとおr /二通/
にとk /煮溶/
にづくr /荷造/
につまt /煮詰/
につまr /煮詰/
につまn /煮詰/
につまc /煮詰/
につm /煮詰/
につk /煮付/
にちょうなg /二丁投/
にちしゅくやすm /日祝休/
にだs /煮出/
にたt /煮立/
にたk /煮炊/
にたc /煮立/
にじりよt /躙り寄/
にじりよr /躙り寄/
にじりよn /躙り寄/
にじりよc /躙り寄/
にじりでy /躙り出/
にじりでt /躙り出/
にじりでs /躙り出/
にじりでr /躙り出/
にじりでn /躙り出/
にじりでm /躙り出/
にじゅううつs /二重写/
にじみでy /滲み出/
にじみでt /滲み出/
にじみでr /滲み出/
にじみでn /滲み出/
にじみでm /滲み出/
にじみだs /滲み出/
にじt /躙/
にじr /躙/
にじn /滲/躙/
にじm /滲/
にじc /躙/
にしむk /西向/
にしm /煮染/
にごt /濁/
にごs /濁/
にごr /濁/
にごn /濁/
にごc /濁/
にころg /煮転/
にこy /柔/和;NB:「なごy」と同形/
にこn /煮込/
にこm /煮込/
にげまわt /逃げ回/
にげまわr /逃げ回/
にげまわn /逃げ回/
にげまわc /逃げ回/
にげまどw /逃げ惑/
にげまどu /逃げ惑/
にげまどt /逃げ惑/
にげまどo /逃げ惑/
にげまどi /逃げ惑/
にげまどe /逃げ惑/
にげまどc /逃げ惑/
にげだs /逃げ出/
にげさt /逃げ去/
にげさr /逃げ去/
にげさn /逃げ去/
にげさc /逃げ去/
にげこn /逃げ込/
にげこm /逃げ込/
にげきt /逃げ切/
にげきr /逃げ切/
にげきn /逃げ切/
にげきc /逃げ切/
にげかくr /逃げ隠/
にげかえt /逃げ帰/
にげかえr /逃げ帰/
にげかえn /逃げ帰/
にげかえc /逃げ帰/
にげおくr /逃げ遅/
にげおおs /逃げ果/
にげおt /逃げ落/
にげおc /逃げ落/
にげうs /逃げ失/
にくみあw /憎み合/
にくみあu /憎み合/
にくみあt /憎み合/
にくみあo /憎み合/
にくみあi /憎み合/
にくみあe /憎み合/
にくみあc /憎み合/
にくばなr /肉離/
にくにくs /憎々/
にくづk /肉付/
にくづi /肉付/
にくずr /荷崩/煮崩/
にくおどt /肉踊/
にくおどr /肉踊/
にくおどn /肉踊/
にくおどc /肉踊/
にくt /憎/
にくs /憎/難;(hard) 考え難い NB:「がたi」と同形/悪;≒憎い/
にくr /憎/
にくn /憎/
にくm /憎/
にくk /憎/難;(hard) 考え難い NB:「がたi」と同形/悪;≒憎い/
にくi /憎/難;(hard) 考え難い NB:「がたi」と同形/悪;≒憎い/
にくg /憎/難;(hard) 考え難い NB:「がたi」と同形/悪;≒憎い/
にぎわw /賑/
にぎわu /賑/
にぎわt /賑/
にぎわo /賑/
にぎわi /賑/
にぎわe /賑/
にぎわc /賑/
にぎりつぶs /握り潰/
にぎりしm /握り締/
にぎはh /賑/
にぎにぎs /賑々/賑賑/
にぎy /賑/
にぎw /賑/
にぎt /握/
にぎr /握/
にぎn /握/
にぎc /握/
にきr /煮切;-り酒/
にがわらi /苦笑/
にがりきt /苦り切/
にがりきr /苦り切/
にがりきn /苦り切/
にがりきc /苦り切/
にがみばしt /苦み走/
にがみばしr /苦み走/
にがみばしn /苦み走/
にがみばしc /苦み走/
にがにがs /苦々/
にがs /苦/逃;非正則(にg)/
にがr /苦/
にがp /苦/
にがm /苦/
にがk /苦/
にがi /苦/
にがg /苦/
にかよw /似通/
にかよu /似通/
にかよt /似通/
にかよo /似通/
にかよi /似通/
にかよe /似通/
にかよc /似通/
におうだt /仁王立/
においたt /匂い立/
においたc /匂い立/
におy /匂;匂やか/
におw /匂/臭;(悪臭) 靴が臭う/
におu /匂/臭;(悪臭) 靴が臭う/
におt /匂/臭;(悪臭) 靴が臭う/
におr /荷下/
におo /匂/臭;(悪臭) 靴が臭う/
におi /匂;よい匂い/臭;いやな臭い/
におe /匂/臭;(悪臭) 靴が臭う/
におc /匂/臭;(悪臭) 靴が臭う/
にえたぎt /煮え滾/
にえたぎr /煮え滾/
にえたぎn /煮え滾/
にえたぎc /煮え滾/
にえたt /煮え立/
にえたc /煮え立/
にえくりかえt /煮え繰り返/
にえくりかえr /煮え繰り返/
にえくりかえn /煮え繰り返/
にえくりかえc /煮え繰り返/
にえきt /煮え切/
にえきr /煮え切/
にえきn /煮え切/
にえきc /煮え切/
にえs /贄/
にいt /兄/
にいs /兄/
にあw /似合/
にあu /似合/
にあt /似合/
にあo /似合/
にあi /似合/
にあg /荷揚/煮上/
にあe /似合/
にあc /似合/
にz /似/煮/
にy /煮/似/
にw /似/煮/
にu /似/煮/
にt /似/煮/
にs /似/煮/
にr /似/煮/
にp /似/煮/
にo /似/煮/
にn /似/荷/煮/
にm /似/煮/
にk /煮/似/
にj /似/煮/
にi /似/煮/
にh /似/煮/
にg /逃/迯;「逃」の異体字/似/煮/
にe /煮/似/
にd /似/煮/
にc /似/煮/
にb /似/煮/
にa /似/煮/
なんばんづk /南蛮漬/
なんなn /垂/
なんなk /難無/
なんとおr /何通/
なんz /難/何/
なんt /何/
なんr /何/
なんn /何/
なんk /何/
なんj /難/何/
なんd /何/
なわばr /縄張/
なれなれs /馴々/
なれそm /馴れ初/
なれしたs /慣れ親/
なれあw /馴れ合/
なれあu /馴れ合/
なれあt /馴れ合/
なれあo /馴れ合/
なれあi /馴れ合/
なれあe /馴れ合/
なれあc /馴れ合/
なるべk /成る可/
なりわたt /鳴り渡/
なりわたr /鳴り渡/
なりわたn /鳴り渡/
なりわたc /鳴り渡/
なりゆk /成り行/成行/
なりやn /鳴り止/
なりやm /鳴り止/
なりふr /形振/
なりひびk /鳴り響/
なりひびi /鳴り響/
なりはt /成り果/
なりだs /鳴り出/
なりたt /成り立/成立/
なりたc /成り立/成立/
なりすm /成り済/
なりさg /成り下/
なりきt /成り切/
なりきr /成り切/
なりきn /成り切/
なりきc /成り切/
なりかわt /成り代/
なりかわr /成り代/
なりかわn /成り代/
なりかわc /成り代/
なりかw /成り代/成り変/
なりあg /成り上/
ならべたt /並べ立/
ならべかe /並べ替/並べ換/並べ変/
ならびたt /並び立/
ならびたc /並び立/
ならびかe /並び換/
ならづk /奈良漬/
ならいおぼe /習い覚/
ならw /習/慣/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならu /習/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならt /習/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならs /均/
ならo /習/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならn /並/列;(行列を作る)「店の前に列ぶ」/竝;「並」の旧字/双;(匹敵する)「双ぶ者なし」/
ならi /習/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならh /習/
ならe /習/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならc /習/倣;imitate.「先人に倣う」/肄;<rare> ≒習う/
ならb /並/列;(行列を作る)「店の前に列ぶ」/双;(匹敵する)「双ぶ者なし」/竝;「並」の旧字/
なよs /名寄/
なやみおおk /悩み多/
なやn /悩/惱;旧字/
なやm /悩/惱;旧字/
なめらk /滑/
なめまわs /舐め回/嘗め回/
なめとt /舐め取/
なめとr /舐め取/
なめとn /舐め取/
なめとc /舐め取/
なめつくs /舐め尽;猫がミルクを-す/嘗め尽;辛酸を-す/
なめつk /嘗め尽;辛酸を-くす/舐め尽;蜜を-くす/
なめずt /舐/
なめずr /舐/
なめずn /舐/
なめずc /舐/
なめあw /舐め合/
なめあu /舐め合/
なめあt /舐め合/
なめあo /舐め合/
なめあi /舐め合/
なめあg /舐め上/
なめあe /舐め合/
なめあc /舐め合/
なめs /鞣/
なめr /滑/
なみはずr /並外/並み外/
なみのr /波乗/
なみだもろs /涙脆/
なみだもろk /涙脆/
なみだもろi /涙脆/
なみだもろg /涙脆/
なみだt /波立/
なみだs /涙/
なみだg /涙/
なみだc /波立/
なみうt /波打/
なみうc /波打/
なみいt /並み居;-る強豪たち/
なみいr /並み居;-る強豪たち/
なみs /蔑;サ変/
なまやさs /生易/
なまやk /生焼/
なまめs /艶/
なまめk /艶/
なまめi /艶/
なまめg /艶/
なまぬるs /生温/
なまぬるk /生温/
なまぬるi /生温/
なまぬるg /生温/
なまにe /生煮/
なまなまs /生々/生生/
なまっちろs /生っ白/
なまっちろk /生っ白/
なまっちろi /生っ白/
なまっちろg /生っ白/
なまじろs /生白/
なまじろk /生白/
なまじろi /生白/
なまじろg /生白/
なまじi /憖/
なまじh /憖/
なまごろs /生殺/
なまぐさs /生臭/腥/
なまぐさk /生臭/腥/
なまぐさi /生臭/腥/
なまぐさg /生臭/腥/
なまくr /鈍;名詞(-ら)/
なまがわk /生乾/
なまえまk /名前負/
なまえつk /名前付/
なまあたたk /生暖/
なまt /訛;発音が訛る/鈍;腕が鈍る/譌;「訛」の異体字/
なまs /生/
なまr /鈍;腕が鈍る/訛;発音が訛る/譌;「訛」の異体字/
なまn /鈍;腕が鈍る/訛;発音が訛る/譌;「訛」の異体字/生/
なまm /生/
なまk /怠/懶/
なまd /生/
なまc /鈍;腕が鈍る/訛;発音が訛る/譌;「訛」の異体字/
なほs /治/直/
なべt /並べ;※送り位置補正/
なぶりごろs /嬲り殺;-し/
なぶりころs /嬲り殺/
なぶt /嬲/嫐;<rare> =嬲る/
なぶr /嬲/嫐;<rare> =嬲る/
なぶn /嬲/嫐;<rare> =嬲る/
なぶc /嬲/嫐;<rare> =嬲る/
なびk /靡/
なびi /靡/
なのりでz /名乗り出/
なのりでy /名乗り出/
なのりでt /名乗り出/
なのりでs /名乗り出/
なのりでr /名乗り出/
なのりでn /名乗り出/
なのりでm /名乗り出/
なのりでk /名乗り出/
なのりでc /名乗り出/
なのt /名乗/名宣;<rare>/名告;=名乗る/
なのr /名乗/名告;=名乗る/名宣;<rare>/
なのn /名乗/名告;=名乗る/名宣;<rare>/
なのm /斜;[文語]/
なのc /名乗/名告;=名乗る/名宣;<rare>/
なにひとt /何一/
なにはさておk /何は扨措/
なにはさておi /何は扨措/
なにげなs /何気無/
なにげなk /何気無/
なにげなi /何気無/
なにげなg /何気無/
なにげn /何気/
なにくw /何食/何喰/
なにかんがe /何考/
なにかt /何彼/
なにw /何/
なにt /何/
なにs /何/
なにn /何/
なにm /何/
なにk /何/
なにg /何/
ななまがr /七曲/
ななころびやおk /七転び八起/
ななこおr /斜子織/魚子織/
ななt /七/
ななs /名無/
ななm /斜/
なでまわs /撫で回/
なでつk /撫で付/
なでさすt /撫で擦/
なでさすr /撫で擦/
なでさすn /撫で擦/
なでさすc /撫で擦/
なであg /撫で上/
なづけt /名付け;※送り位置補正/
なづn /泥/
なづm /泥/
なづk /名付/
なつやすm /夏休/
なつむk /夏向/
なつまつr /夏祭/
なつかs /懐/懷;「懐」の旧字(人名用漢字)/
なつk /懐/懷;「懐」の旧字(人名用漢字)/
なっとくいただk /納得頂/
なっとくいただi /納得頂/
なっとくいt /納得行/
なっとくいk /納得行/
なっとくいc /納得行/
なっとくs /納得/
なだれこn /雪崩れ込/傾れ込/なだれ込/
なだれこm /雪崩れ込/傾れ込/なだれ込/
なだめすかs /宥め賺/
なだかs /名高/
なだかk /名高/
なだかi /名高/
なだかg /名高/
なだt /名立/
なだr /雪崩/傾;(傾く。崩れ落ちる。)/
なだm /宥/
なぞらu /準/擬/准;「準」の略字/凖;「準」の異体字/
なぞらh /準/擬/准;「準」の略字/凖;「準」の異体字/
なぞらe /準/擬/准;「準」の略字/
なぞとk /謎解/
なぞかk /謎掛/
なぞm /謎/
なぜn /何故/
なずらu /準/擬/准;「準」の略字/凖;「準」の異体字/
なずらh /準/擬/准;「準」の略字/凖;「準」の異体字/
なずn /泥/
なずm /泥/
なすりつk /擦り付;NB:「こすりつk」「すりつk」と同形/
なすt /擦;NB:「こすr」「すr」と同形/
なすr /擦;NB:「こすr」「すr」と同形/
なすn /擦;NB:「こすr」「すr」と同形/
なすc /擦;NB:「こすr」「すr」と同形/
なじみぶかs /馴染み深/
なじみぶかk /馴染み深/
なじみぶかi /馴染み深/
なじみぶかg /馴染み深/
なじt /詰/
なじr /詰/
なじn /馴染/詰/
なじm /馴染/
なじc /詰/
なしとg /成し遂/為し遂/
なしくずs /済し崩/なし崩/
なしえz /為し得/
なしえy /為し得/
なしえt /為し得/
なしえs /為し得/
なしえr /為し得/
なしえn /為し得/
なしえm /為し得/
なしえc /為し得/
なしうr /為し得/
なしうb /為し得/
なざs /名指/
なさけぶかs /情深/情け深/
なさけぶかk /情深/情け深/
なさけぶかi /情け深/情深/
なさけぶかg /情け深/情深/
なさけなs /情無/情け無/
なさけなk /情無/情け無/
なさけなi /情無/情け無/
なさけなg /情無/情け無/
なさけしr /情け知/
なさk /情/
なごりおs /名残惜/
なごやk /和や;※送り位置補正/
なごy /和/
なごr /名残/
なごn /和/
なごm /和/
なげわたs /投げ渡/
なげやt /投げ遣/
なげやr /投げ遣/
なげやn /投げ遣/
なげやc /投げ遣/
なげづr /投げ釣/
なげつk /投げ付/
なげだs /投げ出/
なげすt /投げ捨;「テレビを窓から投げ捨てろ」/
なげこn /投げ込/投込/
なげこm /投げ込/投込/
なげきかなs /嘆き悲/
なげかえs /投げ返/
なげかk /投げ掛/
なげおt /投げ落/
なげおr /投げ下/
なげうt /抛/擲;≒抛つ/
なげうc /抛/擲;≒抛つ/
なげいr /投げ入/
なげあw /投げ合/
なげあu /投げ合/
なげあt /投げ合/
なげあo /投げ合/
なげあi /投げ合/
なげあg /投げ上/
なげあe /投げ合/
なげあc /投げ合/
なげk /嘆/歎;≒嘆く (字義:溜め息が出る)/慨;<rare> (字義:胸が詰まる)/
なげi /嘆/歎;≒嘆く (字義:溜め息が出る)/慨;<rare> (字義:胸が詰まる)/
なげe /長/
なけr /泣け;※送り位置補正/
なぐりつk /殴り付/
なぐりたおs /殴り倒/
なぐりころs /殴り殺/
なぐりこn /殴り込/
なぐりこm /殴り込/
なぐりかk /殴り掛/
なぐりあw /殴り合/
なぐりあu /殴り合/
なぐりあt /殴り合/
なぐりあo /殴り合/
なぐりあi /殴り合/
なぐりあe /殴り合/
なぐりあc /殴り合/
なぐさめあw /慰め合/
なぐさめあu /慰め合/
なぐさめあt /慰め合/
なぐさめあo /慰め合/
なぐさめあi /慰め合/
なぐさめあe /慰め合/
なぐさめあc /慰め合/
なぐさn /慰/
なぐさm /慰/
なぐt /殴/撲/毆;「殴」の旧字/擲/
なぐr /殴/撲/擲/毆;「殴」の旧字/
なぐn /殴/撲/擲/毆;「殴」の旧字/
なぐc /殴/撲/擲/毆;「殴」の旧字/
なくなk /泣く泣/
なぎはらw /薙ぎ払/
なぎはらu /薙ぎ払/
なぎはらt /薙ぎ払/
なぎはらo /薙ぎ払/
なぎはらi /薙ぎ払/
なぎはらe /薙ぎ払/
なぎはらc /薙ぎ払/
なぎたおs /薙ぎ倒/
なきわめk /泣き喚/
なきわめi /泣き喚/
なきわかr /泣き別/
なきやn /泣き止/鳴き止/
なきやm /泣き止/鳴き止/
なきふs /泣き伏/
なきはらs /泣き腫/
なきはr /泣き腫/
なきねいr /泣き寝入/
なきぬr /泣き濡/
なきつづk /泣き続/
なきつくs /泣き尽/
なきつかr /泣き疲/
なきつk /泣き付/
なきつi /泣き付/
なきだs /泣き出/
なきたt /泣き立/
なきそぼt /泣き濡/
なきしずn /泣き沈/
なきしずm /泣き沈/
なきしきt /鳴き頻;百舌が-る/泣き頻/
なきしきr /鳴き頻;百舌が-る/泣き頻/
なきしきn /鳴き頻;百舌が-る/泣き頻/
なきしきc /鳴き頻;百舌が-る/泣き頻/
なきさけn /泣き叫/
なきさけb /泣き叫/
なきくらs /泣き暮/
なきくずr /泣き崩/
なきくr /泣き暮/
なきかわs /鳴き交/
なきかw /鳴き交/
なきかr /泣き嗄/
なきおとs /泣き落/泣落/
なきおt /泣き落/
なきあk /泣き明/
ながれゆk /流れ行/
ながれでy /流れ出/
ながれでt /流れ出/
ながれでs /流れ出/
ながれでr /流れ出/
ながれでn /流れ出/
ながれでm /流れ出/
ながれつづk /流れ続/
ながれだs /流れ出/
ながれこn /流れ込/
ながれこm /流れ込/
ながれおt /流れ落/
ながれおc /流れ落/
ながれあるk /流れ歩/
ながれあるi /流れ歩/
ながらh /存/
ながらe /存;-える/
ながもt /長持/
ながもc /長持/
ながめやt /眺め遣/
ながめやr /眺め遣/
ながめやn /眺め遣/
ながめやc /眺め遣/
ながほそs /長細/
ながほそk /長細/
ながほそi /長細/
ながほそg /長細/
ながびs /長引/
ながびk /長引/
ながびi /長引/
ながびg /長引/
ながながs /長々/
ながつづk /長続/
ながすぎr /長過/
ながすg /長過/
ながしつづk /流し続/
ながしさt /流し去/
ながしさr /流し去/
ながしさn /流し去/
ながしさc /流し去/
ながしこn /流し込/
ながしこm /流し込/
ながしうt /流し打/
ながしうc /流し打/
ながいk /長生/
ながt /長/
ながs /流/長/永/
ながr /流/長;-らく,-らえる/永/乍;(助動詞) 聞き乍ら/存;(ながらe?)/
ながm /眺/長/詠;詩歌をうたう NB:「よm」と同形/
ながk /長/永/
ながi /長/永/
ながg /長/永/
ながb /長/
なかよs /仲良/
なかよk /仲良/
なかまわr /仲間割/
なかまはずr /仲間外/
なかまいr /仲間入/
なかぬk /中抜/
なかづr /中吊/
なかだるm /中弛/
なかだt /仲立/
なかだc /仲立/
なかたがi /仲違/
なかじm /中締/
なかおt /中落/
なかおs /中押/
なかt /中;中つ枝,中つ道,中つ国/
なかr /勿/莫;-れ/
なかn /中/
なかb /半/
なおよs /尚良/
なおっt /直/
なおt /直;故障が直る/治;ケガが治る/
なおs /直;故障を直す/治;病を治す/癒;NB:「いやs」と同形/
なおr /直;故障が直る/治;ケガが治る/
なおn /直;故障が直る/治;ケガが治る/
なおc /直;故障が直る/治;ケガが治る/
なうt /名う;※送り位置補正/
ないまz /綯い交/
ないがしr /蔑/
なz /撫/
なw /綯/
なu /綯/
なt /鳴/成/綯/生;実が生る/為/爲;「為」の旧字(人名用漢字)/
なs /無/成;財を成す (「作る」の意が強い)/為;業績を為す (「行う」の意が強い)/生;子を生す/做;見做す/爲;「為」の旧字(人名用漢字)/亡;(dead)父も今は亡い/
なr /慣/鳴/成/生;実が生る/馴;馴れた犬/為/熟;熟れ寿司/狎;人間関係について言う時の「なれる」/爲;「為」の旧字(人名用漢字)/
なo /綯/
なn /鳴/成/生;実が生る/為/爲;「為」の旧字(人名用漢字)/
なm /並/舐;(字義:ペロリとなめる)/嘗;(字義:舌に乗せて味を見る)/無;(神を)-みする(=蔑ろにする)/竝;「並」の旧字/
なk /泣/鳴/亡;(死なれる)「母を亡くす」/失;(字義:手から滑り落ちる)「財布を失くす」/無/啼;声を出して泣く／鳴く/哭;号泣する/涕;涙を流す/嚶;鳥が鳴く/啾;細い声で泣く/
なi /無/泣/鳴/亡;(dead)父も今は亡い/綯/凪;海が凪ぐ/啼;声を出して泣く／鳴く/哭;号泣する/涕;涙を流す/嚶;鳥が鳴く/啾;細い声で泣く/薙;薙ぎ倒す/
なh /綯/
なg /投/凪;海が凪ぐ/薙;薙ぎ倒す/無/
なe /萎/痿;<rare>/綯/
なd /撫/名;-だたる/
なc /綯/鳴/成/生;実が生る/為/爲;「為」の旧字(人名用漢字)/
なb /並;-べて/
どんづまr /どん詰/
どんづm /どん詰/
どんくさs /鈍臭/
どんくさk /鈍臭/
どんくさi /鈍臭/
どんくさg /鈍臭/
どんs /鈍/
どわすr /度忘/
どろよk /泥除/
どろくさs /泥臭/
どろくさk /泥臭/
どろくさi /泥臭/
どろくさg /泥臭/
どよm /響;どよめく/響動/
どもt /吃/
どもr /吃/土盛/
どもn /吃/
どもc /吃/
どなりつk /怒鳴り付/
どなりちr /怒鳴り散/
どなりたt /怒鳴り立/
どなりこn /怒鳴り込/
どなりこm /怒鳴り込/
どなりあw /怒鳴り合/
どなりあu /怒鳴り合/
どなりあt /怒鳴り合/
どなりあo /怒鳴り合/
どなりあi /怒鳴り合/
どなりあe /怒鳴り合/
どなりあc /怒鳴り合/
どなt /怒鳴/
どなr /怒鳴/
どなn /怒鳴/
どなc /怒鳴/
どすぐろs /どす黒/ドス黒/
どすぐろk /どす黒/ドス黒/
どすぐろi /どす黒/ドス黒/
どすぐろg /どす黒/ドス黒/
どしゃぶr /土砂降/
どしゃくづr /土砂崩/
どしがたs /度し難/
どしがたk /度し難/
どしがたi /度し難/
どしがたg /度し難/
どこm /何処/
どこk /何処/
どくどくs /毒々/
どくづk /毒突/
どくづi /毒突/
どくけs /毒消/
どくいr /毒入/
どくs /毒/
どおs /遠/通;(連濁) 負け通し,立ち通し,千枚通し/
どおr /通/
どおm /遠/
どおk /遠/
どおi /遠/
どおg /遠/
どうようn /同様/
どうまわr /胴回/
どうせきs /同席/
どうじょうやぶr /道場破/
どうじn /同時/
どうじm /胴締/
どうけt /道化/
どうけr /道化/
どうけn /道化/
どうけc /道化/
どうぐだt /道具立/
どうきづk /動機付/
どうあg /胴上/
どうz /動/同/
どうr /通;※仮名遣い「どお-り」/
どうj /動/同/
どあi /度合/
どt /取/録/
どs /度/
どr /取/録/何/
どn /何;-の/取/録/
どm /止/留;局留め,靴下留め,札留め/
どk /退/解/融/
どi /退/
どc /取/録/
とんぼがえr /蜻蛉返/
とんでゆk /飛んで行/
とんでいt /飛んで行/
とんでいk /飛んで行/
とんでいc /飛んで行/
とんがt /尖/
とんがr /尖/
とんがn /尖/
とんがc /尖/
とろs /トロ/
とろk /蕩/盪;<rare> ≒蕩/トロ;[口]/
とろi /トロ/
とろg /トロ/
とりわすr /取り忘/
とりわk /取り分/取分/
とりよs /取り寄/取寄/鳥寄/
とりやm /取り止/
とりもなおs /取りも直/
とりもどs /取り戻/
とりもt /取り持/
とりもc /取り持/
とりむすn /取り結/
とりむすb /取り結/
とりみだs /取り乱/
とりまわs /取り回/取回/
とりまとm /取り纏/
とりまぎr /取り紛/
とりまz /取り混/
とりまk /取り巻/取巻/
とりまi /取り巻/取巻/
とりひろg /取り広/
とりひk /取り引/取引/
とりはらw /取り払/
とりはらu /取り払/
とりはらt /取り払/
とりはらo /取り払/
とりはらi /取り払/
とりはらe /取り払/
とりはらc /取り払/
とりはずs /取り外/取外/
とりはこn /取り運/
とりはこb /取り運/
とりはかt /取り計/
とりはかr /取り計/
とりはかn /取り計/
とりはかc /取り計/
とりのぞk /取り除/取除/
とりのぞi /取り除/取除/
とりのこs /取り残/
とりのがs /取り逃/
とりのk /取り除/
とりにg /取り逃/
とりなおs /取り直/録り直;歌の-/撮り直;写真の-/
とりなs /執り成/取り成/
とりつぶs /取り潰/取潰/
とりつくろw /取り繕/取繕/
とりつくろu /取り繕/取繕/
とりつくろt /取り繕/取繕/
とりつくろo /取り繕/取繕/
とりつくろi /取り繕/取繕/
とりつくろe /取り繕/取繕/
とりつくろc /取り繕/取繕/
とりつくs /取り尽/
とりつk /取り付/取付/取り尽/取り憑;霊が取り憑く/
とりつi /取り付/取り次/取り憑;霊が取り憑く/取付/取次/
とりつg /取り次/取次/
とりちがe /取り違/
とりちr /取り散/
とりだs /取り出/取出/
とりたt /取り立/取立/
とりそろe /取り揃/
とりそこn /取り損/
とりすがt /取り縋;(袖に)-る/
とりすがr /取り縋;(袖に)-る/
とりすがn /取り縋;(袖に)-る/
とりすがc /取り縋;(袖に)-る/
とりすm /取り澄/
とりしらb /取調/取り調/
とりしまt /取締/取り締/
とりしまr /取締/取り締/取り締ま;※送り位置補正/
とりしまn /取締/取り締/
とりしまc /取締/取り締/
とりしきt /取り仕切/
とりしきr /取り仕切/
とりしきn /取り仕切/
とりしきc /取り仕切/
とりしm /取り締/取締/
とりさばk /取り捌/
とりさばi /取り捌/
とりさt /取り去/
とりさr /取り去/
とりさn /取り去/
とりさg /取り下/
とりさc /取り去/
とりこわs /取り壊/取壊/
とりころs /取り殺/
とりこぼs /取り零/
とりこs /取り越/
とりこn /取り込/取込/
とりこm /取り込/取込/
とりけs /取り消/取消/
とりくずs /取り崩/取崩/
とりくn /取り組/
とりくm /取り組/取組/
とりきt /取り切/
とりきr /取り切/
とりきn /取り切/
とりきm /取り決/取り極/
とりきc /取り切/
とりかわs /取り交/取交/
とりかたm /取り固/
とりかこn /取り囲/
とりかこm /取り囲/
とりかえs /取り返/
とりかw /取り交/取交/
とりかk /取り掛/
とりかe /取り替/取り換/
とりおとs /取り落/
とりおさe /取り抑/
とりおこなw /執り行/
とりおこなu /執り行/
とりおこなt /執り行/
とりおこなo /執り行/
とりおこなi /執り行/
とりおこなe /執り行/
とりおこなc /執り行/
とりおs /取り押/
とりおk /取り置/
とりおi /取り置/
とりえz /取り得/
とりえy /取り得/
とりえt /取り得/
とりえs /取り得/
とりえr /取り得/
とりえn /取り得/
とりえm /取り得/
とりえc /取り得/
とりうr /取り得/
とりうb /取り得/
とりいそi /取り急/
とりいそg /取り急/
とりいt /取り入/取入/
とりいr /取り入/取入/
とりいn /取り入/取入/
とりいc /取り入/取入/
とりあわs /取り合/
とりあらそw /取り争/
とりあらそu /取り争/
とりあらそt /取り争/
とりあらそo /取り争/
とりあらそi /取り争/
とりあらそe /取り争/
とりあらそc /取り争/
とりあつかw /取り扱/取扱/
とりあつかu /取り扱/取扱/
とりあつかt /取り扱/取扱/
とりあつかo /取り扱/取扱/
とりあつかi /取り扱/取扱/
とりあつかe /取り扱/取扱/
とりあつかc /取り扱/取扱/
とりあつm /取り集/
とりあw /取り合/取合/
とりあu /取り合/取合/
とりあt /取り合/取合/
とりあo /取り合/取合/
とりあi /取り合/取合/
とりあg /取り上/採り上/
とりあe /取り敢/取り合/取合/
とりあc /取り合/取合/
とらぶt /トラブ/
とらぶr /トラブ/
とらぶn /トラブ/
とらぶc /トラブ/
とらがr /虎刈/
とらw /囚;旧習に囚われる/捕;官憲に捕われる/捉/
とらk /蕩/盪/
とらh /囚/捉/捕/
とらe /捉;動きを捉える/捕;犯人を捕える/把/
ともばたらk /共働/
ともなw /伴/
ともなu /伴/
ともなt /伴/
ともなo /伴/
ともなi /伴/
ともなh /伴/
ともなe /伴/
ともなc /伴/
ともだおr /共倒/
ともぐi /共食/
ともかせg /共稼/
ともえなg /巴投/
ともt /灯/点/燈;「灯」の旧字(人名用漢字)/
ともs /灯/点/燈;「灯」の旧字(人名用漢字)/
ともr /灯/点/燈;「灯」の旧字(人名用漢字)/
ともn /共/伴/倶;-に/灯/点/燈;「灯」の旧字(人名用漢字)/
ともc /灯/点/燈;「灯」の旧字(人名用漢字)/
とめおk /留め置/
とめおi /留め置/
とむらw /弔/訪/
とむらu /弔/訪/
とむらt /弔/訪/
とむらo /弔/訪/
とむらi /弔/訪/
とむらe /弔/訪/
とむらc /弔/訪/
とみn /頓;-に(≒急に)/
とまりこn /泊まり込/
とまりこm /泊まり込/
とまどw /戸惑/
とまどu /戸惑/
とまどt /戸惑/
とまどo /戸惑/
とまどi /戸惑/
とまどe /戸惑/
とまどc /戸惑/
とまt /止/泊/停/留/佇/
とまr /泊/止/停/留/
とまn /泊/止/停/留/
とまc /泊/止/停/留/
とぼしi /乏し;※送り位置補正/
とぼs /乏/点/
とぼk /惚/恍/
とほのk /遠退/
とほs /通/徹/遠/
とほk /遠/
とほi /遠/
とほg /遠/
とぶらh /弔/訪/
とびまわt /飛び回/
とびまわr /飛び回/
とびまわn /飛び回/
とびまわc /飛び回/
とびはn /飛び跳/
とびのt /飛び乗/
とびのr /飛び乗/
とびのn /飛び乗/
とびのk /飛び退/跳び退/
とびのi /飛び退/跳び退/
とびのc /飛び乗/
とびぬk /飛び抜/
とびとb /飛び飛/
とびでz /飛び出/
とびでy /飛び出/
とびでt /飛び出/
とびでs /飛び出/
とびでr /飛び出/
とびでn /飛び出/
とびでm /飛び出/
とびでk /飛び出/
とびでc /飛び出/
とびつk /飛び付/
とびつi /飛び付/
とびちt /飛び散/
とびちr /飛び散/
とびちn /飛び散/
とびちc /飛び散/
とびだs /飛び出/飛出/
とびたt /飛び立/
とびたc /飛び立/
とびすさt /飛び退/
とびすさr /飛び退/
とびすさn /飛び退/
とびすさc /飛び退/
とびさt /飛び去/
とびさr /飛び去/
とびさn /飛び去/
とびさc /飛び去/
とびこs /飛び越/
とびこn /飛び込/飛込/
とびこm /飛び込/飛込/
とびこe /飛び越/跳び越/飛越/跳越/
とびかw /飛び交/
とびかu /飛び交/
とびかt /飛び交/
とびかo /飛び交/
とびかi /飛び交/
とびかe /飛び交/
とびかc /飛び交/
とびおr /飛び降/飛び下/
とびおk /飛び起/
とびうつt /飛び移/
とびうつr /飛び移/
とびうつn /飛び移/
とびうつc /飛び移/
とびいt /飛び入/飛入/
とびいr /飛び入/飛入/
とびいn /飛び入/飛入/
とびいc /飛び入/飛入/
とびあるk /飛び歩/
とびあるi /飛び歩/
とびあg /飛び上/跳び上/
とばs /飛/
となりあw /隣り合/隣合/
となりあu /隣合/隣り合/
となりあt /隣り合/隣合/
となりあo /隣合/隣り合/
となりあi /隣合/隣り合/
となりあe /隣合/隣り合/
となりあc /隣合/隣り合/
となr /隣/鄰;「隣」の異体字/
となh /唱/称/
となe /唱/称;(call) 名を称える NB:「たたe」と同形/稱;「称」の異体字/
とどろk /轟/軣;「轟」の異体字/
とどろi /轟/軣;「轟」の異体字/
とどまt /滞/
とどこおt /滞/滯;「滞」の旧字(人名用漢字)/
とどこおr /滞/滯;「滞」の旧字(人名用漢字)/
とどこおn /滞/滯;「滞」の旧字(人名用漢字)/
とどこおc /滞/滯;「滞」の旧字(人名用漢字)/
とどけでz /届け出/
とどけでy /届け出/
とどけでt /届け出/届出/
とどけでs /届け出/
とどけでr /届け出/届出/
とどけでn /届け出/届出/
とどけでm /届け出/
とどけでk /届け出/
とどけでc /届け出/届出/
とどm /留/止/停/畄;「留」の異体字/
とどk /届/屆;「届」の旧字/
とどi /届/屆;「届」の旧字/
ととのえr /整;非正則(ととのe)/
ととのw /整/調;支度|縁談が調う/斉/
ととのu /整/調;支度|縁談が調う/斉/
ととのt /整/調;支度|縁談が調う/斉/
ととのo /整/調;支度|縁談が調う/斉/
ととのi /整/調;支度|縁談が調う/斉/
ととのh /整/斉/調/
ととのe /整/調;準備を調える/斉/
ととのc /整/調;支度|縁談が調う/斉/
とてm /迚/
とつi /嫁/
とつg /嫁/
とっぱらw /取っ払/
とっぱらu /取っ払/
とっぱらt /取っ払/
とっぱらo /取っ払/
とっぱらi /取っ払/
とっぱらe /取っ払/
とっぱらc /取っ払/
とってつk /取って付/
とってかわt /取って代/
とってかわr /取って代/
とってかわn /取って代/
とってかわc /取って代/
とってかえs /取って返/
とってかw /取って代/
とっておk /取って置/
とっておi /取って置/
とっつかm /取っ捕/
とっつk /取っ付/
とっつi /取っ付/
とっしんs /突進/
とっくみあw /取っ組み合/
とっくみあu /取っ組み合/
とっくみあt /取っ組み合/
とっくみあo /取っ組み合/
とっくみあi /取っ組み合/
とっくみあe /取っ組み合/
とっくみあc /取っ組み合/
とっくn /取っ組/
とっくm /取っ組/
とっかかt /取っ掛/
とっかかr /取っ掛/
とっかかn /取っ掛/
とっかかc /取っ掛/
とっかk /取っ掛/
とっかe /取っ替/
とっk /疾っ;※送り位置補正/
とだe /途絶/跡絶/
とじまr /戸締/
とじこもt /閉じ籠/
とじこもr /閉じ籠/
とじこもn /閉じ籠/
とじこもc /閉じ籠/
とじこn /綴じ込/
とじこm /閉じ込/綴じ込/
とじあw /綴じ合/
とじm /戸締/
としよt /年寄/
としよr /年寄/
としよn /年寄/
としよc /年寄/
としとt /年取/
としとr /年取/
としとn /年取/
としとc /年取/
としこs /年越/
としおi /年老/
としあk /年明/
とざs /鎖/閉;非正則(とz)/
ところてんつk /心太突/
ところせまs /所狭/
ところせu /所狭/
ところせs /所狭/
ところせk /所狭/
ところかまw /所構/
とこずr /床擦/
とこs /常/
とげとげs /刺々/刺刺/
とけだs /溶け出/
とけこn /溶け込/
とけこm /溶け込/
とけあw /溶け合/
とけあu /溶け合/
とけあt /溶け合/
とけあo /溶け合/
とけあi /溶け合/
とけあc /溶け合/
とくべつあつかi /特別扱/
とくべつn /特別/
とくばらi /特払/
とくちょうづk /特徴付/
とくs /得/督;利払いを-する/
とくn /特;-に/得;-な(話)/
とくj /得/
とくd /得/
とぎれr /途切れ;※送り位置補正/
とぎすm /研ぎ澄/
とぎr /途切/跡切/
ときほぐs /溶き解;卵を-します/
ときふs /説き伏/
ときはなt /解き放/
ときはなs /解き放/
ときはなc /解き放/
ときつk /説き付/
ときおよn /説き及/
ときおよb /説き及/
ときあk /解き明/説き明/
ときn /時/
ときm /時/
とがめだt /咎め立/
とがt /尖/
とがr /尖/
とがn /尖/
とがm /咎/
とがc /尖/
とおりぬk /通り抜/
とおりすi /通り過;?/
とおりすg /通り過/
とおりこs /通り越/
とおりがk /通り掛/
とおりかかt /通り掛/
とおりかかr /通り掛/
とおりかかn /通り掛/
とおりかかc /通り掛/
とおまわs /遠回/
とおまわr /遠回/
とおまk /遠巻/
とおぼe /遠吠/
とおのr /遠乗/
とおのk /遠退/遠の;※送り位置補正/
とおのi /遠退/
とおすg /遠過/
とおz /遠/
とおt /通/透/徹/
とおs /通/遠/徹;自分のやり方で徹す (NB:「てっs」と同形)/透;光を透す/
とおr /通/透/徹/
とおn /遠/通/透/徹/
とおm /遠/
とおk /遠/
とおi /遠/
とおg /遠/
とおc /通/透/徹/
とうろくs /登録/
とうとu /疾う疾/
とうとs /尊/貴/
とうとn /尊;(respect) 仏法を尊ぶ/貴;(value) 和を貴ぶ/
とうとk /尊/貴/
とうとi /尊/貴/
とうとg /尊/貴/
とうとb /尊;(respect) 仏法を尊ぶ/貴;(value) 和を貴ぶ/
とうぜんn /当然/
とうすg /遠過/
とうじつうr /当日売/
とうこうs /投稿/
とうけつs /凍結/
とうz /投/
とうt /通;※仮名遣い「とお-って」/
とうs /通;※仮名遣い「とお-す」/父/
とうr /通;※仮名遣い「とお-る」/
とうn /当/
とうj /投/
といなおs /問い直/問直/
といつm /問い詰;小一時間問い詰めたい/問詰/
といただs /問い質/
といかえs /問い返/
といかk /問い掛/問掛;名詞・カ行下一/
といあわs /問合/問い合わ;※送り位置補正/
といあw /問い合/問合/
とz /閉/綴/閇;「閉」の異体字/
とw /問/訪;祖国を訪う/
とu /問/疾/訪;祖国を訪う/
とt /取/採;案を-/撮;写真を-/録;DVDを-/盗;(steal)金を-/捕;鼠を-/脱/獲;賞を-/摂;養分を-/執;指揮を-/穫;(harvest)野菜を-/秉;(手にとる)/
とs /賭;賭博/
とr /取/撮;写真を-/採;案を-/摂;養分を-/捕;鼠を-/獲;賞を-,クジラを-/録;DVDを-/執;指揮を-/盗;(steal)金を-/穫;(harvest)野菜を-/脱;<rare> 帽子を-/秉;(手にとる)/
とp /取/
とo /問/訪;祖国を訪う/
とn /飛;fly/富/跳;jump/翔;take wing/取;[口]-んないと/撮;写真を-/採;案を-/摂;養分を-/捕;鼠を-/獲;賞を-/録;DVDを-/執;指揮を-/盗;(steal)金を-/穫;(harvest)野菜を-/秉;(手にとる)/冨;「富」の旧字(人名用漢字)/脱;<rare> 帽子を-/
とm /止/泊;宿に泊まる/富/留;気に留める/停;(park)車を停める/冨;「富」の旧字(人名用漢字)/畄;「留」の異体字/
とk /解;謎|包装を解く/説;(preach)教えを説く/溶;水に溶ける/融;熱で融ける/疾/梳;髪を梳く NB:「すk」と同形/熔;鉄を熔かす/鎔;「熔」の異体字/觧;「解」の異体字/
とj /閉/綴/閇;「閉」の異体字/
とi /問/解;謎|秘密を解く/説;(preach)教えを説く/研;庖丁を研ぐ/觧;「解」の異体字/訪;祖国を訪う/溶;水に溶ける/梳;髪を梳く NB:「すk」と同形/熔;鉄を熔かす/鎔;「熔」の異体字/磨;お米を磨ぐ (「研ぐ」も可)/砥;≒研ぐ/
とh /問/
とg /遂/研;庖丁を研ぐ/磨;お米を磨ぐ (「研ぐ」も可)/砥;≒研ぐ/
とe /問/訪;祖国を訪う/
とd /綴/閉/
とc /取/撮;写真を-/採;案を-/摂;養分を-/捕;鼠を-/獲;賞を-/録;DVDを-/執;指揮を-/盗;(steal)金を-/穫;(harvest)野菜を-/秉;(手にとる)/脱;<rare> 帽子を-/
とb /飛;fly/跳;jump/翔;take wing/
でんちぎr /電池切/
でんげんぬk /電源抜/
でんげんぎr /電源切/
でんげんいr /電源入/
でやすs /出易/
でやすk /出易/
でやすi /出易/
でやすg /出易/
でもどt /出戻/
でもどr /出戻/
でもどn /出戻/
でもどc /出戻/
でむかe /出迎/
でむk /出向/
でむi /出向/
でまわt /出回/
でまわr /出回/
でまわn /出回/
でまわc /出回/
でまかs /出任/
でばらw /出払/
でばらu /出払/
でばらt /出払/
でばらo /出払/
でばらi /出払/
でばらe /出払/
でばらc /出払/
でばt /出張/
でばr /出張/
でばn /出張/
でばc /出張/
ではらw /出払/
ではらu /出払/
ではらt /出払/
ではらo /出払/
ではらi /出払/
ではらc /出払/
ではじm /出始/
ではいr /出入/
でにくs /出難/
でにくk /出難/
でにくi /出難/
でにくg /出難/
でなおs /出直/
でてゆk /出て行/
でてこz /出て来/
でてこy /出て来/
でてこs /出て来/
でてこr /出て来/
でてこn /出て来/
でてこi /出て来/
でてくr /出て来/
でてくn /出て来/
でてきy /出て来/
でてきt /出て来/
でてきs /出て来/
でてきn /出て来/
でてきm /出て来/
でてきd /出て来/
でてきc /出て来/
でていt /出て行/
でていk /出て行/
でていc /出て行/
でづっぱr /出突っ張/
でつづk /出続/
でつくs /出尽/
でつk /出尽/
でっぱなs /出っ放/
でっぱt /出張/出っ張/
でっぱr /出っ張/出張/
でっぱn /出っ張/出張/
でっぱc /出っ張/出張/
でっちあg /捏ち上/でっち上/
でだs /出出/
でたt /出立/
でぞm /出初/
でそろw /出揃/
でそろu /出揃/
でそろt /出揃/
でそろo /出揃/
でそろi /出揃/
でそろe /出揃/
でそろc /出揃/
ですg /出過/
でしいr /弟子入/
でくわs /出会/
でくw /出喰/出食/
でぎt /出切/
でぎr /出切/
でぎn /出切/
でぎc /出切/
できばe /出来栄/出来映/
できなs /出来無/
できなk /出来無/
できなi /出来無/
できなg /出来無/
できだかばらi /出来高払/
できそこn /出来損/
できすg /出来過/
できあi /出来合/
できあg /出来上/
できz /出来/
できy /出来/
できw /出来/
できu /出来/
できt /出来/
できs /出来/
できr /出来/
できp /出来/
できo /出来/
できn /出来/
できm /出来/
できk /出来/
できj /出来/
できi /出来/
できh /出来/
できg /出来/
できe /出来/
できd /出来/
できc /出来/
できb /出来/
できa /出来/
でかせg /出稼/
でかけr /出掛け;※送り位置補正/
でかs /出来/デカ/
でかm /デカ/
でかk /出掛/デカ/
でかi /デカ/
でかg /デカ/
でおくr /出遅/
でいr /出入/
であるk /出歩/
であるi /出歩/
であw /出会/出逢/出合/
であu /出会/出逢/出合/
であt /出会/出逢/出合/
であo /出会/出逢/出合/
であi /出会/出逢/出合/
であe /出会/出逢/出合/
であc /出会/出逢/出合/
でz /出/
でy /出/
でw /出/
でu /出/
でt /出/照/
でs /出/
でr /出/照/
でp /出/
でo /出/
でn /出/照/
でm /出/
でk /出/
でj /出/
でi /出/
でh /出/
でg /出/
でe /出/
でd /出/
でc /出/照/
でb /出/
でa /出/
てんぷいたs /添付致/
てんびk /天引/
てんぱt /テンパ/
てんぱr /テンパ/
てんぱn /テンパ/
てんぱc /テンパ/
てんばいかいもどs /転売買戻/
てんとr /点取/
てんたかk /天高/
てんこもr /天こ盛/
てんかいs /展開/
てんz /転/点/
てんj /転/点/
てをだs /手を出/
てわたs /手渡/
てわk /手分/
てれくさs /照れ臭/
てれくさk /照れ臭/
てれくさi /照れ臭/
てれくさg /照れ臭/
てりはe /照り映/
てりつk /照り付/
てりこn /照り込/
てりこm /照り込/
てりかがやk /照り輝/
てりかがやi /照り輝/
てりかえs /照り返/
てらしあわs /照らし合/照し合/
てらしあw /照らし合/照し合/
てらw /衒/
てらu /衒/
てらt /衒/
てらs /照/
てらo /衒/
てらi /衒/
てらh /衒/
てらe /衒/
てらc /衒/
てやわらk /手柔/
てやわr /手柔/
てもどr /手戻/
てもt /手持/
てもc /手持/
てむk /手向/
てまわs /手回/
てまねk /手招/
てまどt /手間取/
てまどr /手間取/
てまどn /手間取/
てまどc /手間取/
てほどk /手解/
てぶr /手振/手ぶ;※送り位置補正/
てびろs /手広/
てびろk /手広;-く商売する/
てびろi /手広/
てびかe /手控/
てびk /手引/
てひどs /手酷/
てひどk /手酷/
てひどi /手酷/
てひどg /手酷/
てばやs /手早/
てばやk /手早/
てばやi /手早/
てばやg /手早/
てばなs /手放/手離;NB:辞書にはない表記/
てはじm /手始/
てぬるs /手緩/
てぬるk /手緩/
てぬるi /手緩/
てぬるg /手緩/
てぬk /手抜/
てにはいt /手に入/
てにはいr /手に入/
てにはいn /手に入/
てにはいc /手に入/
てにいr /手に入/
てならi /手習/
てなずk /手懐/
てなおs /手直/
てなr /手慣/
てどr /手取/
てとりあしとr /手取り足取/
てとr /手取/
てづよs /手強/
てづよk /手強/
てづよi /手強/
てづよg /手強/
てづまr /手詰/
てづくr /手作/
てづかm /手掴/
てづm /手詰/
てつやあk /徹夜明/
てつづk /手続/
てつだw /手伝/
てつだu /手伝/
てつだt /手伝/
てつだo /手伝/
てつだi /手伝/
てつだe /手伝/
てつだc /手伝/
てつk /手付/
てっとりばやs /手っ取り早/
てっとりばやk /手っ取り早/
てっとりばやi /手っ取り早/
てっとりばやg /手っ取り早/
てっとr /手っ取/
てっs /徹/
てぢかn /手近/
てちがi /手違/
てだすk /手助/
てだt /手立/手出/
てだs /手出/
てだr /手練/
てすr /手摺/
てじm /手締/
てざわr /手触/
てざs /手差/
てさばk /手捌/
てさぐr /手探/
てさs /手差/
てさg /手提/
てごわs /手強/
てごわk /手強/
てごわi /手強/
てごわg /手強/
てごたh /手應/
てごたe /手応;手応え/手應;「応」旧字/
てこずt /梃摺/
てこずr /梃摺/
てこずn /梃摺/
てこずc /梃摺/
てこいr /梃入/テコ入/
てくらg /手暗/
てくばr /手配/
てぎわよs /手際良/
てぎわよk /手際良/
てぎわよi /手際良/
てぎr /手切/
てきびs /手厳/
てきとうn /適当/
てきs /適;適切/敵;衆寡敵せず/
てきn /的/
てきd /的/
てがたs /手堅/
てがたk /手堅/
てがたi /手堅/
てがたg /手堅/
てがかr /手掛/
てがk /手書/手掛/手懸;≒手掛ける,手掛かり/
ておくr /手遅/
ておt /手落/
ておs /手押/
ておi /手負/
ておc /手落/
てうt /手打;-ち(ウドン,になる)/
ていよk /体良;体裁よく/
ていたs /手痛/
ていたk /手痛/
ていたi /手痛/
ていたg /手痛/
ていせいいたs /訂正致/
ていしいたs /停止致/
ていぎづk /定義付/
ていきょうs /提供/
ていs /呈;(show) 活況を呈する/挺;身を挺する/訂;(correct) 原稿を訂する/締;?/
ていr /手入/
てあらs /手荒;手荒い祝福/
てあらk /手荒;手荒い祝福/手粗/
てあらi /手洗;お手洗い/手荒;手荒い祝福/
てあらg /手荒;手荒い祝福/
てあぶr /手焙/
てあつs /手厚/
てあつk /手厚/
てあつi /手厚/
てあつg /手厚/
てあw /手合/
てあt /手当/
てあm /手編/
てあi /手合/
てあg /手上/
てz /手/
てt /照/
てr /照/
てn /手/照/
てm /手/
てg /手/
てd /手/
てc /照/
づらs /辛/
づらk /辛/
づらi /辛/
づらg /辛/
づよs /強/
づよk /強/
づよi /強/
づよg /強/
づとm /勤/
づつn /包/
づつm /包/
づたi /伝/
づくs /尽/
づくr /作/造/做/
づきあi /付き合/
づかr /疲/
づかi /遣/使/
づr /連/釣/吊/
づm /積/詰/
づk /付/漬/突/
づi /付/
つんぼs /聾/
つんぼn /聾/
つんぼd /聾/
つんざk /劈/
つんざi /劈/
つれもどt /連れ戻/
つれもどs /連れ戻/
つれもどr /連れ戻/
つれもどn /連れ戻/
つれもどc /連れ戻/
つれまわs /連れ回/
つれてゆk /連れて行/
つれてこz /連れて来/
つれてこy /連れて来/
つれてこs /連れて来/
つれてこr /連れて来/
つれてこn /連れて来/
つれてこi /連れて来/
つれてくr /連れて来/
つれてくn /連れて来/
つれてきy /連れて来/
つれてきt /連れて来/
つれてきs /連れて来/
つれてきn /連れて来/
つれてきm /連れて来/
つれてきd /連れて来/
つれてきc /連れて来/
つれていt /連れて行/
つれていk /連れて行/
つれていc /連れて行/
つれだt /連れ立/
つれだs /連れ出/
つれだc /連れ立/
つれそw /連れ添/
つれそu /連れ添/
つれそt /連れ添/
つれそo /連れ添/
つれそi /連れ添/
つれそe /連れ添/
つれそc /連れ添/
つれさt /連れ去/
つれさr /連れ去/
つれさn /連れ去/
つれさc /連れ去/
つれこn /連れ込/連込/
つれこm /連れ込/連込/
つれかえt /連れ帰/
つれかえr /連れ帰/
つれかえn /連れ帰/
つれかえc /連れ帰/
つれあi /連れ合/
つるしあg /吊るし上/
つるs /吊/
つるn /交尾/連/
つるm /連/交尾/
つりだs /釣り出/吊り出/
つりさg /吊り下/
つりこn /釣り込/
つりこm /釣り込/
つりあw /釣り合/釣合/
つりあu /釣り合/釣合/
つりあt /釣り合/釣合/
つりあo /釣り合/釣合/
つりあi /釣り合/釣合/
つりあg /釣り上;魚を釣り上げる/吊り上;ロープで吊り上げる/釣上/
つりあe /釣り合/釣合/
つりあc /釣り合/釣合/
つらよごs /面汚/
つらぬきとおs /貫き通/
つらぬk /貫/
つらぬi /貫/
つらがまe /面構/
つらあt /面当/
つらs /辛/ツラ/
つらn /連/列/
つらk /辛/ツラ/
つらi /辛/ツラ/
つらg /辛/ツラ/
つよすg /強過/
つよs /強/
つよm /強/
つよk /強/
つよi /強/
つよg /強/
つゆはらi /露払/
つやがたr /艶語/
つやy /艶/
つやp /艶/
つもりつm /積もり積/
つもt /積/
つもr /積/
つもn /積/
つもc /積/
つめよt /詰め寄/
つめよr /詰め寄/
つめよn /詰め寄/
つめよc /詰め寄/
つめたs /冷/
つめたk /冷/
つめたi /冷/
つめたg /冷/
つめこn /詰め込/
つめこm /詰め込/
つめかk /詰め掛/
つめかe /詰め替/
つめあわs /詰め合/詰合/
つめあw /詰め合/
つめt /冷/詰/
つめr /詰/
つめn /詰/
つむt /瞑/
つむr /瞑/
つむn /瞑/
つむi /紡/
つむg /紡/
つむc /瞑/
つみまs /積み増/積増/
つみほr /罪滅;※送り過剰?/
つみぶかs /罪深/
つみぶかk /罪深/
つみぶかi /罪深/
つみぶかg /罪深/
つみのこs /積み残/積残/
つみなおs /積み直/積直/
つみとt /摘み取/
つみとr /摘み取/
つみとn /摘み取/
つみとc /摘み取/
つみつくr /罪作/
つみだs /積み出/
つみたt /積立/積み立/
つみこn /積み込/
つみこm /積み込/
つみかさn /積み重/積重/
つみかe /積み替/積替/
つみおr /積み降/
つみあg /積み上/積上/
つみs /罪/
つみn /罪/
つみd /罪/
つまみだs /撮み出/
つまみぐi /撮み食/
つまびr /詳/審/
つまびk /爪弾/
つまびi /爪弾/
つまはじk /爪弾/
つまどt /褄取/
つまどr /褄取/
つまどn /褄取/
つまどc /褄取/
つまづk /躓/
つまづi /躓/
つまずk /躓/
つまずi /躓/
つまさきだt /爪先立/
つまさきだc /爪先立/
つまt /詰/
つまs /倹/約;<rare>≒倹しい (字義:紐で引き締める)/
つまr /詰/
つまn /撮/摘/抓/詰/
つまm /摘/抓/撮/
つぼn /蕾;梅が蕾む/窄;NB:「すぼm」と同形/
つぼm /蕾;梅が蕾む/窄;NB:「すぼm」と同形/
つぶらs /円/
つぶらn /円/
つぶらd /円/
つぶよr /粒選/
つぶやk /呟/
つぶやi /呟/
つぶひとt /粒一/
つぶだt /粒立/
つぶだc /粒立/
つぶぞろi /粒揃/
つぶしあw /潰し合/
つぶしあu /潰し合/
つぶしあt /潰し合/
つぶしあo /潰し合/
つぶしあi /潰し合/
つぶしあe /潰し合/
つぶしあc /潰し合/
つぶt /瞑;目を瞑る/
つぶs /潰/
つぶr /潰/瞑;目を瞑る/円;円らな瞳/
つぶn /瞑;目を瞑る/
つぶc /瞑;目を瞑る/
つひe /潰/費/幣/
つばめがえs /燕返/
つばs /唾/
つのt /募/
つのr /募/
つのn /募/
つのc /募/
つねt /抓/
つねr /抓/
つねn /常/抓/
つねc /抓/
つなわたr /綱渡/
つなひk /綱引/
つなぎなおs /繋ぎ直/
つなぎとm /繋ぎ止/
つなぎこn /繋ぎ込/
つなぎこm /繋ぎ込/
つなぎかe /継ぎ換/
つながt /繋/
つながr /繋;非正則(つなg)/
つながn /繋;非正則(つなg)/
つながc /繋;非正則(つなg)/
つなi /繋/継/繼;「継」の旧字/
つなg /繋/継;(つぐ?)/繼;「継」の旧字/
つどw /集/
つどu /集/
つどt /集/
つどo /集/
つどi /集/
つどh /集/
つどe /集/
つどc /集/
つとめあg /勤め上/
つとn /夙/
つとm /努;(exert) 普及に努める/務;(act) 役目を務める/勤;(work for) 会社に勤める/勉;≒努める (字義:無理をする)/力/
つづりあw /綴り合/
つづまy /約;人は己を-やかにし/
つづt /綴/
つづr /綴/
つづn /綴/
つづm /約/
つづk /続/續;旧字/
つづi /続/續;旧字/
つづc /綴/
つつみこn /包み込/
つつみこm /包み込/
つつみかくs /包み隠/
つつまs /慎/
つつぬk /筒抜/
つつしみぶかs /慎み深/
つつしみぶかk /慎み深/
つつしみぶかi /慎み深/
つつしみぶかg /慎み深/
つつしn /慎;(be prudent)「言葉を慎む」/謹;(respect)「謹みて申し上げる」/愼;「慎」の旧字(人名用漢字)/
つつしm /慎;(be prudent)「言葉を慎む」/謹;(respect)「謹みて申し上げる」/愼;「慎」の旧字(人名用漢字)/
つつがなs /恙無/
つつがなk /恙無/
つつがなi /恙無/
つつがなg /恙無/
つつs /慎;非正則(つつしm)/謹;非正則(つつしm)/
つつn /包/慎;NB:「つつしm」と同形/裹;屍を-む/障;[文語]差し支える/恙;≒障む/
つつm /包/慎;NB:「つつしm」と同形/裹;屍を-む/障;[文語]差し支える/恙;≒障む/
つつk /突/突突/
つつi /突/突突/
つっぷs /突っ伏/
つっぱなs /突っ放/
つっぱしt /突っ走/
つっぱしr /突っ走/
つっぱしn /突っ走/
つっぱしc /突っ走/
つっぱt /突っ張/突張/
つっぱr /突っ張/突張/
つっぱn /突っ撥/突っ張/突張/
つっぱc /突っ張/突張/
つっつk /突っ突/
つっつi /突っ突/
つったt /突っ立/
つったc /突っ立/
つっこn /突っ込/突込/
つっこm /突っ込/突込/
つっきt /突っ切/
つっきr /突っ切/
つっきn /突っ切/
つっきc /突っ切/
つっかえs /突っ返/
つっかk /突っ掛/
つっかh /支/閊/
つっかe /支/閊;≒支える/
つちふr /霾/土降/
つちかw /培/
つちかu /培/
つちかt /培/
つちかo /培/
つちかi /培/
つちかe /培/
つちかc /培/
つだw /伝/傳;「伝」の旧字(人名用漢字)/
つだu /伝/傳;「伝」の旧字(人名用漢字)/
つだt /伝/傳;「伝」の旧字(人名用漢字)/
つだo /伝/傳;「伝」の旧字(人名用漢字)/
つだi /伝/傳;「伝」の旧字(人名用漢字)/
つだe /伝/傳;「伝」の旧字(人名用漢字)/
つだc /伝/傳;「伝」の旧字(人名用漢字)/
つたなs /拙/
つたなk /拙/
つたなi /拙/
つたなg /拙/
つたえきk /伝え聞/
つたえきi /伝え聞/
つたw /伝/傳;「伝」の旧字(人名用漢字)/
つたu /伝/傳;「伝」の旧字(人名用漢字)/
つたt /伝/傳;「伝」の旧字(人名用漢字)/
つたo /伝/傳;「伝」の旧字(人名用漢字)/
つたi /伝/傳;「伝」の旧字(人名用漢字)/
つたh /伝/傳;「伝」の旧字(人名用漢字)/
つたe /伝/傳;「伝」の旧字(人名用漢字)/
つたc /伝/傳;「伝」の旧字(人名用漢字)/
つずr /綴;※仮名遣い「つづr」/
つじつまあw /辻褄合/
つごうよs /都合良/
つごうよk /都合良/
つごうよi /都合良/
つこうまつt /仕/
つこうまつr /仕/
つこu /使/
つげしr /告げ知/
つけわすr /付け忘/
つけまわs /付け回/
つけねらw /付け狙/
つけねらu /付け狙/
つけねらt /付け狙/
つけねらo /付け狙/
つけねらi /付け狙/
つけねらe /付け狙/
つけねらc /付け狙/
つけっぱなs /付けっ放;テレビ-し/
つけだs /付け出/
つけたs /付け足/
つけこn /付け込/漬け込/
つけこm /付け込/漬け込/
つけくわw /付け加/
つけくわe /付け加/
つけかe /付け替/
つけいt /付け入/
つけいr /付け入/
つけいn /付け入/
つけいc /付け入/
つけあわs /付け合/
つけあw /付け合/
つけあg /付け上/
つぐなw /償/
つぐなu /償/
つぐなt /償/
つぐなo /償/
つぐなi /償/
つぐなe /償/
つぐなc /償/
つぐn /噤/鉗;<rare>≒噤む (字義:首枷)/
つぐm /噤/鉗;<rare>≒噤む (字義:首枷)/
つくろw /繕/
つくろu /繕/
つくろt /繕/
つくろo /繕/
つくろi /繕/
つくろh /繕/
つくろe /繕/
つくろc /繕/
つくりはじm /作り始/
つくりなおs /作り直/造り直/創り直/
つくりつづk /作り続/
つくりつk /作り付/
つくりだs /作り出/創り出/
つくりそこn /作り損/
つくりこn /作り込/
つくりこm /作り込/
つくりかe /作り替/作り変/創り変/
つくりおk /作り置/
つくりおi /作り置/
つくりあg /作り上/
つくらh /繕/
つくばt /蹲/
つくばr /蹲/
つくばn /蹲/
つくばc /蹲/
つくt /作/創;innovate/造;fabricate/做;「作」の異体字/
つくs /尽/盡;「尽」の旧字(人名用漢字)/殲;<rare> (全滅させる) 敵を殲す/殱;「殲」の異体字/
つくr /作/創;innovate/造;fabricate/做;「作」の異体字/
つくn /捏/作/創;innovate/造;fabricate/做;「作」の異体字/
つくc /作/創;innovate/造;fabricate/做;「作」の異体字/
つぎわk /注ぎ分/
つぎたs /継ぎ足;テープを継ぎ足す/注ぎ足;(液体) 酒を注ぎ足す/
つぎこn /つぎ込/注ぎ込/
つぎこm /つぎ込/注ぎ込/
つぎn /次/
つきやぶt /突き破/
つきやぶr /突き破/
つきやぶn /突き破/
つきやぶc /突き破/
つきまとw /付き纏/
つきまとu /付き纏/
つきまとt /付き纏/
つきまとo /付き纏/
つきまとi /付き纏/
つきまとe /付き纏/
つきまとc /付き纏/
つきばらi /月払/
つきはなs /突き放/
つきはじm /月初/月始;?/
つきはt /尽き果/
つきぬk /突き抜/
つきとおs /突き通/
つきとm /突き止/
つきとb /突き飛/
つきでy /突き出/
つきでt /突き出/
つきでr /突き出/
つきでn /突き出/
つきでm /突き出/
つきづk /付き付/
つきつm /突き詰/
つきつk /突き付/
つきっきr /付きっ切/
つきだs /突き出/突出/
つきたt /突き立/
つきそw /付き添/付添/
つきそu /付き添/付添/
つきそt /付き添/付添/
つきそo /付き添/付添/
つきそi /付き添/付添/
つきそe /付き添/付添/
つきそc /付き添/付添/
つきすすn /突き進/
つきすすm /突き進/
つきしたがw /付き従/
つきしたがu /付き従/
つきしたがt /付き従/
つきしたがo /付き従/
つきしたがi /付き従/
つきしたがe /付き従/
つきしたがc /付き従/
つきさs /突き刺/
つきころs /突き殺/
つきくずs /突き崩/
つきぎr /月切/
つきぎm /月極/
つきがk /月掛/
つきかえs /突き返/
つきおとs /突き落/
つきおくr /月遅/
つきおt /突き落/
つきうごk /突き動/衝き動/
つきあわs /突き合/
つきあw /突き合/付き合/付合/
つきあu /付き合/付合/
つきあt /付き合;-って/突き当;-たり/付合/
つきあo /付き合/付合/
つきあk /月明/
つきあi /付き合/付合/
つきあg /突き上/
つきあe /付き合/付合/
つきあc /付き合/付合/
つきm /拒;[文語]/
つがw /番/
つがu /番/
つがt /番/
つがo /番/
つがi /番/
つがh /番/
つがe /番/
つがc /番/
つかれはt /疲れ果/
つかれきt /疲れ切/
つかれきr /疲れ切/
つかれきn /疲れ切/
つかれきc /疲れ切/
つかみとt /掴み取/
つかみとr /掴み取/
つかみとn /掴み取/
つかみとc /掴み取/
つかみだs /掴み出/
つかみあw /掴み合/
つかみあu /掴み合/
つかみあt /掴み合/
つかみあo /掴み合/
つかみあi /掴み合/
つかみあc /掴み合/
つかまつt /仕/
つかまつr /仕/
つかまつn /仕/
つかまつc /仕/
つかさどt /司/掌/
つかさどr /司/掌/
つかさどn /司/掌/
つかさどc /司/掌/
つかうまつt /仕/
つかうまつr /仕/
つかうまつn /仕/
つかうまつc /仕/
つかいわk /使い分/
つかいやすs /使い易/
つかいやすk /使い易/
つかいやすi /使い易/
つかいやすg /使い易/
つかいまわs /使い回/
つかいふるs /使い古/
つかいばしr /使い走/
つかいはじm /使い始/
つかいはt /使い果/
つかいのこs /使い残/
つかいにくs /使い難/
つかいにくk /使い難/
つかいにくi /使い難/
つかいにくg /使い難/
つかいなr /使い慣/使い馴/
つかいづらs /使い辛/
つかいづらk /使い辛/
つかいづらi /使い辛/
つかいづらg /使い辛/
つかいつづk /使い続/
つかいつk /使い尽/
つかいだs /使い出/
つかいすt /使い捨/
つかいこなs /使い熟/
つかいこn /使い込/
つかいこm /使い込/
つかいきt /使い切/
つかいきr /使い切/
つかいきn /使い切/
つかいきc /使い切/
つかいおw /使い終/
つかいおe /使い終/
つかw /使/遣;(金|気|人形)を遣う/
つかu /使/遣;(金|気|人形)を遣う/
つかt /使/遣;(金|気|人形)を遣う/
つかr /疲/
つかo /使/遣;(金|気|人形)を遣う/
つかn /掴/束;-ねる NB:「たばn」と同形/把;≒掴む/攫;大金を攫む/
つかm /掴/捕/捉;-まえる/把;≒掴む/攫;大金を攫む/
つかi /使/遣;(金|気|人形)を遣う/
つかh /遣/仕/使/支/閊/
つかe /使/仕;(serve) 上司に仕える/支;(hinder) 差し支える/閊;<rare> ≒支える/障;<rare> ≒支える/遣;(金|気|人形)を遣う/
つかc /使/遣;(金|気|人形)を遣う/
つうほうs /通報/
つうじあw /通じ合/
つうじあu /通じ合/
つうじあt /通じ合/
つうじあo /通じ合/
つうじあi /通じ合/
つうじあe /通じ合/
つうじあc /通じ合/
つうz /通/
つうj /通/
ついやs /費/費や;※送り位置補正/
ついてまわt /付いて回/
ついてまわr /付いて回/
ついてまわn /付いて回/
ついてまわc /付いて回/
ついえさt /潰え去/
ついえさr /潰え去/
ついえさn /潰え去/
ついえさc /潰え去/
ついy /費/
ついt /就;非正則(つi)/ツイ/
ついn /遂;-に/対/
ついe /潰;希望が潰える/費;財産が費える/弊;<rare> ≒潰える/
ついd /序/
ついb /啄/
つt /釣;魚を釣る/吊;吊るす/突/攣;足を攣る/
つr /連/釣;魚を釣る/吊;吊るす/攣;足を攣る/
つn /積/摘;花を摘む,鼻を摘まむ/詰/釣;魚を釣る/吊;吊るす/攣;足を攣る/
つm /詰/積/摘;花を摘む,鼻を摘まむ/
つk /付/着/突/漬/尽/就;地位に就く/点;火を点ける/吐;嘘を吐く/衝;不意を衝く/憑;霊が憑く/撞;鐘を撞く/搗;米を搗く/尾;跡を尾ける/築;垣を築く/附;=付/浸;≒漬ける/盡;「尽」の旧字(人名用漢字)/點;「点」の旧字/
つi /付/着/突/継;語り継ぐ/憑;霊が憑く/次/就;地位に就く/附;=付/点;火を点ける/繼;「継」の旧字/吐;嘘を吐く/衝;不意を衝く/撞;鐘を撞く/搗;米を搗く/築;垣を築く/點;「点」の旧字/注;ビールを注ぐ/接;木に竹を接ぐ/嗣;跡目を嗣ぐ/椄;(つぎ木する)/支;?/
つg /継;語り継ぐ/注;ビールを注ぐ/次/告/接;木に竹を接ぐ/嗣;跡目を嗣ぐ/椄;(つぎ木する)/繼;「継」の旧字/
つc /釣;魚を釣る/吊;吊るす/攣;足を攣る/
ぢs /持/
ちんさg /賃下/
ちんがs /賃貸/
ちんがr /賃借/
ちんあg /賃上/
ちりばm /鏤/
ちりぢr /散り散/
ちょんぎt /ちょん切/
ちょんぎr /ちょん切/
ちょんぎn /ちょん切/
ちょんぎc /ちょん切/
ちょくせんみとおs /直線見通/
ちょくせついt /直接行/
ちょくせついk /直接行/
ちょくせついc /直接行/
ちょくn /直;-に/
ちょくd /直/
ちょうむすb /蝶結/
ちょうどよs /丁度良/
ちょうどよk /丁度良/
ちょうどよi /丁度良/
ちょうどよg /丁度良/
ちょうしわるs /調子悪/
ちょうしわるk /調子悪/
ちょうしわるi /調子悪/
ちょうしわるg /調子悪/
ちょうしよs /調子良/
ちょうしよk /調子良/
ちょうしよi /調子良/
ちょうしよg /調子良/
ちょうけs /帳消/
ちょうz /長/
ちょうs /徴;特徴/朝;朝食/弔;弔問/寵;寵愛/
ちょうj /長/
ちゅうもんとr /注文取/
ちゅうづr /宙吊/
ちゅうちょなk /躊躇無/
ちゅうしs /中止/
ちゅうこうr /中古売/
ちゅうがえr /宙返/
ちゅうかんあたr /中間辺/
ちゅうおうよs /中央寄/
ちゅうおうどおr /中央通/
ちゅういぶかs /注意深/
ちゅういぶかk /注意深/
ちゅういぶかi /注意深/
ちゅういぶかg /注意深/
ちゅういがk /注意書/
ちゅういs /注意/
ちゅうs /注;annotate/註;=注する/誅;(punish) 巨悪を誅する/沖;(ascent) 天に沖する/冲;≒沖する/
ちゃのm /茶飲/
ちゃづk /茶漬/
ちゃくばらi /着払/
ちゃくs /着/
ちゃくm /茶汲/
ちゃかs /茶化;(当て字)/
ちゃうk /茶請/
ちゃいろs /茶色/
ちゃいろp /茶色/
ちゃいろk /茶色/
ちゃいろi /茶色/
ちゃいろg /茶色/
ちゃp /茶/
ちまよw /血迷/
ちまよu /血迷/
ちまよt /血迷/
ちまよo /血迷/
ちまよi /血迷/
ちまよe /血迷/
ちまよc /血迷/
ちばなr /乳離/
ちばしt /血走/
ちばしr /血走/
ちばしn /血走/
ちばしc /血走/
ちぬt /釁/血塗/
ちぬr /血塗/釁/
ちぬn /血塗/釁/
ちぬc /血塗/釁/
ちなまぐさs /血腥/血生臭/
ちなまぐさk /血腥/血生臭/
ちなまぐさi /血腥/血生臭/
ちなまぐさg /血腥/血生臭/
ちなn /因/
ちなm /因/
ちつじょだt /秩序立/
ちつじょだc /秩序立/
ちっt /些/
ちぢみこn /縮み込/
ちぢみこm /縮み込/
ちぢみあg /縮み上/
ちぢr /縮/
ちぢn /縮/
ちぢm /縮/
ちぢk /縮/
ちちばなr /乳離/
ちちくりあw /乳繰り合/
ちちくりあu /乳繰り合/
ちちくりあt /乳繰り合/
ちちくりあo /乳繰り合/
ちちくりあi /乳繰り合/
ちちくりあe /乳繰り合/
ちちくりあc /乳繰り合/
ちちくさs /乳臭/
ちちくさk /乳臭/
ちちくさi /乳臭/
ちちくさg /乳臭/
ちちくt /乳繰/
ちちくr /乳繰/
ちちくn /乳繰/
ちちくc /乳繰/
ちちおやごろs /父親殺/
ちぞm /血染/
ちじn /縮/
ちじm /縮;※仮名遣い(ちぢm)/
ちこu /近/
ちぎt /千切/契;(promise) 「女と契る」/
ちぎr /千切/契;(promise) 「女と契る」/
ちぎn /千切/契;(promise) 「女と契る」/
ちぎc /千切/契;(promise) 「女と契る」/
ちがw /違/交;<rare>/
ちがu /違/交;<rare>/
ちがt /違/交;<rare>/
ちがo /違/交;<rare>/
ちがi /違/交;<rare>/
ちがh /違/交/
ちがe /違/交;<rare>/
ちがc /違/交;<rare>/
ちからもt /力持/
ちからもc /力持/
ちからまかs /力任/
ちからなs /力無/
ちからなk /力無/
ちからなi /力無/
ちからづよs /力強/
ちからづよk /力強/
ちからづよi /力強/
ちからづよg /力強/
ちからづk /力付/
ちからつk /力尽/
ちからぞe /力添/
ちかよt /近寄/
ちかよs /近寄/
ちかよr /近寄/
ちかよn /近寄/
ちかよc /近寄/
ちかづs /近付/
ちかづk /近付/
ちかづi /近付/
ちかづg /近付/
ちかすg /近過/
ちかいあw /誓い合/
ちかいあu /誓い合/
ちかいあt /誓い合/
ちかいあo /誓い合/
ちかいあi /誓い合/
ちかいあe /誓い合/
ちかいあc /誓い合/
ちかw /誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちかu /誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちかt /誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちかs /近/親;NB:「したs」と同形/誓/
ちかo /誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちかk /近/誓/
ちかi /近/誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちかh /誓/盟/
ちかg /近/誓/
ちかe /誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちかd /近/
ちかc /誓/盟;<rare> (字義:血を啜ってちかいあう)/
ちいさn /小さ;※送り位置補正/
ちいさk /小/
ちいs /小/
ちt /散/
ちs /小/治/
ちr /散/
ちn /散/
ちk /小/
ちg /血/
ちc /散/
ちb /禿/
だんどr /段取/
だんとr /段取/
だんづk /段付/
だんちがi /段違/
だんせいむk /男性向/
だんじこn /談じ込/
だんじこm /談じ込/
だんぐm /段組/
だんくm /段組/
だんz /断/談/弾/
だんj /断/談/弾/
だれかれかまw /誰彼構/
だれw /誰/
だれt /誰/
だれn /誰/
だれm /誰/
だれk /誰/
だれg /誰/
だれd /誰/
だるs /ダル/怠/懶/
だるk /怠/懶/ダル/
だるi /怠/懶/ダル/
だるg /怠/懶/ダル/
だよr /便/頼/
だめづm /駄目詰/
だめおs /駄目押/
だめp /駄目/
だまりこn /黙り込/
だまりこm /黙り込/
だましこn /騙し込/
だましこm /騙し込/
だましうt /騙し討/
だまt /黙/默;「黙」の旧字(人名用漢字)/
だまs /騙/
だまr /黙/溜/默;「黙」の旧字(人名用漢字)/
だまn /黙/默;「黙」の旧字(人名用漢字)/
だまc /黙/默;「黙」の旧字(人名用漢字)/
だべt /駄弁/
だべr /駄弁/
だべn /駄弁/
だべc /駄弁/
だぶt /ダブ/
だぶr /ダブ/
だぶn /ダブ/
だぶc /ダブ/
だっs /脱/
だっk /抱っ;※送り位置補正/
だだっぴろs /だだっ広/
だだっぴろk /だだっ広/
だだっぴろi /だだっ広/
だだっぴろg /だだっ広/
だしぬk /出し抜/
だしぬi /出し抜/
だしっぱなs /出しっ放;水道-し/
だししぶt /出し渋/
だししぶr /出し渋/
だししぶn /出し渋/
だししぶc /出し渋/
だしきt /出し切/
だしきr /出し切/
だしきn /出し切/
だしきc /出し切/
だしおs /出し惜/
だしいr /出し入/
だしあw /出し合/
だしあu /出し合/
だしあt /出し合/
だしあo /出し合/
だしあi /出し合/
だしあe /出し合/
だしあc /出し合/
だくs /諾;サ変/
だきよs /抱き寄/
だきとt /抱き取/
だきとr /抱き取/
だきとn /抱き取/
だきとm /抱き留/
だきとc /抱き取/
だきつk /抱き付/
だきつi /抱き付/
だきすくm /抱き竦/
だきしm /抱き締/
だきこn /抱き込/
だきこm /抱き込/
だきかかe /抱き抱/
だきおこs /抱き起/
だきおr /抱き下/
だきあわs /抱き合/
だきあw /抱き合/
だきあu /抱き合/
だきあt /抱き合/
だきあo /抱き合/
だきあi /抱き合/
だきあg /抱き上/
だきあe /抱き合/
だきあc /抱き合/
だおs /倒/
だおr /倒;(連濁) 掛け声-,議論-/
だいめいどおr /題名通/
だいぶちがu /大分違/
だいびk /代引/
だいなs /台無/
だいっきらi /大っ嫌/
だいたいおなz /大体同/
だいたいおなj /大体同/
だいすk /大好/
だいきらi /大嫌/
だいs /題/
だt /立/建/
だs /出/堕;放縦に堕する/
だr /垂/
だm /溜/澑;異体字/
だk /抱/炊/
だi /抱/
だc /立/
たんせいこm /丹精込/
たんじゅんn /単純/
たんいじかんあt /単位時間当/
たんz /嘆/歎/
たんn /単/單;「単」の旧字(人名用漢字)/
たんj /嘆/歎/
たをr /手折/
たをm /撓/
たわむr /戯/戲;「戯」の旧字(人名用漢字)/
たわぶr /戯/
たわいなs /たわい無/
たわいなk /たわい無/
たわいなi /たわい無/
たわw /撓;-わ(に稔る)/
たわn /撓/
たわm /撓/
たわk /戯/
たれながs /垂れ流/
たれさg /垂れ下/
たれこn /垂れ込/
たれこm /垂れ込/垂れ籠/
たるs /タル/
たるn /弛/
たるm /弛/
たるk /タル/
たるi /タル/
たるg /タル/
たらしこn /誑し込/
たらしこm /誑し込/
たらいまわs /盥回/
たらz /足ら;※送り位置補正/
たらs /誑/蕩/
たよりなs /頼り無/
たよりなk /頼り無/
たよりなi /頼り無/
たよt /頼/便;letter/
たよr /頼/便;letter/
たよn /頼/便;letter/
たよc /頼/便;letter/
たゆたw /揺蕩/
たゆたu /揺蕩/
たゆたt /揺蕩/
たゆたo /揺蕩/
たゆたi /揺蕩/
たゆたh /揺蕩/
たゆたe /揺蕩/
たゆたc /揺蕩/
たゆn /弛/
たゆm /弛/
たやすs /容易/
たやすk /容易/
たやすi /容易/
たやすg /容易/
たもちつづk /保ち続/
たもt /保/
たもc /保/
ためらw /躊躇/猶豫/
ためらu /躊躇/猶豫/
ためらt /躊躇/猶豫/
ためらo /躊躇/猶豫/
ためらi /躊躇/猶豫/
ためらh /躊躇/猶豫/
ためらe /躊躇/猶豫/
ためらc /躊躇/猶豫/
ためしずr /試し刷/
ためこn /溜め込/
ためこm /溜め込/
ためs /試/
ためn /為/爲;「為」の旧字(人名用漢字)/
ためd /為/
たむろs /屯/
たむk /手向/
たまわt /賜/承/
たまわr /賜/承/
たまわn /賜/承/
たまわc /賜/承/
たまりかn /堪り兼/
たまよk /弾除/
たまつk /玉突/
たまだs /玉出/
たまげt /魂消/
たまげr /魂消/
たまげn /魂消/
たまげc /魂消/
たまぎr /弾切/魂消/
たまきt /玉木/
たまいr /玉入/
たまw /賜;(grant) 「勲章を賜う」/給/
たまu /給/賜;(grant) 「勲章を賜う」/
たまt /溜/澑;異体字/給/賜;(grant) 「勲章を賜う」/堪;堪らない/
たまs /偶/
たまr /溜/堪;堪らない/澑;異体字/
たまo /給/賜;(grant) 「勲章を賜う」/
たまn /偶;sometimes.「-の休み」/溜/堪;堪らない/澑;異体字/
たまi /給/賜;(grant) 「勲章を賜う」/
たまh /給/賜/
たまe /給/賜;(grant) 「勲章を賜う」/
たまc /給/賜;(grant) 「勲章を賜う」/溜/澑;異体字/
たべはじm /食べ始/
たべのこs /食べ残/
たべつづk /食べ続/
たべつくs /食べ尽/
たべちr /食べ散/
たべそこn /食べ損/
たべすg /食べ過/
たべくらb /食べ比/
たべきt /食べ切/
たべきr /食べ切/
たべきn /食べ切/
たべきc /食べ切/
たべかk /食べ掛/
たべおw /食べ終/
たべおe /食べ終/
たべあわs /食べ合/
たべあるk /食べ歩/
たべあるi /食べ歩/
たべあw /食べ合/
たべあk /食べ飽/
たべt /食べ;※送り位置補正/
たべr /食べ;※送り位置補正/
たぶらk /誑/
たふとs /貴/尊/
たふとm /貴/尊/
たふとk /貴/尊/
たふとi /貴/尊/
たふとg /貴/尊/
たふs /倒/
たふr /倒/斃/
たびゆk /旅行/
たびなr /旅慣/
たびだt /旅立/
たびだc /旅立/
たびかさn /度重/
たびs /旅/
たばなs /手放/
たばさn /手挟/手挾;「挟」旧字/
たばさm /手挟/手挾;「挟」旧字/
たばかt /謀/
たばかr /謀/
たばかn /謀/
たばかc /謀/
たばn /束/
たはむr /戲/
たのもs /頼も;※送り位置補正/
たのみこn /頼み込/
たのみこm /頼み込/
たのs /楽/愉;(字義:わだかまりを取り去る)/娯;(字義:笑い興ずる)/樂;「楽」の旧字(人名用漢字)/
たのn /頼/恃;(あてにする) 自ら恃むところ/
たのm /頼/恃;(あてにする) 自ら恃むところ/
たねまk /種蒔/種播/
たねぎr /種切/
たねあかs /種明/
たねあk /種明/
たにまわr /谷回/
たなびk /棚引;雲が-く/
たなびi /棚引;雲が-く/
たなざらs /店晒/
たなおろs /棚卸/
たなあg /棚上/
たどりつk /辿り着/
たどりつi /辿り着/
たどt /辿/到;?/
たどr /辿/
たどn /辿/
たどc /辿/
たとh /喩/譬/
たとe /例;(仮定・具体例)「例えば」/喩;(比喩)「生を旅に喩える」/譬;≒喩 (字義:本筋から逸れる)/
たでくu /蓼食/
たてめぐt /立て巡/
たてめぐr /立て巡/
たてめぐn /立て巡/
たてめぐc /立て巡/
たてまつt /奉/
たてまつr /奉/
たてまつn /奉/
たてまつc /奉/
たてまs /建増/建て増/
たてなおs /立て直;態勢を-/建て直;ビルを-/立直/建直/
たてとおs /立て通/
たてつづk /立て続/
たてつk /建て付;扉の建て付けが悪い/楯突;親に楯突く/建付/盾突;=楯突く/
たてつi /楯突;親に楯突く/盾突/
たてこもt /立て籠/
たてこもr /立て籠/
たてこもn /立て籠/
たてこもc /立て籠/
たてこn /立て込/建て込/
たてこm /立て込/建て込/
たてぐm /縦組/
たてきt /立て切/閉て切;障子を-/
たてきr /立て切/閉て切;障子を-/
たてきn /立て切/閉て切;障子を-/
たてきc /立て切/閉て切;障子を-/
たてがk /縦書/
たてかk /立て掛/
たてかe /立て替;代金を立て替える/建て替;家を建て替える/建替/立替/
たづさh /攜/携/
たづくr /田作/
たづn /尋/訊/訪/
たっとs /尊/貴/
たっとn /尊/貴/
たっとk /尊/貴/
たっとi /尊/貴/
たっとg /尊/貴/
たっとb /尊/貴/
たっせいs /達成/
たっs /達/逹;異体字/
たちよt /立ち寄/立寄/
たちよr /立ち寄/立寄/
たちよn /立ち寄/立寄/
たちよm /立ち読/立読/
たちよc /立ち寄/立寄/
たちゆk /立ち行/
たちもどt /立ち戻/
たちもどr /立ち戻/
たちもどn /立ち戻/
たちもどc /立ち戻/
たちむk /立ち向/
たちまわt /立ち回/
たちまわr /立ち回/
たちまわn /立ち回/
たちまわc /立ち回/
たちまt /忽/
たちまj /立ち交/
たちふさg /立ち塞/
たちはたらk /立ち働/
たちはたらi /立ち働/
たちのぼt /立ち上/
たちのぼr /立ち上/
たちのぼn /立ち上/
たちのぼc /立ち上/
たちのk /立ち退/立退/
たちのi /立ち退/立退/
たちならn /立ち並/
たちならb /立ち並/
たちなおt /立ち直/
たちなおr /立ち直/
たちなおn /立ち直/
たちなおc /立ち直/
たちどおs /立ち通/
たちどm /立ち止/
たちとおs /立ち通/
たちつづk /立ち続/
たちつくs /立ち尽/
たちっぱなs /立ちっ放/
たちすくn /立ち竦/
たちすくm /立ち竦/
たちさt /立ち去/
たちさr /立ち去/
たちさn /立ち去/
たちさg /立ち下/
たちさc /立ち去/
たちこn /立ち込/
たちこm /立ち籠/立ち込/
たちぐi /立食/
たちくらn /立ち眩/
たちくらm /立ち眩/立ち暗;=立ち眩み/
たちぎk /立ち聞/
たちきt /断ち切/裁ち切/截ち切/
たちきr /断ち切/裁ち切/截ち切/
たちきn /断ち切/裁ち切/截ち切/
たちきk /立ち聞/
たちきi /立ち聞/
たちきc /断ち切/裁ち切/截ち切/
たちがr /立枯/立ち枯;[園芸]stand dead/
たちかえt /立ち返/
たちかえr /立ち返/
たちかえn /立ち返/
たちかえc /立ち返/
たちかw /立ち代/
たちおくr /立ち後/立ち遅/
たちうt /太刀打/
たちいたt /立ち至/
たちいたr /立ち至/
たちいたn /立ち至/
たちいたc /立ち至/
たちいt /立ち入/立入/
たちいr /立ち入/立入/
たちいn /立ち入/立入/
たちいc /立ち入/立入/
たちあるk /立ち歩/
たちあるi /立ち歩/
たちあらわr /立ち現/
たちあげr /立ち上げ;※送り位置補正/
たちあw /立会/立ち会/立ち合/立合/
たちあu /立ち会/立ち合/立合/立会/
たちあt /立ち合/立ち会/立合/立会/
たちあo /立ち会/立ち合/立合/立会/
たちあi /立合/立会/立ち会/立ち合/
たちあg /立ち上/起ち上/立上/
たちあe /立会/立ち会/立ち合/立合/
たちあc /立ち会/立ち合/立合/立会/
ただよw /漂/
ただよu /漂/
ただよt /漂/
ただよo /漂/
ただよi /漂/
ただよh /漂/
ただよe /漂/
ただよc /漂/
ただたんn /只単/
ただt /直/
ただs /正/但;但し書き/質;(問い質す) 趣意を質す/糺;(糾弾する) 不正を糺す/匡;(型に押し込めて形を直す)/
ただr /爛/糜;<rare>/
ただc /直/
たたみこn /畳み込/
たたみこm /畳み込/
たたみかk /畳み掛/
たたづm /佇/
たたっきt /叩っ斬/
たたっきr /叩っ斬/
たたっきn /叩っ斬/
たたっきc /叩っ斬/
たたずn /佇/彳/
たたずm /佇/彳/
たたきふs /叩き伏/
たたきなおs /叩き直/
たたきつぶs /叩き潰/
たたきつk /叩き付/叩きつ;※送り位置補正/
たたきだs /叩き出/
たたきこわs /叩き壊/
たたきころs /叩き殺/
たたきこn /叩き込/
たたきこm /叩き込/
たたききt /叩き切/
たたききr /叩き切/
たたききn /叩き切/
たたききc /叩き切/
たたきかえs /叩き返/
たたきおとs /叩き落/
たたきおこs /叩き起/
たたきおk /叩き起/
たたきうt /叩き売/
たたきうr /叩き売/
たたきうn /叩き売/
たたきうc /叩き売/
たたきあg /叩き上/
たたかw /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/斗;「闘」の略字/
たたかu /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/斗;「闘」の略字/戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/
たたかt /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/斗;「闘」の略字/
たたかo /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/斗;「闘」の略字/戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/
たたかi /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/斗;「闘」の略字/
たたかh /戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/
たたかe /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/戰;「戦」の旧字(人名用漢字)/斗;「闘」の略字/鬪;「闘」の旧字/
たたかc /戦;(字義:武器で敵を倒す)/闘;(字義:二者が向き合い争う)/斗;「闘」の略字/戰;「戦」の旧字(人名用漢字)/鬪;「闘」の旧字/
たたえt /湛/
たたえr /湛/
たたえn /湛/
たたえc /湛/
たたt /祟/
たたr /祟/
たたn /祟/畳/疊;「畳」の旧字(人名用漢字)/疉;「畳」の旧字2/疂;「畳」の旧字3/
たたm /畳/疊;「畳」の旧字(人名用漢字)/疉;「畳」の旧字2/疂;「畳」の旧字3/
たたk /叩/敲;(knock)「戸を敲く」/
たたi /叩/敲;(knock)「戸を敲く」/
たたh /称/湛/
たたe /称/讃/湛;水を-/賛/
たたc /祟/
たそがr /黄昏/
たずねいt /尋ね入/
たずねいr /尋ね入/
たずねいn /尋ね入/
たずねいc /尋ね入/
たずねあるk /訪ね歩/
たずねあるi /訪ね歩/
たずねあt /尋ね当/
たずさわt /携/
たずさわr /携/
たずさわn /携/
たずさわc /携/
たずさw /携/攜;異体字/
たずさe /携/攜;異体字/
たずn /尋;generic/訪;visit.「故国を訪ねる」/訊;inquire. 「道を訊ねる」/
たすけあw /助け合/
たすけあu /助け合/
たすけあt /助け合/
たすけあo /助け合/
たすけあi /助け合/
たすけあe /助け合/
たすけあc /助け合/
たすきぞr /襷反/
たすきがk /襷掛/
たすかr /助か;※送り位置補正/
たすk /助/援;(字義:手を差し伸べる)/扶;(字義:手で体を支えてやる)/佐;<rare>(字義:手を添える)/
たしょうちがu /多少違/
たしょうちがt /多少違/
たしょうちがi /多少違/
たしょうちがe /多少違/
たしょうたかs /多少高/
たしょうたかk /多少高/
たしょうたかi /多少高/
たしょうたかg /多少高/
たしょうおくr /多少遅/
たしなn /嗜;(like)詩を嗜む/
たしなm /嗜;(like)詩を嗜む/窘;(warn)非礼を窘める/
たしかめあw /確かめ合/
たしかめあu /確かめ合/
たしかめあt /確かめ合/
たしかめあo /確かめ合/
たしかめあi /確かめ合/
たしかめあe /確かめ合/
たしかめあc /確かめ合/
たしあわs /足し合/
たしあw /足し合/
たしk /確/慥;-か/
たけりたt /猛り立/
たけりたc /猛り立/
たけりくるw /猛り狂/
たけりくるu /猛り狂/
たけりくるt /猛り狂/
たけりくるo /猛り狂/
たけりくるi /猛り狂/
たけりくるc /猛り狂/
たけなわs /酣/闌;≒酣/
たけなわn /闌;≒酣/酣/
たけなわd /酣/闌;≒酣/
たけだけs /猛々/猛猛/
たけしたどおr /竹下通/
たけt /猛/哮;吠える/
たけs /猛/
たけr /猛/哮;吠える/
たけn /猛/哮;吠える/
たけk /猛/
たけi /猛/
たけc /猛/哮;吠える/
たけb /猛;[文語]-ぶ/建;≒猛ぶ/誥;≒猛ぶ/
たぐりよs /手繰り寄/
たぐりこn /手繰り込/
たぐりこm /手繰り込/
たぐu /比/類/
たぐt /手繰/
たぐr /手繰/
たぐn /手繰/
たぐi /類/
たぐh /比/類/
たぐc /手繰/
たくわe /蓄/貯/畜;<rare>/
たくらn /企/
たくらm /企/
たくまs /逞/
たくはh /蓄/貯/
たくs /託;委託/托;托卵/
たくr /綰/
たくn /巧/
たくm /巧/
たぎt /滾/激/
たぎr /滾/激/
たぎn /滾/激/
たぎc /滾/激/
たきつk /焚き付/焚付/
たきしm /薫き染/
たきこn /炊き込;炊き込みご飯/炊込/薫き込;香を薫き込む/
たきこm /炊き込;炊き込みご飯/炊込/薫き込;香を薫き込む/
たきあわs /炊き合/
たきあw /炊き合;筍とワカメを-わせる/
たきあg /炊き上;ふっくらと-げる/
たがやs /耕/畊;「耕」の異体字/畉;別字 (NB:「たがや・す」として使われる可能性は皆無)/
たがいちがi /互い違/
たがw /違/
たがu /違/
たがt /違/
たがo /違/
たがi /互/違/
たがh /違/
たがe /違/
たがc /違/
たかをくくt /高を括/
たかをくくr /高を括/
たかをくくn /高を括/
たかをくくc /高を括/
たからさがs /宝探/
たかぶt /昂/
たかぶr /昂/昂ぶ;※送り位置補正/亢ぶ;※送り位置補正/
たかぶn /昂/
たかぶc /昂/
たかのぞm /高望/
たかなt /高鳴/
たかなr /高鳴/
たかなn /高鳴/
たかなc /高鳴/
たかどm /高止/
たかてr /高照;‖枕詞(-らす)/
たかすg /高過/
たかt /集/
たかs /高/
たかr /集/高;高らか/
たかn /高/集/
たかm /高/
たかk /高/
たかi /高/
たかg /高;-が(知れた)/
たかc /集/
たかb /高/
たおれふs /倒れ伏/倒れ臥/
たおれこn /倒れ込/
たおれこm /倒れ込/
たおれr /殕/
たおしこn /倒し込/
たおしこm /倒し込/
たおy /嫋/
たおt /手折;花を手折る/
たおs /倒/
たおr /倒/手折;花を手折る/斃;(倒れて死ぬ) 戦地に斃れる/仆;(ぱたんと倒れる)/
たおn /手折;花を手折る/
たおc /手折;花を手折る/
たえまなs /絶え間無/
たえまなk /絶え間無/
たえまなi /絶え間無/
たえはt /絶え果/
たえぬk /耐え抜/
たえぬi /耐え抜/
たえだe /絶え絶/
たえしのn /堪え忍/
たえしのb /堪え忍/
たえきt /耐え切/
たえきr /耐え切/
たえきn /耐え切/
たえきc /耐え切/
たえがたs /耐え難/
たえがたk /耐え難/
たえがたi /耐え難/
たえがたg /耐え難/
たえかn /堪え兼/
たえいt /絶え入/
たえいr /絶え入/
たえいn /絶え入/
たえいc /絶え入/
たえz /絶え;※送り位置補正/
たえn /妙/
たうe /田植/
たいへんよs /大変良/
たいへんよk /大変良/
たいへんよi /大変良/
たいへんよg /大変良/
たいへんもうs /大変申/
たいへんおそs /大変遅/
たいへんおそk /大変遅/
たいへんおそi /大変遅/
たいへんおそg /大変遅/
たいげんどm /体言止/
たいおうづk /対応付/
たいおうs /対応/
たいあたr /体当/
たいあt /体当/
たいs /対/大/体;(obey)「意を体する」/對;「対」の旧字/帯/
たいr /平/
たあいなs /他愛無;当て字/
たあいなk /他愛無;当て字/
たあいなi /他愛無;当て字/
たy /絶/
たt /立/建/断/絶;消息を絶つ(途絶える)/経;時間が経つ/裁;布を裁つ/発;パリを発つ/起;風が起つ/截;截ち切る/勃;(erect)一物が勃つ/点;茶を点てる/閉;開け閉て/斷;「断」の旧字/發;「発」の旧字/經;「経」の旧字/強;?/
たs /足/誰;-そ/逹;「達」の異体字/
たr /垂/足/埀;「垂」の旧字/
たn /他/足/
たm /貯;(有用物) 金を貯める/溜/矯;(rectify) 癖を矯める/撓/揉/澑;「溜」の異体字/
たk /炊;飯を炊く/焚;風呂を焚く/長;一芸に長ける/薫;香を薫く/闌;≒長ける/
たi /炊;飯を炊く/焚;風呂を焚く/薫;香を薫く/
たh /他/堪/耐/
たe /耐/絶/堪;(値する) 見るに堪えない/
たc /立/断/経;時間が経つ/建/斷;「断」の旧字/絶;消息を絶つ(途絶える)/裁;布を裁つ/発;パリを発つ/起;風が起つ/截;截ち切る/勃/發;「発」の旧字/經;「経」の旧字/足/
たb /食/賜;[文語](バ行四段)/給;[文語](バ行四段)/
ぞんじあg /存じ上/
ぞんz /存/
ぞんj /存/
ぞろi /揃/
ぞろe /揃/
ぞくs /属/俗/
ぞくp /俗/
ぞくn /俗/
ぞくd /俗/
ぞうさなs /造作無/
ぞうさなk /造作無/
ぞうさなi /造作無/
ぞうs /蔵/
ぞt /反/
ぞr /反/
ぞn /反/
ぞm /初/染/
ぞi /沿/
ぞe /添/
ぞc /反/
そんざいs /存在/
そんz /損/
そんs /損/存/
そんn /損/
そんj /損/
そんd /損/
そろばんだかs /算盤高/
そろばんだかk /算盤高/
そろばんだかi /算盤高/
そろばんだかg /算盤高/
そろw /揃/
そろu /揃/
そろt /揃/
そろo /揃/
そろi /揃/
そろh /揃/
そろe /揃/
そろc /揃/
それとなk /其と無/
そりこn /剃り込/
そりこm /剃り込/
そりかえt /反り返/
そりかえr /反り返/
そりかえn /反り返/
そりかえc /反り返/
そりおとs /剃り落/
そらんz /諳/
そらんj /諳/
そらとぼk /空惚/
そらとb /空飛/
そらぞらs /空々/
そよi /戦/
そよg /戦/
そめわk /染め分/染分/
そめぬk /染め抜/
そめぬi /染め抜/
そめなおs /染め直;自分の色に-す/
そめだs /染め出/
そめこn /染め込/
そめこm /染め込/
そめあg /染め上/
そむk /背/叛;revolt/
そむi /背/叛;revolt/
そぼふt /そぼ降/
そぼふr /そぼ降/
そぼふn /そぼ降/
そぼふc /そぼ降/
そぼt /濡/
そぶr /素振/
そびえたt /聳え立/
そびえたc /聳え立/
そびe /聳/
そばだt /峙/
そねn /妬/嫉/猜/
そねm /妬/嫉/猜/
そなえつk /備え付/
そなw /備/具/
そなh /供/具/備/
そなe /供;(offer) お供え物/備;(prepare) 地震に備える/具;≒備える/
そとむk /外向/
そとまわr /外回/
そとづk /外付/
そとつk /外付/
そとがk /外掛/
そでぐr /袖刳/
そっけなs /素っ気無/
そっけなk /素っ気無/
そっけなi /素っ気無/
そだてあg /育て上/
そだt /育/毓;「育」の異体字/
そだr /具足/
そだc /育/毓;「育」の異体字/
そぞr /漫;-ろ/
そそりたt /聳り立/そそり立/
そそりたc /聳り立/そそり立/
そそばしt /遽走/
そそばしr /遽走/
そそばしn /遽走/
そそばしc /遽走/
そそのかs /唆/嗾;<rare> =唆す/
そそぎこn /注ぎ込/
そそぎこm /注ぎ込/
そそi /注/雪;(=すすg)「汚名を-ぐ」(cf.「雪辱」)/濯;(=すすg)「リンスを-ぐ」/灌;≒注ぐ/
そそg /注/灌;≒注ぐ/濯;(=すすg)「リンスを-ぐ」/雪;(=すすg)「汚名を-ぐ」(cf.「雪辱」)/
そしきだt /組織立/
そしt /謗;原義:あばく/誹;原義:言い立て、仲を裂く/譏;原義:鋭く問い質す/讒;原義:告げ口し陥れる/詆/
そしr /謗;原義:あばく/誹;原義:言い立て、仲を裂く/素知;当て字/そ知/譏;原義:鋭く問い質す/讒;原義:告げ口し陥れる/詆/
そしn /謗;原義:あばく/誹;原義:言い立て、仲を裂く/譏;原義:鋭く問い質す/讒;原義:告げ口し陥れる/詆/
そしc /謗;原義:あばく/誹;原義:言い立て、仲を裂く/譏;原義:鋭く問い質す/讒;原義:告げ口し陥れる/詆/
そこびe /底冷/
そこぬk /底抜/
そこなw /損/害/
そこなu /損/害/
そこなt /損/害/
そこなo /損/害/
そこなi /損/害/
そこなh /損/
そこなe /損/害/
そこなc /損/害/
そこしt /底知/
そこしr /底知/
そこしn /底知/
そこしc /底知/
そこいr /底入/
そこあg /底上/
そこn /損/害/
そぐw /似/
そぐu /似/
そぐt /似/
そぐo /似/
そぐi /似/
そぐe /似/
そぐc /似/
そくs /即;(即応) 実情に即する/則;(準則) 法に則する/促;(促進) 反省を促する/
そぎとt /削ぎ取/
そぎとr /削ぎ取/
そぎとn /削ぎ取/
そぎとc /削ぎ取/
そぎおとs /削ぎ落/
そうろu /候/
そうりょうちゃくばらi /送料着払/
そうらw /候/
そうらi /候/
そうらe /候/
そうめいs /聡明/
そうめいd /聡明/
そうふいただk /送付頂/
そうふいたs /送付致/
そうなm /総嘗/
そうとうn /相当/
そうていs /想定/
そうだんくだs /相談下/
そうだt /総立/
そうぞうs /騒々/
そうそu /然う然/
そうけだt /総毛立/
そうけだc /総毛立/
そうくずr /総崩/
そうz /総/
そうs /奏;「帝に奏する」「功を奏する」/草;「原稿を草する」/相/
そうn /躁;⇔鬱/
そうj /総/
そうd /躁;⇔鬱/
そいとg /添い遂/
そあくn /粗悪/
そw /沿;(go along) 道に沿う/添;寄り添う/副/
そu /沿;(go along) 道に沿う/添;寄り添う/副/
そt /沿;(go along) 道に沿う/添;寄り添う/剃;(shave)髭を剃る/反;(curve)板が反る/副/
そs /素/
そr /剃;(shave)髭を剃る/逸;(stray)話が逸れる/反;(curve)板が反る/其;-れ/
そo /沿;(go along) 道に沿う/添;寄り添う/副/
そn /其/素/剃;(shave)髭を剃る/反;(curve)板が反る/
そm /染/初;知り初める/
そi /沿;(go along) 道に沿う/添;寄り添う/副/削/殺/
そh /沿/添/副/
そg /削/殺/
そe /添;寄り添う/沿;(go along) 道に沿う/副/
そd /素/
そc /沿;(go along) 道に沿う/添;寄り添う/副/剃;(shave)髭を剃る/反;(curve)板が反る/
ぜんだt /膳立/
ぜんk /前/
ぜひきk /是非聞/
ぜひきi /是非聞/
ぜにうしなi /銭失/
ぜっくs /絶句/
ぜっs /絶/
ぜいぬk /税抜/
ぜいこm /税込/
ぜm /責/攻/
せんもんかむk /専門家向/
せんまいどおs /千枚通/
せんまいづk /千枚漬/
せんびk /線引/
せんぬk /栓抜/
せんにんぎr /千人斬/
せんなs /詮無/
せんなk /詮無/
せんなi /詮無/
せんなg /詮無/
せんたくばさm /洗濯挟/
せんたくs /選択/
せんぞがえr /先祖返/先祖帰;NB:辞書は多く「先祖返り」とする/
せんじつm /煎じ詰/
せんさいs /繊細/
せんさいn /繊細/
せんさいd /繊細/
せんかたなs /詮方無/
せんかたなk /詮方無/
せんかたなi /詮方無/
せんかたなg /詮方無/
せんz /詮;(consider)「-ずるに」/煎;(boil)「茶を煎ずる」/先/
せんs /宣;(declare)「革命を宣する」/僭;(ose)「王を僭する」/撰/
せんj /煎/先/
せわずk /世話好/
せわs /忙/
せりまk /競り負;⇔競り勝つ/
せりだs /迫り出/
せりかt /競り勝/
せりかc /競り勝/
せりおとs /競り落/
せりあw /競り合/
せりあu /競り合/
せりあt /競り合/
せりあo /競り合/
せりあi /競り合/
せりあg /競り上/迫り上/
せりあe /競り合/
せりあc /競り合/
せもたr /背凭/
せめよs /攻め寄/
せめほろb /攻め滅/
せめのぼt /攻め上/
せめのぼr /攻め上/
せめのぼn /攻め上/
せめのぼc /攻め上/
せめぬk /攻め抜/
せめぬi /攻め抜/
せめつづk /攻め続;城を攻め続ける/責め続;失敗を責め続ける/
せめたt /攻め立;敵を攻め立てる/責め立;失敗を責め立てる/
せめさいなn /責め苛/
せめさいなm /責め苛/
せめころs /責め殺/
せめこn /攻め込/
せめこm /攻め込/
せめぎあw /鬩ぎ合/
せめぎあu /鬩ぎ合/
せめぎあt /鬩ぎ合/
せめぎあo /鬩ぎ合/
せめぎあi /鬩ぎ合/
せめぎあe /鬩ぎ合/
せめぎあc /鬩ぎ合/
せめきt /攻め切/
せめきr /攻め切/
せめきn /攻め切/
せめきc /攻め切/
せめおとs /攻め落/責め落;<rare>/
せめおt /攻め落/
せめいt /攻め入/
せめいr /攻め入/
せめいn /攻め入/
せめいc /攻め入/
せめあぐn /攻め倦/
せめあぐm /攻め倦/
せめあw /攻め合;陣地を-/責め合;失敗を-/
せめあu /攻め合;陣地を-/責め合;失敗を-/
せめあt /攻め合;陣地を-/責め合;失敗を-/
せめあo /攻め合;陣地を-/責め合;失敗を-/
せめあi /攻め合;陣地を-/責め合;失敗を-/
せめあe /攻め合;陣地を-/責め合;失敗を-/
せめあc /攻め合;陣地を-/責め合;失敗を-/
せめr /攻め;※送り位置補正/
せめi /鬩/
せめg /鬩/
せまりこz /迫り来/
せまりこy /迫り来/
せまりこs /迫り来/
せまりこr /迫り来/
せまりこn /迫り来/
せまりこi /迫り来/
せまりくr /迫り来/
せまりくn /迫り来/
せまりきy /迫り来/
せまりきt /迫り来/
せまりきs /迫り来/
せまりきn /迫り来/
せまりきm /迫り来/
せまりきd /迫り来/
せまりきc /迫り来/
せまっくるs /狭っ苦/
せますg /狭過/
せまくるs /狭苦/
せまt /迫/逼/
せまs /狭/狹;「狭」の旧字(人名用漢字)/
せまr /迫/逼/
せまn /迫/逼/
せまm /狭/狹;「狭」の旧字(人名用漢字)/
せまk /狭/狹;「狭」の旧字(人名用漢字)/
せまi /狭/狹;「狭」の旧字(人名用漢字)/
せまg /狭/狹;「狭」の旧字(人名用漢字)/
せまc /迫/逼/
せぶm /瀬踏/
せばm /狭/狹;「狭」の旧字(人名用漢字)/
せはs /忙/
せのb /背伸/
せなかあw /背中合/
せつめいしょどおr /説明書通/
せつめいs /説明/
せつぞくs /接続/
せつs /切;切断/
せつn /切;切断/
せつk /責付/
せつi /責付/
せつd /切;切断/
せっぱつまt /切羽詰/
せっぱつまr /切羽詰/
せっぱつまn /切羽詰/
せっぱつまc /切羽詰/
せっぱつm /切羽詰/
せっていまちがi /設定間違/
せっていs /設定/
せっつk /責付/
せっつi /責付/
せっしょくs /接触/
せっきんs /接近/
せっきょうたr /説教垂/
せっきょうくさs /説教臭/
せっきょうくさk /説教臭/
せっきょうくさi /説教臭/
せっきょうくさg /説教臭/
せっs /接/
せちがらs /世知辛/
せちがらk /世知辛/
せちがらi /世知辛/
せちがらg /世知辛/
せせらわらw /せせら笑/嘲笑/
せせらわらu /嘲笑/せせら笑/
せせらわらt /せせら笑/嘲笑/
せせらわらo /せせら笑/嘲笑/
せせらわらi /せせら笑/嘲笑/
せせらわらe /せせら笑/嘲笑/
せせらわらc /嘲笑/せせら笑/
せけんずr /世間擦/
せきばらi /咳払/
せきにんもt /責任持/
せきにんとt /責任取/
せきにんとr /責任取/
せきにんとn /責任取/
せきにんとc /責任取/
せきとm /堰き止/塞き止/せき止/
せきたt /急き立/
せききt /急き切/
せききr /急き切/
せききn /急き切/
せききc /急き切/
せきがe /席替/
せおいこn /背負い込/背負込/
せおいこm /背負い込/背負込/
せおw /背負/
せおu /背負/
せおt /背負/
せおo /背負/
せおi /背負/
せおe /背負/
せおc /背負/
せうs /抄/
せいびs /整備/
せいちょうs /成長/
せいだs /精出/
せいぞろi /勢揃/
せいせいs /生成/
せいげんつk /制限付/
せいかくs /正確/
せいかくn /正確/
せいs /制;(control) 接戦を制する/征;(conquer) 夷狄を征する/製;(produce) 薬剤を製する/省/
せいn /聖;聖なる/
せz /為;do/
せy /為;do/
せt /競/迫/糶;<rare> =競り/
せr /迫/競/糶;<rare> =競り/
せn /迫/競/糶;<rare> =競り/
せm /攻;(attack)敵を攻める/責;(blame)失敗を責める/
せk /急/咳/堰;=塞く/塞;=堰く/
せi /急/咳/堰;=塞く/塞;=堰く/
せg /背/
せc /迫/競/糶;<rare> =競り/
ずわr /座/
ずれこn /ずれ込/
ずれこm /ずれ込/
ずれz /ズレ/
ずれy /ズレ/
ずれt /ズレ/
ずれs /ズレ/
ずれr /ズレ/
ずれn /ズレ/
ずれm /ズレ/
ずれk /ズレ/
ずれc /ズレ/
ずるs /狡/
ずるk /狡/
ずるi /狡/
ずるg /狡/
ずりおt /ずり落/
ずりおc /ずり落/
ずぶぬr /ずぶ濡/
ずぶとs /図太/
ずぶとk /図太/
ずぶとi /図太/
ずぶとg /図太/
ずぬk /頭抜/図抜/
ずどr /図取/
ずつk /頭突/
ずうずうs /図々/
ずs /誦;経を-す(る)/
ずr /刷/
ずm /済/住/濟;「済」の旧字/
ずk /好/尽;(連濁) 欲得尽く,納得尽く,他人尽く/付;※仮名遣い「づk」/
すんづm /寸詰/
すわりなおs /座り直/
すわりこn /座り込/
すわりこm /座り込/
すわt /座/坐/
すわr /座/坐/
すわn /座/坐/
すわc /座/坐/
すれちがw /すれ違/擦れ違/
すれちがu /すれ違/擦れ違/
すれちがt /すれ違/擦れ違/
すれちがo /すれ違/擦れ違/
すれちがi /すれ違/擦れ違/
すれちがe /すれ違/擦れ違/
すれちがc /すれ違/擦れ違/
すれあw /擦れ合/
すれあu /擦れ合/
すれあt /擦れ合/
すれあo /擦れ合/
すれあi /擦れ合/
すれあe /擦れ合/
すれあc /擦れ合/
するどs /鋭/
するどk /鋭/
するどi /鋭/
するどg /鋭/
すりよt /擦り寄/摩り寄;<rare>/
すりよr /擦り寄/摩り寄;<rare>/
すりよn /擦り寄/摩り寄;<rare>/
すりよc /擦り寄/摩り寄;<rare>/
すりむk /擦り剥/擦剥/
すりむi /擦剥/擦り剥/
すりへt /磨り減/
すりへr /磨り減/
すりへn /磨り減/
すりへc /磨り減/
すりぬk /擦り抜/すり抜/擦抜/擦り拔;旧字/
すりぬi /擦り抜/すり抜/擦抜/擦り拔;旧字/
すりつぶs /すり潰/磨り潰/摺り潰/
すりつk /擦り付;NB:「こすりつk」「なすりつk」と同形/
すりこn /刷り込;(imprint) 嗜好を刷り込まれる/摺り込;(rub into) 軟膏を摺り込む/摩り込;≒摺り込む/刷込/
すりこm /刷り込;(imprint) 嗜好を刷り込まれる/摺り込;(rub into) 軟膏を摺り込む/摩り込;≒摺り込む/刷込/
すりくだk /擂り碎;「砕」旧字/擂り砕/
すりくだi /擂り砕/擂り碎;「砕」旧字/
すりきt /擦り切/摺り切/摩り切;<rare>/
すりきr /擦り切/摺り切/摩り切;<rare>/
すりきn /擦り切/摺り切/摩り切;<rare>/
すりきc /擦り切/摺り切/摩り切;<rare>/
すりかわr /掏り替/
すりかw /掏り替/
すりかe /摩り替/すり替/掏り替/
すりあわs /擦り合;双方の案を-せる/摺り合;=擦り合わせる/
すりあw /擦り合/摺り合/
すりあg /刷り上/
すやk /素焼/
すもぐr /素潜/
すみわたt /澄み渡/
すみわたr /澄み渡/
すみわたn /澄み渡/
すみわたc /澄み渡/
すみわk /棲み分/住み分/
すみやk /炭焼/
すみなs /住み成;-したる庵あり/
すみなr /住み慣/住み馴/
すみつk /住み着/
すみつi /住み着/
すみこn /住み込/住込/
すみこm /住み込/住込/
すみくr /住み暮/
すみきt /澄み切/
すみきr /澄み切/
すみきn /澄み切/
すみきc /澄み切/
すみy /速/
すまu /住ま;※送り位置補正/
すまi /住ま;※送り位置補正/
すまh /住ま;※送り位置補正/
すぼn /窄/
すぼm /窄/
すべりどm /滑り止/
すべりだs /滑り出/
すべりこn /滑り込/
すべりこm /滑り込/
すべりおt /滑り落/
すべりおc /滑り落/
すべからk /須/
すべt /滑/全/総/總;「総」の旧字/辷;(国字)/
すべr /滑/辷;(国字)/
すべn /滑/辷;(国字)/
すべc /滑/辷;(国字)/
すぶr /素振/
すばらs /素晴/
すばやs /素早/
すばやk /素早/
すばやi /素早/
すばやg /素早/
すばなr /巣離/
すばr /素晴/
すなわt /即/則/乃/
すなわc /即/
すなどt /漁/
すなどr /漁/
すなどn /漁/
すなどc /漁/
すどまr /素泊/
すどおs /素通/
すどおr /素通/
すどm /素泊/
すでn /既/
すてさt /捨て去/
すてさr /捨て去/
すてさn /捨て去/
すてさc /捨て去/
すてきt /捨て切/
すてきr /捨て切/
すてきn /捨て切/
すてきd /素敵/
すてきc /捨て切/
すてがたs /捨て難/
すてがたk /捨て難/
すてがたi /捨て難/
すてがたg /捨て難/
すておk /捨て置/
すておi /捨て置/
すてr /捨て;※送り位置補正/
すづk /酢漬/
すっぽぬk /すっぽ抜/
すっぱぬk /素っ破抜/すっぱ抜/スッパ抜/
すっぱぬi /素っ破抜/すっぱ抜/スッパ抜/
すっとぼk /素っ恍/
すっとn /すっ飛/素っ飛/
すっとb /すっ飛/素っ飛/
すだt /巣立/
すだc /巣立/
すたt /廃/頽;NB:「くずおr」と同形/廢;「廃」の旧字/
すたr /廃/頽;NB:「くずおr」と同形/廢;「廃」の旧字/
すたn /廃/頽;NB:「くずおr」と同形/廢;「廃」の旧字/
すたc /廃/頽;NB:「くずおr」と同形/廢;「廃」の旧字/
すそわk /裾分/
すそとr /裾取/
すずなr /鈴生/
すずy /涼/
すずs /涼/凉;「涼」の旧字(人名用漢字)/
すずr /漫/
すずn /涼/凉;「涼」の旧字(人名用漢字)/
すずm /涼/凉;「涼」の旧字(人名用漢字)/
すすりなk /啜り泣/
すすりなi /啜り泣/
すすりこn /啜り込/
すすりこm /啜り込/
すすりあg /啜り上/
すすみでy /進み出/
すすみでt /進み出/
すすみでr /進み出/
すすみでn /進み出/
すすみでm /進み出/
すすt /啜/
すすr /啜/
すすn /進/啜/
すすm /進/勧;(advise) 留学を勧める/薦;(recommend) 本を薦める/奨;(encourage) 勉学を奨める/勸;「勧」の旧字/
すすk /煤/
すすi /濯;洗い物を-/漱;口を-/雪;恥を-/啌;<rare> ≒漱ぐ/
すすg /濯;洗い物を-/漱;口を-/雪;恥を-/啌;<rare> ≒漱ぐ/
すすc /啜/
すすb /煤;煤ぼけた暖炉/
すじちがi /筋違/
すじがねいr /筋金入/
すじあi /筋合/
すじt /捩/
すじr /捩/
すじn /捩/
すじc /捩/
すさt /退/
すさr /退/
すさn /荒;生活が荒む,風が吹き荒ぶ/退/遊;口遊む,筆の遊び (NB:「あそb」と同形)/進/
すさm /凄;-まじい/荒;生活が荒む/遊;口遊む/進/
すさc /退/
すさb /荒;風が吹き荒ぶ/遊;筆の遊び (NB:「あそb」と同形)/進/
すごもr /巣篭/
すごすg /凄過/
すごしやすs /過ごし易/
すごしやすk /過ごし易/
すごしやすi /過ごし易/
すごしやすg /過ごし易/
すごs /過/凄/
すごm /凄/
すごk /凄/
すごi /凄/
すごg /凄/
すこぶr /頗/
すこy /健/
すこs /少/
すげなs /素気無/
すげなk /素気無/
すげなi /素気無/
すげなg /素気無/
すげかe /挿げ替/すげ替/
すげn /素気;-なく断る/
すぐりぬk /選り抜/
すぐりぬi /選り抜/
すぐt /選;果実を選る NB:「えr」「よr」と同形/
すぐs /過/
すぐr /優/勝/選;果実を選る NB:「えr」「よr」と同形/秀/
すぐn /直/選;果実を選る NB:「えr」「よr」と同形/
すぐc /選;果実を選る NB:「えr」「よr」と同形/
すくなs /少;非正則(すくn)/尠;(字義:甚だしく少ない)/寡;(字義:頼れるものがない)/
すくなk /少;非正則(すくn)/少な;※送り位置補正/尠;(字義:甚だしく少ない)/寡;(字義:頼れるものがない)/
すくなi /少;非正則(すくn)/少な;※送り位置補正/尠;(字義:甚だしく少ない)/寡;(字義:頼れるものがない)/
すくなg /少;非正則(すくn)/尠;(字義:甚だしく少ない)/寡;(字義:頼れるものがない)/
すくいなg /掬い投/
すくいだs /救い出/
すくいあg /掬い上/
すくw /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/
すくu /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/巣く;※送り位置補正/
すくt /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/
すくo /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/
すくn /少/竦;足が竦んで/窘;<rare>/
すくm /竦/窘;<rare>/
すくi /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/
すくh /掬/救/済/抄/
すくe /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/
すくc /救/掬;「水を掬う」「足元を掬う」/巣喰/済;(宗教的に救済する)/抄;≒掬う/
すぎゆk /過ぎ行/
すぎさt /過ぎ去/
すぎさr /過ぎ去/
すぎさn /過ぎ去/
すぎさc /過ぎ去/
すぎn /過ぎ;※送り位置補正/
すきとおt /透き通/透き徹/
すきとおs /透き通/
すきとおr /透き通/透き徹/
すきとおn /透き通/透き徹/
すきとおc /透き通/透き徹/
すきとt /梳き取/
すきとr /梳き取/
すきとn /梳き取/
すきとc /梳き取/
すきずk /好き好/
すきこのn /好き好/
すきこのm /好き好/
すきこn /漉き込/鋤き込/
すきこm /漉き込/鋤き込/
すききらi /好き嫌/
すきかえs /鋤き返/
すきあw /好き合/
すきあu /好き合/
すきあt /好き合/
すきあo /好き合/
すきあi /好き合/
すきあe /好き合/
すきあc /好き合/
すがりつk /縋り付/
すがりつi /縋り付/
すがすがs /清々/
すがt /縋/
すがr /縋/末枯/尽/
すがn /縋/
すがm /眇;-める,矯めつ-めつ/
すがc /縋/
すかしみz /透かし見/
すかしみy /透かし見/
すかしみt /透かし見/
すかしみs /透かし見/
すかしみr /透かし見/
すかしみn /透かし見/
すかしみm /透かし見/
すかしみc /透かし見/
すかs /透;透して見る/賺;宥め賺す/
すえひろg /末広/
すえながs /末永/末長/
すえながk /末永/末長/
すえながi /末永/末長/
すえつk /据え付/据付/
すえたのm /末頼/
すえおそr /末恐/
すえおk /据え置/据置/
すえおi /据え置/据置/
すいよs /吸い寄/
すいとt /吸い取/
すいとr /吸い取/
すいとn /吸い取/
すいとc /吸い取/
すいつづk /吸い続/
すいつk /吸い付/
すいつi /吸い付/
すいだs /吸い出/吸出/
すいすg /吸い過/
すいこn /吸い込/
すいこm /吸い込/
すいあg /吸い上/
すいs /粋/
すいn /粋/
すいd /粋/
すあg /素揚/
すw /吸/据/喫;「煙草を喫う」 NB:比較的新しい表記/
すu /吸/喫;「煙草を喫う」 NB:比較的新しい表記/
すt /捨/吸/刷;本を刷る/棄;(字義:思い切ってすてる)/喫;「煙草を喫う」 NB:比較的新しい表記/擦;マッチを擦る/摺;版画を摺る/擂;胡麻を擂る/磨;墨を磨る/掏;財布を掏る/摩;天を摩る/剃;=そr/
すs /酸/
すr /擦;マッチを擦る/刷;本を刷る/為;do/摺;版画を摺る/擂;胡麻を擂る/磨;墨を磨る/掏;財布を掏る/摩;天を摩る/剃;=そr/爲;「為」の旧字(人名用漢字)/
すp /酸/
すo /吸/喫;「煙草を喫う」 NB:比較的新しい表記/
すn /済/住/棲;(動物が) 川に棲む/澄/拗;-ねる/濟;「済」の旧字/擦;マッチを擦る/刷;本を刷る/摺;版画を摺る/擂;胡麻を擂る/磨;墨を磨る/掏;財布を掏る/摩;天を摩る/剃;=そr/爲;「為」の旧字(人名用漢字)/清;≒澄む/栖;≒棲む/澂;「澄」の異体字/
すm /住/済/棲;(動物が) 川に棲む/澄/清;≒澄む/栖;≒棲む/濟;「済」の旧字/澂;「澄」の異体字/為;do/
すk /好/空/透/漉;紙を漉く/梳;(comb) 髪を梳く/鋤;(cultivate) 畑を鋤く/抄;≒漉く/剥;(slice) NB:「むk」と同形/耡;=鋤く/酸/
すi /酸/吸/空/喫;「煙草を喫う」 NB:比較的新しい表記/好/梳;(comb) 髪を梳く/透/済/濟;「済」の旧字/漉;紙を漉く/鋤;(cultivate) 畑を鋤く/抄;≒漉く/剥;(slice) NB:「むk」と同形/耡;=鋤く/
すg /過/直/
すe /据/吸/饐;(spoil) 饐えた臭い/喫;「煙草を喫う」 NB:比較的新しい表記/
すc /吸/喫;「煙草を喫う」 NB:比較的新しい表記/擦;マッチを擦る/刷;本を刷る/摺;版画を摺る/擂;胡麻を擂る/磨;墨を磨る/掏;財布を掏る/摩;天を摩る/剃;=そr/
すb /統/総;≒統べる/總;「総」の旧字/
じんどt /陣取/
じんどr /陣取/
じんどn /陣取/
じんどc /陣取/
じんとr /陣取/
じわr /地割/
じょさいなs /如才無/
じょさいなk /如才無/
じょさいなi /如才無/
じょうやとi /常雇/
じょうほうくだs /情報下/
じょうだんぬk /冗談抜/
じょうせきどおr /定石通/
じょうさs /状差/
じょうけんづk /条件付/
じょうz /乗/乘;「乗」の旧字(人名用漢字)/
じょうs /城/
じょうn /上/状/
じょうj /乗/乘;「乗」の旧字(人名用漢字)/
じょうd /状/
じょs /除;除算/叙;叙述/序/恕;(ゆるす)寛恕/
じゆうさんかd /自由参加/
じゆうd /自由/
じゅんばんまt /順番待/
じゅんばんまc /順番待/
じゅんじょよs /順序良/
じゅんじょよk /順序良/
じゅんじょよi /順序良/
じゅんじょだt /順序立/
じゅんぐr /順繰/
じゅんおくr /順送/
じゅんz /準/殉/准;「準」の略字/凖;「準」の異体字/
じゅんs /純/
じゅんn /順/純/
じゅんj /準/殉/准;「準」の略字/凖;「準」の異体字/
じゅんd /純/
じゅつごよb /述語呼/
じゅくs /熟;ripe/
じゅうりょうあg /重量挙/
じゅうらいどおr /従来通/
じゅうぶんn /十分/
じゅうぶんd /十分/
じゅうばこよm /重箱読/
じゅうなんn /柔軟/
じゅうだいn /重大/
じゅうじがたm /十字固/
じゅs /誦/呪/
じゅn /得/
じゃらs /戯/
じゃまくさs /邪魔臭/
じゃまくさk /邪魔臭/
じゃまくさi /邪魔臭/
じゃまくさg /邪魔臭/
じゃっかんことn /若干異/
じゃr /戯/
じむてづづk /事務手続/
じまんt /自慢/
じべt /地べ;※送り位置補正/
じひぶかs /慈悲深/
じひぶかk /慈悲深/
じひぶかi /慈悲深/
じひぶかg /慈悲深/
じひびk /地響/
じばk /字化/
じなr /地鳴/
じてんしゃのr /自転車乗/
じてんd /時点/
じづたi /地伝/
じづm /字詰/
じつづk /地続/
じつn /実/
じつh /実/
じっぱひとからg /十把一絡/
じっこうs /実行/
じっt /凝/
じだいおくr /時代遅/時代後/
じずm /字詰/
じしょひk /辞書引/
じさg /字下/
じこt /事故/
じこr /事故/
じこn /事故/
じこm /仕込/
じこc /事故/
じくばr /字配/
じきはずr /時期外/
じきs /直/
じきn /直;-に/
じきd /直/
じがたm /地固/
じかんぎr /時間切/
じかんおくr /時間遅/
じかづk /直付/
じかがk /直書/
じかn /直/
じかk /仕掛/
じあまr /字余/
じs /持;満を持して/辞;職を辞する/侍;(はべる) 帝に侍する/
じr /焦/
じn /死/染/
じm /染/
じk /敷/
じg /字/
しんぼうづよs /辛抱強/
しんぼうづよk /辛抱強/
しんぼうづよi /辛抱強/
しんぴてきd /神秘的/
しんぱいなs /心配無/
しんぱいなk /心配無/
しんぱいなi /心配無/
しんぱいなg /心配無/
しんちょうs /新調/
しんじんぶかs /信心深/
しんじんぶかk /信心深/
しんじんぶかi /信心深/
しんじんぶかg /信心深/
しんじゅくどおr /新宿通/
しんじつづk /信じ続/
しんじこn /信じ込/
しんじこm /信じ込/
しんじがたs /信じ難/
しんじがたk /信じ難/
しんじがたi /信じ難/
しんじがたg /信じ難/
しんじt /信じ;※送り位置補正/
しんじr /信じ;※送り位置補正/
しんしんともn /心身共/
しんこうs /進行/
しんけんd /真剣/
しんきくさs /辛気臭/心気臭;=辛気臭い/
しんきくさk /辛気臭/心気臭;=辛気臭い/
しんきくさi /辛気臭/心気臭;=辛気臭い/
しんきくさg /辛気臭/心気臭;=辛気臭い/
しんいr /新入/
しんz /信/進/死ん;※送り位置補正/
しんn /真/
しんj /信/
しをr /萎/
しわよs /皺寄/
しわぶk /咳/
しわぶi /咳/
しわがr /嗄/
しわs /吝/
しわk /仕分/仕訳;NB:簿記では送らず「仕訳」と書くのが普通/吝/
しわi /吝/
しわg /吝/
しろぬr /白塗/
しろぬk /白抜/
しろうとくさs /素人臭/
しろうとくさk /素人臭/
しろうとくさi /素人臭/
しろうとくさg /素人臭/
しろうとかんがe /素人考/
しろうとp /素人/
しろu /白/
しろs /白/
しろp /白/
しろm /白/
しろk /白/
しろi /白/
しろg /白/
しれわたt /知れ渡/
しれわたr /知れ渡/
しれわたn /知れ渡/
しれわたc /知れ渡/
しるs /記/著;形容詞, 明らかである/印;(mark) 足跡を印す/徴;(predict) 瑞兆を徴す/誌;≒記す/識;≒記す/標;掲げてしるす/示;?/
しるk /著;形容詞, 明らかである/
しるi /著;形容詞, 明らかである/
しるg /著;形容詞, 明らかである/
しりぬぐi /尻拭/
しりぬk /知り抜/
しりぬi /知り抜/
しりつくs /知り尽/
しりつk /知り尽/
しりぞk /退/斥/
しりぞi /退/斥/
しりさがr /尻下/
しりさg /尻下/
しりごm /尻込/
しりこそばゆi /尻擽/
しりきr /尻切/
しりあw /知り合/
しりあu /知り合/
しりあt /知り合/
しりあo /知り合/
しりあi /知り合/知合/
しりあg /尻上/
しりあe /知り合/
しりあc /知り合/
しらべあg /調べ上/
しらべr /調べ;※送り位置補正/
しらぬぞんz /知らぬ存/
しらちゃk /白茶/
しらじらs /白々/
しらz /知ら;※送り位置補正/
しらs /報/知ら;※送り位置補正/
しらn /白/
しらm /白/
しらk /白/
しらg /白;米を白げる(=精白する)/精;=白げる/
しらb /調/
しようくだs /使用下/
しようs /使用/
しようd /使用/
しょりs /処理/
しょぼs /ショボ/
しょぼk /ショボ/
しょぼi /ショボ/
しょぼg /ショボ/
しょってたt /背負って立/
しょってたc /背負って立/
しょっきあらi /食器洗/
しょっきr /初っ切/
しょっからs /塩っ辛/
しょっからm /塩っ辛/
しょっからk /塩っ辛/
しょっからi /塩っ辛/
しょっからg /塩っ辛/
しょたいじm /所帯染/
しょじs /所持/
しょしんしゃむk /初心者向/
しょざいなs /所在無/
しょざいなk /所在無/
しょざいなi /所在無/
しょげこn /悄気込/
しょげこm /悄気込/
しょげかえt /悄気返/
しょげかえr /悄気返/
しょげかえn /悄気返/
しょげかえc /悄気返/
しょげt /悄気/
しょげr /悄気/
しょげn /悄気/
しょげc /悄気/
しょくs /食/属;(漢音)属託(=嘱託)/嘱;属託/
しょきばらi /暑気払/
しょきかs /初期化/
しょうろうながs /精霊流/
しょうめんきt /正面切/
しょうめんきr /正面切/
しょうめんきn /正面切/
しょうめんきc /正面切/
しょうめいずm /証明済/
しょうめいs /証明/
しょうぶづよs /勝負強/
しょうぶづよk /勝負強/
しょうぶづよi /勝負強/
しょうぶづよg /勝負強/
しょうぶつよk /勝負強/
しょうどうがi /衝動買/
しょうだt /章立/
しょうじんおt /精進落/
しょうじいr /招じ入/請じ入/
しょうこだt /証拠立/
しょうこしらb /証拠調/
しょうこr /性懲/
しょうぎだおs /将棋倒/
しょうがつやすm /正月休/
しょうかいいただk /紹介頂/
しょうかいいたs /紹介致/
しょうz /生/請/
しょうs /称/証/賞/抄/頌/生;(呉音)/
しょうj /生/招/請/
しょいこn /背負い込/
しょいこm /背負い込/
しょw /背負/
しょu /背負/
しょt /背負/
しょs /処/署/書/
しょp /塩/
しょo /背負/
しょi /背負/
しょh /背負/
しょe /背負/
しょc /背負/
しゅんs /旬/
しゅんn /旬/
しゅんd /旬/
しゅびよk /首尾良/
しゅつりょくs /出力/
しゅっせばらi /出世払/
しゅくs /祝/
しゅうりがk /修理書/
しゅうねんぶかs /執念深/
しゅうねんぶかk /執念深/
しゅうねんぶかi /執念深/
しゅうねんぶかg /執念深/
しゅうねs /執念/
しゅうねk /執念/
しゅうねi /執念/
しゅうかんおくr /週間遅/
しゅうあk /週明/
しゅうs /執/修/
しゅt /主/
しゃれこn /洒落込/
しゃれこm /洒落込/
しゃれt /洒落/
しゃれr /洒落/
しゃれn /洒落/
しゃれc /洒落/
しゃらくさs /洒落臭/
しゃらくさk /洒落臭/
しゃらくさi /洒落臭/
しゃらくさg /洒落臭/
しゃべりだs /喋り出/
しゃべt /喋/諜;<rare>/
しゃべr /喋/諜;<rare>/
しゃべn /喋/諜;<rare>/
しゃべk /喋/
しゃべc /喋/諜;<rare>/
しゃぶりつk /しゃぶり付/
しゃぶりつi /しゃぶり付/
しゃっきんとr /借金取/
しゃちほこばt /鯱張/
しゃちほこばr /鯱張/
しゃちほこばn /鯱張/
しゃちほこばc /鯱張/
しゃしんうつr /写真写/
しゃしゃりでz /しゃしゃり出/
しゃしゃりでt /しゃしゃり出/
しゃしゃりでr /しゃしゃり出/
しゃしゃりでn /しゃしゃり出/
しゃこいr /車庫入/
しゃくりあg /しゃくり上/
しゃくt /抉;顎を-る (NB:「えぐr」「こじr」と同形)/決;=抉る/刳;=抉る/
しゃくs /癪/
しゃくr /抉;顎を-る (NB:「えぐr」「こじr」と同形)/決;=抉る/刳;=抉る/
しゃくn /抉;顎を-る (NB:「えぐr」「こじr」と同形)/決;=抉る/刳;=抉る/癪;-に障る/
しゃくd /癪/
しゃくc /抉;顎を-る (NB:「えぐr」「こじr」と同形)/決;=抉る/刳;=抉る/
しゃがr /嗄/
しゃs /謝/
しもやk /霜焼/
しもがr /霜枯/
しめわすr /閉め忘/
しめつk /締め付/締付/
しめだs /締め出/閉め出/
しめしあわs /示し合/
しめしあw /示し合/
しめこn /締め込/
しめこm /締め込/
しめくくt /締め括/
しめくくr /締め括/
しめくくn /締め括/
しめくくc /締め括/
しめきt /締め切;応募を-/閉め切;窓を-/締切/
しめきr /締め切;応募を-/閉め切;窓を-/締切/
しめきn /締め切;応募を-/閉め切;窓を-/締切/
しめきc /締め切;応募を-/閉め切;窓を-/締切/
しめいs /指名/
しめあg /締め上/
しめt /湿/〆/濕;「湿」の旧字(人名用漢字)/
しめs /示/湿/濕;「湿」の旧字(人名用漢字)/
しめr /湿/〆/濕;「湿」の旧字(人名用漢字)/
しめp /湿/濕;「湿」の旧字(人名用漢字)/
しめn /湿/〆/濕;「湿」の旧字(人名用漢字)/
しめc /湿/〆/濕;「湿」の旧字(人名用漢字)/
しむk /仕向/
しみとおt /沁み透/
しみとおr /沁み透/
しみとおn /沁み透/
しみとおc /沁み透/
しみでz /滲み出/染み出/
しみでy /滲み出/染み出/
しみでt /滲み出/染み出/
しみでs /滲み出/染み出/
しみでr /滲み出/染み出/
しみでn /滲み出/染み出/
しみでm /滲み出/染み出/
しみでc /滲み出/染み出/
しみつk /染み付/
しみつi /染み付/
しみだs /染み出/滲み出/
しみこn /染み込/
しみこm /染み込/
しみいt /染み入/
しみいr /染み入/
しみいn /染み入/
しみいc /染み入/
しみt /沁;非正則(しm)/
しみr /沁;非正則(しm)/
しみn /沁;非正則(しm)/
しみc /沁;非正則(しm)/
しまながs /島流/
しまいこn /仕舞い込/
しまいこm /仕舞い込/
しまw /仕舞/終/了/蔵/
しまu /仕舞/終/了/蔵/
しまt /仕舞/了/終/蔵/閉/
しまr /閉/
しまo /仕舞/終/了/蔵/
しまn /閉/
しまi /終/仕舞/了/蔵/
しまe /仕舞/終/了/蔵/
しまc /仕舞/終/了/蔵/閉/
しぼりだs /絞り出/搾り出/
しぼりこn /絞り込/
しぼりこm /絞り込/
しぼりあg /絞り上/
しぼt /絞/搾;(汁を取る) 乳を搾る/
しぼr /絞/搾;(汁を取る) 乳を搾る/
しぼn /萎/凋/絞/搾;(汁を取る) 乳を搾る/
しぼm /萎/凋/
しぼc /絞/搾;(汁を取る) 乳を搾る/
しぶt /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶs /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶr /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶn /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶm /渋/
しぶk /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶi /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶg /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しぶc /渋/澁;「渋」の旧字(人名用漢字)/澀;「渋」の旧字2/
しびr /痺/
しばりつk /縛り付/
しばりあg /縛り上/
しばらk /暫/
しばたk /瞬/
しばたi /瞬/
しばかr /柴刈;(薪) 山へ柴刈りに/芝刈;(芝生) 公園の芝刈り/
しばいじm /芝居染/
しばt /縛/
しばs /暫/
しばr /縛/暫/凍/
しばn /縛/
しばc /縛/
しはらw /支払/
しはらu /支払/
しはらt /支払/
しはらo /支払/
しはらi /支払/
しはらe /支払/
しはらc /支払/
しのびわらi /忍び笑/
しのびよt /忍び寄/
しのびよr /忍び寄/
しのびよn /忍び寄/
しのびよc /忍び寄/
しのびなk /忍び泣/
しのびなi /忍び泣/
しのびこn /忍び込/
しのびこm /忍び込/
しのびがたs /忍び難/
しのびがたk /忍び難/
しのびがたi /忍び難/
しのびがたg /忍び難/
しのびいt /忍び入/
しのびいr /忍び入/
しのびいn /忍び入/
しのびいc /忍び入/
しのばずどおr /不忍通/
しのつk /篠突;-く(雨)/
しのごn /四の五/
しのn /忍;恥を忍ぶ/偲;死者を偲ぶ/
しのi /凌/
しのg /凌/
しのb /偲;死者を偲ぶ/忍;恥を忍ぶ/
しにわかr /死に別/
しにものぐるi /死に物狂/
しにはt /死に果/
しにたe /死に絶/
しにぞこn /死に損/
しにそこn /死に損/
しにくs /為難/爲難;「為」旧字/
しにくk /為難/爲難;「為」旧字/
しにくi /為難/爲難;「為」旧字/
しにくg /為難/爲難;「為」旧字/
しにきr /死に切;(死ぬに)-れない/
しにかk /死に掛/
しにおくr /死に遅/
しにいそi /死に急/
しにいそg /死に急/
しなだr /撓垂/
しなぞろi /品揃/
しなぞろe /品揃/
しなさだm /品定/
しなぎr /品切/
しながe /品換/
しなおs /仕直/
しなw /撓/
しなu /撓/
しなt /撓/
しなs /為做/
しなr /撓/
しなo /撓/
しなn /撓/
しなi /撓/
しなh /撓/
しなe /撓/
しなc /撓/
しなb /萎/
しとy /淑/
しとm /仕留/爲留;「為」旧字/
しとg /仕遂/為遂/
しでかs /為出来/
しでk /仕出/為出/
してやt /為て遣/
してやr /為て遣/
してやn /為て遣/
してやc /為て遣/
してきどおr /指摘通/
してきs /指摘/
していs /指定/
しづらs /仕辛/
しづらk /仕辛/
しづらi /仕辛/
しづらg /仕辛/
しづr /垂/埀;「垂」の旧字/
しづn /沈;旧仮名/鎭;「鎮」の旧字(人名用漢字)/靜;「静」の旧字(人名用漢字)/
しづm /沈;旧仮名/鎭;「鎮」の旧字(人名用漢字)/靜;「静」の旧字(人名用漢字)/
しつりょうあたr /質量当/
しつらe /設/
しつけr /躾/
しつk /仕付;名詞・カ行下一/躾;名詞,カ行下一/
しっとぶかs /嫉妬深/
しっとぶかk /嫉妬深/
しっとぶかi /嫉妬深/
しっとぶかg /嫉妬深/
しったかぶt /知ったか振/
しったかぶr /知ったか振/
しったかぶn /知ったか振/
しったかぶc /知ったか振/
しっかt /確;-と/聢;-と/
しっかr /確/
しっs /失;遅きに失す/執/
しちめんどうくさs /七面倒臭/
しちめんどうくさk /七面倒臭/
しちめんどうくさi /七面倒臭/
しちめんどうくさg /七面倒臭/
しちながr /質流/
しちうk /質請/
しちいr /質入/
しだいしだいn /次第次第/
しだs /仕出/
しだr /垂/枝垂;-れ(柳)/
しだk /拉/
しだi /拉/
したよs /下寄/
したよm /下読/
したむk /下向/
したまわt /下回/
したまわr /下回/
したまわn /下回/
したまわc /下回/
したばたらk /下働/
したばe /下生/
したぬr /下塗/
したどt /下取/
したどr /下取/
したどn /下取/
したどc /下取/
したとr /下取/
したてひねr /下手捻/
したてなおs /仕立て直/
したてなg /下手投/
したてだしなg /下手出し投/
したてあg /仕立て上/
したづm /下積/
したつk /下付/
したったr /舌っ足/
したたりおt /滴り落/
したたりおc /滴り落/
したたt /滴/
したたr /滴/舌足/
したたn /滴/
したたm /認/
したたk /強/
したたc /滴/
したしらb /下調/
したしみぶかs /親しみ深/
したしみぶかk /親しみ深/
したしみぶかi /親しみ深/
したしみぶかg /親しみ深/
したしm /親し;※送り位置補正/親;非正則(したs)/
したざわr /舌触/
したごしらe /下拵/
したがw /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したがu /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したがt /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したがo /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したがk /下書/
したがi /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したがh /従/随/順/从;「従」の本字/從;「従」の旧字(人名用漢字)/啝/
したがe /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したがc /従/随;(字義:相手のなすがままにする)「筆に随う」/順;(字義:道筋に沿って行く)「天命に順う」/从;「従」の本字 (字義:人が人について行く)/從;「従」の旧字(人名用漢字)/啝;<rare>/
したうt /舌打/
したうk /下請/
したw /慕/
したu /慕/
したt /仕立/慕/
したs /親/
したo /慕/
したn /下/
したk /下/
したi /慕/
したh /慕/
したe /慕/
したc /慕/
しそんz /仕損/為損/
しそんj /仕損/為損/
しぜんn /自然/
しずみこn /沈み込/
しずみこm /沈み込/
しずまりかえt /静まり返/
しずまりかえr /静まり返/
しずまりかえn /静まり返/
しずまりかえc /静まり返/
しずy /静;-やか/
しずr /垂/
しずn /沈/沒;「没」の旧字/
しずm /沈/静/鎮;(字義:重みで押え付ける)謀反を鎮める/靜;「静」の旧字(人名用漢字)/鎭;「鎮」の旧字(人名用漢字)/沒;「没」の旧字/
しずk /静/靜;「静」の旧字(人名用漢字)/
しじょうむk /市場向/
しじどおr /指示通/
しさいr /子細/
しさs /示唆/
しごとはじm /仕事始/
しごとだかばらi /仕事高払/
しごk /扱/
しごi /扱/
しこうs /而/
しこt /凝;NB:「こr」と同形/痼/
しこr /凝;NB:「こr」と同形/痼/
しこn /仕込/凝;NB:「こr」と同形/痼/
しこm /仕込/
しこc /凝;NB:「こr」と同形/痼/
しげt /茂/繁/楙;<rare> ≒茂る/
しげs /繁/
しげr /茂/繁/楙;<rare> ≒茂る/
しげn /茂/繁/楙;<rare> ≒茂る/
しげm /茂/
しげk /繁/
しげc /茂/繁/楙;<rare> ≒茂る/
しけt /湿気;(get wet) 海苔が湿気る/時化;(storm) 海が時化る/
しけr /湿気;(get wet) 海苔が湿気る/時化;(storm) 海が時化る/
しけp /湿気/
しけn /湿気;(get wet) 海苔が湿気る/時化;(storm) 海が時化る/
しけc /湿気;(get wet) 海苔が湿気る/時化;(storm) 海が時化る/
しぐr /時雨/
しくn /仕組/
しくm /仕組/
しきんぐr /資金繰/
しきわm /爲極;「為」旧字/
しきりなおs /仕切り直/
しきはm /爲極;「為」旧字/
しきつm /敷き詰/
しきt /仕切;部屋を仕切る/頻;(frequent) 降り頻る,頻りに/
しきr /仕切;部屋を仕切る/頻;(frequent) 降り頻る,頻りに/
しきn /仕切;部屋を仕切る/頻;(frequent) 降り頻る,頻りに/
しきc /仕切;部屋を仕切る/頻;(frequent) 降り頻る,頻りに/
しがみつk /しがみ付/
しがみつi /しがみ付/
しかりつk /叱り付/
しかたなs /仕方無/
しかたなk /仕方無/
しかたなi /仕方無/
しかたなg /仕方無/
しかしながr /然し乍/併し乍/乍;「ながr」と同形/
しかくばt /四角張/
しかくばr /四角張/
しかくばn /四角張/
しかくばc /四角張/
しかくs /四角/
しかくk /四角/
しかくi /四角/
しかえs /仕返/
しかt /叱/確;-と/聢;(国字。字義:耳で確かに聞く)「聢と頼んだぞ」/
しかs /然;(however) 然しながら/併;≒然し/而;(then) 而して/
しかr /叱/然/
しかn /為兼/し兼/叱/爲兼;「為」旧字/
しかm /顰/
しかk /仕掛/仕懸;<rare> =仕掛け(る)/
しかc /叱/
しおやk /塩焼/
しおほs /爲果;「為」旧字/
しおづk /塩漬/
しおだm /潮溜/
しおたr /潮垂/
しおくt /仕送/爲送;「為」旧字/
しおくr /仕送/爲送;「為」旧字/
しおくn /仕送/爲送;「為」旧字/
しおくc /仕送/爲送;「為」旧字/
しおからs /塩辛/
しおからk /塩辛/
しおからi /塩辛/
しおからg /塩辛/
しおおs /爲果;「為」旧字/
しおr /萎/撓/枝折/霑/責/
しおk /仕置/爲置;「為」旧字/
しおi /仕置/爲置;「為」旧字/
しおe /為終/
しうt /仕打/
しいれr /仕入れ;※送り位置補正/
しいたg /虐/
しいt /強い;※送り位置補正/
しいs /弑/
しいr /仕入/
しあわs /幸/倖;≒幸せ/仕合;巡り合わせ・成り行き/
しあがt /仕上が;※送り位置補正/仕上/
しあがr /仕上/
しあがn /仕上/
しあがc /仕上/
しあw /仕合/為合/爲合;「為」旧字/
しあu /為合/爲合;「為」旧字/
しあt /為合/爲合;「為」旧字/
しあo /為合/爲合;「為」旧字/
しあi /為合/爲合;「為」旧字/
しあg /仕上/
しあe /為合/爲合;「為」旧字/
しあc /為合/爲合;「為」旧字/
しy /為;do/
しt /知/為;-て遣る/識;recognise/領;-る,-ろしめす (reign)/痴;-れ者/
しs /死/資;(contribute)発展に資す/歯;(仲間入りする)/齒;「歯」の旧字/為;do/
しr /知/識;recognise/領;-る,-ろしめす (reign)/痴;-れ者/為;do/
しn /死/知/為;do/識;recognise/領;-る,-ろしめす (reign)/痴;-れ者/染/沁;(≒染みる) 身に沁みる/凍;寒さで凍みる/滲;(≒染みる) 汗が滲み出る/浸;(≒染みる)/
しm /占/閉/締/染/絞;首を絞める/沁;(≒染みる) 身に沁みる/凍;寒さで凍みる/滲;(≒染みる) 汗が滲み出る/浸;(≒染みる)/〆;(期日や魚介類を)〆める/緊/閇;「閉」の異体字/為;do/
しk /敷/如/若/及/
しi /強/敷/誣;-いる(=欺く・こじつける)/如/若/及/
しh /強/誣/
しc /為;do/知/識;recognise/
ざんねんg /残念/
ざわt /騒/
ざらs /晒;(連濁) 店晒し,洗い晒し/曝/
ざつs /雑/
ざつn /雑/
ざつd /雑/
ざかr /盛/
ざいせきs /在籍/
ざs /座/差/坐;≒座/
ざr /戯/
ざm /覚/醒/冷/
ざk /咲/裂/
ざi /咲/裂/
ざe /冴/
さんまいおr /三枚下/
さんびょうしそろt /三拍子揃/
さんせいいたs /賛成致/
さんすくm /三竦/
さんしょうくだs /参照下/
さんしゅうくだs /参集下/
さんけづk /産気付/
さんけづi /産気付/
さんかくだs /参加下/
さんかいたs /参加致/
さんかs /参加/
さんz /参;馳せ参ずる/散;財を散ずる/
さんs /産/算;サ変(count)/参;サ変(participate)/賛;サ変(agree)/讃;サ変(praise)/
さんj /参;馳せ参じる/散;鬱憤を散じる/
さわぎだs /騒ぎ出/
さわぎたt /騒ぎ立/
さわy /爽/
さわt /触;touch/障;(hinder) 気に障る/觸;「触」の旧字/
さわr /触;touch/障;(hinder) [気癪]に障る/觸;「触」の旧字/
さわn /触;touch/障;(hinder) 気に障る/觸;「触」の旧字/
さわi /騒/騷;「騒」の旧字(人名用漢字)/
さわg /騒/騷;「騒」の旧字(人名用漢字)/
さわc /触;touch/障;(hinder) 気に障る/觸;「触」の旧字/
さりゆk /去り行/
さらけだs /曝け出/
さらあらi /皿洗/
さらw /攫;子供を攫う/浚;ドブを浚う/掠;≒攫う/復習;授業を復習う/渫;≒浚う/濬;≒浚う/
さらu /攫;子供を攫う/浚;ドブを浚う/掠;≒攫う/復習;授業を復習う/渫;≒浚う/濬;≒浚う/
さらt /攫;子供を攫う/浚;ドブを浚う/掠;≒攫う/復習;授業を復習う/渫;≒浚う/濬;≒浚う/
さらs /晒/曝/
さらo /攫;子供を攫う/浚;ドブを浚う/掠;≒攫う/復習;授業を復習う/渫;≒浚う/濬;≒浚う/
さらn /更/然ら;※送り位置補正/
さらk /曝/
さらi /攫;子供を攫う/浚;ドブを浚う/掠;≒攫う/復習;授業を復習う/渫;≒浚う/濬;≒浚う/
さらh /浚/渫/復習/
さらe /浚;ドブを浚う/渫;≒浚う/攫;子供を攫う/掠;≒攫う/復習;授業を復習う/濬;≒浚う/
さらc /攫;子供を攫う/浚;ドブを浚う/掠;≒攫う/復習;授業を復習う/渫;≒浚う/濬;≒浚う/
さらb /然ら;※送り位置補正/
さやばしt /鞘走;刀が-る/
さやばしr /鞘走;刀が-る/
さやばしn /鞘走;刀が-る/
さやばしc /鞘走;刀が-る/
さやあt /鞘当/
さめやr /覚め遣/醒め遣/冷め遣/
さめr /寤/
さむすg /寒過/
さむざむs /寒々/
さむu /寒/
さむs /寒/
さむm /寒/
さむk /寒/
さむi /寒/
さむg /寒/
さみs /寂/淋;NB:日本のみの用字/
さまよw /彷徨;(熟字訓)/さ迷/彷/
さまよu /彷徨;(熟字訓)/さ迷/彷/
さまよt /彷徨;(熟字訓)/さ迷/彷/
さまよo /彷徨;(熟字訓)/さ迷/彷/
さまよi /彷徨;(熟字訓)/さ迷/彷/
さまよe /彷徨;(熟字訓)/さ迷/彷/
さまよc /彷徨;(熟字訓)/さ迷/彷/
さまたg /妨/碍;<rare>/
さまざまn /様々/
さまがわr /様変/
さまがw /様変/
さまs /冷/醒/
さぼt /サボ/
さぼr /サボ/
さぼn /サボ/
さぼc /サボ/
さぶらw /候/
さぶらu /候/
さぶらt /候/
さぶらo /候/
さぶらi /候/
さぶらe /候/
さぶらc /候/
さびどm /錆止/
さびつk /錆付/錆び付/
さびつi /錆び付/錆付/
さびs /寂/淋;NB:日本のみの用字/寞;(ひとけがない)/寥;(まばら)/
さびr /寂/
さばおr /鯖折/
さばk /裁;(judge) 罪を裁く/捌;(dispose) 注文|魚を捌く/
さばi /裁;(judge) 罪を裁く/捌;(dispose) 注文|魚を捌く/
さながr /宛/
さとがえr /里帰/
さとうづk /砂糖漬/
さとt /悟/覚/
さとs /諭/聡;形容詞/悟/訓/説/敏;(字義:反応が早い)/慧;(字義:気が利く)/
さとr /悟/覚/
さとn /悟/覚/
さとk /聡;(字義:理解が早い)/敏;(字義:反応が早い)/慧;(字義:気が利く)/
さとi /聡;(字義:理解が早い)/敏;(字義:反応が早い)/慧;(字義:気が利く)/
さとg /聡;(字義:理解が早い)/敏;(字義:反応が早い)/慧;(字義:気が利く)/
さとc /悟/覚/
さとb /俚/
さておk /扨置/扨措/
さておi /扨置;何は-いて/扨措;=扨置いて/
さついr /札入/
さっぴk /差っ引/
さっぴi /差っ引/
さっちs /察知/
さっきだt /殺気立/
さっきだc /殺気立/
さっt /颯/
さっs /察/
さちうすs /幸薄/
さちうすk /幸薄/
さちうすi /幸薄/
さちうすg /幸薄/
さだm /定/
さだk /定/
さぞy /嘸;-や/
さぞk /嘸/
さそいだs /誘い出/
さそいこn /誘い込/
さそいこm /誘い込/
さそいあわs /誘い合/
さそいあw /誘い合/
さそw /誘/
さそu /誘/哘;<rare> NB:地名以外の用途は考えにくい/
さそt /誘/
さそo /誘/
さそi /誘/
さそe /誘/
さそc /誘/
さずk /授/
さすらw /流離/
さすらu /流離/
さすらt /流離/
さすらo /流離/
さすらi /流離/
さすらe /流離/
さすらc /流離/
さすt /擦;NB:「かすr」「こすr」「すr」「なすr」と同形/摩;NB:「すr」と同形/
さすr /擦;NB:「かすr」「こすr」「すr」「なすr」と同形/摩;NB:「すr」と同形/
さすn /擦;NB:「かすr」「こすr」「すr」「なすr」と同形/摩;NB:「すr」と同形/
さすc /擦;NB:「かすr」「こすr」「すr」「なすr」と同形/摩;NB:「すr」と同形/
さしわたs /差し渡/差渡/
さしもどs /差し戻/差戻/
さしむかi /差向/
さしむk /差し向/
さしまわs /差し回/
さしまねk /麾/
さしまねi /麾/
さしひかe /差し控/差控/
さしひk /差し引/差引/
さしひi /差し引/差引/
さしはさn /差し挟/挟;NB:「はさm」と同形/挿;口を-む/
さしはさm /差し挟/挟;NB:「はさm」と同形/挿;口を-む/
さしのぼt /差し上/差し昇/
さしのぼr /差し上/差し昇/
さしのぼn /差し上/差し昇/
さしのぼc /差し上/差し昇/
さしのb /差し延/差し伸/
さしぬi /刺し縫/
さしとおs /刺し通/
さしとm /差し止/差止/
さしでg /差し出/
さしづm /差し詰/
さしつらぬk /刺し貫/
さしつらぬi /刺し貫/
さしつかw /差し遣/
さしつかe /差し支/差支/
さしちがe /差し違/刺し違/
さしだs /差し出/差出/
さしたt /差し立/
さしせまt /差し迫/
さしせまr /差し迫/
さしせまn /差し迫/
さしせまc /差し迫/
さしずm /差し詰/差詰/
さししめs /指し示/
さしさわt /差し障/差障/
さしさわr /差し障/差障/
さしさわn /差し障/差障/
さしさわc /差し障/差障/
さしころs /刺し殺/
さしこn /差し込;プラグを差し込む/射し込;陽が射し込む/差込/
さしこm /差し込;プラグを差し込む/射し込;陽が射し込む/差込/指し込;?/
さしきt /指切/指し切/
さしきr /指切/指し切/
さしきn /指切/指し切/
さしきc /指切/指し切/
さしかわs /差し交/
さしかw /差し交/
さしかk /差し掛/
さしかe /差し替/差し換/挿し替/
さしおさe /差押/
さしおs /差し押/
さしおk /差し置/
さしおi /差し置/
さしいそi /差し急/
さしいそg /差し急/
さしいr /差し入/挿し入/差入/
さしあたt /差し当/
さしあたr /差し当/
さしあw /差し合/
さしあu /差し合/
さしあt /差し当/差し合/
さしあo /差し合/
さしあi /差し合/
さしあg /差し上/
さしあe /差し合/
さしあc /差し合/
ささわr /障/
ささやk /囁/
ささやi /囁/
ささげもt /捧げ持/
ささげもc /捧げ持/
ささくれだt /ささくれ立/
ささくれだc /ささくれ立/
ささえあw /支え合/
ささえあu /支え合/
ささえあt /支え合/
ささえあo /支え合/
ささえあi /支え合/
ささえあe /支え合/
ささえあc /支え合/
ささy /細/
ささi /捧/
ささg /捧/
ささe /支/
さげわたs /下げ渡/
さげどm /下げ止/
さげすn /蔑;(字義:目にも止めない)/貶;(字義:値を落とす)/
さげすm /蔑;(字義:目にも止めない)/貶;(字義:値を落とす)/
さけよi /酒酔/
さけのm /酒飲/
さけづk /酒漬/
さけずk /酒好/
さけくさs /酒臭/
さけくさk /酒臭/
さけくさi /酒臭/
さけくさg /酒臭/
さけn /叫/
さけb /叫/
さぐりだs /探り出/
さぐりあw /探り合/
さぐりあu /探り合/
さぐりあt /探り当/探り合/
さぐりあo /探り合/
さぐりあi /探り合/
さぐりあe /探り合/
さぐりあc /探り合/
さぐt /探/
さぐr /探/
さぐn /探/
さぐc /探/
さくづk /作付/
さくせいいたs /作成致/
さくせいs /作成/
さくs /策;維新を-す/
さきわたs /先渡/
さきよm /先読/
さきゆk /先行/
さきものがi /先物買/
さきみだr /咲き乱/
さきまわr /先回/
さきほこt /咲き誇/
さきほこr /咲き誇/
さきほこn /咲き誇/
さきほこc /咲き誇/
さきぶr /先触/
さきばらi /先払/
さきばしt /先走/
さきばしr /先走/
さきばしn /先走/
さきばしc /先走/
さきのこt /咲き残/
さきのこr /咲き残/
さきのこn /咲き残/
さきのこc /咲き残/
さきのb /先延/
さきどr /先取/
さきだt /先立/
さきだc /先立/
さきこぼr /咲き溢/
さきがk /先駆/
さきおくt /先送/
さきおくr /先送/
さきおくn /先送/
さきおくc /先送/
さきうt /先打/
さきうr /先売/
さきいt /先行/
さきいk /先行/
さきいc /先行/
さきt /先/
さきn /先/
さきg /先/
さがしまわt /捜し回/探し回/
さがしまわr /探し回/捜し回/
さがしまわn /探し回/捜し回/
さがしまわc /探し回/捜し回/
さがしだs /探し出/捜し出/
さがしあt /探し当/捜し当/
さがt /下/
さがs /探/捜;<esp.あるはずのものをさがす>/搜;「捜」の旧字(人名用漢字)/
さがr /下/下が;※送り位置補正/
さがn /下/
さがc /下/
さかもr /酒盛/
さかむs /酒蒸/
さかまk /逆巻/
さかまi /逆巻/
さかのぼt /遡/溯;≒遡る/泝;≒遡る/逆昇/
さかのぼr /遡/溯;≒遡る/泝;≒遡る/逆昇/逆のぼ;※送り位置補正/
さかのぼn /遡/溯;≒遡る/泝;≒遡る/逆昇/
さかのぼc /遡/溯;≒遡る/泝;≒遡る/逆昇/
さかなつr /魚釣/
さかなかk /魚懸/
さかなy /魚/
さかだt /逆立/
さかうらm /逆恨/
さかあg /逆上/
さかt /盛/
さかs /逆/賢/
さかr /逆/盛/
さかn /盛/
さかe /栄/盛/榮;「栄」の旧字(人名用漢字)/
さかc /盛/
さえわたt /冴え渡/さえ渡;NB:「冴え渡る」の方が一般的/
さえわたr /冴え渡/さえ渡;NB:「冴え渡る」の方が一般的/
さえわたn /冴え渡/さえ渡;NB:「冴え渡る」の方が一般的/
さえわたc /冴え渡/さえ渡;NB:「冴え渡る」の方が一般的/
さえずt /囀/哢;<rare>/
さえずr /囀/哢;<rare>/
さえずn /囀/哢;<rare>/
さえずc /囀/哢;<rare>/
さえぎt /遮/峺;<rare>/
さえぎr /遮/峺;<rare>/
さえぎn /遮/峺;<rare>/
さえぎc /遮/峺;<rare>/
さいわいs /幸/
さいわいn /幸/
さいわいd /幸/
さいわi /幸/
さいばしt /才走/
さいばしr /才走/
さいばしn /才走/
さいばしc /才走/
さいはt /最果/
さいなn /苛/嘖;<rare> NB:日本のみの用字/呵;<rare>/
さいなm /苛/嘖;<rare> NB:日本のみの用字/呵;<rare>/
さいこうn /最高/
さいげんs /再現/
さいきばしt /才気走/
さいきばしr /才気走/
さいきばしn /才気走/
さいきばしc /才気走/
さいかいs /再開/
さいt /最/
さいs /際/賽;(サ変) 御礼参りする/
さいn /際/
さt /去/
さs /差/刺;針を刺す/指;(point)上を指す/挿;カードを挿す/射;陽が射す/鎖;扉を鎖す/注;目薬を注す/点;口紅を点す/止;言い止す/然;然すれば/捺;印を捺す(=おす)/螫;<rare> 虫が螫す/插;「挿」の旧字/
さr /去/然/曝;[文語]/
さn /去/
さm /覚/冷;冷めた紅茶/醒;酔いが醒める/褪;色が褪める/然;然もあらん/覺;旧字/
さk /咲/避/割;時間を割く/裂;(仲|紙)を裂く/
さi /咲/裂;(仲|紙)を裂く/割;時間を割く/削/
さg /下/提;(手に持つ) 鞄を提げる/差/
さe /冴/冱;「冴」の異体字/
さc /去/
さb /錆/寂/銹;=錆びる/荒;≒寂び(れ)る/
ごわつk /強付/
ごわつi /強付/
ごわt /強/
ごろうz /御覧/
ごろうj /御覧/
ごろあw /語呂合/
ごろs /殺/頃/
ごろn /頃/
ごろd /頃/
ごれんらくねがw /御連絡願/
ごれんらくねがu /御連絡願/
ごれんらくねがt /御連絡願/
ごれんらくねがo /御連絡願/
ごれんらくねがi /御連絡願/
ごれんらくねがe /御連絡願/
ごれんらくねがc /御連絡願/
ごれんらくいただk /御連絡戴/御連絡頂/
ごれんらくいただi /御連絡戴/御連絡頂/
ごりようくだs /御利用下/ご利用下/
ごりかいくだs /御理解下/
ごりかいいただk /御理解頂/
ごりおs /ゴリ押/
ごらんくだs /御覧下/
ごようはじm /御用始/
ごようしゃくだs /御容赦下/
ごようおさm /御用納/
ごめんくだs /御免下/
ごまかs /誤魔化/胡麻化;NB:語源「胡麻菓子」/
ごぶがr /五分刈/
ごばらi /後払/
ごのm /好/
ごとうひょうくだs /御投票下/
ごとs /如/若/
ごとn /毎/
ごとk /如/若/
ごったがえs /ごった返/
ごちゅういくだs /御注意下/
ごたe /応/
ごぞんz /御存/
ごぞんj /御存/
ごしらe /拵/
ごしようくだs /御使用下/
ごしどうねがi /御指導願/
ごしどうくだs /御指導下/
ごしてきくだs /御指摘下/
ござt /御座/
ござr /御座/
ござn /御座/
ござi /御座/
ごさんしょうくだs /御参照下/
ごさんかくだs /御参加下/
ごくつぶs /穀潰/
ごきょうりょくくだs /御協力下/
ごきょうじねがi /御教示願/
ごきょうじくだs /御教示下/
ごきょうじいただk /御教示頂/
ごきょうじいただi /御教示頂/
ごきたいくだs /御期待下/
ごかつようくだs /御活用下/
ごかくにんくだs /御確認下/
ごえんりょくだs /御遠慮下/
ごえs /肥/
ごうじょっぱr /強情っ張/
ごうs /号/
ごいっぽうねがw /御一報願/
ごいっぽうねがu /御一報願/
ごいっぽうねがt /御一報願/
ごいっぽうねがo /御一報願/
ごいっぽうねがi /御一報願/
ごいっぽうねがe /御一報願/
ごいっぽうねがc /御一報願/
ごいっぽうくだs /御一報下/
ごいちどくくだs /御一読下/
ごあんしんくだs /御安心下/
ごs /越;(連濁) ガラス越し/期;(決意する) 必勝を期する/伍;(肩を並べる) 列国に伍す/
ごk /極/
ごe /越/超/
こんまk /根負/
こんばんh /今晩/
こんにちh /今日/
こんくらb /根競/
こんきよk /根気良/
こんz /混/
こんj /混/
こわばt /強張/
こわばr /強張/
こわばn /強張/
こわばc /強張/
こわづくr /声作/
こわすg /怖過/
こわs /壊/怖/恐/毀;≒壊す/壞;「壊」の旧字(人名用漢字)/強;強いご飯 NB:「つよi」と同形/
こわr /壊/毀;≒壊れる/壞;「壊」の旧字(人名用漢字)/
こわk /怖/恐/小分/強;強いご飯 NB:「つよi」と同形/
こわi /怖/恐/強;強いご飯 NB:「つよi」と同形/
こわg /怖/恐/強;強いご飯 NB:「つよi」と同形/
こわb /硬/
ころしあw /殺し合/
ころしあu /殺し合/
ころしあt /殺し合/
ころしあo /殺し合/
ころしあi /殺し合/
ころしあe /殺し合/
ころしあc /殺し合/
ころげこn /転げ込/
ころげこm /転げ込/
ころがりこn /転がり込/
ころがりこm /転がり込/
ころがりおt /転がり落/
ころがりおc /転がり落/
ころs /殺/
ころn /転/轉;「転」の旧字(人名用漢字)/
ころg /転/轉;「転」の旧字(人名用漢字)/
ころb /転/轉;「転」の旧字(人名用漢字)/
こりかたm /凝り固/
こらえきt /堪え切/
こらえきr /堪え切/
こらえきn /堪え切/
こらえきc /堪え切/
こらe /堪/怺/
こやすs /小安/
こやすk /小安/
こやすi /小安/
こやすg /小安/
こやs /肥や;※送り位置補正/
こもどr /小戻/
こもt /籠/篭;「籠」の異体字/隠/
こもr /篭;「籠」の異体字/籠/子守/隠/
こもn /篭;「籠」の異体字/籠/隠/
こもc /篭;「籠」の異体字/籠/隠/
こめつk /米搗/
こむらがえr /腓返/
こむずかs /小難/
こみだs /小見出/
こみいt /込み入/混み入;?/
こみいr /込み入/
こみいn /込み入/
こみいc /込み入/
こみあw /混み合/
こみあu /混み合/
こみあt /混み合/
こみあo /混み合/
こみあi /混み合/
こみあg /込み上/
こみあe /混み合/
こみあc /混み合/
こまわr /小回/コマ割/
こまりはt /困り果/
こまりぬk /困り抜/
こまりぬi /困り抜/
こまりきt /困り切/
こまりきr /困り切/
こまりきn /困り切/
こまりきc /困り切/
こまむすb /細結/
こまねk /拱/
こまねi /拱/
こまぬk /拱/
こまぬi /拱/
こまづかi /小間使/
こまつかi /小間使/
こまたすくi /小股掬/
こまぐm /駒組/
こまぎr /細切/小間切/
こまかi /細か;※送り位置補正/
こまy /細/濃/
こまt /困/
こまs /細/
こまr /困/
こまn /困/
こまm /小ま;※送り位置補正/
こまk /細/
こまi /細/
こまg /細/
こまc /困/
こぼt /毀/
こぼs /零;spill/溢/毀;=こぼ・つ/
こぼr /溢/零/毀;(こわれる) 橋が毀れる/
こほr /凍/氷/
こぶr /小振;†小振りな器/小降;†雨が小降りになる/
こびりつk /こびり付/
こびりつi /こびり付/
こびへつらw /媚び諂/
こびへつらu /媚び諂/
こびへつらt /媚び諂/
こびへつらo /媚び諂/
こびへつらi /媚び諂/
こびへつらc /媚び諂/
こばなr /子離/
こばしr /小走/
こばn /拒/
こばm /拒/
こはずk /小恥/
こはz /小恥/
このn /好/
このm /好/
こねまわs /捏ね回/
こねくりまわs /こねくり回/
こねあg /捏ね上;パン生地を-げる/
こにくs /小憎/
こにくr /小憎/
こにくk /小憎/
こにくi /小憎/
こにくg /小憎/
こなs /熟/
こなr /熟/
こなk /子泣/
こどもむk /子供向/
こどもづr /子供連/
こどもずk /子供好/
こどもじm /子供染/
こどもあつかi /子供扱/
こどもr /子供/
こどもp /子供/
ことわりきr /断り切/
ことわりがk /断り書/
ことわt /断/斷;旧字/判;(判断・理解する)/
ことわr /断/判;(判断・理解する)/斷;「断」の旧字/
ことわn /断/判;(判断・理解する)/斷;「断」の旧字/
ことわc /断/判;(判断・理解する)/斷;「断」の旧字/
ことよs /事寄/言寄/
こともなg /事も無/
ことほどさようn /事程左様/
ことほi /寿/
ことほg /言祝/寿/
ことばどおr /言葉通/
ことばづかi /言葉遣/言葉使/
ことばあそb /言葉遊/
ことはじm /事始/
ことなt /異/
ことなr /異/
ことなn /異/
ことなc /異/
こととh /言問/
ことづt /言伝/言傳;「伝」旧字/
ことづk /言付/託;=言付け(る)/
ことたt /事足/
ことたr /事足/
ことたn /事足/
ことたc /事足/
ことずk /託;※仮名遣い「ことづk」/
ことごとs /事々/
ことごとk /悉/尽;=悉く NB:「つk」と同形/盡;「尽」の旧字(人名用漢字)/
ことこまy /事細/
ことこまk /事細/
ことぎr /事切/
こときr /事切/
ことかk /事欠/
ことかi /事欠/
ことえr /言選/
こといm /言忌/
ことあたらs /事新/
ことあg /言挙/
ことw /断/斷;「断」の旧字/
ことn /異/殊;-に/
こてなg /小手投/
こてしらb /小手調/
こづかi /小遣/
こづr /子連/
こづk /小突/
こづi /小突/
こつあg /骨揚/
こっぴどs /こっ酷/
こっぴどk /こっ酷/
こっぴどi /こっ酷/
こっぴどg /こっ酷/
こっぱz /小っ恥/こっ恥/
こだわt /拘;原義:つまらぬことに気を取られる/拘泥/
こだわr /拘;原義:つまらぬことに気を取られる/拘泥/
こだわn /拘;原義:つまらぬことに気を取られる/拘泥/
こだわc /拘;原義:つまらぬことに気を取られる/拘泥/
こだまs /谺/
こだかs /小高/
こだかk /小高/
こだかi /小高/
こだかg /小高/
こだs /小出/
こたh /堪/答/應;「応」の旧字(人名用漢字)/
こたe /答;質問に答える/応;期待に応える,失敗が応える/堪;持ち堪える/應;「応」の旧字(人名用漢字)/
こぞt /挙/
こぞr /挙/
こぞn /挙/
こぞc /挙/
こそだt /子育/
こそi /刮/
こそg /刮/
こぜわs /小忙/
こせいゆたk /個性豊/
こすりつk /擦り付;NB:「なすりつk」「すりつk」と同形/
こすっからs /狡っ辛/
こすっからk /狡っ辛/
こすっからi /狡っ辛/
こすっからg /狡っ辛/
こすからs /狡辛/
こすからk /狡辛/
こすからi /狡辛/
こすからg /狡辛/
こすt /擦/錯;<rare> (ヤスリで磨く)/
こすs /狡/
こすr /擦/錯;<rare> (ヤスリで磨く)/
こすn /擦/錯;<rare> (ヤスリで磨く)/
こすk /狡/
こすi /狡/
こすg /濃過/狡/
こすc /擦/錯;<rare> (ヤスリで磨く)/
こじあk /抉じ開/
こじt /抉;蓋を抉る NB:「えぐr」「くじr」と同形/
こじs /誇示/
こじr /抉;蓋を抉る NB:「えぐr」「くじr」と同形/拗;仲が拗れる,風邪を拗らせる/
こじn /抉;蓋を抉る NB:「えぐr」「くじr」と同形/
こじc /抉;蓋を抉る NB:「えぐr」「くじr」と同形/
こしらh /拵/
こしらe /拵/
こしまわr /腰回/
こしぬk /腰抜/
こしなg /腰投/
こしづk /腰付/
こしくだk /腰砕/
こしかk /腰掛/
こざかs /小賢/
こさむs /小寒/
こさむk /小寒/
こさむi /小寒/
こさむg /小寒/
こごろs /子殺/
こごえはt /凍え果/
こごえじn /凍え死/
こごえしn /凍え死/
こごt /凝/
こごr /凝/
こごn /凝/屈/
こごm /屈/
こごe /凍/
こごc /凝/
こころよs /快/
こころよk /快/
こころよi /快/
こころよg /快/
こころゆるs /心許/
こころゆk /心行/
こころやすs /心安/
こころやすr /心安/
こころやすk /心安/
こころやすi /心安/
こころやすg /心安/
こころやさs /心優/
こころもとなs /心許無/
こころもとなk /心許無/
こころもとなi /心許無/
こころもとなg /心許無/
こころもt /心持/
こころもc /心持/
こころみだr /心乱/
こころみr /試み;※送り位置補正/
こころまどi /心惑/
こころまt /心待/
こころまc /心待/
こころぼそs /心細/
こころぼそk /心細/
こころぼそi /心細/
こころぼそg /心細/
こころぶとs /心太/
こころひk /心魅/
こころのこr /心残/
こころにくs /心憎/
こころにくk /心憎/
こころにくi /心憎/
こころにくg /心憎/
こころなs /心無/
こころなk /心無/
こころなi /心無/
こころなg /心無/
こころづよs /心強/
こころづよk /心強/
こころづよi /心強/
こころづよg /心強/
こころづくs /心尽/
こころづかi /心遣/心使/
こころづk /心付/
こころしずk /心静/
こころざs /志/
こころさみs /心淋/
こころさびs /心淋/心寂/
こころぐるs /心苦/
こころくばr /心配/
こころがまe /心構/
こころがk /心掛/
こころおだy /心穏/
こころおきなs /心置き無/
こころおきなk /心置き無/
こころおきなi /心置き無/
こころおt /心落/
こころおk /心置/
こころおi /心置/
こころえz /心得/
こころえy /心得/
こころえt /心得/
こころえs /心得/
こころえr /心得/
こころえn /心得/
こころえm /心得/
こころえk /心得/
こころえc /心得/
こころうごk /心動/
こころいr /心入/
こころあたたm /心温/心暖/
こころあたr /心当/
こころあt /心当/
こころs /心/
こころm /試/
こころh /心/
こころg /心/
ここのt /九/
ここちよs /心地良/心地好/
ここちよk /心地良/心地好/
ここちよi /心地良/心地好/
ここちよg /心地良/心地好/
ここn /個々/茲;-に/爰;-に/是;-に/
こげくさs /焦げ臭/
こげくさk /焦げ臭/
こげくさi /焦げ臭/
こげくさg /焦げ臭/
こけらおとs /柿落/
こけむs /苔生/
こけt /コケ/
こけr /コケ/
こけn /コケ/
こけc /コケ/
こぐらs /小暗;-い夕べ/木暗;-い森/
こぐらk /小暗;-い夕べ/木暗;-い森/
こぐらi /小暗;-い夕べ/木暗;-い森/
こぐらg /小暗;-い夕べ/木暗;-い森/
こくt /告/
こくs /酷/刻/
こくr /告/
こくn /告/酷/
こくd /酷/
こくc /告/
こぎつk /漕ぎ着/
こぎだs /漕ぎ出/
こぎたなs /小汚/
こぎたなk /小汚/
こぎたなi /小汚/
こぎたなg /小汚/
こきみよs /小気味良/小気味好/
こきみよk /小気味良/小気味好/
こきみよi /小気味良/小気味好/
こきみよg /小気味良/
こきつかw /扱き使/
こきつかu /扱き使/
こきつかt /扱き使/
こきつかo /扱き使/
こきつかi /扱き使/
こきつかe /扱き使/
こきつかc /扱き使/
こきざm /小刻/
こきおr /扱き下/
こがらs /木枯/
こがs /焦/
こがr /焦/木枯/
こかs /転/倒;NB:「たおs」と同形/
こおりづk /氷漬/
こおりつk /凍り付/
こおりつi /凍り付/
こおりけずr /氷削/
こおt /凍/氷;<rare>/
こおr /凍/氷;<rare>/
こおn /凍/氷;<rare>/
こおc /凍/氷;<rare>/
こえふとt /肥え太/
こえふとr /肥え太/
こえふとn /肥え太/
こえふとc /肥え太/
こえだs /声出/
こえたかk /声高/
こえがわr /声変/
こえかk /声掛/
こえt /超/
こうるさs /小煩/
こうるさk /小煩/
こうるさi /小煩/
こうるさg /小煩/
こうりょs /考慮/
こうむt /被;被害を被る NB:「かぶr」と同形/蒙;(≒被る) 御免蒙る/
こうむr /被;被害を被る NB:「かぶr」と同形/蒙;(≒被る) 御免蒙る/
こうむn /被;被害を被る NB:「かぶr」と同形/蒙;(≒被る) 御免蒙る/
こうむc /被;被害を被る NB:「かぶr」と同形/蒙;(≒被る) 御免蒙る/
こうだいn /広大/
こうそくn /高速/
こうせいn /公正/
こうしきr /抗し切/
こうごうs /神々/
こうごk /小動/
こうげきs /攻撃/
こうきゅうとr /高給取/
こうz /講/高/困/昂/嵩/考/
こうs /抗/航/
こうr /小売/
こうj /講;(哲学|策)を講じる/高;≒昂じる/昂;趣味が昂じて/嵩;≒昂じる/困;始末に困じる/
こうb /香/芳/
こいねがはk /希/
こいねがw /希/乞い願/冀/庶幾/
こいねがu /希/乞い願/冀/庶幾/
こいねがt /希/乞い願/冀/庶幾/
こいねがo /希/乞い願/冀/庶幾/
こいねがi /希/乞い願/冀/庶幾/
こいねがe /希/乞い願/冀/庶幾/
こいねがc /希/乞い願/冀/庶幾/
こいしたw /恋い慕/
こいしたu /恋い慕/
こいしたt /恋い慕/
こいしたo /恋い慕/
こいしたi /恋い慕/
こいしたe /恋い慕/
こいしたc /恋い慕/
こいおおk /恋多/
こいs /恋/戀;「恋」の旧字/
こz /来/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/
こy /肥/来/越/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/
こw /請;字義:しっかり目を見て頼む/乞;字義:憐れな声で頼む/恋/戀;「恋」の旧字/
こu /乞;字義:憐れな声で頼む/請;字義:しっかり目を見て頼む/恋/斯/買;(ウ音便)/戀;「恋」の旧字/
こt /凝;趣味に凝る,肩凝り/
こs /越/超;限界を超す/漉;(filter)油を漉す/濾;≒漉す/来/濃/鼓;勇を鼓する/糊;生活する/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/
こr /凝;趣味に凝る,肩凝り/懲;-りる,-らしめる/来;-られる/此;-れ/樵;(cut down) 木を樵る/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/
こo /乞;字義:憐れな声で頼む/請;字義:しっかり目を見て頼む/恋/戀;「恋」の旧字/
こn /込/来/混/捏/此;-の,-んな/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/凝;趣味に凝る,肩凝り/
こm /込/混/籠;音が籠る/篭;「籠」の異体字/
こk /濃/扱;稲を扱く/転;道で転ける,(補助動詞)売り転かす/放;屁を放く/痩;痩けた頬/倒;=転ける/
こi /濃/乞;字義:憐れな声で頼む/来/漕/請;字義:しっかり目を見て頼む/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/恋/戀;「恋」の旧字/扱;稲を扱く,稲を扱ぐ/放;屁を放く/
こh /乞/請/戀;「恋」の旧字/
こg /漕/焦/扱;稲を扱ぐ/濃/
こe /越/超;(特に「上回る」意で) ≒越える/肥;肥えた目/踰;字義:「越」は跳びこえ、「踰」は跨ぎこす/乞;字義:憐れな声で頼む/請;字義:しっかり目を見て頼む/恋/戀;「恋」の旧字/
こd /子/小/
こc /凝;趣味に凝る,肩凝り/
こb /媚/
げんなおs /験直/
げんつk /原付/
げんだいかなづかi /現代仮名遣/
げんじつばなr /現実離/
げんさくどおr /原作通/
げんきよk /元気良/
げんきづk /元気付/
げんz /減/
げんs /減/
げんn /現/
げんj /減/
げびt /下卑/
げびr /下卑/
げぎらi /毛嫌/
げきs /激/檄;檄文を発する/
げs /解/觧;「解」の異体字/
げr /蹴/
げn /実/
けんとうはずr /見当外/
けんとうちがi /見当違/
けんとうs /検討/
けんしょうずm /検証済/
けんいづk /権威付/
けんz /献/
けんs /検;サ変/験;経験/
けんj /献/
けわw /化粧/
けわu /化粧/
けわt /化粧/
けわs /険/峻;峻しい山道/險;「険」の旧字(人名用漢字)/
けわo /化粧/
けわi /化粧/
けわe /化粧/
けわc /化粧/
けりとb /蹴飛/
けりたおs /蹴り倒/
けりころs /蹴り殺/
けりこn /蹴り込;ボールを敵陣に-む/
けりこm /蹴り込;ボールを敵陣に-む/
けりいr /蹴り入/
けりあg /蹴り上/
けやぶt /蹴破/
けやぶr /蹴破/
けやぶn /蹴破/
けやぶc /蹴破/
けむt /煙/烟;「煙」の異体字/
けむs /煙/
けむr /煙/烟;「煙」の異体字/
けむn /煙/烟;「煙」の異体字/
けむk /煙/
けむi /煙/
けむg /煙/
けむc /煙/烟;「煙」の異体字/
けみs /閲/
けぶかs /毛深/
けぶかk /毛深/
けぶかi /毛深/
けぶかg /毛深/
けぶt /煙/烟;「煙」の異体字/
けぶs /煙/
けぶr /煙/烟;「煙」の異体字/
けぶn /煙/烟;「煙」の異体字/
けぶk /煙/
けぶi /煙/
けぶg /煙/
けぶc /煙/烟;「煙」の異体字/
けばだt /毛羽立/
けばだc /毛羽立/
けばs /ケバ/
けばk /ケバ/
けばi /ケバ/
けばg /ケバ/
けはh /化粧/
けなs /貶/
けなm /毛並/
けどt /気取/
けどr /気取/
けどn /気取/
けどc /気取/
けとb /蹴飛/
けづくろi /毛繕/
けづr /削/梳/
けつろんづk /結論付/
けつまずk /蹴躓/
けつまずi /蹴躓/
けっとb /蹴っ飛/
けっていづk /決定付/
けっていいたs /決定致/
けっていs /決定/
けっしゅうs /結集/
けっs /決/結;constipate/
けちくさs /ケチ臭/けち臭/
けちくさk /ケチ臭/けち臭/
けちくさi /ケチ臭/けち臭/
けちくさg /ケチ臭/けち臭/
けちr /蹴散/
けだるs /気怠/
けだるk /気怠/
けだるi /気怠/
けだるg /気怠/
けだかs /気高/
けだかk /気高/
けだかi /気高/
けだかg /気高/
けだs /蓋/
けたはずr /桁外/
けたちがi /桁違/
けたちがh /桁違/
けたぐr /蹴手繰/
けたおs /蹴倒/
けたt /蹴立/
けずりとt /削り取/
けずりとr /削り取/
けずりとn /削り取/
けずりとc /削り取/
けずt /削/梳;(クシで髪をとく)/
けずr /削/梳;(クシで髪をとく)/
けずn /削/梳;(クシで髪をとく)/
けずc /削/梳;(クシで髪をとく)/
けしわすr /消し忘/
けしとn /消し飛/
けしとm /消し止/
けしとb /消し飛/
けしさt /消し去/
けしさr /消し去/
けしさn /消し去/
けしさc /消し去/
けしこn /消し込/
けしこm /消し込/
けしきb /気色;気色ばむ/
けしかk /嗾/
けさがたm /袈裟固/
けこn /蹴込/
けこm /蹴込;-み(建築用語),-む(kick in)/
けぎらi /毛嫌/
けがs /汚;NB:「よごs」と同形/穢;<esp.禁忌的に>/涜;(神聖なものを)/
けがr /汚;NB:「よごr」と同形/穢;<esp.禁忌的に>/
けかえs /蹴返/
けおとs /蹴落/
けおt /蹴落/
けおs /気圧/
けうとs /気疎/
けうとk /気疎/
けうとi /気疎/
けうとg /気疎/
けいとうだt /系統立/
けいじs /掲示/
けいしきばt /形式張/
けいしきばr /形式張/
けいしきばn /形式張/
けいしきばc /形式張/
けいさんだかs /計算高/
けいさんだかk /計算高/
けいさんだかi /計算高/
けいさんだかg /計算高/
けいこくs /警告/
けいけんゆたk /経験豊/
けいけんs /経験/
けいきよk /景気良/
けいきづk /景気付/
けいかいn /軽快/
けいえいs /経営/
けいs /敬;敬意/詣;-す [文語]詣でる/啓;-す [文語]申し上げる/慶;慶事/
けあg /蹴上/
けy /蹴/
けt /蹴/
けs /消/怪;-しからん/決;(けして)/
けr /蹴/
けn /蹴/異/
けc /蹴/
ぐんs /軍;army/
ぐろs /黒/グロ;grotesque/
ぐろk /黒/グロ;grotesque/
ぐろi /黒/グロ;grotesque/
ぐろg /黒/グロ;grotesque/
ぐるs /苦/
ぐるm /包/
ぐるi /狂/
ぐらs /暮/
ぐちt /愚痴/
ぐちr /愚痴/
ぐちp /愚痴/
ぐちn /愚痴/
ぐちc /愚痴/
ぐずt /愚図/
ぐずr /愚図/
ぐずn /愚図/
ぐずc /愚図/
ぐさr /腐/
ぐうs /遇;(treat) 客として遇する/寓;ことよせる/
ぐあi /具合/
ぐs /具/
ぐr /暮/
ぐn /組/
ぐm /組/
ぐi /食/
くんよm /訓読/
くんづk /君付/
くんだr /下;-り NB:「くだr」と同形/
くわわt /加わ;※送り位置補正/
くわだt /企/
くわずぎらi /食わず嫌/
くわえこn /咥え込/銜え込/
くわえこm /咥え込/銜え込/
くわw /加/
くわs /詳/精/委/
くわr /区割/
くわk /区分/
くわe /加/咥;(字義:がっぷり噛み付く)/銜;(字義:馬の轡) ≒咥える/
くろびかr /黒光/
くろぬr /黒塗/
くろすg /黒過/
くろこg /黒焦/
くろz /黒/
くろu /黒/玄/
くろs /黒/玄/梍;<rare>/
くろp /黒/
くろm /黒/
くろk /黒/玄/梍;<rare>/
くろi /黒/玄/梍;<rare>/
くろg /黒/玄/梍;<rare>/
くれゆk /暮れ行/
くれなずn /暮れ泥/
くれなずm /暮れ泥/
くれかk /暮れ掛/
くるめk /眩/
くるめi /眩/
くるしみぬk /苦しみ抜/
くるしみぬi /苦しみ抜/
くるしまぎr /苦し紛/
くるw /狂/
くるu /狂/
くるt /狂/
くるs /苦/
くるo /狂/
くるn /包/
くるm /包/
くるi /狂/
くるh /狂/
くるe /狂/
くるc /狂/
くりもどs /繰り戻/繰戻/
くりひろg /繰り広/
くりのb /繰り延/繰延/
くりぬk /刳り貫/
くりぬi /刳り貫/
くりだs /繰り出/
くりさg /繰り下/
くりこs /繰り越/繰越/
くりこn /繰り込/
くりこm /繰り込/
くりかえs /繰り返/繰返/
くりかe /繰替/
くりいr /繰り入/
くりあわs /繰り合/
くりあw /繰り合/
くりあg /繰り上/繰上/
くらすg /暗過/
くらざらe /蔵浚/
くらがe /鞍替/
くらいどr /位取/
くらいづk /位付/
くらいつk /食らい付/喰らい付/
くらいつi /食らい付/喰らい付/
くらいこn /食らい込/喰らい込/
くらいこm /食らい込/喰らい込/
くらいs /位/
くらu /喰ら;※送り位置補正/食ら;※送り位置補正/
くらt /食/
くらs /暮/暗/昏;(字義:夕闇のくらさ)/冥;(字義:覆われて光がない)/暝;≒冥/眛;(字義:小さくてよく見えない)/罔;(字義:網で覆われて見えない)/
くらn /眩;(目を眩ます)/暗/
くらm /眩;(目を眩ます)/晦;(姿を晦ます)/暗/昏;(字義:夕闇のくらさ)/冥;(字義:覆われて光がない)/暝;≒冥/眛;(字義:小さくてよく見えない)/罔;(字義:網で覆われて見えない)/
くらk /暗/昏;(字義:夕闇のくらさ)/冥;(字義:覆われて光がない)/暝;≒冥/眛;(字義:小さくてよく見えない)/罔;(字義:網で覆われて見えない)/
くらi /暗/昏;(字義:夕闇のくらさ)/冥;(字義:覆われて光がない)/暝;≒冥/罔;(字義:網で覆われて見えない)/眛;(字義:小さくてよく見えない)/
くらg /暗/昏;(字義:夕闇のくらさ)/冥;(字義:覆われて光がない)/暝;≒冥/眛;(字義:小さくてよく見えない)/罔;(字義:網で覆われて見えない)/
くらe /喰ら;※送り位置補正/
くらb /比;字義:並べてくらべる/較;字義:突き合わせてくらべる/競;字義:勝負する/
くゆr /燻/薫/
くやしなk /悔し泣/
くやs /悔/口惜;=悔しい NB:「くちおs」と同形/
くやn /悔/
くやm /悔/
くもゆk /雲行/
くもがくr /雲隠/
くもt /曇/
くもr /曇/
くもn /曇/
くもc /曇/
くみわk /組分/組み分/
くみふs /組み伏/
くみとt /汲み取/
くみとr /汲み取/
くみとn /汲み取/
くみとc /汲み取/
くみつk /組付/組み付/
くみつi /組み付/
くみだs /汲み出/
くみたてr /組み立て;※送り位置補正/
くみたt /組み立/組立/
くみしやすs /与し易/
くみしやすk /与し易/
くみしやすi /与し易/
くみしやすg /与し易/
くみこn /組み込/組込/
くみこm /組込/組み込/
くみかわs /酌み交/
くみかw /酌み交/
くみかe /組替/組み換/組み替/組換;-え食品/
くみおk /汲み置/汲置/
くみおi /汲み置/汲置/
くみいr /組み入/組入/
くみあわs /組合/組み合/組み合わ;※送り位置補正/
くみあw /組み合/組合/
くみあg /汲み上;水|意見を汲み上げる/組み上;部品を組み上げる/組上/
くみs /与/與;「与」の旧字(人名用漢字)/
くまどt /隈取/
くまどr /隈取/
くまどn /隈取/
くまどc /隈取/
くぼn /窪/凹;NB:「へこm」と同形/
くぼm /窪/凹;NB:「へこm」と同形/
くべつs /区別/
くびりころs /縊り殺/
くびひねr /首捻/
くびなg /首投/
くびっぴk /首っ引/
くびくくr /首縊/
くびがたm /首固/
くびt /首/括;括れた胴 NB:「くくr」と同形/縊;(首吊り) 縊れて死ぬ/
くびr /括;括れた胴 NB:「くくr」と同形/縊;(首吊り) 縊れて死ぬ/
くびn /括;括れた胴 NB:「くくr」と同形/縊;(首吊り) 縊れて死ぬ/
くびc /括;括れた胴 NB:「くくr」と同形/縊;(首吊り) 縊れて死ぬ/
くばt /配/
くばr /配/
くばn /配/
くばc /配/
くはh /加/銜/
くどきおt /口説き落/
くどs /諄;(tedious) 諄い説教/
くどk /口説/諄;(tedious) 諄い説教/
くどi /口説/諄;(tedious) 諄い説教/
くどg /諄;(tedious) 諄い説教/
くづほr /頽/
くづs /崩;旧仮名/
くつろi /寛/
くつろg /寛/
くつずr /靴擦/
くつがへs /覆/
くつがへr /覆/
くつがえt /覆/
くつがえs /覆/
くつがえr /覆/
くつがえn /覆/
くつがえc /覆/
くっつk /くっ付/
くっつi /くっ付/
くっt /食;?/
くっs /屈/
くちをs /口惜/
くちよごs /口汚/
くちやかまs /口喧/
くちぶr /口振/
くちふうj /口封/
くちばしt /口走/
くちばしr /口走/
くちばしn /口走/
くちばしc /口走/
くちはばt /口幅/
くちはt /朽ち果/
くちなおs /口直/
くちなs /口無;(死人に)-し/
くちなr /口馴/口慣/
くちどr /口取/
くちどm /口止/
くちづk /口付;(蒼き胸乳に)-ける/
くちだs /口出/
くちぞe /口添/
くちずさn /口遊/
くちずさm /口遊/
くちすすi /漱/嗽;=漱ぐ/
くちすすg /漱/嗽;=漱ぐ/
くちさびs /口寂/
くちごもt /口籠/
くちごもr /口籠/
くちごもn /口籠/
くちごもc /口籠/
くちごたe /口答/
くちごm /口籠/
くちぎたなs /口穢/
くちぎたなk /口穢/
くちぎたなi /口穢/
くちぎたなg /口穢/
くちきr /口切/
くちきk /口利/
くちおs /口惜/
くちうるさs /口煩/
くちうるさk /口煩/
くちうるさi /口煩/
くちうるさg /口煩/
くちうつs /口移/
くちあたr /口当/
くちあt /口当/
くちz /口/
くだけちt /砕け散/
くだけちr /砕け散/
くだけちn /砕け散/
くだけちc /砕け散/
くだt /下/降/
くだs /下/降/
くだr /下/降/
くだn /下/降/
くだk /砕/碎;「砕」の旧字(人名用漢字)/
くだi /砕/碎;「砕」の旧字(人名用漢字)/
くだc /下/降/
くたびr /草臥/
くたs /腐/
くそあつs /糞暑/クソ暑/くそ暑/
くそあつk /糞暑/クソ暑/くそ暑/
くそあつi /糞暑/クソ暑/くそ暑/
くそあつg /糞暑/クソ暑/くそ暑/
くせn /癖/
くずれさt /崩れ去/
くずれさr /崩れ去/
くずれさn /崩れ去/
くずれさc /崩れ去/
くずれおt /崩れ落/
くずれおc /崩れ落/
くずきr /葛切/
くずおr /頽/
くずs /崩/
くずr /崩/
くすりづk /薬漬/
くすりうr /薬売/
くすぶt /燻/
くすぶr /燻/燻ぶ;※送り位置補正/
くすぶn /燻/
くすぶc /燻/
くすぐt /擽/
くすぐr /擽/
くすぐn /擽/
くすぐc /擽/
くすs /奇/
くすk /奇/
くすi /奇/
くすg /擽/奇/
くすb /燻;-べる NB:「燻る」の他動詞版。送りに注意/
くじびk /籤引/
くじk /挫/
くじi /挫/
くしざs /串刺/
くしけづr /梳/
くしけずt /梳/
くしけずr /梳/
くしけずn /梳/
くしけずc /梳/
くさわk /草分/
くさりはt /腐り果/
くさぶかs /草深/
くさぶかk /草深/
くさぶかi /草深/
くさぶかg /草深/
くさふかs /草深/
くさふかk /草深/
くさふかi /草深/
くさふかg /草深/
くさとr /草取/
くさかr /草刈/
くさt /腐/
くさs /臭/
くさr /腐/鏈;(つなぐ)/
くさn /腐/
くさm /臭/
くさk /臭/
くさi /臭/
くさg /臭/
くさc /腐/
くぐりぬk /潜り抜/くぐり抜/
くぐt /潜/潛;旧字/
くぐr /潜/潛;旧字/
くぐn /潜/潛;旧字/
くぐc /潜/潛;旧字/
くくりつk /括り付/
くくりあg /括り上/
くくt /括/
くくr /括/
くくn /括/
くくm /銜/含/
くくc /括/
くぎづk /釘付/
くぎt /区切/
くぎr /区切/
くぎn /区切/
くぎc /区切/
くえこn /崩え込/
くえこm /崩え込/
くうきいr /空気入/
くいやぶt /食い破/
くいやぶr /食い破/
くいやぶn /食い破/
くいやぶc /食い破/
くいのこs /食い残/
くいにg /食い逃/
くいとm /食い止/喰い止/
くいつぶs /食い潰/
くいつなi /食い繋;失業保険で-ぐ/
くいつなg /食い繋;失業保険で-ぐ/
くいつくs /食い尽/
くいつm /食い詰/
くいつk /食い尽/食い付/
くいつi /食い付/
くいちぎt /食い千切/
くいちぎr /食い千切/
くいちぎn /食い千切/
くいちぎc /食い千切/
くいちがw /食い違/喰い違/
くいちがu /食い違/喰い違/
くいちがt /食い違/喰い違/
くいちがo /食い違/喰い違/
くいちがi /食い違/喰い違/
くいちがe /食い違/喰い違/
くいちがc /食い違/喰い違/
くいちr /食い散/
くいたr /食い足/
くいすg /食い過/喰い過/
くいしばt /食い縛/喰い縛/
くいしばr /食い縛/喰い縛/
くいしばn /食い縛/喰い縛/
くいしばc /食い縛/喰い縛/
くいさg /食い下/
くいころs /食い殺/
くいこn /食い込/喰い込/
くいこm /食い込/喰い込/
くいきt /食い切/
くいきr /食い切/
くいきn /食い切/
くいきc /食い切/
くいいt /食い入/喰い入/
くいいr /食い入/喰い入/
くいいn /食い入/喰い入/
くいいc /食い入/喰い入/
くいあわs /食い合/
くいあらたm /悔い改/
くいあw /食い合/
くいあr /食い荒/
くいあk /食い飽/
くy /悔/
くw /食/喰;NB:「食」と区別して訓「くう」を表すための国字/
くu /食/喰;NB:「食」と区別して訓「くう」を表すための国字/
くt /食/朽/喰;NB:「食」と区別して訓「くう」を表すための国字/繰/刳/
くs /奇;奇しくも(=不思議にも)/屈;※送り過剰?/
くr /来/繰/暮/食/喰/呉/刳/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/眩;※送り過剰?/
くo /食/喰;NB:「食」と区別して訓「くう」を表すための国字/
くn /組/汲;水を汲む/酌;酒を酌む,意を酌む/苦;-にする/来;[口]-んな/繰/刳/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/
くm /組/汲;水を汲む/酌;酒を酌む,意を酌む/
くk /絎;衿裏を絎ける/
くi /食/喰;NB:「食」と区別して訓「くう」を表すための国字/悔/
くh /食/
くg /絎/
くe /食/喰;NB:「食」と区別して訓「くう」を表すための国字/
くc /朽/喰;NB:「食」と区別して訓「くう」を表すための国字/食/繰/刳/
くb /焼;-ぶ,(火に)-べる/
ぎんz /吟/
ぎんj /吟/
ぎりだt /義理立/
ぎりがたs /義理堅/
ぎりがたk /義理堅/
ぎりがたi /義理堅/
ぎりがたg /義理堅/
ぎらi /嫌/
ぎょりんがかr /魚鱗懸/
ぎょちょうどm /魚鳥止/
ぎょうぎょうs /仰々/仰仰/
ぎょうz /行/
ぎょs /御;御しやすい/
ぎゅうじt /牛耳/
ぎゅうじr /牛耳/
ぎゅうじn /牛耳/
ぎゅうじc /牛耳/
ぎゃっこうs /逆行/
ぎゃくもどr /逆戻/
ぎゃくむk /逆向/
ぎゃくまわr /逆回/
ぎゃくびk /逆引/
ぎゃくばr /逆張/
ぎゃくじょうs /逆上/
ぎゃくじゅうじがたm /逆十字固/
ぎゃくs /逆/
ぎゃくn /逆/
ぎゃくd /逆/
ぎむづk /義務付/
ぎt /切/
ぎs /擬;(似せる)山水に擬する/議;(議論)問題を議する/義/偽/
ぎr /切/斬/
ぎn /切/義/偽/
ぎm /決/
ぎd /義/偽/
ぎc /切/
きんとうわr /均等割/
きんちょうs /緊張/
きんじえz /禁じ得/
きんじえn /禁じ得/
きんz /禁/
きんj /禁/
きをつk /気を付/
きわどs /際疾/
きわどk /際疾/
きわどi /際疾/
きわどg /際疾/
きわだt /際立/
きわだc /際立/極立/
きわm /極/究;真相を究める/窮;進退窮まる/
きわd /際/
きろくやぶr /記録破/
きれこn /切れ込/
きれこm /切れ込/
きれいずk /綺麗好/
きれあg /切れ上;小股の-がった/
きれz /キレ;[口]/
きれt /キレ;[口]/
きれs /キレ;[口]/
きれr /キレ;[口]/
きれn /キレ;[口]/
きれm /キレ;[口]/
きれk /キレ;[口]/
きれc /キレ;[口]/
きりわk /切り分/
きりもどs /切り戻/
きりもr /切り盛/
きりもm /錐揉/
きりまわs /切り回;店を-す/
きりまz /切り混/
きりふs /切り伏/斬り伏/
きりふk /霧吹/
きりひろg /切り広/
きりひらk /切り開/切開/
きりひらi /切り開/切開/
きりはなs /切り離/切離/
きりはr /切り貼/
きりぬk /切り抜/切抜/
きりぬi /切り抜/切抜/
きりなおs /切り直/
きりどおs /切り通/切通/
きりとおs /切り通/切通/
きりとt /切り取/切取/
きりとr /切り取/切取/
きりとn /切り取/切取/
きりとc /切り取/切取/
きりづk /切り漬/
きりつm /切り詰/
きりつk /切り付/斬り付/
きりだs /切り出/切出/
きりたおs /切り倒;木を-/斬り倒;敵を-/
きりたt /切り立/
きりたc /切り立/
きりそろe /切り揃;前髪を-える/
きりすt /切り捨;弱者を-/斬り捨;-て御免/切捨/斬捨/
きりさk /切り裂/斬り裂/
きりさi /切り裂/斬り裂/
きりさg /切り下/切下/
きりころs /切り殺/斬り殺/
きりこn /切り込/切込/斬り込/
きりこm /切り込/切込/斬り込/
きりくずs /切り崩/
きりきざn /切り刻/
きりきざm /切り刻/
きりかえs /切り返/
きりかえr /切り換え;※送り位置補正/
きりかw /切り替/切替/
きりかk /斬り掛/切り掛/
きりかe /切り替/切替/切り換/切換/
きりおとs /切り落/
きりおt /切り落/
きりおr /切り下/
きりうr /切り売/
きりあw /斬り合/
きりあu /斬り合/
きりあt /斬り合/
きりあo /斬り合/
きりあi /斬り合/
きりあg /切り上/切上/
きりあe /斬り合/
きりあc /斬り合/
きらめk /煌/
きらめi /煌/
きらw /嫌/
きらu /嫌/
きらt /嫌/
きらo /嫌/
きらm /煌/
きらi /嫌/
きらh /嫌/
きらe /嫌/
きらc /嫌/
きらb /燦/
きよs /清/浄/
きよr /清/
きよm /清/浄/
きよk /清/浄/
きよi /清/浄/
きよg /清/浄/
きょぜつs /拒絶/
きょくりょくさk /極力避/
きょくs /曲/局/
きょうりょくくだs /協力下/
きょうみぶかs /興味深/
きょうみぶかk /興味深/
きょうみぶかi /興味深/
きょうみぶかg /興味深/
きょうだいn /強大/
きょうじゅくだs /教授下/
きょうじくだs /教示下/
きょうしゅくs /恐縮/
きょうざm /興醒/
きょうかしょどおr /教科書通/
きょうかぎr /今日限/
きょうz /興/
きょうs /供;(offer) 実用に供する/饗;(banquet) 客を饗する/狂;go mad/
きょうn /今日/
きょうm /今日/
きょうj /興/
きょうh /今日/
きゅうしょげr /急所蹴;痛/
きゅうしゅうs /吸収/
きゅうs /窮;返答に窮する/給;年金を給する/休;万事休す/急/仇;仇敵/
きゅうn /急/
きゅうd /急/
きやすs /気安/
きやすm /気休/
きやすk /気安/
きやすi /気安/
きやすg /気安/
きやs /着痩/
きゃくよs /客寄/
きゃくひk /客引/
きゃくあつかi /客扱/
きもちわるs /気持ち悪/気持悪/
きもちわるk /気持ち悪/気持悪/
きもちわるi /気持ち悪/気持悪/
きもちわるg /気持ち悪/気持悪/
きもちよs /気持ち良/
きもちよk /気持ち良/
きもちよi /気持ち良/
きもちよg /気持ち良/
きもだめs /肝試/
きもいr /肝煎/
きもt /気持/
きもs /キモ/
きもk /キモ/
きもi /キモ/
きもg /キモ/
きもc /気持/
きめつk /決め付/
きめこまk /木目細/きめ細/肌理細/
きめこn /決め込/
きめこm /決め込/木目込/
きむづかs /気難/
きむずかs /気難/
きみわるs /気味悪/
きみわるk /気味悪/
きみわるi /気味悪/
きみわるg /気味悪/
きみw /君/
きみt /君/
きみn /君/
きみm /君/
きみh /君/
きみg /君/
きまわs /着回/
きまりわるs /決まり悪/
きまりわるk /決まり悪/
きまりわるi /決まり悪/
きまりわるg /決まり悪/
きまぐr /気紛/
きまt /決;非正則(きm)/極/
きまr /極/決;非正則(きm)/
きまn /極/決;非正則(きm)/
きまc /極/決;非正則(きm)/
きぼういたs /希望致/
きぶくr /着脹/
きふるs /着古/
きふよm /棋譜読/
きびしi /厳し;※送り位置補正/
きびs /厳/嚴;「厳」の旧字(人名用漢字)/
きばt /気張/
きばr /気張;-る/気晴;-らし/
きばn /気張/
きばc /気張/
きはどs /際疾/
きはどk /際疾/
きはどi /際疾/
きはどg /際疾/
きはz /気恥/
きはm /窮/
きのぼr /木登/
きのうs /機能/
きのr /気乗/
きぬk /気抜/
きにいt /気に入/
きにいr /気に入/
きにいn /気に入/
きにいc /気に入/
きなくさs /きな臭/キナ臭/
きなくさk /きな臭/キナ臭/
きなくさi /きな臭/キナ臭/
きなくさg /きな臭/キナ臭/
きながs /着流/
きなr /着慣;着慣れた服/生成;(無加工) 生成りのシャツ/
きどおs /着通/
きどうs /起動/
きどt /気取/
きどr /気取/
きどn /気取/
きどc /気取/
きていどおr /規定通/
きていt /着て行/
きていk /着て行/
きていc /着て行/
きづかw /気遣/
きづかu /気遣/
きづかt /気遣/
きづかr /気疲/
きづかo /気遣/
きづかi /気遣/
きづかe /気遣/
きづかc /気遣/
きづm /気詰/
きづk /気付/築;旧仮名/気附/
きづi /気付/築;旧仮名/気附/
きつs /キツ/
きつk /気付;-け薬/着付;和服の-け/キツ/
きつi /キツ/
きつg /キツ/
きってすt /斬って捨/
きっかk /切っ掛/
きっs /喫/
きちがいじm /気違い染/
きちがi /気違/
きだt /気立/
きたむk /北向/
きたなs /汚/穢;<esp.禁忌的に>/
きたなr /汚/
きたなk /汚/穢;<esp.禁忌的に>/
きたなi /汚/穢;<esp.禁忌的に>/
きたなg /汚/穢;<esp.禁忌的に>/
きたえぬk /鍛え抜/
きたえぬi /鍛え抜/
きたえあg /鍛え上/
きたいどおr /期待通/
きたいくだs /期待下/
きたいs /期待/
きたt /来/來;「来」の旧字(人名用漢字)/
きたs /来/來;「来」の旧字(人名用漢字)/
きたr /来/來;「来」の旧字(人名用漢字)/
きたn /汚/
きたe /鍛/
きそづk /基礎付/
きそくただs /規則正/
きそいあw /競い合/
きそいあu /競い合/
きそいあt /競い合/
きそいあo /競い合/
きそいあi /競い合/
きそいあe /競い合/
きそいあc /競い合/
きそw /競/竸;異体字/
きそu /競/竸;異体字/
きそt /競/竸;異体字/
きそo /競/竸;異体字/
きそi /競/竸;異体字/
きそh /競/
きそe /競/竸;異体字/
きそc /競/竸;異体字/
きぜわs /気忙/
きせかe /着せ替/
きずつけあw /傷付け合/
きずつけあu /傷付け合/
きずつけあt /傷付け合/
きずつけあo /傷付け合/
きずつけあi /傷付け合/
きずつけあe /傷付け合/
きずつけあc /傷付け合/
きずつk /傷付/
きずつi /傷付/
きずきあg /築き上/
きずかi /気遣/
きずt /傷/
きずk /築/気付;※仮名遣い「きづk」/
きずi /築/
きじよm /記事読/
きしょくわるs /気色悪/
きしょくわるk /気色悪/
きしょくわるi /気色悪/
きしょくわるg /気色悪/
きしちかk /岸近/
きしt /軋/轢;<rare> ≒軋る/
きしr /軋/轢;<rare> ≒軋る/
きしn /軋/轢;<rare> ≒軋る/
きしm /軋/
きしc /軋/轢;<rare> ≒軋る/
きざわr /気障/
きざみつk /刻み付/
きざみこn /刻み込/
きざみこm /刻み込/
きざs /兆/
きざp /気障/
きざn /刻/
きざm /刻/
きさいs /記載/
きさk /気さ;※送り位置補正/
きこしめs /聞こし召/
きこn /着込/
きこm /着込/
きけんn /危険/
きぐm /木組/
きくばr /気配/
きくs /掬/
ききわすr /聞き忘/
ききわk /聞き分/
ききよs /聴き良/
ききよk /聴き良/
ききよi /聴き良/
ききよg /聴き良/
ききやすs /聞き易/
ききやすk /聞き易/
ききやすi /聞き易/
ききやすg /聞き易/
ききもr /聞き漏/聞き洩/
ききまちがi /聞き間違/
ききまちがe /聞き間違/
ききほr /聞き惚/聴き惚/
ききはじm /聴き始/聞き始/
ききのがs /聞き逃/聞逃/
ききのg /聞き逃/
ききにくs /聞き難/
ききにくk /聞き難/
ききにくi /聞き難/
ききにくg /聞き難/
ききながs /聞き流/聴き流/
ききなおs /聞き直/聴き直/
ききなr /聞き慣/聞き馴;≒聞き慣れる/
ききとどk /聞き届/
ききとがm /聞き咎/
ききとおs /聴き通/聞き通/
ききとt /聞き取/聴き取/聞取/
ききとr /聞き取/聴き取/聞取/
ききとn /聞き取/聴き取/聞取/
ききとc /聞き取/聴き取/聞取/
ききつづk /聞き続/聴き続/
ききつk /聞き付/
ききちがe /聞き違/
ききだs /聞き出;情報を聞き出す/効き出;薬が効き出す/
ききたがe /聞き違/
ききそこn /聞き損/
ききせまt /鬼気迫/
ききせまr /鬼気迫/
ききせまn /鬼気迫/
ききせまc /鬼気迫/
ききずt /聞き捨/
ききすg /効き過/
ききしt /聞き知/
ききしr /聞き知/
ききしn /聞き知/
ききしc /聞き知/
ききこn /聞き込/聴き込/
ききこm /聞き込/聴き込/
ききぐるs /聞き苦/
ききくらb /聞き比/聴き比/聴き較/聞き較/
ききがk /聞き書/
ききかじt /聞き齧/
ききかじr /聞き齧/
ききかじn /聞き齧/
ききかじc /聞き齧/
ききかえs /聞き返/
ききおよn /聞き及/
ききおよb /聞き及/
ききおぼe /聞き覚/
ききおとs /聞き落/
ききおt /聞き落/
ききおe /聞き終/聴き終/
ききいt /聞き入/聴き入/
ききいr /聞き入/聴き入/
ききいn /聞き入/聴き入/
ききいc /聞き入/聴き入/
ききあやまt /聞き誤/
ききあやまr /聞き誤/
ききあやまn /聞き誤/
ききあやまc /聞き誤/
ききあk /聞き飽;-きた話/聴き飽;-きたCD/
きがるs /気軽/
きがるk /気軽/
きがるi /気軽/
きがるg /気軽/
きがまe /気構/
きがつk /気が付/気が附/
きがつi /気が付/気が附/
きがかr /気掛/
きがn /気兼/
きがe /着替/
きかざt /着飾/
きかざr /着飾/
きかざn /着飾/
きかざc /着飾/
きかe /着替/着換/
きおくちがi /記憶違/
きおくr /気後/
きおいたt /気負い立/競い立/
きおいたc /気負い立/競い立/
きおいこn /気負い込/
きおいこm /気負い込/
きおw /気負/
きおu /気負/
きおt /気負/気落/
きおo /気負/
きおi /気負/
きおe /気負/
きおc /気負/
きえはt /消え果/
きえさt /消え去/
きえさr /消え去/
きえさn /消え去/
きえさc /消え去/
きえうs /消え失/
きえいt /消え入/
きえいr /消え入/
きえいn /消え入/
きえいc /消え入/
きいろs /黄色/
きいろp /黄色/
きいろm /黄色/
きいろk /黄色/
きいろi /黄色/
きいろg /黄色/
きあいはいt /気合入/
きあいはいr /気合入/
きあいはいn /気合入/
きあいはいc /気合入/
きあいいr /気合入/
きあi /気合/
きz /着/著;<rare> ≒着る/気;?/氣;「気」の旧字(人名用漢字)/
きy /消/来/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/着/著;<rare> ≒着る/
きw /気/氣;「気」の旧字(人名用漢字)/着/著;<rare> ≒着る/
きu /着/著;<rare> ≒着る/
きt /来/切/着/斬;人を斬る/著;<rare> ≒着る/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/伐;木を伐る/剪;盆栽を剪る/截;布地を截る/鑽;<rare> 火を鑽る(=火打ち石で火を起こす)/
きs /着/来/記;(note)別紙に記する/期;(expect)万全を期す,期せずして/帰;(lead to)水泡に帰す/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/歸;「帰」の旧字/皈;「帰」の異体字/著;<rare> ≒着る/
きr /切/着/斬;人を斬る/伐;木を伐る/剪;盆栽を剪る/截;布地を截る/鑽;<rare> 火を鑽る(=火打ち石で火を起こす)/著;<rare> ≒着る/
きp /着/著;<rare> ≒着る/
きo /着/著;<rare> ≒着る/
きn /気/来/着/機/氣;「気」の旧字(人名用漢字)/著;<rare> ≒着る/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/切/斬;人を斬る/伐;木を伐る/剪;盆栽を剪る/截;布地を截る/鑽;<rare> 火を鑽る(=火打ち石で火を起こす)/
きm /決/来/極;NB:「きわm」と同形/着/気/黄/决;「決」の異体字/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/氣;「気」の旧字(人名用漢字)/著;<rare> ≒着る/
きk /聞/聴;(注意してきく) 音楽を聴く/効;(effect) 薬が効く/利;(work) 気が利く,口を利く/訊;(inquire) 道を訊く/尋/着;-こなす/聽;「聴」の旧字(人名用漢字)/效;「効」の旧字/切/著;<rare> ≒着る/
きj /着/著;<rare> ≒着る/
きi /聞/聴;(注意してきく) 音楽を聴く/効;(effect) 薬が効く/利;(work) 気が利く,口を利く/尋/訊;(inquire) 道を訊く/效;「効」の旧字/聽;「聴」の旧字(人名用漢字)/着/著;<rare> ≒着る/
きh /気/氣;「気」の旧字(人名用漢字)/着/著;<rare> ≒着る/
きg /気/氣;「気」の旧字(人名用漢字)/着/著;<rare> ≒着る/
きe /消/着/著;<rare> ≒着る/
きd /気/氣;「気」の旧字(人名用漢字)/来/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/着/著;<rare> ≒着る/
きc /切/来/來;「来」の旧字(人名用漢字)/徠;「来」の異体字/着/斬;人を斬る/伐;木を伐る/剪;盆栽を剪る/截;布地を截る/鑽;<rare> 火を鑽る(=火打ち石で火を起こす)/著;<rare> ≒着る/
きb /黄/着/著;<rare> ≒着る/
きa /着/著;<rare> ≒着る/
がんばりぬk /頑張り抜/
がんばりぬi /頑張り抜/
がんばりとおs /頑張り通/
がんばt /頑張/
がんばr /頑張/
がんばn /頑張/
がんばc /頑張/
がんつk /ガン付/
がんぜなs /頑是無/
がんぜなk /頑是無/
がんぜなi /頑是無/
がんぜなg /頑是無/
がわr /変/替/代/
がわk /乾/
がらあk /がら空/ガラ空/
がらs /辛/
がらm /絡/
がらk /辛/
がらi /辛/
がらg /辛/
がよi /通/
がまんできn /我慢出来/
がまんづよs /我慢強/
がまんづよk /我慢強/
がまんづよi /我慢強/
がまんづよg /我慢強/
がなりたt /がなり立;選挙カーが-てる/
がとu /難/
がっしょうひねr /合掌捻/
がっしょうづくr /合掌造/
がっこうがえr /学校帰/
がっs /合/
がたs /難;考え難い NB:「にくi」と同形/
がたr /語/
がたm /固/
がたk /難;考え難い NB:「にくi」と同形/
がたi /難;考え難い NB:「にくi」と同形/
がたg /難;考え難い NB:「にくi」と同形/
がぞうとr /画像取/
がさn /重/
がけくずr /崖崩/
がかr /係/
がえんz /肯/
がえんj /肯/
がえs /返/
がえr /帰/返/歸;「帰」の旧字/皈;「帰」の異体字/
がえn /肯/
がいs /害/概;概念/
がw /代/変/替/
がt /勝/
がs /貸/賀;年賀/
がr /刈/狩/借/
がk /書/駆/掛/
がi /買/
がe /替/換/
かんれんづk /関連付/
かんれんz /関連;?/
かんれんs /関連/
かんれんd /関連/
かんやどr /神宿/
かんべんねがw /勘弁願/
かんべんねがu /勘弁願/
かんべんねがt /勘弁願/
かんべんねがo /勘弁願/
かんべんねがi /勘弁願/
かんべんねがe /勘弁願/
かんべんねがc /勘弁願/
かんばしt /甲走/
かんばしr /甲走/
かんばしn /甲走/
かんばしc /甲走/
かんばs /芳;(generic, また特に比喩的に否定形で) 評判が芳しくない/香;香しい梅/馨/
かんのんびらk /観音開/
かんねんs /観念/
かんづm /缶詰/
かんづk /感付/
かんづi /感付/
かんちがi /勘違/
かんだかs /甲高/疳高/
かんだかk /甲高/疳高/
かんだかi /甲高/疳高/
かんだかg /甲高/疳高/
かんたんすg /簡単過/
かんせいs /完成/
かんすうよb /関数呼/
かんじょうてきすg /感情的過/
かんじょうだかs /勘定高;≒算盤高い/
かんじょうだかk /勘定高;≒算盤高い/
かんじょうだかi /勘定高;≒算盤高い/
かんじょうだかg /勘定高;≒算盤高い/
かんじやすs /感じ易/
かんじやすk /感じ易/
かんじやすi /感じ易/
かんじやすg /感じ易/
かんじまz /漢字混/
かんじとt /感じ取/
かんじとr /感じ取/
かんじとn /感じ取/
かんじとc /感じ取/
かんじつづk /感じ続/
かんじいt /感じ入/
かんじいr /感じ入/
かんじいn /感じ入/
かんじいc /感じ入/
かんしんs /感心/
かんしゃいたs /感謝致/
かんしゃs /感謝/
かんげいいたs /歓迎致/
かんけいs /関係/
かんぐt /勘繰/
かんぐr /勘繰/
かんぐn /勘繰/
かんぐc /勘繰/
かんきわm /感極/
かんきr /缶切/
かんがみr /鑑み;※送り位置補正/
かんがえぶかs /考え深/
かんがえぶかk /考え深/
かんがえぶかi /考え深/
かんがえぶかg /考え深/
かんがえぬk /考え抜/
かんがえぬi /考え抜/
かんがえなおs /考え直/
かんがえつk /考え付/
かんがえつi /考え付/
かんがえちがi /考え違;名詞/
かんがえだs /考え出/
かんがえすg /考え過/
かんがえこn /考え込/
かんがえこm /考え込/
かんがえおよn /考え及/
かんがえおよb /考え及/
かんがえあわs /考え併/
かんがえあw /考え合/
かんがいぶかs /感慨深/
かんがいぶかk /感慨深/
かんがいぶかi /感慨深/
かんがいぶかg /感慨深/
かんがm /鑑/鑒;異体字/
かんがh /考/
かんがe /考/稽;<rare>/勘;<rare>/攷;<rare>/
かんかつちがi /管轄違/
かんいr /缶入/
かんz /感;(feel)/観;(contemplate) 真理を観ずる/
かんt /冠/
かんs /関;関数/冠/姦;姦淫/刊/緘;(silence) 口を緘する/神/關;「関」の旧字/
かんj /感/
かんg /勘/
かんd /感/勘/
かわりはt /変わり果/
かわりつづk /変わり続/
かわむk /皮剥/
かわばたどおr /川端通/
かわづr /川釣/
かわぞi /川沿/
かわくだr /川下/
かわきr /皮切/
かわいs /可哀/可愛/
かわいr /可愛/
かわいk /可愛/
かわいi /可愛/
かわいg /可愛/
かわt /変/變;「変」の旧字/代/換/替/
かわs /交/躱;(avoid) 攻撃を躱す/
かわr /変/代/換/替/變;「変」の旧字/
かわn /変/代/換/替/變;「変」の旧字/
かわk /乾/渇;(thirst) 喉が渇く/
かわi /乾/渇;(thirst) 喉が渇く/
かわc /変/代/換/替/變;「変」の旧字/
かろy /軽/輕;「軽」の旧字/
かろu /辛/
かろn /軽/
かれんn /可憐/
かれはt /枯れ果/
かれw /彼/
かれt /涸/彼/
かれr /彼/涸/
かれn /涸/彼/
かれm /彼/
かれh /彼/
かれg /彼/
かれc /涸/
かるすg /軽過/
かるがるs /軽々/軽軽/
かるu /軽/輕;「軽」の旧字/
かるs /軽/輕;「軽」の旧字/
かるm /軽/輕;「軽」の旧字/
かるk /軽/輕;「軽」の旧字/
かるi /軽/輕;「軽」の旧字/
かるg /軽/輕;「軽」の旧字/
かりわたs /仮渡/
かりぬi /仮縫/
かりとt /刈り取/刈取/
かりとr /刈り取/刈取/
かりとn /刈り取/刈取/
かりとc /刈り取/刈取/
かりっぱなs /借りっ放;やべ、本-しだ/
かりだs /借り出;(borrow)本を借り出す/駆り出;(bring out)応援に駆り出す/狩り出;(hunt out)犯人を狩り出す/
かりたおs /借り倒/
かりたt /駆り立/
かりそm /仮初/
かりずまi /仮住/
かりずm /借り住/仮住/
かりさしおさe /仮差押/
かりこs /借り越/借越/
かりこn /狩り込/刈り込/刈込/
かりこm /狩り込/刈り込/刈込/
かりきt /借り切/
かりきr /借り切/
かりきn /借り切/
かりきc /借り切/
かりかs /借り貸/
かりかe /借り換/借換/
かりうk /借り受/
かりいr /借り入/刈り入/借入/刈入;名詞,ラ行下一/
かりあつm /駆り集/
かりあg /借り上/刈り上/
かりn /仮/
からめとt /搦め捕/
からめとr /搦め捕/
からめとn /搦め捕/
からめとc /搦め捕/
からむs /空蒸/
からみつk /絡み付/
からみつi /絡み付/
からみあw /絡み合/
からみあu /絡み合/
からみあt /絡み合/
からみあo /絡み合/
からみあi /絡み合/
からみあe /絡み合/
からみあc /絡み合/
からまわr /空回/
からぶt /空振/
からぶr /空振/
からぶk /乾拭/
からづm /空積/
からだk /空焚/
からたけわr /幹竹割/
からすg /辛過/
からさわg /空騒/
からくt /絡繰;[文語]-る/
からくr /絡繰;[文語]-る/
からくn /絡繰;[文語]-る/
からくc /絡繰;[文語]-る/
からうr /空売/
からあg /空揚/
からs /辛;(hot) 辛いカレー/枯ら;※送り位置補正/鹹;(salty) 鹹い味噌汁/
からp /空/
からn /絡/
からm /絡/辛;(hot) 辛いカレー/搦;搦め捕る/鹹;(salty) 鹹い味噌汁/
からk /辛;(hot) 辛いカレー/鹹;(salty) 鹹い味噌汁/
からi /辛;(hot) 辛いカレー/鹹;(salty) 鹹い味噌汁/
からg /絡;裾を絡げる/紮;≒絡げる/辛;(hot) 辛いカレー/鹹;(salty) 鹹い味噌汁/
かよわs /か弱/
かよわk /か弱/
かよわi /か弱/
かよわg /か弱/
かよいつづk /通い続/
かよいつm /通い詰/
かよいあw /通い合/
かよいあu /通い合/
かよいあt /通い合/
かよいあo /通い合/
かよいあi /通い合/
かよいあe /通い合/
かよいあc /通い合/
かよw /通/
かよu /通/
かよt /通/
かよo /通/
かよi /通/
かよe /通/
かよc /通/
かゆs /痒/癢;=痒い/
かゆm /痒/
かゆk /痒/癢;=痒い/
かゆi /痒/癢;=痒い/
かゆg /痒/癢;=痒い/
かやぶk /茅葺/
かやr /蚊遣/
かもしだs /醸し出/
かもs /醸/釀;「醸」の旧字(人名用漢字)/
かもr /鴨/
かむt /被/冠/
かむr /被/冠/
かむn /被/冠/
かむc /被/冠/
かみわk /噛み分/
かみゆi /髪結/
かみづm /紙詰/
かみつぶs /噛み潰/
かみつk /噛み付/
かみつi /噛み付/
かみちぎt /噛み千切/
かみちぎr /噛み千切/
かみちぎn /噛み千切/
かみちぎc /噛み千切/
かみだのm /神頼/
かみしほうがたm /上四方固/
かみしm /噛み締/
かみころs /噛み殺/
かみくだk /噛み砕/
かみくだi /噛み砕/
かみきt /噛み切/
かみきr /噛み切/紙切/髪切/
かみきn /噛み切/
かみきc /噛み切/
かみかざr /髪飾/
かみかくs /神隠/
かみおr /神降/
かみあわs /噛み合/
かみあw /噛み合/
かみあu /噛み合/
かみあt /噛み合/
かみあo /噛み合/
かみあi /噛み合/
かみあe /噛み合/
かみあc /噛み合/
かみs /神/
かみg /神;-ががり,-がかって (神懸かり・神憑り)/
かまびすs /喧/
かまw /構/
かまu /構/
かまt /構/
かまo /構/
かまk /感/
かまi /構/
かまh /構/
かまe /構/
かまc /構/
かぼそs /か細/
かぼそk /か細/
かぼそi /か細/
かぼそg /か細/
かへt /歸;「帰」の旧字/皈;「帰」の異体字/
かへr /歸;「帰」の旧字/皈;「帰」の異体字/
かぶわk /株分/
かぶりつk /齧り付;NB:「かじりつk」と同形/
かぶりつi /齧り付;NB:「かじりつk」と同形/
かぶt /被/齧;[文語](ラ行四段)「-り付く」/
かぶs /被/
かぶr /被/気触;かぶれる/齧;[文語](ラ行四段)「-り付く」/
かぶn /被/齧;[文語](ラ行四段)「-り付く」/
かぶk /傾;古語。「歌舞伎」の語源/
かぶi /傾;古語。「歌舞伎」の語源/
かぶc /被/齧;[文語](ラ行四段)「-り付く」/
かびくさs /黴臭/カビ臭/
かびくさk /カビ臭/黴臭/
かびくさi /黴臭/カビ臭/
かびくさg /黴臭/カビ臭/
かびz /黴/
かびy /黴/
かびt /黴/
かびs /黴/
かびr /黴/
かびn /黴/
かびm /黴/
かびk /黴/
かびc /黴/
かばw /庇/
かばu /庇/
かばt /庇/
かばo /庇/
かばi /庇/
かばe /庇/
かばc /庇/
かはらi /過払/
かはs /交/
かのうn /可能/
かねもうk /金儲/
かねもt /金持/
かねもc /金持/
かねまわr /金回/
かねばらi /金払/
かねづかi /金遣/
かねそなe /兼ね備/
かねあw /兼ね合/
かねあi /兼ね合/兼合/
かねz /兼/
かねy /兼/
かねt /予/兼/
かねs /兼/
かねr /兼/
かねn /兼/
かねm /兼/
かねc /兼/
かにばさm /蟹挟/
かならz /必/
かなづかi /仮名遣/
かなしばr /金縛/
かなぐりすt /かなぐり捨/
かなぎr /金切/
かなきr /金切/
かながk /仮名書/
かなw /叶;叶わぬ夢/敵;君には敵わないよ/適;(conform) 目的に適う/
かなu /叶;(come true) 夢が叶う/敵;(rival) 敵う者なし/適;(conform) 目的に適う/
かなt /叶;(come true) 夢が叶う/適;(conform) 目的に適う/敵;(rival) 敵う者なし/
かなs /悲;(字義:胸が張り裂ける)/哀;(字義:思いで胸がつかえる)/愛;(字義:≒哀) NB:「いとs」と同形/
かなo /叶;(come true) 夢が叶う/敵;(rival) 敵う者なし/適;(conform) 目的に適う/
かなi /叶;(come true) 夢が叶う/敵;(rival) 敵う者なし/適;(conform) 目的に適う/
かなe /叶;(come true) 夢が叶う/敵;(rival) 敵う者なし/適;(conform) 目的に適う/
かなd /奏/
かなc /叶;(come true) 夢が叶う/敵;(rival) 敵う者なし/適;(conform) 目的に適う/
かどk /角/
かていs /仮定/
かつぎだs /担ぎ出/
かつぎこn /担ぎ込/
かつぎこm /担ぎ込/
かつぎあg /担ぎ上/
かつt /嘗/
かつi /担/擔;「担」の旧字/
かつg /担/擔;「担」の旧字/
かつe /餓/
かっぱらw /掻っ払/
かっぱらu /掻っ払/
かっぱらt /掻っ払/
かっぱらo /掻っ払/
かっぱらi /掻っ払/
かっぱらc /掻っ払/
かっとn /かっ飛/
かっとb /かっ飛/
かってでz /買って出/
かってでy /買って出/
かってでt /買って出/
かってでr /買って出/
かってでn /買って出/
かってでm /買って出/
かってこz /買って来/
かってこy /買って来/
かってこs /買って来/
かってこr /買って来/
かってこn /買って来/
かってこi /買って来/
かってくr /買って来/
かってくn /買って来/
かってきy /買って来/
かってきt /買って来/
かってきs /買って来/
かってきn /買って来/
かってきm /買って来/
かってきd /買って来/
かってきc /買って来/
かっさらw /掻っ攫/
かっさらu /掻っ攫/
かっさらt /掻っ攫/
かっさらo /掻っ攫/
かっさらi /掻っ攫/
かっさらc /掻っ攫/
かっさばk /掻っ捌/
かっさばi /掻っ捌/
かっこわるs /格好悪/
かっこわるk /格好悪/
かっこわるi /格好悪/
かっこわるg /格好悪/
かっこうわるs /格好悪/
かっこうわるk /格好悪/
かっこうわるi /格好悪/
かっこうわるg /格好悪/
かっこうよs /格好良/
かっこうよk /格好良/
かっこうよi /格好良/
かっこn /掻っ込/
かっこm /掻っ込/
かっくr /かっ喰/かっ食/
かっきづk /活気付/
かっきづi /活気付/
かっs /渇/
かちまk /勝ち負/
かちほこt /勝ち誇/
かちほこr /勝ち誇/
かちほこn /勝ち誇/
かちほこc /勝ち誇/
かちのこt /勝ち残/
かちのこr /勝ち残/
かちのこn /勝ち残/
かちのこc /勝ち残/
かちぬk /勝ち抜/勝抜/
かちぬi /勝ち抜/勝抜/
かちにg /勝ち逃/
かちとt /勝ち取/
かちとr /勝ち取/
かちとn /勝ち取/
かちとc /勝ち取/
かちつづk /勝ち続/
かちっぱなs /勝ちっ放/
かちすすn /勝ち進/
かちすすm /勝ち進/
かちこs /勝ち越/
かちおt /搗ち落/
かちおc /搗ち落/
かちえz /勝ち得/贏ち得/
かちえy /勝ち得/贏ち得/
かちえt /勝ち得/贏ち得/
かちえs /勝ち得/贏ち得/
かちえr /勝ち得/贏ち得/
かちえn /勝ち得/贏ち得/
かちえm /勝ち得/贏ち得/
かちえk /勝ち得/贏ち得/
かちえc /勝ち得/贏ち得/
かちあw /搗ち合/
かちあu /搗ち合/
かちあt /搗ち合/
かちあo /搗ち合/
かちあi /搗ち合/
かちあg /勝ち上/搗ち上;[相撲]/
かちあc /搗ち合/
かたわらいたs /傍ら痛/
かたわらいたk /傍ら痛/
かたわらいたi /傍ら痛/
かたわらいたg /傍ら痛/
かたわr /傍/片割/
かたりつづk /語り続/
かたりつたe /語り伝/
かたりつくs /語り尽/
かたりつk /語り尽/
かたりつi /語り継/
かたりつg /語り継/
かたりだs /語り出/
かたりきk /語り聞/
かたりかk /語り掛/
かたりあw /語り合/
かたりあu /語り合/
かたりあt /語り合/
かたりあo /語り合/
かたりあk /語り明/
かたりあi /語り合/
かたりあe /語り合/
かたりあc /語り合/
かたよt /偏/片寄/
かたよs /片寄/
かたよr /偏/片寄/
かたよn /偏/片寄/
かたよc /偏/片寄/
かたむすb /片結/
かたむk /傾/
かたむi /傾/
かたべr /片減/
かたぶk /傾;古語/
かたぶi /傾;古語/
かたびらk /片開/
かたひらk /片開/
かたばかr /形許/
かたはらいたs /片腹痛/
かたはらいたk /片腹痛/
かたはらいたi /片腹痛/
かたはらいたg /片腹痛/
かたなs /形無/
かたどおr /型通/
かたどt /象/
かたどr /象/模;≒象る/方取;(気にかける)/
かたどn /象/
かたどc /象/
かたづくr /形作/
かたづk /片付/型付/
かたづi /片付/
かたつk /型付/肩付/
かたちづくt /形作/
かたちづくr /形作/
かたちづくn /形作/
かたちづくc /形作/
かたたたk /肩叩/
かたたがe /方違/
かたすk /肩透/
かたすg /硬過/
かたじけなs /忝/辱/
かたじけなk /忝/辱/
かたじけなi /忝/辱/
かたじけなg /忝/辱/
かたこr /肩凝/
かたぐるs /堅苦/
かたくるs /堅苦/
かたくn /頑/
かたがわr /肩代/
かたがw /肩代/
かたかk /肩掛/
かたおもi /片思/片想/
かたおs /型押/
かたえびがたm /片海老固/
かたいr /肩入/
かたy /片/
かたt /語/騙;(deceive) 名を騙る/
かたs /硬;(カチコチ)「硬い石／演奏」/固;(generic)/堅;(しっかり)「堅いやり方」/難;(difficult)/片;(clean) 部屋を-/
かたr /語/騙;(deceive) 名を騙る/
かたp /片/
かたn /語/騙;(deceive) 名を騙る/
かたm /固/硬/堅/傾;非正則(かたむk)/難;(difficult)/
かたk /固;(generic)/硬;(カチコチ)「硬い石／演奏」/堅;(しっかり)「堅いやり方」/難;(difficult)/
かたi /固;(generic)/硬;(カチコチ)「硬い石／演奏」/堅;(しっかり)「堅いやり方」/難;(difficult)/
かたg /傾;首を-げる/固;(generic)/硬;(カチコチ)「硬い石／演奏」/堅;(しっかり)「堅いやり方」/難;(difficult)/
かたd /片/
かたc /語/騙;(deceive) 名を騙る/
かぞくづr /家族連/
かぞくあw /家族合/
かぞえたt /数え立/
かぞえきt /数え切/
かぞえきr /数え切/
かぞえきn /数え切/
かぞえきc /数え切/
かぞえいr /数え入/
かぞえあg /数え上/
かぞe /数/數;旧字/
かそけs /幽/
かそけk /幽/
かぜむk /風向/
かぜとおs /風通/
かぜあt /風当/
かせぎだs /稼ぎ出/
かせi /稼/
かせg /稼/
かずすくn /数少/
かずしr /数知/
かずかぎりなs /数限り無/
かずかぎりなk /数限り無/
かずかぎりなi /数限り無/
かずかぎr /数限/
かずおおs /数多/
かずおおk /数多/
かずおおi /数多/
かずおおg /数多/
かずあw /数合/
かずあt /数当/
かずk /被/
かずi /被/
かすめとt /掠め取/
かすめとr /掠め取/
かすめとn /掠め取/
かすめとc /掠め取/
かすみわたt /霞み渡/
かすみわたr /霞み渡/
かすみわたn /霞み渡/
かすみわたc /霞み渡/
かすがどおr /春日通/
かすt /掠/擦;NB:「すr」「こすr」「なすr」と同形/
かすr /擦;NB:「すr」「こすr」「なすr」と同形/掠/
かすn /霞/擦;NB:「すr」「こすr」「なすr」と同形/掠/翳;<rare> ≒霞む 「目が翳む」/
かすm /霞/掠/翳;<rare> ≒霞む 「目が翳む」/
かすk /微;(字義:目立たない)/幽;(字義:薄暗くて良く見えない)/
かすc /擦;NB:「すr」「こすr」「なすr」と同形/掠/
かじりつk /齧り付/
かじりつi /齧り付/
かじょうがk /箇条書/
かじかn /悴/
かじかm /悴/
かじt /齧/噛/囓;「齧」の異体字/
かじr /齧/囓;「齧」の異体字/噛/
かじn /齧/囓;「齧」の異体字/噛/
かじc /齧/囓;「齧」の異体字/噛/
かしまs /姦/
かしつk /貸し付/貸付/
かしだs /貸し出/貸出/
かしずk /傅/
かしずi /傅/
かししぶt /貸し渋/
かししぶr /貸し渋/
かししぶn /貸し渋/
かししぶc /貸し渋/
かしこs /賢/畏;(おそれ多い)/
かしこm /畏/
かしこk /賢/畏;(おそれ多い)/
かしこi /賢/畏;(おそれ多い)/
かしこg /賢/畏;(おそれ多い)/
かしきt /貸し切/貸切/
かしきr /貸し切/貸切/
かしきn /貸し切/貸切/
かしきc /貸し切/貸切/
かしかr /貸し借/
かしi /傾/炊/爨/
かしg /炊;‖ガ行五段[gi]/爨;‖ガ行五段[gi]/傾/
かざりつk /飾り付/
かざりたt /飾り立/
かざむk /風向/
かざとおs /風通/
かざt /飾/餝;「飾」の異体字/錺;<rare>(金属でかざる)/
かざs /翳/
かざr /飾/錺;<rare>(金属でかざる)/餝;「飾」の異体字/
かざn /飾/錺;<rare>(金属でかざる)/餝;「飾」の異体字/
かざc /飾/錺;<rare>(金属でかざる)/餝;「飾」の異体字/
かさばt /嵩張/
かさばr /嵩張/
かさばn /嵩張/
かさばc /嵩張/
かさねあw /重ね合/
かさねあu /重ね合/
かさねあt /重ね合/
かさねあo /重ね合/
かさねあi /重ね合/
かさねあe /重ね合/
かさねあc /重ね合/
かさなりあw /重なり合/
かさなりあu /重なり合/
かさなりあt /重なり合/
かさなりあo /重なり合/
かさなりあi /重なり合/
かさなりあe /重なり合/
かさなりあc /重なり合/
かさなt /重な;※送り位置補正/
かさn /重/嵩/
かさm /嵩/
かこつk /託/
かこくn /苛酷/
かこいこn /囲い込/
かこいこm /囲い込/
かこw /囲/圍;「囲」の旧字/
かこu /囲/圍;「囲」の旧字/
かこt /託/囲/喞;≒託つ/圍;「囲」の旧字/
かこo /囲/圍;「囲」の旧字/
かこn /囲/圍;「囲」の旧字/
かこm /囲/圍;「囲」の旧字/
かこi /囲/圍;「囲」の旧字/
かこe /囲/圍;「囲」の旧字/
かこc /囲/圍;「囲」の旧字/
かげふm /影踏/
かげきすg /過激過/
かげt /翳/陰/
かげr /翳/陰/
かげn /翳/陰/
かげc /翳/陰/
かけわたs /架け渡;橋を-/掛け渡;簾を-/
かけよt /駆け寄/
かけよr /駆け寄/
かけよn /駆け寄/
かけよc /駆け寄/
かけもt /掛け持/掛持/
かけもc /掛け持/掛持/
かけめぐt /駆け巡/
かけめぐr /駆け巡/
かけめぐn /駆け巡/
かけめぐc /駆け巡/
かけまわt /駆け回/
かけまわr /駆け回/
かけまわn /駆け回/
かけまわc /駆け回/
かけひk /駆け引;(恋の)-き/駆引/
かけのぼt /駈け登/
かけのぼr /駈け登/
かけのぼn /駈け登/
かけのぼc /駈け登/
かけぬk /駆け抜/
かけどおs /駆け通/
かけてゆk /駆けて行/
かけていt /駈けて行/駆けて行/
かけていk /駆けて行/駈けて行/
かけていc /駆けて行/駈けて行/
かけつけt /駆け付け;※送り位置補正/
かけつk /駆け付/
かけちがw /掛け違/
かけちがu /掛け違/
かけちがt /掛け違/
かけちがo /掛け違/
かけちがi /掛け違/
かけちがc /掛け違/
かけだs /駆け出/駆出/掛け出;-した濡れ縁/掛出/
かけずりまわt /駆けずり回/
かけずりまわr /駆けずり回/
かけずりまわn /駆けずり回/
かけずりまわc /駆けずり回/
かけすt /掛け捨/
かけこn /駆け込/駆込/駈け込/駈込/
かけこm /駆け込/駆込/駈け込/駈込/
かけかe /掛け替/掛替/
かけおt /駆け落/駆落/
かけおr /駆け下/駆け降/駈け降/駈け下/
かけおc /駆け落/駆落/
かけあわs /掛け合/
かけあw /掛け合/
かけあu /懸合/掛合/懸け合/掛け合/
かけあg /駆け上/駈け上/
かけt /翔/
かけr /翔/
かけn /翔/
かけc /翔/
かぐわs /芳/香/馨/
かくりs /隔離/
かくまw /匿/
かくまu /匿/
かくまt /匿/
かくまo /匿/
かくまi /匿/
かくまe /匿/
かくまc /匿/
かくほs /確保/
かくばt /角張/
かくばr /角張/
かくばn /角張/
かくばc /角張/
かくのごとk /斯くの如/
かくのうs /格納/
かくにんねがi /確認願/
かくにんくだs /確認下/
かくにんおよb /確認及/
かくにんs /確認/
かくていs /確定/
かくづk /格付/
かくちょうたかs /格調高/
かくちょうたかk /格調高/
かくちょうたかi /格調高/
かくちょうたかg /格調高/
かくだいs /拡大/
かくしもt /隠し持/
かくしどr /隠し撮/
かくしとおs /隠し通/
かくしきばr /格式張/
かくしきt /隠し切/
かくしきr /隠し切/
かくしきn /隠し切/
かくしきc /隠し切/
かくさg /格下/
かくぎr /角切/
かくがr /角刈/
かくおt /角落/
かくあg /格上/
かくt /確/斯く;※送り位置補正/
かくs /隠/画;一線を画す/匿;(字義:入れ物に入れてかくす) ≒隠す/劃;≒画す/隱;「隠」の旧字/
かくr /隠/隱;「隠」の旧字/
かくm /匿;非正則(かくまu)/
かぎわk /嗅ぎ分/
かぎりなs /限り無/
かぎりなk /限り無/
かぎりなi /限り無/
かぎまわt /嗅ぎ回/
かぎまわr /嗅ぎ回/
かぎまわn /嗅ぎ回/
かぎまわc /嗅ぎ回/
かぎつk /嗅ぎ付/
かぎだs /嗅ぎ出/
かぎざk /鉤裂/
かぎあt /嗅ぎ当/
かぎt /限/
かぎr /限/
かぎn /限/
かぎc /限/
かきわすr /書き忘/
かきわk /掻き分;髪を-/書き分;文体を-/かき分/
かきよごs /書き汚/
かきやすs /書き易/
かきやすk /書き易/
かきやすi /書き易/
かきやすg /書き易/
かきもどs /書き戻/書戻/
かきもr /書き漏/
かきむしt /掻き毟/
かきむしr /掻き毟/
かきむしn /掻き毟/
かきむしc /掻き毟/
かきみだs /掻き乱/
かきまわs /掻き回/
かきまちがi /書き間違/
かきまちがe /書き間違/
かきまz /かき混/掻き混/
かきはじm /書き始/
かきのこs /書き残/
かきぬk /書き抜/
かきぬi /書き抜/
かきならs /掻き均/
かきならb /書き並/
かきながs /書き流;さらっと-す/
かきなおs /書き直/
かきなr /かき鳴/掻き鳴/書き慣/
かきとどm /書き留/
かきとt /書き取/書取/
かきとr /書き取/書取/
かきとn /書き取/書取/
かきとm /書き留/
かきとc /書き取/書取/
かきとb /書き飛/
かきつらn /書き連/
かきつづt /書き綴/
かきつづr /書き綴/
かきつづn /書き綴/
かきつづk /書き続/
かきつづc /書き綴/
かきつたe /書き伝/
かきつくs /書き尽/
かきつk /書き尽/書き付/
かきつi /書き継/
かきつg /書き継/
かきちr /書き散/
かきだs /書き出/書出/かき出/掻き出/
かきたt /書き立/
かきたs /書き足/
かきたr /書き足/
かきたm /書き溜/
かきぞm /書き初/
かきそんz /書き損/
かきそんj /書き損/
かきそこn /書き損/
かきそe /書き添/
かきすt /書き捨/かき捨/掻き捨/
かきしるs /書き記/
かきこn /書き込/書込/掻き込/
かきこm /書き込/書込/掻き込/
かきけs /かき消/掻き消/
かきくわe /書き加/
かきくもt /掻き曇/
かきくもr /掻き曇/
かきくもn /掻き曇/
かきくもc /掻き曇/
かきくどk /掻き口説/
かきくどi /掻き口説/
かきくだs /書き下/
かきくずs /書き崩/
かききt /掻き切/
かききr /掻き切/
かききn /掻き切/
かききe /掻き消/かき消/
かききc /掻き切/
かきかえr /書き換え;※送り位置補正/
かきかw /書き変/
かきかe /書き換/書換/書き替/書き変/
かきおろs /書下/描き下ろ;※送り位置補正/
かきおよn /書き及/
かきおよb /書き及/
かきおとs /書き落/
かきおさm /書き納/
かきおこs /書き起/
かきおくt /書き送/
かきおくr /書き送/
かきおくn /書き送/
かきおくc /書き送/
かきおt /書き落/
かきおr /書き下/書下/
かきおk /書き起/書き置/書置/
かきおi /書き置/書置/
かきおe /書き終/
かきうつs /書き写/
かきいだk /掻き抱/
かきいだi /掻き抱/
かきいr /書き入/
かきあらわs /書き表/
かきあらたm /書き改/
かきあやまt /書き誤/
かきあやまr /書き誤/
かきあやまn /書き誤/
かきあやまc /書き誤/
かきあつm /かき集/掻き集/
かきあg /書き上/
かがよu /耀/
かがよh /耀/
かがやきわたt /輝き渡/
かがやきわたr /輝き渡/
かがやきわたn /輝き渡/
かがやきわたc /輝き渡/
かがやk /輝/耀;(字義:ぎらぎらとかがやく)/赫;(字義:赤々と火照る)/
かがやi /輝/耀;(字義:ぎらぎらとかがやく)/赫;(字義:赤々と火照る)/
かがみこn /屈み込/
かがみこm /屈み込/
かがt /縢;sew/
かがr /縢;sew/
かがn /屈/縢;sew/
かがm /屈/
かがc /縢;sew/
かかわりあw /関わり合/係わり合/
かかわりあu /関わり合/係わり合/
かかわりあt /関わり合/係わり合/
かかわりあo /関わり合/係わり合/
かかわりあi /関わり合/係わり合/
かかわりあe /関わり合/係わり合/
かかわりあc /関わり合/係わり合/
かかわt /拘;(字義:引っ掛かる)「それにも拘らず」/係;(字義:紐でつながる) 「…に係る法律」 NB:「かかr」と同形/関;(字義:かんぬきのように事物をつなぐ) 「プロジェクトに関る」/
かかわr /係;(字義:紐でつながる) 「…に係る法律」 NB:「かかr」と同形/拘;(字義:引っ掛かる)「それにも拘らず」/関;(字義:かんぬきのように事物をつなぐ) 「プロジェクトに関る」/
かかわn /係;(字義:紐でつながる) 「…に係る法律」 NB:「かかr」と同形/拘;(字義:引っ掛かる)「それにも拘らず」/関;(字義:かんぬきのように事物をつなぐ) 「プロジェクトに関る」/
かかわc /係;(字義:紐でつながる) 「…に係る法律」 NB:「かかr」と同形/拘;(字義:引っ掛かる)「それにも拘らず」/関;(字義:かんぬきのように事物をつなぐ) 「プロジェクトに関る」/
かかりつk /掛かり付/
かかりすg /掛り過/
かかえこn /抱え込/
かかえこm /抱え込/
かかw /関;(字義:かんぬきのように事物をつなぐ) 「プロジェクトに関わる」/係;(字義:紐でつながる) 「…に係わる事例」/拘;(字義:引っ掛かる)「それにも拘わらず」/關;「関」の旧字/
かかt /掛/係/罹;病気に罹る/
かかr /係/掛/罹;病気に罹る/
かかn /係/掛/罹;病気に罹る/
かかg /掲/
かかe /抱/
かかc /係/掛/罹;病気に罹る/
かおりたかs /香り高/
かおりたかk /香り高/
かおりたかi /香り高/
かおりたかg /香り高/
かおりたt /香り立/
かおりたc /香り立/
かおむk /顔向/
かおみしr /顔見知/
かおまk /顔負/
かおぶr /顔触/
かおつk /顔付/
かおだt /顔立/
かおだs /顔出/
かおあわs /顔合/
かおあw /顔合/
かおt /薫/香/馨/
かおr /香/薫/馨/
かおn /香/薫/馨/
かおc /香/薫/馨/
かえりざk /返り咲/
かえりざi /返り咲/
かえりがk /帰り掛/
かえりうt /返り討/
かえりm /省;(反省) 我が身を省みる/顧;(look back) 過去を顧みる,危険を顧みない/
かえってこz /帰って来;子供が家に-/返って来;メールが-/
かえってこy /帰って来;子供が家に-/返って来;メールが-/
かえってこs /帰って来;子供が家に-/返って来;メールが-/
かえってこr /帰って来;子供が家に-/返って来;メールが-/
かえってこn /帰って来;子供が家に-/返って来;メールが-/
かえってこi /帰って来;子供が家に-/返って来;メールが-/
かえってくr /帰って来;子供が家に-/返って来;メールが-/
かえってくn /帰って来;子供が家に-/返って来;メールが-/
かえってきy /帰って来;子供が家に-/返って来;メールが-/
かえってきt /帰って来;子供が家に-/返って来;メールが-/
かえってきs /帰って来;子供が家に-/返って来;メールが-/
かえってきn /帰って来;子供が家に-/返って来;メールが-/
かえってきm /帰って来;子供が家に-/返って来;メールが-/
かえってきd /帰って来;子供が家に-/返って来;メールが-/
かえってきc /帰って来;子供が家に-/返って来;メールが-/
かえすがえs /返す返/
かえがたs /代え難/
かえがたk /代え難/
かえがたi /代え難/
かえがたg /代え難/
かえz /替/換/
かえy /替/換/
かえt /帰;家に帰る/返;我に返る,ひっくり返る/却/反;(反転する)/還;(元に戻る) 土に還る/歸;「帰」の旧字/皈;「帰」の異体字/孵;(孵化) 卵が孵る/替/換/卻;「却」の異体字/
かえs /返;金を返す,裏返す/帰;家に帰す/還;(元に戻す) 自然に還す/孵;(孵化) 卵を孵す/反;(≒返す) 反転する/歸;「帰」の旧字/皈;「帰」の異体字/替/換/
かえr /帰;家に帰る/返;我に返る,ひっくり返る/還;(元に戻る) 土に還る/孵;(孵化) 卵が孵る/反;(反転する)/替/換/歸;「帰」の旧字/皈;「帰」の異体字/
かえn /帰;家に帰る/返;我に返る,ひっくり返る/還;(元に戻る) 土に還る/孵;(孵化) 卵が孵る/反;(反転する)/替/換/歸;「帰」の旧字/皈;「帰」の異体字/
かえm /替/換/
かえc /帰;家に帰る/歸;「帰」の旧字/皈;「帰」の異体字/返;我に返る,ひっくり返る/還;(元に戻る) 土に還る/孵;(孵化) 卵が孵る/反;(反転する)/替/換/
かいもどs /買戻/買い戻/
かいもとm /買い求/
かいまみz /垣間見/
かいまみy /垣間見/
かいまみt /垣間見/
かいまみs /垣間見/
かいまみr /垣間見/
かいまみn /垣間見/
かいまみm /垣間見/
かいまみk /垣間見/
かいまみe /垣間見/
かいまみc /垣間見/
かいほうs /解放/
かいびかe /買い控/
かいのs /買い乗/
かいなおs /買い直/
かいなr /飼い馴/
かいなd /掻い撫/
かいどくd /買い得/
かいとt /買い取/買取/
かいとr /買い取/買取/
かいとn /買い取/買取/
かいとc /買い取/買取/
かいつまn /掻い摘/
かいつまm /掻い摘/
かいつづk /買い続/
かいつk /買い付/買付/
かいだs /買い出/
かいたたk /買い叩/
かいたたi /買い叩/
かいたs /買い足/
かいそろe /買い揃/
かいせつs /開設/
かいしょうなs /甲斐性無/
かいしゃがえr /会社帰/
かいしぶt /買い渋/
かいしぶr /買い渋/
かいしぶn /買い渋/
かいしぶc /買い渋/
かいしm /買い占/買占/
かいささe /買い支/
かいさいいたs /開催致/
かいごろs /飼い殺/
かいこs /買い越/
かいこn /買い込/
かいこm /買い込/
かいけつs /解決/
かいぐi /買い食/
かいくぐt /掻い潜/
かいくぐr /掻い潜/
かいくぐn /掻い潜/
かいくぐc /掻い潜/
かいきt /買い切/
かいきr /買い切/
かいきn /買い切/
かいきc /買い切/
かいがんまわr /海岸回/
かいがんちかs /海岸近/
かいがんちかk /海岸近/
かいがんちかi /海岸近/
かいがんちかg /海岸近/
かいがいs /甲斐甲斐/
かいかぶt /買い被/
かいかぶr /買い被/
かいかぶn /買い被/
かいかぶc /買い被/
かいかe /買い替/買い換/買替/
かいおk /買い置/
かいおi /買い置/
かいうk /買い受/
かいいr /買い入/買入/
かいあたe /買い与/
かいあさt /買い漁/
かいあさr /買い漁/
かいあさn /買い漁/
かいあさc /買い漁/
かいあおt /買い煽/
かいあおr /買い煽/
かいあおn /買い煽/
かいあおc /買い煽/
かいあw /貝合/
かいあg /買い上/
かいt /解/觧;「解」の異体字/
かいs /解;善意に解する/介;業者を介する,意に介しない/会;一堂に会する/會;「会」の旧字/觧;「解」の異体字/
かあs /母/
かw /変;(変化)色が変わる/代;(代理)代わりに出席する/交;挨拶を交わす/替;世代が替わる/買/換/飼/變;「変」の旧字/支;ささえる/
かu /買/飼/交/支;ささえる/
かt /勝/買/飼/刈;(crop)草を刈る/狩;(hunt)兎を狩る/且;-つて/駆;バイクを駆って/交;飛び交って/克;(overcome) 逆境に克つ/糅;-てて加えて/苅;「刈」の異体字/驅;「駆」の旧字/支;ささえる/上;(尺八の)カリ⇔減り(メリ)/搗/
かs /貸/化/課;税を課す/科;懲役を科す/嫁;富農に嫁す/架;橋を架す/和;=わ-する/仮;許す/呵/藉/淅/
かr /借/枯;草が枯れる/狩;(hunt)兎を狩る/刈;(crop)草を刈る/駆;(drive)車を駆る,衝動に駆られる/涸;川が涸れる/嗄;声が嗄れる/仮/上;(尺八の)カリ⇔減り(メリ)/苅;「刈」の異体字/驅;「駆」の旧字/
かo /買/飼/交/支;ささえる/
かn /兼/噛/彼/狩;(hunt)兎を狩る/刈;(crop)草を刈る/駆;(drive)車を駆る,衝動に駆られる/咬;かみつく。「蛇が咬む」/嚼;細かくかみ砕く/醸;[文語](酒を)かもす/上;(尺八の)カリ⇔減り(メリ)/苅;「刈」の異体字/驅;「駆」の旧字/
かm /噛/咬;かみつく。「蛇が咬む」/嚼;細かくかみ砕く/醸;[文語](酒を)かもす/
かk /書/掛/欠/駆;駆け足/賭;(bet) 金を賭ける/掻;痒いところを掻く/描;絵を描く NB:「えがk」と同形/画;線を画く/架;橋を架ける/駈;「駆」の旧字(人名用漢字)/翔;空を翔ける/斯;-く(も)/懸;命を懸ける/繋;(ひもでつなぐ)/闕;≒欠ける/舁;駕籠を舁く/畫;「画」の旧字/缺;「欠」の旧字/驅;旧字/
かi /買/書/描;絵を描く NB:「えがk」と同形/飼/画;線を画く/欠/掻/嗅/交/畫;「画」の旧字/缺;「欠」の旧字/支;ささえる/闕;≒欠ける/舁;駕籠を舁く/
かh /替/換/交/支/飼/代/買/變/
かg /嗅/
かe /変;(変化) 態度を変える/替;(取り替え) 部品を替える/代;(代用) あいさつに代える/換;(交換) 金に換える/買/飼/易/變;「変」の旧字/交/支;ささえる/
かc /勝/買/飼/交/支;ささえる/克;(overcome) 逆境に克つ/狩;(hunt)兎を狩る/刈;(crop)草を刈る/駆;(drive)車を駆る,衝動に駆られる/苅;「刈」の異体字/驅;「駆」の旧字/搗/
かb /黴;-びる/
おんよm /音読/
おんびk /音引/
おんなたらs /女誑/
おんなずk /女好/
おんなざかr /女盛/
おんなくさs /女臭/
おんなくさk /女臭/
おんなくさi /女臭/
おんなくさg /女臭/
おんなぎらi /女嫌/
おんなs /女/
おんなr /女/
おんなp /女/
おんなj /同;口語/
おんきs /恩着/
おんがえs /恩返/
おわらi /お笑/
おわたs /お渡/
おわすr /お忘/
おわかs /お若/
おわかr /お別/
おわかk /お若/
おわかi /お若/
おわかg /お若/
おわt /終/畢;(原義:鳥獣を獲る網)/
おわs /御座/在/
おわr /終/畢;(原義:鳥獣を獲る網)/終わ;※送り位置補正/
おわn /終/畢;(原義:鳥獣を獲る網)/
おわc /終/畢;(原義:鳥獣を獲る網)/
おろそk /疎/
おろおぼe /疎覚/
おろs /卸;(wholesale)商品を卸す,大根を卸す/下;NB:「くだs」と同形/
おろk /愚/
おれまがt /折れ曲/
おれまがr /折れ曲/
おれまがn /折れ曲/
おれまがc /折れ曲/
おれまg /折れ曲/
おれw /俺/
おれt /俺/
おれn /俺/
おれm /俺/
おれh /俺/
おれg /俺/
おりよk /折良/
おりめただs /折り目正/
おりまz /織り交/
おりまg /折り曲/
おりなs /織り成/
おりとt /折り取/折取/
おりとr /折り取/折取/
おりとn /折り取/折取/
おりとc /折り取/折取/
おりだs /織り出/
おりたたn /折り畳/折畳/
おりたたm /折り畳/折畳/
おりたt /降り立/下り立/
おりたc /降り立/下り立/
おりこn /折り込;チラシを折り込む/織り込;それはもう織り込み済みだ/折込/織込/
おりこm /折り込;チラシを折り込む/織り込;それはもう織り込み済みだ/折込/織込/
おりかさn /折り重/
おりかえs /折り返/折返/
おりいt /折り入/
おりいr /折り入/
おりいn /折り入/
おりいc /折り入/
おりあw /折り合/折合/
おりあu /折り合/折合/
おりあt /折り合/折合/
おりあs /折悪/
おりあo /折り合/折合/
おりあi /折り合/折合/
おりあe /折り合/折合/
おりあc /折り合/折合/
おりs /折/
およろこb /お慶/
およびがたs /及び難/
およびがたk /及び難/
およびがたi /及び難/
およびがたg /及び難/
およぎこn /泳ぎ込/
およぎこm /泳ぎ込/
およs /凡/お寄/
およr /お寄/
およn /及/
およm /御読/
およi /泳/游;<rare> (字義:水面をゆらゆらする)/
およg /泳/游;<rare> (字義:水面をゆらゆらする)/
およb /及/
おやゆずr /親譲/
おやすs /お安/
おやすm /お休/
おやすk /お安/
おやすi /お安/
おやm /お止/
おもんみz /惟/
おもんみy /惟/
おもんみt /惟/
おもんみs /惟/
おもんみr /惟/
おもんみn /惟/
おもんみm /惟/
おもんみc /惟/
おもんぱかt /慮/
おもんぱかr /慮/
おもんぱかn /慮/
おもんぱかc /慮/
おもんばかt /慮/
おもんばかr /慮/
おもんばかn /慮/
おもんばかc /慮/
おもわせぶr /思わせ振/
おももt /面持/
おもむきぶかs /趣深/
おもむきぶかk /趣深/
おもむきぶかi /趣深/
おもむきぶかg /趣深/
おもむk /赴;(go) 現場に赴く/趣;趣きがある/
おもむi /赴;(go) 現場に赴く/趣;趣きがある/
おもみづk /重み付/
おもはゆs /面映/
おもはゆk /面映/
おもはゆi /面映/
おもはゆg /面映/
おもはy /面映/
おもねt /阿/
おもねr /阿/
おもねn /阿/
おもねc /阿/
おもとm /お求/
おもてむk /表向/
おもてどおr /表通/
おもてだt /表立/
おもてだc /表立/
おもてがk /表書/
おもてあm /表編/
おもだt /主立/重立;=主立つ/
おもだc /重立;=主立つ/
おもすぎr /重過ぎ;※送り位置補正/
おもすg /重過/
おもしろおかs /面白可笑/
おもしろu /面白/
おもしろs /面白/
おもしろm /面白/
おもしろk /面白/
おもしろi /面白/
おもしろg /面白/
おもざs /面差/
おもぐるs /重苦/
おもくるs /重苦/
おもおもs /重々/重重/
おもいわずらw /思い煩/
おもいわずらu /思い煩/
おもいわずらt /思い煩/
おもいわずらo /思い煩/
おもいわずらi /思い煩/
おもいわずらe /思い煩/
おもいわずらc /思い煩/
おもいやt /思い遣/
おもいやr /思い遣/
おもいやn /思い遣/
おもいやc /思い遣/
おもいめぐr /思い巡/
おもいみだr /思い乱/
おもいのこs /思い残/
おもいなやn /思い悩/
おもいなやm /思い悩/
おもいなおs /思い直/
おもいなs /思い做/
おもいどおr /思い通/
おもいとどm /思い止/
おもいでぶかs /思い出深/想い出深/
おもいでぶかk /思い出深/想い出深/
おもいでぶかi /思い出深/想い出深/
おもいでぶかg /思い出深/想い出深/
おもいつづk /思い続/想い続/
おもいつm /思い詰/
おもいつk /思い付/
おもいつi /思い付/
おもいっきr /思いっ切/
おもいちがi /思い違/
おもいちがe /思い違/
おもいだs /思い出/
おもいたt /思い立/
おもいたc /思い立/
おもいすごs /思い過/
おもいすg /思い過/
おもいしt /思い知/
おもいしr /思い知/
おもいしn /思い知/
おもいしc /思い知/
おもいさだm /思い定/
おもいこn /思い込/
おもいこm /思い込/
おもいくらb /思い比/
おもいきt /思い切/
おもいきr /思い切/
おもいきn /思い切/
おもいきc /思い切/
おもいかえs /思い返/
おもいかn /思い兼/
おもいおよn /思い及/
おもいおよb /思い及/
おもいおもi /思い思/
おもいおk /思い起/
おもいえがk /思い描/
おもいえがi /思い描/
おもいうk /思い浮/
おもいいたt /思い至/
おもいいたr /思い至/
おもいいたn /思い至/
おもいいたc /思い至/
おもいいr /思い入/
おもいあまt /思い余/
おもいあまr /思い余/
おもいあまn /思い余/
おもいあまc /思い余/
おもいあt /思い当/
おもいあg /思い上/
おもy /重/
おもw /思/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/
おもu /思/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/重/
おもt /思/重/御持/お持/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/
おもs /重/
おもr /重/
おもo /思/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/
おもn /重/主/
おもm /重/
おもk /重/
おもi /思/重/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/
おもh /思/想/
おもg /重/
おもe /思/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/
おもd /重/
おもc /思/御持/お持/想;(字義:ある対象に向かいおもう)/念;(字義:心中で深くおもう)/憶;(字義:あれこれとおもう)/
おめざm /お目覚/
おめs /お召/
おめn /御目/
おむかe /お迎/
おみまi /御見舞/
おみのがs /お見逃/
おみとおs /御見通/お見通/
おみうk /お見受/
おみe /お見/
おまわr /お巡/
おまもr /御守/
おまちがi /お間違/
おまちがe /お間違/
おまかs /お任/
おまいr /御参/
おまt /お待/
おまk /御負/
おぼろs /朧/
おぼろn /朧/
おぼろg /朧/
おぼろd /朧/
おぼれじn /溺れ死/
おぼつかなs /覚束無/
おぼつかなk /覚束無/
おぼつかなi /覚束無/
おぼつかなg /覚束無/
おぼしめs /思し召/思召/
おぼえなおs /覚え直/
おぼえこn /覚え込/
おぼえこm /覚え込/
おぼy /覚/
おぼw /憶/
おぼt /覚/
おぼs /思/覚/
おぼr /溺/
おぼe /覚/憶;(特に、記憶) 年号を憶える/覺;「覚」の旧字/
おほm /お褒/
おほh /被/覆/
おぶw /負/
おぶu /負/
おぶt /負/
おぶo /負/
おぶi /負/
おぶe /負/
おぶc /負/
おびやk /脅/
おびただs /夥/
おびきよs /誘き寄/
おびきだs /誘き出/
おびk /誘;古語/
おびi /誘;古語/
おびe /怯/脅/
おひとよs /御人好/
おひさs /御久/お久/
おはらi /お祓/お払/
おはよu /お早/
おはなs /お話/
おのぼr /御上/
おののk /戦/
おののi /戦/
おのずかr /自/
おのずt /自/
おのずk /自/
おのおのn /各/
おのz /自/
おのr /己/
おのg /己;-が(じし)/
おねがi /お願/御願/
おねうt /お値打/
おにあi /お似合/
おなやm /お悩/
おながr /お流/
おなz /同/
おなk /お亡/お泣/
おなj /同/
おなi /同/
おどろきいt /驚き入/
おどろきいr /驚き入/
おどろきいn /驚き入/
おどろきいc /驚き入/
おどろk /驚/愕/駭/
おどろi /驚/愕/駭/
おどりでy /躍り出/
おどりでt /躍り出/
おどりでr /躍り出/
おどりでn /躍り出/
おどりでm /躍り出/
おどりだs /踊り出/
おどりこn /踊り込/
おどりこm /踊り込/
おどりくるw /踊り狂/
おどりくるu /踊り狂/
おどりくるt /踊り狂/
おどりくるo /踊り狂/
おどりくるi /踊り狂/
おどりくるe /踊り狂/
おどりくるc /踊り狂/
おどりかk /躍り掛/
おどりあk /踊り明/
おどしとt /脅し取/
おどしとr /脅し取/
おどしとn /脅し取/
おどしとc /脅し取/
おどt /踊;dance/踴;「踊」の異体字/躍;jump/
おどs /脅/威/縅;(鎧の札を綴る)/
おどr /踊;dance/躍;jump/踴;「踊」の異体字/
おどn /踊;dance/躍;jump/踴;「踊」の異体字/
おどk /脅/戯;-ける/嚇;字義:怒りを見せて恐れさせる/
おどc /踊;dance/躍;jump/踴;「踊」の異体字/
おとろe /衰/
おとりよs /お取り寄/お取寄/
おとりおk /お取り置/
おとなw /訪/
おとなu /訪/
おとなt /訪/
おとなs /大人/音無/
おとなp /大人/
おとなo /訪/
おとなi /訪/
おとなe /訪/
おとなc /訪/
おとどk /御届/お届/
おとだs /音出/
おとずr /訪/
おとしこn /落とし込/
おとしこm /落とし込/
おとしいr /陥/陷;「陥」の旧字(人名用漢字)/
おとしm /貶/
おとこざかr /男盛/
おとこくさs /男臭/
おとこくさk /男臭/
おとこくさi /男臭/
おとこくさg /男臭/
おとこr /男/
おとこp /男/
おとぎr /音切/
おとがm /お咎/
おとおs /お通/
おとあw /音合/
おとz /訪;非正則(おとずr)/
おとt /劣/
おとs /落/
おとr /劣/
おとn /劣/
おとm /お泊/
おとc /劣/
おでむかe /お出迎/
おてもt /お手持/
おてあw /お手合/
おてあg /お手上/御手上/
おつとm /お勤/
おつくr /お作;お作りします/お造;お造り(=刺身)/
おつきあi /お付き合/
おつかr /お疲/
おつかi /お使/
おつうj /お通/
おつs /乙/
おつn /乙/
おつg /御告/
おつd /乙/
おっぴろg /おっ広/
おっぱらw /追っ払/
おっぱらu /追っ払/
おっぱらt /追っ払/
おっぱらo /追っ払/
おっぱらi /追っ払/
おっぱらe /追っ払/
おっぱらc /追っ払/
おっぱじm /おっ始/
おっつk /追っ付/
おっちn /おっ死;‖ナ行五段(-ぬ)/
おったt /押っ立/追っ立/おっ立/
おったc /押っ立/おっ立/
おっしゃt /仰/仰有/
おっしゃr /仰/仰有/
おっしゃn /仰/仰有/
おっしゃi /仰/仰有/
おっしゃc /仰/仰有/
おっかぶs /押っ被/
おっかk /追っ掛/
おっt /追っ;※送り位置補正/
おちぶr /零落/落魄/
おちばたk /落葉焚/
おちのb /落ち延/
おちつきはらw /落ち着き払/
おちつきはらu /落ち着き払/
おちつきはらt /落ち着き払/
おちつきはらo /落ち着き払/
おちつきはらi /落ち着き払/
おちつきはらc /落ち着き払/
おちつk /落ち着/落着/
おちつi /落ち着/落着/
おちこn /落ち込/
おちこm /落ち込/
おちくぼn /落ち窪/
おちくぼm /落ち窪/
おちいt /陥/陷;「陥」の旧字(人名用漢字)/落ち入/落入/
おちいr /陥/落ち入/落入/陷;「陥」の旧字(人名用漢字)/
おちいn /陥/陷;「陥」の旧字(人名用漢字)/落ち入/落入/
おちいc /陥/陷;「陥」の旧字(人名用漢字)/落ち入/落入/
おちあw /落ち合/
おちあu /落ち合/
おちあt /落ち合/
おちあo /落ち合/
おちあi /落ち合/
おちあe /落ち合/
おちあc /落ち合/
おちr /落/堕ち;※送り位置補正/墜ち;※送り位置補正/落ち;※送り位置補正/
おちi /陥;非正則(おちいr)/
おだやk /穏/
おだy /穏/穩;旧字/
おだt /煽/
おだs /お出/
おためs /お試/
おたずn /お尋/
おたすk /お助/
おたけb /雄叫/
おたがi /御互/お互/
おたかs /御高/お高/
おたかk /お高/御高/
おたかi /御高/お高/
おたかg /御高/お高/
おたb /お食/
おぞまs /悍;ぞっとする/鈍;どんくさい/悍ま;※送り位置補正/
おぞけだt /怖気立/
おぞけだc /怖気立/
おぞm /悍;(hideous)「悍ましい事件」/鈍;<rare> dull/
おそろs /恐/
おそろi /お揃/
おそれおののk /恐れ戦/
おそれおののi /恐れ戦/
おそれおおs /畏れ多/恐れ多;NB:「畏れ多い」の方が本義を反映した用字/
おそれおおk /畏れ多/恐れ多;NB:「畏れ多い」の方が本義を反映した用字/
おそれおおi /畏れ多/恐れ多;NB:「畏れ多い」の方が本義を反映した用字/
おそれいt /恐れ入/
おそれいr /恐れ入/
おそれいn /恐れ入/
おそれいc /恐れ入/
おそれr /怐/
おそまk /遅蒔/
おそなe /お供/
おそすg /遅過/
おそざk /遅咲/
おそいこz /襲い来/
おそいこy /襲い来/
おそいこs /襲い来/
おそいこr /襲い来/
おそいこn /襲い来/
おそいこi /襲い来/
おそいくr /襲い来/
おそいくn /襲い来/
おそいきy /襲い来/
おそいきt /襲い来/
おそいきs /襲い来/
おそいきn /襲い来/
おそいきm /襲い来/
おそいきd /襲い来/
おそいきc /襲い来/
おそいかk /襲い掛/
おそw /教/襲/
おそu /襲/
おそt /襲/
おそs /遅/遲;旧字/
おそr /恐/怖;(こわがる)/畏;(敬いおそれる)/虞;(悪いことの起こる可能性) NB:送らぬ方が一般的/懼;びくびくする/惧;「懼」の異体字/
おそo /襲/
おそm /遅/遲;旧字/
おそk /遅/遲;旧字/
おそi /遅/襲/遲;旧字/
おそh /襲/
おそg /遅/遲;旧字/
おそe /襲/
おそc /襲/
おぜんだt /御膳立/
おせe /遅/
おすすm /お勧/
おすm /お住/
おじけづk /怖気付/
おじけづi /怖気付/
おじk /怖/
おしわk /押し分/
おしよs /押し寄/
おしやぶt /押し破/
おしやぶr /押し破/
おしやぶn /押し破/
おしやぶc /押し破/
おしやt /押し遣/
おしやr /押し遣/
おしやn /押し遣/
おしやc /押し遣/
おしもどs /押し戻/
おしみなs /惜しみ無/
おしみなk /惜しみ無/
おしみなi /惜しみ無/
おしまg /押し曲/
おしひろg /押し広/
おしひらk /押し開/
おしひらi /押し開/
おしひしi /押し拉/
おしひしg /押し拉/
おしはらi /お支払/
おしはかt /推し量/
おしはかr /推し量/
おしはかn /推し量/
おしはかc /推し量/
おしのk /押し退/
おしながs /押し流/
おしながk /お品書/
おしなb /押し並/
おしとどm /押し止/
おしとおs /押し通/
おしとm /押し止/
おしてしr /推して知/
おしつまt /押し詰/
おしつまr /押し詰/
おしつまn /押し詰/
おしつまc /押し詰/
おしつぶs /押し潰/圧し潰/
おしつつn /押し包/
おしつつm /押し包/
おしつk /押し付/
おしだまt /押し黙/
おしだまr /押し黙/
おしだまn /押し黙/
おしだまc /押し黙/
おしだs /押し出/
おしたおs /押し倒/
おしたt /押し立/
おしせまt /押し迫/
おしせまr /押し迫/
おしせまn /押し迫/
おしせまc /押し迫/
おしすすm /推し進/押し進/
おしさg /押し下/
おしころs /押し殺/圧し殺/
おしこn /押し込/押込/
おしこm /押し込/押込/
おしきt /押し切/
おしきs /御仕着/
おしきr /押し切/
おしきn /押し切/
おしきc /押し切/
おしかくs /押し隠/
おしかえs /押し返/
おしかr /お叱/
おしかk /押し掛/
おしえさとs /教え諭/
おしえこn /教え込/
おしえこm /教え込/
おしえあw /教え合/
おしえあu /教え合/
おしえあt /教え合/
おしえあo /教え合/
おしえあi /教え合/
おしえあe /教え合/
おしえあc /教え合/
おしうr /押し売/押売/
おしいだk /押し抱/
おしいだi /押し抱/
おしいt /押し入/
おしいr /押し入/
おしいn /押し入/
おしいc /押し入/
おしあわs /お幸/
おしあw /押し合/
おしあu /押し合/
おしあt /押し当/押し合/
おしあo /押し合/
おしあk /押し開/
おしあi /押し合/
おしあg /押し上/
おしあc /押し合/
おしr /御知/お知/
おしg /惜し;※送り位置補正/
おしe /教/
おさわg /お騒/
おさむs /御寒/お寒/
おさむk /御寒/お寒/
おさむi /御寒/お寒/
おさむg /御寒/お寒/
おさなs /幼/稚;NB:「いとけなi」「わかi」と同形/
おさなk /幼/稚;NB:「いとけなi」「わかi」と同形/
おさなi /幼/稚;NB:「いとけなi」「わかi」と同形/
おさなg /稚;NB:「いとけなi」「わかi」と同形/幼/
おさっs /御察/
おさそいあw /お誘い合/
おさえつk /押さえ付/抑え付/押え付/
おさえこn /押さえ込/抑え込/
おさえこm /押さえ込/抑え込/
おさえきt /抑え切/押さえ切/押え切/
おさえきr /抑え切/押さえ切/押え切/
おさえきn /抑え切/押さえ切/押え切/
おさえきc /抑え切/押さえ切/押え切/
おさn /幼/
おさm /収;騒ぎを-,成果を-/納;税を-/治;国を-/修;学業を-/收;「収」の旧字(人名用漢字)/
おさe /抑;(suppress) 怒りを抑える/押;(catch) 現場を押える/圧/壓;「圧」の旧字/
おごりたかb /驕り高/
おごそk /厳/嚴;「厳」の旧字(人名用漢字)/
おごt /奢;食事を奢る/驕;驕る平家/傲/
おごr /奢;食事を奢る/驕;驕る平家/傲/
おごn /奢;食事を奢る/驕;驕る平家/傲/
おごc /奢;食事を奢る/驕;驕る平家/傲/
おこりえz /起こり得/
おこりえy /起こり得/
おこりえt /起こり得/
おこりえs /起こり得/
おこりえr /起こり得/
おこりえn /起こり得/
おこりえm /起こり得/
おこりえc /起こり得/
おこりうr /起こり得/
おこりうb /起こり得/
おこぼr /お零/
おこのm /お好/
おこなw /行/行な;※送り位置補正/
おこなu /行/行な;※送り位置補正/
おこなt /行/
おこなo /行/
おこなi /行/行な;※送り位置補正/
おこなh /行/
おこなe /行/
おこなc /行/
おことわr /お断/
おこたt /怠/
おこたr /怠/
おこたn /怠/
おこたc /怠/
おこt /怒/起/興;(prosper)国が興る/
おこs /興;遺風を興す/起/熾;火を熾す/遣;=よこす/お越/起こ;※送り位置補正/
おこr /怒/興;(prosper)国が興る/起/
おこn /行/怒;[口] -んな/興;(prosper)国が興る/起/
おこg /烏滸;-がましい/痴/
おこc /怒/興;(prosper)国が興る/起/
おけr /於け;※送り位置補正/
おくりむかe /送り迎/
おくりなおs /送り直/
おくりとどk /送り届/
おくりつk /送り付/
おくりだs /送り出/
おくりたおs /送り倒/
おくりこn /送り込/
おくりこm /送り込/
おくりかえs /送り返/
おくゆかs /奥床;当て字/
おくゆk /奥行/
おくぶかs /奥深/
おくぶかk /奥深/
おくぶかi /奥深/
おくぶかg /奥深/
おくふかs /奥深/
おくふかk /奥深/
おくふかi /奥深/
おくふかg /奥深/
おくy /お悔/
おくt /送;(send)/贈;(present) 賞を贈る/
おくs /臆;臆病/奥;-さん/
おくr /送;(send)/贈;(present) 賞を贈る/遅/後;気後れ/遲;「遅」の旧字/
おくn /送;(send)/贈;(present) 賞を贈る/
おくc /送;(send)/贈;(present) 賞を贈る/
おぎなw /補/
おぎなu /補/
おぎなt /補/
おぎなo /補/
おぎなi /補/
おぎなe /補/
おぎなc /補/
おきわたs /沖渡/
おきわすr /置き忘/
おきびk /置き引/
おきぬk /起き抜/
おきにいr /お気に入/
おきなおt /起き直/
おきなおs /起き直/
おきなおr /起き直/
おきなおn /起き直/
おきなおc /起き直/
おきてやぶr /掟破/
おきづk /お気付/
おきだs /起き出/
おきたt /起き立/
おきたc /起き立/
おきざr /置き去/
おきがk /置き掛/
おきかえt /置き換え;※送り位置補正/
おきかえr /置き換え;※送り位置補正/
おきかw /置き換/置き変;?/置き代;?/
おきかe /置き換/置換/
おきあg /起き上/
おきm /お決/
おきk /御聞/お聞/
おがみたおs /拝み倒/
おがn /拝/拜;「拝」の旧字(人名用漢字)/
おがm /拝/拜;「拝」の旧字(人名用漢字)/
おかまi /お構/
おかぼr /岡惚/傍惚/
おかどちがi /御門違/お門違/
おかっぴk /岡っ引/
おかたi /お堅/
おかえs /御返/
おかえr /お帰/
おかいもとm /お買い求/
おかいあg /お買い上/
おかw /お変;お変わりありませんか/お代;ご飯お代わり/
おかs /犯;(violate)法を犯す/侵;(invade)権利を侵す/冒;(risk)危険を冒す/可笑;(当て字,funny)/奇/
おかk /お掛/お書/
おおわらi /大笑/
おおよろこb /大喜/
おおよs /凡/
おおもうk /大儲/
おおもr /大盛/
おおもi /お思/
おおむn /概/
おおみだs /大見出/
おおまわr /大回/
おおまちがi /大間違/
おおまk /大負/
おおまg /大曲/
おおぶr /大振;†「HR狙いの-」「-の器」/大降;†「-の雨」/
おおばんぶるまi /大盤振舞/大盤振る舞/
おおにぎw /大賑/
おおどおr /大通/
おおとのごもr /大殿籠;[文語]お眠り(になる)/
おおづm /大詰/
おおちがi /大違/
おおせつk /仰せ付/
おおすぎt /大過ぎ;※送り位置補正/
おおすg /多過/
おおしe /御教/お教/
おおさわg /大騒/
おおぐi /大食/
おおくr /御送/お送/
おおきすg /大き過/
おおがかr /大掛/
おおがk /大掛/
おおうりだs /大売出/
おおうつs /大写/
おおうk /大受/
おおいつくs /覆い尽/
おおいつk /覆い尽/
おおいそがs /大忙/
おおいそg /大急/
おおいかぶs /覆い被/
おおいかくs /覆い隠/
おおあばr /大暴/
おおあt /大当/
おおあr /大荒/
おおz /大/応;※仮名遣い「おう-ずる」/應;「応」の旧字(人名用漢字)/
おおw /覆/被/蔽/蓋/掩/奄;<rare>/
おおu /覆/被/蔽/蓋/掩/多;(ウ音便)/奄;<rare>/
おおt /覆/被/蔽/蓋/掩/奄;<rare>/
おおs /多/仰/雄々/夛;「多」の異体字/果;言い果せる/
おおr /大/多;-らか <rare>/
おおo /覆/被/蔽/蓋/掩/奄;<rare>/
おおm /多/大/夛;「多」の異体字/
おおk /大/多/夛;「多」の異体字/
おおj /応;※仮名遣い「おうじる」/應;「応」の旧字(人名用漢字)/
おおi /多/大/覆/夛;「多」の異体字/被/蔽/蓋/掩/奄;<rare>/
おおh /被/覆/
おおg /大/多/覆/夛;「多」の異体字/
おおe /覆/被/蔽/蓋/掩/奄;<rare>/
おおc /覆/被/蔽/蓋/掩/奄;<rare>/
おえらi /お偉/
おうぼしゃりまわr /応募者利回/
おうぼくだs /応募下/
おうばんぶるまi /椀飯振舞/椀飯振る舞/
おうこうs /横行/
おうかがi /お伺/
おうz /応/應;「応」の旧字(人名用漢字)/
おうr /お売/
おうj /応/應;「応」の旧字(人名用漢字)/
おいわi /お祝/
おいろなおs /御色直/
おいやt /追い遣/
おいやr /追い遣/
おいやn /追い遣/
おいやc /追い遣/
おいもとm /追い求/
おいまわs /追い回/追回/
おいはらw /追い払/
おいはらu /追い払/
おいはらt /追い払/
おいはらo /追い払/
おいはらi /追い払/
おいはらe /追い払/
おいはらc /追い払/
おいのr /お祈/
おいぬk /追い抜/
おいぬi /追い抜/
おいつづk /追い続/
おいつかw /追い使/
おいつかu /追い使/
おいつかt /追い使/
おいつかo /追い使/
おいつかi /追い使/
おいつかe /追い使/
おいつかc /追い使/
おいつm /追い詰/
おいつk /追い付/
おいつi /追い付/
おいちr /追い散/
おいだs /追い出/追出/
おいたt /生い立;-ち/追い立;-てる/
おいそがs /お忙/
おいすがt /追い縋/
おいすがr /追い縋/
おいすがn /追い縋/
おいすがc /追い縋/
おいしげt /生い茂/
おいしげr /生い茂/
おいしげn /生い茂/
おいしげc /生い茂/
おいこs /追い越/
おいこn /追い込/老い込/追込/
おいこm /追い込/老い込/追込/
おいかけまわs /追い掛け回/
おいかえs /追い返/
おいかr /お怒/
おいかk /追い掛/
おいおとs /追い落/
おいおt /追い落/
おいうt /追い討/追い打/追い撃/
おいあg /追い上/
おいt /於/
おいs /美味/
おいd /お出/
おあずk /お預/
おあi /御会/お会/
おz /怖/
おw /終/追/負/逐;(追放) 政権を逐う/
おu /追/負/生/逐;(追放) 政権を逐う/
おt /落/追/折/負/堕;†corrupt.「堕ちた生活」/墜;†go down.「飛行機が墜ちる」/織/居/墮;「堕」の旧字/逐;(追放) 政権を逐う/
おs /押/惜/推;(recommend) 新人を推す/圧;(圧力を加える) 指で圧す/捺;判子を捺す/壓;「圧」の旧字/
おr /降/下/折/織/居/堕;子供を-/
おp /追/
おo /追/逐;(追放) 政権を逐う/負/
おn /折/織/
おm /怖/追/
おk /起/置/於;於ける/追;追っかける/落;落っこちる/措;扨措く/擱;筆を擱く/大;-っきい/
おj /怖/
おi /追/負/老/置/於;於ける/生/措;「除外する」の意の時の「おく」/逐;(追放) 政権を逐う/
おh /負/追/生/
おe /終/負/追/逐;(追放) 政権を逐う/
おd /怖/
おc /落/堕/墜/追/負/逐;(追放) 政権を逐う/折/織/
おb /帯/帶;「帯」の旧字(人名用漢字)/
えんりょぶかs /遠慮深/
えんりょぶかk /遠慮深/
えんりょぶかi /遠慮深/
えんりょぶかg /遠慮深/
えんりょくだs /遠慮下/
えんむすb /縁結/
えんばらi /円払/
えんどおs /縁遠/
えんどおk /縁遠/
えんどおi /縁遠/
えんどおg /縁遠/
えんだt /円建/
えんじわk /演じ分/
えんじきt /演じ切/
えんじきr /演じ切/
えんじきn /演じ切/
えんじきc /演じ切/
えんきr /縁切/
えんz /演/
えんj /演/
えろs /エロ/
えろk /エロ/
えろi /エロ/
えろg /エロ/
えりわk /選り分/
えりぬk /選り抜/
えりぬi /選り抜/
えりごのm /選り好/
えりぐr /襟刳/
えらびぬk /選び抜/
えらびぬi /選び抜/
えらびとr /選び取/
えらびだs /選び出/
えらs /偉/
えらn /選/択;(字義:手に取ってえらぶ)/撰;(歌集を)-ぶ/
えらk /偉/
えらi /偉/
えらg /偉/
えらb /選/撰;(歌集を)-ぶ/択;(字義:手に取ってえらぶ)/偉;-ぶる/
えびぞt /海老反/
えびぞr /海老反/
えびぞn /海老反/
えびぞc /海老反/
えびがたm /海老固/
えとk /絵解/
えづk /餌付/
えつk /絵付/
えだわかr /枝分/
えだわk /枝分/
えだぶr /枝振/
えだがr /枝刈/
えだかr /枝刈/
えぐりだs /抉り出/
えぐt /抉/刔;<rare> =抉る/
えぐr /抉/刔;<rare> =抉る/
えぐn /抉/刔;<rare> =抉る/
えぐk /刳/
えぐi /刳/
えぐc /抉/刔;<rare> =抉る/
えきうr /駅売/
えきs /益/
えがたs /得難/
えがたk /得難/
えがたi /得難/
えがたg /得難/
えがきつづk /描き続/
えがきだs /描き出/
えがききt /描き切/
えがききr /描き切/
えがききn /描き切/
えがききc /描き切/
えがk /描/
えがi /描/
えかk /絵描/
えいz /映/詠/
えいr /絵入/
えいj /映/詠/
えz /得/獲;NB:「とr」と同形/
えy /得/獲;NB:「とr」と同形/
えt /得/獲;NB:「とr」と同形/選;NB:「よr」「すぐr」と同形/
えs /得/獲;NB:「とr」と同形/
えr /得/獲;NB:「とr」と同形/選;NB:「よr」「すぐr」と同形/
えn /得/笑/獲;NB:「とr」と同形/選;NB:「よr」「すぐr」と同形/
えm /笑/得/獲;NB:「とr」と同形/
えk /得/獲;NB:「とr」と同形/
えc /得/獲;NB:「とr」と同形/選;NB:「よr」「すぐr」と同形/
うんわるs /運悪/
うんわるk /運悪/
うんわるi /運悪/
うんわるg /運悪/
うんよk /運良/
うんめいづk /運命付/
うんだめs /運試/
うわむk /上向/
うわむi /上向/
うわまわt /上回/
うわまわr /上回/
うわまわn /上回/
うわまわc /上回/
うわばk /上履/
うわのs /上乗/
うわのr /上乗/
うわぬr /上塗/
うわてひねr /上手捻/
うわてなg /上手投/
うわてだしなg /上手出し投/
うわづm /上積/
うわずt /上擦/
うわずr /上擦/
うわずn /上擦/
うわずm /上澄/
うわずc /上擦/
うわすべr /上滑/
うわさどおr /噂通/
うわさs /噂/
うわがk /上書/
うわかk /上書;?/
うわz /上/
うわt /浮/
うわm /上/
うろたe /狼狽/
うろおぼe /うろ覚/空覚/疎覚/
うれゆk /売行/
うれのこt /売れ残/
うれのこr /売れ残/
うれのこn /売れ残/
うれのこc /売れ残/
うれしがなs /嬉し悲/
うれえr /慯/
うれu /憂/愁/患;NB:「わずらu」と同形/
うれs /嬉/
うれi /憂;(worry)/愁;(sorrow)/患;NB:「わずらi」と同形/
うれe /憂/愁/患;NB:「わずらu」と同形/
うるわs /麗/美/愛/
うるさs /煩/五月蝿/騒/
うるさk /煩/五月蝿/騒/
うるさi /煩/五月蝿/騒/
うるさg /煩/五月蝿/騒/
うるおw /潤/
うるおu /潤/
うるおt /潤/
うるおs /潤/
うるおo /潤/
うるおi /潤/
うるおe /潤/
うるおc /潤/
うるn /潤/
うるm /潤/
うりわたs /売り渡/売渡/
うりはらw /売り払/
うりはらu /売り払/
うりはらt /売り払/
うりはらo /売り払/
うりはらi /売り払/
うりはらe /売り払/
うりはらc /売り払/
うりぬk /売り抜/
うりとb /売り飛/
うりつづk /売り続/
うりつくs /売り尽/
うりつk /売り付/
うりだs /売り出/売出/
うりしぶt /売り渋/
うりしぶr /売り渋/
うりしぶn /売り渋/
うりしぶc /売り渋/
うりさばk /売り捌/
うりさばi /売り捌/
うりこs /売り越/
うりこn /売り込/
うりこm /売り込/
うりきt /売り切/
うりきr /売り切/
うりきn /売り切/
うりきc /売り切/
うりかi /売り買/
うりおs /売り惜/売惜/
うりいそi /売り急/
うりいそg /売り急/
うりあるk /売り歩/
うりあるi /売り歩/
うりあg /売り上/売上/
うりあb /売り浴/
うらわかs /うら若/
うらわかk /うら若/
うらわかi /うら若/
うらわかg /うら若/
うらやまs /羨/
うらやn /羨/
うらやm /羨/
うらなw /占/卜/
うらなu /占/卜/
うらなt /占/卜/
うらなo /占/卜/
うらなk /心泣/
うらなi /占/卜/
うらなg /裏投/
うらなe /占/卜/
うらなc /占/卜/
うらどおr /裏通/
うらどr /裏取/
うらづk /裏付/
うらさびs /心淋/心寂/
うらごs /裏漉/
うらぎt /裏切/
うらぎr /裏切/
うらぎn /裏切/
うらぎc /裏切/
うらがなs /心悲/
うらがえt /裏返;声が-/
うらがえs /裏返/
うらがえr /裏返;声が-/
うらがえn /裏返;声が-/
うらがえc /裏返;声が-/
うらがk /裏書/
うらかえs /裏返/
うらうt /裏打/
うらうc /裏打/
うらあm /裏編/
うらr /麗/
うらn /恨;(字義:心に傷を残す)/怨;(字義:押さえ付けられ鬱屈する)/憾;(遺憾・残念)「繁雑になる憾みがある」/
うらm /恨;(字義:心に傷を残す)/怨;(字義:押さえ付けられ鬱屈する)/憾;(遺憾・残念)「繁雑になる憾みがある」/
うらd /裏/
うやまw /敬/
うやまu /敬/
うやまt /敬/
うやまo /敬/
うやまi /敬/
うやまe /敬/
うやまc /敬/
うやうやs /恭/
うめもどs /埋め戻/
うめつくs /埋め尽/
うめつk /埋め尽/
うめたt /埋め立/
うめこn /埋め込/埋込/
うめこm /埋め込/埋込/
うめあわs /埋め合/
うめあw /埋め合/
うめk /呻/
うめi /呻/
うみわk /産み分/
うみづr /海釣/
うみつk /産み付/
うみだs /生み出/産み出/
うみそだt /産み育/
うみおとs /産み落/生み落/
うみおt /産み落/生み落/
うまれもt /生まれ持/
うまれつk /生まれ付/
うまれつi /生まれ付/
うまれそだt /生まれ育/生れ育/
うまれかわt /生れ変/
うまれかわr /生れ変/
うまれかわn /生れ変/
うまれかわc /生れ変/
うまれかw /生まれ変/
うまれおt /生まれ落/
うまれおc /生まれ落/
うまれあわs /生まれ合/
うまれあw /生まれ合/
うまのr /馬乗/
うまs /旨;(字義:こってりとしたうまみ)/巧;(字義:手の込んだ細工)/美味/上手/美;美し国/甘;NB:「あまi」と同形/
うまr /生/
うまm /旨;(字義:こってりとしたうまみ)/美味/甘;NB:「あまi」と同形/美/
うまk /上手/旨;(字義:こってりとしたうまみ)/巧;(字義:手の込んだ細工)/美味/甘;NB:「あまi」と同形/美/
うまi /上手/旨;(字義:こってりとしたうまみ)/美味/巧;(字義:手の込んだ細工)/甘;NB:「あまi」と同形/美/
うまg /上手/旨;(字義:こってりとしたうまみ)/美味/巧;(字義:手の込んだ細工)/甘;NB:「あまi」と同形/美/
うべなw /諾/
うべなu /諾/
うべなt /諾/
うべなo /諾/
うべなi /諾/
うべなe /諾/
うべなc /諾/
うぶs /初/
うぶn /初/
うぶd /初/
うばいとt /奪い取/
うばいとr /奪い取/
うばいとn /奪い取/
うばいとc /奪い取/
うばいつk /奪い尽/
うばいさt /奪い去/
うばいさr /奪い去/
うばいさn /奪い去/
うばいさc /奪い去/
うばいかえs /奪い返/
うばいあw /奪い合/
うばいあu /奪い合/
うばいあt /奪い合/
うばいあo /奪い合/
うばいあi /奪い合/
うばいあe /奪い合/
うばいあc /奪い合/
うばw /奪/
うばu /奪/
うばt /奪/
うばo /奪/
うばi /奪/
うばe /奪/
うばc /奪/
うのm /鵜呑/鵜飲;?/
うぬぼr /自惚/己惚/
うなだr /項垂/
うなずきかえs /頷き返/
うなずきあw /頷き合/
うなずきあu /頷き合/
うなずきあt /頷き合/
うなずきあo /頷き合/
うなずきあi /頷き合/
うなずきあe /頷き合/
うなずきあc /頷き合/
うなずk /頷/
うなずi /頷/
うながs /促/
うなt /唸/
うなs /魘/
うなr /唸/
うなn /唸/
うなc /唸/
うとs /疎/踈;異体字/
うとn /疎/
うとm /疎/
うとk /疎/踈;異体字/
うとi /疎/踈;異体字/
うとg /疎/踈;異体字/
うでだめs /腕試/
うでたてふs /腕立て伏/
うでぐm /腕組/
うできk /腕利/
うでがたm /腕固/
うでおs /腕押/
うつりゆk /移り行/
うつりこn /写り込;写真に写り込む/映り込;画面に映り込む/
うつりこm /映り込;画面に映り込む/写り込;写真に写り込む/
うつりかわt /移り変/
うつりかわr /移り変/
うつりかわn /移り変/
うつりかわc /移り変/
うつりかw /移り変/
うつむk /俯/
うつむi /俯/
うつぶs /俯/うつ伏/
うつしとt /写し取/
うつしとr /写し取/
うつしとn /写し取/
うつしとc /写し取/
うつしだs /映し出/写し出/
うつしこn /写し込/
うつしこm /写し込/
うつくs /美/
うつt /移/写;写真に写る/映;鏡に映る/遷;都が遷る/冩;「写」の旧字1/寫;「写」の旧字2/暎;「映」の異体字/伝染;(当て字) 風邪が伝染る/
うつs /移/写;(本|写真)を写す/映;鏡に映す/寫;「写」の旧字1/冩;「写」の旧字2/暎;「映」の異体字/鬱/
うつr /移/映;鏡に映る/写;写真に写る/虚;-ろ (名詞)/空;≒虚ろ/伝染;(当て字) 風邪が伝染る/遷;都が遷る/寫;「写」の旧字1/冩;「写」の旧字2/暎;「映」の異体字/
うつn /移/映;鏡に映る/写;写真に写る/伝染;(当て字) 風邪が伝染る/遷;都が遷る/寫;「写」の旧字1/冩;「写」の旧字2/暎;「映」の異体字/鬱/
うつk /虚;-け/空;-け(者)/
うつd /鬱/
うつc /移/映;鏡に映る/写;写真に写る/伝染;(当て字) 風邪が伝染る/遷;都が遷る/寫;「写」の旧字1/冩;「写」の旧字2/暎;「映」の異体字/
うっとうs /鬱陶/欝陶;「鬱」異体字/
うってでz /打って出/
うってでy /打って出/
うってでt /打って出/
うってでs /打って出/
うってでr /打って出/
うってでn /打って出/
うってでm /打って出/
うってでk /打って出/
うってでc /打って出/
うってかわt /打って変/
うってかわr /打って変/
うってかわn /打って変/
うってかわc /打って変/
うっちゃt /打っ棄/打っ遣/
うっちゃr /打っ棄/打っ遣/
うっちゃn /打っ棄/打っ遣/
うっちゃc /打っ棄/打っ遣/
うったえかk /訴え掛/
うったe /訴/
うっすr /薄/
うちわもm /内輪揉/
うちわたs /内渡/
うちよs /打ち寄/
うちやぶt /打ち破/討ち破/
うちやぶr /打ち破/討ち破/
うちやぶn /打ち破/討ち破/
うちやぶc /打ち破/討ち破/
うちもr /討ち漏/
うちまわr /内回/
うちまちがi /打ち間違/
うちまちがe /打ち間違/
うちまk /打ち負/
うちほろb /討ち滅/
うちふt /打ち振/
うちふr /打ち振/
うちふn /打ち振/
うちふc /打ち振/
うちひしi /打ち拉/
うちひしg /打ち拉/
うちはらw /打ち払/
うちはらu /打ち払/
うちはらt /打ち払/
うちはらo /打ち払/
うちはらi /打ち払/
うちはらe /打ち払/
うちはらc /打ち払/
うちはなs /打ち放/
うちはたs /討ち果/
うちはt /討ち果/
うちぬk /打ち抜/撃ち抜/打抜/
うちぬi /打ち抜/撃ち抜/打抜/
うちながm /打ち眺/
うちなおs /打ち直/
うちなr /打ち鳴/
うちどm /打ち止/打止/
うちとおs /打ち通/
うちとt /打ち取/討ち取/
うちとr /打ち取/討ち取/
うちとn /打ち取/討ち取/
うちとk /打ち解/
うちとc /打ち取/討ち取/
うちつづk /打ち続/
うちつk /打ち付/
うちっぱなs /打ちっ放;-しのコンクリ壁/
うちだs /打ち出/
うちたおs /打ち倒/
うちたt /打ち立/
うちそんj /打ち損/
うちすt /打ち捨/
うちじn /討ち死/
うちさわi /打ち騒/
うちさわg /打ち騒/
うちこわs /打ち壊/
うちころs /打ち殺/
うちこn /打ち込/撃ち込;銃弾を-む/打込/
うちこm /打ち込/撃ち込;銃弾を-む/打込/
うちけs /打ち消/打消/
うちくだk /打ち砕/
うちくだi /打ち砕/
うちくずs /打ち崩/
うちきょうz /打ち興/
うちきょうj /打ち興/
うちきt /打ち切/打切/
うちきr /打ち切/打切/
うちきn /打ち切/打切/
うちきc /打ち切/打切/
うちがk /内掛/
うちかえs /打ち返/
うちかt /打ち勝/打ち克/
うちかr /打ち枯/
うちかk /打ち掛/打掛/打ち欠/
うちかi /打ち欠/
うちかc /打ち勝/打ち克/
うちおとs /打ち落/撃ち落/
うちおt /打ち落/撃ち落/
うちおr /打ち下/
うちいt /討ち入/
うちいr /討ち入/
うちいn /討ち入/
うちいc /討ち入/
うちあわs /打合/打ち合/
うちあw /打ち合/打合/撃ち合/
うちあu /打ち合/撃ち合/
うちあt /打ち合/撃ち合/
うちあo /打ち合/撃ち合/
うちあk /打ち明/
うちあi /撃ち合/打ち合/
うちあg /打ち上/打上/
うちあe /打ち合/撃ち合/
うちあc /打ち合/撃ち合/
うたれづよs /打たれ強/
うたれづよk /打たれ強/
うたれづよi /打たれ強/
うたれづよg /打たれ強/
うたぐりぶかs /疑り深/
うたぐりぶかk /疑り深/
うたぐりぶかi /疑り深/
うたぐりぶかg /疑り深/
うたぐt /疑/
うたぐr /疑/
うたぐn /疑/
うたぐc /疑/
うたがいなs /疑い無/
うたがいなk /疑い無/
うたがいなi /疑い無/
うたがw /疑/
うたがu /疑/
うたがt /疑/
うたがo /疑/
うたがi /疑/
うたがe /疑/
うたがc /疑/
うたいはじm /歌い始/
うたいつづk /歌い続/
うたいだs /歌い出/
うたいあk /歌い明/
うたいあg /歌い上/謳い上/
うたw /歌/唄;(気軽にうたう)/謳;(主張する) 高性能を謳う/謡;(無伴奏でうたう)/唱;(はっきりとうたう)/謠;「謡」の旧字(人名用漢字)/謌;「歌」の異体字/詠;和歌を詠う/
うたu /歌/唄;(気軽にうたう)/謳;(主張する) 高性能を謳う/詠;和歌を詠う/唱;(はっきりとうたう)/謡;(無伴奏でうたう)/謠;「謡」の旧字(人名用漢字)/謌;「歌」の異体字/
うたt /歌/唄;(気軽にうたう)/謳;(主張する) 高性能を謳う/謡;(無伴奏でうたう)/唱;(はっきりとうたう)/謌;「歌」の異体字/詠/謠;「謡」の旧字(人名用漢字)/
うたo /歌/唄;(気軽にうたう)/謳;(主張する) 高性能を謳う/謡;(無伴奏でうたう)/唱;(はっきりとうたう)/謠;「謡」の旧字(人名用漢字)/謌;「歌」の異体字/詠;和歌を詠う/
うたi /歌/謳;(主張する) 高性能を謳う/唄;(気軽にうたう)/謡;(無伴奏でうたう)/謌;「歌」の異体字/唱;(はっきりとうたう)/謠;「謡」の旧字(人名用漢字)/詠;和歌を詠う/
うたe /歌/唄;(気軽にうたう)/謡;(無伴奏でうたう)/謌;「歌」の異体字/唱;(はっきりとうたう)/謳;(主張する) 高性能を謳う/謠;「謡」の旧字(人名用漢字)/詠;和歌を詠う/
うたc /歌/唄;(気軽にうたう)/謳;(主張する) 高性能を謳う/唱;(はっきりとうたう)/謡;(無伴奏でうたう)/謠;「謡」の旧字(人名用漢字)/謌;「歌」の異体字/詠;和歌を詠う/
うそぶk /嘯/
うそぶi /嘯/
うそくさs /嘘臭/
うそくさk /嘘臭/
うそくさi /嘘臭/
うそくさg /嘘臭/
うせつまt /右折待/
うせつまc /右折待/
うずまk /渦巻/
うずまi /渦巻/
うずたかs /堆/
うずたかk /堆/
うずたかi /堆/
うずたかg /堆/
うずくまt /蹲/踞/
うずくまr /蹲/踞/
うずくまn /蹲/踞/
うずくまc /蹲/踞/
うずくm /蹲/
うずm /埋;NB:「うm」と同形/
うずk /疼/
うずi /疼/
うすわらi /薄笑/
うすらさむs /薄ら寒/
うすらさむk /薄ら寒/
うすらさむi /薄ら寒/
うすらさむg /薄ら寒/
うすよごr /薄汚/
うすすg /薄過/
うすぐらs /薄暗/
うすぐらk /薄暗/
うすぐらi /薄暗/
うすぐらg /薄暗/
うすくらg /薄暗/
うすぎたなs /薄汚/
うすぎたなk /薄汚/
うすぎたなi /薄汚/
うすぎたなg /薄汚/
うすぎr /薄切/
うすきみわるs /薄気味悪/
うすきみわるk /薄気味悪/
うすきみわるi /薄気味悪/
うすきみわるg /薄気味悪/
うすあきなi /薄商/
うすあおs /薄青/
うすあおm /薄青/
うすあおk /薄青/
うすあおi /薄青/
うすあおg /薄青/
うすs /薄/
うすr /薄/
うすp /薄/
うすm /薄/
うすk /薄/
うすi /薄/
うすg /薄/
うしろむk /後ろ向/後向/
うしろづk /後ろ付/
うしろぐらs /後ろ暗/
うしろぐらk /後ろ暗/
うしろぐらi /後ろ暗/
うしろぐらg /後ろ暗/
うしみt /丑三/
うしなw /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしなu /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしなt /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしなo /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしなi /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしなe /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしなc /失/喪;(字義:人の死を悼んで泣く)「父を喪う」/
うしおi /牛追/
うしr /後/
うしn /失;非正則(うしなu)/
うざs /ウザ/
うざk /ウザ/
うざi /ウザ/
うざg /ウザ/
うさんくさs /胡散臭/
うさんくさk /胡散臭/
うさんくさi /胡散臭/
うさんくさg /胡散臭/
うごめk /蠢/蠕;<rare> ≒蠢く/
うごめi /蠢/蠕;<rare> ≒蠢く/
うごきまわt /動き回/
うごきまわr /動き回/
うごきまわn /動き回/
うごきまわc /動き回/
うごきはじm /動き始/
うごきだs /動き出/
うごk /動/
うごi /動/
うけわたs /受け渡/受渡/
うけもどs /受け戻/
うけもt /受け持/受持/
うけもc /受け持/
うけながs /受け流/
うけとt /受け取/受取/
うけとr /受け取/受取/
うけとn /受け取/受取/
うけとm /受け止/
うけとc /受け取/受取/
うけつk /受け付/受付/
うけつi /受け継/受継/
うけつg /受け継/受継/
うけたまわt /承/
うけたまわr /承/
うけたまわn /承/
うけたまわc /承/
うけたまw /受け賜;NB:語源に忠実な表記。通常は「承る」/
うけこたe /受け答/
うけがw /肯/
うけがu /肯/
うけがt /肯/
うけがo /肯/
うけがi /肯/
うけがe /肯/
うけがc /肯/
うけおw /請け負/請負/
うけおu /請け負/請負/
うけおt /請け負/請負/
うけおo /請け負/請負/
うけおi /請け負/請負/
うけおe /請け負/請負/
うけおc /請け負/請負/
うけうr /受け売/受売/請け売/請売/
うけいr /受け入/受入/受け容/
うけあw /請け合/受け合/
うけあu /請け合/受け合/
うけあt /請け合/受け合/
うけあo /請け合/受け合/
うけあi /請け合/請合/受け合/
うけあe /請け合/受け合/
うけあc /請け合/受け合/
うきぼr /浮き彫/
うきでz /浮き出/
うきでy /浮き出/
うきでt /浮き出/
うきでs /浮き出/
うきでr /浮き出/
うきでn /浮き出/
うきでm /浮き出/
うきでk /浮き出/
うきでc /浮き出/
うきだs /浮き出/
うきたt /浮き立/
うきたc /浮き立/
うきしずm /浮き沈/
うきがs /浮貸/
うきうk /浮き浮/
うきあしだt /浮き足立/浮足立/
うきあしだc /浮き足立/浮足立/
うきあg /浮き上/
うがちすg /穿ち過/
うがいs /嗽/
うがt /穿/鑿/
うがc /穿/鑿/
うかれさわi /浮かれ騒/
うかれさわg /浮かれ騒/
うかびでy /浮かび出/
うかびでt /浮かび出/
うかびでs /浮かび出/
うかびでr /浮かび出/
うかびでn /浮かび出/
うかびでm /浮かび出/
うかびあg /浮かび上/
うかがいしt /窺い知/
うかがいしr /窺い知/
うかがいしn /窺い知/
うかがいしc /窺い知/
うかがw /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかがu /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかがt /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかがo /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかがi /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかがe /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかがc /伺;用件を伺う/窺;様子を窺う (字義:のぞいて見る)/覘;(字義:じっと見る)/
うかt /合格;当て字/
うかr /合格;当て字/浮か;※送り位置補正/
うかn /浮/合格;当て字/
うかc /合格;当て字/
うかb /浮/
うおつr /魚釣/
うえよs /上寄/
うえつk /植え付/上付/植付/
うえこn /植え込/植込/
うえこm /植え込/植込/
うえd /上/
ういろううr /外郎売/
ういういs /初々/
うz /埋/
うw /植/
うt /打/撃;(fire) 銃を撃つ/討;(kill) 仇を討つ/売/射;≒撃つ/撲;(punch) 頬を撲つ/搏;脈搏つ/攵/攴/賣;「売」の旧字(人名用漢字)/
うs /失/憂/
うr /売/熟/得/賣;「売」の旧字(人名用漢字)/
うn /生/産;子供を産む/膿;傷が膿む/売/賣;「売」の旧字(人名用漢字)/倦;人生に倦む/績/
うm /埋/生/産;子供を産む/倦;人生に倦む/膿;傷が膿む/績/
うk /受/浮/請;請け負う/憂/承;伝統を承ける/享;生を享ける/泛;≒浮/
うi /浮/憂/泛;≒浮/
うg /憂/
うe /植/飢/
うd /茹/
うc /打/討;(kill) 仇を討つ/撃;(fire) 銃を撃つ/売/射;≒撃つ/撲;(punch) 頬を撲つ/搏;脈搏つ/攵/攴/賣;「売」の旧字(人名用漢字)/
うb /得/
いんしょうぶかs /印象深/
いんしょうぶかk /印象深/
いんしょうぶかi /印象深/
いんしょうぶかg /印象深/
いんしょうづk /印象付/
いんきくさs /陰気臭/
いんきくさk /陰気臭/
いんきくさi /陰気臭/
いんきくさg /陰気臭/
いんs /因/飲/淫/
いんn /陰/
いわばしr /石走;滝、垂水、近江にかかる枕詞。「-る垂水の上のさわらびの」/
いわw /祝/
いわu /祝/
いわt /祝/
いわr /謂/
いわo /祝/
いわk /曰/
いわi /祝/
いわe /祝/
いわc /祝/
いわb /言わ;※送り位置補正/
いろわk /色分/
いろよi /色好/
いろめきたt /色めき立/
いろめきたc /色めき立/
いろどt /彩/
いろどr /彩/色取/
いろどn /彩/
いろどc /彩/
いろづかi /色使/
いろづk /色付/
いろづi /色付/
いろちがi /色違/
いろだs /色出/
いろこs /色濃/
いろこk /色濃/
いろこi /色濃/
いろけづk /色気付/
いろけづi /色気付/
いろおt /色落/
いろあわs /色合/
いろあw /色合/
いろあs /色褪/
いろあi /色合/
いろp /色/
いろn /色/
いろm /色;色めく/
いれわすr /入れ忘/
いれまz /入れ混/
いれなおs /入れ直/
いれちがw /入れ違/
いれちがu /入れ違/
いれちがt /入れ違/
いれちがo /入れ違/
いれちがi /入れ違/
いれちがc /入れ違/
いれたt /入れ立/
いれこn /入れ込/
いれこm /入れ込/
いれぐi /入れ食/
いれかw /入れ替/入れ換/
いれかe /入れ替/入れ換/
いれあg /入れ揚/
いりみだr /入り乱/
いりまj /入り交/
いりびたt /入り浸/
いりびたr /入り浸/
いりびたn /入り浸/
いりびたc /入り浸/
いりつk /煎り付/炒り付/
いりたt /入り立/
いりたc /入り立/
いりこn /入り込/
いりこm /入り込/
いりくn /入り組/
いりくm /入り組/
いらだt /苛立/
いらだc /苛立/
いらいらしi /苛苛し;※送り位置補正/
いらw /弄/苛/綺/
いらu /弄/苛/綺/
いらt /苛/弄/綺/
いらs /貸;古語/
いらo /弄/苛/綺/
いらi /弄/苛/綺/
いらh /苛/弄/
いらe /応/答/弄/苛/綺/
いらd /苛/
いらc /弄/苛/綺/
いやまs /弥増/いや増/
いやしくm /苟/
いやしm /卑し;※送り位置補正/
いやおうなs /否応無/
いやおうなk /否応無/
いやおうなi /否応無/
いやs /癒/卑/賤;<esp.身分が低い>/医;(字義:「癒」はなおること、「医」はなおすこと)/嫌/厭/
いやr /嫌/
いやn /嫌/厭/
いやm /厭/
いやg /嫌/
いやd /嫌/厭/
いもほr /芋掘/藷掘/
いもはg /芋接/
いもつg /芋継/
いもざs /芋刺/
いみぶかs /意味深/
いみぶかk /意味深/
いみぶかi /意味深/
いみぶかg /意味深/
いみづk /意味付/
いみきらw /忌み嫌/
いみきらu /忌み嫌/
いみきらt /忌み嫌/
いみきらo /忌み嫌/
いみきらi /忌み嫌/
いみきらe /忌み嫌/
いみきらc /忌み嫌/
いみあi /意味合/
いみs /意味/
いまわs /忌/
いまひとt /今一/
いましばらk /今暫/
いましm /戒/縛;ロープで縛る/誡;(≒戒) 注意を与える/警;警戒・用心する/
いまいまs /忌々/
いまy /今/
いまs /今/在/坐;≒在す/
いまn /今/
いまd /未/
いぶりだs /燻り出/
いぶかt /訝/
いぶかs /訝/
いぶかr /訝/
いぶかn /訝/
いぶかc /訝/
いぶt /燻/
いぶs /燻/
いぶr /燻/
いぶn /燻/
いぶk /息吹/気吹;=息吹き/
いぶi /息吹/気吹;=息吹き/
いぶc /燻/
いびつs /歪/
いびつn /歪/
いびつd /歪/
いばt /威張/
いばr /威張/
いばn /威張/
いばc /威張/
いのちもe /命燃/
いのちびろi /命拾/
いのちとr /命取/
いのちごi /命乞/
いのちがk /命懸/
いのこt /居残/
いのこr /居残/
いのこn /居残/
いのこc /居残/
いのt /祈/
いのr /祈/
いのn /祈/
いのc /祈/
いねむr /居眠/
いねかr /稲刈/
いぬじn /犬死/
いぬk /居抜;居抜き物件/射貫;矢で射貫く/
いぬi /居抜;居抜き物件/射貫;矢で射貫く/
いならn /居並/
いならb /居並/
いななk /嘶/
いななi /嘶/
いなかじm /田舎染/
いなかくさs /田舎臭/
いなかくさk /田舎臭/
いなかくさi /田舎臭/
いなかくさg /田舎臭/
いなおt /居直/
いなおr /居直/
いなおn /居直/
いなおc /居直/
いなy /否/
いなn /否/
いなm /否/
いなk /否/
いどn /挑/
いどm /挑/
いとなn /営/營;旧字/
いとなm /営/營;旧字/
いとけなs /稚/幼/
いとけなk /稚/幼/
いとけなi /稚/幼/
いとけなg /稚/幼/
いとw /厭/
いとu /厭/
いとt /厭/
いとs /愛/
いとo /愛/厭/
いとm /射止/
いとk /幼/
いとi /厭/
いとe /厭/
いとc /厭/
いでたt /出で立/
いてつk /凍て付/凍てつ;※送り位置補正/
いてつi /凍て付/
いづらs /居辛/
いづらk /居辛/
いづらi /居辛/
いづらg /居辛/
いつわt /偽/僞;「偽」の旧字(人名用漢字)/
いつわr /偽/僞;「偽」の旧字(人名用漢字)/
いつわn /偽/僞;「偽」の旧字(人名用漢字)/
いつわc /偽/僞;「偽」の旧字(人名用漢字)/
いつのまn /何時の間;-に/
いつづk /居続/
いつくしn /慈/
いつくしm /慈/
いつくs /慈/
いつz /何時/
いつt /五/
いつm /何時/
いつk /居着/何時/
いつi /居着/
いっぽんだt /一本立/
いっぱんn /一般/
いってんばr /一点張/
いってこz /行って来/
いってこy /行って来/
いってこs /行って来/
いってこr /行って来/
いってこn /行って来/
いってこi /行って来/
いってくr /行って来/
いってくn /行って来/
いってきy /行って来/
いってきt /行って来/
いってきs /行って来/
いってきn /行って来/
いってきm /行って来/
いってきk /言って聞/
いってきd /行って来/
いってきc /行って来/
いっそうs /一掃/
いっせいn /一斉/
いっしょn /一緒/
いっしむくi /一矢報/
いっこだt /一戸建/
いっきよm /一気読/
いっきn /一気/
いっかつs /一括/
いっs /逸/
いちりんざs /一輪挿/
いちやづk /一夜漬/
いちもんなs /一文無/
いちもくおk /一目置/
いちもくおi /一目置/
いちはやs /逸速;(文語) -し/逸早;(文語) -し/いち速/いち早/一早/一速/
いちはやk /一早/逸早/逸速/いち速/いち早/一速/
いちはやi /いち速/いち早/一早/逸早/一速/逸速/
いちとr /位置取/
いちづk /位置付/
いちずk /位置付;※仮名遣い「いちづk」/
いちじるs /著/
いちぎm /位置決/
いちがいn /一概/
いちおs /一押/
いちs /位置/
いだk /抱/懐;恋慕の情を-く/
いだi /抱/懐;恋慕の情を-く/
いたわt /労/
いたわs /労;そいつはお-しい/
いたわr /労/
いたわn /労/
いたわc /労/
いためつk /痛め付/
いたみどm /痛み止/
いたみいt /痛み入/
いたみいr /痛み入/
いたみいn /痛み入/
いたみいc /痛み入/
いたぶt /甚振/
いたぶr /甚振/
いたぶn /甚振/
いたぶc /甚振/
いたばさm /板挟/
いただk /頂/戴/
いただi /頂/戴/
いたずらn /徒;vain.「徒な出費」/
いたすg /痛過/
いたしかゆs /痛し痒/
いたがゆs /痛痒/
いたがゆk /痛痒/
いたがゆi /痛痒/
いたがゆg /痛痒/
いたいたs /痛々/
いたw /労/
いたt /至/到;≒至る/致;<rare>/
いたs /致/痛/イタ/
いたr /至/到;≒至る/致;<rare>/
いたn /痛;頭を痛める/傷;筋を傷める,野菜が傷む/悼;死を悼む/至/到;≒至る/致;<rare>/愴;≒悼む/慯;≒悼む,≠傷む/
いたm /痛;頭を痛める/傷;筋を傷める,野菜が傷む/炒/悼;死を悼む/愴;≒悼む/慯;≒悼む,≠傷む/
いたk /痛/イタ/
いたi /痛/イタ/
いたg /痛/イタ/
いたc /至/到;≒至る/致;<rare>/
いぞr /居反/
いそがs /忙/
いそs /勤/
いそi /急/
いそg /急/
いずr /何/孰;-れにせよ/
いずm /居住/
いすわt /居座/
いすわr /居座/
いすわn /居座/
いすわc /居座/
いすくm /射竦/
いじわるs /意地悪/
いじわるk /意地悪/
いじわるi /意地悪/
いじわるg /意地悪/
いじりまわs /弄り回/
いじょうn /異常/
いじっぱr /意地っ張/
いじくりまわs /弄くり回/
いじきたなs /意地汚/
いじきたなk /意地汚/
いじきたなi /意地汚/
いじきたなg /意地汚/
いじt /弄/
いじs /維持/
いじr /弄/
いじn /弄/
いじm /苛/
いじk /弄/
いじc /弄/
いしょうあw /衣装合/
いしゅがえs /意趣返/
いしやk /石焼/
いしなg /石投/
いしとr /石取/
いしづくr /石造/
いしぐm /石組/
いしきs /意識/
いざなw /誘/
いざなu /誘/
いざなt /誘/
いざなo /誘/
いざなi /誘/
いざなe /誘/
いざなc /誘/
いざt /躄/膝行/
いざr /躄/膝行/
いざn /躄/膝行/
いざc /躄/膝行/
いさみたt /勇み立/
いさみたc /勇み立/
いささk /些;(字義:細かい)/聊;(字義:一時的)/
いさぎよs /潔/
いさぎよk /潔/
いさぎよi /潔/
いさぎよg /潔/
いさかw /諍/
いさかu /諍/
いさかt /諍/
いさかo /諍/
いさかi /諍/
いさかe /諍/
いさかc /諍/
いさいかまw /委細構/
いさn /勇/諫/諌;「諫」の異体字/
いさm /勇/諫/諌;「諫」の異体字/
いごk /動/
いごi /動/
いこうs /移行/
いこw /憩/憇;「憩」の異体字/
いこu /憩/憇;「憩」の異体字/
いこt /憩/憇;「憩」の異体字/
いこo /憩/憇;「憩」の異体字/
いこn /鋳込;cast/射込;shoot/
いこm /鋳込;cast/射込;shoot/
いこi /憩/憇;「憩」の異体字/
いこe /憩/憇;「憩」の異体字/
いこc /憩/憇;「憩」の異体字/
いけどt /生け捕/
いけどr /生け捕/
いけどn /生け捕/
いけどc /生け捕/
いけすk /いけ好/
いけn /不可;当て字/
いくとおr /幾通/
いくt /幾/
いくr /幾/
いぎもうしたt /異議申立/
いぎぶかs /意義深/
いぎぶかk /意義深/
いぎぶかi /意義深/
いぎぶかg /意義深/
いぎたなs /寝穢/
いぎたなk /寝穢/
いぎたなi /寝穢/
いぎたなg /寝穢/
いきわたt /行き渡/
いきわたr /行き渡/
いきわたn /行き渡/
いきわたc /行き渡/
いきわかr /生き別/
いきりたt /熱り立/
いきりたc /熱り立/
いきまk /息巻/
いきまi /息巻/
いきのこt /生き残/
いきのこr /生き残/
いきのこn /生き残/
いきのこc /生き残/
いきのb /生き延/
いきぬk /息抜;(relief)ちょっと息抜き/生き抜;(survive)乱世を生き抜く/
いきぬi /生き抜;(survive)乱世を生き抜く/
いきなやn /行き悩/
いきなやm /行き悩/
いきながらe /生き存/
いきながr /生き長/生き永/
いきどおt /憤/
いきどおr /憤/
いきどおn /憤/
いきどおc /憤/
いきどm /行き止/
いきとどk /行き届/
いきとどi /行き届/
いきてゆk /生きて行/
いきていt /生きて行/
いきていk /生きて行/
いきていc /生きて行/
いきづかi /息遣/息使;?/
いきづm /行き詰;計画が行き詰まる/息詰;息詰まる熱戦/
いきづk /息衝/
いきづi /息衝/
いきつづk /生き続/
いきつk /行き着;-く先/行き付;-けの店/
いきつi /行き着/
いきつg /息継/
いきちがw /行き違/
いきちがu /行き違/
いきちがt /行き違/
いきちがo /行き違/
いきちがi /行き違/
いきちがe /行き違/
いきちがc /行き違/
いきだおr /行き倒/
いきたe /息絶/
いきせききt /息せき切/息急き切/
いきせききr /息急き切/息せき切/
いきせききn /息急き切/息せき切/
いきせききc /息急き切/息せき切/
いきせk /息急;息急き切って/
いきすg /行き過/行過/
いきごn /意気込/
いきごm /意気込/
いきぐるs /息苦/
いきぎr /息切/
いきがかt /行き掛/
いきがかr /行き掛/
いきがかn /行き掛/
いきがかc /行き掛/
いきがk /行き掛/
いきかよw /行き通/
いきかよu /行き通/
いきかよt /行き通/
いきかよo /行き通/
いきかよi /行き通/
いきかよe /行き通/
いきかよc /行き通/
いきかえt /生き返;(蘇生) 死者が生き返る/
いきかえr /生き返;(蘇生) 死者が生き返る/行き帰;(往復)/
いきかえn /生き返;(蘇生) 死者が生き返る/
いきかえc /生き返;(蘇生) 死者が生き返る/
いきかw /行き交/
いきかu /行き交/
いきかt /行き交/
いきかo /行き交/
いきかi /行き交/
いきかe /行き交/
いきかc /行き交/
いきおいよk /勢い良/
いきおいづk /勢い付/
いきおいづi /勢い付/
いきおいこn /勢い込/
いきおいこm /勢い込/
いきおいあまt /勢い余/
いきおいあまr /勢い余/
いきおいあまc /勢い余/
いきおi /勢/
いきうつs /生き写/
いきうm /生き埋/
いきいそi /生き急/
いきいそg /生き急/
いきいk /生き生/
いきあたt /行き当/
いきあたr /行き当/
いきあたn /行き当/
いきあたc /行き当/
いきあw /行き合/
いきあu /行き合/
いきあt /行き当/行き合/行当/
いきあo /行き合/
いきあi /行き合/
いきあe /行き合/
いきあc /行き合/
いきs /息/粋/粹;「粋」の旧字(人名用漢字)/
いきr /熱/
いきn /息/粋/粹;「粋」の旧字(人名用漢字)/
いきm /息/
いきg /粋;粋がる/意気;意気がる/
いきd /粋/粹;「粋」の旧字(人名用漢字)/
いがみあw /啀み合/
いがみあu /啀み合/
いがみあt /啀み合/
いがみあo /啀み合/
いがみあi /啀み合/
いがみあe /啀み合/
いがみあc /啀み合/
いがいt /意外/
いがいn /意外/
いがいd /意外/
いがn /啀/
いがm /啀/
いかんなk /遺憾無/
いかりくるw /怒り狂/
いかりくるu /怒り狂/
いかりくるt /怒り狂/
いかりくるo /怒り狂/
いかりくるi /怒り狂/
いかりくるe /怒り狂/
いかりくるc /怒り狂/
いかしきt /活かし切/
いかしきr /活かし切/
いかしきn /活かし切/
いかしきc /活かし切/
いかがw /如何;-わしい/
いかおなz /以下同/
いかおなj /以下同/
いかt /怒/厳/忿;<rare>/
いかr /怒/忿;<rare>/
いかn /以下/何如/如何/怒/忿;<rare>/
いかm /厳;厳めしい/
いかk /射掛;矢を-ける/
いかg /如何/
いかd /如何/
いかc /怒/忿;<rare>/
いえどm /雖/
いえr /癒え;※送り位置補正/
いいわたs /言い渡/言渡/
いいわすr /言い忘/
いいわk /言い分/
いいよどn /言い淀/
いいよどm /言い淀/
いいよt /言い寄/
いいよr /言い寄/
いいよn /言い寄/
いいよc /言い寄/
いいもr /言い漏/
いいまわs /言い回/
いいまちがw /言い間違/
いいまちがu /言い間違/
いいまちがt /言い間違/
いいまちがo /言い間違/
いいまちがi /言い間違/
いいまちがe /言い間違/
いいまちがc /言い間違/
いいまぎr /言い紛/
いいまk /言い負/
いいまg /言い曲/
いいふるs /言い古/
いいふくm /言い含/
いいふr /言い触/
いいひろm /言い広/
いいひらk /言い開/
いいひらi /言い開/
いいはなt /言い放/
いいはなc /言い放/
いいはじm /言い始/
いいはt /言い張/
いいはr /言い張/
いいはn /言い張/
いいはc /言い張/
いいのこs /言い残/
いいのがr /言い逃/
いいのk /言い退/
いいぬk /言い抜/
いいにくs /言い難/
いいにくk /言い難/
いいにくi /言い難/
いいにくg /言い難/
いいならw /言い習/
いいなおs /言い直/
いいとおs /言い通/
いいづらs /言い辛/
いいづらk /言い辛/
いいづらi /言い辛/
いいづらg /言い辛/
いいつのt /言い募/
いいつのr /言い募/
いいつのn /言い募/
いいつのc /言い募/
いいつづk /言い続/
いいつたe /言い伝/
いいつくろw /言い繕/
いいつくろu /言い繕/
いいつくろt /言い繕/
いいつくろo /言い繕/
いいつくろi /言い繕/
いいつくろc /言い繕/
いいつくs /言い尽/
いいつk /言い尽/言い付/
いいつi /言い継/
いいつg /言い継/
いいっぱなs /言いっ放/
いいちがe /言い違/
いいちr /言い散;あることないこと-らす/
いいだs /言い出/
いいたがe /言い違/
いいたt /言い立/
いいたs /言い足/
いいたr /言い足/
いいそんj /言い損/
いいそこn /言い損/
いいそe /言い添/
いいすt /言い捨/
いいすg /言い過/
いいしぶt /言い渋/
いいしぶr /言い渋/
いいしぶn /言い渋/
いいしぶc /言い渋/
いいしt /言い知/
いいしr /言い知/
いいしn /言い知/
いいしc /言い知/
いいこm /言い籠/
いいけs /言い消/
いいくるm /言い包/
いいきt /言い切/
いいきr /言い切/
いいきn /言い切/
いいきk /言い聞/
いいきc /言い切/
いいがたs /言い難/
いいがたk /言い難/
いいがたi /言い難/
いいがたg /言い難/
いいがk /言い掛/
いいかわs /言い交/
いいかえs /言い返/
いいかえr /言い替え;※送り位置補正/
いいかw /言い交/
いいかn /言い兼/
いいかk /言い掛/
いいかe /言い換/言い替/
いいおよn /言い及/
いいおよb /言い及/
いいおとs /言い落/
いいおくt /言い送/
いいおくr /言い送/
いいおくn /言い送/
いいおくc /言い送/
いいおw /言い終/
いいおk /言い置/
いいおi /言い置/
いいおe /言い終/
いいあるk /言い歩/
いいあるi /言い歩/
いいあらわs /言い表/
いいあらたm /言い改/
いいあらそw /言い争/
いいあらそu /言い争/
いいあらそt /言い争/
いいあらそo /言い争/
いいあらそi /言い争/
いいあらそe /言い争/
いいあらそc /言い争/
いいあやまt /言い誤/
いいあやまr /言い誤/
いいあやまn /言い誤/
いいあやまc /言い誤/
いいあw /言い合/
いいあu /言い合/
いいあt /言い当/言い合/
いいあo /言い合/
いいあi /言い合/
いいあe /言い合/
いいあc /言い合/
いあわs /居合/
いあw /居合/
いあu /居合/
いあt /居合/
いあo /居合/
いあi /居合/
いあe /居合/
いあc /居合/
いz /居/射/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いy /癒/居/射/言;[口]そう言や(=そう言えば)/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いw /言/云/謂;(字義:何かに関していう)/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いu /言/云/謂;(字義:何かに関していう)/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いt /言/行/入/居/射/云/炒;卵を炒る/煎;≒炒る/凍/要/逝;(die) 祖父が逝く/謂;(字義:何かに関していう)/鋳;金物を鋳る/将;兵を将る/率;≒将る/熬/鑄;「鋳」の旧字(人名用漢字)/往;(前進) 荒野を往く/
いs /医;サ変/逸;※送り過剰?/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いr /入/射/要/居/炒;卵を炒る/煎;≒炒る/鋳;金物を鋳る/容;進言を容れる/淹;茶を淹れる/挿;指を挿れる/将;兵を将る/率;≒将る/熬/鑄;「鋳」の旧字(人名用漢字)/
いp /射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いo /言/云/謂;(字義:何かに関していう)/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いn /居/異;-な物/去/要;[口]要んない(=要らない)?/往/入/射/炒;卵を炒る/煎;≒炒る/鋳;金物を鋳る/将;兵を将る/率;≒将る/熬/鑄;「鋳」の旧字(人名用漢字)/忌/斎;清める/
いm /忌/居/斎;清める/射/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いk /行/生;(字義:芽が出る)/活;(字義:水が流れる)「特技が活きる」/逝;(die) 祖父が逝く/往;(前進) 荒野を往く/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/良/好/善/可/
いj /射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いi /言/良/云/可/好/善/謂;(字義:何かに関していう)/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いh /云/言/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いg /射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いe /言/癒/云/謂;(字義:何かに関していう)/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いd /出/射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いc /言/行/云/謂;(字義:何かに関していう)/入/射/要/居/炒;卵を炒る/煎;≒炒る/鋳;金物を鋳る/将;兵を将る/率;≒将る/熬/鑄;「鋳」の旧字(人名用漢字)/逝;(die) 祖父が逝く/往;(前進) 荒野を往く/
いb /射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
いa /射/居/鋳;金物を鋳る/将;兵を将る/率;≒将る/鑄;「鋳」の旧字(人名用漢字)/
あんないいたs /案内致/
あんぜんd /安全/
あんしんくだs /安心下/
あんしんs /安心/
あんz /案;(devise)「一計を案ずる」,(worry)「案ずるより産むが易し」/按;(押さえ、揉む)「腰を按ずる」,(考察する)「これを按ずるに…」/
あんn /暗/
あんk /餡/
あんj /案/按/
あんd /編ん;※送り位置補正/
あわれn /憐/
あわれm /憐/
あわびむすb /鮑結/
あわだt /泡立;(bubble) 石鹸が泡立つ/粟立;(鳥肌) 肌が粟立つ/
あわだc /泡立;(bubble) 石鹸が泡立つ/粟立;(鳥肌) 肌が粟立つ/
あわただs /慌/遽/
あわせよn /併せ読/
あわせよm /併せ読/
あわせもt /合わせ持/
あわせもc /合わせ持/
あわせのn /併せ呑/
あわせのm /併せ呑/
あわおどr /阿波踊/
あわあわs /淡淡/淡々/
あわt /慌/周章/
あわs /併;(並べる) 考え併せる/合/淡/
あわr /哀;(かなしく思いあわれむ)/憐;(気の毒に思いあわれむ)/恤/閔/
あわk /淡/
あわi /淡/
あわg /淡/
あれはt /荒れ果/
あれくるw /荒れ狂/
あれくるu /荒れ狂/
あれくるt /荒れ狂/
あれくるo /荒れ狂/
あれくるi /荒れ狂/
あれくるe /荒れ狂/
あれくるc /荒れ狂/
あるきまわt /歩き回/
あるきまわr /歩き回/
あるきまわn /歩き回/
あるきまわc /歩き回/
あるきつづk /歩き続/
あるきつかr /歩き疲/
あるきだs /歩き出/
あるきさt /歩き去/
あるきさr /歩き去/
あるきさn /歩き去/
あるきさc /歩き去/
あるk /歩/
あるi /歩/或/
ありふr /有り触/
ありつk /有り付/
ありつi /有り付/
ありきたr /在り来/
ありがとu /有り難/有難/
ありがたy /有り難/有難/
ありがたs /有り難/有難/
ありがたm /有り難/有難/
ありがたk /有り難/有難/
ありがたi /有り難/有難/
ありがたg /有り難/有難/
ありえz /有り得/
ありえy /有り得/
ありえt /有り得/
ありえs /有り得/
ありえr /有り得/
ありえn /有り得/
ありえm /有り得/
ありえk /有り得/
ありえc /有り得/
ありうr /有り得/
ありうb /有り得/
ありあわs /有り合/
ありあまt /有り余/
ありあまr /有り余/
ありあまn /有り余/
ありあまc /有り余/
ありあw /有り合/在り合/
ありk /歩;[文語]/
あらわs /表;(represent) 意味を表す/現;(show) 姿を現す/著;(author) 小説を著す/顕;(manifest) 名を顕す/露;(字義:透明なので見える)/
あらわr /表/現/顕/
あらわn /露;(字義:透明なので見える)/顕;(字義:顔を見せている)/
あらわd /露;(字義:透明なので見える)/顕;(字義:顔を見せている)/
あらだt /荒立/
あらたn /新/
あらたm /改;generic/革;(思い切って変える)「国政を革める」/検;(inspect)「切符を検める」/更;(renew)「契約を更める」/
あらそw /争/爭;「争」の旧字(人名用漢字)/
あらそu /争/爭;「争」の旧字(人名用漢字)/
あらそt /争/爭;「争」の旧字(人名用漢字)/
あらそo /争/爭;「争」の旧字(人名用漢字)/
あらそi /争/爭;「争」の旧字(人名用漢字)/
あらそe /争/爭;「争」の旧字(人名用漢字)/競/
あらそc /争/爭;「争」の旧字(人名用漢字)/
あらすg /粗過/
あらさがs /粗探/
あらけずr /荒削/
あらがw /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらがu /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらがt /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらがo /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらがk /荒書/
あらがi /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらがe /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらがc /抗/諍/争;NB:「あらそu」と同形/爭;「争」の旧字(人名用漢字)/
あらかせg /荒稼/
あらかじm /予/豫;「予」の旧字/
あらいながs /洗い流/
あらいなおs /洗い直/
あらいだs /洗い出/
あらいきよm /洗い清/
あらいおとs /洗い落/
あらいおt /洗い落/
あらいあg /洗い上/
あらあらs /荒々/
あらz /非/
あらw /表/現/洗/
あらu /洗/
あらt /新/洗/
あらs /粗;(rough) きめが粗い/荒;(wild) 波が荒い/麁;<rare> ≒粗い/
あらr /荒/
あらp /荒/粗/
あらo /洗/
あらk /荒;(wild) 波が荒い/粗;(rough) きめが粗い/麁;<rare> ≒粗い/
あらj /非/
あらi /洗/荒;(wild) 波が荒い/粗;(rough) きめが粗い/麁;<rare> ≒粗い/
あらg /荒;(wild) 波が荒い/粗;(rough) きめが粗い/麁;<rare> ≒粗い/
あらe /洗/
あらc /洗/
あらb /荒/
あゆみよt /歩み寄/
あゆみよr /歩み寄/
あゆみよn /歩み寄/
あゆみよc /歩み寄/
あゆみつづk /歩み続/
あゆn /歩/
あゆm /歩/
あやまt /誤;-って NB:「誤ち」は許容されにくい,(err) 選択を誤る/過;-ち/謝;(apologize) ゴメンと謝る/謬;≒誤る/
あやまr /謝;(apologise) ゴメンと謝る/誤;(err) 選択を誤る/謬;≒誤る/
あやまn /謝;(apologise) ゴメンと謝る/誤;(err) 選択を誤る/謬;≒誤る/
あやまc /過;-ち/誤;-って NB:「誤ち」は許容されにくい,(err) 選択を誤る/謝;(apologize) ゴメンと謝る/謬;≒誤る/
あやつt /操/
あやつr /操/
あやつn /操/
あやつc /操/
あやかt /肖/
あやかr /肖/
あやかn /肖/
あやかc /肖/
あやu /危/
あやs /怪;(不審) 怪しい人物/妖;(艶かしい,不気味) 妖しいムード/恠;<rare> ≒怪しい/
あやm /殺;人を殺める/危;≒殺める/怪;-む (いぶかる)/
あやb /危/
あめふt /雨降/
あめふr /雨降/
あめふn /雨降/
あめふc /雨降/
あめあg /雨上/
あみだs /編み出/
あみこn /編み込/
あみこm /編み込/
あみかk /網掛/
あみうt /網打/
あみあg /編み上/編上/
あまやどr /雨宿/
あまもよi /雨催/
あまもr /雨漏/
あまねs /遍/普/
あまねk /遍/普/
あまとb /天飛/
あまてr /天照/
あまつさe /剰;-え NB:本来は「あまっさえ」の誤用/
あまっさe /剰/
あまだr /雨垂/
あまずp /甘酸/
あますg /甘過/
あまごi /雨乞/
あまくだt /天下/天降;=天下り/
あまくだr /天下/天降;=天下り/
あまくだn /天下/天降;=天下り/
あまくだc /天下/天降;=天下り/
あまぎごe /天城越/
あまがけt /天翔/
あまがけr /天翔/
あまがけn /天翔/
あまがけc /天翔/
あまからs /甘辛/
あまからk /甘辛/
あまからi /甘辛/
あまからg /甘辛/
あまかけt /天翔/
あまかけr /天翔/
あまかけn /天翔/
あまかけc /天翔/
あまy /甘/
あまt /余/甘/餘;「余」の旧字/
あまs /余/甘/餘;「余」の旧字/
あまr /余/餘;「余」の旧字/
あまn /甘/余/餘;「余」の旧字/天/
あまm /甘/
あまk /甘/
あまi /甘/
あまg /甘/
あまe /甘/
あまc /甘;-っちょろい/余/餘;「余」の旧字/
あほくさs /阿呆臭/
あほくさk /阿呆臭/
あほくさi /阿呆臭/
あほくさg /阿呆臭/
あほうくさs /阿呆臭/
あほうくさk /阿呆臭/
あほうくさi /阿呆臭/
あほうくさg /阿呆臭/
あほr /阿呆/
あぶりだs /炙り出/
あぶらじm /油染/
あぶらあg /油揚/
あぶらk /脂/油/
あぶらg /脂/
あぶなs /危;非正則(あぶn)/
あぶなm /危;非正則(あぶn)/
あぶなk /危;非正則(あぶn)/
あぶなi /危;非正則(あぶn)/
あぶなg /危;非正則(あぶn)/
あぶt /焙;(字義:容器の中であぶる) 豆を焙る/炙;(字義:直火であぶる) 肉を炙る/炮/
あぶr /炙;(字義:直火であぶる) 肉を炙る/焙;(字義:容器の中であぶる) 豆を焙る/溢;職に溢れる/炮/
あぶn /危/炙;(字義:直火であぶる) 肉を炙る/焙;(字義:容器の中であぶる) 豆を焙る/炮/
あぶc /炙;(字義:直火であぶる) 肉を炙る/焙;(字義:容器の中であぶる) 豆を焙る/炮/
あふれでy /溢れ出/
あふれでt /溢れ出/
あふれでs /溢れ出/
あふれでr /溢れ出/
あふれでn /溢れ出/
あふれでm /溢れ出/
あふれだs /溢れ出/
あふれかえt /溢れ返/
あふれかえr /溢れ返/
あふれかえn /溢れ返/
あふれかえc /溢れ返/
あふr /溢/
あびせかk /浴びせ掛/
あびs /浴/
あばれまわt /暴れ回/
あばれまわr /暴れ回/
あばれまわn /暴れ回/
あばれまわc /暴れ回/
あばれだs /暴れ出/
あばきたt /暴き立/
あばr /暴/
あばk /暴/発/
あばi /暴/発/
あはなt /畔放/
あなほr /穴掘/
あなねらi /穴狙/
あなどt /侮/
あなどr /侮/
あなどn /侮/
あなどc /侮/
あなずr /侮/
あながt /強/
あなうm /穴埋/
あなあk /穴開/
あともどr /後戻/
あとまわs /後回/
あとばらi /後払/
あとづk /後付;-けの理論/跡付;(変遷を)-ける/
あとつg /跡継/
あとずさt /後退/
あとずさr /後退/
あとずさn /後退/
あとずさc /後退/
あとすこs /後少/
あとくさr /後腐/
あとかたづk /後片付/後片づ;※送り位置補正/
あとおs /後押/
あとおi /後追/
あとu /能/
あとd /後;後づけの理由/跡;(trace)歴史を跡づける/
あでy /艶/
あてはまt /当て嵌/
あてはまr /当て嵌/
あてはまn /当て嵌/
あてはまc /当て嵌/
あてはm /当て嵌/
あてながk /宛て名書/
あてつk /当て付/
あてこすt /当て擦/
あてこすr /当て擦/
あてこすn /当て擦/
あてこすc /当て擦/
あてこn /当て込/
あてこm /当て込/
あてt /宛/
あつらh /誂/
あつらe /誂/
あつまt /集/集ま;※送り位置補正/
あつまr /集/集ま;※送り位置補正/
あつまn /集/
あつまc /集/
あつすg /暑過/熱過/厚過/
あつぐるs /暑苦/
あつくるs /暑苦/
あつぎr /厚切/
あつかw /扱/
あつかu /扱/
あつかt /扱/
あつかo /扱/
あつかi /扱/
あつかe /扱/
あつかc /扱/
あつu /暑;暑い部屋/熱;熱い湯/厚;厚い本/篤;篤い友情/
あつs /暑;暑い部屋/厚;厚い本/熱;熱い湯/圧/篤;篤い友情/
あつm /集/厚/熱/暑/蒐;(探しあつめる)/聚;<rare> (一処にあつめる)/輯;<rare> (あつめて纏める)/纂;<rare> ≒輯/
あつk /熱;熱い湯/暑;暑い部屋/厚;厚い本/篤;篤い友情/扱;非正則(あつかu)/
あつi /熱;熱い湯/暑;暑い部屋/厚;厚い本/篤;篤い友情/
あつg /暑;暑い部屋/熱;熱い湯/厚;厚い本/篤;篤い友情/
あつb /厚/
あったm /温/暖/
あったk /暖/温/
あっけなi /呆気な;※送り位置補正/
あっs /圧/
あだうt /仇討/仇打/
あだp /婀娜/
あたりちr /当たり散/当り散/
あたりかまw /辺り構/
あたらしi /新し;※送り位置補正/
あたらs /新/
あたまわr /頭割/
あたまだs /頭出/
あたまがk /頭書/
あたまうt /頭打/
あたためなおs /温め直;味噌汁を-/暖め直;部屋を-/
あたためあw /温め合/暖め合/
あたためあu /温め合/暖め合/
あたためあt /温め合/暖め合/
あたためあo /温め合/暖め合/
あたためあi /温め合/暖め合/
あたためあe /温め合/暖め合/
あたためあc /温め合/暖め合/
あたたかs /暖/
あたたかk /暖/
あたたかi /暖/
あたたかg /暖/
あたたm /温;(字義:料理があたたかい) 体を温める/暖;(字義:日が当たってあたたかい) 部屋を暖める/
あたたk /暖;暖かい部屋/温;温かい料理/
あたかm /恰;-も/宛;-も/
あたいs /価;price. (字義:商人のつける売値)/値;value. (字義:そのものの価値)/價;「価」の旧字(人名用漢字)/
あたw /能/
あたu /能/
あたt /当;大当り/中;食中り/
あたr /辺;この辺り/当;大当り/中;食中り/新;非正則(あたらs)/邊;「辺」の旧字1/邉;「辺」の旧字2/
あたo /能/
あたn /当;大当り/中;食中り/
あたi /能/
あたh /与/
あたe /与/與;「与」の旧字(人名用漢字)/能/
あたc /当;大当り/中;食中り/
あそんd /遊ん;※送り位置補正/
あそびほうk /遊び呆/遊び惚/
あそびすg /遊び過/
あそびあるk /遊び歩/
あそびあるi /遊び歩/
あそびあk /遊び明/
あそn /遊/游;<rare>(字義:およぐ) ≒遊ぶ/
あそb /遊/游;<rare>(字義:およぐ) ≒遊ぶ/
あせにぎt /汗握/
あせにぎr /汗握/
あせにぎn /汗握/
あせにぎc /汗握/
あせくさs /汗臭/
あせくさk /汗臭/
あせくさi /汗臭/
あせくさg /汗臭/
あせt /焦/
あせs /汗/
あせr /焦/
あせn /焦/
あせc /焦/
あせb /汗;汗ばむ/
あずけいr /預け入/
あずかりしt /与り知/
あずかりしr /与り知/
あずかt /与;(授与)「お誉めに与る」 (関与) 「与り知らぬ」/預;(預託) 子供を預る/
あずかr /与;(授与)「お誉めに与る」 (関与) 「与り知らぬ」/預;(預託) 子供を預る/
あずかn /与;(授与)「お誉めに与る」 (関与) 「与り知らぬ」/預;(預託) 子供を預る/
あずかc /与;(授与)「お誉めに与る」 (関与) 「与り知らぬ」/預;(預託) 子供を預る/
あずk /預/
あじわいぶかs /味わい深/
あじわいぶかk /味わい深/
あじわいぶかi /味わい深/
あじわいぶかg /味わい深/
あじつk /味付/
あじちがi /味違/
あじだs /味出/
あじけなs /味気無/
あじけなk /味気無/
あじけなi /味気無/
あじけなg /味気無/
あじけs /味消/
あじきなs /味気無/
あじきなk /味気無/
あじきなi /味気無/
あじきなg /味気無/
あじw /味/
あじt /アジ/
あじs /味/
あじr /アジ/
あじn /味;-な(もの)/アジ/
あじd /味/
あじc /アジ/
あしまわs /足回/
あしまわr /足回/
あしぶm /足踏/
あしふm /足踏/
あしばらi /足払/
あしなr /足慣/
あしなm /足並/
あしどr /足取/
あしとr /足取/
あしでまとi /足手纏/
あしてまとi /足手纏/
あしたs /晨;あさ/
あししげk /足繁/
あしがらm /足搦/
あしがたm /足固/
あしがかr /足掛/
あしかk /足掛/
あしk /悪/惡;「悪」の旧字(人名用漢字)/
あざわらw /嘲笑/
あざわらu /嘲笑/
あざわらt /嘲笑/
あざわらo /嘲笑/
あざわらi /嘲笑/
あざわらe /嘲笑/
あざわらc /嘲笑/
あざやk /鮮;非正則(あざy)/
あざむk /欺/
あざむi /欺/
あざなw /糾/
あざなu /糾/
あざなt /糾/
あざなo /糾/
あざなi /糾/
あざなe /糾/
あざなc /糾/
あざけt /嘲/
あざけr /嘲/
あざけn /嘲/
あざけc /嘲/
あざy /鮮/
あさやk /朝焼/
あさはやs /朝早/
あさはやk /朝早/
あさはやi /朝早/
あさはやg /朝早/
あさづk /浅漬/
あさすg /浅過/
あさぐろs /浅黒/
あさぐろk /浅黒/
あさぐろi /浅黒/
あさぐろg /浅黒/
あさがえr /朝帰/
あさおk /朝起/
あさいr /浅煎/
あさt /漁/
あさs /浅/淺;「浅」の旧字/
あさr /漁/
あさp /朝/
あさn /漁/
あさm /浅;浅ましい/淺;「浅」の旧字/
あさk /浅/淺;「浅」の旧字/
あさi /浅/淺;「浅」の旧字/
あさg /浅/淺;「浅」の旧字/
あさc /漁/
あこがr /憧/憬;≒憧れ(る)/
あこu /赤/
あげつらw /論/
あげつらu /論/
あげつらt /論/
あげつらo /論/
あげつらi /論/
あげつらe /論/
あげつらc /論/
あげおr /上げ下/
あげあしとr /揚げ足取/
あげt /上/
あけわたs /明け渡/明渡/
あけひろg /開け広/明け広/
あけはなt /開け放/
あけはなs /開け放/
あけっぴろg /開けっ広/明けっ広/
あけっぱなs /開けっ放/明けっ放/
あけたt /開け閉/
あけくれr /明け暮れ;※送り位置補正/
あけくr /明け暮/
あぐn /倦/
あぐm /倦/
あくめいたかs /悪名高/
あくめいたかk /悪名高/
あくめいたかi /悪名高/
あくめいたかg /悪名高/
あくみょうだかs /悪名高/
あくみょうだかk /悪名高/
あくみょうだかi /悪名高/
あくみょうだかg /悪名高/
あくがr /憧;古語。「離れる」の意/
あくr /明く;※送り位置補正/
あきれはt /呆れ果/
あきれかえt /呆れ返/
あきれかえr /呆れ返/
あきれかえn /呆れ返/
あきれかえc /呆れ返/
あきらめきt /諦め切/
あきらめきr /諦め切/
あきらめきn /諦め切/
あきらめきc /諦め切/
あきらm /諦/
あきらk /明/
あきやすm /秋休/
あきばr /秋晴/
あきなw /商/賈;<rare> ≒商う/
あきなu /商/賈;<rare> ≒商う/
あきなt /商/賈;<rare> ≒商う/
あきなo /商/賈;<rare> ≒商う/
あきなi /商/賈;<rare> ≒商う/
あきなe /商/賈;<rare> ≒商う/
あきなc /商/賈;<rare> ≒商う/
あきたt /飽き足/
あきたr /飽き足/
あきたn /飽き足/
あきたc /飽き足/
あきr /明/呆/顕;(原義:顔を見せる) 正体を顕らかにする/煥;<rare>/
あがりこn /上がり込/
あがりこm /上がり込/
あがなw /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがなu /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがなt /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがなo /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがなi /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがなe /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがなc /贖;(redeem)罪を贖う/購;(buy)本を購う/
あがt /上/騰;物価が騰がる/挙が;※送り位置補正/揚が;※送り位置補正/上が;※送り位置補正/
あがr /上/騰;物価が騰がる/挙が;※送り位置補正/揚が;※送り位置補正/上が;※送り位置補正/
あがn /上/騰;物価が騰がる/
あがm /崇/
あがk /足掻/
あがi /足掻/
あがc /上/騰;物価が騰がる/
あかるすg /明る過/
あかるs /明/
あかるm /明/
あかるk /明/
あかるi /明/
あかるg /明/
あからm /赧/
あかぬk /垢抜/
あかちゃk /赤茶/
あかじm /垢染/
あかしだt /証立/
あかぐろs /赤黒/
あかぐろk /赤黒/
あかぐろi /赤黒/
あかぐろg /赤黒/
あかs /証/赤/朱/證;旧字/紅/赫;顔が赫い/
あかr /明/灯/赤/明か;※送り位置補正/
あかp /赤/
あかn /赤/
あかm /赤/紅/朱/
あかk /赤/紅/朱/赫;顔が赫い/
あかi /赤/紅/朱/赫;顔が赫い/
あかg /赤/紅/朱/赫;顔が赫い/
あおりたt /煽り立/
あおむk /仰向/
あおむi /仰向/
あおびかr /青光/
あおばどおr /青葉通/
あおたがi /青田買/
あおじろs /青白/蒼白/
あおじろm /青白/蒼白/
あおじろk /青白/蒼白/
あおじろi /青白/蒼白/
あおじろg /青白/蒼白/
あおぐろs /青黒/黝/
あおぐろm /青黒/黝/
あおぐろk /青黒/黝/
あおぐろi /青黒/黝/
あおぐろg /青黒/黝/
あおくさs /青臭/
あおくさm /青臭/
あおくさk /青臭/
あおくさi /青臭/
あおくさg /青臭/
あおぎみz /仰ぎ見/
あおぎみy /仰ぎ見/
あおぎみt /仰ぎ見/
あおぎみs /仰ぎ見/
あおぎみr /仰ぎ見/
あおぎみn /仰ぎ見/
あおぎみm /仰ぎ見/
あおぎみk /仰ぎ見/
あおぎみc /仰ぎ見/
あおy /青/
あおu /青/蒼;(血の気のない青) 顔が蒼い/碧;(澄んだ青緑) 碧い瞳/
あおt /煽;火を煽る/呷;酒を呷る/
あおs /青/蒼;(血の気のない青) 顔が蒼い/碧;(澄んだ青緑) 碧い瞳/
あおr /煽;火を煽る/呷;酒を呷る/
あおp /青/
あおn /煽;火を煽る/呷;酒を呷る/
あおm /青/蒼;(血の気のない青) 顔が蒼い/碧;(澄んだ青緑) 碧い瞳/
あおk /青/蒼;(血の気のない青) 顔が蒼い/碧;(澄んだ青緑) 碧い瞳/
あおi /青/蒼;(血の気のない青) 顔が蒼い/碧;(澄んだ青緑) 碧い瞳/仰/扇;団扇で扇ぐ/
あおg /仰/扇;団扇で扇ぐ/青/蒼;(血の気のない青) 顔が蒼い/碧;(澄んだ青緑) 碧い瞳/
あおc /煽;火を煽る/呷;酒を呷る/
あえt /敢/敢え;※送り位置補正/
あえi /喘/
あえg /喘/
あいわs /相和/
あいようs /愛用/
あいみたがi /相身互/
あいみz /相見/
あいみy /相見/
あいみt /相見/
あいみs /相見/
あいみr /相見/
あいみn /相見/
あいみm /相見/
あいみc /相見/
あいまt /相俟/
あいぼr /相惚/
あいひとs /相等/
あいはんs /相反/
あいはn /相食;骨肉-む/
あいはm /相食;骨肉-む/
あいのr /相乗/
あいなかb /相半/
あいなt /相成/
あいなr /相成/
あいなn /相成/
あいなc /相成/
あいともなw /相伴/
あいともなu /相伴/
あいともなt /相伴/
あいともなo /相伴/
あいともなi /相伴/
あいともなc /相伴/
あいてどt /相手取/
あいてどr /相手取/
あいてどn /相手取/
あいてどc /相手取/
あいつらn /相連/
あいつとm /相勤/
あいつうz /相通/
あいつうj /相通/
あいつi /相次/相継/
あいつg /相次/相継/
あいたいs /相対/
あいそわらi /愛想笑/
あいそよk /愛想良/
あいそづk /愛想尽/
あいじょうぶかs /愛情深/
あいじょうぶかk /愛情深/
あいじょうぶかi /愛情深/
あいじょうぶかg /愛情深/
あいしあw /愛し合/
あいしあu /愛し合/
あいしあt /愛し合/
あいしあo /愛し合/
あいしあi /愛し合/
あいしあe /愛し合/
あいしあc /愛し合/
あいさつがわr /挨拶代/
あいことn /相異/
あいかわr /相変/
あいかw /相変/
あいうt /相討/相打;相打ち/
あいいr /相容/
あいs /愛/
あいr /愛/
あいk /愛/
あいi /相/
あw /合;(一致) 話が合う/会;人と会う/併/逢;(人と|運命的にあう) 巡り逢う/遭;(偶然、特によくないことにあう) 事故に遭う/會;「会」の旧字/遇;≒遭う/
あu /合;(一致) 話が合う/会;人と会う/遭;(偶然、特によくないことにあう) 事故に遭う/逢;(人と|運命的にあう) 巡り逢う/遇;≒遭う/會;「会」の旧字/
あt /当/宛/充/会;人と会う/合;(一致) 話が合う/有;(⇔無)時間が有る/在;(⇔不在)眼前に在る/遭;(偶然、特によくないことにあう) 事故に遭う/逢;(人と|運命的にあう) 巡り逢う/該/當;「当」の旧字/會;「会」の旧字/遇;≒遭う/
あs /褪/悪/惡;「悪」の旧字(人名用漢字)/
あr /荒/有;(⇔無)時間が有る/在;(⇔不在)眼前に在る/或;(certain) 或る時/
あo /合;(一致) 話が合う/会;人と会う/會;「会」の旧字/遭;(偶然、特によくないことにあう) 事故に遭う/逢;(人と|運命的にあう) 巡り逢う/遇;≒遭う/
あn /編/彼;-の/有;(⇔無)時間が有る/在;(⇔不在)眼前に在る/浴;湯浴み/
あm /編/浴;湯浴み/
あk /開/飽;原義:満腹する/空/明;(夜|年|喪)が明ける/厭;原義:(脂身のように)しつこくて嫌になる/倦;原義:疲れて嫌になる/飫/有;[口]文句有っか/
あi /合;(一致) 話が合う/会;人と会う/空/開/逢;(人と|運命的にあう) 巡り逢う/遭;(偶然、特によくないことにあう) 事故に遭う/會;「会」の旧字/遇;≒遭う/飽;原義:満腹する/明;夜が明ける/厭;原義:(脂身のように)しつこくて嫌になる/倦;原義:疲れて嫌になる/飫/
あh /合/會;「会」の旧字/
あg /上/挙;(示すためにあげる) (例|手)を挙げる/揚;(高くあげる) (旗|からあげ)を揚げる/擧;「挙」の旧字/
あe /会;人と会う/合;(一致) 話が合う/逢;(人と|運命的にあう) 巡り逢う/敢;(dare) 敢えて/和;(調味料等と混ぜる) 胡麻和え/韲;≒和える/遭;(偶然、特によくないことにあう) 事故に遭う/會;「会」の旧字/遇;≒遭う/
あc /合;(一致) 話が合う/会;人と会う/遭;(偶然、特によくないことにあう) 事故に遭う/逢;(人と|運命的にあう) 巡り逢う/遇;≒遭う/會;「会」の旧字/有;(⇔無)時間が有る/在;(⇔不在)眼前に在る/
あb /浴/
>わたs /渡/
>わすr /忘/
>わk /分/
>ようn /様/
>ようd /様/
>ゆk /行/
>やすu /易/
>やすs /易/
>やすm /易/
>やすk /易/
>やすi /易/
>やすg /易/
>やt /遣/
>やr /遣/
>やn /止/遣/
>やm /止/
>やc /遣/
>もらw /貰/
>もらu /貰/
>もらt /貰/
>もらo /貰/
>もらi /貰/
>もらe /貰/
>もらc /貰/
>もt /漏/
>もr /漏/
>もn /漏/
>もc /漏/
>みz /見/
>みy /見/
>みt /見/
>みs /見/
>みr /見/
>みn /見/
>みm /見/
>みc /見/
>まわs /回/
>まよw /迷/
>まよu /迷/
>まよt /迷/
>まよo /迷/
>まよi /迷/
>まよe /迷/
>まよc /迷/
>まどw /惑/
>まどu /惑/
>まどt /惑/
>まどo /惑/
>まどi /惑/
>まどe /惑/
>まどc /惑/
>まちがw /間違/
>まちがu /間違/
>まちがt /間違/
>まちがo /間違/
>まちがi /間違/
>まちがe /間違/
>まちがc /間違/
>まうs /申/
>まs /増/
>ほs /欲/
>ふうn /風/
>ふうd /風/
>ぱらw /払/
>ぱらu /払/
>ぱらt /払/
>ぱらo /払/
>ぱらi /払/
>ぱらe /払/
>ぱらc /払/
>ぱなs /放/
>ばかr /許/
>はらw /払/
>はらu /払/
>はらt /払/
>はらo /払/
>はらi /払/
>はらe /払/
>はらc /払/
>はべt /侍/
>はべr /侍/
>はべn /侍/
>はべc /侍/
>はなs /放/
>はじm /始;(開始)「考え始める」「姫始め」/
>はt /果/
>のこt /残/
>のこs /残/
>のこr /残/
>のこn /残/
>のこc /残/
>ねがw /願/
>ねがu /願/
>ねがt /願/
>ねがo /願/
>ねがi /願/
>ねがe /願/
>ねがc /願/
>ぬk /抜/
>ぬi /抜/
>にくs /難;(hard) 考え難い NB:「がたi」と同形/
>にくk /難;(hard) 考え難い NB:「がたi」と同形/
>にくi /難;(hard) 考え難い NB:「がたi」と同形/
>にくg /難;(hard) 考え難い NB:「がたi」と同形/
>ながr /乍;(助動詞) 聞き乍ら/
>なおs /直;故障を直す/
>なs /無/
>なr /慣/
>なk /無/
>なi /無/
>なg /無/
>どおs /通;(連濁) 負け通し,立ち通し,千枚通し/
>とおs /通/
>とt /取/
>とr /取/
>とn /飛;fly/取/
>とm /止/留;気に留める/
>とc /取/
>とb /飛;fly/
>できz /出来/
>できy /出来/
>できw /出来/
>できu /出来/
>できt /出来/
>できs /出来/
>できr /出来/
>できp /出来/
>できo /出来/
>できn /出来/
>できm /出来/
>できk /出来/
>できj /出来/
>できi /出来/
>できh /出来/
>できg /出来/
>できe /出来/
>できd /出来/
>できc /出来/
>できb /出来/
>できa /出来/
>でz /出/
>でy /出/
>でw /出/
>でu /出/
>でt /出/
>でs /出/
>でr /出/
>でp /出/
>でo /出/
>でn /出/
>でm /出/
>でk /出/
>でj /出/
>でi /出/
>でh /出/
>でg /出/
>でe /出/
>でd /出/
>でc /出/
>でb /出/
>でa /出/
>てきn /的/
>てきd /的/
>づらs /辛/
>づらk /辛/
>づらi /辛/
>づらg /辛/
>づk /付/
>づi /付/
>つのt /募/
>つのr /募/
>つのn /募/
>つのc /募/
>つづk /続/
>つづi /続/
>つくs /尽/
>つかr /疲/
>つk /尽/付/着/
>つi /付/着/継;語り継いで/
>つg /継;語り継ぐ/
>ちがe /違/
>ちt /散/
>ちr /散/
>ちn /散/
>ちc /散/
>だs /出/
>たまw /給/
>たまu /給/
>たまt /給/
>たまo /給/
>たまi /給/
>たまh /給/
>たまe /給/
>たまc /給/
>たてまつt /奉/
>たてまつr /奉/
>たてまつn /奉/
>たてまつc /奉/
>たおs /倒/
>たt /立/
>たs /足/
>たc /立/
>ぞm /初/
>そこなw /損/
>そこなu /損/
>そこなt /損/
>そこなo /損/
>そこなi /損/
>そこなe /損/
>そこなc /損/
>そこn /損/
>そm /初;知り初める/
>ずm /済/
>ずk /好/
>すすn /進/
>すすm /進/
>すg /過/
>じょうn /状/
>じょうd /状/
>しまw /終/了/
>しまu /終/了/
>しまt /終/了/
>しまo /終/了/
>しまi /終/了/
>しまe /終/了/
>しまc /終/了/
>しぶt /渋/
>しぶr /渋/
>しぶn /渋/
>しぶc /渋/
>さt /去/
>さs /止;言い止す/
>さr /去/
>さn /去/
>さg /下/
>さc /去/
>ごs /越;(連濁) ガラス越し/
>ころs /殺/
>こz /来/
>こy /来/
>こs /来/
>こr /来/
>こn /込/来/
>こm /込/
>こi /来/
>くわe /加/
>くるw /狂/
>くるu /狂/
>くるt /狂/
>くるo /狂/
>くるi /狂/
>くるe /狂/
>くるc /狂/
>くらb /比;字義:並べてくらべる/較;字義:突き合わせてくらべる/
>くだs /下/
>くr /来/呉/
>くn /来/
>ぎらi /嫌/
>ぎm /決/
>きy /来/
>きt /来/切/
>きs /来/
>きr /切/
>きn /来/切/
>きm /来/
>きd /来/
>きc /来/切/
>がらm /絡/
>がたs /難;考え難い NB:「にくi」と同形/
>がたk /難;考え難い NB:「にくi」と同形/
>がたi /難;考え難い NB:「にくi」と同形/
>がたg /難;考え難い NB:「にくi」と同形/
>がt /勝/
>がk /掛/
>かわs /交/
>かえs /返;金を返す,裏返す/
>かw /交;挨拶を交わす/
>かn /兼/
>かk /掛/
>かe /替;(取り替え) 部品を替える/
>おわt /終/
>おわr /終/
>おわn /終/
>おわc /終/
>おとs /落/
>おさm /納/
>おこs /起/
>おくr /遅/
>おおs /果;言い果せる/
>おw /終/
>おt /落/
>おr /下/
>おk /起/置/
>おi /置/
>おe /終/
>おc /落/
>えz /得/
>えy /得/
>えt /得/
>えs /得/
>えr /得/
>えn /得/
>えm /得/
>えc /得/
>うr /得/
>うb /得/
>いただk /頂/戴/
>いただi /頂/戴/
>いたs /致/
>いt /行/入/
>いr /入/
>いn /入/
>いk /行/
>いc /行/入/
>あわs /合/
>あるk /歩/
>あるi /歩/
>あさt /漁/
>あさr /漁/
>あさn /漁/
>あさc /漁/
>あぐn /倦/
>あぐm /倦/
>あw /合/
>あu /合/
>あt /合/当/
>あo /合/
>あk /飽/
>あi /合/飽/
>あg /上/
>あe /合/
>あc /合/
;; okuri-nasi entries.
! /！/感嘆符/
!! /！！/
!= /≠/
" /″;second/“;doublequote(open)/”;doublequote(close)/〃;繰り返し記号/
# /#1/#3/#2/＃;number/#0/#8/#4/#5/
#% /#1％/
#) /#1）/
#,# /#1，#1/#1、#1/
#-# /#1〜#1/#1-#1/
#-#-# /#1−#1−#1/
#. /#1．/
#.# /#1．#1/#0月#0日/
#/# /#0月#0日/#1／#1/#1月#1日/
#:# /#1：#1/
#F /#1Ｆ/
#bit /#0ビット/#1ビット/
#cm /#1ｃｍ/
#copy /#0部/
#d /#0日/
#door /#0ドア/#1ドア/
#f /#0階/#1Ｆ/#1階/
#feet /#1フィート/
#fu /#9歩/
#g /#0G/#1ギガ/
#gatu /#1月/
#gatu#niti /#1月#1日/
#giga /#1ギガ/
#gin /#9銀/
#gyoku /#9玉/
#h /#0時間/#1時/#0時/
#h#m /#0時#0分/
#hi /#9飛/
#hisha /#9飛車/
#hu /#9歩/
#inch /#1インチ/
#ji /#1時/
#k /#0金/
#ka /#1日/
#kaku /#9角/
#kei /#9桂/
#kg /#1ｋｇ/
#kin /#9金/
#kyou /#9香/
#lsize /#0Lサイズ/#1Ｌサイズ/
#m /#0Mbytes/#1ｍ/#0月/
#m# /#0月#0日/
#m#d /#0月#0日/
#mega /#1メガ/
#mei /#1名/
#mile /#1マイル/
#min /#0分/
#mm /#1ｍｍ/#2ｍｍ/
#narigin /#9成銀/
#narikei /#9成桂/
#narikyou /#9成香/
#nen /#1年/
#nichi /#1日/
#page /#0ページ/#1ページ/#0 ページ/
#pin /#0ピン/
#room /#0部屋/
#ryu /#9龍/
#ryuu /#9竜/
#t /#1ｔ/#0坪/
#to /#9と/
#uma /#9馬/
#y /#0年/
#y#m#d /#0年#0月#0日/
#yard /#1ヤード/
#yen /#1円/#0円/#8円/
#、# /#1、#1/
#、#てん /#1、#1点/
#、#にち /#1、#1日/
#、#にん /#1、#1人/
#、#ねん /#1、#1年/
#、#ふん /#1、#1分/
#、#まい /#1、#1枚/
#、#まん /#1、#1万/
#。 /#1．/
#。# /#1．#1/#1.#1/
#。#。# /#1．#1．#1/
#。#にん /#1．#1人/
#。#めが /#1.#1Mbyte/
#：# /#1：#1/
#ー# /#1—#1/
#あん /#3案/#1案/#0案/#2案/
#あんだ /#0安打/
#い /#0位/#1位/#3位/#2位/
#う /#3宇;寺院/#1宇/#0宇/#2宇/
#えき /#3駅/#1駅/#0駅/#2駅/
#えだ /#3枝/#1枝/#0枝/#2枝/
#えん /#1円/#0円/#8円/#3円/#0えん/#2円/
#えんさつ /#3円札/
#おうふく /#1往復/
#おく /#1億;10^8/#3億;10^8/#0億;10^8/#2億;10^8/
#おく#せんまん /#1億#1千万/
#おくえん /#0億円/#1億円/#3億円/
#おくねんまえ /#3億年前/
#おり /#3折/#1折/#0折/#2折/
#おん /#3音/#1音/#0音/#2音/
#か /#3日/#3価/#0日/#1日/#2日/#1価/#0価/#2価/#3顆;ハンコ/#1顆/#0顆/#2顆/#3架/#1架/#0架/#2架/#3荷;荷物/#1荷/#0荷/#2荷/
#かい /#1回/#0回/#1階/#0階/#2階/#3回/#1Ｆ/#3階/#2回/
#かいせい /#0回生/#1回生/#3回生/
#かいせん /#0回線;lines/#1回戦;rounds/
#かいだて /#3階建/#0階建/#3階建て/#0階建て/
#かいてん /#0回転/#3回転/
#かいはつ /#3開発/
#かいぶん /#3回分/#0回分/
#かいめ /#0回目/#3回目/
#かかん /#1日間/
#かく /#3格/#1格/#0格/#2格/#3画/#1画/#0画/#2画/
#かくけい /#3角形/
#かげつ /#1ヶ月/#0ヶ月/#3ヶ月/#0カ月/#3箇月/#0 ヶ月/
#かこく /#0カ国/#2カ国/
#かさね /#3重/#1重/#0重/#2重/
#かしょ /#0箇所/#1ヶ所/#1個所/#0ヶ所/#0カ所/#2カ所/
#かじょう /#2カ条/
#かっけい /#3角形/
#かねん /#0カ年/
#かぶ /#3株/#1株/#0株/#2株/
#かぶん /#3日分/#0日分/
#かめ /#1日目/
#かもく /#0科目/
#から# /#1〜#1/
#からむ /#1カラム/
#かん /#1巻/#3巻/#3冠/#3缶/#1缶/#0缶/#2缶/#0巻/#2巻/#1冠/#0冠/#2冠/#3管/#1管/#0管/#2管/#3貫;3.75kg/#1貫/#0貫/#2貫/
#がい /#0階/#1階/#3階/#2階/
#がいだて /#3階建/#0階建/#3階建て/#0階建て/
#がた /#3型/#1型/#0型/#2型/
#がつ /#0月/#1月/#3月/#2月/
#がつ#か /#1月#1日/#0月#0日/
#がつ#にち /#1月#1日/#0月#0日/#2月#2日/#2月#1日/
#がつごう /#0月号/#3月号/#1月号/
#がつちゅう /#0月中/
#がつまつ /#1月末/
#がめん /#1画面/
#がん /#3貫/#1貫/#0貫/#2貫/
#き /#3期/#1期/#0機/#0期/#1基/#2期/#3機/#1機/#2機/#3基/#0基/#2基/
#きゃく /#3脚/#1脚/#3客/#1客/#0客/#2客/#0脚/#2脚/
#きゅう /#3級/#1級/#0級/#2級/#3球/#1球/#0球/#2球/
#きょう /#3強/#1強/#0強/#2強/
#きょうか /#0教科/
#きょく /#1曲/#3曲/#0曲/#2曲/#3局/#1局/#0局/#2局/
#きれ /#3切/#1切/#0切/#2切/
#きろ /#1キロ/#2キロ/#1Km/#1kg/#1kbyte/#1Ｋ/#1ｋ/
#きろばいと /#1kb/#1kbytes/#3kb/#0kb/#2kb/
#きん /#3金/#1金/#0金/#2金/#3禁/#1禁/#0禁/#2禁/#3斤;600g/#1斤;600g/#0斤;600g/#2斤;600g/
#ぎが /#1Ｇ/
#ぎょう /#0行/#1行/#2行/#3行/
#ぎょうめ /#0行目/#1行目/
#ぎん /#3斤/#1斤/#0斤/#2斤/
#く /#3区/#1区/#0区/#2区/#3句/#1句/#0句/#2句/#3口/#1口/#0口/#2口/
#くち /#1口/#3口/#0口/#2口/
#くみ /#1組/#3組/#0組/#2組/
#ぐ /#3具/#1具/#0具/#2具/
#ぐらむ /#1グラム/
#け /#3ヶ/#1ヶ/#0ヶ/#2ヶ/
#けいとう /#0系統/#1系統/
#けた /#3桁/#1桁/#2桁/#0桁/
#けん /#0件/#1件/#1軒/#3間;6尺/#3軒/#3件/#2件/#0軒/#2軒/#1間;6尺/#0間;6尺/#2間;6尺/#3鍵/#1鍵/#0鍵/#2鍵/#0 件/
#けんめ /#1軒目/
#げん /#1限/#3元/#1元/#0元/#2元/#3弦;string/#1弦/#0弦/#2弦/#3軒/#1軒/#0軒/#2軒/#3限/#0限/#2限/
#げんそく /#1原則/
#げんめ /#1限目/
#こ /#3個/#1個/#0個/#2個/#3戸/#1戸/#0戸/#2戸/#3ヶ/#1ヶ/#0ヶ/#2ヶ/#3コ/#1コ/#0コ/#2コ/
#こう /#0項/#0校/#1項/#3項/#2項/#3校/#1校/#2校/
#こうかんけい /#0項関係/
#こく /#3石/#1石/#0石/#2石/
#こし /#3腰/#1腰/#0腰/#2腰/
#こま /#0コマ/#1コマ/#3コマ/#3齣/#1齣/#0齣/#2齣/
#こり /#3梱/#1梱/#0梱/#2梱/
#こん /#3献/#1献/#0献/#2献/
#ご /#0語/#1語/#3語/#2語/
#ごう /#3号/#0号/#1号/#2号/#3合/#0合/#1合/#2合/#5號;「号」の旧字/#3號;「号」の旧字/#2號;「号」の旧字/#0號;「号」の旧字/#1號;「号」の旧字/
#ごうかん /#0号館/#1号館/#1号缶/#0号缶/
#ごうき /#1号機/
#ごうしつ /#0号室/#2号室/
#ごうしゃ /#0号車/#1号車/
#ごうせん /#0号線/
#ごく /#3石/#1石/#0石/#2石/
#さ /#3差/#1差/#0差/#2差/
#さい /#0歳/#1才/#1歳/#2歳/#3歳/#3才/#0才/#2才/
#さお /#3棹/#1棹/#0棹/#2棹/
#さく /#3作/#1作/#0作/#2作/
#さつ /#1冊/#3冊/#0冊/#3札/#1札/#0札/#2札/#2冊/#3刷/#1刷/#0刷/#2刷/
#さつめ /#3冊目/
#さら /#3皿/#1皿/#0皿/#2皿/
#さん /#3山/#1山/#0山/#2山/
#し /#0氏/#3子/#3死/#1死/#0死/#2死/#3氏/#1氏/#2氏/#1子/#0子/#2子/
#しあい /#0試合/
#しき /#3式/#1式/#0式/#2式/#3色/#1色/#0色/#2色/
#しってん /#1失点/
#しつ /#0室/#1室/#3室/#2室/
#しな /#3品/#1品/#0品/#2品/
#しゃ /#1者/#3者/#0者/#2者/#3社/#1社/#0社/#2社/
#しゃく /#3尺/#1尺/#0尺/#2尺/
#しゅ /#3種/#0種/#1種/#2種/#3首/#1首/#0首/#2首/
#しゅう /#1週/#3集/#1集/#0集/#2集/#3週/#0週/#2週/#3周/#1周/#0周/#2周/#3輯/#1輯/#0輯/#2輯/
#しゅうかん /#1週間/#0週間/#3週間/
#しゅうかんご /#0週間後/
#しゅうねん /#1周年/#3周年/
#しゅるい /#0種類/#1種類/#2種類/
#しょう /#1章/#0章/#1勝/#3章/#2章/#3床/#1床/#0床/#2床/#3勝/#0勝/#2勝/
#しょう#せつ /#1章#1節/
#しょう#はい /#1勝#1敗/
#しょうめん /#3正面/
#しょく /#1色/#0色/#3食/#1食/#0食/#2食/#3色/#2色/
#しん /#0進/#1進/#3進/#2進/
#しんすう /#0進数/#1進数/#3進数/
#しんほう /#0進法/#1進法/#3進法/
#じ /#0時/#1時/#2時/#0次/#3次/#1次/#3時/#0字/#3字/#1字/#2字/#2次/#3児/#1児/#0児/#2児/#3寺/#1寺/#0寺/#2寺/
#じ#ふん /#0時#0分/#1時#1分/
#じ#ぷん /#0時#0分/
#じかい /#1次会/#3次会/
#じかん /#0時間/#1時間/#3時間/#2時間/
#じかんはん /#1時間半/
#じかんめ /#1時間目/
#じく /#3軸/#1軸/#0軸/#2軸/
#じげん /#1次元/#0次元/
#じごろ /#0時頃/
#じしけん /#1次試験/#3次試験/
#じたこうしき /#3次多項式/
#じはん /#1時半/#0時半/#3時半/
#じほうていしき /#3次方程式/
#じみゃく /#3次脈/
#じゃく /#3弱/#1弱/#0弱/#2弱/#3尺/#1尺/#0尺/#2尺/
#じゅう /#1重/#3重/#0重/#2重/
#じゅん /#3巡/#1巡/#0巡/#2巡/
#じゅんめ /#3巡目/
#じょ /#2女/#3女/#1女/#0女/
#じょう /#3畳/#0条/#0畳/#0乗/#1畳/#3錠/#1錠/#0錠/#2錠/#3乗/#1乗/#2乗/#3条/#1条/#2条/#2畳/#3帖/#1帖/#0帖/#2帖/
#じよせん /#1次予選/#3次予選/
#すう /#1数/#3数/#0数/#2数/
#すうか /#3数花/
#すうせい /#1数性/
#すじ /#3筋/#1筋/#0筋/#2筋/
#すてーじ /#1ステージ/
#すてっぷ /#1ステップ/
#すん /#2寸/#3寸/#1寸/#0寸/
#ず /#3図/#1図/#0図/#2図/
#ずん /#3寸/#1寸/#0寸/#2寸/
#せい /#1声/#3世/#1世/#0世/#2世/#3声/#0声/#2声/
#せいき /#0世紀/#1世紀/
#せいりょく /#3勢力/
#せき /#3隻;船/#1隻;船/#0隻;船/#2隻;船/#3席/#1席/#0席/#2席/#3石/#1石/#0石/#2石/
#せたい /#0世帯/
#せだい /#1世代/
#せだいめ /#3世代目/
#せっと /#1セット/
#せつ /#1節/#3節/#0節/#2節/
#せん /#1千/#3選/#3線/#1線/#0線/#2線/#3千/#0千/#2千/#3銭/#1銭/#0銭/#2銭/#1選/#0選/#2選/
#せんえん /#1千円/#2千円/
#せんち /#1cm/#1センチ/#3cm/#0cm/#2cm/
#せんまん /#3千万/
#ぜん /#3膳/#1膳/#0膳/#2膳/
#そう /#3層/#0相/#0層/#3艘;船/#1艘;船/#3双;手袋/#1双;手袋/#0艘;船/#1漕/#1層/#2層/#3相/#1相/#2相/#2艘/#0双/#2双/#3漕/#0漕/#2漕/
#そうさ /#1走査/
#そく /#3足;履物/#1足;履物/#3速;ギア/#1速;ギア/#0速/#2速/#0足/#2足/#3束/#1束/#0束/#2束/
#そろい /#3揃/#1揃/#0揃/#2揃/
#ぞく /#1属/#3属/#0属/#2属/
#たい /#0体/#3体/#1体/#2体/
#たく /#3択/#1択/#0択/#2択/
#たば /#1束/#3束/#0束/#2束/
#たま /#3玉/#1玉/#0玉/#2玉/
#たん /#3反/#1反/#0反/#2反/
#だ /#0打/#3打/#3駄/#1駄/#0駄/#2駄/#1打/#2打/
#だい /#0台/#0代/#1台/#3代/#3題/#0題/#1代/#3台/#3大/#1大/#0大/#2大/#1題/#2題/#2台/#2代/
#だいめ /#3台目/#3代目/
#ださ /#0打差/#3打差/
#だすう /#0打数/
#だてん /#0打点/
#だん /#3段/#0段/#1段/#2段/
#だんかい /#1段階/
#だんぐみ /#0段組み/
#だんめ /#1段目/#0段目/
#ち /#0値/#3値/#1値/#2値/
#ちーむ /#0チーム/
#ちっぷ /#1チップ/
#ちゃく /#0着/#3着/#1着/#2着/
#ちょ /#3著/#1著/#0著/#2著/
#ちょう /#3兆;10^12/#1兆;10^12/#0兆;10^12/#2兆;10^12/#3丁/#1丁/#0丁/#2丁/#3挺/#1挺/#0挺/#2挺/#3張/#1張/#0張/#2張/
#ちょうえん /#1兆円/#3兆円/
#ちょうめ /#1丁目/#0丁目/#2丁目/#3丁目/
#つ /#1つ/#0つ/#2つ/#3つ/#3ツ/#1ツ/#0ツ/#2ツ/
#つい /#3対/#1対/#0対/#2対/
#つう /#1通/#0通/#3通/#2通/
#つうめ /#1通目/
#つがい /#3番/#1番/#0番/#2番/
#つき /#3月/#0月/#1月/#2月/
#つつみ /#3包/#1包/#0包/#2包/
#つぶ /#3粒/#1粒/#0粒/#2粒/
#つぼ /#1坪/#3坪/#0坪/#2坪/
#つめ /#1つ目/
#て /#3手/#1手/#0手/#2手/
#てい /#3訂/#1訂/#0訂/#2訂/
#ていばん /#3訂版/
#てん /#0点/#1点/#3点/#2点/#3店/#1店/#0店/#2店/
#てんせっと /#0点セット/
#と /#3斗;10升/#1斗;10升/#0斗;10升/#2斗;10升/
#とう /#1等/#0頭/#3党/#3頭/#1頭/#1党/#0党/#2党/#3等/#0等/#2等/#3灯/#1灯/#0灯/#2灯/#2頭/
#とうしん /#1頭身/
#とおり /#1通り/
#とん /#3噸;ton(1000kg)/#1噸;ton(1000kg)/#0噸;ton(1000kg)/#2噸;ton(1000kg)/
#ど /#1度/#3度/#0度/#2度/#3°;degree/#1°;degree/#0°;degree/#2°;degree/#3℃;celsius/#1℃;celsius/#0℃;celsius/#2℃;celsius/
#どめ /#1度目/#3度目/
#なん /#2男/#3男/#1男/#0男/
#にち /#1日/#0日/#3日/#2日/
#にちかん /#3日間/#0日間/
#にちぶん /#1日分/
#にん /#0人/#1人/#3人/#2人/
#にんぐみ /#1人組/
#にんぶん /#0人分/#1人分/
#にんめ /#3人目/
#ねん /#1年/#0年/#3年/#2年/
#ねん#がつ#にち /#0年#0月#0日/#1年#1月#1日/
#ねん#くみ /#1年#1組/
#ねんかん /#0年間/#1年間/
#ねんご /#3年後/
#ねんせい /#0年生/#3年生/#1年生/
#ねんだい /#0年代/
#ねんど /#0年度/#1年度/#2年度/
#ねんはん /#0年半/
#ねんぶん /#3年分/#0年分/
#ねんまえ /#3年前/#1年前/
#ねんめ /#0年目/#1年目/
#はい /#1敗/#3杯;飲物,イカ,タコ,船/#1杯;飲物,イカ,タコ,船/#0杯/#2杯/#3敗/#0敗/#2敗/
#はいめ /#3杯目/
#はく /#0泊;宿泊/#1泊;宿泊/#0拍;脈拍/#3泊;宿泊/#3拍;脈拍/#1拍;脈拍/#2拍;脈拍/#2泊;宿泊/
#はく#か /#3泊#3日/
#はこ /#1箱/#3箱/#0箱/#2箱/
#はしら /#3柱/#1柱/#0柱/#2柱/
#はち /#3鉢/#1鉢/#0鉢/#2鉢/
#はつ /#0発/#3発/#1発/#2発/
#はり /#1針/#3張り;弓・幕等/#1張り;弓・幕等/#3針/#0針/#2針/#3張/#1張/#0張/#2張/
#はん /#3犯/#1犯/#0犯/#2犯/#3版/#1版/#0版/#2版/#3翻/#1翻/#0翻/#2翻/
#ばい /#1倍/#1杯/#3倍/#0倍/#2倍/#3杯/#0杯/#2杯/
#ばいすう /#1倍数/
#ばいたい /#0倍体/#3倍体/
#ばいと /#1バイト/#0バイト/
#ばん /#3晩/#1番/#0番/#2番/#3番/#1晩/#0晩/#2晩/
#ばんがい /#0番街/#3番街/
#ばんだい /#0番台/
#ばんち /#0番地/
#ばんて /#3番手/
#ばんどおり /#0番通り/#3番通り/
#ばんめ /#0番目/#1番目/#3番目/
#ぱーせんと /#1％;percent/#3％;percent/#0％;percent/#2％;percent/
#ぱい /#3敗/#1敗/#0敗/#2敗/#3杯/#1杯/#0杯/#2杯/
#ぱく /#0拍/#0泊/#3拍/#1拍/#2拍/#3泊/#1泊/#2泊/
#ぱこ /#3箱/#1箱/#0箱/#2箱/
#ぱっく /#0パック/
#ぱつ /#0発/#3発/#1発/#2発/
#ぱん /#3版/#1版/#0版/#2版/#3犯/#1犯/#0犯/#2犯/
#ひき /#1匹/#3匹/#0匹/#2匹/
#ひゃくねん /#3百年/
#ひょう /#0票;vote/#3票;vote/#1票;vote/#2票;vote/#3俵;たわら/#1俵;たわら/#0俵;たわら/#2俵;たわら/
#ひん /#3品/#1品/#0品/#2品/
#び /#3尾/#1尾/#0尾/#2尾/
#びーと /#0ビート/
#びき /#1匹/#3匹/#0匹/#2匹/
#びっと /#1ビット/
#びょう /#0秒/#1秒/#3秒/#0票/#2秒/#3票/#1票/#2票/
#びょうかん /#0秒間/
#びょうし /#1拍子/#3拍子/
#びん /#1便/#3便/#0便/#2便/
#ぴき /#1匹/#3匹/#0匹/#2匹/
#ぴょう /#1票/#0票/#3票/#2票/#3俵/#1俵/#0俵/#2俵/
#ぴん /#3品/#1品/#0品/#2品/
#ふ /#3符/#1符/#0符/#2符/
#ふぃーと /#3呎/#1呎/#0呎/#2呎/
#ふく /#3服/#1服/#0服/#2服/#3幅/#1幅/#0幅/#2幅/
#ふくろ /#1袋/#3袋/#0袋/#2袋/
#ふり /#3振り;刀剣類/#3振/#1振/#0振/#2振/
#ふん /#1分/#0分/#3分/#2分/
#ふん#びょう /#1分#1秒/#0′#0″/
#ふんかん /#0分間/
#ぶ /#0部/#3部/#2分/#3分/#1分/#0分/#1部/#2部/
#ぶおんぷ /#3分音符/#1分音符/#0分音符/
#ぶきゅうふ /#3分休符/#1分休符/#0分休符/
#ぶもん /#0部門/
#ぶんかつ /#3分割/
#ぶんの# /#1分の#1/#3分の#3/
#ぶんの#びょうし /#0分の#0拍子/#3分の#3拍子/#1分の#1拍子/
#ぶんや /#0分野/
#ぷ /#3符/#1符/#0符/#2符/
#ぷく /#3幅/#1幅/#0幅/#2幅/#3服/#1服/#0服/#2服/
#ぷん /#0分/#1分/#3分/#2分/
#ぷんかん /#0分間/
#へい /#3瓶/#1瓶/#0瓶/#2瓶/
#へるつ /#1Hz/#3Hz/#0Hz/#2Hz/
#へん /#0編/#1片/#0辺/#1編/#3辺/#1辺/#2辺/#3編/#2編/#3篇/#1篇/#0篇/#2篇/#3片/#0片/#2片/#3遍/#1遍/#0遍/#2遍/
#べん /#3遍/#1遍/#0遍/#2遍/
#ぺーじ /#1ページ/#0ページ/#3ページ/#0頁/#3頁/#1頁/#2頁/
#ぺん /#3片/#1片/#0片/#2片/#3辺/#1辺/#0辺/#2辺/#3遍/#1遍/#0遍/#2遍/#3編/#1編/#0編/#2編/#3篇/#1篇/#0篇/#2篇/
#ほ /#3歩/#1歩/#0歩/#2歩/
#ほう /#3包/#1包/#0包/#2包/
#ほん /#0本/#1本/#3本/#2本/
#ほんだて /#1本立て/
#ほんば /#3本場;[麻雀]/
#ぼん /#1本/#2本/#0本/#3本/
#ぽ /#3歩/#1歩/#0歩/#2歩/
#ぽん /#1本/#0本/#3本/#2本/
#ぽんど /#0ポンド/#0£;pond,pound/#3£;pond,pound/#1£;pond,pound/#2£;pond,pound/
#まい /#1枚/#0枚/#2枚/#3枚/
#まいぐみ /#0枚組/#1枚組/
#まいぶん /#0枚分/
#まいめ /#2枚目/
#まいる /#3哩/#1哩/#0哩/#2哩/
#まき /#3巻き;糸や巻物など/#1巻き;糸や巻物など/
#まく /#3幕/#1幕/#0幕/#2幕/
#まくもの /#3幕物/
#ます /#0マス/#3枡/#1枡/#0枡/#2枡/
#まん /#1万/#0万/#3万/#2万/
#まんえん /#1万円/#0万円/#3万円/
#まんごく /#3万石/
#まんねん /#3万年/
#みり /#1mm/#3粍/#1粍/#0粍/#2粍/#3mm/#0mm/#2mm/
#むね /#0棟/#3棟/#1棟/#2棟/
#めーとる /#1メートル/
#めい /#0名/#1名/#3名/#2名/
#めいさま /#3名様/
#めが /#1Mbyte/#1メガ/
#めん /#1面/#3面/#0面/#2面/
#もう /#3毛/#1毛/#0毛/#2毛/
#もじ /#1文字/#0文字/#3文字/
#もじめ /#0文字目/#1文字目/#3文字目/
#もん /#1問;question/#3門;gate/#1門;gate/#0門;gate/#2門;gate/#3問;question/#0問;question/#2問;question/#3文/#1文/#0文/#2文/
#や /#3夜/#1夜/#0夜/#2夜/
#よう /#3葉/#1葉/#0葉/#2葉/
#り /#1人/#3里/#1里/#0里/#2里/
#りーる /#1リール/#0リール/
#りゅう /#3粒/#1粒/#0粒/#2粒/
#りょう /#3両/#1両/#0両/#2両/
#りょうへんせい /#0両編成/
#りん /#1輪/#3厘/#1厘/#0厘/#2厘/#3輪/#0輪/#2輪/
#りんか /#3輪花/
#るい /#3類/#1類/#0類/#2類/#3塁/#1塁/#0塁/#2塁/
#るいだ /#2塁打/#0塁打/
#れつ /#0列/#3列/#1列/#2列/#0裂/#1裂/#3裂/#2裂/
#れつめ /#3列目/
#れん /#0連/#3連/#1連/#2連/
#れんきゅう /#1連休/
#れんしょう /#1連勝/
#れんそう /#0連装/
#れんだ /#3連打/#0連打/
#れんちゃん /#3連荘;[麻雀]/
#れんぱい /#1連敗/
#れんぱつ /#3連発/#0連発/
#れんぷ /#1連符/#3連符/#0連符/
#ろう /#3浪/#1浪/#0浪/#2浪/
#ろばん /#0路盤/
#わ /#0話/#1話/#3羽;鳥,ウサギ/#3話/#2話/#1羽;鶏1羽/#0羽;鶏1羽/#2羽;鶏1羽/#3把;葱1把/#1把;葱1把/#0把;葱1把/#2把;葱1把/
#わり /#0割/#3割/#1割/#2割/
#わりびき /#1割引/#3割引/#1割り引き/
#わりまし /#1割増/
$ /＄;dollar/¢;※cent/£;※pond,pound/
% /％/‰;※permill/パーセント/
& /＆/アンド/アンパサンド/
' /′;minute/‘/’/アポストロフィ/´;accent aigu/
'' /″;second/”;doublequote(closing)/
's /ズ/
( /（/［/『/【/〔/
(#) /（#2）/
(#)#-# /（#1）#1-#1/
) /）/］/』/】/
* /＊/※/×/
+ /＋;plus/┼;罫線/╋;罫線(太)/┿;罫線(横太)/╂;罫線(縦太)/
+- /±/
, /，/、/
- /−;minus/—;dash/‐;hyphen/─;罫線/━;太い罫線/マイナス/ー;長音/ … /〜/
-- /—;dash/——/
--- /——/
---- /——/
-: /÷/
-> /→/
-| /┤/┫/
. /．/・/。/…;.../
.# /．#1/
.. /‥/
... /…/・・・;中黒x3/……;三点ダッシュx2 →....../
...... /……/
.com /ドットコム/
.net /ドットネット/
/ /／/÷/
/. /スラッシュドット;slashdot.org/slashdot/スラド/
/= /≠/
0 /０;アラビア数字/〇;漢数字/ゼロ/zero/零/
0base /ゼロベース/
0emission /ゼロエミッション/
0metre /ゼロメートル;sea level/
0sum /ゼロサム/
0sumgame /ゼロサムゲーム;zero-sum game/
1 /１/一/壱;「一」の大字/弌;「一」の異体字/壹;「壱」の旧字/ワン/one/
10 /十/テン/ten/
100 /百/ハンドレッド/hundred/
1000 /千/サウザンド/thousand/
10^-1 /deci;[SI接頭語]/d/デシ/
10^-12 /pico;[SI接頭語]/p/ピコ/
10^-15 /femto;[SI接頭語]/f/フェムト/
10^-18 /atto;[SI接頭語]/a/アト/
10^-2 /centi;[SI接頭語]/c/センチ/
10^-21 /zepto;[SI接頭語]/z/ゼプト/
10^-24 /yocto;[SI接頭語]/y/ヨクト/
10^-3 /milli;[SI接頭語]/m/ミリ/
10^-6 /micro;[SI接頭語]/μ/マイクロ/ミクロ/
10^-9 /nano;[SI接頭語]/n/ナノ/
10^1 /deca;[SI接頭語]/da/デカ/
10^12 /tera;[SI接頭語]/T/テラ/
10^15 /peta;[SI接頭語]/P/ペタ/
10^18 /exa;[SI接頭語]/E/エクサ/
10^2 /hecto;[SI接頭語]/h/ヘクト/
10^21 /zetta;[SI接頭語]/Z/ゼタ/
10^24 /yotta;[SI接頭語]/Y/ヨタ/
10^3 /kilo;[SI接頭語]/K/キロ/
10^6 /mega;[SI接頭語]/M/メガ/
10^9 /giga;[SI接頭語]/G/ギガ/
10th /テンス/
11 /十一/イレブン/イレヴン/eleven/
12 /十二/トウェルブ/トウェルヴ/twelve/
13 /十三/サーティーン/thirteen/
14 /十四/フォーティーン/fourteen/
15 /十五/フィフティーン/fifteen/
16 /十六/シックスティーン/sixteen/
17 /十七/セブンティーン/セヴンティーン/seventeen/
18 /十八/エイティーン/eighteen/
19 /十九/ナインティーン/nineteen/
1bound /ワンバウンド;和製英語(one-hopper)/
1box /ワンボックス/
1boxcar /ワンボックスカー/
1chip /ワンチップ/
1click /ワンクリック/
1coin /ワンコイン/
1cup /ワンカップ;[商標]大関 (言い換え語:カップ酒)/
1cushion /ワンクッション;和製英語。「-置く」/
1drink /ワンドリンク/
1key /ワンキー/
1man /ワンマン/
1manlive /ワンマンライブ/
1manshow /ワンマンショー;one-man show/
1more /ワンモア;one more/
1night /ワンナイト/
1out /ワンアウト/ワンナウト/
1pattern /ワンパターン/
1phrase /ワンフレーズ/
1piece /ワンピース/ワンピ/
1point /ワンポイント/
1pointadvice /ワンポイントアドバイス/
1push /ワンプッシュ/
1rank /ワンランク/
1room /ワンルーム/
1roommansion /ワンルームマンション/
1scene /ワンシーン;one scene/
1set /ワンセット/
1shot /ワンショット/
1shoulder /ワンショルダー/
1side /ワンサイド/
1sidegame /ワンサイドゲーム/
1size /ワンサイズ/
1st /ファースト/
1staid /ファーストエイド;first-aid/
1stalbum /ファーストアルバム/
1stbase /ファーストベース/
1stclass /ファーストクラス/ファースト・クラス/
1stcontact /ファーストコンタクト/
1step /ワンステップ/
1stfly /ファーストフライ/
1stgoro /ファーストゴロ;和製語(grounder)/
1stimpression /ファーストインプレッション/
1stkiss /ファーストキス;first kiss/
1stlady /ファーストレディ/
1stmit /ファーストミット/
1stname /ファーストネーム/
1stop /ワンストップ/
1tempo /ワンテンポ;和製語/
1time /ワンタイム/
1top /ワントップ/
1touch /ワンタッチ/
1way /ワンウェイ/ワンウェー/
2 /２/二/弍;「二」の異体字/ツー/two/
20 /二十/トウェンティ/twenty/
2base /ツーベース;double/
2bass /ツーバス/
2beat /ツービート/
2by4 /ツーバイフォー/
2nd /セカンド/
2ndbase /セカンドベース/
2ndclass /セカンドクラス/
2ndfly /セカンドフライ/
2ndgoro /セカンドゴロ;和製語(grounder)/
2ndhouse /セカンドハウス/
2ndlife /セカンドライフ/
2ndopinion /セカンドオピニオン/
2out /ツーアウト/
2piece /ツーピース/
2platoons /ツープラトン/
2run /ツーラン/
2shot /ツーショット/
2step /ツーステップ/
2tone /ツートン;two-tone/ツートーン/
2tonecolor /ツートンカラー;two-tone/
2tonecolour /ツートンカラー;two-tone/
2top /ツートップ/
2way /ツーウェイ/
2x4 /ツーバイフォー/
3 /３/三/スリー/three/
30 /三十/サーティ/thirty/
3base /スリーベース;triple/
3dots /・・・;中黒x3/
3f /スリーエフ/
3m /スリーエム;www.3m.com/
3out /スリーアウト/
3piece /スリーピース/
3rd /サード/
3rdbase /サードベース/
3rdfly /サードフライ/
3rdgoro /サードゴロ;和製語(grounder)/
3rdparty /サードパーティ/サードパーティー/
3run /スリーラン/
3season /スリーシーズン;three-season/
3size /スリーサイズ;和製英語(mesurements) NB:バスト・ウエスト・ヒップ/
3star /★ ★ ★/
4 /４/四/フォー/four/
40 /四十/フォーティ/fourty/
4beat /フォービート/
4th /フォース/
5 /５/五/ファイブ/five/
50 /五十/フィフティ/fifty/
5th /フィフス/
6 /６/六/シックス/six/
60 /六十/シックスティ/sixty/
6th /シックスス/
7 /７/七/セブン/seven/
70 /七十/セブンティ/seventy/
7bridge /セブンブリッジ/
7star /セブンスター/
7th /セブンス/
8 /８/八/エイト/eight/
80 /八十/エイティ/eighty/
8ball /エイトボール;eight-ball/
8beat /エイトビート/
8mm /８ｍｍ/
8th /エイス/
9 /９/九/ナイン/nine/
90 /九十/ナインティ/ninety/
9ball /ナインボール;nine-ball/
9th /ナインス/
: /：/…/
:- /÷/
:= /≒/
< /〈;山括弧/＜;不等号/←;<-/⊂;subset/《;二重山括弧 →<</クレッシェンド;次第に強く/crescendo/
<- /←/
<-> /⇔/
<< /《;二重山括弧/≪;much smaller/
<= /≦/
<=> /⇔/
<> /≠/◇;菱形/⇔/
= /＝;equal/〓;下駄/≡;合同/
=/ /≠/
=: /≒/
=> /⇒/》/
=| /〒/
> /〉;山括弧/＞;不等号/→/⇒/》;二重山括弧 →>>/≫;much larger/アクセント;その音を特に強く/accent/ディミヌエンド;次第に弱く/diminuendo/デクレッシェンド;次第に弱く/decrescendo/
>= /≧/
>> /》;二重山括弧/≫;much larger/
>あい /愛/
>あじ /味;醤油味,薄塩味/
>あつ /圧;(pressure) 脳圧,内部圧,人口圧/
>あて /宛/
>あと /跡;火傷跡,焚火跡,西郷邸跡/痕/後;もう20分後,死に後/
>あまり /余り/
>あん /案/
>い /委;(委員会) 欧州委/医/
>いか /以下;300円-/
>いがい /以外;関係者-,彼女-,麺類-/
>いき /域/行き/行/
>いくさ /軍;複合時はほとんどがこの字。「船軍,馬軍,死に軍」/
>いこう /以降;19世紀-,来月-/
>いご /以後/
>いじょう /以上;18才-/
>いぜん /以前;石器時代-,就任-/
>いち /市/
>いっしき /一式;道具-,書類-/
>いっしょく /一色;万博-,戦争-/
>いったい /一帯/
>いっぱ /一派/
>いっぱい /一杯;胸-,夢-,茶碗-/
>いない /以内;４位-,300円-/
>いらい /以来;建国-,結成-,十九世紀-/
>いろ /色/
>いん /員/印;銀行印,風景印,蔵書印/因;心因,内在因,究極因/
>うえ /上;兄上,1学年上(年齢),宮島口上(住所)/
>うじ /氏/
>うす /薄;期待薄,望み薄,可能性薄/
>うまれ /生まれ;博多-,満州-/
>うら /裏;路地裏,体育館裏,9回裏/
>え /絵;歌仙絵,役者絵/会;(集会) 香会,華厳会,菖蒲会/
>えいぎょうしょ /営業所/
>えき /駅/益;純益,売却益,営業益/液;電解液,除光液,標準液/
>えん /園/塩;硝酸塩,酸性塩,食卓塩/炎/宴;(party) 詩宴,曲水宴,花見宴/
>おう /王;長屋王,二冠王,遅刻王/
>おき /沖;十勝沖,島根県沖,台湾沖/置き;(間隔) 2時間-,三日-,４年-/
>おもて /表;畳表,3回表,江戸表/
>おやかた /親方/
>おり /織;西陣織,博多織,透かし織/
>おん /音/
>か /化/下/科/課/家/可/歌/禍;薬禍,女禍,文字禍/
>かい /会/界/回/階/海/解;(solution) [極最][大小長短]-/
>かいし /開始/
>かぎり /限り/
>かく /格;主役格,主犯格,城主格/核/角;同位角,結合角,変形角,２四角(将棋)/
>かぜ /風;向い風,先輩風,解散風/
>かた /方/型/過多;胃酸-,在庫-,自慰-/
>かてい /過程;(process) 崩壊-,構築-,移行-/
>かのう /可能/
>かぶ /下部;胴体-,組織-/
>かん /感;(sense) 躍動感/観;(view) 歴史観/間/館/官/刊;岩波書店刊,大正６年刊/艦/管/缶/
>かんきょう /環境;経済環境,再生環境/
>かんび /完備;寮-,空調-,託児所-/
>が /画/
>がい /街/外/
>がお /顔;(連濁) 思案顔,呆れ顔,得意顔/
>がかり /係;飼育係,相談係,お客様係/
>がく /学;法人類学,社会政策学,品質管理学/額;預金額,負債額,債務額/
>がくと /学徒/
>がしら /頭;(top)潮頭,(leader)人足頭,数奇屋頭/
>がた /型;(type)量産型,紋切り型/形;(form)亀甲形,短冊形,三日月形/方;八割方,豊臣方,夕暮れ方/
>がっか /学科;物理-/
>がま /窯;焼き物を焼くかま。「瓦窯」/釜;湯を沸かすかま。「茶釜」/
>がみ /紙/
>がら /柄;花柄,格子柄,職業柄/
>がわ /側/革/皮/
>がん /眼;鑑識眼,審美眼,遠視眼/
>き /器;(instrument) 抽籤器/機;(machine)印刷機, (chance)逆転機/期;period/記;(記録) 釣行記,魚服記/鬼;殺人鬼,隠形鬼(おんぎょうき),食人鬼/旗;flag/忌;開山忌,桜桃忌(太宰治の命日),十三回忌/紀;(紀律)校紀, (時代)帝紀,第４紀/
>きかん /期間/
>きごう /記号;合同-,ト音-/
>きじゅん /基準;業界-,採録-/
>きち /基地;普天間-,米軍-,秘密-/
>きのう /機能;通信-,代表-/
>きゃく /客;買物客,旅行客,乗船客/
>きゅう /級/宮;(宮殿)平安宮, (天宮)天蠍宮/
>きょう /教/強/狂;(-mania) 色情狂,映画狂,政治狂/卿;枢機卿,護国卿,陸軍卿/境;夢幻境,人外境,三昧境/郷;(土地)温泉郷,(境地)酔郷,理想郷/
>きょく /局/
>きん /筋;上腕筋,肋間筋,呼吸筋/禁;１８禁,転載禁,四重禁/菌;納豆菌,梅毒菌,好熱菌/金;見舞金,一時金,手切れ金/
>きんこう /近郊/
>きんし /禁止;侵入-,駐停車-/
>きんぺん /近辺/
>ぎ /儀;地球儀,月球儀,天球儀/着/技;(technique) 画技,筆技,舌技/
>ぎみ /気味;自嘲-,風邪-/
>ぎょう /業;輸入業,販売業,回収業/
>ぎん /銀;(銀行の略称) 兵庫銀,東京三菱銀/
>く /区/苦;二重苦,惑業苦,借金苦/
>くみ /組/
>くらい /位/
>くん /君/訓;師訓,人生訓,熟字訓/
>ぐ /具;茶具,装身具,剣道具/
>ぐう /宮/
>ぐち /口/
>ぐつ /靴/
>ぐみ /組/組み/
>ぐん /郡;†(county)/群;†(group)/軍;女性軍,共和国軍/
>け /家/
>けい /系/形/型/計;温度計,電位計,体脂肪計/刑;絞首刑,斬首刑,石打ち刑/
>けいさつしょ /警察署/
>けいすう /係数;摩擦-,温暖化-/
>けいゆ /経由;高崎-,香港-/
>けいゆう /経由;=けいゆ/
>けん /権/圏;(bloc) 勢力圏,フランス語圏/券;(ticket) お米券/研;(研究所) 佐藤研,ベル研/拳;酔拳,百裂拳,薩摩拳/県/兼/
>けんじん /県人;栃木-/
>げ /気;楽し気,危な気,親し気/下;正五位下/
>げい /芸;足芸,一発芸,座敷芸/
>げき /劇/
>げん /減;(decrease) 税収減,収入減/源;(source) 動力源,エネルギー源/
>げんしょう /現象;心霊-,老化-,毛細管-/
>げんてい /限定/
>こ /個/庫/
>こう /港/工;旋盤工,写植工,板金工/高/口/稿;最終稿,未定稿/
>こうい /行為;裏切り-,反逆-,違反-/
>こうか /効果;節電-,ノーベル賞-,減税-/
>こうき /後期;明治-,博士-/
>こうこう /高校;徳島-,農業-/
>こうざ /講座/
>こうじょ /控除;扶養-,雑損-/
>こうない /構内;上野駅-,東大-,研究所-/
>こうにん /公認;民主党-/
>こうりつ /効率/
>こく /国/
>こつ /骨/
>こゆう /固有/
>こん /婚/
>ご /後/語/
>ごう /号/郷;(昔の行政区画)白川郷,十津川郷,白崎郷/
>ごえ /声/
>ごと /毎/事/
>ごろ /頃/
>さ /差/
>さい /歳;(年齢)/才/斎;(雅号) 六無斎,稗田八方斎/祭/
>さいかい /再開/
>さき /先/
>さく /策/作;鴎外作,苦心作/
>さま /様/
>さん /産/山/酸/
>ざ /座/
>ざい /剤/罪/材;集成材,黄楊材,檜材/財;(goods)代替財,文化財,自由財/
>ざいじゅう /在住/
>ざけ /酒/
>ざま /様;昔様,死に様,振り向き様/
>ざら /皿/
>ざん /残;収支-,支払-,信用-/
>し /市/氏/誌/紙/視/師/史/士;弁理士,救命士,代理士/死;毒死,腹上死,悶絶死/司;斎院司,児童社会福祉司,少年保護司/子/詞;言詞,指示詞,女性詞/
>しかく /資格;在留-,調理師-/
>しき /式/職;中宮職(律令制),大工職/
>ししゃ /支社;大阪-,函館-/
>しじょう /市場;大豆-,香港-,買手-/
>しせつ /施設;音響-,排水-,軍事-/
>した /下/
>しだい /次第;(up to) 状況-,君-, (完了)出来-/
>しつ /室/質;蛋白質,粘液質/
>してん /支店/
>しぶ /支部;名古屋-,中国-/
>しぼう /志望;第二-,画家-/
>しゃ /者/車/
>しゅ /主;造物主,救世主,先入主/手/酒/腫/
>しゅう /集/州/宗;法華宗,修験宗,三論宗/臭;素人臭,腐敗臭/衆;一向衆,玄人衆,職人衆/
>しゅうだん /集団/
>しゅうへん /周辺/
>しゅうりょう /終了/
>しゅぎ /主義/
>しゅぎしゃ /主義者;(-ist) 至上-,民族-,敬虔-/
>しゅしょう /首相;東条-,中国-/
>しゅっしん /出身/
>しゅどう /主導;政治-,民間-/
>しょ /書/所/署;小松川-,湾岸-/
>しょう /症/証/省/商/賞/小;(「小学校」の略)池田-,泉台-/相;(大臣) 厚労相,司法相,情報相/匠;(craftspeople) 織匠(おりしょう・しょくしょう),彫匠,剣匠/
>しょうがい /障害;意識-,[腎肝]機能-/
>しょき /初期;昭和-,離乳-,発病-/
>しょく /色;独自色,政治色,小泉色/食;宇宙食,療養食,減塩食/職;首相職,課長職,一般職/
>しょとう /初頭;19世紀-,2038年-/
>しよう /仕様;寒冷地-,輸出-/
>しん /心;愛郷心,反米心,不動心/審/
>じ /時/路;家路,木曽路,甲州路/辞;接尾辞,限定辞,形容辞/地;漆地,木綿地/
>じかん /次官;国務-,財務-,農水-/
>じく /軸;地軸,結晶軸,再編軸/
>じこう /事項;補足-,確認-,免責-/
>じしん /自身;私-,人物-,首相-/
>じたい /自体/
>じだい /時代;幼年-,田沼-,アケメネス朝-/
>じてん /辞典/
>じま /島/
>じゃく /弱/尺/
>じゅう /中/
>じゅく /塾;画塾,書道塾,英語塾/
>じゅつ /術/
>じゅん /順/
>じょ /所/
>じょう /上/状/場/嬢;鶯嬢,(人名一般に付いて)静香嬢/
>じょうきょう /状況;被害-,活動-,出願-/
>じょうしょう /上昇;価格-,沸点-/
>じょうせい /情勢;チェチェン-,中東-,経済-/
>じょうたい /状態;健康-,泥酔-,潰滅-/
>じょうぶ /上部;大腿-,機体-/
>じょし /女史;女性に付ける敬称。「中根-」/
>じる /汁/
>じん /人/陣/
>す /酢;辛子酢,合成酢,醤酢/
>すい /水;汚染水,処理水,環流水/
>すう /数/
>すえ /末;来月末/
>すじ /筋;外交筋,投機筋,牛筋/
>すんぜん /寸前;爆発-,卒倒-/
>ず /図/酢/
>ずく /尽く;欲-,相対-/
>ずみ /済/
>せい /性;絵画性/制;(system) 会員制/製;(made in,by) 中国製/生;(学生) 早大生/
>せいけん /政権;軍事-,大平-,民主党-/
>せいど /制度;奴隷-,返金-,安全保障-/
>せき /籍;日本籍,中国籍/席;優先席,無料席,可動席/
>せつ /説/
>せん /戦;(battle,game) 中盤戦,対米戦/線;(line)山手線,絶縁線/腺;[解剖](gland) 汗腺,唾液腺/選;(選挙)参院選, (選集)名詩選/専;商専(商業専門学校),売り専,熟女専/船;貨物船,日本船/
>せんこう /専攻;応物-,印哲-,18世紀-/先行;人気-,理論-,黒星-/
>せんしゅう /専修;露文-/
>せんせい /先生/
>せんよう /専用;自分-/
>ぜい /税/勢/
>ぜん /然;超然,紳士然,大家然(たいかぜん)/前;紀元前,出生前,使用前/膳;祝膳,酒肴膳,(料理のコース名)[松竹梅花]膳,海の幸膳/善;絶対善,公共善,至高善/
>ぜんき /前期;2007年度-,東大-/
>ぜんご /前後;(概数) 20人-/
>ぜんしゅう /全集/
>ぜんたい /全体/
>そ /素;語彙素,韻律素(prosodeme),繊維素/
>そう /層/相/槽/僧;帰依僧,学問僧,破戒僧/奏/
>そうそう /早々/
>そうとう /相当;三億円-/
>そうほう /双方;日中-,当事者-/
>そく /則/
>そだち /育ち;街-,和歌山-/
>そつ /卒;京大卒,理学部卒/
>そん /損;純損,累損,含み損/尊/
>ぞい /沿/
>ぞう /像;女性像,二宮尊徳像/増;税収増,前年比増/蔵;個人蔵,○○美術館蔵/贈/
>ぞく /族/
>ぞん /損;(連濁) 丸損,聞き損,評価損/
>たい /帯/隊/態;(voice) 受動態,中間態,可能態/対;巨人対阪神,信号対雑音比/
>たいおう /対応/
>たいこう /対抗;地域-,都市-,企業-/大綱;防衛-,戦略-,改革-/
>たいしょう /対象;蒐集-,攻撃-/
>たいせい /態勢;臨戦-,着陸-,支援-/体制;安保-,量産-,小泉-/
>たく /宅;部長宅,鈴木宅,被害者宅/
>たけ /茸;榎茸,一夜茸,山鳥茸/
>たち /達/
>たて /立て;出来-,洗い-,脱ぎ-/
>たん /譚/
>たんい /単位/
>たんとう /担当;営業-,人事-,入力-/
>だ /打;殊勲打,逆転打,有効打/
>だい /台/大/代/
>だいがく /大学/
>だか /高/
>だけ /岳/
>だん /談/団/
>ち /値/地/知;経験知,絶対知,直観知/
>ちく /地区;名古屋-,南部-/
>ちほう /地方;熱帯-,東北-/
>ちゃ /茶;白茶,人参茶,健康茶/
>ちゃく /着;成田着,香港着,空港着/
>ちゅう /中/注/
>ちゅうし /中止/
>ちょ /著;漱石著,高橋源一郎著/
>ちょう /町/長/調/超/帳;出納帳,漢字練習帳,料理帳/庁/
>ちょうか /超過;債務-,輸出-/
>ちょく /直;市場直,左直(野球)/
>ちょくご /直後/
>ちょくぜん /直前/
>ちん /賃;乗車賃,床屋賃,貸し賃/
>つい /対/
>つう /通;(expert)事情通/痛;(pain)神経痛/
>つき /付き/付/
>づき /付き/
>づら /面/
>づれ /連れ;(男|女|子供|家族)-/
>てい /邸/亭;三遊亭,好文亭/艇;上陸艇,掃海艇,消防艇/体;職人体/
>ていか /低下;学力-,価格-/
>ていし /停止;供給-,営業-/
>ていしょく /定食;酢豚-,唐揚-/
>ていど /程度/
>てき /的/
>てん /点/展/
>で /出;(出身) 大学出,音大出,法学部出/
>でん /殿;大安殿(だいあんでん),神楽殿,弘徽殿/伝;八犬伝,西域伝,漱石伝/
>と /都/徒;政治学徒/
>とう /等/党;労働党,大衆党,猫党(≒-好き)/棟;(building) 高層棟,居住棟/
>とうしょ /当初;発足-,制定/
>とうじ /当時/
>とうりょう /当量;(equivalent) 仕事-,化学-/
>とくゆう /特有/
>とどけ /届;婚姻届,退学届/
>とも /共/
>ど /度/土;構造土,砂壌土,珪藻土/
>どう /道/堂;郁文堂,六角堂,御影堂/
>どうし /同士/
>どうぜん /同然/
>どき /時;(連濁) 飯時,日暮時,辞め時/
>どくじ /独自/
>どくとく /独特/
>どころ /所/
>どの /殿/
>ども /共;男共,女共,雑魚共/
>どん /丼;親子-,カツ-,天-/
>ない /内/
>ないぞう /内蔵;電池-/
>なか /仲;恋仲,夫婦仲,兄弟仲/
>ながら /乍ら;(接続助詞)「歩き乍ら」「若い乍らも」/
>など /等/
>なみ /並み/並;馬並,世間並/
>なり /也/
>に /似;父親似,女優似,広末似/煮;大和煮,甘辛煮,炒め煮/
>ぬし /主;荷主,企業主,落し主/
>ね /音;色音,若音,忍び音/
>ねがい /願/
>ねつ /熱;気化熱,進学熱,地中熱/
>のう /能/
>は /派/波;電磁波,正弦波,第二波/
>はい /杯/拝;(書簡などで自分の名に付す) 夏目拝/
>はく /博/泊;(宿泊) 会社泊,現地泊,那覇泊/
>はだ /肌;乾燥肌,姉御肌,天才肌/
>はつ /発/初;世界初,青森初/
>はば /幅/
>はん /半/班/版/藩/
>はんい /範囲;行動-,出題-/
>ば /場;重力場,問屋場,公事場/
>ばい /倍/
>ばつ /閥;東大閥,官僚閥/
>ばなし /話/
>ばん /版;†(edition) 決定版,岩波版/盤;†(disk,board) 再発盤,将棋盤/判;†(size) 四六判,キャビネ判/
>ひ /比/費/
>ひつ /筆;(written by) 定家筆,天皇筆/
>ひょう /表/票/評;映画評,人物評,辛口評/
>ひん /品/
>び /日/美;肉体美,造形美,脚線美/
>びょう /病/
>ふ /府/
>ふう /風/
>ふか /不可/
>ふきん /付近;現場-,御徒町-/
>ふじん /夫人;社長-,鈴木-/
>ふぜい /風情;(軽蔑)役人-,(卑下)私-/
>ふのう /不能;修復-,観測-/
>ふん /墳/
>ぶ /部/
>ぶつ /物/
>ぶり /振り;(三日|数ヶ月|5年)-/
>ぶん /分;三日-/文;sentence/
>へい /兵;擲弾兵,人民兵,負傷兵/
>へき /壁;(wall) 防音壁,火口壁,子宮壁/癖;(habit) 病癖,妄想癖,逃避癖/
>へん /編;(あむこと)/篇;(あまれたもの) 天国篇,地獄篇,東北篇/
>べ /部;語り部,酒部,(部曲)大伴部/辺;岸辺,寄辺,船辺/
>べつ /別/
>べん /弁/
>ほ /補;(assistant) 警部補,次官補/舗;(shop) 菓子舗,佃煮舗,新聞舗/
>ほう /法/砲;迫撃砲,対戦車砲,無反動砲/
>ほうめん /方面/
>ほど /程/
>ほんい /本位;金-,お客様-/
>ぼ /簿/
>ぼう /某;(匿名)田中某,中島某/坊;(僧侶)正覚坊,風来坊,懲罰房/房;(部屋)雑居房,居住房,懲罰房/帽;(帽子) 学生帽,安全帽,婦人帽/
>ぼうし /防止;事故-,盗難-/
>ぼく /木;封印木,接骨木,旅人木/
>ぼん /本/
>ま /間;(space)切れ間,(room)応接間,伊勢間/魔;記録魔,強姦魔,切り裂き魔/
>まい /枚/
>まえ /前/
>まち /町/
>まっき /末期;室町-,妊娠-/
>まつ /末;19世紀末,年度末/
>まで /迄;明日迄,何所迄/
>まる /丸;(船舶名)海王丸,福竜丸,(幼名)日吉丸/
>み /味;外連味,皮肉味,苦味(NB:形容詞語幹につく場合「味」は当て字)/
>みすい /未遂;強盗-,傷害-/
>みん /民/
>むき /向き;[東西南北]-,(子供|大人|[男女]性)-/
>むけ /向け;(成人|企業|開発者)-/
>むひ /無比;強力-,壮大-,痛快-/
>むら /村/
>め /目;三日目,細目(NB:形容詞語幹につき傾向を表す場合「目」は当て字)/
>めい /名/
>めいぎ /名義/
>めん /面/
>もう /網/
>もく /目/
>もと /元/
>もの /物;輸入物,人情物/者;薄情者,伊賀者/
>もん /紋;(紋所) 九曜紋,三つ紋 (文様) 竜紋,鹿の子紋/門;(gate)玄武門,(門下生)蕪村門,[生物]触手動物門/
>や /屋/野;(大脳皮質の)感覚野,聴覚野,視覚野/
>やく /役;越後屋役,調整役,懸賞役/訳;仏語訳,大學訳/薬;頭痛薬,民間薬/
>やす /安;割安,反動安,10円安/
>ゆ /湯;腰湯,生姜湯,蜜柑湯/油;白樺油,肉桂油,不乾油/
>ゆえ /故;病弱-/
>ゆき /行き/行/
>よ /余;百人余,三年余/
>よう /用/様;唐様,天竺様,言い様/
>ようご /用語;宗教学-,連珠-/
>ようひん /用品;介護-,スポーツ-/
>よく /欲;色欲,征服欲,支配欲/翼/浴/
>よこ /横;玄関横,銀行横,画面横/
>よてい /予定/
>よぼう /予防;虫歯-,性病-/
>より /寄り;[東西南北上下左右町海]-/
>らい /来;三年来,入社来,昨年来/
>らん /欄/
>り /裡;(〜のうちに)秘密裡,盛況裡,無意識裡/裏;秘密裏,極秘裏,隠密裏/吏;(役人) 執行吏,税関吏,官公吏/理;理学部/
>りつ /率;(ratio) 換算率,死亡率/立/律;(law) 因果律,五言律,自然律/
>りゃく /略;前文略,敬称略/
>りゅう /流;二刀流,火砕流,仙波流/瘤/
>りょう /料/量/領;日本領,松平領/陵;(墓地) 天皇-,中山-(孫文),武蔵野-(昭和天皇)/
>りょく /力/
>るい /類/
>れい /例/令;戒厳令,禁止令,待機令/
>れき /歴;(history) 運転歴,離婚歴/暦;(calendar) 宇宙暦,寛政暦,自然暦/
>ろ /炉;電気炉,反応炉,溶融炉/路/
>ろう /郎;(男性名作成用)/
>ろく /録/
>ろん /論/
>わ /羽/
>わき /脇/
>わく /枠;深夜枠,自由枠,広告枠,2人枠/
>わざ /技;(technique) 腰技,包丁技,対空技/
>わん /湾;若狭湾,諫早湾/
? /？/
@ /＠/
A /Å;†angstrom/Α;†Alpha/А;†(Cyrillic)/アンペア;電流の単位,SI基本単位/
ACM /Abstract Control Model;USB/
AIDS /エイズ/後天性免疫不全症候群/
ALFEE /アルフィー/
AND /論理積/
AP /アプリケーション/
Adam /アダム/
Alpha /Α/
America /アメリカ/
April /エイプリル/
Arbeit /アルバイト/
Atena /アテナ/
Audrey /オードリー/
Australia /オーストラリア/
B /Β;Beta (Greek)/Б;Be (Cyrillic)/
B-spline /Ｂ−スプライン/
BBQ /バーベキュー/
BKK /バンコク/
BSE /Bovine Spongiform Encephalopathy/
Bach /バッハ/
Barbara /バーバラ/
Barium /バリウム/
Be /Б;Cyrillic/
Benedict /ベネディクト/
Benz /ベンツ/
Berkeley /バークレー/
Beryl /ベリル/
Beta /Β/
Bezier /ベジエ/
Biff /ビフ/
Bonjours /ボンジュール;※Bonjour?/
Booby /ブービー/
Box /□/
Brown /ブラウン/
Budapest /ブダペスト/
CD /コンパクト・ディスク/Compact Disk/
CDC /Communication Device Class;USB/
CISC /複雑命令セット計算機/Complex Instruction Set Computer/
CORBA /Common Object Request Broker Architecture;アプリケーションを異なる言語・プロセス・OS間で動作させるための規格。プログラミング言語がCORBAを利用するためにIDLを使う。OMGが策定した。/
CS /コミュニケーションサーバ/
CTC /伊藤忠テクノサイエンス/
Caesar /シーザー/カエサル/
Calbee /カルビー/
Camille /カミーユ/
Carter /カーター/
Ch /Ч;Cha (Cyrillic)/
Cha /Ч;Cyrillic/
Chanel /シャネル/
Charlie /チャーリー/
Chi /Χ/
Chlamydia /クラミジア/
Christ /キリスト/
Christmas /クリスマス/
Claire /クレール/
Claudel /クローデル/
Constantine /コンスタンチン/
Crea /クレア/
Cyrillic /А;A/Б;Be/В;Ve/Г;Ge/Д;De/Е;Je/Ё;Jo/Ж;Zhe/З;Ze/И;I/Й;I-kratkoje (J)/К;Ka/Л;El/М;Em/Н;En/О;O/П;Pe/Р;Er/С;Es/Т;Te/У;U/Ф;Ef/Х;Xa/Ц;Tse/Ч;Cha/Ш;Sha/Щ;Scha/Ъ;Znak (Tvjordyj znak)/Ы;Y/Ь;Znak (Xjaxkij znak)/Э;E/Ю;Ju/Я;Ja/
D /Δ;Delta/Д;De (Cyrillic)/
DB /データベース/
DBA /データベース管理者/
DBMS /dbms/
DOM /Document Object Model;W3C/
DTD /Document Type Definition;XMLドキュメントのデータ構造を定めたもの。/
Daffy /ダフィー/
Dagger /ダガー/
De /Д;Cyrillic/
Delta /Δ/
Deutschland /ドイツ/独逸/
Diamond /◇;菱形/◆;菱形/
Dick /ディック/
Disney /ディズニー/
E /Ε;Epsilon/Э;Cyrillic/
EE /Η;Eta/
Edinburgh /エディンバラ/
Edward /エドワード/
Ef /Ф;Cyrillic/
Egypt /エジプト/
El /Л;Cyrillic/
Elizabeth /エリザベス/
Em /М;Cyrillic/
En /Н;Cyrillic/
Epsilon /Ε/
Er /Р;Cyrillic/
Es /С;Cyrillic/
Eskimo /エスキモー/
Esquimau /エスキモー/
Eta /Η/
Euro /ユーロ/
Europa /ヨーロッパ/
Eve /イブ/
Evil /エビル/
F /Φ;†Phi (Greek)/Ф;†Ef (Cyrillic)/
FEN /極東放送/Far East Network/
FSF /Free Software Foundation/
Fourier /フーリエ/
Franken /フランケン/
Frankenstein /フランケンシュタイン/
G /Γ;†Gamma (Greek)/Г;†Ge (Cyrillic)/
GHQ /総司令部/連合国軍総司令部/General Headquarters/
GLPL /GNU Library Public License/
GPL /GNU General Public License;(concat "http:\057\057www.gnu.org\057licenses\057gpl.ja.html")/
GUI /グラフィカルユーザインタフェース/
GW /ゲートウェイ/
Gamma /Γ/
Ge /Г;Cyrillic/
George /ジョージ/
Giants /ジャイアンツ/
Giraffu /ジラフ;※giraffe?/
Goddard /ゴダール;Godard?/
Greek /Α;Alpha/Β;Beta/Γ;Gamma/Δ;Delta/Ε;Epsilon/Ζ;Zeta/Η;Eta/Θ;Theta/Ι;Iota/Κ;Kappa/Λ;Lambda/Μ;Mu/Ν;Nu/Ξ;Xi/Ο;Omicron/Π;Pi/Ρ;Rho/Σ;Sigma/Τ;Tau/Υ;Upsilon/Φ;Phi/Χ;Chi/Ψ;Psi/Ω;Omega/
Grimm /グリム/
Guile /ガイル/
HP /ヒューレット・パッカード/
HTML /Hyper Text Markup Language;W3C/
Harvard /ハーバード/
Henry /ヘンリー/
Hudson /ハドソン/
Hungarian /ハンガリアン/
Hungary /ハンガリー/
I /Ι;Iota/アイ/И;Cyrillic/
I'm /アイム/
I-kratkoje /Й;Cyrillic/
IBM /アイ・ビー・エム/日本アイ・ビー・エム株式会社/
ICU /国際基督教大学;International Christian University/
IDFT /逆離散フーリエ変換;Inverse Discrete Fourier Transform/
IDL /Interface Definition Language;CORBAオブジェクトをコールするために必要な情報を提供する。/
ISO /国際標準化機構;International Organization for Standardization/
Indian /インディアン/
Internet /インターネット/
Iota /Ι/
Itriangle /▽/
J /Й;Cyrillic(I-kratkoje)/
JICC /ＪＩＣＣ出版;[出版社名]/
JIP /日本電子計算;www.jip.co.jp/
JISC /日本工業標準調査会;www.jisc.go.jp/
Ja /Я;Cyrillic/
Jadeite /ジェダイト/
James /ジェームス/
Jamiroquai /ジャミロクワイ;ミュージシャン,バンド名/
Jane /ジェーン/
Je /Е;Cyrillic/
Jenny /ジェニー/
Jimmy /ジミー/
Jo /Ё;Cyrillic/
Joe /ジョー/
John /ジョン/
Jr. /ジュニア/
Ju /Ю;Cyrillic/
Julian /ジュリアン/
Julie /ジュリー/
Jupiter /ジュピター/
K /Κ;†Kappa (Greek)/К;†Ka (Cyrillic)/ケルビン;(kelvin)熱力学温度の単位,SI基本単位/Χ;※(KH) Chi/
KH /Χ;Chi/
Ka /К;Cyrillic/
Kappa /Κ/
Katze /カッツェ/
Kh /Х;Xa (Cyrillic)/
Kiki /キキ/
Knuth /クヌース/
Kodak /コダック/
Kunzite /クンツァイト/
L /£;pond/Λ;Lambda/Л;El (Cyrillic)/
LPF /ローパス・フィルタ/
Lagrange /ラグランジュ/
Lambda /Λ/
Laura /ローラ/
Lebesgue /ルベーグ/
Lilliput /リリパット/
Linus /ライナス/
Lolita /ロリータ/
London /ロンドン/
Los_Angeles /ロサンゼルス/
Lucy /ルーシー/
Lynch /リンチ/
M /Μ;†Mu (Greek)/М;†Em (Cyrillic)/
ML /メイリングリスト/メーリングリスト/
MPT /マルチポートトランシーバー/
MSA /マイクロソフトウェア　アソシエイツ/マイクロソフトウェアアソシエイツ/日米相互防衛援助協定/Micro Software Associates/
Mach /マッハ/
Manhattan /マンハッタン/
Marcica /マーシカ/
Marie /マリー/マリ/
Mario /マリオ/
Mars /マーズ/
Martha /マーサ/
Martin /マーティン/
Mary /メアリ/
Melby /メルビー/
Mercury /マーキュリー/メルクリウス/
Miami /マイアミ/
Michael /マイケル/
Mickey /ミッキー/
Microsoft /マイクロソフト/
Milky /ミルキー/
Minerva /ミネルヴァ/
Motorola /モトローラ/
Mr. /ミスター/
Mrs. /ミセス/
Ms. /ミズ/
Mu /Μ/
N /Ν;Nu/Н;En (Cyrillic)/
NEC /日本電気/
NFS /Network File System/
NRT /成田/
NTT /日本電信電話/
NY /ニューヨーク/
Nausicaa /ナウシカ/
Nephrite /ネフライト/
Neuman /ノイマン/フォン・ノイマン/ヤーノッシュ・フォン・ノイマン/
Newsweek /ニューズウィーク/
Nijmegen /ナイメヘン/
Norman /ノルマン/
Norway /ノルウェー/
Nu /Ν/
O /Ο;†Omicron/О;†(Cyrillic)/Ω;※(OO) Omega/
OMG /the Object Management Group;CORBA策定のためのフレームワークを提供するために組織された。/(concat "http:\057\057www.omg.org\057")/
OO /Ω;Omega/
OR /オペレーションズリサーチ/論理和/
OS /オペレーティングシステム/
Olympic /オリンピック/
Omega /Ω/
Omicron /Ο/
Oo /◎/
P /Π;†Pi (Greek)/П;†Pe (Cyrillic)/
PH /Φ;Phi/
POA /Portable Object Adapter/
PS /P.S./Ψ;Psi/
Palabora /パラボーラ/
Patty /パティ/
Pe /П;Cyrillic/
Peanuts /ピーナッツ/
Peter /ピーター/ピョートル/ペーター/
Phi /Φ/
Philips /フィリップス/
Pi /Π/
Polaroid /ポラロイド/
Psi /Ψ/
R /Ρ;†Rho (Greek)/Р;†Er (Cyrillic)/
RDB /関係データベース;relational database/
RE /正規表現;regular expression/
RISC /限定命令セット計算機/Restricted Instruction Set Computer/
RPC /Remote Procedure Call/
RPG /ロールプレイングゲーム/
Rana /ラナ/
Rho /Ρ/
Richard /リチャード/
Ritchie /リッチー/
Robert /ロバート/ロベルト/
Robin /ロビン/
Rose /ローズ/
Russia /А;→Cyrillic/Б/В/Г/Д/Е/Ё/Ж/З/И/Й/К/Л/М/Н/О/П/Р/С/Т/У/Ф/Х/Ц/Ч/Ш/Щ/Ъ/Ы/Ь/Э/Ю/Я/
S /Σ;Sigma/С;Es (Cyrillic)/
SAX /The Simple API for event-based XML parsing/
SFO /サンフランシスコ/
SPA /製造小売業;繊研新聞社のデスク山崎光弘氏が翻案した略語/Specality Store Retailer of Private Label Apparel/
Sailormoon /セーラームーン/
Saint /聖/
Sally /サリー/
Sandy /サンディー/
Sappho /サッフォー/
Scha /Щ;Cyrillic/
Scotch /スコッチ/
Sh /Ш;Sha (Cyrillic)/
ShSh /Щ;Scha (Cyrillic)/
Sha /Ш;Cyrillic/
Sheena /シーナ/
Shsh /Щ;Scha (Cyrillic)/
Sibip /シビップ/
Sigma /Σ/
Singapore /シンガポール/
Sony /ソニー/
Square /□/
Stallman /ストールマン/
Suesan /スーザン/
Sweden /スウェーデン/
Sylpheed /シルフィード/
T /Τ;†Tau (Greek)/Т;†Te (Cyrillic)/
TA /ターミナルアダプタ/
TDL /東京ディズニーランド/
TH /Θ;Theta/
TV /テレビ/
Tau /Τ/
Te /Т;Cyrillic/
Theta /Θ/
Ti /Ｔｉ/
Tiananmen /天安門/
Tibet /チベット/
Toppe /トッピー/
Toronto /トロント/
Ts /Ц;Tse (Cyrillic)/
Tse /Ц;Cyrillic/
Turing /チューリング/
U /Υ;Upsilon/У;Cyrillic/
Unisys /ユニシス/
Upsilon /Υ/
V /В;Ve (Cyrillic)/
Valentine /バレンタイン/
Ve /В;Cyrillic/
Vega /ベガ/
Venus /ビーナス/ビィーナス/
Versailles /ベルサイユ/ヴェルサイユ/
Vietnam /ベトナム/
W3C /The World Wide Web Consortium/
WG /ワーキンググループ/
WS /ワークステーション/
WW# /第#2次世界大戦/
WW1 /第一次世界大戦/歐州大戰;旧字/
WW2 /太平洋戦争/第二次世界大戦/大東亜戰爭;旧字/
Watson /ワトソン/
X /Ξ;Xi/Х;Xa (Cyrillic)/
XEROX /ゼロックス/
XML /Extensible Markup Language/
Xa /Х;Cyrillic/
Xi /Ξ/
Y /Υ;Upsilon/Й;Cyrillic(I-kratkoje)/Ы;Cyrillic/
Yapoos /ヤプーズ/
Ye /Е;Cyrillic/
Yo /Ё;Cyrillic/
Yu /Ы;Y (Cyrillic)/
Z /Ζ;Zeta/З;Ze (Cyrillic)/
Ze /З;Cyrillic/
Zeta /Ζ/
Zh /Ж;Zhe (Cyrillic)/
Zhe /Ж;Cyrillic/
Znak /Ъ;Cyrillic(Tvjordyj znak)/Ь;Cyrillic(Xjaxkij znak)/
Zoisite /ゾイサイト/
[ /［/【/〔/『/
[[ /『/
[] /□/
\ /＼/¥/
\/ /∨/
] /］/】/〕/』/
]] /』/
^ /↑/∧/アクセント;その音を特に強く/accent/
^^ /↑/
^v /↓/
_ /＿/　;全角スペース/
` /‘;singlequote/｀;accent grave/
`` /“/
a /α;alpha/エー/エイ/アー;(独語)/а;cyrillic/ア/
a# /A#0/Ａ#1/
a#size /A#0サイズ/Ａ#1サイズ/
a4 /Ａ４/
aaa /トリプルA/
aachen /アーヘン/
aalen /アーレン/
aalto /アールト/
aaron /アロン/アーロン/
abacus /アバカス/
abba /アバ/
abbado /アバド/
abbas /アッバス/アッバース/アバス/
abbey /アビー/
abbeyroad /アビーロード/
abbie /アビー/
abbott /アボット/
abby /アビー/
abduction /アブダクション/
abdul /アブドゥル/
abdullah /アブドラ/アブダラ/アブドーラ/アブドゥラ/
abec /アベック;※avec? エイベック?/
abel /アーベル/アベル/
abelia /アベリア/
abend /アーベント/
abgata /ＡＢ型/
abidjan /アビジャン/
abigail /アビゲイル/
ability /アビリティ/
able /エイブル/
abnormal /アブノーマル/
aborigine /アボリジニ/アボリジニー/
abort /アボート/
about /アバウト/
above /アバブ/
abra /アブラ/
abraham /アブラハム/エイブラハム/
abrams /エイブラムス/
abril /アブリル/
abroad /アブロード/ＡＢｒｏａｄ/
absalom /アブサロム/
absinthe /アブサン/
absolute /アブソリュート/
absorber /アブソーバー/アブソーバ/
abstract /アブストラクト/抽象/
abstraction /アブストラクション/
abu /アブ/アブー/
abudabi /アブダビ/
abuja /アブジャ/
abyss /アビス/
abyssinia /アビシニア/
abyssinian /アビシニアン/
ac /アクチニウム/Actinium/
acacia /アカシア/
acadapter /ACアダプタ/ACアダプター/
academia /アカデミア/
academic /アカデミック/
academie /アカデミー/
academism /アカデミズム/
academy /アカデミー/
acappella /アカペラ;a cappella/
acapulco /アカプルコ/
acca /アッカ;www.acca.ne.jp/
accel /アクセル;accelerator/
accelerando /アチェレランド/アッチェレランド;[音楽]次第に速く/
accelerator /アクセラレータ/アクセル/アクセラレーター/
accent /アクセント/´;accent aigue/｀;accent grave/＾;accent circonflexe/¨;trema,umlaut/アクサン;仏語/
accentaigu /アクサンテギュ;accent aigue/´/
accentcirconflexe /アクサンシルコンフレックス;accent circonflexe/＾/
accentgrave /アクサングラーブ;accent grave/アクサングラーヴ/｀/
accept /アクセプト/
acceptable /アクセプタブル/
acceptor /アクセプター/アクセプタ/
access /アクセス/
accesscounter /アクセスカウンター/アクセスカウンタ/
accessibility /アクセシビリティ/アクセシビリティー/
accesslog /アクセスログ/
accessor /アクセサ/アクセッサ/アクセッサー/
accessory /アクセサリー/アクセサリ/
accesspoint /アクセスポイント/
accesstime /アクセスタイム/
accident /アクシデント/
accidental /アクシデンタル/
accidentally /アクシデンタリ/
accommodation /アコモデーション/
accord /アコード/
accordion /アコーディオン/
account /アカウント/
accountability /アカウンタビリティ;(言い換え:説明責任)/アカウンタビリティー/アカンタビリティ/
accounting /アカウンティング/
accoustic /アクースティック;※acoustic?/
accra /アクラ/
accumulator /アキュムレータ/
accuracy /アキュラシー/
ace /エース/
acepilot /エースパイロット/
acerola /アセロラ/
acestriker /エースストライカー/
acetal /アセタール/
acetaldehyde /アセトアルデヒド/
acetamido /アセトアミド/
acetaminophen /アセトアミノフェン;C8H9NO2/
acetate /アセテート/
aceto /アセト/
acetone /アセトン;CH3COCH3/
acetonitrile /アセトニトリル/
acetyl /アセチル;CH3CO-/
acetylcholine /アセチルコリン/
acetylcoa /アセチルCoA/
acetylene /アセチレン/
achaemenes /アケメネス/
achievement /アチーブメント/
achille /アシル/
achilles /アキレス/
achilleus /アキレス/アキレウス/
acid /アシッド/
acidjazz /アシッドジャズ/
ackerman /アッカーマン/
ackermann /アッカーマン/
aclass /Ａクラス/Aクラス/
acm /米国計算機学会;Association for Computing Machinery. www.acm.org/
acme /アクメ/
acne /アクネ/
acom /アコム;[企業名]消費者金融。www.acom.co.jp/
aconcagua /アコンカグア;-川(チリ)/
aconitine /アコニチン/
acosta /アコスタ/
acoustic /アコースティック/
acousticguitar /アコースティックギター/
acoustics /アコースティックス/
acquapazza /アクアパッツァ;(It) acqua pazza/アクアパッツア/
acre /エーカー/
acro /アクロ/
acrobat /アクロバット/
acrobatic /アクロバティック/
acrobatreader /アクロバットリーダー/
acrolein /アクロレイン/
acronym /アクロニム/
acropolis /アクロポリス/
across /アクロス/
acryl /アクリル/
acrylonitrile /アクリロニトリル/
act /アクト/
actin /アクチン/
actinium /アクチニウム;[元素]89,Ac/
actinoid /アクチノイド/
action /アクション/
actiongame /アクションゲーム/
actionprogram /アクションプログラム/
actionscene /アクションシーン/
activate /アクティベート/
activation /アクティベーション/
activator /アクティベーター/アクティベータ/
active /アクティブ/アクティヴ/
activewindow /アクティブウィンドウ/
activist /アクティビスト/
activity /アクティビティ/アクティビティー/
actor /アクター/アクタ/
actress /アクトレス/
actual /アクチュアル/
actuality /アクチュアリティ/
actually /アクチュアリー/
actualtime /アクチュアルタイム/
actuary /アクチュアリー;保険数理士/
actuator /アクチュエータ/アクチュエーター/
acup /Aカップ;10cm/Ａカップ/
acute /アキュート/
acyclovir /アシクロビル/
ad /アド/
ada /Ada/エイダ/アーダ/アダ/
adac /アドバンスド・データ・コントロールズ;www.adac.co.jp/
adagio /アダージョ/
adam /アダム/アダン/
adams /アダムス/
adapt /アダプト/
adaptation /アダプテーション/
adapter /アダプタ/アダプター/
adaptive /アダプティブ/アダプティヴ/
adaptor /アダプタ/アダプター/
adballoon /アドバルーン;和製英語(advertising balloon)/
adc /Ａ／Ｄコンバータ/
add /アッド/
adderley /アダレイ/
addessability /アドレッサビリティ/
addict /アディクト/
addiction /アディクション/
addie /アディ/
addin /アドイン;add-in/
addisababa /アジスアベバ;Addis Ababa/
addisabeba /アジスアベバ;Ababa Abeba/
addon /アドオン/
address /アドレス/
addressbar /アドレスバー/
addressbook /アドレスブック/
addressing /アドレッシング/アドレシング/
addressingmode /アドレッシングモード/
addy /アディ/
adela /アデラ/
adelaide /アデレード/
adele /アデル/アデール/アデーレ/
aden /アデン/
adenine /アデニン;A/
adenoid /アデノイド/
adenosine /アデノシン/
adenovirus /アデノウイルス/アデノウィルス/
adept /アデプト/
adhoc /アドホック;ad hoc/
adidas /アディダス;www.adidas.com/
adieu /アデュー/
adios /アディオス/
adjani /アジャーニ/
adjust /アジャスト/
adjustable /アジャスタブル/
adjuster /アジャスター/アジャスタ/
adjustment /アジャストメント/
adler /アドラー/
adlib /アドリブ;ad lib/
admin /アドミン/
administer /アドミニスター/
administration /アドミニストレーション/
administrator /アドミニストレータ/アドミニストレーター/
admission /アドミッション/
admittance /アドミタンス/
adobe /アドビ;www.adobe.com/Ａｄｏｂｅ/
adolescence /アドレッセンス;青春/アドゥレセンス/
adolf /アドルフ/
adolfo /アドルフォ/
adolph /アドルフ/
adolphe /アドルフ/
adonai /アドナイ/
adonis /アドニス/
adopt /アドプト/
adopter /アダプタ;adapter?/
adorno /アドルノ/
adrenalin /アドレナリン/
adrenaline /アドレナリン/
adria /アドリア/
adrian /エイドリアン/アドリアン/
adriana /アドリアーナ/
adriano /アドリアーノ/
adrien /アドリアン/
adrienne /アドリエンヌ;仏語/エイドリアン/
adrive /Aドライブ;A:/Ａドライブ/
adslmodem /ADSLモデム/
adult /アダルト/
adultdvd /アダルトDVD/
adultgoods /アダルトグッズ/
adultshop /アダルトショップ/
adultsite /アダルトサイト/
adultvideo /アダルトビデオ/
advance /アドバンス/アドヴァンス/
advanced /アドバンスト/アドバンスド/アドヴァンスト/アドヴァンスド/
advantage /アドバンテージ/
advent /アドベント/
adventure /アドベンチャー/
adventuregame /アドベンチャーゲーム/
advertise /アドバタイズ/
advertisement /アドバタイズメント/アド/
advertising /アドバタイジング/
advice /アドバイス/アドヴァイス/
advise /アドバイズ;[動詞]/アドバイス;※名詞「アドバイス」はadvice/
adviser /アドバイザー/アドバイザ/
advisor /アドバイザー/アドバイザ/アドヴァイザー/
advisory /アドバイザリー/アドバイザリ/アドヴァイザリ/アドバイサリ/
adware /アドウェア/
adwords /アドワーズ/
ady /アディ/
aegis /イージス/
aeolia /エオリア/
aeolian /エオリアン;ABCDEFGA/
aeolus /アイオロス/
aeon /イオン;www.aeon.info/
aera /アエラ;[雑誌名]朝日新聞社/AERA/
aerial /エアリアル/
aero /エアロ/
aerobi /エアロビ;aerobics/
aerobics /エアロビクス/
aerobike /エアロバイク;和製英語(stationary bike)/
aerodynamics /エアロダイナミクス/
aeroflot /アエロフロート;www.aeroflot.ru/
aerogramme /エアログラム/
aerosol /エアゾール/
aerospace /エアロスペース/
aeschylus /アイスキュロス/
aesop /イソップ/
aesthe /エステ/
aesthesalon /エステサロン;aesthetic salon/
aesthetic /エステティック/
aesthetician /エステティシャン/
aestheticsalon /エステティックサロン;aesthetic salon/
affair /アフェア/
affiliate /アフィリエイト/アフィリエート/
affiliateprogram /アフィリエイトプログラム/
affiliater /アフィリエイター/
affine /アフィン/
affinity /アフィニティ/アフィニティー/
affordance /アフォーダンス/
afghan /アフガン/
afghanistan /アフガニスタン;.af/
aflatoxin /アフラトキシン/
afreco /アフレコ;after recording/
africa /アフリカ/
africaans /アフリカーンス/
african /アフリカン/
afrikaans /アフリカーンス/
afro /アフロ/
afrohair /アフロヘア/
after /アフター/
afterbeat /アフタービート/
afterburner /アフターバーナー/
aftercare /アフターケア/
afterdark /アフターダーク/
afterfive /アフターファイブ/
afterfollow /アフターフォロー;和製英語(follow-up)/
afternoon /アフタヌーン/
afterservice /アフターサービス/
ag /銀/Silver/
again /アゲイン/アゲーン/
against /アゲインスト/アゲンスト/
agamben /アガンベン/
agamemnon /アガメムノン/
agape /アガペー/
agaricus /アガリクス;ハラタケ属/
agarose /アガロース/
agata /Ａ型/アガタ/
agate /アゲート/
agatha /アガサ/アガタ/
agathe /アガット/アガーテ/アガート/
age /エイジ/エージ/
agency /エージェンシー/
agenda /アジェンダ/会議事項/
agent /エージェント/エイジェント/
aggregate /アグリゲート/
aggregator /アグリゲータ/
aggressive /アグレッシブ/アグレッシヴ/
agharta /アガルタ/
agile /アジャイル/
agility /アジリティ/アジリティー/
aging /エイジング/エージング/
agit /アジト/
agitation /アジテーション/
agitato /アジタート/
agitpunkt /アジト/
agnes /アグネス/アニエス/
agni /アグニ/
agogo /アゴゴ/
agora /アゴラ/
agra /アグラ/
agree /アグリー/
agreement /アグリーメント/
agri /アグリ/
agribusiness /アグリビジネス/
agriculture /アグリカルチャー/
aguilera /アギレラ/
aguirre /アギーレ/
agustin /アグスティン/
ah /アー/
ahead /アヘッド/
ahriman /アーリマン/
ai /AI/人工知能/
aias /アイアス/アイアース/
aibo /アイボ;[商標]ソニー/
aic /アイク;[企業名]消費者金融。aic.jp/
aid /エイド/
aida /アイーダ/
aids /エイズ/後天性免疫不全症候群/
aidsvirus /エイズウイルス/
aiexpert /ＡＩエキスパート/
aiful /アイフル;[企業名]消費者金融。www.aiful.co.jp/
aila /アイラ/
aileen /アイリーン/
aim /エイム/
aimar /アイマール/
aime /エメ/
aimee /エメ/エーメ/
aiming /エイミング/
aina /アイナ/
aino /アイノ/
ainu /アイヌ/
aiolos /アイオロス/
air /エア/エアー/
aira /アイラ/
airbag /エアバッグ/
airborn /エアボーン/
airborne /エアボーン/
airbrush /エアブラシ/
airbus /エアバス/
aircap /エアキャップ;ぷちぷち/
aircheck /エアチェック/
aircleaner /エアクリーナー/
aircon /エアコン;air conditioner/
airconditioner /エアコンディショナー;air conditioner/
aircraft /エアクラフト/
airduct /エアダクト;air duct/
airflow /エアフロー/
airforce /エアフォース;air force/
airforceone /エアフォースワン;Air Force One/
airfrance /エールフランス;www.airfrance.fr/
airgun /エアガン/
airhockey /エアホッケー/
airi /アイリ/
airline /エアライン/
airlines /エアラインズ/
airlock /エアロック/
airmail /エアメール/
airplane /エアプレーン/
airplants /エアプランツ/
airpocket /エアポケット/
airport /エアポート/
airs /エアーズ/
airship /エアシップ/
airsystem /エアシステム/
airterminal /エアターミナル/
airticket /エアチケット/
airvalve /エアバルブ;air valve/
airway /エアウェイ/
airways /エアウェイズ/
aischylos /アイスキュロス/
aisha /アイシャ/アイーシャ/アーイシャ/
aisle /アイル;通路/
ajanta /アジャンタ/アジャンター/
ak /Alaska/アラスカ/
akademeia /アカデメイア/
akapella /アカペラ;※a capella?/ア・カペラ;※a capella?/
akashic /アカシック/
akbar /アクバル/
akcl /AKCL/AKCL(Austin Kyoto Common Lisp)/
akeem /アキーム/
aki /アキ/
akim /アキーム/
akkad /アッカド/
akropolis /アクロポリス/
aku /アク/
al /アル/アルミニウム/Aluminum/アラバマ/Alabama/
ala /アラ/ア・ラ・/
alabama /アラバマ;AL/
alabaster /アラバスター/
alacarte /アラカルト;a la carte/ア・ラ・カルト/
aladdin /アラジン/
alaikum /アライクム;(アラビア語)/
alain /アラン/
alamo /アラモ/
alamode /アラモード;a la mode/ア・ラ・モード/
alamos /アラモス/
alan /アラン/
alanine /アラニン;Ala/
alarcon /アラルコン/
alarm /アラーム/
alaska /アラスカ;AK/
alawi /アラウィ/
alba /アルバ;[商標]セイコー/
alban /アルバン/
albania /アルバニア;.al/
albatross /アルバトロス;信天翁/
albedo /アルベド/
albeit /アルバイト;曹長石/
albeniz /アルベニス/
albert /アルバート/アルベルト/アルベール/
alberta /アルバータ/アルベルタ/
alberti /アルベルティ/
alberto /アルベルト/
albina /アルビナ/
albino /アルビノ/
albion /アルビオン/
albirex /アルビレックス;[Jリーグ]新潟/
albrecht /アルブレヒト/
album /アルバム/
albumin /アルブミン/
albumtitle /アルバムタイトル/
albuquerque /アルバカーキ/
alceste /アルセスト;le Misanthrope/
alchemist /アルケミスト/
alcohol /アルコール/
alcohollamp /アルコールランプ/
alcove /アルコーブ/
alda /アルダ/
aldehyde /アルデヒド/
aldente /アルデンテ;al dente/
alder /アルダー/
aldo /アルド/
ale /エール/アレ/
alec /アレック/
alegre /アレグレ/
alegrias /アレグリアス/
alejandro /アレハンドロ/
aleksandr /アレクサンドル/
aleksei /アレクセイ/
alena /アレナ/
aleph /アレフ/アーレフ/
aleppo /アレッポ;シリア/
alert /アラート/
ales /アレス/
alesi /アレジ/
alessandra /アレッサンドラ/
alessandro /アレッサンドロ/アレサンドロ/
alessio /アレッシオ/
aleutian /アリューシャン/
alex /アレックス/
alexa /アレクサ/
alexander /アレキサンダー/アレクサンダー/アレグザンダー;(英)/アレクサンデル/アレクサンドル/アレクザンダー/
alexandra /アレクサンドラ/アレキサンドラ/アレグザンドラ;(英)/
alexandre /アレクサンドル/
alexandria /アレキサンドリア/アレクサンドリア/
alexandrite /アレキサンドライト/
alexandros /アレクサンドロス/
alexei /アレクセイ/
alexis /アレクシス/アレクシ;仏語/
alf /アルフ/
alfa /アルファ/
alfalfa /アルファルファ/
alfaromeo /アルファロメオ;www.alfaromeo.com/
alfee /アルフィー/
alfine /アルフィーネ;(It) al fine/
alfons /アルフォンス/
alfonso /アルフォンソ/
alfred /アルフレッド/アルフレート;(独語)/
alfredo /アルフレード/
alge /アルジェ/
alger /アルジェ/
algeria /アルジェリア;.dz/
algernon /アルジャーノン/
algin /アルギン/
algol /アルゴル/
algorithm /アルゴリズム/算法/
alhambra /アルハンブラ/
ali /アリ/アリー/
alias /エイリアス/エリアス/エーリアス;<rare>/
aliasing /エイリアシング/エリアシング/
alibaba /アリババ/
alibi /アリバイ/
alice /アリス/
alicia /アリシア/
alien /エイリアン/
alighieri /アリギエリ/
align /アライン/
alignment /アライメント/アラインメント/
alina /アリーナ/
alisa /アリサ/
alison /アリソン/アリスン/
alistair /アリステア/
alitalia /アリタリア;www.alitalia.it/
alive /アライブ/アライヴ/
aljazeera /アルジャジーラ;al-Jazeera. www.aljazeera.net/アルジャズィーラ/
alk /アルク/
alkali /アルカリ/
alkaline /アルカリ/
alkaloid /アルカロイド/
alkan /アルカン/
alkane /アルカン/
alkene /アルケン;C[n]H[2n]/
alkoxide /アルコキシド/
alkyd /アルキド/
alkyl /アルキル;C[n]H[2n-1]-/
alkyne /アルキン;C[n]H[2n-2],RC≡CR/
all /オール/∀/
alla /アラ/アッラ/アーラ/
allabout /オールアバウト;all about/オール・アバウト・/
allah /アラー/アッラー/
allan /アラン/
allback /オールバック/
allclear /オールクリア/
allcolor /オールカラー/
allcolour /オールカラー/
allegory /アレゴリー/
allegra /アレグラ/
allegretto /アレグレット/
allegria /アレグリア/
allegro /アレグロ/
allelopathy /アレロパシー/
allemand /アルマン/
allemande /アルマンド/
allen /アレン/アラン/
allene /アレン/
aller /アレ;仏語/
allergen /アレルゲン/
allergy /アレルギー/アレルギ/
alley /アレイ/アレー/
allgreen /オールグリーン/
alliance /アライアンス/
allicin /アリシン/
allie /アリー/
allied /アライド/
alliedtelesis /アライドテレシス;www.allied-telesis.co.jp/
alligator /アリゲーター/
allinone /オールインワン;all-in-one/
allison /アリソン/
allman /オールマン/
allnight /オールナイト/
allnude /オールヌード/
allo /アロ;(接頭辞)異-/
allocate /アロケート/
allocation /アロケーション/割り当て/
allocator /アロケータ/
allose /アロース/
allow /アラウ/
alloy /アロイ/
allpass /オールパス/
allround /オールラウンド/
allseason /オールシーズン/
allspice /オールスパイス/
allstanding /オールスタンディング/
allstar /オールスター/
allstargame /オールスターゲーム/
allstars /オールスターズ/
alltime /オールタイム/
allweather /オールウェザー/
ally /アリー/
allyl /アリル/
alma /アルマ/
almanac /アルマナック/
almaty /アルマトゥイ/
almighty /オールマイティ/オールマイティー/
alminium /アルミニウム;※aluminium/
almodovar /アルモドバル/
almond /アーモンド/
aloe /アロエ/
aloha /アロハ/
alohashirt /アロハシャツ/
alois /アロイス/
alone /アローン/アロン/
along /アロング/
alonso /アロンソ/アロンゾ/
alonzo /アロンゾ/
alpaca /アルパカ/
alpen /アルペン/
alpena /アルピナ/
alpenhorn /アルペンホルン/
alpenroute /アルペンルート;立山の観光道路。www.alpen-route.com/
alpenski /アルペンスキー/
alpha /α/アルファ/アルファー/
alphabet /アルファベット/
alphatron /アルファトロン/
alphonse /アルフォンス/
alphonso /アルフォンソ/
alphorn /アルプホルン/
alpine /アルパイン/
alpinist /アルピニスト/
alps /アルプス/
alqaeda /アルカイダ;al-Qaeda/
alright /オーライ/オールライト/
als /アルス/
alsace /アルザス/
alt /アルト/
alta /アルタ/
altai /アルタイ/
altamira /アルタミラ/
altar /オルター;祭壇/
altea /アルテア/
alter /アルター/オルター/
altered /オルタード/アルタード/
alterna /オルタナ;alternative/
alternate /オルタネイト/オルタネート/
alternative /オルタナティヴ/オルタナティブ/
althorn /アルトホルン/
althusser /アルチュセール/
altkey /ALTキー/オルトキー/
alto /アルト/
altoflute /アルトフルート/
altohorn /アルトホルン;alto horn/
altrecorder /アルトリコーダー/
altsax /アルトサックス/
alumi /アルミ;aluminium/
alumifoil /アルミホイル;aluminium foil/
alumina /アルミナ/
aluminium /アルミ;Al/アルミニウム;[元素]13,Al/
aluminum /アルミニウム;[元素]13,Al/
alumisash /アルミサッシ;aluminum sash/
alumite /アルマイト/
alvarez /アルバレス/
alvaro /アルバロ/
alvin /アルヴィン/
always /オールウェイズ/
alyosha /アリョーシャ/
alyson /アリソン/
alyssa /アリッサ/
alyssum /アリッサム/
alz /アルツ/
alzheimer /アルツハイマー/
am /アメリシウム/Americium/アム/エーエム/エイエム/
ama /アマ;amateur/
amabile /アマービレ/
amadeus /アマデウス/
amalg /Ц;※これはキリル文字のtse/
amalgam /アマルガム/
amalia /アマリア/
amalthaea /アマルテア/
amalthea /アマルテア/
amanda /アマンダ/
amande /アマンド;(Fr) アーモンド/
amantadine /アマンタジン/
amara /アマラ/
amaranth /アマランス/
amaranthus /アマランサス/
amaretto /アマレット/
amaro /アマロ/
amaryllis /アマリリス/
amateur /アマチュア/
amateurism /アマチュアリズム/
amati /アマティ/
amato /アマート/
amazing /アメイジング/アメージング/
amazon /アマゾン/
amazoness /アマゾネス/
ambassador /アンバサダー/
amber /アンバー/
ambient /アンビエント/
ambition /アンビション/
ambitious /アンビシャス/
ambivalence /アンビバレンス/アンビヴァレンス/
ambivalent /アンビバレント/アンビヴァレント/
ambroise /アンブロワーズ/
ambrose /アンブローズ/
ambrosia /アンブロシア/
ambulance /アンビュランス/
ambush /アンブッシュ/
ameba /アメーバ/
amedas /アメダス;AMeDAS/
amedee /アメデ/
amefoot /アメフト;American football/
amelia /アメリア/
amelie /アメリ/アメリー/
amen /アーメン/Ａ面/アメン/
amenity /アメニティ/アメニティー/
america /アメリカ/亜米利加/
american /アメリカン/
americana /アメリカーナ/
americancherry /アメリカンチェリー/
americancoffee /アメリカンコーヒー/
americancurl /アメリカンカール/
americandream /アメリカンドリーム/
americanexpress /アメリカンエキスプレス;www.americanexpress.com/
americanfootball /アメリカンフットボール/
americanism /アメリカニズム/
americanleague /アメリカンリーグ/
americanshorthair /アメリカンショートヘア/
americium /アメリシウム;[元素]95,Am/
amethyst /アメジスト/紫水晶/紫石英/
ametrine /アメトリン/
amex /アメックス/アメリカンエキスプレス/
ami /アミ/
amide /アミド/
amie /アミ/
amiel /アミエル/
amiens /アミアン/
amigo /アミーゴ/
amina /アミナ/
amine /アミン/
amino /アミノ/
amman /アンマン/
ammon /アモン/
ammonia /アンモニア/
ammonite /アンモナイト/
ammonium /アンモニウム/
ammons /アモンズ/
amnesty /アムネスティ/
amo /アモ/
amoeba /アメーバ/
amor /アモール;(西) 愛/
amoral /アモラル/
amore /アモーレ;(It) 愛/
amoroso /アモローソ/
amorphous /アモルファス/
amortization /アモチゼーション/
amos /アモス/
amount /アマウント/
amour /アムール/
amp /アンプ/アンプリファイア/
ampere /アンペア;A/アンペール;Andre-Marie Ampere (1775-1836)/
ampersand /アンパサンド;&/アンパーサンド/
amphetamine /アンフェタミン/
amphitheater /アンフィシアター;円形劇場/
amphitheatre /アンフィシアター;円形劇場/
ample /アンプル/
ampoule /アンプル/
ampul /アンプル/
amradio /AMラジオ/
amrduk /マルドゥーク/
amrita /アムリタ;[ヒンドゥー教] 不死の水/
amsterdam /アムステルダム/
amulet /アミュレット/
amun /アモン/
amur /アムール;黒竜江/
amuse /アミューズ/
amusement /アミューズメント/
amusementpark /アミューズメントパーク/
amway /アムウェイ;www.amway.com/
amy /エイミー/
amyl /アミル/
amylase /アミラーゼ/
amylose /アミロース/
an /アン/
ana /アナ/
anabel /アナベル/
anabell /アナベル/
anabolic /アナボリック/
anachro /アナクロ;anachronism/
anachronism /アナクロニズム/アナクロ/
anaconda /アナコンダ/
anaerobics /アネロビクス/
anaheim /アナハイム/
anais /アナイス/
anakin /アナキン/
anal /アナル/エイナル/
analfuck /アナルファック/
analizer /アナライザ;※analyzer/
analizing /アナライジング;※analyzing/
analog /アナログ/
analogdata /アナログデータ/
analogrecord /アナログレコード/
analogue /アナログ/
analogy /アナロジー/
analsex /アナルセックス/
analvib /アナルバイブ;anal vibrator/
analyse /アナライズ/
analyser /アナライザ/アナライザー/
analysis /アナリシス/
analyst /アナリスト/
analyze /アナライズ/
analyzer /アナライザ/アナライザー/
ananas /アナナス/
anaphylaxie /アナフィラキシー;(独語)/
anaphylaxis /アナフィラキシー/
anarchism /アナーキズム/アナキズム/
anarchist /アナーキスト/アナキスト/
anarcho /アナルコ/
anarchy /アナーキー/
anastasia /アナスタシア/
anatol /アナトール/
anatole /アナトール/
anatolia /アナトリア/
anc /アクティブノイズコントロール;active noise control/
anchor /アンカー/
anchorage /アンカレッジ/アンカレジ/
anchorman /アンカーマン/
anchovy /アンチョビ/アンチョビー/
ancien /アンシャン/
ancienregime /アンシャンレジーム;ancien regime/
ancient /アンシャン;仏語/アンシエント/アンシェント/エインシェント/
and /アンド/∧/∩/＆/かつ/および/&/
andalucia /アンダルシア/
andaman /アンダマン/
andante /アンダンテ/
andantino /アンダンティーノ/
anders /アンダース/
andersen /アンデルセン/
anderson /アンダーソン/アンデルソン/
andes /アンデス/
andor /アンドール/
andorra /アンドラ;.ad/
andrade /アンドラーデ/
andre /アンドレ/
andrea /アンドレア/
andreas /アンドレアス/
andree /アンドレ/
andrei /アンドレイ/
andres /アンドレス/
andretti /アンドレッティ/
andrew /アンドリュー/
andrews /アンドリューズ/
andrey /アンドレイ/
androgen /アンドロゲン/
android /アンドロイド/
andromeda /アンドロメダ/
andrun /エンドラン/
andy /アンディ/アンディー/
anecdote /アネクドート/
anelka /アネルカ/
anemone /アネモネ/
anergy /アネルギー/
ange /アンジュ;(Fr)天使/
angel /エンジェル/エンゼル/アンヘル/アンジェル/アンゲル/
angela /アンジェラ/アンヘラ/アンゲラ/
angeles /エンジェルス;※angels?/
angelfish /エンゼルフィッシュ/
angelic /エンジェリック/アンジェリック/
angelica /アンジェリカ/アンゼリカ/
angelico /アンジェリコ/
angelina /アンジェリーナ/
angelique /アンジェリーク;(Fr)天使の/アンジェリック/アンジェリク/
angelis /アンジェリス/
angelo /アンジェロ/
angelot /アンジェロ;(Fr)小天使/
angelplan /エンゼルプラン/
angels /エンジェルス;[MLB]/エンジェルズ;[MLB]/
angelus /アンジェラス/
anger /アンガー/アンジェ/
angers /アンジェ/
angie /アンジー/
angkor /アンコール/
angkorwat /アンコールワット;Angkor Wat/
angle /アングル/∠/
anglo /アングロ/
anglosaxon /アングロサクソン;Anglo-Saxon/
angola /アンゴラ;.ao/
angora /アンゴラ/
angry /アングリー/
angstrom /オングストローム/Å/
anguilla /アングイラ;.ai/セントキッツネ;.kn/
angulo /アングロ/
angus /アンガス/
anilide /アニリド/
aniline /アニリン/
anima /アニマ/
animage /アニメージュ;徳間書店/
animal /アニマル/
animals /アニマルズ/
animation /アニメーション/
animato /アニマート/
animator /アニメーター/
animax /アニマックス;www.animax.co.jp/
anime /アニメ/
animechara /アニメキャラ;animation character/
animesong /アニメソング/
animetic /アニメチック;和製英語/
animism /アニミズム/
animus /アニムス/
anion /アニオン/
anisakis /アニサキス/
anise /アニス/
anison /アニソン/
anita /アニタ/アニータ/
anjelica /アンジェリカ/
ankara /アンカラ/
ankh /アンク/
ankle /アンクル/
anklet /アンクレット/
anklung /アンクルン/
ann /アン/
anna /アンナ/アナ/
annabel /アナベル/
annabell /アナベル/
annabella /アナベラ/
annabelle /アナベル/
annales /アナール;(Fr) 年報。「-学派」/
annamillers /アンナミラーズ;Anna Miller's/
annan /アナン/
annapolis /アナポリス/
annapurna /アンナプルナ/
anne /アンネ/アンヌ/アン/
annealing /アニーリング/
annette /アネット/アネッテ/
annex /アネックス/
anni /アンニ/アニ/
annick /アニック/
annie /アニー/
annika /アニカ/アンニカ/
annis /アニス/
anniston /アニストン/
anniversary /アニバーサリー/
annotation /アノテーション/
announce /アナウンス/
announcement /アナウンスメント/
announcer /アナウンサー/
anntena /アンテナ;※antenna?/
annual /アニュアル/
anny /アニー/
ano /アノ/
anode /アノード/
anomaly /アノマリー/
anomie /アノミー/
anomy /アノミー/
anonymous /アノニマス/
anorak /アノラック/
another /アナザー/
anritsu /アンリツ;www.anritsu.co.jp(?)/
ansar /アンサール/
ansel /アンセル/
anselmo /アンセルモ/
ansermet /アンセルメ/
ansi /ANSI/
answer /アンサー/アンサ/
ant /アント/
antananarivo /アンタナナリボ;マダガスカル(tnr)/
antares /アンタレス/
antelope /アンテロープ/
antenna /アンテナ/
antennashop /アンテナショップ/
anthem /アンセム/
anthocyanin /アントシアニン/
anthology /アンソロジー/
anthony /アンソニー/アントニー/
anthracene /アントラセン;C14H10/
anthurium /アンスリウム/
anthy /アンシー/
anti /アンチ/
antiaging /アンチエイジング;anti-aging/
antialias /アンチエイリアス/
antialiasing /アンチエイリアシング/
antichrist /アンチキリスト/
anticlimax /アンチクライマックス/
antico /アンティコ/
antidote /アンチドート/
antigone /アンティゴネ/アンティゴネー/アンチゴネー/アンチゴネ/
antihero /アンチヒーロー/
antilles /アンティル;An,.an/
antilock /アンチロック/
antimon /アンチモン;[元素]51,Sb/
antimony /アンチモン;[元素]51,Sb/アンチモニー/アンティモニー/
antinomy /アンチノミー/
antiochia /アンティオキア/
antipasto /アンティパスト/
antique /アンティーク/
antishock /アンチショック/
antithese /アンチテーゼ/
antivirus /アンチウイルス/アンチウィルス/
antlers /アントラーズ;[Jリーグ]鹿島/
antoine /アントワーヌ/
antoinette /アントワネット/
anton /アントン/
antoni /アントニ/
antonia /アントニア/
antonin /アントナン/
antonio /アントニオ/
antonius /アントニウス/
antony /アントニー/
antwerp /アントワープ/
anu /アヌ/
anus /アヌス/エイヌス/
anvil /アンビル;金床/アンヴィル/
any /エニー/エニ/エニイ/何か/
anya /アーニャ/
anycast /エニーキャスト/エニキャスト/
anything /エニシング/
ao /(concat "and\057or")/
aodai /アオザイ;ao dai/
aorist /アオリスト/
ap /アクセスポイント/
apache /アパッチ/
apart /アパート/
apartheid /アパルトヘイト/
apartment /アパートメント/アパート/
apathy /アパシー/
apatite /アパタイト/
aperitif /アペリティフ/
aperture /アパーチャ/
apex /アペックス;advanced purchase excursion/
aphorism /アフォリズム/
aphrodite /アフロディテ/アフロディーテ/
apia /アピア/
apo /アポ/
apocalypse /アポカリプス/
apoint /アポイント/
apointment /アポイントメント/
apollinaire /アポリネール/
apollo /アポロ/
apollon /アポロン/
apollonia /アポロニア/
apolo /アポロ/
aporia /アポリア/
aposteriori /アポステリオリ;a posteriori/
apostrophe /’/アポストロフィ;'/アポストロフ/
apotosis /アポトーシス/
appalachian /アパラチア/
apparel /アパレル/
apparelmaker /アパレルメーカー/
appartement /アパルトマン;仏語/
appassionata /アパッショナータ/
appassionato /アパッショナート/
appeal /アピール/
appealpoint /アピールポイント;和製英語/
appearance /アピアランス/
appellation /アペラシオン;(Fr) 呼称/
append /アペンド/
appendix /アペンディックス/付録/
appia /アッピア/
applause /アプローズ/
apple /アップル/Ａｐｐｌｅ/
applecomputer /アップルコンピュータ;www.apple.com/
applepie /アップルパイ/
appleseed /アップルシード/
applet /アプレット/
appleton /アップルトン/
appli /アプリ;application/
appliance /アプライアンス/
application /アプリケーション/アプリケイション/応用/
applicationcontext /アプリケーションコンテキスト/
applicationmodal /アプリケーションモーダル/
applicationserver /アプリケーションサーバ/
applicationsoft /アプリケーションソフト/
applique /アップリケ/
apply /アプライ/
appo /アポ;appointment/
appoint /アポイント/
appointer /アポインター/
appointment /アポイントメント/
apprication /アプリケーション/
approach /アプローチ/
approx /〜/≒/
apres /アプレ/
apricot /アプリコット/
april /エイプリル/
aprilfool /エイプリルフール/
apriori /アプリオリ;a priori/
apron /エプロン/
aprondress /エプロンドレス/
aqaba /アカバ;ヨルダン/
aqua /アクア/
aquablue /アクアブルー/
aquacise /アクアサイズ/
aquafresh /アクアフレッシュ;[商標]/
aqualung /アクアラング/
aquamarine /アクアマリン/藍玉/
aquanaut /アクアノート/
aquapolis /アクアポリス/
aquarium /アクアリウム/
aquarius /アクエリアス;水瓶座/
aquatic /アクアティック/
aquatint /アクアチント/
aquinas /アクィナス/
aquitaine /アキテーヌ/
ar /Argon/Arkansas/アーカンソー/アルゴン/人工現実感/アール/
arab /アラブ/アラブ首長国連邦/
arabella /アラベラ/
arabesque /アラベスク/
arabia /アラビア/
arabian /アラビアン/
arabiannight /アラビアンナイト/
arabiannights /アラビアンナイト/アラビアンナイツ/
arabic /アラビック/
arabinose /アラビノース/
arafat /アラファト/
aragon /アラゴン/
aral /アラル/
aram /アラム/
aramid /アラミド/
aranjuez /アランフェス/
arank /Aランク/Ａランク/
ararat /アララト/アララット/
arbeit /アルバイト/バイト/
arbeiter /アルバイター/
arbiter /アービタ/
arbitor /アービター;arbiter?/
arbitrage /アービトラージ/
arbitration /アービトレーション/
arc /アーク/⌒/
arcade /アーケード/
arcadegame /アーケードゲーム/
arcadia /アルカディア/
arcana /アルカナ/
arcanciel /アルカンシェル;(Fr) arc-en-ciel, 虹/
arch /アーチ/
archaic /アルカイック/
arche /アルシュ/アルケー/
archer /アーチャー/
archery /アーチェリー/
archet /アルシェ;(Fr)弓/
archetype /アーキタイプ/
archi /アーキ/
archie /アーチー/
archimedes /アルキメデス/
architect /アーキテクト/
architecture /アーキテクチャ/アーキテクチャー/
archive /アーカイブ/アーカイヴ/
archivefile /アーカイブファイル/
archiver /アーカイバ/
archives /アーカイブス/
archon /アルコン/
archy /アーチー/
arco /アルコ/
arcturus /アルクトゥルス/
ardant /アルダン/
arden /アーデン/
ardija /アルディージャ;[Jリーグ]大宮/
are /アール;100m^2/アー/
area /エリア/域/空間/
areaguide /エリアガイド/
areamap /エリアマップ/
areastudy /エリアスタディ/エリアスタディー/
arena /アリーナ/アレーナ;(西語)「闘牛の-」/
arenas /アレナス/
arendt /アーレント/アレント/
ares /アレス/
arezzo /アレッツォ/
argent /アラザン/アルジャン;仏語/
argentina /アルゼンチン;.ar/
argentine /アルゼンチン/
argentinetango /アルゼンチンタンゴ;Argentine tango/
argento /アルジェント/
argerich /アルゲリッチ/
arginine /アルギニン;Arg/
argo /アルゴ/
argon /アルゴン;[元素]18,Ar/
argos /アルゴス/
argument /アーギュメント/引数/
arguments /アーギュメンツ/
argus /アーガス/
ari /アリ/
aria /アリア/
ariadne /アリアドネ/
ariane /アリアン/
arias /アリアス/
arie /アリ/
ariel /アリエル/
aries /アリエス;牡羊座/
arietta /アリエッタ/
arioso /アリオーソ/
arirang /アリラン/
aris /アリス/
arisa /アリサ/
aristophanes /アリストパネス/アリストファネス/
aristoteles /アリストテレス/
aristotelis /アリストテレス/
aristotle /アリストテレス/
arity /アリティ/
arizona /アリゾナ;AZ/
ark /アーク;箱舟/
arkansas /アーカンソー;AR/
arkas /アルカス/
arkwright /アークライト/
arlene /アーレン/
arlequin /アルルカン/
arles /アルル/
arlington /アーリントン/
arm /アーム/
armadillo /アルマジロ/
armageddon /アルマゲドン/ハルマゲドン/
armagnac /アルマニャック/
armand /アルマンド/アーマンド/アルマン/
armando /アルマンド/
armani /アルマーニ;www.armani.it/
armas /アルマス/
armband /アームバンド/
armchair /アームチェア/
armenia /アルメニア;.am/
armeria /アルメリア/
armin /アーミン/
armitage /アーミテージ/
armor /アーマー/
armored /アーマード/
armour /アーマー/
armoured /アーマード/
armrest /アームレスト/
arms /アームズ/
armstrong /アームストロング/
armwrestling /アームレスリング/
army /アーミー/
arnaud /アルノー/
arne /アルネ/
arno /アルノ/アルノー/
arnold /アーノルド/アルノルト/アルノルド/
arnoul /アルヌール/
arnould /アルヌール/
arnoux /アルヌー/
aroma /アロマ/
aromacandle /アロマキャンドル;和製英語/
aromacology /アロマコロジー/
aromaoil /アロマオイル/
aromatherapy /アロマテラピー/アロマセラピー/
aromatic /アロマティック/
aronalpha /アロンアルファ;[商標]東亜合成/
around /アラウンド/
arowana /アロワナ/
arp /アルプ/
arpa /アルパ/
arpeggio /アルペジオ/
arpeggione /アルペジオーネ/
arpegio /アルペジオ;※arpeggio?/
arrabbiata /アラビアータ/
arrange /アレンジ/
arrangement /アレンジメント/
arranger /アレンジャー/
array /アレイ/アレー/配列/
arrival /アライバル/
arriving /アライビング/
arrow /アロー/→;->/←;<-/↑;^/↓;v/⇒;=>/⇔;<=>,equiv/
ars /アルス;(Lat)芸術/
arsenal /アーセナル/
arsene /アルセーヌ/
arsenic /アースニック;As/アルセニック/アーセニック/
arsine /アルシン;AsH3/
art /アート/
artaud /アルトー/
artdeco /アールデコ;art deco/
artdirector /アートディレクター/
artemis /アルテミス/
artemisia /アルテミシア/アルテミジア/
artflower /アートフラワー;artificial flower/
arthur /アーサー/アルチュール/アルトゥール/アルテュール/
artichoke /アーティチョーク/
article /アーティクル/
articulate /アーティキュレート/アーティキュレイト/
articulation /アーティキュレーション/
artifact /アーティファクト/アーチファクト/
artificial /アーティフィシャル/
artisan /アルティザン/アルチザン/
artist /アーティスト/アーチスト/
artistic /アーティスティック/
artists /アーティスツ/
artnouveau /アールヌーボー;art nouveau/アールヌーヴォー/
arto /アルト/
arts /アーツ/
artur /アルトゥール/
arturo /アルトゥーロ/
artwork /アートワーク/
aruba /アルーバ;.aw/
arya /アーリア/
aryl /アリール/
as /アズ/ヒ素/砒素/Arsenic/
asa /アサ/アーサ/
asahibeer /アサヒビール/
asbestos /アスベスト/
ascension /アセンション/アセンション島;.ac/
ascii /アスキー/ASCII/
asciiart /アスキーアート/
asciicode /ASCIIコード/アスキーコード/
ascot /アスコット;[商標]ホンダ/
ascottie /アスコットタイ/
asgard /アスガルド/
ash /アッシュ/
ashgabad /アシガバード/
ashkenazy /アシュケナージ/
ashley /アシュリー/アシュレイ/
ashram /アシュラム/
ashtray /アッシュトレイ/
asia /アジア/エイジア/亜細亜/アーシア/
asiacup /アジアカップ/
asian /アジアン/エイジアン/
asiana /アシアナ;www.asiana.co.kr/
aside /アサイド/
asimo /アシモ;[商標]ホンダ/
asimov /アシモフ/アジモフ/
asistance /アシスタンス;※assistance?/
ask /アスク/
asklepios /アスクレピオス/
asmara /アスマラ/
asmo /アスモ/
asoka /アショカ/アショーカ/
aspara /アスパラ;asparagus/
asparagine /アスパラギン;Asn/
asparagus /アスパラガス/
aspartame /アスパルテーム/
aspect /アスペクト/
asperger /アスペルガー/
asphalt /アスファルト/
aspirin /アスピリン;C9H8O4/
aspite /アスピーテ/
ass /アス/
assad /アサド/
assai /アッサイ/
assalam /アッサラーム;(アラビア語)/
assam /アッサム/
assassin /アサシン/
assault /アサルト/
assemble /アセンブル/
assembler /アセンブラ/
assembly /アセンブリ/
assert /アサート/
assessment /アセスメント/アセス/
asset /アセット/遺産/
assign /アサイン/割り当て/
assignment /アサインメント/代入/
assisi /アッシジ/
assist /アシスト/
assistance /アシスタンス/
assistant /アシスタント/
assoc /アソック/
associate /アソシエイト/
associates /アソシエイツ/
association /アソシエーション/
associative /アソシアティブ/アソシエイティブ/
assort /アソート/
assurance /アシュアランス/
assyria /アッシリア/
asta /アスタ/
astatine /アスタチン;[元素]85,At/
astec /アステック/
astem /アステム/京都高度技術研究所;※abbrev: Advanced Software Technology & Mechatronics Research Institute of Kyoto. www.astem.or.jp/
asterisk /アスタリスク/
asteroid /アステロイド/
asti /アスティ/
aston /アストン/
astor /アスター/アストル/
astra /アストラ/
astrakhan /アストラハン/
astral /アストラル/
astro /アストロ/
astrology /アストロロジー/
astros /アストロズ;[MLB]/
astroscope /アストロスコープ/
astrud /アストラッド/
asuncion /アスンシオン/
aswan /アスワン/
asyl /アジール;(独語)/
asylum /アサイラム/
asymmetry /アシンメトリー/
at /アット/アト/アスタチン/Astatine/＠/
atacama /アタカマ/
atari /アタリ/
atelier /アトリエ/
atempo /ア・テンポ/アテンポ;a tempo/
athena /アテナ/アテーナー/Ａｔｈｅｎａ/Athena/
athenae /アテナイ/アテネ/
athenai /アテナイ/
athene /アテネ/
athens /アセンズ/
atherom /アテローム;(独語)/
atheroma /アテローマ/アテローム/
athlete /アスリート/
athletic /アスレチック/アスレティック/
athleticclub /アスレチッククラブ/アスレティッククラブ/
athletics /アスレチックス/
athlon /アスロン/
athome /アットホーム/
athos /アトス/
atkins /アトキンス/
atlanta /アトランタ/
atlantic /アトランティック/
atlantis /アトランティス/アトランチス/
atlas /アトラス/
atm /自動現金取り扱い機/自動預貯金機/
atman /アートマン/
atmark /アットマーク;@/
atmosphere /アトモスフィア/アトモスフェア/
atok /Ａｔｏｋ/ATOK/エイトック/
atom /アトム/
atomic /アトミック/
atony /アトニー/
atopie /アトピー/
atopy /アトピー/
atrandom /アトランダム/
atrium /アトリウム/
atropine /アトロピン/
att /ＡＴ＆Ｔ;www.att.com/
attach /アタッチ/
attache /アタッシュ/
attachecase /アタッシュケース;attache case/
attachment /アタッチメント/
attack /アタック/
attacker /アタッカー/
attacking /アタッキング/
attend /アテンド/
attendant /アテンダント/
attent /アテント/
attention /アテンション/
attenuator /アッテネータ/アッテネーター/
attest /アテスト/
attika /アッティカ/
attila /アッティラ/
attlee /アトリー/
atto /アト;[SI接頭語]a,10^-18/
attract /アトラクト/
attraction /アトラクション/
attractive /アトラクティブ/
attractor /アトラクター/アトラクタ/
attribute /アトリビュート/属性/
attu /アッツ/
atype /Aタイプ/Ａタイプ/
au /金/Gold/
aubade /オーバード/
auberge /オーベルジュ/
aubrey /オーブリー/
auckland /オークランド/
auction /オークション/
audi /アウディ;www.audi.com/
audience /オーディエンス/
audio /オーディオ/
audiocable /オーディオケーブル/
audiocd /オーディオCD/
audiofile /オーディオファイル/
audiology /オージオロジ/
audioplayer /オーディオプレイヤー/オーディオプレーヤー/
audiosystem /オーディオシステム/
audiovisual /オーディオビジュアル/
audition /オーディション/
auditorium /オーディトリアム/
audrey /オードリー/オドレイ/
auf /アウフ/
aufheben /アウフヘーベン/
auftact /アウフタクト/
augarten /アウガルテン/
auger /オーガ/オージェ/
augsburg /アウクスブルク/
august /オーガスト/アウグスト/オーギュスト/
augusta /オーガスタ/
auguste /オーギュスト/
augustin /オーギュスタン/アウグスティン/オギュスタン/
augustine /オーガスティン/
augustinus /アウグスティヌス/アウグスチヌス/
augusto /アウグスト/
augustus /アウグストゥス/オーガスタス/
aulait /オレ/
aunt /アント/
aura /オーラ/アウラ/
aurelius /アウレリウス/
aurora /オーロラ/アウロラ/アウローラ/
aurorasauce /オーロラソース/
auroravision /オーロラビジョン;和製英語/
aus /アウス/
auschwitz /アウシュビッツ/アウシュヴィッツ/
auslese /アウスレーゼ/
ausone /オーゾンヌ/
aussie /オージー/
auster /オースター/
austin /オースティン/オースチン/
australia /オーストラリア;.au/
australiagp /オーストラリアGP;[F1]/
australian /オーストラリアン/
austria /オーストリア;.at/
authentic /オーセンティック/
author /オーサ/オーサー/
authoring /オーサリング/
authorise /オーソライズ/
authority /オーソリティ/オーソリティー/
authorize /オーソライズ/
auto /オート/
autobacks /オートバックス;www.autobacks.com/
autobahn /アウトバーン/
autobianchi /アウトビアンキ;www.autobianchi.com/
autobike /オートバイ/
autocamp /オートキャンプ/
autocomplete /オートコンプリート/
autocorrect /オートコレクト/
autofill /オートフィル/
autofocus /オートフォーカス/
autograph /オートグラフ/
autolease /オートリース/
autoload /オートロード/
autoloading /オートローディング/
autoloan /オートローン/
autolock /オートロック/
autologin /オートログイン/
automa /オートマ/
automata /オートマタ/オートマトン;※単数形(automaton)/
automatic /オートマチック/オートマティック/
automation /オートメーション/
automaton /オートマトン/
automobile /オートモービル/
automount /オートマウント/
autopilot /オートパイロット/
autorace /オートレース/
autoraise /オートレイズ/
autorepeat /オートリピート/
autoreverse /オートリバース/
autumn /オータム/
auxin /オーキシン/
availability /アベイラビリティ/
available /アベイラブル/アヴェイラブル/使用可能/利用可能/
aval /アバール/
avant /アバン/アヴァン/
avantgarde /アバンギャルド;avant-garde/アヴァンギャルド/
avanti /アバンティ/アヴァンティ/
avanture /アバンチュール/
avatar /アバター/アバタール/
ave /アベ/アヴェ/
avec /アベック/
avemaria /アヴェマリア;Ave Maria/アベマリア/
avenue /アベニュー/アヴェニュー/
average /アベレージ/
averagehitter /アベレージヒッター/
avex /エイベックス;www.avex.co.jp/
avignon /アヴィニョン/
avila /アビラ/
avispa /アビスパ;[Jリーグ]福岡/
avocado /アボカド/
avogadro /アボガドロ/アヴォガドロ/
avonlea /アボンリー/アヴォンリー/
avril /アヴリル;(Fr) 4月/アブリル/
avsystem /AVシステム/
award /アワード/
awards /アワーズ/アウォーズ/
aware /アウェア/
awareness /アウェアネス/
away /アウェイ/アウェー/
awaygame /アウェイゲーム/アウェーゲーム/
awayteam /アウェイチーム/アウェーチーム/
awk /オーク/
awning /オーニング/
ax /アックス/アクス/
axe /アックス/アクス/
axel /アクセル/
axelrod /アクセルロッド/
axiom /アクシオム/ アクシアム/公理/
axis /アクシス/
axon /Ａｘｏｎ/
ay /エイ/エー/
ayala /アヤラ/
ayatullah /アヤトラ/
aych /エイチ/エッチ/
ayeaye /アイアイ;aye-aye. お猿さんだよ/
ayersrock /エアーズロック/
aykroyd /エイクロイド/
ayler /アイラー/
ayrton /アイルトン/
aytch /エイチ/エッチ/
ayurveda /アーユルヴェーダ/アーユルベーダ/
ayutthaya /アユタヤ/
ayyub /アイユーブ/
az /Arizona/アリゾナ/
aza /アザ/
azalea /アゼリア/アザレア/
azan /アザーン/
azane /アザン/
azel /アゼル/
azerbaijan /アゼルバイジャン;.az/
azido /アジド/
azine /アジン/
aznar /アスナール/
azteca /アステカ/
azulene /アズレン;C10H8/
azur /アジュール/アズール/
b /β;beta/ビー/ベー;(独語)/б;be (cyrillic)/ホウ素/硼素/Boron/
b# /Ｂ#1/B#0/
b#size /B#0サイズ/Ｂ#1サイズ/
b-spline /Ｂ−スプライン/
ba /バリウム/Barium/
baal /バール/
bab /バーブ/
baba /バーバ/ババ/
babe /ベイブ/ベーブ/
babel /バベル/
baberuth /ベーブルース;(1895-1948) Babe Ruth/ベイブルース/
babies /ベイビーズ/
babs /バブス/
baby /ベビー/ベイビー/ベイビィ/
babybath /ベビーバス/
babybed /ベビーベッド/
babyboom /ベビーブーム/
babyboomer /ベビーブーマー;baby boomer/
babycar /ベビーカー;和製英語(pushchair)/
babydoll /ベビードール/
babyface /ベビーフェイス/
babyfood /ベビーフード/
babylon /バビロン/
babylonia /バビロニア/
babylotion /ベビーローション/
babyoil /ベビーオイル/
babypowder /ベビーパウダー/
babyseat /ベビーシート/
babysitter /ベビーシッター/
babywear /ベビーウェア/
bacall /バコール/
bacardi /バカルディ/
baccalaureat /バカロレア/
baccarat /バカラ/
bacchos /バッコス/
bacchus /バッカス/
baccus /バッカス/
bach /バッハ/Ｂａｃｈ/
bachelard /バシュラール/
bachelor /バチェラー/
bacillus /バチルス/
back /バック/
backband /バックバンド/
backbone /バックボーン/
backchain /バックチェイン/
backchorus /バックコーラス;background chorus/
backdancer /バックダンサー/
backdoor /バックドア/
backdrop /バックドロップ/
backend /バックエンド/
backfire /バックファイア/
backgammon /バックギャモン/
backgear /バックギア/
background /バックグラウンド/バックグランド/背景/
backhand /バックハンド/
backhaus /バックハウス/
backhome /バックホーム;和製英語/
backing /バッキング/
backlight /バックライト/
backlog /バックログ/
backmargin /バックマージン/
backmirror /バックミラー/
backnet /バックネット/
backnumber /バックナンバー/
backoffice /バックオフィス/
backorder /バックオーダー/
backpack /バックパック/
backpacker /バックパッカー/
backpacking /バックパッキング/
backplane /バックプレーン/
backpressure /バックプレッシャー/
backprint /バックプリント/
backpropagation /バックプロパゲーション/
backquote /バッククォート/バッククオート/
backs /バックス/
backscreen /バックスクリーン/
backscroll /バックスクロール/
backside /バックサイド/
backslash /バックスラッシュ/＼/
backspace /バックスペース/
backspin /バックスピン/
backstage /バックステージ/
backswing /バックスイング/
backtrace /バックトレース/
backtrack /バックトラック/
backtracking /バックトラッキング/
backup /バックアップ/
backupfile /バックアップファイル/
backward /バックワード/
backy /バッキー/
backyard /バックヤード/
bacon /ベーコン/
baconegg /ベーコンエッグ/
bacteria /バクテリア/
bad /バッド/
badenbaden /バーデンバーデン/
badend /バッドエンド/
badge /バッジ/バッヂ/
badi /バディ/
badminton /バドミントン/
badnews /バッドニュース/
badtiming /バッドタイミング/
badtrip /バッドトリップ/
baffle /バッフル/バフル/
baffy /バフィー;4-wood/バッフィー/
bag /バッグ/
bagatell /バガテル/
bagdad /バグダッド/
bagel /ベーグル/
baggage /バゲージ/
baggio /バッジョ/
baghdad /バグダード/
bagnacaoda /バーニャカウダ;(It)bagna cauda/
bagpipe /バグパイプ/
baguette /バゲット;フランスパン/
baguio /バギオ;フィリピン/
bahamas /バハマ;.bs/
bahamut /バハムート/
bahrain /バーレーン;.bh/
bahraingp /バーレーンGP;[F1]/
baht /バーツ/
baikal /バイカル/
baikonur /バイコヌール;カザフスタン/
bailey /ベイリー/
bain /ベイン/バン;(Fr)風呂/
baiser /ベーゼ;(Fr)キス/
baka /バカ/
bake /ベーク/ベイク/
baked /ベークド/
bakelite /ベークライト/
baker /ベイカー/ベーカー/
bakery /ベーカリー/
bakhtin /バフチン/
baking /ベーキング/
bakingpowder /ベーキングパウダー/
bakken /バッケン/
baku /バクー/
bal /バル/
balalaika /バラライカ/
balance /バランス/
balancer /バランサ/バランサー/
balancesheet /バランスシート/
balancing /バランシング/
balaphone /バラフォン/
balcon /バルコン/
balcony /バルコニー/
baldwin /ボールドウィン/
balenciaga /バレンシアガ/
bali /バリ/
balinese /バリニーズ/
balios /バリオス/
balk /ボーク/
balkan /バルカン/
ball /ボール/
ballack /バラック/
ballad /バラッド/バラード/
ballade /バラード/
ballantine /バランタイン/
ballard /バラード/
ballast /バラスト/
ballbearing /ボールベアリング/
ballerina /バレリーナ/
ballet /バレエ/
balletdancer /バレエダンサー/
balley /ベイリー/
balleys /ベイリーズ;Balleys's/
ballistic /バリスティック/
balloon /バルーン/
ballpark /ボールパーク/
ballpen /ボールペン;和製英語(ballpoint)/
bally /バリー;www.bally.com/
balm /バーム/バルム/
balrog /バルログ/
balsa /バルサ/
balsamico /バルサミコ/
balthasar /バルタザール/バルタザル/
balthazar /バルタザール/バルタザル/
baltic /バルチック/
baltimore /ボルチモア/ボルティモア/
balzac /バルザック/
bamako /バマコ/
bamberg /バンベルク/
bambi /バンビ/
bambino /バンビーノ;(It)子供/
bamboo /バンブー/
bamiyan /バーミヤン;アフガニスタン/
ban /バン/
banach /バナッハ/
banana /バナナ/
bananachips /バナナチップス/
bancroft /バンクロフト/
band /バンド/
banda /バンダ;(It)楽団/
bandage /バンデージ/
bandaid /バンドエイド;[商標]band-aid/
bandana /バンダナ;※bandanna/
bandanna /バンダナ/
banderas /バンデラス/
bandgap /バンドギャップ/
bandman /バンドマン/
bandmaster /バンドマスター/バンマス/
bandmember /バンドメンバー/
bandneon /バンドネオン/
bandoneon /バンドネオン/
bandpass /バンドパス/
bandscore /バンドスコア/
bandung /バンドン;インドネシア/
bandwagon /バンドワゴン/
bandwidth /バンド幅/
bane /ベイン/
banff /バンフ/
bang /バン/
bangalore /バンガロール/
bangkok /バンコク/
bangladesh /バングラデシュ;.bd/
bangle /バングル/
bangui /バンギ/
banjo /バンジョー/
bank /バンク/
bankbutton /バンクボタン/
banker /バンカー;銀行家/
banking /バンキング/
banks /バンクス/
banmas /バンマス;bandmaster/
banner /バナー/
banquet /バンケット/
banshee /バンシー/
bansri /バンスリ/バンスリー/
bantam /バンタム/
baobab /バオバブ/
baptisma /バプテスマ/
baptist /バプテスト/バプティスト/
baptiste /バプティスト/バティスト/
bar /バー/バール;-のようなもの/−;minus/｜;pipe/‖/
barabbas /バラバ/
baraja /バラハ/
barb /バーブ/
barbados /バルバドス;.bb/
barbapapa /バーバパパ/
barbara /バーバラ/バルバラ;quelle connerie la guerre!/
barbaresco /バルバレスコ/
barbarian /バーバリアン/
barbaroi /バルバロイ;(ギリシア語)/
barbecue /バーベキュー/
barbell /バーベル/
barber /バーバー/
barbera /バルベーラ/バルベラ/
barbie /バービー/
barbital /バルビタール/
barbra /バーブラ/
barcarole /バルカローレ/バルカロール/
barcarolle /バルカロール/
barcelona /バルセロナ/
barcode /バーコード/
barcodereader /バーコードリーダー/バーコードリーダ/
bardot /バルドー/
bare /ベア/
barebone /ベアボーン/
barenboim /バレンボイム/
baretop /ベアトップ;和製英語/
bargain /バーゲン/
bargainsale /バーゲンセール/
barge /バージ/
bari /バーリ/
baricade /バリケード;※barricade/
barilla /バリラ/
bariquand /バリカン;仏語/
baritone /バリトン/
baritonesax /バリトンサックス/
barium /バリウム/
bark /バーク/
barlounge /バーラウンジ/
barn /バーン/
barnabas /バルナバ/
barnaby /バーナビー/
barnard /バーナード/
barnes /バーンズ/
barney /バーニー/
barneys /バーニーズ;www.barneys.com/
barnum /バーナム/
barolo /バローロ/
barometer /バロメーター/バロメータ/
baron /バロン/
baroque /バロック/
barouh /バルー/
barrack /バラック/
barracks /バラック/
barracuda /バラクーダ/
barrel /バレル/バーレル/
barrett /バレット/
barricade /バリケード/
barrichello /バリチェロ/
barrier /バリア/バリアー/
barrierfree /バリアフリー/
barrior /バリア;barrier?/
barron /バロン/
barry /バリー/
barrymore /バリモア/
bart /バート/
bartender /バーテンダー/バーテン/
barter /バーター/
barth /バルト/
barthes /バルト/
bartholin /バルトリン/
bartholomew /バーソロミュー/バルトロマイ/
bartime /バータイム/
bartok /バルトーク/
bartoli /バルトリ/
barton /バートン/
barye /バリー/バーリー/バリ/
baryon /バリオン/
baryton /バリトン/
base /ベース/基底/
baseball /ベースボール/
basecamp /ベースキャンプ/
baseclock /ベースクロック/
basel /バーゼル/
baseline /ベースライン/
basement /ベースメント/
basename /ベースネーム/
baserunning /ベースランニング/
baseup /ベースアップ;和製英語(raise)/
bash /バッシュ/
bashing /バッシング/
bashkortostan /バシコルトスタン/
basic /ベーシック/
basie /ベイシー/
basil /バジル/ベイジル/
basilico /バジリコ/
basilisk /バシリスク/
basis /ベーシス/基礎/
bask /バスク/
baske /バスケ;basketball/
basket /バスケット/
basketball /バスケットボール/
basketshoes /バスケットシューズ/
basque /バスク/
basra /バスラ;イラク/
bass /バス/ベース/バース;人名/
bassclarinet /バスクラリネット/
bassdrum /バスドラム/
basset /バセット/
basseterre /バセテール/
bassguitar /ベースギター/
bassist /ベーシスト/
bassline /ベースライン/
basso /バッソ/
bassoon /バスーン/ファゴット;fagotto(It)/
basssolo /ベースソロ/
bastard /バスター/バスタード/
bastian /バスティアン/
bastien /バスティアン/
bastille /バスティーユ/バスチーユ/
bat /バット/
bataille /バタイユ/
batalha /バタリア/
batavia /バタヴィア/
batch /バッチ/
batchfile /バッチファイル/
batchsize /バッチサイズ/
bateau /バトー;(Fr)船/
bateson /ベイトソン/
bath /バス/バース/
bathmat /バスマット/
bathrobe /バスローブ/
bathroom /バスルーム/
bathtime /バスタイム/
bathtowel /バスタオル/
bathtub /バスタブ/
batista /バティスタ/
batman /バットマン/
baton /バトン/
batontouch /バトンタッチ;和製英語(baton pass)/
batontwirling /バトントワリング/
batsu /×/
batter /バッター/
batterbox /バッターボックス;batter's box/
battery /バッテリー/バッテリ/
batterypack /バッテリーパック/
batting /バッティング/
battingcenter /バッティングセンター/
battle /バトル/
battleaxe /バトルアックス/
battler /バトラー/
battleroyal /バトルロワイヤル/バトルロイヤル/
battrang /バッチャン/
baud /ボー/
baudelaire /ボードレール/ボオドレエル/
baudrate /ボーレート/
baudrillard /ボードリヤール/
bauer /バウアー/
bauhaus /バウハウス/
baulk /ボーク/
baum /バウム;(独語)木/ボーム/
baumann /バウマン/
baume /ボーメ/
baumkuchen /バウムクーヘン/バームクーヘン/
bautista /バウティスタ/
bauxite /ボーキサイト/
bavarois /ババロア/
bavaroise /ババロワーズ/バヴァロワーズ/ババロアーズ/バヴァロアーズ/
baxter /バクスター/
bay /ベイ/
bayarea /ベイエリア/
baybridge /ベイブリッジ/
bayer /バイエル/
bayern /バイエルン/
bayes /ベイズ/
bayesian /ベイジアン/
bayleaf /ベイリーフ/
bayley /ベイリー/
bayon /バイヨン/
bayreuth /バイロイト/
bayside /ベイサイド/
baystars /ベイスターズ/
baz /バズ/
bazaar /バザール/
bazar /バザー/バザール/
bazillus /バチルス/
bazooka /バズーカ/
bbc /BBC/
bbs /掲示板/
bclass /Ｂクラス/Bクラス/
bcup /Bカップ;12.5cm/Ｂカップ/
bday /バースディ;BirthDAY/
bdrive /Bドライブ;B:/Ｂドライブ/
be /ビー/ベリリウム/Beryllium/б;cyrillic/
beach /ビーチ/
beachball /ビーチボール/
beachboys /ビーチボーイズ/
beachparasol /ビーチパラソル;和製英語(beach umbrella)/
beachresort /ビーチリゾート/
beachsandal /ビーチサンダル/
beachvolley /ビーチバレー/
beachvolleyball /ビーチバレーボール/
beacon /ビーコン/
bead /ビーズ/
beads /ビーズ/
beadscushion /ビーズクッション/
beagle /ビーグル/
beaker /ビーカー/
beam /ビーム/
beamsabre /ビームサーベル/
bean /ビーン;豆/
beanball /ビーンボール/
beans /ビーンズ/
bear /ベア/ベアー/
bearing /ベアリング/
bears /ベアーズ/
beart /ベアール/
beast /ビースト/
beat /ビート/
beatbox /ビートボックス/
beater /ビーター/
beatles /ビートルズ/
beatnik /ビートニク/
beatrice /ベアトリーチェ/ベアトリス/
beatrix /ベアトリクス/ビアトリクス/ベアトリックス/
beatriz /ベアトリス/
beats /ビーツ/
beau /ボー;仏語/
beaucaillou /ボーカイユ/
beaujolais /ボジョレー/ボージョレ/ボジョレ/ボージョレー/
beaujolaisnouveau /ボジョレーヌーボー;Beaujolais nouveau/ボージョレーヌーボー/ボージョレヌーボー/ボージョレヌーヴォー/ボージョレーヌーヴォー/ボジョレーヌーヴォー/
beaune /ボーヌ/
beaute /ボーテ/ボテ;(Fr)美/
beautiful /ビューティフル/
beauty /ビューティ/ビューティー/
beauvoir /ボーヴォワール/
beauxarts /ボザール;(Fr) beaux-arts. 美術/
beaver /ビーバー/
bebe /ベベ/
bebop /ビバップ/
bec /ベック;(Fr)嘴,マウスピース/
because /ビコーズ/∵/
bechamel /ベシャメル/
bechamelsauce /ベシャメルソース;bechamel sauce/
bechet /ベシェ/
beck /ベック/
beckenbauer /ベッケンバウアー/
becker /ベッケル/
becket /ベケット/
beckett /ベケット/
beckham /ベッカム/
beckie /ベッキー/
becky /ベッキー/
becquerel /ベクレル/
bed /ベッド/
bedcover /ベッドカバー/
bedin /ベッドイン/
bedouin /ベドウィン/
bedroom /ベッドルーム/
bedscene /ベッドシーン/
bedsheets /ベッドシーツ/
bedside /ベッドサイド/
bedtime /ベッドタイム/
bedtown /ベッドタウン;和製英語(dormitory)/
bee /ビー/
beef /ビーフ/
beefcurry /ビーフカレー/
beefjerky /ビーフジャーキー/
beefsteak /ビーフステーキ/
beefstew /ビーフシチュー/
beefstroganoff /ビーフストロガノフ/
beem /ビーム/
been /ビーン/
beep /ビープ/
beer /ビール/ビア/麦酒/
beergarden /ビアガーデン/
beerhall /ビアホール/
beerken /ビール券/
beermug /ビアマグ/
beet /ビート;砂糖大根/
beethoven /ベートーヴェン/ベートーベン/
beetle /ビートル/
beets /ビーツ;甜菜/
before /ビフォア/ビフォー/
begin /ビギン/
beginner /ビギナー/
beginners /ビギナーズ/
beginnersluck /ビギナーズラック/
begins /ビギンズ/
begonia /ベゴニア/
beguine /ビギン;[音楽]begin the -/
behavior /ビヘイビア/
behind /ビハインド/
beige /ベージュ/
beignet /ベニエ/
beijing /ペキン/北京/
being /ビーイング/
beirach /バイラーク/
beirut /ベイルート/
beit /バイト/
bejart /ベジャール/
bel /ベル/
bela /ベラ/
belarus /ベラルーシ;.by/
belcanto /ベルカント;bel canto/
belem /ベレン/
belen /ベレン/
belfast /ベルファスト/
belgie /ベルギー/
belgiegp /ベルギーGP;[F1]/
belgium /ベルギー;.be/
belief /ビリーフ/
believe /ビリーヴ/ビリーブ/
believer /ビリーバー/
belinda /ベリンダ/
belize /ベリーズ;.bz/
bell /ベル/
bella /ベラ/
belladonna /ベラドンナ/
bellamy /ベラミー/ベラミ/
bellbottom /ベルボトム/
bellcore /ベルコア/
belle /ベル/
belleepoque /ベルエポック;la Belle Epoque/
bellemaison /ベルメゾン/
bellini /ベリーニ/
bellken /ベル研/Ｂｅｌｌ研/
bellman /ベルマン/
bellmare /ベルマーレ;[Jリーグ]湘南/
bellof /ベロフ/
bells /ベルズ/
belltree /ベルツリー/
bellucci /ベルッチ/
belly /ベリー/
bellydance /ベリーダンス/
bellydancer /ベリーダンサー/
belmondo /ベルモンド/
belmont /ベルモント/
belmopan /ベルモパン/
below /ビロウ/ビロー/
belt /ベルト/
beltconveyer /ベルトコンベア/ベルトコンベアー/ベルトコンベヤー/ベルトコンベヤ/
beltconveyor /ベルトコンベア/ベルトコンベアー/ベルトコンベヤー/ベルトコンベヤ/
beltran /ベルトラン/
belz /ベルツ/
bem /ベム/
ben /ベン/
benares /ベナレス/
bench /ベンチ/
benchmark /ベンチマーク/
benchmarktask /ベンチマーク・タスク/
benchmarktest /ベンチマークテスト/
benchpress /ベンチプレス/
benchtime /ベンチタイム/
bend /ベンド/
bender /ベンダー/ベンダ/
bending /ベンディング/
bene /ベネ/
benedict /ベネディクト/
benedicte /ベネディクト/
benedictine /ベネディクティン/
benedictus /ベネディクトゥス/
benedikt /ベネディクト/
benefit /ベネフィット/
benelux /ベネルクス;ベルギー・オランダ・ルクセンブルク/
benesse /ベネッセ;www.benesse.co.jp/
benetton /ベネトン;www.benetton.com/
bengal /ベンガル/
bengala /ベンガラ/
bengali /ベンガル/
benghazi /ベンガジ/
benguela /ベンゲラ/
benin /ベニン;.bj/ベナン/
bening /ベニング/
benitez /ベニテス/
benjamin /ベンジャミン/ベンヤミン/
benjaron /ベンジャロン/
benjie /ベンジー/
benjy /ベンジー/
bennet /ベネット/
bennett /ベネット/
bennie /ベニー/
benny /ベニー/
benoit /ブノワ/ブノア/
benson /ベンソン/
bent /ベント/
bentham /ベンサム/
benthos /ベントス;底生生物/
bentley /ベントレー/ベントリー/
benzaldehyde /ベンズアルデヒド/
benzene /ベンゼン/
benzin /ベンジン/
benzine /ベンジン/
benzo /ベンゾ/
benzoyl /ベンゾイル/
benzyl /ベンジル/
beograd /ベオグラード/
beowulf /ベオウルフ/ベーオウルフ/
bera /ベラ/
berardi /ベラルディ/
berber /ベルベル/
beret /ベレー/
beretta /ベレッタ/
berg /バーグ/ベルク/ベルグ/
bergamasque /ベルガマスク/
bergamo /ベルガモ;イタリア/
bergamot /ベルガモット/
bergamotto /ベルガモット;イタリア語/
bergen /ベルゲン/ベルヘン/バーゲン/ベルヘンバーゲン/
berger /ベルジェ/バーガー/
bergerac /ベルジュラック/
bergman /バーグマン/
bergson /ベルクソン/
berimbau /ビリンバウ/
bering /ベーリング/
berio /ベリオ/
berkeley /バークレー;カリフォルニア/バークリー/バークレイ/
berkelium /バークリウム;[元素]97,Bk/
berkley /バークレー/バークリー/バークレイ/
berlin /ベルリン/
berlinphil /ベルリンフィル;Berliner Philharmonisches Orchester/
berlioz /ベルリオーズ/
berlitz /ベルリッツ;www.berlitz.com/
berlusconi /ベルルスコーニ/
bermuda /バミューダ;.bm/バーミューダ/
bern /ベルン/
berna /ベルナ/
bernanke /バーナンキ/
bernard /バーナード/ベルナール/ベルナルド/ベルナルト/
bernardo /ベルナルド/
bernd /ベルント/
berne /ベルヌ/
bernhard /ベルンハルト/バーンハード/
bernhardt /ベルナール/
bernie /バーニー/
bernini /ベルニーニ/
bernoulli /ベルヌーイ/
bernstein /バーンスタイン/
beroff /ベロフ/
berra /ベラ/
berret /ベレー/
berri /ベリ/
berrichello /バリチェロ/
berry /ベリー/ベリ/
berserk /バーサーク/
berserker /バーサーカー/ベルセルク;[北欧神話](NB:英語のberserkは逆成)/
bert /バート/ベルト/ベール/
berta /ベルタ/
bertha /バーサ/ベルタ/
berthold /ベルトルト/
bertini /ベルティーニ/
bertolt /ベルトルト/
bertram /バートラム/ベルトラム/
bertrand /ベルトラン/バートランド/
beryl /ベリル/
beryllium /ベリリウム;[元素]4,Be/
besancon /ブザンソン/
beside /ビサイド/
bess /ベス/
bessel /ベッセル/
bessie /ベッシー/
besson /ベッソン/
bessy /ベッシー/
best /ベスト/
best# /ベスト#0/ベスト#1/
bestalbum /ベストアルバム/
bestdresser /ベストドレッサー/
besteffort /ベストエフォート/
besteleven /ベストイレブン/
bestlap /ベストラップ/
bestmatch /ベストマッチ/
bestmember /ベストメンバー/
bestnine /ベストナイン/
bestone /ベストワン/
bestrap /ベストラップ/
bestseason /ベストシーズン/
bestseller /ベストセラー/
bestsellers /ベストセラーズ/
bestshot /ベストショット/
bestten /ベストテン/
bestthree /ベストスリー/
besttime /ベストタイム/
bet /ベット/
beta /β/ベータ/β版/
betacarotene /βカロチン/ベータカロチン/
betacarotin /βカロチン/ベータカロチン/
betarelease /ベータリリース/βリリース/
betatest /βテスト/ベータテスト/
betaversion /βバージョン/ベータバージョン/
betelgeuse /ベテルギウス/ペテルギウス/
beth /ベス/
bethlehem /ベツレヘム/
betsy /ベッツィ/
betta /ベタ/
better /ベター/
betty /ベティ/ベティー/
between /ビトウィーン/ビトゥイーン/
beulah /ビューラー/
beverage /ビバレッジ/
beverley /ビヴァリー/ビバリー/
beverly /ビバリー/ビヴァリー/
beverlyhills /ビバリーヒルズ;Beverly Hills/
beyond /ビヨンド/
bezel /ベゼル/
bezier /ベジェ/ベジエ/
bf /ブルキナファソ/Burkina Faso/
bflets /Bフレッツ;[商標]NTT/
bg /バックグラウンド/
bgata /Ｂ型/
bh /ボーリウム/Bohrium/
bhakti /バクティ/
bhutan /ブータン;.bt/
bhutto /ブット/
bi /バイ;2/ビスマス/Bismuth/
biafra /ビアフラ/
bian /ビアン/
bianca /ビアンカ/
bianchi /ビアンキ/
bianco /ビアンコ/
bias /バイアス/
biathlon /バイアスロン/
bibimbap /ビビンバ;(朝鮮語)/
bible /バイブル/
biblio /ビブリオ/
bibliography /ビブリオグラフィー/
biblos /ビブロス/
bibtex /BibTeX/
biccamera /ビックカメラ;www.biccamera.com/
bicolor /バイカラー/
bicolour /バイカラー/
bicycle /バイシクル/
bid /ビッド/
bidders /ビッダーズ;www.bidders.co.jp/
bidding /ビディング/
bidet /ビデ/
biedermeier /ビーダーマイヤー/
biela /ビエラ/
bien /ビアン/
biennale /ビエンナーレ/
bierce /ビアス/
biet /ビート;(蘭語)/
biff /ビフ/
bifidus /ビフィズス/
big /ビッグ/
bigband /ビッグバンド/
bigbang /ビッグバン/
bigblue /ビッグブルー/
bigcomic /ビッグコミック;小学館/
bigendian /ビッグエンディアン/
bigevent /ビッグイベント/
bigfoot /ビッグフット/
bighorn /ビッグホーン/
biglobe /ビッグローブ;www.biglobe.ne.jp/
bigmac /ビッグマック/
bigname /ビッグネーム/
bignews /ビッグニュース/
bigsight /ビッグサイト;www.bigsight.jp/
bigsize /ビッグサイズ/
bigtex /BigTeX/
bigwave /ビッグウェーブ/
bijou /ビジュー/
bike /バイク/オートバイ/
biker /バイカー/
bikerace /バイクレース/
bikini /ビキニ/
bikiniline /ビキニライン/
bikinipants /ビキニパンツ/
bilane /ビラン/
bilbao /ビルバオ/
bilbo /ビルボ/
bilin /ビリン/
biline /ビリン/
bilingual /バイリンガル/
bilirubin /ビリルビン/
bill /ビル/
billboard /ビルボード/
billiard /ビリヤード/
billiards /ビリヤード/
billie /ビリー/
billing /ビリング/
billion /ビリオン;1,000,000,000/
billionaire /ビリオネア/
billy /ビリー/
biman /ビーマン/
bimetal /バイメタル/
bin /ビン/バイナリ/
bina /ビーナ/
binary /バイナリ/バイナリー/
binarydump /バイナリダンプ/
binaryeditor /バイナリエディタ/
binaryfile /バイナリファイル/
binaural /バイノーラル/
bind /バインド/
binder /バインダー/バインダ/
binding /バインディング/ビンディング/
bing /ビング/
bingo /ビンゴ/
bingogame /ビンゴゲーム/
binladen /ビンラディン;Bin Laden/
binoche /ビノシュ/
bintan /ビンタン/
bio /バイオ/
biochemical /バイオケミカル/
biochip /バイオチップ/
bioethics /バイオエシックス/
biofermin /ビオフェルミン/
biogas /バイオガス/
biography /バイオグラフィー/
biohazard /バイオハザード/
biology /バイオロジー/
biomass /バイオマス/
biomedical /バイオメディカル/
biometrics /バイオメトリクス/
bionics /バイオニクス/
biopsy /バイオプシー;生検/
bioreactor /バイオリアクター/
biorhythm /バイオリズム/
bios /バイオス;basic I／O system/ビオス;[生物]/
bioscience /バイオサイエンス/
biosensor /バイオセンサー/
biotech /バイオテック;biotechnology/バイテク/
biotechnology /バイオテクノロジー/
biotin /ビオチン;ビタミンH/
biotop /ビオトープ;(独語) 野生生物の生育場所。ギリシャ語のBIO(生物)とTOP(場所)の合成語/
biotope /ビオトープ;野生生物の生育場所。ギリシャ語のBIO(生物)とTOP(場所)の合成語/
biphenyl /ビフェニル;C6H5-C6H5/ビフェニール/
bipolar /バイポーラ/
birch /バーチ/
bird /バード/
birdie /バーディー/バーディ/
birdland /バードランド/
birds /バーズ/
birdseye /バーズアイ/
birdwatching /バードウォッチング/
bireleys /バヤリース;[商標]/バャリース/
birgit /ビルギット/
birman /バーマン;猫/
birmingham /バーミンガム/
birth /バース/
birthday /バースデー/バースディ/
birthdaycake /バースデーケーキ/
birthdaycard /バースデーカード/
birthdayparty /バースデーパーティー/バースデーパーティ/バースディパーティ/
birthdaypresent /バースデープレゼント/バースディプレゼント/
biscuit /ビスケット/ビスキュイ;仏語/
bisexual /バイセクシャル/バイセクシュアル/
bishkek /ビシュケク/
bishop /ビショップ/
bismuth /ビスマス;[元素]83,Bi/
bison /バイソン/Bison/
bisphenol /ビスフェノール/
bissau /ビサウ/
bistro /ビストロ;仏語/
bit /ビット/
bit-field /ビットフィールド/
bitch /ビッチ/
bite /バイト/
bitfield /ビットフィールド/ビット場/
bitimage /ビットイメージ/
bitmap /ビットマップ/
bitmapfont /ビットマップフォント/
bitnet /ビットネット/BITNET/
bitrate /ビットレート/
bits /ビッツ/
bitstream /ビットストリーム/
bitte /ビッテ/
bitter /ビター/
bitters /ビターズ/
bittersweet /ビタースイート/ビタースウィート/
bivouac /ビバーク/
biz /ビズ;business/
bizarre /ビザール/
bizerre /ビザール;※bizarre/
bizet /ビゼー/
bjorn /ビョルン/
bk /バークリウム/Berkelium/
black /ブラック/
blackbass /ブラックバス/
blackberry /ブラックベリー/
blackbird /ブラックバード/
blackbox /ブラックボックス/
blackhawk /ブラックホーク/
blackhole /ブラックホール/
blackhumour /ブラックユーモア/
blackjack /ブラックジャック/
blackjoke /ブラックジョーク/
blacklist /ブラックリスト/
blackmagic /ブラックマジック/
blackmarket /ブラックマーケット/
blackmonday /ブラックマンデー/
blackmore /ブラックモア/
blackmusic /ブラックミュージック/
blackonyx /ブラックオニキス/
blackopal /ブラックオパール/
blackout /ブラックアウト/
blackpearl /ブラックパール/
blackpepper /ブラックペッパー/
blackrider /ブラックライダー/
blacksheep /ブラックシープ/
blackstone /ブラックストーン/
blacktea /ブラックティー/
blackthorn /ブラックソーン/
blacktiger /ブラックタイガー/
blade /ブレード/ブレイド/
bladerunner /ブレードランナー/
bladeserver /ブレードサーバ/
blain /ブレーン/ブラン/
blair /ブレア/
blaise /ブレーズ/
blake /ブレイク/ブレーク/
blakey /ブレイキー/
blanc /ブラン/
blanca /ブランカ/
blanche /ブランシュ/
blanchot /ブランショ/
blancmanger /ブラマンジェ/ブランマンジェ;blanc-manger/
blanco /ブランコ/
blank /ブランク/ブラン/
blanket /ブランケット/
blas /ブラス/
blast /ブラスト/
blaster /ブラスター/
blatt /ブラット;(独語)/
blazer /ブレザー/
bldg /ビル/
bleach /ブリーチ/
bleaching /ブリーチング/
blend /ブレンド/
blendcoffee /ブレンドコーヒー/
blending /ブレンディング/
bleomycin /ブレオマイシン/
bless /ブレス/
bley /ブレイ/ブレー/
blik /ブリキ;(蘭語)/
blind /ブラインド/
blindtest /ブラインドテスト/
blindtouch /ブラインドタッチ/
blink /ブリンク/
bliss /ブリス/
blister /ブリスター/
blitz /ブリッツ/
blizzard /ブリザード/
blob /ブロブ/ブロッブ/
bloc /ブロック/
block /ブロック/
blockdevice /ブロックデバイス/
blockdiagram /ブロックダイアグラム/
blocker /ブロッカー/
blockflote /ブロックフレーテ/
blocking /ブロッキング/
blog /ブログ;weBLOG/
blogger /ブロガー/
blois /ブロア/
blond /ブロンド/
blonde /ブロンド/
blondee /ブロンディ/ブロンディー/
blood /ブラッド/
bloodstone /ブラッドストーン/
bloody /ブラディ/ブラッディ/
bloom /ブルーム/
bloomberg /ブルームバーグ/
bloomer /ブルマ/ブルマー/ブルーマー/
blooming /ブルーミング/
blossom /ブロッサム/
blouse /ブラウス/
blouson /ブルゾン/
blow /ブロー/ブロウ/
blower /ブロワー/
blowing /ブローイング/
blowser /ブラウザ;※browser?/
blue /ブルー/
bluebacks /ブルーバックス/
blueberry /ブルーベリー/
blueberryjam /ブルーベリージャム/
bluebird /ブルーバード/
bluecheese /ブルーチーズ/
bluechip /ブルーチップ/
bluecollar /ブルーカラー/
blueday /ブルーデイ/
bluegill /ブルーギル/
blueglass /ブルーグラス;bluegrass?/
bluegrass /ブルーグラス/
bluejays /ブルージェイズ;[MLB]Blue Jays/
bluejeans /ブルージーンズ/
bluemonday /ブルーマンデー/
bluemoon /ブルームーン/
bluemountain /ブルーマウンテン/
bluenote /ブルーノート/ＢｌｕｅＮｏｔｅ/
blueocean /ブルーオーシャン/
blues /ブルース/ブルーズ/
bluescreen /ブルースクリーン/
bluesheet /ブルーシート/
bluesy /ブルージー/
bluetooth /ブルートゥース;www.bluetooth.com/
bluetopaz /ブルートパーズ/
bluetrain /ブルートレイン/
bluewave /ブルーウェーブ/
bluff /ブラフ/
bluish /ブルーイッシュ/
blum /ブルーム/
bluray /ブルーレイ;(DVD)Blu-Ray/
blush /ブラッシュ/ブラッシ/
blushup /ブラッシュアップ;※brushup?/
bmpfile /BMPファイル/
bnf /BNF(Backus-Naur Form)/
bo /ボ/
boa /ボア/
board /ボード/
boarder /ボーダー/
boardgame /ボードゲーム/
boarding /ボーディング/
boardlevel /ボードレベル/
boat /ボート/
boatrace /ボートレース/
bob /ボブ/
bobbie /ボビー/
bobbin /ボビン/
bobby /ボビー/
bobcat /ボブキャット/
bobsleigh /ボブスレー/
bobtail /ボブテイル/ボブテール/
bocca /ボッカ;(It)口/
boccaccio /ボッカチオ/
boch /ボッホ/
bochum /ボッフム/
bodin /ボダン/
body /ボディ/ボディー/バディ/ボデー/バディー/
bodyart /ボディーアート/ボディアート/
bodybag /ボディバッグ/
bodyblow /ボディーブロー/ボディブロー/
bodyboard /ボディボード/ボディーボード/
bodybuil /ボディビル/
bodybuild /ボディビル/ボディービル/
bodybuilder /ボディビルダー/
bodybuilding /ボディビルディング/
bodycare /ボディケア/
bodycheck /ボディチェック;和製英語(frisk)/ボディーチェック/
bodycolor /ボディーカラー/
bodycolour /ボディーカラー/
bodycon /ボディコン;body-conscious/
bodycream /ボディクリーム/ボディークリーム/
bodyguard /ボディガード/ボディーガード/
bodylanguage /ボディランゲージ/
bodyline /ボディライン/ボディーライン/
bodylotion /ボディローション/ボディーローション/
bodymake /ボディメイク/
bodypaint /ボディペイント/
bodypainting /ボディペインティング/
bodypercussion /ボディパーカッション/ボディーパーカッション/
bodypierce /ボディピアス/ボディーピアス/
bodypress /ボディプレス/
bodyshampoo /ボディシャンプー/
bodysize /ボディサイズ/ボディーサイズ/
bodyslam /ボディスラム/
bodysoap /ボディソープ/ボディーソープ/
boeing /ボーイング;www.boeing.com/
bogart /ボガート/
bogen /ボーゲン/
bogey /ボギー/
bogota /ボゴタ;コロンビア/
bohemia /ボヘミア/
bohemian /ボヘミアン/
bohm /ベーム/
bohn /ボーン/
bohr /ボーア/
bohringer /ボーランジェ/
boil /ボイル/
boiled /ボイルド/
boiler /ボイラー/ボイラ/
boiotia /ボイオティア/
boke /ボケ/
bolan /ボラン/
bold /ボールド/
bolero /ボレロ/
bolivia /ボリビア;.bo/
bolo /ボーロ/
bologna /ボローニャ/
bolsheviki /ボリシェヴィキ;Bol'sheviki/
bolshoi /ボリショイ;(露語)/
bolt /ボルト/
boltzmann /ボルツマン/
bomb /ボム/
bombay /ボンベイ/
bombe /ボンベ;(独語)/ボンブ;(仏語)/
bomber /ボンバー/
bombo /ボンバ/ボンボ/
bon /ボン/
bonanza /ボナンザ/
bonaparte /ボナパルト/
bonbon /ボンボン/
bond /ボンド/
bondage /ボンデージ/
bonds /ボンズ/
bone /ボーン/
bonechina /ボーンチャイナ/
bonehead /ボーンヘッド/
boneless /ボンレス/
bonelessham /ボンレスハム/
bongo /ボンゴ/
bongoes /ボンゴ/
bonheur /ボヌール;(Fr)幸福/
bonita /ボニータ/
bonjour /ボンジュール/
bonn /ボン/
bonnard /ボナール/
bonnet /ボンネット/
bonney /ボニー/
bonnie /ボニー/
bonny /ボニー/
bonus /ボーナス/
bonustrack /ボーナストラック/
boo /ブー/
booby /ブービー/
boogie /ブギー/ブギ/
boogiewoogie /ブギウギ/
booing /ブーイング/
book /ブック/Book/
bookcase /ブックケース/
bookcenter /ブックセンター/
bookcover /ブックカバー;和製英語(jacket)/
bookdesign /ブックデザイン/
bookend /ブックエンド/
booker /ブッカー/
bookfair /ブックフェア/
bookguide /ブックガイド/
booking /ブッキング/
booklet /ブックレット/
booklist /ブックリスト/
bookmaker /ブックメーカー/
bookmark /ブックマーク/
bookmart /ブックマート/
bookoff /ブックオフ;www.bookoff.co.jp/
bookpost /ブックポスト/
bookreview /ブックレビュー/
books /ブックス/
bookservice /ブックサービス/
bookshelf /ブックシェルフ/
bookstand /ブックスタンド/
bookstore /ブックストア/
bool /ブール/
boole /ブール/
boolean /ブーリアン/ブーリアン関数/
boom /ブーム/
boomer /ブーマー/
boomerang /ブーメラン/
boost /ブースト/
booster /ブースター/
boot /ブート/
bootable /ブータブル/
bootdisk /ブートディスク/
booth /ブース/
bootleg /ブートレグ/ブートレッグ/
bootloader /ブートローダ/ブートローダー/
boots /ブーツ/
bootsector /ブートセクタ/
bootstrap /ブートストラップ/
bop /バップ/
borane /ボラン;BH3/
bord /ボード;坑道/
bordeaux /ボルドー/
borden /ボーデン/
border /ボーダー/
bordercollie /ボーダーコリー;border collie/
borderless /ボーダレス/ボーダーレス/
borderline /ボーダーライン/
bore /ボア/
boreas /ボレアス;北風/
borel /ボレル/
borg /ボーグ;cyborg/ボルグ/
borges /ボルヘス/
borgia /ボルジア/
borie /ボリー/
boring /ボーリング/
boris /ボリス/
borland /ボーランド/
born /ボーン/
borne /ボーン/
borneo /ボルネオ/
borneol /ボルネオール/
borodin /ボロディン/
boron /ボロン;B/
boronia /ボロニア/
borromeo /ボロメオ/
borrow /ボロー/バロー/バロウ/
borshch /ボルシチ;(露語)борщ/
borzoi /ボルゾイ/
bosch /ボッシュ/
bose /ボーズ/ボース/
bosendorfer /ベーゼンドルファー/
bosnia /ボスニア/
boson /ボソン/ボース粒子/
bosporus /ボスポラス/ボスポラス海峡/
boss /ボス/
bossa /ボサ;波/ボッサ/
bossanova /ボサノバ;bossa nova/ボサノヴァ/
boston /ボストン/ボストン大学/
bostonbag /ボストンバッグ/
bostonterrier /ボストンテリア/
bot /ボット;robot/⊥/
botanical /ボタニカル/
both /ボス/
botswana /ボツワナ;.bw/
botticelli /ボッティチェリ/
bottle /ボトル/
bottlekeep /ボトルキープ;和製英語/
bottlemail /ボトルメール/
bottleneck /ボトルネック/
bottling /ボトリング/
bottom /ボトム/⊥/下/底/
bottomline /ボトムライン/
bottoms /ボトムス/
bottomup /ボトムアップ/
botulinus /ボツリヌス/
bougainvillea /ブーゲンビリア/ブーゲンビレア/
bouillabaisse /ブイヤベース/
bouillon /ブイヨン/
boulanger /ブーランジェ;(Fr)パン職人/ブランジェ/
boulangerie /ブーランジェリー;(Fr)パン屋/ブランジェリー/ブーランジュリー/ブランジュリー/
boulevard /ブールバール/ブールヴァール/
boulez /ブーレーズ/ブレーズ/
boulogne /ブローニュ/ブーローニュ/
bounce /バウンス/
bound /バウンド/
boundary /バウンダリー/バウンダリ/
bounding /バウンディング/
bouquet /ブーケ/
bouquetgarni /ブーケガルニ/
bourbaki /ブルバキ/
bourbon /バーボン/ブルボン/
bourdieu /ブルデュー/
bourgeois /ブルジョワ/ブルジョア/
bourgeoisie /ブルジョアジー/ブルジョワジー/
bourges /ブールジュ/
bourgogne /ブルゴーニュ/
boutique /ブティック/
boutiquehotel /ブティックホテル;boutique hotel/
bouzouki /ブズーキ/
bovary /ボヴァリー/
bow /ボウ;弓/バウ;お辞儀/
bowgun /ボウガン/ボーガン/
bowie /ボウイ/
bowing /ボーイング;運弓/ボウイング/
bowl /ボール/ボウル/
bowling /ボーリング/ボウリング/
box /ボックス/□/■/
boxer /ボクサー/
boxercise /ボクササイズ/
boxerpants /ボクサーパンツ/
boxing /ボクシング/
boxseat /ボックスシート/
boxset /BOXセット/ボックスセット/
boy /ボーイ/
boycott /ボイコット/
boyer /ボイヤー/ボワイエ/
boyfriend /ボーイフレンド/
boyish /ボーイッシュ/
boyle /ボイル/
boys /ボーイズ/
boyscout /ボーイスカウト/
boyslove /ボーイズラブ;boy's love,和製英語(=yaoi)/
boysoprano /ボーイソプラノ/
bq /“;backquote/
br /臭素/Bromine/
bra /ブラ;brassiere/
brabus /ブラバス;www.brabus.com/
brace /ブレース/｛/｝/
bracelet /ブレスレット/
bracket /ブラケット/［/］/
brad /ブラッド/
bradbury /ブラッドベリ/
bradley /ブラッドリー/ブラッドレイ/ブラッドレー/
brady /ブレイディ/ブレディ/ブレイディー/ブレディー/
brahman /ブラフマン/ブラーマン/ブラフマー/
brahmana /バラモン/
brahmin /バラモン/
brahms /ブラームス/
brain /ブレイン/ブレーン/
brainbuster /ブレーンバスター/
brainstorming /ブレーンストーミング/ブレインストーミング/
brake /ブレーキ/
brakedrum /ブレーキドラム/
brakelamp /ブレーキランプ/
brakelever /ブレーキレバー/
brakeoil /ブレーキオイル/
brakepedal /ブレーキペダル/
braking /ブレーキング/
bram /ブラム/
bramante /ブラマンテ/
branca /ブランカ/
branch /ブランチ/
brand /ブランド/
brandenburg /ブランデンブルク/
brandimage /ブランドイメージ/
branding /ブランディング/
brandmaker /ブランドメーカー/
brando /ブランド/
brandon /ブランドン/
brands /ブランズ/
brandshop /ブランドショップ/
brandt /ブラント/
brandy /ブランデー/
branford /ブランフォード/
brank /Bランク/Ｂランク/
braque /ブラック/
brasilia /ブラジリア/
brass /ブラス/
brassband /ブラスバンド/
brassiere /ブラジャー/
brassy /ブラッシー/
brat /ブラット/
bratislava /ブラチスラヴァ/
braudel /ブローデル/
braun /ブラウン;-管/
brautigan /ブローティガン/
brave /ブレイブ/
braves /ブレーブス;[MLB]/
bravo /ブラボー/ブラヴォー/ブラーボ/ブラーヴォ/
bray /ブレイ/ブレー/
brazil /ブラジル;.br/
brazilgp /ブラジルGP;[F1]/
brazilian /ブラジリアン/
brazzaville /ブラザヴィル/
bread /ブレッド/
break /ブレイク/ブレーク/ブレーキ;※brake?/
breakbeats /ブレイクビーツ/
breakdance /ブレイクダンス/
breakdancer /ブレイクダンサー/
breakdown /ブレークダウン/
breaker /ブレーカー/ブレーカ/
breakfast /ブレックファースト/
breaking /ブレーキング/
breakpoint /ブレークポイント/ブレイクポイント/
breakthrough /ブレークスルー/ブレイクスルー/
breast /ブレスト/
breath /ブレス/
breathe /ブリーズ/
breathing /ブリージング/ブレッシング/
brecht /ブレヒト/
brecker /ブレッカー/
bree /ブリー/ブレー/
breed /ブリード/
breeder /ブリーダー/
breeding /ブリーディング/
breeze /ブリーズ/
breezing /ブリージング/
bremen /ブレーメン/
brenda /ブレンダ/
brendan /ブレンダン/
brendel /ブレンデル/
brentano /ブレンターノ/
bresenham /ブレゼンハム/
bresson /ブレッソン;Henri Cartier-Bresson/
brest /ブレスト/
bret /ブレット/
bretagne /ブルターニュ/
breton /ブルトン/ブレトン/
brett /ブレット/
bretton /ブレトン/
brettonwoods /ブレトンウッズ;Bretton Woods/
brevis /ブレビス/ブレヴィス/
brewers /ブリュワーズ;[MLB]/
brewery /ブルワリー/
brezhnev /ブレジネフ/
brian /ブライアン/
bribri /ブリブリ/
brice /ブライス/
brick /ブリック/
bricolage /ブリコラージュ/
bridal /ブライダル/
bride /ブライド/
bridge /ブリッジ/
bridgestone /ブリヂストン;www.bridgestone.co.jp/ブリジストン/
bridget /ブリジット/
bridgetown /ブリッジタウン/
bridging /ブリッジング/
brief /ブリーフ/
briefcase /ブリーフケース/
briefing /ブリーフィング/
bright /ブライト/
brightness /ブライトネス/
brigid /ブリジッド/
brigit /ブリジット/
brigitte /ブリジット/ブリギッテ/
brillante /ブリランテ/
brillat /ブリア/ブリヤ/
brilliant /ブリリアント/
brilliantcut /ブリリアントカット/
bring /ブリング/
brio /ブリオ/
brioche /ブリオッシュ/
brion /ブリオン/
brisbane /ブリスベン;豪州/ブリスベーン/ブリズベーン/
brisee /ブリゼ/
bristol /ブリストル/
brit /ブリット/
britain /ブリテン;.gb/
britannia /ブリタニア/
britannica /ブリタニカ/
british /イギリス/ブリティッシュ/
britney /ブリトニー/
britten /ブリテン/
brix /ブリックス/
brno /ブルノ/
broach /ブローチ;(工具)/
broad /ブロード/
broadband /ブロードバンド/
broadbandrouter /ブロードバンドルータ/
broadcast /ブロードキャスト/
broadcaster /ブロードキャスター/
broadsword /ブロードソード/
broadway /ブロードウェイ/ブロードウェー/
broca /ブローカ/
broccoli /ブロッコリー/
broch /ブロッホ/
brocken /ブロッケン/
broderick /ブロデリック/
broglie /ブロイ/
broiler /ブロイラー/
broke /ブローク/
broken /ブロークン/
broker /ブローカー/
brom /ブロム;Br/
bromide /ブロマイド/
bromo /ブロモ/
bromodichloromethane /ブロモジクロロメタン;(CHBrCl2) トリハロメタンの一種/
bromoform /ブロモホルム;(CHBr3) トリハロメタンの一種/
bronte /ブロンテ/
bronx /ブロンクス/
bronze /ブロンズ/
brooch /ブローチ/
brook /ブルック/
brookes /ブルックス/
brooklyn /ブルックリン/
brooks /ブルックス/
brother /ブラザー/
brotherhood /ブラザーフッド/
brothers /ブラザーズ/
brouter /ブルータ/
brow /ブラウ;眉/ブロウ;?/
brown /ブラウン/
brownie /ブラウニー/
browning /ブラウニング/ブローニング/
brownsauce /ブラウンソース/
brownsugar /ブラウンシュガー/
browny /ブラウニー/
browse /ブラウズ/
browser /ブラウザ/ブラウザー/
browsersoft /ブラウザソフト/
browsing /ブラウジング/
browzer /ブラウザ;browser?/
brubeck /ブルーベック/
bruce /ブルース/
bruckner /ブルックナー;(1824-96)Josef Anton Bruckner/
brueghel /ブリューゲル/
brule /ブリュレ/
brulee /ブリュレ/
brumaire /ブリュメール/
brunch /ブランチ/
brunei /ブルネイ/
brunelleschi /ブルネレスキ/
brunello /ブルネッロ/
brunette /ブルネット/
brunhild /ブリュンヒルト/
brunhilde /ブリュンヒルデ/
bruni /ブルーニ/
brunnhilde /ブリュンヒルデ/
bruno /ブルーノ/ブリューノ/ブリュノ/
brunswick /ブランズウィック/
bruschetta /ブルスケッタ/
brush /ブラシ/ブラッシュ/
brushing /ブラッシング/
brushup /ブラッシュアップ/
brussels /ブラッセル/
brut /ブリュット/
brute /ブルート/
brutus /ブルータス/
bruxelles /ブリュッセル/
bryan /ブライアン/
bryant /ブライアント/
bryce /ブライス/
bsantenna /BSアンテナ/
bsd /BSD/
bsd# /(concat "BSD\057#0")/
bsdi /BSDI/
bsdigital /BSデジタル/
bsdlicence /BSDライセンス/
bsdlicense /BSDライセンス/
bse /Bovine Spongiform Encephalopathy/
bskey /BSキー/バックスペースキー/
bspline /Bスプライン/
bstuner /BSチューナー/BSチューナ/
btype /Bタイプ/Ｂタイプ/
bubble /バブル/
bubblegum /バブルガム/
bubblejet /バブルジェット/
bubblesort /バブルソート/
bubbling /バブリング/
bubbly /バブリー/
bubbule /バブル;※bubble?/
bucharest /ブカレスト/
buche /ビュッシュ/
buchwald /ブッフバルト/
buck /バック/ブック/
bucket /バケット/バケツ/
bucketrelay /バケツリレー;和製英語(bucket brigade)/
buckingham /バッキンガム/
buckle /バックル/
buckler /バックラー/
buckskin /バックスキン/
bucky /バッキー/
bud /バド/バッド/
budapest /ブダペスト/
buddha /ブッダ/仏陀/
buddhagaya /ブッダガヤ/
buddy /バディ/
budget /バジェット/
budweiser /バドワイザー/
buena /ブエナ/
bueno /ブエノ/
buenos /ブエノス/
buenosaires /ブエノスアイレス;Buenos Aires/
buffalo /バッファロー/バファロー/
buffaloes /バファローズ/バッファローズ/
buffer /バッファ/バッファー/作業域/
buffered /バッファード/
bufferin /バファリン;[商標]ライオン。www.bufferin.net/
buffering /バッファリング/
bufferoverflow /バッファオーバーフロー/
bufferoverrun /バッファオーバーラン/
buffersize /バッファサイズ/
buffet /ビュッフェ/
buffle /バッフル/
buffon /ブッフォン/
bug /バグ/
bugfix /バグフィックス/バグフィクス/
buggy /バギー/
bugle /ビューグル/
buglist /バグリスト/
bugreport /バグレポート/
buick /ビュイック;www.buick.com/
buil /ビル/
build /ビルド/
builder /ビルダー/ビルダ/
buildin /ビルドイン/
building /ビルディング/ビル/ビルヂング/
built-in /ビルトイン/
builtin /ビルトイン/
bujumbura /ブジュンブラ/
bukhara /ブハラ/
bukowski /ブコウスキー/
bulb /バルブ/
bulgari /ブルガリ;www.bulgari.com/
bulgaria /ブルガリア;.bg/
bulgogi /プルコギ;(朝鮮語)/
bulk /バルク/
bull /ブル/
bulldog /ブルドッグ/ブルドック;[企業名]www.bulldog.co.jp/
bulldozer /ブルドーザー/ブルドーザ/
bulletin /ブリテン/
bulletinboard /ブレティンボード/
bullpen /ブルペン/
bump /バンプ/
bumper /バンパー/
bumpmapping /バンプマッピング/
buncher /バンチャ/
bundesliga /ブンデスリーガ;(独語)/
bundle /バンドル/
bundling /バンドリング/
bungalow /バンガロー/
bungee /バンジー/
bungeejump /バンジージャンプ/
bunin /ブーニン/
bunker /バンカー;[ゴルフ]/
bunkershot /バンカーショット/
bunny /バニー/
bunnygirl /バニーガール/
buns /バンズ/
bunt /バント/
bunuel /ブニュエル/
buoy /ブイ/
burberry /バーバリー;www.burberry.com/
burckhardt /ブルクハルト/
burden /バーデン/
bureau /ビューロー/
burg /ブルク;(独語接尾辞)Salzburg,Luxemburg/
burger /バーガー/
burgerking /バーガーキング;www.bk.com/
burgmuller /ブルグミュラー/
burgos /ブルゴス/
burgundy /バーガンディー/バーガンディ/
burial /ベリアル/
burka /ブルカ/
burkinafaso /ブルキナファソ;Burkina Faso,(Burkina Faso) .bf/
burlesque /バーレスク/
burma /ビルマ/
burn /バーン/
burnaby /バーナビー/
burner /バーナー/
burnet /バーネット;ワレモコウ/
burning /バーニング/
burnout /バーンアウト/
burns /バーンズ/
burnt /バーント/
burrell /バレル/
burroughs /バロウズ/バローズ/
burst /バースト/
burster /バースター/
burt /バート/
burton /バートン/
burundi /ブルンジ;.bi/ブルンディ/
buryat /ブリャート/
bus /バス/
busch /ブッシュ/
busclock /バスクロック/
buserror /バスエラー/Ｂｕｓ Ｅｒｒｏｒ/
busguide /バスガイド;和製英語(bus tour guide)/
bush /ブッシュ/
bushbaby /ブッシュベイビー/
bushman /ブッシュマン/
business /ビジネス;.biz/
businesscenter /ビジネスセンター/
businesscentre /ビジネスセンター/
businesschance /ビジネスチャンス/
businessclass /ビジネスクラス/
businesshotel /ビジネスホテル/
businessletter /ビジネスレター/
businesslike /ビジネスライク/
businessman /ビジネスマン/
businessmanner /ビジネスマナー/
businessmodel /ビジネスモデル/
businessperson /ビジネスパーソン/
businessplan /ビジネスプラン/
businessscene /ビジネスシーン/
businessschool /ビジネススクール/
businesssoft /ビジネスソフト/
busjack /バスジャック/
busmaster /バスマスタ/バスマスター/
buspower /バスパワー/
busstop /バスストップ/
bust /バスト/
buster /バスター/
busterminal /バスターミナル/
busters /バスターズ/
bustier /ビスチェ/
bustline /バストライン/
bustour /バスツアー;bus tour/
bustsize /バストサイズ/
busttop /バストトップ/
bustup /バストアップ;和製英語/
busy /ビジー/ビジィ/
but /バット/
butadiene /ブタジエン/
butan /ブタン;C4H10/
butane /ブタン;C4H10/
butanol /ブタノール;C4H9OH/
butch /ブッチ/
butcher /ブッチャー/
butene /ブテン;=butylene/
butler /バトラー/
butor /ビュトール/
butt /バット/ブット/
butter /バター/
buttercream /バタークリーム/
buttercup /バターカップ/
butterfly /バタフライ/
butterflyknife /バタフライナイフ/
butterknife /バターナイフ/
butterrice /バターライス/
butterroll /バターロール;和製語/
buttersauce /バターソース/
butterworth /バタワース/
butting /バッティング/
button /ボタン/バトン;人名/
buttonhole /ボタンホール/ボタン穴/
butyl /ブチル;CH3CH2CH2CH2-/
butylene /ブチレン/
buy /バイ/
buyer /バイヤー/
buyers /バイヤーズ/
buying /バイイング/
buyout /バイアウト/
buzz /バズ/
buzzer /ブザー/
buzzing /バジング/
bvlgari /ブルガリ;vはラテン語表記を模したもの/
by /バイ/
bye /バイ/バーイ/
byebye /バイバイ;bye-bye/
bypass /バイパス/
bypath /バイパス/
byron /バイロン/
byte /バイト/Ｂｙｔｅ/
byte-compile /バイトコンパイル/
byte-compiler /バイトコンパイラ/
bytecode /バイトコード/
bytecompile /バイトコンパイル/
bytecompiler /バイトコンパイラ/
bytes /バイツ/
byzantine /ビザンチン/
c /℃/¢;cent/シー/ツェー;(独語)/セー;(仏語)/炭素/Carbon/Ｃ言語/
c++ /Ｃ＋＋/C++/
c++compiler /C++コンパイラ/
ca /カルシウム/Calcium/California/カリフォルニア/カルフォルニア/
caay /チャイ;Hindi/
cab /キャブ/
cabaca /カバサ/
cabala /カバラ/
cabaret /キャバレー/
cabbage /キャベツ/
cabernet /カベルネ/
cabin /キャビン/
cabinet /キャビネット/キャビネ;仏語/
cable /ケーブル/
cablecar /ケーブルカー/
cablemodem /ケーブルモデム/
cabletv /ケーブルテレビ/ケーブルTV/
cabling /ケーブリング/
caboverde /カーボベルデ;(Cabo Verde) .cv/カーボヴェルデ/
cabrera /カブレラ/
cacao /カカオ/
cachable /キャッシャブル/
cache /キャッシュ/
cachememory /キャッシュメモリ/キャッシュメモリー/
caching /キャッシング/
caco /カコ/
cactus /カクタス;サボテン/
cad /CAD/キャド;computer-aided design/
caddie /キャディ/キャディー/
caddy /キャディ/キャディー/
cadence /ケイデンス/
cadenza /カデンツァ/
cadet /カデット/
cadfael /カドフェル/
cadillac /キャデラック/
cadiz /カディス/
cadmium /カドミウム;[元素]48,Cd/
cadsoft /CADソフト/
cady /キャディー/
caen /カーン/
caesar /シーザー/カエサル/
caesium /セシウム;[元素]55,Cs/
caetla /サエラ;(Fr)ca et la/
cafe /カフェ/
cafeaulait /カフェオレ;cafe au lait/カフェ・オ・レ/
cafebar /カフェバー/
cafelatte /カフェラッテ;(It)cafe latte/
cafeteria /カフェテリア/
cafeterrace /カフェテラス/
cafeterrasse /カフェテラス/
caffeine /カフェイン/
cage /ケージ/
cagliari /カリアリ/
cagliostro /カリオストロ/
cahier /カイエ;(Fr)ノート/
caillois /カイヨワ/
caiman /カイマン/
cain /カイン/ケイン/
caine /ケイン/
cairns /ケアンズ;豪州/
cairo /カイロ/
caisson /ケーソン/
cajon /カホン/
cajun /ケイジャン/
cake /ケーキ/
cakecut /ケーキカット;和製英語/
cakemix /ケーキミックス;cake mix/
cakeset /ケーキセット/
cakewalk /ケークウォーク/
cakra /チャクラ/
calais /カレー/
calbee /カルビー;www.calbee.co.jp/
calceolaria /カルセオラリア/
calcite /カルサイト;方解石/
calcium /カルシウム;[元素]20,Ca/
calciumion /カルシウムイオン;calcium ion/
calculus /カルキュラス/
calcutta /カルカッタ;NB:現在は「コルカタ」/コルカタ;kolkata/
caldera /カルデラ/
caldina /カルディナ/
caleca /カレカ/
caledonia /カレドニア/
calendar /カレンダー/カレンダ/
calender /カレンダ/
calgary /カルガリー/
caliber /キャリバー/
calibration /キャリブレーション/
calico /キャラコ/キャリコ/
calif /カリフ/
california /カリフォルニア/カルフォルニア/
californium /カリフォルニウム;[元素]98,Cf/
caligari /カリガリ/
caligula /カリギュラ/
calimba /カリンバ/
caliph /カリフ/
call /コール/
callas /カラス/
callaway /キャロウェイ/
callback /コールバック/
callcenter /コールセンター/
callcentre /コールセンター/
called /コールド/
calledgame /コールドゲーム;和製英語/
caller /コーラー/呼出し側/
callgirl /コールガール/
calligraphy /カリグラフィー/カリグラフィ/
calling /コーリング/
calliope /カリオペ/
callisto /カリスト/
callose /カロース/
calloway /キャロウェイ/
callsign /コールサイン/
callus /カルス/
calm /カーム/
calme /カルム;仏語/
calorie /カロリー/
caloriemate /カロリーメイト/
calpis /カルピス;www.calpis.co.jp/
caltech /カルテック;カリフォルニア工科大学。www.caltech.edu/
calume /カルメ/
calvados /カルヴァドス/カルバドス/
calvan /カルバン/カルヴァン/
calvary /カルバリー/
calvin /カルヴァン/カルヴィン/カルビン/
calvinklein /カルバンクライン/カルバン・クライン/
calvino /カルヴィーノ;(1923-1985) Italo Calvino/
calypso /カリプソ/
cam /カム/
camara /カマラ/
camber /キャンバー/
cambodia /カンボジア;.kh/
cambria /カンブリア/
cambridge /ケンブリッジ/
camel /キャメル/
camelia /カメリア/
camellia /カメリア/
camelot /キャメロット/
camembert /カマンベール/
cameo /カメオ/
camera /カメラ/
cameraangle /カメラアングル;camera angle/
cameraeye /カメラアイ/
cameraman /カメラマン/
camerawork /カメラワーク/
cameron /キャメロン/
cameroon /カメルーン;.cm/
cameroun /カメルーン/
camilla /カミラ/
camille /カミーユ/
camino /カミーノ/
camion /カミオン/
camisole /キャミソール/
camoranesi /カモラネージ/
camouflage /カモフラージュ/カムフラージュ/
camp /キャンプ/
campaign /キャンペーン/
campaigngirl /キャンペーンガール/キャンギャル/
campana /カンパーナ/
campanella /カンパネラ/カンパネルラ/カンパネッラ/
campanula /カンパニュラ/
campari /カンパリ/
campariorange /カンパリオレンジ/
camparisoda /カンパリソーダ/
campbell /キャンベル/
camper /キャンパー/
campfire /キャンプファイヤー/キャンプファイアー/
camphor /カンフル/
campin /キャンプイン;和製英語/
camping /キャンピング/
campingcar /キャンピングカー;和製英語(camper)/
campo /カンポ;(西語) 草原/
campos /カンポス/
campra /カンプラ/
campus /キャンパス/
campuslife /キャンパスライフ/
campusmap /キャンパスマップ/
camry /カムリ;[商標]トヨタ/
camus /カミュ/
can /キャン/カン;缶/
canaan /カナン/カナーン/
canada /カナダ;.ca/加奈陀/
canadagp /カナダGP;[F1]/
canadian /カナディアン/
canal /カナル/キャナル/
canape /カナッペ/
canard /カナード/カナール;(Fr) 家鴨/
canaria /カナリア/カナリヤ/
canary /カナリア/カナリヤ/
canasta /カナスタ/
canberra /キャンベラ/
cancan /カンカン/
cancel /キャンセル/
canceler /キャンセラ/
cancellation /キャンセレーション/
canceller /キャンセラー/キャンセラ/
cancer /キャンサー;癌/
cancion /カンシオン;(西語)歌/
cancun /カンクン;メキシコ/
candela /カンデラ;cd/
candice /キャンディス/
candid /カンディード/キャンディッド/
candida /カンジダ/
candide /カンディード/
candies /キャンディーズ/
candle /キャンドル/
candlelight /キャンドルライト/
candleservice /キャンドルサービス/
candlestand /キャンドルスタンド/
candy /キャンディ/キャンディー/キャンデー/
cane /ケイン/ケーン/籐/
canet /カネ/
canetti /カネッティ/
canister /キャニスター/
canna /カンナ/
cannabis /カンナビス/
canne /カンヌ/
cannedbeef /コンビーフ/
cannele /カヌレ/
cannes /カンヌ/
cannibalism /カニバリズム/
cannon /キャノン/
cannonball /キャノンボール/
canoe /カヌー/
canola /キャノーラ/カノーラ/
canon /カノン/キャノン/キヤノン;[企業名]www.canon.com/
canonical /カノニカル/
canopus /カノープス/
canopy /キャノピー/
canossa /カノッサ/
cant /カント/
cantabile /カンタービレ/
cantata /カンタータ/交声曲/
canter /キャンター/カンター/
canterbury /カンタベリー/
canto /カント/
cantona /カントナ/
cantor /カントール/カントル/
canvas /キャンバス/カンバス/カンヴァス/
canvastop /キャンバストップ/
canyon /キャニオン/
canzone /カンツォーネ/
canzonette /カンツォネッタ/
cap /キャップ/∩/
capa /キャパ/
capability /ケーパビリティ/
capacitance /キャパシタンス/
capacity /キャパシティ/キャパシティー/
capati /チャパティ/
capcom /カプコン;www.capcom.co.jp/
cape /ケープ/
capek /チャペック/
capella /カペラ/
caper /ケイパー/ケーパー/
capet /カペー/
capetown /ケープタウン/
capeverde /カーボベルデ;Cape Verde (cv)/
capital /キャピタル/
capitalgain /キャピタルゲイン/
capitalism /キャピタリズム/
capitol /キャピトル/
capo /カーポ/
capoeira /カポエイラ/カポエラ/
caponata /カポナータ/
capote /カポーテ/カポーティ/
cappadocia /カッパドキア/
cappuccino /カプチーノ;イタリア語/
capra /キャプラ/
capri /カプリ/
capriccio /カプリッチョ/カプリッチオ/
capriccioso /カプリチオーソ/
caprice /カプリス/
capricious /カプリシャス/
capricorn /カプリコーン;山羊座/カプリコン/
capripants /カプリパンツ;capri pants/
caprolactam /カプロラクタム/
capsaicin /カプサイシン/
capsule /カプセル/
capsulehotel /カプセルホテル;和製英語/
captain /キャプテン/
captaincy /キャプテンシー/
caption /キャプション/
capture /キャプチャ/キャプチャー/取込/
captureboard /キャプチャボード/キャプチャーボード/
capturecard /キャプチャカード/キャプチャーカード/
capybara /カピバラ/
car /カー/
cara /キャラ/カラ/カーラ/
caracas /カラカス/
caramel /キャラメル/カラメル/
caramelo /カルメラ/
caraque /カラク/
carat /カラット;200mg/キャラット/
caraudio /カーオーディオ/
caravan /キャラバン/キャラヴァン/
caravansarai /キャラバンサライ/
caravansary /キャラバンサライ/
caraway /キャラウェイ/
carbattery /カーバッテリー/
carbide /カーバイド/
carbine /カービン/
carbon /カーボン/
carbonara /カルボナーラ/
carbonate /カーボネイト/カーボネート/
carboncopy /カーボンコピー;CC/
carbonfiber /カーボンファイバー/
carbonnanotube /カーボンナノチューブ/
carbonyl /カルボニル/
carboxyl /カルボキシル/
carbuncle /カーバンクル/
carburetor /キャブレター/キャブ/
carchase /カーチェイス/
card /カード/
cardamon /カルダモン/
cardbus /カードバス/
cardcase /カードケース/
cardealer /カーディーラー/
cardgame /カードゲーム/
cardiff /カーディフ/
cardigan /カーディガン/
cardin /カルダン/
cardinal /カーディナル/
cardinals /カージナルス;[MLB]/
cardioid /カージオイド/カーディオイド/
cardloan /カードローン/
cardmodem /カードモデム/
cardreader /カードリーダー/カードリーダ/
cards /トランプ/カーズ/
cardslot /カードスロット/
cardwindow /カードウインドー/
care /ケア/
career /キャリア/キャリアー/
careerpath /キャリアパス/
careerplan /キャリアプラン/
careerup /キャリアアップ;和製英語/
careerwoman /キャリアウーマン/
careful /ケアフル/
carehouse /ケアハウス/
careless /ケアレス/
carelessmiss /ケアレスミス/
caremanagement /ケアマネジメント/
caremanager /ケアマネージャー/
careplan /ケアプラン/
caret /カレット;^/キャレット/
carey /キャリー/
carferry /カーフェリー;和製英語/
cargo /カーゴ/
carib /カリブ/
caribbean /カリビアン/
caribou /カリブー/
caricature /カリカチュア/
carillon /カリヨン/
carina /カリーナ/
carini /カリーニ/
carita /カリタ/
caritas /カリタス/
carl /カール/
carla /カーラ/カルラ/
carlease /カーリース/
carlife /カーライフ/
carlo /カルロ/
carlos /カルロス/
carlotta /カルロッタ/
carlson /カールソン/
carlton /カールトン/
carlyle /カーライル/
carmela /カルメラ/
carmen /カルメン/カーメン/
carmichael /カーマイケル/
carmine /カーマイン/カルミン/カーミン/
carmona /カルモナ/
carna /カルナ/
carnation /カーネーション/
carnaval /カルナバル/
carnavi /カーナビ;car navigation system/
carnavigation /カーナビゲーション;car navigation system/
carnegie /カーネギー/カーネギーメロン大学/
carnegiemellon /カーネギーメロン/
carnelian /カーネリアン/
carnet /カルネ/
carney /カーニー/
carnival /カーニバル/
carnot /カルノー/
carnotcycle /カルノーサイクル/
carol /キャロル/
carole /キャロル/
carolina /キャロライナ/カロライナ/カロリーナ/カロリナ/
caroline /キャロライン/キャロリン/カロリーヌ/
caroling /カロリング/
carolyn /キャロリン/キャロライン/カロリン/
carossa /カロッサ/
carotene /カロチン/カロテン/
carotenoid /カロチノイド/カロテノイド/
carothers /カロザース/
carotin /カロチン/カロテン/
carotinoid /カロチノイド/カロテノイド/
carousel /カルーセル/
carp /カープ/
carpaccio /カルパッチョ/
carpathia /カルパチア/
carpeaux /カルポー/
carpenter /カーペンター/
carpenters /カーペンターズ/
carpet /カーペット/
carport /カーポート/
carr /カー/
carrace /カーレース/
carrageenin /カラギーナン/
carrasco /カラスコ/
carre /カレ/
carrefour /カルフール;(Fr)十字路/
carreras /カレーラス/
carriage /キャリッジ/
carrie /キャリー/
carrier /キャリア/キャリアー/
carriere /カリエール/
carrol /キャロル/
carroll /キャロル/
carrot /キャロット/
carry /キャリー/カレー;※curry?/
carrybag /キャリーバッグ/
carrying /キャリング/
carryingcase /キャリングケース/
carryover /キャリーオーバー/
cars /カーズ/
carsex /カーセックス/
carshop /カーショップ/
carson /カーソン/
carsten /カルステン/
carstereo /カーステレオ/
cart /カート/
carta /カルタ;(葡語)/
carte /カルテ/カルト;(Fr) カード。 cf. a la carte/
cartel /カルテル/
carter /カーター/
cartesian /カルテジアン/
carthago /カルタゴ/
cartier /カルティエ;www.cartier.com/
cartinine /カルニチン/
carton /カートン/カルトン/
cartoon /カートゥーン/
cartrace /カートレース/
cartridge /カートリッジ/
cartrige /カートリッジ;※cartridge/
carve /カーブ;彫る/カーヴ/
carver /カーヴァー/カーバー/
carving /カービング/
cary /ケアリー/ケーリー/
casa /カーサ/
casablanca /カサブランカ/
casals /カザルス/
casanova /カサノヴァ/カサノバ/
casas /カサス/
cascade /カスケード/
cascading /カスケーディング/
case /ケース/ケイス/CASE/
casebycase /ケースバイケース/
casein /カゼイン/
casestudy /ケーススタディ/ケーススタディー/
casette /カセット/
casettedeck /カセットデッキ/
casettetape /カセットテープ/
caseworker /ケースワーカー/
cash /キャッシュ/
cashback /キャッシュバック/
cashcard /キャッシュカード/
cashcorner /キャッシュコーナー/
cashdispencer /キャッシュディスペンサー/
cashe /キャッシュ;※cache?/
cashew /カシュー/
cashewnut /カシューナッツ/
cashflow /キャッシュフロー/
cashier /キャッシャー/
cashing /キャッシング/
cashless /キャッシュレス/
cashmere /カシミヤ/カシミア/
casimir /カシミール/
casing /ケーシング/
casino /カジノ/
casio /カシオ/
casiopea /カシオペア;バンド名 (NB:星座名はcassiopeia)/
cask /キャスク/
casl /CASL/
casper /カスパー/
casque /カスク/
cass /キャス/
cassandra /カサンドラ/カッサンドラ/
cassano /カッサーノ/
cassave /キャッサバ/
cassel /カッセル/
casserole /キャセロール/
cassette /カセット/
cassini /カッシーニ/
cassiopeia /カシオペア/
cassis /カシス/
cassissoda /カシスソーダ/
cassius /カシアス/
cassou /カスー/
cassoulet /カスレ/
casssini /カッシーニ/
cast /キャスト/
casta /カスタ/
castanet /カスタネット/
castanets /カスタネット/
caste /カースト/
castello /カステロ/
castelo /カステロ/
caster /キャスター/
castilla /カステラ/
casting /キャスティング/
castingvote /キャスティングボート/
castle /キャッスル/
castleton /キャッスルトン/
castor /カストル/カスター/
castrato /カストラート/
castries /カストリーズ/
castro /カストロ/
casual /カジュアル/
casualfashion /カジュアルファッション/
casualwear /カジュアルウェア/
cat /キャット/
cata /カタ/
catacomb /カタコンベ/
catacombe /カタコンベ/
catalina /カタリナ/カタリーナ/
catalog /カタログ/
catalogspec /カタログスペック/
catalogue /カタログ/
catalonia /カタロニア/
cataluna /カタルニア/
catalunya /カタルーニャ;スペイン/
catalyst /カタリスト/
catania /カターニア/
catanol /セタノール;C16H35OH/
catapult /カタパルト/
catarina /カタリナ/カタリーナ/
catarrh /カタル/
catastrophe /カタストロフ/
catastrophy /カタストロフィ/カタストロフィー/
catch /キャッチ/
catchball /キャッチボール/
catchcopy /キャッチコピー;和製英語/
catcher /キャッチャー/
catcherfly /キャッチャーフライ/
catchermit /キャッチャーミット/
catchphone /キャッチホン/
catchphrase /キャッチフレーズ/
catchsales /キャッチセールス;和製英語/
catchup /キャッチアップ/
catchy /キャッチー/
catechin /カテキン/
catechol /カテコール/
categorical /カテゴリカル/
categorise /カテゴライズ/
categorize /カテゴライズ/
category /カテゴリ/カテゴリー/範疇/
caterina /カテリーナ/
catering /ケータリング/
caterpillar /キャタピラ/
catfight /キャットファイト/
catfish /キャットフィッシュ;鯰/
catfood /キャットフード/
cath /キャス/
cathari /カタリ/
catharina /カタリナ/
catharsis /カタルシス/
cathay /キャセイ/カセイ/
cathedral /カテドラル/カセドラル/
cathereine /キャサリン/
catherine /キャサリン/カトリーヌ/
catheter /カテーテル/
cathode /カソード/
catholic /カトリック/カソリック/
catholicism /カトリシズム/
cathy /キャシー/
cation /カチオン/
catnip /キャットニップ/
cato /カトー/
cats /キャッツ/
catseye /キャッツアイ;cat's-eye/
catshow /キャットショー/
catsup /ケチャップ/
cattle /キャトル/
cattleya /カトレア/カトレヤ/
catv /ケーブルテレビ/
catwalk /キャットウォーク/
caucasoid /コーカソイド/
caucasus /コーカサス/
cauchy /コーシー/
cauliflower /カリフラワー/
caulking /コーキング/
cause /コーズ/
caution /コーション/
cavalier /キャバリア/キャバリエ/カバリエ/
cavalleria /カヴァレリア/
cave /ケーブ/
caviar /キャビア/
cavitation /キャビテーション/
cavity /キャビティ/キャビティー/
caxias /カシアス/
caxixi /カシシ/
cay /ケイ/
cayenne /カイエン/カイエンヌ/
cayennepepper /カイエンペッパー/カイエンヌペッパー/
cayman /ケイマン;.ky/
cc /カーボンコピー;carbon copy/
ccdcamera /CCDカメラ;charge-coupled device camera/
cclass /Cクラス/Ｃクラス/
ccompiler /Cコンパイラ/
ccr /CCR(Creedence Clearwater Revival)/
ccup /Cカップ;15cm/Ｃカップ/
cd /コンパクトディスク/キャッシュディスペンサー/カドミウム/Cadmium/カンデラ;光度の単位,SI基本単位/CD/
cdb /Command Description Block/
cdbook /CDブック/
cdcase /CDケース/
cddrive /CDドライブ/
cdjacket /CDジャケット/
cdot /・/
cdots /…/
cdplayer /CDプレーヤー/CDプレイヤー/
cdrack /CDラック/
cdradicase /CDラジカセ/
cdreview /CDレビュー/
cdrive /Cドライブ;C:/Ｃドライブ/
cdrom /CD-ROM/ＣＤ−ＲＯＭ/
cds /ＣｄＳ/
cdshop /CDショップ/
ce /セリウム/Cerium/
ceausescu /チャウシェスク/
cebu /セブ;フィリピン/
cecil /セシル/
cecile /セシール/セシル/
cecilia /セシリア/
cedille /セディーユ/
cedric /セドリック/
cee /シー/
ceiling /シーリング/
ceilinglight /シーリングライト/
celadon /セラドン/
celan /ツェラン/
celeague /セリーグ/セ・リーグ/セントラルリーグ/
celeb /セレブ;celebrity/
celebes /セレベス/
celebration /セレブレーション/
celebrity /セレブリティ/
celeron /セレロン/
celery /セロリ/セルリ/セルリー/
celesta /チェレスタ/
celeste /セレステ/セレスト/セレスティ/
celestin /セレスタン/
celestite /セレスタイト/
celia /セリア/
celica /セリカ/
celine /セリーヌ/
cell /セル/
cellanime /セルアニメ;cell animation/
cellar /セラー/セルラー;?/
cellinstance /セルインスタンス/
cellist /チェリスト/
cellmotor /セルモーター;和製英語(starter)/
cello /チェロ/
cellophane /セロファン/セロハン/
cellophanetape /セロハンテープ/
cellosonata /チェロソナタ/
cellular /セルラー/
cellulase /セルラーゼ/
cellulite /セルライト/
celluloid /セルロイド/
cellulose /セルロース/
celsior /セルシオ/
celsius /セルシウス/℃/
celt /ケルト/
celtic /ケルティック/セルティック/
cembalo /チェンバロ/
cemedine /セメダイン;www.cemedine.co.jp/
cement /セメント/
cemetery /セメタリー/
censor /センサー;検閲/
census /センサス/
cent /セント/¢/
centaur /ケンタウロス/
centauri /ケンタウリ/
center /センター/センタ/
centercourt /センターコート/
centerfly /センターフライ/
centering /センタリング/
centerline /センターライン/
centerover /センターオーバー;和製英語/
centerpole /センターポール/
centi /センチ/
centime /サンチーム/
central /セントラル/
centralheating /セントラルヒーティング/
centralleague /セントラルリーグ/
centralpark /セントラルパーク/
centre /センター/
centreline /センターライン/
centric /セントリック/
centrism /セントリズム;econo-,ego-,ethno-/
centromere /セントロメア/
centronics /セントロニクス/
century /センチュリー/
cephem /セフェム/
cepheus /ケフェウス/
cepstral /ケプストラル/
cepstrum /ケプストラム/
ceramic /セラミック/
ceramicheater /セラミックヒーター/
ceramics /セラミックス/セラミクス/
cerberus /ケルベロス;英語綴り/
cercle /セルクル;(Fr)輪/
cereal /シリアル/
ceremony /セレモニー/
cerezo /セレッソ;[Jリーグ]大阪/
ceria /セリア/
cerise /スリーズ;(Fr) 桜/
cerium /セリウム;[元素]58,Ce/
certan /セルタン/
certification /サーティフィケーション/
cervantes /セルバンテス/
cesar /セザール/セサル/
cesare /チェーザレ/チェザレ/チェザーレ/
cesium /セシウム;[元素]55,Cs/
cesp /CESP/CESP(Common Extended Self-contained Prolog)/
cessna /セスナ/
cestlavie /セラヴィ;C'est la vie./
cetane /セタン/
ceylon /セイロン/錫蘭/
cezanne /セザンヌ/
cf /カリホルニウム/Californium/
cg /コンピュータ・グラフィックス/
ch /チャンネル/チャネル/ч;cha (cyrillic)/χ;chi/
cha /ч;cyrillic/
chablis /シャブリ/
chacha /チャチャ/
chachacha /チャチャチャ/
chaco /チャコ/
chaconne /シャコンヌ/
chad /チャド;.td/
chador /チャドル/
chadwick /チャドウィック/
chaff /チャフ/
chagall /シャガール/
chaikovski /チャイコフスキー/
chaikovskii /チャイコフスキー;Чайковский/
chailly /シャイー/
chain /チェーン/チェイン/
chainletter /チェーンレター/
chainlock /チェーンロック/
chainmail /チェーンメール/
chainsaw /チェーンソー/
chainsmoker /チェーンスモーカー/
chair /チェア/チェアー/
chairman /チェアマン/
chakra /チャクラ/
chalaza /カラザ;卵の中にある紐状のもの/
chalcedony /カルセドニー/
chalk /チョーク/
chalking /チョーキング;白亜化/
challenge /チャレンジ/
challengeable /チャレンジャブル/チャレンジブル/
challenger /チャレンジャー/
challenging /チャレンジング/
chalmers /チャルマース/
chalone /ケイロン/
chamber /チャンバー/チェンバー/
chamberlain /チェンバレン/
chambers /チェンバース/
chambre /シャンブル;(Fr)部屋/
chameleon /カメレオン/
chamomile /カモミール/
chamonix /シャモニ/
chamorro /チャモロ/
champ /チャンプ/
champagne /シャンパン/シャンパーニュ/シャンペン/
champagneglass /シャンパングラス/
champignon /シャンピニオン;(Fr) きのこ/
champion /チャンピオン/チャンピォン/
champions /チャンピオンズ/
championship /チャンピオンシップ/
champselysees /シャンゼリゼ;Champs-Elysees/
chan /チャン/チェン;Jackie Chan/
chance /チャンス/
chandelier /シャンデリア/
chandler /チャンドラー/
chandra /チャンドラ/
chanel /シャネル;www.chanel.com/
chang /チャン/チャング/
change /チェンジ/
changer /チェンジャー/
changeup /チェンジアップ/
channel /チャンネル/チャネル/
channeler /チャネラー/
channeling /チャネリング/
chanson /シャンソン/
chansonnier /シャンソニエ/
chant /チャント/
chantal /シャンタル/
chanter /シャンテ;(Fr)歌う/
chantilly /シャンティイ/
chaos /カオス/ケイオス/
chaotic /カオティック/ケイオティック/カオス的/
chapati /チャパティ/
chapeau /シャポー;(Fr)帽子/シャッポ/
chapel /チャペル/
chapelle /シャペル;仏語/
chaplin /チャップリン/
chapman /チャップマン/
chappy /チャッピー/
chapter /チャプター/
char /キャラ;character/キャラクタ/シャール/
chara /キャラ;character/
character /キャラクター/キャラクタ/
characterdesign /キャラクターデザイン/
characterdevice /キャラクタデバイス/
charactergoods /キャラクターグッズ/
characterset /キャラクタセット/キャラクターセット/
charade /シャレード/
charango /チャランゴ/
charcoal /チャコール/
charcoalgray /チャコールグレー/
charcoalgrey /チャコールグレー/
chardin /シャルダン/
chardonnay /シャルドネ/
chardonnet /シャルドネ/
charge /チャージ/
chargeback /チャージバック/
charger /チャージャー/
charging /チャージング/
chari /チャリ/
chariot /チャリオット/
charisma /カリスマ/
charity /チャリティー/チャリティ/
charityconcert /チャリティーコンサート/チャリティコンサート/
charlemagne /シャルルマーニュ/
charlene /シャリーン/シャーリーン/シャーリン/
charles /チャールズ/シャルル/チャールス/
charleston /チャールストン/
charley /チャーリー/
charlie /チャーリー/
charlotte /シャーロット/シャルロット/シャルロッテ/
charlton /チャールトン/
charly /チャーリー/
charm /チャーム/
charmin /シャーミン/
charming /チャーミング/
charmpoint /チャームポイント/
charmy /チャーミー;和製英語(charming)/
charon /シャロン/カロン/カローン/
charpentier /シャルパンティエ/
charpy /シャルピー/
chart /チャート/
charter /チャーター/チャータ/
chartfile /チャートファイル/
chartres /シャルトル/
chase /チェイス/
chasen /ChaSen/茶筅/
chaser /チェイサー/
chasing /チェイシング/
chasm /キャズム/
chassis /シャーシ/
chat /チャット/シャ;(Fr)ねこ/
chateau /シャトー;(Fr)城/
chateaubriand /シャトーブリアン/
chatelet /シャトレー/シャトレ/
chatnoir /シャノワール;(Fr)chat noir,黒猫/シャノアール/シャ・ノワール/
chatroom /チャットルーム/
chattering /チャタリング/
chatterley /チャタレイ/チャタレー/
chaucer /チョーサー/
chaud /ショー/
chausson /ショーソン/
cheap /チープ/
cheaper /チーパー/
cheat /チート/
chebyshev /チェビチェフ/
checa /チェカ/
chech /チェコ/
chechen /チェチェン/
check /チェック/
checkbox /チェックボックス/
checker /チェッカー/チェッカ/
checkerflag /チェッカーフラッグ;checkered flag/
checkerplayer /チェッカープレイヤー/
checkers /チェッカーズ/
checkin /チェックイン/チェック・イン/
checking /チェッキング/
checklist /チェックリスト/
checkmate /チェックメイト/
checkout /チェックアウト/チェック・アウト/
checkpoint /チェックポイント/
checksheet /チェックシート/
checksum /チェックサム/
cheddar /チェダー/
cheddarcheese /チェダーチーズ/
cheek /チーク/
cheekdance /チークダンス;和製英語(cheek-to-cheek)/
cheer /チア/
cheerful /チアフル/
cheergirl /チアガール;和製英語(cheerleader)/
cheerleader /チアリーダー/
cheerleading /チアリーディング/
cheers /チアーズ/
cheese /チーズ/
cheeseburger /チーズバーガー/
cheesecake /チーズケーキ/
cheesecream /チーズクリーム/
cheesefondue /チーズフォンデュ/
cheesepain /チーズパン/
cheesesouffle /チーズスフレ/
cheetah /チーター/
cheeze /チーズ;※cheese/
chef /シェフ/
cheiron /ケイロン/ケイローン/
chekhov /チェーホフ/
cheko /チェコ/
chelate /キレート/
chelsea /チェルシー/
chemical /ケミカル/
chemise /シュミーズ/シミーズ/
chemist /ケミスト/
chemistry /ケミストリー/
chen /チェン/
cheney /チェイニー/
chenille /シェニール/
chenin /シュナン/
chennai /マドラス;インド(maa)/チェンナイ/
cheque /チェック/
cher /シェール;仏語/
chere /シェール;仏語/シェアー/
cherenkov /チェレンコフ/
cheri /シェリ/
cherie /シェリー/シェリ/
cherimoya /チェリモヤ/
cherish /チェリッシュ/
chernobyl /チェルノブイリ/
cherokee /チェロキー/
cherry /チェリー/
cherryboy /チェリーボーイ/
cherubim /ケルビム;智天使/
cherubini /ケルビーニ/
chervil /チャービル/
cheryl /シェリル/
chess /チェス/
chest /チェスト/
chester /チェスター/
chesterfield /チェスターフィールド/
chestpass /チェストパス/
chet /チェット/
chevre /シェーブル;(Fr) 山羊/シェーヴル/
chevrolet /シボレー/
chewable /チュアブル/
chewinggum /チューインガム/
chi /χ/カイ/
chiangmai /チェンマイ;Chiang Mai/
chianti /キャンティ/キアンティ/
chiara /キアラ/キアーラ/
chiboust /シブースト/
chic /シック/
chicago /シカゴ/
chicane /シケイン/
chicca /キッカ/
chick /チック/
chicken /チキン/
chickencurry /チキンカレー/
chickennugget /チキンナゲット/
chickenrace /チキンレース/
chickenrice /チキンライス;chicken and rice/
chickensoup /チキンスープ/
chicory /チコリ/チコリー/
chief /チーフ/
chien /シャン;(Fr)犬/
chiffon /シフォン/
chiffoncake /シフォンケーキ/
chignon /シニヨン/
chihuahua /チワワ/
child /チャイルド/子/
children /チルドレン/
childseat /チャイルドシート/
chile /チリ;.cl/
chilipepper /チリペッパー;chili pepper/
chilipowder /チリパウダー/
chilisauce /チリソース/
chilled /チルド/
chiller /チラー/
chilly /チリー/
chima /チマ;(朝鮮語)/
chimachogori /チマチョゴリ;(朝鮮語)/
chimaira /キマイラ/
chime /チャイム/
chimera /キメラ/キマイラ/
chimney /チムニー/
chimpanzee /チンパンジー/
chin /チン/
china /チャイナ/
chinadress /チャイナドレス/
chinatown /チャイナタウン/
chinchilla /チンチラ/
chinese /チャイニーズ/
chinois /シノワ;(Fr)中国の/
chinoise /シノワーズ/
chinoiserie /シノワズリ/シノワズリー/
chip /チップ/
chipin /チップイン;chip in/
chips /チップス/
chipset /チップセット/
chiquita /チキータ/
chirac /シラク/
chirico /キリコ/
chiron /ケイロン/ケイローン/
chiropractic /カイロプラクティック/
chita /チタ/
chitin /キチン/
chitosan /キトサン/
chittagong /チッタゴン;バングラデシュ/
chivas /シーバス/
chivasregal /シーバスリーガル/
chive /チャイブ/
chlamydia /クラミジア/
chloe /クロエ/
chloral /クロラール/
chlorella /クロレラ/
chloride /クロライド;塩化/クロリド/
chlorine /クロリン;Cl/
chloris /クロリス/
chloro /クロロ;塩素/
chlorobenzene /クロロベンゼン;C6H5Cl/
chloroethylene /クロロエチレン;C2H3Cl/
chloroform /クロロホルム/クロロフォルム/
chlorophyll /クロロフィル/
chloroplene /クロロプレン/
chloroplenegum /クロロプレンゴム/
chlorpromazine /クロルプロマジン/
choco /チョコ/
chocoball /チョコボール/
chocobar /チョコバー/
chococake /チョコケーキ/
chocochip /チョコチップ;chocolate-chips/
chococream /チョコクリーム/
chocoflake /チョコフレーク/
chocoice /チョコアイス;choc-ice/
chocolat /ショコラ/
chocolate /チョコレート/
chocolatecake /チョコレートケーキ/
chocolateparfait /チョコレートパフェ/
chocoparfait /チョコパフェ/
chogori /チョゴリ;(朝鮮語)/
choice /チョイス/
choke /チョーク/
choker /チョーカー/
choking /チョーキング/
cholera /コレラ/
cholesterol /コレステロール/
choline /コリン;C5H14ON/
cholinesterase /コリンエステラーゼ/
chombo /チョンボ/
chomsky /チョムスキー/
chon /チョン;100chon=1won/
chonbo /チョンボ/
chondroitin /コンドロイチン/
chonggag /チョンガー;(朝鮮語)ch'ong-gak/総角/
chop /チョップ/
chopard /ショパール;www.chopard.com/
chopin /ショパン/
chopper /チョッパー/
choppy /チョッピー/
chopstick /チョップスティック;お箸/
choral /コーラル/コラール/
chorale /コラール/
chord /コード/
chordbook /コードブック/
chordname /コードネーム;[音楽]/
chords /コーズ/
chordwork /コードワーク/
chorizo /チョリソ/
choro /ショーロ/
choros /コロス/
chorus /コーラス/
chorusline /コーラスライン/
choucreme /シュークリーム;chou a la creme/
chow /チャウ/
chowder /チャウダー/
chris /クリス/
chrissie /クリッシー/
christ /キリスト/クリスト/クライスト/
christa /クリスタ/
christamas /クリスマス/
christao /キリシタン/
christchurch /クライストチャーチ;ニュージーランド/
christel /クリステル/
christensen /クリステンセン/
christer /クリステル/
christi /クリスティ/
christian /クリスチャン/クリスティアン/
christiandior /クリスチャンディオール/クリスチャン・ディオール/
christiane /クリスティアーネ/
christie /クリスティ/クリスティー/
christies /クリスティーズ;Christie's. www.christies.com/
christina /クリスティーナ/クリスチーナ/クリスティナ/
christine /クリスティーヌ/クリスティン/クリスティーン/クリスティーネ/クリスティネ/
christmas /クリスマス/
christmascake /クリスマスケーキ/
christmascard /クリスマスカード/
christmascarol /クリスマスキャロル/
christmaseve /クリスマスイブ/クリスマスイヴ/
christmasparty /クリスマスパーティー/クリスマスパーティ/
christmaspresent /クリスマスプレゼント/
christmassale /クリスマスセール/
christmassong /クリスマスソング/
christmastree /クリスマスツリー/
christo /クリスト/
christof /クリストフ/
christoph /クリストフ/
christophe /クリストフ/
christopher /クリストファー/
christy /クリスティーナ/
chro /クロ/
chrom /クロム;Cr/
chromakey /クロマキー;chroma-key/
chromatic /クロマチック/クロマティック/
chromatin /クロマチン/
chromato /クロマト/
chromatogram /クロマトグラム/
chromatograph /クロマトグラフ/
chromatography /クロマトグラフィー/クロマトグラフィ/
chrome /クローム/クロム;[元素]24,Cr/
chromium /クロミウム;[元素]24,Cr/
chronicle /クロニクル/
chrono /クロノ/
chronograph /クロノグラフ/
chronology /クロノロジー/
chronometer /クロノメーター/
chrysanthemum /クリサンセマム;菊/
chrysler /クライスラー/
chrysoprase /クリソプレーズ/
chuck /チャック/
chunk /チャンク/
church /チャーチ/
churchill /チャーチル/
chute /シュート/
chutney /チャツネ/
ci /チェックイン/
ciao /チャオ/
ciboulette /シブレット/
cicero /キケロ/
cider /サイダー/
cidre /シードル;仏語/
ciel /シエル/シェル/
cigar /シガー/
cigarette /シガレット/
cigarettecase /シガレットケース/
ciguatera /シガテラ/
cima /シーマ;[商標]日産/
cincinnati /シンシナティ;USA/
cinco /シンコ/チンコ/
cinderella /シンデレラ/
cindy /シンディ/シンディー/
cine /シネ;(Fr) cinema/
cineclub /シネクラブ/
cinema /シネマ/
cinemascope /シネマスコープ/
cinematheque /シネマテーク/
cineraria /シネラリア/サイネリア/
cinesco /シネスコ;cinemascope/
cinnamon /シナモン/
cinnamonstick /シナモンスティック/
cinnamonsugar /シナモンシュガー/
cinnamontea /シナモンティー/
cinzano /チンザノ/
cipher /サイファー;0/
circle /サークル/○/◎/●/
circlek /サークルK;www.circlek.co.jp/サークルＫ/
circuit /サーキット/
circuittraining /サーキットトレーニング/
circular /サーキュラー/
circulation /サーキュレーション/
circulator /サーキュレーター/
circumscribe /サーカムスクライブ/
circumscription /サーカムスクリプション/
circus /サーカス/
cisc /CISC/
cisco /シスコ;www.cisco.com/
cisse /シセ/
cite /シテ/
citeaux /シトー/
citi /シティ/
citibank /シティバンク;www.citibank.com/
citicorp /シティコープ;www.citicorp.com/
citigroup /シティグループ;www.citigroup.com/
citizen /シチズン/
citroen /シトロエン;www.citroen.fr/
citron /シトロン/
citrus /シトラス/
citterio /チッテリオ/
city /シティ/シティー/
citycenter /シティセンター/
citycycle /シティサイクル/
cityhall /シティホール/シティーホール/
cityhotel /シティホテル/シティーホテル/
citylife /シティライフ/
civic /シビック/
civil /シビル/
civilian /シビリアン/
civiliancontrol /シビリアンコントロール/
civilization /シヴィライゼーション/
cl /塩素/Chlorine/
clafouti /クラフティ/クラフティー/
clafoutis /クラフティ/クラフティー/
claidha /クレイダ;Compensate for Loudness by Analyzing Input-signal Digital Hearing Aid/
claim /クレーム/
claimer /クレーマー;和製英語/クレイマー/
clair /クレア/クレール/
claire /クレア/クレール/
clam /クラム/
clamchouder /クラムチャウダー/
clamp /クランプ/
clampmeter /クランプメーター/
clan /クラン/
clancy /クランシー/
clap /クラップ/
clapton /クラプトン/
clara /クララ/
clare /クレア/
clarence /クラレンス/
claret /クラレット/
clarice /クラリス/
clarinet /クラリネット/
clarino /クラリーノ/
clarion /クラリオン/
claris /クラリス/
clarissa /クラリッサ/
clarisse /クラリス/
claritin /クラリチン/
clark /クラーク/
clarke /クラーク/
clarte /クラルテ;(Fr) 明かり/
clash /クラッシュ/クラシュ;<rare>/
clasp /クラスプ/
class /クラス/
classic /クラシック/
classical /クラシカル/
classicballet /クラシックバレエ/
classiccar /クラシックカー/
classiclife /クラシックライフ/
classicmusic /クラシックミュージック/
classics /クラシックス/
classification /クラシフィケーション/クラスフィケーション/分類/
classifier /クラシファイア/
classique /クラシック;仏語/
classlibrary /クラスライブラリ/
classmate /クラスメイト/クラスメート/
claude /クロード/
claudel /クローデル/
claudette /クローデット/
claudia /クラウディア/クローディア/
claudio /クラウディオ/
claudius /クラウディウス/クローディアス/
claus /クラウス/
clause /クローズ/
clavecin /クラヴサン/クラブサン/
claves /クラベス/
clavichord /クラヴィコード/クラビコード/
clavinet /クラビネット/クラヴィネット/
clavinova /クラビノーバ;[商標]YAMAHA/
clavis /クラヴィス;ラテン語/
claw /クロー/
clay /クレイ/クレー/
claycourt /クレーコート/クレイコート/
clean /クリーン/
cleanenergy /クリーンエネルギー/
cleaner /クリーナー/
cleanhit /クリーンヒット/
cleaning /クリーニング/
cleaninstall /クリーンインストール/
cleanroom /クリーンルーム/
cleanser /クレンザー/
cleansing /クレンジング/
cleanup /クリーンアップ/クリーンナップ/クリンナップ/
clear /クリア/クリアー/
clearance /クリアランス/
clearcase /クリアケース/
clearcut /クリアカット/
clearfile /クリアファイル/
clearglass /クリアガラス/
clearing /クリアリング/
clearmiss /クリアミス;和製英語/
cleek /クリーク;5-wood/
clef /クレフ/クレ;仏語/
clelia /クレリア/
clem /クレム/
clematis /クレマチス/
clemence /クレメンス/クレマンス/
clemenceau /クレマンソー/
clemens /クレメンス/
clement /クレマン/クレメント/
clemente /クレメンテ/
clementi /クレメンティ/
clementine /クレモンティーヌ/クレメンタイン/
cleo /クレオ/
cleobury /クレバリー/
cleome /クレオメ/
cleopatra /クレオパトラ/
clerc /クレール/
cleric /クレリック/
clerk /クラーク/
cleveland /クリーブランド;USA/クリーヴランド/
clever /クレバー/
cleves /クレーヴ/クレーブ/
cli /クリ/
cliche /クリシェ/
click /クリック/
clickable /クリッカブル/
clicker /クリッカー/
client /クライアント/
clientmachine /クライアントマシン/
cliff /クリフ/
cliffhanger /クリフハンガー/
clifford /クリフォード/
climate /クライメート/クライメイト/
climax /クライマックス/
climb /クライム/
climber /クライマー/
climbing /クライミング/
climbingwall /クライミングウォール/
clime /クライム/
clinch /クリンチ/
clinet /クリネ/
clinic /クリニック/
clinique /クリニーク;仏語/
clinker /クリンカー/
clint /クリント/
clinton /クリントン/
clio /クリオ/
clione /クリオネ/
clip /クリップ/
clipart /クリップアート/
clipboard /クリップボード/
clipper /クリッパー/
clipping /クリッピング/
clique /クリーク/
clisp /CLISP/
clitoris /クリトリス/
clive /クライヴ/クライブ/
cloak /クローク/
clock /クロック/
clockup /クロックアップ/
clone /クローン/
cloning /クローニング/
clooney /クルーニー/
clop /クロップ/
clos /CLOS(Common Lisp Object System)/CLOS/
close /クローズ/クロース;近い/
closed /クローズド/
closeplay /クロスプレー/
closer /クローザー/クローザ/
closet /クローゼット/クロゼット/
closeup /クローズアップ/
closing /クロージング/
closure /クロージャー/クロージャ/閉包/
cloth /クロス/クロース/
clothing /クロージング/
cloud /クラウド/
cloudy /クラウディ/クラウディー/
clove /クローブ;丁子/
clover /クローバー/
cltl# /ＣＬｔＬ#1/CLtL#0/
club /クラブ/倶楽部/
clubber /クラバー/
clubevent /クラブイベント/
clubhouse /クラブハウス/
clubmember /クラブメンバー/
clubmusic /クラブミュージック/
clubscene /クラブシーン/
clubteam /クラブチーム/
clue /クルー/
cluster /クラスター/クラスタ/
clustering /クラスタリング/
clutch /クラッチ/
clx /CLX(Common Lisp X Interface)/CLX/
clyde /クライド/
cm /コマーシャル/センチ/センチメートル/キュリウム/Curium/Ｃｍ/
cmdline /コマンドライン/
cmsong /CMソング/ＣＭソング/
cmu /カーネギーメロン大学;Carnegie Melon University. www.cmu.edu/CMU/
cmucl /CMU-CL/
co /コ/コバルト/Cobalt/株式会社/Colorado/コロラド/
co2 /ＣＯ2/
coach /コーチ/
coaching /コーチング/
coal /コール/
coaltar /コールタール;coal-tar/
coart /コート;※coat? court?/
coast /コースト/
coastal /コースタル/
coaster /コースター/
coat /コート/
coates /コーツ/
coathanger /コートハンガー/
coating /コーティング/
coatingstaff /コーチングスタッフ/
coats /コーツ/
cobalt /コバルト;[元素]27,Co/
cobaltblue /コバルトブルー/
cobb /コブ/コッブ/コップ/カッブ/カブ/
cobe /コービー;Cosmic Background Explorer/
cobol /コボル/COBOL/
cobra /コブラ/
coca /コカ/
cocacola /コカコーラ/
cocaine /コカイン/
cochin /コーチン/
cock /コック/
cockatrice /コカトリス/
cocker /コッカー/
cockerspaniel /コッカースパニエル/
cocking /コッキング/
cockpit /コックピット/コクピット/
cocktail /カクテル/
cocktailbar /カクテルバー/
cocktailglass /カクテルグラス/
cocktailparty /カクテルパーティー/カクテルパーティ/
coco /ココ/ＣｏＣｏ/
cocoa /ココア/
cocoamilk /ココアミルク/
cocoapowder /ココアパウダー/
coconut /ココナッツ/ココナツ/
coconutmilk /ココナッツミルク/ココナツミルク/
coconuts /ココナッツ/ココナツ/
coconutsmilk /ココナッツミルク/ココナツミルク/
cocoon /コクーン;繭/
cocos /ココス;.cc/
cocostore /ＣｏＣＯストア;?/
cocotte /ココット/
cocteau /コクトー/
cocu /コキュ/
cod /コッド/
coda /コーダ/
code /コード/
codebase /コードベース/
codebook /コードブック/
codebooks /コードブックス/
codec /コーデック/
codeine /コデイン/
codeka /コード化/
codeless /コードレス/
codelessmouse /コードレスマウス/
codename /コードネーム/
codepoint /コードポイント/
coder /コーダー/
codeset /コードセット/
codesign /コデザイン/
codex /コーデックス/
coding /コーディング/
codon /コドン/
coelacanth /シーラカンス/
coen /コーエン/クーン/
coentro /コエンドロ/
coenzyme /コエンザイム/
coffee /コーヒー/珈琲/
coffeebreak /コーヒーブレイク/
coffeecup /コーヒーカップ/
coffeehouse /コーヒーハウス/
coffeejelly /コーヒーゼリー/
coffeemaker /コーヒーメーカー/
coffeemill /コーヒーミル/
coffeepot /コーヒーポット/
coffeeshop /コーヒーショップ/
coffeetime /コーヒータイム/
coffin /コフィン/
cogeneration /コジェネレーション/
cogito /コギト/
cognac /コニャック/
cohen /コーヘン/コーエン/
coherence /コヒーレンス/
coherency /コヒーレンシ/コヒレンシ;<rare>/
coherent /コヒーレント/
cohort /コホート/コーホート/
coil /コイル/
coilspring /コイルスプリング/
coimbra /コインブラ/
coin /コイン/
coincase /コインケース/
coincidence /コインシデンス/
coinlaundry /コインランドリー;和製英語(coin-washer)/
coinlocker /コインロッカー/
coinparking /コインパーキング/
cointoss /コイントス/
cointreau /コアントロー/
coke /コーク/コークス;(独語koks)/
col /コル/
cola /コーラ/
colbert /コルベール/コルバート/
colchicine /コルヒチン/
colchicum /コルチカム/
cold /コールド/
coldcream /コールドクリーム/
coldspray /コールドスプレー/
cole /コール/
coleman /コールマン/
coleslaw /コールスロー/
colette /コレット/
coleus /コリウス/
colgate /コルゲート/
colin /コリン/コラン/
coliseum /コロシアム/
collaborate /コラボレート/コラボレイト/
collaboration /コラボレーション/
collage /コラージュ/
collagen /コラーゲン/
collar /カラー/
collard /コラール/
collateral /コラテラル/
collect /コレクト/
collectcall /コレクトコール/
collection /コレクション/
collective /コレクティブ/
collector /コレクター/コレクタ/
collectors /コレクターズ/
collectorsitem /コレクターズアイテム;collector's item/
colleen /コリーン/
college /カレッジ/コレージュ;仏語/
collider /コライダー/
collie /コリー/
collier /コリア/
collina /コリーナ/
collins /コリンズ/
collision /コリジョン/コリージョン;<rare>/
collocation /コロケーション/
colloid /コロイド/
collotype /コロタイプ/
colo /コロ/
colombe /コロンブ/
colombia /コロンビア;.co/コロムビア/
colombo /コロンボ/
colon /コロン/
colonel /カーネル/コロネル/
colonial /コロニアル/
colonna /コロンナ/
colony /コロニー/
color /カラー/色/
colorado /コロラド/
colorbox /カラーボックス/
colorchange /カラーチェンジ/
colorchart /カラーチャート/
colorcontact /カラーコンタクト;color contact (lens)/
colorcontactlens /カラーコンタクトレンズ;color contact lens/
colorcoordinator /カラーコーディネーター/
colorcopy /カラーコピー/
colored /カラード/
colorfilm /カラーフィルム/
colorful /カラフル/
colorillust /カラーイラスト;color illustration/
coloring /カラーリング/
colorio /カラリオ;[商標]epson/
colorist /カラリスト/
colormap /カラーマップ/
colorpage /カラーページ/
colorpalette /カラーパレット/
colorprinter /カラープリンタ/カラープリンター/
colorscanner /カラースキャナ/
colorstone /カラーストーン/
colortv /カラーテレビ/
colorvariation /カラーバリエーション/
colossae /コロサイ/
colosseum /コロシアム/コロセウム/
colossus /コロッサス/
colour /カラー/
colourchange /カラーチェンジ/
colourchart /カラーチャート/
colourcontact /カラーコンタクト;colour contact (lens)/
colourcontactlens /カラーコンタクトレンズ;colour contact lens/
colourcopy /カラーコピー/
coloured /カラード/
colourfilm /カラーフィルム/
colourful /カラフル/
colourillust /カラーイラスト;colour illustration/
colouring /カラーリング/
colourpage /カラーページ/
colourpalette /カラーパレット/
colourprinter /カラープリンタ/カラープリンター/
colourscanner /カラースキャナ/
colourstone /カラーストーン/
colourtv /カラーテレビ/
colourvariation /カラーバリエーション/
colt /コルト/
coltrane /コルトレーン/
columbia /コロンビア/
columbine /コロンバイン;US/
columbium /コロンビウム;[元素]41,Cb(Nb)/
columbus /コロンブス/コロンバス;オハイオ州の州都/
columella /コルメラ/
column /コラム/カラム/
columnist /コラムニスト/
columnshift /コラムシフト/
com /コム/コン/
coma /コマ/コーマ/
comb /コーム/コム/
combat /コンバット/
combi /コンビ/
combinat /コンビナート/
combination /コンビネーション/
combinator /コンビネータ/
combine /コンバイン/
combing /コーミング/
combo /コンボ/
combobox /コンボボックス/
combodrive /コンボドライブ/
come /カム/コメ;イタリア語/
comeback /カムバック/カンバック/
comedian /コメディアン/
comedical /コメディカル;co-medical/
comedie /コメディー;仏語/
comedy /コメディ/コメディー/喜劇/
comely /カムリ/
comeon /カモン/
comeout /カムアウト/
comer /カマー/
comet /コメット/
comfort /コンフォート/
comfrey /コンフリー/
comic /コミック/
comical /コミカル/
comicband /コミックバンド;comic band/
comicmarket /コミックマーケット/コミケ/
comics /コミックス/
comiket /コミケ/コミケット;コミケの運営会社。www.comiket.co.jp/コミ/
coming /カミング/
comingout /カミングアウト/
comingsoon /カミングスーン/
comma /コンマ/カンマ/，/、;読点/
command /コマンド/
commander /コマンダー/
commandline /コマンドライン/
commandlineoption /コマンドラインオプション/
commandmode /コマンドモード/
commando /コマンド/コマンドー/
commandprompt /コマンドプロンプト/
comme /コム/
commeca /コムサ;(Fr) comme ca/
commedia /コメディア;イタリア語/
comment /コメント/
commentary /コメンタリー/
commentator /コメンテーター/コメンテータ/
commenter /コメンター/
commentout /コメントアウト;comment out/
commerce /コマース/
commercial /コマーシャル/
commercialism /コマーシャリズム/
commercialpaper /コマーシャルペーパー/
commission /コミッション/
commissioner /コミッショナー/
commit /コミット/
commitment /コミットメント/
committee /コミッティー/コミッティ/
committer /コミッター/コミッタ/
commodity /コモディティ/コモディティー/
commodore /コモドール/
common /コモン/共通/
commons /コモンズ/
commonsense /コモンセンス/
commonwealth /コモンウェルス/
commu /コミ;communication/コミュ;community/
commune /コミューン/
communicate /コミュニケート/
communication /コミュニケーション/
communications /コミュニケーションズ/
communicative /コミュニカティブ/
communicator /コミュニケーター/
communique /コミュニケ/
communism /コミュニズム/コミュニスム/
communist /コミュニスト/共産主義者/
community /コミュニティ/コミュニティー/
communitybus /コミュニティバス/
communityfm /コミュニティFM/
communitysite /コミュニティサイト/
commuter /コミューター/
como /コモ/
comodo /コモド/
comoros /コモロ;.km/
comp /コンプ/カンプ/
compa /コンパ/
compact /コンパクト/
compactcamera /コンパクトカメラ/
compactdisk /コンパクトディスク/
compaction /コンパクション/
compactsize /コンパクトサイズ/
companion /コンパニオン/
company /カンパニー/
compaq /コンパック/
comparator /コンパレータ/
compare /コンペア/
compartment /コンパートメント/
compass /コンパス/
compati /コンパチ;compatible/
compatibility /コンパチビリティ/コンパチ/
compatible /コンパチブル/コンパチ/互換/
compe /コンペ;competition/
competency /コンピテンシー/
competition /コンペティション/コンペ/
competitive /コンペティティブ/
compi /コンピ;compilation/
compilation /コンピレーション/コンピ/コンピレイション/
compile /コンパイル/
compileoption /コンパイルオプション/
compiler /コンパイラ/コンパイラー/
complete /コンプリート/
completion /コンプリーション/
complex /コンプレックス/
compliance /コンプライアンス/
compo /コンポ/
component /コンポーネント/
compose /コンポーズ/
composer /コンポーザー/コンポーザ/
composite /コンポジット/
composition /コンポジション/
compost /コンポスト/
compote /コンポート/
compound /コンパウンド/
compress /コンプレス/
compression /コンプレッション/
compressor /コンプレッサー/コンプレッサ/
compton /コンプトン/
compulsory /コンパルソリー/
compuserve /コンピュサーブ/コンピューサーブ/
computation /コンピュテーション/
computer /コンピュータ/コンピューター/
computer-science /コンピュータサイエンス/
computer-software /コンピュータソフトウェア/
computergame /コンピュータゲーム/コンピューターゲーム/
computergraphics /コンピュータグラフィックス;CG/
computermusic /コンピュータミュージック/
computerscience /コンピュータサイエンス/
computersoftware /コンピュータソフトウェア/
computersystem /コンピュータシステム/コンピューターシステム/
computervirus /コンピュータウイルス/コンピュータウィルス/コンピューターウイルス/コンピューターウィルス/
computervision /コンピュータビジョン/コンピュータービジョン/
computing /コンピューティング/
comte /コント/
comtec /コムテック/
comtesse /コンテス/
con /コン/
conakry /コナクリ/
conan /コナン/
conbrio /コンブリオ;con brio/コン・ブリオ/
concealer /コンシーラー/
concentrate /コンセントレート/
concentration /コンセントレーション/
concentrator /コンセントレータ/コンセントレーター/
concept /コンセプト/
conception /コンセプション/
conceptual /コンセプチュアル/
concern /コンサーン/
concert /コンサート/コンセール;仏語/
concertgebouw /コンセルトヘボウ/
concerthall /コンサートホール/
concertmaster /コンサートマスター/
concerto /コンチェルト/
concerttour /コンサートツアー/
conchiglie /コンキリエ/
concierge /コンシェルジュ/コンシェルジェ/
concious /コンシャス/
concise /コンサイス/簡明な/
conclave /コンクラーベ/
concord /コンコルド/コンコード/
concordance /コンコーダンス/
concorde /コンコルド/
concours /コンクール;仏語/
concourse /コンコース/
concrete /コンクリート/コンクレート;具象/
concreteblock /コンクリートブロック/
concretejungle /コンクリートジャングル/
concurrency /コンカレンシー/
concurrent /コンカレント/
conde /コンデ/
condense /コンデンス/
condensedmilk /コンデンスミルク/
condensemilk /コンデンスミルク;condensed milk/
condenser /コンデンサ/コンデンサー/
condition /コンディション/
conditioner /コンディショナー/
conditioning /コンディショニング/
condom /コンドーム/
condominium /コンドミニアム/
condor /コンドル/
condorcet /コンドルセ/
conduct /コンダクト/
conductance /コンダクタンス/
conductor /コンダクター/コンダクタ/
conduit /コンジット/
condyloma /コンジローム/
cone /コーン/
cones /コーンズ/
confectionary /コンフェクショナリー;菓子屋/
confede /コンフェデ;confederation/
confederation /コンフェデレーション/
confer /カンファー/
conference /カンファレンス/コンファレンス/
confidential /コンフィデンシャル/
config /コンフィグ/コンフィギュレーション;configuration/
configuration /コンフィギュレーション/コンフィグレーション/
configure /コンフィギュア/
confirm /コンファーム/
confit /コンフィ/
confiture /コンフィチュール/
conflict /コンフリクト/競合/衝突/
confocal /コンフォーカル/
conga /コンガ/
congas /コンガ/
conglomerate /コングロマリット/
congo /コンゴ;(コンゴ民主共和国).cd, (コンゴ共和国).cg/
congratulations /コングラチュレーション/コングラッチュレーション/
congress /コングレス/
congruence /≡/
congruent /≡/
conic /コニック/
conifer /コニファー/
conn /コン/
connect /コネクト/接続/
connecter /コネクタ/
connecticut /コネチカット;CT/
connection /コネクション/
connectionism /コネクショニズム/
connectionist /コネクショニスト/
connectionistmodel /コネクショニストモデル/
connectivity /コネクティビティ/
connector /コネクタ/コネクター/
connelly /コネリー/コナリー/コノリー/
conner /コナー/
connerie /コネリー/
connery /コネリー/
connie /コニー/
connor /コナー/
connotation /コノテーション/
conny /コニー/
conor /コナー/
conquistador /コンキスタドール/
conrad /コンラッド/
conrod /コンロッド;con-rod, connection rod/
cons /コンス/
consadole /コンサドーレ;[Jリーグ]札幌/
conscell /コンスセル/
consensus /コンセンサス/
consent /コンセント/
conserva /コンサバ;conservative/
conservative /コンサバティブ/コンサーバティブ/
conservatoire /コンセルヴァトワール/コンセルバトワール/
conservatory /コンセルヴァトーリ/
consider /コンシダー/
consistency /コンシステンシー/コンシステンシ/
consolation /コンソレーション/
console /コンソール/
consomme /コンソメ/
consommesoup /コンソメスープ;和製語(consomme(Fr) + soup(英))/
consort /コンソート/
consortium /コンソーシアム/
constable /コンスタブル/
constance /コンスタンス/
constant /コンスタント/コンスタン;(1767-1830)Benjamin Constant de Rebecque/
constantin /コンスタンティン/コンスタンチン/コンスタンタン/
constantine /コンスタンティン/
constantinople /コンスタンチノープル/
constantinus /コンスタンティヌス/
construct /コンストラクト/
construction /コンストラクション/
constructor /コンストラクタ/コンストラクター/構築子/
consul /コンサル/
consult /コンサルト/
consultant /コンサルタント/
consultation /コンサルテーション/
consulting /コンサルティング/
consume /コンシューム/
consumer /コンシューマ/コンシューマー/コンシュマー/
conta /コンタ/
contac /コンタック/
contact /コンタクト/
contactlens /コンタクトレンズ/
container /コンテナ/コンテナー/
containergarden /コンテナガーデン/
conte /コント/コンテ/
contemporary /コンテンポラリー/
content /コンテント/
contents /コンテンツ/
contest /コンテスト/
context /コンテキスト/コンテクスト/
contexte /コンテクスト;仏語/
contextmenu /コンテキストメニュー/コンテクストメニュー/
conti /コンティ/
continental /コンチネンタル/
contingency /コンティンジェンシー/
continuation /コンティニュエーション/継続/
continue /コンティニュー/
continuous /コンティニュアス/
contour /コンター/コンタ/
contra /コントラ/
contrabass /コントラバス/
contract /コントラクト/
contractbridge /コントラクトブリッジ/
contraction /コントラクション/
contralto /コントラルト/
contrast /コントラスト/
contredanse /コントルダンス/
contribution /コントリビューション/
control /コントロール/制御/
controlcenter /コントロールセンター/
controlcentre /コントロールセンター/
controler /コントローラ;※controLLer/
controlkey /コントロールキー/CONTROLキー/
controller /コントローラ/コントローラー/
controlpanel /コントロールパネル/
controltower /コントロールタワー/
conveni /コンビニ/
convenience /コンビニエンス/
conveniencestore /コンビニエンスストア/コンビニ/
convention /コンベンション/コンヴェンション/
conventional /コンベンショナル/コンヴェンショナル/
convergence /コンバージェンス/
conversation /カンバセーション/
conversion /コンバージョン/コンヴァージョン/変換/
convert /コンバート/コンヴァート/変換/
converter /コンバータ/コンバーター/
convertible /コンバーチブル/
convertor /コンバータ/
convex /コンベックス/
conveyer /コンベア/コンベアー/コンベヤ/コンベヤー/
conveyor /コンベア/コンベアー/コンベヤ/コンベヤー/
convolution /コンヴォリューション/
convolve /コンヴォルヴ/
convoy /コンボイ/
conway /コンウェイ/
cooder /クーダー/
cook /クック/コック/
cooker /クッカー/
cookie /クッキー/
cookiejar /クッキージャー/
cooking /クッキング/
cookingheater /クッキングヒーター/
cooky /クッキー/
cool /クール/
coolbiz /クールビズ;[新語]和製英語/
coolbox /クールボックス/
cooldown /クールダウン/
cooler /クーラー/
coolerbox /クーラーボックス/
cooley /クーリー/
coolidge /クーリッジ/
coolie /クーリー/
cooling /クーリング/
coolingoff /クーリングオフ/
coop /コープ/
cooper /クーパー/
cooperate /コーポレート/
cooperative /コーポラティブ/
coordinate /コーディネート/座標/コーディネイト/
coordination /コーディネーション/
coordinator /コーディネーター/コーディネータ/
cop /コップ/
copacabana /コパカバーナ/
copenhagen /コペンハーゲン/
copernicus /コペルニクス/
copier /コピア/
copland /コープランド/
copolymer /コポリマー/
coppelia /コッペリア/
copper /カッパー/
coppola /コッポラ/
coprocessor /コプロセッサ/
coprod /Ц;※これはキリル文字のtse/
copter /コプター;helicopter/
copula /コピュラ/
copy /コピー/
copyback /コピーバック/
copyband /コピーバンド;和製英語(cover band)/
copyguard /コピーガード/
copyleft /コピーレフト/
copymap /コピーマップ/
copyonce /コピーワンス/
copyonwrite /コピーオンライト/
copype /コピペ;copy and paste/
copyprotect /コピープロテクト/
copyright /コピーライト;略号は(C)/
copyservice /コピーサービス/
copywriter /コピーライター/
copywriting /コピーライティング/
coquette /コケット/
coquettish /コケティッシュ/
coquille /コキール/コキーユ/
cora /コーラ/コラ/
coral /コーラル/
coralie /コラリー/
corazon /コラソン/
corbusier /コルビュジエ;(1887-1965) Le Corbusier/
cord /コード/
cordelia /コーデリア/
cordial /コーディアル/
cordoba /コルドバ/
cordon /コルドン/
cordreel /コードリール;cord reel/
cords /コーズ/
cordula /コーデュラ/
corduroy /コーデュロイ/
core /コア/
coredump /コアダンプ/
corega /コレガ;www.corega.co.jp/
coreless /コアレス/
corelli /コレッリ/
coretime /コアタイム/
corfu /コルフ/
corgi /コーギー/
coriander /コリアンダー/
corin /コリン/
corinne /コリン/コリーヌ/コリンヌ/
corinth /コリント/
coriolis /コリオリ/
cork /コルク/
corkboard /コルクボード/
corkscrew /コルクスクリュー/
cormac /コーマック/
corn /コーン/
corncream /コーンクリーム/
cornedbeef /コンビーフ/
corneille /コルネイユ/コルネーユ/
cornelia /コーネリア/コルネリア/
cornelius /コーネリアス/コルネリウス/
cornell /コーネル/
corner /コーナー/┘/└/┐/┌/┓/┏/┛/┗/
cornering /コーナリング/コーナーリング/
cornerkick /コーナーキック/
cornet /コルネット/コロネ/コルネ;(Fr) (アイスなどの)コーン/
cornflake /コーンフレーク/
cornflakes /コーンフレーク/
cornflour /コーンフラワー/
cornish /コーニッシュ/
cornmeal /コーンミール/
cornpotage /コーンポタージュ/
corns /コーンズ/
cornsoup /コーンスープ/
cornstarch /コーンスターチ/
coro /コロ/
corolla /カローラ/
coromandel /コロマンデル/
corona /コロナ/
coronabeer /コロナビール/
coronado /コロナド/
corot /コロー/
corp /コープ;corporation/
corpo /コーポ;corporate house/
corporate /コーポレート/
corporategovernance /コーポレートガバナンス/
corporation /コーポレーション/
corporatism /コーポラティズム/
corpse /コープス/
corpus /コーパス/
correct /コレクト/正確な/
correction /コレクション;修正/
correlation /コリレーション/
correspondence /コレスポンデンス/コレスポンダンス/
correspondent /コレスポンデント/コレスポンダント/
corrida /コリーダ/
corrugate /コルゲート/
corsage /コサージュ/コサージ/
corse /コルス/
corset /コルセット/
corsica /コルシカ/
cortes /コルテス/
cortisol /コルチゾール/
cortisone /コルチゾン/コーチゾン/
cortot /コルトー/
corundum /コランダム/
corvette /コルベット/
cos /コサイン/コス/
cosecant /コセカント;余割/
cosine /コサイン/
cosme /コスメ;cosmetics/
cosmetic /コスメティック/コスメチック/
cosmetics /コスメティックス/
cosmic /コズミック/コスミック/
cosmo /コスモ/
cosmology /コスモロジー/
cosmopolitan /コスモポリタン/
cosmos /コスモス/
cosplay /コスプレ;<costume play (NB:英語化している)/
cosplayer /コスプレイヤー/
cossack /コサック;Казак/
cossackdance /コサックダンス/
cost /コスト/
costa /コスタ/
costadelsol /コスタデルソル;Costa del Sol/
costarica /コスタリカ;Costa Rica/
costdown /コストダウン;和製英語(cost-cutting)/
coste /コスト/
costello /コステロ/
costner /コスナー/
costperformance /コストパフォーマンス/
costume /コスチューム/
costumeplay /コスチュームプレイ/コスチュームプレー/コスプレ/
cota /コタ/
cotangent /コタンジェント;余接/
cote /コート/
cotedazur /コートダジュール;Cote d'Azur/
cotedivoire /コートジボワール;Cote d'Ivoire (.ci)/
cotes /コーツ/
cottage /コテージ/カッテージ/
cottagecheese /カッテージチーズ/
cotton /コットン/
coubertin /クーベルタン/
couch /カウチ/
couchpotato /カウチポテト/
coucou /クク/
could /クド/クッド/
couleur /クルール;(Fr)色/
coulis /クーリ/
coulomb /クーロン/
coulthard /クルサード/
coumarin /クマリン;C9H6O2/
counseling /カウンセリング/
counselor /カウンセラー/
count /カウント/
countdown /カウントダウン/
counter /カウンター/カウンタ/
counterattack /カウンターアタック/
counterculture /カウンターカルチャー/
counterkitchen /カウンターキッチン/
counterpart /カウンターパート/
counterpropagation /カウンタープロパゲーション/
counterpunch /カウンターパンチ/
countertable /カウンターテーブル/
countertenor /カウンターテナー/カウンターテノール/
country /カントリー/
countryclub /カントリークラブ/
countrymusic /カントリーミュージック/
countup /カウントアップ/
coupdetat /クーデター;(Fr)coup d'etat/
coupe /クーペ;仏語/クープ/
coupepain /コッペパン;和製仏語(pain coupe?)/
couperin /クープラン/
couple /カップル/
coupler /カプラ/カプラー/
coupling /カップリング/
coupon /クーポン/
courante /クーラント/
courbet /クールベ/
cource /コース;※course/
courier /クーリエ/
courreges /クレージュ/
cours /クール;仏語/
course /コース/
coursemenu /コースメニュー/
courseout /コースアウト;(和製英語)/
court /コート/
courteney /コートニー/
courthouse /コートハウス/
courtyard /コートヤード/
couscous /クスクス;(粉状パスタ)/
cousin /カズン/
couture /クチュール/
couturier /クチュリエ/
couverture /クーベルチュール/
cover /カバー/カヴァー/
coverage /カバレッジ/カバレージ/
coveralbum /カバーアルバム/
coverall /カバーオール/
covergirl /カバーガール/
coverillust /カバーイラスト;cover illustration/
covering /カバーリング/
coverstory /カバーストーリー/
coverup /カバーアップ/
coverversion /カバーバージョン/
cow /カウ/
cowbell /カウベル/
cowboy /カウボーイ/
cowen /コーエン/
cowgirl /カウガール/
cowper /カウパー/
cox /コックス/
coy /コイ/
coyote /コヨーテ/
cozy /コージー/
cps /CPS(Continuation-Passing Style)/
cpu /CPU/中央処理装置/
cr /CR/クロム/Chromium/
crack /クラック/
cracker /クラッカー/
cracking /クラッキング/
cradle /クレードル/クレイドル/
craft /クラフト/
craftman /クラフトマン;craftsman/
craftsman /クラフトマン/
craftwork /クラフトワーク/
craig /クレイグ/クレーグ/
cram /クラム/
cramer /クレーマー/クレイマー/
cranberry /クランベリー/
crane /クレーン/
crank /クランク/Cランク/Ｃランク/
crankin /クランクイン;和製英語/
crankup /クランクアップ;和製英語/
crap /クラップ/
crash /クラッシュ/
crashcymbal /クラッシュシンバル/
crate /クレート/
crater /クレーター/
crawford /クロフォード/
crawl /クロール/
crawler /クローラー/クローラ/
crawling /クローリング/
cray /クレイ/
crayon /クレヨン/
crazy /クレイジー/クレージー/
crea /クレア/
cream /クリーム/
creamcheese /クリームチーズ/
creamer /クリーマー/
creampain /クリームパン/
creamsoda /クリームソーダ/
creamsoup /クリームスープ/
creamstew /クリームシチュー/
creamy /クリーミー/
create /クリエイト/クリエート/
creatine /クレアチン/
creatinine /クレアチニン/
creation /クリエーション/クリエイション/
creative /クリエイティブ/クリエーティブ/クリエイティヴ/
creativity /クリエイティビティ/
creator /クリエイター/クリエーター/クリエータ/クリエイタ/
creature /クリーチャー/
credit /クレジット/
creditcard /クレジットカード/
credittitle /クレジットタイトル/
credo /クレド/
creek /クリーク/
creep /クリープ/
creepers /クリーパーズ/
creme /クレーム;仏語/
cremebrulee /クレームブリュレ;(Fr) creme brulee/
cremona /クレモナ/
creole /クレオール/
creosote /クレオソート/
crepe /クレープ/
cresc /クレッシェンド;次第に強く/crescendo/
crescendo /クレッシェンド/
crescent /クレセント/
cresol /クレゾール;C7H8O/
cresson /クレソン/
crest /クレスト/
cresta /クレスタ;[商標]トヨタ/
crested /クレステッド/
crete /クリート/
creutz /クロイツ/
crevasse /クレバス/クレヴァス/
crew /クルー/
crewneck /クルーネック/
crick /クリック/
cricket /クリケット/
crime /クライム/
crimea /クリミア/
criminal /クリミナル/
crimson /クリムゾン/
cripper /クリッパー/
crisis /クライシス/
crisp /クリスプ/
crispin /クリスピン/
crispy /クリスピー/
cristian /クリスティアン/
cristiano /クリスティアーノ/クリスチアーノ/
cristina /クリスティーナ/クリスチーナ/クリスチナ/
cristo /クリスト/
cristobal /クリストバル/
criterion /クライテリオン/
critic /クリティック/
critical /クリティカル/
criticalhit /クリティカルヒット/
criticalpath /クリティカルパス/
critique /クリティーク/クリティック/
croatia /クロアチア;.hr/
croche /クロッシュ/クローシュ/クロシュ/♪/
crocodile /クロコダイル/
crocop /クロコップ/
crocus /クロッカス/
croesus /クロイソス/
croissant /クロワッサン/
cromagnon /クロマニヨン/クロマニョン/
cromatie /クロマティ/
cromwell /クロムウェル/
cron /クーロン/
cronus /クロノス/
crop /クロップ/
cropped /クロップド/
croquembouche /クロカンブッシュ/
croquet /クロッケー/
croquette /コロッケ/クロケット/
croquis /クロッキー/
crosby /クロスビー/
cross /クロス/×/┼/╋/┿/╂/
crossball /クロスボール/
crossbar /クロスバー/
crossbow /クロスボウ/
crossbreed /クロスブリード/
crosscable /クロスケーブル;crossing cable/
crosscheck /クロスチェック/
crosscompile /クロスコンパイル/
crosscompiler /クロスコンパイラ/
crosscounter /クロスカウンター/
crosscountry /クロスカントリー;cross country/
crossfade /クロスフェード/
crossfire /クロスファイア/
crossing /クロッシング/
crosslicence /クロスライセンス/
crosslicense /クロスライセンス/
crossover /クロスオーバー/クロスオーヴァー/
crosspoint /クロスポイント;cross-point/
crosspost /クロスポスト/
crossroad /クロスロード/
crossstitch /クロスステッチ/
crosstalk /クロストーク/
crossword /クロスワード/
crosswordpuzzle /クロスワードパズル/
crostini /クロスティーニ/
croton /クロトン/
croute /クルート/
crouton /クルトン/
crow /クロー/
crowley /クロウリー/クローリー/
crown /クラウン/
crtdisplay /CRTディスプレイ/
crtmonitor /CRTモニタ/CRTモニター/
cru /クリュ/
cruise /クルーズ/
cruiser /クルーザー/
cruising /クルージング/
crunch /クランチ/
crusader /クルセイダー/
crusaders /クルセイダーズ/
crush /クラッシュ/
crusher /クラッシャー/
crusoe /クルーソー/
crust /クラスト/
crutch /クラッチ/
cruz /クルーズ/クルス/
cruzeiro /クルゼイロ/
cry /クライ/
crying /クライング/
cryo /クリオ;(接頭辞:低温)/クライオ/
cryostat /クライオスタット/
crypt /クリプト/
crypto /クリプト/
cryptococcus /クリプトコッカス/
cryptoxanthin /クリプトキサンチン/
crysknife /クリスナイフ/
crystal /クリスタル/水晶/
crystalglass /クリスタルガラス/クリスタルグラス/
cs /セシウム/Cesium/
csantenna /CSアンテナ/
csh /Cシェル/
cstuner /CSチューナー/CSチューナ/
csvfile /CSVファイル/
ct /Connecticut/コネチカット/コネティカット/
ctesiphon /クテシフォン/
cthulhu /クトゥルフ/
ctrlkey /CTRLキー/コントロールキー/
ctscan /CTスキャン/
ctype /Cタイプ/Ｃタイプ/
cu /銅/Copper/
cuba /キューバ;.cu/
cuban /キューバン/
cube /キューブ/
cubic /キュービック/
cubism /キュビズム/キュービズム/
cubisme /キュビスム/
cubs /カブス;[MLB]/
cuckoo /カッコウ/カッコー/
cue /キュー/
cuff /カフ/
cuffs /カフス/
cuffsbutton /カフスボタン/
cuica /クイーカ/
cuisine /キュイジーヌ/
cuit /キュイ;(Fr) 焼いた/
culotte /キュロット/
culotteskirt /キュロットスカート;culottes/
cult /カルト/
cultmovie /カルトムービー/
cultural /カルチュラル/
culture /カルチャー/カルチュア/
cultureschool /カルチャースクール/
cultureshock /カルチャーショック/
cum /カム/
cumene /クメン/
cumin /クミン/
cuminseed /クミンシード/
cummin /クミン/
cunni /クンニ;cunnilingus/
cunnilingus /クンニリングス/
cunning /カンニング/
cunt /カント/
cuomo /クオモ/
cuore /クオレ/
cup /カップ/コップ/∪/
cupboard /カップボード/
cupcake /カップケーキ/
cupid /キューピッド/
cupin /カップイン;cup in/
cupnoodle /カップヌードル/
cupola /キューポラ/
cupple /カップル;※couple?/
curacao /キュラソー/
curare /クラーレ/
curator /キュレーター/
curd /カード/
cure /キュア/
curie /キュリー/
curiosity /キュリオシティ/
curious /キュリアス/
curium /キュリウム;[元素]96,Cm/
curl /カール/
curler /カーラー/
curling /カーリング/
curly /カーリー/
curot /キュロット/
curran /カラン/
currant /カラント;すぐり/
currect /カレント/
currency /カレンシー/カレンシ/
current /カレント/
currentdirectory /カレントディレクトリ;pwd/
curriculum /カリキュラム/
curry /カレー/カリー/
currying /カリー化/
currypain /カレーパン/
currypowder /カレーパウダー/
curryrice /カレーライス/
curryroux /カレールー;NB:英語curry + 仏語roux/
currysauce /カレーソース/
currysoup /カレースープ/
curse /カース/
curses /カーセス/
cursor /カーソル/カーサ/
cursorkey /カーソルキー/
curt /クルト/
curtain /カーテン/
curtaincall /カーテンコール/
curtainrail /カーテンレール/
curtainwall /カーテンウォール/
curtis /カーティス/カーチス/
curve /カーブ/カーヴ/
curving /カービング/
cusco /クスコ/
cuscus /クスクス;有袋類/
cushion /クッション/
cusp /カスプ/
custard /カスタード/
custardcream /カスタードクリーム/
custer /カスター/
custom /カスタム/
customcar /カスタムカー/
customchip /カスタムチップ/
customer /カスタマー/カスタマ/
customercenter /カスタマーセンター/
customercentre /カスタマーセンター/
customerservice /カスタマーサービス/
customersupport /カスタマーサポート/
customisable /カスタマイザブル/
customisation /カスタマイゼーション/
customise /カスタマイズ/
customised /カスタマイズド/
customiser /カスタマイザ/
customizable /カスタマイザブル/
customization /カスタマイゼーション/
customize /カスタマイズ/カスタム化/
customized /カスタマイズド/
customizer /カスタマイザ/
custommade /カスタムメイド/カスタムメード/
cut /カット/
cutback /カットバック/
cutball /カットボール/
cute /キュート/
cutglass /カットガラス/カットグラス/
cuthbert /カスバート/
cuticle /キューティクル/クチクラ/
cutie /キューティー/キューティ/
cutin /カットイン;cut-in/クチン;[植物]/
cutlery /カトラリー/
cutlet /カツレツ/
cutoff /カットオフ/
cutout /カットアウト/
cutover /カットオーバー/
cutpants /カットパンツ/
cutsew /カットソー;cut and sewn/
cutter /カッター/
cutterknife /カッターナイフ;和製英語(utility knife)/
cutting /カッティング/
cuttingsheet /カッティングシート;[商標]/
cutup /カットアップ/
cuty /キューティー;※cutie?/
cuvee /キュヴェ;仏語/
cuzco /クスコ/
cyalume /サイリューム;[商標]OmniGlow社/
cyan /シアン/
cyanine /シアニン/
cyano /シアノ/
cyanocobalamin /シアノコバラミン/
cyanocobalamine /シアノコバラミン/
cyanosis /チアノーゼ/
cyber /サイバー/
cybernetic /サイバネティック/
cybernetics /サイバネティックス/サイバネティクス/
cyberpunk /サイバーパンク/
cyberspace /サイバースペース/
cyborg /サイボーグ/
cybozu /サイボウズ;cybozu.co.jp/
cyclamen /シクラメン/
cycle /サイクル/
cyclehit /サイクルヒット/
cyclic /サイクリック/
cyclin /サイクリン/
cycling /サイクリング/
cyclingroad /サイクリングロード/
cyclo /シクロ/サイクロ/
cycloid /サイクロイド/
cyclon /サイクロン/
cyclops /サイクロプス/
cyclotron /サイクロトロン/
cygne /シーニュ;(Fr) 白鳥/
cylindar /シリンダー;※cylinder/
cylinder /シリンダー/シリンダ/
cylinderhead /シリンダーヘッド/シリンダヘッド/
cyma /シーマ/
cymbal /シンバル/
cymbals /シンバル/
cymbidium /シンビジウム/
cyndy /シンディ/シンディー/
cynical /シニカル/
cynicism /シニシズム/
cynnamon /シナモン;※cinnamon/
cynthia /シンシア/
cyprus /キプロス;.cy/
cyrano /シラノ/
cyric /サイクロトロンＲＩ/
cyril /シリル/ツィリル/
cyrille /シリル/
cyrillic /а;a/б;be/в;ve/г;ge/д;de/е;je/ё;jo/ж;zhe/з;ze/и;i/й;i-kratkoje (j)/к;ka/л;el/м;em/н;en/о;o/п;pe/р;er/с;es/т;te/у;u/ф;ef/х;xa/ц;tse/ч;cha/ш;sha/щ;scha/ъ;znak (tvjordyj znak)/ы;y/ь;znak (xjaxkij znak)/э;e/ю;ju/я;ja/
cyrus /サイラス/キュロス/
cystein /システイン;Cys/
cystine /シスチン/
cytokine /サイトカイン/
cytosine /シトシン;C/
czar /ツァー/ツァーリ/
czech /チェコ;.cz/
czechslovakia /チェコスロバキア/チェコスロヴァキア/
czerny /ツェルニー/チェルニー/
d /δ;delta/∂;differential/ディー/デー/д;de (cyrillic)/
d# /Ｄ#1/
dB /デシベル/
da /↓/
dabadie /ダバディ/
dacapo /ダカーポ;da capo/ダ・カーポ/
dacca /ダッカ/
dachshund /ダックスフンド/ダックスフント/
dacquoise /ダックワーズ/ダコワーズ/
dad /ダッド/ダド/
dada /ダダ/
dadaisme /ダダイスム/
daddy /ダディ/ダディー/
daemon /デーモン/
daff /ダフ/
daffy /ダフィ/ダッフィ/ダフィー/
dag /ダグ/
dagger /ダガー/†/‡;ddagger/
dagmar /ダグマー/
dahl /ダール/
dahlia /ダリア/
daidalos /ダイダロス/
daiei /ダイエー;www.daiei.co.jp/
daily /デイリー/デーリー/
dailysports /デイリースポーツ;www.daily.co.jp/
daimler /ダイムラー/
daiquiri /ダイキリ/
daisy /デイジー/デージー/ディジー/Ｄａｉｓｙ/
daisychain /デイジーチェーン/
dakar /ダカール/
dal /ダール/
dalaiblama /ダライラマ/達頼喇嘛/
dalailama /ダライラマ/達頼喇嘛/
dale /デール/ディル/デイル/
dalembert /ダランベール;Jean Le Rond d'Alembert (1717-1783)/
dali /ダリ/
dallara /ダラーラ/
dallas /ダラス/
dalmatian /ダルメシアン/
dam /ダム/
damage /ダメージ/
damascus /ダマスカス/
dame /ダム;仏語/
damia /ダミア/
damian /ダミアン/
damiani /ダミアーニ/
damiano /ダミアーノ/
damien /ダミアン/
damon /デーモン/デイモン/ダモン/
damore /ダモーレ;(It.) d'amore/
damour /ダムール;(Fr) d'amour. 愛の/
damp /ダンプ/
damper /ダンパー/
dan /ダン/
dana /ダーナ/デーナ/ダナ/デナ/
danae /ダナエ/
danang /ダナン;Da-Nang,ベトナム/
dance /ダンス/
danceable /ダンサブル/
dancefloor /ダンスフロア/
dancegroup /ダンスグループ/
dancehall /ダンスホール/
dancemusic /ダンスミュージック/
danceparty /ダンスパーティー/ダンスパーティ/
dancer /ダンサー/
danceschool /ダンススクール/
danceteam /ダンスチーム/
dancing /ダンシング/
dandelion /ダンデライオン;たんぽぽ/
dandy /ダンディ/ダンディー/
dandyism /ダンディズム/
dane /デン/デーン/
danese /ダネーゼ/
dangaree /ダンガリー/
dangdut /ダンドゥット/
danger /デンジャー/
dangerous /デンジャラス/
dani /ダニ/
daniel /ダニエル/
daniela /ダニエラ/
daniele /ダニエル/ダニエーレ/
daniella /ダニエラ/
danielle /ダニエル/
danilo /ダニーロ/
danish /デニッシュ/ダニッシュ/
dank /ダンク/
danke /ダンケ/
dankshoot /ダンクシュート/
danner /ダナー/
danny /ダニー/
dans /ダン;仏語/
dante /ダンテ/
danube /ダニューブ/
dany /ダニー/
danzig /ダンチヒ/ダンツィヒ/
daphne /ダフネ/
daphnis /ダフニス/
darbukka /ダルブッカ/ダラブッカ/
darc /ダルク/
darcy /ダーシー/
daressalam /ダルエスサラーム;Dar es Salam/
dari /ダリ/
daria /ダリア/ダリヤ/
dario /ダリオ/
darius /ダリウス/ダライアス/
darjeeling /ダージリン/
dark /ダーク/
darkblue /ダークブルー/
darkbrown /ダークブラウン/
darkcolor /ダークカラー/
darkcolour /ダークカラー/
darkelf /ダークエルフ/
darkgray /ダークグレー/
darkgreen /ダークグリーン/
darkgrey /ダークグレー/
darkhorse /ダークホース/
darkmatter /ダークマター/
darkness /ダークネス/
darkred /ダークレッド/
darkside /ダークサイド/
darksuit /ダークスーツ/
darla /ダーラ/
darling /ダーリン/ダーリング/
darrel /ダレル/
darrell /ダレル/
darren /ダレン/
dart /ダート/
dartagnan /ダルタニャン/ダルタニアン/
darth /ダース/
darthvader /ダースベイダー/ダースベーダー/
darts /ダーツ/
darussalam /ダルエスサラーム/
darwin /ダーウィン/
darwinism /ダーウィニズム/
daryl /ダリル/
das /ダス/
dasa /ダサ/
dasein /ダーザイン/
dash /ダッシュ/—/
dashboard /ダッシュボード/
dashv /┤/
dassault /ダッソー/
data /データ/データー/
databank /データバンク/
database /データベース/
databasesoft /データベースソフト/
databasesystem /データベースシステム/データベース・システム/
databook /データブック/
datacenter /データセンター/データセンタ/
datacentre /データセンター/データセンタ/
datadisk /データディスク/
datafile /データファイル/
dataflow /データフロー/
dataglove /データグローブ/
datagram /データグラム/
datalink /データリンク/
datamining /データマイニング/
dataobject /データオブジェクト/
datapack /データパック/
dataserver /データサーバ/データサーバー/
dataset /データセット/
datasheet /データシート/
datashow /データショウ/
datasize /データサイズ/
datastore /データストア/
datatype /データタイプ/
date /デート/デイト/
datebase /データベース/
datecourse /デートコース/
dates /デーツ/
datespot /デートスポット/
datsun /ダットサン;[商標]日産/
datura /ダチュラ;朝鮮朝顔/
daudet /ドーデ/
daughter /ドーター/
daumier /ドーミエ/
daun /ダウン/
davao /ダバオ;フィリピン/
dave /デイブ/デイヴ/デーブ/デーヴ/ディヴ/
david /デビッド/デヴィッド/デイビッド/ダビデ/デービッド/デーヴィッド/ダヴィド/ダヴィッド/ダビド/デーヴィド/ダーフィット/ダビッド/
davide /ダビデ/ダヴィデ/
davidoff /ダビドフ;www.davidoff.com/
davidson /ダビッドソン/デビッドソン/
davinch /ダ・ビンチ;(1452-1519)Leonardo da Vinci/
davinci /ダヴィンチ/ダ・ヴィンチ/
davis /デイビス/デイヴィス/デービス/デビス/
daviscup /デビスカップ/
dawkins /ドーキンス/
dawn /ドーン/
dawson /ドーソン/
day /ディ/デイ/デー/
daycare /デイケア/
daycream /デイクリーム/
daydream /デイドリーム/
daygame /デーゲーム/デイゲーム/
dayhome /デイホーム/
daylight /デイライト/ディライト/
daypack /デイパック/
days /デイズ/
dayservice /デイサービス/
dayservicecenter /デイサービスセンター/
dayservicecentre /デイサービスセンター/
daytime /デイタイム/
daytona /デイトナ;米国・フロリダ/
daytrade /デイトレード/デイトレ/
daytrader /デイトレーダー/
db /データベース/デシベル;decibel/ドブニウム/Dubnium/
dbms /データベース管理システム;database management system/DBMS/
dbserver /データベースサーバ/DBサーバ/
dbsoft /データベースソフト/
dbsystem /データベースシステム/
dc /直流/District of Columbia/コロンビア/
dcbrand /ＤＣブランド/DCブランド/
dccard /DCカード;www.dccard.co.jp/
dcircle /◎/
dcup /Dカップ;17.5cm/Ｄカップ/
ddagger /‡/
ddb /演繹データベース;deductive database/文書データベース;document database/
ddrive /Dドライブ;D:/Ｄドライブ/
de /デ/ド/ドゥ/д;cyrillic/Delaware/デラウェア/
dead /デッド/
deadball /デッドボール;和製英語(hit by pitch)/
deadcopy /デッドコピー/
deadend /デッドエンド/
deadheat /デッドヒート/
deadlift /デッドリフト/
deadline /デッドライン/
deadlink /デッドリンク;404/
deadlock /デッドロック/
deadspace /デッドスペース/
deadstock /デッドストック/
deaf /デフ/
deal /ディール/
dealer /ディーラー/ディーラ/
dealing /ディーリング/
deallocate /デアロケイト/
deamon /デーモン/
dean /ディーン/
deanna /ディアナ/
dear /ディア/ディアー/
death /デス/
deathmarch /デスマーチ/
deathmask /デスマスク/
deathmatch /デスマッチ/
deathmetal /デスメタル/
deb /デブ/
debate /ディベート/
debbie /デビー/
debby /デビー/
debeers /デビアス;De Beers. www.debeers.com/
debian /デビアン/
debit /デビット/
debitcard /デビットカード/
debora /デボラ/
deborah /デボラ/
debra /デブラ/
debris /デブリ/
debroglie /ド・ブロイ;de Broglie/ドブロイ/
debt /デット/
debug /デバッグ/ディバッグ/
debugger /デバッガ/デバッガー/ディバッガ/
debugging /デバッギング/
debussy /ドビュッシー/
debut /デビュー/
debutalbum /デビューアルバム/
debutsingle /デビューシングル/
dec /DEC/
deca /デカ;[SI接頭語]da,10^1/
decade /ディケード/ディケイド/
decadence /デカダンス/
decadent /デカダン/
decal /デカール;decalcomania/
decalcomanie /デカルコマニー/
decalog /デカローグ;十戒/
decalogue /デカローグ;十戒/
decameron /デカメロン/
decane /デカン;C10H22/
decanter /デキャンタ/デカンタ/デキャンター/デカンター/
decare /デカール;1000m^2/
decay /ディケイ/
decca /デッカ/
deccan /デカン/
december /ディセンバー/
deci /デシ;[SI接頭語]d,10^-1/
decibel /デシベル;db/
decimal /デシマル/十進数/
decision /デシジョン/
deck /デッキ/デック/
deckbrush /デッキブラシ/
deckchair /デッキチェア/
decken /ゼッケン;(独語)/
decker /デッカ/デッカー/
deckshoes /デッキシューズ/
decode /デコード/復号化/
decoder /デコーダ/デコーダー/
decoding /デコーディング/
decollete /デコルテ/
deconvolution /デコンボリューション/
decor /デコール;(Fr)装飾/
decorate /デコレート/
decoration /デコレーション/
decorationcake /デコレーションケーキ;和製英語/
decorative /デコラティブ/デコレイティブ/
decoy /デコイ/
decrement /デクリメント/
decres /デクレッシェンド;次第に弱く/decrescendo/
decrescendo /デクレッシェンド/
dederot /ディドロ/
dee /ディー/
deep /ディープ/
deepblue /ディープブルー/
deepkiss /ディープキス/
deeplink /ディープリンク/
deeppurple /ディープパープル/
deepthroat /ディープスロート/
deet /ディート/
defacto /デファクト;de facto/
defactostandard /デファクトスタンダード;de facto standard/
defau /デフォ;default/
default /デフォルト/ディフォルト/省略/ディフォールト;<rare>/デファルト;<rare>/
defaultresourcefile /デフォルトリソースファイル/
defect /ディフェクト/
defence /ディフェンス/
defend /ディフェンド/
defender /ディフェンダー/
defending /ディフェンディング/
defendingchampion /ディフェンディングチャンピオン/
defense /ディフェンス/
deffenbacchia /ディフェンバキア/
define /デファイン/
definition /デフィニション/ディフィニション/
defla /デフレ;deflation/
deflation /デフレーション/デフレ/
deflator /デフレーター/デフレータ/
defoe /デフォー/
deformer /デフォルメ/
defrag /デフラグ;defragmentation/
degas /ドガ/
degaulle /ドゴール/ド・ゴール/
degrade /デグレード/
degree /ディグリー/°/℃;celsius/
deimos /ダイモス/デイモス/
deirdre /ディアドラ/
deja /デジャ/
dejavu /デジャヴ;(Fr) deja vu/デジャブ/デジャヴュ/デジャビュ/
dejeuner /デジュネ;(Fr)昼食/
dejohnette /ディジョネット/デジョネット/
del /デル/
delacroix /ドラクロワ/ドラクロア/
delaware /デラウェア;DE/
delay /ディレイ/ディレー/
delayed /ディレイド/
delayline /ディレイライン/
delegate /デリゲート/
delerue /ドルリュー/
delete /デリート/
deleuze /ドゥルーズ/
delft /デルフト/
delgado /デルガド/
delhi /デリー/
delia /デリア/
delibes /ドリーブ/
delica /デリカ/
delicacy /デリカシー/
delicate /デリケート/
delicatessen /デリカテッセン/
delicious /デリシャス/
delight /ディライト/
delikatessen /デリカテッセン;(独)/
delilah /デリラ/
delimiter /デリミタ/
delivery /デリバリー/
deliveryhealth /デリバリーヘルス/デリヘル/
delkey /DELキー/デリートキー/
dell /デル/
della /デラ/デッラ/
dellinger /デリンジャー/
delon /ドロン/
delos /デロス/
delphi /デルフィ/デルファイ/
delphine /デルフィーヌ/
delphinium /デルフィニウム/
delphoi /デルフォイ/
delpy /デルピー/
delta /δ/デルタ/
deltarule /δルール/
deluxe /デラックス/
dem /デム/
dema /デマ/
demacs /Ｄｅｍａｃｓ/
demagog /デマゴーグ/
demand /デマンド/
demel /デメル/
demerit /デメリット/
demeter /デメテル/
demi /デミ/ドゥミ;仏語/
demian /デミアン/
demiglace /デミグラス/ドミグラス/
demiglacesauce /デミグラスソース/ドミグラスソース/
demitasse /デミタス;demi-tasse/
demo /デモ;demonstration/デモ版/
democracy /デモクラシー/
demokritos /デモクリトス/
demon /デーモン/
demonbane /デモンベイン/
demonstration /デモンストレーション/
demonstrator /デモンストレーター/デモンストレータ/
demorgan /ド・モルガン;(1806-1871) Augustus de Morgan/ドモルガン;De Morgan/
demosthenes /デモステネス/
demotape /デモテープ/
demy /ドゥミ/デミー/
den /デン/
dendro /デンドロ/
dendrobium /デンドロビウム/
deneuve /ドヌーヴ/
denhaag /ハーグ;Den Haag/
denied /ディナイド/拒否された/
denier /デニール/
denim /デニム/
denimjacket /デニムジャケット/
denimpants /デニムパンツ/
denimskirt /デニムスカート/
denis /デニス/ドニ/ドゥニ/
denise /デニス/
deniz /デニス/
denmark /デンマーク;.dk/
dennett /デネット/
dennis /デニス/
dennys /デニーズ;Denny's/
denomi /デノミ;denomination/
denomination /デノミネーション/
denotation /デノテーション/
denotational /デノテーショナル/
denpasar /デンパサール;バリ島(インドネシア)/
dense /デンス/
density /デンシティ/
dent /デント/
dental /デンタル/
dentalcare /デンタルケア/
denver /デンヴァー/デンバー;コロラド(USA)/
denys /デニス/
deodorant /デオドラント/
deoxy /デオキシ/
deoxyribose /デオキシリボース/
depardieu /ドパルデュー/
depart /デパート/
department /デパートメント/デパート/
departure /デパーチャー/
depaysement /デペイズマン;仏語/
depend /ディペンド/
dependency /ディペンデンシ/
depo /デポ/
deposerver /デポサーバー/
deposit /デポジット/
depth /デプス/
dequeue /デキュー/
der /ダー/
derby /ダービー/
derek /デレク/デリク/デレック/
derick /デリック/デリク/
deringer /デリンジャー/
derivative /デリバティブ/
derived /デライブド/
derrick /デリック/デリク/
derrida /デリダ/
derringer /デリンジャー/
des /デ;仏語/デス/
desailly /デサイー/
desc /記述子;descriptor/
descartes /デカルト/
descente /デサント/
describe /ディスクライブ/
descripter /記述子;※descriptor/
description /ディスクリプション/
descriptor /ディスクリプタ/記述子/
desert /デザート/
deserteagle /デザートイーグル/
design /デザイン/
designer /デザイナー/デザイナ/
designers /デザイナーズ/
designersbrand /デザイナーズブランド/
designpattern /デザインパターン/
desir /デジール;仏語/
desire /デザイア/デザイアー/デジレ;仏語/
desiree /デジレ;仏語/
desk /デスク/
desklight /デスクライト/
desktop /デスクトップ/
desktoppc /デスクトップPC/デスクトップパソコン/
deskwork /デスクワーク/
desmond /デズモンド/
desmonde /デスモンド/
desnos /デスノス/
dessau /デッサウ/
dessert /デザート/
dessertwine /デザートワイン/
dessin /デッサン/
destination /デスティネーション/ディスティネーション/デスティネイション/
destiny /デスティニー/ディスティニー/
destroy /デストロイ/破壊する/
destroyer /デストロイヤー/破壊者/
destruction /デストラクション/
destructor /デストラクタ/ディストラクタ/消滅子/
det /行列式;determinant/
detach /デタッチ/
detail /ディテール/
detect /ディテクト/発見する/
detective /ディテクティブ/
detector /ディテクタ/ディテクター/
detente /デタント/
detonation /デトネーション/
detroit /デトロイト/
detune /デチューン/
deuce /デュース/ジュース/
deutsch /ドイツ/ドイツ語/ドイチュ/
deutsche /ドイチェ/
deutschegp /ドイツGP;[F1]/
deutschland /ドイツ;.de/
deux /ドゥ/ドゥー/
deuxmagots /ドゥマゴ;Les Deux Magots/
develop /ディベロップ/デベロップ/
developer /デベロッパー/ディベロッパー/デベロッパ/
development /デベロップメント/ディベロップメント/
device /デバイス/デヴァイス/
devicedriver /デバイスドライバ/デバイスドライバー/
deviceid /デバイスID/
devicemanager /デバイスマネージャ/デバイスマネージャー/
devil /デビル/
devilman /デビルマン/
devilrays /デビルレイズ;[MLB]Devil Rays/
devin /デヴィン/
devine /デヴァイン/ディバイン/
devon /デボン/デヴォン/
devora /デボラ/
dew /デュー/
dewey /デューイ/
dex /デックス/
dexter /デクスター/
dextrin /デキストリン/
dharan /ダーラン;サウジアラビア/
dharma /ダルマ;法/
dhcpc /DHCPクライアント/
dhcpclient /DHCPクライアント/
dhcps /DHCPサーバ/
dhcpserver /DHCPサーバ/
dhole /ドール/
di /ジ;2/ディ/
dia /ダイヤ/ダイア/◇;菱形/◆;菱形/
diablo /ディアブロ/
diabolo /ディアボロ/
diacritical /ダイアクリティカル/
diagnosis /ダイアグノーシス/
diagram /ダイアグラム/ダイヤグラム/
dial /ダイヤル/ダイアル/
dialer /ダイアラー/ダイヤラー/ダイヤラ/ダイアラ/
dialin /ダイヤルイン/ダイアルイン/
dialing /ダイアリング/
dialog /ダイアログ/ダイアローグ/
dialogbox /ダイアログボックス/
dialogue /ダイアログ/
dialq# /ダイヤルQ#0/ダイヤルＱ#1/
dialq2 /ダイヤルQ2/ダイヤルＱ２/
dialup /ダイアルアップ/ダイヤルアップ/
diamond /ダイヤモンド/ダイアモンド/◇;菱形/◆;菱形/ダイヤ/金剛石/
diamondbacks /ダイヤモンドバックス;[MLB]/
diamondcut /ダイヤモンドカット/
diamonddust /ダイヤモンドダスト/
diana /ダイアナ/ディアナ/ディアーナ/
diane /ダイアン/ディアヌ/
dianne /ダイアン/
diary /ダイアリー/ダイアリ/
diaspora /ディアスポラ;(ギリシア語)離散/
diastase /ジアスターゼ/
diatone /ダイアトーン/
diatonic /ダイアトニック/
diaz /ディアス/ディアズ/
dibromochloromethane /ジブロモクロロメタン;(CHBr2Cl) トリハロメタンの一種/
dic /ディック/辞書/
dicaprio /ディカプリオ;DiCaprio/
dice /ダイス/
dichloro /ジクロロ/
dichloroethylene /ジクロロエチレン;C2H2Cl2/
dichloromethane /ジクロロメタン/
dick /ディック/
dickens /ディケンズ/
dickie /ディッキー/
dickson /ディクソン/ディクスン/
dictionary /ディクショナリー/ディクショナリ/辞書/
did /ディド/
diderot /ディドロ/
didge /ディジュ;didgeridoo/
didgeridoo /ディジュリドゥ/ディジュリドゥー/ディジリドゥ/ディジェリドゥ/ディジェリドゥー/ディジリドゥー/
didier /ディディエ/
dido /ディド/
didot /ディド/
die /ダイ/ディー/
diecast /ダイキャスト;die-cast/ダイカスト/
diego /ディエゴ/
diehard /ダイハード/
dies /ダイス/
diesel /ディーゼル/
dieselcar /ディーゼルカー/
dieselengine /ディーゼルエンジン/
dieskau /ディースカウ/
diet /ダイエット/
dietary /ダイエタリー/
dieter /ディーター/
dietfood /ダイエットフード/
diethyl /ジエチル/
dietrich /ディートリッヒ/ディートリヒ/
dieu /デュー;(Fr)神/
diff /ディフ/
difference /ディファレンス/
different /ディファレント/
differential /ディファレンシャル/∂/デフ/
diffuse /ディフューズ/
diffusion /ディフュージョン/
dig /ディグ/
digest /ダイジェスト/
digger /ディガー/
digicame /デジカメ;digital camera/
digipak /デジパック;[商標]AGI/
digit /デジット/ディジット/
digital /デジタル/ディジタル/Digital/
digitalaudio /デジタルオーディオ/
digitalaudioplayer /デジタルオーディオプレーヤー;dap/デジタルオーディオプレイヤー/
digitalcamera /デジタルカメラ/デジカメ/
digitaldata /デジタルデータ/
digitaldivide /デジタルデバイド/デジタルディバイド/ディジタルデバイド/ディジタルディバイド/
digitalhivision /デジタルハイビジョン/
digitalis /ジギタリス/
digitalpiano /デジタルピアノ/
digitalprint /デジタルプリント/
digitalsound /デジタルサウンド/
digitalsurround /デジタルサラウンド/
digitaltv /デジタルテレビ/
digitalvideo /デジタルビデオ/
digitalzoom /デジタルズーム/
digitizer /デジタイザ/デジタイザー/
dignity /ディグニティ/
dihydro /ジヒドロ/
dijkstra /ダイクストラ/
dijon /ディジョン/
dike /ダイク/
dilation /ダイレーション/
dildo /ディルド/ディルドー/
dilemma /ジレンマ/
dilettante /ディレッタント/
dill /ディル/
dillon /ディロン/
dilly /ディリー/
dim /ディム/ディミヌエンド;次第に弱く/diminuendo/
dimaggio /ディマジオ;DiMaggio/
dimanche /ディマンシュ;(Fr) 日曜日/
dimbula /ディンブラ;紅茶/
dime /ダイム/
dimension /ディメンション/ディメンジョン/
dimethyl /ジメチル/
dimethylamine /ジメチルアミン/
dimethylether /ジメチルエーテル/
diminish /ディミニッシュ/
diminuendo /ディミヌエンド/
dimple /ディンプル/
dina /ダイナ/ディナ/
dinah /ダイナ/
dinar /ディナール/
dine /ダイン/
diner /ダイナー/ディネ;(Fr)夕食/
diners /ダイナース/ダイナーズ/
dinghy /ディンギー/
dingo /ディンゴ/
dining /ダイニング/
diningkitchen /ダイニングキッチン/
diningroom /ダイニングルーム/
diningset /ダイニングセット/
diningtable /ダイニングテーブル/
dinkie /ディンキー/
dinks /ディンクス/double income, no kids/
dinner /ディナー/
dinnershow /ディナーショー/
dinnertime /ディナータイム/
dino /ディーノ/ディノ/
diode /ダイオード/
diogenes /ディオゲネス/
diol /ジオール/
dion /ディオン/
dionne /ディオンヌ/
dionysos /ディオニュソス/ディオニソス/
dior /ディオール;www.dior.com/
diorama /ジオラマ/ディオラマ/
dios /ディオス/
dioxin /ダイオキシン/
dip /ディップ/
diphtheria /ジフテリア/
diplomacy /ディプロマシー/
diplomat /ディプロマット/
diplomate /ディプロマット/
diplomatic /ディプロマティック/
diplomatique /ディプロマティーク;仏語/
dipole /ダイポール/
dipswitch /ディップスイッチ/DIPスイッチ/
dir /ディレクトリ/ディレクトリー/
dirac /ディラック/ディラク/
direct /ダイレクト/
direction /ディレクション/
directive /ディレクティブ/
directlink /ダイレクトリンク;直リン/
directmail /ダイレクトメール/
director /ディレクター/
directory /ディレクトリ/ディレクトリー/ディレクトリィ/デイレクトリー/
dirichlet /ディリクレ/
dirk /ディルク/デリック/
dirt /ダート/
dirtcourse /ダートコース/
dirty /ダーティ/ダーティー/
dis /ディス/
disable /ディスエーブル/ディゼーブル/
disassemble /ディスアセンブル/
disassembler /ディスアセンブラ/
disaster /ディザスター/ディザスタ/
disc /ディスク/
discard /ディスカード/
discarray /ディスクアレイ/
discbrake /ディスクブレーキ/
discharge /ディスチャージ/
discjockey /ディスクジョッキー;DJ/
disclosure /ディスクロージャー/ディスクロージャ/
discman /ディスクマン/
disco /ディスコ/
discography /ディスコグラフィー/ディスコグラフィ/
discommunication /ディスコミュニケーション/
disconnect /ディスコネクト/
discount /ディスカウント/
discountshop /ディスカウントショップ/
discountstore /ディスカウントストア/
discours /ディスクール/
discourse /ディスコース/
discovery /ディスカバリー/
discrete /ディスクリート/
discreview /ディスクレビュー/
discrimination /ディスクリミネーション/
discriminator /ディスクリミネータ/
discunion /ディスクユニオン/
discuss /ディスカス/
discussion /ディスカッション/
dish /ディッシュ/
disk /ディスク/DISK/
diskaccess /ディスクアクセス/
diskarray /ディスクアレイ/
diskcase /ディスクケース/
diskdrive /ディスクドライブ/
diskette /ディスケット/
diskimage /ディスクイメージ/
diskjockey /ディスクジョッキー/
diskless /ディスクレス/
diskman /ディスクマン/
diskreview /ディスクレビュー/
diskspace /ディスクスペース/
disney /ディズニー/
disneyland /ディズニーランド/
disneyresort /ディズニーリゾート/
disneysea /ディズニーシー;DisneySea/
disorder /ディスオーダー/
dispatch /ディスパッチ/
dispatcher /ディスパッチャ/
dispencer /ディスペンサー/ディスペンサ/
dispenser /ディスペンサー/
displacement /ディスプレイスメント/
display /ディスプレイ/ディスプレー/
disposer /ディスポーザー/
distance /ディスタンス/
distemper /ジステンパー/
distortion /ディストーション/
distri /ディストリ;distribution (NB:英語ではdistro)/
distribution /ディストリビューション/
distributor /ディストリビューター/ディストリビュータ/
district /ディストリクト/
distro /ディストロ;(Linuxの)distribution/
dita /ディタ/
dither /ディザ/
dithering /ディザリング/
div /÷/
diva /ディーバ/ディーヴァ;歌姫/
dive /ダイブ/ダイヴ/
diver /ダイバー/
divergence /ダイバージェンス/
diversity /ダイバーシティ/ダイバシティ/
divertimento /ディヴェルティメント/ディベルティメント/
divide /デバイド/ディバイド/
divider /ディバイダー/デバイダー/
divine /ディバイン/ディヴァイン/デヴァイン/デバイン/
diving /ダイビング/ダイヴィング/
divingcatch /ダイビングキャッチ/
division /ディビジョン/ディヴィジョン/
divot /ディボット/
dixie /デキシー/ディキシー/ディクシー/
dixieland /デキシーランド/ディキシーランド/
dixielandjazz /デキシーランドジャズ/
dizzy /ディジー/
dj /ディスクジョッキー/
django /ジャンゴ/
djembe /ジャンベ/
djibouti /ジブチ;.dj/
djinni /ジン/
dma /DMA/Direct Memory Access/
dmitri /ドミトリー/
dmitrii /ドミトリー/
dmitry /ドミトリー/
dnepr /ドニエプル/
do /ドゥ/ド/
dob /ドブ/
doberman /ドーベルマン/
dobermann /ドーベルマン;(独語)/
doc /ドク;doctor/ドキュメント;document/
docetaxel /ドセタキセル/
dock /ドック/
docking /ドッキング/
docment /ドキュメント;※document/
docomo /ドコモ;www.nttdocomo.co.jp/DoCoMo/
doctor /ドクター/ドクトル/博士/医者/博士課程/
doctorcar /ドクターカー/
doctorcheck /ドクターチェック/
doctorcourse /ドクターコース/
doctorstop /ドクターストップ/
doctrine /ドクトリン/
document /ドキュメント/文書/
documentalist /ドキュメンタリスト/
documentary /ドキュメンタリー/
documentation /ドキュメンテーション/
dodge /ドッジ/
dodgeball /ドッジボール/
dodgers /ドジャース;[MLB]/
dodo /ドードー/
doek /ズック;(蘭語)/
does /ダズ/
dog /ドッグ/
dogfight /ドッグファイト/
dogfood /ドッグフード/
doggie /ドギー/
doggy /ドギー/
dogleg /ドッグレッグ/
dogma /ドグマ/
dogmatic /ドグマティック/ドグマチック/
dograce /ドッグレース/
dogshow /ドッグショー/
dogtag /ドッグタグ/
doha /ドーハ/
dohran /ドーラン/
doimoi /ドイモイ/
dolby /ドルビー/
dolbydigital /ドルビーデジタル;Dolby digital/
dolbysurround /ドルビーサラウンド/
dolce /ドルチェ;www.dolcegabbana.it/
dolcetto /ドルチェット/
dole /ドール/
dolittle /ドリトル/
doll /ドール/ドル/
dollar /ドル/ダラー/＄/
dolly /ドリー/
dolmen /ドルメン/
dolomite /ドロマイト/
dolores /ドロレス/
dolphin /ドルフィン/イルカ/
dolphy /ドルフィー/ドルフィ/
dom /ドム/
domain /ドメイン/ドメーン;<rare>/
domainname /ドメインネーム/ドメイン名/
domani /ドマーニ/
dome /ドーム/
domenica /ドメニカ/
domenico /ドメニコ/
domestic /ドメスティック/
domi /ドミ/
domina /ドミナ/
dominant /ドミナント/
domingo /ドミンゴ/
dominic /ドミニク/
dominica /ドミニカ;.dm/
dominik /ドミニク/
dominion /ドミニオン/
dominique /ドミニク/
domino /ドミノ/
domperi /ドンペリ;Dom Perignon/
domperignon /ドンペリニョン;Dom Perignon/ドンペリニヨン/ドンペリ/
don /ドン/
donald /ドナルド/
donaldduck /ドナルドダック;[商標]Disney/
donaldson /ドナルドソン/
donatello /ドナテッロ/ドナテロ/ドナテルロ/
donation /ドネーション;寄付/
donato /ドナート/
donau /ドナウ/
done /ダン/
donetsk /ドネツク/
dongle /ドングル/
doni /ドニ/
donizetti /ドニゼッティ/
donjuan /ドンファン;Don Juan/
donkey /ドンキー/
donna /ドナ/ドンナ/
donnie /ドニー/
donny /ドニー/
donor /ドナー/
donorcard /ドナーカード/
donovan /ドノヴァン/ドノバン/
donquijote /ドンキホーテ;Don Quijote/ドン・キホーテ/
donquixote /ドンキホーテ;(英語綴) Don Quixote/ドン・キホーテ/
dont /ドント;don't/
dontmind /ドンマイ;Don't mind/
donut /ドーナツ/ドーナッツ/
donuts /ドーナツ/ドーナッツ/
dooard /ドアーズ;紅茶/
dooley /ドーリー/
doom /ドゥーム/
door /ドア/ドアー/
doorbell /ドアベル/
doorchain /ドアチェーン/
doorchime /ドアチャイム/
doorknob /ドアノブ/
doorlock /ドアロック/
doorman /ドアマン/
doormirror /ドアミラー/
doorphone /ドアホン;和製英語(intercom)/
doors /ドアーズ/
doorstopper /ドアストッパー/
dopa /ドーパ;DihydrOxyPhenylAlanine/
dopamine /ドーパミン/ドパミン/
dope /ドープ/
doping /ドーピング;薬物使用/
doppelganger /ドッペルゲンガー/
doppler /ドップラー/ドップラ/
dor /ドール/
dora /ドラ/ドーラ/
doreen /ドリーン/
doremi /ドレミ/
doremifa /ドレミファ/
dorham /ドーハム/
doria /ドリア/ドーリア/
dorian /ドリアン;DEFGABCD/
doris /ドリス/ドーリス/
dormie /ドーミー/
dormitory /ドミトリー/
dorothy /ドロシー/
dorris /ドリス/
dortmund /ドルトムント/
dos /ドス/DOS/
dose /ドーズ/
dostoevskii /ドストエフスキー;Достоевский/ドストエフスキイ/
dostoevsky /ドストエフスキー/ドストエフスキイ/
dostoyevsky /ドストエフスキー/ドストエフスキイ/
dosv /(concat "DOS\057V")/
dot /ドット/./．/・/、;読点/，;comma/丶;「チュ」の字/…/・・・;中黒x3/
dotcom /ドットコム;.com/
dotfile /ドットファイル;.skk/
dotfont /ドットフォント/
dotpitch /ドットピッチ/
dots /ドッツ/…/‥/.../・・・;中黒x3/
dotted /ドッティド/
dotter /ドッター/
double /ダブル/
doublea /ダブルA/
doublebass /ダブルベース/
doublebed /ダブルベッド/
doublebind /ダブルバインド/
doublebooking /ダブルブッキング/
doubleclick /ダブルクリック/
doublecount /ダブルカウント/
doubledagger /‡;ddagger/
doubledecker /ダブルデッカー/
doubledribble /ダブルドリブル/
doubleeagle /ダブルイーグル/
doublefault /ダブルフォルト/ダブルフォールト/
doubleflat /ダブルフラット/
doubleheader /ダブルヘッダー/
doubleplay /ダブルプレー/ダブルプレイ/
doublepunch /ダブルパンチ/
doublequotation /ダブルクオーテーション;”/
doublequote /ダブルクォート/“;opening/”;closing/
doublereed /ダブルリード/
doubleroom /ダブルルーム/
doubles /ダブルス/
doubleschool /ダブルスクール/
doublescore /ダブルスコア/
doublesharp /ダブルシャープ/
doublesize /ダブルサイズ/
doublestandard /ダブルスタンダード/
doublesteal /ダブルスチール/
doubleu /ダブリュー/
doubleyew /ダブリュー/
doubleyou /ダブリュー/
doubling /ダブリング/
doubt /ダウト/
douce /ドゥース/
doug /ダグ/ダッグ/
dougal /ドゥーガル/
dough /ドウ/
doughnut /ドーナツ/ドーナッツ/
doughnuts /ドーナツ/ドーナッツ/
douglas /ダグラス/
douglass /ダグラス/
doulton /ドルトン/
doutor /ドトール/
doux /ドウ/
dove /ダブ/ダヴ/
dover /ドーバー/ドーヴァー/
dow /ダウ/
down /ダウン/↓/
downarrow /↓/
downbeat /ダウンビート/
downer /ダウナー/
downgrade /ダウングレード/
downhill /ダウンヒル/
downjacket /ダウンジャケット/
downlight /ダウンライト/
downlink /ダウンリンク/
download /ダウンロード/
downloader /ダウンローダ/ダウンローダー/
downsampling /ダウンサンプリング/
downside /ダウンサイド/
downsizing /ダウンサイジング/
downstream /ダウンストリーム/
downswing /ダウンスイング/
downto /↓/
downtown /ダウンタウン/
downvest /ダウンベスト/
dowsing /ダウジング/
doyle /ドイル/
dozen /ダース/ダズン/
dq /ドラクエ;[ゲーム]Dragon Quest/
drab /ドラブ;鳶色/
dracaena /ドラセナ/
drachma /ドラクマ/
dracula /ドラキュラ/
draft /ドラフト/
drafting /ドラフティング/
drag /ドラッグ/
draganddrop /ドラッグアンドドロップ/
dragee /ドラジェ/
dragging /ドラッギング/
dragon /ドラゴン/
dragonball /ドラゴンボール;[アニメ]/
dragonfruit /ドラゴンフルーツ/
dragonquest /ドラゴンクエスト;[ゲーム]Enix/ドラクエ/
dragons /ドラゴンズ/
dragonslayer /ドラゴンスレイヤー/
dragoon /ドラグーン;竜騎兵/
dragrace /ドラッグレース/
drain /ドレイン/ドレン/ドレン／ベント/
drak /ドラク/
drake /ドレーク/ドレイク/
drama /ドラマ/
dramatic /ドラマティック/ドラマチック/
dramaturgie /ドラマツルギー/
dramaturgy /ドラマツルギー/
drang /ドラング/
drank /Dランク/Ｄランク/
drape /ドレープ/
drastic /ドラスティック/
dravida /ドラヴィダ/ドラビダ/
draw /ドロー/
drawer /ドロワ/ドロアー/ドロワー/ドロア/
drawers /ズロース/
drawing /ドローイング/
dread /ドレッド/
dreadhair /ドレッドヘア/
dreadnought /ドレッドノート/
dream /ドリーム/
dreamcast /ドリームキャスト;[商標]SEGA/
dreamer /ドリーマー/
dreaming /ドリーミング/
dreamjumbo /ドリームジャンボ;宝くじ/
dreamland /ドリームランド/
dreams /ドリームス/ドリームズ/
dreamteam /ドリームチーム/
dreamy /ドリーミー/
drei /ドライ/
dresden /ドレスデン/
dress /ドレス/
dresscode /ドレスコード/
dresser /ドレッサー/
dressing /ドレッシング/
dressshirt /ドレスシャツ/
dressshirts /ドレスシャツ/
dressup /ドレスアップ/
dressy /ドレッシー/
drew /ドリュー/ドルー/ドゥルー/
drewell /ドリエル/
dreyfus /ドレフュス/
dribble /ドリブル/
drier /ドライヤー/
drift /ドリフト/
drifter /ドリフター/
drifters /ドリフターズ/
drill /ドリル/
driller /ドリラー/
drink /ドリンク/
drinkbar /ドリンクバー/
drinker /ドリンカー/
drip /ドリップ/
dripcoffee /ドリップコーヒー/
dripper /ドリッパー/
dripping /ドリッピング/
drive /ドライブ/ドライヴ/
drivebay /ドライブベイ/
drivecourse /ドライブコース/
drivein /ドライブイン/
driveletter /ドライブレター/
drivemap /ドライブマップ;和製英語(roadmap)/
driven /ドリブン/
driver /ドライバー/ドライバ/ドライヴァ/
driverset /ドライバーセット/
driveway /ドライブウェイ/ドライブウェー/
driving /ドライビング/ドライヴィング/
drocer /ドローサー/
droit /ドロワ/
dron /Ｄ論/
drone /ドローン/
drop /ドロップ/
dropgoal /ドロップゴール/
drophandle /ドロップハンドル/
dropin /ドロップイン/
dropkick /ドロップキック/
dropout /ドロップアウト/
drops /ドロップス/
dropshot /ドロップショット/
drpepper /ドクターペッパー;www.drpepper.com/Dr Pepper;"Dr"はドットなし/
druaga /ドルアーガ/
drucker /ドラッカー/
drug /ドラッグ/
drugstore /ドラッグストア/
druid /ドルイド/
drum /ドラム/
drumbrake /ドラムブレーキ/
drumhead /ドラムヘッド/
drummer /ドラマー/
drumming /ドラミング/
drumnbass /ドラムンベース;drum'n'bass/
drumroll /ドラムロール/
drums /ドラムス/
drumset /ドラムセット/
drumsolo /ドラムソロ/
drumstick /ドラムスティック/
drunk /ドランク/
drunker /ドランカー/
dry /ドライ/
dryad /ドリアード/ドライアド/
drycleaning /ドライクリーニング/
drycurry /ドライカレー;dried curry/
dryer /ドライヤー/
dryeye /ドライアイ/
dryflower /ドライフラワー;dried flower/
dryfood /ドライフード/
dryfruit /ドライフルーツ;dried fruits/
dryfruits /ドライフルーツ;dried fruits/
dryice /ドライアイス/
drymartini /ドライマティーニ/
drypoint /ドライポイント/
dryskin /ドライスキン/
drysuit /ドライスーツ/
drysuits /ドライスーツ/
drytype /ドライタイプ/
dryyeast /ドライイースト/
dsp /デジタル信号処理;digital signal processing/ディジタル信号処理/
dte /DTE/
dtmsoft /DTMソフト/
dtpsoft /DTPソフト/
dtype /Dタイプ/Ｄタイプ/
du /デュ/
dual /デュアル/
dualboot /デュアルブート/
dualdisplay /デュアルディスプレイ/
dualmode /デュアルモード/
dualsystem /デュアルシステム/
duane /デュアン/ドゥエイン/デュエイン/
dub /ダブ/
dubai /ドバイ;UAE/
dubbing /ダビング/
dubble /ダブル;?/
dublin /ダブリン/
duboeuf /デュブッフ/
dubois /デュボワ/
ducamp /デュカン/
ducasse /デュカス/
duchamp /デュシャン/
duck /ダック/ズック/
ducking /ダッキング/
ducru /デュクリュ/
duct /ダクト/
dud /ダッド/
dudley /ダドリー/ダッドリー/
due /デュー/
duel /デュエル/
duelist /デュエリスト/
dueprocess /デュープロセス/
duet /デュエット/
duetto /デュエット/
duff /ダフ/
duffel /ダッフル/
duffelcoat /ダッフルコート/
duffle /ダッフル/
dufflecoat /ダッフルコート/
dufy /デュフィ/
dugong /ジュゴン/
dugout /ダッグアウト/ダグアウト/
dukas /デュカス/
duke /デューク/
dulcie /ダルシー/
dulcimer /ダルシマー/
dulfer /ダルファー/
dull /ダル/
dumas /デュマ/
dumb /ダム/
dumbbell /ダンベル/
dumbo /ダンボ/
dumdum /ダムダム/
dummy /ダミー/
dummyhead /ダミーヘッド/
dump /ダンプ/
dumpcar /ダンプカー;和製英語(dump truck)/
dumper /ダンパー/
dumping /ダンピング/
dumpty /ダンプティ/ダンプティー/
dun /ダン/
dunan /デュナン/
dunaway /ダナウェイ/
duncan /ダンカン/
dundee /ダンディ/
dune /デューン/
dungarees /ドンゴロス/
dungeon /ダンジョン/
dungeons /ダンジョンズ/
dunhill /ダンヒル;www.dunhill.com/
dunk /ダンク/
dunkerque /ダンケルク/
dunlop /ダンロップ/
duo /デュオ/
duplex /デュプレックス/デュープレックス/デュプレクス/
duplicate /デュプリケート/デュプリケイト/デュープリケート/
dupont /デュポン;Du Pont de Nemours/
duralumin /ジュラルミン/
duran /デュラン/
durand /デュラン/
duras /デュラス/
duration /デュレーション/デュレイション/
durban /ダーバン;南ア/
durer /デューラー/
durga /ドゥルガー/
durian /ドリアン/
durkheim /デュルケム/デュルケーム/
dushanbe /ドゥシャンベ/
duskin /ダスキン;www.duskin.co.jp/
dusseldorf /デュッセルドルフ/
dust /ダスト/
dustbox /ダストボックス/
dustcover /ダストカバー/
duster /ダスター/
dustin /ダスティン/
dusty /ダスティ/ダスティー/
dutch /ダッチ/
dutchoven /ダッチオーブン/
dutchroll /ダッチロール/
dutchwife /ダッチワイフ/
dutoit /デュトワ/
duty /デューティー/デューティ/
dutyfree /デューティーフリー/デューティフリー/
dvdaudio /DVDオーディオ/
dvdbox /DVDボックス/
dvdcase /DVDケース/
dvddeck /DVDデッキ/
dvddrive /DVDドライブ/
dvdmulti /DVDマルチ/
dvdmultidrive /DVDマルチドライブ/
dvdplayer /DVDプレーヤー/DVDプレイヤー/
dvdrack /DVDラック/
dvdrecorder /DVDレコーダー/
dvdshop /DVDショップ/
dvdvideo /DVDビデオ/
dvdvideocamera /DVDビデオカメラ/
dvorak /ドヴォルザーク/ドボルザーク/ドヴォルジャーク/ドボルジャーク/
dwarf /ドワーフ/
dwight /ドワイト/
dy /ジスプロシウム/Dysprosium/
dyck /ダイク/
dying /ダイイング/
dyingmessage /ダイイングメッセージ/
dylan /ディラン/Ｄｙｌａｎ/Dylan/Dylan(Dynamic language)/
dyna /ダイナ/
dynabook /ダイナブック;[商標]東芝/
dynamic /ダイナミック/
dynamicrange /ダイナミックレンジ/
dynamics /ダイナミクス/ダイナミックス/
dynamism /ダイナミズム/
dynamite /ダイナマイト/
dynamo /ダイナモ/
dynasty /ダイナシティ/ダイナスティ/
dyne /ダイン;10^-5N/
dyquem /ディケム;d'Yquem/
dysprosium /ジスプロシウム;[元素]66,Dy/
dystrophy /ジストロフィー/ジストロフィ/
e /ε;epsilon/イー/э;cyrillic/エー;(独語)/ウー;(仏語)/
e+ /イープラス;eee.eplus.co.jp/
eaccess /イーアクセス;www.eaccess.net/
each /イッチ/
eagle /イーグル/
eagles /イーグルス/
ear /イヤー/イア/
earhook /イヤーフック/
earl /アール/
earlgrey /アールグレイ;Earl Grey/アールグレー/
early /アーリー/
earlyamerican /アーリーアメリカン/
earpad /イヤーパッド/
earphone /イヤホン/イヤフォン/イアフォン/
earring /イヤリング/イアリング/
earth /アース/
earthday /アースデイ;4.22/
earthquake /アースクエイク/
earthy /アーシー/
ease /イーズ/
easel /イーゼル/
eason /イーソン/
east /イースト/Ｅａｓｔ/
eastcoast /イーストコースト/
eastend /イーストエンド;East End, London/
easter /イースター/
easteregg /イースターエッグ/
eastern /イースタン/
easternleague /イースタンリーグ/
eastside /イーストサイド/
eastwood /イーストウッド/
easy /イージー/
easylistening /イージーリスニング/
easyorder /イージーオーダー/
easyrider /イージーライダー/
eat /イート/
eater /イーター/
eatin /イートイン;eat-in/
eau /オー;(Fr)水/
eaudecologne /オーデコロン;eau de Cologne/
eaudetoilette /オードトワレ;eau de toilette/
ebank /イーバンク;www.ebank.co.jp/
ebay /イーベイ;www.ebay.com/
ebola /エボラ/
ebonite /エボナイト/
ebony /エボニー/
ebro /エブロ/
ecaprolactam /ε-カプロラクタム/ε-caprolactam/
ecbatana /エクバタナ/
eccentric /エキセントリック/
echalote /エシャロット/
echelon /エシュロン;米国営の盗聴システム/
echinacea /エキナセア/エキナシア/
echo /エコー/
echoback /エコーバック/
eckart /エッカート/エッカルト/
eckert /エッカート/
eckhard /エックハルト/
eckhardt /エックハルト/
eclaire /エクレア/
eclipse /エクリプス/
eco /エコ/エーコ;(1932-) Umberto Eco/
ecobusiness /エコビジネス/
ecohouse /エコハウス/
ecole /エコール;仏語/
ecological /エコロジカル/
ecologist /エコロジスト/
ecology /エコロジー/
ecomark /エコマーク;ちきゅうにやさしい/
ecommerce /eコマース/Eコマース/
economic /エコノミック/
economical /エコノミカル/
economics /エコノミクス/エコノミックス/
economist /エコノミスト/
economy /エコノミー/
economyclass /エコノミークラス/
ecosystem /エコシステム/
ecrit /エクリ/
ecriture /エクリチュール/
ecstasy /エクスタシー/
ecuador /エクアドル;.ec/
ecup /Eカップ;20cm/Ｅカップ/
ed /エド/
eda /エダ/
edam /エダム/
edamcheese /エダムチーズ/
edbeta /ＥＤベータ/
edda /エッダ/
eddie /エディ/エディー/
eddy /エディ/エディー/
ede /イード/
edel /エーデル;(独語)高貴な/エデル/
edelweiss /エーデルワイス/
eden /エデン/
edgar /エドガー/
edgard /エドガー/
edge /エッジ/
edging /エッジング/
edible /エディブル/
edie /エディ/エディー/イーディ/
edinburgh /エディンバラ/エジンバラ;イギリス/
edison /エジソン/エディソン/
edit /エディット/エディト/編集/
edith /エディス/イーディス/
editing /エディティング/
edition /エディション/
editor /エディタ/エディター/
editorial /エディトリアル/
editors /エディターズ/
edmond /エドモンド/エドモン/
edmondo /エドモンド/
edmonton /エドモントン/
edmund /エドモンド/エドマンド/エドムント/
edna /エドナ/
edoard /エドゥアルド/エドアルド/
edoardo /エドアルド/
edouard /エドゥアール/エドワール/
edrive /Eドライブ;E:/Ｅドライブ/
edu /エドゥ/
eduard /エドゥアルド/エドアルド/エデュアルド/エドゥアルト/
eduardo /エドゥアルド/エドアルド/エデュアルド/
educatation /エデュケーション/
education /エデュケーション/エデュケイション/
educational /エデュケーショナル/
educator /エデュケーター/
edutainment /エデュテイメント;[新語]education + entertainment/エデュテインメント/
edward /エドワード/
edwin /エドウィン/
ee /η;eta/イー/
eel /イール/
eero /エーロ/
ef /ф;cyrillic/エフ/
eff /エフ/
effect /エフェクト/イフェクト/
effector /エフェクター/エフェクタ/イフェクタ/
effects /エフェクツ/
effort /エフォート/
egalite /エガリテ;(Fr)平等/
egg /エッグ/
eggman /エッグマン;Goo goo g'joob!/
egmont /エグモント/
ego /エゴ/
egoism /エゴイズム/
egoist /エゴイスト/
egoistic /エゴイスティック/
egon /エゴン/
egypt /エジプト;.eg/
egyptian /エジプシャン/
egyptianmau /エジプシャンマウ/
eichmann /アイヒマン/
eicosanoid /エイコサノイド/
eiffel /エッフェル/
eiger /アイガー/
eight /エイト/
eightball /エイトボール/
eightbeat /エイトビート/
eighteen /エイティーン/
eighth /エイス/
eighty /エイティ/
eileen /アイリーン/
ein /アイン/
einstein /アインシュタイン/
einsteinium /アインスタイニウム;[元素]99,Es/
eira /エイラ/
eire /エール/
eisenhower /アイゼンハワー/
eiswein /アイスヴァイン/
eizenshtein /エイゼンシュテイン/
eject /イジェクト/
ekaterina /エカテリーナ/エカチェリーナ/
el /エル/л;cyrillic/
elaine /エレイン/イレイン/
elan /エラン/
elastic /エラスティック/
elastin /エラスチン/
elba /エルバ/
elbe /エルベ/
elbow /エルボー/
elbowpad /エルボーパッド/
elda /エルダ/
elder /エルダー/
eldorado /エルドラド;El Dorado/
eleanor /エレナ/エレノア/エリノア/エレナー/エレアノール/
elearning /eラーニング;e-learning/
elec /エレキ/
elect /エレクト/
election /エレクション/
electone /エレクトーン/
electra /エレクトラ/
electric /エレクトリック/
electrical /エレクトリカル/
electricbass /エレクトリックベース/
electricguitar /エレクトリックギター/
electro /エレクトロ/
electroluminescence /エレクトロルミネッセンス;EL/エレクトロルミネセンス/
electron /エレクトロン/
electronic /エレクトロニック/
electronica /エレクトロニカ/
electronics /エレクトロニクス/
elegance /エレガンス/
elegant /エレガント/
elegante /エレガンテ/
elegie /エレジー/
elegy /エレジー/
elektra /エレクトラ/
element /エレメント/
elemental /エレメンタル/
elementary /エレメンタリー/
elements /エレメンツ/
elena /エレナ/エレーナ/
eleni /エレニ/
elenore /エレノア/エリノア/エリナー/
eleonora /エレオノーラ/
elephant /エレファント/
elescorial /エスコリアル;El Escorial/
elevation /エレベーション/
elevator /エレベーター/エレベータ/
elevatorgirl /エレベーターガール/
eleven /イレブン/
elf /エルフ/
elfin /エルフィン/
elgar /エルガー/
eli /エリ/
elia /エリア/
eliade /エリアーデ/
eliana /エリアナ/
elias /エリアス/イライアス/
elie /エリー/イリヤ/イリア/
elijah /エリヤ/
eliminator /エリミネーター/
elina /エリナ/エリーナ/
elinor /エリナ/エリノア/
elio /エリオ/
eliot /エリオット/
elis /エリス/
elisa /イライザ/エリザ/エリサ/
elisabeth /エリザベート/エリザベト/エリザベス/
elise /エリーゼ/エリース/エリーズ/エリス/
elisha /エリシャ/
elisp /EmacsLisp/Emacs Lisp/
elite /エリート/
elixir /エリクシール/エリキシル/
eliza /エリザ/イライザ/
elizabeth /エリザベス/
elk /エルク/Elk/
ella /エラ/
ellas /エラス/
elle /エル/
ellen /エレン/
ellery /エラリー/
elli /エリ/エリー/
ellie /エリー/
ellington /エリントン/
elliott /エリオット/
ellis /エリス/
ellison /エリソン/エリスン/
ellora /エローラ/
elly /エリー/
elma /エルマ/
elmer /エルマー/
elmo /エルモ/
elnino /エルニーニョ;El Nino/
elocution /エロキューション/
elodie /エロディ/
elohim /エロヒム/
eloise /エロイーズ/
eloy /エロア/エロイ/
elpaso /エルパソ;El Paso/
elric /エルリック/
elroy /エルロイ/
elsa /エルザ/エルサ/
elsalvador /エルサルバドル;El Salvador,sv,.sv/
else /エルス/
elsie /エルシー/エルセ/
elton /エルトン/
eltsyn /エリツィン/
eluard /エリュアール/
elvin /エルヴィン/
elvira /エルビラ/エルヴィラ/
elvis /エルヴィス/エルビス/
elysee /エリゼ/
em /м;cyrillic/エム/
ema /エマ/
emacs /Ｅｍａｃｓ/ｅｍａｃｓ/Emacs/イーマックス/Editing MACroS/
emacslisp /EmacsLisp/Emacs Lisp/
email /E-mail/Eメール/電子メール/電子メイル/
emailaddress /Eメールアドレス/E-mailアドレス/
emanuel /エマニュエル/エマニエル/エマヌエル/
emanuele /エマヌエーレ/
embassy /エンバシー/
embed /エンベッド/
embedded /エンベデッド/
emblem /エンブレム/
emboss /エンボス/
embouchure /アンブシュア/
embryo /エンブリオ/
emerald /エメラルド/
emergency /エマージェンシー/
emerging /エマージング/
emerson /エマーソン/エマソン/
emery /エメリ/エメリー/
emil /エミール/エミル/エーミール/
emile /エミール/
emilia /エミリア/エミーリア/
emiliano /エミリアーノ/
emilie /エミリー/
emilio /エミリオ/
emily /エミリ/エミリー/
emission /エミッション/
emitter /エミッタ/エミッター/
emma /エマ/エンマ/
emmanuel /エマヌエル/エマニュエル/
emmanuelle /エマニュエル/エマヌエル/
emmenthal /エメンタール/
emmerich /エメリッヒ/
emmet /エメット/
emmy /エミー/
emotion /エモーション/
emotional /エモーショナル/
emperor /エンペラー/
emphasis /エンファシス/強調/
empire /エンパイア/
emporium /エンポリアム/エンポリウム/
empower /エンパワー/
empowerment /エンパワーメント/
empty /エンプティ/エンプティー/
emu /エミュー;[鳥]/エミュ;emulator/
emulate /エミュレート/イミュレート/
emulation /エミュレーション/
emulator /エミュレータ/エミュレーター/イミュレータ;<rare>/イミュレイタ;<rare>/
emulsion /エマルジョン/
emurate /エミュレート;※emulate/
emurater /エミュレータ;※emulator/
en /エン/アン;仏語/エヌ/
enable /イネーブル/
enableware /イネーブルウェア/
enamel /エナメル/
enbug /エンバグ/
encapsulate /カプセル化/
encapsulation /エンカプセレーション/エンカプシュレーション/
encapsulator /エンカプスレータ/
enchainement /アンシェヌマン/
enchant /エンチャント/
enchante /アンシャンテ/
enclosure /エンクロージャー/エンクロージャ/
encode /エンコード/符号化/
encoder /エンコーダ/エンコーダー/
encoding /エンコーディング/
encore /アンコール/
encount /エンカウント/
encounter /エンカウンター/
encyclopedia /エンサイクロペディア/百科事典/
end /エンド/
ende /エンデ/
endeavour /エンデバー/
ender /エンダー/
endevor /エンデバー/
endian /エンディアン/
ending /エンディング/
endingroll /エンディングロール/
endingtheme /エンディングテーマ/
endive /エンダイブ/
endless /エンドレス/
endline /エンドライン/
endmark /エンドマーク/
endorphin /エンドルフィン/
endpoint /エンドポイント/
endtoend /エンドツーエンド/
enduser /エンドユーザー/エンドユーザ/
endymion /エンディミオン/
ene /エネ;energy/
enema /エネマ/
energisch /エネルギッシュ;(独語)/
energish /エネルギッシュ;※energisch?/
energy /エネルギー/エナジー/
enfant /アンファン/
engage /エンゲージ/アンガージュ;仏語/
engagement /アンガージュマン;仏語/エンゲージメント/
engagering /エンゲージリング/
engel /エンゲル/
engelbert /エンゲルベルト/エンゲルバート/
engelhardt /エンゲルハート/
engels /エンゲルス/エゲレス;(蘭語)/
engine /エンジン/
enginebrake /エンジンブレーキ/
engineer /エンジニア/
engineering /エンジニアリング/
enginekey /エンジンキー/
enginetrouble /エンジントラブル/
england /イングランド/イギリス/
englar /エングラー/
english /イングリッシュ/イギリス/英吉利/
englishhorn /イングリッシュホルン/
enhance /エンハンス/
enhanced /エンハンスド/エンハンスト/
enid /アニド/
enigma /エニグマ;謎/
enix /エニックス/
enja /エンヤ/
enjoy /エンジョイ/
enki /エンキ/
enkidu /エンキドゥ/
enlil /エンリル/
ennio /エンニオ/
ennis /エニス/
ennui /アンニュイ/
enoch /エノク/イノック/イーノック/
enola /エノラ/
enolagay /エノラゲイ;Enola Gay/エノラ・ゲイ/
enos /エノス/
enquete /アンケート/
enqueue /エンキュー/
enrich /エンリッチ/
enrico /エンリコ/
enrique /エンリケ/
ensemble /アンサンブル/
entailment /→/
entasis /エンタシス/
enter /エンター/
enterbrain /エンターブレイン;www.enterbrain.co.jp/
enterkey /エンターキー/ENTERキー/
enterprise /エンタープライズ/
entertainer /エンターテイナー/エンターティナー/
entertainment /エンターテイメント/エンターテインメント/エンタテインメント/エンタテイメント/エンターティメント/
enthalpy /エンタルピー/
entire /エンタイア/
entitle /エンタイトル/
entity /エンティティ/
entoutcas /アンツーカー;(Fr)en tout cas/
entrance /エントランス/
entrancehall /エントランスホール/
entrapment /エントラップメント/
entree /アントレ/
entremet /アントルメ/
entremets /アントルメ/
entrepreneur /アントレプレナー/
entropy /エントロピー/
entry /エントリー/エントリ/
entrymodel /エントリーモデル/
entrysheet /エントリーシート/
envelope /エンベロープ/
envy /エンヴィ/エンヴィー/
enzo /エンツォ/
eof /EOF/
eos /エオス/イーオス/
epee /エペ/
ephedrine /エフェドリン/
ephesos /エフェソス/エペソ/
ephesus /エペソ/エフェソス/
epi /エピ/
epic /エピック/
epicurean /エピキュリアン/
epigonen /エピゴーネン/
epigraph /エピグラフ/
epikuros /エピクロス/エピキュロス/
epilogue /エピローグ/
epiphanie /エピファニー;仏語/
epiphany /エピファニー/
epipolar /エピポーラ/
episode /エピソード/
episteme /エピステーメー/
epitaxy /エピタキシー/エピタキシ/
epitope /エピトープ/
eplus /イープラス;eee.eplus.co.jp/
epoch /エポック/
epochmaking /エポックメイキング/エポックメーキング/
epock /エポック;※epoch?/
epoque /エポック;仏語/
epoxy /エポキシ/
eprecord /EPレコード/
epsilon /ε/イプシロン/∋;include/∈/
epson /エプソン;www.epson.co.jp/
eq /＝/≡/
equal /イコール/＝/
equalise /イコライズ/
equaliser /イコライザー/イコライザ/
equality /イクアリティ/
equalize /イコライズ/
equalizer /イコライザー/イコライザ/
equity /エクイティ/エクイティー/
equiv /⇔/≡/
equivalent /⇔/≡/
er /р;cyrillic/エルビウム/Erbium/
era /エラ/イラ/イアラ/
erase /イレース/
eraser /イレイザー/イレーザー/イレーサー/イレイサー/
erasmus /エラスムス/
eratosthenes /エラトステネス/
erbium /エルビウム;[元素]68,Er/
erda /エルダ/
erebos /エレボス/
erebus /エレボス/
erect /エレクト/
erection /エレクション/
erector /エレクター/
eren /エレン/
erg /エルグ;10^-7J/
ergo /エルゴ/
ergode /エルゴード/
ergonomics /エルゴノミクス;人間工学/
ergosterol /エルゴステロール/
eria /エリア/
eric /エリック/
erica /エリカ/
erich /エーリッヒ/エーリヒ/
erick /エリック/
erie /エリー/
erik /エリック/エリク/エーリク/
erika /エリカ/
erikson /エリクソン/
eritrea /エリトリア;.er/
erlung /アーラン/
erma /エルマ/アーマ/
ermine /アーミン/
ermitazh /エルミタージュ/
ernest /アーネスト/エルネスト/
ernesto /エルネスト/
ernie /アーニー/
ernst /エルンスト/
ero /エロ/
eroanime /エロアニメ;erotic animation,和製英語(hentai)/
eroero /エロエロ/
erogro /エログロ;erotic and grotesque/
eroica /エロイカ/
eros /エロス/
erosite /エロサイト/
erotic /エロティック/エロチック/
erotica /エロチカ/
eroticism /エロティシズム/エロチシズム/
erotomania /エロトマニア/
erovideo /エロビデオ;和製英語(porn video)/
err /エラー/
errata /エラッタ/エラータ/
errol /エロール/
erroll /エロール/
error /エラー/エラーメッセージ/
errorcheck /エラーチェック/
errorcode /エラーコード/
errordialog /エラー・ダイアログ/
errorlog /エラーログ/
errormessage /エラーメッセージ/
errorsignal /エラーシグナル/
erwin /エルヴィン/アーウィン/
erythritol /エリスリトール/
erythromycin /エリスロマイシン/
es /エス/с;cyrillic/アインスタイニウム/Einsteinium/
esa /エサ/
esc /エスケープ/
escalate /エスカレート/
escalation /エスカレーション/
escalator /エスカレーター/エスカレータ/
escape /エスケープ/
escapekey /エスケープキー/
escapesequence /エスケープシーケンス/
escargot /エスカルゴ/
escher /エッシャー/
esckey /ESCキー/エスケープキー/
escort /エスコート/
escrow /エスクロー/
esfahan /イスファハン/エスファハン/
esher /エッシャー/
eskimo /エスキモー/
esmeralda /エスメラルダ/
esoteric /エソテリック/
esp /ESP/
espace /エスパス;(Fr)空間/エスパース/
espagnole /エスパニョール/
espana /エスパーニャ/
espanol /エスパニョール/
espanola /エスパニョーラ/
esper /エスパー/
esperance /エスペランス/
esperanto /エスペラント/
esperanza /エスペランサ/
espoir /エスポワール/
espressione /エスプレッシオーネ/
espressivo /エスプレッシーヴォ/
espresso /エスプレッソ;スペイン語/
espressocoffee /エスプレッソコーヒー/
espressomachine /エスプレッソマシン/エスプレッソマシーン/
esprit /エスプリ/
esquimau /エスキモー/
esquisse /エスキス;仏語/
essai /エセー;仏語/エッセイ/エッセー/
essay /エッセイ/エッセー/エッセィ/
essayist /エッセイスト/
esse /エッセ/
essen /エッセン/
essence /エッセンス/
essential /エッセンシャル/
essentialoil /エッセンシャルオイル;精油/
essex /エセックス/
establish /エスタブリッシュ/
establishment /エスタブリッシュメント/設立/
estate /エステート/
esteban /エステバン/
estella /エステラ/
estelle /エステル/
ester /エステル/エスター/
esterase /エステラーゼ/
esthe /エステ/
esther /エステル/エスター/
esthesalon /エステサロン;esthetic salon/
esthetic /エステティック/
estheticien /エステティシャン;仏語/
estheticsalon /エステティックサロン;esthetic salon/
esthetique /エステティック/
estima /エスティマ;[商標]トヨタ/
estonia /エストニア;.ee/
estradiol /エストラジオール/
estragon /エストラゴン/
estrogen /エストロゲン/
estron /エストロン/
eta /η/エータ/
etat /エタ;仏語/
etcetera /エトセトラ/
etch /エッチ/
etching /エッチング/
eternal /エターナル/
eternity /エタニティ/エタニティー/
ethan /エタン;C2H6/イーサン;人名/
ethane /エタン;C2H6/
ethanol /エタノール/
ethel /エセル/
ether /エーテル/イーサ/
etherboard /イーサボード/イーサーボード/
ethernet /イーサネット/
ethica /エチカ/
ethics /エシックス/
ethiopia /エチオピア;.et/エティオピア/
ethnic /エスニック/
ethnicity /エスニシティ/
ethno /エスノ/
ethos /エートス/エトス/
ethyl /エチル;-C2H5/
ethylalcohol /エチルアルコール/
ethylene /エチレン;C2H4/
ethylenediamine /エチレンジアミン/
ethylenegas /エチレンガス/
ethyleneglycol /エチレングリコール;C2H6O2/
eti /エティ/
etienne /エティエンヌ/
etiquette /エチケット/
etna /エトナ/
etoile /エトワール/
eton /イートン/
etrange /エトランゼ/エトランジェ/
etruria /エトルリア/
etta /エッタ/
ettore /エットレ/
etude /エチュード/
etype /Eタイプ/Ｅタイプ/
eu /ユウロピウム/Europium/
eucalyptus /ユーカリ/
euccode /EUCコード/
euclid /ユークリッド/
eudora /ユードラ/
eugen /オイゲン/
eugene /ユージン/ユージーン/ウジェーヌ;仏語/
eukleides /エウクレイデス/ユークリッド;euclid/
euler /オイラー/
eunice /ユーニス/
eunos /ユーノス/
euphonium /ユーフォニアム/
euphoria /ユーフォリア/
euphrates /ユーフラテス/
eurasia /ユーラシア/
eure /ウール/
eureka /ユリイカ/エウレカ/ユーレカ/
euripides /エウリピデス/
euro /ユーロ/
eurobeat /ユーロビート/
europa /エウロパ/ヨーロッパ/欧羅巴/欧州/歐州/歐羅巴/
europagp /ヨーロッパGP;[F1]/
europe /ヨーロッパ/エウロペ/欧州/欧羅巴/歐州/歐羅巴/
european /ヨーロピアン/
europium /ユーロピウム;[元素]63,Eu/
eurostar /ユーロスター/
eurus /ユーラス;東風/エウロス/
eurydike /エウリュディケ/
eva /エヴァ/エバ/
evaluate /エバリュエート/評価する/
evaluator /エバリュエータ/
evamilk /エバミルク;evaporated milk/
evangeline /エヴァンジェリン/
evangelion /エヴァンゲリオン;[アニメ]/
evangelist /エバンジェリスト/
evans /エヴァンス/エバンス/
evaporator /エバポレータ/エバポレーター/
eve /イブ/イヴ/エヴァ/
evelyn /エブリン/イヴリン/エヴリン/イブリン/イーヴリン/
even /イーブン/
evening /イブニング/
eveningdress /イブニングドレス/
evenpar /イーブンパー/
event /イベント/イヴェント/
eventdriven /イベントドリブン/
eventer /イベンター/
eventhandler /イベントハンドラ/
eventschedule /イベントスケジュール/
eventspace /イベントスペース/
ever /エバー/エヴァー/
everest /エベレスト/エヴェレスト/
evergreen /エバーグリーン/
everton /エヴァートン/
every /エブリ/エヴリ/
everybody /エブリバディ/
everyday /エブリデイ/エブリディ/エブリデー/
everyone /エブリワン/
evgeni /エフゲニー/
evgenii /エフゲニー/
evian /エビアン/エヴィアン/
evidence /エビデンス/
evil /エビル/
evolution /エボリューション/エヴォリューション/発展/
ew /─;罫線/━;太い罫線/
ewan /ユアン/
ewn /┴/┻;太/┷;横太/┸;縦太/
ews /┬/┳;太/┯;横太/┰;縦太/エンジニアリング・ワークステーション/ワークステーション/
ex /エクス/エキス/イクス/∃/エックス/
exa /エクサ;[SI接頭語]E,10^18/
excalibur /エクスカリバー/
exceed /エクシード/
excel /エクセル/
excelan /エクセラン;[企業名]/
excellence /エクセレンス/
excellent /エクセレント/
excentric /エキセントリック/
except /エクセプト/
exception /エクセプション/例外/
excess /エクセス/
exchange /エクスチェンジ/
excite /エキサイト/
exciting /エキサイティング/
exclamation /エクスクラメーション/感嘆符/！/
exclamationmark /エクスクラメーションマーク;！/
exclusive /エクスクルーシブ/
excursion /エクスカーション/
excuse /エクスキューズ/
exe /エグゼ/
exec /実行/
exective /エグゼクティブ;※executive/
execute /エグゼキュート/
executive /エグゼクティブ/エクゼクティブ/
exercise /エクササイズ/Ｅｘｅｒｃｉｓｅ/
exergy /エクセルギー/
exhibition /エキシビション/エキシビジョン;※「エキシビション」の方が忠実/エキジビション/エグジビション/
exist /イグジスト/∃/
exists /∃/
exit /イグジット/
exodus /エクソダス/
exon /エクソン/エキソン/
exorcist /エクソシスト/
exotic /エキゾチック/エキゾティック/
exp /エクスポネンシャル/
expand /エキスパンド/エクスパンド/イクスパンド/拡張/
expander /エキスパンダー/エクスパンダー/エキスパンダ/エクスパンダ/
expansion /エキスパンション/エクスパンション/
experience /エクスペリエンス/
experiment /エクスペリメント/
experimental /エクスペリメンタル/
expert /エキスパート/
expertsystem /エキスパートシステム/エキスパート・システム/
expiration /エクスパイレーション/
expire /エクスパイア/
explorer /エクスプローラ/エクスプローラー/
explosion /エクスプロージョン/
expo /エキスポ/エクスポ/
exponential /エクスポネンシャル/
export /エクスポート/エキスポート/
expose /エクスポーズ/
exposure /エクスポージャー/
express /エクスプレス/エキスプレス/
expression /エクスプレッション/イクスプレッション/式/
extend /エクステンド/
extended /エクステンデッド/
extender /エクステンダー/エクステンダ/
extension /エクステンション/
extent /エクステント/
extention /エクステンション/
exterior /エクステリア/
external /エクスターナル/
extra /エクストラ/エキストラ/
extract /エキス/
extravirgin /エクストラバージン/エクストラヴァージン/
extreme /エクストリーム/
exxon /エクソン/
eyck /アイク/
eye /アイ/
eyebank /アイバンク/
eyebrow /アイブロウ/アイブロー/
eyecatch /アイキャッチ;和製英語/
eyecolor /アイカラー/
eyecolour /アイカラー/
eyecontact /アイコンタクト/
eyeguard /アイガード/
eyeline /アイライン/
eyeliner /アイライナー/
eyemake /アイメイク;eye makeup/
eyemask /アイマスク/
eyes /アイズ/
eyeshadow /アイシャドウ/アイシャドー/
eyre /エア/
ezekiel /エゼキエル/
ezra /エズラ/
f /φ;phi/エフ/ф;ef (cyrillic)/フッ素/Flourine/フォルテ;強く/forte/周波数/
f#driver /F#0ドライバー/Ｆ#1ドライバー/
f#key /F#0キー/
f#race /F#0レース/Ｆ#1レース/
f#racer /F#0レーサー/Ｆ#1レーサー/
f1 /Ｆ１/１／ｆゆらぎ/
fa /ファ/
fabian /フェビアン/ファビアン/
fabien /ファビアン/
fabio /ファビオ/
fable /ファーブル;仏語/フェイブル/
fabless /ファブレス/
fabre /ファーブル/
fabric /ファブリック/
fabrice /ファブリス/
fabrizio /ファブリツィオ/
facade /ファサード/
face /フェイス/フェース/
facecare /フェイスケア/
faceline /フェイスライン/
facemark /フェイスマーク;:-)/
facet /ファセット/
facetowel /フェイスタオル/
facial /フェイシャル/
facilitator /ファシリテーター/ファシリテータ/
facility /ファシリティ/ファシリティー/
facom /ファコム/
facsimile /ファクシミリ/
fact /ファクト/
factbook /ファクトブック/
factor /ファクター/ファクタ/
factoring /ファクタリング/
factory /ファクトリー/ファクトリ/
fad /ファド/ファッド/
fade /フェード/フェイド/
fadein /フェードイン/
fadeout /フェードアウト/
fader /フェーダー/フェーダ/フェイダー/
fagotto /ファゴット/
fahd /ファハド/
fail /フェイル/失敗/フェール/
failover /フェイルオーバー/
failsafe /フェイルセーフ/フェールセーフ/
failure /フェイリュア/
faint /フェイント/
fair /フェア/フェアー/
fairbanks /フェアバンクス/
fairlady /フェアレディ/
fairway /フェアウェイ/
fairy /フェアリー/
fairyland /フェアリーランド/
fairytale /フェアリーテール/
faith /フェイス/
fake /フェイク/
fakefur /フェイクファー/
falcom /ファルコム;www.falcom.co.jp/
falcon /ファルコン/
falkland /フォークランド;.fk/
fall /フォール/
falla /ファリャ/
fallback /フォールバック/
falluja /ファルージャ;イラク/
false /フォルス/フォールス/誤/偽/
falsetto /ファルセット/
fame /フェイム/フェーム/Ｆａｍｅ/
fami /ファミ;family/
famicom /ファミコン/
famicon /ファミコン/
familia /ファミリア/
familiar /ファミリア/
family /ファミリー/ファミリ/
familyclub /ファミリークラブ/
familycomputer /ファミリーコンピュータ/ファミコン/
familymart /ファミリーマート;www.family.co.jp/
familyname /ファミリーネーム/
familyplan /ファミリープラン/
familyrestaurant /ファミリーレストラン/
famires /ファミレス;family restaurant/
famous /フェイマス/
fan /ファン/
fanatic /ファナティック/
fanclub /ファンクラブ/
fancy /ファンシー/
fancygoods /ファンシーグッズ/
fancyshop /ファンシーショップ/
fandango /ファンダンゴ/
fanfare /ファンファーレ/
fang /ファング/
fanheater /ファンヒーター/
fanin /ファンイン/
fanless /ファンレス/
fanletter /ファンレター/
fannie /ファニー/
fanny /ファニー/
fanout /ファンアウト/
fanservice /ファンサービス/
fansite /ファンサイト/
fanta /ファンタ/
fantasia /ファンタジア/
fantasic /ファンタジック/
fantasista /ファンタジスタ/
fantastic /ファンタスティック/
fantasy /ファンタジー/
fantasynovel /ファンタジーノベル/
farad /ファラッド/ファラド/
faraday /ファラデー/
farandole /ファランドール/
farce /ファルス/
fareast /ファーイースト;極東/
farewell /フェアウェル/
farfalle /ファルファッレ/
farina /ファリーナ/
farm /ファーム/
farmer /ファーマー/
farming /ファーミング/
farside /ファーサイド/
farther /ファーザー/
fascio /ファッショ;(イタリア語)/
fascism /ファシズム/
fascist /ファシスト/
fashion /ファッション/
fashionable /ファッショナブル/
fashionbrand /ファッションブランド/
fashiondesign /ファッションデザイン/
fashiondesigner /ファッションデザイナー/
fashioned /ファッションド/
fashionhealth /ファッションヘルス/
fashionhotel /ファッションホテル/
fashionleader /ファッションリーダー/
fashionmodel /ファッションモデル/
fashionsense /ファッションセンス/
fashionshop /ファッションショップ/
fashionshow /ファッションショー/
fast /ファースト/ファスト/
fastener /ファスナー/
fastfood /ファーストフード/ファストフード/
fat /ファット/
fatah /ファタハ/
fatal /フェイタル/ファタール;仏語/ファタル;仏語/
fate /フェイト/
father /ファーザー/ファザー/
fathercon /ファザコン;father complex/
fatherland /ファザーランド/
fathers /ファーザーズ/
fatima /ファティマ/ファーティマ/
fats /ファッツ/
fauchon /フォション;www.fauchon.fr/
faulkner /フォークナー/
fault /フォルト/フォールト/
faulttolerance /フォールトトレランス/
faulttolerancy /フォルトトレランシ/
faun /フォーン/
fauna /ファウナ/
faure /フォーレ/
faust /ファウスト/
fausto /ファウスト/
fauvism /フォービズム/フォーヴィズム/
fauvisme /フォーヴィスム/フォービスム/
favor /フェイバー/
favorite /フェイバリット/フェイヴァリット/
favour /フェイバー/
fax /ファックス/ファクス/ファクシミリ;facsimile/Ｆａｘ/FAX/
faxmodem /FAXモデム/ファックスモデム/
faxservice /FAXサービス/
fay /フェイ/
faye /フェイ/フェー/
fazzy /ファジィ;※fuzzy/
fb /フレームバッファ/
fcup /Fカップ;22.5cm/Ｆカップ/
fd /フロッピーディスク/FD/
fe /鉄/Iron/
fear /フィアー/フィア/
feasibility /フィージビリティ/
feather /フェザー/
feature /フィーチャー/フィーチャ/
featuring /フィーチャリング/
february /フェブラリー/
federal /フェデラル/
federico /フェデリコ/
fedora /フェドーラ;中折れ帽/フェドラ/
fee /フィー/
feed /フィード/
feedback /フィードバック/
feeder /フィーダー/フィーダ/
feedforward /フィードフォワード/
feel /フィール/
feeling /フィーリング/
feet /フィート/
feferman /フェファーマン/
fei /フェイ/
feint /フェイント/
feldman /フェルドマン/
felice /フェリーチェ/フェリス/
felicia /フェリシア/
feliciano /フェリシアーノ/
felipe /フェリペ/
felix /フェリス/フェリックス/フェリクス/
fella /フェラ/
fellatio /フェラチオ/
feller /フェラー/
fellini /フェリーニ/
fellow /フェロー/
fellowship /フェローシップ/
felt /フェルト/
feltpen /フェルトペン/
female /フィメール/♀/
femi /フェミ;feminism,feminist/
femina /フェミナ/
feminine /フェミニン/
feminism /フェミニズム/
feminist /フェミニスト/
femme /ファム/
femto /フェムト;[SI接頭語]f,10^-15/
fence /フェンス/
fencer /フェンサー/
fencing /フェンシング/
fender /フェンダー/
fenderrhodes /フェンダーローズ/
fendi /フェンディ;www.fendi.it/
fenelon /フェヌロン/
fennel /フェンネル;茴香/
fenollosa /フェノロサ/
fenrir /フェンリル/
fentanyl /フェンタニル/
fep /フロントエンドプロセッサ/
ferdinand /フェルディナンド/フェルディナント/フェルディナン/
ferdinando /フェルディナンド/
fergana /フェルガナ/
fergus /ファーガス/
ferguson /ファーガソン/
fermat /フェルマー/フェルマ/
fermata /フェルマータ/
fermi /フェルミ/
fermion /フェルミオン/フェルミ粒子/
fermium /フェルミウム;[元素]100,Fm/
fern /ファーン/
fernand /フェルナンド/フェルナン/
fernandes /フェルナンデス/
fernandez /フェルナンデス/
fernando /フェルナンド/
feroce /フェローチェ/
ferragamo /フェラガモ;www.salvatoreferragamo.it/
ferrara /フェラーラ;イタリア/
ferrari /フェラーリ/
ferre /フェレ/
ferreira /フェレイラ/
ferrer /フェレール/
ferret /フェレット/
ferretti /フェレッティ/
ferri /フェリ;(接頭辞) 鉄/
ferrite /フェライト/
ferry /フェリー/
fes /フェス/
fest /フェスト/
festa /フェスタ;(イタリア語)/
festiva /フェスティヴァ/
festival /フェスティバル/フェスティヴァル/
fetch /フェッチ/
feti /フェチ;fetishist/
fetish /フェティッシュ/
fetishism /フェティシズム/
fettuccine /フェットチーネ/
fettucine /フェットチーネ;=fettuccine/
feuerbach /フォイエルバッハ/
fever /フィーバー/
feynman /ファインマン/
fez /ファス/フェズ/
ff /font-family/フォルテッシモ;fより強く/fortessimo/
fff /フォルテッシシモ;ffより強く/fortessissimo/
fg /フォアグラウンド/
fiance /フィアンセ/
fiancee /フィアンセ/
fiat /フィアット/
fiber /ファイバー/ファイバ/
fiberscope /ファイバースコープ/
fibonacci /フィボナッチ/
fichte /フィヒテ/
fick /フィック/
fiction /フィクション/
fiddle /フィドル/
fiddler /フィドラー/
fidel /フィデル/
fidele /フィデル/
fidelio /フィデリオ/
fidelity /フィデリティ/
field /フィールド/
fielder /フィールダー/
fielderschoice /フィルダースチョイス;fielder's choice. 野選/
fieldgoal /フィールドゴール/
fielding /フィールディング/
fieldmap /フィールドマップ/
fieldnote /フィールドノート;field-note/
fields /フィールズ/
fieldwork /フィールドワーク;field-work/
fiesta /フィエスタ;(西語)/
fifteen /フィフティーン/
fifth /フィフス/
fifty /フィフティ/
figaro /フィガロ/
figeac /フィジャック/
fight /ファイト/
fighter /ファイター/
fighters /ファイターズ/
fighting /ファイティング/
fightingpose /ファイティングポーズ/
fightmoney /ファイトマネー/
figure /フィギュア/フィギュアー/
figureskate /フィギュアスケート/
fiji /フィジー;.fj/フィージー/
filament /フィラメント/
filaria /フィラリア/
file /ファイル/
fileformat /ファイルフォーマット/
filehandle /ファイルハンドル/
filemanager /ファイルマネージャ/ファイルマネージャー/
filemenu /ファイルメニュー/ファイル・メニュー/
filename /ファイルネーム/ファイル名/
filepointer /ファイルポインタ/
filer /ファイラー/ファイラ/
fileserver /ファイルサーバ/ファイルサーバー/
fileset /ファイルセット/
filesize /ファイルサイズ/
filesystem /ファイルシステム/
filet /ヒレ/フィレ/
filetype /ファイルタイプ/
filia /フィリア/
filing /ファイリング/
filip /フィリップ/
filippo /フィリッポ/
fill /フィル/
fille /フィーユ/
fillet /ヒレ/フィレット/
fillin /フィルイン/
filling /フィリング/
fillmore /フィルモア/
film /フィルム/フイルム/
filmcase /フィルムケース/
films /フィルムズ/
filmscanner /フィルムスキャナ/フィルムスキャナー/
filter /フィルター/フィルタ/
filterbank /フィルタバンク/
filtered /フィルタード/
filtering /フィルタリング/
fin /フィン/
fina /フィーナ/フィナ/
final /ファイナル/
finale /フィナーレ/
finalfantasy /ファイナルファンタジー;[ゲーム]Square/
finalise /ファイナライズ/
finalist /ファイナリスト/
finalize /ファイナライズ/
finallap /ファイナルラップ/
finance /ファイナンス/
financhier /フィナンシェ/
financial /ファイナンシャル/
financialplanner /ファイナンシャルプランナー;FP/
finch /フィンチ/
find /ファインド/
finder /ファインダー/ファインダ/
finding /ファインディング/
fine /ファイン/フィーネ/
fineart /ファインアート/
fineceramics /ファインセラミックス/
finechemical /ファインケミカル/
fineplay /ファインプレー/
finesse /フィネス/
finest /ファイネスト/
finetuning /ファインチューニング/
finger /フィンガー/
fingering /フィンガリング/
fingerprint /フィンガープリント/
finish /フィニッシュ/
finishing /フィニッシング/
fink /フィンク/
finland /フィンランド;.fi/
finlay /フィンレイ/
finn /フィン/
finnegan /フィネガン/
fiona /フィオナ/
fiore /フィオーレ/
fiorentina /フィオレンティーナ/
fiorentino /フィオレンティーノ/
fire /ファイア/ファイヤー/ファイアー/ファイヤ/
fireball /ファイアボール/ファイヤーボール/ファイアーボール/
firefox /ファイヤーフォックス/
fireman /ファイヤーマン/ファイアーマン/ファイアマン/
firenze /フィレンツェ/
firewall /ファイアウォール/ファイアーウォール/ファイヤーウォール/ファイヤウォール/
firm /ファーム/
firmware /ファームウェア/
first /ファースト/１ｓｔ/第1要素/
firstaid /ファーストエイド;first-aid/
firstalbum /ファーストアルバム/
firstbase /ファーストベース/
firstclass /ファーストクラス/ファースト・クラス/
firstcontact /ファーストコンタクト/
firstfly /ファーストフライ/
firstgoro /ファーストゴロ;和製語(grounder)/
firstimpression /ファーストインプレッション/
firstkiss /ファーストキス;first kiss/
firstlady /ファーストレディ/
firstmit /ファーストミット/
firstname /ファーストネーム/
fischer /フィッシャー/
fish /フィッシュ/
fisher /フィッシャー/
fisherman /フィッシャーマン;漁師/
fishing /フィッシング/
fisichella /フィジケラ/
fissler /フィスラー/
fist /フィスト/
fistfuck /フィストファック/
fit /フィット/
fitness /フィットネス/
fitnessclub /フィットネスクラブ/
fitter /フィッター/
fitting /フィッティング/
fitzgerald /フィッツジェラルド/
five /ファイブ/ファイヴ/
fix /フィックス/フィクス/修正/
fixed /フィクスト/
fixer /フィクサー/
fizz /フィズ/
fjord /フィヨルド/
fl /Florida/フロリダ/
flag /フラッグ/フラグ/
flagship /フラッグシップ/フラグシップ/
flail /フレイル/
flake /フレーク/
flam /フラム/
flamand /フラマン/
flambe /フランベ/
flamber /フランベ/
flame /フレーム/フレイム/
flamenco /フラメンコ/
flamingo /フラミンゴ/
flamm /フラム/
flamme /フラム;(Fr) 炎/
flan /フラン/
flanagan /フラナガン/
flanders /フランダース/
flandre /フランドル/
flange /フランジ/
flannel /フランネル/
flap /フラップ/
flapping /フラッピング/
flare /フレア/フレアー/
flareskirt /フレアスカート;flared skirt/フレアースカート/
flash /フラッシュ/
flashback /フラッシュバック/
flashmemory /フラッシュメモリ/フラッシュメモリー/
flask /フラスコ/
flat /フラット/♭/
flatbed /フラットベッド/
flatcable /フラットケーブル/
flatpanel /フラットパネル/
flatter /フラッタ/
flattop /フラットトップ/
flaubert /フローベール/フロベール/
flauto /フラウト/
flavan /フラバン/
flavanone /フラバノン/
flavin /フラビン/
flavone /フラボン/
flavonoid /フラボノイド/
flavonol /フラボノール/
flavor /フレーバー/フレイバー/フレイヴァー/Ｆｌａｖｏｒ/Flavor/
flavortea /フレーバーティー/
flax /フラックス/
fleamarket /フリーマーケット;蚤の市/
fleece /フリース/
fleet /フリート/
fleming /フレミング/
flesh /フレッシュ;肉/
fletcher /フレッチャー/
flets /フレッツ;flets.com/
fleur /フルール/
fleuret /フルーレ/
flex /フレックス/
flexible /フレキシブル/柔軟な/
flextime /フレックスタイム/
flick /フリック/
flicker /フリッカー/フリッカ/
flier /フライヤー/
flight /フライト/
flightattendant /フライトアテンダント/
flightsimulator /フライトシミュレータ/
flint /フリント/
flintstone /フリントストーン/
flip /フリップ/
flipflop /フリップフロップ/
flipper /フリッパー/
flippers /フリッパーズ/
flo /フロ/
float /フロート/浮動小数点数/
floating /フローティング/浮動小数点数/
flock /フロック;群れ/
flon /フロン/
flongas /フロンガス/
floor /フロア/フロアー/
flooring /フローリング/
floorlight /フロアライト/
floorplan /フロアプラン/
floorshift /フロアシフト/
floortam /フロアタム/
flop /フロップ/
floppy /フロッピー/フロッピィ/フロッピ/
floppydisk /フロッピーディスク/フロッピィディスク/
floppydiskdrive /フロッピーディスクドライブ;FDD/
flora /フローラ/
floral /フローラル/
flore /フロール/フローレ/
floreal /フロレアール/
florence /フローレンス/フロレンス/フロランス/フローランス/
florent /フローラン/
florentin /フロランタン;(Fr) フィレンツェの./
florentine /フロランティーヌ;(Fr) フィレンツェの./
flores /フローレス/フロレス/
floria /フローリア/
florian /フロリアン/フローリアン/
florida /フロリダ/
florist /フローリスト/
floss /フロス/
flour /フラワー;小麦粉/
flow /フロー/フロウ/
flowchart /フローチャート/フロウチャート;<rare>/
flower /フラワー/
flowerarrangement /フラワーアレンジメント/
flowerbox /フラワーボックス/
flowergift /フラワーギフト/
flowers /フラワーズ/
flowershop /フラワーショップ/
flowgraph /フローグラフ/
floyd /フロイド/
flugelhorn /フリューゲルホルン/フリューゲルホーン/
fluid /フルイド/
fluke /フロック;まぐれ/
fluorine /フローリン;F/
fluorite /フローライト;蛍石/フルオライト/
fluoro /フルオロ/フッ化/弗化/
fluorocarbon /フルオロカーボン/
flush /フラッシュ/
flute /フルート/
flutist /フルーティスト/
flutter /フラッター/フラッタ/
flux /フラックス/
fluxus /フルクサス/
fly /フライ/ハエ/
flyfishing /フライフィッシング;fly-fishing/
flying /フライング/
flying-pan /フライパン;※frying-pan?/
fm /フェルミウム/Fermium/エフエム;frequency modulation/
fmarinos /F・マリノス;[Jリーグ]横浜/
fmradio /FMラジオ/
foam /フォーム;泡/
foaming /フォーミング/
focaccia /フォカッチャ/
focus /フォーカス/
focusmode /フォーカスモード/
fodor /フォドー/
foehn /フェーン/
fog /フォグ/
foghorn /フォグホーン/
foglamp /フォグランプ/
foiegras /フォアグラ;foie gras/
foil /ホイル/フォイル/
fold /フォールド/
folder /フォルダ/フォルダー/
folding /フォールディング/
foley /フォーリー/フォリー/
folie /フォリー/
folio /フォリオ/
folk /フォーク/フォルク/
folkdance /フォークダンス/
folkduo /フォークデュオ/
folkguitar /フォークギター/
folklore /フォルクローレ;(西語)/フォークロア/
folksong /フォークソング/
follifollie /フォリフォリ;www.follifollie.com/
follow /フォロー/フォロウ/
follower /フォロワー/
followthrough /フォロースルー/
followup /フォローアップ/
folly /フォリー/
foma /フォーマ;[商標]NTT DoCoMo/
fond /フォンド/フォン;仏語/
fondant /フォンダン/
fonddeveau /フォンドボー;fond de veau/
fondu /フォンデュ/
fondue /フォンデュ/
fons /フォンス/
font /フォント/
fontaine /フォンテーヌ;(Fr)泉/
fontainebleau /フォンテーヌブロー/フォンテンブロー/
fontana /フォンタナ/
fontlist /フォントリスト/
fontpath /フォントパス/
fontserver /フォントサーバ/フォントサーバー/
fontset /フォントセット/
fontsize /フォントサイズ/
food /フード/
foodprocessor /フードプロセッサー/フードプロセッサ/
foods /フーズ/
fool /フール/
foolproof /フールプルーフ/
fools /フールズ/
foot /フット/
football /フットボール/
footbath /フットバス/
footer /フッタ/フッター/
footlight /フットライト/
footnote /¶/フットノート/
footpedal /フットペダル/
footprint /フットプリント/
footrest /フットレスト/
footware /フットウェア/
footwork /フットワーク/
for /フォア/
forall /∀/
forbes /フォーブス/
force /フォース/
forceout /フォースアウト/
forcus /フォーカス/
ford /フォード/
fore /フォア/
foreground /フォアグラウンド/
forehand /フォアハンド/
foreign /フォーリン/
foreman /フォアマン/フォーマン/
forest /フォレスト/
forestcat /フォレストキャット/
forester /フォレスター/
foret /フォレ;(Fr) 森/
forever /フォーエバー/フォーエヴァー/
fork /フォーク/
forkball /フォークボール/
forklift /フォークリフト/
form /フォーム/
formal /フォーマル/形式的/
formaldehyde /ホルムアルデヒド/
formaldress /フォーマルドレス/
formaline /ホルマリン/
formalism /フォルマリズム/フォーマリズム/
formalize /フォーマライズ/
formalwear /フォーマルウェア/
formamide /ホルムアミド/
forman /フォアマン/
formant /フォルマント/ホルマント/
format /フォーマット/形式/
formation /フォーメーション/
formatstring /フォーマットストリング/
formatter /フォーマッタ/
formatting /フォーマッティング/
forme /フォルム/
formfactor /フォームファクタ/
forming /フォーミング/
formula /フォーミュラ/論理式/
fort /フォート/
forte /フォルテ/
fortepiano /フォルテピアノ/
fortessimo /フォルテッシモ/
fortis /フォルティス/
fortran /フォートラン/
fortress /フォートレス/
fortune /フォーチュン/
fortunecookie /フォーチュンクッキー;What a pity, you cannot read it!/
fortworth /フォートワース/
forum /フォーラム/
forval /フォーバル/
forward /フォワード/
forwarder /フォワーダー/フォワーダ/フォーワーダ/
forwarding /フォワーディング/
forword /フォワード;※forward/
foster /フォスター/
foucault /フーコー/
foul /ファール/ファウル/
foulball /ファールボール/ファウルボール/
foulfly /ファールフライ/
foultip /ファールチップ/ファウルチップ/
found /ファウンド/
foundation /ファンデーション/ファウンデーション/
founder /ファウンダー/
foundry /ファウンドリ/
fountain /ファウンテン/
four /フォー/フォア/
fourball /フォアボール/
fourbeat /フォービート/
fourier /フーリエ/
fournier /フルニエ/
fourre /フーレ/
fourree /フーレ/
fourteen /フォーティーン/
fourth /フォース/
fourty /フォーティ/
fox /フォックス/
foxtrot /フォックストロット/
foxy /フォクシー/
foyer /ホワイエ/
fp /フォルテピアノ;強く、ただちに弱く/forte piano/
fr /フランシウム/Francium/
fractal /フラクタル/
fragile /フラジャイル/
fragment /フラグメント/
fragmentation /フラグメンテーション/
fragrance /フレグランス/フラグランス/
fraiche /フレーシュ;(Fr) <frais/
frais /フレ;(Fr) 新鮮な/
fraise /フライス/
framboise /フランボワーズ;(Fr)木苺/
frame /フレーム/フレイム/
framebuffer /フレームバッファ/
framedrum /フレームドラム/
framein /フレームイン/
frameless /フレームレス/
frameout /フレームアウト/
framerelay /フレームリレー/
framework /フレームワーク/
framing /フレーミング/
fran /フラン/
franc /フラン/フランク/
franca /フランカ/
francais /フランセ/
francaise /フランセーズ/
france /フランス;.fr/仏蘭西/佛蘭西/
francebed /フランスベッド;www.francebed.co.jp/
francegp /フランスGP;[F1]/
francepain /フランスパン;和製仏語(baguette)/
frances /フランシス/フランセス/
francesca /フランチェスカ/
francesco /フランチェスコ/
francewine /フランスワイン;vin francais/
franchise /フランチャイズ/
francine /フランシーヌ/
francis /フランシス/
francisco /フランシスコ/
francium /フランシウム;[元素]87,Fr/
franck /フランク/
franco /フランコ/
francois /フランソワ/
francoise /フランソワーズ/
frank /フランク/
franka /フランカ/
franken /フランケン/
frankenstein /フランケンシュタイン/
frankfurt /フランクフルト/
frankie /フランキー/
frankl /フランクル/
franklin /フランクリン/
franky /フランキー/
frannie /フラニー/
franny /フラニー/
frantz /フランツ/
franz /フランツ/
frappe /フラッペ/
fraser /フレイザー;豪州/フレーザー/
fraternite /フラテルニテ;(Fr)同胞愛/
frau /フラウ;(独語)女性/フロー/
fraulein /フロイライン;(独語)未婚女性/
frazer /フレイザー/フレーザー/
freak /フリーク/
freaks /フリークス/
freaky /フリーキー/
frebel /フレーベル/
fred /フレッド/
freda /フリーダ/
freddi /フレディ/フレディー/
freddie /フレディ/フレディー/
freddy /フレディ/フレディー/
frederic /フレデリック/
frederica /フレデリカ/
frederick /フレデリック/
free /フリー/
free-software /フリーソフトウェア/
freeaccess /フリーアクセス/
freeagent /フリーエージェント;FA/
freebatting /フリーバッティング/
freecell /フリーセル/
freeclimbing /フリークライミング/
freecup /フリーカップ;和製英語/
freed /フリード/
freedial /フリーダイヤル/フリーダイアル/
freedman /フリードマン/
freedom /フリーダム/
freefall /フリーフォール/
freehand /フリーハンド/
freejazz /フリージャズ/
freekick /フリーキック/
freelance /フリーランス/
freelancer /フリーランサー/
freelist /フリーリスト/
freemail /フリーメール/
freeman /フリーマン/
freemarket /フリーマーケット;自由市場(≠flea market)/
freemason /フリーメーソン/フリーメイソン/
freepage /フリーページ/
freepaper /フリーペーパー/
freepass /フリーパス/
freepath /フリーパス/
freeplan /フリープラン/
freeradical /フリーラジカル/
freerider /フリーライダー/
freerun /フリーラン/
freeschool /フリースクール/
freesex /フリーセックス;和製英語/
freesia /フリージア/
freesize /フリーサイズ;和製英語(one-size-fits-all)/
freesoft /フリーソフト/
freesoftware /フリーソフトウェア/フリーソフトウエア/
freespace /フリースペース/
freestyle /フリースタイル/
freetalk /フリートーク/
freeter /フリーター;和製英語(part-time)/
freethrow /フリースロー/
freetime /フリータイム/
freetown /フリータウン/
freeware /フリーウェア/
freeword /フリーワード;和製英語/
freewriter /フリーライター;和製英語(freelance writer)/
freeze /フリーズ/
freezedry /フリーズドライ/
freezer /フリーザー/
freezing /フリージング/
frege /フレーゲ/
frei /フライ/フレイ/
freiburg /フライブルク/
freight /フレート/フレイト/
freire /フレイレ/
french /フレンチ/フランス語/
frenchbulldog /フレンチブルドッグ/
frenchdressing /フレンチドレッシング/
frenchfry /フレンチフライ/
frenchhorn /フレンチホルン/
frenchkiss /フレンチキス/
frenchrestaurant /フレンチレストラン/
frenchtoast /フレンチトースト/
frequency /フリークエンシー/
frere /フレール;(Fr)兄弟/
fresco /フラスコ/フレスコ/Fresco/
fresh /フレッシュ/
freshjuice /フレッシュジュース/
freshman /フレッシュマン/
freshness /フレッシュネス/
fret /フレット/
fretless /フレットレス/
freud /フロイト/
freund /フロイント/
frey /フレイ/
fri /金/
friand /フリアン/
fricasse /フリカッセ/
friction /フリクション/
frida /フリーダ/
friday /フライデー/フライデイ/フライディ/
fried /フライド/フリード/
frieda /フリーダ/
friedchicken /フライドチキン/
friedel /フリーデル/
friedman /フリードマン/
friedpotato /フライドポテト;fried potatoes/
friedrich /フリードリヒ/フリードリッヒ/
friend /フレンド/
friendly /フレンドリー/フレンドリ/
friends /フレンズ/
friendship /フレンドシップ/
frigate /フリゲート/
fright /フライト/
frill /フリル/
fringe /フリンジ/
fripper /フリッパー/
frisbee /フリスビー/
frisky /フリスキー/
frit /フリット/
frite /フリット/
fritter /フリッター/
fritz /フリッツ/
frock /フロック/
frockcoat /フロックコート/
frodo /フロド/
frog /フロッグ/
frois /フロイス/
from /フロム/
fromage /フロマージュ;(Fr)チーズ/
fromentin /フロマンタン/
fromm /フロム/
front /フロント/
frontale /フロンターレ;[Jリーグ]川崎/
frontdoor /フロントドア/
frontend /フロントエンド/
frontglass /フロントガラス/
fronthook /フロントホック/
frontier /フロンティア/
frontlight /フロントライト/
frontline /フロントライン/
frontpage /フロントページ/
frontpanel /フロントパネル/
frontpocket /フロントポケット/
frontrow /フロントロー/
frontrunner /フロントランナー/
frontside /フロントサイド/
frost /フロスト/
frostglass /フロストガラス/
frottage /フロッタージュ/
frown /⌒/
frozen /フローズン/
fructose /フルクトース/
fruit /フルーツ/フルート/フリュイ;仏語/
fruitcake /フルーツケーキ/
fruitjelly /フルーツゼリー/
fruitjuice /フルーツジュース/
fruitparfait /フルーツパフェ/
fruitpunch /フルーツポンチ/
fruits /フルーツ/
fruitsbasket /フルーツバスケット/
fruitscake /フルーツケーキ;fruitcake/
fruitsjuice /フルーツジュース/
fruitsparfait /フルーツパフェ/
fruitsparlour /フルーツパーラー/
fruitswine /フルーツワイン/
fruitwine /フルーツワイン/
fruity /フルーティ/
frunze /フルンゼ/
frustration /フラストレーション/
fry /フライ/
frye /フライ/
fryer /フライヤー/
frypan /フライパン;fry pan/
fsf /Free Software Foundation/FSF/
ftp /FTP/
ftpserver /FTPサーバ/
ftpsite /FTPサイト/
ftype /Fタイプ/Ｆタイプ/
fuchsia /フクシア/
fuck /ファック/
fucker /ファッカー/
fuckin /ファッキン;fuckin'/
fucose /フコース/
fucus /フーカス/
fudge /ファッジ/
fuego /フエゴ/
fuel /フューエル/フュエル/
fuga /フーガ/
fuji /フジ/
fujifilm /富士フイルム;www.fujifilm.co.jp/富士写真フイルム/フジフイルム/
fujitsu /富士通/
fujitv /フジテレビ;www.fujitv.co.jp/
ful /フル/
fulbright /フルブライト/
fulda /フルダ/
fulfil /フルフィル/
fulfill /フルフィル/
full /フル/一杯/
full-time /フルタイム/
fullaccess /フルアクセス/
fullalbum /フルアルバム/
fullauto /フルオート;full-automatic/
fullback /フルバック/
fullbase /フルベース;和製英語(bases loaded)/
fullbrowser /フルブラウザ/
fullcast /フルキャスト/
fullcity /フルシティ/フルシティー/
fullcolor /フルカラー/
fullcolour /フルカラー/
fullcontents /フルコンテンツ/
fullcount /フルカウント/
fullcourse /フルコース/
fuller /フラー/
fullerene /フラーレン;C60/
fullface /フルフェイス;full-face/
fullhouse /フルハウス/
fullinstall /フルインストール/
fullkeyboard /フルキーボード/
fullmarathon /フルマラソン/
fullmark /フルマーク/
fullmember /フルメンバー/
fullmesh /フルメッシュ/
fullmetal /フルメタル/
fullmoon /フルムーン/
fullname /フルネーム/
fullnude /フルヌード/
fullpath /フルパス/
fullpitch /フルピッチ/
fullpower /フルパワー/
fullrange /フルレンジ/
fullscale /フルスケール/
fullscore /フルスコア/
fullscratch /フルスクラッチ/
fullscreen /フルスクリーン/
fullseason /フルシーズン/
fullset /フルセット/
fullshot /フルショット/
fullsize /フルサイズ/
fullswing /フルスイング/
fullthrottle /フルスロットル/
fulltime /フルタイム/
fulltower /フルタワー/
fullversion /フルバージョン/
fully /フリー/
fumble /ファンブル/ハンブル/
fume /ヒューム/フューム/
fun /ファン/
funafuti /フナフティ/
funckey /ファンクションキー/
function /ファンクション/機能/関数/
functional /ファンクショナル/汎関数/
functionkey /ファンクションキー/
fund /ファンド/
fundamental /ファンダメンタル/
fundamentalism /ファンダメンタリズム;原理主義/
fundamentalist /ファンダメンタリスト;原理主義者/
fundamentals /ファンダメンタルズ/
funeral /フューネラル/
fungi /フンギ/
funk /ファンク/
funky /ファンキー/
funny /ファニー/
fur /ファー/
furan /フラン/
furio /フリオ/
furlong /ハロン/ファーロング/
furniture /ファニチャー/ファーニチャー/
further /ファーザー/
furtwangler /フルトヴェングラー/
fusco /フスコ/
fuse /ヒューズ/フューズ/
fusion /フュージョン/
futsal /フットサル/
future /フューチャー/フューチャ/
fuzzy /ファジー/ファジィ/
fyodor /フョードル/
g /γ;gamma/ジー/г;ge (cyrillic)/ゲー;(独語)/
ga /ガリウム/Gallium/Georgia/ジョージア/
gabardine /ギャバジン/
gabby /ガビー/ギャビー/
gabin /ギャバン/
gabon /ガボン;.ga/
gaborone /ハボローネ/
gabriel /ガブリエル/
gabriela /ガブリエラ/
gabriella /ガブリエラ/
gabrielle /ガブリエル/
gaby /ガビー/ゲイビー/
gacchan /ガッチャン/
gad /ガッド/
gadd /ガッド/
gadget /ガジェット/
gadolinium /ガドリニウム;[元素]64,Gd/
gaea /ガイア/
gael /ゲール/
gaff /ギャフ/ガフ/
gag /ギャグ/
gagarin /ガガーリン/
gagsense /ギャグセンス/
gaia /ガイア/
gail /ゲイル/ゲール/
gaillard /ガイヤール/ガイヤルド/
gaillarde /ガイヤルド/
gain /ゲイン/
gainax /ガイナックス;www.gainax.co.jp/
gainsbourg /ゲンズブール/
gal /ギャル/ガル/
gala /ガラ;仏語/ガーラ/ゲイラ;(英)/ギャラ/
galaconcert /ガラコンサート/
galact /ガラクト;(接頭辞)乳/
galactic /ギャラクティック/
galactose /ガラクトース/
galapagos /ガラパゴス/
galatea /ガラテア/
galatia /ガラテヤ/ガラテア/
galaxy /ギャラクシー/
galbraith /ガルブレイス/
gale /ゲイル/ゲール/
galette /ガレット/
galia /ガリア/
galicia /ガリシア/
galilaia /ガリラヤ/
galilei /ガリレイ/
galileo /ガリレオ/
galina /ガリーナ/
gall /ギャル/
galleria /ガレリア;(イタリア語)/
gallery /ギャラリー/
galley /ゲラ/ガレー;-船/ギャレー/
galli /ガリ/
gallia /ガリア/
galliano /ガリアーノ/
gallimard /ガリマール/
gallium /ガリウム;[元素]31,Ga/
galliver /ガリバー/
gallo /ガロ/
gallon /ガロン/
gallop /ギャロップ/
galo /ガロ/
galois /ガロワ/
gals /ギャルズ/
gamay /ガメ/
gamba /ガンバ;[Jリーグ]大阪/
gambia /ガンビア;.gm/
gamble /ギャンブル/
gambler /ギャンブラー/
gambling /ギャンブリング/
game /ゲーム/
gamebalance /ゲームバランス/
gamebook /ゲームブック/
gameboy /ゲームボーイ;[商標]任天堂/
gameboyadvance /ゲームボーイアドバンス;[商標]任天堂/
gameboymicro /ゲームボーイミクロ;[商標]任天堂/
gamebusiness /ゲームビジネス/
gamecenter /ゲームセンター/
gamecorner /ゲームコーナー/
gamecube /ゲームキューブ;[商標]任天堂/
gamelan /ガムラン/
gamemachine /ゲームマシン/
gamemaker /ゲームメーカー/
gamemaster /ゲームマスター/
gamemusic /ゲームミュージック/
gameover /ゲームオーバー/
gamepad /ゲームパッド/
gameplay /ゲームプレイ/
gamer /ゲーマー/
gamers /ゲーマーズ/
games /ゲームズ/
gameset /ゲームセット/
gameshow /ゲームショウ/
gamesoft /ゲームソフト;game software/
gamest /ゲーメスト/
gamestart /ゲームスタート/
gametitle /ゲームタイトル/
gamewatch /ゲームウォッチ;[商標]任天堂/
gaming /ゲーミング/
gamma /γ/ガンマ/γ版/
gammon /ギャモン/
ganache /ガナッシュ/
gandalf /ガンダルフ/
gandhara /ガンダーラ/
gandhi /ガンジー/ガンディー/
ganesha /ガネーシャ/
gang /ギャング/
ganga /ガンガー/
ganges /ガンジス/
gangster /ギャングスター/
ganja /ガンジャ/
ganttchart /ガントチャート;Gantt chart/
ganymede /ガニメデ/
ganymedes /ガニュメデス/
ganza /ガンザ/
gap /ギャップ/
garage /ガレージ/ガラージ;(原音に近い表記)/
garagekit /ガレージキット/
garagesale /ガレージセール/
garam /ガラム/
garammasala /ガラムマサラ/
garbage /ガベージ/ガーベージ/ガーベッジ/
garcia /ガルシア/
garcon /ギャルソン/
gard /ガール/
garden /ガーデン/
gardener /ガードナー/
gardening /ガーデニング/
gardenparty /ガーデンパーティ/
gardenplace /ガーデンプレイス;www.gardenplace.co.jp/
gardner /ガードナー/
gareth /ギャレス/
garfield /ガーフィールド/
garfunkel /ガーファンクル/
gargantua /ガルガンチュア/
gargoyle /ガーゴイル/
garhard /ゲルハルト/
garibaldi /ガリバルディ/
garland /ガーランド/
garlic /ガーリック/
garlicbutter /ガーリックバター/
garlictoast /ガーリックトースト/
garment /ガーメント/
garner /ガーナー/
garnet /ガーネット/
garnier /ガルニエ/
garonne /ガロンヌ/
garr /ゲール/
garret /ギャレット/
garrett /ギャレット/
garrison /ギャリソン/
garry /ゲイリー/
garter /ガーター/
garterbelt /ガーターベルト/
garuda /ガルーダ/ガルダ/
gary /ゲイリー/ゲーリー/
gas /ガス/瓦斯/ガソリン/
gasbombe /ガスボンベ;(独語)/
gasburner /ガスバーナー/
gascogne /ガスコーニュ/
gasket /ガスケット/
gasmask /ガスマスク/
gasmeter /ガスメーター/
gasoline /ガソリン/
gasolineengine /ガソリンエンジン/
gasolinestand /ガソリンスタンド;和製英語(gas station)/
gaspard /ガスパール/ガスパル/
gasrange /ガスレンジ/
gasstove /ガスストーブ/
gastable /ガステーブル;和製英語/
gastank /ガスタンク/
gaston /ガストン/
gastronomie /ガストロノミー;仏語/
gastronomy /ガストロノミー/
gasturbine /ガスタービン/
gate /ゲート/
gatearray /ゲートアレイ/
gateau /ガトー/
gateauchocolat /ガトーショコラ/
gateball /ゲートボール/
gatecity /ゲートシティ;大崎/
gatekeeper /ゲートキーパー/
gates /ゲイツ/
gateway /ゲートウェイ/
gather /ギャザー/ギャザ/
gathering /ギャザリング/
gatsby /ギャツビー/
gatt /ガット;General Agreement on Tariffs and Trade/
gatti /ガッティ/
gattuso /ガットゥーゾ/
gauche /ゴーシュ/
gaucho /ガウチョ/
gaudi /ガウディ/
gaudy /ゴーディ/
gaufre /ゴーフル/
gaufrette /ゴーフレット/
gauge /ゲージ/
gauguin /ゴーギャン/ゴーガン/
gaul /ゴール/
gauloise /ゴロワーズ/
gaultier /ゴルチェ;www.jeanpaul-gaultier.com/
gauntlet /ガントレット/
gauss /ガウス/
gaussian /ガウシアン/
gautier /ゴーティエ/ゴーチェ/ゴーチエ/
gauze /ガーゼ/
gavin /ガビン/ギャビン/ギャヴィン/
gavotte /ガボット/ガヴォット/
gawein /ガウェイン/
gay /ゲイ/ガイ/
gaya /ガヤ/
gaybar /ゲイバー/
gaze /ガーゼ;(独語)/
gazelle /ガゼル/
gazette /ガゼット/
gazpacho /ガスパチョ/ガスパッチョ/ガスパーチョ/
gb /ＧＢｙｔｅ/
gc /ガーベッジ・コレクション/グラフィク・コンテキスト/
gcc /Gcc/
gcl /GCL/
gcup /Gカップ;25cm/Ｇカップ/
gd /ガドリニウム/Gadolinium/
ge /г;cyrillic/≧/ゲルマニウム/Germanium/
gear /ギア/ギヤ/
gearbox /ギアボックス/
gearchange /ギアチェンジ/
gecko /ゲッコー;ヤモリ/
ged /ゲド/
gee /ジー/
geek /ジーク/
geen /ジーン/
geena /ジーナ/
gefitinib /ゲフィチニブ;NB:通称Iressa/
gehennom /ゲヘナ/
gehry /ゲーリー/
geiger /ガイガー/
geigercounter /ガイガーカウンター/
geist /ガイスト/
gel /ジェル/ゲル/
gelande /ゲレンデ;(独語)/
gelatin /ゼラチン/
gelatine /ゼラチン/
gelato /ジェラート;(It)アイスクリーム/
gelee /ジュレ;(Fr) ゼリー/
gelette /ガレット/
geller /ゲラー/
gelly /ゲリー/
gelsomina /ジェルソミーナ/
gem /ジェム/
gema /ジェマ/
gemclip /ゼムクリップ/
gemeinschaft /ゲマインシャフト/
gemini /ジェミニ/
gemma /ジェンマ/ジェマ/
gender /ジェンダー/
genderfree /ジェンダーフリー;和製英語/
gene /ジーン/ジェネ/
genecon /ゼネコン;general contractor/
genepro /ゲネプロ;<Generalprobe/
general /ゼネラル/ジェネラル/
generalist /ゼネラリスト/ジェネラリスト/
generalmanager /ゼネラルマネージャー;GM/
generate /ジェネレート/
generation /ジェネレーション/
generationgap /ジェネレーションギャップ;generation gap/
generator /ジェネレータ/ジェネレーター/
generic /ジェネリック/
genesis /ジェネシス/
genet /ジュネ/
genetic /ジェネティック/
geneticalgorithms /ジェネティックアルゴリズム/
genetics /ジェネティクス/ジェネティックス/
geneticsystem /ジェネティックシステム/
geneve /ジュネーブ/ジュネーヴ/
genevieve /ジュヌヴィエーヴ/ジュヌビエーブ/
genghiskhan /ジンギスカン;Genghis Khan/成吉思汗/
genie /ジニー/ジェニー;仏語/
genius /ジーニアス/
genoa /ゼノア;genovaの英語読み/ジェノア/ジェノバ/ジェノヴァ/
genocide /ジェノサイド/
genoise /ジェノワーズ/
genom /ゲノム/
genome /ゲノム/
genova /ジェノバ/ジェノヴァ/
genre /ジャンル/
gentle /ジェントル/
gentleman /ジェントルマン/ゼントルマン/
gentlemen /ジェントルメン/
gently /ジェントリー/ジェントリィ/
gentzen /ゲンツェン/
geo /ジオ/
geoff /ジェフ/
geoffrey /ジェフリー/
geography /ジオグラフィ/ジオグラフィー/
geoid /ジオイド/
geometry /ジオメトリ/ジオメトリー/
geopotential /ジオポテンシャル/
georg /ゲオルク/ゲオルグ/
george /ジョージ/ジョルジュ/ゲオルゲ/
georgemason /ジョージ・メイソン大学/
georges /ジョルジュ/
georgetown /ジョージタウン/
georgette /ジョーゼット/
georgia /ジョージア/グルジア;.ge/
georgie /ジョルジ/ジョージー/
georgii /ゲオルギー/ゲオールギー/
georgina /ジョージナ/
geq /≧/
gera /ゲーラ/
gerald /ジェラルド/
geraldine /ジェラルディン/ジェラルダイン/
geraniol /ゲラニオール/
geranium /ゼラニウム/
gerard /ジェラルド/ジェラード/ジェラール/
gerardo /ヘラルド/ジェラルド/
gerbera /ガーベラ/
gerd /ゲルト/
gerda /ゲルダ/
gere /ギア/
gerhard /ゲルハルト/
geri /ジェリ/
gericault /ジェリコ/ジェリコー/
gerin /ゲラン/
germain /ジェルマン/
german /ジャーマン/ドイツ/ゲルマン/ヘルマン/
germane /ゲルマン/
germania /ゲルマニア/
germanium /ゲルマニウム;[元素]32,Ge/
germansuplex /ジャーマンスープレックス/
germany /ドイツ/
geronimo /ジェロニモ/
gerrard /ジェラード/
gerry /ジェリー/ゲリー/
gershwin /ガーシュイン/ガーシュウィン/
gertie /ガーティ/
gertrude /ガートルード/
gesellschaft /ゲゼルシャフト/
gestalt /ゲシュタルト/
gestapo /ゲシュタポ/
gesture /ジェスチャー/
gesturegame /ジェスチャーゲーム/
get /ゲット/得る/
getaway /ゲッタウェイ/
gethsemane /ゲッセマネ/
getmethod /GETメソッド/
gets /ゲッツ/
getter /ゲッター/ゲッタ/
getting /ゲッティング/
gettwo /ゲッツー/
gettysburg /ゲティスバーグ/
getz /ゲッツ/
gewalt /ゲバルト;(独語)暴力/
geyer /ガイヤー/
gfx /グラフィックス;graphics/
gfxboard /グラフィックボード;graphic board/
gfxcard /グラフィックカード;graphic card/
gfxdesign /グラフィックデザイン/
gfxdesigner /グラフィックデザイナー/
gg /≫/
ggtp /γGTP;γ-glutamyl transpeptitase/
ghana /ガーナ;.gh/
ghazza /ガザ/
ghee /ギー/
ghetto /ゲットー;(イタリア語)/
ghibli /ジブリ/
ghosn /ゴーン/
ghost /ゴースト/
ghosttown /ゴーストタウン/
ghostwriter /ゴーストライター/
giacometti /ジャコメッティ/
giacomo /ジャコモ/
gian /ジャン/
giancarlo /ジャンカルロ/
gianfranco /ジャンフランコ/
gianluca /ジャンルカ/
gianluigi /ジャンルイジ/ジャン・ルイジ/
gianna /ジャンナ/
giannini /ジャンニーニ/
giant /ジャイアント/
giantpanda /ジャイアントパンダ/
giants /ジャイアンツ/
gibberellin /ジベレリン/
gibbs /ギブス/
gibernau /ジベルナウ/
gibraltar /ジブラルタル;.gi/
gibson /ギブソン/ギブスン/
gid /グループID/
gide /ジッド/ジイド/ジード/
gideon /ギデオン/
gien /ジアン/
gifanimation /GIFアニメーション/
gifanime /GIFアニメ/
giffile /GIFファイル/
gift /ギフト/
giftbox /ギフトボックス/
giftcard /ギフトカード/
giftcorner /ギフトコーナー/
giftset /ギフトセット/
giftshop /ギフトショップ/
giftwrapping /ギフトラッピング/
gig /ギグ/
giga /ギガ;G,10^9/
gigabit /ギガビット/
gigabyte /ギガバイト/
gigabytes /ギガバイト/
gigantes /ギガンテス/
giger /ギーガー/
gigi /ジジ/
gigolo /ジゴロ/
gigue /ジグ/ジーグ/
gil /ジル/ギル/ヒル/
gila /ギラ/
gilardino /ジラルディーノ/
gilbert /ギルバート/ジルベール/
gilberto /ジルベルト/
gile /ガイル/
giles /ジャイルズ/
gilgamesh /ギルガメッシュ/ギルガメシュ/
gill /ジル/ギル/
gilles /ジル/
gillespie /ガレスピー/
gillette /ジレット/
gillian /ジリアン/ギリアン/
gillie /ギリー/
gilly /ギリー/
gilmour /ギルモア/
gilyak /ギリヤーク/
gimlet /ギムレット/
gimmick /ギミック/
gin /ジン/
gina /GINA(the Generic Interactive Application)/ジーナ/ジナ/
ginette /ジネット/
ginfizz /ジンフィズ/
ginger /ジンジャー/
gingerale /ジンジャーエール/ジンジャエール/
gingham /ギンガム/
ginghamcheck /ギンガムチェック/
ginn /ギン/
ginny /ジニー/
gino /ジーノ/ジノ/
ginsberg /ギンズバーグ/
gintonic /ジントニック;和製英語(gin and tonic)/
gioconda /ジョコンダ/
giocoso /ジョコーソ/
giordano /ジョルダーノ/
giorgio /ジョルジオ/ジョルジョ/
giotto /ジョット/ジオット/
giovanna /ジョヴァンナ/ジョバンナ/
giovanni /ジョヴァンニ/ジョバンニ/
gips /ギプス;(独語)/
giraffu /ジラフ;※giraffe?/
giraldo /ジラルド/
giraud /ジロー/
girdle /ガードル/
girl /ガール/
girlfriend /ガールフレンド/
girlish /ガーリッシュ/
girls /ガールズ/
girlscout /ガールスカウト/
girly /ガーリー/
girolamo /ジローラモ/
gironde /ジロンド/
gisele /ジゼル/
giselle /ジゼル/
gitanes /ジタン/
giulia /ジュリア/
giuliano /ジュリアーノ/
giulietta /ジュリエッタ/
giulini /ジュリーニ/
giuseppe /ジュゼッペ/
giveandtake /ギブアンドテイク;give-and-take/
given /ギブン/
givency /ジバンシー/
giveup /ギブアップ/
glace /グラッセ/
glad /グラッド/
gladiator /グラディエーター/
gladiolus /グラジオラス/
gladys /グラディス/
glaive /グレイブ/グレイヴ/
glamor /グラマー/
glamorous /グラマラス/
glamour /グラマー/
glamourous /グラマラス/
glare /グレア/
glasgow /グラスゴー/
glasnost /グラスノスチ/
glass /グラス/ガラス/硝子/
glassblock /ガラスブロック/
glassboat /グラスボート/
glasscase /ガラスケース/
glassfiber /グラスファイバー/
glassharp /グラスハープ/
glasslens /ガラスレンズ/
glasstable /ガラステーブル/
glasstop /ガラストップ/
glasswool /グラスウール/
glaze /グレイズ/グレーズ/
glazunov /グラズノフ/
glee /グリー/
gleeclub /グリークラブ/
glen /グレン/
glencheck /グレンチェック/
glenda /グレンダ/
glenn /グレン/
glia /グリア/
glico /グリコ;www.glico.co.jp/
glider /グライダー/
gliss /グリス;[音楽]/
glissade /グリセード/
glitch /グリッチ/
glitter /グリッター/
global /グローバル/
globaladdress /グローバルアドレス/
globaldatafile /グローバルデータファイル/
globalip /グローバルIP/
globalisation /グローバリゼーション/
globalism /グローバリズム/
globalization /グローバリゼーション/
globalmemory /グローバルメモリ/
globalstandard /グローバルスタンダード/
globalstd /グローバルスタンダード;global standard/
globe /グローブ/
globin /グロビン/
globulin /グロブリン/
glocal /グローカル/
glock /グロック/
glocken /グロッケン/
glockenspiel /グロッケンシュピール/
gloom /グルーム/
gloomy /グルーミー/
gloria /グロリア/グローリア/
glorious /グロリアス/グローリアス/
glory /グローリー/
glossary /グロッサリー/
glove /グローブ/グラブ/グローヴ/
glover /グローバ/グラバー/グローバー/
glow /グロー;白熱/グロウ/
glucan /グルカン/
gluck /グルック/
gluco /グルコ/
glucomannan /グルコマンナン/
glucosamine /グルコサミン/
glucose /グルコース/
glue /グルー/
gluhwein /グリューワイン/グリューヴァイン/
gluon /グルーオン/グルオン/
glutamine /グルタミン;Gln/
glutathion /グルタチオン/
gluten /グルテン/
glycan /グリカン/
glycerin /グリセリン/
glycerine /グリセリン/
glycerol /グリセロール/グリセリン;glycerin/
glyceryl /グリセリル/
glycine /グリシン;Gly/
glycogen /グリコーゲン/
glycol /グリコール/
glycoside /グリコシド/
glycyrrhizin /グリチルリチン/
glykogen /グリコーゲン;(独語)/
glykol /グリコール;(独語)/
glyme /グリム/
glyph /グリフ/
gmd /GMD(German National Research Center for Computer Science)/
gmen /Ｇメン/Gメン/
gmt /グリニッジ標準時/GMT/
gnome /ノーム/
gnosis /グノーシス/
gnossienne /グノシェンヌ/グノシエンヌ/
gnu /ヌー;[動物]/グヌー;GNU is not unix/グニュー/GNU/
gnus /ニューズ/Ｇｎｕｓ/ｇｎｕｓ/GNUS/Gnus/
go /ゴー/
goa /ゴア/
goal /ゴール/
goalarea /ゴールエリア/
goalin /ゴールイン;和製英語/
goalkeeper /ゴールキーパー/
goalkick /ゴールキック/
goalline /ゴールライン/
goalpost /ゴールポスト/
gobi /ゴビ/
goblet /ゴブレット/
goblin /ゴブリン/
gocart /ゴーカート/
god /ゴッド/ガッド/
godard /ゴダール/
goddamn /ガッデム/
goddard /ゴダード/ゴッダード/
godel /ゲーデル/
godfather /ゴッドファーザー/
godiva /ゴディバ/
godmother /ゴッドマザー/
godot /ゴドー/
godwin /ゴドウィン/
godzilla /ゴジラ/
goebbels /ゲッベルス/ゲッペルス;※ゲッ「ベ」ルスの方が正確/
goedel /ゲーデル/
goes /ゴーズ/
goethe /ゲーテ/
goggle /ゴーグル/
gogh /ゴッホ/
gogo /ゴーゴー/
gogol /ゴーゴリ/
going /ゴーイング/
golan /ゴラン/
gold /ゴールド/
goldberg /ゴールドバーグ/ゴルトベルク/ゴールドベルグ/
goldcard /ゴールドカード/
goldcoast /ゴールドコースト;Gold Coast, オーストラリア(ool)/
goldcollar /ゴールドカラー/
golddisk /ゴールドディスク/
golden /ゴールデン/
goldencross /ゴールデンクロス/
goldeneagles /ゴールデンイーグルス/
goldenglove /ゴールデングラブ;NB:MLBのは Gold Glove/
goldenretriever /ゴールデンレトリバー/ゴールデンレトリーバー/ゴールデンリトリバー/
goldentime /ゴールデンタイム/
goldenweek /ゴールデンウィーク/
goldglove /ゴールドグラブ;Gold Glove/
goldie /ゴールディ/
goldman /ゴールドマン/
goldrush /ゴールドラッシュ/
goldsmith /ゴールドスミス/
goldstone /ゴールドストーン/
golem /ゴーレム/
golf /ゴルフ/
golfbag /ゴルフバッグ/
golfball /ゴルフボール/
golfclub /ゴルフクラブ/
golfcourse /ゴルフコース/
golfer /ゴルファー/
golfgame /ゴルフゲーム/
golfresort /ゴルフリゾート/
golfshoes /ゴルフシューズ/
golfshop /ゴルフショップ/
golfware /ゴルフウェア/
golgotha /ゴルゴタ/
goliath /ゴリアテ/
golo /ゴーロ/
gom /ゴム;(蘭語)/
gomes /ゴメス/
gomez /ゴメス/
gommage /ゴマージュ/
gomorrha /ゴモラ/
goncourt /ゴンクール/
gondola /ゴンドラ/
gone /ゴーン/
gong /ゴング/
gonzales /ゴンザレス/
gonzalez /ゴンザレス/ゴンサレス/
gonzalo /ゴンサロ/
goo /グー;www.goo.ne.jp/
good /グッド/グー/
good-bye /グッド・バイ/
goodbye /グッバイ/グッドバイ/
gooddesign /グッドデザイン/
goodjob /グッジョブ/
goodluck /グッドラック/
goodman /グッドマン/
goodmorning /グッドモーニング/
goodnight /グッドナイト/グッナイ/グンナイ/
goods /グッズ/
goodtiming /グッドタイミング/
goodwill /グッドウィル/
goodwin /グッドウィン/
goody /グッディ/
goodyear /グッドイヤー;www.goodyear.com/グッドイアー;<rare>/
google /グーグル;www.google.com/
goose /グース/
gopher /ゴーファー/
goran /ゲラン/ゴラン/
gorbachev /ゴルバチョフ/
gordon /ゴードン/
gore /ゴア/
goretex /ゴアテックス;[商標]/
gorge /ゴルジュ/
gorgeous /ゴージャス/
gorgias /ゴルギアス/
gorgo /ゴルゴ;13/
gorgon /ゴルゴン/
gorgonzola /ゴルゴンゾーラ/
gorilla /ゴリラ/
gorkii /ゴーリキー/ゴーリキイ/
gosign /ゴーサイン/GOサイン/
gospel /ゴスペル/
gossip /ゴシップ/
gotama /ゴータマ/瞿曇/
goteborg /エーテボリ;スウェーデン/ヨーテボリ/イェーテボリ/イェテボリ/
goth /ゴート/
gothenburg /イェテボリ/
gothic /ゴシック/
gothiclolita /ゴシックロリータ/ゴスロリ/
gothloli /ゴスロリ;gothic lolita/
gottfried /ゴットフリート/
gottingen /ゲッティンゲン/
gouache /ガッシュ/グワッシュ/グアッシュ/
gouda /ゴーダ/
goudacheese /ゴーダチーズ/
gould /グールド/
gounod /グノー/
gourmand /グルマン/
gourmet /グルメ/
governance /ガバナンス/
government /ガバメント/
governor /ガバナー/
gown /ガウン/
goya /ゴヤ/
gpan /ジーパン;和製英語(jeans)/Ｇパン/Gパン/
gpl /GPL/
gpllicence /GPLライセンス;NB:general public licence licence/
gpllicense /GPLライセンス;NB:general public license license/
grab /グラブ/
grabber /グラバー/
grace /グレース/グレイス/
graceful /グレイスフル/グレースフル/
gracia /グラシア/
gracias /グラシアス;(西語)/
gracie /グレイシー/
gracious /グレイシャス/
gracq /グラック/
grad /グラード/グラッド/
gradation /グラデーション/
grade /グレード/グレイド/
gradedown /グレードダウン/
gradeup /グレードアップ/グレイドアップ/
gradient /グラディエント/
gradius /グラディウス;[ゲーム]コナミ/
graduate /グラデュエート/大学院生/
graf /グラフ/
graffiti /グラフィティ/
graham /グラハム/グレアム/
grain /グレン/グレイン/グレーン/
gram /グラム/
grammar /グラマー/
gramme /グラム/
grammy /グラミー/
grampus /グランパス;[Jリーグ]名古屋/
grampuseight /グランパスエイト;[Jリーグ]名古屋/
gramsci /グラムシ/
gran /グラン/
granada /グラナダ/
granados /グラナドス/
grand /グランド/グラン;仏語/
grandcanyon /グランドキャニオン;Grand Canyon/
grandcru /グランクリュ;grand cru/
granddesign /グランドデザイン/
grande /グランデ/
grandfinale /グランドフィナーレ/
grandhotel /グランドホテル/
grandi /グランディ/
grandioso /グランディオーソ/
grandmarnier /グランマルニエ;(Fr) grand marnier/
grandmaster /グランドマスター;grand master/
grandopen /グランドオープン/
grandopera /グランドオペラ/
grandpiano /グランドピアノ/
grandprix /グランプリ;grand prix/
grandslam /グランドスラム/
grandvin /グランヴァン/
grange /グランジェ/
granite /グラニット/グラニテ;(Fr)氷菓/
grant /グラント/
granular /グラニュラー/
granville /グランビル/グランヴィル/
grape /グレープ/
grapefruit /グレープフルーツ/
grapefruits /グレープフルーツ/
graph /グラフ/
graphic /グラフィック/グラフィク/
graphica /グラフィカ/
graphicaccelerator /グラフィックアクセラレータ/
graphical /グラフィカル/
graphicalinterface /グラフィカル・インターフェイス/
graphicboard /グラフィックボード/
graphiccard /グラフィックカード/
graphicdesign /グラフィックデザイン/
graphicdesigner /グラフィックデザイナー/
graphicer /グラフィッカー/
graphics /グラフィックス/グラフィクス/
graphite /グラファイト/
graphmatching /グラフマッチング/
graphy /グラフィ/グラフィー/
grappa /グラッパ/
grapple /グラップル/
grass /グラス/
grassbunker /グラスバンカー/
grasscourt /グラスコート/
grasshopper /グラスホッパー/
grassski /グラススキー/
gratin /グラタン/
grating /グレーチング/グレーティング/
grau /グラウ/
grave /グレイブ/グレイヴ/グラーヴ;仏語/グラーブ/グラーベ;(イタリア語)/
graves /グラーブ/
gravity /グラビティ/グラヴィティ/
gravure /グラビア/
gravureidol /グラビアアイドル/
gray /グレー/グレイ/
graycollar /グレーカラー/
grayhound /グレイハウンド/
grayout /グレーアウト/グレイアウト/
grayscale /グレースケール/グレイスケール/
grayzone /グレーゾーン/
graz /グラーツ/
graze /グレイズ/
grazia /グラツィア/
grazie /グラッチェ;(イタリア語)/
grazioso /グラツィオーソ/
grease /グリス/グリース/
great /グレート/グレイト/
greatbarrierreef /グレートバリアリーフ/
greatbritain /グレートブリテン;Great Britain/
greatdane /グレートデン/
greater /グレーター/グレイター/
greatest /グレーテスト/グレイテスト/
greco /グレコ/
grecoroman /グレコローマン/
gree /グリー;www.gree.jp/
greece /ギリシャ;.gr/ギリシア/グリース/
greeclub /グリークラブ;gree club/
greek /α;alpha/β;beta/γ;gamma/δ;delta/ε;epsilon/ζ;zeta/η;eta/θ;theta/ι;iota/κ;kappa/λ;lambda/μ;mu/ν;nu/ξ;xi/ο;omicron/π;pi/ρ;rho/σ;sigma/τ;tau/υ;upsilon/φ;phi/χ;chi/ψ;psi/ω;omega/グリーク/ギリシャ/
green /グリーン/
greenasparagus /グリーンアスパラガス/
greenbelt /グリーンベルト/
greenberet /グリーンベレー/
greencard /グリーンカード/
greene /グリーン/
greenfee /グリーンフィ/グリーンフィー/
greenhouse /グリーンハウス/
greenland /グリーンランド;.gl/
greenpeace /グリーンピース;www.greenpeace.org/
greenpeas /グリーンピース/
greenpepper /グリーンペッパー/
greenpia /グリーンピア/
greensleeves /グリーンスリーブス/グリーンスリーヴス/
greenspan /グリーンスパン/
greentea /グリーンティー/グリーンティ/
greenwich /グリニッジ/
greeting /グリーティング/
greetingcard /グリーティングカード/
greg /グレッグ/
gregor /グレゴール/
gregorio /グレゴリオ/
gregorius /グレゴリウス/
gregory /グレゴリー/
gremlin /グレムリン/
grenada /グレナダ;.gd/
grenade /グレネード/
grenier /グルニエ;(Fr)屋根裏部屋/
grenoble /グルノーブル/
grep /グレップ/
gresham /グレシャム/
gresia /ギリシャ;(<蘭語)/ギリシア/
greta /グレタ/
gretchen /グレートヒェン/グレッチェン/グレートヘン/
grete /グレーテ/
gretel /グレーテル/
grey /グレー/グレイ/
greycollar /グレーカラー/
greyhound /グレイハウンド/
greyout /グレーアウト/
greyscale /グレースケール/グレイスケール/
greyzone /グレーゾーン/
grid /グリッド/
griddle /グリドル/
grieg /グリーグ/
griffin /グリフィン/
griffis /グリフィス/
griffith /グリフィス/
griffon /グリフォン/
grill /グリル/
grillpan /グリルパン/
grim /グリム/
grimm /グリム/
grind /グラインド/
grinder /グラインダー/グラインダ/
griotte /グリオット/
grip /グリップ/
gripper /グリッパー/
grisaille /グリザイユ/
grissini /グリッシーニ/
grit /グリット/
gro /グロ;grotesque/
grocery /グローサリー/
groggy /グロッキー/
groom /グルーム/
groomer /グルーマー/
grooming /グルーミング/
groove /グルーヴ/グルーブ/
groovy /グルーヴィー/
gropius /グロピウス/
gross /グロス/
grossman /グロスマン/
grotesque /グロテスク/
ground /グランド/グラウンド/
grounder /グラウンダー/ゴロ/
grounding /グラウンディング/
groundzero /グラウンドゼロ;原爆の爆心/
group /グループ/
grouphome /グループホーム/
groupid /グループID/
grouping /グルーピング/
groupingeffect /グルーピング・エフェクト/
grouplesson /グループレッスン/
groupsounds /グループサウンズ/
groupware /グループウェア/
groupwork /グループワーク/
groupy /グルーピー/
grow /グロー;成長/グロウ/
growing /グローイング/
growl /グロール/
growth /グロース/グロウス/
grumman /グラマン/
grunge /グランジ/
grusin /グルーシン/
gruyere /グリュイエール/
gruziya /グルジア/
gryphon /グリフォン/
gs /ghostscript/
gspot /Ｇスポット;G-spot/Gスポット/
gt /＞/
gtype /Gタイプ/Ｇタイプ/
guadalajara /グアダラハラ/
guadalcanal /ガダルカナル/
guadeloupe /グアドループ;.gp/
guam /グアム;.gu/グァム/
guanidine /グアニジン/
guanine /グアニン;G/
guano /グアノ/
guanosine /グアノシン/
guantanamo /グアンタナモ;キューバ/
guarana /ガラナ/
guarantee /ギャランティー/ギャランティ/ギャラ/
guard /ガード/
guardian /ガーディアン/
guardman /ガードマン;和製英語(security guard)/
guardrail /ガードレール/
guatemala /グアテマラ;gt/グァテマラ/ガテマラ/
guattari /ガタリ/
guava /グァバ/グアバ/
guayaquil /グアヤキル;エクアドル(gye)/
gucci /グッチ;www.gucci.com/
guccio /グッチオ/
guerin /ゲラン/ゲリン/
guerlain /ゲラン;www.guerlain.com/
guernica /ゲルニカ/
guernsey /ガーンジー;.gg/
guerre /ゲール/
guerrilla /ゲリラ/
guess /ゲス/
guest /ゲスト/
guestbook /ゲストブック/
guesthouse /ゲストハウス/
guestroom /ゲストルーム/
guetre /ゲートル/
guevara /ゲバラ;Ernesto Che Guevara/
guggenheim /グッゲンハイム/
guglielmo /グリエルモ/
gui /グラフィカルユーザインターフェース/GUI/
guiana /ギアナ/
guidance /ガイダンス/
guide /ガイド/
guidebook /ガイドブック/
guideline /ガイドライン/
guidemap /ガイドマップ/
guidetour /ガイドツアー/
guideway /ガイドウェイ/
guido /グイド/ギド/グィード/
guild /ギルド/
guilder /ギルダー/
guile /ガイル/
guillaume /ギョーム/ギヨーム/
guillotine /ギロチン/
guilty /ギルティ/ギルティー/
guin /グイン/グウィン/グィン/
guinea /ギニア;.gn/
guineabissau /ギニアビサウ;Guinea-Bissau/
guinness /ギネス;www.guinness.ie/
guinnessbook /ギネスブック/
guiro /ギロ/
guitar /ギター/
guitaramp /ギターアンプ/
guitarist /ギタリスト/
guitarmagazine /ギターマガジン/
guitarsolo /ギターソロ/
guitarsynth /ギターシンセ/
gukbap /クッパ;(朝鮮語)/
gulda /グルダ/
gulf /ガルフ/
gull /ガル;かもめ/
gulose /グロース/
gum /ゴム/ガム/
gumband /ゴムバンド;rubber band/
gumbo /ガンボ;オクラ/
gumboat /ゴムボート/
gumhose /ゴムホース/
gumpacking /ゴムパッキン/
gumsyrup /ガムシロップ;gum syrup/
gumtape /ガムテープ;和製英語(packing tape)/
gun /ガン/
gundam /ガンダム;[アニメ]/
gunman /ガンマン/
gunnar /グンナー/
gunner /ガンナー/
gunter /ギュンター/
gunther /ギュンター/グンター/ガンサー/
guppy /グッピー/
gupta /グプタ/
gurkha /グルカ/
guru /グル/
gus /ガス/
gushose /ガスホース/
gust /ガスト;www.gust.co.jp/
gusta /グスタ/
gustaf /グスタフ/
gustav /グスタフ/
gustave /グスタフ/ギュスターヴ/ギュスターブ/
gusto /ガスト;英語/グスト;イタリア語)/ガストー/
gut /ガット/
gutenberg /グーテンベルク/グーテンベルグ/
gutguitar /ガットギター/
gutierrez /グティエレス/
guts /ガッツ/
gutspose /ガッツポーズ;和製英語/
gutter /ガーター/ガター/
guy /ガイ/ギー;仏語/ギイ/ギュイ/
guyana /ガイアナ;.gy/
gw /ゴールデンウィーク/ゲートウェイ/GateWay/
gwen /グエン/グウェン/
gym /ジム/
gymnasium /ギムナジウム/ジムナジウム/
gymnopedie /ジムノペディ/
gynt /ギュント/
gypsy /ジプシー/
gyro /ジャイロ/
gyroscope /ジャイロスコープ/
h /エッチ/エイチ/ハー;(独語)/水素/Hydrogen/
h# /平成#0年度/平成#0年/
h#.#.# /平成#0年#0月#0日/
haag /ハーグ/
haagendazs /ハーゲンダッツ;Haagen-Dazs/
haas /ハース/
habakkuk /ハバクク/
habanera /ハバネラ/
habanero /ハバネロ/
haber /ハーバー/
habermas /ハーバーマス/ハーバマス/
habit /ハビット/
habitat /ハビタット/
habitation /アビタシオン/
habitus /ハビトゥス/
habsburg /ハプスブルグ/
hachette /アシェット/
hack /ハック/
hacker /ハッカー/
hacking /ハッキング/
had /ハド/
hadamard /アダマール/
hades /ハデス/
hadley /ハドリー/ハドレー/
hadron /ハドロン/
hafnium /ハフニウム;[元素]72,Hf/
hagen /ハーゲン/
haggai /ハガイ/
hague /ヘーグ;the Hague, Holland/
hahn /ハーン/
hahnium /ハーニウム;[元素]105,Hn/
haines /ヘインズ/
haiphong /ハイフォン;ベトナム/
hair /ヘアー/ヘア/
hairaccessory /ヘアアクセサリー/
hairball /ヘアボール/
hairband /ヘアバンド/
hairbrush /ヘアブラシ/
haircare /ヘアケア/
haircolor /ヘアカラー/
haircolour /ヘアカラー/
haircut /ヘアカット/
hairdye /ヘアダイ/
hairgum /ヘアゴム/
hairline /ヘアライン/
hairmake /ヘアメイク/ヘアメーク/
hairnude /ヘアヌード;和製英語/
hairpiece /ヘアピース/
hairpin /ヘアピン/
hairpincurve /ヘアピンカーブ/
hairsalon /ヘアサロン/
hairspray /ヘアスプレー/
hairstyle /ヘアスタイル/ヘアースタイル/
hairtonic /ヘアトニック/
haiti /ハイチ;.ht/ハイティ/
hajj /ハッジ;[イスラム]巡礼/
haken /ハーケン/
hakenkreuz /ハーケンクロイツ/
hakkinen /ハッキネン/
hal /ハル/
halation /ハレーション/
halberd /ハルバード/
halcion /ハルシオン/
half /ハーフ/
halfback /ハーフバック/
halfbottle /ハーフボトル/
halfcoat /ハーフコート;和製英語(half-length coat)/
halfcourt /ハーフコート/
halfmarathon /ハーフマラソン/
halfmirror /ハーフミラー/
halfmoon /ハーフムーン/
halfpants /ハーフパンツ/
halfpitch /ハーフピッチ/
halfsize /ハーフサイズ/
halfsleeve /ハーフスリーブ/
halfswing /ハーフスイング/
halftime /ハーフタイム/
halftone /ハーフトーン/
halfway /ハーフウェイ/ハーフウェー/
hali /ハーリー/
haliburton /ハリバートン/
halifax /ハリファックス/
halim /ハリム;インドネシア(hlp)/
hall /ホール/
halle /ハレ/ハル/
hallelujah /ハレルヤ/
halley /ハレー/ハリー;Edmund Halley (1656-1742)/
halloween /ハロウィン/ハロウィーン/
hallstaff /ホールスタッフ/
halo /ハロー/ハロ/
halogen /ハロゲン/
halogenheater /ハロゲンヒーター/
halogenlamp /ハロゲンランプ/
halon /ハロン;CF3Brなど/
halothane /ハロセン/
halt /ホルト/
halter /ホルター/
halterneck /ホルターネック;halter-neck/
ham /ハム/
hamadan /ハマダーン/
hamam /ハマム/
hamann /ハーマン/ハマン/
hamas /ハマス/
hambacker /ハムバッカー/
hamburg /ハンバーグ/ハンブルク/ハンブルグ/
hamburger /ハンバーガー/
hamegg /ハムエッグ;和製英語(ham and eggs)/
hameln /ハーメルン;ドイツ/
hamilton /ハミルトン/
hamiltonian /ハミルトニアン/
hamlet /ハムレット/
hammer /ハンマー/ハンマ/
hammerhead /ハンマーヘッド/
hamming /ハミング/
hammock /ハンモック/
hammond /ハモンド/
hammondorgan /ハモンドオルガン/
hammurabi /ハンムラビ/ハムラビ/
hampshire /ハンプシャー/
hampton /ハンプトン/
hamsalad /ハムサラダ/
hamster /ハムスター/
hamza /ハムザ/
hana /ハナ/
hancock /ハンコック/
hand /ハンド/
handbag /ハンドバッグ/
handball /ハンドボール/
handbell /ハンドベル/
handbook /ハンドブック/
handbrake /ハンドブレーキ/
handclap /ハンドクラップ/
handcraft /ハンドクラフト/
handcream /ハンドクリーム/
handel /ヘンデル/
handgun /ハンドガン/
handheld /ハンドヘルド/
handi /ハンディ;handicap/ハンデ/ハンディー/
handicap /ハンディキャップ/
handkerchief /ハンカチーフ/ハンカチ/ハンケチ/
handle /ハンドル/
handlename /ハンドルネーム/
handler /ハンドラ/
handling /ハンドリング/
handmade /ハンドメイド/ハンドメード/
handoff /ハンドオフ/
handout /ハンドアウト/
handover /ハンドオーバー/
hands /ハンズ/
handsfree /ハンズフリー/
handshake /ハンドシェイク/
handsoap /ハンドソープ/
handsome /ハンサム/
handtowel /ハンドタオル;napkin/
handy /ハンディ/ハンディー/
handycam /ハンディカム;[商標]SONY. (<handy camera)/
hanes /ヘインズ/
hang /ハング/
hanger /ハンガー/
hanging /ハンギング/
hangingbasket /ハンギングバスケット/
hangman /ハングマン/
hangul /ハングル/
hangup /ハングアップ/
hank /ハンク/
hankel /ハンケル/
hanks /ハンクス/
hanna /ハンナ/
hannah /ハンナ/
hanne /ハンネ/
hannibal /ハンニバル/
hanning /ハニング/
hannon /ハノン/
hannover /ハノーバー;ドイツ/ハノーヴァー/
hanns /ハンス/
hanoch /エノク/
hanoi /ハノイ/
hans /ハンス/
hansa /ハンザ/
hanse /ハンザ;(独)/
hansel /ヘンゼル/
hansen /ハンセン/
hanson /ハンソン/
hanuman /ハヌマーン/ハヌマン/
happening /ハプニング/
happiness /ハピネス/ハッピネス/
happy /ハッピー/
happybirthday /ハッピーバースデー/ハッピーバースディ/
happyend /ハッピーエンド/
happymonday /ハッピーマンデー/
happytalking /ハッピートーキング/
harald /ハラルド/
haram /ハーレム/ハレム/
harappa /ハラッパ;パキスタン/ハラッパー/
harare /ハラレ/
harassment /ハラスメント/
harbor /ハーバー/
harbour /ハーバー/
hard /ハード/ハードウェア/
hardboiled /ハードボイルド/
hardbop /ハードバップ/
hardcase /ハードケース/
hardcoat /ハードコート/
hardcode /ハードコード/
hardcontact /ハードコンタクト;hard contact lens/
hardcontactlens /ハードコンタクトレンズ/
hardcopy /ハードコピー/
hardcore /ハードコア/
hardcover /ハードカバー/
harddisk /ハードディスク/
harddiskdrive /ハードディスクドライブ;HDD/
hardgay /ハードゲイ/
hardhit /ハードヒット/
hardhitter /ハードヒッター/
hardlanding /ハードランディング/
hardle /ハードル;※hurdle/
hardlens /ハードレンズ;hard lens/
hardlink /ハードリンク/
hardliquor /ハードリカー/
hardluck /ハードラック/
hardoff /ハードオフ;www.hardoff.co.jp/
hardrock /ハードロック/
hardschedule /ハードスケジュール;和製英語(tight schedule)/
hardsf /ハードSF/
hardsm /ハードSM/
hardtop /ハードトップ/
hardware /ハードウェア/ハードウエア/
hardwiring /ハードワイアリング/
hardy /ハーディー/ハーディ/
harem /ハーレム;英語綴り/ハレム/
hargreaves /ハーグリーブス/ハーグリーブズ/
harijan /ハリジャン/
harim /ハーレム/ハレム/
harlan /ハーラン/
harlem /ハーレム;NYの./
harlequin /ハーレクイン/
harley /ハーレー/ハーリー/ハーレイ/
harleydavidson /ハーレーダビッドソン;Harley-Davidson/
harmagedon /ハルマゲドン/
harmonia /ハルモニア/ハーモニア/
harmonic /ハーモニック/
harmonica /ハーモニカ/
harmonics /ハーモニクス/ハーモニックス/
harmonious /ハーモニアス/
harmonisation /ハーモナイゼーション/
harmonise /ハーモナイズ/
harmonium /ハルモニウム/
harmonization /ハーモナイゼーション/
harmonize /ハーモナイズ/
harmony /ハーモニー/
harness /ハーネス/
harnoncourt /アーノンクール/
harold /ハロルド/
harp /ハープ/
harper /ハーパー/
harpsichord /ハープシコード/
harpy /ハーピー/ハルピュイア/
harrier /ハリヤー/ハリアー/
harriet /ハリエット/
harris /ハリス/
harrison /ハリスン/ハリソン/
harrop /ハロップ/
harry /ハリー/
harrypotter /ハリーポッター;Harry Potter/
harte /ハート/
hartley /ハートレイ/ハートリー/ハートレー/
hartmann /ハルトマン/ハートマン/
hartree /ハートリー/
harty /ハーティ/ハーティー/
harvard /ハーバード/
harvest /ハーベスト/ハーヴェスト/
harvester /ハーベスター/ハーベスタ/
harvey /ハービー/ハーベイ/ハーヴェイ/ハーヴィー/
has /ハズ/
hash /ハッシュ/
hashed /ハッシュド/
hashedbeef /ハッシュドビーフ/
hashish /ハシシ/ハシシュ/
hashtable /ハッシュテーブル/
hassan /ハッサン/
haste /ヘイスト/
hat /ハット/
hatch /ハッチ/
hatchback /ハッチバック/
hatching /ハッチング/
hatckback /ハッチバック/
hate /ヘイト/
hathaway /ハサウェイ/ハザウェイ/
hattie /ハッティ/
hattrick /ハットトリック/
hauptmann /ハウプトマン/
hauser /ハウザー/
haut /オー;(Fr) 高い/
hautbrion /オーブリオン;Haut Brion/
hautecouture /オートクチュール;(Fr)haute couture/
hautmedoc /オーメドック;Haut Medoc/
havana /ハバナ/
have /ハブ/ハヴ/
haven /ヘイブン/ヘイヴン/
hawaii /ハワイ/
hawaiian /ハワイアン/
hawes /ホーズ/
hawk /ホーク/
hawking /ホーキング/
hawkins /ホーキンス/
hawks /ホークス/
hawley /ホーリー/
haws /ホーズ/
hayden /ハイデン/ヘイドン/
haydn /ハイドン/
haydon /ヘイドン/
hayek /ハイエク/
hayes /ヘイズ/
hayley /ヘイリー/
haynes /ヘインズ/ハイネス/
hazard /ハザード/
hazardlamp /ハザードランプ/
hazardmap /ハザードマップ/
hazel /ヘーゼル/ヘイゼル/
hazelnut /ヘーゼルナッツ/
hcup /Hカップ;27.5cm/Ｈカップ/
hd /ハードディスク/
hddrecorder /HDDレコーダー/
he /ヒー/ヘリウム/Helium/
head /ヘッド/
headbutt /ヘッドバット/
headcoach /ヘッドコーチ/
headdress /ヘッドドレス/
header /ヘッダ/ヘッダー/
headerfile /ヘッダファイル/ヘッダーファイル/
headgear /ヘッドギア/
headhunt /ヘッドハント/
headhunter /ヘッドハンター/
headhunting /ヘッドハンティング/
heading /ヘディング/ヘッディング/
headlamp /ヘッドランプ/
headlight /ヘッドライト/
headline /ヘッドライン/
headphone /ヘッドホン/ヘッドフォン/
headquarter /ヘッドクォーター/ヘッドクオーター/
headset /ヘッドセット/
headsliding /ヘッドスライディング;和製英語(headfirst sliding)/
heal /ヒール/
healer /ヒーラー/
healing /ヒーリング/
health /ヘルス/
healthcare /ヘルスケア/
healthcheck /ヘルスチェック/
healthmeter /ヘルスメーター;和製英語/
healthy /ヘルシー/
heap /ヒープ/
hear /ヒア/
hearing /ヒアリング/
hearn /ハーン/
heart /ハート/ハツ/
heartbeat /ハートビート/
heartbreak /ハートブレイク/
heartful /ハートフル/
hearth /ハース/
heartland /ハートランド/
heartmark /ハートマーク/
hearts /ハーツ/
hearty /ハーティー/ハーティ/
heat /ヒート/
heater /ヒーター/
heath /ヒース/
heather /ヘザー/
heathrow /ヒースロー;イギリス(lhr)/
heatisland /ヒートアイランド/
heatpipe /ヒートパイプ/
heatpump /ヒートポンプ/
heatsink /ヒートシンク/
heatup /ヒートアップ/
heaven /ヘブン/ヘヴン/
heavenly /ヘブンリー/
heavy /ヘビー/ヘヴィ/ヘヴィー/
heavyduty /ヘビーデューティー/
heavymetal /ヘビーメタル/ヘヴィメタル/ヘビメタ/ヘヴィメタ/
heavysmoker /ヘビースモーカー/
heavyuser /ヘビーユーザー/ヘビーユーザ/
hebe /ヘーベ/ヘベ/ヘーベー/
hebrew /ヘブライ/
heckel /ヘッケル/
hecta /ヘクタ;100/
hectare /ヘクタール;10000m^2/
hecto /ヘクト;[SI接頭語]h,10^2/
hectopascal /ヘクトパスカル;hPa/
hector /ヘクター/ヘクトル/ヘクトール/エクトル/
hedda /ヘッダ/
hedge /ヘッジ/
hedgefund /ヘッジファンド/
hedgehog /ヘッジホッグ/
hedi /エディ/
heel /ヒール/
hegel /ヘーゲル/
heide /ハイデ/
heidegger /ハイデガー/ハイデッガー/
heidelberg /ハイデルベルク/
heiden /ハイデン/
heidfeld /ハイドフェルド/
heidi /ハイジ/ハイディ/ヘイディ/
heifetz /ハイフェッツ/
height /ハイト/高さ/
heights /ハイツ/
heike /ハイケ/
heil /ハイル;(独語)万歳/
heim /ハイム/
heimat /ハイマート;(独語)故郷/
hein /ハイン/
heine /ハイネ/
heineken /ハイネケン/
heiner /ハイナー/
heinlein /ハインライン/
heinrich /ハインリッヒ/ハインリヒ/
heintz /ハインツ/
heinz /ハインツ/ハインズ/
heisenberg /ハイゼンベルク/ハイゼンベルグ/
helen /ヘレン/
helena /ヘレナ/エレナ/
helene /ヘレネ/エレーヌ/
helga /ヘルガ/
helguera /エルゲラ/
heli /ヘリ;helicopter/
helical /ヘリカル/
helichrisum /ヘリクリサム/
helicopter /ヘリコプター/
helio /ヘリオ/
heliopolis /ヘリオポリス/
helios /ヘリオス/
heliotrope /ヘリオトロープ/
heliport /ヘリポート/
helium /ヘリウム/
helix /ヘリックス/
hell /ヘル/
hella /ヘラ/
hellas /ヘラス/
hellcat /ヘルキャット/
hellenism /ヘレニズム/
hello /ハロー/
hellokitty /ハローキティ;[商標]sanrio/
hellopage /ハローページ/
hellowork /ハローワーク;和製英語(job centre)/
helm /ヘルム/
helmet /ヘルメット/
helmholtz /ヘルムホルツ/
helmut /ヘルムート/
helmuth /ヘルムート/
heloise /エロイーズ/
help /ヘルプ/
helpdesk /ヘルプデスク/
helper /ヘルパー/ヘルパ/
helpfile /ヘルプファイル/
helpsystem /ヘルプシステム/
helsinki /ヘルシンキ/
hematite /ヘマタイト/
heme /ヘム/
hemi /ヘミ/
hemingway /ヘミングウェイ/ヘミングウェー/
hemming /ヘミング/
hemoglobin /ヘモグロビン/
hemp /ヘンプ/
hen /ヘン/
hendel /ヘンデル/
henderson /ヘンダーソン/
hendricks /ヘンドリックス/ヘンドリクス/
hendrik /ヘンドリック/
hendrix /ヘンドリックス/ヘンドリクス/
henkel /ヘンケル/
henley /ヘンリー/
henleyneck /ヘンリーネック/
hennessy /ヘネシー/
henning /ヘニング/
henri /アンリ/ヘンリ/
henrietta /ヘンリエッタ/
henriette /アンリエット/ヘンリエッテ/
henrik /ヘンリク/ヘンリック/
henrique /エンリケ/
henry /ヘンリー/アンリ/ヘンリ/
heparin /ヘパリン/
hepburn /ヘップバーン/ヘプバーン/ヘボン/
hephaistos /ヘパイストス/ヘファイストス/
hepta /ヘプタ;7/
heptane /ヘプタン;C7H16/
her /ハー/
hera /ヘラ/
herakleitos /ヘラクレイトス/
herakles /ヘラクレス/
herald /ヘラルド/
herat /ヘラート/
herb /ハーブ/
herbal /ハーバル/
herbert /ヘルベルト/ハーバート/
herbie /ハービー/
herboil /ハーブオイル/
herbrand /エルブラン/
herbtea /ハーブティー/ハーブティ/
hercegovina /ヘルツェゴビナ/ヘルツェゴヴィナ/
hercule /エルキュール/
hercules /ヘラクレス/
here /ヒア/
heredocument /ヒアドキュメント/
herend /ヘレンド/
heritage /ヘリテージ/
herman /ヘルマン/エルマン/ハーマン/
hermann /ヘルマン/ハーマン/
hermes /エルメス/ヘルメス/ヘルメース/
hermione /ハーマイオニー/ヘルミオネ/
hermit /ハーミット/エルミット;?/
hermite /エルミート/
hernandez /ヘルナンデス/エルナンデス/
hernando /ヘルナンド/
hernia /ヘルニア/
hero /ヒーロー/
herod /ヘロデ/
herodes /ヘロデ/ヘロデス/
herodotos /ヘロドトス/
heroes /ヒーローズ/
heroic /ヒロイック/
heroin /ヘロイン/
heroine /ヒロイン/
herointerview /ヒーローインタビュー/
heroism /ヒロイズム/
heron /ヘロン/
herpes /ヘルペス/
herrmann /ハーマン/ヘルマン/
hers /ハーズ/
hershey /ハーシー/
hertha /ヘルタ/
hertz /ヘルツ/
herve /エルヴェ/
herzegovina /ヘルツェゴビナ/
herzog /ヘルツォーク/
hesiodos /ヘシオドス/
hesse /ヘッセ/
hessen /ヘッセン/
hestia /ヘスティア/
hetero /ヘテロ/ヘテロジニアス/
heterodyne /ヘテロダイン/
heterogeneous /ヘテロジニアス/
heterosexual /ヘテロセクシャル/ヘテロセクシュアル/
heuer /ホイヤー/
heuristic /ヒューリスティック/
heuristics /ヒューリスティクス/
hewlett /ヒューレット/
hewlettpackard /ヒューレットパッカード;www.hp.com/
hex /ヘックス/十六進数/
hexa /ヘキサ;6/ヘクサ/
hexagon /ヘキサゴン;六角形/
hexane /ヘキサン;C6H14/
hexard /ヘキサード;www.hexard.co.jp/
hey /ヘイ/
heyden /ハイデン/
heydon /ヘイドン/
hf /ハフニウム/Hafnium/
hg /水銀/Mercury/
hi /ハイ/Hawaii/ハワイ/
hi8 /Ｈｉ８/
hiace /ハイエース;[商標]トヨタ/
hiband /ＨｉＢａｎｄ/
hibernation /ハイバネーション/
hibiscus /ハイビスカス/
hickory /ヒッコリー/
hicks /ヒックス/
hidalgo /イダルゴ/
hidden /ヒドゥン/
hide /ハイド/非表示/
hiding /ハイディング/
hierarchie /ヒエラルヒー;(独語)/
hierarchy /ヒエラルキー/ハイアラーキー/
hieroglyph /ヒエログリフ/
hieronymus /ヒエロニムス/
hierro /イエロ/
hifi /ハイファイ;hi-fi/
higgins /ヒギンズ/
higgs /ヒッグス/
high /ハイ/
highball /ハイボール/
highcalorie /ハイカロリー/
highclass /ハイクラス/
highcost /ハイコスト/
highend /ハイエンド/
highgrade /ハイグレード/
highhat /ハイハット/
highheels /ハイヒール/
highjack /ハイジャック/
highjacker /ハイジャッカー/
highjump /ハイジャンプ/
highkey /ハイキー;high key/
highkick /ハイキック/
highland /ハイランド/
highleg /ハイレグ;high-leg/
highlevel /ハイレベル/
highlight /ハイライト/
highneck /ハイネック/
highness /ハイネス/
highnote /ハイノート/
highoc /ハイオク;high-octan/
highpace /ハイペース/
highpass /ハイパス/
highperformance /ハイパフォーマンス/
highpitch /ハイピッチ/
highpower /ハイパワー/
highquality /ハイクオリティ/
highreso /ハイレゾ;high resolution/
highreturn /ハイリターン/
highrisk /ハイリスク/
highschool /ハイスクール/
highscore /ハイスコア/
highseason /ハイシーズン/
highsense /ハイセンス/
highso /ハイソ;high society, high sox/
highsociety /ハイソサエティ/ハイソサエティー/ハイソ/
highsocks /ハイソックス/
highsox /ハイソックス;high socks/
highspec /ハイスペック/
highspeed /ハイスピード/
hightech /ハイテク;high technology/
hightechnology /ハイテクノロジー/
highteen /ハイティーン/
hightempo /ハイテンポ/
hightension /ハイテンション/
hightom /ハイタム/
hightone /ハイトーン/
hightouch /ハイタッチ/
highvision /ハイビジョン/
highway /ハイウェイ/ハイウェー/
highwaybus /ハイウェイバス/
highwaycard /ハイウェイカード/
hihat /ハイハット/
hiho /ハイホー/
hijack /ハイジャック/
hijacker /ハイジャッカー/
hijrah /ヒジュラ/
hike /ハイク/
hiker /ハイカー/
hiking /ハイキング/
hilaire /イレール/
hilary /ヒラリー/
hilbert /ヒルベルト/
hilda /ヒルダ/
hilde /ヒルデ/
hilevel /ハイレベル/
hilight /ハイライト/
hilite /ハイライト/
hill /ヒル/
hillary /ヒラリー/
hillbilly /ヒルビリー/
hillman /ヒルマン/
hills /ヒルズ/
hilltop /ヒルトップ/
hilton /ヒルトン/
him /ヒム/
himalaya /ヒマラヤ/
himalayan /ヒマラヤン;猫/
himmler /ヒムラー/
hindemith /ヒンデミット/
hindi /ヒンディ/ヒンディー/
hindu /ヒンズー/ヒンドゥー/ヒンドゥ/
hinge /ヒンジ/
hingis /ヒンギス/
hint /ヒント/
hip /ヒップ/
hiphop /ヒップホップ/
hipline /ヒップライン/
hipp /ヒップ/
hippie /ヒッピー/
hippocket /ヒップポケット/
hippocrates /ヒポクラテス/
hippokrates /ヒポクラテス/
hipsize /ヒップサイズ/
hipup /ヒップアップ;和製英語/
hiram /ハイラム/ヒラム/
hire /ハイヤー/ハイア/
hireso /ハイレゾ/
hirsch /ヒルシュ/
his /ヒズ/
hispania /イスパニア/
hispanic /ヒスパニック/
hiss /ヒス/
histamine /ヒスタミン/
histidine /ヒスチジン;His/
histogram /ヒストグラム/
histon /ヒストン/
history /ヒストリー/ヒストリ/
hit /ヒット/
hit&run /ヒットエンドラン;hit and run/
hitandrun /ヒットエンドラン/
hitch /ヒッチ/
hitchart /ヒットチャート/
hitchcock /ヒッチコック/
hitchhike /ヒッチハイク/
hitchhiker /ヒッチハイカー/
hitler /ヒトラー/ヒットラー/
hitman /ヒットマン/
hitnumber /ヒットナンバー/
hitom /ハイタム/
hitparade /ヒットパレード;hit parade/
hitpoint /ヒットポイント/
hits /ヒッツ/
hitsong /ヒットソング/
hitter /ヒッター/
hitting /ヒッティング/
hittite /ヒッタイト/
hivision /ハイビジョン/
hix /ヒックス/
hj /┐;vi式罫線入力/┓;太/
hjk /┤;vi式罫線入力/┫;太/┨;縦太/┥;横太/
hjkl /┼;vi式罫線入力/╋;太/┿;横太/╂;縦太/
hjl /┬;vi式罫線入力/┳;太/┯;横太/┰;縦太/
hk /┘;vi式罫線入力/┛;太/
hkl /┴;vi式罫線入力/┻;太/┷;横太/┸;縦太/
hl /─;vi式罫線入力/━;太/
ho /ホルミウム/Holmium/
hoare /ホーア/
hoax /ホークス/
hob /ホブ/
hobbes /ホッブズ/
hobbit /ホビット/Ｈｏｂｂｉｔ/
hobby /ホビー/
hobgoblin /ホブゴブリン/
hochiminh /ホーチミン;Ho Chi Minh/
hochst /ヘキスト/
hockey /ホッケー/
hodge /ホッジ/
hodges /ホッジス/
hoe /ホー/
hoffer /ホッファー/
hoffmann /ホフマン/
hofmann /ホフマン/
hofmannsthal /ホフマンスタール/
hog /ホッグ/
hogan /ホーガン/
hohl /ホール/
hoist /ホイスト/
hola /オラ/
holbein /ホルバイン/
hold /ホールド/
holden /ホールデン/
holder /ホルダー/ホルダ/
holderlin /ヘルダーリン/
holding /ホールディング/
holdings /ホールディングス/
hole /ホール/
holeinone /ホールインワン;hole-in-one/
holeout /ホールアウト/
holger /ホルガー/オルガー/
holi /ホーリー/
holiday /ホリデー/ホリデイ/ホリディ/
holland /オランダ/ホランド/
holly /ホーリー/ホリー/
hollywood /ハリウッド/
hollywoodstar /ハリウッドスター/
holm /ホルム/
holmes /ホームズ/
holmium /ホルミウム;[元素]67,Ho/
holocaust /ホロコースト/
hologram /ホログラム/
holographic /ホログラフィック/
holography /ホログラフィ/ホログラフィー/
holon /ホロン/
hols /ホルス/
holst /ホルスト/
holstein /ホルスタイン/
holster /ホルスター/
holy /ホーリー/
holyname /ホーリーネーム/
home /ホーム/
homebakery /ホームベーカリー;和製英語(home baking)/
homebase /ホームベース/
homecenter /ホームセンター;和製英語/
homecentre /ホームセンター;和製英語/
homeconcert /ホームコンサート/
homedir /ホームディレクトリ/
homedirectory /ホームディレクトリ/
homedoctor /ホームドクター;和製英語(family doctor)/
homedrama /ホームドラマ;和製英語(domestic drama)/
homegame /ホームゲーム/
homeground /ホームグラウンド/
homehelp /ホームヘルプ/
homehelper /ホームヘルパー/
homein /ホームイン/
homeland /ホームランド/
homeless /ホームレス/
homemade /ホームメイド/ホームメード/
homeoffice /ホームオフィス/
homeopathy /ホメオパシー/
homeostasis /ホメオスタシス/
homepage /ホームページ/
homepageaddress /ホームページアドレス/
homeparty /ホームパーティ/ホームパーティー/
homeplate /ホームプレート/
homeposition /ホームポジション/
homer /ホーマー/
homeroom /ホームルーム/
homeros /ホメロス/
homerun /ホームラン/
homesick /ホームシック/
homestay /ホームステイ/
homesteal /ホームスチール;和製英語(steal home)/
hometeam /ホームチーム/
hometheater /ホームシアター/
hometheatre /ホームシアター/
hometown /ホームタウン/
hometrade /ホームトレード/
homework /ホームワーク/
homing /ホーミング/
hommage /オマージュ;仏語/
homo /ホモ/
homocystein /ホモシステイン/
homology /ホモロジー/
homosapiens /ホモサピエンス/
homosexual /ホモセクシャル/ホモセクシュアル/ホモ/
homunculus /ホムンクルス/
homunkulus /ホムンクルス/
honda /ホンダ/
honduras /ホンジュラス;.hn/
honegger /オネゲル/
honest /アーネスト/オネスト/アネスト/
honesty /オネスティ/
honey /ハニー/
honeybee /ハニービー/
honeycomb /ハニカム/
honeymoon /ハネムーン/
honeypie /ハニーパイ/
honeypot /ハニーポット/
honfleur /オンフルール/
hongkong /ホンコン/香港/
honiara /ホニアラ/
honkytonk /ホンキートンク;honky-tonk/
honolulu /ホノルル/
honor /オナー/
honore /オノレ/
hood /フッド/
hook /フック/ホック/
hooke /フック;(1635-1703) Robert Hooke/
hooker /フッカー/
hooking /フッキング/
hooligan /フーリガン/
hoop /フープ/
hoover /フーバー/フーヴァー/
hop /ホップ/
hope /ホープ/
hopeful /ホープフル/
hopkin /ホプキン/
hopkins /ホプキンス/
hopper /ホッパー/
hopping /ホッピング/
hoppy /ホッピー/
hopstepjump /ホップステップジャンプ/
horace /ホレス/ホリス/
horatio /ホレイショ/ホレイショー/ホレーショー/
horece /ホレス/
horizon /ホライズン/
horizont /ホリゾント/
horizontal /ホリゾンタル/水平/水平方向/
hormon /ホルモン;(独語)/
hormone /ホルモン/
hormonebalance /ホルモンバランス/
horn /ホーン/ホルン/
hornet /ホーネット;雀蜂/
hornfels /ホルンフェルス/
horoscope /ホロスコープ/
horowitz /ホロヴィッツ/
horror /ホラー/
horsdoeuvre /オードブル;hors-d'oeuvre/
horse /ホース/
horseradish /ホースラディッシュ/
horst /ホルスト/
horus /ホルス/
hose /ホース/
hosea /ホセア/
hoshi /☆/★/
hospice /ホスピス/
hospital /ホスピタル/
hospitality /ホスピタリティ/ホスピタリティー/
host /ホスト/
hostaddress /ホストアドレス/
hostclub /ホストクラブ/
hostcomputer /ホストコンピュータ/
hostdata /ホストデータ/
hostel /ホステル/
hostess /ホステス/
hosting /ホスティング/
hostingservice /ホスティングサービス/
hostname /ホストネーム/ホスト名/
hostroute /ホストルート/
hot /ホット/
hotcake /ホットケーキ/
hotcakemix /ホットケーキミックス;和製英語(pancake mix)/
hotcarpet /ホットカーペット;和製英語(electric carpet)/
hotchkiss /ホッチキス;=stapler/
hotcoffee /ホットコーヒー/
hotcorner /ホットコーナー/
hotdog /ホットドッグ/
hotdrink /ホットドリンク/
hotel /ホテル/オテル;仏語/
hotelman /ホテルマン/
hotels /ホテルズ/
hotkey /ホットキー/
hotline /ホットライン/
hotlist /ホットリスト/
hotmail /ホットメール;MSN/
hotmilk /ホットミルク/
hotnews /ホットニュース/
hotpants /ホットパンツ/
hotplate /ホットプレート/ホット・プレート/
hotplug /ホットプラグ/
hotsalad /ホットサラダ/
hotsand /ホットサンド/
hotspot /ホットスポット/
hotswap /ホットスワップ/
hottentot /ホッテントット/
houdunit /ハウダニット/How done it?/
hough /ハフ/
hound /ハウンド/
hour /アワー/
hours /アワーズ/
house /ハウス/
housecleaning /ハウスクリーニング/
housedust /ハウスダスト/
household /ハウスホールド/
housekeeper /ハウスキーパー/
housekeeping /ハウスキーピング/
housemaker /ハウスメーカー/
housemannequin /ハウスマヌカン;和製語/
housemusic /ハウスミュージック/
housewine /ハウスワイン/
housing /ハウジング/
houston /ヒューストン/
hover /ホバー/フーバー;人名/
hovercraft /ホバークラフト/
hovering /ホバリング/
how /ハウ/
howard /ハワード/
howell /ハウエル/
howl /ハウル/
howling /ハウリング/
howlite /ハウライト/
howto /ハウツー/
hp /ヒューレット・パッカード;Hewlett-Packard/ホームページ;homepage/HP/
hpaddr /ホームページアドレス/HPアドレス/
hpaddress /ホームページアドレス/HPアドレス/
hpf /ハイパスフィルタ/
hr /ホルン/
hs /ハッシウム/Hassium/
htmlfile /HTMLファイル/
httpserver /HTTPサーバ/
hub /ハブ/
hubbard /ハバード/
hubble /ハッブル/
huber /フーバー/ユベール/
hubert /ユベール/ヒューバート/
huck /ハック/
huckleberry /ハックルベリー/
hudson /ハドソン/波怒村/
hue /フエ/色調/ユー/
huffman /ハフマン/
hug /ハグ/
huge /ヒュージ/
hugh /ヒュー/
hughes /ヒューズ/
hughie /ヒューイ/
hugo /ユゴー/ユーゴー/ヒューゴー/ヒューゴ/フーゴ/ウーゴ/
huguenot /ユグノー/
hugues /ユーグ/
huhhot /フフホト;中国/呼和浩特/
huizinga /ホイジンガ/
hula /フラ/
huladance /フラダンス/
hulagirl /フラガール/
hull /ハル/
hullnote /ハルノート;(1941)Hull Note/
human /ヒューマン/
humanerror /ヒューマンエラー/
humanism /ヒューマニズム/
humanisme /ユマニスム/
humanist /ヒューマニスト/
humaniste /ユマニスト/
humanite /ユマニテ;仏語/
humanity /ヒューマニティ/ヒューマニティー/
humanlike /ヒューマンライク/
humanoid /ヒューマノイド/
humanskill /ヒューマンスキル;和製英語/
humbert /アンベール/ハンバート/フンベルト/
humble /ハンブル/
humboldt /フンボルト/
hume /ヒューム/
hummel /フンメル/
hummer /ハマー;GM/
humming /ハミング/
hummingbird /ハミングバード/
humor /ユーモア/
humoresque /ユーモレスク/
humorous /ユーモラス/
humour /ユーモア/
humphrey /ハンフリー/
humpty /ハンプティ/ハンプティー/
humptydumpty /ハンプティダンプティ/
hundred /ハンドレッド/
hung /ハング/
hungarian /ハンガリアン/
hungary /ハンガリー;.hu/
hungarygp /ハンガリーGP;[F1]/
hungerstrike /ハンガーストライキ/ハンスト/
hungry /ハングリー/
hungup /ハングアップ/
hunk /ハンク/
hunt /ハント/
hunter /ハンター/
hunting /ハンティング/ハンチング;-帽/
huntingworld /ハンティングワールド;www.huntingworld.com/
huppert /ユペール/
hurd /Hurd/
hurdle /ハードル/
hurdygurdy /ハーディガーディ/
hurley /ハーレー/ハーリー/ハーレイ/
huron /ヒューロン/
hurrah /フレー/
hurricane /ハリケーン/
hurry /ハリー/
hus /ハズ/
husband /ハズバンド/
hush /ハッシュ/
husky /ハスキー/
huskyvioce /ハスキーボイス/
hussain /フセイン/
husserl /フッサール/
hustle /ハッスル/
hustler /ハスラー/
huston /ヒューストン;人名/
hut /ハット;小屋/
hutte /ヒュッテ/
huxley /ハクスリー/ハクスレー/ハックスレー/ハックスリ/
huygens /ホイヘンス/
huysmans /ユイスマンス/
hyacinth /ヒヤシンス/ヒアシンス/
hyades /ヒアデス/
hyaena /ハイエナ/
hyatt /ハイアット/
hybrid /ハイブリッド/
hybridcar /ハイブリッドカー/
hyde /ハイド/
hydepark /ハイドパーク;Hyde Park, London/
hyderabad /ハイデラバード/
hydra /ヒドラ/ヒュドラ/
hydrate /ハイドレート/
hydrazine /ヒドラジン;N2H4/
hydride /ハイドライド;水素化/
hydro /ハイドロ/ヒドロ/
hydrogen /ハイドロジェン;H/
hydroquinone /ハイドロキノン;C6H4(OH)2/ヒドロキノン/
hydroxy /ヒドロキシ;-OH/ハイドロキシ/
hymn /ヒム/
hyper /ハイパー/
hypercard /ハイパーカード/
hypercube /ハイパーキューブ/
hyperion /ハイペリオン/ヒペリオン/ヒュペリオン/
hyperlink /ハイパーリンク/
hypermedia /ハイパーメディア/
hypertext /ハイパーテキスト/
hyperthreading /ハイパースレッディング/
hyphen /ハイフン/‐/
hyphenation /ハイフネーション/
hypnosis /ヒプノシス/
hypnotherapy /ヒプノセラピー;催眠療法/
hypo /ハイポ/
hyrax /ハイラックス/
hysteresis /ヒステリシス/
hysteria /ヒステリー/
hysteric /ヒステリック/
hysterie /ヒステリー/
hyundai /ヒュンダイ;www.hyundai-motor.com/現代/
hz /ヘルツ/Ｈｚ/
i /ι;iota/アイ/и;cyrillic/ヨウ素/Iodine/私/
i'm /アイム/
i-kratkoje /й;cyrillic/
i/o /Ｉ／Ｏ/
ia /Iowa/アイオワ/
iain /イアン/
iam /アイアム;I am/アイ・アム/
ian /イアン/ヤン/
iappli /iアプリ/
ib /イヴ/
iban /イバン/
iberia /イベリア/
iberis /イベリス/
ibex /アイベックス/
ibm /インターナショナル・ビジネス・マシーンズ・コーポレーション/アイ・ビー・エム/
ibmpc /ＩＢＭ-ＰＣ/
ibn /イブン/
ibrahim /イブラヒム/
ibuprofen /イブプロフェン;C13H18O2/
icarus /イカルス;(英綴)/イカロス/
iccard /ICカード/
icchip /ICチップ/
ice /アイス/インサーキットエミュレーター;in-circuit emulator/氷/
icebar /アイスバー/
iceberg /アイスバーグ/
icebox /アイスボックス/
icecap /アイスキャップ/
icecoffee /アイスコーヒー/
icecream /アイスクリーム/
icecube /アイスキューブ/
icedance /アイスダンス/
icehockey /アイスホッケー/
iceland /アイスランド;.is/
icemilk /アイスミルク/
icenon /アイスノン;[商標]白元/
icepail /アイスペール/
icepick /アイスピック/
icerink /アイスリンク/
icetea /アイスティー/アイスティ/
icewine /アイスワイン/
ich /イッヒ/
icing /アイシング/
icon /アイコン/
iconic /アイコン化;?/
iconify /アイコニファイ/
ictag /ICタグ/
icup /Iカップ;30cm/Ｉカップ/
icy /アイシー/
id /イド;[精医]/アイディー/識別子/Idaho/アイダホ/
ida /イダ/アイダ/イーダ/
idaho /アイダホ;ID/
idcard /IDカード/
ide /アイド/
idea /アイデア/アイディア/イデア;ιδεα/
ideal /イデアル/アイデアル/
ideaman /アイデアマン/
idecable /IDEケーブル/
idecontroller /IDEコントローラ/
idedevice /IDEデバイス/
idedrive /IDEドライブ/
idee /イデー/
identifier /アイデンティファイア/識別子/
identify /アイデンティファイ/
identity /アイデンティティ/アイデンティティー/
ideologie /イデオロギー/
ideologue /イデオローグ/
ideology /イデオロギー/
idic /Ｉ-ｄｉｃ/
idiom /イディオム/
idiomatic /イディオマティック/
idiot /イディオット/
idle /アイドル/
idletime /アイドルタイム/
idling /アイドリング/
idol /アイドル/
idola /イドラ/
if /イフ/インターフェース/インタフェース/
iff /必要十分条件;if and only if/⊃⊂/<==>/
iglesias /イグレシアス/
igloo /イグルー/
ignacio /イグナチオ/イグナシオ/
ignite /イグナイト/
ignition /イグニッション/
ignitor /イグナイター/イグナイタ/
ignore /イグノア/
igor /イーゴリ/イゴール/イーゴル/
iguana /イグアナ/
iguanodon /イグアノドン/
iguazu /イグアス/
ihatov /イーハトーブ;(賢治)/イーハトーヴ/
ikaros /イカロス/イカルス/
ikra /イクラ;икра/
il /Illinois/イリノイ/イル/
ilia /イリヤ/
ilias /イリアス/イーリアス/
ill /イル/
illegal /イリーガル/
illich /イリイチ/
illinois /イリノイ/
illumination /イルミネーション/イリュミナシオン;仏語/イリュミネイション;<rare>/
illusion /イリュージョン/
illust /イラスト/
illustration /イラストレーション/
illustrator /イラストレーター/イラストレータ/
ilmari /イルマリ/
ilove /アイラブ;I love/アイ・ラブ・/
iloveyou /アイラブユー;I love you/
ilse /イルゼ/
ilya /イリヤ/イリア/
ilyich /イリイチ/
im /イン/
imac /iMac;[商標]アップル/アイマック/
image /イメージ/イマージュ;仏語/
imagealbum /イメージアルバム/
imagechange /イメージチェンジ;和製英語/
imagecharacter /イメージキャラクター/
imagedown /イメージダウン;和製英語/
imagefile /イメージファイル/
imagegirl /イメージガール/
imageillust /イメージイラスト/
imagemap /イメージマップ/
imagescanner /イメージスキャナ/
imagesensor /イメージセンサ/イメージセンサー/
imagesong /イメージソング/
imagetraining /イメージトレーニング/
imageup /イメージアップ;和製英語/
imagevideo /イメージビデオ/
imagewindow /イメージウィンドウ/イメージウインドー;<rare>/
imaginary /イマジナリー/
imagination /イマジネーション/
imaging /イメージング/
imago /イマーゴ/
imam /イマーム/イマム/
imbalance /インバランス/
imelda /イメルダ/
imidazole /イミダゾール/
imido /イミド/
imine /イミン/
imitation /イミテーション/
immanuel /イマニュエル/イマヌエル/
immigration /イミグレーション/
immoral /インモラル/
imode /iモード/
imp /インプ/⊃/
impact /インパクト/
impala /インパラ/
impedance /インピーダンス/
imperial /インペリアル/
imphal /インパール/
implant /インプラント/
implement /インプリメント/
implementation /インプリメンテーション/インプリメンテイション/
implementor /インプリメンタ/
implication /インプリケーション/⊃/
implied /⊂/
implies /→/⇒/⊃/ならば/
imply /⊃/→/
impo /インポ;impotenz/
import /インポート/
importer /インポーター/
impose /インポーズ/
impossible /インポッシブル/インポシブル/
impotence /インポテンス/
impotent /インポテンツ/
impotenz /インポテンツ;(独語)/
impre /インプレ;impression/
impress /インプレス/
impression /インプレッション/
impressive /インプレッシブ/
impreza /インプレッサ;[商標]スバル/
imprint /インプリント/
imprinting /インプリンティング/
impro /インプロ;improvisation/
impromptu /アンプロンプチュ/アンプロンプテュ/即興曲/
improvisation /インプロヴィゼーション/インプロビゼーション/インプロ/
improviser /インプロヴァイザー/インプロバイザー/
impulse /インパルス/
in /イン/∈/インチ/Indiana/インディアナ/インジウム/Indium/
ina /アイナ/
inactive /インアクティブ/
inari /イナリ/
inax /イナックス;www.inax.co.jp/
inbal /インバル/
inbound /インバウンド/
inc /Ｉｎｃ．/
incense /インセンス/
incentive /インセンティブ/
incest /インセスト/
inch /インチ/吋/
incident /インシデント/
incite /インサイト/
include /インクルード/∈/∋/
inclusion /インクルージョン/
inclusive /インクルーシブ/
income /インカム/
incomegain /インカムゲイン;income gain/
incourse /インコース;和製英語(inside)/
incredible /インクレディブル/
increment /インクリメント/
incremental /インクリメンタル/
incrementalsearch /インクリメンタルサーチ/
incubate /インキュベート/
incubation /インキュベーション/
incubator /インキュベータ/インキュベーター/
incubus /インキュバス/
inden /インデン/
indent /インデント/
indentation /インデンテーション/インデンテイション/字下げ/
independant /アンデパンダン;仏語/
independence /インデペンデンス/インディペンデンス/
independent /インディペンデント/
index /インデックス/インデクス/
indexation /インデクセーション/
indexer /インデクサ/インデクサー/
indexing /インデクシング/
indexmode /インデックスモード/
indi /インディ/インディー/
india /インディア/インド;.in/
indian /インディアン/
indiana /インディアナ;IN/
indianapolis /インディアナポリス/
indians /インディアンズ;[MLB]/
indica /インディカ/
indication /インディケーション/
indicator /インジケータ/インジケーター/インディケーター/インディケータ/
indicial /インディシャル/
indies /インディーズ/
indigo /インディゴ/
indigoblue /インディゴブルー/
indio /インディオ/
indirect /インダイレクト/
indium /インジウム;[元素]49,In/
individual /インディヴィジュアル/インディビジュアル/
indo /インド/印度/
indochina /インドシナ/
indole /インドール/
indomethacin /インドメタシン;C19H16ClNO4/
indonesia /インドネシア;.id/
indoor /インドア/
indra /インドラ/
inductance /インダクタンス/
induction /インダクション/帰納法/
indus /インダス/
industrial /インダストリアル/
industries /インダストリーズ/
industry /インダストリー/インダストリ/
indy /インディ/インディー/
ines /イネス/アイネス/
infant /インファント/
inferior /インフェリア/
inferno /インフェルノ/
infield /インフィールド/
infight /インファイト/
infinite /インフィニット/
infinity /インフィニティ/インフィニティー/∞/
infla /インフレ;inflation/
inflation /インフレーション/インフレ/
inflationary /インフレーショナリ/インフレ/
influence /インフルエンス/
influenza /インフルエンザ/
influenzavirus /インフルエンザウイルス/
info /インフォ/
inform /インフォーム/
informal /インフォーマル/
informant /インフォーマント/
informatic /インフォマティック/
informatics /インフォマティクス/インフォマティックス/
information /インフォメーション/情報/
informationcenter /インフォメーションセンター/
informationcentre /インフォメーションセンター/
informatique /アンフォルマティーク/
informed /インフォームド/
informedconsent /インフォームドコンセント/
informel /アンフォルメル/
informercial /インフォマーシャル;information + commercial/
infoseek /インフォシーク;www.infoseek.com/
infra /インフラ/
infrastructure /インフラストラクチャ/インフラストラクチャー/インフラ/
infusion /インフュージョン/
ing /イング/
inge /インゲ/
inglez /イギリス/
ingo /インゴ/
ingoal /インゴール/
ingot /インゴット/
ingram /イングラム/
ingrid /イングリッド/
inheritance /インヘリタンス/
inhigh /インハイ;[野球]和製英語(inside high)/
inhouse /インハウス/
iniesta /イニエスタ/
initial /イニシャル/
initialise /イニシャライズ/
initialize /イニシャライズ/
initiative /イニシアティブ/イニシアチブ/
initiator /イニシエータ/
injection /インジェクション/
injector /インジェクター/
ink /インク/インキ/
inka /インカ/
inkcartridge /インクカートリッジ/
inkjet /インクジェット/
inkjetprinter /インクジェットプリンタ/インクジェットプリンター/
inkribbon /インクリボン/
inlane /インレーン/
inlay /インレー/インレイ/
inline /インライン/
inlineframe /インラインフレーム/
inlineskate /インラインスケート/
inlining /インライニング/
inlow /インロー;[野球]和製英語(inside low)/
inn /イン/
inna /インナ/
inner /インナー/
innercity /インナーシティ/
innerspace /インナースペース/
innerwear /インナーウェア/
innerworld /インナーワールド/
innes /イネス/アイネス/イニス/
inning /イニング/
innocence /イノセンス/
innocent /イノセント/
innovation /イノベーション/
innovator /イノベーター/イノベータ/
innsbruck /インスブルック/
inode /iノード/ｉノード/
inositol /イノシトール/
inplay /インプレー;in play/インプレイ/
inprovisation /インプロヴァイゼィション;※improvisation?/
inpulse /インパルス/
input /インプット/入力/
inputmethod /インプットメソッド/
insect /インセクト/
insensitive /インセンシティブ/
insert /インサート/
insertion /インサーション/
inshallah /インシャラー/
inside /インサイド/
insideout /インサイドアウト/
insider /インサイダー/
insidework /インサイドワーク/
insight /インサイト/
insoft /インソフト/
insole /インソール/
inspection /インスペクション/
inspector /インスペクタ/インスペクター/
inspiration /インスピレーション/
inspire /インスパイア/
inst /インスト/
install /インストール/
installation /インスタレーション/インストレーション/
installer /インストーラ/インストーラー/
instance /インスタンス/
instant /インスタント/
instantcamera /インスタントカメラ/
instantcoffee /インスタントコーヒー/
instantiate /インスタンシエート/具体化/
institute /インスティテュート/インスティチュート/
institution /インスティテューション/
instore /インストア/
instorelive /インストアライブ/
instruction /インストラクション/
instructor /インストラクター/
instrument /インストゥルメント/インストルメント/インスツルメント/
instrumental /インストゥルメンタル/インストルメンタル/インスツルメンタル/
instruments /インスツルメンツ/
insufficient /不充分/不足/
insulation /インシュレーション/
insulator /インシュレーター/インシュレータ/
insulin /インスリン/インシュリン/
insulinoma /インスリノーマ/
insurance /インシュアランス/インシュランス/
int /∫/
integer /インテジャー/インテジャ/整数/
integra /インテグラ/
integral /インテグラル/∫/∬/
integrate /インテグレート/
integration /インテグレーション/
integrator /インテグレータ/インテグレーター/
integrin /インテグリン/
integrity /インテグリティ/完全/
intel /インテル/Intel/
intellectual /インテレクチュアル/
intelli /インテリ/
intelligence /インテリジェンス/
intelligent /インテリジェント/
intelligentsia /インテリゲンチャ/
intelligentzia /インテリゲンチャ/
intense /インテンス/
intensity /インテンシティ/
intensive /インテンシブ/
inter /インター/インタ/
interact /インタラクト/
interaction /インタラクション/インターアクション/
interactive /インタラクティブ/インタラクティヴ/
interactivity /インタラクティビティ/
interbank /インターバンク/
intercept /インターセプト/インタセプト/
interchange /インターチェンジ/
intercom /インターコム/
intercontinental /インターコンチネンタル/
interest /インタレスト/
interface /インターフェイス/インターフェース/インタフェース/インタフェイス/
interfaceboard /インターフェースボード/
interfere /インターフェア/
interferon /インターフェロン/
interhigh /インターハイ;和製英語(inter + high school)/
interior /インテリア/
interiorcoordinator /インテリアコーディネーター/
interiordesign /インテリアデザイン/
interiordesigner /インテリアデザイナー/
interiorshop /インテリアショップ/
interlace /インターレース/インタレース/
interlaken /インターラーケン/
interleave /インターリーブ/インタリーブ/
interleukin /インターロイキン/
interlock /インターロック/インタロック/
interlocking /インターロッキング/
interlude /インターリュード/インタリュード/
intermedia /インターメディア/
intermezzo /インテルメッツォ/
intermission /インターミッション/
intern /インターン/
internal /インターナル/
international /インターナショナル/
internet /インターネット/インタネット/Ｉｎｔｅｒｎｅｔ/
internetbanking /インターネットバンキング/
internetcafe /インターネットカフェ/
internetexplorer /インターネットエクスプローラー/インターネットエクスプローラ/
internetserver /インターネットサーバ/
internetwork /インターネットワーク/
internetworking /インターネットワーキング/
internoise /インターノイズ/
internship /インターンシップ/
interphone /インターホン/インターフォン/
interplay /インタープレイ/
interpol /インターポール;www.interpol.int/
interpret /インタープリト/
interpretation /インタープリテーション/
interpreter /インタプリタ/インタープリター/インタープリタ/インタープリータ;<rare>/
interpretive /インタプリティブ/
interrace /インターレース;※interlace/
interrupt /インタラプト/
interrupter /インタラプター/
intersection /∩/
intersex /インターセックス/
interval /インターバル/インタバル/
interview /インタビュー/インタビュ/インタヴュー/
interviewer /インタビュアー/インタヴュアー/
intimate /インティメイト/
into /イント/
intolerance /イントレランス/
intonation /イントネーション/
intra /イントラ/
intranet /イントラネット/
intrinsics /イントリンシックス/
intro /イントロ/
introduction /イントロダクション/導入/
inuit /イヌイット/
inulin /イヌリン/
invader /インベーダー/
invalid /インバリッド/誤った/無効な/
invalidate /インバリデート/
invalidation /インバリデーション/
invariant /インバリアント/インヴァリアント/
invention /インヴェンション/インベンション/
inventory /インベントリ/インベントリー/
inverse /インバース/インヴァース/
inversion /インバージョン/インヴァージョン/
invert /インバート/
inverter /インバータ/インバーター/
invest /インベスト/
investment /インベストメント/
invincible /インビンシブル/
invisible /インビジブル/
invitation /インビテーション/
invitational /インビテーショナル/インヴィテイショナル;<rare>/
invitro /インビトロ;in vitro/
invoice /インボイス/インヴォイス/
involvement /インボルブメント/
inzaghi /インザーギ/
io /イオ/Ｉ／Ｏ/入出力/(concat "I\057O")/
ioan /ヨアン/
iocard /イオカード/
iodine /アイオダイン/ヨード;Jod/
iodo /ヨード;(接中辞)/
iolite /アイオライト/
ion /イオン/アイオン/
iona /イオナ/アイオナ/
ionbeam /イオンビーム/
ione /イオネ/
ionesco /イヨネスコ/
ionia /イオニア/
ionian /イオニアン;CDEFGABC/アイオニアン/
ionicchannel /イオニック・チャンネル/
ioport /(concat "I\057Oポート")/
iosif /ヨシフ/
iota /ι/イオタ/
iowa /アイオワ/
ip /IPアドレス/IP/
ipaddress /IPアドレス/
ipanema /イパネマ/
ipmasquerade /IPマスカレード/
ipod /iPod;[商標]アップル/アイポッド;iPod/
ipphone /IPフォン/IP電話/
ipsum /イプサム;[商標]トヨタ/
ir /イリジウム/Iridium/
ira /アイラ/
irak /イラク;iq/
iran /イラン;.ir/
iraq /イラク;.iq/
ireland /アイルランド;.ie/
irene /アイリーン/イレーヌ/イレーネ/
iressa /イレッサ;=gefitinib/
iridium /イリジウム;[元素]77,Ir/
irina /イリーナ/
iris /アイリス/イリス/イーリス/
irish /アイリッシュ/
irkutsk /イルクーツク/
irma /イルマ/
iro /イロ/
iron /アイアン/アイロン/
ironie /イロニー/
ironman /アイアンマン/
ironside /アイアンサイド/
irony /アイロニー/
irq /IRQ/
irregular /イレギュラー/
irrumatio /イラマチオ/
irvin /アーヴィン/アービン/
irvine /アーヴィン/アービン/
irving /アーヴィング/
is /イズ/
isaac /アイザック/イサク/イザーク/
isabel /イザベル/イサベル/
isabella /イザベラ/
isabelle /イザベル/
isabus /ISAバス/
isaiah /イザヤ/
isbncode /ISBNコード;International Standard Book Number/ISBN番号/
iscariot /イスカリオテ;-のユダ/
iscariote /イスカリオテ/
isfahan /イスファハン;イラン/
ishtar /イシュタル/イシター/
isis /イシス/
iskandar /イスカンダル/
islam /イスラム/イスラーム/
islamabad /イスラマバード/
island /アイランド/
isle /アイル;島/
ism /イズム/
ismael /イスマエル/
isme /イスム;仏語/
iso /イソ/アイソ/ISO/
iso# /ISO#0/ＩＳＯ#1/
isodine /イソジン/
isoflavone /イソフラボン/
isoimage /ISOイメージ/
isola /イソラ/
isolation /アイソレーション/
isolator /アイソレータ/
isolde /イゾルデ/
isoleucin /イソロイシン;Ile/
isome /アイソメ;isometric/
isometric /アイソメトリック/
isoparametric /アイソパラメトリック/
isoprene /イソプレン/
isopropanol /イソプロパノール/
isopropyl /イソプロピル/
isotonic /アイソトニック/
isotope /アイソトープ/
isou /イズー/
isozyme /アイソザイム/
israel /イスラエル;.il/
issac /アイザック/
issue /イシュー/
ist /イスト/
istanbul /イスタンブール/
it /イット/アイティー/
it's /イッツ/
italia /イタリア;.it/伊太利亜/
italiagp /イタリアGP;[F1]/
italian /イタリアン/
italiana /イタリアーナ/
italiano /イタリアーノ/
italianrestaurant /イタリアンレストラン/
italiawine /イタリアワイン/
italic /イタリック/
italo /イタロ/
italy /イタリー/イタリア;.it/
itbubble /ITバブル/
itchy /イッチー/
itelie /イタリー;仏語/
item /アイテム/項目/
iteration /イテレーション/
iterative /逐次型/
iterator /イテレータ/
itriangle /▼/
its /イッツ/
itsystem /ITシステム/
iturn /Ｉターン/Iターン/
ivan /イワン/イヴァン/アイヴァン/イバン/
ivanhoe /アイヴァンホー/アイバンホー/
ives /アイヴズ/アイヴス/アイブス/
ivo /イヴォ/イボ/
ivory /アイボリー/アイヴォリー/
ivorywhite /アイボリーホワイト/
ivy /アイビー/アイヴィー/アイヴィ/
iybank /アイワイバンク;www.iy-bank.co.jp/
izmir /イズミル;トルコ/
j /ジェイ/ジェー/й;cyrillic(i-kratkoje)/
j2 /Ｊ２/
ja /ヤー;(独語)/я;cyrillic/
jab /ジャブ/
jabberwock /ジャバウォック/
jack /ジャック/ジャッキ/
jackal /ジャッカル/
jacke /ヤッケ/
jacker /ジャッカー/
jacket /ジャケット/
jackie /ジャッキー/
jackpot /ジャックポット/
jackrussell /ジャックラッセル;[犬]Jack Russell/
jackson /ジャクソン/
jaco /ジャコ/
jacob /ヤコブ/ジェイコブ/ジャコブ/ヤーコブ/ジェーコブ/
jacobi /ヤコビ/
jacobs /ジェイコブス/ジェイコブズ/
jacobsen /ヤコブセン/
jacobson /ヤコブソン/
jacquard /ジャカード/ジャガード/
jacqueline /ジャクリーン/ジャクリーヌ/
jacques /ジャック/
jacquiline /ジャクリーヌ/
jacuzzi /ジャグジー/ジャクージ/
jade /ジェイド/ジェード/
jaeger /イェーガー/
jael /ジェイル/ジェール/ヤエル/
jaggy /ジャギー/
jaguar /ジャガー/
jahn /ヤーン/
jahnn /ヤーン/
jail /ジェイル/
jaime /ハイメ/ジェイム/ジャイメ/ジェイミー/
jaipur /ジャイプール/
jair /ジェイル/ヤイル/
jaist /北陸先端大/ジャイスト/北陸先端科学技術大学院大学/JAIST/Japan Advanced Institute of Science and Technology/
jakarta /ジャカルタ/
jake /ジェイク/
jakob /ヤコブ/ジェイコブ/
jakobson /ヤコブソン/
jal /日本航空/日航/
jalapeno /ハラペーニョ/
jalousie /ジャロジー;(Fr)嫉妬。(窓の)ブラインド/ジャルジー/
jam /ジャム/
jamaica /ジャマイカ;.jm/
jamaican /ジャマイカン/
jamais /ジャメ/
jamal /ジャマール/ジャマル/
jambalaya /ジャンバラヤ/
jamband /ジャムバンド/
jamboree /ジャンボリー/
james /ジェームズ/ジェームス/ジェイムズ/ヤコブ/
jamie /ジェイミー/
jamila /ジャミラ/ジャミーラ/
jammes /ジャム/
jamming /ジャミング/
jammy /ジャミー/
jamsession /ジャムセッション/
jan /ジャン/ヤン/ヤーン/
jana /ヤナ/
janacek /ヤナーチェク/
jancode /JANコード;Japanese Article Number/
jane /ジェーン/
janet /ジャネット/
jani /ヤニ/
janice /ジャニス/
janie /ジェイニー/
janine /ジェニン/
janis /ジャニス/
janne /ヤンネ/
janos /ヤーノシュ/
jansen /ヤンセン/ジャンセン/
january /ジャニュアリー/
janus /ヤヌス;>january/
janusz /ヤヌス/ヤヌシュ/
jap /ジャップ/
japan /ジャパン/日本/
japancup /ジャパンカップ/
japanese /ジャパニーズ/
japanesque /ジャパネスク/
japon /ジャポン;仏語/
japonica /ジャポニカ/
japonisme /ジャポニスム/
jar /ジャー/
jardin /ジャルダン;(Fr)庭/
jared /ジャレド/ヤレド/
jargon /ジャーゴン/
jari /ヤリ/
jarno /ヤルノ/
jarpot /ジャーポット/
jarre /ジャール/
jarrett /ジャレット/
jarry /ジャリ/
jasdaq /ジャスダック;www.jasdaq.co.jp/
jasmin /ジャスミン;人名/
jasmine /ジャスミン/
jasminetea /ジャスミンティー/
jason /ジェイソン/
jasper /ジャスパー/碧玉/
jaspers /ヤスパース/
jasrac /ジャスラック/
jataka /ジャータカ/
jati /ジャーティ/
jaune /ジョーヌ;(Fr)黄色/
java /ジャワ/ジャバ/ジャヴァ/
javaapplet /JAVAアプレット/ジャバアプレット/
javanese /ジャバニーズ/
javascript /JAVAスクリプト/ジャバスクリプト/
javelin /ジャベリン/
jaw /ジョー/
jaws /ジョーズ/
jax /ジャックス/
jay /ジェイ/ジェー/
jaya /ジャヤ/
jazz /ジャズ/
jazzband /ジャズバンド/
jazzbar /ジャズバー/
jazzchorus /ジャズコーラス/
jazzclub /ジャズクラブ/
jazzdance /ジャズダンス/
jazzdrum /ジャズドラム/
jazzdrummer /ジャズドラマー/
jazzfes /ジャズフェス/
jazzfestival /ジャズフェスティバル/
jazzfunk /ジャズファンク/
jazzfusion /ジャズフュージョン/
jazzguitar /ジャズギター/
jazzlife /ジャズライフ/
jazzlive /ジャズライブ/
jazzman /ジャズマン/
jazzmen /ジャズメン/
jazzpiano /ジャズピアノ/
jazzrock /ジャズロック/
jazzsinger /ジャズシンガー/
jazzsong /ジャズソング/
jazzvocal /ジャズボーカル/
jazzy /ジャジー/
jbibtex /jBibTeX/
jcbcard /JCBカード;www.jcb.co.jp/
jcom /ジェイコム/
jcup /Jカップ;32.5cm/Ｊカップ/
je /е;cyrillic/ジュ/
jealous /ジェラス/
jealousy /ジェラシー/
jean /ジーン/ジャン/
jeanette /ジャネット/
jeanie /ジーニー/
jeanist /ジーニスト/
jeanne /ジャンヌ/
jeannedarc /ジャンヌダルク;(1412-1431) Jeanne d'Arc/
jeannette /ジャネット/
jeannie /ジニー/
jeans /ジーンズ/
jeddah /ジェッダ;サウジアラビア(jed)/
jedi /ジェダイ/
jeep /ジープ/
jef /ジェフ/
jeff /ジェフ/
jefferson /ジェファーソン/ジェファソン/
jeffery /ジェフリー/
jeffrey /ジェフリー/
jefunited /ジェフユナイテッド;[Jリーグ]市原・千葉/
jehovah /エホバ/
jekyll /ジキル/
jelly /ゼリー/ジェリー/
jellybeans /ジェリービーンズ/ゼリービーンズ/
jellyfish /ジェリーフィッシュ;くらげ/
jem /ジェム/
jena /イエナ/イェナ/
jenga /ジェンガ;[商標]/
jeni /ジェニ/
jenka /ジェンカ/
jenkins /ジェンキンス/ジェンキンズ/
jenna /ジェナ/ヤンナ/
jenner /ジェンナー/
jennie /ジェニー/ジェニィ/
jennifer /ジェニファー/
jennings /ジェニングス/
jenny /ジェニー/ジェニィ/
jens /ジェンス/イエンス/イェンス/
jensen /ジェンセン/ジャンセン/イェンセン/イエンセン/イェンゼン/
jenson /ジェンソン/
jeremiah /エレミヤ/ジェレマイア/
jeremie /ジェレミー/
jeremy /ジェレミー/
jerez /ヘレス/
jeri /ジェリ/
jericho /エリコ;パレスチナ/ジェリコ/
jerk /ジャーク/
jerky /ジャーキー/
jermaine /ジャーメイン/
jerome /ジェローム/
jeronimo /ジェロニモ/
jerry /ジェリー/
jersey /ジャージ/ジャージー/
jerusalem /エルサレム/イェルサレム/
jess /ジェス/
jesse /ジェシー/エッサイ/
jessica /ジェシカ/
jessie /ジェシー/
jesus /イエス/ジーザス/イエズス/ヘスス/
jesuschrist /イエスキリスト;Jesus Christ/イエス・キリスト/
jet /ジェット/
jetaime /ジュテーム;Je t'aime/
jetbath /ジェットバス;和製英語/
jetcoaster /ジェットコースター/
jete /ジュテ/
jetengine /ジェットエンジン/
jeter /ジーター/
jethro /ジェスロ/
jetro /ジェトロ;日本貿易振興会/
jetski /ジェットスキー/
jetstream /ジェットストリーム/
jeunesse /ジュネス/
jew /ジュー/ユダヤ/
jewel /ジュエル/
jewelcase /ジュエルケース/
jeweler /ジュエラー/
jewelry /ジュエリー/
jewelrybox /ジュエリーボックス/
jewelrycase /ジュエリーケース/
jewelryshop /ジュエリーショップ/
jibe /ジャイブ/
jig /ジグ/治具/
jigae /チゲ;(朝鮮語)/
jigsaw /ジグソー/
jigsawpuzzle /ジグソーパズル/
jihad /ジハード/
jil /ジル/
jill /ジル/
jim /ジム/
jimenez /ヒメネス/
jimi /ジミ/
jimmie /ジミー/
jimmy /ジミー/
jimny /ジムニー/
jingiskan /ジンギスカン;Genghis Khan?/
jingle /ジングル/
jinglebell /ジングルベル/
jinn /ジン/
jinx /ジンクス/
jis /ジス;Japanese Industrial Standard/
jis# /JIS#0/
jiscode /JISコード/
jismark /JISマーク/ジスマーク/
jitter /ジッタ/ジッター/
jitterbug /ジルバ/ジターバグ/ジッターバグ/ジタバグ/
jive /ジャイブ/ジャイヴ/
jk /│;vi式罫線入力/┃;太/
jkl /├;vi式罫線入力/┣;太/┠;縦太/┝;横太/
jl /┌;vi式罫線入力/┏;太/
jlatex /jLaTeX/
jleague /Jリーグ/Ｊリーグ/
jnic /日本ネットワークインフォメーションセンター;www.jnic.jp/
jo /ё;cyrillic/ジョー/
joachim /ヨアキム/ヨアヒム/
joan /ジョアン/ジョーン/
joanna /ジョアンナ/ジョアナ/
joanne /ジョアン/ジョアンヌ/
joao /ジョアン/
joaquin /ホアキン/
job /ジョブ/ヨブ/
jobim /ジョビン/
jobs /ジョブズ/ジョブス/
jocelyn /ジョセリン/
jockey /ジョッキー/
jod /ヨード;[元素]I (独語)/ヨート/
jodel /ヨーデル;(独語)/
jody /ジョディ/
joe /ジョー/
joel /ヨエル/ジョエル/
joelle /ジョエル/
jog /ジョグ/
jogger /ジョガー/
jogging /ジョギング/
joggingcourse /ジョギングコース/
joggingshoes /ジョギングシューズ/
jogjakarta /ジョグジャカルタ;インドネシア(jog)/
johan /ヨハン/
johann /ヨハン/
johanna /ヨハンナ/ヨハナ/
johannes /ヨハネ/ヨハネス/ヨハンネス/
johannesburg /ヨハネスブルグ;(jnb)南アフリカ/ヨハネスブルク/
johanson /ヨハンソン/
john /ジョン/ヨハネ/
johnlennon /ジョンレノン;(1940-1980)John Lennon/ジョン・レノン/
johnnie /ジョニー/
johnny /ジョニー/
johnnys /ジャニーズ;www.johnnys-net.jp/
johns /ジョーンズ/ジョンズ/
johnson /ジョンソン/
johorbahru /ジョホールバル;Johor Bahru,マレーシア(jhb)/
joie /ジョア/ジョワ/
join /ジョイン/
joint /ジョイント/
jointconcert /ジョイントコンサート/
jointlive /ジョイントライブ/
jointventure /ジョイントベンチャー/
jojo /ジョジョ/
jojoba /ホホバ/
joke /ジョーク/
joker /ジョーカー/
jolene /ジョリーン/
jolivet /ジョリヴェ/
jolly /ジョリー/
jon /ジョン/
jonah /ヨナ/
jonas /ジョナス/
jonathan /ジョナサン/ヨナタン/
jones /ジョーンズ/
joplin /ジョプリン/
jordan /ヨルダン;.jo/ジョルダン/ジョーダン/
jordi /ジョルディ/
jorg /ヨルグ/イェルク/
jorge /ホルヘ/ジョルジュ/ジョルジェ/ジョージ/
jose /ホセ/ジョゼ/
josef /ジョセフ/ジョゼフ/ヨーゼフ/ヨゼフ/ヨセフ/ジョーゼフ/
joseph /ヨセフ/ジョーゼフ/ヨーゼフ/ヨシフ/ジョセフ/
josephe /ジョセフ/
josephine /ジョセフィン/ジョゼフィーヌ;仏語/ジョセフィーヌ/
josephson /ジョセフソン/
josette /ジョゼット/
josh /ジョシュ/ジョッシュ/
joshua /ヨシュア/ジョシュア/
josie /ジョシー/
josquin /ジョスカン/
jota /ホタ/
joule /ジュール/
journal /ジャーナル/
journaling /ジャーナリング/
journalism /ジャーナリズム/
journalist /ジャーナリスト/
journalistic /ジャーナリスティック/
journey /ジャーニー/
joy /ジョイ/
joyce /ジョイス/
joyful /ジョイフル/
joypad /ジョイパッド/
joystick /ジョイスティック/
jpegfile /JPEGファイル/
jperiod /．/
jpgfile /JPGファイル/
jpop /Ｊポップ/Jポップ/J-POP/
jr /ジュニア/
jsbach /J.S.バッハ/J.S.Bach/ヨハンセバスチャンバッハ/ヨハン・セバスチャン・バッハ/
jsme /日本機械学会;Japan Society of Mechanical Engineers. www.jsme.or.jp/
jtex /jTeX/
ju /ю;cyrillic/
juan /ファン/ホアン/ジュアン/
juana /ファナ/
jubilee /ジュビリー/
jubilo /ジュビロ;[Jリーグ]磐田/
judah /ユダ;(ヤコブの子)/ジュダ/
judas /ユダ;(キリストを売った弟子)/ジューダス/
jude /ジュード/ユダ/
judea /ユダヤ/
judge /ジャッジ/
judgement /ジャッジメント/
judi /ジュディ/
judith /ジュディス/ユーディット/ジュディット/
judy /ジュディ/ジュディー/
jug /ジャグ/ジョッキ/
jugend /ユーゲント/
juggle /ジャッグル/
juggler /ジャグラー/
juggling /ジャグリング/
juha /ユハ/
juice /ジュース/
juicer /ジューサー/
juicy /ジューシー/
juillet /ジュイエ/
juin /ジュアン/
juke /ジューク/
jukebox /ジュークボックス/
jukka /ユッカ/
jule /ジュール/
jules /ジュール/
julia /ジュリア/ユリア/フリア/
julian /ジュリアン/フリアン/
julianna /ジュリアナ/
julianus /ユリアヌス/
julie /ジュリー/
julien /ジュリアン/
juliet /ジュリエット/
juliette /ジュリエット/
julio /フリオ/ジュリオ/
julius /ユリウス/ジュリアス/
july /ジュライ/
jumbo /ジャンボ/
jump /ジャンプ/
jumper /ジャンパー/ジャンパ/
jumperpin /ジャンパピン/ジャンパーピン/
jumperskirt /ジャンパースカート;和製英語(jumper)/
jumping /ジャンピング/
jumpsuit /ジャンプスーツ/
junction /ジャンクション/
june /ジューン/
junebride /ジューンブライド/
junet /JUNET/
jung /ユング/
jungfrau /ユングフラウ/
jungle /ジャングル/
junglebook /ジャングルブック;1894,Kipling/
junglegym /ジャングルジム/
junior /ジュニア/
junius /ジュニアス/
junk /ジャンク/
junker /ユンカー/ユンケル;(独語)/
junkfood /ジャンクフード/
junkie /ジャンキー/
junkmail /ジャンクメール/
junky /ジャンキー/
juno /ジュノー/ユノ/ユーノ/ユーノー/
jupiter /ジュピター/ユピテル/
jupon /ズボン;仏語/
juponpresser /ズボンプレッサー;和製語(trouser press)/
jura /ジュラ/
jurassic /ジュラシック/
jurgen /ユルゲン/
juri /ユリ/ユーリ/
jus /Ｊｕｓ/ＪＵＳ/
jusco /ジャスコ/
jussi /ユッシ/
just /ジャスト/ジュス/
juste /ジュスト;仏語/
justfit /ジャストフィット/
justice /ジャスティス/
justification /ジャスティフィケーション/
justify /ジャスティファイ/
justin /ジャスティン/
justine /ジュスティーヌ/ジャスティン/
justmeet /ジャストミート;和製英語/
justsystem /ジャストシステム/
jute /ジュート/
juvenile /ジュブナイル/ジュヴナイル/
jv /共同企業体;joint venture/
jwave /Ｊ−ＷＡＶＥ/
k /κ;kappa/ケイ/ケー/к;ka (cyrillic)/キロ/カリウム/Potassium/χ;※(kh) chi/
ka /к;cyrillic/
kaaba /カーバ/
kaas /カース/
kabaddi /カバディ/
kabah /カーバ/
kabalevskii /カバレフスキー/
kabalevsky /カバレフスキー/
kabbala /カバラ/
kabul /カブール/
kadenz /カデンツ/
kaffein /カフェイン;(独語)/
kafka /カフカ/
kahla /カーラ/
kahler /カーラー/
kahlua /カルーア/カルア/
kahluamilk /カルアミルク/カルーアミルク/
kai /χ/カイ/
kailas /カイラス/
kain /ケイン/
kaiser /カイザー/カイゼル/
kaj /カイ/
kalahari /カラハリ/
kalanchoe /カランコエ/
kalashnikov /カラシニコフ/
kalbi /カルビ;(朝鮮語)/
kale /ケール/
kaleidoscope /カレイドスコープ/
kalevala /カレワラ/
kali /カーリー/
kalimantan /カリマンタン/
kalimba /カリンバ/
kaliope /カリオペ/
kalium /カリウム;[元素]19,K/
kaliumion /カリウムイオン;potassium ion/
kalk /カルキ;(独語)/
kalle /カレ/
kallisto /カリスト/
kalman /カルマン/
kalmia /カルミア/
kama /カーマ/
kamasutra /カーマスートラ/
kamchatka /カムチャッカ/カムチャツカ/
kamen /カーメン/
kamiokande /カミオカンデ;KAMIOKA Nucleon Decay Experiment/
kampala /カンパラ/
kampher /カンフル;(蘭語)/
kamuy /カムイ;(アイヌ語)神/
kana /カナ/
kanamycin /カナマイシン/
kandahar /カンダハル/
kandinsky /カンディンスキー/
kandy /キャンディ;紅茶/
kangaroo /カンガルー/
kangfu /カンフー/功夫/
kanon /カノン/
kansas /カンザス;KS/
kansascity /カンザスシティ/カンザスシティー/
kant /カント/
kantele /カンテレ/
kantor /カントル/
kaolin /カオリン/
kaolinite /カオリナイト/
kapo /カポ/
kappa /κ/カッパ/
kapsel /カプセル;(独語)/
kara /〜/
karaat /カラット;(蘭語)/
karachi /カラチ;パキスタン/
karajan /カラヤン/
karamazov /カラマーゾフ/
karaoke /カラオケ/
karaokebox /カラオケボックス/
karat /カラット/
karbala /カルバラ;イラク/
karel /カレル/
karelia /カレリア/
karen /カレン/
karenina /カレーニナ/
kari /カリ/
karin /カリン/カーリン/
karl /カール/カルル/
karlheinz /カールハインツ/
karlsruhe /カールスルーエ/
karma /カルマ/
karmen /カーメン/カルメン/
karna /カーナ/カルナ/
karrer /カーラー/
karst /カルスト/
karte /カルテ;(独語)/
kartell /カルテル;(独語)/
karzai /カルザイ/
kasein /カゼイン/
kashmir /カシミール/カシミヤ/カシミア/
kaspar /カスパー/カスパル/
kasper /カスパー/
kassovitz /カソヴィッツ/
kastner /ケストナー/
katalase /カタラーゼ/
katar /カタール;.qa/
kate /ケイト/ケート/
katerina /カテリーナ/カテリナ/
katharine /キャサリン/
katharsis /カタルシス/
kathe /ケーテ/
katherina /カテリーナ/カテリナ/
katherine /キャサリン/
katheter /カテーテル;(蘭語)/
kathleen /キャスリーン/キャスリン/キャサリン/
katholiek /カトリック;(蘭語)/
kathryn /キャスリン/
kathusha /カチューシャ;(日本語)/
kathy /キャシー/キャッシー/
kati /カティ/
katie /ケイティー/
kation /カチオン;(独語)/
katmandu /カトマンズ/
katrin /カトリン/カトリーン/
katrina /カトリーナ/
katyusha /カチューシャ/
kauai /カウアイ/
kaufman /カウフマン/
kaufmann /カウフマン/
kaus /カウス/
kavkaz /カフカス/
kawai /カワイ/
kaxgar /カシュガル;中国/
kay /ケー/ケイ/
kayak /カヤック/
kazakh /カザフ/
kazakhstan /カザフスタン;.kz/
kazan /カザン/
kazoo /カズー/
kb /キーボード/キロバイト/
kbbutz /キブツ/
kbyte /キロバイト/
kcl /KCL/
kcup /Kカップ/Ｋカップ/
kean /キーン/
keaton /キートン/
keats /キーツ/
kebab /ケバブ/カバブ/
kechak /ケチャ/
keema /キーマ/
keemun /キーマン/
keen /キーン/
keene /キーン/
keep /キープ/
keepalive /キープアライブ/
keeper /キーパー/
keeping /キーピング/
kefir /ケフィア/
keita /ケイタ/
keith /キース/
keller /ケラー/
kellogg /ケロッグ/
kelly /ケリー/
keloid /ケロイド/
kelvin /ケルビン/
kemp /ケンプ/
kempff /ケンプ/
ken /ケン;Kenneth/
kenaf /ケナフ/
kendall /ケンドール/
kennedy /ケネディ/
kennel /ケンネル/ケネル/
kenneth /ケネス/
kenny /ケニー/
kent /ケント/
kentauros /ケンタウロス/
kentucky /ケンタッキー/
kenwood /ケンウッド/Ｋｅｎｗｏｏｄ/
kenya /ケニア;.ke/ケニヤ/
kepheus /ケフェウス/
kepler /ケプラー/
keratin /ケラチン/
kerberos /ケルベロス/
keris /クリス/
kern /カーン/ケルン/
kernel /カーネル/
kerner /ケルナー/
kernighan /カーニハン/
kerning /カーニング/
kerosene /ケロシン/
kerouac /ケルアック/
kerr /カー/カール/ケア/ケル/
kerry /ケリー/
kessel /ケッセル/
kessler /ケスラー/
ketamine /ケタミン;C13H16ClNO・HCl/
ketchup /ケチャップ/
ketone /ケトン/
kettle /ケトル/
ketty /ケティ/
kevin /ケビン/ケヴィン/
kevlar /ケブラー/
kewpie /キューピー/
key /キー/キイ/ケイ/
keyassign /キーアサイン/
keybind /キーバインド/
keybinding /キーバインディング/
keyboard /キーボード/
keyboardist /キーボーディスト/
keyboardmacro /キーボードマクロ/
keycase /キーケース/
keycode /キーコード/
keyconcept /キーコンセプト/
keyholder /キーホルダー/
keyling /キーリング;豪州/
keylock /キーロック/
keylogger /キーロガー/
keyman /キーマン/
keymap /キーマップ/
keynes /ケインズ/
keynesian /ケインジアン/
keynote /キーノート/
keypad /キーパッド/
keyperson /キーパーソン/
keyphrase /キーフレーズ/
keypitch /キーピッチ/
keypoint /キーポイント;key point/
keypuncher /キーパンチャー/
keyring /キーリング/
keysequence /キーシーケンス/
keystation /キーステーション/
keystone /キーストーン/
keystroke /キーストローク/
keytop /キートップ/
keytouch /キータッチ/
keyword /キーワード/
keywordsearch /キーワードサーチ/
kfc /ケンタッキーフライドチキン/
kg /キログラム/Ｋｇ/
kh /χ;chi/х;xa (cyrillic)/
khabarovsk /ハバロフスク/
khachaturyan /ハチャトゥリアン/
khaki /カーキ/
khan /カン/カーン/ハン/ハーン/汗/
kharakhorum /カラコルム/
khartoum /ハルツーム/
khmer /クメール/
khoisan /コイサン/
khomeini /ホメイニ/
khoomei /ホーメイ/
khoomii /ホーミー/
khorosho /ハラショー;(露語)/
khrushchev /フルシチョフ/
khubilai /フビライ/忽必烈/忽比烈/
khufu /クフ/
kick /キック/
kickback /キックバック/
kickboard /キックボード/
kickboxer /キックボクサー/
kickboxing /キックボクシング/
kicker /キッカー/
kickin /キックイン/
kickoff /キックオフ/
kicks /キックス/
kickstart /キックスタート;kick-start/
kid /キッド/
kidd /キッド/
kidnap /キッドナップ/
kidney /キドニー/
kids /キッズ/
kidsroom /キッズルーム;託児室/
kiefer /キーファー/
kieffer /キーファー/
kiel /キール/
kier /キア/
kiev /キエフ/
kigali /キガリ/
kiki /キキ/
kilauea /キラウエア/
kilia /キリア/
kilimanjaro /キリマンジャロ/
kill /キル/
killer /キラー/
killers /キラーズ/
killing /キリング/
kilmer /キルマー/
kiln /キルン/窯/
kilo /キロ;K,10^3/
kilobyte /キロバイト/
kilobytes /キロバイト/
kilocalorie /キロカロリー/
kilogram /キログラム/
kiloliter /キロリットル/
kilolitre /キロリットル/
kilometer /キロメートル/
kilometre /キロメートル/
kilowatt /キロワット/
kilt /キルト/
kim /キム/金/
kimberley /キンバリー/
kimberly /キンバリー/
kimchi /キムチ;(朝鮮語) kimch'i/
kimi /キミ/
kin /キン/
kina /キナ/
kinase /キナーゼ/
kind /カインド/
kinder /キンダー/
kinema /キネマ;kinematograph/
kinesiology /キネシオロジー/
kinetic /キネティック/
kinetin /カイネチン/キネチン/
king /キング/
kingdom /キングダム/
kingkong /キングコング/
kingof /キング・オブ・/キングオブ/
kingrecord /キングレコード/
kings /キングス/キングズ/
kingsalmon /キングサーモン/
kingsize /キングサイズ/
kingston /キングストン/
kingstown /キングスタウン/
kinine /キニーネ/
kinsey /キンゼイ/
kinshasa /キンシャサ;コンゴ民主共和国/
kinski /キンスキー/
kiosk /キオスク/キヨスク/
kipling /キプリング/キップリング/
kir /キール/
kira /キラ/
kirby /カービィ/カービー/
kirchhoff /キルヒホッフ/
kirgistan /キルギスタン/
kirgiz /キルギス/
kiribati /キリバス;.ki/
kirinbeer /キリンビール/
kirk /カーク/
kirkland /カークランド/
kirsch /キルシュ/
kirsten /キルステン/
kirsty /カースティ/
kishinyov /キシニョフ/
kiska /キスカ/
kiss /キス/キッス/×××/
kissin /キーシン/
kissinger /キッシンジャー/
kissmark /キスマーク;和製英語(lovebite)/
kissscene /キスシーン/
kit /キット/
kitchen /キッチン/
kitchencounter /キッチンカウンター/
kitchenette /キチネット/
kitchenknife /キッチンナイフ/
kitchenpaper /キッチンペーパー/
kitchenscale /キッチンスケール/
kitchensink /キッチンシンク/
kitchentimer /キッチンタイマー/
kitchenware /キッチンウェア/
kite /カイト/
kithara /キタラ/
kitkat /キットカット;[商標]/
kitsch /キッチュ;(独語)/
kittel /キッテル/
kitto /キット/
kitty /キティ/キティー/
kittyhawk /キティホーク;Kitty Hawk, USA/
kiwi /キウイ/キウィ/
kk /株式会社/（株）/
kkbestsellers /KKベストセラーズ;www.kk-bestsellers.com/
kl /└;vi式罫線入力/┗;太/キロリットル/
klar /クラール/
klara /クララ/クラーラ/
klaus /クラウス/
klavichord /クラヴィコード;(独語)/クラビコード/
klavier /クラヴィーア/クラヴィア/
klaxon /クラクション/
klee /クレー/
kleene /クリーネ/
kleiber /クライバー/
klein /クライン/
klemperer /クレンペラー/
klezmer /クレズマー/
klien /クリエン/
klimt /クリムト/
klose /クローゼ/
kluger /クルーガー/
klum /クラム/
km /Ｋｍ/
kmc /京大マイコンクラブ/
knack /ナック/
knapsack /ナップザック/ナップサック/
knee /ニー/
kneedrop /ニードロップ/
kneel /ニール/
kneepad /ニーパッド/
kneesocks /ニーソックス/
kneesox /ニーソックス;knee socks/
knife /ナイフ/
knight /ナイト/
knights /ナイツ/
knit /ニット/
knitcap /ニットキャップ/
knitshirt /ニットシャツ/
knitting /ニッティング/
knob /ノブ/
knock /ノック/
knockdown /ノックダウン/
knocker /ノッカー/
knocking /ノッキング/
knockout /ノックアウト/
knomeini /ホメイニ/
knot /ノット/節/
knotting /ノッティング/
know /ノウ/
knowhow /ノウハウ/
knowledge /ナレッジ/
known /ノーン/ノウン/
knuckle /ナックル/
knut /クヌート/
knuth /クヌース/
ko /ＫｎｏｃｋＯｕｔ/
koala /コアラ/
koblenz /コブレンツ/
kobold /コボルド/
koch /コッホ/
kochel /ケッヘル/
kocher /コッヘル/
kodak /コダック;www.kodak.com/
kodaly /コダーイ;(1882-1967)Kodaly Zoltan/
koehler /ケーラー/
kohl /コール/
kohler /ケーラー/コーラー/
kohlrabi /コールラビ/
kok /コック;(蘭語)/
kokand /コーカンド/
koks /コークス;(独語)/
kolchizin /コルヒチン/
kolkata /コルカタ/
kolkhoz /コルホーズ/
kollagen /コラーゲン;(独語)/
kolmogorov /コルモゴロフ/
koln /ケルン/
kolossai /コロサイ/
kolsch /ケルシュ/
kombinat /コンビナート;(露語)/
kome /※/
komi /コミ/
kommentar /コンメンタール/
komodo /コモド;インドネシア/
komododragon /コモドドラゴン;Komodo dragon/
kona /コナ/
kondom /コンドーム;(独語)/
kondratieff /コンドラチェフ/
kong /コング/
konica /コニカ;www.konicaminolta.jp/
konide /コニーデ/
konitz /コニッツ/
konrad /コンラッド/コンラート/
konstantin /コンスタンティン/
konstanz /コンスタンツ/
konzern /コンツェルン/
konzert /コンツェルト/
koran /コーラン/クルアーン/
korea /コリア/
korean /コリアン/
korg /コルグ/
koror /コロール/
korsakov /コルサコフ/
kosma /コスマ/
kosmos /コスモス;ギリシア語/
kosovo /コソボ/コソヴォ/
kotakinabalu /コタキナバル;マレーシア/
kouglof /クグロフ/
koumiss /クミス/
kr /クリプトン/Krypton/
kraan /カラン;(蘭語)/
kraepelin /クレペリン/
kraken /クラーケン/
krakow /クラクフ/
kramer /クレーマー/クレイマー/
kranke /クランケ/
krasnoyarsk /クラスノヤルスク/
kraus /クラウス/
krause /クラウゼ/
krauss /クラウス/
kreapelin /クレペリン/
kreis /クライス;(独語)領分/
kreisler /クライスラー/
kremer /クレーメル/
kremlin /クレムリン/
kreta /クレタ/
kretschmer /クレッチマー/
kreutzer /クロイツェル/クロイツァー/
kreuz /クロイツ/
kripke /クリプキ/クリプケ/
kris /クリス/
krishna /クリシュナ/
kriss /クリス/
kristel /クリステル/
kristeva /クリステヴァ/
kristian /クリスチャン/クリスティアン/
kristiania /クリスチャニア/
kristin /クリスティン/
kristina /クリスティーナ/クリスティナ/
kronecker /クロネッカー/
kroneckerdelta /クロネッカーのデルタ/
kronos /クロノス/
krsna /クリシュナ/
kruger /クルーガー/
krugman /クルーグマン/
krym /クリム/
krypton /クリプトン;[元素]36,Kr/
ks /Kansas/カンサス/カンザス/
ksatriya /クシャトリア/クシャトリヤ/
kterm /KTerm/
kualalumpur /クアラルンプール;Kuala Lumpur/
kuantan /クアンタン;マレーシア(kua)/
kubelik /クーベリック/
kubota /クボタ/
kubrick /キューブリック/
kuchen /クーヘン;(独) 菓子/
kugel /クーゲル/
kuhn /クーン/
kuijken /クイケン/
kuiper /カイパー/
kuli /クーリー/
kumiss /クミス/
kundera /クンデラ/
kunlun /クンルン/
kunst /クンスト;(独語)芸術/
kunz /クンツ/
kurd /クルド/
kurhaus /クアハウス/
kurt /カート/クルト/
kurz /クルツ/
kuwait /クウェート;.kw/
ky /Kentucky/ケンタッキー/
kypros /キプロス/
kyrgyzstan /キルギス;.kg/
kyrie /キリエ/
l /λ;lambda/エル/л;el (cyrillic)/リットル/
la /ラ/Lanthanum/ランタン/Louisiana/ルイジアナ/
lab /ラボ/研究室/
laban /ラバン/
label /ラベル/レーベル/
labelgate /レーベルゲート/
labelgatecd /レーベルゲートCD/
labeling /ラベリング/ラベル付け/
labelwidget /ラベル・ウィジット/
labia /ラビア/
labo /ラボ;laboratory/
labor /レイバー/レーバー/
laboratories /ラボラトリーズ/
laboratory /ラボラトリー/ラボラトリ/
labour /レイバー/レーバー/
labrador /ラブラドル/ラブラドール/
labradorretriever /ラブラドールレトリバー;Labrador retriever/
labyrinth /ラビリンス/
lacan /ラカン/
lace /レース/
lacecurtain /レースカーテン/
lacey /レイシー/
lack /ラック/
laclos /ラクロ/
lacoste /ラコステ/
lacquer /ラッカー/
lacroix /ラクロワ/
lacrosse /ラクロス/
lact /ラクト/
lactam /ラクタム/
lactice /ラクトアイス;和製英語(lacto + ice)/
lacto /ラクト/
lactoice /ラクトアイス;和製英語(lacto + ice)/
lactone /ラクトン/
lacy /レイシー/
lad /ラッド/
ladder /ラダー;梯子/
laden /ラディン/
ladies /レディース/レディス/
ladiescomic /レディースコミック/
ladle /レードル/
lado /ラド/
ladon /ラドン/
lady /レディ/レディー/
ladyborden /レディーボーデン;[商標]ロッテ/レディボーデン/
ladyfirst /レディーファースト;ladies first/レディファースト/
laetitia /レティシア/
lafaro /ラファロ;LaFaro/
lafayette /ラファイエット;La Fayette/
lafcadio /ラフカディオ/
lafite /ラフィット/
lafont /ラフォン/
lafontaine /ラ・フォンテーヌ;La Fontaine/ラフォンテーヌ/
laforet /ラフォーレ;(Fr) la foret/
laforgue /ラフォルグ/
lafrance /ラフランス;(日本産の洋梨)/
lag /ラグ/
lage /ラーゲ;(独語)/
lager /ラガー/ラーゲリ;(露)лагерь/
lagerbeer /ラガービール/
lagerfeld /ラガーフェルド/
lago /ラーゴ/
lagoon /ラグーン/
lagos /ラゴス/
lagrange /ラグランジュ/ラグランジェ/
lagrangian /ラグランジアン/
lagtime /ラグタイム;lag time/
lahore /ラホール/
lai /レイ/
laila /レイラ/ライラ/
laine /レーヌ;(Fr)羊毛/レーン/
laing /レイン/
lair /レア/
laisserfaire /レッセフェール;laisser faire/
laissezfaire /レッセフェール;laissez faire/
lake /レイク/レーク/
lakeside /レイクサイド/レークサイド/
lakshmi /ラクシュミ/ラクシュミー/
lala /ララ/
lalala /ラララ/
lally /ラリー/
lama /ラマ/
lamancha /ラマンチャ;La Mancha/ラ・マンチャ/
lamarck /ラマルク/
lamarseillaise /ラ・マルセイエーズ;La Marseillaise (フランス国歌)/
lamaze /ラマーズ/
lamb /ラム/
lambada /ランバダ/
lambchop /ラムチョップ;lamb chop/
lambda /λ/ラムダ/λ-算法/
lambert /ランバート/ランベール/ランベルト/
lamborghini /ランボルギーニ;www.lamborghini.com/
lambrusco /ランブルスコ/
lame /ラメ/レイム/
laminate /ラミネート/
lamp /ランプ/
lampshade /ランプシェード/
lamy /ラミー/
lan /LAN/
lana /ラナ/ラーナ/
lanboard /LANボード/
lancable /LANケーブル/
lancard /LANカード/
lancashire /ランカシャー/
lancaster /ランカスター/
lance /ランス/
lancelot /ランスロット/ランスロ/ラーンスロット/
lancer /ランサー/
lancet /ランセット/
lancia /ランチア;www.lancia.com/
land /ランド/∧/
landcruiser /ランドクルーザー/
landing /ランディング/
landmark /ランドマーク/
landmarktower /ランドマークタワー;横浜/
lando /ランド/
landrover /ランドローバー/
landsat /ランドサット/
landscape /ランドスケープ/
landy /ランディ/
lane /レーン/
lang /ラング/
langage /ランガージュ/
langerhans /ランゲルハンス/
langkawi /ランカウイ;マレーシア(lgk)/
langley /ラングレー/
langsam /ラングザーム/ラングザム/
language /ランゲージ/
langue /ラング/
languedechat /ラングドシャ;langue de chat/
languedoc /ラングドック;Langue d'Oc/
lanina /ラニーニャ;La Nina/
lantana /ランタナ/
lantern /ランタン/
lanthanoid /ランタノイド/
lanthanum /ランタン;[元素]57,La/
lanza /ランツァ/
laocoon /ラオコーン;英語綴り/
laokoon /ラオコーン/
laon /ラン/
laos /ラオス;.la/
laox /ラオックス;www.laox.co.jp/
lap /ラップ/
lapaz /ラパス;La Paz/
lapis /ラピス;石/
lapislazuli /ラピスラズリ;lapis lazuli/
laplace /ラプラス/
laplacian /ラプラシアン/
lapland /ラップランド/
laplata /ラプラタ;La Plata/
lapp /ラップ/
lapping /ラッピング/
laptime /ラップタイム/
laptop /ラップトップ/
laputa /ラピュタ/
lara /ララ/ラーラ/
larc /ラルク;l'arc. (Fr)弓/
lard /ラード/
large /ラージ/
largehill /ラージヒル/
largesize /ラージサイズ/
larghetto /ラルゲット/
largo /ラルゴ/
lariat /ラリアット/ラリアート/
lark /ラーク/
larmen /ラーメン;?/
laroche /ラロッシュ/
larousse /ラルース/
larry /ラリー/ラリイ/ラリィ/
lars /ラーズ/ラルス/
larsen /ラーセン/ラルセン/
las /ラス/
lasagna /ラザニア/ラザーニャ/
lasalle /ラサール/ラ・サール/
lascaux /ラスコー/
laser /レーザー/レーザ/
laserbeam /レーザービーム/
laserdisc /レーザーディスク/
laserdisk /レーザーディスク/
laserpointer /レーザーポインター/レーザーポインタ/レーザポインタ/
laserprinter /レーザープリンタ/レーザープリンター/レーザプリンタ/
laserwriter /レーザーライタ/ＬａｓｅｒＷｒｉｔｅｒ/
lasse /ラッセ/
lassen /ラッセン/
lassi /ラッシー;インド風飲むヨーグルト/
last /ラスト/
lastboss /ラスボス/
lastdance /ラストダンス/
lastname /ラストネーム/
lastnumber /ラストナンバー/
lastorder /ラストオーダー/
lastresort /ラストリゾート;last resort. 最後の拠り所/
lastscene /ラストシーン/
lastspurt /ラストスパート/
lasvegas /ラスベガス/
laswell /ラズウェル/
latch /ラッチ/
late /レイト/レート/
latency /レイテンシ/レイテンシー/
lateral /ラテラル/
lateshow /レイトショー/
latex /ラテックス;ゴム/ラテフ;LaTeX/ＬａＴｅＸ/ＬAＴEＸ/LaTeX/\LaTeX/
latin /ラテン/
latin# /Latin-#0/
latinamerica /ラテンアメリカ/
latour /ラトゥール/
lattice /ラティス/ラチス/
latvia /ラトビア;.lv/ラトヴィア/
lauan /ラワン/
laud /ロード/
lauda /ラウダ/
laude /ロード/
laue /ラウエ/
laugh /ラフ/
laughing /ラフィング/ラーフィング/
launcer /ランチャー/ランチャ/
launch /ランチ/
launcher /ランチャー/ランチャ/
launder /ロンダ/
laundering /ロンダリング/
laundry /ランドリー/
laura /ローラ/ラウラ/
laure /ロール/
laurel /ローレル/
lauren /ローレン/
laurence /ローレンス/ロレンス/ローランス/
laurencin /ローランサン/
laurent /ロラン/ローラン/
laurie /ローリー/
laurier /ローリエ/
lauro /ラウロ/
lausanne /ローザンヌ/
laut /ラウト/
lautreamont /ロートレアモン/
lautrec /ロートレック;(1864-1901)Henri de Toulouse-Lautrec/
lavender /ラベンダー/ラヴェンダー/
law /ロー/
lawn /ローン;芝/
lawntennis /ローンテニス/
lawrence /ローレンス/ロレンス/
lawrencium /ローレンシウム;[元素]103,Lr/
lawschool /ロースクール/
lawson /ローソン/Ｌａｗｓｏｎ/
lawsonticket /ローソンチケット;www2.lawsonticket.com/
lay /レイ/
laydock /レイドック/
layer /レイヤー/レイヤ/
layered /レイヤード/
layman /レイマン/
laymantype /レイマン型/
layoff /レイオフ/
layout /レイアウト/
layoutsystem /レイアウトシステム/
laytracing /レイトレーシング;※ray tracing/
lazare /ラザール/
lazaro /ラザロ/
lazarus /ラザロ/ラザルス/ラザラス/
lazer /レーザー/レーザ/
lazerbeam /レーザービーム;※laserbeam/
lazy /レイジー/
lbp /レーザビームプリンタ/
lcd /液晶;liquid crystal display/
ld /LD/
ldots /.../
le /ル;仏語/≦/
lea /レア/
lead /リード/
leader /リーダー/リーダ/
leaderalbum /リーダーアルバム/
leadership /リーダーシップ/
leadguitar /リードギター/
leading /リーディング/
leadoff /リードオフ/
leadoffman /リードオフマン/
leadtime /リードタイム;所要時間/
leadvocal /リードボーカル/
leaf /リーフ/
leaflet /リーフレット/
leafpie /リーフパイ/
league /リーグ/
leaguer /リーガー/
leah /リア/レア/
leak /リーク/
lean /リーン/
learn /ラーン/
learner /ラーナー/
learning /ラーニング/学習/
lease /リース/
leasing /リーシング/
leather /レザー/
leathercraft /レザークラフト/
leave /リーブ/
leaves /リーブス/リーヴス/リーブズ/
leaving /リービング/
lebanon /レバノン;.lb/
lebesgue /ルベーグ/
leblanc /ルブラン/
lechatelier /ルシャトリエ;Henry Louis Le Chatelier (1850-1936)/
lecithin /レシチン/
leconte /ルコント/
lector /レクター/
lecture /レクチャー/レクチャ/
leda /レダ/
ledlight /LEDライト/
ledoux /ルドゥー/
lee /リー/李/
leeds /リーズ/
leek /リーキ/リーク;ねぎ/
lees /リース/
lefevre /ルフェーブル/
left /レフト/←/左/
leftarrow /←/
leftfly /レフトフライ/
leftover /レフトオーバー/
lefty /レフティ/レフティー/
leg /レッグ/
legacy /レガシー/レガシィ/
legal /リーガル/
legato /レガート/
legend /レジェンド/
legendary /レジェンダリー/
legendre /ルジャンドル/
legends /レジェンズ/
leger /レジェ/
leggiero /レッジェーロ/レジェーロ/
leghorn /レグホーン/
legiondhonneur /レジオンドヌール;Legion d'honneur/
legionella /レジオネラ/
lego /レゴ/
legrand /ルグラン;le Grand/
legwarmer /レッグウォーマー/
lehar /レハール/
lehavre /ルアーブル;Le Havre/
lehman /リーマン/レーマン/
lehmann /レーマン/
leibniz /ライプニッツ/
leica /ライカ/
leiden /ライデン/
leier /ライアー/ライエル/
leigh /レイ/
leila /レイラ/リーラ/
leipzig /ライプチヒ/ライプツィヒ/
leisure /レジャー/
leisureland /レジャーランド;和製英語/
leisuresports /レジャースポーツ/
leitmotiv /ライトモチーフ/
leloup /ルルー/
lem /レム/
lema /レマ/
lemaire /ルメール/
lemans /ルマン;Le Mans/
lemma /レンマ/Lemma/補題/
lemming /レミング/
lemon /レモン/檸檬/
lemonade /レモネード/ラムネ;NB:lemonadeの訛り/
lemonbalm /レモンバーム/
lemonde /ルモンド;Le Monde. lemonde.fr/ル・モンド/
lemongrass /レモングラス/
lemonpeel /レモンピール;lemon peel/
lemonpie /レモンパイ/
lemonsour /レモンサワー/
lemonsquash /レモンスカッシュ/
lemontea /レモンティー/
lemonyellow /レモンイエロー/
len /レン/
lena /レナ/レイナ/レーナ/リーナ/
lender /レンダー;貸し手/
length /レングス/
lenin /レーニン/
leningrad /レニングラード;現・Sankt-Peterburg/
lennie /レニー/
lennon /レノン/
lenny /レニー/
lenore /レノア/
lenovo /レノボ/聯想;[企業名]www.lenovo.com/
lenox /レノックス/
lens /レンズ/
lenscase /レンズケース/
lenscover /レンズカバー/
lense /レンズ/
lenshood /レンズフード;lens hood/
lento /レント/
lenz /レンツ/
leo /レオ/
leon /レオン/
leona /レオナ/
leonard /レオナルド/レナード/レオナール/
leonardo /レオナルド/
leonardodavinci /レオナルドダヴィンチ;(1452-1519) Leonardo da Vinci/レオナルド・ダ・ヴィンチ/
leone /レオーネ/
leonhard /レオンハルト/
leonhardt /レオンハルト/
leonhart /レオンハルト/
leoni /レオーニ/
leonid /レオニード/
leonor /レオノール/
leonora /レオノーラ/
leonore /レオノール/レオノーレ/
leopalace /レオパレス;[企業名]/
leopold /レオポルド/レオポルト/
leopoldo /レオポルド/
leotard /レオタード/
leoville /レオヴィル/
leprechaun /レプラコーン/
lepton /レプトン/
leq /≦/
leroux /ルルー/
leroy /リロイ;LeRoy/ルロイ/ルロワ/
les /レ/
lesbian /レズビアン/レズ/
lesbos /レスボス/
lescault /レスコー/
lescaut /レスコー/
lesley /レズリー/レスリー/
leslie /レスリー/レズリー/
lesmiserables /レミゼラブル;Les Miserables,1862,Hugo/レ・ミゼラブル/
lesotho /レソト;.ls/
lespaul /レスポール;Les Paul/
less /レス/
lesser /レッサー/
lesserpanda /レッサーパンダ/
lessig /レッシグ/
lessing /レッシング/
lesson /レッスン/
lester /レスター/
let /レット/
lethal /リーサル/
leto /レト/
lets /レッツ;let's/
letsgo /レッツゴー/
letter /レター/レッテル;(蘭語) NB:label(En)/手紙/
letterhead /レターヘッド/
lettering /レタリング/
letteropener /レターオープナー/
letterset /レターセット/
lettie /レティ/
lettuce /レタス/
lettucesalad /レタスサラダ/
letty /レティ/
leucin /ロイシン;Leu/
leukotriene /ロイコトリエン;LT/
lev /レフ/
levan /レヴァン/
level /レベル/レヴェル/
leveldown /レベルダウン/
levelup /レベルアップ/
lever /レバー/
leverage /レバレッジ/
levi /レビ/レヴィ/
leviathan /リヴァイアサン/リバイアサン/レヴィアタン/
levin /レビン/レヴィン/
levinas /レヴィナス/
levine /レヴィン/レヴァイン/
levis /リーバイス;[商標]Levi's/
levistrauss /レヴィ=ストロース;Claude Levi-Strauss/
levit /レビ/
levy /リービ/レヴィ/レビ/レビー/レヴィー/
lew /ルー/リュー/
lewie /ルーイ/
lewin /レビン/レヴィン/ルウィン/リューイン/
lewis /ルイス/
lex /レックス;法/レクス/
lexical /レキシカル/
lexicon /レキシコン/
lexington /レキシントン/
lexus /レクサス;[商標]トヨタ/
leyte /レイテ/
lf /ロジカル・フレームワーク/
lhasa /ラサ/拉薩/
lhotse /ローツェ/
li /リチウム/Lithium/
lia /リア/
liaison /リエゾン/
liam /リアム/リーアム/
liane /リアーヌ/
liar /Ｌｉａｒ/
lib /ライブラリ/ライブラリー/リブ/
libby /リビー/
libera /リベラ/
liberal /リベラル/
liberalism /リベラリズム/
liberalist /リベラリスト/
liberation /リベレーション/リベラシオン;仏語/
liberia /リベリア;.lr/
libero /リベロ/
libertarian /リバタリアン/
libertarianism /リバタリアニズム/
liberte /リベルテ;(Fr)自由/
liberty /リバティ/リバティー/
libido /リビドー/
libra /リブラ;天秤座/リーブラ/
librarian /ライブラリアン/
library /ライブラリ/ライブラリー/
libre /リーブル;(Fr)自由な/
libro /リブロ/
libya /リビア;.ly/
licence /ライセンス/
licencekey /ライセンスキー/
license /ライセンス/
licensee /ライセンシー/
licensekey /ライセンスキー/
licenser /ライセンサー/
licensing /ライセンシング/
lich /リッチ/
lichtenstein /リキテンシュタイン/リキテンスタイン/
lick /リック/
lid /リッド/
lida /リーダ/リダ/
liddell /リデル/
liddi /リディ/
liddy /リディ/
lidia /リディア/
lidocaine /リドカイン/
liebe /リーベ;(独) 愛/
liechtenstein /リヒテンシュタイン;.li/
lied /リート/
lieder /リーダー/
liege /リエージュ/
liesa /リーザ/
liese /リーゼ/
lieu /リュー;(Fr)場所/
life /ライフ/
lifeboat /ライフボート/
lifecycle /ライフサイクル/
lifegame /ライフゲーム/
lifeguard /ライフガード/
lifehistory /ライフヒストリー/
lifejacket /ライフジャケット/
lifeline /ライフライン/
lifeplan /ライフプラン/
lifesaver /ライフセーバー/
lifesaving /ライフセービング/
lifescience /ライフサイエンス/
lifeservice /ライフサービス/
lifestage /ライフステージ/
lifestyle /ライフスタイル/
lifetime /ライフタイム/
lifework /ライフワーク/
lift /リフト/
lifter /リフター/
lifting /リフティング/
liftup /リフトアップ/
light /ライト/
lightbeige /ライトベージュ/
lightblue /ライトブルー/
lightbrown /ライトブラウン/
lighter /ライター/
lightgray /ライトグレー/
lightgreen /ライトグリーン/
lightgrey /ライトグレー/
lighthouse /ライトハウス/
lighting /ライティング/
lightmiddle /ライトミドル/
lightning /ライトニング/
lightnovel /ライトノベル/
lightup /ライトアップ/
lightvan /ライトバン/
lightyellow /ライトイエロー/
lignan /リグナン/
lignin /リグニン/
lihue /リフエ;lih/
like /ライク/
likud /リクード/
lil /リル/
lila /リラ/
lilac /リラ/ライラック/
lilas /リラ/
lili /リリー/リリ/
lilia /リリア/
lilian /リリアン/
liliane /リリアン/
lilienthal /リリエンタール/
lille /リール/
lilli /リリ/リリー/
lillian /リリアン/
lillie /リリー/
lilliput /リリパット/
lilly /リリー/
lilongwe /リロングウェ/
lily /リリー/リリィ/
lima /リマ/
liman /リマン/
limbo /リンボー/リンボ/
limbodance /リンボーダンス;limbo/
lime /ライム/
limegreen /ライムグリーン/
limelight /ライムライト/
limit /リミット/
limitcycle /リミットサイクル/
limited /リミテッド/
limiter /リミッター/リミッタ/
limoges /リモージュ/
limoncello /リモンチェッロ/
limonen /リモネン/
limousine /リムジン/
limousinebus /リムジンバス/
lin /リン/
lina /リナ/リーナ/
lincoln /リンカーン/
linda /リンダ/
lindberg /リンドバーグ;(ポピュラーバンド名)/
lindbergh /リンドバーグ;(1902-1974) Charles Augustus Lindbergh 飛行家/
linden /リンデン/
lindgren /リンドグレーン/
lindie /リンディ/リンディー/
lindsay /リンゼイ/リンジー/
lindsey /リンゼイ/リンジー/
lindy /リンディ/
line /ライン/‾/＿/リーネ;(独語人名)/リヌ/
lineage /リネージュ;[ゲーム]www.lineage.com/
linear /リニア/
linearmotor /リニアモーター/
linearmotorcar /リニアモーターカー/
lineback /ラインバック;linebacker/
linebacker /ラインバッカー/
linedance /ラインダンス/
linefeed /ラインフィード/
linein /ラインイン/
linen /リネン/
lineout /ラインアウト/
liner /ライナー/
linernote /ライナーノート/
linernotes /ライナーノーツ/
lineset /ラインセット/
linet /リネット/
lineup /ラインナップ/ラインアップ/
ling /リング/リン/
linga /リンガ/
linger /リンガー/
lingerie /ランジェリー/
lingerieshop /ランジェリーショップ/
lingua /リンガ;(Lat) 言語/
linguafranca /リンガフランカ/
lingual /リンガル/
lining /ライニング/
link /リンク/
linkage /リンケージ/
linkbanner /リンクバナー/
linked /リンクト/
linker /リンカ/リンカー/
linkfield /リンクフィールド/
linkfree /リンクフリー;当然/
linkpage /リンクページ/
linkpolicy /リンクポリシー/
links /リンクス/
linksite /リンクサイト/
linn /リン/
linne /リンネ/
linnea /リネア/
linnet /リネット/
lino /リノ/
linoleum /リノリウム/
linsey /リンゼイ/
lint /リント/
linus /ライナス/リーナス/リヌス/
linux /リナックス/ライナックス/リヌクス/リヌックス/リーヌックス/Linux/
linz /リンツ/
lion /ライオン/
lionel /ライオネル/リオネル/
lioness /ライオネス/
lions /ライオンズ/
lionsclub /ライオンズクラブ;www.lionsclub.org/
lionsmansion /ライオンズマンション;[商標]大京/
lip /リップ/
lipase /リパーゼ/
lipbrush /リップブラシ/
lipcream /リップクリーム/
lipline /リップライン/
lipliner /リップライナー/
lipo /リポ/
lippi /リッピ/
lips /リップス/
lipservice /リップサービス/
lipslur /リップスラー/
lipstick /リップスティック/
lipton /リプトン;www.lipton.com/
liqueur /リキュール/
liquid /リキッド/
liquor /リカー/
lira /リラ/
lirica /リリカ/
lirico /リリコ/
lisa /リサ/リザ/リーザ/ライザ/
lisbon /リスボン/
lisle /ライル/リール/
lisleadam /リラダン;(1838-1889) Auguste de Villiers de L'Isle-Adam/
lisp /リスプ/Ｌｉｓｐ/Lisp/
lisper /Ｌｉｓｐｅｒ/ｌｉｓｐｅｒ/
lissa /リサ/
list /リスト/
listbox /リストボックス/
listen /リッスン/
listener /リスナー/リスナ/
listening /リスニング/
listing /リスティング/
listup /リストアップ/
liszt /リスト/
lit /リット/
litchi /ライチ/
lite /ライト/Ｌｉｔｅ/
liter /リットル/リッター/リター/
literacy /リテラシー/リテラシ/
literal /リテラル/
lithium /リチウム/
lithiumion /リチウムイオン;lithium-ion/
lithograph /リトグラフ/
lithography /リソグラフィ/リソグラフィー/
lithuania /リトアニア;.lt/
litmus /リトマス/
litre /リットル/リッタ/
littbarski /リトバルスキー/
litter /リットル/リッター/リター/
little /リトル/
littleleague /リトルリーグ/
littre /リトレ/
live /ライブ/ライヴ/
livealbum /ライブアルバム/
livecamera /ライブカメラ/
livecd /ライブCD/
livechat /ライブチャット/
livedoor /ライブドア;livedoor.com/
livedvd /ライブDVD/
liveevent /ライブイベント/
livehouse /ライブハウス/ライヴハウス/
livelock /ライブロック/
lively /ライブリー/
liver /レバー/
liverecording /ライブレコーディング/
livereport /ライブレポート/
liverpaste /レバーペースト/
liverpool /リバプール/リヴァプール/
lives /ライブス/
liveschedule /ライブスケジュール/
liveshow /ライブショー/
liveticket /ライブチケット/
livetour /ライブツアー/
liveunderthesky /ライヴ・アンダー・ザ・スカイ/
livevideo /ライブビデオ/
living /リビング/
livingdead /リビングデッド/
livingroom /リビングルーム/
livingstone /リビングストン/リヴィングストン/
livingtable /リビングテーブル/
livre /リーブル/リーヴル/£/
liz /リズ/
liza /リザ/ライザ/
lizard /リザード/
lizardman /リザードマン/
lizzie /リジー;Elizabeth/
lizzy /リジー;Elizabeth/
ljubljana /リュブリャーナ/
ll /≪/
lladro /リヤドロ/
llama /ラマ/リャマ/
lloyd /ロイド/
llsize /LLサイズ/ＬＬサイズ/
lm /ロードモジュール/
lmenthol /l-メントール/
load /ロード/
loadable /ローダブル/
loadbalancer /ロードバランサー/ロードバランサ/
loader /ローダー/ローダ/
loading /ローディング/
loadmodule /ロードモジュール/
loady /ローディ/
loafer /ローファー/
loafers /ローファー/
loam /ローム/
loan /ローン/
loancard /ローンカード/
lob /ロブ/
lobbing /ロビング/
lobby /ロビー/
lobbying /ロビイング/
lobbyist /ロビイスト/
lobelia /ロベリア/
lobo /ロボ/
lobotomy /ロボトミー/
lobster /ロブスター/
local /ローカル/局所/
localaddress /ローカルアドレス/
localarea /ローカルエリア/
locale /ロケール/ロカール/
localhost /ローカルホスト/
localip /ローカルIP/
localisation /ローカリゼーション/ローカライゼーション/
localise /ローカライズ/
localism /ローカリズム/
locality /ローカリティ/
localization /ローカリゼーション/ローカライゼーション/
localize /ローカライズ/
localminima /ローカルミニマ/局所的最良解/
localnews /ローカルニュース/
localrule /ローカルルール/
localtime /ローカルタイム/
locate /ロケート/
location /ロケーション/
locator /ロケータ/
lock /ロック/施錠/
locke /ロック/
locker /ロッカー/
lockerroom /ロッカールーム/
lockfile /ロックファイル/
lockheed /ロッキード/
lockin /ロックイン;lock-in/
locking /ロッキング/
lockmode /ロックモード/
lockon /ロックオン;lock-on/
lockout /ロックアウト/
loco /ロコ/
locomoco /ロコモコ;(ハワイ語)/
locomotion /ロコモーション/
locrian /ロクリアン;BCDEFGAB/
locus /ローカス/
lode /ロード/
lodge /ロッジ/
loeb /ローブ/
loewe /ロエベ;www.loewe.com/
loft /ロフト/Ｌｏｆｔ/
loftbed /ロフトベッド/
log /ログ/
logan /ローガン/
logdata /ログデータ/
logfile /ログファイル/
logger /ロガー/
logging /ロギング/ログィング;<rare>/
loghouse /ログハウス/
logic /ロジック/⊃;superset/∧;and/∨;or/¬;not/∀;all/∃;exist/論理/
logical /ロジカル/
logicool /ロジクール;www.logicool.co.jp/
logicprogramming /ロジック・プログラミング/
login /ログイン/
loginid /ログインID/
logistic /ロジスティック/ロジスティク/
logistics /ロジスティクス/ロジスティックス/
logit /ロジット/
logitech /ロジテック;www.logitech.com/
logo /ロゴ/
logoff /ログオフ/
logomark /ロゴマーク;和製英語(logo)/
logon /ログオン/
logos /ロゴス/
logotype /ロゴタイプ/
logout /ログアウト/
logue /ローグ/
logy /ロジー/
lohengrin /ローエングリン/
loire /ロワール/ロアール/
lois /ロイス/
loki /ロキ/
lola /ローラ/
loli /ロリ;Lolita, lolicon/
lolicon /ロリコン;Lolita complex, pedophilia/
lolita /ロリータ/
lollipop /ロリポップ/
lolo /ロロ/
lombardi /ロンバルディ/
lombardia /ロンバルディア/
lombok /ロンボク/ロンボック/
lome /ロメ/
london /ロンドン/
londonboots /ロンドンブーツ;和製英語(platform shoes)/
londonderry /ロンドンデリー/
lone /ローン/
lonely /ロンリー/ロンリィ/
lonewolf /ローンウルフ;lone wolf/
long /ロング/
longbeach /ロングビーチ/
longboard /ロングボード/
longboots /ロングブーツ/
longcoat /ロングコート/
longdress /ロングドレス/
longfellow /ロングフェロー/
longhair /ロングヘア/ロングヘアー/
longhit /ロングヒット;和製英語(extra-base)/
longhole /ロングホール;par-5/
longine /ロンジン/
longiron /ロングアイアン;2-4/
longisland /ロングアイランド/
longneck /ロングネック/
longo /ロンゴ/
longpass /ロングパス/
longputt /ロングパット/
longrun /ロングラン/
longseller /ロングセラー/
longshoot /ロングシュート/
longshot /ロングショット/
longsize /ロングサイズ/
longskirt /ロングスカート/
longsleeve /ロングスリーブ/
longstay /ロングステイ/
longsword /ロングソード/
longtime /ロングタイム/
longueville /ロングヴィル/
longversion /ロングバージョン/
longword /ロングワード/
lonnie /ロニー/
lonny /ロニー/
lonsdale /ロンズデール/
look /ルック/
lookahead /ルックアヘッド/
looking /ルッキング/
looks /ルックス/
lookup /ルックアップ/
loom /ルーム/
loop /ループ/
loopback /ループバック/
loose /ルース/ルーズ;NB:日本式発音/
looseleaf /ルーズリーフ/
loosesocks /ルーズソックス/
loosesox /ルーズソックス;loose socks/
lopez /ロペス/
lor /∨/
lora /ローラ/
lorca /ロルカ/
lord /ロード/
lore /ロア/
loreal /ロレアル;l'Oreal/
lorelei /ローレライ/
loren /ローレン/
lorena /ロリーナ/
lorentz /ローレンツ/
lorenz /ローレンツ/
lorenzo /ロレンツォ/ロレンソ/
loretta /ロレッタ/
lorin /ローリン/
loris /ロリス/
lorna /ローナ/
lorraine /ロレーヌ/ロレイン/
lorry /ローリー/
los /ロス/ロス・アンゼルス;los Angeles NB:losは単なる冠詞/
losalamos /ロスアラモス/ロス・アラモス/
losangeles /ロサンゼルス/ロサンジェルス/ロスアンゼルス/ロスアンジェルス/
lose /ルーズ/
loser /ルーザー/
loss /ロス/
losstime /ロスタイム;和製英語(extra time)/
lost /ロスト/
lostvirgin /ロストバージン;和製英語/
lot /ロット/ロト;[聖書]/
lothar /ローター/
loti /ロティ/
lotion /ローション/
lotnumber /ロットナンバー/
lotta /ロッタ/
lotte /ロッテ/
lotteria /ロッテリア/
lottie /ロッティ/
lotto /ロト/ロット/
lotus /ロータス/
lou /ルー/
loud /ラウド/
loudness /ラウドネス/
loudspeaker /ラウドスピーカー/ラウドスピーカ/
louis /ルイ/ルイス/
louisa /ルイザ/ルイーザ/
louise /ルイーズ/ルイズ/
louisiana /ルイジアナ;LA/
louison /ルイゾン/
louisvuitton /ルイヴィトン/ルイ・ヴィトン/
loukas /ルカ/
loulou /ルル/
lounge /ラウンジ/
loura /ローラ/
loussier /ルーシェ/
louver /ルーバー/
louvre /ルーブル;-美術館/ルーヴル/
love /ラブ/ラヴ/
lovecall /ラブコール/
lovecome /ラブコメ;love comedy/
lovecomedy /ラブコメディ/ラブコメディー/ラブコメ/
lovecraft /ラヴクラフト/ラブクラフト/
lovedoll /ラブドール/
lovegoods /ラブグッズ/
loveho /ラブホ/
lovehotel /ラブホテル/ラヴホテル/
lovejuice /ラブジュース/
loveletter /ラブレター/ラヴレター/
lovelove /ラブラブ;和製英語(lovey-dovey)/
lovely /ラブリー/
lover /ラバー/ラヴァー/
loveromance /ラブロマンス;love and romance/
lovers /ラヴァーズ/ラバーズ/
lovescene /ラブシーン/
lovesong /ラブソング;love song/
lovestory /ラブストーリー/ラブ・ストーリー/
loving /ラビング/ラヴィング/
low /ロー/ロウ/
lowangle /ローアングル/
lowblow /ローブロー/
lowcalorie /ローカロリー/
lowcost /ローコスト/
lowell /ローウェル/
lowend /ローエンド/
lowfat /ローファット/
lowheel /ローヒール/
lowkick /ローキック/
lowlevel /ローレベル/
lowpass /ローパス/
lowprice /ロープライス/
lowprofile /ロープロファイル/
lowrise /ローライズ;low-rise/
lowrisk /ローリスク/ロウリスク/
lowry /ローリー/ロウリー/
lowspec /ロースペック/
lowtech /ローテク;low technology/
lowteen /ローティーン/
lowtension /ローテンション/
lowtom /ロータム/
lox /ロックス/
loy /ロイ/
loyalty /ローヤリティ;忠誠/
loyola /ロヨラ/
lp /LP/
lpc /LPC/
lpf /ローパスフィルタ;lowpass filter/
lpgas /LPガス/
lprecord /LPレコード/
lr /ローレンシウム/Lawrencium/
lse /最小2乗法;Least Squares Estimation/
lsize /Lサイズ/Ｌサイズ/
lt /＜/
lu /ルテチウム/Lutetium/ルー/
lua /ルア/
luana /ルアナ/
luanda /ルアンダ/
lubeck /リューベック/
luc /リュック/
luca /ルカ/ルーカ/ルッカ/
lucas /ルーカス/
luce /ルース/ルス/リュス/
luchino /ルキノ/
lucia /ルシア/ルチア/ルーシア/
lucian /ルシアン/
luciano /ルチアーノ/ルチャーノ/
lucid /ルーシッド/Ｌｕｃｉｄ/Lucid/
lucie /ルーシー/
lucien /ルシアン/リュシアン/
lucifer /ルシファー/
lucile /ルシル/
lucille /ルシル/ルシール/
lucinda /ルシンダ/
lucio /ルチオ/ルーチョ/ルシオ/
luck /ラック/
lucky /ラッキー/Ｌｕｃｋｙ/
lucky7 /ラッキーセブン/
luckyseven /ラッキーセブン/
luckystrike /ラッキーストライク/
luckyzone /ラッキーゾーン/
lucretia /ルクレチア/
lucrezia /ルクレツィア/
lucy /ルーシー/
ludens /ルーデンス;(Lat.) 遊ぶ/
ludmilla /リュドミラ/
ludo /ルード;(It)仮面劇/
ludwig /ルートヴィヒ/
lufthansa /ルフトハンザ;www.lufthansa.de/
lug /ラグ/
luge /リュージュ/
luger /ルガー/ルーガー/
luggage /ラゲージ/
luigi /ルイージ/ルイジ/
luis /ルイ/ルイス/
luisa /ルイーザ/
luise /ルイーゼ/
lukacs /ルカーチ/
lukas /ルーカス/
luke /ルカ/ルーク/
lukes /ルークス/
lula /ルーラ/
lullaby /ララバイ/
lulu /ルル/リュリュ/
lumbini /ルンビニ/ルンビニー/
lumen /ルーメン/
lumi /ルミ/
lumiere /リュミエール/ルミエール/
lumine /ルミネ/
luminescence /ルミネッセンス/ルミネセンス/
luminous /ルミナス/
lump /ランプ/
lumpen /ルンペン/
lun /Logical Unit Number/
luna /ルナ/Ｌｕｎａ/ＬＵＮＡ/
lunar /ルナー/
lunatic /ルナティック/
lunch /ランチ/
lunchbox /ランチボックス/
luncheon /ランチョン/
luncheonmat /ランチョンマット/
lunchset /ランチセット/
lunchtime /ランチタイム/
lune /ルーン/リューヌ;仏語/
lung /ラング/
lupe /ルーペ/
lupin /ルパン/
lupine /ルピナス/
lupinus /ルピナス/
luque /ルケ/
lure /ルアー/
lurefishing /ルアーフィッシング/
lust /ラスト/ルスト;(独語)欲望/
lute /リュート/
lutecium /ルテチウム;[元素]71,Lu/
lutetium /ルテチウム;[元素]71,Lu/
luther /ルター/ルーテル/ルーサー/
lutz /ルッツ/
luv /ラブ;=love/
lux /ルクス/
luxembourg /ルクセンブルク;.lu/ルクセンブルグ/リュクサンブール/
luxemburg /ルクセンブルク/
luxor /ルクソール;エジプト/
luxury /ラグジュアリー/
luzern /ルツェルン/
luzon /ルソン/
ly /リー;(接尾辞)/リィ/
lyall /ライアル/
lycaon /リカオン/
lycee /リセ/
lycopene /リコピン/
lycoris /リコリス/
lydia /リディア/
lydian /リディアン;FGABCDEF/
lyle /ライル/
lymph /リンパ/
lympha /リンパ/
lynch /リンチ/
lyndon /リンドン/
lynette /リネット/
lynn /リン/
lynne /リン/
lynx /リンクス/
lyon /リヨン/
lyotard /リオタール/
lyric /リリック/
lyrical /リリカル/
lys /リス/
lysine /リジン;Lys/
lysosome /リソソーム/
lysozym /リゾチーム/
m /μ;mu/エム/メートル/
m# /Ｍ#1/
m17n /multilingualization/多言語化/
ma /マ/Massachusetts/マサチューセッツ/
maar /マール/
maas /マース/マーズ/
maastricht /マーストリヒト/
maazel /マゼール/
mab /マブ/
mabel /メイベル/メーベル/
mac /マック/Ｍａｃ/マッキントッシュ/Macintosh/Ｍａｃｉｎｔｏｓｈ/マク/
macadamia /マカダミア/マカデミア/
macadamianuts /マカダミアナッツ/
macaddress /MACアドレス/
macaron /マカロン/
macaroni /マカロニ/
macaronigratin /マカロニグラタン/
macaroniwestern /マカロニウエスタン/マカロニウェスタン/
macaroon /マカロン/
macarthur /マッカーサー;MacArthur/
macau /マカオ;.mo/
macbeth /マクベス/
macdonald /マクドナルド;MacDonald/
mace /メイス/
macedonia /マケドニア;.mk/マチェドニア;(イタリア語)/
macfarlane /マクファーレン/
macguffin /マクガフィン/
mach /マッハ/マッハ数/Ｍａｃｈ/Mach/
machiavelli /マキャベリ/マキアヴェッリ/マキアヴェリ/マキアベリ/
machiavellism /マキャベリズム/マキアヴェリズム/
machine /マシン/マシーン/計算機/ミシン;sawing machine/
machinegun /マシンガン/
machineguntalk /マシンガントーク/
machinepower /マシンパワー/
machineroom /マシンルーム/
machinery /マシナリー/
machinevision /マシンビジョン/マシン・ビジョン/
machining /マシニング/
macho /マッチョ/
machupicchu /マチュピチュ;Machu Picchu,Peru/
macintosh /マッキントッシュ/
mackenzie /マッケンジー/
maclaine /マクレーン/マクリーン/
maclean /マクレーン/マクリーン/
macpherson /マクファーソン/
macro /マクロ/
macrobiotic /マクロビオティック/
macrolens /マクロレンズ/
macromedia /マクロメディア;www.macromedia.com/
macromodel /マクロモデル;macro-model/
macrophage /マクロファージ/
macross /マクロス/
macrovirus /マクロウイルス/マクロウィルス/
mad /マッド/
madagascar /マダガスカル;.mg/
madam /マダム/
madame /マダム/
made /メイド/メード/
madein /メイドイン;made in ~/メイド・イン・/
madeinjapan /メイドインジャパン/メイド・イン・ジャパン/made in Japan/日本製/
madeira /マデイラ/
madeleine /マドレーヌ/
madeline /マドリン/マデリン/
mademoiselle /マドモアゼル/マドモワゼル/
madness /マッドネス/
madonna /マドンナ/
madras /マドラス/
madrid /マドリッド/マドリード/
madrigal /マドリガル/
madrigale /マドリガーレ/
madscientist /マッドサイエンティスト/
mae /メイ/
maestoso /マエストーソ/
maestra /マエストラ/
maestro /マエストロ/
maetel /メーテル;また一つ星が消えるよ/
maeterlinck /メーテルリンク/メーテルランク/
mafia /マフィア/
mag /マグニチュード;magnitude/マグ/
maga /マガ;magazine/
magagine /マガジン;※magazine/
magali /マガリ/
magazine /マガジン/
magazinehouse /マガジンハウス;www.magazine.co.jp/
magazinerack /マガジンラック/
magazines /マガジンズ/
magda /マグダ/
magdala /マグダラ;-のマリア/
magdalena /マグダレーナ/マグダレナ/
mage /メイジ/
magellan /マゼラン/
magenta /マゼンタ/
maggie /マギー/
maggy /マギー/
maghreb /マグレブ/
magic /マジック/
magical /マジカル/
magicgate /マジックゲート/
magichand /マジックハンド/
magician /マジシャン/
magicmirror /マジックミラー/
magicmushroom /マジックマッシュルーム/
magicnumber /マジックナンバー/
magictape /マジックテープ;和製英語(velcro)/
magik /マジック;magic/
magma /マグマ/
magnacarta /マグナカルタ;Magna Carta/
magnesia /マグネシア;MgO,苦土/
magnesium /マグネシウム;[元素]12,Mg/
magnesiumion /マグネシウムイオン;magnesium ion/
magnet /マグネット/
magnetic /マグネティック/マグネチック/
magnetite /マグネタイト/
magnificat /マニフィカト/
magnitude /マグニチュード/
magnum /マグナム/
magnus /マグナス/マグヌス/
magritte /マグリット/
maguire /マグワイア/
magyar /マジャール;ハンガリー/
magzine /マガジン;※magazine/
mahabharata /マハーバーラタ/
mahalanobis /マハラノビス/
maharaja /マハラジャ/
mahdi /マフディ;[イスラム]救世主/マフディー/
mahjong /マージャン/
mahler /マーラー/
mahogany /マホガニー/
maia /マイア/
maid /メイド/メード/
maiden /メイデン/
maier /マイヤー/
maigret /メグレ/
maija /マイヤ/
maik /マイク/
mail /メール/メイル/手紙/〒/
mailaccount /メールアカウント/
mailaddress /メールアドレス/
mailbomb /メールボム;mail bomb/
mailbox /メールボックス/
mailcheck /メールチェック/
mailclient /メールクライアント/
mailer /メーラー/メーラ/メイラ/メイラー/
mailfilter /メールフィルタ/
mailfiltering /メールフィルタリング/
mailform /メールフォーム/
mailfriend /メールフレンド/
mailheader /メールヘッダ/
mailing /メーリング/メイリング/
mailing-list /メイリングリスト/
mailinglist /メーリングリスト/メイリングリスト/
maillist /メールリスト/メイルリスト/
maillol /マイヨール/
maillot /マイヨ/
maillotjaune /マイヨジョーヌ/
mailmaga /メルマガ;e-mail magazine/
mailmagazine /メールマガジン;e-mail magazine/
mailnews /メールニュース/
mailorder /メールオーダー/
mailpassword /メールパスワード/
mailreader /メールリーダー/
mailserver /メールサーバー/メールサーバ/メイルサーバ/
mailservice /メールサービス/
mailsoft /メールソフト;e-mail client/
mailsystem /メールシステム/
main /メイン/メーン/マイン/
mainbank /メインバンク/メーンバンク/
mainboard /メインボード/
maincast /メインキャスト/
maincontents /メインコンテンツ/
maindish /メインディッシュ/
maine /メーン;ME/
mainecoon /メインクーン/
mainevent /メインイベント/
mainframe /メインフレーム/
maingate /メインゲート/
mainmachine /メインマシン/
mainmemory /メインメモリ/
mainmenu /メインメニュー/
mainpage /メインページ/
mainroutine /メインルーチン/
mainsite /メインサイト/
mainstage /メインステージ/
mainstand /メインスタンド/
mainstream /メインストリーム/
mainstreet /メインストリート/
maintainance /メンテナンス/
maintainancefree /メンテナンスフリー/
maintainer /メンテナ/メンテナー/
maintarget /メインターゲット/
mainte /メンテ;maintenance/
maintenance /メンテナンス/メインテナンス/
maintheme /メインテーマ/
maintitle /メインタイトル/
mainvocal /メインボーカル/
mainwindow /メインウィンドウ/メインウインドー/メーンウインドー;<rare>/
mainz /マインツ/
maira /マイラ/
maiskii /マイスキー/
maison /メゾン/
maisonette /メゾネット/
maitai /マイタイ;mai tai/
maitre /メートル/
maj /マイ/
majesta /マジェスタ/
majesty /マジェスティ/マジェスティー/
majong /麻雀;mah-jong?/
major /メジャー/メージャー/メイジャー/メージャ/
majorca /マジョルカ;(英語風表記) =mallorca/
majordebut /メジャーデビュー;和製英語/
majority /マジョリティ/マジョリティー/
majorlabel /メジャーレーベル/
majorleague /メジャーリーグ/
majorleaguer /メジャーリーガー/
majormode /メジャーモード/
majorversion /メジャーバージョン/
majuro /マジュロ/
make /メイク/メーク/
makedonia /マケドニア/
makefile /makeファイル/メイクファイル/メークファイル/Makefile/
makelele /マケレレ/
makelove /メイクラブ;skk: don't know how to make love. Stop/
maker /メーカー/メーカ/メイカー/
makerbrand /メーカーブランド/
makeup /メイクアップ/メークアップ/メーキャップ/メイキャップ/
makeupartist /メイクアップアーティスト;美容師/
makgeoolri /マッコリ;(朝鮮語)/
makgoli /マッコリ;(朝鮮語)/
making /メイキング/メーキング/
maksim /マクシム/
mal /マル/モール/マール/
malabo /マラボ/
malacca /マラッカ/
malachi /マラキ/マラカイ/
malachite /マラカイト/
malaga /マラガ;スペイン/
malaguena /マラゲーニャ/
malai /マレー/
malaria /マラリア/
malawi /マラウイ;.mw/マラウィ/
malay /マレー/
malaysia /マレーシア;.my/
malaysiagp /マレーシアGP;[F1]/
malcom /マルコム/
maldini /マルディーニ/
maldives /モルディブ;.mv/モルジブ/
maldoror /マルドロール/
male /メール/♂/マーレ/
mali /マリ;.ml/
malia /マリア/
malibu /マリブ/
malik /マリク/
malinowski /マリノフスキー/
mall /モール/
mallarme /マラルメ/
malle /マル/
mallet /マレット/
mallorca /マジョルカ/
mallow /マロー/マロウ/
malory /マロリー/
malraux /マルロー/
malt /モルト/
malta /マルタ;.mt/
maltese /マルチーズ/
malthus /マルサス/
maltitol /マルチトール/
maltose /マルトース/
maltwhiskey /モルトウイスキー/モルトウィスキー/
malware /マルウェア/
mama /ママ/
maman /ママン/
mambo /マンボ/
mamluk /マムルーク/
mamma /マンマ/
mammoth /マンモス/
mammy /マミー/
man /マン/♂/マニュアル/
man-machine /マン-マシン/
mana /マナ/
manage /マネージ/
managed /マネージド/
management /マネジメント/マネージメント/
manager /マネージャー/マネージャ/マネジャー/マネジャ/
managing /マネージング/
managua /マナグア/
manama /マナーマ/
manas /マナス/
manatee /マナティ/マナティー/
manaus /マナウス/
mance /マンス/
manchester /マンチェスター/
mancini /マンシーニ/マンチーニ/
mancur /マンサー/
mandala /マンダラ/曼荼羅;mandala/曼陀羅/
mandalay /マンダレー/
mandarin /マンダリン/
mandela /マンデラ/
mandelbrot /マンデルブロ/マンデルブロー/マンデルブロート/
mandelin /マンデリン/
mandiargues /マンディアルグ/
mandola /マンドラ/マンドーラ/
mandolin /マンドリン/
mandoline /マンドリン/
mandolino /マンドリーノ/
mandom /マンダム;www.mandom.co.jp/
mandrake /マンドレイク/マンドレーク/
mandrill /マンドリル/
mandy /マンディ/マンディー/
manet /マネ/
maneuver /マヌーバー/マヌーヴァー/
manfred /マンフレッド/
manga /マンガ/
mangan /マンガン;Mn/
manganese /マンガン;[元素]25,Mn/
mangatic /マンガチック;和製英語/
mango /マンゴー/マンゴ/
mangold /マンゴールド/
mangosteen /マンゴスチン/
mangrove /マングローブ/
manhattan /マンハッタン/
manhole /マンホール/
mania /マニア/
maniac /マニアック/
manicure /マニキュア/
maniera /マニエラ;(It)様式/
manierisme /マニエリスム/
manifest /マニフェスト/
manifesto /マニフェスト;政権公約/
manila /マニラ/
manipulate /マニピュレイト/
manipulation /マニピュレーション/
manipulator /マニピュレータ/マニピュレーター/
mann /マン/
manna /マナ/マンナ/
mannan /マンナン/
mannequin /マネキン/マヌカン/
manner /マナー/
mannerism /マンネリズム/マンネリ/
mannermode /マナーモード/
mannheim /マンハイム/
mannish /マニッシュ/
mannose /マンノース/
manns /マンス/
manolo /マノロ/
manon /マノン/
manpower /マンパワー/
manque /マンケ/
mansard /マンサード/
mansell /マンセル/
mansfield /マンスフィールド/
manshon /マンション;※mansion/
mansion /マンション/
manson /マンソン/
manta /マンタ/
manteau /マント/
mantelpiece /マントルピース/
manticore /マンティコア/
mantis /マンティス/
mantle /マントル/
mantoman /マンツーマン/
mantra /マントラ/
manu /マヌ/
manual /マニュアル/
manualpage /マニュアルページ/
manuel /マヌエル/マニュエル/マニエル/
manuela /マヌエラ/マニュエラ/
manufacture /マニュファクチュア/マニュファクチャー/
manuscript /マニュスクリプト/
manx /マンクス/
many /メニー/メニ/
manya /マーニャ/
map /マップ/写像/
mapentry /マップエントリ/
maple /メイプル/メープル/
maplesyrup /メープルシロップ/メイプルシロップ/
mapped /マップド/
mapping /マッピング/
mapplethorpe /メイプルソープ/
mappy /マッピー;[ゲーム]ナムコ/
maputo /マプート/
mara /マラ/
maracas /マラカス/
marais /マレー/
maraschino /マラスキーノ/
marathon /マラソン/マラトン/
marathoncourse /マラソンコース/
marble /マーブル/
marbling /マーブリング/
marc /マルク/マーク/
marca /マルカ/
marceau /マルソー/
marcel /マルセル/マーセル/
marcela /マルセラ/マルチェラ/
marcelino /マルセリーノ/
marcelle /マルセル/
marcello /マルチェロ/マルチェッロ/
marcelo /マルセロ/
march /マーチ/
marchand /マルシャン/
marche /マルシェ;仏語/マルシュ;(Fr)歩み/
marching /マーチング/
marchingband /マーチングバンド/
marcia /マーシャ/マルシア/
marcica /マーシカ/
marcie /マーシー/
marco /マルコ/マーコ/
marconi /マルコーニ/
marcopolo /マルコポーロ;Marco Polo/
marcos /マルコス/
marcus /マルコ/マーカス/マルクス;(ローマ皇帝)/
marcy /マーシー/
marek /マレック/マレク/
maresca /マレスカ/
margaret /マーガレット/
margarete /マルガレーテ/
margarine /マーガリン/
margarita /マルガリータ/
margaux /マルゴー/マルゴ/
marge /マージ/
margery /マージェリー/
margherita /マルゲリータ/
margie /マージー/
margin /マージン/
marginal /マージナル/
margo /マーゴ/
margot /マルゴ/マーゴット/
margrit /マルグリット/
marguerite /マーガレット/マルグリット/
margueritte /マルグリット/
mari /マリ;(Fr)夫/マリー/
maria /マリア/
mariage /マリアージュ;仏語/
mariah /マライア/
marian /マリアン/
mariana /マリアナ;.mp/
mariane /マリアン/
marianna /マリアンナ/
marianne /マリアン/マリアンヌ/マリアンネ/
mariano /マリアーノ/マリアノ/
marie /マリー/マリエ;(Fr)花婿/
mariee /マリエ;(Fr)花嫁/
mariel /マリエル/
marielle /マリエル/
marienbad /マリエンバート/マリエンバード/
marier /マリエ;(Fr)結婚する/
marietta /マリエッタ/
marigold /マリーゴールド/マリゴールド/
marihuana /マリファナ/
marija /マリヤ/
marijuana /マリファナ/
marika /マリカ/
marilla /マリラ/
marilyn /マリリン/
marimba /マリンバ/
marin /マリン/
marina /マリーナ/マリナ/
marine /マリン/マリーン/マリネ/
marineblue /マリンブルー/
marinera /マリネラ/
mariners /マリナーズ;[MLB]/
marines /マリーンズ/
marinesnow /マリンスノー/
marinesport /マリンスポーツ/
marinesports /マリンスポーツ/
marini /マリーニ/
marino /マリノ/マリーノ/
marinos /マリノス;[Jリーグ]横浜/
marinovski /マリノフスキー/
mario /マリオ/
marion /マリオン/
marionette /マリオネット/
maris /マリス/
marisa /マリサ/
marius /マリウス/
marjoram /マージョラム/
marjorie /マージョリー/
mark /マーク/マルク/
marker /マーカー/マーカ/
market /マーケット/
marketer /マーケッター/
marketing /マーケティング/
marketplace /マーケットプレイス/
marking /マーキング/
marko /マルコ/
markos /マルコス/
markov /マルコフ/マルコフ過程/マルコフ遷移/
markovmodel /マルコフモデル;Markov model/
marks /マークス/
marksheet /マークシート/
markup /マークアップ/
markus /マルクス/マーカス/
marl /マール/
marlboro /マルボロ/マールボロ/
marlene /マレーネ/マルレーン/
marley /マーリー/マーレイ/
marlin /マーリン/
marlins /マーリンズ;[MLB]/
marlon /マーロン/
marlowe /マーロウ/
marmalade /マーマレード/
marmelo /マルメロ;(ポルトガル語)/
marmoset /マーモセット/
marmot /モルモット;(蘭語) guinea pig/マーモット/
marne /マルヌ/
marnier /マルニエ/
maro /マロー/マロ/
maroon /マルーン/
marot /マロ/
marquee /マーキー/
marquez /マルケス/
marquis /マルキ/
marquise /マルキーズ/
marrakesh /マラケシュ;モロッコ/
marriage /マリッジ/
marriagering /マリッジリング/
marric /マリック/
marriott /マリオット/
marriotte /マリオット/
marron /マロン/
marronglace /マロングラッセ;marron glace/
marronnier /マロニエ/
marry /マリー/
mars /マーズ/マルス/
marsalis /マルサリス/
marseillaise /マルセイエーズ/
marseille /マルセイユ/マルセーユ/
marsh /マーシュ/
marsha /マーシャ/
marshal /マーシャル/
marshaling /マーシャリング/
marshall /マーシャル;.mh/
marshmallow /マシュマロ/
mart /マート/マー/
marta /マルタ/マータ/
marteau /マルトー/
martha /マーサ/マルタ/
marthe /マルト/
marti /マルティ/マーティ/マーティー/
martial /マーシャル/
martialarts /マーシャルアーツ/
martin /マーチン/マーティン/マルタン/マルティン/マルチン/
martina /マルチナ/マルティナ/
martine /マルティーヌ/
martinet /マルティネ/
martinez /マルティネス/マルチネス/
martini /マティーニ/マルティーニ/マルティニ/
martinique /マルティニク;.mq/
martinlof /マーティンレーフ/
martino /マルティーノ/マルチーノ/
marton /マートン/
marty /マルティ/マーティ/マーティー/
maru /●/○/〇;漢数字のゼロ/◎/
marvel /マーベル/マーヴェル/
marvellous /マーベラス/
marvelous /マーベラス/
marvin /マービン/マーヴィン/メルビン/
marx /マルクス/
marxism /マルキシズム/
mary /マリー/メリー/メアリー/メアリ/
maryann /メリーアン/メアリーアン/
maryland /メリーランド/
marypoppins /メリーポピンズ;Mary Poppins/
marzipan /マジパン/マルツィパン/
mas /マッツ/
masala /マサラ;(Hindi)香辛料/
mascara /マスカラ/
mascarpone /マスカルポーネ/
mascot /マスコット/
mascotcharacter /マスコットキャラクター/
maser /メーザー;microwave amplification by stimulated emission of radiation/メーザ/
maserati /マセラティ;www.maserati.it/
maseru /マセル/
mash /マッシュ/
masha /マーシャ/
mashpotato /マッシュポテト;mashed potato/
mask /マスク/仮面/
masked /マスクド/マスクト/
maskedspector /マスクトスペクトル/
maskee /マスキー/マスキ/
masker /マスカ/マスカー/
masking /マスキング/
maskingtape /マスキングテープ/
maslow /マズロー/
maso /マゾ;masochist,masochism/
masoch /マゾッホ/マゾ/ザッヘル＝マゾッホ/
masochism /マゾヒズム/被虐趣味/嗜虐的趣味/被虐淫乱症/
masochist /マゾヒスト/被虐趣味者/嗜虐的趣味者/
mason /メイスン/メーソン/
masqat /マスカット/
masquerade /マスカレード/
mass /マス/マッス;[美術]/
massa /マッサ/
massachusetts /マサチューセッツ;MA/
massage /マッサージ/
massagechair /マッサージチェア/
massageoil /マッサージオイル/
massager /マッサージャー/
masscommunication /マスコミュニケーション/
masscomp /マスコンプ/
masse /マッス;(仏語)/マッセ;(独語)/
massenet /マスネ/
massgame /マスゲーム;和製英語/
massimo /マッシモ;(It)最大/
massive /マッシヴ/マッシブ/
massmedia /マスメディア/
masspro /マスプロ;mass production/
mast /マスト/
master /マスター/マスタ/修士/
mastercard /マスターカード;www.mastercard.com/MasterCard/
mastercourse /マスターコース/
masterdata /マスターデータ/マスタデータ/
mastering /マスタリング/
masterkey /マスターキー/
masterpiece /マスターピース/
masterplan /マスタープラン/
masters /マスターズ/
mastertape /マスターテープ/
mastroianni /マストロヤンニ/
masturbation /マスターベーション/
mat /マット/
mata /マータ/マタ/
matador /マタドール/
match /マッチ/
matchbox /マッチボックス/
matching /マッチング/
matchplay /マッチプレー/
matchpoint /マッチポイント/
matchppomp /マッチポンプ;和製語/
matchppump /マッチポンプ;和製語/
mate /メイト/マテ/マテ茶/
mateo /マテオ/
materazzi /マテラッツィ/
material /マテリアル/
maternity /マタニティ/マタニティー/
mates /メイツ/
mateus /マテウス/
math /マス/±;+-/×;x/÷;div/∞;infinity,oo/∝;proportional/∴;therefore/∵;because/⇒;=>/⇔;equiv,<=>/∀;all/∃;exist/∂;d,partial/Δ;Delta/∇;nabla/√;root,sqrt/∫;integral/∬;integral/≡;equiv/∽;similar/≒;=:,approx/≠;neq,!=/≦;<=/≧;>=/≪;<</≫;>>/∈;include/∋;include/⊆;subseteq/⊇;superseteq/⊂;subset/⊃;superset/∪;sum/∩;cap/∧;and/∨;or/¬;not/∠;angle/⌒;arc,frown/⊥;vertical/
mathew /マシュー/
mathias /マティアス/マサイアス/
mathieu /マシュー/マチュー/
mathilda /マチルダ/
mathilde /マチルド/
matias /マティアス/マチアス/
matic /マチック/マティック/
matiere /マチエール/
matilda /マチルダ/
matinee /マチネ/
matisse /マチス/マティス/
mato /マト/
matreshka /マトリョーシカ/
matrix /マトリックス/マトリクス/行列/
matroid /マトロイド/
mats /マッツ/
matt /マット/
mattaeus /マタイ/
matteo /マッテオ/
matter /マター/
matterhorn /マッターホルン/
mattew /マシュー/
matthaus /マテウス/
matthew /マタイ/マシュー/
matthews /マシューズ/
matthias /マティアス/
matti /マッティ/
mattie /マッティ/
mattress /マットレス/
matty /マティ/マッティ/
mau /マウ/
maud /モード;Who was that Maud person anyway?/
maude /モード/
maugham /モーム/
maui /マウイ/
maul /モール/
maunakea /マウナケア/
maunaloa /マウナロア/
maupassant /モーパッサン/
maureen /モーリン/モーリーン/
mauri /マウリ/
mauriat /モーリア/
maurice /モーリス/
mauritania /モーリタニア;.mr/
mauritius /モーリシャス;.mu/
maurizio /マウリツィオ/
mauro /マウロ/モーロ/
maus /マウス/
mauss /モース/
mauve /モーブ/
maverick /マーベリック;一匹狼/
mavis /メイビス/メイヴィス/
max /マックス/最大/
maxell /マクセル/
maxi /マキシ/
maxim /マキシム/マクシム/
maxime /マクシム/
maximilian /マクシミリアン/
maximin /マキシミン/マクシミン/
maximo /マキシモ/
maximum /マキシマム/最大/最大値/
maxisingle /マキシシングル/
maxwell /マクスウェル/マックスウェル/
may /メイ/メー/
maya /マヤ/マーヤ/マーヤー/
maybe /メイビー/
mayday /メーデー/
mayer /マイヤー/メイヤー/マイエル/マイアー/メイア/マイア/
mayfield /メイフィールド/
mayflower /メイフラワー/
maynard /メイナード/
mayne /メイン/
mayo /メイヨ/
mayol /マイヨール/
mayonnaise /マヨネーズ/
mayor /メイヤー;市長/
mayotte /マヨット;.yt/
mayqueen /メークイン/メイクイーン/メイクイン/
mazarin /マザラン/
mazda /マツダ/
maze /メイズ/
mazurka /マズルカ/
mazza /マッツァ/
mb /メガバイト/
mbabane /ムババネ/
mbira /ムビラ/
mbps /Ｍｂｐｓ/
mc /マック;人名の一部(McDonald,McCartney)/マク/
mcafee /マカフィー/
mccallum /マッカラム/
mccarran /マッカラン;McCarran/
mccarthy /マッカーシー/ＭｃＣａｒｔｈｙ/McCarthy/
mccartney /マッカートニー;McCartney/
mccollum /マッカラム/マッコーラム/
mccoy /マッコイ;McCoy/
mcculloch /マッカロー/
mcdonald /マクドナルド;McDonald/
mcenroe /マッケンロー;McEnroe/
mcentire /マッケンタイア;McEntire/
mcfarlane /マクファーレン;McFarlane/
mcgrawhill /マグロウヒル/
mcguffin /マクガフィン/
mcgwire /マグワイア;McGwire/
mckee /マッキー;McKee/
mckinley /マッキンリー/マッキンレー/
mclain /マクレーン/マクリーン/
mclaren /マクラーレン;McLaren/
mclaughlin /マクラフリン;McLaughlin/
mclean /マクリーン;McLean/マクレーン/
mcluhan /マクルーハン;McLuhan/
mcmahon /マクマホン/
mcneil /マクニール;McNeil/
mcpherson /マクファーソン/
mcqueen /マックイーン/
mcrae /マクレー;McRae/マクリー/
md /ミニディスク/Mendelevium/メンデレビウム/Maryland/メリーランド/
mdplayer /MDプレーヤー/
mdrecorder /MDレコーダー/
me /ミー/Maine/メイン/メーン/
mead /ミード/
meadow /メドウ;牧草地/
meal /ミール/
mean /ミーン/
meaning /ミーニング/
measure /メジャー/
measurecup /メジャーカップ/
measuring /メジャリング/
meat /ミート/
meatball /ミートボール/
meatloaf /ミートローフ/
meatpie /ミートパイ/
meatsauce /ミートソース/
mecab /MeCab/和布蕪/
mecca /メッカ/
mecenat /メセナ;仏語/
mecha /メカ/
mechanic /メカニック/
mechanical /メカニカル/
mechanics /メカニクス/メカニックス/
mechanism /メカニズム/
mechatronics /メカトロニクス/
meche /メッシュ/
meda /メダ/
medal /メダル/
medalist /メダリスト/
medallion /メダリオン/
medallist /メダリスト/
medan /メダン/
medea /メディア/メデア/
medi /メディ/
media /メディア/ミーディア/
mediacase /メディアケース/
mediacenter /メディアセンター/
mediacentre /メディアセンター/
mediafactory /メディアファクトリー;www.mediafactory.co.jp/
medialiteracy /メディアリテラシー/
mediamix /メディアミックス/
mediaplayer /メディアプレイヤー/
medias /メリヤス/
mediaservice /メディアサービス/
mediator /メディエータ/
mediaworks /メディアワークス;www.mediaworks.co.jp/
medic /メディック/
medical /メディカル/
medicalcheck /メディカルチェック;和製英語/
medication /メディケーション/
medici /メディチ/
medicine /メディシン/
medicis /メディシス/
medico /メディコ/
medina /メジナ/メディナ/
meditation /メディテーション/
medium /ミディアム/
medley /メドレー/
medoc /メドック/
medusa /メデューサ/メドゥーサ/メドゥサ/
meerkat /ミーアキャット/
meet /ミート/
meeting /ミーティング/会議/
meets /ミーツ/
meg /メグ/
mega /メガ;M,10^6/
megabank /メガバンク/
megabit /メガビット/
megabyte /メガバイト/
megabytes /メガバイト/
megadeath /メガデス/
megademo /メガデモ/
megadrive /メガドライブ/
megafloat /メガフロート/
megalopolis /メガロポリス/
megan /メーガン/
megaphone /メガホン/
megastore /メガストア/
megaton /メガトン/
mehmet /メフメト/
meier /メイヤー/
meissen /マイセン/
meissner /マイスナー/
meister /マイスター/
meistersinger /マイスタージンガー/
meitec /メイテック;www.meitec.co.jp/
mekong /メコン/
mel /メル/
melamine /メラミン/
melancholia /メランコリア/
melancholic /メランコリック/
melancholy /メランコリー/
melancolie /メランコリー;仏語/
melandri /メランドリ/
melanesia /メラネシア/
melanie /メラニー/メラニ/
melanin /メラニン/
melatonin /メラトニン/
melba /メルバ/
melbourne /メルボルン/
melby /メルビー/
melchior /メルキオール/メルキオル/
melco /メルコ/
melinda /メリンダ/
melisande /メリザンド/
melissa /メリッサ/メリサ/
mell /メル/
mello /メロ/
mellon /メロン/
mellow /メロウ/メロー/
melo /メロ/
melocore /メロコア;melodic core/
melodia /メロディア/
melodic /メロディック/
melodie /メロディー;仏語/メロディ/
melodion /メロディオン/
melodious /メロディアス/
melodius /メロディアス;※melodious?/
melodrama /メロドラマ/
melody /メロディ/メロディー/
melodyline /メロディーライン/メロディライン/
melon /メロン/ムロン;ブドウの品種/
melonpain /メロンパン/
melrose /メルローズ/
melt /メルト/
meltdown /メルトダウン/
melville /メルヴィル/メルビル/
melvin /メルヴィン/メルビン/
melvyn /メルヴィン/
member /メンバー/メンバ/
memberlist /メンバーリスト/
members /メンバーズ/
memberscard /メンバーズカード/
membersclub /メンバーズクラブ/
membership /メンバーシップ/メンバシップ/
membrane /メンブレン/
meme /ミーム/メーム/
memfis /メンフィス/
memo /メモ/
memomemo /メモメモ/
memorandum /メモランダム/メモ/
memorial /メモリアル/
memories /メモリーズ/
memory /メモリ/メモリー/
memoryaccess /メモリアクセス/
memorycard /メモリーカード/メモリカード/
memorychip /メモリチップ/
memoryleak /メモリリーク/
memorymapped /メモリマップド/
memoryset /メモリセット/
memoryslot /メモリースロット/メモリスロット/
memorystick /メモリースティック/
memphis /メンフィス/
men /メン/
mena /メナ/
menado /メナド/
menam /メナム/
menard /メナード/
mendel /メンデル/
mendeleev /メンデレーエフ/
mendelevium /メンデレビウム;[元素]101,Md/
mendelssohn /メンデルスゾーン/
mendieta /メンディエタ/
mendoza /メンドーサ/
menger /メンガー/
meniere /メニエール/
meno /メノ;(It)もっと/
mens /メンズ;men's/メンス;Menstruation/
mensfashion /メンズファッション/
mensshop /メンズショップ/
ment /メント;(接尾辞)/
mental /メンタル/
mentalcare /メンタルケア/
mentalhealth /メンタルヘルス/
mentalism /メンタリズム/
mentality /メンタリティ/メンタリティー/
mentaltraining /メンタルトレーニング/
menthol /メントール/メンソール/薄荷脳/
mentor /メンター/
menu /メニュー/ムニュ;(Fr) 定食/
menubar /メニューバー/メニュー・バー/
menuett /メヌエット/
menulist /メニューリスト/
mephist /メフィスト;mephistopheles/
mephistopheles /メフィストフェレス/
mer /メール;(Fr)海/
mercado /メルカド/
mercaptan /メルカプタン/
mercator /メルカトル/
mercedes /メルセデス/
mercedesbenz /メルセデスベンツ/
merchandise /マーチャンダイズ/
merchandiser /マーチャンダイザー/
merchandising /マーチャンダイジング/
merchant /マーチャント/
merchen /メルヘン;(独語)/メルヒェン/
merchentic /メルヘンチック;和製語(独語merchen + tic)/
merci /メルシー/メルシィ/
mercian /メルシャン;www.mercian.co.jp/
merck /メルク/
mercurius /メルクリウス/
mercury /マーキュリー/メルクリウス/
mercy /マーシー/
mere /メア/メール;(Fr)母/
meredith /メレディス/
merengue /メレンゲ/
merge /マージ/
mericlone /メリクロン/
merida /メリダ/
merimee /メリメ/
meringue /メレンゲ/
merit /メリット/
meritocracy /メリトクラシー/
merits /メリッツ/
merkel /メルケル/
merkl /メルクル/
merkmal /メルクマール/
merle /マール/メルル/
merleau /メルロー/メルロ/
merleauponty /メルロ=ポンティ/メルロポンティ/
merlin /マーリン/メルラン/
merlot /メルロー/メルロ/
merluza /メルルーサ/
mermaid /マーメイド/
merrell /メレル/
merrick /メリック/
merrill /メリル/
merrit /メリット/
merrow /メロウ;[ケルト神話]/
merry /メリー/
merrychristmas /メリークリスマス/
merrygoround /メリーゴーランド;merry-go-round/メリーゴーラウンド/
merryxmas /メリークリスマス/
mersenne /メルセンヌ/
merveille /メルヴェイユ/メルヴェーユ/
meryl /メリル/
mes /メ;仏語/
mescaline /メスカリン/
mesh /メッシュ/
meso /メソ/
meson /メソン/中間子/
mesopotamia /メソポタミア/
mess /メス/
messa /メッサ/
message /メッセージ/
messagebox /メッセージボックス/
messagecard /メッセージカード;note card/
messageid /メッセージＩｄ/
messaging /メッセージング/
messanger /メッセンジャー/メッセンジャ/
messangers /メッセンジャーズ/
messe /メッセ/
messerschmitt /メッサーシュミット/
messiaen /メシアン/
messiah /メシア/メサイア/
messier /メシエ/
messina /メッシーナ/
messy /メッシー/
mesto /メスト/
meta /メタ/メータ/
metabolic /メタボリック/
metadata /メタデータ/
metafiction /メタフィクション/
metafont /メタフォント/
metal /メタル/
metalband /メタルバンド/
metalcable /メタルケーブル/
metalevel /メタレベル/
metalframe /メタルフレーム/
metalic /メタリック/
metaliccolor /メタリックカラー/
metaliccolour /メタリックカラー/
metaljacket /メタルジャケット/
metallic /メタリック/
metallica /メタリカ/
metallicblue /メタリックブルー/
metalogue /メタローグ;[出版社名]www.metalogue.co.jp/
metalpercussion /メタルパーカッション/
metaltape /メタルテープ/
metamorphose /メタモルフォーゼ/
metaphor /メタファー/
metasearch /メタサーチ/
metasequoia /メタセコイア/
meteo /メテオ/
meteor /メテオ/メテオール/
meter /メートル/メーター/メータ/
methan /メタン;(独語)/
methane /メタン;CH4/
methanegas /メタンガス/
methanehydrate /メタンハイドレート/
methanol /メタノール/
metheny /メセニー/
methionine /メチオニン;Met/
metho /メト;methyl/
method /メソッド/
methodist /メソジスト/
methodology /メソドロジ/
methoxy /メトキシ/
methyl /メチル;-CH3/
methylalcohol /メチルアルコール/
methylamine /メチルアミン/
methylbenzene /メチルベンゼン;=toluene/
methylene /メチレン/
methylether /メチルエーテル/
metier /メチエ/
metonymy /メトニミー/
metric /メトリック/
metrics /メトリックス/メトリクス/
metro /メトロ/
metronom /メトロノーム;(独語)/
metronome /メトロノーム/
metropolis /メトロポリス/
metropolitan /メトロポリタン/
metry /メトリー/メトリ/
mets /メッツ;[MLB]/
metz /メス/
meunier /ムニエ/
meuniere /ムニエル/
meursault /ムルソー/
mexican /メキシカン/
mexico /メキシコ;.mx/メヒコ;(西語読み)/
mexicocity /メキシコシティ;メキシコ(mex)/メキシコシティー/
mexp /M式/
meyer /マイヤー/
mezzo /メゾ;(イタリア語)/
mezzoforte /メゾフォルテ;mezzo forte/
mezzopiano /メゾピアノ;mezzo piano/
mezzosoprano /メゾソプラノ/
mezzotint /メゾチント/
mf /MetaFont/メゾフォルテ;やや強く/mezzo forte/
mg /マグネシウム/Magnesium/ミリグラム/
mhz /ＭＨｚ/
mi /Michigan/ミシガン/ミ/
mia /ミーア/ミア/
miami /マイアミ/
mic /マイク;microphone/
mica /マイカ;雲母/
micah /ミカ/
miccoli /ミッコリ/
mice /マイス/
micelle /ミセル/
michael /マイケル/ミカエル/ミヒャエル/ミッシェル/ミハエル/
michaela /ミカエラ/
michaux /ミショー/
michel /ミシェル/ミッシェル/マイケル/ミチェル/
michelangelo /ミケランジェロ/
michele /ミケーレ;(イタリア語)/ミシェル;仏語/ミッシェル;仏語/
michelet /ミシュレ/
michelin /ミシュラン/
michelle /ミシェル/ミッシェル/
michigan /ミシガン/
mick /ミック/
mickey /ミッキー/
mickeymouse /ミッキーマウス;[商標]Disney/
micky /ミッキー/
micom /マイコン/
micro /マイクロ/ミクロ/μ/
microbus /マイクロバス/
microchip /マイクロチップ/
microcomputer /マイクロコンピュータ/
microcosmos /ミクロコスモス/
microfiber /マイクロファイバー/
microfilm /マイクロフィルム/
microgram /μg/マイクログラム/
microgramme /μg/マイクログラム/
microkernel /マイクロカーネル/
microlens /マイクロレンズ/
micromachine /マイクロマシン/
micrometer /μm/マイクロメートル/マイクロメータ/マイクロメーター/
micrometre /μm/マイクロメートル/
micromini /マイクロミニ/
micromouse /マイクロマウス/
micron /ミクロン/
micronesia /ミクロネシア;.fm/
microphone /マイクロフォン/マイクロホン/
microprocessor /マイクロプロセッサ/
microscope /マイクロスコープ/
microsecond /マイクロセカンド/マイクロ秒/
microsoft /マイクロソフト;www.microsoft.com/
microsome /ミクロソーム/ミクロゾーム/
microsystems /マイクロシステムズ/
microtower /マイクロタワー/
microwave /マイクロウェーブ/
mid /ミッド/
midas /ミダス/
midcentury /ミッドセンチュリー/
middle /ミドル/
middleage /ミドルエイジ/
middleclass /ミドルクラス/
middlehole /ミドルホール;par-4/
middleiron /ミドルアイアン;5-7/
middlename /ミドルネーム/
middlerange /ミドルレンジ/
middleshoot /ミドルシュート/
middletempo /ミドルテンポ/
middletower /ミドルタワー/
middleware /ミドルウェア/ミドルウエア/
midfield /ミッドフィールド/
midfielder /ミッドフィールダー/ミッドフィルダー/
midgard /ミッドガルド/
midi /ミディ/
midnight /ミッドナイト/
midrange /ミッドレンジ/
midship /ミッドシップ/
midtown /ミッドタウン/
midway /ミッドウェー/ミッドウェイ;イリノイ(USA)(mdw)/
miffy /ミッフィー/
mig /ミグ/
might /マイト/
mighty /マイティ/
mignon /ミニョン/ミニヨン/
migrate /マイグレート/移送/マイグレイト/
migration /マイグレーション/移送/マイグレイション/
miguel /ミゲル/
mihaela /ミハイル/
mihail /ミハイル/
mihrab /ミフラーブ/
mika /ミカ/
mikael /ミカエル/
mike /マイク/ミケ/
mikey /マイキー/
mikhail /ミハイル/ミハエル/
mikihouse /ミキハウス;www.mikihouse.co.jp/
mikko /ミッコ/
mikonos /ミコノス/
mil /ミル/
mila /ミラ/
milage /マイレッジ/
milan /ミラン/
milano /ミラノ/
mild /マイルド/
mildred /ミルドレッド/
mildseven /マイルドセブン/
mile /マイル/
mileage /マイレージ/マイレッジ/
milena /ミレナ/ミレーナ/
miler /マイラー/
miles /マイルス/マイルズ/
milestone /マイルストーン/
milhaud /ミヨー/
military /ミリタリー/
milk /ミルク/
milka /ミルカ/
milkchoco /ミルクチョコ/
milkchocolate /ミルクチョコレート/
milkcocoa /ミルクココア/
milkcoffee /ミルクコーヒー/
milkpan /ミルクパン;(鍋)milk pan/
milkpot /ミルクポット/
milkshake /ミルクセーキ/
milktea /ミルクティー/ミルクティ/
milky /ミルキー/
mill /ミル/
milla /ミラ/
millan /ミラン/
mille /ミル/
millecrepe /ミルクレープ;mille crepe/
millefeuille /ミルフィーユ;mille-feuille/
millenium /ミレニアム/
miller /ミラー/
millet /ミレー/
milli /ミリ/
millibar /ミリバール;=hectopascal/
millie /ミリー/
milligram /ミリグラム/
milligramme /ミリグラム/
millikan /ミリカン/
milliliter /ミリリットル/
millilitre /ミリリットル/
millimeter /ミリメートル/
millimetre /ミリメートル/
million /ミリオン;1,000,000/
millionaire /ミリオネア/
millionseller /ミリオンセラー/
millisecond /ミリセカンド/ミリ秒/
milly /ミリー/
milner /ミルナー/
milo /ミロ/
milon /ミロン/
milonga /ミロンガ/
milos /ミロシュ/ミロス/
milt /ミルト/
milton /ミルトン/
milwaukee /ミルウォーキー;USA/
mimd /MIMD/
mime /マイム/ミーム/
mimesis /ミメーシス/ミメシス/
mimi /ミミ/
mimic /ミミック/
mimosa /ミモザ/
min /ミン/ミニマム/
mina /ミナ/
minardi /ミナルディ/
minaret /ミナレット/
minas /ミナス/
mince /ミンチ/
mind /マインド/
mindanao /ミンダナオ;フィリピン/
mindcontrol /マインドコントロール/
mine /マイン/ミーネ;(独語人名)/
minebea /ミネベア;www.minebea.co.jp/
miner /マイナー/
mineral /ミネラル/
mineralwater /ミネラルウォーター/
minerva /ミネルヴァ/ミネルバ/
minestrone /ミネストローネ/
minette /ミネット/
mingus /ミンガス/
mini /ミニ/
minialbum /ミニアルバム/
miniature /ミニチュア/
miniaturedachs /ミニチュアダックス;miniature dachshund/
miniaturedachshund /ミニチュアダックスフンド/ミニチュアダックスフント/
minibottle /ミニボトル/
minibuffer /ミニバッファ/
minibus /ミニバス/
minicar /ミニカー/
minicom /ミニコン/
minicompo /ミニコンポ;minicomponent stereo/
minicomputer /ミニコンピュータ/ミニコン/
minidisc /ミニディスク;MD/
minidisk /ミニディスク/
minigame /ミニゲーム/
minijack /ミニジャック/
minilive /ミニライブ/
minimal /ミニマル/
minimalism /ミニマリズム/
minimalist /ミニマリスト/
minimalmusic /ミニマルミュージック/
minimini /ミニミニ/
minimum /ミニマム/最小/最小値/
mining /マイニング/
minion /ミニオン/
minisize /ミニサイズ/
miniskirt /ミニスカート/
minister /ミニスター/
ministop /ミニストップ;www.ministop.co.jp/
minitower /ミニタワー/
minivan /ミニバン/
mink /ミンク/
minkowski /ミンコフスキー/
minna /ミンナ/
minneapolis /ミネアポリス/
minnesota /ミネソタ;MN/
minnie /ミニー/
minolta /ミノルタ;www.konicaminolta.jp/
minor /マイナー/マイナ/
minorchange /マイナーチェンジ/
minority /マイノリティ/マイノリティー/
minorleague /マイナーリーグ/
minormode /マイナーモード/
minorversion /マイナーバージョン/
minos /ミノス/
minotaur /ミノタウロス/ミノトール/
minotauros /ミノタウロス/
minovsky /ミノフスキー/
minsk /ミンスク/
minstrel /ミンストレル/
mint /ミント/
mintgreen /ミントグリーン/
minton /ミントン/
minuet /メヌエット/
minus /マイナス/−;minus/
minusdriver /マイナスドライバー;和製英語(flat screwdriver)/
minusimage /マイナスイメージ;和製英語(negative image)/
minusion /マイナスイオン;和製英語(negative ion)/
minute /ミニット/′/
minutes /ミニッツ/
minutia /マニューシャ/
mips /MIPS/
mira /ミラ/
mirabel /ミラベル/
mirabelle /ミラベル/
miracle /ミラクル/
miraclefruit /ミラクルフルーツ/
miraclefruits /ミラクルフルーツ/
mirage /ミラージュ/
miranda /ミランダ/
mireille /ミレイユ/ミレーユ/
miri /ミリ/
miriam /ミリアム/
mirko /ミルコ/
miro /ミロ/
miron /ミロン/
miroslav /ミロスラフ/
mirra /ミイラ;(ポルトガル語)/
mirror /ミラー/
mirrorball /ミラーボール/
mirroring /ミラーリング/
mirrorsite /ミラーサイト/
mis /ミス/
miscast /ミスキャスト/
miserable /ミゼラブル/
misha /ミーシャ/
misjudge /ミスジャッジ/
mismatch /ミスマッチ/
mispri /ミスプリ;misprint/
misprint /ミスプリント/
miss /ミス/
missa /ミサ/
missanga /ミサンガ/
misshit /ミスヒット/
missile /ミサイル/
missing /ミッシング/
missinglink /ミッシングリンク/
mission /ミッション/
missioncritical /ミッションクリティカル/
missionschool /ミッションスクール/
mississippi /ミシシッピ;MS/
missouri /ミズーリ;MO/
misspell /ミススペル/
misspicking /ミスピッキング/
misstouch /ミスタッチ/
misstype /ミスタイプ/
mist /ミスト/
mistake /ミステイク/
mister /ミスター/
misterdonut /ミスタードーナツ;www.misterdonut.co.jp/
misterioso /ミステリオーソ/
mistery /ミステリー;※mystery/
mistral /ミストラル/
mistress /ミストレス/
misty /ミスティ/ミスティー/
mit /MIT/ミット/
mitchell /ミッチェル/
mithra /ミスラ/ミトラ/
mithril /ミスリル/
mitochondria /ミトコンドリア/
mitomycin /マイトマイシン/
mitra /ミトラ/
mitt /ミット/
mitten /ミトン/
mitterrand /ミッテラン/
mitya /ミーチャ/
mix /ミックス/ミクス/
mixer /ミキサー/ミキサ/
mixi /ミクシィ;mixi.jp/
mixing /ミキシング/
mixjuice /ミックスジュース/
mixnuts /ミックスナッツ/
mixolydian /ミクソリディアン;GABCDEFG/
mixture /ミクスチャー/ミクスチャ/ミクスチュア/
mjollnir /ミョルニル/ミョルニール/
ml /メーリングリスト/メイリングリスト/
mlsize /MLサイズ/ＭＬサイズ/
mm /ミリメートル/
mmi /マン・マシン・インタフェース/
mn /マンガン/Manganese/ミネソタ/Minnesota/
mnemonic /ニーモニック/
mnemosyne /ムネモシュネ/
mo /Molybdenum/モリブデン/光磁気ディスク/Missouri/ミズーリ/MO/
moai /モアイ/
moan /モーン/
moanin /モーニン;moanin'/
moaning /モーニング;うめき/
mob /モブ/
mobile /モバイル/モービル/モビル/モビール/
mobilenote /モバイルノート/
mobilepage /モバイルページ/
mobileservice /モバイルサービス/
mobilesuit /モビルスーツ/
mobility /モビリティ/
mobit /モビット;[企業名]消費者金融。www.mobit.ne.jp/
mobius /メビウス/
moblog /モブログ/
mobscene /モブシーン/
moby /モービー/
moccasin /モカシン/
moccus /モックス/
mocha /モカ/
mock /モック/
mocking /モッキング/
mockingbird /モッキンバード/モッキングバード/
mockup /モックアップ/
moco /モコ/
modal /モーダル/
modality /モダリティ/
modalshift /モーダルシフト/
mode /モード/
mode-line /モードライン/
model /モデル/
modelcar /モデルカー/
modelcase /モデルケース/
modelchange /モデルチェンジ/
modelcourse /モデルコース/
modeler /モデラー/モデラ/
modeless /モードレス/
modelgun /モデルガン/
modelhouse /モデルハウス/
modeline /モードライン/
modeling /モデリング/
modelling /モデリング/
modelnumber /モデルナンバー/
modelroom /モデルルーム/
modem /モデム/
modemcard /モデムカード/
modemrental /モデムレンタル/
modena /モデナ/
moderate /モデレート/モデラート;※moderato(It.)?/モデレイト/
moderato /モデラート/
moderator /モデレータ/モデレーター/
modern /モダン/
modernart /モダンアート/
modernballet /モダンバレエ/
moderndance /モダンダンス/
moderne /モデルヌ;仏語/
modernism /モダニズム/モダニスム/
modernite /モデルニテ;(Fr) 現代性/
modernjazz /モダンジャズ/
moderno /モデルノ;(イタリア語)/
modest /モデスト/
modifier /モディファイア/
modify /モディファイ/
modigliani /モジリアーニ/
modisk /MOディスク/
modrive /MOドライブ/
modular /モジュラー/モジュラ/
modularity /モジュラリティ/
modularjack /モジュラージャック/
modulation /モジュレーション/
module /モジュール/モデュール/
moduler /モジュラー;※modular/
modulo /モデューロ/モジュロ/
moebius /メビウス/
mogadishu /モガディシュ/
mogol /モール;(ポルトガル語)/
mogul /モーグル/
mohair /モヘア/モヘヤ/
mohammad /モハメド/ムハンマド/モハマド/
mohawk /モホーク/
mohenjodaro /モヘンジョダロ;Mohenjo-Daro/モヘンジョ・ダロ/
mohican /モヒカン/
mohr /モーア/
mohs /モース/
moi /モワ/
moira /モイラ/
moire /モアレ/
moist /モイスト/
moisture /モイスチャー/
mojito /モヒート/
mol /モル/
mola /モラ/モーラ/
mold /モールド/
moldau /モルダウ/
moldova /モルドバ;.md/モルドヴァ/
mole /モール/モル/
molecular /モレキュラー/
moleskin /モールスキン/
moley /モーリー/
moliere /モリエール/
molina /モリーナ/
moll /モール/モル/
mollis /モリス/
molly /モーリー/モリー/
molokai /モロカイ/
molto /モルト;(It)非常に/
molybden /モリブデン;Mo/
molybdenum /モリブデン;[元素]42,Mo/
mom /マム/
mombasa /モンバサ/
moment /モーメント/
moments /モーメンツ/
momentum /モメンタム/モーメント/モーメンタム/モーメント項/
mommy /マミー/
momo /モモ/
momos /モモス/
mompou /モンポウ/
mon /モン/月/
monaco /モナコ/
monacogp /モナコGP;[F1]/
monad /モナド/
monaghan /モナハン/
monarch /モナーク/
monaural /モノラル/
monday /マンデー/マンディ/マンデイ/マンディー/月曜日/
monde /モンド/
mondriaan /モンドリアン/
mondrian /モンドリアン;(英語綴り)=Mondriaan/
monet /モネ/
monetarism /マネタリズム/
monetary /マネタリー/
money /マネー/
moneygame /マネーゲーム/
moneylaundering /マネーロンダリング/
moneysupply /マネーサプライ/
mongol /モンゴル/
mongolia /モンゴリア;.mn/
mongolian /モンゴリアン/
mongoloid /モンゴロイド/
mongoose /マングース/
monica /モニカ/
monika /モニカ/
monique /モニク/
monitor /モニター/モニタ/
monitorcable /モニターケーブル/モニタケーブル/
monitoring /モニタリング/
monitormode /モニタモード/
monk /モンク/
monkey /モンキー/
monnalisa /モナリザ;Monna Lisa/
mono /モノ/モノクロ;monochrome/
monochro /モノクロ;monochrome/
monochrome /モノクローム/モノクロ/
monoculture /モノカルチャー/
monod /モノ/
monoethyl /モノエチル/
monogram /モノグラム/
monograph /モノグラフ/
monoid /モノイド/
monolith /モノリス/
monolithic /モノリシック/
monolog /モノローグ/
monologue /モノローグ/
monomania /モノマニア/
monomer /モノマー/単量体/
monomethyl /モノメチル/
monopole /モノポール/
monopoly /モノポリー/
monorail /モノレール/
monotone /モノトーン/
monotype /モノタイプ/
monroe /モンロー/
monsieur /ムッシュー/ムッシュウ/
monsoon /モンスーン/
monster /モンスター/
monsters /モンスターズ/
montage /モンタージュ/
montague /モンタギュー/
montaigne /モンテーニュ/
montana /モンタナ;MT/
montand /モンタン/
montblanc /モンブラン;Mont Blanc/
monte /モンテ/モント/モンティ/
montecarlo /モンテカルロ;Monte-Carlo/モンテカルロ法/
montecristo /モンテクリスト;Monte Cristo/モンテ=クリスト/
montee /モンテ/
montella /モンテッラ/
montenegro /モンテネグロ/
monterey /モントレー;USA/
monterosa /モンテローザ;Monte Rosa/
montes /モンテス/
montesquieu /モンテスキュー/
montessori /モンテッソーリ/
monteverdi /モンテヴェルディ/
montevideo /モンテビデオ/
montgomery /モンゴメリー/モンゴメリ/モントゴメリー;地名/
month /マンス/
monthly /マンスリー/
monti /モンティ/
montmartre /モンマルトル;18区/
montoya /モントーヤ/
montparnasse /モンパルナス;15区/
montpellier /モンペリエ/
montreal /モントリオール/
montreux /モントルー;スイス/
montrose /モンローズ;Mont Rose/
montserrat /モントセラト;.ms/
monty /モンティ/
montylymansion /マンスリーマンション/
monument /モニュメント/
monumental /モニュメンタル/
mood /ムード/
moodmaker /ムードメーカー/
moody /ムーディー/ムーディ/
moodys /ムーディーズ;Moody's. www.moodys.com/
moog /モーグ/ムーグ/
mook /ムック/
moomin /ムーミン/
moon /ムーン/
moonlight /ムーンライト/
moonriver /ムーンリバー/
moonsault /ムーンサルト/
moonstone /ムーンストーン/
moor /ムーア/
moorcock /ムアコック/
moore /ムーア/
moose /ムース/
mop /モップ/MOP/
mora /モーラ/モラ/
moraine /モレーン/
moral /モラル/
morale /モラル/モラール/
morales /モラレス/
moralhazard /モラルハザード/
moralism /モラリズム/
moralist /モラリスト/
moraliste /モラリスト/
moran /モラン/モーラン/
morandi /モランディ/
moratorium /モラトリアム/
moravia /モラヴィア/
mordor /モルドール/
more /モア/モレ/
moreau /モロー/
morel /モレル/
morell /モレル/
morelle /モレル/
morello /モレロ/
moreno /モレノ/
moretti /モレッティ/
morgan /モーガン/モルガン/
morganite /モルガナイト/
morgue /モルグ/
mori /モーリ/
morientes /モリエンテス/
morin /モラン/モーリン/モリン/
morison /モリソン/
moritz /モーリッツ/モリッツ/
morley /モーリー/
mormon /モルモン/
mornin /モーニン;mornin'/
morning /モーニング/
morningcall /モーニングコール;和製英語(wake-up call)/
morningset /モーニングセット/
morningstar /モーニングスター/
moro /モロ/
morocco /モロッコ/
moroco /モロッコ;.ma/
moroni /モロニ/
morozov /モロゾフ/
morph /モーフ/モーフィング/
morphine /モルヒネ/
morphing /モーフィング/
morrell /モレル/
morricone /モリコーネ/
morrigan /モリガン/
morris /モーリス/モリス/
morrison /モリソン/
morrow /モロー/モロウ/
morse /モース/モールス/
mort /モール;(Fr)死/
mortal /モータル/
mortar /モルタル/
mortgage /モーゲージ/
morton /モートン/
mos /モス/
mosa /モサ/
mosaic /モザイク/
mosburger /モスバーガー;www.mos.co.jp/
moscato /モスカート/
moscow /モスクワ/モスコー/
mosel /モーゼル/
moses /モーセ/モーゼ/モーゼス/
mosh /モッシュ/
moskowmule /モスコミュール/
moskva /モスクワ/
moslem /モスレム/
mosque /モスク/
mosquito /モスキート/
moss /モス/
mossad /モサド/
mossgreen /モスグリーン/
mosso /モッソ/
most /モスト/
mosul /モスル;イラク/
mot /モ;(Fr)語/
motedio /モンテディオ;[Jリーグ]山形/
motel /モーテル/
motet /モテット/
mother /マザー/
motherbo /マザボ;motherboard/
motherboard /マザーボード/
mothercon /マザコン;mother complex/
mothergoose /マザーグース;Mother Goose/
mothers /マザーズ/
mothership /マザーシップ/
mothra /モスラ/
motif /モチーフ/モティーフ/Ｍｏｔｉｆ/Motif/
motion /モーション/
motioncapture /モーションキャプチャー/モーションキャプチャ/
motionfeedback /モーションフィードバック/
motionpicture /モーションピクチャー/
motivation /モチベーション/
moto /モート/
motocross /モトクロス/
motor /モーター/モータ/
motorboat /モーターボート/
motorcar /モーターカー/
motorcycle /モーターサイクル/
motorisation /モータリゼーション/
motorization /モータリゼーション/
motorola /モトローラ/Motorola/
motors /モータース/モーターズ/
motorshow /モーターショー/
motorsport /モータースポーツ/
motorsports /モータースポーツ/
motown /モータウン/
motrola /モトローラ;※motorola?/
motta /モッタ/
motto /モットー/
moule /ムール/
moulinrouge /ムーランルージュ/
moulis /ムリス/
mound /マウンド/
mount /マウント/
mountain /マウンテン/
mountainbike /マウンテンバイク/
mounter /マウンタ/
mounting /マウンティング/
mountposition /マウントポジション/
mouse /マウス/
mousebutton /マウスボタン/
mousecursor /マウスカーソル/
mousepad /マウスパッド/
mousepointer /マウスポインタ/マウスポインター/
mousewheel /マウスホイール/
moussaka /ムサカ;Μουσακασ/
mousse /ムース/
mouth /マウス/
mouthpiece /マウスピース/
mouton /ムートン/
move /ムーブ/ムーヴ/
movement /ムーブメント/ムーヴメント/
mover /ムーバ/ムーバー/
movie /ムービー/ムーヴィー/
moving /ムービング/
moya /モヤ/
mozambique /モザンビーク;.mz/
mozart /モーツァルト/モーツアルト/
mozilla /モジラ/
mozzarella /モッツァレラ/モツァレラ/
mp /メゾピアノ;やや弱く/mezzo piano/
mp#file /MP#0ファイル/
mp#player /MP#0プレーヤー/MP#0プレイヤー/
mp3player /MP3プレーヤー/MP3プレイヤー/
mr /Ｍｒ．/ミスター;Mr./
mrdonut /ミスタードーナツ;www.misterdonut.co.jp/
mrna /ｍ-ＲＮＡ/
mrs /ミセス;Mrs./
ms /ミズ;Ms./ミリ秒/ミリセカンド/ミリセコンド/Mississippi/ミシシッピ/マイクロソフト/
ms-dos /MS-DOS/
msdos /MS-DOS/ＭＳ−ＤＯＳ/
msec /ミリセカンド/millisecond/ミリ秒/
msize /Mサイズ/Ｍサイズ/
mt /マウント/マイトネリウム/Meitnerium/Montana/モンタナ/
mu /μ/ミュー/ミュウ/ムー/ムウ/
muaythai /ムエタイ/
much /マッチ/
mucha /ミュシャ/
mud /マッド/
muddler /マドラー/
mueller /ミュラー/ミューラー/ミュレル/
muff /マフ/
muffin /マフィン/
muffler /マフラー/
mug /マグ/
mugcup /マグカップ;和製英語(mug)/
mughal /ムガール/ムガル/
muguet /ミュゲ;(Fr)鈴蘭/
muhammad /モハメド/ムハンマド/マホメット/
mujahadeen /ムジャヒディン/
mujahideen /ムジャヒディン/ムジャヒディーン/
mule /ミュール/Mule/
muleta /ムレタ/
muller /ミュラー/ミューラー/マラー/
multi /マルチ/
multiagent /マルチエージェント/マルチエイジェント/
multiboot /マルチブート/
multibyte /マルチバイト/
multicast /マルチキャスト/
multichip /マルチチップ/
multicomputer /マルチコンピュータ/
multicore /マルチコア/
multidrive /マルチドライブ/
multihome /マルチホーム/
multilevel /マルチレベル/
multilingual /マルチリンガル/
multimedia /マルチメディア/
multimodal /マルチモーダル/
multipart /マルチパート/
multipath /マルチパス/
multiplayer /マルチプレイヤー/
multiple /マルチプル/
multiplex /マルチプレックス/
multiplexer /マルチプレクサ/
multiplexor /マルチプレクサ/
multiplier /マルチプライヤ/
multipost /マルチポスト/
multiprocessor /マルチプロセッサ/
multirate /マルチレート/
multiscan /マルチスキャン/
multiserver /マルチサーバ/
multiset /マルチセット/
multitalker /マルチトーカ/
multitalkernoise /マルチトーカノイズ/
multitask /マルチタスク/
multithread /マルチスレッド/
multitrack /マルチトラック/
multiuser /マルチユーザー/マルチユーザ/
multiwindow /マルチウィンドウ/
mulukhiya /モロヘイヤ/
mumbai /ムンバイ;インド/
mummy /マミー;ミイラ/
munch /ムンク/ミュンシュ/
munchen /ミュンヘン/
munchkin /マンチキン/マンチカン/
munich /ミュンヘン/
munson /マンソン/
muon /ミューオン/
murano /ムラーノ/ムラノ/
murcia /ムルシア/
murder /マーダー/
murdoch /マードック/
muriel /ミュリエル/
murphy /マーフィー/マーフィ/
murray /マレー;オーストラリア/マーレイ/マレイ/
musa /ムーサ/
musai /ムーサイ/
muscadet /ミュスカデ/
muscarine /ムスカリン/
muscat /マスカット/ミュスカ;仏語/
muscle /マッスル/
muse /ミューズ/
musee /ミュゼ;(Fr)美術館/
musette /ミュゼット/
musharraf /ムシャラフ/
mushroom /マッシュルーム/
music /ミュージック/♪;quaver/♯;sharp/♭;flat/∫;※積分記号(integral)/∬;※二重積分記号/
musica /ムジカ/
musical /ミュージカル/
musicbox /ミュージックボックス/
musician /ミュージシャン/
musicschool /ミュージックスクール/
musicvideo /ミュージックビデオ/
musik /ムジーク;(独語)音楽/
musium /ミュージアム/
musket /マスケット/
muslim /ムスリム/
muslin /モスリン/
musorgskii /ムソルグスキー/
musset /ミュッセ/
mussolini /ムッソリーニ/
must /マスト/
mustafa /ムスタファ/
mustang /ムスタング/
mustapha /ムスタファ/
mustard /マスタード/
mustardgas /マスタードガス/
mustardsauce /マスタードソース/
mutable /ミュータブル/
mutant /ミュータント/
mute /ミュート/
mutex /ミューテックス/
muti /ムーティ/
mutt /マット;犬/
mutter /ムター/ムッター/
mutton /マトン/
mutual /ミューチュアル/
mw /ミドルウエア/
mxtv /MXテレビ;www.mxtv.co.jp/
my /マイ/
myanmar /ミャンマー;.mm/
myboom /マイブーム;和製英語/
mycar /マイカー/
mycenae /ミケーネ/ミュケナイ/
mycenai /ミケーネ/ミュケナイ/
mycin /マイシン/
mycomputer /マイコンピュータ/
mycotoxin /マイコトキシン/
myelin /ミエリン/
myers /マイヤーズ/
myhome /マイホーム/
mylene /ミレーヌ/
myline /マイライン/
myoglobin /ミオグロビン/
myosin /ミオシン/
mypace /マイペース/
mypage /マイページ/
myra /マイラ/
myriam /ミリアム/
myroom /マイルーム/
myrrh /ミルラ/マー/
myrrha /ミルラ/
myrte /ミルテ/
myrtle /マートル/
myself /マイセルフ/
mysterious /ミステリアス/
mystery /ミステリー/ミステリ/
mysterycircle /ミステリーサークル/
mysterytour /ミステリーツアー/
mythology /ミソロジー/
mythos /ミトス/ミュトス/
mytyl /ミチル/
myway /マイウェイ/
n /ν;nu/エヌ/н;en (cyrillic)/窒素/Nitrogen/
na /ナトリウム/Sodium/
naan /ナン/ナーン/
nabisco /ナビスコ/
nabla /∇;ベクトル微分/
nabokov /ナボコフ/
nacelle /ナセル/
nacht /ナハト/
nachtmusik /ナハトムジーク/
nack /ナック/
nadal /ナダル/
nadar /ナダール/
nadia /ナディア/
nadine /ナディーン/ナディーヌ/
nadja /ナジャ/
naga /ナーガ/
nagoyadome /ナゴヤドーム/名古屋ドーム/
nahum /ナホム/
naiad /ナイアード/
nail /ネイル/
nailart /ネイルアート/
nailcare /ネイルケア/
nailchip /ネイルチップ;和製英語(artificial nail)/
nailcolor /ネイルカラー/
nailcolour /ネイルカラー/
nailenamel /ネイルエナメル/
nailsalon /ネイルサロン/
nairobi /ナイロビ/
naive /ナイーブ/
najaf /ナジャフ;イラク/
naked /ネイキッド/
nakhodka /ナホトカ/
namaste /ナマステ/
namco /ナムコ;www.namco.co.jp/
name /ネーム/名/名称/名前/
nameplate /ネームプレート/
nameserver /ネームサーバ/ネームサーバー/
namespace /ネームスペース/
namevalue /ネームヴァリュー/ネームバリュー/
nami /〜/
namibia /ナミビア;.na/
naming /ネーミング/
namingrights /ネーミングライツ/
namingsense /ネーミングセンス/
namplaa /ナンプラー/
namul /ナムル;(朝鮮語)/
nan /ナン/
nana /ナナ/
nanao /ナナオ/
nance /ナンス/
nancy /ナンシー/
nanette /ナネット/
nannette /ナネット/
nanni /ナンニ/
nanny /ナニー/
nano /ナノ;[SI接頭語]n,10^-9/
nanometer /ナノメートル/
nanometre /ナノメートル/
nanoscale /ナノスケール/
nanosleep /ナノスリープ/
nanotech /ナノテク;nanotechnology/
nanotechnology /ナノテクノロジー/
nanotube /ナノチューブ/
nantes /ナント/
naomi /ナオミ;(聖書人名)/
nap /ナップ/
napalm /ナパーム/
naphtha /ナフサ/ナフタ/
naphthalene /ナフタレン;C10H8/ナフタリン/
naphthol /ナフトール/
napkin /ナプキン/ナフキン;転訛/
napoleon /ナポレオン/
napoli /ナポリ/
napolitan /ナポリタン/
nappage /ナパージュ/
napster /ナップスター;www.napster.com/
narcism /ナルシズム/
narciso /ナルシソ/
narcisse /ナルシス/
narcissism /ナルシシズム/
narcissist /ナルシシスト/
narcist /ナルシスト/
narcistic /ナルシスティック/
narcolepsy /ナルコレプシー/
narkissos /ナルキッソス/
narod /ナロード;(露語)人民/
narration /ナレーション/
narrative /ナラティブ/ナラティヴ/
narrator /ナレーター/
narrow /ナロー/
narrowband /ナローバンド/
nasa /NASA/
nasdaq /ナスダック/
nash /ナッシュ/
nasha /ナーシャ/
nashville /ナッシュヴィル/ナッシュビル;テネシー(USA)/
nassau /ナッソー/
nasser /ナセル/
nastassja /ナスターシャ/
nasturtium /ナスタチウム;キンレンカ/
nasty /ナスティー/ナスティ/
nat /ナット/
nata /ナタ/
natacha /ナターシャ/
natadecoco /ナタデココ;nata de coco/
natalia /ナタリア/
natalie /ナタリー/
natasha /ナターシャ/
nate /ネイト/
nathalie /ナタリー/
nathan /ネイサン/ナタン/ナータン/
nathaniel /ナサニエル/
nation /ネーション/ネイション/ナシオン;仏語/
national /ナショナル/
nationalism /ナショナリズム/
nationalist /ナショナリスト/
nationality /ナショナリティ/ナショナリティー/
nationalleague /ナショナルリーグ/
nationals /ナショナルズ;[MLB]/
native /ネイティブ/ネイティヴ/ネーティブ/
nativespeaker /ネイティブスピーカー/
natrium /ナトリウム;[元素]11,Na/
natriumion /ナトリウムイオン;sodium ion/
natriumlamp /ナトリウムランプ;sodium lamp/
natural /ナチュラル/
naturalcheese /ナチュラルチーズ/
naturalhigh /ナチュラルハイ/
naturalist /ナチュラリスト/
nature /ネイチャー/ナチュール;仏語/Ｎａｔｕｒｅ/
nauru /ナウル/
nausicaa /ナウシカ/
naut /ノート/
nautilus /ノーチラス/
navajo /ナバホ/ナヴァホ/
navarro /ナバロ/ナヴァロ/ナバーロ/
navel /ネーブル/
navi /ナビ/Ｎａｖｉ/ナヴィ/
navier /ナビア/
navigate /ナビゲート/
navigation /ナビゲーション/
navigationbar /ナビゲーションバー/
navigator /ナビゲーター/ナビゲータ/
navy /ネイビー/
navyblue /ネイビーブルー/
nay /ネイ/ナーイ/
nazar /ナザール/
nazare /ナザレ/
nazareth /ナザレ/ナザレス/
nazca /ナスカ;ペルー/
nazgul /ナズグル/
nazi /ナチ/
nazis /ナチス/
nazisdeutsch /ナチスドイツ/
nazism /ナチズム/
nb /ニオブ/Niobium/
nc /North Carolina/ノースカロライナ/
nd /North Dakota/ノースダコタ/ネオジム/Neodymium/
ne /≠/ネオン/Neon/Nebraska/ネブラスカ/└/┗;太/
neal /ニール/
neale /ニール/
neanderthal /ネアンデルタール/
near /ニア/
nearlyequal /≒/
nearmiss /ニアミス/
neat /ニート/
nebbiolo /ネッビオーロ/
nebraska /ネブラスカ;NE/
nebula /ネビュラ/
nec /日本電気/NEC/
neck /ネック/
neckar /ネッカー/
necker /ネッカー/
neckerchief /ネッカチーフ/
necklace /ネックレス/
neckline /ネックライン/
neckstrap /ネックストラップ/
necktie /ネクタイ/
necktiepin /ネクタイピン;和製英語(tiepin)/
necro /ネクロ/
necromancer /ネクロマンサー/
necrophilia /ネクロフィリア/
necropolis /ネクロポリス/
necrosis /ネクローシス/
nectar /ネクター/ネクタル/
nectarine /ネクタリン/
nector /ネクター/
ned /ネッド/
nederland /ネーデルラント/
need /ニード/
needle /ニードル/
needs /ニーズ/
neel /ニール/
neenah /ニーナ/
neeson /ニーソン/
neet /ニート;Not in Education, Employment or Training/
neg /¬/
nega /ネガ;negative/
negafilm /ネガフィルム;negative film/
negativa /ネガティブ/ネガティヴ/
negative /ネガティブ/ネガティヴ/
neglect /ネグレクト/
neglige /ネグリジェ/
negligee /ネグリジェ;英語綴り/
nego /ネゴ;negotiation/
negotiate /ネゴシエート/
negotiation /ネゴシエーション/
negotiator /ネゴシエーター/
negri /ネグリ/
negrito /ネグリト/
negro /ニグロ/ネグロ/
negroid /ネグロイド/
nehemiah /ネヘミヤ/
nehru /ネルー/
neige /ネージュ;(Fr)雪/
neighbor /ネイバー/
neil /ニール/
neill /ニール/
nein /ナイン;(独語)/
nejd /ネジド/
nektar /ネクタル/
nel /ネル/
nell /ネル/
nella /ネッラ/
nelldrip /ネルドリップ/
nelli /ネッリ/ネリー/ネリ/
nellie /ネリー/
nello /ネロ/
nelly /ネリー/
nelson /ネルソン/
nemacs /ＮＥｍａｃｓ/Ｎｅｍａｃｓ/ｎｅｍａｃｓ/NEmacs/
nematic /ネマティック/
nemesis /ネメシス/
nemo /ネモ/
nemophila /ネモフィラ/
neo /ネオ/
neoclassic /ネオクラシック/
neocon /ネオコン;<neo-conservative/
neodymium /ネオジム;[元素]60,Nd/ネオジミウム/
neogeo /ネオジオ;[商標]SNK/
neoliberalism /ネオリベラリズム/
neon /ネオン/
neonazi /ネオナチ/
neonsign /ネオンサイン/
neontetra /ネオンテトラ/
neoprene /ネオプレン;=chloroplene gum/
neoteny /ネオテニー/
nepal /ネパール;.np/
nepenthes /ネペンテス;ウツボカズラ/
nephrite /ネフライト/
nephrose /ネフローゼ/
nephrosis /ネフローゼ/
nephthys /ネフティス/
nepoch /NEpoch/
neptune /ネプチューン/
neptunium /ネプツニウム;[元素]93,Np/
neq /≠/
nereid /ネレイド/
nereides /ネレイデス/
nereis /ネレイス/
nereus /ネレウス/
nergal /ネルガル/
neri /ネリ/
nero /ネロ/
nerval /ネルヴァル;(1808-55) Gerard de Nerval/
nervous /ナーバス/
nescafe /ネスカフェ;[商標]Neslet/
ness /ネス/
nessie /ネッシー/
nest /ネスト/
nesta /ネスタ/
nesting /ネスティング/
nestle /ネスレ/ネッスル/
nestor /ネストール/ネスター/ネストル/
net /ネット/ネットワーク/
netauction /ネットオークション/
netbank /ネットバンク/
netbanking /ネットバンキング/
netbiz /ネットビジネス/
netbusiness /ネットビジネス/
netcafe /ネットカフェ/
netdatabase /ネットデータベース/
netgame /ネットゲーム/
nethack /ネットハック/
netherland /ネーデルランド/ネーデルラント/ネザーランド/
netherlands /オランダ;.nl/
netidol /ネットアイドル/
netin /ネットイン;和製英語/
netiquette /ネチケット;network etiquette/
netizen /ネチズン/
netlist /ネットリスト/
netmanner /ネットマナー;和製英語(netiquette)/
netmask /ネットマスク/
netnews /ネットニュース/
netone /ネットワン/
netplay /ネットプレイ/ネットプレー/
netradio /ネットラジオ/
netscape /ネットスケープ/
netshop /ネットショップ/
netshopping /ネットショッピング/
netstore /ネットストア/
netsurfing /ネットサーフィン/
netta /ネッタ/
nettalk /ＮＥＴｔａｌｋ/
nettopology /ネット・トポロジー/
nettv /ネットテレビ/
netware /ネットウェア/NetWare/
network /ネットワーク/アメリカネットワーク;net,.net/
networkaddress /ネットワークアドレス/
networkadmin /ネットワークアドミン/
networkcable /ネットワークケーブル/
networkcard /ネットワークカード/
networkcomputer /ネットワークコンピュータ/
networker /ネットワーカー/
networking /ネットワーキング/
networks /ネットワークス/
networksystem /ネットワークシステム/
neue /ノイエ;(独)/
neuf /ヌフ;(Fr) 新しい/
neumann /ノイマン/ノイマン型/
neural /ニューラル/Ｎｅｕｒａｌ/
neuralnet /ニューラルネット/ＮｅｕｒａｌＮｅｔ/
neuralnetwork /ニューラルネットワーク/
neuralware /ＮｅｕｒａｌＷａｒｅ/
neuro /ニューロ/
neurocomputer /ニューロコンピュータ/
neurocomputing /ニューロコンピューティング/
neuroethology /ニューロエソロジー/
neuromancer /ニューロマンサー/
neuron /ニューロン/
neuroscience /ニューロサイエンス/
neurose /ノイローゼ;(独語)/
neutral /ニュートラル/
neutrino /ニュートリノ/
neuve /ヌーヴ;(Fr) <neuf/
neva /ネヴァ/ネバ/
nevada /ネバダ;NV/
never /ネバー/ネヴァー/
nevergiveup /ネバーギブアップ/ネヴァーギブアップ/
neverland /ネバーランド/ネヴァーランド/
nevermind /ネバーマインド/ネバーマイン/
neville /ネビル/
new /ニュー/
newage /ニューエイジ/ニューエージ/
newalbum /ニューアルバム/
newark /ニューアーク;ニュージャージー(USA)/
newcaledonia /ニューカレドニア;New Caledonia/
newcastle /ニューカッスル/ニューキャッスル/ニューキャッスル大学/
newcomer /ニューカマー/
newdelhi /ニューデリー;New Delhi/
neweconomy /ニューエコノミー/
newell /ニューウェル/
newengland /ニューイングランド;New England, Australia/
newface /ニューフェイス/ニューフェース/
newfoundland /ニューファンドランド/
newfrontier /ニューフロンティア/
newguinea /ニューギニア;New Guinea/
newhalf /ニューハーフ;和製英語/
newhampshire /ニューハンプシャー;NH/
newjersey /ニュージャージー;NJ/Ｎｅｗ−Ｊｅｒｓｅｙ/
newman /ニューマン/
newmedia /ニューメディア/
newmexico /ニューメキシコ;NM/ニューメキシコ州立大学/
newmodel /ニューモデル/
newmusic /ニューミュージック/
newohtani /ニューオータニ/
neworleans /ニューオリンズ/ニューオーリンズ/
newrelease /ニューリリース/
news /ニュース/ニューズ/ＮｅＷＳ/
newscaster /ニュースキャスター/
newsfeed /ニュースフィード/
newsflash /ニュースフラッシュ/
newsgroup /ニュースグループ/
newsletter /ニュースレター/ニューズレター/
newsouthwales /ニューサウスウェールズ/
newspaper /ニュースペーパー/
newsreader /ニュースリーダー/
newsrelease /ニュースリリース/
newsserver /ニュースサーバ/ニュースサーバー/
newssite /ニュースサイト/
newssource /ニュースソース/
newsspool /ニューススプール/
newsstation /ニュースステーション;番組名/
newssystem /ニュースシステム/
newsweek /ニューズウィーク;www.newsweek.com/
newt /ニュート;イモリ/
newtech /ニューテック/
newton /ニュートン/
newtown /ニュータウン/
newtype /ニュータイプ/
newversion /ニューバージョン/
newwave /ニューウェーブ/ニューウェーヴ/
newworld /ニューワールド/
newyear /ニューイヤー/
newyork /ニューヨーク/紐育/
newyorkcity /ニューヨークシティ/
newyorker /ニューヨーカー;New Yorker/
newyorktimes /ニューヨークタイムズ;New York Times. www.nytimes.com/ニューヨーク・タイムズ/
newzealand /ニュージーランド;(.nz) New Zealand/
next /ネクスト/ＮｅＸＴ/NeXT/
nexus /ネクサス/
ng /ニュースグループ/
ngram /N-gram/
ngword /NGワード/
nh /New Hampshire/ニューハンプシャー/
nhkhall /NHKホール/
nhkradio /NHKラジオ/
ni /∋/ニッケル/Nickel/
niacin /ナイアシン/
niagara /ナイアガラ/
niamey /ニアメ/
nias /ナイアス/
nib /ニブ/
nibble /ニブル/
nibelung /ニーベルング/
nic /The Network Information Center/
nicad /ニッカド;nickel-cadmium/
nicaragua /ニカラグア;.ni/
nicd /NiCd/ニッカド;nickel-cadmium/
nice /ナイス/ニース/
nicebody /ナイスバディ/ナイスボディ/
nicecatch /ナイスキャッチ/
niceguy /ナイスガイ/
nicemiddle /ナイスミドル/
niceshot /ナイスショット/
niche /ニッチ/
nicholas /ニコラス/
nicholls /ニコルズ/ニコルス/
nichols /ニコルズ/ニコルス/
nicholson /ニコルソン/
nichrome /ニクロム/
nick /ニック/
nickel /ニッケル/
nicklaus /ニクラウス/
nickname /ニックネーム/
nicky /ニッキー/
nico /ニコ/
nicol /ニコル/
nicola /ニコラ/
nicolai /ニコライ/
nicolas /ニコラス/ニコラ;仏語/
nicolaus /ニコラウス/
nicole /ニコル/ニコール/
nicolet /ニコレ/
nicoletta /ニコレッタ/
nicolette /ニコレット/
nicollet /ニコレ/
nicolo /ニコロ/
nicorette /ニコレット;[商標]/
nicos /ニコス;www.nicos.co.jp/
nicosia /ニコシア/
nicotine /ニコチン/
niedersachsen /ニーダーザクセン/
niels /ニールス/
nielsen /ニールセン/
nietzsche /ニーチェ/
nif /Ｎｉｆｔｙ/
nifty /ニフティ/Ｎｉｆｔｙ/ＮＩＦＴＹ/
niftyserve /ニフティサーブ/
nigel /ナイジェル/
niger /ニジェール;.ne/
nigeria /ナイジェリア;.ng/
nigger /ニガー/
night /ナイト/
nightcap /ナイトキャップ/
nightcare /ナイトケア/
nightclub /ナイトクラブ/
nightcream /ナイトクリーム/
nighter /ナイター/
nightgame /ナイトゲーム/
nightgown /ナイトガウン/
nightingale /ナイチンゲール/
nightlife /ナイトライフ/
nightly /ナイトリー/
nightmare /ナイトメア/ナイトメアー/
nights /ナイツ/
nightspot /ナイトスポット/
nighttable /ナイトテーブル/
nighttime /ナイトタイム/
nighty /ナイティ/ナイティー/
nihil /ニヒル/
nihilism /ニヒリズム/
nihilist /ニヒリスト/
nihon /ニホン/
nihontv /日本テレビ;www.ntv.co.jp/
nijinsky /ニジンスキー/
nike /ナイキ/ニケ/
niki /ニキ/
nikita /ニキータ/
nikka /ニッカ/
nikki /ニキ/ニッキー/
niklas /ニクラス/
niko /ニコ/
nikola /ニコラ/
nikolai /ニコライ/
nikolaus /ニコラウス/
nikolay /ニコライ/
nikoli /ニコリ/
nikon /ニコン;www.nikon.co.jp/
nikos /ニコス/
niku /ニク/
nil /ニル/空リスト/ニール/
nile /ナイル/
nilgiri /ニルギリ;紅茶/
nils /ニルス/
nilson /ニルソン/
nilsson /ニルソン/
nim /ニム/
nimes /ニーム/
nin /ニン/
nina /ニーナ/ニナ/
ninaricci /ニナリッチ;www.ninaricci.fr/ニナ・リッチ/
nine /ナイン/
nineball /ナインボール/
nineteen /ナインティーン/
nineth /ナインス;※ninth/
ninety /ナインティ/
nino /ニーノ/
nintendo /ニンテンドー/
nintendods /ニンテンドーDS;[商標]/
ninth /ナインス/
niob /ニオブ;Nb/
niobe /ニオベ/
niobium /ニオブ;[元素]41,Nb(Cb)/
nip /ニップ/
nipper /ニッパー/
nipple /ニップル/
nippon /ニッポン/
nipponia /ニッポニア/
nir /ニール/
nirvana /ニルヴァーナ/ニルバーナ/
nissan /ニッサン/
nite /ナイト;=night/
nitrile /ニトリル/
nitro /ニトロ/
nitrobenzene /ニトロベンゼン/
nitrocellulose /ニトロセルロース/
nitrogen /ナイトロジェン;N/
nitroglycerine /ニトログリセリン/
nitrosamine /ニトロソアミン/
niue /ニウエ;.nu/
niven /ニーヴン/
nix /ニックス/
nixon /ニクソン/
nizhinskii /ニジンスキー/
nj /New Jersey/ニュージャージー/
nji /n次/
njigen /ｎ次元/
nko /ｎ個/
nm /ナノメートル;nanometre/New Mexico/ニューメキシコ/
no /ノー/Ｎｏ．/ＮＯ/No./ナンバー/番号/ノーベリウム/Nobelium/
no# /ナンバー#0/ナンバー#1/
no.# /ナンバー#0/ナンバー#1/
no1 /Ｎｏ．１/
noaa /ノア/
noah /ノア/
noam /ノーム/
nob /ノブ/
nobel /ノーベル/
nobelium /ノーベリウム;[元素]102,No/
noble /ノーブル/
noblesseoblige /ノブレスオブリッジ/
nobody /ノーバディ/ノーボディ/
nobound /ノーバウンド/
nobra /ノーブラ;braless/
nobrand /ノーブランド/
nocheck /ノーチェック;unchecked/
nocomment /ノーコメント/
nocount /ノーカウント/
nocturne /ノクターン/夜想曲/
nocut /ノーカット;和製英語(uncut)/
node /ノード/節点/
noel /ノエル;(Fr)クリスマス/Ｎｏёｌ/
noelle /ノエル/
nogame /ノーゲーム/
nogoal /ノーゴール/
noguard /ノーガード/
nohit /ノーヒット/
nohitnorun /ノーヒットノーラン;no-hitter/
noir /ノワール;(Fr)黒/ノアール/
noire /ノワール;(Fr)黒/ノアール/
noiret /ノワレ/
noise /ノイズ/
noiselevel /ノイズレベル/
noisereduction /ノイズリダクション/
noisette /ノワゼット/ノアゼット/
noisiness /ノイジネス/
noisy /ノイジー/ノイズィ/
nokia /ノキア;www.nokia.com/
nolan /ノーラン/
noloan /ノーローン;和製英語/
nomad /ノマド/
nomade /ノマド/
nomadic /ノマディック/
nomake /ノーメイク;和製英語/
nomark /ノーマーク;和製英語(unmarked)/
nomat /ノーマット;和製英語/
nombre /ノンブル/
nominal /ノミナル/
nominate /ノミネート/
nomore /ノーモア/
nomos /ノモス/
non /ノン/
nona /ノナ;9/ノーナ/
nonadult /ノンアダルト/
nonalcohol /ノンアルコール;nonalcoholic/
nonbank /ノンバンク/
noncalorie /ノンカロリー;和製英語(noncaloric)/
noncareer /ノンキャリア/
nonchalant /ノンシャラン/
nonecktie /ノーネクタイ;和製英語(tieless)/
nonet /ノネット/
nonfiction /ノンフィクション/
nonframe /ノンフレーム/
nongenre /ノンジャンル/
nonie /ノーニ/
nonlinear /ノンリニア/
nonmaskable /ノンマスカブル/
nonno /ノンノ;(アイヌ語)花/
nonoil /ノンオイル/
nonpro /ノンプロ;non-professional/
nonsection /ノンセクション/
nonsense /ナンセンス/ナンセンス！/
nonstop /ノンストップ/
nonsugar /ノンシュガー;sugar-free/
nonverbal /ノンバーバル/
noodle /ヌードル/
noon /ヌーン/
noout /ノーアウト/
nopan /ノーパン;pantyless/
noproblem /ノープロブレム/
nor /ノア/not or/ノル;(接頭辞)正-/
nora /ノラ/ノーラ/
noradrenalin /ノルアドレナリン/
noradrenaline /ノルアドレナリン/
norah /ノラ/ノーラ/
norbert /ノルベルト/ノーバート/
nordic /ノルディック/
nordicski /ノルディックスキー/
nordrheinwestfalen /ノルトラインヴェストファーレン/
noreturn /ノーリターン/
norfolk /ノーフォーク;.nf/
noriega /ノリエガ/
norisk /ノーリスク/
norm /ノルム/
norma /ノルマ/ノーマ/
normal /ノーマル/ノルマル;(独語)/正常/
normalhill /ノーマルヒル/
normalisation /ノーマライゼーション/
normalise /ノーマライズ/
normalization /ノーマライゼーション/
normalize /ノーマライズ/
normalmode /ノーマルモード/
norman /ノーマン/ノルマン/
normand /ノルマン/
normandie /ノルマンディー/ノルマンディ/
norn /ノルン/
norris /ノリス/
north /ノース/
northcarolina /ノースカロライナ;NC/
northdakota /ノースダコタ;ND/
northeast /ノースイースト/
northern /ノーザン/
northpole /ノースポール;north pole/
northrop /ノースロップ/
northwest /ノースウエスト/ノースウェスト/
northwestern /ノースウェスタン/
northwesternuniv /ノースウェスタン大学/
norton /ノートン/
norun /ノーラン/
norway /ノルウェー;.no/ノルウェイ/諾威/
nose /ノーズ/
nosferatu /ノスフェラトゥ/
noside /ノーサイド/
nosleeve /ノースリーブ/ノースリーヴ/
nostalgia /ノスタルジー/ノスタルジア/
nostalgic /ノスタルジック/
nostradamus /ノストラダムス/
not /ノット/¬/〜/
notation /ノーテーション/ノウテイション/
notch /ノッチ/
notchfilter /ノッチフィルタ/
note /ノート/
notebook /ノートブック/
notepad /ノートパッド/
notepasocom /ノートパソコン;notebook computer/
notepc /ノートPC/ノートパソコン/
noteq /≠/
notequal /≠/
notes /ノーツ/
nothing /ナッシング/
notice /ノーティス/
notify /ノーティファイ/
notime /ノータイム/
notouch /ノータッチ/
notre /ノートル;仏語/
notredame /ノートルダム/
nottingham /ノッティンガム/
notus /ノトス;南風/ノータス/
nouakchott /ヌアクショット/
nougat /ヌガー/
noumea /ヌメア/ヌーメア/
nouveau /ヌーヴォー/ヌーボー/
nouvelle /ヌーベル/ヌーヴェル/
nouvellevague /ヌーベルバーグ;nouvelle vague/ヌーヴェルヴァーグ/
nova /ノバ/ノヴァ/ノーヴァ/
novalis /ノヴァーリス/
novel /ノベル/ノヴェル/
novelgame /ノベルゲーム/
novelisation /ノベライゼーション/
novelise /ノベライズ/
novelization /ノベライゼーション/
novelize /ノベライズ/
novels /ノベルズ/ノベルス/
novelty /ノベルティ/ノベルティー/
noveltygoods /ノベルティグッズ/ノベルティーグッズ/
november /ノベンバー/
novice /ノービス/
novo /ノボ/
novosibirsk /ノボシビルスク/ノヴォシビルスク/
now /ナウ/
nowait /ノーウェイト/ノーウエイト/
nox /ノックス/窒素酸化物/
nozzle /ノズル/
np /ネプツニウム/Neptunium/
nqueen /Ｎクィーン/
nroff /エヌロフ/
nrzi /NRZI/
ns /│;罫線/┃;太い罫線/
nse /├/┣;太/┠;縦太/┝;横太/
nsew /┼/╋;太/┿;横太/╂;縦太/
nsw /┤/┫;太/┨;縦太/┥;横太/
nten /Ｎ点/
ntt /NTT/
nttdocomo /NTTドコモ;www.nttdocomo.co.jp/
ntv /日本テレビ/
nu /ν/ニュー/
nuance /ニュアンス/
nubia /ヌビア/
nuclear /ニュークリア/
nucleoside /ヌクレオシド/
nucleotide /ヌクレオチド;NB:nucleosideのリン酸エステル/
nude /ヌード/
nudemodel /ヌードモデル/
nudist /ヌーディスト/
nugget /ナゲット/
nukualofa /ヌクアロファ/
null /ヌル/ナル/NULL/
nullpointer /ヌルポインタ/
number /ナンバー/ナンバ/番号/＃/
numberdisplay /ナンバーディスプレイ/
numbering /ナンバリング/
numberone /ナンバーワン/
numberplate /ナンバープレート/
numbers /ナンバーズ/
numbertwo /ナンバーツー/
numeric /ニューメリック/
numerics /ニューメリックス/
nunez /ヌニェス/
nurnberg /ニュルンベルク/
nurse /ナース/
nursecall /ナースコール/
nursery /ナーサリー/
nursestation /ナースステーション/
nursing /ナーシング/
nut /ナット/
nutmeg /ナツメグ/
nutria /ヌートリア/
nutrition /ニュートリション/
nuts /ナッツ/
nuwaraeliya /ヌワラエリヤ;Nuwara Eliya,紅茶/
nv /Nevada/ネバダ/
nw /┘;罫線/┛;太い罫線/
ny /New York/ニューヨーク/Ｎ.Ｙ./
nydow /NYダウ/
nylon /ナイロン/
nymph /ニンフ/
nymphet /ニンフェット/
nymphomania /ニンフォマニア/
nyquist /ナイキスト/
nytimes /ニューヨークタイムズ;www.nytimes.com/ニューヨーク・タイムズ/
nyu /ν/
nyx /ニクス/ニュクス/
nz /ニュージーランド/
o /ο;omicron/○;記号のマル/о;cyrillic/オー/酸素/Oxygen/ω;※(oo) omega/
oacleaner /OAクリーナー/
oahu /オアフ/
oak /オーク/
oakland /オークランド;USA/
oakley /オークリー/オークレー/
oakridge /オークリッジ/
oaks /オークス/
oar /オール/
oasis /オアシス/
oat /オート/オート麦/
oatmeal /オートミール/
oats /オーツ/
oaxaca /オアハカ/
ob /オビ/
obadiah /オバデヤ/
obbligato /オブリガート/
obelisk /オベリスク/
oberon /オベロン/
obi /オビ/
obj /オブジェクト;object/
object /オブジェクト/
objectcode /オブジェクトコード/
objectoriented /オブジェクトオリエンテッド/
objectshikou /オブジェクト指向/
objet /オブジェ/
oblaat /オブラート;(蘭語)/
oblate /オブラート;(独語)/
oboe /オーボエ/
observation /オブザベーション/
observer /オブザーバー/オブザーバ/
obsession /オブセッション/
obsidian /オブシディアン/
obstruction /オブストラクション/
oc /∝;proportion/
ocalina /オカリナ;※ocarina/
ocarina /オカリナ/
occam /オッカム/
occlusion /オクルージョン/
occult /オカルト/
occupation /オキュペーション/職業/
occurrence /オカレンス/
ocean /オーシャン/
oceanblue /オーシャンブルー/
oceania /オセアニア/
oceanus /オケアノス/
ocelot /オセロット/
ochoa /オチョア/
ochs /オークス/オクス/
ocicat /オシキャット/
ockham /オッカム/
oconnor /オコナー;O'Conner/
ocrsoft /OCRソフト/
octa /オクタ;8/
octagon /オクタゴン;八角形/
octan /オクタン/
octane /オクタン;C8H18/
octave /オクターブ/オクターヴ/
octavia /オクタヴィア/オクタビア/
octavio /オクタビオ/
octet /オクテット/
octo /オクト;8/
october /オクトーバー/
octopus /オクトパス/
odalisk /オダリスク/
odalisque /オダリスク/
oday /オデイ;O'Day/
odd /オッド/
odds /オッズ/
ode /オード/
odense /オーデンセ/
odeon /オデオン/
odessa /オデッサ/
odette /オデット/
odin /オーディン/
odometer /オドメーター/
odysseia /オデュッセイア/
odysseus /オデュッセウス/
odyssey /オデッセイ/オデュッセイア/
oedipus /オイディプス/
of /オブ/オヴ/
off /オフ/
offbeat /オフビート/
offcom /オフコン;office computer/
offenbach /オッフェンバック/
offence /オフェンス/
offense /オフェンス/
offer /オファー/
office /オフィス/
office-computer /オフコン/
officecomputer /オフィスコンピュータ/オフコン/
officehour /オフィスアワー/
officelady /オフィスレディ/
officelove /オフィスラブ/
officer /オフィサー/
officesoft /オフィスソフト/
officesuite /オフィススイート/
officework /オフィスワーク/
officeworker /オフィスワーカー/
official /オフィシャル/
officialhomepage /オフィシャルホームページ/
officialhp /オフィシャルホームページ/
officialpage /オフィシャルページ/
officialsite /オフィシャルサイト/
offline /オフライン/
offpeak /オフピーク/
offrec /オフレコ/
offreco /オフレコ/
offroad /オフロード/
offroader /オフローダー/
offscreen /オフスクリーン/
offseason /オフシーズン/
offset /オフセット/
offshore /オフショア/
offshot /オフショット/
offshoulder /オフショルダー/
offside /オフサイド/
offsidetrap /オフサイドトラップ/
offsite /オフサイト/
offspring /オフスプリング/
offtime /オフタイム/
offtopic /オフトピック;off-topic/
offwhite /オフホワイト/
ogata /Ｏ型/
ogier /オジェ/
ogre /オーガ/オウガ/
oh /オー/Ohio/オハイオ/
ohara /オハラ;O'Hara/
ohhisse /オーエス;(Fr) oh hisse/
ohio /オハイオ;OH/
ohm /オーム/Ω/
oidipous /オイディプス/
oidipus /オイディプス/
oil /オイル/
oilfence /オイルフェンス/
oilheater /オイルヒーター/
oillighter /オイルライター;oil lighter/
oilmassage /オイルマッサージ/
oilmoney /オイルマネー/
oilpot /オイルポット/
oilsand /オイルサンド/
oilsardine /オイルサーディン/
oilskin /オイルスキン/
oily /オイリー/
ok /オッケー/オーケー/オーケイ/オッケイ/Ｏ.Ｋ./Oklahoma/オクラホマ/承知しました./大丈夫/
okapi /オカピ/
okeanos /オケアノス/
okhotsk /オホーツク/
oklahoma /オクラホマ;OK/
okra /オクラ/
olaf /オラフ/
olanda /オランダ/和蘭/
old /オールド/
oldenburg /オルデンブルグ/
oldfashion /オールドファッション/
oldies /オールディーズ/
oldmiss /オールドミス;和製英語(old maid)/
oldtype /オールドタイプ/
ole /オーレ/
oleg /オレグ/
oleo /オレオ/
olga /オルガ/オリガ/
oligo /オリゴ/
oligomer /オリゴマー/
olin /オーリン/
olive /オリーブ/オリーヴ/
olivegreen /オリーブグリーン/
oliveoil /オリーブオイル/
oliver /オリバー/オリヴァー/
olivia /オリビア/オリヴィア/
olivier /オリヴィエ/オリビエ/
olmeca /オルメカ/
ologun /オロゴン/
olympas /オリンパス/
olympia /オリンピア/
olympiad /オリンピアード/オリンピック;?/
olympic /オリンピック/
olympos /オリンポス/オリュンポス/
olympus /オリンパス/オリュンポス/
om /オウム/オーム/
omaha /オマハ/
omalley /オマリー;O'Malley/
oman /オマーン;.om/
ombra /オンブラ/
ombudsman /オンブズマン/
omega /ω/オメガ/
omelet /オムレツ/
omelette /オムレツ/オムレット/
omen /オーメン/
omicron /ο/オミクロン/
omit /オミット/
omni /オムニ/
omnibus /オムニバス/
omnis /オムニス/
omrice /オムライス;日本料理(omelette-rice)/
omron /オムロン;[企業名]www.omron.co.jp/立石電機;[企業名]/OMRON;[企業名]/
on /オン/
onahole /オナホール/
onair /オンエア/オンエアー/
onan /オナン/
onanie /オナニー/
onanist /オナニスト/
onapet /オナペット/
onbeat /オンビート/
onboard /オンボード/
once /ワンス/
oncemore /ワンスモア;once more/
onchip /オンチップ/
oncidium /オンシジウム/
ondemand /オンデマンド/
ondine /オンディーヌ;=undine/
one /ワン/
one-to-one /一対一/
onebound /ワンバウンド;和製英語(one-hopper)/
onebox /ワンボックス/
oneboxcar /ワンボックスカー/
onechip /ワンチップ/
oneclick /ワンクリック/
onecoin /ワンコイン/
onecup /ワンカップ;[商標]大関 (言い換え語:カップ酒)/
onecushion /ワンクッション;和製英語。「-置く」/
onedrink /ワンドリンク/
oneill /オニール;O'Neill/
onekey /ワンキー/
oneman /ワンマン/
onemanlive /ワンマンライブ/
onemanshow /ワンマンショー;one-man show/
onemore /ワンモア;one more/
onenight /ワンナイト/
oneout /ワンアウト/ワンナウト/
onepattern /ワンパターン/
onephrase /ワンフレーズ/
onepi /ワンピ;one-piece/
onepiece /ワンピース/ワンピ/
onepoint /ワンポイント/
onepointadvice /ワンポイントアドバイス/
onepush /ワンプッシュ/
onerank /ワンランク/
oneroom /ワンルーム/
oneroommansion /ワンルームマンション/
onescene /ワンシーン;one scene/
oneset /ワンセット/
oneshot /ワンショット/
oneshoulder /ワンショルダー/
oneside /ワンサイド/
onesidegame /ワンサイドゲーム/
onesize /ワンサイズ/
onestep /ワンステップ/
onestop /ワンストップ/
onetempo /ワンテンポ;和製語/
onetime /ワンタイム/
onetop /ワントップ/
onetouch /ワンタッチ/
onetwo /ワンツー/
oneway /ワンウェイ/ワンウェー/
onion /オニオン/
onionslice /オニオンスライス/
online /オンライン/
onlineauction /オンラインオークション/
onlinebanking /オンラインバンキング/
onlinecasino /オンラインカジノ/
onlinegame /オンラインゲーム/
onlinehelp /オンラインヘルプ/
onlinemagazine /オンラインマガジン/
onlinemanual /オンラインマニュアル/
onlineservice /オンラインサービス/
onlineshop /オンラインショップ/
onlineshopping /オンラインショッピング/
onlinesignup /オンラインサインアップ/
onlinesoft /オンラインソフト/
onlinestore /オンラインストア/
onlinesystem /オンラインシステム/
onlinetrade /オンライントレード/
only /オンリー/
onlyone /オンリーワン/
onoff /オン・オフ/オンオフ/
onomatopee /オノマトペ;仏語/
onomatopoeia /オノマトペ/
onon /オノン/
onparade /オンパレード;on parade/
onpu /♪/
onroad /オンロード/
onscreen /オンスクリーン/
onseason /オンシーズン;和製英語/
onsite /オンサイト/
onstage /オンステージ/
ontario /オンタリオ/
ontek /オンテック/
onthefly /オンザフライ;on-the-fly/
ontherock /オンザロック;on the rocks/
ontherocks /オンザロック;on the rocks/
ontime /オンタイム/
ontologie /オントロギー;存在論/オントロジー;仏語/
ontology /オントロジー;存在論/
onward /オンワード/
onyx /オニキス/
oo /∞;infinity/ω;omega/○○;まるまる/Object-Oriented/オブジェクト指向/
oodb /オブジェクト指向データベース/
oodl /OODL/
oolong /ウーロン/烏龍/
oolongtea /ウーロン茶/
oop /オブジェクト指向プログラミング/
ooparts /オーパーツ;out of place artifacts/
oopl /OOPL/
ooze /ウーズ/
opal /オパール/蛋白石/
ope /オペ;operation/
opecode /オペコード/
opel /オペル;www.opel.com/
open /オープン/開/
openair /オープンエア/
opencafe /オープンカフェ;和製語/
opencampus /オープンキャンパス/
opencar /オープンカー/
openend /オープンエンド/
opener /オープナー/
opengolf /オープンゴルフ/
openheart /オープンハート/
openhouse /オープンハウス/
opening /オープニング/
openingtheme /オープニングテーマ/
openjaw /オープンジョー/
openkitchen /オープンキッチン/
openlab /オープンラボ;openlab.jp/
openlook /ＯｐｅｎＬｏｏｋ/
openoffice /オープンオフィス;www.openoffice.org/
openprice /オープンプライス/オープン価格/
openreel /オープンリール/
openschool /オープンスクール/
opensource /オープンソース/
openspace /オープンスペース/
opensystem /オープンシステム/
openwindow /OpenWindow/
openwindows /ＯｐｅｎＷｉｎｄｏｗｓ/
opera /オペラ/歌劇/
operability /オペラビリティ/
operacity /オペラシティ;www.operacity.jp/
operaglass /オペラグラス;opera glasses/
operaglasses /オペラグラス/
operahouse /オペラハウス/
operand /オペランド/
operant /オペラント/
operate /オペレート/
operating /オペレーティング/
operatingsystem /オペレーティングシステム/
operation /オペレーション/操作/
operational /オペレーショナル/
operations /オペレーションズ/
operationsresearch /オペレーションズリサーチ;OR/オペレーションズ・リサーチ/オペレーションズ リサーチ/
operationsreserch /オペレーションズリサーチ;OR/
operator /オペレーター/オペレータ/演算子/
operetta /オペレッタ/
operon /オペロン/
ophelia /オフィーリア/オフェーリア/
opinion /オピニオン/
opinionleader /オピニオンリーダー/
opioid /オピオイド/
opium /オピウム/
oppenheimer /オッペンハイマー/
opportunity /オポチュニティ/オポチュニティー/
opt /オプト/
optical /オプティカル/
opticalflow /オプティカルフロー/
opticalmouse /オプティカルマウス/
optima /オプティマ/
optimal /オプティマル/
optimism /オプティミズム/
optimist /オプティミスト/
optimize /オプティマイズ/最適化/
optimizer /オプティマイザ/
optimum /オプティマム/
optin /オプトイン;opt-in/
option /オプション/
optional /オプショナル/
optionbutton /オプション・ボタン/
optionmenu /オプションメニュー/
options /オプションズ/
opto /オプト/
optout /オプトアウト;opt-out/
opus /オーパス/オプス/
or /オア/∨/∪/または/Oregon/オレゴン/
oracle /オラクル/
oral /オーラル/
oralsex /オーラルセックス/
orange /オレンジ/
orangecuracao /オレンジキュラソー/
orangejuice /オレンジジュース/
orangepeel /オレンジピール/
orangepekoe /オレンジペコ/オレンジペコー/
orangutan /オランウータン/
oratorio /オラトリオ/聖譚曲/
orb /オーブ/
orbis /オービス;ねずみとり/
orbit /オービット/
orbital /オービタル/
orbiter /オービター/
orc /オーク/
orca /オルカ/
orch /オケ;orchestra/
orchard /オーチャード/
orchardhall /オーチャードホール/
orche /オケ/
orchestra /オーケストラ/
orchestrapit /オーケストラピット/
orchestration /オーケストレーション/
orchid /オーキッド/
order /オーダー/オーダ/
ordermade /オーダーメイド/オーダーメード/
ordersheet /オーダーシート/
orderstop /オーダーストップ/
ordinary /オーディナリー/
ordos /オルドス/
oread /オレアード/
oregano /オレガノ/
oregon /オレゴン/
oreilly /オライリー;O'Reilly. www.oreilly.com/
oreillyjapan /オライリージャパン;[出版社名]www.oreilly.co.jp/O'Reilly Japan/
oreo /オレオ/
orestes /オレステス/
org /オルグ/
orga /オルガ/
organ /オルガン/オーガン/
organdie /オーガンジー/
organelle /オルガネラ/
organic /オーガニック/
organisation /オーガニゼーション/
organise /オーガナイズ/
organiser /オーガナイザー/
organism /オルガニズム/
organist /オルガニスト/
organization /オーガニゼーション/
organize /オーガナイズ/
organizer /オーガナイザー/オーガナイザ/
orgasm /オーガズム/オルガズム/オルガスム/
orgasme /オルガスム;仏語/オーガスム/
orgasmus /オルガスムス/
orgel /オルゴール;(蘭語)/
orgy /オージー/
orico /オリコ;www.orico.co.jp/
oricon /オリコン;www.oricon.co.jp/
orient /オリエント/
oriental /オリエンタル/
orientalism /オリエンタリズム/
orientation /オリエンテーション/オリエンテイション/
oriented /オリエンテッド/
orienteering /オリエンテーリング/
orifice /オリフィス/
origin /オリジン/
original /オリジナル/
originalalbum /オリジナルアルバム/
originalbrand /オリジナルブランド/
originalgoods /オリジナルグッズ/
originality /オリジナリティ/オリジナリティー/
originalprint /オリジナルプリント/
originalversion /オリジナルバージョン/
origo /オリゴ/
oring /Oリング;O-ring/Ｏリング/
orinoco /オリノコ/
oriol /オリオール/
orioles /オリオールズ;[MLB]/
orion /オリオン/
orix /オリックス/
orlando /オーランド/オルランド/
orleans /オルレアン/
orly /オルリー;フランス(ory)/
ornament /オーナメント/
ornella /オルネラ/
ornette /オーネット/
orourke /オルーク;O'Rourke/
orphan /オーファン/
orphee /オルフェ/
orpheus /オルフェウス/
orquesta /オルケスタ;(西語)/
orsay /オルセー/
orso /オルソ/
orson /オーソン/オルソン/
ortega /オルテガ/
ortho /オルト/オルソ/オーソ/
orthodox /オーソドックス/
ortiz /オルティス/
orvieto /オルヴィエート/
orwell /オーウェル/
oryza /オリザ;稲/
os /オペレーティングシステム/オペレーティング・システム/オスミウム/Osmian/基本ソフトウェア/OS/オペレイティング・システム;<rare>/
os9 /ＯＳ９/
osama /オサマ/
osborn /オズボーン/
osborne /オズボーン/
oscar /オスカー/オスカル/
oscillator /オシレーター/オシレータ/
oscillo /オシロ/
oscilloscope /オシロスコープ/
osciloscope /オシロスコープ;※oscilloscope/
osf /OSF/
osiris /オシリス/
oskar /オスカル/
oslo /オスロ/
osman /オスマン/
osmium /オスミウム;[元素]76,Os/
osmo /オスモ/
ossian /オシアン/
osteria /オステリア/
ostrich /オーストリッチ/オストリッチ/
osullivan /オサリバン;O'Sullivan/オサリヴァン/
oswald /オズワルド/
otacky /オタッキー/
otfried /オトフリート/
othello /オセロ/
other /アザー/その他/
otis /オーティス/
ottawa /オタワ/
otto /オットー/オット/
ottoman /オットマン/
ouch /アウチ/
oui /ウィ;(仏語)/ウィー;(仏語)/
ounce /オンス/
our /アワ/
ouroboros /ウロボロス/
ours /アワーズ/
out /アウト/
outboxing /アウトボクシング/
outbreak /アウトブレイク/
outcourse /アウトコース;和製英語(outside)/
outdoor /アウトドア/
outdoorlife /アウトドアライフ/
outer /アウター/
outerspace /アウタースペース/
outerwear /アウターウェア/
outfit /アウトフィット/
outlane /アウトレーン/
outlaw /アウトロー/
outlet /アウトレット/
outline /アウトライン/
outlinefont /アウトラインフォント/
outlook /アウトルック/
outlow /アウトロー;[野球]和製英語(outside low)/
outof /アウト・オブ・/アウトオブ/
outplacement /アウトプレースメント/
output /アウトプット/出力/
outside /アウトサイド/
outsider /アウトサイダー/
outsource /アウトソース/
outsourcing /アウトソーシング/
oval /オーバル/楕円/
ovation /オベーション/オヴェイション/
oven /オーブン/
ovenrange /オーブンレンジ;和製英語/
oventoaster /オーブントースター;和製英語(toaster oven)/
over /オーバー/オーバ/オーヴァー/
overall /オーバーオール/
overblouse /オーバーブラウス/
overbooking /オーバーブッキング/
overcharge /オーバーチャージ/
overclock /オーバークロック/
overcoat /オーバーコート/
overcomplete /オーバコンプリート/
overdoctor /オーバードクター/
overdrive /オーバードライブ/
overdubbing /オーバーダビング/オーヴァーダビング/
overflow /オーバーフロー/
overhaul /オーバーホール/
overhead /オーバーヘッド/オーバヘッド/
overkill /オーバーキル/
overknee /オーバーニー/
overlap /オーバーラップ/オーバラップ/
overlay /オーバーレイ/オーバレイ/
overline /オーバーライン;~/
overload /オーバーロード/
overloading /オーバーローディング/
overnight /オーバーナイト/
overpar /オーバーパー/
override /オーバーライド/
overrun /オーバーラン/
overseas /オーバーシーズ/
overskirt /オーバースカート/
overspec /オーバースペック/
overstay /オーバーステイ/
overtake /オーバーテイク/
overtime /オーバータイム/
overtop /オーバートップ/
overture /オーバーチュア/
overview /オーバービュー/
overwork /オーバーワーク/
overwrap /オーバーラップ/
overwrite /オーバーライト/オーバライト/
owen /オーウェン/オーエン/オウエン/
own /オウン/
owner /オーナー/オーナ/オウナー/
ownerchef /オーナーシェフ/
ownership /オーナーシップ/
owngoal /オウンゴール/
oxford /オックスフォード/
oxidant /オキシダント/
oxidase /オキシダーゼ/
oxide /オキサイド/オキシド/
oxine /オキシン/
oxo /オキソ/
oxy /オキシ/オキソ/
oxydol /オキシドール/
oxygen /オキシジェン/酸素/
oxygen-destroyer /オキシジェン・デストロイヤー/水中酸素破壊剤/
oxytocin /オキシトシン/
oyster /オイスター/
oystersauce /オイスターソース/
oz /オズ/
ozon /オゾン/
ozone /オゾン/
ozonehole /オゾンホール/
p /π;pi/ピー/п;pe (cyrillic)/リン/燐/Phosphorus/ピアノ;弱く/piano/
pa /プロトアクチニウム/Protactinium/ペンシルバニア/Pennsylvania/ペンシルベニア/
pablo /パブロ/
paca /パカ/
pace /ペース/
pacedown /ペースダウン/
pacemaker /ペースメーカー/ペースメーカ/
paceup /ペースアップ/
pachelbel /パッヘルベル/
pachinker /パチンカー/
pachinko /パチンコ/
pachislot /パチスロ;<pachinko + slot machine/
pacific /パシフィック/
pacifica /パシフィカ;(西)/
pacificleague /パシフィックリーグ/
pacifico /パシフィコ;(西)/
pack /パック/
package /パッケージ/
packagedesign /パッケージデザイン/
packagesoft /パッケージソフト/
packagetour /パッケージツアー/
packaging /パッケージング/
packard /パッカード/
packer /パッカー/
packet /パケット/
packetfilter /パケットフィルタ/
packetfiltering /パケットフィルタリング/
packing /パッキング/パッキン;蛇口の-/
packtour /パックツアー;package tour/
paclitaxel /パクリタキセル/
pacman /パックマン;[ゲーム]ナムコ/
paco /パコ/
pad /パッド/パット/
padang /パダン;インドネシア(pdg)/
padding /パディング/パッディング/
paddle /パドル/
paddling /パドリング/
paddock /パドック/
paddy /パディ/
padova /パドヴァ/
padre /バテレン/
padres /パドレス;[MLB]/
padstack /パッドスタック/
paella /パエリア/
pagan /パガン/
pagani /パガーニ/
paganini /パガニーニ/
page /ページ/ペイジ/頁/パージュ/
pageant /ページェント/
pagefault /ページフォールト/
pagein /ページイン/
pageone /ページワン/
pageout /ページアウト/
pageprinter /ページプリンタ/ページプリンター/
pager /ページャー/ページャ/
pagerank /ページランク/
pagesize /ページサイズ/
pagetable /ページテーブル/
pagetop /ページトップ/
paging /ページング/
pagingdaemon /ページングデーモン/
pagoda /パゴダ/
paid /ペイド/
pail /ペール/
pain /ペイン/パン;仏語/
paine /ペイン/
paint /ペイント/ペンキ;NB:蘭語pek/
painter /ペインター/
painting /ペインティング/
pair /ペア/ペアー/
pairglass /ペアガラス;和製英語(double glass)/
pairing /ペアリング/
pairlook /ペアルック/
pairring /ペアリング;和製英語(matching rings)/
pairticket /ペアチケット;和製英語(pair of tickets)/
pairwise /ペアワイズ/
paisa /パイサ/
pajamas /パジャマ/
pajero /パジェロ;[商標]三菱自動車/
pakistan /パキスタン;.pk/
pal /パル/
pala /パーラ/
palabora /パラボーラ;www.palabora.com(?) (NB:放物線はparabola/
palace /パレス/
palacios /パラシオス/
palais /パレ/
palau /パラオ;.pw/パラウ/
pale /ペール/ペイル/
paleague /パリーグ/パ・リーグ/パシフィックリーグ/
palembang /パレンバン/
paleo /パレオ;(接頭辞:古)/
palermo /パレルモ/
palestine /パレスチナ;.ps/パレスティナ/
palet /パレ;(Fr)円盤/
palette /パレット/
paletteknife /パレットナイフ/
pali /パーリ/
palikir /パリキール/
pall /ポール/パール/
palladium /パラジウム;[元素]46,Pd/
pallas /パラス/
pallet /パレット/
palm /パーム/
palma /パルマ/
palmer /パーマー/パルマー/パルメ/
palmier /パルミエ;(Fr) 棕櫚/
palmitin /パルミチン/
palmrest /パームレスト/
palmtop /パームトップ/
palmtree /パームツリー;palm tree,椰子の木/
palmyra /パルミラ;シリア/
palo /パロ/
paloma /パロマ/
palomar /パロマ/
palos /パロス/
palpal /パルパル/
pam /パン/パム/
pamela /パメラ/
pamir /パミール/パミル/
pampa /パンパ/
pampas /パンパス/
pampers /パンパース;[商標]P&G/
pamph /パンフ/
pamphlet /パンフレット/
pan /パン/
pana /パナ/パーナ/
panama /パナマ;.pa/
pancake /パンケーキ/
pancetta /パンチェッタ/
pancras /パンクラス/
panda /パンダ/
pandeiro /パンデイロ/
pandeiros /パンデイロ/
pandora /パンドラ/パンドーラー/
pane /ペイン/ペーン/パーネ;(It) パン/
panel /パネル/
paneldiscussion /パネルディスカッション/
paneler /パネラー/
panelheater /パネルヒーター/
panelist /パネリスト/
panflet /パンフレット;※pamphlet/
panflute /パンフルート/
pangaea /パンゲア/
panic /パニック/
panini /パニーニ;<panino/
panino /パニーノ/
panis /パニス/
panku /パンク;?/
pannacotta /パンナコッタ;(It) panna cotta/
pannier /パニエ/
panning /パニング/パンニング/
panopticon /パノプティコン/
panorama /パノラマ/
panoramic /パノラミック/
panpipe /パンパイプ/
panpot /パンポット/
pansto /パンスト;panty stocking/
pansy /パンジー/
pant /パント/
pantagruel /パンタグリュエル/
pantalon /パンタロン/
pantheon /パンテオン/
panther /パンサー/
pantie /パンティ/パンティー/
pantograph /パンタグラフ/
pantomime /パントマイム/
pantry /パントリー/
pants /パンツ/
pantslook /パンツルック/
pantssuit /パンツスーツ;※pantsuit/
pantsuit /パンツスーツ/
panty /パンティ/パンティー/
pantystocking /パンティストッキング/パンスト/
pantzer /パンツァー/
panza /パンサ/
paola /パオラ/
paolo /パオロ/
papa /パパ/
papageno /パパゲーノ/
paparazzi /パパラッチ/
papaya /パパイヤ/パパイア/
papeete /パペーテ;タヒチ/
paper /ペーパー/論文/
paperback /ペーパーバック/
papercraft /ペーパークラフト/
paperdrip /ペーパードリップ/
paperdriver /ペーパードライバー;和製英語/
paperholder /ペーパーホルダー/
paperjam /ペーパージャム/
paperknife /ペーパーナイフ/
paperless /ペーパーレス/
papermoon /ペーパームーン/
papertest /ペーパーテスト;和製英語/
paperweight /ペーパーウェイト/
papi /パピ/
papier /パピエ;(Fr)紙/
papillon /パピヨン/
paprika /パプリカ/
papua /パプア/
papuanewguinea /パプアニューギニア;Papua New Guinea/
par /パー/
para /パラ/
parabola /パラボラ/
parabolaantenna /パラボラアンテナ/
parachute /パラシュート/
parada /パラダ/
parade /パレード/
paradigm /パラダイム/
paradigmshift /パラダイムシフト/パラダイム・シフト/
paradise /パラダイス/
paradiso /パラディソ/
paradox /パラドックス/パラドクス/
paraffin /パラフィン/
paraglider /パラグライダー/
paragon /パラゴン/
paragraph /パラグラフ/¶/
paraguay /パラグアイ;.py/
paraiso /パライソ/
parallel /パラレル/‖/
parallelport /パラレルポート/
parallelturn /パラレルターン/
parallelworld /パラレルワールド/
paralympic /パラリンピック/
paramaribo /パラマリボ/
paramedic /パラメディック/
paramedical /パラメディカル/
parameter /パラメータ/パラメーター/パラメタ/パラメター/引数/
parameterfile /パラメーターファイル/
parameterization /パラメタリゼーション/
parameterized /パラメタライズド/
parametric /パラメトリック/
paramount /パラマウント/
parano /パラノ;paranoia/
paranoia /パラノイア/偏執狂/偏執病/
paranoid /パラノイド/
parapara /パラパラ/
paraphrase /パラフレーズ/
parasite /パラサイト/
parasol /パラソル/
parathion /パラチオン/
parco /パルコ/
parcolation /パーコレーション/
parcolator /パーコレーター/
pardon /パードン/
pare /パレ/
paredes /パレデス/
parent /ペアレント/
parenthesis /（/）/
parents /ペアレンツ/
pareto /パレート/
parfait /パフェ/パルフェ/
paris /パリ/パリス/
parisbrest /パリブレスト;paris-brest (お菓子)/
parisien /パリジャン/
parisiennne /パリジェンヌ/
parity /パリティ/パリティー/
paritybit /パリティビット/
park /パーク/
parka /パーカ/パーカー/
parker /パーカー/
parkhotel /パークホテル/
parking /パーキング/
parkingarea /パーキングエリア/
parkingmeter /パーキングメーター/パーキングメータ/
parkinson /パーキンソン/
parliament /パーラメント/
parlor /パーラー/
parlour /パーラー/
parme /パルム/
parmenides /パルメニデス/
parmesan /パルメザン/
parmigiano /パルミジャーノ/
parnasse /パルナス/
parnassos /パルナッソス/パルナソス/
parnassus /パルナッソス;(英語綴り)/
parnell /パーネル/
paro /パロ/
parody /パロディ/パロディー/
parole /パロール/
paroxetine /パロキセチン/
parque /パルク/
parrot /パロット/
parry /パリー/パリィ/
parrying /パリング/
parse /パース/パーズ/
parsec /パーセク/
parser /パーザ/パーザー/
parsifal /パルシファル/パルジファル/
parsing /パージング/
parsley /パセリ/
parsons /パーソンズ/
part /パート/
part# /パート#1/
parthenon /パルテノン/
partial /パーシャル/∂/
particle /パーティクル/
particleboard /パーティクルボード/
partisan /パルチザン/
partita /パルティータ/
partition /パーティション/パーテーション;esp.間仕切り/
partitioning /パーティショニング/
partner /パートナー/パートナ/
partners /パートナーズ/
partnership /パートナーシップ/
parts /パーツ/
parttime /パートタイム/
parttimer /パートタイマー/
party /パーティ/パーティー/
partygoods /パーティグッズ/
partyroom /パーティールーム/パーティルーム/
parvati /パールヴァティ/パールヴァティー/
pas /パ/
pasadena /パサデナ/
pascal /パスカル/
pascale /パスカル/
pascual /パスカル/
pasdedeux /パドドゥ;pas de deux/
pashtun /パシュトゥーン/
pasocom /パソコン/パーソナルコンピュータ/
pasocomsoft /パソコンソフト;PC software/
pasocon /パソコン/
pasolini /パゾリーニ/
pasona /パソナ;www.pasona.co.jp/
pass /パス/
passage /パッセージ/パサージュ;仏語/パッサージュ/
passball /パスボール;和製英語(passed ball)/
passcase /パスケース/
passcode /パスコード/
passenger /パッセンジャー/
passepied /パスピエ/
passing /パッシング/
passion /パッション/
passionata /パッショナータ/
passionato /パッショナート/
passionflower /パッションフラワー;時計草/
passionfruit /パッションフルーツ/
passionfruits /パッションフルーツ/
passive /パッシブ/
passphrase /パスフレーズ/
passport /パスポート/
passwd /パスワード/
password /パスワード/
passwordfile /パスワードファイル/
past /パスト/
pasta /パスタ/
pastamachine /パスタマシーン/パスタマシン/
pastapot /パスタポット/
pastasauce /パスタソース/
paste /ペースト/貼り付け/
pastel /パステル/
pastelblue /パステルブルー/
pastelcolor /パステルカラー/
pastelcolour /パステルカラー/
pastelpink /パステルピンク/
pasteur /パスツール/パストゥール/
pastiche /パスティーシュ/パスティッシュ/パスティシュ/
pastime /パスタイム/
pastis /パスティス/
pastor /パストール/
pastoral /パストラル/
pastorale /パストラル/パストラーレ;(イタリア語)/
pastral /パストラル;※pastoral?/
pastrius /パストリアス/
pastry /ペストリー/
pat /パット/
patagonia /パタゴニア/
pataliputra /パータリプトラ/
patcar /パトカー;patrol car/
patch /パッチ/
patchfile /パッチファイル/
patchkit /パッチキット/
patchrelease /パッチリリース/
patchtest /パッチテスト/
patchwork /パッチワーク/
pate /パテ/
patent /パテント/
paternalism /パターナリズム/
path /パス/
pathetic /パセティック/
pathos /ペーソス/パトス/ペイソス/
pathway /パスウェイ/
pathy /パシー/
patient /ペイシェント/
patio /パティオ/
patisserie /パティスリー;(Fr)ケーキ屋/
patissier /パティシエ/
patissiere /パティシエール;(Fr)ケーキ職人/
patlabor /パトレイバー;[アニメ]/
patlight /パトライト;[商標]/
patrice /パトリス/
patricia /パトリシア/
patrick /パトリック/
patriot /パトリオット/
patrol /パトロール/
patrolcar /パトロールカー/パトカー/
patron /パトロン/
patsy /パッツィ/
pattern /パターン/パタン/
patterner /パタンナー;和製英語(pattern maker)/
patternfile /パターンファイル/
patternmatch /パターンマッチ/
patternmatching /パターンマッチング/パターン・マッチング/
patternrecognition /パターン認識/
patterson /パターソン/
patti /パティ/
patty /パティ/パティー/
pau /ポー/
pauch /パウチ/
pauillac /ポイヤック/
paul /ポール/パウロ/パウル/
paula /ポーラ/パウラ/
paule /ポール/
paulette /ポーレット/
pauli /パウリ/
pauline /ポーリン/ポーリーヌ/
pauling /ポーリング/
paulo /パウロ/ポーロ/
paulos /パウロ/
paulus /パウルス/
pause /ポーズ/
pavane /パヴァーヌ/
pavarotti /パヴァロッティ/パバロッティ/
pavel /パヴェル/パベル/パーヴェル/
pavilion /パビリオン/
pavillon /パヴィヨン;仏語/
pavlov /パブロフ/パヴロフ/
pawn /ポーン/
pax /パックス;(latin) 平和/パクス/パークス/
paxil /パキシル/
pay /ペイ/
paycheck /ペイチェック/
payload /ペイロード/
payment /ペイメント/
payoff /ペイオフ/
paz /パス/
pb /鉛/Lead/
pc /パソコン/パーソナルコンピュータ/PC/
pc98 /ＰＣ９８/
pcat /ＰＣ／ＡＴ/
pccamera /PCカメラ/
pccard /PCカード/
pccase /PCケース/
pcdesk /パソコンデスク/PCデスク/
pcengine /PCエンジン;[商標]NEC/
pcgame /PCゲーム/パソコンゲーム/
pcibus /PCIバス/
pcicard /PCIカード/
pcidevice /PCIデバイス/
pcislot /PCIスロット/
pcl /PCL/PCL(Portable Common Loops)/
pcmaker /PCメーカー/パソコンメーカー/PCメーカ/パソコンメーカ/
pcmodel /ＰＣモデル/
pcode /Pコード;チケットぴあ/
pcrack /パソコンラック/PCラック/
pcshop /PCショップ/パソコンショップ/
pcsite /PCサイト/
pcsoft /PCソフト/パソコンソフト/
pd /パラジウム/Palladium/
pdffile /PDFファイル/
pdp# /PDP-#0/
pds /パブリックドメインソフト/パブリックドメーンソフトウエア/
pe /п;cyrillic/プロセッシングエレメント/
peace /ピース/
peaceboat /ピースボート;www.peaceboat.org/
peaceful /ピースフル/
peacesign /ピースサイン/
peach /ピーチ/
peacock /ピーコック/
peak /ピーク/
peakout /ピークアウト/
peaks /ピークス/
peaky /ピーキー/
peano /ペアノ/
peanut /ピーナッツ/ピーナツ/
peanutbutter /ピーナッツバター/ピーナツバター/
peanuts /ピーナッツ/ピーナツ/
peanutsbutter /ピーナッツバター/ピーナツバター/
pear /ペア;洋梨/
pearl /パール/真珠/
pearlcolor /パールカラー/
pearlcolour /パールカラー/
pearlharbor /パールハーバー;Pearl Harbor/
pearlite /パーライト/
pearlwhite /パールホワイト/
pearson /ピアソン/
peau /ポー/
pecan /ペカン/ピーカン/
pecannuts /ピーカンナッツ/
peccary /ペッカリー/
peche /ペシェ;(Fr) 罪/ペーシュ;(Fr) 桃/
pecker /ペッカー/
pectin /ペクチン/
pectine /ペクチン/
ped /ペド/
pedal /ペダル/
pedaling /ペダリング/
pedantic /ペダンティック/
pedantry /ペダントリー/
pedicure /ペディキュア/
pediment /ペディメント/
pedo /ペド/
pedophilia /ペドフィリア/
pedro /ペドロ/
pedrosa /ペドロサ/
pee /ピー/
peek /ピーク/
peel /ピール/
peeler /ピーラー/
peeling /ピーリング/
peephole /ピープホール/
peer /ピア/ペール;Peer Gynt/
peergynt /ペールギュント/ペール・ギュント/
peerreview /ピアレビュー/
peertopeer /ピアツーピア/
peg /ペグ/
pegasos /ペガソス/
pegasus /ペガサス/
peggy /ペギー/
pek /ペンキ;(蘭語)/
peking /ペキン/北京/
pekingduck /北京ダック/ペキンダック/
pekingese /ペキニーズ/
pekoe /ペコ/ペコー/
pel /ペル/
peleg /ペレグ/
peleus /ペレウス/
pelican /ペリカン/
pellagra /ペラグラ/
pelleas /ペレアス/
pellet /ペレット/
peloponnesos /ペロポネソス/
pembroke /ペンブローク/
pen /ペン/
pena /ペーニャ/
penalty /ペナルティ/ペナルティー/
penaltyarea /ペナルティーエリア/
penaltykick /ペナルティーキック;PK/
penang /ペナン/
pencase /ペンケース/
pence /ペンス/
pencil /ペンシル/
penclub /ペンクラブ;www.pen.org/
pendant /ペンダント/
pendanthead /ペンダントヘッド/
pendanttop /ペンダントトップ/
pending /ペンディング/
pendulum /ペンデュラム/
pene /ペネ/
penelope /ペネロペ/
penetration /ペネトレーション/
penfriend /ペンフレンド/
penguin /ペンギン/
penicillin /ペニシリン/
peninsula /ペニンシュラ/
penis /ペニス/
penlight /ペンライト/
penname /ペンネーム/
pennant /ペナント/
pennantrace /ペナントレース/
penne /ペンネ/
pennsylvania /ペンシルバニア/ペンシルベニア;PA/
penny /ペニー/
penpal /ペンパル/
penrose /ペンローズ/
pensee /パンセ/
pension /ペンション/
penstand /ペンスタンド/
penta /ペンタ;5/
pentablet /ペンタブレット/
pentagon /ペンタゴン/
pentane /ペンタン/
pentatonic /ペンタトニック/
pentax /ペンタックス;www.pentax.co.jp/
pentecost /ペンテコステ/
penthouse /ペントハウス/
pentium /ペンティアム/Pentium/
pentouch /ペンタッチ/
pentyl /ペンチル/
people /ピープル/
peoria /ピオリア;Illinois, USA/
pep /ペップ/
pepe /ペペ/
pepee /ペペ;仏語/
pepper /ペッパー/ペパー/
peppermill /ペッパーミル/
peppermint /ペパーミント/
pepperoncino /ペペロンチーノ/
pepsi /ペプシ;www.pepsi.com/
pepsico /ペプシコ;www.pepsico.com/
pepsicola /ペプシコーラ;Pepsi-Cola/
pepsin /ペプシン/
peptidase /ペプチダーゼ/
peptide /ペプチド/
peptideglycan /ペプチドグリカン/
peptidehormone /ペプチドホルモン;peptide hormone/
peptone /ペプトン/
per /ペール/パー/ペア/
percent /パーセント/％/
percentage /パーセンテージ/
perception /パーセプション/
perceptron /パーセプトロン/
perceval /パーシバル/パーシヴァル/
percival /パーシバル/
percuss /パーカス/
percussion /パーカッション/
percussionist /パーカッショニスト/
percussive /パーカッシブ/パーカッシヴ/
percy /パーシー/
pere /ペール;(Fr)父/
perestroika /ペレストロイカ/
perez /ペレス/
perfect /パーフェクト/
perfectv /パーフェクTV/
perform /パフォーム/
performance /パフォーマンス/パーフォーマンス/
performer /パフォーマー/
performing /パフォーミング/
perfume /パフューム/パルファン;仏語/
pergamon /ペルガモン/
pergola /パーゴラ/
peri /ペリ/
peridot /ペリドット/
perier /ペリエ/
periere /ペリエール/
perignon /ペリニョン/ペリニヨン/
period /ピリオド/Ｐｅｒｉｏｄ/．/
periodic /ピリオディック/
peripheral /ペリフェラル/
perkin /パーキン/
perkins /パーキンス/パーキンズ/
perl /パール/Ｐｅｒｌ/Perl/
perla /パーラ/
perlscript /Perlスクリプト/perlスクリプト/
perm /パーマ;permanent/
perma /パーマ/
permanent /パーマネント/
permil /‰/パーミル/
permill /‰/パーミル/
permission /パーミッション/
perno /ペルノ/
pero /ペロ/
peron /ペロン/
peroxo /ペルオキソ/
peroxy /ペルオキシ/
perp /┴/
perpignan /ペルピニャン/
perrault /ペロー/
perrin /ペラン/
perrine /ペリーヌ/
perrot /ペロー/
perry /ペリー/
persephone /ペルセポネ/ペルセフォネ/
persepolis /ペルセポリス/
perseus /ペルセウス/
persia /ペルシャ/ペルシア/
persistent /パーシステント/永続/
persocom /パソコン/
person /パーソン/
persona /ペルソナ/
personal /パーソナル/
personal-computer /パソコン/
personalcomputer /パーソナルコンピュータ/パーソナルコンピューター/
personalise /パーソナライズ/
personality /パーソナリティ/パーソナリティー/
personalize /パーソナライズ/
personalmedia /パーソナルメディア/
personnel /パーソネル/
perspective /パースペクティブ/
perth /パース/
perto /ペトロ/
peru /ペルー;.pe/
pescatore /ペスカトーレ/
peseta /ペセタ/
peshawar /ペシャワール;パキスタン/
pesrsonal /パーソナル/
pessac /ペサック/
pessary /ペッサリー/
pessimism /ペシミズム/
pessimist /ペシミスト/
pest /ペスト/
pet /ペット/
peta /ペタ;P,10^15/
petal /ペタル/
petanque /ペタンク/
petbottle /ペットボトル/PETボトル/
pete /ピート/
peter /ピーター/ペーター/ペテロ/ピョートル/ペテル/
peterburg /ペテルブルグ/
peterpan /ピーターパン;Peter Pan/
peterrabbit /ピーターラビット/
petersen /ペーターゼン/
peterson /ピーターソン/
petfood /ペットフード/
petgoods /ペットグッズ/
pethotel /ペットホテル/
petit /プチ/プティ/
petite /プティット/
petitgateau /プチガトー/プティガトー/
petitknife /ペティナイフ/
petittomato /プチトマト;和製英語(petite tomate?)/
petra /ペトラ/
petrarca /ペトラルカ/
petri /ペトリ/
petros /ペテロ/
petrouchka /ペトルーシュカ/
petrucciani /ペトルチアーニ/
petrus /ペトリュス/
pets /ペッツ/
petshop /ペットショップ/
petsitter /ペットシッター/
petticoat /ペチコート/
petting /ペッティング/
petty /ペティ/ペティー/
petunia /ペチュニア/
petz /ペッツ/
peugeot /プジョー/
pex /ペックス/
peyote /ペヨーテ/
pfalz /ファルツ/
pfartz /プファルツ/
pfizer /ファイザー/
ph /φ;phi/
phage /ファージ/
phalaenopsis /ファレノプシス/
phallus /ファルス/
phantasm /ファンタズム/
phantasma /ファンタズマ/
phantom /ファントム/
pharaoh /ファラオ/
pharisee /パリサイ/
pharma /ファーマ/
pharmacy /ファーマシー/
pharming /ファーミング/
phase /フェーズ/フェイズ/
phasing /フェージング/フェイズィング;<rare>/
phenol /フェノール/
phenolphthalein /フェノールフタレイン/
phenoxy /フェノキシ/
phenoxyethanol /フェノキシエタノール/
phenyl /フェニル;C6H5-/フェニール/
phenylalanine /フェニルアラニン;Phe/
pheromone /フェロモン/
phi /φ/ファイ/
phil /フィル/
philadelphia /フィラデルフィア/
phile /フィル;仏語/ファイル;英語/
philemon /フィレモン/ピレモン/
philharmonia /フィルハーモニア/
philharmonic /フィルハーモニック/
philharmonie /フィルハーモニー/
philharmony /フィルハーモニー/
philia /フィリア/
philip /フィリップ/
philipp /フィリップ/
philippa /フィリッパ/フィリパ/
philippe /フィリップ/
philippi /ピリピ/
philippine /フィリピン/フィリピーヌ/
philippinepub /フィリピンパブ/
philippines /フィリピン;.ph/比律賓/
philips /フィリップス/
phillies /フィリーズ;[MLB]/
phillips /フィリップス/
phillis /フィリス/
philly /フィリー/
philo /フィロ/
philology /フィロロジー/
philopon /ヒロポン/
philosophy /フィロソフィー/
phishing /フィッシング/
phmeter /pHメーター/pHメータ/
phnompenh /プノンペン;Phnom Penh/
pho /フォー;ベトナム料理/
phobia /フォビア/
phobos /フォボス/
phoebe /フィービー/フェーベ/
phoenicia /フェニキア/
phoenix /フェニックス/
phon /フォン/
phone /フォン/ホン/
phono /フォノ;(接頭辞:音)/
phonon /フォノン/
phononics /フォノニクス/
phony /フォニー/
phosgen /ホスゲン/
phosgene /ホスゲン/
phosphor /フォスファー;P/
photo /フォト/
photoalbum /フォトアルバム/
photocd /フォトCD/
photocontest /フォトコンテスト/
photocoupler /フォトカプラ/
photoframe /フォトフレーム/
photogallery /フォトギャラリー/
photogenic /フォトジェニック/
photograph /フォトグラフ/
photographer /フォトグラファー/
photography /フォトグラフィー/フォトグラフィ/
photolog /フォトログ/
photomask /フォトマスク/
photon /フォトン/
photoretouch /フォトレタッチ/
photoshop /フォトショップ/
photostand /フォトスタンド;和製英語/
phrase /フレーズ/
phrasing /フレージング/フレイジング/
phrygian /フリジアン;EFGABCDE/
phthalein /フタレイン/
phuket /プーケット/
phyllis /フィリス/
physical /フィジカル/
physics /フィジックス/
physis /ピュシス/
pi /π/パイ/
pia /ピア/ぴあ;www.pia.co.jp/
piacere /ピアチェーレ/
piaf /ピアフ/
pianica /ピアニカ/
pianism /ピアニズム/
pianissimo /ピアニッシモ/
pianist /ピアニスト/
piano /ピアノ/
pianocover /ピアノカバー/
pianoforte /ピアノフォルテ/
pianosolo /ピアノソロ/
pianosonata /ピアノソナタ/
pianotrio /ピアノトリオ/
piazza /ピアッツァ;(It)広場/ピアザ/
piazzolla /ピアソラ/
pica /パイカ/
picador /ピカドール/
picard /ピカード/ピカール/
picaresque /ピカレスク/
picasso /ピカソ/
piccadilly /ピカデリー/
piccata /ピカタ/
piccoli /ピッコリ/
piccolo /ピッコロ/
pichon /ピション/
pick /ピック/
pickel /ピッケル/
picker /ピッカー/
picket /ピケ/ピケット/
picking /ピッキング/
pickles /ピクルス/
pickup /ピックアップ/
picmicom /PICマイコン/
picnic /ピクニック/
pico /ピコ;[SI接頭語]p,10^-12/
picot /ピコ/
pictogram /ピクトグラム/
picture /ピクチャー/ピクチャ/
picturecard /ピクチャーカード/ピクチャカード/
picturelabel /ピクチャーレーベル/
pid /プロセスID/
pidgin /ピジン/
pie /パイ/
piece /ピース/
pieces /ピーシーズ/
piedra /ピエドラ/
piemonte /ピエモンテ;イタリア/
pier /ピア/ピアー/ピエル/
pierce /ピアス;和製英語/
piercer /ピアッサー/
piercing /ピアッシング/ピアシング/
piero /ピエロ/
pierre /ピエール/
pierrecardin /ピエールカルダン;Pierre Cardin. www.pierrecardin.com/
pierrot /ピエロ/
piers /ピアス/
pieta /ピエタ/
pietro /ピエトロ/
piezo /ピエゾ;圧電/
pig /ピッグ/
pigeon /ピジョン/
piggy /ピギー/
pigma /ピグマ/
pigmy /ピグミー/
pilaf /ピラフ/
pilar /ピラール/
pilatus /ピラト/
pile /パイル/
piledriver /パイルドライバー/
pilgrim /ピルグリム/
pill /ピル/
pillar /ピラー/
pillow /ピロー/
pillowcase /ピローケース;枕カバー/
pilot /パイロット/
pilotis /ピロティ/ピロティー/
pilotlamp /パイロットランプ/
piment /ピーマン;仏語/
pin /ピン/
pinbadge /ピンバッジ/
pinball /ピンボール/
pincet /ピンセット;(蘭語) NB:forceps(En)/
pinch /ピンチ/
pincher /ペンチ/ピンチャー/
pinchhitter /ピンチヒッター/
pinchrunner /ピンチランナー/
pindaros /ピンダロス/
pine /パイン/
pineapple /パイナップル/
pineau /ピノー/
pines /パインズ/
ping /ピン/ピング/
pingpong /ピンポン/
pingu /ピングー/
pinheel /ピンヒール/
pinhole /ピンホール/
pinholecamera /ピンホールカメラ/
pinjack /ピンジャック/
pink /ピンク/
pinkerton /ピンカートン/
pinklady /ピンクレディー/ピンクレディ/
pinknoise /ピンクノイズ/
pinkpanther /ピンクパンサー/
pinkrotor /ピンクローター/
pinksalon /ピンクサロン/ピンサロ/
pinky /ピンキー/
pinnacle /ピナクル/
pinnock /ピノック/
pino /ピノ/
pinocchio /ピノキオ/
pinochet /ピノチェト/
pinot /ピノ/
pinotnoir /ピノノワール;pinot noir/
pinpoint /ピンポイント/
pinscher /ピンシャー/
pinstripe /ピンストライプ/
pint /ピント/パイント/
pinto /ピント/
pinup /ピンナップ/
pinyin /ピンイン/
pio /ピオ/
pion /パイオン/
pioneer /パイオニア/
piotr /ピョートル/
pipe /パイプ/
pipecut /パイプカット;和製英語(vasectomy)/
pipeline /パイプライン/
pipeorgan /パイプオルガン/
piper /パイパー/
pipette /ピペット/
piping /パイピング/
pippi /ピッピ;Pippi Langkous/
pippin /ピピン/
pique /ピケ/
piranha /ピラニア/
pirarucu /ピラルク/
pirates /パイレーツ;[MLB]/
pirlo /ピルロ/
pirouette /ピルエット/
pirozhki /ピロシキ/
pisa /ピサ/
pisces /ピスケス;魚座/
piss /ピス/
pissarro /ピサロ/
pistachio /ピスタチオ/
pistol /ピストル/
piston /ピストン/
pit /ピット/
pita /ピタ;中東のパン/
pitapain /ピタパン;pita bread/
pitch /ピッチ/
pitcher /ピッチャー/
pitcherfly /ピッチャーフライ/
pitchergoro /ピッチャーゴロ;和製語(grounder)/
pitching /ピッチング/
pitchingwedge /ピッチングウェッジ/
pitcrew /ピットクルー/
pitfall /ピットフォール/
pitin /ピットイン;和製英語(pit stop)/
pitinn /ピットイン;www.pit-inn.com/ＰｉｔＩｎｎ/
pitstop /ピットストップ/
pittsburgh /ピッツバーグ;USA/
pius /ピウス/ピアス/
pivot /ピボット/
pixel /ピクセル/
pixer /ピクサー/
pixmap /ピックスマップ/
pixus /ピクサス;[商標]Canon/
pixy /ピクシー/
pizarro /ピサロ/
pizza /ピザ/ピッツァ/ピッツア/
pizzala /ピザーラ;www.pizza-la.co.jp/
pizzeria /ピッツェリア/
pizzicato /ピチカート/
pla /プラ;plastic/
placard /プラカード/
placase /プラケース;plastic case/
place /プレイス/プレース/プラース/
placebo /プラシーボ/プラセボ/
placid /プラシッド/
placido /プラシド/
plain /プレーン/プレイン/
plaintext /プレーンテキスト/
plaisir /プレジール;(Fr)快楽/
plala /ぷらら;www.plala.or.jp/
plamo /プラモ;plamodel/
plamodel /プラモデル;plastic model/
plan /プラン/
planaria /プラナリア/
planck /プランク/
plane /プレーン/
planet /プラネット/
planetarium /プラネタリウム/
planetary /プラネタリー/
planets /プラネッツ/
planing /プレーニング/プランニング;※plaNNing/
plank /プランク/
plankton /プランクトン/
planner /プランナー/プランナ/
planning /プランニング/
plant /プラント/
plantation /プランテーション/
planter /プランター/
plants /プランツ/
plaque /プラーク/
plasma /プラズマ/
plasmadisplay /プラズマディスプレイ/
plasmatv /プラズマテレビ/
plasmid /プラスミド/
plassey /プラッシー/
plaster /プラスター/
plasterboard /プラスターボード/
plastic /プラスチック/プラスティック/
plasticlens /プラスチックレンズ/
plastics /プラスチックス/
platanus /プラタナス/
plate /プレート/
plateau /プラトー/
platetectonics /プレートテクトニクス/
platform /プラットフォーム/プラットホーム/
plathome /ぷらっとホーム;www.plathome.co.jp NB:駅のはplatform/
platina /プラチナ/
platini /プラティニ/
platinum /プラチナ/
plato /プラトン/
platon /プラトン/
platonic /プラトニック/
platonism /プラトニズム/
platoon /プラトン/プラトーン/
platt /プラット/
platter /プラッタ/プラッター/
play /プレイ/プレー/
playback /プレイバック/プレーバック/
playball /プレイボール/プレーボール/
playboy /プレイボーイ/
player /プレーヤー/プレイヤー/プレーヤ/プレイヤ/
players /プレイヤーズ/
playgirl /プレイガール/
playguide /プレイガイド;和製英語(ticket agency)/
playing /プレイング/プレーイング/
playlist /プレイリスト/
playmate /プレイメイト/
playmode /プレイモード/
playoff /プレーオフ/プレイオフ/
playroom /プレイルーム/
plays /プレイズ/
playspot /プレイスポット/
playstation /プレイステーション;[商標]Sony/プレステ/
playstyle /プレイスタイル/
plaza /プラザ/プラーザ/プラサ/
plazahotel /プラザホテル/
please /プリーズ/
pleasure /プレジャー/
pleats /プリーツ/
pleatsskirt /プリーツスカート/
pleiade /プレイアード/
pleiades /プレアデス/プレイアデス/
plein /プレーン/プレイン/
pletnev /プレトニョフ/
plind /プリンディ;?/
plinius /プリニウス/
plot /プロット/
plotinos /プロティノス/
plototype /プロトタイプ/
plotter /プロッタ/プロッター/
plough /プラウ/
plow /プラウ/
plug /プラグ/
plugandplay /プラグアンドプレイ/
plugin /プラグイン/
plum /プラム/
plumeria /プルメリア/
plumi /±/
plus /プラス/＋/
plusalpha /プラスα/プラスアルファ/+α/＋α/
plusdriver /プラスドライバー;和製英語(Phillips-head screwdriver)/
plusion /プラスイオン;和製英語(positive ion)/
plusminus /プラスマイナス/±/
plusone /プラスワン/
plutarch /プルターク/プルタルコス/
plutarchos /プルタルコス/
pluthermal /プルサーマル;和製英語(plutonium + thermal)/
pluto /プルート/
pluton /プルトン/
plutonium /プルトニウム;[元素]94,Pu/
plymouth /プリマス/
pm /±/プロメチウム/Promethium/
po /ポロニウム/Polonium/ポー/
poachedegg /ポーチドエッグ/
pochette /ポシェット/
pocket /ポケット/
pocketbell /ポケットベル/ポケベル/
pocketmoney /ポケットマネー/
pocketmonster /ポケットモンスター/
pocketreference /ポケットリファレンス/
pocketsize /ポケットサイズ/
pockettissue /ポケットティッシュ/
pocky /ポッキー/
poco /ポコ/
pocoapoco /ポコアポコ;poco a poco/ポコ・ア・ポコ/
pod /ポッド/
podcast /ポッドキャスト/
podcasting /ポッドキャスティング/
podium /ポディウム/
poe /ポー/
poem /ポエム/
poeme /ポエム;仏語/
poertyreading /ポエトリーリーディング/
poesie /ポエジー/
poet /ポエット/ポエト/
poete /ポエット;(Fr)詩人/ポエト/
poetic /ポエティック/
poetry /ポエトリー/
poile /ポワール/
poincare /ポアンカレ/
poinsettia /ポインセチア/
point /ポイント/ポワン;仏語/ポアン;仏語/・/点/
pointcard /ポイントカード/
pointer /ポインタ/ポインター/
pointing /ポインティング/
pointingdevice /ポインティングデバイス/
points /ポインツ/
pointservice /ポイントサービス/
pointsystem /ポイントシステム/
pointup /ポイントアップ/
poire /ポワール;(Fr) 洋梨/ポアール/
poirot /ポワロ/
poison /ポイズン/
poisonpill /ポイズンピル/
poisson /ポアソン/
poitiers /ポワティエ/
pokemon /ポケモン;pocketmonster/
poker /ポーカー/
pokerface /ポーカーフェイス/
pokhara /ポカラ/
pola /ポーラ/
poland /ポーランド;.pl/
polanski /ポランスキー/
polanyi /ポランニー/
polar /ポーラー/
polaris /ポラリス/
polaroid /ポラロイド/
polaroidcamera /ポラロイドカメラ/
polder /ポルダー/
pole /ポール/
polenta /ポレンタ/
polepole /ポレポレ/
poleposition /ポールポジション/
police /ポリス/
policeman /ポリスマン/
policy /ポリシー/ポリシ/
polimeralloy /ポリマーアロイ;polimer alloy/
poling /ポーリング/
polio /ポリオ/
polis /ポリス/
polish /ポリッシュ/ポーランド;?/
polisher /ポリッシャー/
political /ポリティカル/
politician /ポリティシャン/
politics /ポリティクス/ポリティックス/
polka /ポルカ/
poll /ポール/
polling /ポーリング/
pollini /ポリーニ/
pollux /ポルックス/
polly /ポリー/
pollyanna /ポリアンナ/
polo /ポロ/ポーロ/
polonaise /ポロネーズ/
polonium /ポロニウム;[元素]84,Po/
poloshirt /ポロシャツ/
poloshirts /ポロシャツ/
poltergeist /ポルターガイスト/
poly /ポリ/
polyamide /ポリアミド/
polybucket /ポリバケツ;polyethylene bucket/
polycarbonate /ポリカーボネート/
polydextrose /ポリデキストロース/
polydor /ポリドール/
polyester /ポリエステル/
polyethylene /ポリエチレン/
polyethyleneglycol /ポリエチレングリコール/
polygon /ポリゴン/
polygraph /ポリグラフ/
polyline /ポリライン/
polymer /ポリマー/重合体/
polymerase /ポリメラーゼ/
polymorphic /ポリモルフィック/多相型/
polymorphism /ポリモーフィズム/ポリモルフィズム/
polynesia /ポリネシア;.pf/
polynesian /ポリネシアン/
polyp /ポリープ/ポリプ/
polyphonic /ポリフォニック/
polyphony /ポリフォニー/
polypropylene /ポリプロピレン/
polyrhythm /ポリリズム/
polysilane /ポリシラン/
polystar /ポリスター/
polystyrene /ポリスチレン/
polytank /ポリタンク;和製英語(polybottle)/
polyurethane /ポリウレタン/
polyvinyl /ポリビニル/
pomade /ポマード/
pomato /ポマト;<potato + tomato/
pomeranian /ポメラニアン;犬/
pomerol /ポムロール/
pomodoro /ポモドーロ;(It)トマト/
pomp /ポンプ;(蘭語)/
pompeii /ポンペイ/
pompidou /ポンピドゥー/ポンピドゥ/ポンピドー/
poncho /ポンチョ/
pond /£/ポンド/
pong /ポン/
pons /ポンス/
ponte /ポンテ/
ponti /ポンティ/
pontiac /ポンティアック/
pontneuf /ポンヌフ;Pont-Neuf/
ponty /ポンティ/
pony /ポニー/
ponycanyon /ポニーキャニオン;www.ponycanyon.co.jp/
ponytail /ポニーテール/
poo /Parallel Object-Oriented/
poodle /プードル/
pooh /プー/
pool /プール/Parallel Object-Oriented Language/
poolside /プールサイド/
poor /プア/
pop /ポップ/
popart /ポップアート/
popband /ポップバンド/
popcorn /ポップコーン/
popculture /ポップカルチャー/
pope /ポープ;法王/
popeye /ポパイ/
popfly /ポップフライ/
poplar /ポプラ/
poplin /ポプリン/
popmusic /ポップミュージック/
popp /ポップ/
popper /ポッパー/ポパー/
poppins /ポピンズ/
poppy /ポピー/
pops /ポップス/
popsong /ポップソング/
popular /ポピュラー/
popularmusic /ポピュラーミュージック/
popularscience /ポピュラーサイエンス/
popularsong /ポピュラーソング/
populism /ポピュリズム/
populist /ポピュリスト/
popup /ポップアップ/
popupmenu /ポップアップメニュー/ポップアップ・メニュー/
popupwindow /ポップアップウィンドウ/
porcelain /ポーセリン/ポーセレン/
porch /ポーチ/
porcini /ポルチーニ/
pork /ポーク/
porkchop /ポークチョップ/
porkcurry /ポークカレー/
porno /ポルノ/
pornography /ポルノグラフィ/ポルノグラフィー/
pororoca /ポロロッカ/
porphyrin /ポルフィリン/
porsche /ポルシェ/
port /ポート/
portability /ポータビリティ/
portable /ポータブル/
portableaudio /ポータブルオーディオ/
portableplayer /ポータブルプレーヤー/
portal /ポータル/
portalsite /ポータルサイト/
portamento /ポルタメント/
portasound /ポータサウンド/
portatone /ポータトーン/
porter /ポーター/
portfolio /ポートフォリオ/
porting /ポーティング/
portio /ポルチオ/
portion /ポーション/
portland /ポートランド/
portlouis /ポートルイス;Port Louis/
portmoresby /ポートモレスビー;Port Moresby/
porto /ポルト/
portrait /ポートレート/ポートレイト/
ports /ポーツ/
portsaid /ポートサイド/
portscan /ポートスキャン/
portside /ポートサイド/
portsmouth /ポーツマス/
portugal /ポルトガル;.pt/葡萄牙/
portulaca /ポーチュラカ/
portvila /ポートヴィラ;Port-Vila/
portwine /ポートワイン/
pose /ポーズ/
poseidon /ポセイドン/
posi /ポジ;positive/
posifilm /ポジフィルム;positive film/
posing /ポージング/
position /ポジション/
positioning /ポジショニング/
positive /ポジティブ/ポジティヴ/
posix /POSIX/
possum /ポッサム/
possystem /POSシステム/
post /ポスト/〒/
postal /ポスタル/
postcard /ポストカード/
postcolonial /ポストコロニアル/
postdoc /ポストドク/
postdoctor /ポストドクター/ポスドク/
poster /ポスター/ポスタ/
postercolor /ポスターカラー/
postercolour /ポスターカラー/
postersession /ポスターセッション/
postharvest /ポストハーベスト/
posting /ポスティング/
postit /ポストイット;[商標]3M/ポウストイット;<rare>/
postman /ポストマン/
postmaster /ポストマスター/ポストマスタ/
postmethod /POSTメソッド/
postmodern /ポストモダン/
postpet /ポストペット/
postprocess /ポストプロセス/
postscript /ポストスクリプト/
postseason /ポストシーズン/
pot /ポット/
potage /ポタージュ/
potala /ポタラ;チベット・ラサ/
potassium /カリウム;[元素]19,K/ポタシウム;=Kalium/ポタジウム/
potato /ポテト/
potatochip /ポテトチップ/
potatochips /ポテトチップス/
potatofry /ポテトフライ;和製英語(fried potatoes)/
potatosalad /ポテトサラダ/
potaufeu /ポトフ;pot-au-feu/
potemkin /ポチョムキン/
potente /ポテンテ/
potential /ポテンシャル/
potentiometer /ポテンショメータ/
pothos /ポトス/
potion /ポーション/
potlatch /ポトラッチ/
potomac /ポトマック/
potpourri /ポプリ;(Fr) pot-pourri/
potsdam /ポツダム/
potter /ポッター/
pottery /ポタリー/ポッタリー/
pouch /ポーチ/パウチ/
poudre /プードル;(Fr) 粉/
poulain /プラン/
poulenc /プーランク/
pound /ポンド/パウンド/£/
poundcake /パウンドケーキ/
poussin /プーサン/プッサン/
powder /パウダー/
powderroom /パウダールーム/
powdersnow /パウダースノー/
powderspray /パウダースプレー/
powdery /パウダリー/
powell /パウエル/
power /パワー/
poweramp /パワーアンプ/
powerbalance /パワーバランス/
powerbomb /パワーボム/
powerbook /パワーブック/
powercable /パワーケーブル/
powerdown /パワーダウン/
powered /パワード/
powerful /パワフル/
powergame /パワーゲーム/
poweroff /パワーオフ/
poweron /パワーオン/
powerpoint /パワーポイント;[商標]Microsoft/
powers /パワーズ/
powershovel /パワーショベル/
powerspector /パワースペクトル/
powersteer /パワステ/
powersteering /パワーステアリング/パワステ/
powerstone /パワーストーン/
powerup /パワーアップ/
poweruser /パワーユーザー/パワーユーザ/
powerwindow /パワーウィンドウ/
pp /ピアニッシモ;pより弱く/pianissimo/
ppp /ピアニッシッシモ;ppより弱く/pianississimo/
pr /プラセオジム/Praseodymium/
practical /プラクティカル/
practice /プラクティス/
prada /プラダ;www.prada.it/
prado /プラド/
pragma /プラグマ/
pragmatic /プラグマティック/
prague /プラハ/
praha /プラハ/
praia /プライア/
prairie /プレーリー/
prairiedog /プレーリードッグ/
praise /プレイズ/
praline /プラリネ/プラリーヌ/
pralinee /プラリネ/
praseodymium /プラセオジミウム;[元素]59,Pr/
prasma /プラズマ/
prat /プラット/
pratt /プラット/
pravda /プラウダ/
pray /プレイ/
prayer /プレイヤ;祈る人/プレア;祈り/
pre /プリ/プレ/
prealocate /プリアロケート/
preamble /プリアンブル/
preamp /プリアンプ/
precious /プレシャス/
precision /プレシジョン/
precut /プレカット/
predator /プレデター/
predicate /プレディケート/プレディケイト/述語/
predump /プリダンプ/
preemmptive /プリエンプティブ/
preemption /プリエンプション/
preemptive /プリエンプティブ/
preevent /プレイベント/
prefab /プレハブ/
preference /プリファレンス/プレファレンス/
prefetch /プリフェッチ/
prefix /プレフィックス/プリフィクス/プレフィクス/
preinstall /プリインストール/プレインストール/
preload /プリロード/プレロード/
prelocate /プリロケート/
prelude /プレリュード/
premainamp /プリメインアンプ;pre-main amp/
premier /プルミエ;(Fr)第一/プレミア/
premiere /プルミエール/プレミア/
premium /プレミアム/プレミア/
preopen /プレオープン/
prepaid /プリペイド/
prepaidcard /プリペイドカード/
preparat /プレパラート;(独語)/
preprint /プレプリント/
preprocessor /プリプロセッサ/
prerelease /プレリリース/
preseason /プレシーズン/
presen /プレゼン;presentation/
presence /プレゼンス/
present /プレゼント/
presentation /プレゼンテーション/プレゼンテイション/
presenter /プレゼンター/
presents /プレゼンツ/
preserve /プリザーブ/
preserved /プリザーブド/
preservedflower /プリザーブドフラワー/
preset /プリセット/
president /プレジデント/
presidential /プレジデンシャル/
presley /プレスリー/
press /プレス/
presser /プレッサー/
pressing /プレッシング/
pressrelease /プレスリリース/
pressroom /プレスルーム/
presssheet /プレスシート;和製英語/
pressure /プレッシャー/
prestige /プレステージ/プレスティッジ/
presto /プレスト/
preston /プレストン/
pretaporte /プレタポルテ;(Fr)pret-a-porter/
pretoria /プレトリア/
pretty /プリティ/プリティー/
prettyprint /プリティプリント/
pretzel /プレッツェル/
preussen /プロイセン/
prevert /プレヴェール/
preview /プレビュー/プレヴュー/
previewer /プレビュアー/プレビューア/プレヴュア/
previn /プレヴィン/
prevost /プレヴォー/プレヴォ/
pri /プリ/
price /プライス/
pricedown /プライスダウン/
priceless /プライスレス/
pricing /プライシング/
prick /プリック/
pride /プライド/
priest /プリースト/
prieto /プリエト/
prima /プリマ/
primadonna /プリマドンナ;prima donna/
primal /プライマル/
primary /プライマリ/プライマリー/
primavera /プリマベーラ;(It)春/プリマヴェーラ/
prime /プライム/
primer /プライマー/プリマー/
primera /プリメーラ/
primerate /プライムレート/
primetime /プライムタイム/
priming /プライミング/
primitive /プリミティブ/プリミティヴ/
primo /プリモ/
primrose /プリムローズ;桜草/
primula /プリムラ/
prince /プリンス/
princehotel /プリンスホテル/
princess /プリンセス/
princeton /プリンストン/
principal /プリンシパル/
principia /プリンキピア/
pringles /プリングルス/
print /プリント/
printable /プリンタブル/
printemps /プランタン;(Fr)春/
printer /プリンタ/プリンター/
printerbuffer /プリンタバッファ/
printercable /プリンタケーブル/
printerdriver /プリンタドライバ/
printerserver /プリンタサーバ/
printing /プリンティング/
printout /プリントアウト/
printserver /プリントサーバ/
printtshirt /プリントTシャツ/プリントＴシャツ/
printtshirts /プリントTシャツ/プリントＴシャツ/
prion /プリオン/
priori /プライオリ/
priority /プライオリティ/
priscilla /プリシラ/プリスキラ/
prism /プリズム/
prison /プリズン/
prisoner /プリズナー/
prius /プリウス;[商標]トヨタ/
privacy /プライバシー/プライヴァシー/
privacypolicy /プライバシーポリシー/
private /プライベート/
privateaddress /プライベートアドレス/
privatebrand /プライベートブランド/
privateip /プライベートIP/
privatelesson /プライベートレッスン/
prix /プリ;(Fr)賞/
prize /プライズ/
pro /プロ/
proama /プロアマ;proam/
probe /プローブ/
probing /プロービング/
problem /プロブレム/
proc /プロシジャ/
procaine /プロカイン/
procedural /プロシジュアル/プロシージャル/
procedure /プロシージャ/プロシジャ/手続き/
procedurecall /プロシジャ・コール/プロシジャコール/
proceeding /プロシーディング/プロスィーディング;<rare>/
proceedings /プロシーディングス/
process /プロセス/処理/
processcheese /プロセスチーズ/
processid /プロセスID/
processing /プロセッシング/
processor /プロセッサ/プロセッサー/
processorset /プロセッサセット/
procter /プロクター/
procyon /プロキオン/
produce /プロデュース/
producer /プロデューサー/
product /プロダクト/
production /プロダクション/
products /プロダクツ/
prof /プロフ;profile,professor/
profession /プロフェッション/
professional /プロフェッショナル/
professionalism /プロフェッショナリズム/
professor /プロフェッサー/
profile /プロフィール/プロファイル/
profiler /プロファイラ/
profiling /プロファイリング/
profit /プロフィット/利潤/
prog /プログラム/
progesteron /プロゲステロン/
progesterone /プロゲステロン/
progolf /プロゴルフ/
progolfer /プロゴルファー;pro golfer/
program /プログラム/算譜/
programable /プログラマブル/
programcounter /プログラムカウンタ;PC/
programer /プログラマ/プログラマー/
programers /プログラマーズ/
programfile /プログラムファイル/
programing /プログラミング/
programmability /プログラマビリティ/
programmable /プログラマブル/
programme /プログラム/
programmer /プログラマ/プログラマー/
programmers /プログラマーズ/
programming /プログラミング/
progre /プログレ;progressive (music|rock)/
progress /プログレス/進行/
progression /プログレッション/
progressive /プログレッシブ/プログレッシヴ/
progressiverock /プログレッシブロック/
project /プロジェクト/
projecter /プロジェクタ/
projection /プロジェクション/
projectleader /プロジェクトリーダー/
projectmanager /プロジェクトマネージャー/プロジェクトマネージャ/プロマネ/
projector /プロジェクター/プロジェクタ/
projectteam /プロジェクトチーム/
projet /プロジェ;仏語/
prokofiev /プロコフィエフ/
prolactin /プロラクチン/
proleague /プロリーグ;professional league/
proletariat /プロレタリア/プロレタリアート/
proline /プロリン;Pro/
prolog /プロログ/Ｐｒｏｌｏｇ/
prologue /プロローグ/
promenade /プロムナード/
prometheus /プロメテウス/
promethium /プロメチウム;[元素]61,Pm/
prominence /プロミネンス/
promiscuous /プロミスカス/
promo /プロモ;promotion/
promodel /プロモデル/
promote /プロモート/
promoter /プロモーター/
promotion /プロモーション/
promotionvideo /プロモーションビデオ/
prompt /プロンプト/
prompter /プロンプター/
pronto /プロント/
proof /プルーフ/証明/
prop /プロップ/
propaganda /プロパガンダ/
propagation /プロパゲーション/
propan /プロパン;(独語)/
propane /プロパン;C3H8/
propanegas /プロパンガス/
propanol /プロパノール/
propeller /プロペラ/
proper /プロパー/
property /プロパティ/プロパティー/
prophecy /プロフェシー/
prophet /プロフェット/
propion /プロピオン/
propolis /プロポリス/
proportion /プロポーション/∝/
proportional /プロポーショナル/∝/
proportionalfont /プロポーショナルフォント/
proposal /プロポーザル/
propose /プロポーズ/
proprietary /プロプライエタリ/
propto /∝/
propyl /プロピル;CH3CH2CH2-/
propylene /プロピレン/
proscenium /プロセニアム/
prosecco /プロセッコ/
proserpina /プロセルピナ/
proshop /プロショップ;pro shop/
prosper /プロスパー/
prost /プロスト/
prostaglandin /プロスタグランジン;PG/
protactinium /プロトアクチニウム;[元素]91,Pa/
protagoras /プロタゴラス/
protea /プロテア/
protease /プロテアーゼ/
protect /プロテクト/
protected /プロテクテッド/
protection /プロテクション/
protector /プロテクター/プロテクタ/
protein /プロテイン/タンパク質/
proteo /プロテオ/
proteoglycan /プロテオグリカン/
proteon /プロテオン/Ｐｒｏｔｅｏｎ/
protest /プロテスト/
protestant /プロテスタント/
protestantism /プロテスタンティズム/
proteus /プロテウス/
proto /プロト/
protocol /プロトコル/
protocolstack /プロトコルスタック/
proton /プロトン/
prototype /プロトタイプ/
prototyping /プロトタイピング/
proust /プルースト/
provence /プロヴァンス/プロバンス/
proves /├/┣/
provia /プロビア/
provider /プロバイダー/プロバイダ/
provitamin /プロビタミン/
provitamina /プロビタミンA;caroteneなど/
prowres /プロレス/
prowrestler /プロレスラー;professional wrestler/
prowrestling /プロレスリング;professional wrestling/
proxy /プロキシ/プロクシ/
proxyserver /プロキシサーバ/プロクシサーバ/
pruisen /プロイセン/
prussia /プロシア/
ps /ψ;psi/ＰＳ．/Ｐ．Ｓ．/ＰｏｓｔＳｃｒｉｐｔ/ポストスクリプト/PS./PostScript/プロセス/
ps/# /ＰＳ／#1/
psalm /サーム/
pseudo /シュード/
psi /ψ/プサイ/プシー/
psilocybin /シロシビン/サイロシビン/
psych /サイク/
psyche /プシュケ/プシュケー/プシケ/サイケ;<psychedelic/
psychedelic /サイケデリック/
psychic /サイキック/
psycho /サイコ/
psychodrama /サイコドラマ/
psychokinesis /サイコキネシス/
psychological /サイコロジカル/
psychology /サイコロジー/
psychopath /サイコパス/
psychotherapy /サイコセラピー/
psyllium /サイリウム;オオバコ/
psys /サイズ/PSY・S/
pt /白金/Platinum/
pteranodon /プテラノドン/
ptex /pTeX/
ptile /Pタイル;plastic tile/
ptolemaios /プトレマイオス/
ptr /ポインタ/
pu /プルトニウム/Plutonium/
pub /パブ/
public /パブリック/
publication /パブリケーション/パブリケイション/
publiccomment /パブリックコメント/
publicdomain /パブリックドメイン/
publicinvolvement /パブリックインボルブメント/
publicity /パブリシティ/公告/宣伝/
publicschool /パブリックスクール/
publicspace /パブリックスペース/
publish /パブリッシュ/
publisher /パブリッシャー/
publishing /パブリッシング/
pucci /プッチ/
puccini /プッチーニ/
puck /パック/
pudding /プリン/プディング/
pueraria /プエラリア/
puerta /プエルタ/
puerto /プエルト/
puertorico /プエルトリコ;.pr/
puff /パフ/
puffy /パフィー/パフィ/
pug /パグ/
puis /ピュイ;(Fr) それから/
puit /ピュイ;(Fr) 井戸/
puli /プーリー;犬/
pulitzer /ピュリッツァー/ピューリッツァー/
pull /プル/
pulldown /プルダウン/
pulldownmenu /プルダウンメニュー/
pulley /プーリー/プリー/
pulling /プリング/
pullover /プルオーバー/
pulltab /プルタブ/
pulltop /プルトップ/
pullup /プルアップ/
pulp /パルプ/
pulpfiction /パルプフィクション/
pulsar /パルサー/
pulse /パルス/
puma /ピューマ/
pump /ポンプ/
pumping /パンピング/
pumpkin /パンプキン/南瓜/
pumpkinpie /パンプキンパイ/
pumps /パンプス/
punc /パンク;puncture/
punch /パンチ/ポンチ;フルーツ-/
punchcard /パンチカード/
puncher /パンチャー/
punching /パンチング/
punchingball /パンチングボール/パンチボール/
punchout /パンチアウト/
punchperm /パンチパーマ;和製英語/
punchperma /パンチパーマ;和製英語/
puncture /パンク/
punjab /パンジャブ/
punk /パンク/
punkrock /パンクロック/
punt /パント/
pup /パップ/パプ/
puppet /パペット/
puppy /パピー/
purana /プラーナ/
purcell /パーセル/
pure /ピュア/
puree /ピューレ/ピュレ/
puremalt /ピュアモルト/
purewhite /ピュアホワイト/
purge /パージ/
purify /ピューリファイ/
purine /プリン/
purist /ピュアリスト/
puritan /ピューリタン/
purple /パープル/
purser /パーサ/パーサー/
push /プッシュ/
pushbutton /プッシュボタン/
pushing /プッシング/
pushkin /プーシキン/
pushphone /プッシュホン/
pushup /プッシュアップ/
pussy /プッシー/
put /プット/
putin /プーチン/
putt /パット/
putter /パター/
puttgolf /パットゴルフ/
putting /パッティング/
puyol /プジョール/
puzzle /パズル/
puzzlegame /パズルゲーム/
pygmalion /ピグマリオン/
pygmy /ピグミー/
pyjamas /パジャマ/
pylon /パイロン/
pylori /ピロリ/
pynchon /ピンチョン/
pyotr /ピョートル/
pyramid /ピラミッド/
pyramidal /ピラミダル/
pyran /ピラン/
pyrene /ピレン/
pyrenees /ピレネー/ピレネーズ;犬/
pyrethroid /ピレスロイド/
pyrex /パイレックス/
pyridine /ピリジン;C5H5N/
pyridinium /ピリジニウム/
pyridoxine /ピリドキシン/
pyrimidine /ピリミジン/
pyrine /ピリン/
pyrone /ピロン/
pyrrole /ピロール/
pyrrolin /ピロリン/
pyrroline /ピロリン/
pythagoras /ピタゴラス/
python /パイソン/
q /キュー/¶/
q&a /Ｑ＆Ａ/
qa /Ｑ＆Ａ/
qaddafi /カダフィ/
qanat /カナート/
qanun /カーヌーン/
qasba /カスバ/
qatar /カタール;.qa/
qazan /カザン/
qccircle /QCサークル;quality-control circle/
qibla /キブラ/
qic /QIC/
qomolangma /チョモランマ/珠穆朗瑪/
qrcode /QRコード;quick response code/
quadrille /カドリーユ/カドリール/
quaker /クエーカー/
qualia /クオリア/
qualify /クオリファイ/
qualite /カリテ;(Fr) 質/
quality /クオリティ/クオリティー/
quantas /カンタス/
quantifier /コンティファイア/
quantize /クォンタイズ/
quantum /カンタム;量子/
quark /クォーク/クオーク/
quarter /クォーター/クオーター/
quarterback /クォーターバック/
quartet /カルテット/
quartette /カルテット/
quartetto /カルテット/
quartier /カルティエ/カルチェ/カルチエ/
quartz /クオーツ/
quasar /クエーサー/
quate /クウェート;Kuwait?/
quatro /クアトロ/
quattro /クアトロ/
quaver /♪/
que /ク/ケ/
quebec /ケベック/
queen /クイーン/クィーン/
queens /クイーンズ/
queensize /クイーンサイズ/
queensland /クイーンズランド;豪州/
quel /ケル;仏語/
quena /ケーナ/
queneau /クノー/
quentin /クエンティン/クェンティン/カンタン/
query /クエリ/クエリー/問合せ/キュエリ;<rare>,原音からも遠い/
quesaisje /クセジュ;Que sais-je?/
queserasera /ケセラセラ;(西語)que sera sera/
quesnay /ケネー/
quest /クエスト/
questa /クエスタ/
question /クエスチョン/？/質問/
questionmark /クエスチョンマーク;？/
questo /クエスト/
quetzalcoatl /ケツァルコアトル/
queue /キュー/
queueing /キューイング/
quiche /キッシュ/
quick /クイック/クィック/
quickreference /クイックリファレンス/
quicksort /クイックソート/
quickstart /クイックスタート/
quicktime /クイックタイム/
quickturn /クイックターン;和製英語(flip turn)/
quijada /キハーダ/
quijote /キホーテ;Don Quijote/
quilt /キルト/
quilting /キルティング/
quin /クイン/
quincy /クインシー/
quine /クワイン/キーン/
quinn /クイン/
quinone /キノン/
quint /クイント/
quintet /クインテット/
quintetto /クインテット;(イタリア語)/
quinto /クイント/
quinton /クイントン/
quit /クイット/
quito /キト/
quixote /キホーテ;(英語綴) Don Quixote/
quiz /クイズ/
quo /クオ;ラテン語/
quocard /QUOカード;www.quocard.com/クオカード/
quolia /クオリア/
quot /クウォート/
quota /クォータ/クオータ/
quotation /クォーテーション/クオーテーション/
quote /クォート/クオート/クウォート/クォウト/“;opening/”;closing/‘;opening/’;closing/『』/
quran /クルアーン;Qur'an/コーラン/
r /ρ;rho/アール/р;er (cyrillic)/
r&b /リズム・アンド・ブルース/
r&d /Ｒ＆Ｄ/
ra /ラジウム/Radium/ラー/
rabat /ラバト/
rabaul /ラバウル/
rabbi /ラビ/
rabbit /ラビット/
rabelais /ラブレー/
rabi /ラビ/
raccoon /ラクーン;あらいぐま/
race /レース/
racecar /レースカー/
racequeen /レースクイーン;和製英語/レースクィーン/
racer /レーサー/
rachel /レイチェル/レーチェル/ラケル/
racine /ラシーヌ/
racing /レーシング/
racingcar /レーシングカー/
racingteam /レーシングチーム/
racism /レイシズム/
rack /ラック/
racket /ラケット/
rackmount /ラックマウント/
rackmounted /ラックマウント/
racoon /ラクーン;あらいぐま/
rada /ラーダ/レーダ/ラダ/
radar /レーダー/
radarsite /レーダーサイト/
radcliffe /ラドクリフ/
radetzky /ラデツキー/
radial /ラジアル/
radialtire /ラジアルタイヤ/
radian /ラジアン/
radiator /ラジエーター/ラジエータ/ラジエター/ラジエタ/
radical /ラジカル/ラディカル/
radicase /ラジカセ;radio-casette/
radicon /ラジコン;radio control/
radio /ラジオ/ラヂオ/レイディオ/
radio-casette /ラジカセ/
radiobotton /ラジオボタン/
radiobox /ラジオボックス/
radiobutton /ラジオボタン/
radiocasette /ラジオカセット/ラジカセ/
radiocm /ラジオCM/
radiodrama /ラジオドラマ/
radioname /ラジオネーム/
radiosity /ラジオシティ/
radish /ラディッシュ/
radium /ラジウム;[元素]88,Ra/
radon /ラドン;[元素]86,Rn/
raf /ラフ/
rafael /ラファエル/
rafe /レイフ/
raffaello /ラファエロ/
raffles /ラッフルズ/
rafflesia /ラフレシア/
raft /ラフト/
rafting /ラフティング/
raga /ラーガ/
ragdoll /ラグドール/
rage /レイジ/
raggae /レゲエ;※reggae?/
ragmat /ラグマット/
ragna /ラグナ/
ragnarok /ラグナロク;[北欧神話]神々の運命/
ragout /ラグー/
ragtime /ラグタイム/
rahmen /ラーメン;[建築]/
raid /レイド/
raiders /レイダース/
raikkonen /ライコネン/
rail /レール/レイル/
railgun /レールガン/
railroad /レイルロード/レールロード/
railway /レイルウェイ/レールウェイ/
raimonda /ライモンダ/
rain /レイン/
rainbow /レインボー/
rainbowbridge /レインボーブリッジ/
raincoat /レインコート/
rainer /ライナー/
rainey /レイニー/
rainier /レーニア/
rainmaker /レインメーカー/
raintire /レインタイヤ/
rainwear /レインウェア/
rainy /レイニー/
raise /レイズ/
raisin /レーズン/レザン;仏語/
raising /レイジング/
raison /レゾン;仏語/
raisondetre /レゾンデートル;(Fr) raison d'etre. 存在理由/レーゾンデートル/
raja /ラージャ/
rakel /ラケル/
rakhmaninov /ラフマニノフ/
rakko /ラッコ;(アイヌ語)/
ralf /ラルフ/
rally /ラリー/
ralph /ラルフ/
ralphlauren /ラルフローレン;Ralph Lauren/
ram /ラム/RAM/
rama /ラーマ/
ramadan /ラマダン/ラマダーン/
ramallah /ラマラ/
ramayana /ラーマーヤナ/
rambert /ランベール/
ramble /ランブル/
ramdisk /RAMディスク/
rameau /ラモー/
rami /ラミ/
ramirez /ラミレス/
ramjet /ラムジェット/
ramon /ラモン/
ramona /ラモーナ/
ramos /ラモス/
ramp /ランプ/
ramsay /ラムゼイ/ラムゼー/
ramses /ラムセス/
rana /ラナ/
randal /ランダル/
randall /ランダル/ランドール/
randolph /ランドルフ/
random /ランダム/
randomaccess /ランダムアクセス/
randomhouse /ランダムハウス;Random House/
randomize /ランダマイズ/
randomized /ランダマイズド/
randomjump /ランダムジャンプ/
randomwalk /ランダムウォーク/
randy /ランディ/ランディー/
range /レンジ/範囲/
rangehood /レンジフード;和製英語/
ranger /レンジャー/
rangers /レンジャーズ;[MLB]/
rangoon /ラングーン/
ranieri /ラニエリ/
rank /ランク/
rankdown /ランクダウン/
ranke /ランケ/
ranker /ランカー/
rankin /ランクイン;rank-in,和製英語/
ranking /ランキング/
rankup /ランクアップ/
ransel /ランドセル/
ranunculus /ラナンキュラス/
raoul /ラウール/ラウル/
rap /ラップ/
rape /レイプ/
raper /レイパー/
raphael /ラファエル/
rapid /ラピッド/
rapier /レイピア/
rapoport /ラパポート/
rapper /ラッパー/
rapport /ラポール;(Fr)関係/ラポート/
rapsodie /ラプソディ;仏語/ラプソディー/
rare /レア/
rarecase /レアケース/
rarecheese /レアチーズ;和製英語/
rarecheesecake /レアチーズケーキ;和製英語/
raregoods /レアグッズ/
rareitem /レアアイテム/
raremetal /レアメタル/
rascal /ラスカル/
rash /ラッシュ/
raskolnikov /ラスコーリニコフ/
raspberry /ラズベリー;キイチゴ/
rasputin /ラスプーチン/
rast /ラスト/
raster /ラスター/ラスタ/
rasterfile /ラスターファイル/
rat /ラット/
ratatouille /ラタトゥイユ/ラタトゥーユ/
ratchet /ラチェット/
rate /レート/
rather /ラザー/
rating /レーティング/
ratio /レシオ/
ration /レーション/
rattle /ラトル/
rau /ラウ/
raul /ラウル/
raum /ラウム;[商標]トヨタ/
rave /レイブ/レイヴ/
ravel /ラベル/ラヴェル/
raven /レイブン/レイヴン;Quoth the raven, 'Nevermore.'/
ravenna /ラヴェンナ/
ravioli /ラビオリ/
raw /ロー/
rawls /ロールズ/
ray /レイ/
rayban /レイバン;Ray-Ban. www.rayban.com/
rayleigh /レイリー/レーリー/
raymond /レイモンド/レーモン/レーモンド/レイモン/
raynaud /レイノー/
rayon /レーヨン/
raysol /レイソル;[Jリーグ]柏/
raytracing /レイトレーシング/
rb /ルビジウム/Rubidium/
rcs /RCS/
rdb /リレーショナルデータベース/関係データベース/
re /リ/レニウム/Rhenium/レ/
reach /リーチ/
reachable /リーチャブル/
reacitivate /リアクティベート/
reactance /リアクタンス/
reaction /リアクション/
reactivation /リアクティベーション/
reactive /リアクティブ/
reactor /リアクター/
read /リード/レッド;p,pp/
readable /リーダブル/
reader /リーダー/リーダ/
readers /リーダーズ/
readiness /レディネス/
reading /リーディング/
readings /リーディングス/
readme /README/
readonly /リードオンリー/
ready /レディ/
readymade /レディメイド/
reagan /レーガン/
real /リアル/レアル/
realism /リアリズム/
realisme /レアリスム/
realist /リアリスト/
realiste /レアリスト/
realistic /リアリスティック/
reality /リアリティ/リアリティー/
reallife /リアルライフ/
really /リアリー/
realmode /リアルモード/
realmoney /リアルマネー/
realplayer /リアルプレイヤー;www.real.com/リアルプレーヤー/
realtime /リアルタイム/
realtimesystem /リアルタイムシステム/
realworld /リアルワールド/
ream /リーム/
reamer /リーマー/
rear /リア/リヤ/
rearcar /リヤカー/
rearglass /リアガラス/
rearseat /リアシート/
rearwindow /リアウィンドウ/
reason /リーズン/
reasonable /リーズナブル/
reasoning /リーズニング/
reassemble /リアセンブル/
rebate /リベート/
rebecca /レベッカ/リベカ/
rebirth /リバース/
reboot /リブート/
rebound /リバウンド/
rebuild /リビルド/
recall /リコール/
receipt /レシート/
receive /レシーブ/
receiver /レシーバー/レシーバ/リシーバ;<rare>/
reception /レセプション/
receptor /レセプター/レセプタ/
recession /リセッション/
recette /ルセット;(Fr) レシピ/
recharge /リチャージ/
recipe /レシピ/
recipient /レシピエント;⇔donor/
recit /レシ;仏語/
recital /リサイタル/
recitativo /レチタティーヴォ/
reclam /レクラム/
reclining /リクライニング/
recliningchair /リクライニングチェア/
recliningseat /リクライニングシート/
recognition /リコグニション/認識/
recoil /リコイル/
recommen /レコメン;recommend(ed)/
recommend /リコメンド/
recompile /リコンパイル/
reconfirm /リコンファーム/
reconquista /レコンキスタ/
record /レコード/
recorder /レコーダー/レコーダ/リコーダー/
recording /レコーディング/
recordplayer /レコードプレーヤー/
records /レコーズ/
recordshop /レコードショップ/
recordya /レコード屋/
recoreco /レコレコ/
recover /リカバー/
recovery /リカバリー/リカバリ/レカバリ;<rare>/
recoverycd /リカバリCD/リカバリーCD/
recoverydisk /リカバリディスク/リカバリーディスク/
recreation /レクリエーション/
recruit /リクルート/
recruiter /リクルーター/
recruitment /リクルートメント/
rector /レクター/
recursion /リカージョン/
recursive /リカーシブ/再帰的/
recycle /リサイクル/
recycleshop /リサイクルショップ/
red /レッド/
redbull /レッドブル/
redcard /レッドカード/
redd /レッド/
redeye /レッドアイ/
redford /レッドフォード/
redhat /レッドハット/
redial /リダイアル/
redirect /リダイレクト/
redirection /リダイレクション/
redisplay /リディスプレイ/
redmond /レドモンド/
redo /リドゥ/
redon /ルドン/
redondo /レドンド/
redouble /リダブル/
redpepper /レッドペッパー/
redpurge /レッドパージ;red purge, 赤狩り/
redribbon /レッドリボン/
reds /レッズ/
redsox /レッドソックス;[MLB]Red Sox/
reduce /リデュース/
reducer /レデューサー/レデューサ/
reduction /リダクション/
redundant /リダンダント/
redzeppelin /レッドツェッペリン/
redzone /レッドゾーン/
reed /リード/
reef /リーフ/
reel /リール/
reengineering /リエンジニアリング/
reentrant /リエントラント/
reese /リーズ/
reeves /リーブス/リーヴス/リーブズ/
ref /レフ;reflex/
refactoring /リファクタリング/
refer /リファー/
referee /レフェリー/
refereestop /レフェリーストップ/
reference /リファレンス/レファレンス/参考文献/参照型/
referencer /リファレンサ/
referer /リファラ/リファラー/
refile /リファイル/リフィル;refill?/
refill /リフィル/
refinance /リファイナンス/
refine /リファイン/
reflation /リフレーション/
reflection /リフレクション/
reflective /リフレクティブ/
reflector /リフレクター/反射鏡/
reflex /リフレックス/レフレックス/
reflexion /リフレクション;=reflection/
reform /リフォーム/
refrain /リフレイン/ルフラン;仏語/
refresh /リフレッシュ/リフレシュ/
refreshrate /リフレッシュレート/
refund /リファンド/
refuse /リフューズ/拒否/
reg /レッグ/
regain /リゲイン/
regan /リーガン/
regatta /レガッタ/
regent /リーゼント/
regexp /正規表現/
reggae /レゲエ/
reggiano /レッジャーノ/
reggie /レジー/
reggio /レッジョ/
regi /レジ;<register/
regime /レジーム/
regina /レジーナ/レジナ/
reginald /レジナルド/
region /リージョン/
regional /リージョナル/
regionalism /リージョナリズム/
regioncode /リージョンコード/
regionfree /リージョンフリー/
regis /レジス/
regist /レジスト/
register /レジスタ/レジスター/レジ/
registrar /レジストラ/
registration /レジストレーション/
registry /レジストリ/レジストリー/
regnier /レニエ/
regression /リグレッション/
regret /リグレット/
regular /レギュラー/
regularcoffee /レギュラーコーヒー/
regulargasoline /レギュラーガソリン/
regularmember /レギュラーメンバー/
regularseason /レギュラーシーズン/
regularsize /レギュラーサイズ/
regulation /レギュレーション/
regulator /レギュレータ/レギュレーター/
rehabili /リハビリ;<rehabilitation/
rehabilitation /リハビリテーション/リハビリ/機能回復訓練/
reharsal /リハーサル;※rehearsal/
rehearsal /リハーサル/
reich /ライヒ/
reign /レイン/
reilly /ライリー/
reims /ランス/
reina /レイナ/
reincarnation /リインカーネーション/
reine /レーヌ;(Fr)王妃/
reiner /ライナー/
reinhard /ラインハルト/
reinhardt /ラインハルト/ラインハート/
reinhold /ラインホルト/
reino /レイノ/
reinstall /リインストール/
reis /ライス/レー/
reischauer /ライシャワー/
reissue /リイシュー/
reject /リジェクト/
relation /リレーション/
relational /リレーショナル/
relationaldatabase /リレーショナルデータベース/
relationaldb /リレーショナルデータベース/
relations /リレーションズ/
relationship /リレーションシップ/
relative /リラティブ/レラティブ/
relax /リラックス/
relaxation /リラクゼーション/
relaxing /リラクシング/
relay /リレー/
release /リリース/
relief /レリーフ;浮き彫り/リリーフ;救済/
religion /レリジョン/
reload /リロード/
relocatable /リロケータブル/
relocate /リロケート/
relocation /リロケーション/
rem /レム/
remain /リメイン/
remake /リメイク/リメーク/
remark /リマーク/
remaster /リマスター/
remastering /リマスタリング/
rembrandt /レンブラント/
remedy /レメディ/レメディー/
remember /リメンバー/
remi /レミ/
remind /リマインド/
reminder /リマインダー/リマインダ/
remix /リミックス/
remocon /リモコン/
remodel /リモデル/
remodeling /リモデリング/
remon /レモン/
remote /リモート/
remoteaccess /リモートアクセス/
remotehost /リモートホスト/
removable /リムーバブル/
remove /リムーブ/
remover /リムーバー/リムーバ/
remus /レムス/
remy /レミー/レミ/
ren /レン/
rena /レナ/リナ/
renaissance /ルネッサンス/ルネサンス/
rename /リネーム/
renard /ルナール/
renat /レナート/
renata /レナータ/
renate /レナーテ/
renato /レナート/
renaud /ルノー/
renault /ルノー/
render /レンダー/レンダ/
renderer /レンダラー/レンダラ/
rendering /レンダリング/
rendez-vous /ランデヴー/
rendezvous /ランデブー;(Fr)Rendez-vous/ランデヴー/
rendition /レンディション/
rene /ルネ/レネ/
renee /レニー/ルネ/レネ/
renew /リニュー/
renewal /リニューアル/
renewalopen /リニューアルオープン;和製英語/
renie /ルニエ/
renn /レン/
rennes /レンヌ/
rennie /レニー/
renny /レニー/
reno /Ｒｅｎｏ/
renoir /ルノワール/ルノアール/
renovation /リノベーション/
renown /レナウン/
rent /レント/
renta /レンタ/
rentacar /レンタカー;rent-a-car/
rentacycle /レンタサイクル;和製英語/
rental /レンタル/
rentalbbs /レンタルBBS/
rentalcd /レンタルCD/
rentalcgi /レンタルCGI/
rentalchat /レンタルチャット/
rentaldvd /レンタルDVD/
rentalease /レンタリース;和製英語(rental + lease)/
rentalserver /レンタルサーバ/レンタルサーバー/
rentalservice /レンタルサービス/
rentalshop /レンタルショップ/
rentalspace /レンタルスペース/
rentalstudio /レンタルスタジオ/
rentalvideo /レンタルビデオ/
renton /レントン/
renumber /リナンバー/レナンバ;<rare>/
repair /リペア/リペアー/
repeat /リピート/々/
repeater /リピーター/リピータ/
repertory /レパートリー/
replace /リプレース/
replacement /リプレースメント/
replay /リプレイ/
replica /レプリカ/
replication /レプリケーション/
replique /レプリーク/
reply /リプライ/返事/返信/
repo /ルポ;reportage/レポ;report/
report /レポート/リポート/
reportage /ルポルタージュ/
reporter /レポーター/リポーター/
reporting /レポーティング/
repository /リポジトリ/レポジトリ/
repost /リポスト/
repowriter /ルポライター;和製英語(reporter)/
reprint /リプリント/
reprise /リプリーズ/
republic /リパブリック/
request /リクエスト/要求/
requiem /レクイエム/
rerun /リラン/
res /レス;response/
rescan /リスキャン/
rescue /レスキュー/
research /リサーチ/
researcher /リサーチャー/
reserpine /レセルピン/
reserva /レゼルヴァ;(西語)/レゼルバ/
reservation /リザベーション/
reserve /リザーブ/レゼルブ;仏語/レザーブ/
reserved /リザーブド/
reserver /リザーバー/リザーバ/
reset /リセット/
resetbutton /リセットボタン/
resetswitch /リセットスイッチ/
residence /レジデンス/
residencial /レジデンシャル/
resident /レジデント/
resign /リザイン/
resin /レジン/
resist /レジスト/
resistance /レジスタンス/
resize /リサイズ/
reslie /レスリー/
resnais /レネ/
resolution /レゾリューション/リゾリューション/
resolve /リゾルブ/
resolver /リゾルバ/レゾルバ/
resonance /レゾナンス/
resonant /レゾナント/
resort /リゾート/
resorthotel /リゾートホテル/
resortmansion /リゾートマンション/
resource /リソース/
resourcefile /リソースファイル/
resourcemanager /リソースマネージャ/
respect /リスペクト/
respighi /レスピーギ/
responce /レスポンス;※response/
response /レスポンス/リスポンス/
ressentiment /ルサンチマン/
rest /レスト/
restart /リスタート/
restaurant /レストラン/
resthouse /レストハウス/
restore /リストア/
restroom /レストルーム/
result /リザルト/
resume /レジュメ;要約/レジューム;再開/リジューム/
retail /リテール/リテイル/
retainer /リテイナー/
retake /リテイク/
reti /レティ/
retinoid /レチノイド/
retinol /レチノール/
retire /リタイア/リタイヤ/
retirement /リタイアメント/
retort /レトルト/
retortcurry /レトルトカレー/
retortpouch /レトルトパウチ/
retouch /レタッチ/
retract /リトラクト/レトラクト/
retreat /リトリート/
retrieval /リトリーバル/検索/
retrieve /リトリーブ/
retriever /レトリバー/レトリーバー/リトリバー/リトリーバー/
retro /レトロ/
retrogame /レトロゲーム/
retrovirus /レトロウイルス/
retry /リトライ/
return /リターン/復帰/
returnable /リターナブル/
returnkey /リターンキー/RETURNキー/
returnmatch /リターンマッチ/
returns /リターンズ/
retyi /レティ/
reuben /ルーベン/
reunion /レユニオン;.re/
reusable /リユーザブル/
reuse /リユース/
reuter /ロイター/
reuters /ロイター;www.reuters.com/
reve /レーブ;(Fr)夢/レーヴ/
revenge /リベンジ/
revenger /リベンジャー/
reversal /リバーサル/
reversalfilm /リバーサルフィルム/
reverse /リバース/
reverseengineering /リバースエンジニアリング/
reversible /リバーシブル/
reves /リーブス/リーヴス/リーブズ/
review /レビュー/レヴュー/リビュー/リヴュー/
reviewer /レビュアー/レビューアー/レビューア/
revise /リバイズ/リヴァイズ/
revision /リビジョン/
revival /リバイバル/リヴァイヴァル/
revo /リボ;revolving/
revolution /レボリューション/
revolver /リボルバー/
revolving /リボルビング/
reward /リワード/
rewrite /リライト/
rex /レックス;王/
rey /レイ/
reyes /レジェス/
reykjavik /レイキャヴィク/レイキャビク;アイスランド(rek)/
reynard /レイナード/
reynaud /レイノー/
reynold /レイノルド/
reynolds /レイノルズ/
rezept /レセプト;(独)/
rf /ラザホージウム/Rutherfordium/
rh /ロジウム/Rhodium/
rhapsody /ラプソディ/ラプソディー/
rhea /レア/
rhein /ライン/レイン/
rheingau /ラインガウ/
rheinhessen /ラインヘッセン/
rheinland /ラインラント/
rhenium /レニウム;[元素]75,Re/
rheology /レオロジー/
rhetoric /レトリック/
rheumati /リウマチ;rheumatism/リューマチ/
rheumatisch /リウマチ;(蘭語)/リューマチ/
rheumatism /リウマチ/リューマチ/
rhinestone /ラインストーン/
rhizome /リゾーム/
rho /ρ/ロー/
rhoda /ローダ/
rhodan /ローダン/ロダン/
rhode /ロード/
rhodeisland /ロードアイランド;RI/
rhodes /ロウズ/ローズ/
rhodesia /ローデシア/
rhodium /ロジウム;[元素]45,Rh/
rhodopsin /ロドプシン/
rhodos /ロードス/ロドス/
rhone /ローヌ/
rhubarb /ルバーブ/
rhumba /ルンバ/
rhyme /ライム/
rhys /リス/
rhythm /リズム/
rhythmbox /リズムボックス/
rhythmic /リズミック/
rhythmical /リズミカル/
rhythmpattern /リズムパターン/
rhythmsection /リズムセクション/
rhythmtrack /リズムトラック/
ri /Rhode Island/ロードアイランド/
ria /リア/
rian /ライアン/
rias /リアス/
rib /リブ/
ribbon /リボン/
ribera /リベラ/
ribo /リボ;ribonucleic/
riboflavin /リボフラビン;V.B2/
ribose /リボース/
ribosome /リボソーム/
ribozyme /リボザイム/
ribroast /リブロース/
ribsteak /リブステーキ/
rica /リカ/
ricard /リカール/
ricardo /リカード/リカルド/
riccardo /リカルド/リッカルド/
ricci /リッチ/
rice /ライス/
ricecurry /ライスカレー/
ricepaper /ライスペーパー/
ricercare /リチェルカーレ/
rich /リッチ/リッシュ/リッヒ/
richard /リチャード/リヒャルト/リシャール/リカルド/
richards /リチャーズ/
richardson /リチャードソン/
riche /リシェ/
richelieu /リシュリュー/
richie /リッチー/リチー/
richman /リッチマン/
richmedia /リッチメディア/
richmond /リッチモンド/
richter /リヒター/リクター/リヒテル/
richtext /リッチテキスト/
ricin /リシン/
rick /リック/
ricken /リッケン/
rickettsia /リケッチア/
rickey /リッキー/
ricky /リッキー/
ricoeur /リクール/
ricoh /リコー;www.ricoh.co.jp/
ricotta /リコッタ/
riddell /リデル/
riddle /リドル/
ride /ライド/
rideau /リドー/
ridecymbal /ライドシンバル/
rider /ライダー/
riders /ライダーズ/ライダース/
ridge /リッジ/
ridgeway /リッジウェイ/
ridgway /リッジウェイ/
riding /ライディング/
riec /東北大学電気通信研究所;www.riec.tohoku.ac.jp/電気通信研究所/東北大通研/
riedel /リーデル/
riemann /リーマン/
rien /リアン/リエン/
riesling /リースリング/
riesman /リースマン/
riff /リフ;refrain/
rifle /ライフル/
riga /リガ/
rigatoni /リガトーニ/
right /ライト/→/右/
rightarrow /→/
rightfly /ライトフライ/
righthand /ライトハンド/
rightover /ライトオーバー;和製英語/
rights /ライツ/
rigid /リジッド/
rigoletto /リゴレット/
rihanna /リアーナ/
rika /リカ/
rikki /リッキー/
riku /リク/
rilke /リルケ/
rim /リム/
rimbaud /ランボー/
rime /ライム/
rimnet /リムネット;www.rim.or.jp/
rims /数理解析研究所;www.kurims.kyoto-u.ac.jp/京都大学数理解析研究所/
rimshot /リムショット/
rimskii /リムスキー/
rina /リーナ/リナ/
ring /リング/
ringer /リンガー/リンゲル/
ringing /リンギング/
ringo /リンゴ/
ringout /リングアウト/
rings /リングス/
ringside /リングサイド/
rink /リンク;{7,900,000}/
rinne /リンネ/
rinse /リンス/
rio /リオ/
riodejaneiro /リオデジャネイロ;Rio de Janeiro/
riogrande /リオグランデ;Rio Grande/
rioja /リオハ;スペイン/
rion /リオン/
riot /ライオット/
rip /リップ/
ripper /リッパー/
ripping /リッピング/
ripple /リップル/リプル/
risc /リスク/RISC/
rise /ライズ/
riser /ライザー/ライザ/
risercard /ライザーカード/ライザカード/
rising /ライジング/
risingsun /ライジングサン;Rising Sun(=Japan)/
risk /リスク/
riskfactor /リスクファクター/
riskhedge /リスクヘッジ/
riskmanagement /リスクマネージメント/
risky /リスキー/
risotto /リゾット/
risperidone /リスペリドン/
risto /リスト/
ristorante /リストランテ;(イタリア語)/
rit /リット/
rita /リタ/リータ/
ritardando /リタルダンド/
ritchie /リッチー/リチー/
ritenour /リトナー/
ritt /リット/
ritz /リッツ/
riva /リーバ/
rival /ライバル/ライヴァル/
rivas /リバス/
rive /リヴ/リブ/
river /リバー/リヴァー/
rivera /リベラ/リヴェラ/
riverfront /リバーフロント/
rivers /リバーズ/
riverside /リバーサイド/リヴァーサイド/
rivet /リベット/
riviera /リビエラ;イタリア/リヴィエラ/
riviere /リビエール/リヴィエール/
riyadh /リヤド/
riz /リズ/
rizotto /リゾット;※risotto/
rlogin /リモートログイン/
rms /Richard M. Stallman/リチャード・Ｍ・ストールマン/
rn /ラドン/Radon/
ro-maji /ローマ字/
roach /ローチ/
road /ロード/
roadbike /ロードバイク/
roadgame /ロードゲーム/
roadmap /ロードマップ/
roadmovie /ロードムービー/
roadpricing /ロードプライシング/
roadrace /ロードレース/
roadracer /ロードレーサー/
roadshow /ロードショー/ロードショウ/
roadster /ロードスター/
roadwork /ロードワーク/
roam /ローム/
roaming /ローミング/
roar /ロアー/ロア/
roast /ロースト/
roastbeef /ローストビーフ/
roastchicken /ローストチキン/
roaster /ロースター/
roastpork /ローストポーク/
rob /ロブ/
robber /ロバー/
robbie /ロビー/
robbins /ロビンス/
robby /ロビー/
robe /ローブ/
robert /ロバート/ロベルト/ロベール/
roberta /ロベルタ/ロバータ/
roberto /ロベルト/
roberts /ロバーツ/
robertson /ロバートソン/
robespierre /ロベスピエール/
robin /ロビン/ロバン/
robinhood /ロビンフッド;Robin Hood/
robinson /ロビンソン/
robo /ロボ/
robocup /ロボカップ;www.robocup.or.jp/
robot /ロボット/
robotanime /ロボットアニメ/
robotarm /ロボットアーム/
robotics /ロボティックス/ロボティクス/
robson /ロブソン/
robust /ロバスト/
roby /ロビー/
robyn /ロビン/
rocca /ロッカ/
roche /ロッシュ/
rochefort /ロシュフォール/
rochelle /ロシェル/
roches /ロッシュ/
rochester /ロチェスター/
rock /ロック/
rock'n /ロックン/
rockabilly /ロカビリー/
rockband /ロックバンド/
rockclimbing /ロッククライミング/
rockcrystal /ロッククリスタル/
rockefeller /ロックフェラー/
rocker /ロッカー/
rocket /ロケット/
rocketengine /ロケットエンジン/
rocketlauncher /ロケットランチャー/
rockets /ロケッツ/
rockfill /ロックフィル/
rockguitar /ロックギター/
rockice /ロックアイス/
rockies /ロッキーズ;[MLB]/
rocking /ロッキング/
rockingchair /ロッキングチェア/
rocknroll /ロックンロール;rock'n'roll/
rockridge /ロックリッジ/
rocks /ロックス/
rockwell /ロックウェル/
rockwool /ロックウール/
rocky /ロッキー/
rococo /ロココ/
rod /ロッド/
roddy /ロディ/
rode /ローデ/
roden /ローデン/
rodeo /ロデオ/
roderick /ロデリック/
rodger /ロジャー/
rodgers /ロジャース/ロジャーズ/
rodin /ロダン/
rodney /ロドニー/
rodolfo /ロドルフォ/
rodrigo /ロドリゴ/ロドリーゴ/
rodriguez /ロドリゲス/
roentgen /レントゲン/
roger /ロジャー/ロジェ;仏語/ラジャー;了解!/
rogers /ロジャース/ロジャーズ/
roget /ロジェ/
rogue /ローグ;@/
rohan /ローハン/ロアン/ロハン/
rohmer /ロメール/
rojas /ロハス/
rojo /ロホ/
roland /ローランド/ロラン/ローラン/
role /ロール/
roleplay /ロールプレイ/
roleplaying /ロールプレイング/
roleplayinggame /ロールプレイングゲーム/
rolex /ロレックス;www.rolex.com/
rolf /ロルフ/
roll /ロール/
rollback /ロールバック/
rollcabbage /ロールキャベツ;rolled cabbage/
rollcake /ロールケーキ;rolled cake/
roller /ローラー/
rollerball /ローラーボール/
rollerblade /ローラーブレード;[商標] NB:言い換え語"inline skate"/
rollercoaster /ローラーコースター/
rollerskate /ローラースケート/
rollin /ローリン/
rolling /ローリング/
rollingstones /ローリングストーンズ/
rollins /ロリンズ/
rollo /ロロ/
rollover /ロールオーバー/
rollpain /ロールパン/
rollpaper /ロールペーパー/
rollscreen /ロールスクリーン/
rollsroyce /ロールスロイス;Rolls-Royce/
rollup /ロールアップ/
rolly /ローリー/
rom /ロム/ROM/
roma /ローマ/羅馬/ロマ;=Gypsy/
romaclub /ローマクラブ;Club of Rome. www.clubofrome.org/
romain /ロマン/
romaji /ローマ字/
roman /ロマン/ローマン/ローマ字/
romana /ロマーナ/
romance /ロマンス/
romancecar /ロマンスカー/
romancegray /ロマンスグレー/
romancegrey /ロマンスグレー/
romancing /ロマンシング/
romancingstone /ロマンシングストーン/
romane /ロマーヌ/
romanesque /ロマネスク/
romania /ルーマニア;.ro/
romano /ロマノ/ロマーノ/
romanov /ロマノフ/
romantic /ロマンチック/ロマンティック/
romanticism /ロマンティシズム/ロマンチシズム/
romantist /ロマンチスト/ロマンティスト/
rome /ローマ/
romeo /ロミオ/
romero /ロメロ/
rommel /ロンメル/
romper /ロンパー/
rompers /ロンパース/
romulus /ロムルス/
romy /ロミー/
ron /ロン/
ronald /ロナルド/ロナウド/
ronde /ロンド/輪舞/
rondeau /ロンドー/
rondo /ロンド/
ronnie /ロニー/
ronny /ロニー/
ronsard /ロンサール/
rontgen /レントゲン/
roof /ルーフ/
roofgarden /ルーフガーデン/
roofrack /ルーフラック/
rooftop /ルーフトップ/
rook /ルーク/
rookie /ルーキー/
rooky /ルーキー/
room /ルーム/
roomcharge /ルームチャージ/
rooming /ルーミング/
roomlamp /ルームランプ/
roomlight /ルームライト/
roommate /ルームメイト/ルームメート/
roomnumber /ルームナンバー/
roomservice /ルームサービス/
roomshare /ルームシェア/
roop /ループ/
roosevelt /ルーズベルト/ルーズヴェルト/
root /ルート/√/根/
rootbeer /ルートビア/
rootdirectory /ルートディレクトリ/
roots /ルーツ/
rope /ロープ/
roper /ローパー/
ropeway /ロープウェイ/ロープウェー/
ropework /ロープワーク/
roquefort /ロックフォール/
roquentin /ロカンタン/
roro /ロロ/
rorschach /ロールシャッハ/
rorschachtest /ロールシャッハテスト/
rory /ローリー/
ros /ロス/
rosa /ローザ/ロサ/
rosado /ロサード/
rosalia /ロザリア/
rosalie /ロザリー/
rosalind /ロザリンド/
rosamunde /ロザムンデ/
rosanna /ロザンナ/
rosanne /ロザン/ロザンヌ/
rosario /ロザリオ/
rosch /ロッシュ/
rose /ローズ/ロゼ;仏語/ローゼ/
roseau /ロゾー/
rosegarden /ローズガーデン/
rosehip /ローズヒップ/
rosemary /ローズマリー/
rosenthal /ローゼンタール/
rosepink /ローズピンク/
rosered /ローズレッド/
rosetta /ロゼッタ/
rosette /ロゼット/ローゼット/
rosewine /ロゼワイン/
rosewood /ローズウッド/
rosie /ロージー/
rosin /ロジン/ロージン/
rosinante /ロシナンテ/
rosinbag /ロージンバッグ/ロジンバッグ/
ross /ロス/
rossby /ロスビー/
rossbywave /ロスビー波/
rossellini /ロッセリーニ/
rosser /ロッサー/
rossi /ロッシ/
rossignol /ロシニョール/
rossini /ロッシーニ/
rossiya /ロシア;Росий/
rosso /ロッソ/
rostand /ロスタン/
rostow /ロストウ/
rostropovich /ロストロポーヴィチ/ロストロポーヴィッチ/
rosy /ロージー/
rot /ロット/
rota /ロータ/
rotary /ロータリー/
rotaryclub /ロータリークラブ/
rotaryengine /ロータリーエンジン/
rotate /ローテート/
rotation /ローテーション/
rothenburg /ローテンブルク;Rothenburg ob der Tauber/
rothman /ロスマン/
rothmans /ロスマンズ/
rothschild /ロートシルト/
roti /ロティ/ロティー/
rotondo /ロトンド/
rotor /ローター/ロータ/
rotring /ロットリング;www.rotring.de/
rotta /ロッタ/
rotterdam /ロッテルダム/
roty /ロティ/
rouault /ルオー/
rouble /ルーブル;(貨幣単位)/
rouen /ルーアン/
rouge /ルージュ/
rough /ラフ/
roughplay /ラフプレー/ラフプレイ/
roughsketch /ラフスケッチ/
roulette /ルーレット/
round /ラウンド/
roundrobin /ラウンドロビン/
roundtrip /ラウンドトリップ/
roundup /ラウンドアップ/
rousseau /ルソー/
roussel /ルーセル/
route /ルート/
routemap /ルートマップ/
router /ルータ/ルーター/
routerid /ルータID/
routes /ルーツ/
routesales /ルートセールス/
routine /ルーチン/ルーティン/
routinework /ルーチンワーク/
routing /ルーティング/
routingtable /ルーティングテーブル/
roux /ルー/
rover /ローバー/
row /ロウ/
rowing /ローイング/
rowland /ローランド/
rox /ロックス/
roxy /ロキシー/
roy /ロイ/
royal /ロイヤル/ローヤル/ロワイヤル/ロワイアル/
royalalbert /ロイヤルアルバート/
royalcopenhagen /ロイヤルコペンハーゲン/
royalhotel /ロイヤルホテル/
royaljelly /ローヤルゼリー/ロイヤルゼリー/
royalpark /ロイヤルパーク/
royals /ロイヤルズ;[MLB]/
royalty /ロイヤリティー/ロイヤリティ/ロイヤルティ/ロイヤルティー/ローヤリティ/
roza /ローザ/
rs232c /ＲＳ−２３２Ｃ/
rssreader /RSSリーダー/RSSリーダ/
ru /ルテニウム/Ruthenium/
rubaiyat /ルバイヤート/
rubalkhali /ルブアルハリ;Rub Al Khali/
rubato /ルバート/
rubber /ラバー/
rubbersole /ラバーソール/
rubbersoul /ラバーソウル;Beatles/
rubble /ラブル/
ruben /ルーベン/
rubens /ルーベンス/
rubicon /ルビコン/
rubidium /ルビジウム;[元素]37,Rb/
rubik /ルービック/
rubikcube /ルービックキューブ;Rubik cube/
rubinstein /ルビンスタイン/ルビンシュタイン/ルービンシュタイン/
rubio /ルビオ/
ruby /ルビー/ルビ/紅玉/
rubyscript /rubyスクリプト/Rubyスクリプト/
ruck /ラック/リュック/
rucker /ラッカー/
rucksack /リュックサック/
rucola /ルッコラ/
rudbeckia /ルドベキア/
rudder /ラダー;舵/
rude /ルード/
rudi /ルーディ/ルディ/
rudiment /ルーディメント/
rudiments /ルーディメンツ/
rudolf /ルドルフ/
rudolph /ルドルフ/
rudy /ルディ/ルーディ/
rue /ルー/
ruff /ラフ/
rufino /ルフィーノ/
rufus /ルーファス/ルフス/
rug /ラグ/
rugby /ラグビー/
rugbyball /ラグビーボール/
rugger /ラガー/
ruggero /ルッジェーロ/
ruggiero /ルッジェーロ/
ruhr /ルール/
ruhuna /ルフナ;紅茶/
ruin /ルイン/ルーイン/
ruiz /ルイス/
rule /ルール/規則/
rulebook /ルールブック/
ruled /ルールド/
ruler /ルーラ/ルーラー/
ruleset /ルールセット/
rum /ラム/
rumania /ルーマニア/
rumba /ルンバ/
rumble /ランブル/Ｒｕｍｂｌｅ/
rumcoke /ラムコーク/
rummy /ラミー/
rumor /ルーマー/
rumour /ルーマー/
rump /ランプ/
rumraisIn /ラムレーズン/
run /ラン/
rundown /ランダウン/
rune /ルーン/
runlength /ランレングス/
runner /ランナー/
runners /ランナーズ/
runnershigh /ランナーズハイ;runner's high/
running /ランニング/
runningcost /ランニングコスト/
runninghigh /ランニングハイ/
runninghomerun /ランニングホームラン/
runningshirt /ランニングシャツ/
runningshirts /ランニングシャツ/
runtime /ランタイム/
rupee /ルピー/
rupert /ルパート/
rupiah /ルピア/
rural /ルーラル/
rush /ラッシュ/
rusher /ラッシャー/
rushhour /ラッシュアワー/
rusk /ラスク/
ruslan /ルスラン/
russ /ラス/ルス/
russe /リュス/ルッセ/リュッス/
russel /ラッセル/
russell /ラッセル/
russia /ロシア;.ru/露西亜/魯西亜/а;→cyrillic/б/в/г/д/е/ё/ж/з/и/к/й/м/н/л/п/с/о/р/т/у/ш/ф/х/ч/ц/ь/щ/я/ъ/ы/э/ю/
russian /ロシアン/ルシアン/ロシア語/
russianblue /ロシアンブルー/
russianroulette /ロシアンルーレット/
rust /ラスト/
rusticana /ルスティカーナ/
rusty /ラスティ/
rute /ルーテ/
ruth /ルツ/ルース/ルート/ルス/
ruthenium /ルチニウム;[元素]44,Ru/
rutherford /ラザフォード/
rutherfordium /ラザホージウム;[元素]104,Rf/
rutile /ルチル/
rutin /ルチン/
ruwer /ルワー/ルーヴァー/
rwanda /ルワンダ;.rw/
ryan /ライアン/
rye /ライ/
rythmique /リトミック;仏語/
s /σ;sigma/エス/с;es (cyrillic)/硫黄/Sulfur/秒/
s# /昭和#0年/
saab /サーブ/
saal /ザール;(独語)ホール/
saar /ザール/
saara /サーラ/
saarland /ザールラント/
sabado /サバト;(ポルトガル語)/
sabao /シャボン;(ポルトガル語)/
sabatini /サバティーニ/
sabbat /サバト;(蘭語)/
sabbath /サバス/サバト;(英語)/
sabbatical /サバティカル/
saber /サーベル/セイバー/
sabia /サビア/
sabina /サビーナ/
sabine /サビーヌ/ザビーネ/セービン/
sable /セーブル/サブレ/
sabot /サボ/
sabotage /サボタージュ/
sabre /サーベル/サーブル/
sabrina /サブリナ/
sachsen /ザクセン/
sack /サック/ザック/
sacrament /サクラメント/
sacramento /サクラメント/
sacrifice /サクリファイス/
sad /サッド/サド/
saddam /サダム/
saddle /サドル/
sade /サド/サド侯爵/Marquis de Sade/Donation Alphonse Francois de Sade/
sadism /サディズム/加虐趣味/嗜虐的趣味/加虐淫乱症/
sadist /サディスト/加虐趣味者/嗜虐的趣味者/
sadomaso /サドマゾ;sado-maso/
saens /サーンス/
safari /サファリ/
safaripark /サファリパーク/
safe /セーフ/
safeguard /セーフガード/
safemode /セーフモード/
safety /セーフティ/セーフティー/セイフティ/セイフティー/
safetybunt /セーフティバント;和製英語/セーフティーバント/
safetynet /セーフティネット/セーフティーネット/
safflower /サフラワー/
saffraan /サフラン;(蘭語)/
saffron /サフラン/
saga /サガ/サーガ/
sagan /サガン/
sage /セージ/
sagittarius /サジタリウス/
sagnier /サニエ/
sagrada /サグラダ/
sagradafamilia /サグラダファミリア;Sagrada Familia/
sahara /サハラ;.eh/
sahel /サヘル/
saibaba /サイババ/
said /サイード/セッド;<say/
sail /セール/
sailer /セイラー;帆船/ザイラー;(人名)/
sailing /セーリング/セイリング/
sailor /セーラー/
sailorcollar /セーラーカラー/
saint /セイント/セント/サン/
saintbernard /セントバーナード/
sainte /サント;仏語/
saintemilion /サンテミリオン;Saint-Emilion/
saintestephe /サンテステフ;Saint-Estephe/
saintexupery /サンテグジュペリ;Saint-Exupery/サン＝テグジュペリ/
saintgermain /サンジェルマン;Saint-Germain/
sainthelena /セントヘレナ;Saint Helena/
sainthonore /サントノーレ;(Fr) saint-honore/サントノレ/
saintjohns /セントジョーンズ;Saint Johns/
saintjulien /サンジュリアン;Saint-Julien/
saintlaurent /サンローラン/
saintlawrence /セントローレンス;Saint Lawrence/
saintlouis /セントルイス/サンルイ/
saintlucia /セントルシア;Saint Lucia (.lc)/
saintmarc /サンマルク;(Fr) Saint-Marc/
saintmichel /サンミッシェル;(Fr) Saint-Michel/
saintmoritz /サンモリッツ/
saintpaul /セントポール;Saint Paul/
saintpaulia /セントポーリア/
saintsaens /サンサーンス/サン=サーンス/
saintsebastien /サンセバスチャン;Saint Sebastien (ケーキ)/
sainttropez /サントロペ/
sainz /サインツ/
saipan /サイパン/
saison /セゾン/
sakari /サカリ/
sakha /サハ/
sakhalin /サハリン/
saki /サキ/
saku /サク/
sal /サル/
sala /サラ/サーラ/
salad /サラダ/
saladbar /サラダバー/
saladbowl /サラダボウル/サラダボール/
saladdressing /サラダドレッシング/
saladin /サラディン/サラディーン/
saladoil /サラダオイル/
salam /サラーム/
salamanca /サラマンカ/
salamander /サラマンダー/サラマンダ/サラマンドラ/
salami /サラミ/
salamis /サラミス/
salary /サラリー/
salaryman /サラリーマン/
salat /サラート/
sale /セール/
salem /セーラム;USA/セイラム/
salerno /サレルノ/
sales /セールス/
saleslady /セールスレディ/
salesman /セールスマン/
salespoint /セールスポイント/
salestalk /セールストーク;sales talk/
salgado /サルガド/
salicyl /サリチル/
salieri /サリエリ/
salim /サリム/
salinas /サリナス/
salinger /サリンジャー/
sallie /サリー/
sally /サリー/
salmon /サーモン/サルモン/
salmonella /サルモネラ/
salmonpink /サーモンピンク/
salome /サロメ/
salomon /サロモン/
salon /サロン/
salonconcert /サロンコンサート/
salonika /サロニカ/
saloon /サルーン/
salopette /サロペット/
salsa /サルサ/
salsasauce /サルサソース/
salt /ソルト/
saltlake /ソルトレイク;Salt Lake/ソルトレーク/
saltlakecity /ソルトレイクシティー;Salt Lake City, Utah, USA/ソルトレークシティー/ソルトレイクシティ/ソルトレークシティ/
salto /サルト/
salty /ソルティー/ソルティ/
saltydog /ソルティードッグ/ソルティドッグ/
salut /サリュー;仏語/
salute /サリュート/
salvador /サルバドール/サルバドル/サルヴァドール/
salvage /サルベージ/
salvatore /サルバトーレ/サルヴァトーレ/
salvia /サルビア/
salz /ザルツ/
salzburg /ザルツブルク/ザルツブルグ;※「ク」の方が正確/
sam /サム/
samantha /サマンサ/
samaranch /サマランチ/
samaria /サマリア/
samarium /サマリウム;[元素]62,Sm/
samarkand /サマルカンド/
samawah /サマワ;イラク/サマーワ/
samba /サンバ/
sambawhistle /サンバホイッスル/
sambo /サンボ/
same /セイム/
samen /ザーメン;(独)/
sami /サミ/サミー/
sammy /サミー/
samoa /サモア;.ws, (米領).as/
samosa /サモサ/
samovar /サモワール/
sample /サンプル/
samplecode /サンプルコード/
sampleprogram /サンプルプログラム/
sampler /サンプラー/
sampling /サンプリング/
samplingrate /サンプリングレート/
samsa /ザムザ/
samson /サムソン/
samsung /サムスン;(三星) www.samsung.com/三星/
samu /サム/
samuel /サミュエル/サムエル/
samuelson /サミュエルソン/サムエルソン/
samurnori /サムルノリ;(韓国語) sa mur nor i/
samy /サミー/
san /サン/
san-francisco /サンフランシスコ/
sana /サヌア/サナ/サーナ/
sanantonio /サンアントニオ;San Antonio/
sanatorium /サナトリウム/
sanborn /サンボーン/
sanchez /サンチェス/
sancho /サンチョ/
sanction /サンクション/
sanctuary /サンクチュアリ/サンクチュアリー/
sanctus /サンクトゥス/
sand /サンド/
sanda /サンダ/
sandakan /サンダカン/
sandal /サンダル/
sandalwood /サンダルウッド/
sandbag /サンドバッグ/
sandbeige /サンドベージュ/
sandbox /サンドボックス/
sander /サンダー/
sanders /サンダース/
sandiego /サンディエゴ;San Diego/サン・ディエゴ/
sandor /サンダー/
sandpaper /サンドペーパー/
sandra /サンドラ/
sandro /サンドロ/
sandwedge /サンドウェッジ/
sandwich /サンドイッチ/サンドウィッチ/
sandwitch /サンドイッチ;※sandwich/
sandy /サンディ/サンディー/
sanfrancisco /サンフランシスコ;San Francisco/サン・フランシスコ/
sanfrecce /サンフレッチェ;[Jリーグ]広島/
sanga /サンガ;[Jリーグ]京都/
sangiovese /サンジョヴェーゼ/
sangria /サングリア/
sani /サニ/
sanitary /サニタリー/
sanjose /サンノゼ/サンホセ;San Jose/
sanjuan /サンファン;San Juan/
sankaku /△/▲/
sankt /サンクト/
sanktpeterburg /サンクトペテルブルグ;Sankt-Peterburg/
sanmarino /サンマリノ;San Marino (.sm)/
sanmarinogp /サンマリノGP;[F1]San Marino/
sanpietro /サンピエトロ;San Pietro/
sanremo /サンレモ/
sanrio /サンリオ;www.sanrio.co.jp/
sans /サン/
sansalvador /サンサルバドル;San Salvador/
sanserif /サンセリフ;=sans serif/
sanskrit /サンスクリット/
sansserif /サンセリフ/
santa /サンタ/
santabarbara /サンタバーバラ;Santa Barbara/
santaclaus /サンタクロース;Santa Claus/
santacruz /サンタ・クルーズ/サンタクルーズ;Santa Cruz, ボリビア(vvi)/
santafe /サンタフェ;Santa Fe/
santafedebogota /サンタフェデボゴタ;Santa Fe de Bogota/
santamaria /サンタマリア;Santa Maria/
santamarta /サンタマルタ;Santa Marta, Colombia/
santamonica /サンタモニカ;Santa Monica/
santana /サンタナ/
sante /サンテ/
santi /サンティ/
santiago /サンチアゴ/サンティアゴ/サンチャゴ/
santodomingo /サントドミンゴ;Santo Domingo/
santorini /サントリーニ/
santoro /サントロ/
santos /サントス/
sanyo /サンヨー/
sanz /サンス/
saopaulo /サンパウロ;Sao Paulo, Brasil/
sap /SAP/サップ/
saphire /サファイア/青玉/
sapiens /サピエンス;ラテン語/
sapir /サピア/
saponin /サポニン/
sapp /サップ/
sapphire /サファイア/サファイヤ/
sapphireblue /サファイアブルー/
sappho /サッフォー/
sapporobeer /サッポロビール/
sara /サラ/セイラ/ザーラ/
saraband /サラバンド/
saraca /サラサ/
saracen /サラセン/
sarah /サラ/サラー/
sarai /サライ/
sarajevo /サラエボ/サラエヴォ/
sarangi /サーランギ/サランギ/
saranwrap /サランラップ;[商標]旭化成/
sarasate /サラサーテ/
sarasvati /サラスヴァティ/サラスヴァティー/
saratoga /サラトガ/
sarde /サルド/
sardegna /サルデーニャ/
sardes /サルデス/
sardine /サーディン/
sari /サリー/サリ/
sarin /サリン/
sarod /サロード/サロッド/
sartre /サルトル/
saruman /サルマン/
sasa /ササ/
sasan /ササン/
sash /サッシ/
sasha /サーシャ/
sasi /SASI/Shugart Associates System Interface;Shugart社開発のシステムインターフェイス/
sassoon /サスーン/
sat /土/
satan /サタン/
satchmo /サッチモ;=Louis Armstrong/
satellite /サテライト/
satelliteoffice /サテライトオフィス/
sati /サティ/サティー/
satie /サティ/
satijn /サテン;(ポルトガル語)/
satin /サテン/
satisfaction /サティスファクション/
saturation /サチュレーション/彩度/
saturday /サタデー/サタデイ/サタディ/
saturn /サターン/
satyros /サテュロス/
sauber /ザウバー/
sauce /ソース/
saucer /ソーサー/
saudade /サウダージ;(葡語) 哀愁/
saudi /サウジ/サウディ/
saudiarabia /サウジアラビア;Saudi Arabia (.sa)/サウディアラビア/
sauerkraut /ザワークラウト/
saul /サウル/ソール/
sauna /サウナ/
sauron /サウロン/
sausage /ソーセージ/
saussure /ソシュール/
saute /ソテー/
sauter /ソテー/
sauterne /ソーテルヌ/
sauvage /ソバージュ/
sauvignon /ソーヴィニヨン/ソーヴィニョン/
savanna /サバンナ/
savarin /サバラン/サヴァラン/
save /セーブ/
savedata /セーブデータ/
saveon /セーブオン;www.saveon.co.jp/
savepoint /セーブポイント;和製英語(saves)/
saver /セーバー/セイバー/セイヴァー/セーバ/
saving /セービング/
saviola /サビオラ/
savoia /サヴォイア/
savon /サボン;(Fr)石鹸/サヴォン/
savoy /サヴォイ/
saw /ソー/
sawallisch /サヴァリッシュ/
sawing /ソーイング/
sawyer /ソーヤ/
sax /サックス/
saxophone /サクソフォン/サキソフォン/
say /セイ/
sayonara /サヨナラ/
sayonarahit /サヨナラヒット/
sayonarahomerun /サヨナラホームラン;sayonara homerun/
sayonarahr /サヨナラホームラン;sayonara homerun/
saz /サズ/
sb /アンチモン/Antimony/
sc /スカンジウム/Scandium/サウスカロライナ/South Carolina/
scala /スカラ;-座(Teatro alla Scala)/
scalability /スケーラビリティ/スケイラビリティ/
scalable /スケーラブル/スケイラブル/
scalar /スカラ/スカラー/スケーラ/
scale /スケール/スケイル/
scaledown /スケールダウン;scale-down/
scalemerit /スケールメリット/
scaleout /スケールアウト/
scaler /スケーラ/スケーラー/スカラー;※scalar?/
scaleup /スケールアップ/
scalewindow /スケールウインドー/
scaling /スケーリング/
scalingfactor /スケーリングファクター/
scalp /スカルプ/
scan /スキャン/
scandal /スキャンダル/
scandalous /スキャンダラス/
scandinavia /スカンジナビア/
scandinavian /スカンジナビアン/
scandium /スカンジウム;[元素]21,Sc/
scanline /スキャンライン/
scanner /スキャナ/スキャナー/
scanning /スキャニング/
scanties /スキャンティ/スキャンティー/
scanty /スキャンティ/
scape /スケープ/
scapegoat /スケープゴート/
scar /スカー/
scarborough /スカボロー/
scare /スケア/
scarf /スカーフ/
scarface /スカーフェイス/スカーフェース/
scarlatti /スカルラッティ/
scarlet /スカーレット/
scat /スキャット/
scatolo /スカトロ;scatology/
scatology /スカトロジー/スカトロ/
scatterometer /スキャトロメーター/
scavenger /スカベンジャー/
scena /シェーナ/
scenario /シナリオ/
scenariowriter /シナリオライター/
scene /シーン/
scenery /シナリー/
scha /щ;cyrillic/
schanze /シャンツェ/
schedule /スケジュール/
scheduler /スケジューラ/スケジューラー/
scheduling /スケジューリング/
scheffe /シェッフェ/
scheherazade /シェエラザード/シェヘラザード/
schelling /シェリング/
schema /スキーマ/シェーマ;(独)/
schemata /スキーマタ/
schematic /スケマティック/
scheme /スキーム/Scheme/
schere /シェーレ/
scherzando /スケルツァンド/
scherzo /スケルツォ/
schiff /シフ/
schiheil /シーハイル;Schi Heil/
schiller /シラー/
schilling /シリング/
schilt /シュルト/シルト/
schizo /スキゾ;schizophrenia/
schlaf /シュラフ;(独語)Schlafsack/
schlegel /シュレーゲル/
schliemann /シュリーマン/
schmid /シュミット/
schmidt /シュミット/
schmitt /シュミット/
schnabel /シュナーベル/
schneider /シュナイダー/
schnorchel /シュノーケル;(独語)/
scholar /スカラ/スカラー/
scholarship /スカラシップ/
scholl /ショル/
schon /シェーン/
schonberg /シェーンベルク/
school /スクール/
schoolboy /スクールボーイ/
schoolbus /スクールバス/
schoolgirl /スクールガール/
schooling /スクーリング/
schoolmate /スクールメイト/スクールメート/
schoolzone /スクールゾーン/
schop /スコップ;(蘭語)/
schopenhauer /ショーペンハウアー/ショーペンハウエル/
schottky /ショットキー/
schroder /シュローダー/
schrodinger /シュレディンガー/シュレーディンガー/
schroeder /シュレーダー/シュローダー/
schubert /シューベルト/
schulz /シュルツ/
schumacher /シューマッハ/シューマッハー/
schuman /シューマン/
schumann /シューマン/
schumpeter /シュンペーター/
schwab /シュワブ/
schwann /シュワン/
schwartz /シュワルツ/シュヴァルツ/
schwarz /シュワルツ/シュヴァルツ/シュバルツ/
schwarzenegger /シュワルツェネッガー/シュワルツネッガー/
schwarzschild /シュヴァルツシルト/シュバルツシルト/シュワルツシルト/
schwarzwald /シュバルツバルト/シュヴァルツヴァルト/
schweitzer /シュバイツァー/シュヴァイツァー/シュバイツアー/
science /サイエンス/
scientific /サイエンティフィック/
scientist /サイエンティスト/
scimitar /シミター/
scintillation /シンチレーション/
scissor /シザー/
scitech /サイテック;sci-tech, science and technology/
sclereid /スクレレイド/
scola /スコラ/
scone /スコーン/
scoop /スクープ/スコップ;schop/
scooter /スクーター/
scope /スコープ/
scorch /スコーチ/
score /スコア/
scoreboard /スコアボード/
scorebook /スコアブック/
scorecard /スコアカード/
scorer /スコアラー/
scoria /スコリア/
scoring /スコアリング/
scorpio /スコーピオ;蠍座/
scorpion /スコーピオン/
scort /スコート/
scot /スコット/
scotch /スコッチ/Ｓｃｏｔｃｈ/
scotchwhiskey /スコッチウイスキー/
scotland /スコットランド/
scott /スコット/
scottish /スコティッシュ/
scottishfold /スコティッシュフォールド/
scotty /スコッティ/
scout /スカウト/
scouter /スカウター/
scoutman /スカウトマン;和製英語(recruiter)/
scramble /スクランブル/
scrambledegg /スクランブルエッグ/
scrambleegg /スクランブルエッグ;scrambled egg/
scrap /スクラップ/
scrap&build /スクラップ＆ビルド/
scrapbook /スクラップブック/
scraper /スクレーパー/スクレーパ/スケッパー;scraperの訛音?/
scrapie /スクレイピー/
scratch /スクラッチ/
scream /スクリーム/
screaming /スクリーミング/
screen /スクリーン/
screening /スクリーニング/
screensaver /スクリーンセーバー;screen saver/スクリーンセーバ/スクリーンセイバー/
screenshot /スクリーンショット/
screentone /スクリーントーン/
screw /スクリュー/スクリユー;<rare>/
screwball /スクリューボール/
screwdriver /スクリュードライバー/
scriabin /スクリャービン/
scrimmage /スクリメージ/
script /スクリプト/
scripter /スクリプター/スクリプタ/
scripting /スクリプティング/
scroll /スクロール/
scrollback /スクロールバック/
scrollbar /スクロールバー/
scrolledwindow /スクロール・ウィンドー/
scrub /スクラブ/
scrum /スクラム/
scsi /スカジー/SCSI/Small Computer System Interface/
scsiboard /SCSIボード/
scsicard /SCSIカード/
scsidevice /SCSIデバイス/
scsidrive /SCSIドライブ/
scsiinterface /SCSIインターフェイス;NB:Small Computer System Interface interface/SCSIインターフェース/
scuba /スキューバ/スクーバ/
scubadiving /スキューバダイビング/
scull /スカル/
sculpture /スカルプチャー/
scum /スカム/
sd /標準偏差;Standard Deviation/South Dakota/サウスダコタ/
sds /システムデザインサービス/
se /セレン/Selenium/┌;罫線/┏;太い罫線/
sea /シー/
seabass /シーバス;sea bass/
seafood /シーフード/
seafoodsalad /シーフードサラダ/
seagull /シーガル/
seajack /シージャック/
seal /シール/
sealer /シーラー/
sealing /シーリング/
seam /シーム/
seamless /シームレス/
seamonkey /シーモンキー/
sean /ショーン/
seaparadise /シーパラダイス;www.seaparadise.co.jp/
search /サーチ/探索/
searchengine /サーチエンジン/
searcher /サーチャー/サーチャ/
searchlight /サーチライト/
searle /サール/
seas /シーズ/
seaside /シーサイド/
season /シーズン/
seasoning /シーズニング/
seasonoff /シーズンオフ;和製英語(off-season)/
seat /シート/
seatbelt /シートベルト/
seating /シーティング/
seatknock /シートノック;和製英語/
seattle /シアトル/
seaworld /シーワールド/
sebastian /セバスチャン/セバスティアン/
sebastiano /セバスティアーノ/
sebastien /セバスチャン/セバスチアン/
sec /セック/
secant /セカント;正割/
seco /セコ/
secom /セコム;www.secom.co.jp/
second /セカンド/セコンド/″/秒/
secondary /セカンダリ/セカンダリー/
secondbase /セカンドベース/
secondclass /セカンドクラス/
secondfly /セカンドフライ/
secondgoro /セカンドゴロ;和製語(grounder)/
secondhouse /セカンドハウス/
secondlife /セカンドライフ/
secondopinion /セカンドオピニオン/
secret /シークレット/
secretary /セクレタリー/
secretservice /シークレットサービス/
sect /セクト/
section /セクション/§/
sectionalism /セクショナリズム/
sectionning /セクショニング/
sector /セクター/セクタ/
secure /セキュア/
security /セキュリティ/セキュリティー/
securityhole /セキュリティホール/
securitylevel /セキュリティレベル/セキュリティーレベル/
securitypolicy /セキュリティポリシー/セキュリティーポリシー/
sedan /セダン/
see /シー/
seed /シード/
seeds /シーズ/
seek /シーク/
seeker /シーカ/シーカー/
seektime /シークタイム/
seen /シーン/
seesaw /シーソー/
seesawgame /シーソーゲーム/
seethrough /シースルー/
sega /セガ/
segasaturn /セガサターン;[商標]/
segesta /セジェスタ/
segment /セグメント/
segmentation /セグメンテーション/
segovia /セゴビア/
segway /セグウェイ/
seidel /ザイデル/
seiko /セイコー/
seil /ザイル/
sein /ザイン;(独語)/
seine /セーヌ/
seismic /サイスミック/
select /セレクト/
selecter /セレクタ/
selection /セレクション/
selector /セレクター/セレクタ/
selectshop /セレクトショップ;和製英語/
selene /セレネ/セレーネ/
selenite /セレナイト/
selenium /セレニウム;[元素]34,Se/セレン;[元素]34,Se/
seleno /セレノ/
seles /セレス/セレシュ/
self /セルフ/Self/
selfcare /セルフケア/
selfcheck /セルフチェック/
selfcontrol /セルフコントロール/
selfcover /セルフカバー/
selfesthe /セルフエステ/
selfhelp /セルフヘルプ;self-help/
selfimage /セルフイメージ;self-image/
selfish /セルフィッシュ/
selfportrait /セルフポートレート/
selfpower /セルフパワー/
selfservice /セルフサービス/
selfstand /セルフスタンド/
selftimer /セルフタイマー/
selim /セリム/
selina /セリーナ/
seljuk /セルジューク/
sell /セル/
seller /セラー/
sellers /セラーズ/
selling /セリング/セーリング/
sellotape /セロテープ;[商標]/
sellvideo /セルビデオ;⇔レンタルビデオ/
selma /セルマ/
selmer /セルマー/
selva /セルバ/
semantic /セマンティック/
semantics /セマンティクス/意味/
semaphore /セマフォ/セマフォー/
semblance /センブランス/
semen /ザーメン/
semester /セメスター/
semi /ゼミ;seminar/セミ;-プロ/セミナー/
semiauto /セミオート;semi-automatic/
semicolon /セミコロン/
semiconductor /セミコンダクタ;半導体/セミコンダクター/
semicustom /セミカスタム/
semidouble /セミダブル/
semifinal /セミファイナル/
semihard /セミハード/
semillon /セミヨン/
semilong /セミロング;和製英語/
seminaire /セミネール/
seminar /セミナー/ゼミナール;(独語)/セミナ/ゼミ/
seminor /セミナー/
seminorm /セミノルム/
seminude /セミヌード/
semiorder /セミオーダー;和製英語/
semipro /セミプロ;semi-professional/
semisweet /セミスイート/
semmy /セーム/セミー/
semophore /セマフォ/
semplice /センプリーチェ/
sen /セン/
send /センド/
sender /センダ/センダー/
seneca /セネカ/
senegal /セネガル;.sn/
senior /シニア/
senna /セナ/センナ;[植物]/
senor /セニョール;(西語)/
senorita /セニョリータ;(西語)/
sens /サンス;仏語/センス/
sensation /センセーション/
sensational /センセーショナル/
sense /センス/
sensible /センシブル/
sensing /センシング/
sensitive /センシティブ/センシティヴ/
sensor /センサー/センサ/
sensual /センシュアル/
sent /セント/
sentence /センテンス/
sentiment /センチメント/
sentimental /センチメンタル/
sentimento /センチメント;(イタリア語)/
sentinel /センチネル/
seoul /ソウル/
separate /セパレート/
separates /セパレーツ/
separation /セパレーション/
separator /セパレータ/セパレーター/
sepatakraw /セパタクロー/
sepia /セピア/
september /セプテンバー/
septet /セプテット/
sequence /シーケンス/シークエンス/シークェンス/
sequencer /シーケンサー/シーケンサ/
sequencial /シーケンシャル/
sequent /シークエント/シーケント/
sequential /シーケンシャル/
sequoia /セコイア/
sera /セラ/
serafin /セラフィン/
seraphim /セラフィム;熾天使/
serbia /セルビア/
serena /セレナ/
serenade /セレナーデ/セレナード/
serenata /セレナータ/
serendipity /セレンディピティー/
serge /サージ/セルジュ/
sergeant /サージェント/
sergei /セルゲイ/
sergi /セルジ/
sergio /セルジオ/セルヒオ/セルジョ/
serial /シリアル/
serialise /シリアライズ/
serialize /シリアライズ/
serialnumber /シリアルナンバー/
serialport /シリアルポート/
serie /セリエ;(イタリア語)/セリー;仏語/
seriea /セリエA/
series /シリーズ/
serif /セリフ/
serine /セリン;Ser/
serio /セリオ;(イタリア語)/
serious /シリアス/
sermon /サーモン;説教/
serna /セルナ/
serotonin /セロトニン/
serpent /サーペント/
serra /セラ/セーラ/
servant /サーバント/
serve /サーブ/
server /サーバー/サーバ/サーヴァ/
serverdown /サーバーダウン/サーバダウン/
servermachine /サーバマシン/サーバーマシン/
serverrack /サーバーラック/サーバラック/
serverroom /サーバルーム/
service /サービス/サーヴィス/
serviceace /サービスエース/
servicearea /サービスエリア/
servicecenter /サービスセンター/
servicecentre /サービスセンター/
servicecounter /サービスカウンター/
serviceguide /サービスガイド/
serviceline /サービスライン/
servicelist /サービスリスト/
serviceman /サービスマン/
serviceprovider /サービスプロバイダ/
servicer /サービサー;債権管理回収業/
servicestation /サービスステーション/
servlet /サーブレット/
servo /サーボ/
sesame /セサミ/
sesamestreet /セサミストリート;(番組名) Sesame Street/
session /セッション/
sessionid /セッションID/
sessions /セッションズ/
set /セット/集合/
setback /セットバック/
sete /セテ/
seth /セト;(エジプト神話)/セツ;(聖書)/セス/
setlist /セットリスト/
setmenu /セットメニュー/
setminus /＼;LaTeX/
seton /シートン/
setplay /セットプレー/
setpoint /セットポイント/
setposition /セットポジション/
setservice /ネットサービス/
setter /セッター/
setting /セッティング/
setup /セットアップ/
setupper /セットアッパー/
seurat /スーラ/
seven /セブン/セヴン/
sevenbridge /セブンブリッジ/
seveneleven /セブンイレブン;www.sej.co.jp/
sevenstar /セブンスター/
seventeen /セブンティーン/セヴンティーン/
seventh /セブンス/
seventy /セブンティ/
severe /シビア/
sevilla /セビリア/セビーリャ/
sevres /セーブル/セーヴル/
sewing /ソーイング/
sewn /ソーン/
sex /セックス/Ｓ−ｅｘｐｒｅｓｓｉｏｎ/Ｓ式/
sexappeal /セックスアピール/
sexaroid /セクサロイド/
sexe /セクス;仏語/
sexfriend /セックスフレンド/セフレ/
sexless /セックスレス/
sexlife /セックスライフ/
sexology /セクソロジー/
sexp /S式/
sexscene /セックスシーン/
sextet /セクステット/
sexual /セクシャル/セクシュアル/性的/
sexualharassment /セクシャルハラスメント/セクハラ/
sexualis /セクスアリス;ラテン語/
sexuality /セクシュアリティ/セクシャリティ/セクシュアリティー/セクシャリティー/
sexy /セクシー/セクシィ/
seychelles /セイシェル;.sc/セーシェル/
seyfext /セイファート/
sf /スフォルツァンド;その音を特に強く/sforzando/
sfmagazine /SFマガジン;早川書房/
sforzando /スフォルツァンド/
sfz /スフォルツァンド;その音を特に強く/sforzando/
sg /シーボーギウム/Seaborgium/シリコン・グラフィックス/
sgi /シリコングラフィックス/
sgml /SGML/
sh /ш;sh (cyrillic)/Bシェル/
sha /ш;cyrillic/
shaba /シャバ/
shade /シェード/
shading /シェーディング/
shadow /シャドウ/シャドー/
shadowboxing /シャドーボクシング/シャドウボクシング/
shadowing /シャドーイング/シャドウイング/
shadowmask /シャドウマスク/シャドーマスク/
shaft /シャフト/
shaggy /シャギー/
shah /シャー/
shahrazad /シェエラザード/シェヘラザード/シェラザード/
shake /シェイク/
shakehand /シェイクハンド/シェークハンド/
shaker /シェーカー/シェイカー/
shakespeare /シェイクスピア/シェークスピア/
shakti /シャクティ/
shallow /シャロー/シャロウ/
shaman /シャーマン/
shamanism /シャーマニズム/
shambala /シャンバラ/
shampoo /シャンプー/
shampoodresser /シャンプードレッサー/
shampoohat /シャンプーハット/
shamrock /シャムロック/
shandy /シャンディ/シャンディー/
shane /シェーン/
shanghai /シャンハイ/上海/
shanghi /シャンハイ;※shanghai?/上海;※shanghai?/
shangrila /シャングリラ;Shangri-la/
shank /シャンク/
shannon /シャノン/
shanon /シャノン/
shanti /シャンティ;(ヒンディ語) 平和/
shanty /シャンティ/シャンティー/
shape /シェイプ/シェープ/
shaper /シェイパー/シェーパー/
shapeup /シェイプアップ/
shaping /シェイピング/
sharapova /シャラポワ/
share /シェア/
shared /シェアード/シェアド/
shareware /シェアウェア/
sharia /シャリア/シャリーア/
sharing /シェアリング/
shark /シャーク/
sharon /シャロン/
sharp /シャープ/♯;音楽記号のシャープ/＃;number/
sharpener /シャープナー/
sharpness /シャープネス/
sharppen /シャープペン;和製英語(mechanical pencil)/シャーペン/
sharppencil /シャープペンシル;和製英語(mechanical pencil)/シャーペン/
shattle /シャトル;※shuttle?/
shave /シェイブ/
shaver /シェーバー/
shaving /シェービング/
shavingcream /シェービングクリーム/
shawl /ショール/
she /シー/
shear /シアー/シャー/
shearing /シアリング/
sheat /シート/
sheba /シバ/
sheena /シーナ/
sheep /シープ/
sheepdog /シープドッグ/
sheet /シート/
sheetfeeder /シートフィーダ/シートフィーダー/
sheeting /シーティング/
sheets /シーツ/
sheffield /シェフィールド/
sheila /シーラ/シェイラ/シェーラ/
shekele /シェケレ/
sheldon /シェルダン/
shelf /シェルフ/
shell /シェル/
shelley /シェリー/
shellscript /シェルスクリプト/
shelter /シェルター/
shemale /シーメール/
shena /シーナ/
shepherd /シェパード/
sheraton /シェラトン/
sherbet /シャーベット/
sheriff /シェリフ/
sherlock /シャーロック/
sherpa /シェルパ/
sherry /シェリー/
sheryl /シェリル/
shiah /シーア/
shield /シールド/
shields /シールズ/
shift /シフト/
shiftchange /シフトチェンジ/
shifter /シフター/
shiftjis /シフトＪＩＳ/シフトJIS/
shiftkey /SHIFTキー/シフトキー/シフト・キー/
shiftlever /シフトレバー/
shihtzu /シーズー;shih tzu/
shikaku /□/■/
shilling /シリング/
shime /〆/
shin /シン/
shine /シャイン/
shingle /シングル/
shinguard /シンガード;すねあて/
shining /シャイニング/
shiny /シャイニー/
ship /シップ/
shipper /シッパー/
shipping /シッピング/
shiraz /シーラーズ/
shire /シャー/シャイア/
shirley /シャーリー/
shirring /シャーリング/
shirt /シャツ/
shirts /シャツ/
shishkebab /シシカバブ;shish kebab/
shit /シット/
shiva /シバ/
shoah /ショアー/
shock /ショック/
shocker /ショッカー/
shocking /ショッキング/
shockingpink /ショッキングピンク/
shockwave /ショックウェーブ/
shoe /シュー/
shoebox /シューボックス/
shoes /シューズ/
shoesbox /シューズボックス/
sholokhov /ショーロホフ/
shone /ショーン/
shoot /シュート/
shootball /シュートボール/
shootdown /シュートダウン/
shooter /シューター/
shooting /シューティング/
shootinggame /シューティングゲーム/
shootingstar /シューティングスター/
shop /ショップ/
shopbrand /ショップブランド/
shoppage /ショップページ/
shopper /ショッパー/
shopping /ショッピング/
shoppingbag /ショッピングバッグ/
shoppingcart /ショッピングカート/
shoppingcenter /ショッピングセンター/
shoppingmall /ショッピングモール/
shoppingplaza /ショッピングプラザ/
shoppingsite /ショッピングサイト/
shore /ショア/
short /ショート/
shortboard /ショートボード/
shortbound /ショートバウンド/
shortcake /ショートケーキ/
shortcut /ショートカット/
shortcutkey /ショートカットキー/
shortening /ショートニング/
shorter /ショーター/
shortfly /ショートフライ/
shortgoro /ショートゴロ;和製語(grounder)/
shorthair /ショートヘア/ショートヘアー/
shorthand /ショートハンド/
shorthole /ショートホール;par-3/
shortiron /ショートアイアン;8-/
shortpants /ショートパンツ/
shortpass /ショートパス/
shorts /ショーツ/
shortscale /ショートスケール/
shortshort /ショートショート;short-short/
shortsize /ショートサイズ/
shortsleeve /ショートスリーブ/
shortstay /ショートステイ/
shortstop /ショートストップ/
shortsword /ショートソード/
shorttrack /ショートトラック/
shorty /ショーティ/
shostakovich /ショスタコーヴィチ/
shot /ショット/
shotbar /ショットバー/
shotglass /ショットグラス/
shotgun /ショットガン/
should /シュド/シュッド/
shoulder /ショルダー/
shoulderbag /ショルダーバッグ/
shoulderstrap /ショルダーストラップ;肩紐/
shout /シャウト/
shovel /ショベル/シャベル/
shovelcar /ショベルカー/
show /ショー/ショウ/
showbusiness /ショービジネス/
showcase /ショーケース/ショウケース/
shower /シャワー/
showercurtain /シャワーカーテン/
showerhead /シャワーヘッド/
showerroom /シャワールーム/
showerscene /シャワーシーン/
showertoilet /シャワートイレ;和製英語/
showroom /ショールーム/ショウルーム/
showtime /ショウタイム/ショータイム/
showup /ショーアップ/ショウアップ/
showwindow /ショーウィンドウ/ショーウィンドー/ショウウィンドウ/
shredder /シュレッダー/シュレッダ/
shrimp /シュリンプ/
shrink /シュリンク/
shroedinger /シュレーディンガー/
shsh /щ;scha (cyrillic)/
shuffle /シャッフル/シャフル/
shuffling /シャッフリング/
shura /シューラ/
shut /シャット/
shutdown /シャットダウン/
shutout /シャットアウト/
shutter /シャッター/シヤッター;NB:企業名「三和-,東洋-,文化-」/
shutterbutton /シャッターボタン/
shutterchance /シャッターチャンス;和製英語/
shuttle /シャトル/
shuttlebus /シャトルバス/
shuttlecock /シャトルコック;バドミントンの羽根/
shy /シャイ/
shylock /シャイロック/
si /ケイ素/珪素/Silicon/シ/サイ/
siam /シャム/サイアム/
siamese /サイアミーズ/
sian /シアン/
sibelius /シベリウス/
siberia /シベリア/
siberian /シベリアン/サイベリアン/
siberianhusky /シベリアンハスキー/
sibip /シビップ/
sice /計測自動制御学会;Society of Instrument and Control Engineers. www.sice.or.jp/
sicilia /シチリア/
siciliana /シチリアーナ/
siciliano /シチリアーノ/
sicilien /シシリアン/
sicilienne /シシリエンヌ/
sick /シック/
sickhouse /シックハウス;和製英語/
sicp /ＳＩＣＰ(Structure and Interpretation of Computer Programs)/
sid /シド/セッションID/
siddhartha /シッダールタ/悉達多/
side /サイド/
sidearm /サイドアーム/
sideback /サイドバック/
sidebag /サイドバッグ/
sidebar /サイドバー/
sideboard /サイドボード/
sidebrake /サイドブレーキ/
sidebusiness /サイドビジネス/
sidecar /サイドカー/
sidedish /サイドディッシュ/
sidedoor /サイドドア/
sideline /サイドライン/
sideman /サイドマン/
sidemen /サイドメン/
sidemirror /サイドミラー/
sideout /サイドアウト/
sidepanel /サイドパネル/
sidepocket /サイドポケット/
sider /サイダー/
sidestep /サイドステップ/
sidetable /サイドテーブル/
sidethrow /サイドスロー;和製英語(sidearm)/
sidewalk /サイドウォーク/
sidewinder /サイドワインダー/
siding /サイディング/
sidney /シドニー/
siebold /シーボルト/
sieg /ジーク/ジーグ/
siegfried /ジークフリート/
siegmund /ジークムント/
siemens /シーメンス/ジーメンス/シーメンズ/ジーメンズ/
siemreap /シエムリアプ;Siem Reap, カンボジア(rep)/
siena /シエナ/
sienna /シエナ/
sierra /シエラ/シェラ/
sierracup /シェラカップ/
sierraleone /シエラレオネ;(Sierra Leone) .sl/シエラレオーネ/
sierranevada /シエラネバダ;Sierra Nevada/シェラネバダ/
siesta /シエスタ/
sieve /シーブ/
sievert /シーベルト/
sift /シフト/
sig /シグ/
sight /サイト/
sigma /σ/シグマ/
sigmarion /シグマリオン;[商標]NTT DoCoMo/
sigmoid /シグモイド/シグモイド関数/
sigmund /ジグムント/ジークムント/シグムンド/
sign /サイン/署名/
signal /シグナル/
signalhandler /シグナルハンドラ/
signaling /シグナリング/
signalling /シグナリング/
signature /シグネチャー/シグネチャ/シグニチャ/シグネイチャー/シグナチャー/
signball /サインボール/
signe /シーニュ/
signifiant /シニフィアン/
signifie /シニフィエ/
signin /サインイン;sign in/
signon /サインオン/
signori /シニョーリ/
signout /サインアウト;sign out/
signpen /サインペン;和製英語(felt pen)/
signplay /サインプレー;和製英語/
signup /サインアップ/
sihanouk /シアヌーク/
sikh /シーク/
sikkim /シッキム/
silane /シラン;SiH4/
silas /サイラス/
sildenafil /シルデナフィル;=viagra/
silence /サイレンス/
silencer /サイレンサー/
silent /サイレント/
silhouette /シルエット/
silica /シリカ/
silicagel /シリカゲル;silica gel/
silicon /シリコン/
silicone /シリコーン/
silicongum /シリコンゴム/
siliconvalley /シリコンバレー/
silk /シルク/
silkhat /シルクハット/
silkroad /シルクロード/
silkscreen /シルクスクリーン/
silky /シルキー/
sillitoe /シリトー/
silly /シリー/
silo /サイロ/
silt /シルト/
silva /シルヴァ/シルバ/
silver /シルバー/シルヴァー/
silverfox /シルバーフォックス/
silvergray /シルバーグレー/シルバーグレイ/
silvergrey /シルバーグレー/シルバーグレイ/
silverseat /シルバーシート/
silverstone /シルバーストーン/
silvester /シルベスター/シルベスタ/シルヴェスター/シルヴェスタ/
silvia /シルヴィア/シルビア/
silvio /シルヴィオ/
silvousplait /シルブプレ;S'il vous plait/
sim /シム/〜/
sima /シーマ/
simbox /シミュレーション・ボックス/
simcity /シムシティ;[ゲーム]/
simeon /シメオン/
simeone /シメオネ/
similar /∽/
simla /シムラ/
simm /ジム/
simmel /ジンメル/
simmonds /シモンズ/
simmons /シモンズ/
simms /シムズ/
simon /サイモン/シモン/
simonds /シモンズ/
simone /シモーヌ/シモーネ;(イタリア語)/
simonetta /シモネッタ/
simons /シモンズ/
simple /シンプル/
simplelife /シンプルライフ;和製英語/
simplex /シンプレックス/
simpson /シンプソン/
sims /シムズ/
simul /サイマル;simultaneous/
simulacre /シミュラークル;仏語/
simulate /シミュレート/シミュレイト/
simulation /シミュレーション/シミュレイション/
simulationgame /シミュレーションゲーム/
simulator /シミュレーター/シミュレータ/シミュレイタ;<rare>/
sin /サイン/シン;罪悪/
sina /シーナ/
sinai /シナイ/
sinatra /シナトラ/
since /シンス/
sindbad /シンドバッド/
sine /サイン/
sinecurve /サインカーブ/
sing /シング/
singapore /シンガポール;.sg/
singapura /シンガプーラ/
singer /シンガー/
singers /シンガーズ/
singersongwriter /シンガーソングライター/
singing /シンギング/
single /シングル/
singlebed /シングルベッド/
singleclick /シングルクリック/
singlecut /シングルカット/
singlehit /シングルヒット;和製英語(single)/
singlelife /シングルライフ;和製英語/
singlemother /シングルマザー/
singlequote /シングルクォート/‘;opening/’;closing/
singleroom /シングルルーム/
singles /シングルス/シングルズ/
singlesize /シングルサイズ/
singletask /シングルタスク/
singleton /シングルトン/
singleuser /シングルユーザー/シングルユーザ/
singspiel /ジングシュピール/
sinker /シンカー/
sinopoli /シノーポリ/
sinusoid /サイン曲線/
sion /シオン/
sip /シップ/
siphon /サイフォン/サイホン/
sippo /シッポ/
sir /サー/
siracusa /シラクサ/
siren /サイレン/セイレーン/シレン/
sirius /シリウス/
sirloin /サーロイン/
sirloinsteak /サーロインステーキ/
sirocco /シロッコ/
sisley /シスレー/
sistema /システマ/
sister /シスター/
sisters /シスターズ/
sistine /システィーナ/システィナ/
sisyphus /シジフォス/
sitar /シタール/
site /サイト/
sitelicence /サイトライセンス/
sitelicense /サイトライセンス/
sitemap /サイトマップ/
sitepolicy /サイトポリシー/
sitetop /サイトトップ/
sitter /シッター/
sitting /シッティング/
situation /シチュエーション/
siva /シヴァ/シバ/
sivuch /セイウチ;(露語)сивуч/
six /シックス/
sixnine /シックスナイン/
sixteen /シックスティーン/
sixth /シックスス/
sixty /シックスティ/シクスティ/
size /サイズ/
sizedown /サイズダウン;和製英語/
sizefree /サイズフリー;和製英語(one-size-fits-all)/
sizeup /サイズアップ;和製英語/
sizing /サイジング/
sizzle /シズル/
ska /スカ/
skate /スケート/
skateboard /スケートボード/スケボー/
skater /スケーター/
skaterink /スケートリンク;skating rink/
skaters /スケーターズ/
skating /スケーティング/
skatole /スカトール/
skeet /スキート/
skeleton /スケルトン/
skelton /スケルトン/
sketch /スケッチ/
sketchbook /スケッチブック/
skew /スキュー/
ski /スキー/
skid /スキッド/
skier /スキーヤー/
skill /スキル/
skillet /スキレット/
skillful /スキルフル/
skillup /スキルアップ;和製英語(upskill)/
skim /スキム/
skimmer /スキマー/
skimmilk /スキムミルク/
skimming /スキミング/
skin /スキン/
skincare /スキンケア/
skincream /スキンクリーム/
skindiving /スキンダイビング;素潜り/
skinhead /スキンヘッド/
skinlotion /スキンローション/
skinning /スキニング/
skins /スキンズ/
skinship /スキンシップ/
skip /スキップ/
skipper /スキッパー/
skiresort /スキーリゾート/
skirt /スカート/
skit /スキット/
skiware /スキーウェア/
skk /SKK/Simple Kana to Kanji conversion program/
skolem /スコーレム/
skopje /スコピエ/
skryabin /スクリャービン/
skull /スカル/
skunk /スカンク/スコンク;ボロ負け/
sky /スカイ/
skyblue /スカイブルー/
skydiver /スカイダイバー/
skydiving /スカイダイビング/
skylark /スカイラーク;ひばり/すかいらーく;www.skylark.co.jp/すかいら〜く/
skylight /スカイライト/
skyline /スカイライン/
skylla /スキュラ/
skymark /スカイマーク;www.skymark.co.jp/
skyperfectv /スカイパーフェクTV;www.skyperfectv.co.jp/SKY PerfecTV!/スカパー/
skythai /スキタイ/
skywalk /スカイウォーク/
skywalker /スカイウォーカー/
slab /スラブ/
slack /スラック/
slacks /スラックス/
slag /スラグ/
slalom /スラローム/
slam /スラム/
slamdunk /スラムダンク/
slammer /スラマー/
slang /スラング/
slapstick /スラップスティック/
slash /スラッシュ/／/
slashdot /スラッシュドット;slashdot.org/スラド/
slate /スレート/
slategray /スレートグレー/
slategrey /スレートグレー/
slaughter /スローター/
slav /スラヴ/スラブ/
slave /スレーブ/スレイブ/
slax /スラックス/
slay /スレイ/
slayer /スレイヤー/
slayers /スレイヤーズ/
sleep /スリープ/
sleeper /スリーパー/
sleeping /スリーピング/
sleepingbag /スリーピングバッグ/
sleeve /スリーブ/スリーヴ/
sleeveless /スリーブレス/
sleeves /スリーブス/スリーヴス/
sleigh /スレー/
slender /スレンダー/
slice /スライス/
slicealmond /スライスアーモンド/
slicecheese /スライスチーズ/
slicer /スライサー/スライサ/
slicing /スライシング/
slicker /スリッカー/
slide /スライド/
slideglass /スライドガラス/スライドグラス/
slider /スライダー/
sliderail /スライドレール/
slidermemory /スライダーメモリ/
slideshow /スライドショー/
sliding /スライディング/
slim /スリム/
slimane /スリマン/
slimcase /スリムケース/
slime /スライム/
slimming /スリミング/
slimsize /スリムサイズ/
slimtype /スリムタイプ/
slimup /スリムアップ/
sling /スリング/
slingshot /スリングショット/
slip /スリップ/
slipon /スリップオン;slip-on/スリッポン/
slipper /スリッパ/
slipstream /スリップストリーム/
slit /スリット/
slitdrum /スリットドラム/
sloan /スローン/
sloane /スローン/
slogan /スローガン/
slone /スローン/
slope /スロープ/
slot /スロット/
slotmachine /スロットマシン/スロットマシーン/
slotter /スロッター/
slovak /スロバキア;.sk/
slovakia /スロバキア/スロヴァキア/
slovenia /スロベニア;.si/
slovenija /スロヴェニア/
slow /スロー/スロウ/
slowball /スローボール/
slowcurve /スローカーブ/
slowdance /スローダンス/
slowdown /スローダウン/
slowfood /スローフード;slow food/
slowlife /スローライフ;slow life/
slowly /スローリー/
slowmotion /スローモーション/
slowness /スローネス/
slowpace /スローペース/
slowstep /スローステップ/
slowtempo /スローテンポ/
sludge /スラッジ/
slug /スラッグ/
slugger /スラッガー/
slum /スラム/
slump /スランプ/
slur /スラー/
sly /スライ/
sm /サマリウム/Samarium/
smack /スマック/
small /スモール/
smallsize /スモールサイズ/
smalltalk /Smalltalk/Ｓｍａｌｌｔａｌｋ/SmallTalk/
smap /スマップ/
smart /スマート/
smartball /スマートボール/
smartcard /スマートカード/
smartmedia /スマートメディア/
smash /スマッシュ/
smasher /スマッシャー/
smashhit /スマッシュヒット/
smclub /SMクラブ/
smeagol /スメアゴル/
smell /スメル/
smetana /スメタナ/
smile /スマイル/
smiley /スマイリー;顔文字 :-)/
smirnoff /スミルノフ/スミノフ/
smirnov /スミルノフ/
smith /スミス/
smithsonian /スミソニアン/
smog /スモッグ/
smoke /スモーク/
smokecheese /スモークチーズ/
smokedsalmon /スモークサーモン;smoked salmon/
smoker /スモーカー/
smokesalmon /スモークサーモン;smoked salmon/
smokin /スモーキン;smokin'/
smoking /スモーキング/
smoky /スモーキー/
smooth /スムーズ/スムース/
smoother /スムーサー/
smoothing /スムージング/
smplay /SMプレイ/
sn /スズ/錫/Tin/
snack /スナック/
snake /スネーク/
snakehead /スネークヘッド;蛇頭/
snap /スナップ/
snapbutton /スナップボタン/
snappy /スナッピー/
snapshot /スナップショット/
snare /スネア/
snaredrum /スネアドラム/
snatch /スナッチ/
snatcher /スナッチャー/
snd /サウンド;sound/
sndboard /サウンドボード/
sneak /スニーク/
sneaker /スニーカー/
snell /スネル/
sniff /スニフ/スニッフ/
sniffer /スニファ/スニファー/
snipe /スナイプ/
sniper /スナイパー/
snob /スノッブ/
snobbism /スノビズム/
snobo /スノボ;snowboard/
snoop /スヌープ/
snooping /スヌーピング/
snoopy /スヌーピー/
snooze /スヌーズ/
snore /スノア/
snorkel /シュノーケル/スノーケル/
snorkeling /シュノーケリング/スノーケリング/
snort /スノート/
snow /スノー/
snowball /スノーボール/
snowbird /スノーバード/
snowboard /スノーボード/
snowboarder /スノーボーダー/
snowboat /スノーボート/
snowdrop /スノードロップ/
snowshoe /スノーシュー/
snowtire /スノータイヤ/
snowwhite /スノーホワイト/
snufkin /スナフキン/
so /ソ/ソー/ソウ/
soap /ソープ/
soapland /ソープランド/
soapopera /ソープオペラ/
soarer /ソアラ/
soave /ソアーヴェ/
soccer /サッカー/
soccerball /サッカーボール/
soccerclub /サッカークラブ/
soccerteam /サッカーチーム/
sochi /ソチ/
social /ソーシャル/ソシアル/ソーシアル/
socialdance /ソシアルダンス/ソーシャルダンス/
socialengineering /ソーシャルエンジニアリング/
socialnetwork /ソーシャルネットワーク/
socialnetworking /ソーシャルネットワーキング/
socialworker /ソーシャルワーカー/
societe /ソシエテ/
society /ソサエティ/ソサエティー/
socio /ソシオ/
sociometry /ソシオメトリー/
socket /ソケット/
socks /ソックス/
socrates /ソクラテス/
soda /ソーダ/
sodium /ソディウム;Na/ナトリウム;[元素]11,Na/ソジウム/
sodom /ソドム/
sodomy /ソドミー/
sofa /ソファ/ソファー/
sofabed /ソファベッド/ソファーベッド/
sofia /ソフィア/
sofmap /ソフマップ;www.sofmap.com/
soft /ソフト/ソフトウェア/
softball /ソフトボール/
softbank /ソフトバンク;www.softbank.co.jp/
softcase /ソフトケース/
softcontact /ソフトコンタクト;soft contact lens/
softcontactlens /ソフトコンタクトレンズ/
softcream /ソフトクリーム;和製英語/
softdrink /ソフトドリンク/
softether /ソフトイーサ/
softfocus /ソフトフォーカス/
softhouse /ソフトハウス;和製英語/
softlanding /ソフトランディング/
softlens /ソフトレンズ;soft lens/
softly /ソフトリー/
softsm /ソフトSM/
softsynthe /ソフトシンセ;software synthesizer/
softtennis /ソフトテニス/
softtouch /ソフトタッチ/
software /ソフトウェア/ソフトウエア/
softwarestack /ソフトウェア・スタック/
softwear /ソフトウェア;※software?/
soho /ソーホー/
soir /ソワール;(Fr)夕/
soiree /ソワレ/
sol /ソル/ゾル/ソ/
solanin /ソラニン/
solar /ソーラー/
solarbattery /ソーラーバッテリー/
solarcar /ソーラーカー/
solarhouse /ソーラーハウス/
solaris /ソラリス/Ｓｏｌａｒｉｓ/Solaris/
solarisation /ソラリゼーション/
solarization /ソラリゼーション/
solarpanel /ソーラーパネル/
solarpoewr /ソーラーパワー/
solarsystem /ソーラーシステム/
sold /ソールド/ソルド/
soldier /ソルジャー/
soldiers /ソルジャーズ/
soldout /ソールドアウト/
sole /ソール/ソウル/
soleil /ソレイユ/
solemnis /ソレムニス/
solenoid /ソレノイド/
solfege /ソルフェージュ/
solid /ソリッド/
solidstate /ソリッドステート;solid-state/
solingen /ゾーリンゲン/
solist /ソリスト/
solitaire /ソリティア/
soliton /ソリトン/
solitude /ソリチュード/
sollers /ソレルス/
solo /ソロ/
soloalbum /ソロアルバム/
soloist /ソリスト/
sololive /ソロライブ/
solomon /ソロモン;.sb/
solon /ソロン/
solti /ショルティ/
solution /ソリューション/
solutions /ソリューションズ/
solver /ソルバー/ソルバ/
solzhenitsyn /ソルジェニーツィン/ソルジェニツィン/
soma /ソーマ/
somali /ソマリ/
somalia /ソマリア;.so/
soman /ソマン;(神経ガス)/
sombrero /ソンブレロ/
some /サム/ゾーム;ribosome,lysosome/
someday /サムデイ/サムディ/
somersault /サマーソルト/
somerset /サマセット/
something /サムシング/
sometime /サムタイム/
sommelier /ソムリエ/
sommelierknife /ソムリエナイフ/
sommer /ソマー/
son /サン/ソン;仏語/
sonar /ソナー/
sonata /ソナタ/
sonatine /ソナチネ/
sonde /ゾンデ/
sonet /ソネット;www.so-net.ne.jp/
song /ソング/
songbook /ソングブック/
songs /ソングス/
songwriter /ソングライター/
sonia /ソニア/ソーニャ/
sonic /ソニック/
sonicboom /ソニックブーム/
sonnet /ソネット/
sonny /ソニー/
sono /ソノ;(接頭辞:音)/
sonogram /ソノグラム/
sonority /ソノリティ/
sonosheet /ソノシート;和製英語(sound sheet)/
sontag /ソンタグ/
sony /ソニー/
sonya /ソーニャ/
sonymusic /ソニーミュージック;www.sonymusic.co.jp/
sonynews /ＳＯＮＹ ＮＥＷＳ/
sonyplaza /ソニープラザ;www.sonyplaza.com/
sonyrecord /ソニーレコード/
soon /スーン/
sophia /ソフィア/
sophie /ソフィー/ソフィ/ゾフィー;(独語)/
sophist /ソフィスト/
sophisticate /ソフィスティケート/
sophokles /ソポクレス/ソフォクレス/
sophy /ソフィー/
sopranino /ソプラニーノ/
soprano /ソプラノ/
sopranorecorder /ソプラノリコーダー/
sopranosax /ソプラノサックス/
sor /ソル/
sorbet /ソルベ;(Fr) シャーベット/
sorbit /ソルビット/
sorbitol /ソルビトール/
sorbonne /ソルボンヌ/
sorcerer /ソーサラー/
sorel /ソレル/
soriano /ソリアーノ/
sorkin /ソーキン/
sorrento /ソレント/
sorrow /ソロー/ソロウ/
sorry /ソーリー/
sort /ソート/
sorting /ソーティング/
sortstest /スポーツテスト/
sosa /ソーサ/
sostenuto /ソステヌート/
sotec /ソーテック;www.sotec.co.jp/
sothebys /サザビーズ;Sotheby's. www.sothebys.com/
soto /ソト/
souffle /スフレ/
soul /ソウル/
soulful /ソウルフル/
soulmusic /ソウルミュージック/
sound /サウンド/
soundboard /サウンドボード/
soundcard /サウンドカード/
soundchip /サウンドチップ/
sounddevice /サウンドデバイス/
sounddriver /サウンドドライバ/
soundeffect /サウンドエフェクト/
sounding /サウンディング/
soundnovel /サウンドノベル/
sounds /サウンズ/
soundscape /サウンドスケープ/
soundtrack /サウンドトラック/
soup /スープ/
soupcurry /スープカレー/
soupstock /スープストック/
sour /サワー/
source /ソース/
sourcecode /ソースコード/
sourcefile /ソースファイル/
sourcenext /ソースネクスト;www.sourcenext.com/
sourceprogram /ソースプログラム/
sourcream /サワークリーム/
sousaphone /スーザフォン/
south /サウス/
southampton /サウサンプトン/サザンプトン/
southcarolina /サウスカロライナ;SC/
southdakota /サウスダコタ;SD/
southeast /サウスイースト/
southern /サザン/
southerncross /サザンクロス/
southpaw /サウスポー/
southwest /サウスウエスト/サウスウェスト/
souvenir /スーベニア/スーベニール/スブニール;仏語/スーブニール;仏語/スヴニール/
sovet /ソビエト;совет/
soviet /ソビエト/ソヴィエト/ソ連/
sovkhoz /ソフホーズ/
sow /ソー/ソウ/
sox /ソックス;=socks/
soy /ソイ/
soyuz /ソユーズ/
sp /　;全角スペース/
spa /スパ/
spaak /スパーク/
space /スペース/　;全角スペース/□/スペイス/
spacebar /スペースバー/
spacecolony /スペースコロニー/
spacecraft /スペースクラフト/
spaceinvader /スペースインベーダー;[ゲーム]タイトー/
spacekey /スペースキー/SPACEキー/
spaceopera /スペースオペラ/
spacer /スペーサー/
spaceship /スペースシップ/
spaceshuttle /スペースシャトル/
spacing /スペーシング/
spade /スペード/スペイド/
spaghetti /スパゲティ/スパゲッティ/スパゲティー/スパゲッティー/
spain /スペイン;.es/Ｓｐａｉｎ/西班牙/
spaingp /スペインGP;[F1]/
spam /スパム/
spammail /スパムメール/
spammer /スパマー/
span /スパン/
spandex /スパンデックス/
spangle /スパンコール/スパングル/
spaniel /スパニエル/
spanish /スパニッシュ/スペイン語/
spank /スパンク/
spanking /スパンキング/
spanner /スパナ/
spanning /スパニング/
spar /スパー/
sparc /スパーク/Sparc/
spare /スペア/
sparekey /スペアキー/
sparemint /スペアミント/
sparerib /スペアリブ/
spareribs /スペアリブ/
sparetire /スペアタイヤ/
spark /スパーク/
sparkle /スパークル/
sparkling /スパークリング/
sparklingwine /スパークリングワイン/
sparring /スパーリング/
sparse /スパース/
sparta /スパルタ/
spasiba /スパシーバ;(露語)Спасибо/
spat /スパット/
spats /スパッツ/
spatter /スパッタ/
spattering /スパッタリング/
spatula /スパチュラ/スパテラ/
spaulding /スポルディング/
speak /スピーク/
speaker /スピーカー/スピーカ/
speaking /スピーキング/
spear /スピア/スピアー/
spearmint /スペアミント/
spec /スペック/仕様/
special /スペシャル/
specialguest /スペシャルゲスト/
specialist /スペシャリスト/
speciality /スペシャリティ/スペシャリティー/
specific /スペシフィック/
specification /スペシフィケーション/
specifier /スペシファイア/指示子/
spectacle /スペクタクル/
specter /スペクター/
spector /スペクトル/スペクター/
spectral /スペクトラル/スペクトル;spectre?/
spectre /スペクトル;仏語/
spectrogram /スペクトログラム/
spectrometer /スペクトロメータ;分光計/スペクトロメーター/
spectrum /スペクトラム/スペクトル/
speech /スピーチ/
speed /スピード/
speedball /スピードボール/
speeddown /スピードダウン;和製英語(slow-down)/
speedgun /スピードガン/
speedmeter /スピードメーター/
speedskate /スピードスケート/
speedtest /スピードテスト/
speedup /スピードアップ/
speedway /スピードウェイ/
speedy /スピーディー/スピーディ/
spell /スペル/
spellcheck /スペルチェック/
spellchecker /スペルチェッカー;spelling checker/スペルチェッカ/
spelling /スペリング/
spellmiss /スペルミス;和製英語(misspell)/
spelunker /スペランカー/
spencer /スペンサー/
spenser /スペンサー/
sperma /スペルマ/
sphere /スフィア/スフェア/
sphinx /スフィンクス/
sphynx /スフィンクス;猫/
spica /スピカ/
spice /スパイス/
spicy /スパイシー/
spider /スパイダー/
spider-man /スパイダーマン/
spiderman /スパイダーマン;正しくは"Spider-man"と綴る/
spiegel /シュピーゲル/
spielberg /スピルバーグ/
spike /スパイク/
spiker /スパイカー/
spiketire /スパイクタイヤ/
spill /スピル/
spillover /スピルオーバー/
spin /スピン/
spindle /スピンドル/
spine /スパイン/
spinel /スピネル/
spinet /スピネット/
spinglass /スピングラス/
spinics /スピニクス/
spinlock /スピンロック/
spinner /スピナー/
spinoff /スピンオフ;spin-off/
spinout /スピンアウト/
spinoza /スピノザ/
spiral /スパイラル/
spirit /スピリット/
spirits /スピリッツ/
spiritual /スピリチュアル/
spiritualism /スピリチュアリズム/
spiro /スピロ/
spirochaeta /スピロヘータ/
spirytus /スピリタス;アルコール96度のウォッカ/
spit /スピット/
spitfire /スピットファイア/
spitz /スピッツ;犬/
splash /スプラッシュ/
splatter /スプラッター/スプラッタ/
splay /スプレー;※spRay?/
splice /スプライス/
spline /スプライン/
split /スプリット/
splitter /スプリッタ/スプリッター/
splus /Splus/
spock /スポック/
spode /スポード/
spoil /スポイル/
spoiler /スポイラー/
spoke /スポーク/
spokesman /スポークスマン/
spokesperson /スポークスパーソン/
sponge /スポンジ/
spongecake /スポンジケーキ/
sponsor /スポンサー/
sponsored /スポンサード/
sponsorship /スポンサーシップ/
spoofing /スプーフィング/
spool /スプール/
spooler /スプーラ/
spoon /スプーン/
spore /スポア/
sport /スポーツ/
sportcaster /スポーツキャスター/
sports /スポーツ/スポーツ新聞/
sportsbag /スポーツバッグ/
sportscar /スポーツカー/
sportscaster /スポーツキャスター/
sportscenter /スポーツセンター/
sportsclub /スポーツクラブ/
sportsdrink /スポーツドリンク/
sportsfair /スポーツフェアー/
sportsgym /スポーツジム/
sportskite /スポーツカイト/
sportsman /スポーツマン/
sportsmanship /スポーツマンシップ/
sportsshop /スポーツショップ/
sportswear /スポーツウェア/
sporty /スポーティ/スポーティー/
spot /スポット/スパット;ボウリングの-/
spotlight /スポットライト/
spotter /スポッター/
sprawl /スプロール/
spray /スプレー/
spread /スプレッド/
spreadsheet /スプレッドシート/
sprechchor /シュプレヒコール/
sprecord /SPレコード/
sprice /スプライス;※splice?/
spriggan /スプリガン/
spring /スプリング/
springboard /スプリングボード/
springer /スプリンガー/
springs /スプリングス/
sprinkler /スプリンクラー/
sprint /スプリント/
sprinter /スプリンター/
sprite /スプライト/
sprout /スプラウト/
spuit /スポイト;(蘭語)/
spulse /エスパルス;[Jリーグ](S-pulse) 清水/
spumante /スプマンテ/
spumoni /スプモーニ/
spur /シュプール/スパー/
spurt /スパート/
sputnik /スプートニク/
spy /スパイ/
spyware /スパイウェア/
sq /□/■/
sqrt /√/
squalane /スクワラン;C30H62/
squalene /スクワレン;C30H50/スクアレン/
squall /スコール/
square /スクウェア/スクエア/スクェア/■/□/
squaredance /スクエアダンス/
squareenix /スクウェアエニックス;www.square-enix.com/スクウェア・エニックス/SQUARE ENIX/
squash /スカッシュ/
squashing /スカッシング関数/
squat /スクワット/
squeeze /スクイーズ/スクイズ/
sr /ストロンチウム/Strontium/ステラジアン;立方角の単位,SI基本単位/
sra /Software Research Associate,Inc./
src /ソース/
srcfile /ソースファイル/
srijayawardenepurakotte /スリジャヤワルダナプラコッテ;Sri Jayawardenepura Kotte (スリランカの首都)/
srilanka /スリランカ;.lk/
srinagar /スリナガル;インド(sxr)/
ss /§/
sseki /Ｓ席/
ssize /Sサイズ/Ｓサイズ/
sssize /SSサイズ/ＳＳサイズ/
st /サン;St. (saint)/
stab /スタブ/
stabatmater /スターバトマーテル/
stabiliser /スタビライザー/スタビライザ/
stability /スタビリティ/
stabilizer /スタビライザー/スタビライザ/
stable /ステーブル/
staccato /スタッカート/
stack /スタック/
stackable /スタッカブル/
stackframe /スタックフレーム/
stacking /スタッキング/
stackobject /スタック・オブジェクト/
stackpointer /スタック・ポインタ/
stacy /ステイシー/
stadium /スタジアム/
stadiumjumper /スタジアムジャンパー/スタジャン/
stael /スタール/
staff /スタッフ/
stafford /スタッフォード/スタフォード/
staffroll /スタッフロール/
stage /ステージ/
stagflation /スタグフレーション/
staging /ステージング/
stained /ステンド/
stainedglass /ステンドグラス/
staines /ステイン/ステインズ/
stainless /ステンレス/
stainlesssteel /ステンレススチール/ステンレススティール/
stair /ステア/
stake /ステーク/ステーキ;※steak?/
stakeholder /ステークホルダー/
stakes /ステークス/
stale /ステイル/
stalin /スターリン/
stalingrad /スターリングラード;現Volgograd/
stalk /ストーク/
stalker /ストーカー/
stalking /ストーキング/
stall /ストール/
stallman /ストールマン/
stallon /スタローン/
stamen /スタメン;<和製英語 starting member/
stamina /スタミナ/
stamp /スタンプ/
stamper /スタンパー/
stamping /スタンピング/
stamprally /スタンプラリー;和製英語/
stan /スタン/
stance /スタンス/
stand /スタンド/
standalone /スタンドアロン/スタンドアローン/
standard /スタンダード/標準/
standardnumber /スタンダードナンバー/
standards /スタンダーズ/
standby /スタンバイ/スタンドバイ/
standcollar /スタンドカラー/
standing /スタンディング/
standingovation /スタンディングオベーション/
standoff /スタンドオフ/
standplay /スタンドプレー;和製英語(grandstand)/スタンドプレイ/
standup /スタンドアップ/スタンダップ/
stanford /スタンフォード/スタンフォード大学/
stanislav /スタニスラフ/
stanislaw /スタニスワフ/スタニスラフ/
stanley /スタンリー/スタンレー/スタンリ/
stanza /スタンザ/
staple /ステープル/
stapler /ステープラー/
star /スター/★/☆/＊/STAR/
starboard /スターボード/
starbucks /スターバックス;www.starbucks.com/
starch /スターチ/
stardom /スターダム/
stardust /スターダスト/
starfruit /スターフルーツ/
starfruits /スターフルーツ/
stark /スターク/
starlight /スターライト/
starocean /スターオーシャン/
starr /スター/
starruby /スタールビー/
stars /スターズ/
starship /スターシップ/
start /スタート/
startbit /スタートビット/
startbutton /スタートボタン/
startdash /スタートダッシュ;和製英語/
starter /スターター/スタータ/
starterkit /スターターキット/スタータキット/
starting /スターティング/
startinggrid /スターティンググリッド/
startingmember /スターティングメンバー;和製英語(starting lineup)/
startline /スタートライン/
startmenu /スタートメニュー/
startpage /スタートページ/
startrek /スタートレック/
startup /スタートアップ/
starwars /スターウォーズ/
stat /スタット/
state /ステート/ステイト/
stateful /ステートフル/
statefull /ステートフル;※stateful?/
stateless /ステートレス/
statement /ステートメント/ステイトメント/文/
states /ステイツ/ステーツ/
static /スタティック/静的/
statice /スターチス/
staticlink /スタティックリンク/
statics /スタティックス/
statin /スタチン/
station /ステーション/ステイション/
stationary /ステーショナリー;静止した/
stationery /ステーショナリー/
stationwagon /ステーションワゴン/
status /ステータス/ステイタス/
statusbar /ステータスバー/
statussymbol /ステータスシンボル/
stay /ステイ/スティ/
stayer /ステイヤー/
stdin /標準入力/
stdout /標準出力/
steady /ステディ/
steak /ステーキ/
steal /スチール/スティール/
stealth /ステルス/
steam /スチーム/
steambath /スチームバス/
steamer /スチーマー/
stearin /ステアリン/
steed /スティード/
steel /スチール/スティール/
steeldrum /スチールドラム/スティールドラム/
steelguitar /スチールギター/スティールギター/
steelpan /スティールパン/スチールパン/
steelpipe /スチールパイプ/
steely /スティーリー/
steer /ステア/
steering /ステアリング/
stefan /ステファン/シュテファン/
stefania /ステファニア/
stefanie /ステファニー/
stefano /ステファノ/
stegosaurus /ステゴサウルス/
stein /シュタイン/
steiner /シュタイナー/スタイナー/
steinway /スタインウェイ/
steivie /スティービー/
stella /ステラ/
stello /ステロ/
stem /ステム/シュテム/
stemilion /サンテミリオン;Saint-Emilion/
sten /ステン/
stencil /ステンシル/
stendhal /スタンダール/
stent /ステント/
step /ステップ/ステップ応答/ステップ関数/
stephan /シュテファン/ステファン/スティーブン/
stephane /ステファン/ステファーヌ/
stephanie /ステファニー/
stephanos /ステファノ/
stephen /ステファン/シュテファン/スティーブン/スティーヴン;(英)/ステパノ/
steppe /ステップ/
stepper /ステッパー/
stepping /ステッピング/
steps /ステップス/
stepsize /ステップサイズ/
stepup /ステップアップ/
steradian /ステラジアン;sr/
stereo /ステレオ/
stereogram /ステレオグラム/
stereosound /ステレオサウンド/
stereotype /ステレオタイプ/
sterling /スターリング/スターリン/
sterne /スターン/
steroid /ステロイド/
steroidhormone /ステロイドホルモン;steroid hormone/
sterol /ステロール/
stestephe /サンテステフ;Saint-Estephe/
steve /スティーブ/スティーヴ/
steven /スティーブン/スティーヴン/
stevenson /スティーブンソン/スティーヴンソン/スティーヴンスン/スチーブンソン/
stevia /ステビア/
stevie /スティービー/スティーヴィー/
stew /シチュー/
steward /スチュワード/
stewardess /スチュワーデス/
stewart /スチュワート/
stibium /アンチモン;[元素]51,Sb/
stick /スティック/ステッキ/スティク/
sticker /ステッカー/
sticks /スティックス/
stieglitz /スティグリッツ/スティーグリッツ/
stiffness /スチフネス/
stiglitz /スティグリッツ/
stiletto /スティレット/
still /スティル/スチル/スチール/
stillcamera /スチルカメラ/
stina /スティーナ/
sting /スティング/
stingray /スティングレイ/スティングレー/
stirling /スターリング/
stitch /ステッチ/スティッチ/
stjulien /サンジュリアン;Saint-Julien/
stk /STk/
stlouis /セントルイス;St.Louis/
stoa /ストア/
stock /ストック/
stocker /ストッカー/
stockhausen /シュトックハウゼン/
stockholm /ストックホルム/
stocking /ストッキング/
stockings /ストッキング/
stockoption /ストックオプション/
stockyard /ストックヤード/
stoic /ストイック/
stoke /ストーク/
stokes /ストークス/
stole /ストール/
stollen /シュトーレン;(独)クリスマスケーキ/シュトレン/
stolon /ストロン/
stomach /ストマック/
stone /ストーン/
stonecircle /ストーンサークル/
stonehenge /ストーンヘンジ/
stones /ストーンズ/
stool /スツール/
stop /ストップ/
stopbit /ストップビット/
stopmotion /ストップモーション/
stopper /ストッパー/
stopwatch /ストップウォッチ/
stopword /ストップワード/
storage /ストレージ/ストーレジ;<rare>/
storagedevice /ストレージデバイス/
storagemedia /ストレージメディア/
store /ストア/ストアー/
stored /ストアド/
storethrough /ストアスルー/
storey /ストーリー/ストーリィ/
stories /ストーリーズ/
storm /ストーム/シュトルム;人名/
stormbringer /ストームブリンガー/
storming /ストーミング/
stormy /ストーミー/
story /ストーリー/ストーリ/
storyteller /ストーリーテラー/
storytelling /ストーリーテリング/
stout /スタウト/
stove /ストーブ/ストーヴ/
stoveleague /ストーブリーグ/
stradivari /ストラディバリ/ストラディヴァリ/
stradivarius /ストラディバリウス/ストラディヴァリウス/
straight /ストレート/ストレイト/
straightcable /ストレートケーブル/
straighthair /ストレートヘア/
straightjuice /ストレートジュース/
straightperm /ストレートパーマ/
straightperma /ストレートパーマ/
strainer /ストレーナー/ストレーナ/
strange /ストレンジ/
stranger /ストレンジャー/
strap /ストラップ/
strapless /ストラップレス/
strasbourg /ストラスブール/
strategist /ストラテジスト;戦略家/
strategy /ストラテジー/ストラテジ/
stratos /ストラトス/
strauss /シュトラウス/ストロース/
stravinsky /ストラヴィンスキー/ストラビンスキー/
straw /ストロー/
strawberry /ストロベリー/
strawberryjam /ストロベリージャム/
stray /ストレイ/
straysheep /ストレイシープ/
streak /ストリーク/
streaking /ストリーキング/
stream /ストリーム/
streamer /ストリーマー/ストリーマ/
streaming /ストリーミング/
street /ストリート/
streetchildren /ストリートチルドレン/
streetfashion /ストリートファッション/
streetfighter /ストリートファイター/
streetlive /ストリートライブ/
streetmusician /ストリートミュージシャン/
strelitzia /ストレリチア/
strength /ストレングス/
streptomycin /ストレプトマイシン/
stress /ストレス/
stressor /ストレッサー/
stretch /ストレッチ/
stretcher /ストレッチャー/
stretching /ストレッチング/
strict /ストリクト/
stride /ストライド/
strider /ストライダー/
strike /ストライク/ストライキ/
striker /ストライカー/
strikezone /ストライクゾーン/
strindberg /ストリンドベリ/
string /ストリング/文字列/
strings /ストリングス/
strip /ストリップ/
stripe /ストライプ/
stripes /ストライプス/
striping /ストライピング/
stripper /ストリッパー/
stripping /ストリッピング/
stripshow /ストリップショー/
strobe /ストローブ/
strobo /ストロボ/
stroganoff /ストロガノフ/
stroke /ストローク/
strokeplay /ストロークプレー/
stromatolite /ストロマトライト/
strong /ストロング/
strontium /ストロンチウム;[元素]38,Sr/
struckout /ストラックアウト/
struct /ストラクト/構造体/
structure /ストラクチャ/ストラクチャー/
strut /ストラット/
strychnine /ストリキニーネ/
stuart /スチュアート/スチュワート/
stub /スタブ/
stucco /スタッコ/
stuck /スタック/
stud /スタッド/
student /スチューデント/
studies /スタディーズ/
studio /スタジオ/ステュディオ;仏語/
studioghibli /スタジオジブリ;Studio Ghibli/
studiolive /スタジオライブ/
studiomusician /スタジオミュージシャン/
studium /スタジアム/
studless /スタッドレス/
studlesstire /スタッドレスタイヤ/
study /スタディー/スタディ/
stuff /スタッフ/
stuffed /スタッフド/
stun /スタン/
stungun /スタンガン/
stunt /スタント/
stuntman /スタントマン/
sturges /スタージェス/
sturm /シュトルム/
stuttgart /シュツットガルト/シュトゥットガルト/
sty /スタイル/
style /スタイル/
stylebook /スタイルブック/
styleguide /スタイルガイド/
stylesheet /スタイルシート/
styling /スタイリング/
stylish /スタイリッシュ/
stylist /スタイリスト/
stylus /スタイラス/
styluspen /スタイラスペン/
styrene /スチレン;C8H8/
styrol /スチロール/
styx /スティクス/ステュクス/
su /スーパーユーザ/スーパユーザ/
suarez /スアレス/
sub /サブ/部分/
subaddress /サブアドレス/
subbag /サブバッグ/
subblock /サブブロック/
subcategory /サブカテゴリ/サブカテゴリー/
subclass /サブクラス/
subcul /サブカル;subculture/
subculture /サブカルチャー/
subdirectory /サブディレクトリ/
subdomain /サブドメイン/サブドメーン;<rare>/
subdominant /サブドミナント/
subfolder /サブフォルダ/
subgoal /サブゴール/
subgraph /サブグラフ/
subgroup /サブグループ/
subheader /サブヘッダ/
subject /サブジェクト/
subleader /サブリーダー/
sublime /サブライム/
subliminal /サブリミナル/
submachine /サブマシン/
submap /サブマップ/
submarine /サブマリン/
submaster /サブマスター/
submenu /サブメニュー/
submission /サブミッション/
submit /サブミット/
submodel /サブモデル/
subnet /サブネット/
subnetmask /サブネットマスク/
subnetting /サブネッティング/
subnetwork /サブネットワーク/
subnote /サブノート/
subpattern /サブパターン/
subprocess /サブプロセス/
subprogram /サブプログラム/
subroutine /サブルーチン/
subscribe /サブスクライブ/
subscript /サブスクリプト/
subscription /サブスクリプション/
subset /サブセット/⊂/
subseteq /⊆/
subshell /サブシェル/
subsite /サブサイト/
substitute /置換/
subsystem /サブシステム/
subtheme /サブテーマ/
subtitle /サブタイトル/
subtraction /サブトラクション/
subtype /サブタイプ/
subunit /サブユニット/
suburban /サバーバン/
suburbia /サバービア/
subway /サブウェイ/
succeed /サクシード/
success /サクセス/
succession /サクセション/
successstory /サクセスストーリー/
succubus /サキュバス/
such /サッチ/
suck /サック/
sucker /サッカー/
sucralose /スクラロース/
sucre /スクレ/シュクル;(Fr) 砂糖/
sucrer /シュクレ;仏語/
sucrose /スクロース/サッカロース/
sudan /スーダン;.sd/
sudden /サドン/
suddendeath /サドンデス/
sudra /スードラ/シュードラ/
sue /スー/シュー/スウ/スゥ/
suede /スエード/
suesan /スーザン;※susan?/
suez /スエズ/
suffix /サフィックス/拡張子/添字/
sufi /スーフィー/スーフィ/
sufism /スーフィズム/
sug /サン・ユーザ・グループ/
sugar /シュガー/
sugarcraft /シュガークラフト;sugar craft/
sugarmilk /シュガーミルク/
sugarpot /シュガーポット/
suggest /サジェスト/
suggestion /サジェスチョン/
suharto /スハルト/
suica /スイカ/
suicide /スーサイド/
suisse /スイス/
suit /スーツ/スート/
suitcase /スーツケース/
suite /スイート/スート;カードの-/スィーツ/
suiteroom /スイートルーム/
suits /スーツ/
suitscase /スーツケース/
suleyman /スレイマン/
sulfa /サルファ/
sulfate /サルフェート/
sulfide /サルファイド;硫化/スルフィド/
sulfite /サルファイト;亜硫酸/
sulfone /スルホン/
sulfoxide /スルホキシド/
sulfur /サルファ;S/サルファー/
sullivan /サリヴァン/サリバン/
sully /シュリ/シュリー/
sulphate /サルフェート;硫酸/
sulphide /サルファイド;硫化/スルフィド/
sulphite /サルファイト;亜硫酸/
sulphur /サルファ;S/サルファー/
sultan /サルタン/スルタン/スルターン/
sum /サム/∪/スム;ラテン語/
sumatra /スマトラ/
sumer /シュメール/
summarize /サマライズ/
summary /サマリー/サマリ/
summer /サマー/
summercamp /サマーキャンプ/
summersale /サマーセール/
summertime /サマータイム/
summit /サミット/
sun /サン/日/Ｓｕｎ/ｓｕｎ/Sun/ＳＵＮ/
sun3 /Ｓｕｎ３/
sun4 /Ｓｕｎ４/
sundae /サンデー/
sundance /サンダンス/
sunday /サンデー/サンディ/サンディー/サンデイ/
sundeck /サンデッキ/
sundress /サンドレス/
sune /スネ/
sunflower /サンフラワー/
sunglass /サングラス/
sunglasses /サングラス/
sunkist /サンキスト;www.sunkist.com/
sunkus /サンクス;www.sankus.co.jp/
sunlight /サンライト/
sunmusic /サン・ミュージック/
sunna /スンナ;[イスラム]慣習法/
sunnet /ＳｕｎＮｅｔ/
sunni /スンニ/スンニー/
sunny /サニー/
sunnylettuce /サニーレタス/
sunnyside /サニーサイド/
sunoil /サンオイル/
sunos /ＳｕｎＯＳ/SunOS/
sunrise /サンライズ/
sunroof /サンルーフ/
sunroom /サンルーム/
sunset /サンセット/
sunshine /サンシャイン/
sunstar /サンスター;www.sunstar.com/
suntory /サントリー;www.suntory.co.jp/
suntoryhall /サントリーホール/
sunview /ＳｕｎＶｉｅｗ/
sunvisor /サンバイザー/
suomi /スオミ;フィンランド/
super /スーパー/スーパ/
superascii /ＳｕｐｅｒＡｓｃｉｉ/
superball /スーパーボール;和製英語/
superbowl /スーパーボウル/スーパーボール/
supercar /スーパーカー/
superclass /スーパークラス/スーパクラス/
supercom /スパコン;super computer/
supercomputer /スーパーコンピュータ/スーパーコンピューター/
superdry /スーパードライ;[商標]アサヒビール/
superfine /スーパーファイン/
superhero /スーパーヒーロー/
superimpose /スーパーインポーズ/
superior /スーペリア/スペリオール/スペリオル/
superiore /スペリオーレ/
superkamiokande /スーパーカミオカンデ/
superman /スーパーマン/
supermarket /スーパーマーケット/
supermodel /スーパーモデル/
supermulti /スーパーマルチ/
superoption /スーパーオプション/
superpower /スーパーパワー/
superrealism /スーパーリアリズム/
superrich /スーパーリッチ/
superscalar /スーパースケーラ/スーパスカラ/スーパースカラ/スーパースカラー/スーパースケーラー/
superscaler /スーパースケーラ;※scalar/
superset /⊃/スーパーセット/
superseteq /⊇/
supersize /スーパーサイズ/
superstar /スーパースター/
superuser /スーパーユーザー/スーパーユーザ/スーパユーザ/
supervielle /シュペルヴィエル/
supervisor /スーパバイザ/
superwoofer /スーパーウーファー/
suplex /スープレックス/
suppe /スッペ/
supper /サパー/
supple /サプリ;supplement/
supplement /サプリメント/
supplier /サプライヤー/サプライヤ/サプライア/
supplies /サプライズ/
supply /サプライ/
supplychain /サプライチェーン/
supplyside /サプライサイド/
suppocen /サポセン;supportcenter/
support /サポート/
supportcenter /サポートセンター/サポセン/
supportcentre /サポートセンター/サポセン/
supporter /サポーター/
supportmember /サポートメンバー/
supportpage /サポートページ/
suppress /サプレス/
supra /スープラ/
supremacy /スプレマシー/
supreme /シュープリーム/シュプリーム/
supset /⊃/
supseteq /⊇/
suq /スーク/
sur /シュール;仏語/サー/
surabaya /スラバヤ/
surcharge /サーチャージ/
surdo /スルド/
sure /シュア/
surf /サーフ/
surface /サーフェス/サーフェイス/サーフィス/
surfboard /サーフボード/
surfer /サーファー/
surfing /サーフィン/
surinam /スリナム/
suriname /スリナム;.sr/
surpass /サーパス/
surplus /サープラス/
surprise /サプライズ/
surrealisme /シュールレアリスム/
surrealiste /シュールレアリスト/
surrender /サレンダー/
surrogate /サロゲート/
surround /サラウンド/
surroundspeaker /サラウンドスピーカー/
surveillance /サーベイランス/
survey /サーベイ/
surveyor /サーベイヤー/
survival /サバイバル/
survivalgame /サバイバルゲーム/
survivalknife /サバイバルナイフ/
survive /サヴァイヴ/サバイブ/
survivor /サバイバー/
susa /スーサ/
susan /スーザン/
susanna /スザンナ/
susannah /スザンナ/
susanne /スザンヌ/
susceptance /サセプタンス/
susie /スージー/
suspend /サスペンド/
suspended /サスペンデッド/
suspender /サスペンダー/
suspense /サスペンス/
suspension /サスペンション/
sussex /サセックス/
sustain /サステイン/
sustainable /サステイナブル/サステナブル/
sutherland /サザーランド/
sutra /スートラ/
suva /スヴァ/
suzanne /スザンヌ/シュザンヌ/
suzdal /スーズダリ/
suzie /スージー/
suzy /スージー/
sven /スヴェン/スベン/
svetlana /スベトラーナ/
svyatoslav /スヴャトスラフ/
sw /┐;罫線/┓;太い罫線/
swallow /スワロー/
swallows /スワローズ/
swamp /スワンプ/
swan /スワン/
swanee /スワニー/
swap /スワップ/
swapfile /スワップファイル/
swapout /スワップアウト/
swapper /スワッパ/
swapping /スワッピング/
swarovski /スワロフスキー/
swatch /スウォッチ;www.swatch.com/
sway /スウェー/スウェイ/
swaziland /スワジランド/
sweat /スウェット/
sweater /セーター/
sweatshirt /スウェットシャツ/
sweatshirts /スウェットシャツ/
sweden /スウェーデン;.se/スエーデン/
sweep /スイープ/スウィープ/
sweeper /スイーパー/
sweet /スイート/スウィート/
sweetcorn /スイートコーン/
sweetheart /スウィートハート/スイートハート/
sweethome /スイートホーム/スウィートホーム/
sweetie /スウィーティー/
sweetpea /スイートピー;sweet pea/
sweetpotato /スイートポテト/スウィートポテト/
sweets /スイーツ/スウィーツ/
sweetspot /スイートスポット/スウィートスポット/
swell /スウェル/
swift /スイフト/スウィフト/
swim /スイム/
swimmer /スイマー/
swimming /スイミング/スウィミング/スィミング/
swimmingpool /スイミングプール/
swimmingschool /スイミングスクール/
swimwear /スイムウェア/
swing /スイング/スウィング/
swingby /スイングバイ/
swingjazz /スウィングジャズ/スイングジャズ/
swingout /スウィングアウト/スイングアウト/
swingy /スウィンギー/スインギー/
swiss /スイス/瑞西/
switch /スイッチ/スィッチ/
switcher /スイッチャー/
switchhitter /スイッチヒッター/
switching /スイッチング/
switchinghub /スイッチングハブ/
switchoff /スイッチオフ/
switchon /スイッチオン/
switzerland /スイス;.ch/
swizzling /シズリング/
sword /ソード/
swordfish /ソードフィッシュ/
syan /シアン/
sybil /シビル/
sybilla /シビラ/
sydney /シドニー/
syllable /シラブル/
syllabus /シラバス/
sylph /シルフ/
sylpheed /シルフィード/
sylvain /シルヴァン/シルバン/
sylvester /シルヴェスター/
sylvia /シルビア/シルヴィア/
sylvie /シルヴィ/シルヴィー/
symantec /シマンテック/
symbol /シンボル/
symbolcolor /シンボルカラー/
symbolcolour /シンボルカラー/
symbolic /シンボリック/
symbolic-link /シンボリック・リンク/
symboliclink /シンボリックリンク/シンボリック・リンク/
symbolise /シンボライズ/
symbolism /シンボリズム/
symbolisme /サンボリスム;象徴派/
symbolize /シンボライズ/
symbolmark /シンボルマーク/
symlink /シンボリックリンク/
symmetric /シンメトリック/
symmetrical /シンメトリカル/
symmetry /シンメトリー/
symonds /シモンズ/
symons /シモンズ/
sympa /シンパ/
sympathy /シンパシー/
symphonia /シンフォニア/
symphonic /シンフォニック/
symphony /シンフォニー/
sympo /シンポ/
symposium /シンポジウム/
synagogue /シナゴーグ/
synaps /シナプス;※synapse/
synapse /シナプス/
sync /シンク/
synch /シンク/
synchro /シンクロ;synchronise(d)/
synchronise /シンクロナイズ/
synchronised /シンクロナイズド/
synchronize /シンクロナイズ/
synchronized /シンクロナイズド/
synchronizing /シンクロナイジング/
synchronous /シンクロナス/
synchrotron /シンクロトロン/
syncopation /シンコペーション/
syndicate /シンジケート/
syndrome /シンドローム/
synergy /シナジー/
synonym /シノニム/
synopsis /シノプシス/
syntactic /シンタクティック/
syntax /シンタックス/シンタクス/
synth /シンセ/
synthe /シンセ/
synthese /ジンテーゼ/
synthesize /シンセサイズ/
synthesizer /シンセサイザー/シンセサイザ/
syphon /サイフォン/サイホン/
syrah /シラー/
syren /サイレン/セイレーン/セイレン/
syria /シリア;.sy/
syringe /シリンジ/
syrinx /シリンクス/シュリンクス/
syrup /シロップ/
sys /シス/
sysad /シスアド/システムアドミニストレータ;※abbrev/
syslab /シスラボ/
sysop /シスオペ;system operator/
system /システム/
system5 /システム５/
systemadministrator /システムアドミニストレータ/
systematic /システマティック/
systembath /システムバス/
systembus /システムバス/
systemcall /システムコール/
systemclock /システムクロック/
systemdisk /システムディスク/
systemdown /システムダウン/
systemengineer /システムエンジニア;SE/
systemengineering /システムエンジニアリング/
systemerror /システムエラー/
systemfile /システムファイル/
systemkitchen /システムキッチン;和製英語/
systems /システムズ/
systemtest /システムテスト/
systollic /シストリック/
systollicarray /シストリックアレイ/
sysv /ＳｙｓＶ/
szymanowski /シマノフスキ/シマノフスキー/
t /τ;tau/ティー/т;te (cyrillic)/〒;zip/├;罫線/┬/┤/┴/┣/┳/┫/┻/┠/┯/┨/┷/┝/┰/┥/┸/
t-shirt /Ｔシャツ/
ta /タンタル/Tantalum/
taart /タルト;(蘭語)/
tab /タブ/
tabacco /タバコ/
tabaco /タバコ/
tabasco /タバスコ/
tabbrowser /タブブラウザ/
tabitha /タバサ/
tabkey /TABキー/タブキー/
tabl /タブル/
tabla /タブラ/
tablature /タブラチュア/
table /テーブル/表/ターブル;仏語/
tableau /タブロー/
tableaux /タブロー/
tablecloth /テーブルクロス/
tablegame /テーブルゲーム/
tablemanner /テーブルマナー/
tablet /タブレット/
tabletalk /テーブルトーク/
tabletennis /テーブルテニス/
tabletop /テーブルトップ/
tabletpc /タブレットPC/
tablette /タブレット;仏語/
tableware /テーブルウェア/
tablewine /テーブルワイン/
tabloid /タブロイド/
taboo /タブー/
tabor /テーバー/
tabriz /タブリーズ/
tabu /タブー;(ポリネシア語)/
tabun /タブン;(神経ガス)/
tac /TAC/
tachometer /タコメーター/タコメータ/
tachyon /タキオン/
tack /タック/
tackle /タックル/
tacoma /タコマ/
tacos /タコス/
tactic /タクティック/
tactical /タクティカル/
tactics /タクティクス/
tadzhik /タジク/
tadzhikistan /タジキスタン/
taekwondo /テコンドー/
tafeta /タフタ/
taffy /タフィー/タフィ/トフィー/
tag /タグ/タッグ/Ｔａｇ/
tagalog /タガログ/
tagheuer /タグホイヤー;www.tagheuer.com/タグ・ホイヤー/
tagliatelle /タリアテッレ/
tagliolini /タリオリーニ/
tagmatch /タッグマッチ/
tagore /タゴール/
tahiti /タヒチ/
taiga /タイガ;(露語)тайга/
tail /テイル/テール/
tailend /テールエンド/
taillamp /テールランプ/
tailor /テーラー/テイラー/
tailored /テーラード/
tailormade /テーラーメイド/テーラーメード/
tailsoup /テールスープ/
taine /テーヌ/
tains /テインズ/TAINS/
taito /タイトー;www.taito.co.jp/タイト/
taiwan /タイワン/台湾/
tajikistan /タジキスタン;.tj/
tajmahal /タージマハル;Taj Mahal/
tajo /タホ/
take /テイク/
takeback /テイクバック/テークバック/
takeoff /テイクオフ/
takeout /テイクアウト;take-out/
taklamakan /タクラマカン;Takla Makan/タクラマカン砂漠/
takt /タクト/
tal /タル/
tala /ターラ/
talas /タラス/
talc /タルク/
tale /テイル/テール/
talent /タレント/
tales /テイルズ/
taliban /タリバン/タリバーン/
talisman /タリスマン/
talk /トーク/
talker /トーカ/
talkevent /トークイベント/
talkie /トーキー/
talking /トーキング/
talkingdrum /トーキングドラム/
talklive /トークライブ/
talkshow /トークショー/トークショウ/
tall /トール/
tallcase /トールケース/
tallinn /タリン/
tallis /タリス/
talmud /タルムード/
talon /タロン/
tam /タム/
tamar /タマル/
tamara /タマラ/タマーラ/
tamarin /タマリン/
tamarind /タマリンド/
tambora /タンボラ/
tambourine /タンバリン/
tambura /タンブーラ/
tami /タミ/
tamiflu /タミフル;抗インフルエンザ薬/
tamil /タミル/
tammy /タミー/
tampa /タンパ/
tampere /タンペレ/
tampon /タンポン/
tamtam /タムタム/
tan /タン/
tanbur /タンブール/
tandem /タンデム/
tandoori /タンドリー/
tandoorichicken /タンドリーチキン/
tanga /タンガ/
tangent /タンジェント/
tangerine /タンジェリン/
tango /タンゴ/
tangor /タンゴール/
tangram /タングラム/
tania /タニア/
tank /タンク/
tanker /タンカー/
tankini /タンキニ;tanktop + bikini/
tanklorry /タンクローリー/
tanktop /タンクトップ/
tannat /タナ/
tannhauser /タンホイザー/
tannin /タンニン/
tano /タノ/
tanqueray /タンカレー/
tantal /タンタル;Ta/
tantalos /タンタロス/
tantalum /タンタル;[元素]73,Ta/
tanto /タント;(It)たくさん/
tantra /タントラ/
tanya /ターニャ/タニア/
tanzania /タンザニア;.tz/
tanzanite /タンザナイト/
tap /タップ/
tapdance /タップダンス/
tapdancer /タップダンサー/
tape /テープ/テイプ/
tapecut /テープカット/
tapedrive /テープドライブ/
taperecorder /テープレコーダー/テープレコーダ/
tapestry /タペストリー/タペストリ/タピストリー/タピストリ/
tapia /タピア/
taping /テーピング/
tapio /タピオ/
tapioca /タピオカ/
tapper /タッパー;[商標]www.tapperware.com/タッパ/
tapperware /タッパーウェア;[商標]www.tapperware.com/
tapping /タッピング/
tar /タール/
tara /タラ/
tarantella /タランテラ/
tarantino /タランティーノ/
tarantula /タランチュラ/
taras /タラス/
tarawa /タラワ/
target /ターゲット/
targeting /ターゲティング/ターゲッティング/
tariff /タリフ/
tarim /タリム/
tarkovskii /タルコフスキー/
tarot /タロット/
tarotcard /タロットカード/
tart /タルト/トルテ/
tartan /タータン/
tartancheck /タータンチェック/
tartar /タルタル/
tartaresauce /タルタルソース/
tartaresteak /タルタルステーキ/
tartaros /タルタロス/
tartarsauce /タルタルソース/
tartarsteak /タルタルステーキ/
tarte /タルト/
tartelette /タルトレット/
taru /タル/
tarzan /ターザン/
tasha /ターシャ/
tashkent /タシケント/
task /タスク/
taskbar /タスクバー/
taskforce /タスクフォース/
tasking /タスキング/
taskmanager /タスクマネージャ/タスクマネージャー/
tasman /タスマン/
tasmania /タスマニア/
tasmanian /タスマニアン/
tasse /タス;(Fr) 茶碗/
tassel /タッセル/
taste /テイスト/ティスト/テースト/
tasting /テイスティング/
tasty /テイスティ/
tatar /タタール/
tatarstan /タタルスタン/
tate /テート/テイト/│;罫線/┃;太い罫線/
tatiana /タチアナ/
tatoo /タトゥー/タトゥ/
tatum /テイタム/テータム/
tatyana /タチアナ/
tau /τ/タウ/
taurine /タウリン/
taurus /トーラス;牡牛座/タウラス/
taut /タウト/
tautology /トートロジー/
tautou /トトゥ/
taverna /タベルナ/タヴェルナ/
tax /タックス/
taxane /タキサン/
taxanswer /タックスアンサー;www.taxanser.nta.go.jp/
taxhaven /タックスヘイブン/
taxi /タクシー/
taxy /タクシー/
taxydriver /タクシードライバー/
taylor /テイラー/
tb /テルビウム/Terbium/
tback /Ｔバック/Tバック/ティーバック/
tbilisi /トビリシ/
tc /テクネチウム/Technetium/
tchad /チャド/
tchaikovsky /チャイコフスキー/
tcode /T-Code/Tコード/
tcp /ＴＣＰ／ＩＰ/TCP/
tcpip /ＴＣＰ／ＩＰ/
te /т;cyrillic/テルル/Tellurium/
tea /ティー/ティ/テア/
teabag /ティーバッグ/
teacher /ティーチャー/
teaching /ティーチング/
teacup /ティーカップ/
teak /チーク/
team /チーム/
teamcolor /チームカラー/
teamcolour /チームカラー/
teamer /チーマー/
teamleader /チームリーダー/
teammate /チームメイト/チームメート/
teamplay /チームプレー/チームプレイ/
teamwork /チームワーク/
teaparty /ティーパーティー/
teapot /ティーポット/
tear /ティア/ティアー/
teardrop /ティアドロップ/
tearoom /ティールーム/
tears /ティアーズ/
teaserver /ティーサーバー/
teaset /ティーセット/
teaspoon /ティースプーン/
teatime /ティータイム/
teatro /テアトロ/
tech /テック/テク;technology/
technetium /テクネチウム;[元素]43,Tc/
technic /テクニック/
technica /テクニカ/
technical /テクニカル/
technicalengineer /テクニカルエンジニア/
technicalsupport /テクニカルサポート/
technician /テクニシャン/
technique /テクニック/
techno /テクノ/
technocrat /テクノクラート/
technologies /テクノロジーズ/
technology /テクノロジー/テクノロジ/
technopolis /テクノポリス/
technopop /テクノポップ;techno-pop/
technosterss /テクノストレス/
technostress /テクノストレス;techno-stress/
tectonics /テクトニクス/
ted /テッド/
tedd /テッド/
teddy /テディ/
teddybear /テディベア/
tee /ティー/
teen /ティーン/
teenage /ティーンエイジ/
teenager /ティーンエイジャー/ティーンエージャー/
teens /ティーンズ/
teeshot /ティーショット/
teeth /ティース/
teeup /ティーアップ/
teflon /テフロン/
tegucigalpa /テグシガルパ/
teheran /テヘラン/
tehran /テヘラン/
tektro /テクトロ/
tel /テル/電話/電話番号/Ｔｅｌ/TEL/
telaviv /テルアビブ;イスラエル(tlv)/
tele /テレ/
teleca /テレカ;telephone card/
telecom /テレコム/
telecommunication /テレコミュニケーション/
telekinesis /テレキネシス/
telemann /テレマン/
telemark /テレマーク/
telemarker /テレマーカー/
telemeter /テレメータ/テレメーター/
telemetry /テレメトリ/テレメトリー/
telepath /テレパス/
telepathy /テレパシー/
telephone /テレホン/テレフォン/
telephonecard /テレホンカード/テレフォンカード/
telephoneservice /テレホンサービス/テレフォンサービス/
telephony /テレフォニー/
teleport /テレポート/
telescope /テレスコープ/
telescopic /テレスコピック/
telesis /テレシス/
teletype /テレタイプ/
televi /テレビ;television/
televicamera /テレビカメラ/
televigame /テレビゲーム/
television /テレビジョン/テレビ/
telework /テレワーク/
telex /テレックス/
tell /テール/テル/
teller /テラー/
telling /テリング/
tellurium /テルル;[元素]52,Te/
telly /テリー/
telnet /テルネット/
telomere /テロメア/
telop /テロップ/
tema /テーマ;?/
temp /テンプ/テンポラリ/temporary/
tempera /テンペラ/
tempering /テンパリング/
tempest /テンペスト/
templa /テンプレ/
template /テンプレート/テンプレイト/
temple /テンプル/
templete /テンプレート;※template/
tempo /テンポ/
temporal /テンポラル/
temporary /テンポラリ/テンポラリー/
tempranillo /テンプラニーリョ/
ten /テン/・/
tenant /テナント/
tender /テンダー/
tenkey /テンキー/
tenn /テン/
tennessee /テネシー;TN/
tennis /テニス/
tennisball /テニスボール/
tenniscircle /テニスサークル/
tennisclub /テニスクラブ/
tenniscourt /テニスコート/
tennisracket /テニスラケット/
tennisshoes /テニスシューズ/
tenniswear /テニスウェア/
tennyson /テニスン/テニソン/
tenochtitlan /テノチティトラン/
tenor /テナー/テノール/
tenorsax /テナーサックス/
tense /テンス/
tenshan /テンシャン/
tension /テンション/
tensor /テンソル/
tent /テント/
tentative /テンタティブ/試験的/
tenten /…/・・・;中黒x3/
tenth /テンス/
tenuto /テヌート/
teo /テオ/
tequila /テキーラ/
tera /テラ;[SI接頭語]T,10^12/
terabyte /テラバイト/
terabytes /テラバイト/
terbium /テレビウム;[元素]65,Tb/
tercel /ターセル;[商標]トヨタ/
terence /テレンス/
teresa /テレサ/
term /ターム/用語/
terminal /ターミナル/端末/
terminaladapter /ターミナルアダプタ/ターミナルアダプター/
terminalcare /ターミナルケア/
terminalemulator /ターミナルエミュレータ/
terminate /ターミネート/ターミネイト/
termination /ターミネーション/
terminator /ターミネーター/ターミネータ/ターミネイタ/
tero /テロ/
terpen /テルペン/
terpene /テルペン/
terpenoid /テルペノイド/
terra /テラ/
terrace /テラス/
terracehouse /テラスハウス/
terracotta /テラコッタ/
terraforming /テラフォーミング/
terrain /テレイン/
terrarium /テラリウム/
terrence /テレンス/
terrier /テリア;犬/
terrine /テリーヌ/
territory /テリトリー/
terror /テロ/テラー/テロル/
terrorism /テロリズム/
terrorist /テロリスト/
terry /テリー/
tess /テス/
tessa /テッサ/
test /テスト/試験/
testarossa /テスタロッサ;[商標]Ferrari/
testcase /テストケース/
testdata /テストデータ/
testdriver /テストドライバー/
tester /テスター/テスタ/
testing /テスティング/
testmail /テストメール/
testosterone /テストステロン/
testpattern /テストパターン/
testrun /テストラン/
testset /テストセット/
tethering /テザリング/
tetra /テトラ;4/
tetrachloroethylene /テトラクロロエチレン;C2Cl4/
tetris /テトリス/
tetrodotoxin /テトロドトキシン;フグ毒/
tex /テフ/テックス/テック/ＴｅＸ/ＴEＸ/TeX/\TeX/
texas /テキサス/
texel /テクセル/
texinfo /Texinfo/
text /テキスト/テクスト/文字列/教科書/
textarea /テキストエリア/
textbook /テキストブック/
textbox /テキストボックス/
textdata /テキストデータ/
texte /テクスト;仏語/
texteditor /テキストエディタ/
textfield /テキストフィールド/
textfile /テキストファイル/
textile /テキスタイル/
textual /テクスチュアル/
texture /テクスチャ/テクスチャー/テキスチャ;<rare>/
textwidget /テキスト・ウィジット/
th /θ;theta/トリウム/Thorium/ス;(接尾辞)fifth,length/
thai /タイ/
thaibaht /タイバーツ/
thailand /タイランド;.th/タイ/
thais /タイス/
thalassa /タラサ/
thalassotherapie /タラソテラピー/
thales /タレス/タレース/
thalia /タリア/
thalidomide /サリドマイド/
thallium /タリウム;[元素]81,Tl/
thames /テムズ/テームズ/
than /ザン/
thanatos /タナトス/
thank /サンク/
thanks /サンクス/
thanksgiving /サンクスギビング;感謝祭/
thankyou /サンキュー/
thar /タール/
that /ザット/
that's /ザッツ/
thatcher /サッチャー/
thats /ザッツ;that's/
the /ザ/ジ/
thea /テア/
theater /シアター/
theatre /テアトル/シアター/
thebai /テーバイ/テバイ/テーベ/
thebes /テーベ/
thebestten /ザ・ベストテン/
thehague /ヘーグ;the Hague/
theirs /ゼアーズ/
thelma /セルマ/テルマ/
thelonious /セロニアス/
them /ゼム/
thema /テーマ;(独)/
theme /テーマ/
themepark /テーマパーク/
themesong /テーマソング/
themis /テミス/
then /ゼン/
theo /テオ/セオ/
theobromine /テオブロミン/
theodor /テオドール/シオドア/テオドル/
theodore /テオドール/セオドア/シオドア/
theophil /テオフィル/
theophile /テオフィル/
theophylline /テオフィリン/
theory /セオリー/
theos /テオス;神(θεοσ)/
therapist /セラピスト/テラピスト/
therapy /セラピー/テラピー/
there /ゼア/
therefore /∴/
theremin /テルミン/
theresa /テレサ/テリーサ/
therese /テレーズ/テレーゼ/
theresia /テレジア/
thermal /サーマル/
thermidor /テルミドール/
thermo /サーモ/
thermograph /サーモグラフ/
thermography /サーモグラフィー/サーモグラフィ/
thermometer /サーモメーター/
thermostat /サーモスタット/
theron /セロン/
thesaurus /シソーラス/
these /テーゼ/
theseus /テセウス/
thessalia /テッサリア/
thessalonica /テサロニケ/テサロニカ/
thessaloniki /テサロニケ/テサロニキ/
theta /θ/シータ/
thetelevision /ザ・テレビジョン/
thetis /テティス/
they /ゼイ/
thiamin /チアミン;V.B1/
thiamine /チアミン;V.B1/
thibaud /ティボー/チボー/
thibault /チボー/
thick /シック/
thief /シーフ/
thierry /ティエリ/
thigh /サイ/
thimphu /ティンプー/
thin /シン/
thing /シング/
think /シンク/
thinking /シンキング/
thinktank /シンクタンク/
thinner /シンナー/
thio /チオ/
thiol /チオール/
thiophene /チオフェン/
third /サード/３ｒｄ/第3要素/
thirdbase /サードベース/
thirdfly /サードフライ/
thirdgoro /サードゴロ;和製語(grounder)/
thirdparty /サードパーティ/サードパーティー/
thirteen /サーティーン/
thirty /サーティ/
this /ジス/ディス/
thistle /シスル;あざみ/
thom /トム/
thoma /トーマ/
thomas /トーマス/トマス/トマ/トーマ/
thomascook /トーマスクック/
thompson /トンプソン/
thomson /トムソン/トムスン/
thong /トング/
thor /トール/
thoreau /ソロー/
thorium /トリウム;[元素]90,Th/
thorn /ソーン;茨/
thoroughbred /サラブレッド/
thorpe /ソープ/
thoth /トート/トト/
thought /ソート/
thousand /サウザンド/
thracia /トラキア/
thrashing /スラッシング/
thread /スレッド/
threading /スレッディング/
threadsafe /スレッドセーフ/
three /スリー/
threebase /スリーベース;triple/
threef /スリーエフ;www.three-f.co.jp/
threeout /スリーアウト/
threepiece /スリーピース/
threerun /スリーラン/
threeseason /スリーシーズン;three-season/
threesize /スリーサイズ;和製英語(mesurements) NB:バスト・ウエスト・ヒップ/
threonine /スレオニン;Thr/トレオニン;=スレオニン/
threshold /スレッシュホールド/閾値/
thriling /スリリング/
thrill /スリル/
thriller /スリラー/
thrilling /スリリング/
throat /スロート/
thromboxane /トロンボキサン;TX/
throne /スローン/
throttle /スロットル/
through /スルー/
throughpass /スルーパス;和製英語/
throughput /スループット/
throw /スロー/
throwin /スローイン;throw-in/
throwing /スローイング/
thru /スルー/
thu /木/
thule /トゥーレ/
thulium /ツリウム;[元素]69,Tm/
thumb /サム/
thumbhole /サムホール/
thumbing /サミング/
thumbnail /サムネイル/サムネール/
thumbturn /サムターン;和製英語/
thunder /サンダー/
thunderbird /サンダーバード/
thunderbolt /サンダーボルト/
thuram /テュラム/
thuringen /チューリンゲン/
thursday /サーズデイ/サーズデー/サーズディ/
thurston /サーストン/
thyme /タイム/
thymine /チミン;T/
thymol /チモール/
thyristor /サイリスタ/
thyroxin /サイロキシン/
thyroxine /チロキシン/
ti /チタン/Titanium/テキサスインスツルメンツ/
tia /ティア/
tiago /ティアゴ/
tiamat /ティアマット/
tiananmen /天安門/
tiara /ティアラ/
tiber /タイバー/
tiberius /ティベリウス/
tibet /チベット/
tibetan /チベタン/
tic /チック/
tick /チック/ティック/
ticket /チケット/切符/
ticketless /チケットレス/
ticketpia /チケットぴあ;t.pia.co.jp/
ticketshop /チケットショップ/
ticktack /チクタク;tick-tack/チックタック/
tie /タイ/
tiebreak /タイブレーク/
tiepin /タイピン/
tieup /タイアップ/
tifanny /ティファニー/
tiff /ティフ/
tiffany /ティファニー/
tiffin /ティフィン/
tiger /タイガー/
tigers /タイガース/
tight /タイト/
tights /タイツ/
tightskirt /タイトスカート/
tignes /ティーニュ/
tigris /チグリス/ティグリス/
tijuana /ティファナ/
tilapia /ティラピア/テラピア/
tilda /チルダ/ティルダ/
tilde /チルダ/〜/ティルデ/ティルド/
tile /タイル/
tiling /タイリング/
till /ティル/
tilly /ティリー/
tilt /ティルト/
tim /ティム/
timbales /ティンバレス/
timber /ティンバー/
timbre /タンブル/
time /タイム/時間/
timeattack /タイムアタック/
timecapsule /タイムカプセル/
timecard /タイムカード/
timekeeper /タイムキーパー/
timelag /タイムラグ/
timelimit /タイムリミット/
timeline /タイムライン/
timely /タイムリー/
timelyhit /タイムリーヒット/
timemachine /タイムマシン/タイムマシーン/
timeout /タイムアウト/
timeover /タイムオーバー;和製英語(out of time)/
timer /タイマー/タイマ/
timerace /タイムレース/
timerecorder /タイムレコーダー/
times /タイムス/タイムズ/×/
timesale /タイムセール/
timescale /タイムスケール/
timeschedule /タイムスケジュール/
timeserver /タイムサーバ/タイムサーバー/
timeservice /タイムサービス/
timeshift /タイムシフト/
timeslip /タイムスリップ/
timespan /タイムスパン/
timessquare /タイムズスクエア/
timestamp /タイムスタンプ/
timetable /タイムテーブル/
timetravel /タイムトラベル/
timetrial /タイムトライアル/
timetunnel /タイムトンネル/
timeup /タイムアップ;和製英語(time's up)/
timezone /タイムゾーン/
timing /タイミング/
timm /ティム/
timmons /ティモンズ/
timo /ティモ/
timor /チモール/ティモール/
timothy /ティモシー/チモシー/テモテ/ティモテ/
timpani /ティンパニ/ティンパニー/
timur /ティムール/チムール/
tin /ティン;Sn/
tina /ティナ/ティーナ/
tinkerbell /ティンカーベル/
tinkle /ティンクル/
tino /ティノ/
tinpanalley /ティンパンアレイ;Tin-Pan Alley/
tint /ティント/
tinto /ティント/
tiny /タイニー/
tip /チップ/ティップ/
tips /ティップス/
tiramisu /ティラミス/
tirana /チラナ/ティラナ;アルバニア(tia)/
tire /タイヤ/タイア/
tirechain /タイヤチェーン/
tiresize /タイヤサイズ/
tirol /チロル/
tirolean /チロリアン/
tissue /ティッシュ/
tissuecase /ティッシュケース/
tissuepaper /ティッシュペーパー;和製英語/
tit /ティット/
titan /チタン/タイタン/Ｔｉｔａｎ/
titania /チタニア/
titanic /タイタニック/
titanium /チタニウム/チタン;[元素]22,Ti/
title /タイトル/
titlebar /タイトルバー/
titlematch /タイトルマッチ/
titlepage /タイトルページ/
titlerole /タイトルロール/
tito /チトー/
titus /テトス/タイタス/
tivoli /チボリ/
tiziano /ティツィアーノ/
tk80 /ＴＫ８０/
tl /タリウム/Thalium/
tm /ツリウム/Thulium/
tn /Tennessee/テネシー/
to /トゥ/ツー/→/
toad /トード/
toast /トースト/
toaster /トースター/トースタ/
tobacco /タバコ/
tobias /トビアス/トバイアス/トビト/
toby /トビー/
toccata /トッカータ/
tochka /トーチカ/
toco /トコ/
tocopherol /トコフェロール;V.E/
tocotrienol /トコトリエノール/
tocqueville /トクヴィル/
tod /トッド/トート;(独) 死/
today /トゥデイ/トゥディ/トゥデー/
toe /トゥ/トウ/トー/
toeic /トーイック;Test of English for International Communication/TOEIC/
toeplitz /テプリッツ/
toeshoes /トウシューズ/トゥシューズ/
together /トゥギャザー/
toggle /トグル/
togglebutton /トグルボタン/
toggleswitch /トグルスイッチ/
togo /トーゴ;.tg/
tohoku /東北/東北大学/東北地方/
toi /トワ/
toile /トイレ;toilet/
toilet /トイレット/トイレ/
toiletmat /トイレマット;bathroom mat/
toiletpaper /トイレットペーパー/
toiletry /トイレタリー/
tokaj /トカイ/
tokarev /トカレフ/
tokay /トカイ/
tokelau /トケラウ;.tk/
token /トークン/
tokenring /トークンリング/
tokhara /トカラ/トハラ/吐火羅/都貨邏/
tokio /トキオ/
tokyo /トーキョー/東京/
tokyodome /東京ドーム/
toledo /トレド/
tolerance /トレランス/
tolerant /トレラント/
tolkien /トールキン/
tolley /トリー/
tolstoi /トルストイ/
toluene /トルエン/
tom /トム/タム/
toma /トーマ/
tomahawk /トマホーク/
tomas /トマス/
tomato /トマト/
tomatojuice /トマトジュース/
tomatoketchup /トマトケチャップ/
tomatopuree /トマトピューレ/
tomatosalad /トマトサラダ/
tomatosauce /トマトソース/
tomcat /トムキャット;F-14/
tomei /トメイ/
tomi /トミ/
tommy /トミー/
tomorrow /トゥモロー/
tomtom /タムタム/トムトム/
tomy /トミー/
ton /トン/噸/瓲/
tonal /トーナル/
tonality /トーナリティ/
tondo /トンド/
tone /トーン/
tonedown /トーンダウン/
toner /トナー/
tonercartridge /トナーカートリッジ/
tong /トング/
tonga /トンガ;.to/
tongue /タング/タン/
tonguestew /タンシチュー/
tonguing /タンギング/
toni /トニー/トーニ/トニ/
tonic /トニック/
tonicwater /トニックウォーター;tonic/
tonight /トゥナイト/
tonino /トニーノ/
tonio /トニオ/
tonny /トニー/
tony /トニー/
tonya /トーニャ/
too /ツー/トゥー/
tool /ツール/
toolbar /ツールバー/
toolbox /ツールボックス/
toolkit /ツールキット/
tools /ツールス/ツールズ/
tooltip /ツールチップ/
tooth /トゥース/
top /トップ/上/
top# /トップ#0/トップ#1/
top10 /トップテン/
topaz /トパーズ/
topbatter /トップバッター/
topbust /トップバスト;top bust/
topclass /トップクラス;top class/
topdomain /トップドメイン/
topdown /トップダウン/
tope /トープ/
topgear /トップギア/
topgun /トップガン/
topia /トピア/
topic /トピック/
topics /トピックス/
topix /トピックス;東証株価指数/
toplady /トップレディ/
topleader /トップリーダー/
topleague /トップリーグ/
topless /トップレス/
toplevel /トップレベル/
toplight /トップライト/
topline /トップライン/
topmenu /トップメニュー/
topmodel /トップモデル/
topnote /トップノート/
topo /トポ/
topography /トポグラフィー/トポグラフィ/
topological /トポロジカル/
topology /トポロジー/トポロジ/
topos /トポス/
toppage /トップページ/
toppan /トッパン/
toppe /トッピー/
topping /トッピング/
topplayer /トッププレイヤー/トッププレーヤー/
toppro /トッププロ/
toprank /トップランク/
toprope /トップロープ/
toprunner /トップランナー/
tops /トップス/
topsales /トップセールス/
topsecret /トップシークレット/
topspin /トップスピン/
topstar /トップスター/
topten /トップテン/
toptime /トップタイム;和製英語/
tor /トール/
toradja /トラジャ/
torah /トーラー/トラー/トーラ/
toraja /トラジャ/
toraji /トラジ/
torch /トーチ/
toreador /トレアドール/
toredomin /トレドミン/
torerant /トレラント;※tolerant?/
torino /トリノ/
torn /トーン/
tornado /トルネード/
toronto /トロント/トロント大学/
torque /トルク/
torr /トル;=mmHg/
torre /トーレ/
torrent /トレント/
torres /トーレス/
torrey /トリー/トーリー/
torricelli /トリチェリ/
torrie /トリー/
torso /トルソー/
torsten /トルステン/
torte /トルテ;(独語)/
tortilla /トルティーヤ/トルティージャ/
tortoise /トータス/
torus /トーラス/
torvalds /トーバルズ/
tory /トリー/トーリー/
tosca /トスカ/
toscana /トスカーナ/トスカナ/
toscanini /トスカニーニ/
tosh /トッシュ/
toss /トス/
tossbatting /トスバッティング/
tostem /トステム;www.tostem.co.jp/
total /トータル/
totalcoordinate /トータルコーディネート/
totebag /トートバッグ/
totem /トーテム/
totempole /トーテムポール/
totipotent /トティポテント/
toto /トト/
totocalcio /トトカルチョ/
totti /トッティ/
touch /タッチ/
touchdown /タッチダウン/
touchline /タッチライン/
touchout /タッチアウト;和製英語(tag out)/
touchpanel /タッチパネル/
touchpen /タッチペン;和製英語/
touchsensor /タッチセンサー/
touchtype /タッチタイプ/
touchtyping /タッチタイピング/
touchup /タッチアップ;touch-up/
tough /タフ/
toughguy /タフガイ/
toughness /タフネス/
toulon /ツーロン/トゥーロン/
toulouse /トゥールーズ/ツールーズ/
tour /ツアー/
tourbus /ツアーバス;tour bus/
tourconductor /ツアーコンダクター/
tourdefrance /ツールドフランス;le Tour de France/
tourguide /ツアーガイド/
touring /ツーリング/
tourism /ツーリズム/
tourist /ツーリスト/
tourmarine /トルマリン/
tournament /トーナメント/
tournier /トゥルニエ/
tours /ツール/トゥール/ツアーズ/
toussaint /トゥーサン/
tove /トーベ/
toward /トワード/トゥワード/
towel /タオル/
towelhanger /タオルハンガー/
towelket /タオルケット;和製英語(towel+blanket)/
tower /タワー/
towering /タワーリング/
towermansion /タワーマンション/
towerrecord /タワーレコード;www.towerrecords.com/
towers /タワーズ/
town /タウン/
townes /タウンズ/
townhall /タウンホール/
townmeeting /タウンミーティング/
townpage /タウンページ;itp.ne.jp/
towns /タウンズ/
townsville /タウンズビル/
toxin /トキシン/
toy /トイ/
toynbee /トインビー/
toyopet /トヨペット/
toyota /トヨタ;www.toyota.co.jp/
toypiano /トイピアノ/
toypoodle /トイプードル/
toys /トイズ/
toyshop /トイショップ/
toysrus /トイザらス/トイザラス/
trace /トレース/トレイス/
traceability /トレーサビリティ/トレーサビリティー/
tracer /トレーサ/トレーサー/
tracey /トレイシー/トレーシー/
tracing /トレーシング/
tracingpaper /トレーシングペーパー/
track /トラック/
trackback /トラックバック/
trackball /トラックボール/
trackdown /トラックダウン/
tracker /トラッカー/
tracking /トラッキング/
trackpad /トラックパッド/
traction /トラクション/
tractor /トラクター/トラクタ/
tracy /トレイシー/トレーシー/
trad /トラッド/
trade /トレード/
trade-off /トレードオフ/
tradecenter /トレードセンター/
tradecentre /トレードセンター/
trademark /トレードマーク;TM/
tradeoff /トレードオフ/
trader /トレーダー/
trading /トレーディング/
tradingcard /トレーディングカード/
tradition /トラディション/
traditional /トラディショナル/
trafalgar /トラファルガー/
traffic /トラフィック/トラヒック/
tragedy /トラジェディ/
tragic /トラジック/
trail /トレイル/トレール/
trailer /トレーラー/
trailerhouse /トレーラーハウス/
train /トレイン/
trainee /トレーニー/トレイニー/
trainer /トレーナー/トレーナ/トレイナー/トレイナ;<rare>/
training /トレーニング/
trainingmachine /トレーニングマシン/トレーニングマシーン/
trainingwear /トレーニングウェア/
tram /トラム/
tramp /トランプ/
trampoline /トランポリン/
trance /トランス/
tranceiver /トランシーバ;※transceiver/トランシーバー;※transceiver/
trancy /トランシー/
tranquilizer /トランキライザー/トランキライザ/
trans /トランス/
transaction /トランザクション/
transactional /トランザクショナル/
transceiver /トランシーバー/トランシーバ/
transcript /トランスクリプト/
transcription /トランスクリプション/
transducer /トランスジューサ/
transfer /トランスファー/転送/
transform /トランスフォーム/
transformer /トランスフォーマー/
transgender /トランスジェンダー/
transgenic /トランスジェニック;遺伝子組換え/
transient /トランジェント/
transistor /トランジスタ/トランジスター/
transit /トランジット/
transition /トランジション/
translate /トランスレート/
translater /トランスレータ/
translation /トランスレーション/
translator /トランスレータ/トランスレーター/
transmission /トランスミッション/
transmit /転送/
transmitter /トランスミッター/トランスミッタ/
transnational /トランスナショナル/
transparent /トランスペアレント/透過/
transpersonal /トランスパーソナル/
transport /トランスポート/
transpose /トランスポーズ/
transputer /トランスピュータ/
transsexual /トランスセクシャル/
transversal /トランスバーサル/
transylvania /トランシルヴァニア/
trap /トラップ/タラップ;(蘭語)/
trapping /トラッピング/
trappists /トラピスト/
trash /トラッシュ/
trattoria /トラットリア/
trauma /トラウマ/
traumerei /トロイメライ/
travail /トラバーユ/
travel /トラベル/トラヴェル/
traveler /トラベラー/
travelers /トラベラーズ/
travelerscheck /トラベラーズチェック;traveler's check, TC/
traveling /トラベリング/
traveller /トラベラー/
travellers /トラベラーズ/
travelling /トラベリング/
travers /トラバース/
traverse /トラバース/
traverso /トラヴェルソ/
traviata /トラヴィアータ;椿姫/
travolta /トラボルタ/
trawl /トロール/
tray /トレー/トレイ/
tread /トレッド/
treadmill /トレッドミル/
treasure /トレジャー/
treasury /トレジャリー/
treat /トリート/
treatment /トリートメント/
trebbiano /トレッビアーノ/
treble /トレブル/
tree /ツリー/
trehalose /トレハロース/
trek /トレック/
trekker /トレッカー/
trekking /トレッキング/
trema /¨/
tremolo /トレモロ/
trench /トレンチ/
trenchcoat /トレンチコート/
trend /トレンド/
trendmicro /トレンドマイクロ/
trendo /トレンド;trend?/
trendy /トレンディ/トレンディー/
trento /トレント/
tres /トレ/トレス/
tresbien /トレビアン/
trevi /トレビ/トレヴィ/
trevise /トレビス/
trezeguet /トレゼゲ/
tri /トリ;3/
triad /トライアド/
trial /トライアル/
trialkit /トライアルキット/
triangle /トライアングル/△/▲/▽/▼/
triathlete /トライアスリート/
triathlon /トライアスロン/
triazolam /トリアゾラム/
tribal /トライバル/
tribe /トライブ/
tribune /トリビューン/
tribute /トリビュート/
trichloro /トリクロロ/
trichloroethylene /トリクロロエチレン/
trichomonas /トリコモナス/
tricia /トリシア/
trick /トリック/
trickart /トリックアート/
tricks /トリックス/
trickster /トリックスター/
tricky /トリッキー/
triclosan /トリクロサン/
tricolore /トリコロール/
trident /トライデント/
trie /トライ;<reTRIEval/
triennale /トリエンナーレ/
trieste /トリエステ/
triffid /トリフィド/
trigger /トリガー/トリガ/
triglyceride /トリグリセリド/
trigonelline /トリゴネリン/
trigraph /三連文字/
trihalomethane /トリハロメタン;THM/
trilemma /トリレンマ/
trill /トリル/
trim /トリム/
trimethylamine /トリメチルアミン/
trimmer /トリマー/
trimming /トリミング/
trine /トリーネ/トライン/
trinidad /トリニダード;Cuba/
trinitron /トリニトロン/
trinitrotoluene /トリニトロトルエン;TNT/
trinity /トリニティ;三位一体/トリニティー/
trino /トリノ/
trio /トリオ/
trip /トリップ/
tripeptide /ポリペプチド/
triple /トリプル/
triplea /トリプルA/トリプルＡ/
tripleplay /トリプルプレー/トリプルプレイ/
tripleroom /トリプルルーム/
triplet /トリプレット/
tripod /トライポッド/トリポッド/
tripoli /トリポリ/
tripper /トリッパー/
tripping /トリッピング/
tris /トリス/
tristan /トリスタン/
triste /トリスト/
tristram /トリストラム/
tritech /トライテック/
triton /トリトン/
triumph /トライアンフ;勝利/トリンプ;(独語) www.triumph.com/
trivia /トリビア/トリヴィア/
trivial /トリビアル/
trix /トリックス/
troche /トローチ/
troff /ティーロフ/
troia /トロイア/
troika /トロイカ/
trois /トロワ/
troll /トロール/トロル/
trolley /トロリー/
trolling /トローリング/
trombone /トロンボーン/
trompeloeil /トロンプルイユ;trompe-l'oeil/
tron /トロン/
trondheim /トロンヘイム/
troop /トループ/
trophy /トロフィー/トロフィ/
tropical /トロピカル/
tropicalfruit /トロピカルフルーツ/
tropicalfruits /トロピカルフルーツ/
tropicana /トロピカーナ/
troppo /トロッポ/
trotsky /トロツキー/
troubadour /トルバドゥール/トゥルバドゥール/
trouble /トラブル/
troublemaker /トラブルメーカー/
troubleshoot /トラブルシュート/
troubleshooting /トラブルシューティング/
trough /トラフ/
troussier /トルシエ/
trout /トラウト/
troy /トロイ/
troyounce /トロイオンス;31.1035g/
truck /トラック/
trucker /トラッカー/
true /トゥルー/正/
truetype /ＴｒｕｅＴｙｐｅ/
truffaut /トリュフォー/
truffe /トリュフ/
truffle /トリュフ;(英語綴り)/
trulli /トゥルーリ/
truman /トルーマン/トゥルーマン/
trump /トランプ/
trumpet /トランペット/
trumpeter /トランペッター/
trumpoline /トランポリン;※trampoline/
trunk /トランク/
trunkroom /トランクルーム/
trunks /トランクス/
truss /トラス/
trussardi /トラサルディ/
trust /トラスト/
truth /トゥルース/
try /トライ/
try&error /トライ＆エラー/
tryout /トライアウト/
trypsin /トリプシン/
tryptophan /トリプトファン;Trp/
ts /ц;tse (cyrillic)/
tsar /ツァー/ツァーリ/
tse /ц;cyrillic/
tshirt /Ｔシャツ/Tシャツ/ティーシャツ/
tshirts /Ｔシャツ/Tシャツ/ティーシャツ/
tu /テュ/
tuba /チューバ/
tube /チューブ/
tubeless /チューブレス/
tuberkulin /ツベルクリン/
tubetop /チューブトップ/
tubular /チューブラー/チューブラ/
tubularbell /チューブラベル/チューブラーベル/
tuck /タック/
tucker /タッカー/
tuckin /タックイン/
tucking /タッキング/
tuckseal /タックシール/
tucson /ツーソン/トゥーソン/
tue /火/
tuesday /チューズデイ/チューズデー/チューズディ/チューズディー/
tuft /タフト;房/
tug /タグ/
tugboat /タグボート/
tugjump /タグジャンプ/
tuka /ツーカー;www.tu-ka.co.jp/
tulip /チューリップ/
tull /タル/
tulle /チュール/
tullelace /チュールレース/
tumble /タンブル/
tumbler /タンブラー/
tumi /トゥミ;www.tumi.com/
tuna /ツナ/
tunakai /トナカイ;(アイヌ語)/
tunasalad /ツナサラダ/
tundra /ツンドラ/
tune /チューン/
tuner /チューナー/チューナ/
tuneup /チューンナップ/チューンアップ/
tungsten /タングステン;[元素]74,W/
tungus /ツングース/
tunic /チュニック/
tuning /チューニング/テューニング;<rare>/
tunis /チュニス/
tunisia /チュニジア;.tn/
tunnel /トンネル/
tunneling /トンネリング/トネリング/
tuple /タプル/
tupper /タッパー/
tupple /タプル;?/
turban /ターバン/
turbine /タービン/
turbo /ターボ/
turbocharger /ターボチャージャー/
turboengine /ターボエンジン/
turbolighter /ターボライター;和製英語/
turbolinux /ターボリナックス;www.turbolinux.com/
turco /トルコ/
turcogp /トルコGP;[F1]/
turf /ターフ/
turfan /トルファン;中国/
turgenev /ツルゲーネフ/
turing /チューリング/テューリング/
turingmachine /チューリングマシン/
turingtest /チューリングテスト/
turk /トルコ/土耳古/
turkestan /トルキスタン/
turkey /トルコ;.tr/ターキー/
turkmen /トルクメン/
turkmenistan /トルクメニスタン;.tm/
turmeric /ターメリック/
turn /ターン/
turnaround /ターンアラウンド/
turner /ターナー/
turning /ターニング/
turningmachine /チューリングマシン/
turningpoint /ターニングポイント/
turnover /ターンオーバー/
turnpike /ターンパイク/
turnstile /├/┣/ターンスタイル/
turntable /ターンテーブル/
turquoise /ターコイズ/
turquoiseblue /ターコイズブルー/
turtle /タートル/
turtleneck /タートルネック/
tuscan /タスカン/
tuscana /トスカナ/
tutankhamen /ツタンカーメン;Tut Ankh Amen/
tutor /チューター/チュータ/
tutorial /チュートリアル/
tutti /トゥッティ/
tutu /チュチュ/
tuvalu /ツバル;.tv/トゥ;tv/
tuxedo /タキシード/
tv /テレビ/テレビジョン/
tvanime /TVアニメ/テレビアニメ/ＴＶアニメ/
tvantenna /テレビアンテナ/
tvasahi /テレビ朝日;www.tv-asahi.co.jp/
tvboard /テレビボード/
tvcamera /テレビカメラ/
tvcm /テレビCM/
tvdrama /TVドラマ/テレビドラマ/ＴＶドラマ/
tvgame /テレビゲーム/TVゲーム/ＴＶゲーム/
tvmonitor /テレビモニター/テレビモニタ/TVモニター/TVモニタ/
tvnews /テレビニュース/TVニュース/ＴＶニュース/
tvseries /テレビシリーズ/
tvshopping /テレビショッピング/TVショッピング/
tvtokyo /テレビ東京;www.tv-tokyo.co.jp/
tvtuner /テレビチューナー/テレビチューナ/
twain /トウェイン/トウェーン/
tweed /ツイード/
tweeter /ツイーター/ツィーター/
twei /ツヴァイ/
twelve /トウェルブ/トゥウェルブ/
twenty /トウェンティ/
twilight /トワイライト/
twill /ツイル/
twin /ツイン/
twin-peaks /ツイン・ピークス/
twinbed /ツインベッド/
twinbee /ツインビー;[ゲーム]コナミ/
twincam /ツインカム/
twindrum /ツインドラム/
twining /トワイニング/
twinkle /トゥインクル/ツインクル/
twinpeaks /ツインピークス/
twinroom /ツインルーム/
twins /ツインズ/
twintail /ツインテール/
twist /ツイスト/
twisted /ツイステッド/
twister /ツイスター/
twistpair /ツイストペア;twisted-pair/
twistpaircable /ツイストペアケーブル;twisted-pair cable/
two /ツー/
twobase /ツーベース;double/
twobass /ツーバス/
twobeat /ツービート/
twobyfour /ツーバイフォー/
twoout /ツーアウト/
twopiece /ツーピース/
twoplatoons /ツープラトン/
tworun /ツーラン/
twoshot /ツーショット/
twostep /ツーステップ/
twotone /ツートン;two-tone/ツートーン/
twotonecolor /ツートンカラー;two-tone/
twotonecolour /ツートンカラー;two-tone/
twotop /ツートップ/
twoway /ツーウェイ/
tx /Texas/テキサス/
txtfile /TXTファイル/テキストファイル/
tyler /タイラー/
tylor /タイラー/
tyltyl /チルチル/
tyndall /チンダル/
tyner /タイナー/
type /タイプ/型/
typea /タイプA/タイプＡ/
typeb /タイプB/タイプＢ/
typec /タイプC/タイプＣ/
typemiss /タイプミス/
typesetter /タイプセッタ/
typewriter /タイプライター/タイプライタ/
typhoon /タイフーン/
typhus /チフス/
typical /ティピカル/
typing /タイピング/
typist /タイピスト/
typo /タイポ/
typographer /タイポグラファ/
typography /タイポグラフィ/タイポグラフィー/
tyr /チュール/
tyrannosaurus /ティラノサウルス/
tyre /タイヤ/
tyrosine /チロシン;Tyr/
tyson /タイソン/
tzara /ツァラ/
tzone /Ｔゾーン/Tゾーン/
u /υ;upsilon/ユー/у;cyrillic/ウラン/Uranium/
ubiquitous /ユビキタス/ユービキタス/
uboat /Ｕボート/Uボート/ユーボート/
ud /ウード/
ufa /ウファ/
ufocatcher /UFOキャッチャー;[商標]SEGA/
uganda /ウガンダ;.ug/
ugly /アグリー/
ugo /ウーゴ/
ui /ユーザーインターフェース/ユーザインターフェース/
uid /ユーザーID/ユーザID/
uif /ユーザ・インタフェース/
uighur /ウイグル/
uk /イギリス/
ukraina /ウクライナ/
ukraine /ウクライナ;.ua/
ukulele /ウクレレ/
ulanbator /ウランバートル/
ulanude /ウランウデ/
ulf /ウルフ/
ulla /ウラ/ウッラ/
ulm /ウルム/
ulrich /ウルリヒ/ウルリッヒ/
ultima /ウルティマ/
ultimate /アルティメット/
ultra /ウルトラ/
ultrac /ウルトラC;和製語/ウルトラＣ/
ultralight /ウルトラライト/
ultraman /ウルトラマン/
ultramarine /ウルトラマリン;群青色/
ulysses /ユリシーズ/
um /UNIX Magazine/
umar /オマル/ウマル/
umayyads /ウマイヤ/
umberto /ウンベルト/
umbrella /アンブレラ/
umbria /ウンブリア/
umlaut /¨/ウムラウト/
umma /ウンマ/
umount /アンマウント/
umpire /アンパイア/
un /アン/
una /ウナ/ウーナ/
unakite /ユナカイト/
unbalance /アンバランス/
unbelievable /アンビリーバボー/アンビリーバブル/
unberbar /アンダーバー;_/
unbundle /アンバンドル/
uncle /アンクル/
und /ウント/
undead /アンデッド/
under /アンダー/
underbust /アンダーバスト;under bust/
undercoat /アンダーコート/
undercover /アンダーカバー/
underflow /アンダーフロー/
underfull /アンダーフル/
underground /アンダーグラウンド/アンダーグランド/アングラ/
underhair /アンダーヘア/
underline /アンダーライン/
underpar /アンダーパー/
underrun /アンダーラン/
underscore /アンダースコア/
undershirt /アンダーシャツ/
undershirts /アンダーシャツ/
understand /アンダースタンド/
underwater /アンダーウォーター/
underwear /アンダーウェア/
underworld /アンダーワールド/
undine /ウンディーネ/
undo /アンドゥ/
undulation /アンジュレーション/
uneck /Ｕネック/Uネック/
unesco /ユネスコ;www.unesco.org/
unfair /アンフェア/
unformat /アンフォーマット/
ungaro /ウンガロ/
unhappy /アンハッピー/
uni /ユニ/
unicast /ユニキャスト/
unicef /ユニセフ;www.unicef.org/
unicode /ユニコード/
unicorn /ユニコーン/
unifiable /ユニファイアブル/
unification /ユニフィケーション/
unifier /ユニファイア/
uniform /ユニフォーム/ユニホーム/
unify /ユニファイ/単一化/
unilateralism /ユニラテラリズム/
unimaga /ユニマガ/UNIX Magazine/
uninstall /アンインストール/
uninstaller /アンインストーラ/アンインストーラー/
union /ユニオン/∪/共用体/共有体/
uniprocessor /ユニプロセッサ/
uniq /ユニーク/
uniqlo /ユニクロ;www.uniqlo.com/
unique /ユニーク/
uniquinone /ユビキノン/
unisex /ユニセックス/
unisol /ユニソル/
unison /ユニゾン/
unisys /ユニシス;www.unisys.com/
unit /ユニット/単位/
unitary /ユニタリ/
unitbath /ユニットバス;和製英語(prefabricated bath)/
unite /ユニテ;仏語/
united /ユナイテッド/
unity /ユニティ/ユニティー/
universal /ユニバーサル/
universaldesign /ユニバーサルデザイン/
universalservice /ユニバーサルサービス/
universalstudio /ユニバーサルスタジオ;www.universalstudios.com/
universe /ユニバース/ユニヴァース/
universiade /ユニバーシアード/
university /ユニバーシティ/
unix /ユニックス/UNIX/
unixfair /ＵＮＩＸフェアー/
unixmagazine /ＵＮＩＸマガジン/
unknown /アンノウン/アンノーン/
unlimited /アンリミテッド/
unlink /アンリンク/
unload /アンロード/
unlock /アンロック/
unlucky /アンラッキー/
unmap /アンマップ/
unmount /アンマウント/
uno /ウノ/ウーノ/
unofficial /アンオフィシャル/
unparse /アンパーズ/
unparser /アンパーザ/アンパーザー/
unplayable /アンプレアブル/アンプレヤブル/
unplugged /アンプラグド/
unreal /アンリアル/
unrecognized /識別不能/
unrolling /アンローリング/
untied /アンタイド/
until /アンティル/
untouchable /アンタッチャブル/
up /アップ/↑/
upanisad /ウパニシャッド/
uparrow /↑/
upbeat /アップビート/
upcall /アップコール/
updata /アップデータ;[新語]/
update /アップデート/アップデイト/
updater /アップデータ/
updike /アップダイク/
updown /アップダウン/
upfront /アップフロント/
upgrade /アップグレード/
uplight /アップライト/
uplightpiano /アップライトピアノ/
uplink /アップリンク/
upload /アップロード/
uploader /アップローダー/アップローダ/
upon /アポン/
upper /アッパー/
uppercut /アッパーカット/
uppermiddle /アッパーミドル/
uppsala /ウプサラ/
upright /アップライト/
uprightpiano /アップライトピアノ/
upset /アップセット/
upside /アップサイド/
upsilon /υ/ユプシロン/
upstream /アップストリーム/
uptempo /アップテンポ/
uptime /アップタイム/
uptown /アップタウン/
upward /アップワード/
ur /ウル/
ura /ウラー/
uracil /ウラシル;U/
ural /ウラル/
uran /ウラン;U/
uranium /ウラニウム;U/ウラン;[元素]92,U/
uranos /ウラノス/
uranus /ウラヌス/
urban /アーバン/
urbanlife /アーバンライフ/
urdu /ウルドゥ/ウルドゥー/
urea /ユリア;尿素/
urethan /ウレタン/
urethane /ウレタン/
urgent /アージェント/
uribe /ウリベ/
uriel /ウリエル/
urs /ウルス/
ursula /ウルスラ/アーシュラ/
uruguay /ウルグアイ;.uy/
us /アス/
usability /ユーザビリティ/
usama /ウサマ/
usasu /ウシャス/
usbbus /USBバス;NB:Universal Serial Bus bus/
usbcable /USBケーブル/
usbcard /USBカード/
usbdevice /USBデバイス/
usbdrive /USBドライブ/
usbhub /USBハブ/
usbkeyboard /USBキーボード/
usbmemory /USBメモリ/USBメモリー/
usbmouse /USBマウス/
use /ユーズ;[動詞]/ユース;[名詞]/
usecase /ユースケース/
used /ユーズド/
user /ユーザー/ユーザ/USER/
useraccount /ユーザーアカウント/ユーザアカウント/
useragent /ユーザエージェント/ユーザーエージェント/
userfriendly /ユーザーフレンドリー/ユーザフレンドリー/ユーザフレンドリ/
usergroup /ユーザーグループ/ユーザグループ/
userguide /ユーザガイド/
userid /ユーザーID/ユーザID/ユーザid/
userinterface /ユーザーインターフェース/ユーザインタフェース/
usermanual /ユーザーマニュアル/ユーザマニュアル/
usermode /ユーザモード/
users /ユーザーズ/
usersguide /ユーザーズガイド/
userside /ユーザーサイド/ユーザサイド/
usersmanual /ユーザーズマニュアル/
usersupport /ユーザーサポート/ユーザサポート/
usher /アッシャー/
usr /ユーザ;user/ユーザー/
usual /ユージュアル/
ut /Utah/ユタ/
utah /ユタ;UT/
utility /ユーティリティ/ユーティリティー/
utilitysoft /ユーティリティソフト/
utnet /UTnet/
utopia /ユートピア/
utpcable /UTPケーブル/
utrecht /ユトレヒト/
utrillo /ユトリロ/
uturn /Ｕターン/Uターン/
uu /UNIX USER/
uub /ウンウンビウム/Ununbium/
uucp /UUCP/
uuh /ウンウンヘキシウム/Ununhexium/
uun /ウンウンニリウム/Ununnilium/
uuo /ウンウンオクチウム/Ununoctium/
uuq /ウンウンクアジウム/Ununquadium/
uuu /ウンウンウニウム/Unununium/
uva /ウバ/ウヴァ/
uvcut /UVカット/
uwe /ウーヴェ/
uzbek /ウズベク/
uzbekistan /ウズベキスタン;.uz/
v /ブイ/ヴイ/в;ve (cyrillic)/∨;or/↓/バナジウム/Vanadium/
va /ビオラ/Virginia/ヴァージニア/バージニア/
vacance /バカンス/ヴァカンス/
vacation /バケーション/ヴァケーション/
vaccine /ワクチン/
vaccinesoft /ワクチンソフト/
vacuum /バキューム/
vacuumcar /バキュームカー/
vader /ベイダー/ベーダー/ヴェイダー/
vadim /ヴァディム/ワディム/
vaduz /ファドーツ/
vagabond /バガボンド/
vagina /ヴァギナ/ワギナ/バギナ/
vague /ヴァーグ/バーグ/
vaio /バイオ;[商標]SONY/ヴァイオ/
vaisya /バイシャ/ヴァイシャ/
vakzin /ワクチン;(独語)/
val /ヴァル/バル/
valdes /バルデス/
vale /ヴェール/
valencia /バレンシア/
valentine /バレンタイン/ヴァレンタイン/
valentineday /バレンタインデー;2.14/
valentino /バレンチノ;www.valentino.it/ヴァレンティノ/ヴァレンチノ/ヴァレンティーノ/
valeria /ヴァレリア/
valerie /ヴァレリー/バレリー/
valeron /バレロン/
valery /ヴァレリー/ワレリー/
valetudo /バーリトゥード;vale tudo/
valeur /バルール/ヴァルール/
valhalla /ヴァルハラ/
valiant /バリアント;勇壮/ヴァリアント/
valid /ヴァリッド/バリッド/恒真/
validation /バリデーション/
valine /バリン;Val/
valken /ヴァルケン/
valkyrie /ワルキューレ/ヴァルキューレ/ヴァルキリー/
valletta /ヴァレッタ/
valley /バレー/
valli /ヴァリ/
valse /ヴァルス;(Fr)ワルツ/
value /バリュー/ヴァリュー/値/Ｖａｌｕｅ/
valuechain /バリューチェーン/
valve /バルブ/ヴァルヴ/
valvu /バルブ/
vamp /バンプ/ヴァンプ/
vampire /ヴァンパイア/バンパイア/バンパイヤ/ヴァンパイヤ/
van /ファン;van der Waals/ヴァン;van Gogh/バン/
vanadium /バナジウム;[元素]23,V/
vanallen /バンアレン;Van Allen/ヴァンアレン/バン・アレン/ヴァン・アレン/
vancomycin /バンコマイシン/
vancouver /バンクーバー/
vanda /バンダ/ヴァンダ/
vanderbilt /ヴァンダービルト/バンダービルト/
vanderwaals /ファンデルワールス;Johannes Diderik van der Waals (1837-1923)/
vandyck /ファンダイク;van Dyck/
vanessa /ヴァネッサ/
vangelis /ヴァンゲリス/
vanguard /バンガード/ヴァンガード/
vanilla /バニラ/ヴァニラ/
vanillabeans /バニラビーンズ/ヴァニラビーンズ/
vanillaessence /バニラエッセンス/
vanillaice /バニラアイス/
vanille /ヴァニーユ;(Fr) バニラ/バニーユ/
vanuatu /バヌアツ;.vu/
vanvogt /ヴァン=ヴォークト/
vanya /ワーニャ/
varaha /ヴァラーハ/
varanasi /ヴァラナシ/バラナシ;インド(vns)/
varela /バレラ/
varese /ヴァレーズ/
vargas /ヴァルガス/
variable /バリアブル/ヴァリアブル/変数/
variant /バリアント;異本/ヴァリアント/
variation /バリエーション/ヴァリエーション/
variety /バラエティー/バラエティ/ヴァラエティ/ヴァリエティ;<rare>/
varig /ヴァリグ/
varna /ヴァルナ/
varnish /ワニス/ニス/
vartan /バルタン/
vasallo /バサロ/
vasco /バスコ/ヴァスコ/
vascodagama /バスコダガマ;(1469?-1524) Vasco da Gama/ヴァスコダガマ/
vaseline /ワセリン/ヴァセリン/
vasquez /バスケス/
vat /バット/
vatican /バチカン;.va/ヴァチカン/ヴァティカン/
vaucher /バウチャー/
vaudeville /ヴォードヴィル/ボードビル/
vaudevillian /ボードビリアン/
vaughan /ヴォーン/ボーン/
vault /ボールト/ヴォールト/
vax /VAX/
vazquez /バスケス/
vc /チェロ/ビレッジセンター/Ｖｃ/
vcine /Ｖシネ;video + cinema/Vシネ/
vcinema /Ｖシネマ;video + cinema/Vシネマ/
vdash /├/
vdots /：;全角のコロン/
ve /в;cyrillic/
vector /ベクター/ベクトル/ベクタ/
vectorchi /ベクトル値/
veda /ヴェーダ/
vee /∨/ブイ/ヴィー/
vega /ベガ/ヴェガ/
vegas /ベガス;Las Vegas/
vegetable /ベジタブル/
vegetarian /ベジタリアン/
vehicle /ビークル/ヴィークル/
veil /ベール/ヴェール/
veinna /ウインナー/
vela /ベラ/ヴェラ/
velazquez /ベラスケス/
vella /ベラ/ヴェラ/
velma /ヴェルマ/
veloce /ヴェローチェ/
velocity /ベロシティ/ヴェロシティ/
velvet /ベルベット/ヴェルヴェット/
vendemiaire /ヴァンデミエール/
vender /ベンダー/ベンダ/
vendor /ベンダー/ベンダ/ヴェンダー/
veneer /ベニヤ/ベニア/
venetian /ベネチアン/ヴェネチアン/ヴェネツィアン/ベネシャン/
venezia /ヴェネチア/ヴェネツィア/ベネチア/ベネツィア/
venezuela /ベネズエラ;.ve/
venice /ベニス/ヴェニス/
venn /ベン/ヴェン/
venom /ヴェノム/ベノム/
vent /ベント/
venta /ベンタ/
venter /ベンター/
ventilation /ベンチレーション/
ventilator /ベンチレーター/
ventri /ベンチュリ/
venture /ベンチャー/ベンチャ/
venturebusiness /ベンチャービジネス/
venturecapital /ベンチャーキャピタル/
ventures /ベンチャーズ/
venus /ヴィーナス/ウェヌス/
venusline /ビーナスライン;信州の観光道路。www.venus-line.net/
vera /ベラ/ヴェラ/
verandah /ベランダ/
verbal /バーバル/
verbena /バーベナ/
verbose /バーボス/冗長な/
verde /ベルデ;(西語)緑/ヴェルデ/
verdi /ヴェルディ/ベルディ/
verdun /ベルダン/ヴェルダン/
verdy /ヴェルディ;[Jリーグ]東京/
vergilius /ウェルギリウス/ヴェルギリウス/
veridian /ビリジアン/
verify /ベリファイ/
verisign /ベリサイン;www.verisign.com/VeriSign/
verlaine /ヴェルレーヌ/ベルレーヌ/
vermeer /フェルメール/
vermiculite /バーミキュライト;蛭石/
vermilion /バーミリオン/
vermillion /バーミリオン/ヴァーミリオン/
vermont /バーモント;VT/
vermouth /ベルモット/
vernacular /ヴァナキュラー/バナキュラー/
verne /ヴェルヌ/
vernier /バーニア/
vernon /ヴァーノン/バーノン/
verona /ヴェローナ/ベローナ/ベロナ/ヴェロナ/
veronica /ヴェロニカ/ベロニカ/
veronique /ヴェロニク/ベロニク/
verra /ベラ/ヴェラ/
verre /ヴェール;(Fr)ガラス/
versace /ヴェルサーチ;ww.versace.com/ベルサーチ/
versailles /ベルサイユ/ヴェルサイユ/
verse /ヴァース;歌詞/
version /バージョン/ヴァージョン/版/
version-up /バージョンアップ/
versionup /バージョンアップ/ヴァージョンアップ/
versus /バーサス/ヴァーサス/
vert /ヴェール;(Fr)緑/
vertical /バーティカル/ヴァーティカル/⊥/垂直/垂直方向/
verve /ヴァーヴ/
very /ベリー/ベリィ/
vespa /ベスパ/
vessel /ベッセル/
vest /ベスト/
vesta /ベスタ/ヴェスタ/
vesuvio /ベスビオ/ヴェスヴィオ/
vet /ヘット;(蘭語)牛脂/
veteran /ベテラン/ヴェテラン/
vgoal /Ｖゴール;victory + goal/Vゴール/
vhll /VHLL(Very High Level Language)/
vi /ヴィ/
via /ビア/ヴィア/バイア/ヴァイア/
viagra /バイアグラ/
vian /ヴィアン/
vib /バイブ;vibrator/ヴァイブ/
vibraphone /ビブラフォン/ヴィブラフォン/
vibraslap /ビブラスラップ/ヴィブラスラップ/
vibration /バイブレーション/
vibrato /ビブラート/ヴィブラート/
vibrator /バイブレーター/バイブレータ/
vic /ビック/
vice /ヴァイス/
vicente /ビセンテ/
vichy /ヴィシー/
vichyssoise /ビシソワーズ/ヴィシソワーズ/
vicious /ヴィシャス/ビシャス/
vick /ヴィック/
vicki /ヴィッキー/
vicky /ビッキー/ヴィッキー/
victoire /ヴィクトワール/
victor /ビクター/ヴィクター/ヴィクトル/ビクトル/ヴィクトール/ ビクトール/
victoria /ビクトリア/ヴィクトリア/
victorian /ヴィクトリアン/ビクトリアン/
victory /ビクトリー/ヴィクトリー/
vidal /ヴィダル/ビダル/
vidalsassoon /ヴィダルサスーン;www.vidalsassoon.com/
video /ビデオ/ヴィデオ/
videocable /ビデオケーブル/
videocamera /ビデオカメラ/
videocapture /ビデオキャプチャ/ビデオキャプチャー/
videocard /ビデオカード/
videocasette /ビデオカセット/
videocd /ビデオCD/
videochat /ビデオチャット/
videochip /ビデオチップ/
videoclip /ビデオクリップ/
videodeck /ビデオデッキ/
videogame /ビデオゲーム/
videoletter /ビデオレター/
videomemory /ビデオメモリ/
videomessage /ビデオメッセージ/
videorecorder /ビデオレコーダー/
videorental /ビデオレンタル/
videoresearch /ビデオリサーチ;www.videor.co.jp/
videoshop /ビデオショップ/
videotape /ビデオテープ/
videotex /ビデオテックス/
vie /ヴィ;仏語/ヴィー/
vieil /ヴィエイユ/
vieille /ヴィエイユ/
vienna /ウィンナー/ウィンナ/
viennoiserie /ヴィエノワズリー;(Fr) 菓子パン類/
vientiane /ヴィエンチャン/ビエンチャン;ラオス(vte)/
vieri /ヴィエリ/
vietnam /ベトナム;.vn/ヴェトナム/ヴィエトナム/
vieux /ヴュー/
view /ビュー/Ｖｉｅｗ/ヴュー/
viewer /ビューア/ビューアー/ビューワ/ビューワー/
viewhotel /ビューホテル/
viewing /ビューイング/
viewpoint /ビューポイント/
viewport /ビューポート/
vigny /ヴィニー/ビニー/
vigor /ビガー/
vihara /ビハーラ/ヴィハーラ/
viking /バイキング/ヴァイキング/
viktor /ヴィクトル/ヴィクトール/
viktoria /ヴィクトリア/
vila /ビラ/
villa /ビラ/ヴィラ/ビジャ/
village /ビレッジ/ヴィレッジ/ヴィラージュ;仏語/
villeneuve /ビルヌーブ/ヴィルヌーヴ/
villeroy /ビレロイ/
villon /ヴィヨン/
vilnyus /ヴィリニュス/
vin /ヴァン;(Fr) ワイン/
vina /ヴィーナ/
vinaigrette /ビネグレット/ヴィネグレット/
vince /ビンス/ヴィンス/
vincent /ヴィンセント/ビンセント/ヴァンサン/
vincenzo /ヴィンチェンツォ/
vinci /ヴィンチ/ビンチ/
vine /ヴァイン/バイン/
vinegar /ビネガー/ヴィネガー/
vinnie /ヴィニー/ビニー/
vinny /ヴィニー/ビニー/
vinson /ヴィンソン/ビンソン/
vintage /ヴィンテージ/ビンテージ/
vinyl /ビニール/ビニル/
vinylalcohol /ビニルアルコール/
vinylcover /ビニールカバー/
vinylhouse /ビニールハウス;和製英語(plastic greenhouse)/
vinylidene /ビニリデン/
vinylsheet /ビニールシート/
vinyltape /ビニールテープ/
viola /ビオラ/ヴィオラ/
violation /バイオレーション/
violence /バイオレンス/
violent /バイオレント/
violet /バイオレット/ヴァイオレット/
violetta /ヴィオレッタ/
violin /ヴァイオリン/バイオリン/
violinist /ヴァイオリニスト/バイオリニスト/
violinsonata /ヴァイオリンソナタ/バイオリンソナタ/
violon /ヴィオロン;(Fr)バイオリン/
viper /バイパー/ヴァイパー/
virgin /バージン/ヴァージン/
virginia /バージニア;VA/ヴァージニア/
virginie /ヴィルジニー/
virginoil /バージンオイル/
virginroad /バージンロード;和製英語/
virgo /バーゴ;乙女座/ヴァーゴ/バルゴ/ビルゴ/
viridian /ビリジアン/
virtual /バーチャル/ヴァーチャル/仮想/
virtualdomain /バーチャルドメイン/
virtualhost /バーチャルホスト/
virtualmachine /バーチャルマシン/
virtualmall /バーチャルモール/
virtualpet /バーチャルペット/
virtualreality /バーチャルリアリティ/
virtuoso /ヴィルトゥオーゾ/ヴィルトゥオーソ/
virus /ウイルス/ウィルス/ビールス/ヴィールス/
virusbuster /ウイルスバスター/ウィルスバスター/
viruscheck /ウイルスチェック/ウィルスチェック/
virusmail /ウイルスメール/ウィルスメール/
virusscan /ウイルススキャン/ウィルススキャン/
virussoft /ウイルスソフト/
vis /ビス/
visa /ビザ/ヴィザ/
visacard /VISAカード;www.visa.com/ビザカード/
visconti /ビスコンティ/ヴィスコンティ/
vision /ビジョン/ヴィジョン/視覚/
visionary /ビジョナリー/
visit /ビジット/ヴィジット/
visitor /ビジター/
visnu /ヴィシュヌ/
visor /バイザー/
vissel /ヴィッセル;[Jリーグ]神戸/
vista /ビスタ/ヴィスタ/
visual /ビジュアル/ヴィジュアル/
visualisation /ビジュアライゼーション/
visualise /ビジュアライズ/
visualization /ビジュアライゼーション/
visualize /ビジュアライズ/
vita /ヰタ;ラテン語/ヴィタ/
vital /バイタル/
vitality /バイタリティ/バイタリティー/ヴァイタリティ/
vitamin /ビタミン/
vitamina /ビタミンA/ビタミンＡ/
vitamina# /ビタミンA#0/ビタミンＡ#0/
vitaminb /ビタミンB/ビタミンＢ/
vitaminb# /ビタミンB#0/ビタミンＢ#0/
vitaminc /ビタミンC/ビタミンＣ/
vitamind /ビタミンD/ビタミンＤ/
vitamind# /ビタミンD#0/
vitamine /ビタミン/ビタミンE/ビタミンＥ/
vitamink /ビタミンK/ビタミンＫ/
vitesse /ヴィテス;(Fr)速度/
vittorio /ヴィットーリオ/ヴィットリオ/
vitz /ヴィッツ;[商標]トヨタ/
viv /ヴィヴ/
viva /ビバ;(It)万歳/ヴィヴァ/
vivace /ヴィヴァーチェ/ビバーチェ/
vivaldi /ヴィヴァルディ/ビバルディ/
vivant /ヴィヴァン;仏語/
vivarium /ビバリウム/
vive /ビブ;(Fr)万歳/ヴィヴ/
vivian /ビビアン/ヴィヴィアン/
vivid /ビビッド/ヴィヴィッド/
vividcolor /ビビッドカラー/
vividcolour /ビビッドカラー/
vivien /ヴィヴィアン/
vivo /ヴィーヴォ/ビーボ/
vjebeta /VJE-β/
vlad /ブラッド/ブラド/ヴラド;Vlad was here!/
vladimir /ウラジミール/ウラジーミル/ウラディミール/ヴラディミール/
vladivostok /ウラジオストク;ロシア(vvo)/ウラジオストック;ロシア/
vleague /Vリーグ/Ｖリーグ/
vltava /ヴルタヴァ/
vn /ヴァイオリン/
vneck /Ｖネック/Vネック/ブイネック/
vocabulary /ボキャブラリー/ボキャブラリ/語彙/ヴォキャブラリ;<rare>/ヴォキャブラリィ;<rare>/
vocal /ボーカル/ヴォーカル/
vocalise /ヴォカリーズ/ヴォーカリーズ/
vocalist /ヴォーカリスト/ボーカリスト/
voce /ヴォーチェ/
vocoder /ボコーダー/ボコーダ/
vodafone /ボーダフォン;www.vodafone.jp/
vodka /ウォッカ/
vogue /ヴォーグ/ボーグ/
voice /ボイス/ヴォイス/
voicechat /ボイスチャット/
voicemail /ボイスメール/
voicepercussion /ボイスパーカッション/
voicerecorder /ボイスレコーダー/
voices /ヴォイセズ/
voicetraining /ボイストレーニング/
voicing /ボイシング/ヴォイシング/
void /ボイド/ヴォイド/
volante /ボランチ/
volga /ボルガ/ヴォルガ/
volk /フォルク;(独語)/
volker /フォルカー/
volkl /Ｖｏｌｋｌ/
volkswagen /フォルクスワーゲン/
volley /バレー/ボレー/
volleyball /バレーボール/
volt /ボルト/
volta /ボルタ/ヴォルタ/
voltage /ボルテージ/
voltaire /ヴォルテール/ボルテール/
volume /ボリューム/ヴォリューム/
volumeup /ボリュームアップ/
voluntary /ボランタリー/
volunteer /ボランティア/
volvo /ボルボ/
volvox /ボルボックス/
von /フォン/
vongole /ボンゴレ/
vonnegut /ヴォネガット/
vonneumann /フォンノイマン;von Neumann/フォン・ノイマン/
voodoo /ブードゥー/ヴードゥー/
vorpal /ボーパル/ヴォーパル/
vortex /ボルテックス/ヴォルテックス/
vostok /ボストーク/ヴォストーク/
vote /ボート/
voyager /ボイジャー/
vr /バーチャルリアリティ;virtual reality/バーチャルリアリティー/
vs /versus/バーサス/ｖｓ．/
vsign /Ｖサイン/Vサイン;(^-^)v/
vt /Vermont/バーモント/ヴァーモント/
vuitton /ヴィトン;www.vuitton.com/
vulcan /バルカン/
vulnerability /ヴァルネラビリティ/
vulunteer /ボランティア/
vzone /Ｖゾーン/Vゾーン/
w /ダブリュー/タングステン/Tungsten/
wa /Washington/ワシントン/
wa-pro /ワープロ/
wacoal /ワコール;www.wacoal.co.jp/
wafer /ウェハ/ウエハー/ウェハー/ウェーハ/ウエーハ/ウェファ/
wafers /ウエハース/
waffle /ワッフル/
wagen /ワーゲン/
wagner /ワーグナー/ワグナー/ヴァーグナー/ワグネル/
wagon /ワゴン/
wagonsale /ワゴンセール/
waikiki /ワイキキ/
wais /ウェイズ/
waist /ウエスト/ウェスト/
waistbag /ウエストバッグ;和製英語/ウェストバッグ/
waistline /ウエストライン/
waistpouch /ウエストポーチ;和製英語(belt bag)/
waistsize /ウエストサイズ/
wait /ウェイト/ウエイト/
waiter /ウェイター/
waiting /ウェイティング/
waitress /ウェイトレス/
waits /ウェイツ/
waiver /ウェーバー/
wake /ウェイク/
wakeboard /ウェイクボード/
wakeup /ウェイクアップ/
walden /ウォールデン/
waldo /ウォルド/ワルド/ウォルドー/
waldstein /ワルトシュタイン/
wales /ウェールズ/
walk /ウォーク/
walker /ウォーカー/
walkin /ウォークイン/
walkincloset /ウォークインクローゼット;walk-in closet/
walking /ウォーキング/
walkingshoes /ウォーキングシューズ/
walkman /ウォークマン;[商標]SONY/
walkrally /ウォークラリー/
walkthrough /ウォークスルー/
walkure /ワルキューレ/ヴァルキューレ/
wall /ウォール/
wallaby /ワラビ/ワラビー/
wallace /ウォーレス/ウォレス/
wallet /ウォレット/
wallstreet /ウォールストリート/ウォール街/
wally /ウォーリー/
walmart /ウォルマート;www.walmart.com/
walnut /ウォルナット;胡桃/
walnuts /ウォールナッツ/ウォルナッツ/
walras /ワルラス/
walsh /ウォルッシュ/
walt /ウォルト/
walter /ウォルター/ワルター/ヴァルター/
walther /ワルター/ワルサー/ヴァルター/ウォルター/バルター/
waltherp# /ワルサーP#0/
waltz /ワルツ/
wand /ワンド/
wanda /ワンダ/ヴァンダ/
wander /ワンダー/
wanderer /ワンダラー/
wandering /ワンダリング/
wandervogel /ワンダーフォーゲル;(独語)/
wanernmusic /ワーナーミュージック;wmg.com/
wangel /ワンゲル;Wandervogel(?)/
wannabe /ワナビー/
want /ウォント/
wanted /ウォンテッド/
wants /ウォンツ/
wappen /ワッペン;(独語)/
war /ウォー/
ward /ワード/
wardrobe /ワードローブ/
ware /ウェア/ウエア/Ｗａｒｅ/
warehouse /ウェアハウス/ウエアハウス/
waren /ワーレン/
warhol /ウォーホル/
warlock /ウォーロック/
warlord /ウォーロード/
warm /ウォーム/
warmbiz /ウォームビズ;[新語]和製英語/
warmer /ウォーマー/
warming /ウォーミング/
warmingup /ウォーミングアップ/
warmup /ウォームアップ/
warn /ワーン/ウォーン/
warner /ワーナー/
warning /ワーニング/ウォーニング/警告/
warp /ワープ/
warrant /ワラント/
warren /ウォーレン/
warrior /ウォーリア/ウォーリアー/ウォリアー/
warriors /ウォーリアーズ/ウォリアーズ/
wars /ウォーズ/
warship /ウォーシップ/
warszawa /ワルシャワ;ポーランド/
was /ワズ/ウォズ/
wash /ウォッシュ/
washable /ウォッシャブル/
washer /ワッシャー/ウォッシャー/ワッシャ/
washing /ウォッシング/
washington /ワシントン/
washingtondc /ワシントンＤＣ/ワシントンDC/
washingtonhotel /ワシントンホテル/
washlet /ウォシュレット;和製英語/ワォシュレット;<rare>/
wasp /ワスプ/
waste /ウェイスト/
wat /ワット/
watch /ウォッチ/
watchdog /ウォッチドッグ/
watching /ウォッチング/
water /ウォーター/
waterbed /ウォーターベッド/
waterbottle /ウォーターボトル/
watercooler /ウォータークーラー/
waterfall /ウォーターフォール/ウォータフォール/
waterfront /ウォーターフロント/
watergarden /ウォーターガーデン/
watergate /ウォーターゲート/
waterhazard /ウォーターハザード/
waterjet /ウォータージェット/
waterloo /ワーテルロー/ウォータールー/
watermark /ウォーターマーク;透かし/
waterproof /ウォータープルーフ/
watersport /ウォータースポーツ/
watersports /ウォータースポーツ/
watkins /ワトキンス/
watson /ワトソン/ワトスン/
watt /ワット/
watts /ワッツ/
wave /ウェーブ/ウエーブ/ウェイブ/ウェイヴ/波/
wavefront /ウェーブフロント/
wavelet /ウェーブレット/
wavfile /WAVファイル/
wavy /ウェービー/
wax /ワックス/
way /ウェイ/ウェー/ウエイ/
wayne /ウェイン/ウエイン/
ways /ウェイズ/
we /ウィ/ウィー/
weak /ウィーク/
weakpoint /ウィークポイント/
wealth /ウェルス/
weapon /ウェポン/ウエポン/
wear /ウェア/ウエア/
weather /ウェザー/ウエザー/
weatherreport /ウェザーリポート/
web /ウェブ/
webbrowser /WEBブラウザ/ウェブブラウザ/
webcomic /Webコミック/ウェブコミック/
webdesign /ウェブデザイン/
webdesigner /ウェブデザイナー/
webdirectory /ウェブディレクトリ/
webdrama /Webドラマ/ウェブドラマ/
weber /ウェーバー/ウェバー/ヴェーバー/ウェーバ/
webern /ウェーベルン/
weblog /ウェブログ;blog/
webmagazine /WEBマガジン/ウェブマガジン/
webmail /ウェブメール/
webmaster /ウェブマスター/
webmoney /ウェブマネー/
webpage /ウェブページ/Webページ/
webradio /Webラジオ/ウェブラジオ/
webring /ウェブリング/
webserver /Webサーバ/ウェブサーバ/ウェブサーバー/webサーバ/
webservice /Webサービス/ウェブサービス/webサービス/
website /Webサイト/ウェブサイト/webサイト/
webster /ウェブスター/ウエブスター/
wed /水/
wedding /ウェディング/ウエディング/
weddingbell /ウェディングベル/ウエディングベル/
weddingcake /ウェディングケーキ/
weddingdress /ウェディングドレス/ウエディングドレス/
wedeln /ウェーデルン/
wedge /∧/ウェッジ/
wedgewood /ウェッジウッド/
wedgwood /ウェッジウッド/
wednesday /ウェンズデー/ウェンズデイ/ウェンズディ/
weed /ウィード/
week /ウィーク/ウイーク/
weekday /ウィークデー/ウィークデイ/
weekend /ウィークエンド/
weekly /ウィークリー/ウイークリー/
weeklymansion /ウィークリーマンション/
weeks /ウィークス/
wegner /ウェグナー/ウェゲナー/
weight /ウェイト/ウェート/
weightlifting /ウェイトリフティング/
weighttraining /ウェイトトレーニング/
weil /ヴェイユ/
weimar /ワイマール/
wein /ウェイン/ウエイン/ヴァイン;(独語)ワイン/
weird /ウィアード/
weisman /ワイズマン/ワイスマン/
weiss /ヴァイス/
weissman /ワイスマン/
welcome /ウェルカム/ウエルカム/
welfare /ウェルフェア/
well /ウェル/ウェール/
well-done /ウェルダン/
wellcity /ウェルシティ;厚生年金会館/
welldone /ウェルダン/
weller /ウェラー/
welles /ウェルズ/
wellington /ウェリントン/
wellness /ウェルネス/ウエルネス/
wells /ウェルズ/
welsh /ウェルシュ/
welter /ウェルター/
wenders /ヴェンダース/
wendy /ウェンディ/ウェンディー/
went /ウェント/
wentz /ウエンツ/ウェンツ/
were /ワー/
werner /ワーナー/ウェルナー/ベルナー/ヴェルナー/
wernicke /ウェルニッケ/
wes /ウェス/ウエス/
wesley /ウェスリー/
wessex /ウェセックス/
wesson /ウェッソン/
west /ウエスト/
westcoast /ウエストコースト;西海岸/ウェストコースト/
westend /ウエストエンド/
western /ウエスタン/ウェスタン/
westernleague /ウエスタンリーグ/
westminster /ウェストミンスター/ウエストミンスター/
westphalia /ウェストファリア/ウエストファリア/
westside /ウェストサイド/ウエストサイド/
westvirginia /ウェストバージニア;WV/ウエストバージニア;WV/
wet /ウェット/ウエット/
wetsuit /ウェットスーツ/
wetsuits /ウェットスーツ/
wettype /ウェットタイプ/
weyl /ワイル/
wg /ワーキンググループ/
whale /ホエール/
what /ホワット/
what's /ホワッツ/
whats /ホワッツ;what's/
wheat /フィート;小麦/
wheel /ホイール/
wheelbase /ホイールベース/
wheelclick /ホイールクリック/
wheeler /ホイーラー/
wheelie /ウィリー/ウイリー/
wheelmouse /ホイールマウス/
where /ホエア/ウェア/
whey /ホエー;乳清/ホエイ/
which /フィッチ/
while /ワイル/ホワイル/ファイル/
whip /ホイップ/
whipcream /ホイップクリーム/
whipper /ホイッパー/
whisker /ウィスカー/ウイスカー/
whiskey /ウイスキー/ウィスキー/ウヰスキー/
whisky /ウイスキー/ウィスキー/
whisper /ウィスパー/
whistle /ホイッスル/
white /ホワイト/
whiteasparagus /ホワイトアスパラガス/
whiteband /ホワイトバンド;www.whiteband.org/
whiteboard /ホワイトボード/
whitebox /ホワイトボックス/
whitechoco /ホワイトチョコ/
whitechocolate /ホワイトチョコレート/
whitechristmas /ホワイトクリスマス;white Christmas/
whitecollar /ホワイトカラー/
whitecuracao /ホワイトキュラソー/
whiteday /ホワイトデー/ホワイトデイ/
whitehole /ホワイトホール/
whitehouse /ホワイトハウス/
whiteknight /ホワイトナイト/
whitelist /ホワイトリスト/
whitening /ホワイトニング/
whitenoise /ホワイトノイズ/
whiteopal /ホワイトオパール/
whiteout /ホワイトアウト/
whitepapper /ホワイトペッパー/
whitepearl /ホワイトパール/
whiterum /ホワイトラム/
whitesauce /ホワイトソース/
whitesox /ホワイトソックス;[MLB]White Sox/
whitexmas /ホワイトクリスマス;white Christmas/
whitman /ホイットマン/
whitney /ホイットニー/
who /フー/
whodunit /フーダニット;推理小説/Who done it?/
whole /ホール/
wholesale /ホールセール/
wholesaler /ホールセラー/
wholetomato /ホールトマト/
whom /フム/
whose /フーズ/
why /ホワイ/
whydunit /ホワイダニット/Why done it?/
wi /Wisconsin/ウィスコンシン/
wicky /ウィッキー/
wide /ワイド/WIDE/
wideangle /ワイドアングル/
widearea /ワイドエリア/
widescreen /ワイドスクリーン/
wideshow /ワイドショー/ワイドショウ/
widesize /ワイドサイズ/
widespan /ワイドスパン/
widetv /ワイドテレビ/
widget /ウィジェット/ウィジット/Widget/
widow /ウィドウ/ウィドー/
width /幅/
wie /ヴィー;(独語)/
wien /ウィーン/
wiener /ウインナー/ウィンナー/ウィナー/ウィンナ/ウインナ/ウィーナー/
wienphil /ウィーンフィル;Wiener Philharmoniker/
wiese /ヴィーゼ/
wiest /ウィースト/
wife /ワイフ/
wig /ウィッグ/
wiki /ウィキ/
wikipedia /ウィキペディア;wikipedia.org/
wilbur /ウィルバー/
wild /ワイルド/
wildcard /ワイルドカード/
wildcat /ワイルドキャット/
wilde /ワイルド/
wilder /ワイルダー/
wilderness /ウィルダネス/
wildflower /ワイルドフラワー/
wildlife /ワイルドライフ/
wildpitch /ワイルドピッチ/
wildrice /ワイルドライス;マコモ/
wildstrawberry /ワイルドストロベリー/
wiley /ウィリー/ワイリー;人名/
wilfred /ウィルフレッド/
wilhelm /ヴィルヘルム/ウィルヘルム/
wilkins /ウィルキンズ/
wilkinson /ウィルキンソン/
will /ウィル/
willcom /ウィルコム;www.willcom-inc.com/
willem /ウィレム/
william /ウィリアム/ウイリアム/
williams /ウィリアムズ/ウイリアムズ/ウィリアムス/ウイリアムス/
williamson /ウィリアムソン/ウィリアムスン/
willie /ウィリー/
willis /ウィリス/ウイリス/
willow /ウィロー/
willy /ウィリー/ウイリー/
wilm /ヴィルム/
wilma /ウィルマ/
wilson /ウィルソン/ウイルソン/ウィルスン/
wim /ヴィム/
wimbledon /ウィンブルドン/ウインブルドン/
win /ウィン/ウイン/
winch /ウインチ/ウィンチ/
winchester /ウィンチェスター/
wind /ウインド/ウィンド/
windbreaker /ウインドブレーカー/ウィンドブレーカー/
windchime /ウインドチャイム/ウィンドチャイム/
windham /ウィンダム/ウインダム/
windhoek /ウィントフック/
winding /ワインディング/
windmill /ウィンドミル/
windom /ウィンダム/ウインダム/
window /ウィンドウ/ウインドウ/ウインドー/
windowing /ウインドウィング/
windowmanager /ウィンドウマネージャ/
windows /ウィンドウズ/ウインドウズ/Windows/
windowsystem /ウィンドウシステム/
windsor /ウィンザー;UK/
windsurfing /ウインドサーフィン/ウィンドサーフィン/
windup /ワインドアップ/
windy /ウィンディ/ウィンディー/ウインディ/ウインディー/
wine /ワイン/
winebar /ワインバー/
winecellar /ワインセラー/
winecooler /ワインクーラー/
wineglass /ワイングラス/
wineopener /ワインオープナー/
winered /ワインレッド/
winery /ワイナリー/
winevinegar /ワインビネガー/
wing /ウイング/ウィング/
wings /ウィングス/
wink /ウインク/ウィンク/Ｗｉｎｋ/
winker /ウインカー/ウィンカー/
winner /ウィナー/ウイナー/
winners /ウィナーズ/
winnie /ウィニー/
winning /ウイニング/ウィニング/
winningball /ウイニングボール/
winningrun /ウイニングラン/ウィニングラン/
winnipeg /ウィニペグ/
winny /ウィニー/
wins /ウィンズ/ウインズ/
winston /ウィンストン/ウインストン/
winter /ウィンター/ウインター/
winterp /WINTERP(Widget Interpreter)/
wintersports /ウィンタースポーツ/
wipe /ワイプ/
wipeout /ワイプアウト/
wiper /ワイパー/
wire /ワイヤー/ワイヤ/ワイア/ワイアー/
wirebrush /ワイヤーブラシ/
wirecable /ワイヤーケーブル/
wired /ワイヤード/
wiredor /ワイヤードオア/
wireframe /ワイヤーフレーム/ワイヤフレーム/
wireless /ワイヤレス/
wirelessmouse /ワイヤレスマウス/
wirelock /ワイヤーロック/
wirerope /ワイヤーロープ/ワイヤロープ/
wirewrapping /ワイヤラッピング/
wiring /ワイヤリング/
wisconsin /ウィスコンシン;WI/
wisdom /ウィズダム/
wise /ワイズ/
wiseman /ワイズマン/
wish /ウィッシュ/
wishbone /ウィッシュボーン/
wisp /ウィスプ/
wit /ウィット/
witch /ウィッチ/
with /ウィズ/ウイズ/
wither /ウィザー/
witherspoon /ウィザースプーン/
within /ウィズイン/
without /ウィズアウト/
witness /ウィットネス/
wittgenstein /ウィトゲンシュタイン/
witty /ウィッティ/
witz /ウィッツ/
wizard /ウィザード/
wizardry /ウィザードリィ/ウイザードリィ/
wm /ウィンドウマネージャー/
wnn /Ｗｎｎ/WNN/
wolf /ウルフ/ヴォルフ/
wolfe /ウルフ/
wolff /ウォルフ/ウルフ/ボルフ/
wolfgang /ヴォルフガング/ウォルフガング/
wolfram /タングステン;[元素]74,W/ウォルフラム/ヴォルフラム/
wolframium /タングステン;[元素]74,W/
wolter /ウォルター/
woman /ウーマン/
womanlib /ウーマンリブ;women's liberation/
womans /ウーマンズ;woman's/
womb /ウーム/
wombat /ウォンバット/
women /ウィメン/ウィミン/
womens /ウィメンズ;women's/
won /ウォン/ウオン/
wonder /ワンダー/
wonderful /ワンダフル/
wonderland /ワンダーランド/
wonderswan /ワンダースワン;[商標]バンダイ/
wont /ウォント;won't/
wood /ウッド/
woodbass /ウッドベース/
woodblock /ウッドブロック/
woodcraft /ウッドクラフト/
wooddeck /ウッドデッキ/
woodfence /ウッドフェンス/
woodpecker /ウッドペッカー/
woods /ウッズ/
woodshole /ウッズホール/
woodstock /ウッドストック/
woodward /ウッドワード/
woody /ウディ/ウッディ/ウッディー/ウディー/
woofer /ウーファー/ウーハー/ウーファ/
woogie /ウギ/
wool /ウール/
woolf /ウルフ/
woolly /ウーリー/
woolmark /ウールマーク/
wooly /ウーリー/
worcester /ウスター/ウースター/
word /ワード/
word-processor /ワードプロセッサ/ワープロ/ワードプロセッサー/
wordpad /ワードパッド/
wordprocessor /ワードプロセッサ/ワードプロセッサー/
words /ワーズ/
wordsworth /ワーズワース/
work /ワーク/
workaholic /ワーカホリック/
workarea /ワークエリア/
workaround /ワークアラウンド/
workbench /ワークベンチ/
workbook /ワークブック/
worker /ワーカー/
workflow /ワークフロー/
workgroup /ワークグループ/
working /ワーキング/
workinggroup /ワーキンググループ/
workingholiday /ワーキングホリデー/
workingmother /ワーキングマザー/
workingset /ワーキングセット/
workload /ワークロード/
workman /ワークマン/
workout /ワークアウト/
workroom /ワークルーム/
works /ワークス/
worksharing /ワークシェアリング/
worksheet /ワークシート/
workshop /ワークショップ/
workspace /ワークスペース/
workstation /ワークステーション/
workstyle /ワークスタイル/
world /ワールド/
worldcup /ワールドカップ;World Cup/
worldmusic /ワールドミュージック/
worlds /ワールズ/
worldseries /ワールドシリーズ/
worldtour /ワールドツアー/
worldwide /ワールドワイド/
worm /ワーム/
wormhole /ワームホール/
worpro /ワープロ/
worprosoft /ワープロソフト;word processor software/
worry /ウォーリー/
worse /ワース/
worship /ワーシップ/
worst /ワースト/
worst# /ワースト#0/ワースト#1/
worstone /ワーストワン/
worth /ワース/
would /ウド/ウッド/
wow /ワウ/
wowow /WOWOW/
wp /ワープロ/
wraith /レイス/
wrap /ラップ/
wrapper /ラッパー/ラッパ/
wrapping /ラッピング/
wreath /リース;花輪/
wrecker /レッカー/
wren /レン/
wrench /レンチ/
wrestler /レスラー/
wrestling /レスリング/
wright /ライト/
wrinkle /リンクル/
wrist /リスト/
wristband /リストバンド/
wristcut /リストカット;和製英語/
wristwatch /リストウォッチ/
write /ライト/書き込み/
writeonly /ライトオンリー/
writeprotect /ライトプロテクト/
writer /ライター/ライタ/
writing /ライティング/
writingdesk /ライティングデスク/
wrong /ロング/
ws /ワークステーション/WS/
wurzburg /ヴュルツブルク/ブルツブルク/
wv /West Virginia/ウェストヴァージニア/ウェストバージニア/ウエストバージニア/
wy /Wyoming/ワイオミング/ワイ/
wyatt /ワイアット/
wyler /ワイラー/
wyn /ウィン/
wyndham /ウィンダム/ウインダム/
wynn /ウィン/
wynne /ウィン/
wynton /ウィントン/ウイントン/
wyoming /ワイオミング;WY/
wyvern /ワイバーン/
x /エックス/エクス/×;バツ/ξ;xi/х;xa (cyrillic)/
x# /Ｘ#1/X#0/
x#r# /Ｘ#1Ｒ#1/
xa /х;cyrillic/
xan /ザン/
xanthan /キサンタン/
xanthangum /キサンタンガム/
xanthine /キサンチン/
xanthippe /クサンチッペ/クサンティッペ/
xanthos /クサントス/
xavier /ザビエル/ハビエル/クザヴィエ/
xc /XConsortium/
xday /Ｘデー;和製英語(D-day)/Ｘデイ/Xデー/Xデイ/
xe /キセノン/Xenon/
xenakis /クセナキス/
xenon /キセノン;[元素]54,Xe/
xenophon /クセノフォン/
xeon /ジオン/
xerography /ゼログラフィ/
xerox /ゼロックス/
xevious /ゼビウス;[ゲーム]ナムコ/
xi /ξ/クシー/クサイ/
xjiku /X軸/Ｘ軸/
xlib /Xlib/
xlisp /ＸＬｉｓｐ/XLisp/
xlsize /XLサイズ/ＸＬサイズ/
xmas /クリスマス;christmas/
xmascake /クリスマスケーキ/
xmascard /クリスマスカード/
xmascarol /クリスマスキャロル/
xmaseve /クリスマスイブ/クリスマスイヴ/
xmasparty /クリスマスパーティー/クリスマスパーティ/
xmaspresent /クリスマスプレゼント/
xmassale /クリスマスセール/
xmassong /クリスマスソング/
xmastree /クリスマスツリー;Christmas tree/
xpost /クロスポスト;crosspost/
xps /XPS(eXpansion Passing Style)/
xsen /X線/Ｘ線/エックス線/
xssize /XSサイズ/ＸＳサイズ/
xtc /エクスタシー/
xterminal /Ｘ端末/
xview /Ｘｖｉｅｗ/
xwindow /Ｘウィンドウ/
xx /××/
xylene /キシレン;C6H4(CH3)2/
xylitol /キシリトール/
xylo /キシロ/
xylocaine /キシロカイン/
xylophone /シロフォン/シロホン/
xylose /キシロース/
y /υ;upsilon/ワイ/й;cyrillic(i-kratkoje)/ы;cyrillic/イットリウム/Yttrium/
y# /#0円/
ya /←/→/↑/↓/ヤー/
yacht /ヨット/
yachtharbor /ヨットハーバー/
yachtharbour /ヨットハーバー/
yachtman /ヨットマン/
yachtrace /ヨットレース/
yachtsman /ヨットマン/
yah /ヤー/
yahoo /ヤフー;www.yahoo.com/Yahoo!/
yahooauction /ヤフーオークション;auctions.yahoo.co.jp/Yahoo!オークション/
yahoobb /Yahoo! BB/
yahweh /ヤハウェ/
yajirushi /→/←/↑/↓/
yak /ヤク/
yakult /ヤクルト/
yakutsk /ヤクーツク/
yale /エール/イェール/イエール/
yalta /ヤルタ/
yamaha /ヤマハ/
yamoussoukro /ヤムスクロ/
yan /ヤン/
yana /ヤナ/
yang /ヤン/
yangon /ヤンゴン/
yank /ヤンク/
yankee /ヤンキー/
yankees /ヤンキース;[MLB]/
yann /ヤン/
yaounde /ヤウンデ/
yaplog /ヤプログ;www.yaplog.jp/
yapoo /ヤプー/
yard /ヤード/
yarder /ヤーダ/
yarn /ヤーン/
yb /イッテルビウム/Ytterbium/
ydan /Ｙ談/
ye /е;cyrillic/
yea /イェイ/イエイ/イェー/イエー/イェア/
yeah /イェー/イエー/イェア/イェイ/イエイ/
year /イヤー/
years /イヤーズ/
yeast /イースト/
yeastfood /イーストフード/
yeats /イエーツ/イェーツ/イエイツ/
yellow /イエロー/イェロー/
yellowcab /イエローキャブ/
yellowcard /イエローカード/
yellowgreen /イエローグリーン/
yellowknife /イエローナイフ;カナダ(yzf)/
yellowpage /イエローページ/
yellowstone /イエローストーン/
yemen /イエメン;.ye/
yen /¥/円/
yenisei /エニセイ/
yepes /イエペス/
yerevan /エレヴァン/
yes /イエス/
yesman /イエスマン/
yessir /イエッサー;Yes, Sir!/
yesterday /イエスタデイ/イエスタディ/
yeti /イエティ/
yevgeny /エフゲニー/
yew /ユー/
yeye /イエイエ;ye-ye/
yggdrasil /ユグドラシル;[北欧神話]世界樹/イグドラシル/
yhwh /ヤハウェ/ヤーウェ/ヤーヴェ/エホバ/
yiddish /イディッシュ/
yield /イールド/
yjiku /Y軸/Ｙ軸/
yo /ё;cyrillic/
yocto /ヨクト;[SI接頭語]y,10^-24/
yoda /ヨーダ/
yodel /ヨーデル/
yoga /ヨガ/ヨーガ/
yogurt /ヨーグルト/
yoho /ヤッホー;yo-ho/
yoke /ヨーク/
yoko /─;罫線/━;太い罫線/
yolanda /ヨランダ/
yoni /ヨニ/
yoohoo /ヤッホー;yoo-hoo/
york /ヨーク/
yorkie /ヨーキー/
yorkshire /ヨークシャー/ヨークシャ/
yorkshireterrier /ヨークシャーテリア/ヨークシャテリア/
yorktown /ヨークタウン/
yosemite /ヨセミテ/
yotta /ヨタ;[SI接頭語]Y,10^24/
you /ユー/
young /ヤング/
youngadult /ヤングアダルト;young adult/
youngjump /ヤングジャンプ;集英社/
youngmagazine /ヤングマガジン;講談社/
youngsunday /ヤングサンデー;小学館/
your /ユア/
yours /ユアーズ/
yourself /ユアセルフ/
youth /ユース/
youthful /ユースフル/
youthhostel /ユースホステル/
yoyo /ヨーヨー/
ys /イース/
yshirt /ワイシャツ;和製英語(white shirt)/Ｙシャツ/Yシャツ/
yshirts /ワイシャツ;和製英語(white shirt)/Ｙシャツ/Yシャツ/
ytterbium /イッテルビウム;[元素]70,Yb/
yttrium /イットリウム;[元素]39,Y/
yu /ы;y (cyrillic)/
yucca /ユッカ/
yugo /ユーゴ/
yugoslavia /ユーゴスラビア;.yu/ユーゴスラヴィア/
yukar /ユーカラ;(アイヌ語)/ユカラ/
yukatan /ユカタン/
yukhoe /ユッケ;(朝鮮語)/
yul /ユル/
yulian /ユリアン/
yumin /ユーミン/
yuri /ユーリ/
yury /ユーリー/
yuzhnosakhalinsk /ユジノサハリンスク;Yuzhno-Sakhalinsk/
yves /イブ/イヴ/
yvessaintlaurent /イブサンローラン;Yves Saint Laurent/
yvette /イヴェット/イベット/
yvonne /イボンヌ/イヴォンヌ/
z /ζ;zeta/ゼット/з;ze (cyrillic)/
zabadak /ザバダック;誰にも知られず消えてゆく強さ/
zack /ザック/
zagreb /ザグレブ/
zaire /ザイール;.zr (現コンゴ .cd)/
zak /ザック/
zambezi /ザンベジ/
zambia /ザンビア/
zambrotta /ザンブロッタ/
zamenhof /ザメンホフ;(1859-1917) Esperantoの創案者/
zamora /サモラ/
zampona /サンポーニャ/
zanetti /ザネッティ/
zanzibar /ザンジバル/
zap /ザップ/
zapper /ザッパー/
zapping /ザッピング/
zaragoza /サラゴサ/
zarathustra /ツァラトゥストラ/
zardas /チャルダッシュ/
zaurus /ザウルス/
zaza /ザザ/
zazie /ザジ/
zbuffer /Zバッファ;Z-buffer/
ze /з;cyrillic/
zeal /ジール/
zebra /ゼブラ/
zechariah /ゼカリヤ/
zed /ゼット/ゼッド/
zee /ジー/ゼー/ゼット/
zeeman /ゼーマン/
zeit /ツァイト;(独語)時間/
zelda /ゼルダ/
zele /ゼール;(Fr)熱意/
zemi /ゼミ;semi?/
zener /ツェナー/
zenith /ゼニス/
zeno /ゼノ/
zenobia /ゼノビア/
zenon /ゼノン/
zeolite /ゼオライト/
zephaniah /ゼパニヤ/
zepher /ゼファー/
zephyr /ゼファー/ゼフィール/
zephyros /ゼフィロス;西風/
zeppelin /ツェッペリン/
zepto /ゼプト;[SI接頭語]z,10^-21/
zermatt /ツェルマット/
zero /ゼロ/〇/零/
zerobase /ゼロベース/
zeroemission /ゼロエミッション/
zerometre /ゼロメートル;sea level/
zerosum /ゼロサム;zero-sum/
zerosumgame /ゼロサムゲーム;zero-sum game/
zeste /ゼスト;(Fr) 柑橘類の皮/
zeta /ζ/ゼータ/
zetta /ゼタ;[SI接頭語]Z,10^21/
zeus /ゼウス/
zexy /ゼクシィ;[雑誌名]zexy.net/
zgundam /Zガンダム;[アニメ]ゼータガンダム/Ζガンダム;(ギリシア文字のZeta)/
zh /←/ж;zhe (cyrillic)/
zhe /ж;cyrillic/
zhivago /ジバゴ/
zico /ジーコ/
zidane /ジダン/
ziegler /ツィーグラー/
zigeuner /ツィゴイネル;(独語)ジプシー/
zigeunerweisen /ツィゴイネルワイゼン/チゴイネルワイゼン/
ziggy /Ｚｉｇｇｙ/
zigzag /ジグザグ/
zimbabwe /ジンバブエ;.zw/
zimbalon /ツィンバロン/
zimmerman /ツィンマーマン/
zina /ジナ/
zinc /ジンク;Zn/
zinedine /ジネディーヌ/
zinfandel /ジンファンデル/
zion /シオン;=Jerusalem/ジオン/ザイオン/
zionism /シオニズム/
zionist /シオニスト/
zip /ジップ/〒/
zipangu /ジパング/
zipfile /ZIPファイル/
ziplock /ジップロック/
zipper /ジッパー/
zippo /ジッポ;www.zippo.com/ジッポー/
zircon /ジルコン/
zirconia /ジルコニア/
zirconium /ジルコニウム;[元素]40,Zr/
zirkon /ジルコン/
zither /ツィター/シタール/
zizek /ジジェク/
zizi /ジジ/
zj /↓/
zjiku /Z軸/Ｚ軸/
zk /↑/
zl /→/
zn /亜鉛/Zinc/
znak /ъ;cyrillic (tvjordyj znak)/ь;cyrillic (xjaxkij znak)/
zodiac /ゾディアック/
zoe /ゾーイ/ゾエ/
zoff /ゾフ/
zola /ゾラ/
zoltan /ゾルタン/
zombie /ゾンビ/
zone /ゾーン/
zonedefence /ゾーンディフェンス/
zoning /ゾーニング/
zoo /ズー/
zoom /ズーム/
zoomin /ズームイン/
zooming /ズーミング/
zoomlens /ズームレンズ/
zoomout /ズームアウト/
zoot /ズート/
zoroaster /ゾロアスター/
zr /ジルコニウム/Zirconium/
zubrowka /ズブロッカ;(ポーランドのウォッカ)/
zucchini /ズッキーニ/
zuccotto /ズコット/
zurich /チューリッヒ/チューリヒ/
zyanose /チアノーゼ;(独語)/
zyklus /チクルス/ツィクルス/
{ /｛/
| /｜;pipe/│;罫線/┃;太い罫線/‖/
|- /├/┣/
|| /‖/
} /｝/
~ /〜/¬/‾/
ー /〜/
「 /『/【/〔/［/
」 /』/】/〕/］/
あ /亜/吾;私/彼;=吾/阿;阿呆/婀;婀娜っぽい/痾;宿痾/唖;聾唖/亞;「亜」の旧字(人名用漢字)/椏;また/娃;美女/哇/襾/安;?/明;?/嗚;?/
あ> /亜;亜熱帯,亜低木,亜硝酸/
あーくとう /アーク灯/
あーくほうでん /アーク放電/
あーくようせつ /アーク溶接;arc welding/
あーくろ /アーク炉/
あーけーどがい /アーケード街/
あーさーおう /アーサー王;Arthur King/
あーさーおうでんせつ /アーサー王伝説;roman arthurien/
あーすせん /アース線/
あーちがた /アーチ型/
あーちきょう /アーチ橋/
あーとし /アート紙/
あーとてん /アート展/
あーべるぐん /アーベル群/
あーりあじん /アーリア人;aryan/
ああ /嗚呼/噫/唖唖;カラスの声/あゝ/
あい /愛/相/藍/間/合/亜衣;人名/哀;悲哀/埃;(ほこり)塵埃/挨;挨拶/曖;曖昧/瞹;「曖」の異体字/靉/噫;ああ/欸/隘;狭隘/娃/藹;和気藹々/阨;≒隘/穢;(慣用音)/姶;姶良町/会;?/饗;?/
あい> /相;相まみえる,相勤める,相和す/愛;愛猫,愛バイク,愛労連(愛媛)/
あいあい /藹々;和気-/靄々/相合/藹藹/靄靄/
あいあいがさ /相合傘/相合い傘/
あいいく /愛育/
あいいそ /相磯/
あいいちろう /愛一郎/
あいいろ /藍色/
あいいん /愛飲/合印/
あいうえおじゅん /アイウエオ順/あいうえお順/
あいうち /相打ち/相討ち/相撃ち/
あいうら /相浦/
あいえ /藍絵/
あいえき /愛液/
あいえん /愛煙/
あいえんか /愛煙家/
あいえんきえん /合縁奇縁/
あいおい /相生/
あいか /哀歌/
あいかぎ /合鍵/合い鍵/
あいかた /相方/合方/
あいかわ /相川/愛川/鮎川/合川/
あいかわらず /相変わらず/
あいかん /哀感;pathos.「-漂う」/哀歓;pools of sorrow, waves of joy.「-を共にする」/
あいが /相賀/
あいがみ /間紙/藍紙/
あいがも /合鴨/間鴨;=合鴨/
あいがん /愛玩/哀願/
あいがんけん /愛玩犬/
あいがんどうぶつ /愛玩動物/
あいき /愛機/
あいきどう /合気道/
あいきゃく /相客/
あいきゅう /哀泣/
あいきょう /愛嬌/愛敬;=愛嬌/愛郷;-心/
あいきょうげん /間狂言/
あいぎ /合着/間着/
あいぎょう /愛敬;†愛され敬われる/愛楽;†愛し、求める/
あいぎん /愛吟/
あいくち /匕首/合口/合い口/
あいぐま /藍隈/
あいけい /愛敬/
あいけん /愛犬/
あいけんか /愛犬家/
あいこ /愛子/藍子/愛顧/アイ子/
あいこう /愛好/愛甲;地名/愛校/
あいこういしだ /愛甲石田/
あいこうか /愛好家/
あいこうかい /愛好会/
あいこうしゃ /愛好者/
あいこうしん /愛校心/
あいこうだいめいでん /愛工大名電/
あいこうぼん /愛好本/
あいこく /愛国/哀哭/
あいこくしん /愛国心/
あいことば /合言葉/合い言葉/
あいこんか /アイコン化/
あいご /愛護/愛語/
あいごま /合駒/合い駒/
あいさい /愛妻/
あいさいか /愛妻家/
あいさいごう /愛妻号/
あいさいべんとう /愛妻弁当/
あいさつ /挨拶/
あいさつご /挨拶語;Hello Bonjour 初めまして/
あいさつじょう /挨拶状/
あいさつまわり /挨拶回り/
あいさわ /相沢/
あいざわ /相沢/相澤/会沢/
あいし /哀史/間紙/哀詩/愛子/
あいしーかーど /ＩＣカード/ICカード/
あいしーたぐ /ＩＣタグ/ICタグ/
あいしかた /愛し方/
あいしゃ /愛車/愛社/
あいしゃせいしん /愛社精神/
あいしゅう /哀愁/愛執/
あいしょ /愛書/
あいしょう /相性/愛称/愛唱;†好んでうたう。「-歌集」/愛妾/哀傷/愛誦;†好んで口ずさむ。「ヴェルレーヌを-する」/合性/
あいしょううらない /相性占い/
あいしょうか /愛唱歌/
あいしょうきょく /愛唱曲/
あいしょうしんだん /相性診断/
あいしょうひょう /相性表/
あいしょうめい /愛称名/
あいしょうもんだい /相性問題/
あいしょか /愛書家/
あいしんかくら /愛新覚羅/愛新覺羅;旧字/
あいしんせいき /アイシン精機/
あいじ /愛児/
あいじゃく /愛著/
あいじょう /愛情/愛嬢/哀情/
あいじょうひょうげん /愛情表現/
あいじん /愛人/
あいすみちょう /愛住町/
あいず /合図/相図;=合図/会津;※仮名遣い「あいづ」/
あいずだい /会津大;※仮名遣い「あいづ」/
あいずだいがく /会津大学;※仮名遣い「あいづ」/
あいずばんだいさん /会津磐梯山;※仮名遣い「あいづ」/
あいずみ /藍住/
あいせき /相席/愛惜;大切にする/哀惜;悲しむ/合席/
あいせつ /哀切/
あいぜつ /哀絶/
あいぜん /愛染/
あいぜんみょうおう /愛染明王/
あいそ /愛想/哀訴/相磯/相曽/愛相/
あいそう /愛想/
あいそく /愛息/
あいそづかし /愛想尽かし/
あいそよく /愛想良く/
あいそわらい /愛想笑い/
あいそん /愛孫/
あいぞう /愛憎/愛蔵/
あいぞうげき /愛憎劇/
あいぞうばん /愛蔵版/
あいぞめ /藍染め/
あいたい /相対/靉靆/
あいたいばいばい /相対売買/
あいたしゅぎ /愛他主義;altruisme/
あいだ /間/相田/愛田/藍田/会田/合田/英田/
あいだい /愛大/
あいだがら /間柄/
あいだじゅう /間中/
あいだちょう /英田町/
あいち /愛知/相知/
あいちいかだいがく /愛知医科大学/
あいちいだい /愛知医大/
あいちかんじょうてつどう /愛知環状鉄道/
あいちがくせんだい /愛知学泉大/
あいちがくせんだいがく /愛知学泉大学/
あいちきょういくだい /愛知教育大/
あいちきょういくだいがく /愛知教育大学/
あいちきんろうかいかん /愛知勤労会館/
あいちぎんこう /愛知銀行/
あいちけん /愛知県/
あいちけんけい /愛知県警/
あいちけんじん /愛知県人/
あいちけんない /愛知県内/
あいちこうぎょうだいがく /愛知工業大学/
あいちこうじょう /愛知工場/
あいちこうせいねんきん /愛知厚生年金/
あいちこうだい /愛知工大/
あいちばんぱく /愛知万博;‖2005/
あいちべん /愛知弁/
あいちみと /愛知御津/
あいちゃく /愛着/合着;?/
あいちょう /愛聴/愛鳥/哀調/愛重/
あいちょうしゅうかん /愛鳥週間;bird week. 5.10-16/
あいちょうばん /愛聴盤/
あいつ /彼奴/
あいつぎ /相次/
あいづ /会津/
あいづき /相築/
あいづじょう /会津城/
あいづたかだ /会津高田/
あいづたじま /会津田島/
あいづだい /会津大/
あいづだいがく /会津大学/
あいづち /相槌/相づち/相鎚;=相槌/
あいづてつどう /会津鉄道/
あいづのうしょ /会津農書/
あいづばんだいさん /会津磐梯山/
あいづま /逢妻/
あいづわかまつ /会津若松/
あいづわかまつし /会津若松市/
あいて /相手/
あいてかた /相手方/
あいてがた /相手方/
あいてがわ /相手側/
あいてきぎょう /相手企業/
あいてきゅうだん /相手球団/
あいてきょく /相手局/
あいてぎんこう /相手銀行/
あいてこく /相手国/
あいてさき /相手先/
あいてしだい /相手次第/
あいてしゃりょう /相手車両/
あいてじんない /相手陣内/
あいてせいふ /相手政府/
あいてせんしゅ /相手選手/
あいてだしゃ /相手打者/
あいてとうしゅ /相手投手/
あいてやく /相手役/
あいてりきし /相手力士/
あいでぃーかーど /IDカード/
あいとう /哀悼/
あいどお /間遠/
あいどく /愛読/
あいどくしゃ /愛読者/
あいどくしょ /愛読書/
あいなかば /相半ば/
あいなめ /鮎魚女/鮎並/
あいにく /生憎/
あいぬご /アイヌ語;アイヌの言語。一部地名などに残る。/
あいぬみんぞく /アイヌ民族/
あいねずみ /藍鼠/
あいの /愛野/
あいのえき /愛野駅/
あいのこ /間の子/合いの子/
あいのす /愛の巣/
あいのちょう /愛野町/
あいのて /間の手/合いの手/合の手/
あいのみなこ /愛野美奈子/
あいのむち /愛の鞭/
あいのり /相乗り/
あいは /愛葉;名/
あいはら /相原/粟飯原/愛原/藍原;姓/合原/
あいはん /合判/相判/
あいば /愛馬/相羽/饗場/相庭/相場;姓/
あいばじょうほう /愛馬情報/
あいばら /相原/合原/
あいびき /逢引/逢い引き/合挽き/合挽/合い引き/
あいびょう /愛猫/
あいびょうか /愛猫家/
あいぴーあどれす /IPアドレス/
あいぴーでんわ /ＩＰ電話/IP電話/
あいふ /合符;手荷物合符/
あいふく /間服/合服/
あいふだ /合札/
あいぶ /愛撫/
あいべ /相部/
あいべつ /愛別/哀別/
あいべつりく /愛別離苦;愛する者との死別の苦しみ/
あいべや /相部屋/
あいぼ /愛慕/
あいぼう /相棒/
あいぼし /相星;[相撲]勝敗(星)数が同じ/
あいぼれ /相惚れ/
あいま /合間/合い間/
あいまあいま /合間合間/
あいまい /曖昧/
あいまいせい /曖昧性/
あいまいもこ /曖昧模糊/
あいまいやど /曖昧宿/
あいまって /相俟って/
あいみ /愛美/亜衣実/
あいみたがい /相身互い/
あいみつもり /合い見積もり;(concat "http:\057\057abc.trans.jp\057glossary\057aimitsu.htm")/
あいみるちゃ /藍海松茶/
あいもち /相持ち/
あいもと /相本/
あいもん /合文/
あいやく /相役/
あいやぐら /相矢倉;[将棋]/
あいやど /相宿/
あいやぶし /あいや節/
あいやま /相山/
あいよう /愛用/
あいようき /愛用機/
あいようしゃ /愛用者/
あいよく /愛欲/愛慾;=愛欲/
あいよし /相吉/
あいよつ /相四つ;[相撲]/
あいら /姶良;地名/吾平/
あいらく /哀楽/
あいり /愛里;名/
あいりん /愛輪/
あいるらんど /愛蘭/
あいれん /愛恋/哀憐;憐れむ/愛憐;愛し憐れむ/
あいろ /隘路/文色/
あいろんだい /アイロン台/
あいわ /哀話/
あいんすたいにうむ /Es/Einsteinium/
あう /央/奥/桜/奧;「奥」の旧字(人名用漢字)/媼;老女/櫻;「桜」の旧字(人名用漢字)/
あうすとろばいれやか /Austrobaileyaceae/
あうん /阿吽/
あえ /阿江/
あえぎ /喘ぎ/
あえぎごえ /喘ぎ声/
あえて /敢えて/
あえば /饗庭/
あえもの /和え物/韲え物/
あえり /愛絵理/
あえん /亜鉛/Zn/Zinc/
あえんか /亜鉛華/
あお /青/蒼/碧/
あお> /青;青ペン,青鉛筆,青線/
あおあお /青々/青青/蒼蒼/蒼々/
あおあざ /青痣/青アザ/
あおあらし /青嵐/
あおい /葵/青井/碧/
あおいきといき /青息吐息/
あおいけ /青池/
あおいし /青石/
あおいっしょく /青一色/
あおいとり /青い鳥;L'Oiseau Bleu, 1909, Maeterlinck/
あおいのうえ /葵上/葵の上;[源氏物語]/
あおいはな /青い花;Heinrich von Ofterdingen,1802,Garshin/
あおいまつり /葵祭/
あおいめ /青い目/
あおいもく /アオイ目/Malvales/
あおいもん /葵紋/
あおいろ /青色/
あおいろしんこく /青色申告/
あおうなばら /青海原/
あおうま /白馬;† NB:「あを」は本来白灰色/青馬;†/
あおうみがめ /青海亀/
あおえ /青江/青絵/
あおえきしょう /青液晶/
あおおに /青鬼/
あおかち /青褐/
あおかび /青黴/青カビ/青かび/
あおかん /青姦;[卑]/青かん/
あおがい /青貝/
あおがえる /青蛙/
あおがき /青垣/
あおがく /青学/青山学院大学;※abbrev/
あおがくだい /青学大/
あおがしま /青ヶ島/
あおがり /青刈り/
あおき /青木/
あおきいさお /青木功;人名/
あおきいろ /青黄色/
あおきがはら /青木ヶ原/
あおきこ /青木湖/
あおきこんよう /青木昆陽;人名/
あおきっぷ /青切符/
あおきばし /青木橋/
あおきん /青金/
あおぎいろ /青黄色/
あおぎり /青桐/榮;「栄」の旧字(人名用漢字)/
あおくさ /青草/
あおくび /青首/
あおくびだいこん /青首大根/
あおけいとう /青系統/
あおげ /青毛/
あおこーなー /青コーナー/
あおさ /石蓴/
あおさぎ /青鷺/
あおさび /青錆/
あおさぶらい /青侍/
あおざかな /青魚/
あおざむらい /青侍/
あおしお /青潮/
あおしか /青鹿/
あおしま /青島/青嶋/
あおしんごう /青信号/
あおじ /青地/
あおじそ /青紫蘇/青ジソ/
あおじゃしん /青写真/
あおじる /青汁/
あおすじ /青筋/
あおせざかな /青背魚/
あおせん /青線;赤線の外のモグリ/
あおそ /青麻/青苧/
あおぞら /青空/蒼空/
あおぞらいちば /青空市場/
あおぞらきょうしつ /青空教室/
あおぞらちゅうしゃ /青空駐車/
あおぞらぶんこ /青空文庫;電子テキストを多く集めたサイト。www.aozora.gr.jp/
あおた /青田/
あおたがい /青田買い/
あおたがり /青田刈り/青田刈/
あおたけ /青竹/
あおたん /青短;花札で青色の短冊の札および役/青痰/青丹;あおに?/
あおだいしょう /青大将/
あおだけ /青竹/
あおだけいろ /青竹色/
あおだけふみ /青竹踏み/
あおだたみ /青畳/
あおだち /青立ち/
あおだま /青玉/
あおち /青地/
あおちゃ /青茶;(jincha)烏龍茶など/
あおてんじょう /青天井/
あおでんわ /青電話/
あおと /青砥/青戸/
あおとうがらし /青唐辛子/
あおどうしん /青道心/
あおな /青菜;-に塩/
あおなし /青梨/
あおに /青二/青丹/
あおにさい /青二才/
あおにび /青鈍/
あおぬま /青沼/
あおね /青嶺/
あおねおんせん /青根温泉/
あおねぎ /青葱/青ネギ/
あおねこ /青猫/
あおの /青野/
あおのはら /青野原/
あおのり /青海苔/
あおはた /青旗/
あおば /青葉/
あおばえ /青蠅/
あおばかい /青葉会/
あおばきねんかいかん /青葉記念会館/
あおばく /青葉区/
あおばしょう /青葉賞/
あおばじょう /青葉城/
あおばじょうし /青葉城址/
あおばずく /青葉木菟/
あおばだい /青葉台/
あおばだいえき /青葉台駅/
あおばどおり /青葉通/
あおばばし /青葉橋/
あおばやま /青葉山/
あおばん /青版/青盤/
あおひげ /青髭/青髯;Barbe-Bleue, Perrault.妻殺し/
あおひょう /青票/
あおびかり /青光り/
あおびょうし /青表紙/青標紙;1840-41,大野広城/
あおぶさ /青房/
あおほん /青本/
あおぼうず /青坊主/
あおまめ /青豆/
あおみ /青み/青身;青魚の身/
あおみどり /青緑/
あおみどりいろ /青緑色/
あおみどりけい /青緑系/
あおみどろ /青味泥/水綿/
あおむぎ /青麦/
あおむけ /仰向け/
あおむし /青虫/
あおむらさき /青紫/
あおむらさきいろ /青紫色/
あおめ /青眼/
あおもじ /青文字/
あおもと /青本/
あおもの /青物/
あおものよこちょうえき /青物横丁駅/
あおもり /青森/
あおもりうんてんじょ /青森運転所/
あおもりえき /青森駅/
あおもりけん /青森県/
あおもりけんじん /青森県人/
あおもりし /青森市/
あおもりはこだてかん /青森函館間/
あおもりはつ /青森発/
あおもりべん /青森弁/
あおもん /青門/
あおや /青谷/青屋/
あおやき /青焼き;blueprint/青焼/
あおやぎ /青柳/
あおやなぎ /青柳/
あおやま /青山/
あおやまいっちょうめ /青山一丁目/
あおやまえんけいげきじょう /青山円形劇場/
あおやまがくいん /青山学院/
あおやまがくいんだい /青山学院大/
あおやまがくいんだいがく /青山学院大学/
あおやません /青山線/
あおやまちょう /青山町/
あおやまほうめん /青山方面/
あおやまぼち /青山墓地/
あおり /煽り/
あおりもんく /煽り文句/
あおんそく /亜音速/
あか /赤/垢/亜科;[生物]subfamily/閼伽;[仏教](argha) 仏前に供える水/淦;船底の水/絳;真紅/
あか> /赤;赤ペン,赤狩り,赤線/
あかあお /赤青/
あかあおみどり /赤青緑/
あかあか /赤々/明々/
あかあざ /赤痣/
あかあり /赤蟻/
あかい /赤井/
あかいえか /赤家蚊/
あかいがわ /赤井川/
あかいくつ /赤い靴/
あかいけ /赤池/
あかいけえき /赤池駅/
あかいし /赤石/
あかいしさんみゃく /赤石山脈/
あかいしだけ /赤石岳/
あかいっしょく /赤一色/
あかいでんき /赤井電機;[企業名]/
あかいぬ /赤犬/
あかいはね /赤い羽根/
あかいろ /赤色/
あかいわ /赤岩/赤磐/
あかいわえき /赤岩駅/
あかいわぐん /赤磐郡/
あかいわし /赤鰯/
あかうお /赤魚/
あかうま /赤馬/
あかうみがめ /赤海亀/
あかえ /赤絵/
あかえそ /赤狗母魚/
あかえだ /赤枝/
あかえび /赤海老/赤蝦/
あかえぼし /赤烏帽子;亭主の好きな-/
あかえんぴつ /赤鉛筆/
あかお /赤尾/
あかおか /赤岡/
あかおすぎ /赤尾杉/
あかおに /赤鬼/
あかおまな /赤御魚/
あかかげ /赤影/
あかかぶ /赤蕪;-の漬物/
あかがい /赤貝/
あかがしら /赤頭/
あかがね /銅/
あかがねいろ /銅色/
あかがみ /赤紙/
あかがり /赤狩り/赤狩/
あかがわ /赤川/
あかきっぷ /赤切符/
あかきゃべつ /赤キャベツ;red cabbage/
あかぎ /赤城/赤木/
あかぎいろ /赤黄色/
あかぎこうげん /赤城高原/
あかぎさん /赤城山/
あかぎちょう /赤城町/
あかぎつね /赤狐/
あかぎぬ /赤衣/
あかぎやま /赤城山/
あかぎれ /皸/皹/
あかくら /赤倉/
あかくろ /赤黒/
あかぐつ /赤靴;海魚/
あかぐま /赤熊/
あかぐみ /紅組;紅白歌合戦の-/赤組;運動会の-/
あかけいとう /赤系統/
あかげ /赤毛/
あかげら /赤啄木鳥/
あかげわしゅ /褐毛和種/
あかこーなー /赤コーナー/
あかこほん /赤小本/
あかご /赤子/赤児/
あかごめ /赤米/
あかさか /赤坂/
あかさかえき /赤坂駅/
あかさかほんしゃ /赤坂本社/
あかさかみつけ /赤坂見附/赤坂見付;※「赤坂見附」が正式/
あかさかみつけえき /赤坂見附駅/
あかさかみつけてん /赤坂見附店/
あかさかりきゅう /赤坂離宮/
あかさき /赤崎/赤碕/
あかさび /赤錆/
あかざ /藜/
あかざか /アカザ科/
あかざかな /赤魚/
あかざき /赤崎/
あかざとう /赤砂糖/
あかざわ /赤沢/赤澤/
あかざん /赤残/
あかし /明石/証/灯/證/赤司/証し/絳し/
あかしお /赤潮/
あかしかいきょう /明石海峡/
あかしかいきょうおおはし /明石海峡大橋/
あかしがわ /明石側/
あかしこう /明石港/
あかしし /明石市/
あかしな /明科/
あかしば /赤芝/
あかしま /暴/
あかしや /明石家/
あかしやき /明石焼/
あかしろ /赤白/
あかしんごう /赤信号/
あかしんぶん /赤新聞/
あかじ /赤字/赤地/
あかじかくご /赤字覚悟/
あかじがく /赤字額/
あかじく /赤字区/
あかじけっさん /赤字決算/
あかじこくさい /赤字国債/
あかじそ /赤紫蘇/
あかじはば /赤字幅/
あかじろせん /赤字路線/
あかすいしょう /赤水晶/
あかすり /垢擦り/
あかず /赤酢;紫蘇入り梅酢/
あかずきん /赤頭巾/
あかずのま /開かずの間/
あかせがわ /赤瀬川/
あかせがわげんぺい /赤瀬川原平/
あかせん /赤線/
あかぞめえもん /赤染衛門;やすらはで 寝なましものを さ夜ふけて かたぶくまでの 月をみしかな/
あかたにせん /赤谷線/
あかたん /赤短;花札で赤色の短冊の札および役/赤丹/
あかだし /赤出し/
あかだな /閼伽棚/
あかだま /赤玉/
あかだまつち /赤玉土;[園芸]関東ロームの土/
あかちゃ /赤茶/
あかちゃいろ /赤茶色/
あかちゃん /赤ちゃん/
あかちゃんよう /赤ちゃん用/
あかちょうちん /赤提灯/
あかちん /赤チン/
あかっぱじ /赤っ恥/
あかつか /赤塚/
あかつかふじお /赤塚不二夫/
あかつき /暁/垢付き/閼伽坏/曉;「暁」の旧字(人名用漢字)/
あかつきがた /暁方/
あかつきづくよ /暁月夜/
あかつきやみ /暁闇/
あかつち /赤土/赭/赭土/
あかつつみ /赤堤/
あかつめくさ /赤詰草/
あかてん /赤点/
あかでみーしょう /アカデミー賞;[映画]Academy Award/
あかでん /赤電/
あかでんわ /赤電話/
あかとうがらし /赤唐辛子/
あかとき /暁/
あかときづくよ /暁月夜/
あかとんぼ /赤蜻蛉/赤とんぼ/
あかどう /赤胴/
あかどまり /赤泊/
あかな /赤名/
あかなす /赤茄子/
あかに /赤丹/
あかにし /赤螺/
あかにんじゃ /赤忍者/
あかぬけ /垢抜け/
あかぬま /赤沼/
あかね /茜/朱子/
あかねいろ /茜色/
あかねか /アカネ科/Rubiaceae/
あかねぐも /茜雲/
あかねこ /赤猫/
あかねさす /茜さす/
あかねもく /アカネ目/Rubiales/
あかのたにん /赤の他人/
あかのひろば /赤の広場;モスクワの-/
あかはじ /赤恥/
あかはた /赤旗/旃/
あかはだ /赤膚/赤肌/
あかはだか /赤裸/
あかはな /赤鼻/
あかはに /赤埴/
あかはね /赤羽/
あかはら /赤腹/
あかばこ /赤箱/
あかばな /赤花/
あかばね /赤羽/赤羽根/
あかばねえき /赤羽駅/
あかばねせん /赤羽線/
あかばん /赤盤/
あかひげ /赤髭;鳥/
あかひと /赤人/
あかひら /赤平/
あかびょうし /赤表紙/
あかびら /赤平/
あかぴーまん /赤ピーマン/
あかふく /赤福/
あかふくほんてん /赤福本店/
あかふくもち /赤福餅/
あかふじ /赤富士;富嶽三十六景/
あかふじょう /赤不浄/
あかふだ /赤札/
あかぶさ /赤房/
あかぺん /赤ペン/
あかほ /赤穂/
あかほり /赤堀/
あかほん /赤本/
あかぼう /赤帽/
あかぼし /赤星/明星/
あかぼり /赤堀/
あかま /赤間/
あかまい /赤米/
あかまえき /赤間駅/
あかまじんぐう /赤間神宮/
あかまつ /赤松/
あかまど /赤窓/
あかまる /赤丸/
あかまるきゅうじょうしょう /赤丸急上昇/
あかまるじょうしょうちゅう /赤丸上昇中/
あかまんぼう /赤翻車魚/
あかまんま /赤飯/
あかみ /赤身/赤み/
あかみず /赤水/閼伽水;仏に供える水/
あかみそ /赤味噌/赤みそ/
あかみどり /赤緑/
あかみどりいろ /赤緑色/
あかむし /赤虫/
あかむらさき /赤紫/
あかむらさきいろ /赤紫色/
あかめ /赤目/
あかめいも /赤芽芋/
あかめがしわ /赤芽柏/
あかめぐち /赤目口/
あかもん /赤門/
あかゆ /赤湯/
あかゆき /赤雪/
あから /赤ら/
あからがお /赤ら顔/
あからく /赤楽/
あからしま /暴/
あからんぷ /赤ランプ;red light/
あかり /明かり/灯り/灯/明り/燈;「灯」の旧字(人名用漢字)/
あかりとり /明かり取り/明り取り/
あかりまど /明かり窓/明り窓/
あかるみ /明るみ/
あかれんが /赤煉瓦/赤レンガ/
あかわいん /赤ワイン/
あかん /阿寒/
あかんこ /阿寒湖/
あかんたい /亜寒帯/
あかんちょう /阿寒町/
あかんぼう /赤ん坊/
あがおか /阿賀岡/
あがた /県/
あがつま /吾妻/我妻/
あがない /贖い/贖/
あがの /阿賀野/
あがのがわ /阿賀野川/
あがほ /英賀保/
あがり /上がり/上り/
あがりかた /上がり方/
あがりかまち /上がり框/
あがりがまち /上がり框/
あがりさがり /上がり下がり/
あがりしょう /上がり性/
あがりた /揚田/
あがりだか /上がり高/
あがりば /上がり場/
あがりめ /上がり目/
あがりゆ /上がり湯/
あがわ /阿川/吾川/
あき /秋/安芸/空/空き/亜希/亜紀/亜季/亜樹/光/明/章/晶/昭/暁/晃/亮/哲/彰/朗/顕/彬/安岐/璋/晄;「晃」の異体字(人名用漢字)/晶紀/穐;「秋」の異体字/龝/晢/晰/朖/
あき> /空き;(vacant) -部屋,-スロット/
あきあかね /秋茜/
あきあき /飽き飽き/厭き厭き/
あきあじ /秋味/
あきいこう /秋以降/
あきう /秋保/
あきうみ /明生/
あきえ /明恵/章江/秋江/昭江/秋絵/晃枝/亜紀恵/
あきお /昭夫/明夫/昭雄/章夫/昭男/明男/明雄/彰夫/暁生/秋夫/秋男/秋雄/晶夫/亜希夫/晃夫/明央/彬生/
あきおか /秋岡/
あきおみ /明臣/
あきかず /彰一/
あきかぜ /秋風/
あきかわ /秋川/
あきかわけいこく /秋川渓谷/
あきかん /空き缶/空缶/空き罐/
あきがせ /秋ケ瀬/
あきがわ /秋川/
あきぎり /秋霧/
あきく /安芸区/
あきぐち /秋口/
あきぐん /安芸郡/
あきけいば /秋競馬/
あきげしき /秋景色/
あきこ /亜希子/晶子/明子/晃子/亜紀子/章子/昭子/暁子/彰子/顕子/朗子/亜季子/亜樹子/朱子/亜以子;?/
あきごう /秋号/
あきごえ /秋肥/
あきごろ /秋頃/
あきさと /穐里/
あきさば /秋鯖/
あきさめ /秋雨/
あきさめぜんせん /秋雨前線;秋の長雨をもたらす/
あきさわ /秋澤/
あきざくら /秋桜/
あきしぐれ /秋時雨/
あきしつ /空き室/
あきしの /秋篠/
あきしのでら /秋篠寺/
あきしののみや /秋篠宮/
あきしま /昭島/安芸島/
あきしまし /昭島市/
あきしょう /飽き性/
あきしょせん /秋初戦/
あきじかん /空き時間/空時間/
あきす /空き巣/空巣/
あきすえ /秋末/
あきすねらい /空き巣狙い/空巣狙い/
あきせき /空き席/
あきぞら /秋空/
あきた /秋田/飽田;地名,熊本/
あきたいぬ /秋田犬/
あきたえき /秋田駅/
あきたぎんこう /秋田銀行/
あきたけん /秋田県/秋田犬/
あきたこまち /秋田小町/
あきたし /秋田市/
あきたしょてん /秋田書店;[出版社名]www.akitashoten.co.jp/
あきたじんく /秋田甚句;[民謡]「キタカサイサイ」/
あきただい /秋田大/
あきただいがく /秋田大学/
あきたに /秋谷/
あきたべん /秋田弁/
あきだい /秋大/
あきち /空き地/空地/
あきつ /秋津/蜻蛉/安芸津/
あきつぐ /明二/
あきつしま /秋津島/
あきづき /秋月/
あきづきでんし /秋月電子/
あきと /彰人/
あきとし /彰俊/明敏/晃年/秋利/
あきとも /秋友/
あきな /明菜/
あきない /商い/
あきないぐち /商い口/
あきなが /秋永/
あきなぎ /秋奈祇/
あきなす /秋茄子/
あきなり /秋成/章成/
あきなる /秋成/
あきの /秋野/昭乃/
あきのこえ /秋の声;-を聞く/
あきのそら /秋の空;変わりやすいもの。「女心と-」/
あきのひ /秋の日/
あきのよ /秋の夜/
あきのよのながものがたり /秋夜長物語/
あきのり /明徳/明憲/昭憲/昭則/明紀/昭徳/彰則/晃紀/晧則/
あきは /秋葉/
あきはさん /秋葉山/
あきはばら /秋葉原/
あきはばらえき /秋葉原駅/
あきはばらかかく /秋葉原価格/
あきば /秋葉/秋場/秋庭/
あきばけい /アキバ系;[新語]秋葉原系/
あきばこ /空箱/
あきばしょ /秋場所/
あきばれ /秋晴れ/秋晴/
あきひこ /明彦/昭彦/彰彦/秋彦/暁彦/晶彦/祥彦/
あきひさ /彰久/顕尚/
あきひで /彰英/
あきひと /昭仁/明仁/祥仁/
あきひろ /明宏/昭宏/明弘/彰宏/章宏/昭博/晃弘/章弘/明広/明浩/章博/昭弘/明大/昭浩/章裕/章浩/明裕/晃宏/晃広/章広/暁宏/彰広/哲裕/碩宏/
あきびえ /秋冷え/
あきびより /秋日和/
あきびん /空瓶/空ビン/
あきふく /秋服/
あきふみ /明文/章文/晶文/
あきふゆ /秋冬/
あきぶもん /空部門/
あきべや /空き部屋/空部屋/
あきほ /明穂/秋穂/秋保/
あきま /秋間/空き間/
あきまき /秋蒔き;[園芸]autumn sowing/
あきまつり /秋祭り/秋祭/
あきまで /秋迄/
あきまる /秋丸/
あきみ /秋生/
あきみず /秋水/
あきみち /明倫/
あきみつ /彬光/章充/
あきむら /秋村/
あきめ /秋芽/
あきめくら /明き盲/
あきもと /秋元/秋本/
あきもの /秋物/
あきものがたり /秋物語/
あきもよう /秋模様/
あきや /空家/空き家/空き屋/空屋/明き家/
あきやさい /秋野菜/
あきやしき /空屋敷/
あきやす /彰康/
あきやすみ /秋休み/
あきやま /秋山/
あきゅーせいでん /阿Ｑ正伝;(1921)魯迅/
あきゅう /秋保/
あきゅうせい /亜急性/
あきゆき /昭如/
あきょう /阿膠/阿嬌/
あきよ /明代/晃代/
あきようりょう /空き容量/空容量/
あきよし /秋吉/昭義/明良/昭良/明吉/彰芳/
あきよしくみこ /秋吉久美子/
あきよしだい /秋吉台/
あきよしどう /秋芳洞/
あきら /光/明/章/輝/晶/陽/昭/晃/彰/暁/亮/聡/朗/啓/鑑/旭/顕/亨/彬/洸/日明/曉;「暁」の旧字(人名用漢字)/晧/顯;「顕」の旧字(人名用漢字)/滉/璋/晄;「晃」の異体字(人名用漢字)/昜/朖/
あきらか /明らか/明か;(非正則)/曠/昿/
あきらめ /諦め/
あきらめがお /諦め顔/
あきりすと /空きリスト/
あきりょういき /空領域/
あきれ /呆れ/
あきれがお /呆れ顔/あきれ顔/
あきれすけん /アキレス腱/
あきんど /商人/
あきんどやど /商人宿/
あぎ /阿木/亜木/阿魏/吾君/顎/
あぎと /顎/鰓/顎門/
あぎなし /顎無し/
あぎに /阿耆尼/
あぎょう /ア行/あ行/
あく /悪/灰汁/握;握力/幄;天幕/渥;(厚い)/阿久;人名/軛;くびき/齷;齷齪/堊;つち/惡;「悪」の旧字(人名用漢字)/空/
あくあらい /灰汁洗い/
あくい /悪意/阿久井/
あくいん /悪因/
あくいんあっか /悪因悪果;悪い原因に伴う悪い結果/
あくいんしょう /悪印象/
あくうかん /亜空間/
あくうん /悪運/
あくえいきょう /悪影響/
あくえき /悪疫/
あくえきしつ /悪液質;癌腫等の末期の衰弱状態/
あくえん /悪縁/
あくかんきょう /悪環境/
あくかんじょう /悪感情/
あくぎ /悪戯/
あくぎゃく /悪逆/悪虐/
あくぎゃくむどう /悪逆無道/
あくぎょう /悪行/悪業/
あくげんた /悪源太/
あくこうか /悪効果/
あくごう /悪業/
あくさい /悪妻/悪才/
あくさく /齷齪/
あくざいりょう /悪材料/
あくしつ /悪質/悪疾/
あくしつか /悪質化/
あくしゃ /幄舎/
あくしゅ /握手/悪手/悪趣;[仏教]/
あくしゅう /悪臭;stink/悪習;vice/
あくしゅうぼうしほう /悪臭防止法/
あくしゅかい /握手会/
あくしゅけん /握手券/
あくしゅみ /悪趣味/
あくしょ /悪書;bad book/悪所/
あくしょう /悪性/
あくしょついほう /悪書追放/
あくしん /悪心/
あくじ /悪事/
あくじき /悪食/
あくじせんり /悪事千里/
あくじゅんかん /悪循環/
あくじょ /悪女/
あくじょう /悪尉/
あくじょうけん /悪条件/
あくじょうけんか /悪条件下/
あくせい /悪性/悪政;misrule/悪声;bad voice/
あくせいか /悪性化/
あくせいこくしょくしゅ /悪性黒色腫/
あくせいしゅよう /悪性腫瘍/
あくせいど /悪性度/
あくせいりんぱしゅ /悪性リンパ腫/
あくせく /齷齪/
あくせすかいせき /アクセス解析/
あくせすけん /アクセス権;[電算]permission/
あくせすじょうきょう /アクセス状況/
あくせすすう /アクセス数/
あくせん /悪銭/悪戦/
あくせんくとう /悪戦苦闘/
あくせんと /accent;その音を特に強く/
あくせんときごう /アクセント記号/
あくぜい /悪税/
あくそう /悪相/悪僧/
あくそうきゅう /悪送球;[野球]/
あくた /芥/
あくたい /悪態/
あくたがわ /芥川/
あくたがわしょう /芥川賞/
あくたがわしょうこうほ /芥川賞候補/
あくたがわやすし /芥川也寸志/
あくたがわりゅうのすけ /芥川龍之介/
あくたれ /悪たれ/
あくたろう /悪太郎;いたずらっ子/
あくだいかん /悪代官/
あくだま /悪玉/
あくだまか /悪玉化;「コレステロールの-」「旧体制の-」/
あくだまきん /悪玉菌;⇔善玉菌/
あくだまこれすてろーる /悪玉コレステロール/
あくち /悪血/
あくちしき /悪知識/
あくちにうむ /Ac/Actinium/
あくちにうむけいれつ /アクチニウム系列;4n+3系列/
あくつ /阿久津/圷/
あくてん /悪天/
あくてんこう /悪天候/
あくてんこうじ /悪天候時/
あくと /踵/悪徒/
あくとう /悪党/悪投/
あくとく /悪徳/
あくとくしょうにん /悪徳商人/
あくとくしょうほう /悪徳商法/
あくとくふどうさんや /悪徳不動産屋/
あくどう /悪童/悪道/
あくなき /飽くなき/
あくにち /悪日/
あくにん /悪人/
あくにんしょうき /悪人正機/
あくにんしょうきせつ /悪人正機説/
あくぬき /灰汁抜き/
あくね /阿久根/
あくねん /悪念/
あくねんぴ /悪燃費/
あくのはな /悪の華;Les Fleurs du Mal,1857-61,Baudelaire/
あくはつとほ /握髪吐哺/
あくば /悪罵/
あくひつ /悪筆/
あくひょう /悪評/
あくひょうばん /悪評判/
あくび /欠伸/悪日/欠/
あくびょう /悪病/
あくびょうどう /悪平等/
あくふ /握斧;handaxe/
あくふう /悪風/
あくぶん /悪文/
あくへい /悪弊/
あくへき /悪癖/
あくへん /悪変/
あくほう /悪法/悪報/
あくぼくとうせん /悪木盗泉/
あくま /悪魔/
あくまがったい /悪魔合体/
あくまじょう /悪魔城/
あくますうはい /悪魔崇拝/
あくまてき /悪魔的/
あくまで /飽く迄/
あくまばらい /悪魔払い;?/
あくみ /飽海/
あくみょう /悪名/
あくむ /悪夢/
あくめい /悪名/
あくもん /悪問/
あくやく /悪役/
あくゆう /悪友/阿久悠/
あくよう /悪用/
あくようかのう /悪用可能/
あくらつ /悪辣/
あくりゅう /悪竜/
あくりょう /悪霊/
あくりょうたいさん /悪霊退散/
あくりょく /握力/
あくりょくけい /握力計/
あくりるえのぐ /アクリル絵の具;acrylic paint/アクリル絵具/
あくりるじゅし /アクリル樹脂/
あくりるせい /アクリル製/
あくる /明くる/
あくるあさ /明くる朝/
あくるひ /明くる日/
あくれい /悪例/
あくろ /悪路/
あぐい /阿久比/安居院/安食/
あぐさ /阿草/
あぐに /粟国/
あぐら /胡座/胡坐/胡床/趺坐;NB:「ふざ」とも/
あぐらなべ /安愚楽鍋;仮名垣魯文/
あぐり /亜久里/
あぐん /亜群/
あけ /朱/明け/暁/曉;「暁」の旧字(人名用漢字)/明/
あけお /暁生/
あけがた /明け方/
あけがらす /明烏/
あけくれ /明け暮れ/
あけこ /朱子/
あけしめ /開け閉め/
あけすけ /明け透け;point-blank. 「-に言う」/
あけたて /開け閉て/
あけち /明智/
あけちこごろう /明智小五郎/
あけちたんてい /明智探偵/
あけちみつひで /明智光秀/
あけっぴろげ /開けっ広げ/
あけに /明荷;[相撲]/
あけの /明野/
あけのみょうじょう /明けの明星;the evening star (金星)/
あけはま /明浜/
あけび /木通/通草/
あけびか /アケビ科/Lardizabalaceae/
あけぼの /曙/
あけぼのいろ /曙色/
あけぼのばし /曙橋/
あけみ /明美/朱美/暁美/朱実/明海/明珠/
あけわたし /明け渡し/
あげ /上げ/揚げ/揚/上/安芸/
あげあし /揚げ足;-を取る/上げ足/上足/挙げ足/揚足/挙足/
あげあしとり /揚げ足取り/
あげあぶら /揚げ油/
あげいた /上げ板/
あげお /上尾/
あげおえき /上尾駅/
あげおし /上尾市/
あげおろし /上げ下ろし;布団の-/
あげかじ /上げ舵/
あげがし /揚げ菓子/
あげぎょうざ /揚げ餃子/揚餃子/
あげく /挙句/挙げ句/揚げ句;=挙げ句/揚句;=挙(げ)句/上げ句;?/
あげくだし /上げ下し/
あげくのはて /挙句の果て/挙げ句の果て/
あげさげ /上げ下げ/
あげしお /上げ潮/上潮/
あげぜん /上げ膳/
あげぜんすえぜん /上げ膳据え膳;至れり尽せり/
あげぞこ /上げ底/上底/
あげだい /揚代/
あげだし /揚げ出し;-豆腐/揚出し;-豆腐/
あげだしどうふ /揚げ出し豆腐;居酒屋の定番/揚出し豆腐/
あげだま /揚げ玉/揚玉;天かす/
あげち /上地/揚地/
あげつらい /論い/
あげど /揚げ戸/揚戸/
あげどうふ /揚げ豆腐;油揚げ/揚豆腐/
あげなべ /揚げ鍋/
あげの /揚野/
あげは /揚羽/
あげはちょう /揚羽蝶/
あげはば /上げ幅/
あげはま /揚浜;[囲碁] 取った石/揚げ浜;-式塩田/
あげば /揚場/揚げ場/
あげばり /幄/
あげぱん /揚げパン/
あげひばり /揚げ雲雀/
あげぶた /上げ蓋/
あげまい /上米;[日本史]享保の改革/
あげまき /揚巻/総角/
あげまつ /上松/
あげもち /揚げ餅/
あげもの /揚げ物/
あげや /揚屋/
あげやいり /揚屋入り/
あこ /吾子/亜古/彼所;there/亜子/
あこう /赤穂/亜綱/赤魚/
あこうざんたい /亜高山帯/
あこうせん /赤穂線/
あこうそく /亜光速/
あこうだい /赤魚鯛/阿候鯛/
あこうろうし /赤穂浪士/
あこがれ /憧れ/憬れ;=憧れ/
あこぎ /阿漕/
あこそ /阿古曽;地名,三重/阿古曾/
あこめ /衵/袙/
あこや /阿古屋/
あこやがい /阿古屋貝/
あご /顎/阿児/飛魚/
あごひげ /顎鬚/鬚/
あごひも /顎紐/
あごわん /英虞湾/
あさ /朝/麻/浅/晨/阿佐/厚狭/安佐/淺;「浅」の旧字/
あさあめ /朝雨/
あさい /浅井/朝井/淺井;「浅」旧字/
あさいち /朝市/朝一/朝イチ/
あさいちばん /朝一番/
あさいと /麻糸/麻絲;「糸」旧字/
あさいり /浅煎り/浅炒り/
あさえだ /朝枝/浅枝/
あさお /麻生/浅尾/朝雄/
あさおか /朝丘/朝岡/麻丘/浅丘/
あさおき /朝起き/
あさおり /麻織/
あさおりもの /麻織物/
あさか /朝霞;地名,埼玉/安積;地名,福島/浅香;地名,=安積/朝加;人名/
あさかげ /朝影/
あさかぜ /朝風/
あさかそすい /安積疎水/安積疏水/
あさかのみや /朝香宮/
あさかわ /浅川/朝川/
あさが /浅賀/朝賀/
あさがえり /朝帰り/
あさがお /朝顔/蕣/
あさがおいち /朝顔市/
あさがけ /朝駆/
あさがすみ /朝霞/
あさがた /朝方;⇔夕方/朝型;⇔夜型/
あさがみ /麻上/
あさがや /阿佐ヶ谷/阿佐谷/
あさき /麻木/
あさきた /安佐北/
あさきたく /安佐北区/
あさぎ /浅葱/浅黄/麻木/浅木/
あさぎいろ /浅葱色/
あさぎうら /浅葱裏/
あさぎぬ /麻衣/
あさぎまく /浅葱幕/
あさぎり /朝霧/
あさぎりこうげん /朝霧高原/
あさくさ /浅草/
あさくさえき /浅草駅/
あさくさこうかいどう /浅草公会堂/
あさくさしんげきじょう /浅草新劇場/
あさくさせん /浅草線/
あさくさのり /浅草海苔/
あさくさばし /浅草橋/
あさくさばしえき /浅草橋駅/
あさくさほうめん /浅草方面/
あさくち /浅口/
あさくら /朝倉/浅倉/麻倉/
あさくらえき /朝倉駅/
あさくらしょてん /朝倉書店;[出版社名]www.asakura.co.jp/
あさぐつ /浅沓/
あさけ /朝明/
あさげ /朝餉/
あさげいこ /朝稽古/
あさこ /麻子/朝子/浅子/あさ子/亜抄子/
あさご /朝来/
あさごはん /朝御飯/朝ご飯/朝ごはん/
あさざけ /朝酒/
あさしお /朝潮/
あさしな /浅科/
あさしも /朝霜/
あさしゃん /朝シャン/
あさしろ /麻城/
あさじ /朝地;地名/浅茅/朝事/
あさじう /浅茅生;-の(小野[枕詞])/
あさじうの /浅茅生の/
あさじえ /浅知恵/
あさすおう /浅蘇芳/
あさせ /浅瀬/
あさせん /阿佐線/
あさぞら /朝空/
あさだ /浅田/麻田/朝田/阿佐田/
あさだあきら /浅田彰/
あさだあめ /浅田飴/
あさだき /浅炊き/
あさだち /朝立ち/
あさだみよこ /浅田美代子/
あさぢ /浅茅/
あさぢえ /浅知恵/
あさって /明後日/
あさっぱら /朝っぱら/朝っ腹/
あさつき /浅葱/胡葱/
あさつゆ /朝露/
あさづきよ /朝月夜/
あさづくよ /朝月夜/
あさづけ /浅漬/浅漬け/
あさづま /朝妻/
あさてい /朝定/
あさで /朝出/浅手/浅傷;⇔深傷/
あさと /朝戸/麻人;人名/
あさどやゆんた /安里屋ユンタ;[民謡]沖縄/
あさどら /朝ドラ/
あさなぎ /朝凪/
あさなべ /浅鍋/
あさなゆうな /朝な夕な/
あさなわ /麻縄/
あさぬの /麻布/
あさぬま /浅沼/
あさね /朝寝/
あさねぼう /朝寝坊/
あさの /浅野/
あさのは /麻の葉/
あさのぶ /朝信/
あさのみ /麻の実/
あさはか /浅はか/
あさはなだ /浅縹/
あさはやく /朝早く/
あさはら /浅原/麻原/
あさば /浅場/浅羽;地名/
あさばん /朝晩/
あさひ /朝日/旭/朝陽/
あさひかせい /旭化成;[企業名]/
あさひかせいこうぎょう /旭化成工業;[企業名]/
あさひかせいじょうほう /旭化成情報/
あさひかわ /旭川/
あさひかわえき /旭川駅/
あさひかわけいばじょう /旭川競馬場/
あさひかわし /旭川市/
あさひかわせん /旭川線/
あさひがおか /旭ヶ丘/旭ケ丘/旭が丘/朝日ヶ丘/
あさひがらす /旭硝子/
あさひがわ /旭川/
あさひぎんこう /あさひ銀行/
あさひく /旭区/
あさひけい /朝日系/
あさひけいれつ /朝日系列/
あさひこうよう /朝日航洋/
あさひしゅっぱんしゃ /朝日出版社;[出版社名]/
あさひしんぶん /朝日新聞/
あさひしんぶんけい /朝日新聞系/
あさひしんぶんしゃ /朝日新聞社;[企業名]www.asahi.com/
あさひしんぶんちょうかん /朝日新聞朝刊/
あさひしんぶんゆうかん /朝日新聞夕刊/
あさひせいめい /朝日生命/
あさひせんしょ /朝日選書/
あさひそのらま /朝日ソノラマ/
あさひだい /旭台/
あさひだけ /旭岳/
あさひちょう /朝日町/
あさひちょうかん /朝日朝刊/
あさひつうしんしゃ /旭通信社/
あさひな /朝比奈/朝日奈/
あさひなたかし /朝比奈隆/
あさひはい /朝日杯/
あさひびーる /朝日麦酒/
あさひぶんこ /朝日文庫/
あさひほうそう /朝日放送/
あさひまち /旭町/
あさひむら /朝日村/
あさひや /旭屋/
あさひやしょてん /旭屋書店/
あさひやま /朝日山/
あさひゆうかん /朝日夕刊/
あさひる /朝昼/
あさひるばん /朝昼晩/
あさびん /朝便/
あさふく /浅福/
あさぶ /麻生/麻布/
あさぶき /麻吹/
あさぶくろ /麻袋/
あさぶろ /朝風呂/
あさほうそう /朝放送/
あさぼらけ /朝ぼらけ;曙,東雲/
あさま /浅間/朝間/
あさまおんせん /浅間温泉/
あさまさんそうじけん /浅間山荘事件/
あさました /浅間下/
あさまじんじゃ /浅間神社/
あさまつ /朝松/
あさまやま /浅間山/
あさみ /麻美/あさ美/浅見/亜沙美/麻見/朝美/亜左美/
あさみぞ /麻溝/
あさみどり /浅緑/
あさみなみ /安佐南/
あさみなみく /安佐南区/
あさみや /朝宮/麻宮;人名/
あさむし /浅虫/浅蒸し/
あさむらさき /浅紫/
あさめし /朝飯/朝メシ/
あさめしまえ /朝飯前/
あさもや /朝靄/
あさやけ /朝焼け/
あさやま /朝山/浅山/
あさゆ /朝湯/
あさゆう /朝夕/
あさり /浅蜊/浅利/朝里/蜊/鯏/漁り/
あさりじる /浅蜊汁/あさり汁/アサリ汁/
あされん /朝練/
あさんかちっそ /亜酸化窒素;N2O/
あざ /字/痣/黶;=痣/
あざい /浅井/
あざな /字/字名/
あざぶ /麻布/
あざぶじゅうばん /麻布十番/
あざぶだい /麻布台/
あざみ /薊/
あざみうま /薊馬/
あざやか /鮮やか/鮮か/
あざらし /海豹/
あざわらい /嘲笑い/
あし /足/脚;(椅子の-,動物の-)/芦;「蘆」の異体字/葦;=芦/葭;=葦/蘆/悪し/
あしあと /足跡/
あしいろ /足色/
あしうら /足裏/
あしお /足尾/
あしおえき /足尾駅/
あしおざん /足尾山/
あしおせん /足尾線/
あしおと /足音/跫/脚音/
あしおどうざん /足尾銅山;[日本史]-鉱毒事件/
あしおり /足折/
あしか /海驢/葦鹿;=海驢/
あしかが /足利/
あしかがうじみつ /足利氏満;1359-98/
あしかががっこう /足利学校/
あしかがけ /足利家/
あしかがけいば /足利競馬/
あしかがこうぎょうだいがく /足利工業大学/
あしかがこうこう /足利高校/
あしかがし /足利氏/
あしかがしげうじ /足利成氏;1438-97/
あしかがじだい /足利時代;室町時代/
あしかがたかうじ /足利尊氏;[日本史]初代 (1305-1358 在職:1338-58)/
あしかがただふゆ /足利直冬/
あしかがただよし /足利直義;1306-52/
あしかがばくふ /足利幕府/
あしかがぶんこ /足利文庫/
あしかがまさとも /足利政知;1435-91/
あしかがもちうじ /足利持氏;1398-1439/
あしかがもとうじ /足利基氏;1340-67/
あしかがよしあき /足利義昭;[日本史]十五代 (1537-97 在職:1568-73)/
あしかがよしあきら /足利義詮;[日本史]二代 (1330-67 在職:1358-67)/
あしかがよしかず /足利義量;[日本史]五代 (1407-25 在職:1423-25)/
あしかがよしかつ /足利義勝;[日本史]七代 (1434-43 在職:1442-43)/
あしかがよしずみ /足利義澄;[日本史]十一代(1480-1511 在職:1494-1508)/
あしかがよしたね /足利義稙;[日本史]十代 (1466-1523 在職:1490-93,1508-21)/
あしかがよしてる /足利義輝;[日本史]十三代 (1536-65 在職:1546-65)/
あしかがよしのり /足利義教;[日本史]六代 (1394-41 在職:1429-41)/
あしかがよしはる /足利義晴;[日本史]十二代 (1511-50 在職:1521-46)/
あしかがよしひさ /足利義尚;[日本史]九代 (1465-89 在職:1473-89)/
あしかがよしひで /足利義栄;[日本史]十四代 (1538-68 在職:1568)/
あしかがよしまさ /足利義政;[日本史]八代 (1436-90 在職:1449-73)/
あしかがよしみ /足利義視;1439-91/
あしかがよしみつ /足利義満;[日本史]三代 (1358-1408 在職:1368-1408)/
あしかがよしもち /足利義持;[日本史]四代 (1386-1428 在職:1394-1423)/
あしかけ /足掛け/足掛/
あしかせ /足枷/桎/鐐/
あしからず /悪しからず/
あしかり /芦刈/
あしかわ /芦川/
あしがかり /足掛かり/足掛り/足がかり/
あしがた /足型/足形/
あしがため /足固め/
あしがなえ /足鼎/
あしがら /足柄/
あしがらえき /足柄駅/
あしがらかみ /足柄上/
あしがらしも /足柄下/
あしがらとうげ /足柄峠/
あしがらみ /足搦み/
あしがらやま /足柄山;地名/
あしがる /足軽/
あしがわ /芦川/
あしき /悪しき/
あしきしゅうきゅう /ア式蹴球/
あしきた /芦北/葦北/
あしきょう /芦響/
あしきり /足切り;センター試験の-/
あしくせ /足癖/
あしくび /足首/
あしくびねんざ /足首捻挫/
あしぐみ /足組み/
あしげ /芦毛/足蹴/葦毛;=芦毛/
あしげい /足芸/
あしこぎ /足漕ぎ/
あしこし /足腰/脚腰/
あしごしらえ /足拵え/
あしさき /足先/脚先/
あしさばき /足捌き;footwork/
あしざま /悪し様/
あしざわ /芦沢/芦澤/
あしざわり /足触り;-のいいカーペット/
あししげく /足繁く/
あししろ /足代;足場/
あしずもう /足相撲/
あしずり /足摺/
あしずりみさき /足摺岬/
あしそこ /足底/
あしぞこばん /足底板/
あした /明日/朝/晨;あさ/
あしたか /愛鷹/
あしたば /明日葉/鹹草/
あしだ /芦田/
あしだい /足代/
あしだひとし /芦田均/
あしつき /足付/足付き/
あしつぎ /足継ぎ/
あしづかい /足遣い/
あしづけ /足付/
あしてまとい /足手纏い/
あしで /足手/葦手/
あしでえ /葦手絵/
あしでまとい /足手纏い/
あしでもじ /葦手文字/
あしとり /足取り/
あしどめ /足止め/足止/足留め/
あしどり /足取り/足鳥/
あしな /芦名/足名/蘆名/芦品/
あしなえ /跛/蹇/
あしなが /足長/
あしなみ /足並み/足並/
あしならし /足慣らし/
あしぬけ /足抜け/
あしのこ /芦ノ湖/
あしのこう /足の甲/
あしはこび /足運び/
あしはら /芦原/葦原/蘆原/
あしはらちゅう /芦原中/
あしはらちゅうがっこう /芦原中学校/
あしはらのなかつくに /葦原の中つ国/
あしば /足場/
あしばや /足早/
あしばらい /足払い/
あしひきの /足引きの;(枕詞) -山/
あしび /馬酔木/
あしびょうし /足拍子/
あしふき /足拭き/
あしぶえ /葦笛/
あしぶね /葦舟/葦船/
あしぶみ /足踏み/足踏/
あしぶみじょうたい /足踏み状態/
あしへん /足偏/
あしべ /芦辺/芦部/
あしべつ /芦別/
あしぼね /足骨/
あしまえ /足前/
あしまかせ /足任せ/
あしまわり /足回り/
あしめ /走目/
あしもと /足元/足下/足許/脚元/
あしもの /脚物;椅子やテーブルなど/
あしもり /足守/
あしゃ /唖者/
あしや /芦屋/芦谷/
あしやがわ /芦屋川/
あしやがわえき /芦屋川駅/
あしやがんのすけ /芦屋雁之助/
あしやし /芦屋市/
あしやす /芦安/
あしやすめ /足休め/
あしゅ /亜種/
あしゅう /阿州;阿波/
あしゅら /阿修羅/
あしゅらぞう /阿修羅像/
あしゅらどう /阿修羅道/
あしゆ /足湯/脚湯/
あしゆび /足指/趾/
あしょうさん /亜硝酸/
あしょうさんえん /亜硝酸塩/
あしょうさんのうど /亜硝酸濃度/
あしょろ /足寄/
あしよわ /足弱/
あしろ /安代/
あしわざ /足技/足業/
あしわだ /足和田/
あしわら /葦原/
あじ /味/鯵;「鰺」の異体字/鰺/庵治/
あじあ /亜細亜/亞細亞/
あじあかいはつぎんこう /アジア開発銀行;Asian Development Bank(ADB) www.adb.org/
あじあかっこく /アジア各国/
あじあけい /アジア系/
あじあしょこく /アジア諸国/
あじあじん /アジア人/
あじあぞう /アジア象;asian elephant/
あじあたいかい /アジア大会/
あじあだい /亜細亜大/
あじあてき /アジア的/
あじおう /味皇/
あじおか /味岡/
あじおんち /味音痴/味オンチ/
あじか /簣/
あじから /味方/
あじがさわ /鯵ヶ沢/
あじがわ /安治川/
あじき /味気/
あじきこう /味紀行/
あじけ /味気/
あじけない /味気ない/
あじさい /紫陽花/
あじさか /鯵坂/
あじじまん /味自慢/
あじす /阿知須/
あじそんびょう /アジソン病;[医]Addison's disease/
あじつけ /味付け/味付/
あじつけのり /味付け海苔/
あじとみ /安次富/
あじどころ /味処/
あじな /阿品/芦品/
あじのもと /味の素;[商標] NB:言い換え「うま味調味料」/
あじふめい /味不明/
あじま /安島/
あじみ /味見/
あじみよう /味見用/
あじむ /安心院/
あじゃら /戯/
あじゃり /阿闍梨/
あじろ /網代/足代/安代/
あじわい /味わい/
あす /明日/
あすあさって /明日明後日/
あすいこう /明日以降/
あすか /明日香/飛鳥/
あすかい /飛鳥井/
あすかいちょう /飛鳥井町/
あすかじ /飛鳥路/
あすかじだい /飛鳥時代/
あすかでら /飛鳥寺/
あすかぶんか /飛鳥文化/
あすかやま /飛鳥山/
あすけ /足助/
あすけかんちゃ /足助寒茶/
あすこ /彼所/
あすこるびんさん /アスコルビン酸/
あすじゅう /明日中/
あすたちん /At/Astatine/
あすぢゅう /明日中/
あすてかぶんめい /アステカ文明;Azteca/
あすなろ /翌檜/
あすぱらぎんさん /アスパラギン酸/
あすぺくとひ /アスペクト比/
あすら /阿修羅/
あすわ /足羽/
あずかり /預かり/預り/
あずかりきん /預り金/預かり金/
あずかりしょ /預かり所/預り所/
あずかりしょう /預かり証/
あずかりもの /預かり物/預り物/
あずき /小豆/
あずきいろ /小豆色/
あずきがゆ /小豆粥/
あずきもち /小豆餅/
あずけ /預け/
あずけあい /預合/
あずけきん /預け金/
あずさ /梓/
あずさがわ /梓川/
あずさみこ /梓巫女/
あずさゆみ /梓弓/
あずち /安土/堋/
あずま /吾妻/吾嬬/東/
あずまあそび /東遊び/東遊/
あずまおとこ /東男/
あずまかがみ /吾妻鏡/東鑑/
あずまくだり /東下り/
あずまことば /東言葉/
あずません /吾妻線/
あずまばし /吾妻橋/
あずまふじ /東富士/
あずまや /東屋/四阿/阿亭/
あずみ /安曇/安住/杏美/
あずみぐん /安曇郡/
あずみの /安曇野/
あせ /汗/阿瀬/
あせい /阿世;曲学—/
あせかき /汗掻き/汗かき/
あせだく /汗だく/
あせちるさりちるさん /アセチルサリチル酸/
あせっかき /汗っ掻き/汗っかき/
あせとり /汗取り/
あせび /馬酔木/
あせふき /汗拭き/
あせぼ /馬酔木/
あせまみれ /汗塗れ/
あせみ /馬酔木/
あせみず /汗水/
あせみどろ /汗みどろ/
あせも /汗疹/
あせり /焦り/
あせんやく /阿仙薬/
あぜ /畔/畦/
あぜくら /校倉/
あぜくらづくり /校倉造り;[建築]/校倉造/
あぜぬり /畦塗り/
あぜみち /畦道/
あぜん /唖然/
あそ /阿蘇/安蘇/阿曽/
あそう /麻生/阿僧/
あそうがわ /麻生川/
あそうぎ /阿僧祇;10^56/
あそこ /彼処/彼所/
あそさん /阿蘇山/
あそび /遊び/
あそびあいて /遊び相手/
あそびうた /遊び歌/遊び唄/
あそびかた /遊び方/
あそびがね /遊び金/
あそびがみ /遊び紙/
あそびぐせ /遊び癖/
あそびぐるま /遊び車;[機械]/
あそびげ /遊び毛;遅れ毛/
あそびごころ /遊び心/
あそびて /遊び手/
あそびどうぐ /遊び道具/
あそびにん /遊び人/遊人/
あそびはんぶん /遊び半分/
あそびば /遊び場/
あそびべ /遊部/
あそびめ /遊女/遊び女/
あそみ /朝臣/
あそん /朝臣/
あぞく /亜属;[生物]subgenus/
あた /咫/
あたい /値;value. (字義:そのものの価値)/価;price. (字義:商人のつける売値)/私/價;「価」の旧字(人名用漢字)/値い/
あたいせんきん /値千金/
あたいていぎ /値定義/
あたいひょう /値表/
あたいよび /値呼び/
あたえかた /与え方/
あたか /安宅/宛/恰/
あたかも /恰も/宛も/宛/
あたがわ /熱川/
あたく /安宅/
あたくし /私/
あたけ /安宅/
あたご /愛宕/
あたごばし /愛宕橋/
あたごやま /愛宕山/
あたし /私/
あたたかみ /暖かみ/
あたま /頭/
あたまいがい /頭以外/
あたまうち /頭打ち/
あたまかず /頭数/
あたまかぶ /頭株/
あたまがみ /頭紙/
あたまがわ /頭側/
あたまきん /頭金/
あたまごし /頭越し/
あたまごなし /頭ごなし/
あたまだし /頭出し/
あたまでっかち /頭でっかち/
あたまわり /頭割り/頭割/
あたみ /熱海/
あたみえき /熱海駅/
あたみかん /熱海間/
あたらし /新子/
あたらしや /新屋/
あたり /当たり/辺り/当り/辺/邊;「辺」の旧字1/邉;「辺」の旧字2/
あたりがね /当り鉦;ちゃんちき/
あたりくじ /当たり籤/
あたりさわり /当たり障り;-のない/当り障り/
あたりどころ /当たり所/
あたりどし /当たり年/
あたりはずれ /当たり外れ/当り外れ/
あたりばち /当たり鉢;「擂鉢」の忌言葉/当り鉢/
あたりまえ /当たり前/当り前/
あたりや /当たり屋/当り屋/
あたりやく /当たり役/当役/当り役/
あたる /鼎/中/
あたん /亜炭/
あだ /仇/徒/婀娜/讐/讎/
あだい /亜大;亜細亜大学/
あだうち /仇討ち/仇討/
あだうちもの /仇討物/
あだごと /徒事/
あだざくら /徒桜/
あだしごと /徒し事/
あだしの /徒野/化野/
あだたら /安達太良/
あだたらこうげん /安達太良高原/
あだたらやま /安達太良山/
あだち /足立/安達/足達/
あだちく /足立区/
あだっきゅう /亜脱臼/
あだて /当/
あだな /渾名;nickname/仇名;(当て字) =渾名/徒名;噂/綽名;=渾名/あだ名/
あだなみ /徒波/
あだばな /徒花/
あだもの /徒物/
あだゆめ /徒夢/
あだん /ア段/阿檀/
あち /彼方/阿智;地名,長野/閼;(呉音の一つ)/窪地;?/
あちこち /彼方此方/
あちら /彼方/
あちらこちら /彼方此方/
あちわ /阿知波/
あっか /悪化/悪貨/
あっかい /圧壊/圧潰/
あっかく /圧覚/
あっかどご /アッカド語;Akkadian/
あっかん /圧巻/悪漢/
あっかんじょう /悪感情/
あっかんたんてい /悪漢探偵/
あっかんども /悪漢共/
あっき /悪気/悪鬼/
あっきらせつ /悪鬼羅刹/
あっく /悪口/
あっけ /呆気/
あっけい /悪計/
あっけし /厚岸/
あっけない /呆気ない/
あっこう /悪口/
あっこうぞうごん /悪口雑言/
あっさい /圧砕/
あっさく /圧搾/
あっさくき /圧搾機;presser/
あっさくくうき /圧搾空気/
あっさつ /圧殺/
あっさぶ /厚沢部/
あっし /圧死/私;(要ルビ)/
あっしゅく /圧縮/
あっしゅくがす /圧縮ガス/
あっしゅくがわ /圧縮側/
あっしゅくき /圧縮機/
あっしゅくきちょう /圧縮記帳/
あっしゅくきのう /圧縮機能/
あっしゅくぎじゅつ /圧縮技術/
あっしゅくくうき /圧縮空気/
あっしゅくけい /圧縮系/
あっしゅくけいしき /圧縮形式/
あっしゅくこうりつ /圧縮効率/
あっしゅくご /圧縮後/
あっしゅくちんれつ /圧縮陳列/
あっしゅくど /圧縮度/
あっしゅくばん /圧縮版/
あっしゅくひ /圧縮比/
あっしゅくふぁいる /圧縮ファイル/
あっしゅくほう /圧縮法/
あっしゅくほうしき /圧縮方式/
あっしゅくほうほう /圧縮方法/
あっしゅくまえ /圧縮前/
あっしゅくよう /圧縮用/
あっしゅくりつ /圧縮率/
あっしょう /圧勝/
あっせい /圧政;†tyranny.「皇帝の-」/圧制;†oppression.「民衆を-する」/
あっせつ /圧雪/圧接/
あっせつしゃ /圧雪車/
あっせつじょうたい /圧雪状態/
あっせん /斡旋/
あっせんしゅうわい /斡旋収賄/
あっそう /圧送/
あっち /彼方/
あっちこっち /彼方此方/
あっちゃく /圧着/
あっちゃくぶ /圧着部/
あっつう /圧痛/
あってん /圧点/
あっと /＠/
あっとう /圧倒/
あっとうてき /圧倒的/
あっとうてきたすう /圧倒的多数/
あっとうてきたすうは /圧倒的多数派/
あっとうてきゆうり /圧倒的有利/
あっとこ /厚床/
あっばーすちょう /アッバース朝;Abbasids/
あっぱい /圧排/
あっぱく /圧迫/
あっぱくかん /圧迫感/
あっぱくこっせつ /圧迫骨折/
あっぱくめんせつ /圧迫面接/
あっぱれ /天晴れ/天晴/遖/
あっぴ /安比/
あっぴこうげん /安比高原/
あっぷく /圧服/圧伏;≒圧服/
あつ /圧/厚/暑/熱/篤/軋;軋轢/斡;斡旋/遏;(とどめる)/壓;「圧」の旧字/淳;(人名用)/惇;(人名用)/敦;(人名用)/閼;?/乢;?/
あつ> /厚/
あつあげ /厚揚げ/
あつあつ /熱々/
あついた /圧板/
あつえん /圧延/
あつえんき /圧延機/
あつお /敦夫/淳夫/厚雄/敦男/
あつかい /扱い/扱/
あつかいかた /扱い方/
あつかいさき /扱先/
あつかいだか /扱い高/
あつかいてん /扱店/
あつかいりょう /扱い量/
あつかべ /厚壁/
あつかん /熱燗/
あつがま /厚釜/
あつがましき /厚釜式/
あつがみ /厚紙/
あつがり /暑がり/
あつき /敦紀;名/
あつぎ /厚木/厚着/
あつぎえいぎょうしょ /厚木営業所/
あつぎえき /厚木駅/
あつぎかん /厚木間/
あつぎきち /厚木基地/
あつぎし /厚木市/
あつぎしない /厚木市内/
あつぎないろん /厚木ナイロン/
あつぎぬ /厚衣/
あつぎほうめん /厚木方面/
あつぎり /厚切り/
あつけし /厚岸/
あつげしょう /厚化粧/
あつこ /淳子/温子/敦子/あつ子/厚子/篤子/惇子/亜都子/
あつさ /暑さ/厚さ/
あつさしのぎ /暑さ凌ぎ/
あつし /淳/敦/篤/厚/陸/篤史/敦史/篤志/厚志/敦士;名/敦司/淳史/敦志/篤司/充史/
あつしば /厚芝/
あつじ /厚地/
あつじょう /圧条/
あつぜつし /圧舌子/
あつぞこ /厚底/
あつぞこぐつ /厚底靴/
あつた /熱田/厚田/
あつたか /篤孝/
あつたじんぐう /熱田神宮/
あつつぐ /淳嗣/
あつで /厚手/
あつでん /圧電/
あつでんき /圧電気;[化学]piezoelectricity/
あつでんこうか /圧電効果/
あつでんざい /圧電材/
あつでんたい /圧電体/
あつにゅう /圧入/
あつぬり /厚塗り/厚塗/
あつのぶ /篤信/
あつひこ /敦彦/篤彦/淳彦/
あつひと /厚人/
あつひろ /敦弘/淳裕/厚宏/
あつび /熱火/
あつへいこお /圧平衡;※仮名遣い「へいこう」/
あつべつ /厚別/
あつま /厚真/
あつまり /集まり/集り/
あつみ /厚味/厚み/温海/渥美/淳美/厚見/
あつみちょう /渥美町/
あつみつ /圧密;consolidation/
あつみはんとう /渥美半島/
あつめ /厚め/熱め/厚目/熱目/
あつもの /羹/
あつもり /敦盛/
あつもりそう /敦盛草/
あつや /篤哉/
あつやき /厚焼き/厚焼;-卵/
あつやきたまご /厚焼き卵/
あつゆ /熱湯/
あつゆき /敦之/淳之/篤幸/
あつよう /厚様/
あつらえ /誂え/
あつらえむき /誂え向き/
あつりょく /圧力/壓力;「圧」旧字/
あつりょくいじょう /圧力以上/
あつりょくか /圧力下/
あつりょくがま /圧力釜/
あつりょくけい /圧力計/
あつりょくこうばい /圧力勾配/
あつりょくさ /圧力差/
あつりょくだんたい /圧力団体/
あつりょくなべ /圧力鍋/
あつりょくは /圧力波/
あつりょくようき /圧力容器/
あつれき /軋轢/
あつろう /篤郎;名/淳良/
あづかりきん /預かり金/
あづち /安土/
あづちじだい /安土時代;1576-82/
あづちじょう /安土城/
あづちももやまじだい /安土桃山時代/
あづま /吾妻/我妻/東/
あづません /吾妻線/
あづまばし /吾妻橋/
あづまや /東谷/
あて /宛/当て/貴/
あてうま /当て馬/
あてがいぶち /宛行扶持/
あてぎ /当て木/
あてこすり /当て擦り/
あてこと /当て事/
あてさき /宛先/宛て先/
あてさきじゅん /宛先順/
あてさきにん /宛先人/
あてさきふめい /宛先不明/
あてさきめい /宛先名/
あてじ /当て字/あて字/宛字/宛て字/
あてずいりょう /当て推量/
あてずっぽう /当てずっぽう/
あてつ /阿哲/
あてつけ /当て付け/
あてど /当て所/
あてな /宛名/宛て名/
あてないんじ /宛名印字/
あてながき /宛名書/宛名書き/
あてにげ /当て逃げ/
あてぬの /当て布;patch/
あてね /雅典/
あてはつ /宛発/
あてびと /貴人/
あてぶり /当て振り/
あてみ /当て身/
あてもの /当て物/
あてらざわ /左沢/
あてるい /阿弖流為/
あで /艶/
あですがた /艶姿/
あでのしんさんりんさん /アデノシン三リン酸/
あでやか /艶やか/
あと /後/跡;trace.「-を追う」「-が残る」/痕;きずあと/蹟;物事のあと/踪;あしあと/atto;[SI接頭語]a,10^-18/
あとあし /後足/後脚/
あとあじ /後味/
あとあと /後々/後後/
あといっこ /後一個/
あといっぽ /後一歩/
あとう /阿東;地名,山口/阿党/
あとうた /後歌/
あとうだ /阿刀田/
あとおい /後追い/後追/
あとおし /後押し/
あとかいぎ /後会議/
あとかた /跡形/跡かた/
あとかたづけ /後片付け/後かたづけ/後片付/
あとかわ /後川/
あとがき /後書き/後書/
あとがね /後金;=あときん/
あとがま /後釜/
あときん /後金/
あとくされ /後腐れ/
あとくち /後口/
あとこうてい /後工程/
あとさき /後先/
あとさく /後作/
あとざん /後産/
あとしまつ /後始末/
あとしょり /後処理/
あとすうねん /後数年/
あとずさり /後退り/
あとぜめ /後攻め/
あとぞめ /後染め/
あとだし /後出し/
あとち /跡地/
あとぢえ /後知恵/
あとつぎ /跡継ぎ/後継ぎ/後継/跡継/
あとづけ /後付け/後付/
あととり /跡取り/
あとのまつり /後の祭り/後の祭/
あとのり /後乗り/後ノリ/
あとはん /後版/
あとばらい /後払い/
あとばん /後番;後番組/
あとばんぐみ /後番組/
あとぴーせい /アトピー性/
あとぴーせいひふえん /アトピー性皮膚炎/
あとべ /跡部/
あとまわし /後回し/
あとみ /跡見/
あとみがくえん /跡見学園/
あとみや /後宮/
あとめ /跡目/
あとめあらそい /跡目争い/
あとめそうぞく /跡目相続/
あともどり /後戻り/
あとやく /後厄/
あとり /花鶏/
あど /亜土/
あどがわ /安曇川/
あどりあかい /アドリア海/
あどれすちょう /アドレス帳/
あな /穴;くぼんだあな/孔;突き抜けたあな/坑;垂直なあな/
あなあき /穴開き/
あなあきせん /穴明き銭/
あなあけ /穴開け/
あない /案内/穴井/
あなうま /穴馬/
あなうめ /穴埋め/
あなかんむり /穴冠;[部首]「窓」のかんむり/
あながち /強ち/
あながま /穴窯/
あながわ /穴川/
あなきょうだい /穴兄弟;[卑]/
あなぐま /穴熊/
あなぐら /穴蔵/窖/
あなご /穴子/
あなし /阿梨/
あなた /貴方/彼方;there/貴女/
あなたがた /貴方方/貴女方/あなた方/
あなたこなた /彼方此方/
あなたじしん /貴方自身/
あなたたち /貴方達/あなた達/
あなたまかせ /貴方任せ/
あなだ /穴田/
あなとう /穴党/
あなどり /侮り/
あなにんき /穴人気/
あなば /穴場/穴馬/
あなぶき /穴吹/
あなほり /穴掘り/
あなぼこ /穴ぼこ/
あなみず /穴水/
あなやま /穴山/
あなよそう /穴予想/
あなろぐかいせん /アナログ回線/
あなろぐどけい /アナログ時計/
あなろぐばん /アナログ盤/
あなろぐほうそう /アナログ放送/
あなん /阿南/
あなんだ /阿難陀;Ananda/
あに /兄/豈/阿仁;地名,秋田/
あにい /兄い/
あにうえ /兄上/
あにき /兄貴/
あにきぶん /兄貴分/
あにぎみ /兄君/
あにさま /兄様/
あにじゃ /兄者/
あにでし /兄弟子/
あにめえ /アニメ絵/
あにめえいが /アニメ映画/
あにめか /アニメ化/
あにや /安仁屋/
あによめ /兄嫁/嫂/
あね /姉/姐/
あねうえ /姉上/
あねおとうと /姉弟/
あねがこうじ /姉小路;地名/
あねがさき /姉ヶ崎/
あねがわ /姉川/
あねき /姉貴/
あねぎみ /姉君/
あねご /姉御/姐御/
あねごはだ /姉御肌/姐御肌/
あねさき /姉崎/
あねさま /姉様/
あねさん /姐さん/姉さん;NB:「ねえさん」と同形/
あねさんにょうぼう /姉さん女房/
あねざき /姉崎/
あねじゃ /姉者/
あねたい /姉帯;姓/
あねったい /亜熱帯/
あねったいせい /亜熱帯性/
あねったいちいき /亜熱帯地域/
あねったいちほう /亜熱帯地方/
あねむこ /姉婿/
あの> /彼の/
あのう /穴太;地名/安濃;地名/
あのかた /彼の方;(要ルビ)/あの方/
あのくたら /阿耨多羅/
あのくたらさんみゃくさんぼだい /阿耨多羅三藐三菩提/
あのこ /あの子/あの娘/
あのころ /あの頃/
あのつ /安濃津;地名,三重/
あのてこのて /あの手この手/
あのひ /あの日/
あのへん /あの辺/
あのよ /あの世/彼の世/
あのよう /彼の様/
あはなち /畔放/畔放ち/
あば /阿波/浮子/網端;網用の「うき」/
あばしり /網走/
あばしりえき /網走駅/
あばしりこ /網走湖/
あばずれ /阿婆擦れ;bitch/
あばた /痘痕/
あばら /肋/
あばらぼね /肋骨/あばら骨/
あばれ /暴れ/
あばれうま /暴れ馬/
あばれがわ /暴れ川/
あばれもの /暴れ者/
あばれんぼう /暴れん坊/
あぱらちあさんみゃく /アパラチア山脈/
あひかけ /足腰/
あひさん /亜砒酸/
あひる /家鴨/鶩;=家鴨/阿比留/
あび /阿鼻/阿比;[鳥]/
あびき /網引/
あびきょうかん /阿鼻叫喚/
あびこ /我孫子/安彦/
あびこし /我孫子市/
あびじごく /阿鼻地獄/
あびせたおし /浴びせ倒し/
あびだつま /阿毘達磨;[仏教]abhidharma/
あびる /阿比留/
あふ /亜父/阿父/凹;旧仮名/押;旧仮名/
あふち /樗/楝/
あふりか /阿弗利加/
あふりかけい /アフリカ系/
あふりかじん /アフリカ人/
あふりかぞう /アフリカ象/
あふりかたいりく /アフリカ大陸/
あふりかとういつきこう /アフリカ統一機構;OAU/
あぶ /虻/阿武/
あぶく /泡/
あぶくぜに /泡銭/
あぶくま /阿武隈/
あぶくまがわ /阿武隈川/
あぶくまきゅうこう /阿武隈急行/
あぶくまさんち /阿武隈山地;地名/
あぶしんべるしんでん /アブシンベル神殿/
あぶた /虻田/
あぶな /危な/
あぶなえ /危絵/
あぶなげ /危な気/
あぶはち /虻蜂;「-取らず」/
あぶはちとらず /虻蜂取らず/
あぶみ /鐙/
あぶみがわら /鐙瓦;=軒丸瓦/
あぶみこつ /鐙骨/
あぶら /油/脂;常温で固体のあぶら/膏;肉のあぶら/
あぶらあか /脂垢/油垢/
あぶらあげ /油揚げ/油揚/
あぶらあげぼん /油揚本/
あぶらあせ /脂汗/
あぶらいし /油石/
あぶらいため /油炒め/
あぶらいろ /油色/
あぶらえ /油絵/
あぶらえのぐ /油絵具/油絵の具;oil/
あぶらかす /油粕;oilcake. (肥料にする)/油糟;<rare>/
あぶらかわ /油川/
あぶらがに /油蟹;タラバガニのパチモン/
あぶらがみ /油紙/
あぶらぐすり /膏薬/脂薬/
あぶらぐち /油口/
あぶらげ /油揚/
あぶらこし /油漉し/
あぶらさし /油差し/油注し/
あぶらざめ /油鮫/
あぶらざら /油皿/
あぶらしょう /脂性/
あぶらぜみ /油蝉/
あぶらだ /油田;姓/
あぶらつち /油土/
あぶらつぼ /油壺/油壷;「壺」異体字/
あぶらづけ /油漬;イワシの-缶詰/油漬け/
あぶらとり /脂取り/
あぶらどおし /油通し;[料理]炒める前に軽く揚げておくこと/
あぶらな /油菜/薹/
あぶらなか /アブラナ科/
あぶらぬき /油抜き/
あぶらねんど /油粘土/
あぶらひ /油日/
あぶらひき /油引き/
あぶらぶん /油分/
あぶらみ /脂身/油身/
あぶらむし /油虫/蜚/
あぶらめ /油女/
あぶらもと /油本;姓/
あぶらや /油屋/
あぶらやけ /油焼け/
あぶり /炙り/焙り/
あぶりだし /炙り出し/
あぶりやき /炙り焼き/
あぶれもの /溢れ者/
あへん /阿片/鴉片;=阿片/
あへんくつ /阿片窟/
あへんせんそう /阿片戦争;[世界史]清vs英国/
あへんちゅうどく /阿片中毒/
あべ /阿部;-和重/安倍;-晴明/安部;-公房/阿倍;-仲麻呂/阿武;あぶ?/
あべかわ /安倍川/
あべかわもち /安倍川餅/
あべがくいん /安部学院/
あべこうぼう /安部公房;(1924-93)作家。『砂の女』/
あべた /安部田/
あべの /阿倍野;†地名,大阪/阿部野;†阿倍野にある駅名/
あべのく /阿倍野区/
あべのせいめい /安倍晴明/
あべのなかまろ /阿倍仲麻呂/
あべまき /阿部槙/
あほ /阿呆/
あほう /阿呆/阿房/
あほうづら /阿呆面/
あほうどり /信天翁/
あほうれっしゃ /阿房列車/
あほだらきょう /阿呆陀羅経/
あぼ /安保/英保/阿母/
あぼう /安房/
あぼうとうげ /安房峠/
あぼがどろていすう /アボガドロ定数;6.0221367*10^23 mol^-1/
あぼし /網干/
あぽくりんせん /アポクリン腺/
あぽろてき /アポロ的;[美学]Apollonic/
あぽろんてき /アポロン的;[美学]Apollonic/
あま /尼/海人/海士/海女/亜麻/甘/天/雨/蜑;=海人/塰;=海士/
あまあし /雨足/雨脚/
あまいけ /天池/雨池/
あまいた /天板/
あまいと /亜麻糸/
あまいろ /亜麻色/
あまうけ /雨受け/
あまえ /甘え/
あまえっこ /甘えっ子/
あまえび /甘海老/甘エビ/甘えび/
あまえんぼ /甘えん坊/
あまえんぼう /甘えん坊/
あまお /雨尾/
あまおおい /雨覆い/
あまおと /雨音/
あまおとめ /天少女/
あまかす /甘粕/甘糟/
あまかぜ /雨風/
あまかみ /甘噛み/
あまから /甘辛/
あまからに /甘辛煮/
あまかわ /天川/甘皮/
あまかんむり /雨冠/
あまがい /天海/雨海/
あまがえる /雨蛙/
あまがき /甘柿/
あまがさ /雨傘;umbrella/雨笠;rain hat/雨がさ/雨ガサ/
あまがさき /尼崎/
あまがさきかん /尼崎間/
あまがさきし /尼崎市/
あまがさばんぐみ /雨傘番組;天候の都合で中止された番組の代りに放送される番組/
あまがせ /天瀬/天ケ瀬/
あまがっぱ /雨合羽/雨ガッパ;raincoat/
あまがみ /甘噛み/
あまき /天木/
あまぎ /天城/甘木/雨着/亜麻木/
あまぎごえ /天城越え/
あまぎせん /甘木線/
あまぎとうげ /天城峠/
あまぎみ /尼君/
あまぎゆがしま /天城湯ヶ島/
あまぎゆがしまちょう /天城湯ヶ島町/
あまぎり /雨霧/
あまくさ /天草/
あまくさしろう /天草四郎/
あまくさばん /天草版/
あまくだり /天下り/天降り/
あまくち /甘口/
あまくぼ /天久保/
あまぐ /雨具/
あまぐつ /雨靴/
あまぐも /雨雲/
あまぐり /甘栗/
あまこ /尼子/
あまごい /雨乞い/
あまさ /甘さ/
あまざけ /甘酒/
あまざらし /雨曝し/雨晒し/
あまし /蔗/
あましょく /甘食/
あまじ /天路/
あまじお /甘塩/
あまじみ /雨染み/
あますところ /余す所/
あまず /甘酢/
あまずあえ /甘酢和え/
あまぞら /雨空/
あまた /数多/天田/
あまだ /天田/
あまだい /甘鯛/
あまだな /天棚/
あまだれ /雨垂れ/雨だれ/
あまち /天地/天池;(いけ)/
あまちまり /天地真理/
あまちゃ /甘茶/
あまちゃづる /甘茶蔓/
あまちゃん /甘ちゃん/
あまったれ /甘ったれ/
あまつ /天津/
あまつかぜ /天つ風/天津風/
あまつかみ /天津神/天つ神/
あまつくに /天津国/
あまつさえ /剰え/
あまつじ /天辻/
あまつつみ /天津罪/天つ罪/
あまつばめ /雨燕/
あまつぶ /雨粒/
あまづ /天津/
あまてらすおおみかみ /天照大神/天照大御神/
あまでら /尼寺/
あまとう /甘党/
あまとぶや /天飛ぶや/
あまど /雨戸/
あまどい /雨樋/
あまどり /天鳥/
あまどりのみこと /天鳥命/
あまなっとう /甘納豆/
あまなつ /甘夏/
あまに /甘煮/
あまぬま /天沼/
あまね /周/
あまの /天野/雨野/
あまのいわと /天の岩戸/天の磐戸/
あまのかぐやま /天香久山/
あまのがわ /天の川/天の河/
あまのじゃく /天邪鬼/天の邪鬼/
あまのはしだて /天橋立/天の橋立/
あまのはら /天の原/
あまのむらくものつるぎ /天叢雲剣;草薙剣/
あまのり /甘海苔/
あまぶた /雨蓋/
あまべ /海部/
あまほうし /尼法師/
あまみ /甘味/奄美/甘み/
あまみおおしま /奄美大島/
あまみず /雨水/
あまみそ /甘味噌/
あまみちほう /奄美地方/
あまみや /雨宮/天宮/
あまめ /甘め/甘目/
あまも /甘藻/
あまもと /天本/
あまもよい /雨催/雨催い/
あまもよう /雨模様/
あまもり /雨漏り/雨森/雨漏/
あまやか /甘やか/
あまやどり /雨宿り/
あまよ /雨夜;-の品定め/
あまよけ /雨除け/雨避け;=雨除け/
あまり /余り/甘利/
あまりもの /余り物;-で恐縮ですが/
あまるべ /余部/餘部;「余」旧字/
あまるめ /余目/
あまんざ /甘座/
あみ /網/阿弥/亜美;人名/阿見/醤蝦/网/罔/糠蝦/
あみあげぐつ /編み上げ靴/編上靴/
あみあぶら /網油/
あみうち /網打ち/
あみえ /網江/
あみかけ /網掛け/網かけ/網掛/
あみかんり /網管理/
あみがさ /編笠/編み笠/
あみがしら /罔頭/
あみき /編み機/
あみぎょぎょう /網漁業/
あみこ /安見子/
あみこみ /編み込み/
あみしま /網島/
あみしろ /網代/
あみじ /編地/
あみじゃくし /網杓子/
あみじょう /網状/
あみせいぎょ /網制御/
あみせつぞく /網接続/
あみたいつ /網タイツ/
あみだ /阿弥陀/
あみだくじ /阿弥陀籤/
あみださんぞん /阿弥陀三尊/
あみだどう /阿弥陀堂/
あみだな /網棚/
あみだにょらい /阿弥陀如来/
あみだぶつ /阿弥陀仏/
あみちょう /阿見町/
あみてん /網点/
あみど /網戸/
あみなか /網中/
あみの /網野/
あみのき /アミノ基;animo group/
あみのさん /アミノ酸/
あみのとう /アミノ糖;aminosugar/
あみのめ /網の目/
あみはま /網浜/
あみはり /網張/
あみはん /網版/
あみばり /編み針/編針/
あみびと /網人/
あみぼう /編み棒/編棒/
あみぼし /網干/
あみめ /網目/編み目/編目/
あみめおり /網目織/
あみめじょう /網目状/
あみもと /網元/
あみもの /編み物/編物/
あみや /網屋/
あみやき /網焼き/網焼/
あみわたり /網渡/
あむ /虻/
あむろ /安室/
あめ /雨/飴/天/豆汁/
あめあがり /雨上がり/
あめあし /雨足/雨脚/
あめあられ /雨霰/雨あられ/
あめいせんそう /蛙鳴蝉噪/
あめいろ /飴色/
あめおとこ /雨男/
あめおんな /雨女/
あめかぜ /雨風/
あめかんむり /雨冠/
あめがし /飴菓子;candy/
あめこう /アメ公/
あめざいく /飴細工/
あめしゃ /アメ車/
あめたいさく /雨対策/
あめたいふう /雨台風/
あめだま /飴玉/
あめつち /天地/
あめつぶ /雨粒/
あめつゆ /雨露/
あめに /飴煮/
あめのもり /雨森/
あめふらし /雨降/雨虎/
あめふり /雨降り/雨ふり/
あめみや /雨宮/
あめもよう /雨模様/
あめや /飴屋/
あめやよこちょう /アメヤ横丁;地名,通称「アメ横」/
あめよこ /アメ横/
あめよほう /雨予報/
あめりか /亜米利加/亞米利加;「亜」旧字/米/
あめりかえいが /アメリカ映画/
あめりかえいご /アメリカ英語/
あめりかがっしゅうこく /アメリカ合衆国/
あめりかぐん /アメリカ軍/
あめりかさん /アメリカ産/
あめりかしき /アメリカ式/
あめりかしじょう /アメリカ市場/
あめりかしゃ /アメリカ車/
あめりかじん /アメリカ人/
あめりかせい /アメリカ製/
あめりかたいりく /アメリカ大陸/
あめりかてき /アメリカ的/
あめりかぶんか /アメリカ文化/
あめりしうむ /Am/Americium/
あめんぼ /水馬/水黽/飴坊/
あも /母/餅/
あもい /厦門/廈門/
あもく /亜目/
あもん /亜門/
あや /綾;言葉の-/文;≒綾/彩/絢;≒綾/礼;(人名用)/彪;(虎の縞模様)/亜弥;人名/亜矢/亜也/漢/禮;「礼」の旧字(人名用漢字)/
あやいがさ /綾藺笠/
あやいと /綾糸/
あやう /危/
あやうじ /漢氏/
あやうた /綾歌/
あやおり /綾織/綾織り/
あやか /彩香/綾香/
あやかみ /綾上/
あやがみ /綾上/
あやぎく /綾菊/
あやぎぬ /綾絹/綺/
あやこ /綾子/彩子/文子/亜矢子/絢子/章子/亜弥子/亜也子/操子/
あやし /愛子/怪し/
あやしろ /綾城/
あやせ /綾瀬;地名,足立区／神奈川/綾世;人名?/
あやせえき /綾瀬駅/
あやせがわ /綾瀬川/
あやせし /綾瀬市/
あやせししょうこうかい /綾瀬市商工会/
あやせま /綾瀬間/
あやたり /綾足/
あやだけ /綾竹/
あやつ /彼奴/
あやつか /綾塚/
あやつじ /綾辻/
あやつり /操/
あやつりにんぎょう /操り人形/操人形/
あやとも /文友/
あやとり /綾取り/
あやね /綾音/
あやの /綾乃/綾野/
あやのこうじ /綾小路/
あやのみや /礼宮/
あやはな /彩花/
あやふみ /礼史/
あやべ /綾部/
あやま /阿山/
あやまち /過ち/誤ち;?/
あやまり /誤り/謬り/謝り/
あやまりりつ /誤り率/
あやむら /文村/
あやめ /菖蒲/文目/
あやめいけ /あやめ池/
あやめか /アヤメ科/
あやめざけ /菖蒲酒/
あやめもく /アヤメ目/Iridales/
あやめもくあぐん /アヤメ目亜群/
あゆ /鮎/阿諛/東風/
あゆかわ /鮎川/
あゆこ /亜佑子/
あゆさわ /鮎澤/
あゆざわ /鮎澤/
あゆついしょう /阿諛追従/
あゆついじゅう /阿諛追従;あゆついしょう ※おもねる意では「追従」は「ついしょう」と読む/
あゆつり /鮎釣り/
あゆづり /鮎釣り/
あゆみ /歩み/亜由美/歩美/亜弓/歩/彩友美/天弓;名/
あゆみあし /歩み足/
あゆみいた /歩み板/
あゆみより /歩み寄り/
あゆむ /渉/
あら /新/粗/荒/
あら> /粗;粗挽き,粗加工,粗仕上げ/新;新手,新鉢,新屋敷/現;現人神,現御神/
あらい /新井/荒井/新居/
あらいおけ /洗い桶/
あらいかた /洗い方/
あらいがえ /洗い替え/
あらいがき /洗柿/
あらいがみ /洗い髪/
あらいぐま /洗熊/浣熊/
あらいざらい /洗い浚い/
あらいざらし /洗い晒し/
あらいし /荒石/
あらいしゅ /洗朱/
あらいじゅく /新井宿/
あらいそ /荒磯/
あらいだし /洗い出し/
あらいど /荒井戸/
あらいはくせき /新井白石/
あらいはり /洗い張り/
あらいば /洗い場/
あらいまち /新居町/
あらいもの /洗い物/
あらいわ /荒岩/
あらうま /荒馬/
あらうみ /荒海/
あらお /荒尾/荒生/
あらおり /粗織/
あらか /殿/
あらかじめ /予め/予/豫め;「予」旧字/豫;「予」の旧字/
あらかせぎ /荒稼ぎ/
あらかた /粗方/
あらかね /鉱;未精錬の金属/粗金;未精錬の金属/
あらかべ /荒壁/粗壁/
あらかわ /荒川/粗皮/
あらかわおき /荒川沖/
あらかわおきえき /荒川沖駅/
あらかわく /荒川区/
あらかわしゃこまえ /荒川車庫前/
あらかわせん /荒川線/
あらかわだけ /荒川岳/
あらかわほうすいろ /荒川放水路/
あらかん /阿羅漢/
あらがき /新垣/荒書き/
あらがね /鉱;未精錬の金属/粗金;未精錬の金属/荒金;地名(茨城県),姓/
あらき /荒木/
あらきだ /荒木田/
あらきどんさん /アラキドン酸/
あらきの /新木野/
あらきゆみこ /荒木由美子/
あらぎも /荒肝/
あらぎょう /荒行/
あらぎり /粗切り/荒切り/
あらくさ /荒草/
あらくち /新口/
あらくれ /荒くれ/
あらくれもの /荒くれ者/
あらけ /有明/
あらけずり /荒削り/粗削り/
あらこ /荒子/
あらごし /粗漉し/
あらごと /荒事/
あらごなし /荒ごなし/
あらさがし /粗探し/あら探し/粗捜し/
あらさき /荒崎/
あらさわ /荒沢/荒澤/
あらし /嵐/荒らし/
あらしがおか /嵐ヶ丘/
あらしごと /荒仕事/
あらしね /荒稲/
あらしやま /嵐山/
あらしやまびじゅつかん /嵐山美術館/
あらじお /粗塩/
あらじる /粗汁/あら汁/
あらすかはんとう /アラスカ半島/
あらすじ /粗筋/
あらず /非ず/
あらぜき /荒関/
あらそい /争い/
あらそいごと /争い事/
あらた /新た/新田/荒田/新太;名/新/
あらたけ /荒武/
あらたに /荒谷/
あらたま /新田間/
あらため /改め/
あらためて /改めて/
あらだき /あら炊き/
あらち /新血/
あらちゃ /荒茶/
あらづくり /粗造り/
あらて /新手/
あらと /荒砥/
あらどこ /新床/
あらなみ /荒波/
あらなわ /荒縄/
あらぬの /粗布/
あらねつ /粗熱/
あらの /荒野/曠野/
あらはた /荒畑/
あらはま /荒浜/
あらばち /新鉢;virgin/
あらひとがみ /現人神/荒人神/
あらびあ /亜剌比亜;Arabia/亜拉毘亜/亞剌比亞;「亜」旧字/
あらびあご /アラビア語;assalam alaikum/
あらびあじん /アラビア人;Arabian/
あらびあすうじ /アラビア数字;0123456789(普通の「数字」)/
あらびあせきゆ /アラビア石油;[企業名]/
あらびあもじ /アラビア文字/
あらびき /粗挽き;-ウインナー,-豆/粗引き/粗碾き/
あらふか /荒深/
あらふね /荒船/
あらぶけい /アラブ系/
あらぶじん /アラブ人/
あらほうし /荒法師/
あらぼとけ /新仏/
あらぼん /新盆/
あらまき /荒巻;-鮭/荒牧;地名/新巻;=荒巻/
あらまきじゃけ /新巻鮭/
あらまさ /新政/
あらまた /荒俣/
あらまち /荒町/
あらまつ /荒松/
あらむご /アラム語;Aramaic/
あらむしゃ /荒武者/
あらむしろ /荒筵/粗筵/
あらむもじ /アラム文字/
あらめ /荒目/荒布/
あらもと /荒本/
あらもの /荒物/
あらものや /荒物屋/
あらや /新屋/新谷/
あらやしき /新屋敷/阿頼耶識/
あらやま /荒山/
あらゆ /新湯/
あらゆる /凡/∀/
あららぎ /蘭;[植物]/塔;(忌み言葉) tower/
あららぎは /アララギ派/
あらり /粗利/
あらりえき /粗利益/荒利益;=粗利益/
あらりょうじ /荒療治/
あらりょうち /荒療治/
あられ /霰/
あられしょうが /霰生薑/
あらわ /露;(字義:透明なので見える)/顕;(字義:顔を見せている)/現;動詞語幹?/表;動詞語幹?/露わ/
あらわざ /荒技/荒業/
あらわし /荒鷲/
あらわしかた /表し方/
あらわれ /現れ/表れ/顕れ/
あらん /亜蘭/亜欄/
あり /蟻/有/阿梨/有り/衽/袵/
ありーなせき /アリーナ席/
ありあけ /有明/
ありあけかい /有明海/
ありあけころしあむ /有明コロシアム/
ありあけしらうお /有明白魚/
ありあけせん /有明線/
ありあけのつき /有明の月/
ありあけばし /有明橋/
ありあけひめしらうお /有明姫白魚/
ありあり /有り有り;-と分かる/在り在り;-と浮び上がる/
ありあわせ /有り合わせ/
ありう /有り得/
ありえ /有家/
ありか /在処/在り処/亜里香/
ありかた /あり方/在り方/有り方/
ありかべ /有壁/蟻壁;[建築]/
ありかわ /有川/
ありが /有賀/有我/
ありがた /有難/有り難;-や,-迷惑/
ありがたみ /有難味/ありがた味/
ありがためいわく /有難迷惑/有り難迷惑/
ありがち /有り勝ち/
ありがとう /有難う/有り難う/
ありがね /有り金/
ありき /有木/
ありきたり /在り来り/
ありくい /蟻食/食蟻獣/
ありくら /有倉/
ありげ /有り気/
ありさ /亜里沙/亜利沙/亜理佐/
ありさか /有坂/
ありさま /有様/有り様/
ありさわ /有沢/有澤/
ありさん /阿里山/
ありざ /有座/
ありしひ /在りし日;『-の歌』(中也)/
ありしま /有島;姓/
ありしまたけお /有島武郎/
ありしゃかい /蟻社会/
ありしよ /在りし世/
ありじごく /蟻地獄/
ありす /有栖/
ありすがわ /有栖川/
ありすがわのみや /有栖川宮/
ありた /有田/
ありたてつどう /有田鉄道/
ありたま /有玉/
ありたやき /有田焼/
ありだ /有田/
ありだか /有り高/
ありったけ /有りっ丈/
ありつぎ /有次/
ありつね /有恒/
ありづか /蟻塚/垤;=蟻塚/
ありてい /有り体/有体/有態/
ありとう /有藤/
ありとも /有朋/
ありなが /有永/
ありなし /有り無し/
ありのとうぐさもく /アリノトウグサ目/Haloragales/
ありのまま /有りの儘/
ありのみ /有りの実;梨/
ありはた /有畠/
ありはら /在原/有原/
ありま /有馬/
ありまおんせん /有馬温泉/
ありまきねん /有馬記念/
ありまぐち /有馬口/
ありまさ /有正/
ありみ /有里巳/
ありみつ /有光/
ありむら /有村/
ありむらさんぎょう /有村産業;[企業名]/
ありもと /有本/
ありもの /有り物/
ありもり /有森/
ありもんじ /有文字/
ありや /有家/
ありやま /有山/
ありゅーしゃんれっとう /アリューシャン列島/
ありゅう /亜流/
ありゅうさん /亜硫酸/
ありゅうさんがす /亜硫酸ガス;SO2/
ありよう /有り様/
ありよし /有吉/
ありわら /在原/
ありわらのなりひら /在原業平;平安時代の歌人。『伊勢物語』の主人公? (825-880)/
ある /或る/或/亜留/∃;exist/
ある> /或る/
あるあさ /ある朝/或る朝/
あるいは /或いは/或は/
あるかなし /有るか無し/
あるかりいおんすい /アルカリイオン水/
あるかりか /アルカリ化/
あるかりかんでんち /アルカリ乾電池/
あるかりせい /アルカリ性/
あるかりちょうせき /アルカリ長石;alkali feldspar/
あるかりでんち /アルカリ電池/
あるかりど /アルカリ度/アルカリ土/
あるかりどじょう /アルカリ土壌/
あるかりどるいきんぞく /アルカリ土類金属;Ca,Sr,Ba,Ra/
あるが /有賀/
あるき /歩き/
あるきかた /歩き方/
あるきたばこ /歩き煙草/歩きタバコ;-は迷惑です/
あるきめですのげんり /アルキメデスの原理/
あるきるき /アルキル基/
あるぎんさん /アルギン酸/
あるこーるいぞんしょう /アルコール依存症/
あるこーるいんりょう /アルコール飲料/
あるこーるちゅうどく /アルコール中毒/
あるこーるどすう /アルコール度数/
あるこーるぶん /アルコール分/
あることないこと /有る事無い事/
あるござ /アルゴ座;88星座には含まれない/
あるごん /Ar/Argon/
あるしゅ /或る種/ある種/
あるじ /主/
あるじもうけ /饗設け/
あるぜんちん /亞爾然丁;「亜」旧字/
あるたみらどうくつ /アルタミラ洞窟;Altamira/
あるちゅう /アル中/
あるつはいまーびょう /アルツハイマー病;Alzheimer/
あるとき /ある時/或る時/
あるときばらい /有る時払い/
あるところ /ある所/
あるとし /ある年/或る年/
あるばいとだい /アルバイト代/
あるばいとりょう /アルバイト料/
あるばん /ある晩/或る晩/
あるひ /ある日/或る日/
あるひと /ある人/或る人/
あるふぁ /α;alpha/Α;Alpha/
あるふぁー /α;alpha/Α;Alpha/
あるふぁせい /α星/
あるふぁせん /α線/アルファ線/
あるふぁは /α波/
あるふぁばん /α版/
あるふぁべっとじゅん /アルファベット順/
あるふぁほうかい /α崩壊/
あるふぁりゅうし /α粒子/
あるぷすでんき /アルプス電気;[企業名]/
あるへいとう /有平糖/
あるみかん /アルミ缶/
あるみせい /アルミ製/
あるみなべ /アルミ鍋/
あるみにうむ /Al/Aluminum/
あるみはく /アルミ箔;foil/
あるよ /ある夜/或る夜/
あれ /荒れ/
あれい /亜鈴;ダンベル/唖鈴;ダンベル/
あれこれ /彼是/彼此/
あれしょう /荒れ性/
あれち /荒地/荒れ地/
あれつ /ア列/あ列/
あれの /荒れ野/
あれほうだい /荒れ放題/
あれほど /彼程/
あれもよう /荒れ模様/
あれら /彼等/
あれるぎーせい /アレルギー性/
あれるぎーせいびえん /アレルギー性鼻炎/
あれるぎーたいしつ /アレルギー体質;allergic tendency/
あろかっせんものがたり /鴉鷺合戦物語/
あろじ /主/
あわ /泡;bubble/粟;millet.「濡れ手で粟」/阿波;地名,徳島/安房;地名,千葉/慌/
あわあわ /淡淡/淡々/
あわい /間/
あわいい /粟飯/
あわいけだ /阿波池田/
あわおどり /阿波踊り/
あわこうぞう /泡構造/
あわさ /粟佐/
あわさか /泡坂/
あわざ /阿波座/
あわしま /淡島/
あわじ /淡路/
あわじしま /淡路島/
あわじちょう /淡路町/
あわじちょうえき /淡路町駅/
あわじょう /泡状/
あわず /粟津/
あわせ /袷/合わせ/
あわせいれつ /泡整列/
あわせかがみ /合わせ鏡/合せ鏡/
あわせじょうゆ /合わせ醤油/合せ醤油/
あわせず /合わせ酢/合せ酢/
あわせて /併せて/
あわせみそ /合わせ味噌/合せ味噌/
あわせめ /合わせ目/合せ目/
あわせもの /合わせ物/合せ物/
あわせわざ /合わせ技/
あわた /粟田/
あわたてき /泡立て器/
あわだち /泡立ち;-の悪い石鹸/泡立/
あわだちそう /泡立草/
あわだてき /泡立て器/
あわつ /粟津/
あわつぶ /粟粒;millet/泡粒;bubble/
あわづ /粟津/
あわづおんせん /粟津温泉/
あわづはら /粟津原/
あわてもの /慌て者/
あわの /粟野/阿波野/
あわばこ /泡箱/
あわひめ /泡姫;[俗]/
あわび /鮑/鰒/蚫/
あわびむすび /鮑結び/
あわぶろ /泡風呂/
あわべん /阿波弁/
あわみどり /淡緑/
あわむらさき /淡紫/
あわめし /粟飯/
あわもり /泡盛/
あわや /粟屋/淡谷/粟谷/
あわゆき /淡雪/泡雪/沫雪/
あわゆきかん /泡雪羹/
あわゆきそば /泡雪蕎麦/
あわゆきたまご /泡雪卵/
あわゆきどうふ /泡雪豆腐/
あわら /芦原/
あわれ /哀れ/
あわれみ /哀れみ/憐れみ/
あん /案/餡/庵;いおり/安/暗/闇;明闇/諳;諳誦/黯/按;按配/鞍;鞍馬/晏/鮟;鮟鱇/罨/菴;≒庵/杏;杏子/行;行脚/閼;?/
あん> /暗;-赤褐色,-順応/
あんあんり /暗々裡/暗々裏/
あんい /安易/
あんいつ /安逸/安佚;=安逸/
あんうつ /暗鬱/
あんうん /暗雲/
あんえい /安永;年号(1772-81)/暗影/晏嬰;晏子/暗翳/
あんか /安価/行火/案下/
あんかけ /餡掛け/餡掛/
あんかせい /安価性/
あんかっしょく /暗褐色/
あんかん /安閑/暗槓/
あんかんてんのう /安閑天皇/
あんが /安臥/
あんがい /案外/
あんがいかんたん /案外簡単/
あんがいようい /案外容易/
あんき /暗記/安徽/安気;ease/安危;-存亡/暗鬼/諳記/晏起/
あんきかもく /暗記科目/
あんきほう /暗記法/
あんきも /鮟肝;アンコウのキモ/
あんきもの /暗記物/
あんきょ /暗渠/安居/
あんきりょく /暗記力/
あんぎゃ /行脚/
あんぎゃそう /行脚僧/
あんぎょう /安行/
あんくん /暗君/
あんぐ /暗愚/
あんぐう /行宮/
あんけーとちょうさ /アンケート調査/
あんけーとようし /アンケート用紙/
あんけい /安慶/
あんけん /案件/
あんけんさつ /暗剣殺/
あんげん /安元;年号(1175-1177)/
あんこ /餡こ/安固/暗刻;[麻雀](anke)/
あんこー /暗刻/
あんこう /鮟鱇/安康/暗刻;[麻雀]/鮟;(字義:サンショウウオ),?/鱇;(「鮟鱇」の一部にするために作られた国字),?/
あんこうがた /鮟鱇形/
あんこうしょく /暗紅色/
あんこうてんのう /安康天皇/
あんこうなべ /鮟鱇鍋/
あんこがた /鮟鱇形/
あんこく /暗黒/安国/闇黒/
あんこくがい /暗黒街/
あんこくくうかん /暗黒空間/
あんこくじ /安国寺/
あんこくじだい /暗黒時代/
あんこくせいうん /暗黒星雲/
あんこくたいりく /暗黒大陸/
あんこくちたい /暗黒地帯/
あんこくぶっしつ /暗黒物質;(天文) dark matter/
あんこくめん /暗黒面/
あんころもち /餡ころ餅/
あんご /安居/安吾/暗語/
あんごう /暗号;code/暗合;偶然の一致/
あんごうか /暗号化/
あんごうかぎ /暗号鍵;[情報]encryption key/
あんごうちょう /暗号帳/
あんごうひょう /暗号表/
あんごうぶん /暗号文/
あんさつ /暗殺/
あんさつけいかく /暗殺計画/
あんさつしゃ /暗殺者/
あんさつしれい /暗殺指令/
あんさつめいれい /暗殺命令/
あんさん /兄さん/
あんざ /安座/
あんざい /安西/安斉/安斎/安齋/安在/安齊/
あんざん /安産/暗算/鞍山/
あんざんがん /安山岩/
あんざんきがん /安産祈願/
あんし /暗視/晏子;春秋時代の斉の宰相/
あんししょく /暗紫色/
あんしつ /暗室/庵室/
あんしゅ /庵主/按手/
あんしゅう /暗愁/
あんしゅつ /案出/
あんしょ /暗所/
あんしょう /暗唱;†recite.「-する」/暗証;†「-番号」/暗礁;†reef.「-に乗り上げる」/暗誦;=暗唱/諳誦/
あんしょうか /暗証化/
あんしょうばんごう /暗証番号/
あんしょうぶ /暗証部/
あんしょく /暗色/
あんしん /安心/
あんしんかん /安心感/
あんしんど /安心度/
あんしんりつめい /安心立命/
あんしんりょう /安心料/
あんじ /暗示/案じ/
あんじてき /暗示的/
あんじゅ /庵主/杏樹/
あんじゅう /安住/
あんじゅんのう /暗順応/
あんじょ /晏如/
あんじょう /安城/鞍上/安生/
あんじょうきょうか /鞍上強化/
あんじょく /鞍褥/
あんじりょうほう /暗示療法;[精医]/
あんじん /安心/
あんじんりゅうみょう /安心立命/
あんじんりょうみょう /安心立命/
あんず /杏/杏子/
あんずいろ /杏子色;tangerine red/
あんせい /安静/安政;年号(1854-1860)/
あんせいじ /安静時/
あんせいど /安静度/
あんせいのたいごく /安政の大獄/
あんせきしょく /暗赤色/
あんぜん /安全/暗然/
あんぜんいき /安全域/
あんぜんうんてん /安全運転/
あんぜんえいせい /安全衛生/
あんぜんか /安全化/
あんぜんかくじつ /安全確実/
あんぜんかくにん /安全確認/
あんぜんかくほ /安全確保/
あんぜんかんり /安全管理/
あんぜんがわ /安全側/
あんぜんがわせん /安全側線/
あんぜんき /安全器/
あんぜんきかく /安全規格/
あんぜんきじゅん /安全基準/
あんぜんきょういく /安全教育/
あんぜんきょり /安全距離/
あんぜんぎじゅつ /安全技術/
あんぜんく /安全区/
あんぜんぐつ /安全靴/
あんぜんけいすう /安全係数;[物理]safety coefficient/
あんぜんけん /安全圏/安全研/
あんぜんけんきゅうしょ /安全研究所/
あんぜんこうしゅう /安全講習/
あんぜんこうしゅうかい /安全講習会/
あんぜんさく /安全策/
あんぜんじょう /安全上/
あんぜんせい /安全性/
あんぜんせいかくほ /安全性確保/
あんぜんせつび /安全設備/
あんぜんせんげん /安全宣言/
あんぜんそうこう /安全走行/
あんぜんそうち /安全装置/
あんぜんたいさく /安全対策/
あんぜんたいさくきじゅん /安全対策基準/
あんぜんだいいち /安全第一/
あんぜんちたい /安全地帯/
あんぜんていし /安全停止/
あんぜんとう /安全灯/安全燈/
あんぜんぱい /安全牌/
あんぜんひょうか /安全評価/
あんぜんび /安全日/
あんぜんぴん /安全ピン/
あんぜんべん /安全弁/
あんぜんほしょう /安全保障/
あんぜんほしょうじょうやく /安全保障条約/
あんぜんほしょうりじかい /安全保障理事会/
あんぜんぼう /安全帽;helmet/
あんぜんめん /安全面/
あんぜんもう /安全網/
あんぜんよう /安全用/
あんぜんりつ /安全率/
あんそうおん /暗騒音/
あんそく /安息/
あんそくこう /安息香/
あんそくこうさん /安息香酸;C6H5COOH/
あんそくび /安息日/
あんそっこう /安息香/
あんたい /安泰/
あんたく /安宅/
あんたくせいろ /安宅正路/
あんたん /暗澹/
あんだ /安打/
あんだすう /安打数/
あんち /安置/安地/庵地/
あんちじょ /安置所/
あんちもん /Sb/Antimony/
あんちゃく /安着/
あんちゃん /兄ちゃん;[口]兄、または若者の呼称/
あんちゅう /暗中/闇中/
あんちゅうひやく /暗中飛躍/
あんちゅうもさく /暗中模索/
あんちょく /安直/
あんちん /安珍/
あんちんきよひめ /安珍清姫;道成寺/
あんてい /安定/安貞;年号(1227-1229)/
あんていか /安定化/
あんていかでんげん /安定化電源/
あんていかどう /安定稼働/
あんていかぶぬし /安定株主/
あんていかん /安定感/
あんていかんばつぐん /安定感抜群/
あんていき /安定期/
あんていきょうきゅう /安定供給/
あんていこうぞう /安定構造/
あんていざい /安定剤/
あんていじょうたい /安定状態/
あんていせい /安定性/
あんていせいじゅうし /安定性重視/
あんていせいそう /安定成層/
あんていせいちょう /安定成長/
あんていせいりろん /安定性理論/
あんていたすう /安定多数;[政治]議長等の議席を差し引いても過半数を取れる議席数/
あんていてき /安定的/
あんていてん /安定点/
あんていど /安定度/
あんていどういたい /安定同位体/
あんていどうさ /安定動作/
あんていばん /安定板;fin/
あんていひこう /安定飛行/
あんていりくかい /安定陸塊/
あんてん /暗転/鞍点/
あんてんほう /鞍点法/
あんでぱんだんてん /アンデパンダン展/
あんでるせんどうわ /アンデルセン童話/
あんでんりゅう /暗電流/
あんとう /安東/暗闘/
あんとく /安徳/
あんとくてんのう /安徳天皇/
あんど /安堵/∩/∧/
あんどう /安藤/安東/
あんどうしょうえき /安藤昌益/
あんどうでんき /安藤電気/
あんどうひろしげ /安藤広重/
あんどかん /安堵感/
あんどく /暗読/
あんどろめだざ /アンドロメダ座;Andromeda(And)/
あんどん /行灯/行燈/闇鈍/
あんな /杏奈/安和;年号(968-970)/
あんない /案内/
あんないかんばん /案内看板/
あんないがかり /案内係/
あんないきじ /案内記事/
あんないしゃ /案内者/
あんないしょ /案内書/
あんないじょ /案内所/
あんないじょう /案内状/
あんないず /案内図/
あんないそうち /案内装置/
あんないちず /案内地図/
あんないにん /案内人/
あんないばん /案内板/
あんないひょうしき /案内標識/
あんないひょうじ /案内表示/
あんないぶん /案内文/
あんないぶんしょ /案内文書/
あんないほうそう /案内放送/
あんないやく /案内役/
あんないよう /案内用/
あんなか /安中/
あんなかかん /安中間/
あんなん /安南;地名/
あんに /暗に/
あんにん /杏仁/
あんにんどうふ /杏仁豆腐/
あんねい /安寧/
あんねいちつじょ /安寧秩序/
あんねいてんのう /安寧天皇/
あんねん /安念/
あんの /庵野/安野/
あんのう /鞍嚢/
あんのじょう /案の定/
あんのん /安穏/
あんはんのう /暗反応/
あんば /鞍馬;体操の種目/
あんばい /塩梅;≒按配/按配/案配;=按配/按排;=按配/
あんばこ /暗箱;カメラの-/
あんぱち /安八/
あんぱん /餡パン/あんパン/
あんひつ /安謐/
あんぴ /安否/
あんぴかくにん /安否確認/
あんぶ /暗部;「社会の-」/鞍部;[地質学]col/
あんぶん /按分/案文;draft/案分;≒按分/
あんぷ /暗譜/
あんぼれらか /アンボレラ科/Amborellaceae/
あんぽ /安保/
あんぽう /罨法/
あんぽじょうやく /安保条約/
あんぽたいせい /安保体制/
あんぽとうそう /安保闘争/
あんぽもんだい /安保問題/
あんぽり /安保理/
あんぽりけつぎ /安保理決議/
あんぽりじかい /安保理事会/
あんぽんたん /安本丹/
あんま /按摩/
あんまく /暗幕/
あんまん /餡饅/
あんみつ /餡蜜/
あんみん /安眠/
あんめん /暗面/
あんもく /暗黙/
あんもくち /暗黙知/
あんもくてき /暗黙的/
あんもち /餡餅/
あんもにあすい /アンモニア水/
あんもん /案文/
あんや /暗夜/闇夜/
あんやく /暗躍/
あんやこうろ /暗夜行路/
あんゆ /暗喩;[修辞]metaphor/
あんゆてき /暗喩的/
あんらく /安楽/
あんらくいす /安楽椅子/
あんらくこく /安楽国;[仏教]極楽/
あんらくし /安楽死/
あんり /杏里/
あんりゅう /暗流/
あんりょくしょく /暗緑色/
あんろくざん /安禄山/
い /胃/意/異/医/位/井/伊/委/衣/居/射/威/亥;[十二支](12)いのしし/夷;夷狄/姨;おば/洟;はな/痍;満身創痍/維;維持/帷;かたびら/惟;思惟/唯;唯唯諾諾/韋;韋駄天/違;相違/偉;偉人/緯;緯度/幃;とばり/圍;「囲」の旧字/囲;周囲/慰;慰留/尉;少尉/熨;のし/蔚/萎;萎縮/痿/逶/矮;(呉音) 矮小(わいしょう)/謂;い・う/渭;渭水/椅;椅子/倚/猗/為;行為/爲;「為」の旧字(人名用漢字)/彙;語彙/彝/彜;「彝」の異体字/以/苡/詒/貽;貽貝/怡/遺;遺産/依;依存/易;安易/畏;畏怖/移;移動/堰;せき/莞/詑/胆/猪/鮪;まぐろ/揖/噫/已;已然形/恚;瞋恚/懿/矣;(助辞)/肄;(ならう)/頤;おとがい/饐;す・える/鰄;かいらぎ/醫;「医」の旧字/囗;(「口」(くち)とは別)/五/ゐ;→うぃ/如;如何/斐;甲斐/鋳;い・る?/鑄/忌;い・む?/偽;?/僞;「偽」の旧字(人名用漢字)/李;り?/
い> /異/伊;[略語]イタリア.-首相,-企業/居;(あ行・わ行上一段 未然・連用形)居座る,居回る,居隠る/
いーじすかん /イージス艦/
いーすと /ＥＡＳＴ/
いーすときん /イースト菌/
いーた /η;eta/Η;Eta/
いーふぁん /一翻/
いーめーる /Eメール/
いあ /依阿/
いあい /居合/居合い/遺愛/畏愛/
いあいごし /居合腰/
いあいどう /居合道/
いあいぬき /居合抜き/
いあく /帷幄/
いあくじょうそう /帷幄上奏/
いあつ /威圧/威壓/
いあつかん /威圧感/
いあつてき /威圧的/
いあん /慰安/
いあんかい /慰安会/
いあんじょ /慰安所/
いあんふ /慰安婦/
いあんりょこう /慰安旅行/
いい /飯/謂/猪/井伊/伊井/猪井/依依/依違/依倚/唯々/
いいあい /言い合い/
いいあらそい /言い争い/
いいうり /言売/
いいお /飯尾;姓/
いいおか /飯岡/
いいかえ /言い換え/
いいかお /好い顔;好い顔をしなかった/
いいかげん /いい加減/好い加減/
いいかた /言い方/
いいがかり /言い掛かり/言いがかり/言い掛り/
いいき /異域/いい気/好い気/
いいぎり /椅/
いいくら /飯倉/
いいくらかたまち /飯倉片町/
いいぐさ /言い草/言い種/
いいこ /いい子/
いいこと /いい事/
いいさか /飯坂/
いいざか /飯坂/
いいざかおんせん /飯坂温泉/
いいざま /言い様/
いいざわ /飯沢/
いいし /飯石/
いいじま /飯島/飯嶋/
いいじょう /言い条/
いいすぎ /言い過ぎ/
いいすて /言い捨て/
いいずか /飯塚;※仮名遣い「いいづか」/
いいたいほうだい /言いたい放題/
いいたか /飯高/
いいたがわ /飯田川/
いいたて /飯館/
いいだ /飯田/
いいだか /飯高/
いいだくだく /唯唯諾諾/唯々諾々/
いいだこ /飯蛸/
いいだし /飯田市/
いいだしっぺ /言い出しっぺ/
いいだせん /飯田線/
いいだばし /飯田橋/
いいだばしえき /飯田橋駅/
いいだばしほうめん /飯田橋方面/
いいつけ /言い付け/
いいつたえ /言い伝え/
いいづか /飯塚/
いいづかし /飯塚市/
いいづな /飯綱/
いいで /飯豊/
いいとし /好い年/いい年/いい歳/
いいなおすけ /井伊直弼;幕末の大老/
いいなが /稲永/
いいなずけ /許婚/許嫁/
いいなり /言い成り/言いなり/
いいなん /飯南/
いいぬま /飯沼/
いいね /言い値/
いいの /飯野/
いいのがれ /言い逃れ/
いいはま /飯浜/
いいはん /一翻/
いいぶん /言い分/
いいぼし /飯干/
いいま /飯間/
いいまちがい /言い間違い/
いいまわし /言い回し/言回し/
いいむら /飯村/
いいもり /飯盛/飯森/
いいもりやま /飯盛山/
いいや /否/
いいやま /飯山/
いいやまでんき /飯山電機;[企業名]/
いいよう /言い様;他にもっと-もあるだろう/
いいわけ /言い訳/言訳/
いいわたし /言い渡し/言渡し/
いいん /委員/医院/医員/伊尹/
いいんかい /委員会/
いいんかいあん /委員会案/
いいんかいかんり /委員会管理/
いいんかいぎちょう /委員会議長/
いいんかいこうにん /委員会公認/
いいんかいさくせい /委員会作成/
いいんかいせい /委員会制/
いいんかいせいど /委員会制度/
いいんかいせつりつ /委員会設立/
いいんかいぜんたい /委員会全体/
いいんかいそしき /委員会組織/
いいんかいたいせい /委員会体制/
いいんかいとうせっちがいしゃ /委員会等設置会社;NB:H14の改正商法特例法（2003.04施行）により採択可能となった企業統治の仕組/
いいんかいないぶ /委員会内部/
いいんかいほうしき /委員会方式/
いいんぜんたい /委員全体/
いいんちょう /委員長/
いいんちょうあて /委員長宛/
いいんどうし /委員同士/
いうこと /言う事/
いうち /井内/
いうなれば /言うなれば/
いうら /井浦/
いぇん /¥/円;Yen/
いえ /家/伊江/彌;「弥」の旧字/
いえい /遺影/家居/遺詠/
いえいえ /家々/
いえいがい /家以外/
いえがた /家型/
いえがまえ /家構え/
いえがら /家柄/
いえき /胃液/
いえしま /家島/
いえじ /家路/
いえじゅう /家中/
いえすじ /家筋/
いえずすかい /イエズス会;[キリスト教]Jesuit order/
いえせいど /家制度/
いえだ /家田/
いえつき /家付き/家付/
いえづくり /家造り/家作り/
いえで /家出/
いえでしょうじょ /家出少女/
いえでにん /家出人/
いえどころ /家所/
いえども /雖も/雖/
いえなが /家永/
いえなみ /家並み/家並/
いえねこ /家猫/
いえばと /家鳩/
いえみつ /家光/
いえもち /家茂/家持ち/
いえもと /家元/
いえやしき /家屋敷/
いえやす /家康/
いえやま /家山/
いえよう /家様/
いえらいしゃん /夜来香/
いえん /胃炎/以遠/
いえんけん /以遠権/
いお /魚/五百/
いおう /硫黄/S/Sulfur/
いおうしゅう /硫黄臭/
いおうじ /医王寺/
いおうじま /硫黄島/伊王島/
いおうせん /硫黄泉/
いおうとう /硫黄島/
いおえ /五百重/五百枝/
いおか /井岡/
いおた /ι;iota/Ι;Iota/
いおち /庵地/
いおにあしき /イオニア式;[建築]Ionian order. ギリシア建築の様式/
いおの /魚野/
いおのめ /魚の目/
いおはら /庵原;姓/
いおり /庵/菴/伊織/
いおりてん /庵点/
いおん /異音/倚音;[音楽]Vorschlag/遺恩/
いおんか /イオン化/
いおんかけいこう /イオン化傾向;[化学]ionisation tendency/
いおんけっしょう /イオン結晶;[化学]ionic crystal/
いおんけつごう /イオン結合/
いおんこうかん /イオン交換;[化学]/
いおんはんけい /イオン半径;[化学]ionic radius/
いおんびん /イ音便/
いか /以下/如何/医科/烏賊/異化/位下/医家/伊香/≦;<=/
いかい /異界/位階/猪飼/伊貝/
いかいくんとう /位階勲等/
いかいよう /胃潰瘍/胃かいよう/
いかいんよう /以下引用/
いかが /如何/
いかがく /医科学;medical sciences/医化学;medical chemistry/
いかく /威嚇/位格/居角/威赫/
いかくしゃげき /威嚇射撃/
いかくしょく /威嚇色/
いかくちょう /胃拡張/
いかけ /鋳掛け/鋳掛/
いかけや /鋳掛屋/鋳掛け屋/
いかけん /医科研/
いかさま /如何様/
いかさんしょう /以下参照/
いかざき /五十崎/
いかしか /医科歯科/
いかしょうりゃく /以下省略/
いかすい /胃下垂/
いかすみ /イカ墨/烏賊墨/いか墨/
いかずち /雷/霆/霹/
いかた /伊方/
いかたる /胃カタル;[医]gastric catarrh/
いかだ /筏/桴;=筏 NB:「ばち」とも読む/
いかだい /筏井/
いかだいがく /医科大学/
いかつ /威喝/
いかづち /雷/
いかてん /イカ天/
いかどうぶん /以下同文/
いかどうよう /以下同様/
いかな /如何な/
いかないよう /以下内容/
いかなご /玉筋魚/
いかなる /如何なる/
いかに /如何に/
いかにも /如何にも/
いかの /以下の/
いかのぼり /凧/
いかひ /異花被/
いかひか /異花被花/
いかほ /伊香保/
いかほおんせん /伊香保温泉/
いかほど /如何程/
いかほんぶん /以下本文/
いかむけ /医家向け/
いかめら /胃カメラ/
いかもの /如何物/
いかやき /烏賊焼き/イカ焼き/いか焼き/
いかよう /如何様/
いからし /五十嵐/
いかり /錨/碇;=錨/怒り/怒/
いかりがせき /碇ヶ関/
いかりがた /怒り肩/
いかりしんとう /怒り心頭/
いかりそう /碇草/
いかりど /錨戸/
いかりゃく /以下略/
いかる /斑鳩/鵤/
いかるが /斑鳩/
いかるがのみや /斑鳩宮/
いかわ /井川/居川/井河/
いかわだに /伊川谷/
いかん /如何/移管/遺憾/衣冠/医官/尉官/偉観/異観/
いかんそく /維管束/
いかんそくたい /衣冠束帯/
いかんとも /如何とも;-し難い/
いかんなく /遺憾無く/
いが /伊賀/毬/
いがい /以外;†except.「それ-」/意外;†unexpected.「-な展開」/遺骸/貽貝/
いがいせい /意外性/
いがうえ /伊賀上/
いがうえの /伊賀上野;地名/
いがき /斎垣/
いがく /医学/
いがくか /医学科/
いがくかい /医学界/
いがくかんけい /医学関係/
いがくかんけいしゃ /医学関係者/
いがくかんれん /医学関連/
いがくけい /医学系/
いがくけんきゅう /医学研究/
いがくけんきゅうか /医学研究科/
いがくけんきゅうしゃ /医学研究者/
いがくざっし /医学雑誌/
いがくし /医学史/
いがくしゃ /医学者/
いがくしょ /医学書/
いがくしょいん /医学書院;[出版社名]www.igaku-shoin.co.jp/
いがくじしょ /医学辞書/
いがくじてん /医学事典/
いがくじょう /医学上/
いがくせい /医学生/
いがくそうだん /医学相談/
いがくてき /医学的/
いがくてきけんきゅう /医学的研究/
いがくてきこうさつ /医学的考察/
いがくてきじょうほう /医学的情報/
いがくてきちしき /医学的知識/
いがくてきもんだい /医学的問題/
いがくはかせ /医学博士/
いがくはくし /医学博士/
いがくぶ /医学部/
いがくぶせい /医学部生/
いがくようご /医学用語/
いがぐり /毬栗/
いがぐりあたま /毬栗頭/いがぐり頭/
いがこうべ /伊賀神戸/
いがさてつどう /井笠鉄道/
いがしら /井頭/
いがせん /伊賀線/
いがた /鋳型/井形/鎔/范/
いがっか /医学科/
いがみ /井上/
いがみあい /啀み合い/
いがや /井ヶ谷/
いがやき /伊賀焼/
いがらし /五十嵐/
いがり /猪狩/
いがりゅう /伊賀流;忍者/
いがわ /井川/居川/
いがん /胃癌/依願/胃がん/胃ガン/
いがんたいしょく /依願退職/
いがんめんしょく /依願免職/
いき /息/粋/域/閾;threshold/意気/遺棄/壱岐;地名,長崎/行/行き/生き/位記/囲気/委棄;[法]所有権の放棄/生/粹;「粋」の旧字(人名用漢字)/
いき> /活/
いきあたり /行き当たり;-ばったり/行き当り/
いきあたりばったり /行き当たりばったり/
いきいき /生き生き/活き活き/
いきうお /活き魚/
いきうつし /生き写し/
いきうま /生き馬/
いきうめ /生き埋め/生埋め/
いきえ /生き餌/
いきおい /勢い/
いきか /閾下/
いきかえり /行き帰り;-の電車/
いきかた /生き方;†lifestyle/行き方;†way/
いきかん /異機間/
いきがい /域外/生き甲斐/生きがい/
いきがかり /行き掛かり;-でやむを得なかった/行き掛り/
いきがけ /行き掛け/
いきがみ /生き神/
いきき /行き来/往き来/一箕/
いきぎも /生き肝/生き胆/
いきぎれ /息切れ/
いきくち /生き口/
いきけんこう /意気軒昂/
いきごみ /意気込み/意気ごみ/
いきさき /行き先/行先/
いきさきあんない /行先案内/
いきさきひょうじ /行先表示/
いきさつ /経緯/
いきさわ /生澤/
いきざい /遺棄罪/
いきざかな /生き魚/
いきざま /生き様/
いきしな /行きしな/
いきしに /生き死に/
いきしゅ /異機種/
いきしゅかん /異機種間/
いきしょうちん /意気消沈/
いきしょうてん /意気衝天/
いきしょうにん /生き証人/
いきじごく /生き地獄/
いきじびき /生き字引/
いきす /伊岐須/
いきすぎ /行き過ぎ/行過ぎ/
いきすじ /粋筋/
いきそそう /意気阻喪;がっくし/意気沮喪;=意気阻喪/
いきたい /生き体;[相撲]⇔死に体/
いきだおれ /行き倒れ/
いきち /閾値/生き血/生血/域値/
いきちがい /行き違い/
いきちしょり /閾値処理/
いきつき /生月/
いきつぎ /息継ぎ/
いきつけ /行き付け/
いきづかい /息遣い/息づかい/
いきづまり /行き詰まり/
いきとうごう /意気投合/
いきどおり /憤り/
いきどまり /行き止まり/
いきな /生名/
いきない /域内/
いきなり /行き成り/行成り/
いきにんぎょう /生き人形/
いきぬき /息抜き/息抜/
いきのこり /生き残り/
いきのした /息の下/
いきのね /息の根/
いきのまつばら /生の松原/
いきはじ /生き恥/
いきば /行き場/行場/
いきびん /生きビン/
いきぼとけ /生き仏/
いきみ /生き身/
いきもの /生き物/生物/
いきやすめ /息休め/
いきょ /依拠/
いきょう /異教;pagan/異郷;foreign sky/異境;≒異郷/異香;素晴らしい香り/井京/
いきょうと /異教徒/
いきょく /医局/委曲;details.「-を尽くす」/異曲;同工-/
いきようよう /意気揚々/意気揚揚/
いきりょう /生霊/生き霊/
いきわかれ /生き別れ/
いぎ /意義;†meaning.「有-」/異議;†objection.「-を唱える」/異義;†別義。「同音-」/威儀;重々しい挙動/猪木/
いぎあり /異議有り/
いぎご /異義語/
いぎす /伊岐須/
いぎそ /意義素;sememe,semanteme/
いぎなし /異議なし/
いぎもうしたて /異議申し立て/異議申立て/異議申立/
いぎょう /偉業/異形/医業/遺業/易行/イ行/い行/
いぎょうしゅ /異業種/
いぎょうどう /易行道/
いぎりす /英吉利;Inglez/
いぎりすぐん /イギリス軍/
いぎりすせい /イギリス製/
いぎりすぶんがく /イギリス文学/
いく /育/幾/畏懼/郁;馥郁/燠;おき/礇/鬻;ひさ・ぐ/粥;かゆ/毓;「育」の異体字/生/
いく> /幾;幾度,幾尾,幾秒/
いくい /生井/
いくいな /生稲/
いくうかん /異空間/
いくえ /幾重/郁恵/育江/
いくえい /育英/
いくえいかい /育英会/
いくえいしょうがくきん /育英奨学金/
いくお /郁夫/郁雄/育男/郁生/幾雄/幾夫/
いくきゅう /育休/
いくこ /郁子/育子/幾久子/以玖子/郁久子/
いくさ /戦/軍/戰;「戦」の旧字(人名用漢字)/
いくさ> /軍;複合時はほとんどがこの字。「軍場,軍船,軍ごっこ」/
いくさか /生坂/
いくさがみ /軍神/
いくさき /行く先/
いくさち /生幸/
いくさば /軍場/
いくさひょうじょう /軍評定/
いくさびと /軍人/
いくさぶぎょう /軍奉行/
いくさぶね /軍船/
いくさぼし /軍星;北斗七星/
いくさものがたり /軍物語/
いくしま /生島/
いくしゅ /育種/
いくしゅがく /育種学/
いくしゅるい /幾種類/
いくじ /育児/意気地/
いくじかいごきゅうぎょうほう /育児介護休業法/
いくじきゅうか /育児休暇/
いくじきゅうぎょう /育児休業/
いくじきゅうぎょうきゅうふ /育児休業給付/
いくじきゅうぎょうほう /育児休業法/
いくじきゅうしょくせいど /育児休職制度/
いくじけいけん /育児経験/
いくじけいけんしゃ /育児経験者/
いくじしょ /育児書/育児所/
いくじせいど /育児制度/
いくじそうだん /育児相談/
いくじなし /意気地無し/意気地なし/
いくじのう /育児嚢/
いくじひ /育児費/
いくじぶんたん /育児分担/
いくじほうき /育児放棄/
いくすう /育雛/
いくすじ /幾筋/
いくせい /育成/
いくせいしつ /育成室;学童保育を行う施設の名称/
いくせいしゃ /育成者/
いくせいしょ /育成所/
いくせいじぎょう /育成事業/
いくせいそう /幾星霜/
いくせいぶ /育成部/
いくせいぼくじょう /育成牧場/
いくせん /幾千/
いくせんまん /幾千万/
いくそ /幾十/
いくそう /幾層/
いくぞう /郁三/幾三/
いくた /幾多/生田/
いくたがわ /生田川/
いくたさい /生田祭/
いくたじんじゃ /生田神社/
いくたはら /生田原/
いくたび /幾度/
いくたま /生玉/
いくたり /幾人/
いくたりゅう /生田流;箏曲/
いくつ /幾つ/
いくつか /幾つか/
いくつき /幾月/
いくとしつき /幾年月/
いくとせ /幾年/
いくど /幾度/
いくどうおん /異口同音/
いくにち /幾日/
いくにん /幾人/
いくねん /幾年/
いくの /生野/
いくのとうげ /生野峠/
いくは /的/
いくはら /幾原/
いくばく /幾許/幾何/
いくひと /生人/
いくひろ /郁博/
いくび /猪首/
いくびょう /育苗/
いくびょうばこ /育苗箱/
いくぶん /幾分/いく分/
いくほど /幾程/
いくま /伊玖磨/
いくまん /幾万/
いくみ /育巳/
いくもう /育毛/
いくもうざい /育毛剤/
いくや /郁哉/育也/
いくゆう /育友/
いくゆうかい /育友会/
いくゆうかいかつどう /育友会活動/
いくよ /幾世/幾代/幾夜/郁代;人名/育代/
いくら /幾ら/伊倉/居倉/
いくらか /幾らか/
いくらどん /イクラ丼/
いくらなんでも /幾ら何でも/
いくりん /育林/
いくん /遺訓;「先代の-」/異訓;eg.「擦る」(する・こする)/
いぐ /伊具/
いぐさ /藺草/井草/伊草/
いぐさもく /イグサ目/Juncales/
いぐすり /胃薬/
いぐち /井口/
いぐるみ /弋/弑/
いぐん /威軍/
いけ /池/
いけい /畏敬/異形/異型/医系/
いけいさいぼう /異形細胞/
いけいざい /違警罪/
いけいしき /異形式/
いけいたい /異形態/
いけいちょう /衣掛町/
いけいのねん /畏敬の念/
いけいよう /異形葉/
いけいれん /胃痙攣/
いけうお /活魚/生け魚/活け魚/
いけうち /池内/
いけうら /池浦/
いけえ /池江/
いけお /池尾/
いけがき /生垣/生け垣/
いけがみ /池上/
いけがみきみこ /池上季実子/
いけがみせん /池上線/
いけがみつうしんき /池上通信機/
いけがめ /池亀/
いけがや /池谷/池ケ谷/
いけがわ /池川/
いけごえ /池越え/
いけさか /池坂/
いけざわ /池澤/池沢/生澤/
いけした /池下/
いけしょうじ /池庄司/
いけじり /池尻/
いけじりおおはし /池尻大橋/
いけす /生け簀/生簀/
いけずみ /活け炭/埋け炭;灰の中に埋め込んだ炭火/
いけた /井桁/
いけたに /池谷/
いけだ /池田/
いけだこうこう /池田高校/
いけだし /池田市/
いけだちょう /池田町/
いけだやじけん /池田屋事件;[日本史](1864)/
いけだりよこ /池田理代子/
いけつき /池月/
いけつつみ /池堤/
いけづくり /活け造り/活け作り/生け作り/生け造り/
いけど /池戸/
いけどり /生け捕り/
いけなが /池永/
いけなみ /池波/
いけにえ /生贄/生け贄/犠牲/犠/牲/犧;旧字/
いけの /池野/池乃/
いけのうえ /池ノ上/
いけのはた /池の端/
いけのぼう /池坊/池の坊/
いけはぎ /生剥/
いけはら /池原/
いけばな /生け花/活け花/挿花/活花/生花/
いけび /埋け火;=うずみび/
いけぶくろ /池袋/
いけぶくろえき /池袋駅/
いけぶくろえきひがしぐち /池袋駅東口/
いけぶくろかん /池袋間/
いけぶくろぐち /池袋口/
いけぶくろせいぶ /池袋西武/
いけぶくろせん /池袋線/
いけぶくろせんえんせん /池袋線沿線/
いけぶくろてん /池袋店/
いけぶくろとうぶ /池袋東武/
いけぶくろにしぐち /池袋西口/
いけべ /池辺/
いけぽちゃ /池ポチャ/
いけみず /池水/
いけみや /池宮/
いけもと /池本/
いけもり /池森;姓/
いけや /池谷/
いけやま /池山/
いけわき /池脇;姓/
いけん /意見/違憲/異見;異存・忠告/遺賢/威権/
いけんこうい /違憲行為/
いけんこうかん /意見交換/
いけんこうかんちゅう /意見交換中/
いけんこうこく /意見広告/
いけんしょ /意見書/
いけんせい /違憲性/
いけんなど /意見等/
いけんはんけつ /違憲判決/
いけんばこ /意見箱/
いけんばん /意見番/
いけんひょうめい /意見表明/
いけんようぼう /意見要望/
いけんらん /意見欄/
いけんりっぽうしんさ /違憲立法審査/
いけんりっぽうしんさけん /違憲立法審査権/
いげた /井桁/
いげん /威厳/異言/遺言/威嚴;「厳」旧字/
いげんご /異言語/
いげんびょう /医原病/
いこ /依怙/遺孤/
いこーる /＝;equal/≒/≠/
いこい /憩い/憩/
いこう /以降/移行/意向/遺構/遺稿/威光/移項/衣桁/偉功/異香/偉効/胃腔/維綱/
いこうあん /移行案/
いこうき /移行期/
いこうきかん /移行期間/
いこうきかんちゅう /移行期間中/
いこうご /移行後/
いこうさき /移行先/
いこうさぎょう /移行作業/
いこうじ /移行時/
いこうずみ /移行済/
いこうせい /移行性/
いこうそち /移行措置/
いこうそちきかん /移行措置期間/
いこうぞう /異構造/
いこうだんかい /移行段階/
いこうちゅう /移行中/
いこうちょうさ /意向調査/
いこく /異国/
いこくしゅみ /異国趣味/
いこくじょうちょ /異国情緒/
いこくじん /異国人/
いこくてき /異国的/
いこじ /意固地/依怙地/
いこつ /遺骨/
いこつちょうさ /遺骨調査/
いこま /生駒/居駒/
いこまこうさくせん /生駒鋼索線/
いこまし /生駒市/
いこまやま /生駒山/
いこみ /鋳込み/
いこみき /已己巳己/
いこん /遺恨/意根/
いこんじあい /遺恨試合/
いこんたいけつ /遺恨対決/
いご /以後/囲碁/伊語/
いごう /伊号/意業;[仏教]/
いごきし /囲碁棋士/
いごきょうかい /囲碁協会/
いごこうざ /囲碁講座/
いごこち /居心地/
いごころ /居心/
いごしょうぎぶ /囲碁将棋部/
いごたいかい /囲碁大会/
いごん /遺言/
いごんしょうしょ /遺言証書/
いさ /異差/伊佐/諌;「諫」の異体字/
いさい /委細/異才/異彩;-を放つ/偉才/
いさお /勲/功/勇夫/勲男/勳;「勲」の旧字(人名用漢字)/烈/勇雄/
いさおし /勲/功/
いさか /井坂/伊坂/
いさかい /諍い/諍/
いさき /伊佐木/鶏魚/
いさく /遺作/
いさこ /いさ子/
いさご /砂金/砂子/沙/砂/
いささか /聊か/些か/
いさつ /縊殺/
いさな /勇魚/鯨魚/細小魚/小魚/
いさはや /諫早;地名/諌早;「諫」異体字/
いさはやわん /諫早湾/
いさはら /井佐原/
いさみ /勇/
いさみあし /勇み足/勇足/
いさみはだ /勇み肌/
いさむ /勇/勲/勳;「勲」の旧字(人名用漢字)/
いさやま /諌山/伊佐山/
いさり /漁/
いさりび /漁火/
いさわ /石和/井沢/伊沢/井澤/伊澤/
いさわおんせん /石和温泉/
いさん /遺産/胃酸/胃散/違算/
いさんかた /胃酸過多/
いさんかたしょう /胃酸過多症;[医]/
いさんぜい /遺産税/
いさんそうぞく /遺産相続/
いさんそうぞくけん /遺産相続権/
いさんそうぞくにん /遺産相続人/
いさんどうき /遺産動機/
いさんぶんかつ /遺産分割/
いざい /異材/偉材/
いざかや /居酒屋/
いざき /井崎/伊崎/
いざけ /居酒/
いざなぎ /伊邪那岐/伊弉諾/
いざなぎけいき /伊弉諾景気/
いざなぎのみこと /伊邪那岐命/伊弉諾尊/
いざなみ /伊邪那美/伊弉冉/
いざやしょ /イザヤ書;[聖書]Isaiah(Is,Isa)/
いざよい /十六夜/
いざよいにっき /十六夜日記/
いざよいのつき /十六夜の月;陰暦一六日の月/
いざり /躄/
いざりうお /躄魚/
いざわ /井沢/伊沢/伊澤/
いし /石/医師/意思;†purpose. 思っていること。「-表示」/意志;†will. 決意したこと・する能力。「-が弱い」/遺志;†「亡父の-」/縊死/遺址;relics/遺子;orphan/頤使;人をアゴで使う/頤指;=頤使/遺思;?/
いしあたま /石頭/
いしい /石井/
いしいも /石芋/
いしうす /石臼/
いしうち /石打/
いしうちやま /石打山/
いしおか /石岡/
いしおざん /石尾山/
いしかい /医師会/
いしかべ /石壁/
いしかめ /石亀/
いしかり /石狩/
いしかりがわ /石狩川/
いしかりし /石狩市/
いしかりちょう /石狩町/
いしかりなべ /石狩鍋/
いしかりぬまた /石狩沼田/
いしかわ /石川/石河/
いしかわえき /石川駅/
いしかわけん /石川県/
いしかわけんない /石川県内/
いしかわこうせん /石川高専/
いしかわごえもん /石川五右衛門/
いしかわじま /石川島/
いしかわじまはりま /石川島播磨/
いしかわじゅん /石川淳/
いしかわせん /石川線/
いしかわたくぼく /石川啄木/
いしかわだい /石川台/
いしかわちょう /石川町/
いしかわちょうえき /石川町駅/
いしがき /石垣/
いしがきくうこう /石垣空港/
いしがきし /石垣市/
いしがきじま /石垣島/
いしがに /石蟹/
いしがね /石金/
いしがま /石窯;(炭焼き用)/石釜;(製塩用)/石鎌;(弥生時代の石器)/
いしがみ /石神/石上/
いしがめ /石亀/
いしがわら /石瓦/
いしき /意識/伊敷/臀/
いしきか /意識下;†subconscious.「-の願望」/意識化;†awaken.「問題の-」/
いしきかいかく /意識改革/
いしきかてい /意識過程/
いしきしょうがい /意識障害/
いしきじょう /意識上/
いしきちょうさ /意識調査/
いしきてき /意識的/
いしきのながれ /意識の流れ;[文学]stream of consciousness/
いしきふめい /意識不明/
いしきりば /石切場/石切り場/
いしきれべる /意識レベル/
いしく /石工/
いしくに /石國/
いしくら /石倉/
いしくれ /石塊/
いしぐみ /石組み/石組/
いしぐろ /石黒/
いしぐろけん /石黒賢/
いしけってい /意思決定/意志決定/
いしけっていかてい /意思決定過程/意志決定過程/
いしけっていきかん /意思決定機関/
いしけっていしゃ /意思決定者/
いしけっていほうしき /意思決定方式/
いしけっていほうほう /意思決定方法/意志決定方法/
いしけり /石蹴り/
いしげ /石毛/石下/
いしこ /石子/
いしこし /石越/
いしこしえき /石越駅/
いしこじん /医師個人/
いしこっかしけん /医師国家試験/
いしころ /石塊/石ころ/
いしごう /石郷/
いしごおり /石氷/
いしざか /石坂/
いしざかせん /石坂線/
いしざき /石崎/
いしざきがわ /石崎川/
いしざら /石皿/
いしざわ /石澤/石沢/
いししかく /医師資格/
いしした /石下/
いししゅぎ /意思主義/
いししょう /異嗜症;[精医]異食症/
いしじ /石地/
いしじま /石島/石嶋/
いしず /石津/
いしずえ /礎/
いしずか /石塚;※仮名遣い「いしづか」/
いしずけ /石附;※仮名遣い「いしづけ」?/
いしずみ /石炭/
いしそつう /意思疎通/
いしそね /石曽根/
いしぞね /石曽根/
いしだ /石田/
いしだい /石鯛/
いしだか /石高/
いしだかみち /石高道/
いしだたみ /石畳/甃;NB:「しきがわら」とも訓む/
いしだみつなり /石田三成/
いしだりゅう /石田流/
いしだん /石段/
いしつ /異質/遺失/
いしつか /石塚/
いしつせい /異質性/
いしつぶつ /遺失物/
いしつぶて /石礫/石つぶて/
いしつみ /石積み/
いしづ /石津/
いしづえ /礎/
いしづか /石塚/
いしづき /鐓/石突き/石突/
いしづくり /石造り/石作り/
いしづけ /石附/
いしづみ /石積み;mansory/
いしてき /意志的/
いしでら /石寺/
いしでんたつ /意思伝達/
いしとうろう /石燈篭/
いしとび /石飛/
いしどう /石堂/
いしどうろう /石灯籠/
いしどこ /石床/
いしどりや /石鳥谷/
いしなぎ /石投;魚名/
いしなげ /石投げ/
いしなべ /石鍋/
いしぬき /石貫/
いしの /石野/
いしのうりょく /意思能力/
いしのまき /石巻/
いしのまきえき /石巻駅/
いしのまきし /石巻市/
いしのまきせん /石巻線/
いしのみ /石鑿/
いしのもり /石之森/
いしはくじゃく /意志薄弱/
いしはた /石畑/
いしはま /石浜/
いしはら /石原/
いしはらかんじ /石原莞爾/
いしはらさんぎょう /石原産業;[企業名]/
いしはらしんたろう /石原慎太郎/
いしはらゆうじろう /石原裕次郎/
いしはり /石播/
いしば /石場/
いしばい /石灰/
いしばし /石橋/
いしばしえき /石橋駅/
いしばしかん /石橋間/
いしばち /石鉢/
いしばり /石張り/
いしひょうじ /意思表示/意志表示;?/
いしひょうめい /意思表明/意志表明;?/
いしびつ /石櫃/
いしぶし /石伏/
いしぶみ /碑/石文/
いしへん /石偏/
いしべ /石部/石辺/
いしべい /石塀/
いしべきんきち /石部金吉/
いしほう /医師法/
いしほういはん /医師法違反/
いしぼとけ /石仏/
いしま /石間/
いしまき /石巻/
いしまつ /石松/
いしまつえき /石松駅/
いしまる /石丸/
いしまるでんき /石丸電気/
いしみ /石見/
いしみち /石道/
いしみつ /石光/
いしみね /石嶺/
いしむら /石村/
いしむれ /石牟礼/
いしむろ /石室/
いしめ /石目/
いしめんきょ /医師免許/
いしもた /石母田/
いしもだ /石母田/
いしもち /石持/石首魚/
いしもと /石本/石元/
いしもり /石森/
いしもりしょうたろう /石森章太郎/
いしゃ /医者/慰謝;NB:「慰藉」の常用漢字での書き換え/慰藉;慰め労る/
いしゃやく /医者役/
いしゃりょう /慰謝料;NB:「慰藉料」の常用漢字での書き換え/慰藉料/
いしや /石屋/
いしやかわしゃこ /石屋川車庫/
いしやがわ /石屋川/
いしやき /石焼/石焼き/
いしやきいも /石焼き芋/石焼芋/
いしやま /石山/
いしやまさかもとせん /石山坂本線/
いしやまざか /石山坂/
いしやまでら /石山寺/
いしゅ /異種;variant/異株;雌雄-/意趣;-返し/遺珠;滄海の-/縊首/
いしゅう /異臭/蝟集/遺習/伊州;伊賀/
いしゅうち /意趣討ち/
いしゅかくとうぎ /異種格闘技/
いしゅかくとうぎせん /異種格闘技戦/
いしゅかんきょう /異種環境/
いしゅがえし /意趣返し/
いしゅぎり /意趣斬り/
いしゅく /萎縮/畏縮;畏れ縮こまる/蝟縮;ハリネズミ(蝟)のように畏縮する/委縮;?/
いしゅくしょう /萎縮症/
いしゅくびょう /萎縮病;[植物]/
いしゅこうはい /異種交配;[生物]crossbreed/
いしゅせい /異種性/
いしゅせいめいたい /異種生命体/
いしゅぞく /異種族/
いしゅつ /移出/
いしゅばらし /意趣晴らし/
いしゆみ /弩/石弓;crossbow/
いしょ /遺書/医書/異書/移書/緯書/
いしょう /衣装/衣裳;≒衣装 (原義は「上衣と裳裾」)/意匠/異称/囲障/遺詔/
いしょうがえ /衣装替/
いしょうけーす /衣装ケース/
いしょうけん /意匠権/
いしょうせい /意匠性/
いしょうだな /衣装棚/
いしょうだんす /衣装箪笥/
いしょうてき /意匠的/
いしょうとうろく /意匠登録/
いしょうほう /意匠法/
いしょく /移植/委嘱/異色/衣食/異食;pica/依嘱;頼りにする/
いしょくごて /移植鏝/移植ごて/
いしょくさぎょう /移植作業/
いしょくさく /異色作/移植作/
いしょくしゃ /移植者/
いしょくしゅじゅつ /移植手術/
いしょくしょう /異食症/
いしょくじゅう /衣食住/
いしょくじゅつ /移植術/
いしょくじょう /委嘱状/移植上/
いしょくじょうほう /移植情報/
いしょくすう /移植数/
いしょくせい /移植性/
いしょくたんぺんしゅう /異色短編集/
いしょくちゅう /移植中/
いしょくど /移植度/
いしょくどうげん /医食同源/
いしょくばん /移植版/
いしょくぶつ /移植物/
いしりょく /意志力/
いしわおんせん /石和温泉;※いさわおんせん?/
いしわた /石綿;asbestos/石渡;人名/
いしわたり /石渡/
いしわら /石原/
いしわり /石割/石割り/
いしん /維新/威信/以深/遺臣/異心/
いしんぐんだん /維新軍団/
いしんご /維新後/
いしんでんしん /以心伝心/
いしんは /維新派/
いしんりき /維新力/
いじ /維持/意地/医事/遺児;orphan/異字;-同訓/位次;rank/異時;another time/遺事;先代の-/異事;emergency/医治/依次/意字;⇔音字/依恃;depend/
いじかんり /維持管理/
いじげん /異次元/
いじげんくうかん /異次元空間/
いじたい /異字体/
いじち /伊地知/
いじっぱり /意地っ張り/
いじどうくん /異字同訓;eg.「取る」「録る」「撮る」/
いじひ /維持費/
いじひよう /維持費用/
いじめ /苛め/
いじめっこ /苛めっ子/いじめっ子/
いじめられっこ /苛められっ子/いじめられっ子/
いじゃく /胃弱/
いじゅう /移住/
いじゅういん /伊集院/
いじゅうけん /居住権/
いじゅうしゃ /移住者/
いじゅつ /医術/
いじょう /以上/異常;†abnormal.「-事態」/異状;†unusual.『西部戦線-なし』/移譲;†ゆずりわたす。「土地の-」/委譲;†ゆずり、ゆだねる。「権限の-」/移乗/囲繞/≧;>=/
いじょう> /異常;-事態,-値/
いじょういでんし /異常遺伝子/
いじょうおん /異常音/
いじょうかしょ /異常箇所/
いじょうきしょう /異常気象/
いじょうけい /異常系/
いじょうけんしゅつ /異常検出/
いじょうげんしょう /異常現象/
いじょうこうどう /異常行動/
いじょうしゃ /異常者/
いじょうしゅうりょう /異常終了/
いじょうしょくよく /異常食欲/
いじょうしんどう /異常振動/
いじょうしんりがく /異常心理学;abnormal psychology/
いじょうじ /異常時/
いじょうじたい /異常事態/
いじょうじょうたい /異常状態/
いじょうじんかく /異常人格/
いじょうせい /異常性/
いじょうせいかく /異常性格/
いじょうせいよく /異常性欲/
いじょうそうこう /異常走行/
いじょうぞうしょく /異常増殖/
いじょうち /異常値/
いじょうつうち /異常通知/
いじょうど /異常度/
いじょうどうさ /異常動作/
いじょうにんき /異常人気/
いじょうにんしん /異常妊娠/
いじょうねんしょう /異常燃焼/
いじょうはっせい /異常発生/
いじょうはんざい /異常犯罪/
いじょうはんしょく /異常繁殖/
いじょうふ /偉丈夫/
いじょうぶんさん /異常分散/
いじょうぶんべん /異常分娩/
いじょうぷりおん /異常プリオン/
いじょく /居職/
いじら /伊自良/
いじり /井尻/
いじるし /井印/
いじわる /意地悪/
いじん /偉人;hero/異人;foreigner/
いじんかん /異人館/
いじんしゅ /異人種/
いじんでん /偉人伝/
いす /椅子/倚子;=椅子/柞;[植物]イスノキ/
いすい /渭水/
いすう /位数/異数/
いすか /交喙/
いすがた /椅子型/
いすけ /伊介/
いすこうげき /椅子攻撃/
いすず /いすゞ/
いすずがわ /五十鈴川/
いすずじどうしゃ /いすゞ自動車;[企業名]/
いすせき /椅子席/
いすとりげーむ /椅子取りゲーム/
いすのき /柞/
いすばい /柞灰/
いすみ /夷隅/伊角;姓/
いすみぐんし /夷隅郡市/
いすみまち /夷隅町/
いすらえるぐん /イスラエル軍/
いすらむきょう /イスラム教/
いすらむきょうこく /イスラム教国/
いすらむきょうと /イスラム教徒/
いすらむけん /イスラム圏/
いすらむぶんか /イスラム文化/
いすらむほう /イスラム法/
いすらむれき /イスラム暦/
いず /伊豆/伊津/
いずい /泉井/
いずかいようこうえん /伊豆海洋公園/
いずかた /何方/
いずきゅう /伊豆急/
いずきゅうこう /伊豆急行/
いずきゅうしもだ /伊豆急下田/
いずくんぞ /焉/焉んぞ/
いずこ /何処/
いずこうげん /伊豆高原/
いずし /出石/
いずしま /出島/
いずしやき /出石焼/
いずしょとう /伊豆諸島/
いずた /泉田/
いずち /何方/
いずちほう /伊豆地方/
いずつ /井筒;※仮名遣い「いづつ」/
いずながおか /伊豆長岡/
いずながおかちょう /伊豆長岡町/
いずにった /伊豆仁田/
いずぬま /伊豆沼/
いずはこね /伊豆箱根/
いずはこねてつどう /伊豆箱根鉄道/
いずはら /厳原/
いずはんとう /伊豆半島/
いずほうめん /伊豆方面/
いずまい /居ずまい/居住まい;-を正す/居住い/
いずみ /泉/和泉;地名,大阪/出水;地名,鹿児島/湶;「泉」の異体字/五住;人名/偉津美/
いずみおおつ /泉大津/
いずみかわ /泉川/
いずみがおか /泉ヶ丘/
いずみがたけ /泉ヶ岳/
いずみがわ /泉川/
いずみきょうか /泉鏡花/
いずみく /泉区/
いずみごう /泉郷/
いずみさき /泉崎/
いずみさの /泉佐野/
いずみしきぶ /和泉式部/
いずみたに /泉谷/
いずみたまがわ /和泉多摩川/
いずみだ /泉田/
いずみちゅうおう /泉中央/
いずみどの /泉殿/
いずみや /泉谷/
いずみやま /泉山/
いずみりゅう /和泉流;狂言方/
いずも /出雲/
いずもざき /出雲崎/
いずもし /出雲市/
いずもしんわ /出雲神話/
いずもたいしゃ /出雲大社/
いずもたいしゃまえ /出雲大社前/
いずものおくに /出雲阿国/
いずものくに /出雲国/
いずもべん /出雲弁/
いずれ /何れ/孰れ;-判るだろう/
いずれか /何れか/
いせ /伊勢/
いせい /異性/威勢/以西/異星/為政/遺制/遺精/
いせいあい /異性愛;⇔同性愛/
いせいあいしゃ /異性愛者/
いせいか /異性化/
いせいかこうそ /異性化酵素/
いせいかんけい /異性関係/
いせいけん /遺生研/
いせいこうゆう /異性交友/
いせいしゃ /為政者/
いせいじん /異星人/
いせいたい /異性体/
いせいぶつ /異生物/
いせえび /伊勢海老/伊勢エビ/
いせおきつ /伊勢奥津/
いせかい /異世界/
いせかいどう /伊勢街道/
いせき /遺跡/移籍/井関/遺蹟;=遺跡/偉績/
いせききんがく /移籍金額/
いせきぐみ /移籍組/
いせきけってい /移籍決定/
いせきご /移籍後/
いせきさき /移籍先/
いせきせつ /移籍説/
いせきちょうさ /遺跡調査/
いせきのうき /井関農機/
いせきはっくつ /遺跡発掘/
いせきばなし /移籍話/
いせきもんだい /移籍問題/
いせきりょう /移籍料/
いせさき /伊勢崎/伊勢左木/
いせざき /伊勢崎/伊勢佐木/
いせざきせん /伊勢崎線/
いせざきちょう /伊勢崎町/
いせしま /伊勢志摩/
いせじ /伊勢路/
いせじどうしゃどう /伊勢自動車道/
いせじんぐう /伊勢神宮/
いせせん /伊勢線/
いせたん /伊勢丹/
いせだ /伊勢田/
いせちょう /伊勢町/
いせつ /移設/異説/
いせつこうじ /移設工事/
いせつご /移設後/
いせてつどう /伊勢鉄道/
いせなかがわ /伊勢中川/
いせのたゆう /伊勢大輔;いにしへの 奈良の都の 八重桜 けふ九重に にほひぬるかな/
いせはら /伊勢原/
いせはらし /伊勢原市/
いせはらしみん /伊勢原市民/
いせほうめん /伊勢方面/
いせまいり /伊勢参り/
いせもと /伊勢本/
いせものがたり /伊勢物語/
いせや /伊勢屋/
いせり /井芹/
いせわん /伊勢湾/
いせわんたいふう /伊勢湾台風/
いせん /緯線/伊仙/以浅/胃腺/
いせんこう /胃穿孔/
いせんじょう /胃洗浄/
いぜき /井関/
いぜな /伊是名/
いぜん /以前/依然;still.「-として」/已然;⇔未然/
いぜんけい /已然形/
いぜんとうこう /以前投稿/
いぜんほうそう /以前放送/
いぜんもんだい /以前問題/
いぜんわだい /以前話題/
いそ /磯/五十/
いそう /移送/位相;phase/異相;hetero-phase/移相;phase shift/意想/遺草/
いそうお /磯魚/
いそうかいせき /位相解析/
いそうかく /位相角/
いそうかんけい /位相関係/
いそうがい /意想外/
いそうがく /位相学/
いそうき /移相器/
いそうきかがく /位相幾何学;トポロジーのことを日本語では位相幾何学という/
いそうくうかん /位相空間/
いそうくうかんろん /位相空間論/
いそうご /位相語/
いそうさ /位相差/
いそうさき /移送先/
いそうさけんびきょう /位相差顕微鏡;phase-contrast microscope/
いそうじょうほう /位相情報/
いそうすうがく /位相数学;analysis situs, topology/
いそうせいぎょ /位相制御/
いそうそくど /位相速度/
いそうてき /位相的/
いそうとくせい /位相特性/
いそうぶんぷ /位相分布/
いそうへんちょう /位相変調/
いそうろう /居候/
いそがい /磯貝/
いそがみ /磯上/
いそがわ /五十川/
いそぎあし /急ぎ足/
いそぎんちゃく /磯巾着/
いそく /夷則/
いそくど /異速度/
いそご /磯子/
いそごえき /磯子駅/
いそごく /磯子区/
いそざお /磯竿/
いそざき /磯崎/
いそし /勤し/
いそしぎ /磯鷸/
いそじ /五十路/磯路/五十/
いそじまん /磯自慢/
いそじん /磯陣/
いそだ /磯田/礒田/
いそっぷものがたり /イソップ物語;Aesop's Fables/
いそづり /磯釣り/
いそていえん /磯庭園/
いそとし /五十年;名/
いそなみ /磯波/
いその /磯野/
いそのけ /磯野家/
いそぶし /磯節;[民謡]茨城/
いそべ /磯部/磯辺/
いそべあげ /磯辺揚げ/
いそほものがたり /伊曾保物語;イソップ物語の訳本/
いそま /磯間/
いそまつ /磯松/
いそまつもく /イソマツ目/Plumbaginales/
いそみち /磯道/
いそむら /磯村/
いそめ /磯蚯蚓/
いそもじ /急文字/
いそや /磯谷/
いそやま /磯山/礒山/
いそん /依存/
いそんかんけい /依存関係;dependency/
いそんざいげん /依存財源;地方交付税など. ⇔自主財源/
いそんしょう /依存症/
いそんしん /依存心/
いそんせい /依存性/
いそんひん /易損品/
いぞう /遺贈/以蔵/
いぞく /遺族/異族/異俗/
いぞくかい /遺族会/
いぞくねんきん /遺族年金/
いぞり /居反り/
いぞん /依存;=いそん/異存;objection.「-はない」/
いぞんかいせき /依存解析/
いぞんかんけい /依存関係/
いぞんがた /依存型/
いぞんぎみ /依存気味/
いぞんしょう /依存症/
いぞんじょうほう /依存情報/
いぞんせい /依存性/
いぞんせき /依存積/
いぞんたいしつ /依存体質/
いぞんてき /依存的/
いぞんど /依存度/
いぞんぶ /依存部/
いぞんわ /依存和/
いた /板/痛/
いたあつ /板厚/
いたい /遺体/異体/板井/
いたいいたいびょう /イタイイタイ病/
いたいけ /幼気/
いたいし /板石/
いたいじ /異体字/
いたいどうしん /異体同心/
いたいめ /痛い目/
いたいもじ /異体文字/
いたかぶ /板株/
いたかべ /板壁/
いたがき /板垣/
いたがきたいすけ /板垣退助/
いたがこい /板囲い/
いたがね /板金/鈑/
いたがみ /板紙/
いたがらす /板硝子/板ガラス;plate glass/
いたきれ /板切れ/
いたく /委託;任せる。「-販売」/依託;頼る/
いたくがいしゃ /委託会社/
いたくがくせい /依託学生/
いたくきん /委託金/依託金;?/
いたくぎょうしゃ /委託業者/
いたくけんきゅう /委託研究/
いたくしゃ /委託者/
いたくしょうこきん /委託証拠金/
いたくはんばい /委託販売/
いたくはんばいひん /委託販売品/
いたくばいばい /委託売買;証券会社が顧客の委託により行う有価証券の売買。⇔自己売買/
いたくほしょうきん /委託保証金/
いたくら /板倉/
いたくりょう /委託料/
いたけだか /居丈高/
いたこ /潮来;地名/板子/
いたこぶし /潮来節;俗謡/
いたご /板子;和船の底板/
いたさと /板里/
いたさん /板さん/
いたざい /板材/
いたざき /板崎/
いたしかた /致し方/
いたしかゆし /痛し痒し/
いたしゃ /痛車/
いたしんどう /板振動/
いたじき /板敷/
いたじょう /板状/
いたずき /病/
いたずら /悪戯;mischief.「子供の悪戯」/徒;vain.「徒な出費」/徒ら/
いたずらっこ /悪戯っ子/
いたずらに /徒に/
いたずり /板摺り;キュウリを-する/
いただき /頂き/頂/戴き/
いただきます /戴きます/
いただきもの /頂き物/戴き物/
いただたみ /板畳/
いただに /板谷;姓/
いたち /鼬/
いたちうお /鼬魚/
いたちごっこ /鼬ごっこ/
いたちょう /板長/
いたちょこ /板チョコ/
いたって /至って/
いたつき /板付き/
いたづけ /板付/
いたづら /悪戯/惡戲/
いたで /痛手/
いたでん /イタ電/
いたど /板戸/
いたどこ /板床/
いたどり /板取/
いたに /猪谷/
いたの /板野/
いたのま /板の間/
いたのり /板海苔/
いたはし /板橋/
いたば /板場/
いたばさみ /板挟み/
いたばし /板橋/
いたばしく /板橋区/
いたばしほんちょう /板橋本町/
いたばね /板発条;leaf springs/
いたばり /板張り/板張/
いたひょうめん /板表面/
いたびさし /板庇/板廂/
いたびょうし /板表紙/
いたぶんこ /板文庫/
いたべい /板塀/
いたま /板間/
いたまえ /板前/
いたみ /伊丹/痛み/
いたみし /伊丹市/
いたみどめ /痛み止め/
いたみわけ /痛み分け/傷み分け;=痛み分け/
いため /板目/炒め/
いためがみ /板目紙/
いためし /イタ飯/
いためなべ /炒め鍋/
いために /炒め煮/
いためもの /炒め物/
いためん /板面/
いたもち /板持/
いたや /板谷/板屋/板矢/
いたやえき /板谷駅/
いたやがい /板屋貝/
いたやとうげ /板谷峠/
いたやなぎ /板柳/
いたやね /板屋根;[建築]/
いたよせ /板寄/
いたらぬ /至らぬ/
いたり /至り/
いたりー /伊太利/
いたりあ /伊太利亜/伊太利屋;商号?/
いたりあご /イタリア語/
いたりあさん /イタリア産/
いたりあじん /イタリア人/
いたりあせい /イタリア製/
いたりあぶんがく /イタリア文学/
いたりありょうり /イタリア料理/
いたりっくたい /イタリック体/
いたる /至/到/格/
いたるところ /至る所/到る所/
いたれりつくせり /至れり尽くせり/至れり尽せり/
いたわさ /板山葵/板わさ/
いたわり /労り/板割り/板割/功/
いたん /異端/医短/医療技術短期大学部;※abbrev/
いたんし /異端視/
いたんしゃ /異端者/
いたんしんもん /異端審問/
いたんじ /異端児/
いたんちょう /イ短調/
いたんてき /異端的/
いたんぶんし /異端分子/
いだ /井田/伊田/委佗/
いだい /偉大/医大/
いだいさ /偉大さ/
いだし /出/
いだしぐるま /出車/
いだつ /遺脱/
いだてん /韋駄天/
いだん /イ段/
いち /一/位置/市/壱;「一」の大字/弌;「一」の異体字/壹;「壱」の旧字/伊知/依遅/１/1/Ｉ;全角英数のアイ/
いち> /一/
いちあく /一握;-の砂(啄木)/
いちあくのすな /一握の砂;啄木/
いちあん /一案/
いちい /一位/一意/櫟/市井/一井/一葦/
いちいか /一位科/
いちいしめい /一位指名/
いちいせい /一意性/
いちいせんしん /一意専心/
いちいたいすい /一衣帯水/
いちいち /一々/一一/
いちいてき /一意的/
いちいん /一員/一因/一院/
いちいんせい /一院制/
いちいんとうてい /一韻到底/
いちう /一宇/
いちえ /一会/
いちえいが /一映画/
いちえねるぎー /位置エネルギー;[物理]potential energy. mgh/
いちえん /一円/
いちえんだま /一円玉/
いちおう /一応/一往/
いちおうかくにん /一応確認/
いちおうふく /一往復/
いちおうふくぶん /一往復分/
いちおく /一億/
いちおくえん /一億円/
いちおくにん /一億人/
いちおし /一押し/一推し/
いちおん /一音/
いちおんせつ /一音節/
いちかい /市貝/
いちかいいん /一会員/
いちかいそう /一階層/
いちかくにん /位置確認/
いちかくほ /位置確保/
いちかたい /一方井;姓/
いちかたりゅう /一方流/都方流/
いちかばちか /一か八か/
いちから /一から/
いちかわ /市川/
いちかわえんのすけ /市川猿之助/
いちかわけおり /市川毛織/
いちかわし /市川市/
いちかわだいもん /市川大門/
いちかわだんじゅうろう /市川団十郎/
いちかわふさえ /市川房枝/
いちかんけい /位置関係/
いちかんそく /位置観測/
いちかんたい /一艦隊/
いちがい /一概/
いちがいに /一概に/
いちがお /市ヶ尾/
いちがくしょう /一楽章/
いちがくせい /一学生/
いちがくねん /一学年/1学年/
いちがくねんした /一学年下/
いちがしら /市頭/
いちがっき /一学期/
いちがつ /一月/１月/1月/睦月;※連想,旧暦/
いちがつごう /1月号/
いちがつまえ /一月前/
いちがめん /一画面/
いちがや /市ヶ谷/市谷/市ケ谷/
いちがやさないちょう /市谷左内町/
いちがん /一眼/一丸/
いちがんれふ /一眼レフ/
いちき /市来/一木/市來;「来」旧字/
いちきしゅ /一機種/
いちきじゅん /位置基準/
いちぎ /一義/
いちぎてき /一義的/
いちぎてきせきにん /一義的責任/
いちぎゅうめいち /一牛鳴地/
いちぎょう /一行/１行/1行/
いちぎょういちぎょう /一行一行/
いちぎょうめ /一行目/
いちぎょうやろう /一行野郎;one-liner/
いちく /移築/
いちくら /肆/
いちぐう /一隅;かたすみ。「宇宙の-」/一遇;千載-/
いちぐん /一群/一軍/
いちぐんこうしきせん /一軍公式戦/
いちぐんとうろく /一軍登録/
いちけい /位置系/
いちけいさん /位置計算/
いちけいたい /一形態/
いちけいとう /一系統/
いちけってい /位置決定/
いちけん /一研/
いちけんしき /一見識/
いちけんしゅつ /位置検出/
いちけんとう /一検討/
いちげ /市毛/
いちげい /一芸/
いちげき /一撃/
いちげきひっさつ /一撃必殺/
いちげきりだつ /一撃離脱/
いちげつさんしゅう /一月三舟/
いちげん /一言/一見/一元/一限/一弦/壱源/
いちげんか /一元化/
いちげんかんり /一元管理/
いちげんきん /一弦琴/
いちげんこじ /一言居士/
いちげんさん /一見さん/
いちげんせい /一元性/
いちげんてき /一元的/
いちげんろん /一元論/
いちこ /一子/市子/巫子/神巫/伊智子/
いちこう /一高/
いちこうさつ /一考察/
いちこうもく /一項目/
いちこくみん /一国民/
いちこし /市越/
いちこじん /一個人/
いちこたい /一個体/
いちこつ /壱越/
いちこつちょう /壱越調/
いちこてい /位置固定/
いちご /苺/一期/一語/莓;別字/
いちごあじ /イチゴ味/
いちごいちえ /一期一会/
いちごいちじゅう /一伍一什/
いちごいろ /苺色/
いちごう /一号/一合/壱号/
いちごうかん /一号館/
いちごうき /一号機/
いちごうせん /一号線/
いちごうてん /一号店/
いちごうとう /一号棟/
いちごがり /いちご狩り/
いちごん /一言/
いちごんいっく /一言一句/
いちごんはんく /一言半句/
いちさんかしゃ /一参加者/
いちざ /一座/
いちざひょう /位置座標/
いちし /一志/
いちしじん /一私人/
いちしちょうしゃ /一視聴者/
いちしてい /位置指定/
いちしみん /一市民/
いちしゅうきょう /一宗教/
いちしゅぞく /一種族/
いちしゅほう /一手法/
いちしょうじょ /一少女/
いちしょうじょう /一症状/
いちしんきょう /一神教/
いちじ /一時/一次/一字/一事;-が万事/一児/伊知地/１時/1時/１次/1次/
いちじ> /一時/一次/
いちじいっく /一字一句/
いちじおくれ /一次遅れ/
いちじおくれようそ /一次遅れ要素/
いちじかい /一次会/1次会/
いちじかいこ /一時解雇;layoff/
いちじかりいれきん /一時借入金/
いちじかん /一時間/1時間/
いちじかんいない /一時間以内/
いちじかんご /一時間後/
いちじかんすう /一次関数/
いちじかんはん /一時間半/
いちじかんまえ /一時間前/
いちじかんめ /一時間目/
いちじがわ /一次側/
いちじき /一時期/
いちじきかつどう /一時期活動/
いちじききゅう /一時帰休/
いちじきこく /一時帰国/
いちじきざいせき /一時期在籍/
いちじきもんだい /一時期問題/
いちじきゅうし /一時休止/
いちじきん /一時金/
いちじきんじ /一次近似/
いちじく /無花果/一軸/
いちじくけっしょう /一軸結晶/
いちじげん /一次元/1次元/
いちじげんてき /一次元的/
いちじこくゆうか /一時国有化/
いちじさんぴん /一次産品;primary products/
いちじさんらん /一次散乱/
いちじし /一次子/
いちじしき /一次式/
いちじしけん /一次試験/
いちじしのぎ /一時凌ぎ/
いちじしょとく /一時所得;cf.給与所得/
いちじしりょう /一次資料/
いちじせんきん /一字千金/
いちじだい /一時代/
いちじちがい /一字違い/
いちじちゅうし /一時中止/
いちじちゅうだん /一時中断/
いちじつ /一日/
いちじつさんしゅう /一日三秋/
いちじつせんしゅう /一日千秋/
いちじていし /一時停止/
いちじていしゃ /一時停車/
いちじてき /一時的;temporary/一次的;primary/
いちじでんち /一次電池;primary battery. 充電できない/
いちじのがれ /一時逃れ/
いちじはんしゃ /1次反射/
いちじばらい /一時払い/
いちじばん /一字版/
いちじふぁいる /一時ファイル;temporary file/
いちじふさいり /一事不再理/
いちじへき /一次壁/
いちじへんかん /一次変換/
いちじへんすう /一時変数/
いちじほうていしき /一次方程式/
いちじほかん /一時保管/
いちじほぞん /一時保存/
いちじま /市島/市嶋/
いちじみゃく /一次脈/
いちじもくぶ /一次木部/
いちじゅ /一樹/
いちじゅう /一重/一汁/
いちじゅういっさい /一汁一菜/
いちじゅうごさい /一汁五菜;一汁三菜プラス坪・猪口/
いちじゅうさんさい /一汁三菜;飯・汁・香の物・膾・平皿・焼物/
いちじゅん /一巡/一順/一旬/
いちじゅんめ /一巡目/
いちじょ /一助/一女/
いちじょう /一条/一場/一定/一畳/一城/
いちじょうじ /一乗寺/一条寺/
いちじょうてんのう /一条天皇/
いちじょうほう /位置情報/
いちじょせい /一女性/
いちじよせん /一次予選/
いちじわだい /一時話題/
いちじん /一陣/
いちじんえい /一陣営/
いちじんぶつ /一人物/
いちすぎ /一杉/
いちず /一途/一頭/
いちせ /一瀬/
いちせいぎょ /位置制御/
いちせいど /位置精度/
いちせいぶつ /一生物/
いちせいぶん /一成分/
いちせたい /一世帯/
いちぜん /一膳/
いちそうさ /一走査/
いちそくめん /一側面/
いちぞく /一族/
いちぞくろうとう /一族郎党/
いちぞくろうどう /一族郎党/
いちぞん /一存/
いちたいいち /一対一/1対1/
いちたいいちたいおう /一対一対応/
いちたいた /一対多/
いちたに /市谷/
いちたへん /一夕偏/
いちたろう /一太郎/市太郎/
いちたんご /一単語/
いちだ /一打/一朶/市田/伊地田/
いちだい /一大/一代/一台/
いちだい> /一大;-決戦,-決心,-ニュース/
いちだいかぎり /一代限り/
いちだいがく /一大学/
いちだいき /一代記/
いちだいけっしん /一大決心/
いちだいけつい /一大決意/
いちだいざっしゅ /一代雑種/
いちだいじ /一大事/
いちだいとしより /一代年寄/
いちだいぶん /一台分/
いちだいめ /一代目/一台目/
いちだくせんきん /一諾千金/
いちださ /一打差/
いちだん /一段/一団/
いちだんうえ /一段上/
いちだんかい /一段階/
いちだんかつよう /一段活用/
いちだんした /一段下/
いちだんだか /一段高/
いちだんどうし /一段動詞/
いちだんめ /一段目/
いちだんやす /一段安/
いちだんらく /一段落/
いちちほうとし /一地方都市/
いちちょうせい /位置調整/
いちぢ /伊知地/
いちづけ /位置付け/位置づけ/
いちてき /位置的/
いちてんき /一転機/
いちとうかせい /位置透過性/
いちとくせい /一特性/
いちとし /一都市/
いちど /一度/１度/1度/
いちどう /一同/一堂;-に会する/一道/
いちどき /一時/
いちどく /一読/
いちどくらい /一度位/
いちどていど /一度程度/
いちどめ /一度目/
いちどり /位置取り/
いちな /一名/
いちなん /一難/
いちに /一二/
いちにかい /一二回/
いちにち /一日/１日/1日/
いちにちいちぜん /一日一善/
いちにちいちにち /一日一日/
いちにちいちや /一日一夜/
いちにちいっかい /一日一回/
いちにちおき /一日置き/
いちにちくらい /一日位/
いちにちけん /一日券/
いちにちご /一日後/
いちにちしょちょう /一日署長/
いちにちじゅう /一日中/
いちにちじょうしゃけん /一日乗車券/
いちにちせんしゅう /一日千秋/
いちにちてんちょう /一日店長/
いちにちのばし /一日延ばし/
いちにちぶん /一日分/
いちにちめ /一日目/
いちにてん /一二点/
いちにほ /一二歩/
いちにょ /一如/
いちにん /一任/一人/
いちにんしゃ /一人者/
いちにんしょう /一人称/
いちにんとうせん /一人当千/
いちにんまえ /一人前/
いちねん /一年/一念/1年/
いちねんいか /一年以下/
いちねんいじょう /一年以上/
いちねんいじょうまえ /一年以上前/
いちねんいない /一年以内/
いちねんかん /一年間/1年間/
いちねんかんしよう /一年間使用/
いちねんき /一年忌/
いちねんけいか /一年経過/
いちねんけいやく /一年契約/
いちねんご /一年後/1年後/
いちねんじ /一年次/
いちねんじゅう /一年中/
いちねんせい /一年生/
いちねんせいそうほん /一年生草本/
いちねんそう /一年草/
いちねんていど /一年程度/
いちねんはん /一年半/
いちねんぶん /一年分/
いちねんほっき /一念発起/
いちねんほど /一年程/
いちねんまえ /一年前/
いちねんめ /一年目/
いちの /市野/
いちのう /一能/
いちのおり /一の折;[俳諧]/
いちのき /一の樹/
いちのぎく /市之菊/市乃菊/
いちのくら /一ノ蔵/一ノ倉/一の倉/
いちのせ /一ノ瀬/一瀬/市之瀬/一の瀬/一野瀬/
いちのせき /一関/一ノ関/
いちのちょう /一の町/
いちのつかさ /市司/
いちのへ /一戸/
いちのぼう /一の坊/
いちのみや /一宮/一の宮/一ノ宮/
いちのもと /櫟本/檪本/
いちのや /一の矢/
いちはさま /一迫/
いちはざま /一迫/
いちはし /市橋/
いちはた /一畑/
いちはつ /鳶尾/
いちはな /一端/
いちはやく /いち早く/
いちはら /市原/
いちはらし /市原市/
いちはらの /市原野/
いちば /市場/一場/一馬/市庭;≒市場/
いちばい /一倍/
いちばいはん /一倍半/
いちばた /一畑/
いちばつひゃっかい /一罰百戒/
いちばまち /市場町/
いちばめん /一場面/
いちばん /一番/壱番/
いちばん> /一番/
いちばんあんしん /一番安心/
いちばんあんぜん /一番安全/
いちばんあんてい /一番安定/
いちばんいや /一番嫌/
いちばんいんしょうてき /一番印象的/
いちばんうえ /一番上/
いちばんおく /一番奥/
いちばんかくじつ /一番確実/
いちばんかん /一番館;[映画]/一番艦/壱番館/
いちばんかんじん /一番肝心/一番肝腎/
いちばんかんたん /一番簡単/
いちばんき /一番機/
いちばんきたい /一番期待/
いちばんきほんてき /一番基本的/
いちばんくろう /一番苦労/
いちばんぐみ /一番組/
いちばんこうか /一番高価/
いちばんこうかてき /一番効果的/
いちばんこうりつ /一番効率/
いちばんごうか /一番豪華/
いちばんさいあく /一番最悪/
いちばんさいきん /一番最近/
いちばんさいご /一番最後/
いちばんさいしょ /一番最初/
いちばんさき /一番先/
いちばんざんねん /一番残念/
いちばんした /一番下/
いちばんしょうぶ /一番勝負/
いちばんじゅうよう /一番重要/
いちばんじょうず /一番上手/
いちばんそこ /一番底/
いちばんそと /一番外/
いちばんたいせつ /一番大切/
いちばんたんじゅん /一番単純/
いちばんだいこ /一番太鼓;歌舞伎の開催を知らせる/
いちばんだいじ /一番大事/
いちばんちょう /一番町/一番丁/
いちばんて /一番手/
いちばんていとう /一番抵当/
いちばんてまえ /一番手前/
いちばんでし /一番弟子/
いちばんとく /一番得/
いちばんどり /一番鶏/
いちばんにんき /一番人気/
いちばんのり /一番乗り/一番乗/
いちばんはし /一番端/
いちばんひだり /一番左/
いちばんひだりがわ /一番左側/
いちばんふしぎ /一番不思議/
いちばんべんり /一番便利/
いちばんぼし /一番星/
いちばんまえ /一番前/
いちばんみぎ /一番右/
いちばんみぎがわ /一番右側/
いちばんみりょくてき /一番魅力的/
いちばんめ /一番目/1番目/
いちばんもんだい /一番問題/
いちばんやり /一番槍/
いちばんらく /一番楽/
いちひめ /市姫/
いちひめにたろう /一姫二太郎/
いちびょう /一秒/
いちびょういか /一秒以下/
いちびょうかん /一秒間/
いちびょうそくさい /一病息災/
いちびょうたんい /一秒単位/
いちびん /一便/
いちぶ /一部/一分/1部/
いちぶ> /一部;(part of) -可,-改正,-地方/
いちぶいん /一部員/
いちぶいんよう /一部引用/
いちぶかいつう /一部開通/
いちぶかっそうか /一部滑走可/
いちぶきぎょう /一部企業/
いちぶきしゅ /一部機種/
いちぶきんえん /一部禁煙/
いちぶくかん /一部区間/
いちぶしじゅう /一部始終/
いちぶしていせき /一部指定席/
いちぶしゃりょう /一部車両/
いちぶしゅうせい /一部修正/
いちぶしょうりゃく /一部省略/
いちぶしよう /一部仕様/
いちぶしろくろ /一部白黒/
いちぶじょうじょう /一部上場/
いちぶちいき /一部地域/
いちぶつ /一物/
いちぶついか /一部追加/
いちぶていせい /一部訂正/
いちぶはっぴょう /一部発表/
いちぶはんけつ /一部判決/
いちぶばっすい /一部抜粋/
いちぶふくせんか /一部複線化/
いちぶふっき /一部復帰/
いちぶぶん /一部分/
いちぶへんこう /一部変更/
いちぶへんしゅう /一部編集/
いちぶほけん /一部保険/
いちぶもん /一部門/
いちぶゆうこう /一部有効/
いちぶりゃく /一部略/
いちぶん /一文/一分/一聞/
いちぶんかいのう /位置分解能/
いちぶんし /一分子/
いちぶんせつ /一文節/
いちぶんや /一分野/
いちへいし /一兵士/
いちへんすう /1変数/一変数/位置変数/
いちへんせい /一編成/
いちべくとる /位置ベクトル/
いちべつ /一瞥/一別/
いちぺーじ /一ページ/一頁/
いちほうこう /一方向/
いちほうし /一法師/
いちほうほう /一方法/
いちぼう /一望/
いちぼうせんり /一望千里/
いちぼく /一木/
いちぼくいっそう /一木一草/
いちぼくづくり /一木造り;[彫刻]一つの木から彫り出す/
いちまい /一枚/
いちまいいた /一枚板/
いちまいいちまい /一枚一枚/
いちまいいわ /一枚岩/
いちまいうわて /一枚上手/
いちまいえ /一枚絵/
いちまいかんばん /一枚看板/
いちまいがい /一枚貝/
いちまいがわ /一枚革/一枚皮/
いちまいした /一枚下/
いちまいぶん /一枚分/
いちまいめ /一枚目/
いちまつ /市松/一抹/一松/
いちまつもよう /市松模様/
いちまん /一万/一萬/
いちまんえん /一万円/1万円/壱万円/壱萬圓/
いちまんえんさつ /一万円札/
いちまんじゃく /一万尺/
いちまんまい /一万枚/
いちみ /一味/
いちみとうがらし /一味唐辛子/
いちみととう /一味徒党/
いちみどうしん /一味同心/
いちみゃく /一脈/
いちむら /市村/一村/
いちむらざ /市村座;[歌舞伎]江戸三座の一/
いちめ /市女/
いちめい /一名/一命;-を取り留める/1名/
いちめいれい /一命令/
いちめがさ /市女笠/
いちめん /一面/
いちめんしき /一面識/
いちめんてき /一面的/
いちもう /一望;唯一の希望 (≠いちぼう)/一毛/
いちもうさく /一毛作/
いちもうだじん /一網打尽/
いちもく /一目/
いちもくさん /一目散/
いちもくりょうぜん /一目瞭然/
いちもじ /一文字/１文字/1文字/
いちもじめ /一文字目/
いちもつ /一物/逸物/
いちもん /一門;clan/一文;-なし/一問;-一答/
いちもんいっとう /一問一答/
いちもんきなか /一文半銭;はした金/
いちもんじ /一文字/
いちもんせん /一文銭/
いちもんなし /一文無し/
いちもんはんせん /一文半銭/
いちもんふち /一文不知;illiterate/
いちもんふつう /一文不通/
いちもんめ /一問目/
いちや /一夜/
いちやく /一躍/一役/
いちやくきゃっこう /一躍脚光/
いちやじょう /一夜城/
いちやづけ /一夜漬け/一夜漬/
いちやなぎ /一柳/
いちやぶん /一夜分/
いちゅう /意中/移駐/
いちゆう /一揖/
いちょ /遺著/
いちょう /胃腸/銀杏/医長/移調/公孫樹;=銀杏/異朝/移牒/鴨脚樹;=銀杏/異聴/威張;?/
いちょういも /銀杏芋/
いちょうえん /胃腸炎/
いちょうかん /胃腸管/
いちょうがえし /銀杏返し/
いちょうがっき /移調楽器/
いちょうぎり /銀杏切り;1／4円形/
いちょうこう /イチョウ綱/Ginkgopsida/
いちょうしょうがい /胃腸障害/
いちょうちょう /イ長調/
いちょうなみき /銀杏並木/
いちょうひょう /異聴表/
いちょうびょう /胃腸病/
いちょうやく /胃腸薬/
いちよ /市代/
いちよう /一様/一葉/
いちようか /一様化/
いちようき /一葉忌;11／23/
いちようしゅうそく /一様収束/
いちようせい /一様性/
いちようそ /一要素/
いちようぶんぷ /一様分布/
いちようらいふく /一陽来復/
いちようらんすう /一様乱数/
いちよく /一翼/
いちよし /市吉/
いちよそく /位置予測/
いちらん /一覧/一蘭/壹覽/
いちらんさくせい /一覧作成/
いちらんせい /一卵性/
いちらんせいそうせいじ /一卵性双生児/
いちらんひょう /一覧表/
いちらんひょうじ /一覧表示/
いちり /一理;-ある/一利;百害あって-なし/一里/
いちりいちがい /一利一害/
いちりき /一力/
いちりつ /一律/市立/一率;?/
いちりつかぜい /一律課税/
いちりつてき /一律的/
いちりつふなばし /市立船橋/
いちりづか /一里塚/
いちりの /一里野/
いちりやま /一里山/
いちりゅう /一流/一粒;-万倍/一留/
いちりゅうきぎょう /一流企業/
いちりゅうせんしゅ /一流選手/
いちりゅうだいがく /一流大学/
いちりゅうば /一流馬/
いちりゅうまんばい /一粒万倍/
いちりょう /一両/
いちりょういき /一領域/
いちりょうしゃ /一両車/
いちりょうじつ /一両日/
いちりょうじつちゅう /一両日中/
いちりようしゃ /一利用者/
いちりん /一輪/1輪/
いちりんか /一輪花/
いちりんざし /一輪挿し/
いちりんしゃ /一輪車/
いちる /一縷/
いちるい /一塁/一類/
いちるいがわ /一塁側/
いちるいしゅ /一塁手/
いちるいそうしゃ /一塁走者/
いちれい /一例/一礼/
いちれつ /一列/1列/
いちれつめ /一列目/
いちれん /一連;-の事件/一蓮;-托生/
いちれんたくしょう /一蓮托生/
いちろ /一路/
いちろう /一浪/一郎/一朗/市郎/伊知郎/
いちろうた /一朗太/
いちろくぎんこう /一六銀行;質屋 (NB:1+6=7しち)/
いちろなんか /一路南下/
いちろへいあん /一路平安;Bon voyage!/
いちろん /一論/
いちわ /一話/一羽/
いちわかんけつ /一話完結/
いちわり /一割/
いちわりいじょう /一割以上/
いちわりびき /一割引/
いっ /逸/
いっか /一家/一過;「台風-」/一課;「捜査-」/一和;調和していること/一価;[化学]monovalent.「-のイオン」/一下;「号令-」/一顆;ひとつぶ/
いっかい /一介/一回/一階/一塊/１回/1回/１Ｆ/
いっかいいっかい /一回一回/
いっかいき /一回忌/
いっかいごと /一回毎/
いっかいじゅつごろんり /一階述語論理/
いっかいせい /一回性/一回生;freshman/
いっかいせき /一階席/
いっかいせん /一回戦/一回線;single line/
いっかいていど /一回程度/
いっかいてん /一回転/
いっかいぶん /一回分/
いっかいめ /一回目/１回目/
いっかかんすう /一価関数/
いっかく /一角/一画/一郭/一攫;-千金/一廓;=一郭/一劃;「画」旧字/一獲;=一攫/
いっかくじゅう /一角獣/
いっかくじゅうざ /一角獣座;Monoceros(Mon)/
いっかくせんきん /一攫千金/一獲千金;=一攫千金 (NB:「攫」は「掴む」の意)/
いっかくせんにん /一角仙人/
いっかげつ /一ヶ月/一カ月/一箇月/１ヶ月/１か月/
いっかげつまえ /一箇月前/
いっかげん /一家言/
いっかごん /一家言;※「いっかげん」が正しい/
いっかしょ /一箇所/一カ所/一ヶ所/一か所/1カ所/
いっかしんじゅう /一家心中/
いっかせい /一過性/
いっかだんらん /一家団欒/
いっかつ /一括;-払い/一喝;バカモン！/
いっかつこうにゅう /一括購入/
いっかつさくじょ /一括削除/
いっかつしょり /一括処理/
いっかつそうしん /一括送信/
いっかつとうろく /一括登録/
いっかつにゅうりょく /一括入力/
いっかつばらい /一括払い/
いっかつへんかん /一括変換/
いっかつほう /一括法/
いっかてき /一過的/
いっかりさん /一家離散/
いっかりつ /一価律/
いっかん /一環/一貫/一巻/一管/
いっかんきょういく /一貫教育/
いっかんせい /一貫性/
いっかんぼん /一巻本/
いっき /一気/一揆/一期/逸機/一騎/一季/一機/一輝;人名/
いっきいちゆう /一喜一憂/
いっきうち /一騎打ち/一騎討ち/一騎打/
いっきかせい /一気呵成/
いっきく /一掬/
いっきせい /一期生/
いっきつうかん /一気通貫/
いっきとうせん /一騎当千/
いっきに /一気に/
いっきのみ /一気飲み/
いっきゃく /一脚/
いっきゅう /一級/一休/一球/
いっきゅうけんちくし /一級建築士/
いっきゅうひん /一級品/
いっきょ /一挙/逸居;easygoing/
いっきょいちどう /一挙一動/
いっきょう /一興/一驚/
いっきょく /一曲/一極/一局/
いっきょくこうぞう /一極構造/
いっきょくしゅうちゅう /一極集中/一局集中;?/
いっきょくめ /一曲目/
いっきょこうかい /一挙公開/
いっきょしゅ /一挙手/
いっきょしゅいっとうそく /一挙手一投足/
いっきょりょうとく /一挙両得/
いっきょりょうどく /一挙両得/
いっきん /一斤/一金/
いっく /一句/一区/
いっくかん /一区間/
いっけい /一計;-を案じる/一系;万世-/一景/一型/
いっけいあくせんと /一型アクセント;音韻的対立のないアクセント体系/
いっけつ /一穴/一決/溢血/
いっけん /一見/一件/一軒/一間/1件/
いっけんいっけん /一軒一軒/
いっけんしき /一見識/
いっけんや /一軒家/
いっけんやど /一軒宿/
いっけんらくちゃく /一件落着/
いっこ /一個/一戸/一顧;-だにしない/一己;私-/一箇/一ヶ/1個/
いっこいっこ /一個一個/
いっこう /一行/一向;-にない/一考/一項/一幸/一稿/一鉤/溢口/1項/
いっこういっき /一向一揆/
いっこうかんけい /1項関係/一項関係/
いっこうしゅう /一向宗/一向衆/
いっこく /一刻/一国/
いっこくいちじょう /一国一城/
いっこくしゅぎ /一国主義/
いっこくせんきん /一刻千金/
いっこくせんしゅう /一刻千秋/
いっこくにせいど /一国二制度/
いっこくもの /一刻者/
いっこじん /一個人/
いっこだて /一戸建て/
いっこてん /一壺天/
いっこぶん /一個分/
いっこん /一献/
いっこんぞめ /一斤染/
いっさ /一茶/
いっさい /一切/一妻;-多夫/一再;-ならず/一歳/一際;?/一済;?/
いっさい> /一切/
いっさいがっさい /一切合切/一切合財;=一切合切/
いっさいきょう /一切経/
いっさいきんし /一切禁止/
いっさいしょうりゃく /一切省略/
いっさいせきにん /一切責任/
いっさいたふ /一妻多夫/
いっさいてん /一斎点/
いっさいふかのう /一切不可能/
いっさいむかんけい /一切無関係/
いっさいむし /一切無視/
いっさく /一策;窮余の-/一作/一昨;-日/
いっさくじつ /一昨日/
いっさくねん /一昨年/
いっさくねんど /一昨年度/
いっさくばん /一昨晩/
いっさくめ /一作目/
いっさくや /一昨夜/
いっさつ /一冊/一札/
いっさつぶん /一冊分/
いっさつめ /一冊目/
いっさんか /一酸化/
いっさんかたんそ /一酸化炭素/
いっさんかたんそちゅうどく /一酸化炭素中毒/
いっさんかちっそ /一酸化窒素/
いっし /一矢;-報いる/一糸;-纏わず/一子/一指/一志/一紙/一死/逸史/
いっしあい /一試合/
いっしき /一式/一色/
いっしそうでん /一子相伝/
いっしつ /一室/逸失/一失/
いっしつりえき /逸失利益/
いっしどうじん /一視同仁/
いっしはんせん /一紙半銭/
いっしまんるい /一死満塁/
いっしゃ /一社/一者/
いっしゃせん /一車線/
いっしゃせんり /一瀉千里/
いっしゃていきょう /一社提供/
いっしゅ /一種/一首/
いっしゅ> /一種/
いっしゅう /一周/一蹴/壱州;壱岐/一週/
いっしゅうかん /一週間/
いっしゅうかんいじょう /一週間以上/
いっしゅうかんくらい /一週間位/
いっしゅうかんご /一週間後/
いっしゅうかんていど /一週間程度/
いっしゅうかんぶん /一週間分/
いっしゅうかんほど /一週間程/
いっしゅうかんまえ /一週間前/
いっしゅうき /一周忌/一周期/
いっしゅうねん /一周年/
いっしゅうめ /一週目/一周目/
いっしゅく /一宿/
いっしゅくいっぱん /一宿一飯/
いっしゅつ /逸出/
いっしゅどくとく /一種独特/
いっしゅるい /一種類/
いっしゅん /一瞬/
いっしゅんいっしゅん /一瞬一瞬/
いっしゅんかん /一瞬間/
いっしゅんでんき /一瞬電気/
いっしょ /一緒/一書/一所/逸書/佚書;=逸書/
いっしょう /一生/一升;1.8L/一笑;-に付す/一将;-功成りて万骨枯る/一章/一勝/
いっしょういっぱい /一勝一敗/
いっしょうがい /一生涯/
いっしょうけんめい /一生懸命/
いっしょうせつ /一小節/
いっしょうびん /一升瓶/
いっしょうもの /一生物/一生モノ/一生もの/
いっしょく /一色/一食/
いっしょくそくはつ /一触即発/
いっしょくた /一緒くた/
いっしょくぶん /一食分/
いっしょけんめい /一所懸命/
いっしん /一新;陣容を-する/一心;…したい-で/一身;-に引き受ける/一審/一針;頂門の-/
いっしんいったい /一進一退/
いっしんきょう /一神教/
いっしんじょう /一身上/
いっしんとう /一親等/
いっしんどうたい /一心同体/
いっしんはいそ /一審敗訴/
いっしんふらん /一心不乱/
いっしんろん /一神論/
いっすい /一睡/溢水/一炊;-の夢/一穂/
いっすん /一寸/
いっすんさき /一寸先/
いっすんぼうし /一寸法師/
いっせ /一世/一瀬/
いっせい /一斉/一声/一世/一生;人名/一成/一誠/
いっせいいちげん /一世一元/
いっせいいちだい /一世一代;※いっせいちだい/
いっせいこうげき /一斉攻撃/
いっせいしゃげき /一斉射撃/
いっせいじゅぎょう /一斉授業/
いっせいちだい /一世一代/
いっせいちょうさ /一斉調査/
いっせいどう /一誠堂/
いっせいに /一斉に/
いっせき /一石/一隻/一席/一夕;一朝-/
いっせきがん /一隻眼;見識/
いっせきにちょう /一石二鳥/
いっせつ /一節/一説/
いっせつたしょう /一殺多生/
いっせつな /一刹那/
いっせん /一線/一戦;-交える/一銭/一閃;紫電-/一千/一煎/一洗;旧弊-/
いっせんいちやものがたり /一千一夜物語/
いっせんきゅう /一線級/
いっせんごりん /一銭五厘;≒赤紙 NB:召集令状の郵便料金/
いっせんねん /一千年/
いっせんまん /一千万/
いっせんまんえん /一千万円/
いっせんめ /一煎目/
いっそ /一噌/不如/一層/
いっそう /一層/一掃/一双;a pair/逸走/一左右;一回の連絡/
いっそう> /一層;(副詞) -便利,-お求めやすく/
いっそうこうかてき /一層効果的/
いっそうべんり /一層便利/
いっそうりゅう /一噌流;笛方/
いっそく /一足/一束;-一本/
いっそくとび /一足飛び/
いったい /一体/一帯/一隊/
いったい> /一体/
いったいいち /一対一/
いったいか /一体化/
いったいかん /一体感/
いったいがた /一体型/
いったいけい /一体形/
いったいしき /一体式/
いったいせいけい /一体成形/
いったいぜんたい /一体全体/
いったいだれ /一体誰/
いったいてき /一体的/
いったいなぜ /一体何故/
いったいなに /一体何/
いったいなにもの /一体何者/
いったく /一択/一卓/
いったん /一旦;-停止/一端;-を垣間見る/一反/一短;一長-/一箪;-の食/一たん/
いったんしゅうりょう /一旦終了/
いったんちゅうし /一旦中止/
いったんていし /一旦停止/
いったんもめん /一反木綿/
いっち /一致/
いっちしすう /一致指数;[経済]coincedent index/
いっちせい /一致性/
いっちだんけつ /一致団結/
いっちてん /一致点/
いっちど /一致度/
いっちはんかい /一知半解/
いっちはんてい /一致判定/
いっちゃく /一着/
いっちゅう /一中/一籌/
いっちゅうぶし /一中節;[浄瑠璃]/
いっちゅうや /一昼夜/
いっちょう /一丁/一聴/一朝/一兆/一長/一張/
いっちょういっし /一張一弛/
いっちょういっせき /一朝一夕/
いっちょういったん /一長一短/
いっちょうめ /一丁目/１丁目/
いっちょうら /一張羅/
いっちょくせん /一直線/
いっちょくせんじょう /一直線上/
いっちょまえ /一丁前/
いっつい /一対/
いっついひかく /一対比較/
いっついひかくほう /一対比較法/
いっつう /一通/1通/
いっつうめ /一通目/
いっつうわ /一通話/
いって /一手/
いってい /一定/
いっていいか /一定以下/
いっていいじょう /一定以上/
いっていおんどいじょう /一定温度以上/
いっていかいてん /一定回転/
いっていかいてんすう /一定回転数/
いっていかく /一定角/
いっていかんかく /一定間隔/
いっていがく /一定額/
いっていがくいじょう /一定額以上/
いっていきかん /一定期間/
いっていきぼいじょう /一定規模以上/
いっていきょうど /一定強度/
いっていきょり /一定距離/
いっていしゅうき /一定周期/
いっていしゅうはすう /一定周波数/
いっていじ /一丁字/
いっていじかん /一定時間/
いっていじかんいじょう /一定時間以上/
いっていじかんかんかく /一定時間間隔/
いっていじかんご /一定時間後/
いっていじかんない /一定時間内/
いっていすう /一定数/
いっていすういじょう /一定数以上/
いっていそくど /一定速度/
いっていち /一定値/
いっていていど /一定程度/
いっていねんげん /一定年限/
いっていはば /一定幅/
いっていふへん /一定不変/
いっていりつ /一定率/
いっていりょう /一定量/
いっていりょうきん /一定料金/
いってき /一滴/一擲;乾坤-/
いってきせんきん /一擲千金/
いってこい /行って来い;±0/
いってつ /一徹/
いってるびうむ /Yb/Ytterbium/
いってん /一点/一転/一天/1点/
いってんか /一天下/
いってんがい /一点買い/
いってんき /一転機/
いってんさ /一点差/
いってんさせん /一点鎖線;—・—・/
いってんしかい /一天四海/
いってんとうし /一点透視/
いってんばり /一点張り/
いってんめ /一点目/
いってんろ /一点炉/
いっと /一途/一斗;18.039l/一都;-三県/一兎;二兎を追うものは-をも得ず/
いっとう /一等/一頭/一党/一刀/一投/一統/一灯;貧者の-/
いっとういっぱ /一党一派/
いっとうこうかいし /一等航海士/
いっとうこく /一等国/
いっとうさい /一刀斉/
いっとうしゃ /一等車/
いっとうしょう /一等賞/
いっとうしん /一等親/
いっとうせい /一等星/
いっとうそく /一投足/
いっとうそつ /一等卒/
いっとうち /一等地/一頭地;-を抜く/
いっとうどくさい /一党独裁/
いっとうへい /一等兵/
いっとうぼり /一刀彫/一刀彫り/
いっとうりゅう /一刀流/
いっとうりょうだん /一刀両断/
いっとかん /一斗缶/
いっとき /一時/
いっとく /一得/
いっとくいっしつ /一得一失/
いっとさんけん /一都三県/
いっとます /一斗枡/
いっとりうむ /Y/Yttrium/
いっぱ /一派/一波/
いっぱい /一杯/一敗/
いっぱいいっぱい /一杯一杯;見るからに-/
いっぱいきげん /一杯機嫌/
いっぱいのみや /一杯飲み屋/
いっぱいぶん /一杯分/
いっぱいほど /一杯程/
いっぱく /一泊/一拍/一白;[陰陽道]/
いっぱくふつか /一泊二日/
いっぱくめ /一拍目/
いっぱくりょこう /一泊旅行/
いっぱし /一端/
いっぱつ /一発/一髪;危機-/
いっぱつぎゃくてん /一発逆転/
いっぱつげい /一発芸/
いっぱつしょうぶ /一発勝負/
いっぱつだい /一発台/
いっぱつだいぎゃくてん /一発大逆転/
いっぱつどり /一発録り/
いっぱつにはつ /一発二発/
いっぱつへんかん /一発変換/
いっぱつめ /一発目/
いっぱつや /一発屋/
いっぱつやろう /一発野郎/
いっぱつろくおん /一発録音/
いっぱん /一般/一版/一班/一飯;一宿-/一半/一斑/
いっぱん> /一般;-部門,-会員,-ユーザ/
いっぱんいし /一般意思/
いっぱんうけ /一般受け/一般受/
いっぱんえいが /一般映画/
いっぱんえんだい /一般演題/
いっぱんか /一般化/
いっぱんかい /一般解/
いっぱんかいいん /一般会員/
いっぱんかいけい /一般会計/
いっぱんかかく /一般価格/
いっぱんかがく /一般科学/
いっぱんかく /一般角/
いっぱんかざひょう /一般化座標/
いっぱんかてい /一般家庭/
いっぱんがいねん /一般概念/
いっぱんきぎょう /一般企業/
いっぱんきじゅん /一般基準/
いっぱんきゃく /一般客/
いっぱんきょういく /一般教育/
いっぱんきょういくぶ /一般教育部/
いっぱんきょうしょ /一般教書/
いっぱんきょうしょえんぜつ /一般教書演説/
いっぱんきょうそう /一般競争/
いっぱんきょうよう /一般教養/
いっぱんけい /一般形/一般型/
いっぱんけんきゅう /一般研究/
いっぱんけんきゅうはっぴょう /一般研究発表/
いっぱんけんせつぎょう /一般建設業/
いっぱんげんごがく /一般言語学;linguistique generale. 『-講義』(Saussure)/
いっぱんげんそく /一般原則/
いっぱんげんり /一般原理/
いっぱんこう /一般項/
いっぱんこうえん /一般講演/
いっぱんこうかい /一般公開/
いっぱんこうかいび /一般公開日/
いっぱんこうかいまえ /一般公開前/
いっぱんこうしゅうかいせん /一般公衆回線/
いっぱんこうつう /一般交通/
いっぱんこうどう /一般公道/
いっぱんこうぼ /一般公募/
いっぱんこくどう /一般国道/
いっぱんこくみん /一般国民/
いっぱんご /一般語/
いっぱんさつえい /一般撮影/
いっぱんさんか /一般参加/
いっぱんさんかしゃ /一般参加者/
いっぱんざい /一般材/
いっぱんざいげん /一般財源/
いっぱんざっし /一般雑誌/
いっぱんざひょう /一般座標/
いっぱんざひょうへんかん /一般座標変換/
いっぱんし /一般紙/一般誌/
いっぱんしじょう /一般市場/一般誌上/
いっぱんしつもん /一般質問/
いっぱんしていせき /一般指定席/
いっぱんしみん /一般市民/
いっぱんしゃ /一般車/
いっぱんしゃいん /一般社員/
いっぱんしゃかい /一般社会/
いっぱんしゃしん /一般写真/
いっぱんしゃりょう /一般車両/
いっぱんしゅふ /一般主婦/
いっぱんしょ /一般書/
いっぱんしょうひぜい /一般消費税/
いっぱんしょく /一般職/一般色/
いっぱんしょせき /一般書籍/
いっぱんしょてん /一般書店/
いっぱんしょみん /一般庶民/
いっぱんしよう /一般使用/
いっぱんじげん /一般次元/
いっぱんじこう /一般事項/
いっぱんじどう /一般児童/
いっぱんじむ /一般事務/
いっぱんじゅうたく /一般住宅/
いっぱんじゅうみん /一般住民/
いっぱんじょうきゃく /一般乗客/
いっぱんじょうしき /一般常識/
いっぱんじょうせい /一般情勢/
いっぱんじょうようしゃ /一般乗用車/
いっぱんじょせい /一般女性/
いっぱんじん /一般人/
いっぱんせい /一般性/
いっぱんせいかつ /一般生活/
いっぱんせいふ /一般政府/
いっぱんせつび /一般設備/
いっぱんせんきょ /一般選挙/
いっぱんせんしゅ /一般選手/
いっぱんぜいしゅう /一般税収/
いっぱんそうたいせいりろん /一般相対性理論/
いっぱんそうたいろん /一般相対論/
いっぱんそく /一般則/
いっぱんたいしゅう /一般大衆/
いっぱんたいしょく /一般退職/
いっぱんだい /一般台/
いっぱんだんし /一般男子/
いっぱんち /一般値/
いっぱんちしき /一般知識/
いっぱんてき /一般的/
いっぱんてきかいしゃく /一般的解釈/
いっぱんてきけいこう /一般的傾向/
いっぱんてきけんかい /一般的見解/
いっぱんてきしよう /一般的使用/
いっぱんてきじょうしき /一般的常識/
いっぱんてきもんだい /一般的問題/
いっぱんてきりかい /一般的理解/
いっぱんてん /一般店/
いっぱんでんわよう /一般電話用/
いっぱんとうえい /一般投影/
いっぱんとうしか /一般投資家/
いっぱんとうろく /一般登録/
いっぱんどう /一般道/
いっぱんどうろ /一般道路/
いっぱんどくしゃ /一般読者/
いっぱんにほんじん /一般日本人/
いっぱんにゅうし /一般入試/
いっぱんにゅうじょう /一般入場/
いっぱんにゅうじょうけん /一般入場券/
いっぱんにゅうじょうしゃ /一般入場者/
いっぱんはいきぶつ /一般廃棄物/
いっぱんはっぴょう /一般発表/
いっぱんはつばい /一般発売/
いっぱんぶもん /一般部門/
いっぱんほう /一般法/
いっぱんほうそく /一般法則/
いっぱんまどぐち /一般窓口/
いっぱんみんかんじん /一般民間人/
いっぱんむき /一般向/
いっぱんめい /一般名/
いっぱんめいし /一般名詞/
いっぱんめいしょう /一般名称/
いっぱんゆーざ /一般ユーザ/
いっぱんゆーざー /一般ユーザー/
いっぱんゆうりょうどうろ /一般有料道路/
いっぱんよう /一般用/
いっぱんようご /一般用語/
いっぱんよぼう /一般予防/
いっぱんりょく /一般力/
いっぱんりょこう /一般旅行/
いっぱんりようしゃ /一般利用者/
いっぱんりろん /一般理論/
いっぱんれっしゃ /一般列車/
いっぱんろ /一般路/
いっぱんろん /一般論/
いっぱんろんてき /一般論的/
いっぱんろんぶん /一般論文/
いっぴ /１日/
いっぴき /一匹/
いっぴきおおかみ /一匹狼/
いっぴつ /一筆/
いっぴつけいじょう /一筆啓上/
いっぴょう /一票/一瓢;-の飲/1票/
いっぴん /一品/逸品/
いっぴんいっしょう /一顰一笑/
いっぴんりょうり /一品料理/
いっぷ /一夫/
いっぷいっさい /一夫一妻/
いっぷいっぷ /一夫一婦/
いっぷう /一風/一封/
いっぷく /一服/一幅;-の絵/一腹;-の兄弟/
いっぷたさい /一夫多妻/
いっぷたさいせい /一夫多妻制/
いっぷん /一分/１分/1分/
いっぷんいない /一分以内/
いっぷんかん /一分間/
いっぺい /一平/一兵;名/
いっぺいそつ /一兵卒/
いっぺき /一碧/
いっぺん /一変/一片/一辺/一編/一遍/一篇/一偏/
いっぺんとう /一辺倒/
いっぽ /一歩/
いっぽいっぽ /一歩一歩/
いっぽう /一方/一報/一法/
いっぽうつうこう /一方通行/
いっぽうつうこうきせい /一方通行規制/
いっぽうつうこうろ /一方通行路/
いっぽうてき /一方的/
いっぽさき /一歩先/
いっぽぜんしん /一歩前進/
いっぽてまえ /一歩手前/
いっぽまえ /一歩前/
いっぽん /一本/
いっぽんあし /一本足/
いっぽんあしだほう /一本足打法/
いっぽんいっぽん /一本一本/
いっぽんか /一本化/
いっぽんがたな /一本刀/
いっぽんがち /一本勝ち/
いっぽんぎ /一本気/
いっぽんさ /一本鎖/
いっぽんざし /一本差し/
いっぽんしょうぶ /一本勝負/
いっぽんすぎ /一本杉/
いっぽんすじ /一本筋/
いっぽんせん /一本線/
いっぽんぜおい /一本背負/一本背負い/
いっぽんだち /一本立ち/
いっぽんちょうし /一本調子/
いっぽんぢょうし /一本調子/
いっぽんづり /一本釣り;カツオの-/
いっぽんばし /一本橋/
いっぽんぶん /一本分/
いっぽんまつ /一本松/
いっぽんみち /一本道/
いっぽんめ /一本目/
いっぽんやり /一本槍/
いっぽんゆび /一本指/
いつ /何時/稜威/厳;=稜威/逸;逸失/佚;散佚(≒散逸)/軼;軼事(≒逸事)/溢;横溢/鎰;(かぎ)/聿;(ここに)/鴪/一/五/壱;=一/壹;「壱」の旧字/弌;「一」の異体字/乙;(漢音) おつ/伍;(人名用)/
いついつ /何時何時/
いつう /胃痛/
いつお /厳夫;名/逸生/
いつか /五日/何時か/５日/5日/
いつかいち /五日市/
いつかいちかいどう /五日市街道/
いつかいちせん /五日市線/
いつき /斎/五木/五月/五紀/樹/
いつきだ /五木田/
いつきひろゆき /五木寛之/
いつきめ /斎女/
いつくしま /厳島/
いつくしまじんじゃ /厳島神社/
いつくしみ /慈しみ/
いつこ /伊都子/
いつごろ /いつ頃/何時頃;NB:「なんじごろ」と同形/
いつざい /逸材/
いつしか /何時しか/
いつじ /逸事/軼事/
いつぞんそうしょ /佚存叢書/
いつだつ /逸脱/
いつつ /五つ/５つ/5つ/
いつつばし /五橋/
いつつぼし /五つ星;☆☆☆☆☆ 「-レストラン」/
いつつもん /五つ紋/
いつづけ /居続け/
いつでも /何時でも/
いつとものふみ /五部書/
いつなんどき /何時何時/
いつねんごう /逸年号/
いつはし /五橋/
いつぶつ /逸物/
いつぶん /逸文;lost document/逸聞;知られていない話/佚文;=逸文/
いつまで /何時迄/
いつまでぐさ /常春藤/
いつまでも /何時迄も/
いつみ /逸見/逸美/
いつも /何時も/
いつらく /逸楽/
いつわ /逸話/五和/五輪/
いつわり /偽り/
いつわりもの /偽り者/
いづ /伊津/
いづつ /井筒/
いづつや /井筒屋/
いづな /飯綱/
いづはら /厳原/出原/
いづぶち /出渕/
いづれ /何れ/孰れ/
いて /射手/
いてき /夷狄/
いてざ /射手座;Sagittarius(Sgr),(11.22-12.21)/
いてん /移転/移点;†訓点を写す/
いてんかかく /移転価格/
いてんけいかく /移転計画/
いてんさき /移転先/
いてんしゅうし /移転収支/
いてんしょとく /移転所得;[経済]transfer income/
いてんとうき /移転登記/
いてんまえ /移転前/
いで /出/井出/井手/出澤/
いであろん /イデア論/
いでい /出居/
いでぐち /井手口/
いでさわ /出澤/出沢/
いでたち /出で立ち/
いでみつ /出光/
いでむら /出村/
いでゆ /出で湯;温泉/出湯/
いでん /遺伝/異伝/位田/
いでんあるごりずむ /遺伝アルゴリズム/
いでんあんごう /遺伝暗号/
いでんいんし /遺伝因子;[生物]genetic factor/
いでんがく /遺伝学/
いでんがくしゃ /遺伝学者/
いでんけん /遺伝研/
いでんし /遺伝子/
いでんしいじょう /遺伝子異常/
いでんしかいせき /遺伝子解析/
いでんしかんけい /遺伝子関係/
いでんしかんれん /遺伝子関連/
いでんしがく /遺伝子学/
いでんしがた /遺伝子型;[生物]genotype/
いでんしぎんこう /遺伝子銀行;[新語]gene bank/
いでんしくみかえ /遺伝子組み換え;「-大豆は使用していません」/遺伝子組換え;「-大豆は使用していません」/
いでんしげん /遺伝資源/
いでんしこうがく /遺伝子工学/
いでんしごうせい /遺伝子合成/
いでんしさいぼう /遺伝子細胞/
いでんしざ /遺伝子座/
いでんししっかん /遺伝子疾患/
いでんししんだん /遺伝子診断;[医]genetic diagnosis/
いでんしじょうほう /遺伝子情報/
いでんしぜんたい /遺伝子全体/
いでんしそうさ /遺伝子操作/
いでんしちりょう /遺伝子治療/
いでんしてき /遺伝子的/
いでんしはいれつ /遺伝子配列/
いでんしひょうげん /遺伝子表現/
いでんじょうほう /遺伝情報/
いでんじょうほうしょり /遺伝情報処理/
いでんせい /遺伝性/
いでんせいしっかん /遺伝性疾患/
いでんせいたいけんきゅう /遺伝生態研究/
いでんてき /遺伝的/
いでんてきえいきょう /遺伝的影響/
いでんてきげんいん /遺伝的原因/
いでんびょう /遺伝病/
いでんほうそく /遺伝法則/
いでんや /遺伝屋/
いと /糸/意図/伊都;地名,和歌山県/絲;「糸」の旧字/異図;謀反の意図/縷;細い糸/怡土;地名,福岡県/
いとーよーかどう /イトーヨーカ堂;[企業名]/
いとい /糸井/
いといがわ /糸魚川/
いといがわし /糸魚川市/
いといがわせん /糸魚川線/
いといしげさと /糸井重里/
いとう /伊藤/伊東/以東/依投/伊富魚/伊富/
いとうえん /伊藤園/
いとうお /糸魚/
いとうおんせん /伊東温泉/
いとうし /伊東市/
いとうじゃくちゅう /伊藤若冲/
いとうせん /伊東線/
いとうちゅう /伊藤忠;[企業名]/
いとうちゅうしょうじ /伊藤忠商事;[企業名]/
いとうちゅうねんりょう /伊藤忠燃料;[企業名]/
いとうはむ /伊藤ハム;[企業名]/
いとうひろぶみ /伊藤博文;1841-1909/
いとうまん /伊藤萬/
いとうや /伊東屋/
いとおり /糸織/
いとが /糸賀/
いときり /糸切り/
いときりば /糸切り歯;犬歯/糸切歯/
いとく /遺徳;「故人の-」/威徳;威厳と人徳/懿徳;優れた徳/
いとくず /糸屑/
いとくてんのう /懿徳天皇/
いとぐち /糸口/緒/
いとぐら /糸倉/
いとぐるま /糸車/
いとこ /従兄弟/従姉妹/従兄/従弟/従姉/従妹/
いとこおおおじ /従兄弟大小父/
いとこおおおば /従兄弟大小母/
いとこおじ /従兄弟小父/
いとこおば /従兄弟小母/
いとこん /糸コン/
いとこんにゃく /糸蒟蒻;シラタキ/糸こんにゃく/糸コンニャク/
いとさき /糸崎/
いとざき /糸崎/
いとざくら /糸桜/
いとしご /愛し子;beloved child/いとし子/
いとしま /糸島/
いとじり /糸尻/
いとすぎ /糸杉/
いとぞこ /糸底/
いとたけ /糸竹/
いとたに /糸谷/
いとだ /糸田/
いとちゅう /伊藤忠/
いとづくり /糸作り/
いとてき /意図的/
いとでんわ /糸電話/
いととじ /糸綴じ;[製本]/
いととんぼ /糸蜻蛉/
いとなみ /営み/
いとぬき /糸貫/
いとのこ /糸鋸/
いとのこぎり /糸鋸/
いとひきあじ /糸引鰺/
いとふめい /意図不明/
いとへん /糸偏;「綱」の偏/
いとま /暇/遑/
いとまき /糸巻/
いとまごい /暇乞い/
いとまん /糸満/
いとまんせん /糸満線/
いとめ /糸目/厭目/
いとやま /糸山/
いとゆう /糸遊/
いとよ /糸魚/
いとようじ /糸楊枝/
いとより /糸撚り/糸縒り/
いとよりだい /糸縒鯛/
いど /井戸/緯度/異土/
いどう /移動/異動;†「人事-」/異同;†difference.「諸写本の-」/医道/
いどういち /移動位置/
いどううんよう /移動運用/
いどうかいし /移動開始/
いどうかのう /移動可能/
いどうかんけい /移動関係/
いどうがた /移動型/
いどうきゃく /移動客/
いどうきょく /移動局/
いどうきょり /移動距離/
いどうきろく /移動記録/
いどうぐみ /異動組/
いどうけい /移動系/
いどうけんけつしゃ /移動献血車/
いどうご /移動後/
いどうさき /移動先/異動先/
いどうしき /移動式/
いどうしゃ /移動者/
いどうしゅだん /移動手段/
いどうじ /移動時/
いどうじかん /移動時間/
いどうじき /移動時期/
いどうせい /移動性/
いどうそうさ /移動操作/
いどうそうち /移動装置/
いどうそくど /移動速度/
いどうたい /移動体/
いどうたいじょうほう /移動体情報/
いどうたいつうしん /移動体通信/
いどうたいでんわ /移動体電話/
いどうだな /移動棚/
いどうち /移動地/
いどうちゅう /移動中/
いどうつうしん /移動通信/
いどうつうしんぎじゅつ /移動通信技術/
いどうつうしんもう /移動通信網/
いどうてじゅん /移動手順/
いどうとどけ /異動届/
いどうど /移動度/
いどうは /移動派/
いどうはば /移動幅/
いどうはん /移動班/
いどうはんい /移動範囲/
いどうひ /移動費/
いどうひょう /移動票/
いどうび /移動日/
いどうぶったい /移動物体/
いどうへいきん /移動平均/
いどうへいきんせん /移動平均線/
いどうへいきんほう /移動平均法/
いどうほうこう /移動方向/
いどうほうほう /移動方法/
いどうまえ /移動前/
いどうめいれい /移動命令/
いどうもう /移動網/
いどうもと /移動元/
いどうもんだい /移動問題/
いどうよう /移動用/
いどうりゆう /移動理由/
いどうりょう /移動量/
いどうりょく /移動力/
いどがわ /井戸川/
いどけいど /緯度経度/
いどころ /居所/拠所/
いどし /亥年;=いのししどし/
いどたい /緯度帯/
いどちゃわん /井戸茶碗;最高級/
いどばた /井戸端/
いどばたかいぎ /井戸端会議/
いどべい /井戸塀/
いどほうこう /緯度方向/
いどほり /井戸掘り/
いどみず /井戸水/
いな /否/稲/伊奈/伊那/伊南/維那;[仏教]/稻;「稲」の旧字(人名用漢字)/
いない /以内/稲井/
いなえ /稲枝/
いなお /稲尾/稲生/
いなおえき /稲生駅/
いなおおせどり /稲負鳥/
いなおか /稲岡/
いなおり /居直り/
いなおりごうとう /居直り強盗/
いなか /田舎/
いなかことば /田舎言葉/
いなかざむらい /田舎侍/
いなかしんし /田舎紳士/
いなかず /稲数/
いなかそば /田舎蕎麦/
いなかだて /田舎館/
いなかっぺ /田舎っぺ/
いなかふう /田舎風/
いなかま /田舎間;畳一枚 = 1760x880 (⇔京間 1910x960)/
いなかまち /田舎町/
いなかみち /田舎道/
いなかもの /田舎者/
いなかわ /稲川/
いながき /稲垣/
いながきたるほ /稲垣足穂;作家。『Ａ感覚とＶ感覚』/
いながけ /稲掛;姓/
いながわ /猪名川/稲川/
いなき /稲木/稲城/
いなぎ /稲城/稲木/稲置/
いなぎし /稲城市/
いなぐら /稲倉/
いなげ /稲毛/
いなげえき /稲毛駅/
いなこ /稲子/
いなこと /異な事/
いなご /蝗/
いなさ /引佐/
いなさく /稲作/
いなさくでんらい /稲作伝来/
いなさくぶんか /稲作文化/
いなさぐん /引佐郡/
いなさやま /稲佐山/
いなざわ /稲沢/
いなしき /稲敷/
いなしろ /稲城/
いなず /稲津/
いなずま /稲妻/霆/電/
いなせ /粹;「粋」の旧字(人名用漢字)/
いなたま /稲魂/
いなだ /稲田/鰍/
いなだき /頂/
いなだま /稲魂/
いなち /稲地/
いなつき /稲築/
いなつぎ /稲継;姓/
いなづ /稲津/
いなづま /稲妻/
いななが /稲永/
いななき /嘶き/
いなにわ /稲庭/
いなの /稲野/
いなば /稲葉/因幡/稲場/
いなひさ /稲久/
いなびかり /稲光/
いなぶ /稲武/
いなぶし /伊那節;[民謡]長野/
いなぶね /稲舟/
いなべ /員弁/
いなほ /稲穂/
いなみ /井波/稲美/印南/伊波/
いなみね /稲嶺/
いなむし /蝗/
いなむら /稲村/
いなもと /稲元/
いなもり /稲森/稲盛/
いなもりざいだん /稲盛財団/
いなや /否や/
いなよし /稲吉/
いなり /稲荷/
いなりこうじ /稲荷小路/
いなりしんこう /稲荷信仰/
いなりずし /稲荷鮨/
いなりだ /稲荷田/
いなりまち /稲荷町/
いなりやま /稲荷山/
いなわしろ /猪苗代/
いなわしろこ /猪苗代湖/
いなん /以南/
いにしえ /古/古え/
いにゅう /移入/
いにゅうしゅ /移入種;[生物]≒外来種/
いにょう /囲繞/遺尿/
いにょうち /囲繞地/
いにん /委任/
いにんうらがき /委任裏書/
いにんけいり /委任経理/
いにんけいりきん /委任経理金/
いにんじむ /委任事務/
いにんじょう /委任状/
いにんとうち /委任統治/
いにんとうちりょう /委任統治領/
いにんめいれい /委任命令/
いにんりっぽう /委任立法/
いぬ /犬/狗;(字義:愛玩用の小型犬)/戌;[十二支]11/
いぬい /乾/犬井/戌亥;北西/
いぬいもん /乾門/
いぬかい /犬飼/犬養/
いぬかいつよし /犬養毅;(1855-1932) 政治家/
いぬかき /犬掻き;[水泳]/犬かき/
いぬかみ /犬上/
いぬがみ /犬神/
いぬがみぐん /犬上郡/
いぬがみけ /犬神家/
いぬき /居抜き/
いぬくい /犬食い/
いぬくぼう /犬公方;徳川綱吉/
いぬぐい /犬食い/犬喰い/
いぬころ /犬ころ/
いぬごや /犬小屋/
いぬざくら /犬桜/
いぬじに /犬死に/
いぬじにん /犬神人/
いぬぞり /犬橇/犬ぞり/
いぬたで /犬蓼/
いぬちくしょう /犬畜生/
いぬっころ /犬っころ/
いぬつか /犬塚/
いぬどし /戌年/
いぬなき /犬鳴/
いぬにく /犬肉/
いぬねこ /犬猫/
いぬのふぐり /犬の陰嚢;[植物]/
いぬは /犬派/
いぬばしり /犬走り;[建築]建物の外周の地面を固める/犬走/
いぬぶえ /犬笛/
いぬぶし /犬伏/
いぬぼう /犬棒/
いぬぼうさき /犬吠崎/犬吠埼/
いぬぼうざき /犬吠埼/
いぬまる /犬丸/
いぬめ /犬目/
いぬやま /犬山/
いぬやまし /犬山市/
いぬやまじょう /犬山城/
いぬやまばし /犬山橋/
いぬよう /犬用/
いね /稲/稻/伊根/禾/
いねか /イネ科/稲科/
いねかり /稲刈り/稲刈/
いねだ /稲田/
いねちょう /伊根町/
いねなが /稲永/
いねの /稲野/
いねみつ /稲光/
いねむり /居眠り/
いねむりうんてん /居眠り運転/
いねもく /イネ目/Glumiflorae/Graminales/Poales/
いねん /為念/
いねんごう /異年号/
いの /猪/伊野/井野/猪野/
いのいちばん /いの一番/
いのう /異能/伊能;人名/稲生/衣嚢/
いのうえ /井上/井之上/
いのうえてつじろう /井上哲次郎/
いのうえやすし /井上靖;(1907-1991)作家。『しろばんば』/
いのうえようすい /井上陽水/
いのうただたか /伊能忠敬/
いのおか /猪岡/
いのかしら /井の頭/
いのかしらこうえん /井の頭公園/
いのかしらせん /井の頭線/
いのがしら /井の頭/
いのがしらこうえん /井の頭公園/
いのき /猪木/
いのくち /井口/
いのくま /猪熊/
いのぐち /井ノ口/井口/
いのこ /猪の子/豕/
いのこずち /牛膝/
いのこへん /豕偏/
いのこり /居残り/
いのさか /猪坂/
いのしかちょう /猪鹿蝶/
いのしし /猪/亥;[十二支]12/豕/猯;(まみ)/
いのししどし /亥年/
いのししなべ /猪鍋/
いのした /井下/
いのせ /猪瀬/
いのだ /伊野田/
いのち /命/生命;(当て字)/
いのちからがら /命辛々/命辛辛/
いのちがけ /命懸け/命がけ/
いのちごい /命乞い/
いのちしらず /命知らず/
いのちづな /命綱/
いのちとり /命取り/
いのちのつな /命の綱/
いのちびろい /命拾い/
いのなか /井の中/
いのはら /猪原/
いのふ /胃の腑/
いのぶた /猪豚/
いのべ /井ノ部/
いのま /猪摩/
いのまた /猪俣/猪股/
いのまま /意のまま/
いのめ /猪の目/
いのめげぎょ /猪の目懸魚/
いのり /祈り/祷/
いのる /祷/
いは /伊波/
いはい /位牌/違背/
いはく /威迫/医博/曰く/
いはつ /遺髪/衣鉢/
いはら /井原/伊原/庵原/
いはらさいかく /井原西鶴;(1642-93)浮世草子作者。『好色一代男』/
いはらだ /居原田/
いはん /違反/違犯;法に背き、罪を犯す/
いはんきっぷ /違反切符;-を切られる/
いはんこうい /違反行為/
いはんしゃ /違反者/違反車;「-のレッカー移動」/
いはんしゃりょう /違反車両/
いはんじじつ /違反事実/
いはんないよう /違反内容/
いば /射場/伊庭/井場/
いばく /帷幕/
いばしょ /居場所/
いばしんえん /意馬心猿/
いばら /茨/棘/荊/井原/
いばらき /茨城;-県/茨木;大阪府-市/
いばらきけん /茨城県/
いばらきてん /茨木店/
いばらきべん /茨城弁/
いばらぎ /茨城;※いばらき/
いばらぎえき /茨木駅;※いばらき/
いばらぎけん /茨城県;※いばらき/
いばらぎけんない /茨城県内;※いばらき/
いばらぎけんほくぶ /茨城県北部;※いばらき/
いばらぎけんみん /茨城県民;※いばらき/
いばらぎし /茨木市;※いばらきし/
いばらぎだいがく /茨城大学;※いばらき/
いばらぎてん /茨木店;※いばらき/
いばらぎほうそう /茨城放送;※いばらき/
いばらのみち /茨の道/
いばらももく /イバラモ目/Najadales/
いばり /尿/
いばん /異版/
いひょう /意表/依憑/違表;?/
いひょうき /異表記/
いひん /遺品/
いび /揖斐;地名/萎靡;萎縮/威部;沖縄の聖地・神/依微;かすか/
いびがわ /揖斐川/
いびき /鼾/
いびしゃ /居飛車/
いびつ /歪/飯櫃/
いびつなり /飯櫃形/
いびょう /胃病/
いふ /畏怖/異父/委付/依附/
いふ> /異父;-[兄弟姉妹]/
いふう /威風;-堂々/遺風;relic/異風;変わった風習/
いふうどうどう /威風堂々/威風堂堂/
いふきょうだい /異父兄弟/
いふく /衣服/異腹/威服/
いふくべ /伊福部/
いふごう /異符号/
いふしん /畏怖心/
いぶ /慰撫/威武/伊武/ＥＶＥ/
いぶか /井深/
いぶき /息吹;「春の-」/伊吹;[植物]chinese juniper/
いぶきやま /伊吹山/
いぶくろ /胃袋/
いぶしぎん /燻し銀/
いぶすき /指宿/
いぶすきおんせん /指宿温泉/
いぶすきせん /指宿線/
いぶすきまくらざきせん /指宿枕崎線/
いぶせ /井伏/
いぶせますじ /井伏鱒二;作家。『山椒魚』/
いぶつ /異物;-が混入する/遺物;過去の-/
いぶつかん /異物感/
いぶり /胆振/
いぶん /異文;variant.「-の註記」/異聞;珍しい話。「-録」/遺文;遺した文。「聖人の-」/遺聞;知られぬ話/
いぶんか /異文化/
いぶんかりかい /異文化理解/
いぶんし /異分子/
いぷしろん /ε;epsilon/Ε;Epsilon/
いぷしろんせんい /ε遷移/
いへき /胃壁/
いへや /伊平屋/
いへん /異変/韋編/
いへんさんぜつ /韋編三絶/
いべ /伊部/井部/
いべんとれつ /イベント列/
いほう /違法/異邦;alien/彙報;報告の取り集め/移封/異方;-性(anisotropy)/遺芳;後世に遺る業績・書跡/遺法;ancient law/異法;異なる法。「-地域」/
いほうかいぞう /違法改造/
いほうかいぞうしゃ /違法改造車/
いほうきょく /違法局/
いほうけんちく /違法建築/
いほうこうい /違法行為/
いほうこぴー /違法コピー/
いほうし /違法視/
いほうじょうたい /違法状態/
いほうじん /異邦人/
いほうせい /違法性;illegality/異方性;anisotropy.「光学-」/
いほうせいそきゃく /違法性阻却/
いほうたい /異方体/
いほうちゅうしゃ /違法駐車/
いほうちゅうしゃしゃりょう /違法駐車車両/
いほうは /違法派/
いほうひん /違法品/
いほうろん /違法論/
いほく /以北/
いほん /異本/
いぼ /異母/疣;wart/揖保;地名,兵庫県/肬;≒疣/贅;<rare> ≒疣/
いぼ> /異母;-[兄弟姉妹]/
いぼう /威望/依傍/
いぼがわ /揖保川/
いぼきょうだい /異母兄弟/
いぼく /遺墨/
いぼじ /疣痔/
いぼだい /疣鯛/
いま /今/居間/
いまい /今井/
いまいけ /今池/
いまいじょう /今以上/
いまいずみ /今泉/
いまいち /今一/今市;地名,栃木/今イチ/
いまいちど /今一度/
いまいちばん /今一番/
いまいっぽ /今一歩/
いまいで /今出/
いまいま /今今/
いまいみき /今井美樹/
いまおか /今岡/
いまかがみ /今鏡;作品名/
いまかれ /今彼;[口]今の彼氏/
いまがね /今金/
いまがわ /今川/
いまがわやき /今川焼/
いまき /今来/
いまげんざい /今現在/
いまこまち /今小町/
いまころ /今頃/
いまごろ /今頃/今ごろ/
いまさき /今崎/
いまさっき /今さっき/
いまさと /今里/
いまさら /今更/今さら/
いまし /汝/
いましがた /今し方/今しがた/
いましばらく /今暫く/
いましま /今嶋/
いましめ /戒め;warning.「師の-」/縛め;bondage.「-を解く」/誡め;=戒め/警め;≒戒め/
いまじぶん /今時分/
いまじょう /今庄/今城/
いますこし /今少し/
いまず /今津/
いまずせん /今津線/
いまぜき /今関/
いまだ /未だ/未/今田/
いまだかつて /未だ嘗て/
いまだて /今立/
いまだに /未だに/
いまち /井街/
いまちづき /居待月/
いまづ /今津/
いまづえき /今津駅/
いまづかん /今津間/
いまづほうめん /今津方面/
いまで /今出/
いまでがわ /今出川/
いまでがわどおり /今出川通り/
いまど /今戸/
いまどうしん /今道心/
いまどき /今時/今どき/
いまなお /今尚;even now/今なお/今猶/
いまなか /今中/今仲/
いまなが /今永/
いまに /今仁/
いまにし /今西/
いまにしきんじ /今西錦司/
いまはし /今橋/
いまはん /今半/
いまばやし /今林/
いまばり /今治/
いまひと /今仁/
いまひとつ /今一つ/
いまふう /今風/
いまふく /今福/
いまふじ /今藤;姓/
いまべっぷ /今別府/
いまべつ /今別/
いままで /今迄/今まで/
いまみち /今道/
いまみや /今宮/
いまむら /今村/
いまむらさき /今紫/
いまもって /今以て/
いまものがたり /今物語/
いまや /今や/
いまやま /今山/
いまよう /今様/
いまよういろ /今様色/
いまよううた /今様歌/
いまよし /今吉/
いまり /伊万里/
いまりやき /伊万里焼/
いまりゅう /今流/
いまる /井丸/
いまわ /今際/
いまわだい /今話題/
いまわの /忌野/
いまわのきわ /今際の際/
いみ /意味/
いみあい /意味合い/意味合/
いみあけ /忌明け/忌み明け/
いみかいしゃく /意味解釈/
いみかいせき /意味解析/
いみき /忌寸/
いみきじゅつ /意味記述/
いみきそく /意味規則/
いみげんご /意味言語/
いみこうぞう /意味構造/
いみことば /忌み言葉/忌み詞/忌言葉/
いみさよう /意味作用/
いみしょり /意味処理/
いみしん /意味深/
いみしんちょう /意味深長/
いみじょう /意味上/
いみず /射水/
いみそ /意味素;seme/
いみちしき /意味知識/
いみづけ /意味付け/
いみてき /意味的/
いみな /諱/
いみないよう /意味内容/
いみなし /意味無/
いみび /忌日/斎日;縁起の悪い日/忌み日/
いみふめい /意味不明/
いみふめいりょう /意味不明瞭/
いみめいりょう /意味明瞭/
いみもの /斎物/忌物/忌み物/
いみや /井宮/
いみょう /異名/
いみりょういき /意味領域/
いみろん /意味論/
いみろんてき /意味論的/
いみん /移民/
いみんきょく /移民局/
いみんぞく /異民族/
いむ /医務/異夢/諱/
いむしつ /医務室/
いむた /伊牟田/
いむちょう /医務長/
いむら /井村/
いむらや /井村屋/
いむらやせいか /井村屋製菓/
いめ /夢/
いめーじけんさく /イメージ検索/
いめい /異名/依命/遺命/威名/違名;異名の誤り?/
いも /芋/薯/藷/妹/
いもあらし /芋嵐/
いもあん /芋餡/芋あん/
いもうと /妹/
いもうとふうふ /妹夫婦/
いもうとぶん /妹分/
いもうとむこ /妹婿/
いもうとやく /妹役/
いもお /妹尾;せのお?/
いもかけどうふ /芋掛け豆腐/芋掛豆腐/
いもかわ /芋川/
いもかわうどん /芋川饂飩/
いもがい /芋貝/
いもがしら /芋頭/
いもがま /芋竈/
いもがゆ /芋粥/
いもがら /芋茎/芋幹/
いもざし /芋刺し/
いもじ /鋳物師/湯文字/
いもじょうちゅう /芋焼酎/藷焼酎/
いもじる /芋汁/
いもすけ /芋助/
いもせ /妹背/
いもたれ /胃もたれ/
いもだい /芋台/
いもちびょう /稲熱病/
いもちゃしゃく /芋茶杓/
いもつぎ /芋継ぎ/
いもづる /芋蔓/
いもづるしき /芋蔓式/芋づる式/
いもでんがく /芋田楽/
いもと /井本/井元/妹/
いもなっとう /芋納豆/
いもに /芋煮/
いもにかい /芋煮会/
いもになべ /芋煮鍋/
いもの /鋳物/
いものこ /芋の子;-を洗うよう/
いものし /鋳物師/
いもはぎ /芋接ぎ/
いもばん /芋版/
いもびな /芋雛/
いもほり /芋掘り/藷掘り/
いもぼう /芋棒/
いもむし /芋虫/
いもむしはぐるま /芋虫歯車/
いもめいげつ /芋名月/
いもめし /芋飯/
いもめじ /芋目地/
いももと /芋本/
いもようかん /芋羊羹/
いもり /井守/井森;人名/
いもるい /芋類/
いもん /慰問/
いや /嫌/厭/祖谷;地名/弥/彌;「弥」の旧字(人名用漢字)/否/
いやいとこ /弥従兄弟/弥従姉妹/
いやいや /嫌々;-引き受ける/否々;No,no./嫌嫌/否否/
いやおう /否応/
いやがうえにも /弥が上にも/
いやがおう /否が応/
いやがらせ /嫌がらせ/
いやき /嫌気/
いやく /医薬/意訳/違約/依約/
いやくきん /違約金/
いやくひん /医薬品/
いやくぶがいひん /医薬部外品/
いやくぶんぎょう /医薬分業/
いやけ /嫌気/
いやけい /祖谷渓/
いやし /癒し/鄙/癒やし/
いやしくも /苟も/
いやしけい /癒し系;[新語]和む雰囲気の人やモノ/
いやして /癒し手/
いやち /忌地;[園芸]連作障害/
いやちこ /灼然/
いやなが /彌永/
いやま /井山/
いやみ /嫌味/嫌み/厭味/厭み/
いゆう /畏友/
いよ /伊予/伊代/壱与/
いよいよ /愈々/愈/
いよう /異様/医用/威容/偉容/
いようがぞう /医用画像/
いようこうがく /医用工学/
いようこうぶんし /医用高分子/
いようせいみつこうがく /医用精密工学/
いよかん /伊予柑/
いよく /意欲/
いよくさく /意欲作/
いよくてき /意欲的/
いよこ /伊代子/
いよし /伊予市/
いよじ /五代嗣/
いよたに /伊豫谷/
いよだ /伊與田/
いよてつ /伊予鉄/
いよてつどう /伊予鉄道/
いよぶし /伊予節;[民謡]/
いよべん /伊予弁/
いよほうしょ /伊予奉書/
いよほうじょう /伊予北条/
いよみしま /伊予三島/
いら /苛/
いらい /以来/依頼/
いらいげんこう /依頼原稿/
いらいしゃ /依頼者/
いらいしょ /依頼書/
いらいしん /依頼心/
いらいじょう /依頼状/
いらいせい /依頼制/
いらいたいしょく /依頼退職/
いらいちゅう /依頼中/
いらいにん /依頼人/
いらいぬし /依頼主/
いらいひょう /依頼票/
いらいひん /依頼品/
いらいもと /依頼元/
いらいら /苛々/苛苛/
いらいらかん /苛々感/イライラ感/
いらえ /答え/応え/
いらか /甍/
いらくぐん /イラク軍/
いらくさ /蕁麻/刺草/
いらくさもく /イラクサ目/Urticales/
いらくさもくあぐん /イラクサ目亜群/
いらくじん /イラク人/
いらくせんそう /イラク戦争;[時事]2003年4月、米英軍がイラクに侵攻して起きた戦争/
いらこ /伊良湖;=いらご/
いらここう /伊良湖港;(いらごこう?)/
いらこみさき /伊良湖岬;=いらごみさき/
いらご /伊良湖;地名,愛知県・渥美半島/
いらごみさき /伊良湖岬;地名/
いらだち /苛立ち/
いらつ /苛つ/
いらつこ /郎子/
いらつめ /郎女/
いらぶ /伊良部/
いらべ /伊良部/
いらぼ /伊羅保/
いらん /伊蘭;Iran/
いらんいらくせんそう /イランイラク戦争/
いらんくう /囲卵腔/
いらんじん /イラン人/
いり /入り/入/圦;水門/杁;=圦/伊理/炒り/熬り;≒炒り (字義:「炒」は軽くいためる、「熬」は強烈にいりつける)/
いりあい /入会/入相/
いりあいけん /入会権/
いりあいち /入会地/
いりうち /入内/
いりうちじま /入内島/
いりうみ /入海/
いりえ /入江/入り江/
いりおもて /西表/
いりおもてじま /西表島/
いりおもてやまねこ /西表山猫/
いりかさやま /入笠山/
いりがい /入貝/
いりがた /入り方/
いりき /入来/
いりくち /入り口/
いりくり /入り繰り/
いりぐち /入口/入り口/
いりぐちがわ /入口側/
いりぐちふきん /入口付近/
いりぐちわき /入口脇/
いりこ /海参/炒り粉/煎り粉/熬海鼠;=海参/熬り子;≒煮干し/
いりごめ /炒り米/煎り米/
いりさ /入佐/
いりさく /入作;(受け入れ側から見た)小作/
いりさわ /入澤/
いりざけ /煎り酒/
いりしお /入潮/
いりじうむ /Ir/Iridium/
いりすみ /入隅/入角;=入隅/
いりた /入田/
いりたはま /入田浜/
いりたまご /炒り卵/炒り玉子/煎り卵/
いりどうふ /炒り豆腐/煎り豆腐/
いりなか /杁中/
いりの /入野/
いりはま /入り浜/入浜;-式塩田/
いりひ /入り日/
いりふね /入船/入り船/
いりべ /入部/
いりぼし /熬り干し/
いりまじり /入交/
いりまち /入り待ち/
いりまめ /炒り豆/煎豆/
いりむこ /入り婿/
いりもや /入母屋/
いりもやづくり /入母屋造り/入母屋造/
いりもやはふ /入母屋破風;[建築]/
いりや /入谷/
いりやま /入山/
いりゅう /慰留/移流/遺留;-品/
いりゅうぎり /移流霧/
いりゅうひん /遺留品/
いりゅうぶん /遺留分/
いりょう /医療/衣料/衣糧;衣料と食糧/
いりょういがい /医療以外/
いりょういっぱん /医療一般/
いりょうかご /医療過誤/
いりょうかつどう /医療活動/
いりょうかんけい /医療関係/
いりょうかんけいしゃ /医療関係者/
いりょうきかん /医療機関/
いりょうきき /医療機器/
いりょうきぐ /医療器具/
いりょうぎじゅつ /医療技術/
いりょうぎょうせい /医療行政/
いりょうけい /医療系/
いりょうけいむしょ /医療刑務所/
いりょうげんば /医療現場/
いりょうこうい /医療行為/
いりょうこうがく /医療工学/
いりょうさいばん /医療裁判/
いりょうしせつ /医療施設/
いりょうしょうねんいん /医療少年院/
いりょうしょち /医療処置/
いりょうしんだん /医療診断/
いりょうじこ /医療事故/
いりょうじゅうじしゃ /医療従事者/
いりょうせいど /医療制度/
いりょうせいひん /衣料製品/医療製品/
いりょうせん /医療船/
いりょうそうだん /医療相談/
いりょうそうだんまどぐち /医療相談窓口/
いりょうたんきだいがく /医療短期大学/
いりょうたんきだいがくぶ /医療短期大学部/
いりょうだんたい /医療団体/
いりょうちーむ /医療チーム/
いりょうてんすう /医療点数/
いりょうとくやく /医療特約/
いりょうはいきぶつ /医療廃棄物/
いりょうひ /医療費/
いりょうひぜんたい /医療費全体/
いりょうひふたん /医療費負担/
いりょうひん /衣料品/医療品/
いりょうひんてん /衣料品店/
いりょうふくし /医療福祉/
いりょうふたん /医療負担/
いりょうぶ /医療部/
いりょうほう /医療法/
いりょうほうしゅう /医療報酬/
いりょうほうじん /医療法人/
いりょうほけん /医療保険/
いりょうほけんせいど /医療保険制度/
いりょうみす /医療ミス/
いりょうもくてき /医療目的/
いりょうもんだい /医療問題/
いりょうよう /医療用/
いりょく /威力;power/偉力;great power/意力;will/
いりょくぎょうむぼうがい /威力業務妨害/
いりよう /入用/入り用/
いりわけ /入り訳/
いるい /衣類/異類/彙類/
いるいこんいんたん /異類婚姻譚/
いるか /海豚/鯆;=海豚 NB:「さば」とも/
いるかざ /海豚座;Delphinus(Del)/
いるかせ /忽/
いるす /居留守/
いるま /入間/
いるまがわ /入間川/
いるまし /入間市/
いれ /入れ/
いれい /異例/慰霊/威令/違例/
いれいさい /慰霊祭/
いれいひ /慰霊碑/
いれかえ /入れ替え/入替/入れ換え/入換/
いれかえせい /入れ替え制/入替制/
いれかえせん /入れ替え戦/入替戦/
いれかえよう /入換用/
いれかた /入れ方/淹れ方/
いれかわり /入れ替わり/入れ代わり/
いれかわりたちかわり /入れ替わり立ち替わり/
いれき /入木/
いれぐい /入れ食い;-状態/
いれこ /入れ子/入籠/
いれこみ /入れ込み/入込/
いれこみすう /入込数/
いれさく /入れ作/
いれずみ /入れ墨/刺青/文身/
いれたて /入れ立て/
いれちがい /入れ違い/
いれぢえ /入れ知恵/
いれつ /イ列/い列/威烈/
いれば /入れ歯/入歯/
いれふだ /入れ札/
いれぼくろ /入れ黒子/
いれもの /入れ物/容れ物/
いろ /色/艷;(つや)/
いろあい /色合い/色合/色相;?/
いろあく /色悪/
いろあげ /色揚げ/
いろあわせ /色合わせ/色合せ/
いろいがい /色以外/
いろいと /色糸/
いろいろ /色々/色色/色いろ/
いろう /慰労/遺漏/胃瘻/
いろうかい /慰労会/
いろうきん /慰労金/
いろうざき /石廊崎/
いろうつり /色移り/
いろえ /色絵/
いろえんぴつ /色鉛筆/
いろおち /色落ち/
いろおとこ /色男/
いろおび /色帯/
いろおんど /色温度/
いろおんな /色女/
いろか /色香/
いろかず /色数/
いろかわ /色川/
いろかんけい /色関係/
いろがたき /色敵/
いろがみ /色紙/
いろがら /色柄/
いろがらす /色ガラス;stained glass/
いろがわり /色変り/
いろきちがい /色気違い/
いろきろく /色記録/
いろくうかん /色空間/
いろくさ /色草/
いろくず /鱗/
いろぐすり /色釉/
いろぐるい /色狂い/
いろぐろ /色黒/
いろけ /色気/
いろこ /色子/
いろこい /色恋/
いろこいざた /色恋沙汰/
いろこう /色校/
いろこうせい /色校正/
いろごと /色事/
いろごとし /色事師/
いろごのみ /色好み/
いろさいげん /色再現/
いろさいげんせい /色再現性/
いろざと /色里/
いろざんげ /色懺悔/
いろしすう /色指数;[天文][地学]Colour Index(CI)/
いろしてい /色指定/
いろしゅうさ /色収差/
いろしんごう /色信号/
いろじかけ /色仕掛け/
いろじょうほう /色情報/
いろじろ /色白/
いろすう /色数/
いろずり /色刷り/色刷/
いろたいおう /色対応/
いろだま /色玉;柘榴/
いろちがい /色違い/
いろつき /色付き/
いろつや /色艶/
いろづかい /色使い/色遣い/
いろづけ /色付け/色付/
いろとりどり /色取り取り/
いろどめ /色止め;塩水に浸し-する/
いろどり /彩/彩り/色取り/色鳥/
いろなおし /色直し/
いろね /色音/
いろは /伊呂波/以呂波/
いろはいち /色配置/
いろはうた /伊呂波歌/
いろはじゅん /伊呂波順/
いろはじるいしょう /色葉字類抄/
いろはんてん /色反転/
いろばんごう /色番号/
いろひょうじ /色表示/
いろふごう /色符号/
いろふん /色粉/
いろぶみ /色文/
いろぶんかい /色分解/
いろほうしき /色方式/
いろほせい /色補正/
いろぼうしょ /色奉書/
いろぼけ /色ボケ/
いろまち /色町/色街/
いろみ /色見/
いろみほん /色見本/
いろむら /色斑/
いろめ /色目/
いろめい /色名/
いろめがね /色眼鏡/
いろもの /色物/
いろり /囲炉裏/鑪/鈩/
いろりったい /色立体;[色彩学]colour solid. HSBを座標化/
いろりばた /囲炉裏端/
いろわけ /色分け/色分/
いろん /異論/
いろんな /色んな/
いわ /岩/違和/磐/巖/
いわあな /岩穴/
いわい /祝/祝い/岩井/磐井/岩韋/
いわいうた /祝い唄/祝い歌/祝歌/祝唄/頌/
いわいごと /祝い事/祝事/
いわいざけ /祝い酒/祝酒/
いわいずみ /岩泉/
いわいはら /岩井原/
いわいべどき /祝部土器/
いわうち /岩内/
いわうめもく /Diapensiales/イワウメ目/
いわえのぐ /岩絵具/岩絵の具/
いわお /巌/巖;旧字/岩男/岩尾/岩夫/磐/岩雄/岩生/
いわおおじ /岩大路/
いわおか /岩岡/
いわかげ /岩陰/
いわかど /岩角/
いわかべ /岩壁/
いわかみ /岩上/
いわかめ /岩亀/
いわかわ /岩川/
いわかん /違和感/
いわがき /岩牡蠣/
いわがに /岩蟹/
いわき /岩城/磐城/岩木/岩鬼/
いわきさん /岩木山/
いわきじ /磐城路/
いわきり /岩切/
いわぎ /岩城/
いわく /曰く/曰/
いわくいんねん /曰く因縁/
いわくつき /曰く付き;-の物件/
いわくに /岩国/
いわくま /岩熊/
いわくら /岩倉/岩鞍/
いわくらともみ /岩倉具視/
いわぐみ /岩組/岩組み/
いわぐんじょう /岩群青;blue verditer/
いわさ /岩佐/
いわさき /岩崎/
いわさききょうこ /岩崎恭子/
いわさきしょてん /岩崎書店;[出版社名]/
いわさきつうしん /岩崎通信/
いわさきでんき /岩崎電気/
いわさわ /岩沢/
いわし /鰯/鰮/鰛/
いわしぐも /鰯雲/
いわした /岩下/
いわしたしま /岩下志麻/
いわしみず /岩清水/
いわしみずはちまんぐう /石清水八幡宮/
いわしみずものがたり /石清水物語/
いわしみづ /岩清水/
いわしろ /岩代/岩城/
いわずもがな /言わずもがな/
いわせ /岩瀬/石瀬/
いわた /岩田/磐田/
いわたき /岩滝/
いわたけ /岩岳/岩茸/
いわたし /磐田市/
いわたしみんぶんかかいかん /磐田市民文化会館/
いわたに /岩谷/
いわたや /岩田屋/
いわだけ /岩岳/
いわだたみ /岩畳;長瀞の- (ながとろ.天然記念物)/
いわだな /岩棚/
いわだぬき /岩狸/
いわつう /岩通/
いわつか /岩塚/
いわつき /岩槻/岩月/
いわつばめ /岩燕/
いわつぼ /岩壺/
いわて /岩手/
いわてけん /岩手県/
いわてけんみんかいかん /岩手県民会館/
いわてこうげん /岩手高原/
いわてだいがく /岩手大学/
いわてほうそう /岩手放送/
いわてんじょう /岩天井/
いわで /岩出/
いわでやま /岩出山/
いわと /岩戸/磐戸/石門/
いわとくせん /岩徳線/
いわとけいき /岩戸景気/
いわど /岩戸/
いわな /岩魚/
いわない /岩内/
いわないこう /岩内港/
いわなみ /岩波;-書店/岩浪/
いわなみえき /岩波駅/
いわなみこうざ /岩波講座/
いわなみこくごじてん /岩波国語辞典/
いわなみしょてん /岩波書店;[出版社名]/
いわなみしんしょ /岩波新書/
いわなみすうがくじてん /岩波数学辞典/
いわなみぜんしょ /岩波全書/
いわなみばん /岩波版/
いわなみぶんこ /岩波文庫/
いわなみぶんこばん /岩波文庫版/
いわなみやく /岩波訳/
いわにちせん /岩日線/
いわぬま /岩沼/
いわぬまし /岩沼市/
いわぬまや /岩沼屋/
いわね /岩根/
いわの /岩野/
いわのり /岩海苔/
いわはし /岩橋/
いわはだ /岩肌/
いわはな /岩鼻/岩端;=岩鼻/
いわはら /岩原/
いわば /岩場/言わば/謂わば/
いわばやし /岩林/
いわひろ /岩廣/
いわふじ /岩藤/
いわふね /岩船/岩舟/
いわぶえ /石笛/
いわぶき /岩蕗/
いわぶち /岩渕/岩淵/
いわぶろ /岩風呂/
いわほり /岩堀/
いわま /岩間/
いわまつ /岩松/
いわみ /石見/岩美/岩見/
いわみさわ /岩見沢/
いわみざわ /岩見沢/
いわみず /岩水/
いわみだ /岩見田/
いわみね /岩峰/
いわむら /岩村/
いわむろ /岩室/石室/
いわめ /岩女魚/岩女/
いわもと /岩本/
いわや /岩屋/窟/石屋/岩谷/巌谷/
いわやま /岩山/
いわゆる /所謂/
いわれ /謂れ/
いわんや /況んや/
いん /印/韻/員/院/陰;陰性/隠;隠者/因/殷;中国の王朝(BC16c-BC11c)/慇;慇懃/淫;淫乱/婬;≒淫/霪;ながあめ/咽;咽喉/姻;婚姻/氤/茵;しとね/飲;飲食/飮;「飲」の旧字/引;引力/蚓;蚯蚓/音;母音/韵;「韻」の異体字/隕;隕石/殞;おちる/湮;証拠湮滅/堙;≒湮/胤;落胤/尹/寅;(十二支の)とら/蔭;かげ/允/廴;(えんにょう)/贇;(うつくしい)/酳/隱;「隠」の旧字/
いん> /印;[略語]インド.-パ,-哲/陰;陰部,陰音階,陰関数 ⇔陽/
いんあつ /印圧/
いんい /陰萎/因依/
いんいおん /陰イオン/
いんいつ /隠逸/淫逸/淫佚;=淫逸/
いんいん /殷々/
いんいんめつめつ /陰々滅々/陰陰滅滅/
いんう /淫雨/
いんうつ /陰鬱/
いんえい /陰影/印影/陰翳/
いんおう /印欧/
いんおうご /印欧語/
いんおうごぞく /印欧語族;[言語]Indo-European/
いんおうそご /印欧祖語/
いんおんかい /陰音階/
いんか /引火/印加;†impress.「電圧-」/印可;†(師の)承認/印花;†[陶芸]/陰火;≒鬼火/允可;聞き届ける/陰窩/
いんかか /隠花果/
いんかく /陰核/
いんかしょくぶつ /隠花植物/
いんかせい /引火性/
いんかていこく /インカ帝国/
いんかてん /引火点/
いんかでんあつ /印加電圧/
いんかふ /印花布/
いんかぶんめい /インカ文明/
いんかろん /因果論/
いんかん /印鑑/殷鑑;-遠からず/隠閑/
いんかんしょうめい /印鑑証明/
いんかんしょうめいなど /印鑑証明等/
いんかんすう /陰関数/
いんかんとうろく /印鑑登録/
いんかんや /印鑑屋/
いんが /因果/印画/陰画/
いんがい /院外/員外/
いんがいしょほうせん /院外処方箋/
いんがおうほう /因果応報/
いんがかんけい /因果関係/
いんがし /印画紙/
いんがしじょう /印画紙上/
いんがじょう /印画上/
いんがせい /因果性/
いんがてき /因果的/
いんがほうそく /因果法則/
いんがもの /因果者/
いんがものがたり /因果物語/
いんがりつ /因果律/
いんき /陰気/印記/
いんきょ /隠居/允許/殷墟/
いんきょう /印僑;華僑のインド人版/韻鏡/
いんきょく /陰極/
いんきょくかん /陰極管/
いんきょくせん /陰極線/
いんきょくせんかん /陰極線管;CRT/
いんきょせいかつ /隠居生活/
いんきょもじ /殷墟文字/
いんきん /印金/陰金/引磬;和楽器/
いんきんたむし /陰金田虫/
いんぎ /院議/
いんぎゃく /淫虐/
いんぎょう /印形/隠形/
いんぎょうてんのう /允恭天皇/
いんぎん /慇懃/
いんぎんぶれい /慇懃無礼/
いんくぎれ /インク切れ/
いんくつぼ /インク壺;ink pot/
いんぐ /淫具/
いんぐらんど /英蘭/
いんぐらんどぎんこう /イングランド銀行;Bank of England(BOE) NB:世界最古の銀行/
いんけい /陰茎/
いんけん /陰険/引見/隠顕/隠見;=隠顕/
いんげ /院家/
いんげん /隠元/
いんげんまめ /隠元豆/
いんこ /鸚哥/
いんこう /咽喉/淫行/印行/淫荒/
いんこく /陰刻/印刻/
いんご /隠語/淫語;[新語]卑猥な隠語/韻語/
いんごう /院号/因業/引業/
いんさいだーとりひき /インサイダー取引/
いんさつ /印刷/
いんさついち /印刷位置/
いんさつかのうもじ /印刷可能文字/
いんさつがいしゃ /印刷会社/
いんさつき /印刷機/
いんさつきのう /印刷機能/
いんさつきょく /印刷局/
いんさつぎじゅつ /印刷技術/
いんさつぎょう /印刷業/
いんさつぎょうかい /印刷業界/
いんさつけいしき /印刷形式/
いんさつけいひ /印刷経費/
いんさつけっか /印刷結果/
いんさつげんこう /印刷原稿/
いんさつしつ /印刷室/
いんさつしゅっぱん /印刷出版/
いんさつしゅつりょく /印刷出力/
いんさつしょ /印刷所/
いんさつじ /印刷時/
いんさつじゅつ /印刷術/
いんさつじょ /印刷所/
いんさつそうち /印刷装置/
いんさつそくど /印刷速度/
いんさつたい /印刷体/
いんさつたいしょう /印刷対象/
いんさつだい /印刷代/
いんさつちゅう /印刷中/
いんさつはいせん /印刷配線;[電子]printed wiring. cf.プリント基板/
いんさつはんい /印刷範囲/
いんさつばいたい /印刷媒体/
いんさつひ /印刷費/
いんさつひょうじゅんじたい /印刷標準字体/
いんさつぶすう /印刷部数/
いんさつぶつ /印刷物/
いんさつほうほう /印刷方法/
いんさつぼん /印刷本/
いんさつまいすう /印刷枚数/
いんさつもじ /印刷文字/
いんさつや /印刷屋/
いんさつよう /印刷用/
いんさつようげんこう /印刷用原稿/
いんさつようご /印刷用語/
いんさつようし /印刷用紙/
いんさん /陰惨/
いんざい /印材/印西;地名/
いんし /因子/印紙/院試/淫祠;邪神のやしろ/淫祀;邪神を祭る/
いんしか /因子化/
いんしぜい /印紙税/
いんしだい /印紙代/
いんしつ /陰湿/
いんしぶんせき /因子分析/
いんしぶんせきほう /因子分析法/
いんしゅ /飲酒/
いんしゅう /因習/因襲;≒因習/因州;因幡/隠州;隠岐/
いんしゅうてき /因習的/因襲的/
いんしゅうんてん /飲酒運転/
いんしゅきんし /飲酒禁止/
いんしゅりつ /飲酒率/
いんしょ /印書/引書;引用書/韻書/淫書/音書/
いんしょう /印象/印章;はんこ/引証;cite/引照;refer/陰証/
いんしょうしゅぎ /印象主義/
いんしょうてき /印象的/
いんしょうど /印象度/
いんしょうは /印象派/
いんしょうひひょう /印象批評;impressionistic criticism/
いんしょく /飲食/
いんしょくぎょう /飲食業/
いんしょくだい /飲食代/
いんしょくてん /飲食店/
いんしょくてんがい /飲食店街/
いんしょくひ /飲食費/
いんしょくぶつ /飲食物/
いんしん /陰唇/殷賑/
いんじ /印字/印璽/韻字/
いんじいち /印字位置/
いんじうむ /In/Indium/
いんじかのう /印字可能/
いんじき /印字機/
いんじけっか /印字結果/
いんじしゅつりょく /印字出力/
いんじそくど /印字速度/
いんじのうど /印字濃度/
いんじはば /印字幅/
いんじひんしつ /印字品質/
いんじほうしき /印字方式/
いんじみつど /印字密度/
いんじめい /印字名/
いんじゃ /隠者/
いんじゅ /院主/印綬/
いんじゅう /陰獣/
いんじゅん /因循/
いんじゅんこそく /因循姑息/
いんじょ /淫女/
いんじょう /引接/引摂/
いんじれい /印字例/
いんすい /引水;我田-/飲水/淫水;愛液/
いんすう /員数;メンバー数/因数;factor/引数;NB:電算用語としては「ひきすう」が一般的/
いんすうていり /因数定理/
いんすうぶんかい /因数分解/
いんすうれつ /引数列/
いんずう /員数/
いんせい /院生/陰性/院政;上皇・法皇による政治/隠棲/隠栖;=隠棲/隕星/
いんせいけんきゅうしつ /院生研究室/
いんせいしつ /院生室/
いんせいはんのう /陰性反応/
いんせき /隕石/引責/姻戚/殞石;=隕石/
いんせきかんけい /姻戚関係/
いんせきじにん /引責辞任/
いんせつ /引接/
いんせん /陰線;shade line. 陰を表す線/隠線;hidden line. 陰に隠れる線/
いんせんしょり /陰線処理/
いんせんぽう /陰旋法/
いんぜい /印税/
いんぜいしゅうにゅう /印税収入/
いんぜいせいかつ /印税生活/
いんぜみ /院ゼミ/
いんぜん /隠然/院宣/
いんそう /印相/
いんそつ /引率/院卒/
いんそつきょうし /引率教師/
いんそつしゃ /引率者/
いんぞう /印相/
いんぞく /姻族/
いんたい /引退/隠退/院体/
いんたいあいさつ /引退挨拶/
いんたいご /引退後/
いんたいしき /引退式/
いんたいじ /引退時/
いんたいじあい /引退試合/
いんたいずもう /引退相撲/
いんたいせつ /引退説/
いんたいせんげん /引退宣言/
いんたいひょうめい /引退表明/
いんたいまえ /引退前/
いんだすぶんめい /インダス文明;Indus/
いんち /吋/引致/韻致/
いんちょう /院長/院庁/
いんちん /影青/
いんてい /陰梃/
いんてつ /隕鉄/
いんてん /院展/
いんでぃあんざ /インディアン座;Indus(Ind)/
いんでぃかまい /インディカ米;長粒種/
いんでんき /陰電気/
いんでんし /陰電子/
いんとう /咽頭/淫蕩/
いんとうえん /咽頭炎/
いんとうかじょ /隠頭花序/
いんとうけつまくねつ /咽頭結膜熱;[医]pharyngoconjunctival fever(PCF)/
いんとうへき /咽頭壁/
いんとく /隠匿/
いんとくざい /隠匿罪/
いんとん /隠遁/
いんど /印度/
いんどう /引導/陰道/犬童;姓/
いんどこうろ /インド航路;[世界史]欧州→喜望峰→印度/
いんどしな /印度支那/
いんどじん /印度人/インド人/
いんどぞう /インド象;indian elephant/
いんどてつがく /インド哲学/
いんどねしあご /インドネシア語/
いんどよーろっぱごぞく /インドヨーロッパ語族;[言語]Indo-European/
いんどよう /インド洋/
いんどりょうり /インド料理/
いんどわた /インド綿/
いんない /院内/印内/
いんないかんせん /院内感染/
いんなみ /印南/
いんに /因位/陰に/
いんにく /印肉/
いんにゅうし /院入試/
いんにょう /飲尿/廴繞;[部首]/
いんにん /隠忍/
いんにんじちょう /隠忍自重/
いんねん /因縁/
いんのう /陰嚢/
いんのしま /因島/
いんのしょう /院庄/
いんば /印旛/
いんばい /淫売/
いんばぐん /印旛郡/
いんばぬま /印旛沼/
いんばん /印判/
いんぱ /印パ;India-Pakistan/院派/
いんぱるすおうとう /インパルス応答/
いんび /淫靡/隠微/韻尾/
いんびさ /淫靡さ/
いんびせん /因美線/
いんぴ /隠避/隠秘/
いんふらせいび /インフラ整備/
いんぶ /陰部/
いんぶん /韻文/陰文;⇔陽文/
いんぷ /印譜/淫婦/殷富/陰阜/
いんぷく /隠伏/
いんべん /員弁/
いんぺい /隠蔽/
いんぺいかん /隠蔽艦/
いんぺいこうさく /隠蔽工作/
いんぺいし /隠蔽子/
いんぺいしょく /隠蔽色;保護色など/
いんぺいたいしつ /隠蔽体質/
いんぺいりょく /隠蔽力/
いんぼ /韻母/
いんぼう /陰謀/
いんぼうせつ /陰謀説/
いんぼうろん /陰謀論/
いんぽん /院本/印本/淫奔/淫本/
いんみょう /因明/
いんむ /淫夢/
いんめい /因明/
いんめつ /隠滅/湮滅/堙滅;証拠-/
いんめん /印面/隠面/
いんめんしょうきょ /隠面消去/
いんめんちょうしょ /員面調書/
いんもう /陰毛/
いんもん /陰門/陰文;=いんぶん/
いんゆ /隠喩;[修辞]metaphor/引喩;[修辞]allusion/
いんゆてき /隠喩的/
いんゆぶん /隠喩文/
いんゆほう /隠喩法/
いんよう /引用/飲用/陰陽/
いんよういがい /引用以外/
いんようか /陰陽家/引用可/
いんようかいし /引用開始/
いんようきごう /引用記号/
いんようきじ /引用記事/
いんようきょか /引用許可/
いんようぎょう /引用行/
いんようごぎょうせつ /陰陽五行説/
いんようさんしょう /引用参照/
いんようし /引用始/
いんようしゅうりょう /引用終了/
いんようしょ /引用書/
いんようじ /引用時/
いんようじゅん /引用順/
いんようすい /飲用水/
いんようちゅう /引用中/
いんようふ /引用符/
いんようふか /引用不可/
いんようぶ /引用部/
いんようぶぶん /引用部分/
いんようぶん /引用文/
いんようぶんけん /引用文献/
いんようぶんちゅう /引用文中/
いんようほうほう /引用方法/
いんようもと /引用元/
いんようれい /引用例/
いんよく /淫欲/
いんらく /淫楽/
いんらん /淫乱/
いんりつ /韻律/
いんりつろん /韻律論;prosody/
いんりょう /飲料/
いんりょうすい /飲料水/
いんりょうよう /飲料用/
いんりょく /引力/
いんりょくけん /引力圏/
いんれい /引例/
いんれき /陰暦/
いんれつ /陰裂/
いんろう /印籠/印篭/
いんわい /淫猥/
う /雨/右/得/鵜/有/卯;[十二支](4)うさぎ/羽;羽毛/挧;(くぬぎ)/于/宇;宇宙/迂;迂回/紆;紆余曲折/盂;盂蘭盆/芋;いも/兎;うさぎ/禹;古代中国の聖王/齲;(むしば)/傴;傴僂/嫗;おうな/烏;烏合/生/夘;「卯」の異体字/饂;饂飩/憂/胡;(唐音) こ/菟;?/
う> /右/
うーかーぴーちゅー /五加皮酒/
うーはん /武漢/
うーろん /烏龍/
うーろんちゃ /烏龍茶/ウーロン茶/
うぃ /ゐ/ヰ/
うぃーん /維納;Wien/
うぃーんがくだん /ウィーン学団;Wiener Kreis/
うぃり /干莉/
うい /初/有為/宇井;姓/
ういきょう /茴香/
ういぐるご /ウイグル語/
ういこうぶり /初冠;[文語]元服/
ういご /初子/
ういざん /初産/
ういじん /初陣/
ういち /宇一/
ういてんぺん /有為転変/
ういまご /初孫/
ういむじょう /有為無常/
ういるすせいかんえん /ウイルス性肝炎;[医]viral hepatitis/
ういるすびょう /ウイルス病/
ういろう /外郎/
ういろううり /外郎売/外郎売り/
ういろうまめ /外郎豆/
ううろんちゃ /烏龍茶/
うぇ /ゑ/ヱ/
うぇぶじょう /ウェブ上/
うぇるたーきゅう /ウェルター級/
うえ /上/飢え/植/↑/
うえ> /上;上半分,上寄り/
うええだ /上枝/
うえおか /植岡/
うえがはら /上ヶ原/
うえがめん /上画面/
うえがわ /上側/
うえき /植木/植え木/
うえきぐみ /植木組/
うえきざん /植木算/
うえきばち /植木鉢/植え木鉢/
うえきや /植木屋/
うえくさ /植草/
うえくぼ /上窪/
うえこみ /植え込み/植込み/植込/
うえさか /上坂/
うえさま /上様/
うえさんかく /上三角/
うえさんかくぎょうれつ /上三角行列/
うえしき /上式/
うえした /上下/
うえしば /植芝/
うえしま /上島/
うえじ /植字/
うえじに /飢え死に/餓え死に/餓死/
うえじま /上島/
うえす /上江洲/上須/
うえすぎ /上杉/
うえすぎけんしん /上杉謙信/
うえすぎてるとら /上杉輝虎/
うえすぎまさとら /上杉政虎/
うえぞの /上園/
うえた /植田/
うえたけ /植竹/
うえたに /上谷/
うえだ /上田/植田/
うえだあきなり /上田秋成/
うえだし /上田市/
うえちゅうだん /上中段/
うえつ /羽越/
うえつかた /上つ方/
うえつき /上付き/
うえつけ /植付け/植え付け/
うえつせん /羽越線/
うえつほんせん /羽越本線/
うえづけ /上付/
うえなか /植中/
うえにし /上西/
うえの /上野/植野/
うえのあおもりかん /上野青森間/
うえのえき /上野駅/
うえのえきまえてん /上野駅前店/
うえのおのこ /上の男;殿上人のこと/
うえのかん /上野間/
うえのがくえん /上野学園/
うえのぐち /上野口/
うえのこうえん /上野公園/
うえのし /上野市/
うえのせんそう /上野戦争;1868/
うえのちゃく /上野着/
うえのてん /上野店/
うえのどうぶつえん /上野動物園/
うえのはつ /上野発/
うえのはら /上野原/
うえのひろこうじ /上野広小路/
うえはま /上浜/
うえはら /上原/植原/
うえはらせい /上原成/
うえはんぶん /上半分/
うえひら /植平/
うえびと /上人;殿上人/
うえほうこう /上方向/
うえほんまち /上本町/
うえほんまちろくちょうめ /上本町六丁目/
うえまち /上町/
うえまつ /植松/上松/
うえむき /上向き/
うえむら /上村/植村/
うえもと /植本/
うえもり /上森/
うえもん /右衛門/
うえもんのかみ /右衛門督;[律令制]/
うえもんのじょう /右衛門尉/
うえもんふ /右衛門府;[律令制]/
うえや /↑/上矢/
うえやじるし /上矢印/
うえやま /上山/
うえろく /上本町六丁目;「うえほんまちろくちょうめ」の通り名 ※abbrev/
うえわらわ /上童/
うえん /有縁/迂遠/
うぉーるがい /ウォール街/
うお /魚/宇夫/
うおい /魚井/
うおいちば /魚市場/
うおうさおう /右往左往/
うおかす /魚滓/
うおがし /魚河岸/
うおごころ /魚心/
うおざ /魚座;Pisces(Psc),(2.19-3.20)/
うおざき /魚崎/
うおざききたちょう /魚崎北町/
うおざききたまち /魚崎北町/
うおしま /魚島/
うおしまどき /魚島時/
うおじょうゆ /魚醤油/
うおすき /魚鋤/
うおずみ /魚住/
うおせ /魚瀬/
うおぜっきょう /魚説経/
うおぜっぽう /魚説法/
うおそうめん /魚素麺/
うおたか /魚鷹/
うおだな /魚店/
うおつか /魚塚/
うおつきりん /魚付き林/
うおつり /魚釣り/
うおづ /魚津/
うおづし /魚津市/
うおに /魚荷/
うおにかわ /魚膠/
うおぬま /魚沼/
うおぬまさん /魚沼産/
うおのがわ /魚野川/
うおのめ /魚の目/
うおびしお /魚醤/
うおへん /魚偏/
うおみ /魚見/
うおみそ /魚味噌/
うおみつ /魚光/
うおや /魚屋/
うおんず /雨温図/
うおんびん /ウ音便/
うか /羽化/雨下/
うかい /迂回/鵜飼/鵜飼い/有界;[仏教]/
うかいうんてん /迂回運転/
うかいろ /迂回路/
うかいろせん /迂回路線/
うかがい /伺/伺い/窺;?/
うかがいしょ /伺い書/伺書/
うかじ /宇梶/
うかつ /迂闊/迂濶;「闊」異体字/
うかとうせん /羽化登仙/
うかぬかお /浮かぬ顔/
うかのみたま /稲魂/
うかみ /斥候/窺見/
うから /親族/
うかれ /浮かれ/
うかれめ /浮かれ女/
うかわ /鵜川/
うかん /有漢/
うかんむり /ウ冠/
うがい /嗽/鵜飼/
うがいぐすり /うがい薬/嗽薬/
うがき /宇垣/
うがく /有学/
うがちすぎ /穿ち過ぎ/
うがん /右岸/右眼/烏丸/烏桓/
うき /右記/雨季/雨期/浮き;釣り道具/浮/浮子/泛子/憂き/
うき> /浮/
うきあし /浮き足;-立つ/浮足/
うきいし /浮石/浮き石/
うきうお /浮き魚/浮魚/
うきうき /浮き浮き/
うきえ /浮江/
うきおり /浮織/
うきがや /浮ヶ谷/
うきくさ /浮草/浮き草/萍/
うきくさかぎょう /浮き草稼業/浮草稼業/
うきくさるい /浮草類/
うきぐ /浮具/
うきぐも /浮雲/
うきごし /浮腰/浮き腰/
うきさんばし /浮桟橋/
うきしずみ /浮き沈み/
うきしま /浮島/浮き島/
うきしろものがたり /浮城物語/
うきす /浮巣/
うきせいこう /雨奇晴好/
うきた /浮田/
うきだま /浮き玉/
うきつ /浮津/
うきどっく /浮ドック/浮きドック;floating dock/
うきな /浮名/浮き名/
うきはし /浮橋/浮き橋/
うきばし /浮橋/
うきふね /浮舟/浮船/
うきぶくろ /浮き袋/浮袋/鰾/
うきぼり /浮き彫り/浮彫/浮彫り/
うきみ /浮き身;†「プールで-」/浮身/浮き実;†「スープの-」/憂き身;†「-を窶す」/
うきめ /憂き目/
うきょう /右京/
うきょうしき /右京職;[律令制]朱雀大路東側の行政担当/
うきょうのだいぶ /右京大夫;[律令制]右京職の長官/
うきょく /迂曲/
うきよ /浮世/浮き世/憂き世/
うきよえ /浮世絵/
うきよえびじゅつかん /浮世絵美術館/
うきよことば /浮世言葉/
うきよぞうし /浮世草子;[文学]/
うきよばなれ /浮世離れ/浮き世離れ/
うきよぶろ /浮世風呂;式亭三馬/
うきよぼん /浮世本/
うきよものがたり /浮世物語/
うきわ /浮き輪/浮輪/
うぎょう /ウ行/う行/
うく /宇久/
うくらいな /烏克蘭/
うぐ /迂愚/
うぐい /鯏/石斑魚/
うぐいす /鶯/鴬;異体字/
うぐいすいろ /鶯色/
うぐいすざわ /鶯沢/鴬沢;異体字/
うぐいすじょう /鶯嬢/ウグイス嬢/
うぐいすだに /鴬谷/
うぐいすだにえき /鶯谷駅/
うぐいすちゃ /鶯茶/
うぐいすな /鶯菜/
うぐいすばり /鶯張り/
うぐいすぶえ /鶯笛/
うぐいすもち /鶯餅/
うぐら /葎/
うけ /有卦/食/槽/筌/受/受け/請け/
うけあい /請け合い/受け合い/請合い/受合い/
うけい /右傾/誓約/
うけいれ /受け入れ/受入/受入れ/
うけいれたいせい /受け入れ態勢/受入れ態勢/
うけうり /受け売り/受売り/請け売り/請売り/
うけおい /請負/
うけおいぎょう /請負業/
うけおいぎょうしゃ /請負業者/
うけおいにん /請負人/
うけかた /受け方/
うけがわ /受け側/
うけぎ /受け木;[建築]/
うけくち /受け口/
うけぐち /受け口/受口/
うけこたえ /受け答え/
うけごし /受け腰/
うけざら /受け皿/
うけしょ /請書/受書/
うけつけ /受付/受け付け/受付け/
うけつけかいし /受付開始/
うけつけきかん /受付期間/
うけつけきげん /受付期限/
うけつけじかん /受付時間/
うけつけじょう /受付嬢/
うけつけちゅう /受付中/
うけつけねんがっぴ /受付年月日/
うけつけばんごう /受付番号/
うけつけび /受付日/
うけて /受け手/受手/
うけとり /受取/受け取り/受取り;receipt/
うけとりかた /受け取り方/
うけとりかのう /受取可能/
うけとりかんじょう /受取勘定/
うけとりがわ /受け取り側/受取側/
うけとりきょひ /受取拒否/
うけとりご /受取後/
うけとりしょ /受取書/
うけとりしょうしょ /受取証書/
うけとりて /受け取り手/
うけとりてがた /受取手形/
うけとりにん /受取人/
うけとりりそく /受取利息/
うけにぬし /受荷主/
うけにん /請人/
うけのみたま /稲魂/
うけはらい /受払/受払い/受け払い/
うけばこ /受箱/受け箱/凵/
うけばらい /受け払い/受払/
うけぶみ /請文/
うけみ /受け身/受身/
うけもち /受け持ち/受持ち/
うけやど /請宿;口入れ屋/
うけら /朮/
うけわたし /受け渡し/受渡/受渡し/
うけわたしほうほう /受渡方法/
うけん /宇検/
うげつ /雨月/
うげつものがたり /雨月物語/
うげん /右舷/迂言/
うこう /宇高/
うこうけん /宇航研/
うこうこくどう /宇高国道/
うこうこつ /烏口骨/
うこうれんらくせん /宇高連絡船/
うこぎ /五加;[植物]aralia/五加木/
うこさべん /右顧左眄/
うこっけい /烏骨鶏;天然記念物/
うこん /右近;⇔左近/鬱金;turmeric/
うこんいろ /鬱金色/
うご /雨後/羽後/
うごう /烏合/
うごうのしゅう /烏合の衆/
うごき /動き/
うさ /宇佐/右左/憂さ/
うさがわ /宇佐川/
うさぎ /兎/卯;[十二支]4/兔;「兎」の異体字/菟;≒兎/莵;「菟」の異体字/
うさぎうま /兎馬;ロバ/驢/
うさぎがり /兎狩り/
うさぎごや /兎小屋/ウサギ小屋/
うさぎざ /兎座;Lepus(Lep)/
うさぎだいら /兎平/
うさぎとび /兎跳び/兎飛び/
うさぎどし /卯年/
うさせつ /右左折/
うさせつしゃ /右左折車/
うさばらし /憂さ晴らし/
うさみ /宇佐美/宇佐見/宇沙美/
うさわ /宇沢/
うさん /胡散/
うさんくさい /胡散臭い/
うざき /宇崎/
うざく /鰻ざく;[料理]鰻とキュウリの三杯酢和え/
うざわ /鵜沢/鵜澤/宇沢/宇澤;姓/
うし /牛/丑;[十二支]2/齲歯;むしば/
うしお /潮/牛尾/
うしおい /牛追い/
うしおいうた /牛追い唄/
うしおしゅっぱん /潮出版;[出版社名]/
うしおしゅっぱんしゃ /潮出版社;[出版社名]/
うしおじる /潮汁/
うしおだ /潮田/
うしおでんき /ウシオ電機;[企業名]/
うしおに /牛鬼/
うしかい /牛飼い/牛飼/
うしかいざ /牛飼い座;Bootes(Boo)/牛飼座;Bootes(Boo)/
うしかいめんじょうのうしょう /牛海綿状脳症;[時事]bovine spongiform encephalopathy(BSE),狂牛病/
うしがえる /牛蛙/
うしき /牛木/
うしく /牛久/
うしくぬま /牛久沼/
うしごめ /牛込/
うしごめやなぎちょう /牛込柳町/
うしごや /牛小屋/
うしじま /牛島/牛嶋/
うしじろう /牛次郎/
うした /牛田/
うしづ /牛津/
うしとら /艮/丑寅;北東/
うしどし /丑年/
うしね /牛根/
うしの /牛野/
うしのこく /丑の刻/
うしのこくまいり /丑の刻参り/
うしのひ /丑の日/
うしばえ /牛蠅/
うしぶか /牛深/
うしへん /牛偏/
うしぼり /牛堀/
うしまど /牛窓/
うしまる /牛丸/
うしみつ /丑三つ/
うしみつどき /丑三つ時;午前三時頃。「草木も眠る-」/丑三つ刻/
うしや /牛屋/
うしゅう /羽州;出羽/
うしゅうかいどう /羽州街道;奥州街道-羽州-青森/
うしょう /鵜匠/右相/羽觴/有生/有性/
うしょうべん /右少弁/
うしらん /烏糸欄/
うしろ /後ろ/後/
うしろあし /後ろ足/
うしろあわせ /後ろ合せ/
うしろおし /後ろ押し/
うしろかげ /後ろ影/
うしろかわ /後川/
うしろがみ /後ろ髪/後髪/
うしろがわ /後側/
うしろきず /後ろ傷;不名誉/後ろ疵/
うしろざま /後ろ方/後ろ様;-に倒れる/
うしろすがた /後ろ姿/後姿/
うしろだて /後ろ盾/後ろ楯;=後ろ盾/後立/後ろだて/
うしろで /後ろ手/
うしろはんぶん /後半分/
うしろほうこう /後方向/
うしろまえ /後ろ前/
うしろまわしげり /後ろ廻し蹴り/
うしろみ /後見/後ろ身/
うしろみごろ /後ろ身頃/
うしろむき /後ろ向き/後向き/
うしろめ /後目/
うしろゆび /後ろ指/
うしわかまる /牛若丸/
うしわた /牛渡/
うしん /有心/
うしんしつ /右心室/
うしんてい /有心体/
うしんふぜん /右心不全/
うしんぼう /右心房/
うじ /氏/宇治/蛆/
うじい /雲林院/
うじいえ /氏家/
うじかばね /氏姓/
うじがみ /氏神/
うじがわ /宇治川/
うじきんとき /宇治金時/
うじこ /氏子/
うじさと /氏郷/
うじし /宇治市/
うじしゅういものがたり /宇治拾遺物語/
うじじゅうじょう /宇治十帖;『源氏物語』末尾の十帖/
うじすじょう /氏素性/氏素姓/
うじせん /宇治線/
うじだいなごんものがたり /宇治大納言物語;現存せず/
うじちゃ /宇治茶/
うじでら /氏寺/
うじな /宇品/
うじはら /氏原/
うじばし /宇治橋/
うじびと /氏人/
うじふさ /氏房/
うじむし /蛆虫/ウジ虫/
うじやま /宇治山/
うじやまだ /宇治山田/
うじょう /有情/羽状/鵜匠/雨上/
うじょうしょう /右丞相;右大臣/
うじょうふくよう /羽状複葉/
うじょうみゃく /羽状脈/
うす /臼/薄/碓;足で搗くウス/有珠;地名,北海道/舂;臼で搗くこと/
うす> /薄;薄暗がり,薄明(か)り,薄商い/
うすあお /薄青/淡青/
うすあおいろ /薄青色/
うすあかり /薄明かり/薄明り/
うすあきない /薄商い/
うすあげ /薄揚げ/
うすあじ /薄味/
うすい /雨水;([二十四節気]2.19頃)/臼井/碓氷/碓井/薄井/
うすいえき /臼井駅/
うすいこう /雨水溝/
うすいた /薄板/
うすいとうげ /碓氷峠/
うすいまち /碓井町/
うすいろ /薄色/
うすうす /薄々/薄薄/
うすかべ /薄壁/
うすかわ /薄皮/
うすがすみ /薄霞/
うすがた /薄型/
うすがたか /薄型化/
うすがみ /薄紙/
うすき /臼杵;地名/薄/
うすきいろ /薄黄色/
うすきし /臼杵市/
うすきみ /薄気味/
うすぎ /薄着/
うすぎぬ /薄衣/薄絹/
うすぎり /薄切り/薄霧/
うすくち /薄口/
うすくちしょうゆ /薄口醤油/淡口醤油/
うすくらがり /薄暗がり/
うすくれない /薄紅/
うすぐも /薄雲/
うすぐもり /薄曇/薄曇り/うす曇り/
うすげ /薄毛;-を気にする/
うすげしょう /薄化粧/
うすこうばい /薄紅梅/
うすごおり /薄氷/
うすごろも /薄衣/
うすざいしき /薄彩色/
うすざん /有珠山/
うすじ /薄地/
うすじお /薄塩/
うすずみ /薄墨/
うすずみいろ /薄墨色/
うすずみがみ /薄墨紙/
うすた /薄田/
うすだ /臼田/
うすだいこ /臼太鼓/
うすだたみ /薄畳;春夏用/
うすちゃ /薄茶/
うすちゃいろ /薄茶色/
うすっぺら /薄っぺら/
うすづき /薄月/
うすづきよ /薄月夜/
うすづくり /薄造り/薄作り/
うすで /薄手/
うすにく /薄肉/
うすにごり /薄濁り/
うすぬり /薄塗り;-のファンデーション/薄塗/
うすねず /薄鼠/
うすのろ /薄鈍/
うすはないろ /薄花色/
うすはなざくら /薄花桜/
うすはなだ /薄縹/
うすば /薄刃/薄葉/
うすばかげろう /薄羽蜉蝣/
うすび /薄日/
うすびょう /護田鳥尾/
うすべお /護田鳥尾/
うすべに /薄紅/
うすべにいろ /薄紅色/
うすべり /薄縁/
うすぼんやり /薄ぼんやり/
うすまく /薄膜/
うすみどり /薄緑/
うすみどりいろ /薄緑色/
うすむらさき /薄紫/
うすむらさきいろ /薄紫色/
うすめ /薄目/薄め/
うすめえき /薄め液/
うすもの /薄物/羅/
うすももいろ /薄桃色/
うすもよう /薄模様/
うすやき /薄焼き/薄焼;-煎餅/
うすやみ /薄闇/
うすゆき /薄雪/
うすゆきものがたり /薄雪物語/
うすよう /薄葉/薄様/
うすようし /薄葉紙/
うすら /薄ら/
うすらばか /薄ら馬鹿/
うすらひ /薄ら氷/
うすらわらい /薄ら笑い/
うすわらい /薄笑い/
うず /渦/右図/烏頭/
うずい /渦位/
うずき /疼き/宇津木/
うずくまる /踞/蹲/
うずしお /渦潮/
うずでんりゅう /渦電流/
うずど /渦度/
うずどほうていしき /渦度方程式/
うずの /鶉野/
うずば /渦場/
うずべくご /ウズベク語/
うずまき /渦巻/渦巻き/
うずまきぎんが /渦巻銀河/渦巻き銀河/
うずまきもよう /渦巻模様/
うずまさ /太秦/
うずみび /埋み火/
うずむし /渦虫/
うずむしるい /渦虫類/
うずゆそう /渦輸送/
うずら /鶉/
うずらいし /鶉石/
うずらたまご /鶉卵/うずら卵/
うずらの /鶉野/
うせい /迂生/
うせつ /右折/雨雪/
うせつさせつ /右折左折/
うせつしゃ /右折車/
うせつしゃせん /右折車線/
うせつやじるし /右折矢印/
うせつやじるししんごう /右折矢印信号/
うせもの /失せ物/
うせんけい /右線形/
うせんせい /右旋性/
うぜん /羽前/
うぜんちとせ /羽前千歳/
うそ /嘘/鷽;[鳥]bullfinch/嘯;口笛/獺;かわうそ/
うそいつわり /嘘偽り/
うそうそ /嘘々/
うそく /右側/
うそさむ /うそ寒/
うそじ /嘘字/
うそっぱち /嘘っぱち/嘘っ八;(当て字)/
うそつき /嘘吐き/嘘つき/
うそなき /嘘泣き/
うそはっけんき /嘘発見器/嘘発見機/
うそはっぴゃく /嘘八百/
うそふき /嘯/
うそぶえ /嘯笛/
うぞうむぞう /有象無象/
うた /歌/唄/詩/謌;「歌」の異体字/宇田;人名/謳/
うたあわせ /歌合/
うたい /謡/謠/
うたいかた /歌い方/
うたいがい /歌以外/
うたいぞめ /謡初/
うたいて /歌い手/
うたいぼん /謡本/
うたいめ /歌い女/
うたいもの /歌い物;⇔語り物/謡い物;⇔語り物/
うたいもんく /謳い文句/歌い文句/謡い文句/謳文句/歌文句/
うたいり /歌入り/
うたいれ /歌入れ/
うたうたい /歌唄い/歌歌い/
うたうら /歌占/
うたえもん /歌右衛門/
うたかい /歌会/
うたかいはじめ /歌会始/
うたかた /泡沫/
うたがい /疑い/
うたがいなく /疑い無く/
うたがいれい /疑い例/
うたがき /歌垣/
うたがっせん /歌合戦/
うたがわ /歌川/宇田川/
うたがわくによし /歌川国芳/
うたがわひろしげ /歌川広重/
うたぎれ /歌切/
うたぐち /歌口/
うたげ /宴/讌;=宴/
うたこ /詩子/歌子/
うたことば /歌詞/
うたごえ /歌声/
うたごえきっさ /歌声喫茶;客が合唱する/
うたごころ /歌心/
うたしない /歌志内/
うたしろ /歌代/
うたせゆ /打たせ湯/
うたた /転/
うたたね /うたた寝/転寝/転た寝/
うただ /宇多田;姓/
うたつ /歌津/宇多津/
うたつえき /宇多津駅/
うたづ /宇多津/
うたづかさ /雅楽寮;[律令制]/
うたて /転/
うたの /菟田野/歌野/宇多野/
うたのかみ /雅楽頭/
うたのつかさ /雅楽寮;[律令制]/
うたのやまい /歌の病;和歌で、避けるべき欠点/
うたばん /歌伴/
うたばんぐみ /歌番組/
うたひめ /歌姫/
うたひめでんせつ /歌姫伝説/
うたびと /歌人/
うたほん /歌本/
うたまい /歌舞/
うたまいのつかさ /楽官;[律令制]/雅楽寮/
うたまくら /歌枕/
うたまる /歌丸;芸名/
うたまろ /歌麿/
うたもの /歌物/唄物;-の演目/
うたものがたり /歌物語/
うたよ /歌代/詩代/
うたよみ /歌詠み/
うたん /右端/
うだ /宇田/宇陀/
うだい /宇大/宇内/
うだいしょう /右大将/
うだいじん /右大臣/
うだいべん /右大弁/
うだがわ /宇田川/
うだがわちょう /宇田川町/
うだち /卯建/
うだつ /卯建/
うだてんのう /宇多天皇/
うだん /ウ段/
うち /内/打ち/家/中/鬱/欝/裡/
うち> /内;内金,内風呂,内巻き/
うちあい /打ち合い/
うちあけばなし /打ち明け話/
うちあげ /打ち上げ/打上げ;launch/内揚げ;[服飾]/内揚;[服飾]/内上げ;内金/
うちあげはなび /打ち上げ花火/打上花火/打上げ花火/
うちあみ /打網/打ち網/
うちあわせ /打ち合わせ/打合せ/打ち合せ/
うちい /内井/
うちいけ /内池/
うちいで /打出/
うちいり /討ち入り/討入り/内入り/
うちいわい /内祝/内祝い/
うちうち /内々/
うちうみ /内海/
うちうら /内浦/内裏/
うちかぎ /内鍵/
うちかけ /打掛/打ち掛け/打掛け/裲襠/
うちかた /打ち方/内方/内潟/
うちかわ /内川/
うちかんだ /内神田/
うちがけ /内掛け/
うちがし /打ち菓子/打菓子/
うちがた /内型/
うちがたな /打刀/打ち刀/
うちがま /内釜/
うちがわ /内側/
うちき /内気/内木/
うちきず /打ち傷/打傷/
うちきば /内木場/
うちきり /打ち切り/打切り/打切/
うちきん /内金/
うちぎ /袿/
うちぎぬ /打衣/
うちくび /打ち首/打首/
うちぐるま /内車/
うちけし /打ち消し/打消し/
うちげいこ /内稽古;⇔出稽古/
うちげば /内ゲバ/
うちげんかん /内玄関/
うちこ /打ち粉/内子;地名/打粉/
うちこし /打越/
うちこば /内木場/
うちこみ /打ち込み/
うちこわし /打ち毀し/
うちごろ /打ち頃/
うちさいわい /内幸/
うちさいわいちょう /内幸町/
うちさぶらい /内侍/
うちざた /内沙汰/
うちじに /討死/討ち死に/討死に/
うちじゅう /家中/
うちぜい /内税/
うちそで /内袖/
うちた /打田/
うちだ /内田/
うちだゆき /内田有紀/
うちだようこう /内田洋行/
うちだんねつ /内断熱/
うちだんねつこうほう /内断熱工法;[建築]/
うちちがい /打違い/
うちっぱなし /打ちっ放し/
うちつくに /内つ国/
うちづま /内妻/
うちづら /内面/
うちて /打ち手/討手/打手/
うちで /打ち出/打出/
うちでし /内弟子/
うちでのこづち /打ち出の小槌/打出の小槌/
うちとびら /内扉/
うちど /内戸/
うちどい /内樋/
うちどころ /打ち所/
うちどめ /打ち止め/打止め/打止/
うちなかはら /内中原/
うちなだ /内灘/
うちにわ /内庭/
うちぬき /打ち抜き/打抜き/打抜/
うちねこ /内猫/
うちの /内野/
うちのうら /内之浦/
うちのみ /内海/
うちのり /内法/内のり/
うちのりなげし /内法長押;[建築]/
うちはし /内橋;姓/
うちはちもんじ /内八文字/
うちはなし /打放し/打ち放し/
うちはら /内原/
うちばば /内馬場/
うちばらい /内払い/
うちばり /内張り/梁/
うちひとり /内一人/
うちひょうじ /内表示/
うちひら /内平/
うちびらき /内開き/
うちふづめ /打歩詰め/
うちぶ /打歩;premium. 「-公債,-発行」/
うちぶくろ /内袋/
うちぶた /内蓋/
うちぶろ /内風呂/
うちべんけい /内弁慶/
うちぼう /内房/
うちぼうせん /内房線/
うちぼうせんそが /内房線蘇我/
うちぼり /内堀/内濠/内壕/
うちぽけっと /内ポケット;財布を入れます/
うちまき /内巻き;髪型/内巻/
うちまく /内幕/
うちまご /内孫/
うちまた /内股/
うちまたごうやく /内股膏薬/
うちまちがい /打ち間違い/
うちまど /内窓/
うちまわり /内回り/
うちみ /打ち身/打見/
うちみず /打ち水/
うちみや /内宮/
うちむき /内向き/
うちむそう /内無双/
うちむら /内村/
うちむらかんぞう /内村鑑三/
うちもうこ /内蒙古/
うちもと /内一/
うちもの /打ち物/打物/
うちもも /内股/内腿/
うちやま /内山/
うちやまだ /内山田/
うちゅう /宇宙/雨中/
うちゅういがく /宇宙医学;astromedicine/
うちゅういち /宇宙一/
うちゅうえいゆう /宇宙英雄/
うちゅうかいぞく /宇宙海賊/
うちゅうかいはつ /宇宙開発/
うちゅうかいはつけいかく /宇宙開発計画/
うちゅうかいはつじぎょうだん /宇宙開発事業団/
うちゅうかいぶつ /宇宙怪物/
うちゅうかがく /宇宙科学/
うちゅうかがくけんきゅうじょ /宇宙科学研究所/
うちゅうかぞく /宇宙家族/
うちゅうかん /右中間/宇宙観/
うちゅうかんきょう /宇宙環境/
うちゅうがく /宇宙学/
うちゅうきち /宇宙基地/
うちゅうきぼ /宇宙規模/
うちゅうきょく /宇宙局/
うちゅうくうかん /宇宙空間/
うちゅうくうぼ /宇宙空母/
うちゅうぐん /宇宙軍/
うちゅうけん /宇宙研/
うちゅうげんしょう /宇宙現象/
うちゅうげんり /宇宙原理/
うちゅうこう /宇宙項/
うちゅうこうがく /宇宙工学/
うちゅうこうくうけんきゅうかいはつきこう /宇宙航空研究開発機構;JAXA/
うちゅうしょく /宇宙食/
うちゅうしょくみんち /宇宙植民地/
うちゅうじっけん /宇宙実験/
うちゅうじょうほう /宇宙情報/
うちゅうじょうやく /宇宙条約;Space Treaty(1967)/
うちゅうじん /宇宙人/宇宙塵/
うちゅうすてーしょん /宇宙ステーション;space station/
うちゅうせん /宇宙船;starship/宇宙線;cosmic rays/宇宙戦;space war/
うちゅうせんかん /宇宙戦艦/
うちゅうせんかんそくじょ /宇宙線観測所/
うちゅうせんそう /宇宙戦争/
うちゅうせんとう /宇宙戦闘/
うちゅうせんとうき /宇宙戦闘機/
うちゅうせんない /宇宙船内/
うちゅうぜんたい /宇宙全体/
うちゅうそうせい /宇宙創成/
うちゅうそくど /宇宙速度/
うちゅうたんさ /宇宙探査/
うちゅうたんさき /宇宙探査機;space probe/
うちゅうつうしん /宇宙通信/
うちゅうてい /宇宙艇/
うちゅうていおう /宇宙帝王/
うちゅうていすう /宇宙定数/
うちゅうてき /宇宙的/
うちゅうとし /宇宙都市/
うちゅうねんだいき /宇宙年代記/
うちゅうはいけいほうしゃ /宇宙背景放射;cosmic background radiation/
うちゅうひこう /宇宙飛行/
うちゅうひこうし /宇宙飛行士/
うちゅうふく /宇宙服/
うちゅうぶつり /宇宙物理/
うちゅうぶつりがく /宇宙物理学;astrophysics/
うちゅうべん /右中弁/
うちゅうぼうえんきょう /宇宙望遠鏡/
うちゅうゆうえい /宇宙遊泳/
うちゅうよう /宇宙用/
うちゅうりょこう /宇宙旅行/
うちゅうれき /宇宙暦/
うちゅうろん /宇宙論/
うちゆ /内湯/
うちょうてん /有頂天/
うちょうてんがい /有頂天外/
うちょく /右直/
うちょくじこ /右直事故/
うちら /内良/
うちわ /内輪/団扇/
うちわうけ /内輪受け/内輪受/
うちわく /内枠/
うちわけ /内訳/
うちわけしょ /内訳書/
うちわたし /内渡し/
うちわだいこ /団扇太鼓;日蓮宗/
うちわばなし /内輪話/
うちわもめ /内輪揉め/
うっかい /鬱懐/
うっかりもの /うっかり者/
うっき /鬱気/
うっくつ /鬱屈/
うっけつ /鬱血/うっ血/欝血;異体字/鬱結/
うっこ /鬱乎/
うっこん /鬱金/
うっこんこう /鬱金香/
うっさん /鬱散;憂さ晴らし/
うっすら /薄ら/
うっせい /鬱生/
うっせき /鬱積/うっ積/欝積;異体字/
うっそう /鬱蒼/欝蒼;異体字/鬱葱;盛ん/
うっそく /鬱塞/
うったい /鬱滞/
うったえ /訴え/
うったえかた /訴え方/
うっちゃり /打っ棄り/
うっちょう /鬱鬯/
うって /討手/
うっとう /鬱陶/欝陶;「鬱」異体字/
うっぷん /鬱憤/欝憤;異体字/
うっぷんばらし /鬱憤晴らし/
うつ /鬱/欝;「鬱」の異体字/蔚;[植物]オトコヨモギ/
うつい /鬱伊/
うついく /鬱郁/
うつう /鬱紆/
うつうつ /鬱々/鬱鬱/
うつお /空/靫/
うつおう /鬱怏/鬱泱/鬱懊/
うつおぶね /空舟/
うつき /宇津木/宇津喜/
うつぎ /宇津木/
うつぎみ /鬱気味/
うつく /美/
うつくしがおか /美しが丘/
うつくしがはら /美ヶ原/
うつけ /空け/虚け/
うつけもの /呆気者/空け者/
うつし /写し/写/
うつしえ /写し絵/
うつしみ /現身/現し身/
うつしよ /現世/
うつじゅう /鬱情;?/
うつじょう /鬱情/
うつじょうたい /鬱状態;[精医]⇔躁状態/
うつせ /虚/
うつせがい /虚貝/
うつせみ /空蝉/現身/
うつぜん /鬱然/
うつそみ /現身/
うつつ /現/
うつて /打つ手/
うつのみや /宇都宮/
うつのみやえき /宇都宮駅/
うつのみやこうじょう /宇都宮工場/
うつのみやし /宇都宮市/
うつのみやせん /宇都宮線/
うつのみやだい /宇都宮大/
うつのみやだいがく /宇都宮大学/
うつばり /梁/
うつびょう /鬱病/うつ病/
うつぶせ /俯せ/
うつほ /空/
うつほぶね /空舟/
うつほものがたり /宇津保物語/
うつぼ /笂/靭;地名/靱;異体字/靫;矢の容器/空穂/
うつぼかずら /靫葛/
うつぼぐさ /靫草/
うつぼつ /鬱勃/
うつぼものがたり /宇津保物語/
うつみ /内海/慈/宇都美/
うつみや /宇津宮/
うつむきかげん /俯き加減/
うつも /鬱茂/
うつもん /鬱悶/
うつゆう /鬱悒/鬱邑/
うつよく /鬱抑/
うつり /写り/映り/
うつりかわり /移り変わり/移り変り/
うつりが /移り香/
うつりぎ /移り気/
うつりこみ /写り込み/映り込み/
うつりごし /移り腰/
うつりつ /鬱律/
うつりょうとう /鬱陵島;地名,Ullung-do/
うつろ /虚ろ/虚/宇津呂/空ろ/
うつろい /移ろい/
うつわ /器/噐/
うつわもの /器物/
うづ /宇津/
うづき /卯月;陰暦4月/宇津木/
うづきゅうめいがん /宇津救命丸/
うて /右手/
うてき /雨滴/
うてきかんち /雨滴感知/
うてな /台;高台/萼;花のガク/
うてん /雨天/
うてんけっこう /雨天決行/
うてんじ /雨天時/
うてんじゅんえん /雨天順延/
うてんちゅうし /雨天中止/
うで /腕/
うでおし /腕押し;暖簾に-/
うでかざり /腕飾り/
うできき /腕利き/
うでぎ /腕木/
うでくらべ /腕比べ/
うでぐみ /腕組み/
うでじまん /腕自慢/
うでずく /腕ずく/腕尽く/
うでずもう /腕相撲/
うでぞろい /腕揃い/
うでたて /腕立/
うでたてふせ /腕立て伏せ/腕立伏せ/
うでだめし /腕試し/
うでっぷし /腕っ節/
うでづく /腕尽く/
うでどけい /腕時計/
うでぶし /腕節/
うでまえ /腕前/
うでまくら /腕枕/
うでまくり /腕捲り/腕まくり/
うでわ /腕輪/
うと /宇都/宇土/
うとう /宇藤/宇籐/
うとく /有徳/宇徳/
うとくじん /有徳人/
うとろ /宇登呂/
うど /独活;独活の大木/
うどし /卯年/
うどじんぐう /鵜戸神宮/
うどねり /内舎人/
うどの /鵜殿/
うどり /羽鳥/
うどん /饂飩/
うどんげ /優曇華;(udumbara)「盲亀の浮木-の花」/
うどんこ /饂飩粉/うどん粉/
うどんや /饂飩屋/うどん屋/
うな /鰻/項/
うない /宇内/
うなかみ /海上/
うながし /令/
うなぎ /鰻/
うなぎどんぶり /鰻丼;うなどん/
うなぎのぼり /鰻登り/鰻上り/うなぎ登り/うなぎ上り/
うなぎめし /鰻飯/
うなぎや /鰻屋/
うなぎりょうり /鰻料理/
うなさか /海境/
うなじ /項/
うなじゅう /鰻重/
うなぞこ /海底/
うなづき /宇奈月/
うなでん /ウナ電;(<URgent)至急電報/
うなどん /鰻丼/うな丼/
うなばら /海原/
うなり /唸り/
うなりごえ /唸り声/
うに /雲丹/海胆/
うにょう /右繞;[仏教]/
うぬ /己/汝/
うぬぼれ /自惚れ/己惚れ/
うね /畝/畦/宇根;地名/有年;地名/疇/畆/畴/
うねおか /宇根岡/
うねおり /畝織/
うねかわ /畝川/
うねび /畝傍/
うねびやま /畝傍山/
うねま /畝間/
うねめ /采女/
うねもと /畝本/
うの /宇野/鵜野/宇能/
うのう /右脳/
うのき /鵜木/卯木/宇野木/卯野木/
うのけ /宇ノ気/
うのせん /宇野線/
うのはな /卯の花/
うのみ /鵜呑み/鵜呑/
うのめたかのめ /鵜の目鷹の目/
うは /右派/
うば /姥/乳母/
うばい /優婆夷;[仏教]/烏梅/
うばいあい /奪い合い/
うばいし /姥石/
うばがい /姥貝/
うばぐるま /乳母車/
うばざくら /姥桜/
うばすて /姥捨/姥捨て/
うばすてやま /姨捨山/
うばそく /優婆塞/
うばめがし /姥目樫/
うひょう /雨氷/
うひょうえ /右兵衛/
うひょうえのかみ /右兵衛督;[律令制]/
うひょうえのじょう /右兵衛尉;[律令制]/
うびょう /宇廟/
うふさま /右府様/
うぶ /産/初/初心/有部/生/
うぶぎ /産着/産衣/
うぶぎぬ /産衣/
うぶげ /産毛/
うぶこ /産子/
うぶご /産子/
うぶごえ /産声/
うぶごや /産小屋/
うぶすな /産土/
うぶすながみ /産土神/
うぶね /鵜舟/
うぶめ /産女/
うぶや /産屋/
うぶやま /産山/
うぶゆ /産湯/
うぷしろん /υ;upsilon/Υ;Upsilon/
うへん /右辺/羽片/
うへんち /右辺値/
うべ /宇部/宜/
うべこう /宇部興/
うべこうさん /宇部興産/
うべせん /宇部線/
うべんかん /右弁官/
うほ /禹歩/
うほう /右方/
うま /馬/午;[十二支]7/旨/
うまあぶ /馬虻/
うまいち /馬市/
うまいり /馬入/
うまうま /旨々;-と/
うまおい /馬追い/
うまかたぶし /馬方節;馬子唄/
うまき /鰻巻き/
うまくさ /秣/
うまくち /甘口/
うまこ /馬子/
うまこし /馬越/
うまご /孫/
うまごめ /馬込/
うまごや /馬小屋/
うまごやし /苜蓿/馬肥やし;[植物]alfalfa/
うまさけ /味酒;-の三諸の山/旨酒;(枕詞)-の,-を/
うまじ /馬路/
うまじしん /馬自身/
うまじたい /馬自体/
うまじるし /馬印/馬標/
うまずめ /石女/不生女/
うまずら /馬面;※仮名遣い「うまづら」/
うまたち /馬達/
うまたて /馬立/
うまたん /馬単/
うまづら /馬面/
うまづらはぎ /馬面剥;フグ目の海魚。カワハギの仲間。/
うまとび /馬跳び/馬飛び/
うまどし /午年/
うまに /甘煮/旨煮;白菜の-/馬荷/
うまぬし /馬主/
うまの /馬野/
うまのかみ /右馬頭/馬頭/
うまのすけ /右馬助/
うまのすずくさか /ウマノスズクサ科/Aristolochiaceae/
うまのすずくさもく /ウマノスズクサ目/Aristolochiales/
うまのはなむけ /餞/
うまのほね /馬の骨/
うまのり /馬乗り/
うまはし /馬橋/
うまば /馬場/
うまばえ /馬蠅/
うまばしら /馬柱;[競馬]/
うまばん /馬番/
うまふざい /馬不在/
うまぶね /馬槽/
うまへん /馬偏/
うまみ /旨味/旨み/
うまみち /馬道/
うまみちょうみりょう /旨味調味料;『味の素』の類/
うまや /厩/馬屋/廐/廏/
うまやごえ /厩肥;[農業]barnyard manure/
うまやどのおうじ /厩戸皇子;聖徳太子/
うまら /茨/
うまれ /生まれ/生れ/生/
うまれかわり /生まれ変わり;reincarnation/生れ変り/
うまれこきょう /生まれ故郷/
うまれつき /生まれつき/生まれ付き/
うまれどし /生まれ年/
うまれん /馬連/
うみ /海/膿/生/宇美/
うみいぐあな /海イグアナ/
うみいちめん /海一面/
うみうお /海魚/
うみうし /海牛/
うみうま /海馬;タツノオトシゴ/
うみかぜ /海風/
うみがみ /海神/
うみがめ /海亀/
うみがわ /海側/
うみぎり /海霧/
うみさち /海幸/
うみざかな /海魚/
うみしばうら /海芝浦/
うみせんやません /海千山千/
うみそだち /海育ち/
うみぞい /海沿い/
うみだし /海田市/
うみち /膿血/
うみつばめ /海燕/
うみづき /産み月/
うみづり /海釣り/海釣/
うみて /海手;⇔山手/
うみどり /海鳥/
うみなり /海鳴り/
うみねこ /海猫/
うみの /海野/
うみのいえ /海の家/
うみのおや /生みの親;-より育ての親/産みの親/
うみのくるしみ /産みの苦しみ/生みの苦しみ/
うみのさち /海の幸/
うみのなかみち /海の中道/
うみのひ /海の日;七月の第三月曜日/
うみはら /海腹/
うみはらかわせ /海腹川背/
うみびらき /海開き/
うみへび /海蛇/
うみへびざ /海蛇座;Hydra(Hya)/
うみべ /海辺/
うみべり /海縁/
うみほたる /海蛍/
うみぼうず /海坊主/
うみやま /海山/
うむ /有無/孳/
うむき /蛤/
うめ /梅/楳/
うめあわせ /埋め合わせ/埋め合せ/
うめがえ /梅枝/
うめがえもち /梅枝餅;太宰府名物/
うめがおか /梅が丘/
うめがき /梅垣/
うめがしま /梅ヶ島/
うめがたに /梅ヶ谷/
うめがわ /梅川/
うめき /埋木/呻き/
うめきごえ /呻き声/
うめきち /梅吉/
うめくさ /埋め草/埋草/
うめこ /梅子/
うめこうじ /梅小路/
うめこぶちゃ /梅昆布茶/
うめこみ /埋め込み/
うめさお /梅棹/
うめさわ /梅沢/
うめざき /梅崎/
うめざわ /梅沢/梅澤/
うめしゅ /梅酒/
うめず /梅酢/楳図;人名/梅津/梅図/
うめぞの /梅園/
うめぞめ /梅染/
うめた /梅田/
うめたて /埋め立て/埋立/埋立て/
うめたてち /埋立地/埋め立て地/
うめたに /梅谷/
うめだ /梅田/楳田/
うめだえき /梅田駅/
うめだかもつえき /梅田貨物駅/
うめだかもつせん /梅田貨物線/
うめだがわ /梅田川/
うめだきた /梅田北/
うめだしてん /梅田支店/
うめだはんしん /梅田阪神/
うめづ /梅津/
うめづけ /梅漬け/梅漬/
うめにしき /梅錦/
うめの /梅野/
うめはら /梅原/
うめばち /梅鉢;紋所/
うめびしお /梅醤/
うめぼし /梅干し/梅干/
うめみ /梅見/
うめみや /梅宮/
うめむら /梅村/
うめむろ /梅室/
うめもと /梅本/
うめもどき /梅擬/
うめもり /梅森/
うめやま /梅山/
うも /芋/
うもう /羽毛/
うもうだ /羽毛田/
うもうふく /羽毛服/
うもうふとん /羽毛布団/
うもうぶとん /羽毛布団/
うもん /宇門/
うや /雨夜/礼/
うやく /烏薬/
うやま /宇山/
うやむや /有耶無耶/
うゆう /烏有;-に帰す/
うよ /紆余/紆餘;「余」旧字/
うよう /右葉/
うよきょくせつ /紆余曲折/
うよく /右翼/羽翼;wing. assist./
うよくしゅ /右翼手/
うよくせき /右翼席/
うよくだんたい /右翼団体/
うよくてき /右翼的/
うら /裏/浦/占/裡/心;心恋しい,心寂しい,心無し/錙;?/
うら> /裏/
うらあみ /裏編み/
うらうえ /裏表/
うらうす /浦臼/
うらうち /裏打ち/裏打/
うらうつり /裏移り/
うらえ /浦江/
うらえり /裏襟/
うらおもて /裏表/
うらおもてがみ /裏表紙/
うらかいどう /裏街道/
うらかすみ /浦霞/
うらかぜ /浦風/裏風/
うらかた /裏方/
うらかみ /浦上/
うらかわ /浦河/浦川/
うらが /浦賀/
うらがえし /裏返し/
うらがお /裏顔/
うらがき /裏書/裏書き/
うらがききんし /裏書禁止/
うらがききんしうらがき /裏書禁止裏書/
うらがきじょうと /裏書譲渡/
うらがきてがた /裏書手形/
うらがきにん /裏書人/
うらがすいどう /浦賀水道/
うらがすみ /浦霞/
うらがすみぜん /浦霞禅/
うらがすみだいぎんじょう /浦霞大吟醸/
うらがせん /浦賀線/
うらがね /裏金/
うらがみ /浦上/裏紙/
うらがみえきまえ /浦上駅前/
うらがみしゃこ /浦上車庫/
うらがめん /裏画面/
うらがわ /裏側/浦川/裏革/裏皮/
うらきど /裏木戸/
うらきばん /裏基盤/
うらきもん /裏鬼門/
うらぎり /裏切り/裏切/
うらぎりもの /裏切り者/裏切者/
うらぐち /裏口/
うらぐちにゅうがく /裏口入学/
うらけい /裏罫/
うらけん /裏拳/
うらげい /裏芸/
うらこう /浦港/
うらこうさく /裏工作/
うらごえ /裏声/
うらごし /裏漉し/
うらさ /浦佐/
うらさく /裏作/
うらさわ /浦沢/
うらさんしょう /裏参照/
うらしの /嬉野/
うらしま /浦島/
うらしまそう /浦島草/
うらしまたろう /浦島太郎/
うらしゃかい /裏社会/
うらじ /裏地/
うらじおすとっく /浦鹽斯徳/
うらじじょう /裏事情/
うらじゃけ /裏ジャケ/
うらじょうほう /裏情報/
うらじろ /裏白/
うらじろがし /裏白樫/
うらじろど /裏白戸/
うらじろれんが /裏白連歌/
うらすじ /裏筋/
うらずみ /裏住み/
うらせ /浦瀬/
うらせってい /裏設定/
うらせんけ /裏千家/
うらぜん /浦禅/
うらそえ /浦添/
うらぞこ /浦底/
うらた /浦田/
うらだな /裏店/
うらち /浦地/
うらづけ /裏付け/裏付/
うらて /裏手/
うらとりひき /裏取引/
うらどおり /裏通り/
うらどら /裏ドラ/
うらない /占い/卜い/卦;?/
うらないし /占い師/
うらなげ /裏投げ/
うらなみ /浦波/
うらなり /末成り/末生り/
うらにし /浦西/
うらにほん /裏日本/
うらにわ /裏庭/
うらの /浦野/
うらはいけい /裏背景/
うらはく /裏拍/
うらはず /末弭/末筈/
うらはま /浦浜/
うらはら /裏腹/裏原;[略語]裏原宿(原宿の裏通り)/
うらはらじゅく /裏原宿/
うらば /裏葉/
うらばなし /裏話/
うらばなしてき /裏話的/
うらばん /裏番/
うらばんぐみ /裏番組/
うらばんだい /裏磐梯/
うらばんだいねこま /裏磐梯猫魔/
うらびでお /裏ビデオ/
うらびょうし /裏表紙/
うらぶた /裏蓋/
うらぶたい /裏舞台/
うらべ /卜部/占部/浦部/浦辺/裏部/
うらべかねよし /卜部兼好/
うらべや /裏部屋/
うらほ /裏帆/
うらほろ /浦幌/
うらぼん /盂蘭盆/裏盆/
うらまち /裏町/
うらまど /裏窓/
うらみ /恨み/怨み/憾み;残念なこと。欠点。/浦見/
うらみごと /恨み言/怨み言/
うらみごろ /裏身頃/
うらみち /裏道/
うらみっこ /恨みっこ;-なし/
うらみつらみ /恨みつらみ;-をぶちまける/
うらみぶし /恨み節/怨み節/
うらむ /怏/
うらめ /裏目/
うらめい /裏銘/
うらめし /浦飯/
うらめん /裏面/
うらもと /浦本/
うらもの /裏物/
うらもん /裏門/裏紋/
うらもんじょ /裏文書/
うらやき /裏焼き;すまりなに逆右左/
うらやす /浦安/
うらやすかん /浦安間/
うらやすし /浦安市/
うらやま /浦山/裏山/
うらよみ /裏読み/
うらら /麗ら/麗/
うららか /麗らか/
うらる /烏拉/
うらるあるたいごぞく /ウラルアルタイ語族;[言語]Ural-Altaic/
うらるごぞく /ウラル語族;[言語]/
うらわ /浦和/
うらわえき /浦和駅/
うらわざ /裏技/
うらわざてき /裏技的/
うらわし /浦和市/
うらわせん /浦和戦/
うらわだいもん /浦和大門/
うらわでんしゃく /浦和電車区/
うらわにしぐち /浦和西口/
うらわみなみ /浦和南/
うらん /U/Uranium/
うらんけいれつ /ウラン系列;4n+2系列/
うらんのうしゅく /ウラン濃縮;[科技]uranium enrichment/
うり /瓜/売り/
うりあげ /売上/売り上げ/売上げ/
うりあげかかく /売上価格/
うりあげかくほ /売上確保/
うりあげがく /売上額/
うりあげきん /売上金/
うりあげきんがく /売上金額/
うりあげけいさんしょ /売上計算書/
うりあげげんか /売上原価/
うりあげこうせいひ /売上構成比/
うりあげさいけん /売上債権/
うりあげさいけんかいてんりつ /売上債権回転率/
うりあげぜい /売上税/
うりあげそうりえきりつ /売上総利益率/
うりあげぞう /売上増/
うりあげぞうだい /売上増大/
うりあげだいすう /売上台数/
うりあげだか /売上高/
うりあげふしん /売上不振/
うりいえ /売り家/
うりう /瓜生/
うりおしみ /売り惜しみ/
うりか /ウリ科/
うりかい /売り買い/
うりかけ /売掛/売り掛け/
うりかけきん /売掛金/
うりかけちょう /売掛帳/
うりかた /売り方/売方/
うりきれ /売り切れ/売切れ/売切/
うりきれごめん /売り切れ御免/
うりぎょく /売玉;[相場]/売り玉;[相場]selling account/
うりくち /売り口/
うりぐい /売り食い/
うりぐすり /売薬/売り薬/
うりけはい /売気配/売り気配/
うりこ /売り子/売子/
うりことば /売り言葉/売言葉/
うりこひめ /瓜子姫;説話/
うりこみ /売り込み/
うりごえ /売り声/売声/
うりざいりょう /売り材料/
うりざね /瓜実/瓜核/
うりざねがお /瓜実顔/
うりざん /売り残/
うりそうば /売相場/
うりだし /売り出し/売出し/売出/
うりだしきかん /売出期間/
うりだしちゅう /売り出し中/売出中/
うりだて /売建/売り建て;[相場]/売建て;[相場]/
うりだてぎょく /売建玉/
うりち /売地/
うりちゅうもん /売り注文/
うりづら /瓜連/
うりて /売り手/売手/
うりてしじょう /売り手市場/売手市場/
うりどき /売り時/
うりぬけ /売り抜け/
うりぬし /売主/売り主/
うりね /売値/売り値/
うりの /売野/
うりば /売り場/売場/
うりばめんせき /売場面積/
うりふたつ /瓜二つ/
うりぼう /瓜坊/
うりみばえ /瓜実蠅/
うりもく /ウリ目/Cucurbitales/
うりもの /売り物/売物/
うりもんく /売り文句/
うりや /売り家/
うりゅ /雨龍/
うりゅう /雨竜/瓜生/雨龍/
うりゅうの /瓜生野/
うりょう /雨量/
うりょうけい /雨量計/
うりよね /糶/売り米/
うりわたし /売渡/売り渡し/売渡し/
うりん /雨林/
うりんけ /羽林家/
うる /宇留/
うるい /潤/
うるう /閏/
うるうづき /閏月/
うるうどし /閏年/
うるうび /閏日;2.29/
うるうびょう /閏秒/
うるおい /潤い/
うるか /潤香;鮎の内臓の塩漬/
うるき /売木/夏枯草/
うるごめ /粳米/
うるさ /煩/
うるさがた /うるさ型/
うるし /漆/
うるしえ /漆絵/
うるしじ /漆地/
うるしぬり /漆塗り/漆塗/
うるしね /粳/粳稲/
うるしねんぐ /漆年貢/
うるしはら /漆原/
うるしばた /漆畑/
うるしま /漆島/
うるしまけ /漆負け/
うるしやま /漆山/
うるた /粳田/
うるち /粳/
うるちまい /粳米/うるち米/
うるとらしー /ウルトラＣ/
うるむち /烏魯木斉/
うるめ /潤目/
うるめいわし /潤目鰯/
うれ /末/売れ/
うれあし /売れ足/
うれい /憂い/愁い/恙/騷;「騒」の旧字(人名用漢字)/
うれいがお /憂い顔/愁い顔/
うれう /悄/
うれえ /憂え/愁え/
うれくち /売れ口/
うれし /嬉し/
うれしがらせ /嬉しがらせ/
うれしなき /嬉し泣き/
うれしなみだ /嬉し涙/
うれしの /嬉野/
うれすじ /売れ筋/
うれせん /売れ線/
うれたんじゅし /ウレタン樹脂/
うれだか /売れ高/
うれっこ /売れっ子/
うれつ /ウ列/う列/
うれのこり /売れ残り/
うれゆき /売れ行き/売行き/売行/
うろ /雨露/烏鷺/迂路/有漏/空/洞/空洞/虚/
うろう /傴僂/
うろおぼえ /うろ覚え/疎覚え/
うろくず /鱗/
うろこ /鱗/
うろこがた /鱗形/
うろこぐも /鱗雲/
うろこじょう /鱗状/
うろん /胡乱/
うわ /上/宇和/
うわ> /上;上枠,上滑り/
うわあご /上顎/
うわえ /上絵/
うわえだ /上枝/
うわえつけ /上絵付け/
うわえのぐ /上絵の具/
うわがき /上書き/上書/
うわがきほぞん /上書き保存/
うわがけ /上掛け/
うわがまち /上框;[建築]/
うわがみ /上紙/
うわがわ /上側/
うわき /浮気/
うわきがんぼう /浮気願望/
うわきごころ /浮気心/
うわきしょう /浮気性/
うわきちゅう /浮気中/
うわきちょうさ /浮気調査/
うわきもの /浮気者/
うわぎ /上着/上衣/
うわくちびる /上唇/
うわぐすり /釉/釉薬/上薬;釉薬/
うわぐつ /上靴/
うわごえ /上声/
うわごと /譫言/
うわさ /噂/
うわさのたね /噂の種/
うわさばなし /噂話/
うわざら /上皿/
うわざらてんびん /上皿天秤/
うわじま /宇和島/
うわじまじどうしゃ /宇和島自動車;[企業名]/
うわじまひがし /宇和島東/
うわすべり /上滑り/
うわずみ /上澄み/上住/
うわぜい /上背/
うわぞこ /上底/
うわだな /上棚/
うわちょうし /上調子/
うわぢょうし /上調子;[音楽] 1octave上/
うわっちょうし /上っ調子/
うわっつら /上っ面/
うわっぱり /上っ張り/
うわつき /上付き/
うわつら /上面/
うわづつみ /上包み/
うわづみ /上積み/
うわて /上手/
うわてだしなげ /上手出し投げ/
うわてなげ /上手投げ/
うわてひねり /上手捻り/
うわなり /嫐/
うわに /上荷/
うわにぶね /上荷船/
うわぬり /上塗り/
うわね /上値/
うわの /宇和野/
うわのせ /上乗せ/
うわのそら /上の空/
うわのだい /上の台/
うわのり /上乗り/
うわばき /上履き/
うわばみ /蟒蛇/蠎蛇;「蟒」異体字/
うわばり /上張り/
うわひ /上翳/
うわぶたしき /上蓋式/
うわべ /上辺/
うわまい /上米;年貢米に掛ける通行税(「上前」の語源)/
うわまえ /上前/
うわみ /上身/宇和海/
うわみぞ /上溝/
うわみの /上蓑/
うわむき /上向き/
うわめ /上目/
うわめづかい /上目使い/上目遣い/
うわもの /上物/
うわや /上屋/
うわやく /上役/
うわん /右腕/
うん /運/雲/暈;(かさ)眩暈/云;云々/紜;紛紜/耘;耕耘機/吽;阿吽/繧;繧繝/慍;(いか・る)慍色/薀;薀蓄(=蘊蓄)/蘊;蘊蓄/褞;褞袍/黄;?/曇;?/
うんう /雲雨/
うんうんうにうむ /Uuu/Unununium/
うんうんおくちうむ /Uuo/Ununoctium/
うんうんくあじうむ /Uuq/Ununquadium/
うんうんにりうむ /Uun/Ununnilium/
うんうんびうむ /Uub/Ununbium/
うんうんへきしうむ /Uuh/Ununhexium/
うんえい /運営/
うんえいいいん /運営委員/
うんえいいいんかい /運営委員会/
うんえいかつどう /運営活動/
うんえいがいしゃ /運営会社/
うんえいがわ /運営側/
うんえいしきん /運営資金/
うんえいしつ /運営室/
うんえいしゃ /運営者/
うんえいしゃがわ /運営者側/
うんえいじょう /運営上/
うんえいちゅう /運営中/
うんえいどりょく /運営努力/
うんえいのうりょく /運営能力/
うんえいひ /運営費/
うんえいひよう /運営費用/
うんえいぶ /運営部/
うんえいほうしん /運営方針/
うんえいほうほう /運営方法/
うんえいぼたい /運営母体/
うんえいもと /運営元/
うんえいよう /運営用/
うんえいりねん /運営理念/
うんえん /雲煙/
うんえんかがん /雲煙過眼/
うんえんひょうびょう /雲煙縹渺/
うんか /雲霞/浮塵子/
うんかい /雲海/
うんかく /雲鶴/雲客;殿上人/
うんかん /雲漢;天の川/
うんが /運河/
うんがかん /運河間/
うんき /運気/温気/
うんきゅう /運休/運弓;[音楽]bowing.「バイオリンの-」/
うんきゅうほう /運弓法/
うんけい /運慶/雲形/
うんけいじょうぎ /雲型定規/
うんげいせん /雲芸線/
うんげん /繧繝/
うんこう /運行;†(バス|天体)の-/運航;†(船|飛行機)の-/暈光/
うんこうがいしゃ /運行会社/
うんこうけいたい /運行形態/
うんこうじかん /運行時間/
うんこうじかんたい /運行時間帯/
うんこうじょうきょう /運行状況/
うんこうじょうけん /運行条件/
うんこうじょうむいん /運航乗務員/
うんこうちゅう /運行中;†「-の電車」/運航中;†「-の船舶」/
うんこうちゅうし /運航中止/
うんこうていし /運航停止/
うんこうにってい /運航日程/
うんこうまえてんけん /運行前点検/
うんこうよう /運行用/
うんこく /雲谷/
うんごうむしゅう /雲合霧集/
うんさん /雲散/
うんさんむしょう /雲散霧消;跡形もなく消える/
うんざん /運算/
うんし /運指/
うんしだい /運次第/
うんしゅう /温州;(Wenzhou) 中国・浙江省の都市/雲州;出雲/雲集;-霧散/
うんしゅうみかん /温州蜜柑/
うんしゅうむさん /雲集霧散;集まったり散ったりする/
うんしょうむさん /雲消霧散;=雲散霧消/
うんしょく /慍色;むっとした顔色/暈色;鉱物の虹色/
うんしん /運針/雲身/
うんしんげっせい /雲心月性/
うんじゃく /雲雀/
うんじゅ /琅珠/
うんじょう /雲上/運上/
うんじょうびと /雲上人/
うんすい /雲水/
うんせい /運勢/運星;†星の巡り合わせ/
うんぜん /雲仙/
うんぜんこうえん /雲仙公園/
うんぜんだけ /雲仙岳/
うんぜんふげんだけ /雲仙普賢岳/
うんそう /運送/
うんそうがいしゃ /運送会社/
うんそうぎょう /運送業/
うんそうぎょうかい /運送業界/
うんそうぎょうしゃ /運送業者/
うんそうけいやく /運送契約/
うんそうじょう /運送状/
うんそうちゅう /運送中/
うんそうてん /運送店/
うんそうにん /運送人/
うんそうひ /運送費/
うんそうひよう /運送費用/
うんそうほけん /運送保険/
うんそうや /運送屋/
うんそうやっかん /運送約款/
うんそうりょう /運送料/
うんそく /運足/
うんだい /雲台/
うんだめし /運試し/
うんちく /蘊蓄/薀蓄;=蘊蓄/
うんちゃん /運ちゃん/
うんちゅうはっかく /雲中白鶴/
うんちょう /雲頂/
うんちん /運賃/
うんちんかいせい /運賃改正/
うんちんかいてい /運賃改定/
うんちんかくさ /運賃格差/
うんちんきそく /運賃規則/
うんちんけいさん /運賃計算/
うんちんしゅうにゅう /運賃収入/
うんちんせい /運賃制/
うんちんたいけい /運賃体系/
うんちんばこ /運賃箱/
うんちんひょう /運賃表/
うんちんひょうじ /運賃表示/
うんちんひょうじき /運賃表示器/運賃表示機/
うんちんふたん /運賃負担/
うんちんぶん /運賃分/
うんちんめん /運賃面/
うんちんりょうきん /運賃料金/
うんてい /雲梯;遊具/
うんてん /運転/
うんてんいがい /運転以外/
うんてんかい /運転会/
うんてんかんかく /運転間隔/運転感覚/
うんてんぎじゅつ /運転技術/
うんてんぎりょう /運転技量/
うんてんくかん /運転区間/
うんてんけいたい /運転形態/
うんてんけいとう /運転系統/
うんてんさいかい /運転再開/
うんてんし /運転士/
うんてんしきん /運転資金/
うんてんしつ /運転室/
うんてんしどう /運転指導/
うんてんしほん /運転資本/
うんてんしゃ /運転者/
うんてんしゃいがい /運転者以外/
うんてんしゃせき /運転者席/
うんてんしゅ /運転手/
うんてんしゅうりょうご /運転終了後/
うんてんしゅし /運転手氏/
うんてんしよう /運転士用/
うんてんしれい /運転指令/
うんてんじ /運転時/
うんてんじかん /運転時間/
うんてんじき /運転時期/
うんてんじゅつ /運転術/
うんてんじょう /運転上/
うんてんせき /運転席/
うんてんせきがわ /運転席側/
うんてんせきこうほう /運転席後方/
うんてんせきじょう /運転席上/
うんてんせきひだりがわ /運転席左側/
うんてんせきよこ /運転席横/
うんてんそうさ /運転操作/
うんてんたいど /運転態度/
うんてんだい /運転台/
うんてんちゅう /運転中/
うんてんていしゃ /運転停車/
うんてんのうりょく /運転能力/
うんてんひんど /運転頻度/
うんてんび /運転日/
うんてんびちゅうい /運転日注意/
うんてんほう /運転法/
うんてんほうほう /運転方法/
うんてんほんすう /運転本数/
うんてんめんきょ /運転免許/
うんてんめんきょしけん /運転免許試験/
うんてんめんきょしょう /運転免許証/
うんてんよう /運転用/
うんてんれき /運転歴/
うんでい /雲泥/
うんでいのさ /雲泥の差/
うんどう /運動/
うんどういん /運動員/
うんどうえねるぎー /運動エネルギー;[物理]kinetic energy. mv^2／2/
うんどうか /運動家/
うんどうかい /運動会/
うんどうかく /運動覚/
うんどうかんかく /運動感覚;kinesthesia/
うんどうがく /運動学/
うんどうがくてき /運動学的/
うんどうがわ /運動側/
うんどうき /運動器/
うんどうきのう /運動機能/
うんどうきょうぎ /運動競技;athletics/
うんどうぐ /運動具;飛び箱やボールなど/
うんどうぐつ /運動靴/
うんどうこう /運動項/
うんどうこうえん /運動公園/
うんどうこうえんない /運動公園内/
うんどうこうぞう /運動構造/
うんどうし /運動史/
うんどうしっちょう /運動失調;[医]ataxia/
うんどうしょうがい /運動障害/
うんどうしんけい /運動神経/
うんどうじ /運動時/
うんどうじょう /運動場/
うんどうじょうたい /運動状態/
うんどうせい /運動性/
うんどうせいぎょ /運動制御/
うんどうせいのう /運動性能/
うんどうせいぶん /運動成分/
うんどうそしき /運動組織/
うんどうたい /運動体/
うんどうちゅう /運動中/
うんどうちゅうすう /運動中枢/
うんどうのう /運動能/
うんどうのうりょく /運動能力/
うんどうひ /運動費/
うんどうぶ /運動部/
うんどうぶそく /運動不足/
うんどうぶそくぎみ /運動不足気味/
うんどうぶったい /運動物体/
うんどうほうこう /運動方向/
うんどうほうそく /運動法則/
うんどうほうていしき /運動方程式/
うんどうまひ /運動麻痺;[医]akinesia/
うんどうや /運動野;[解剖]motor area/
うんどうようそ /運動要素/
うんどうりょう /運動量/
うんどうりょうほう /運動療法;kinesiology/
うんどうりょうほぞんそく /運動量保存則/
うんどうりょうゆそう /運動量輸送/
うんどうりょく /運動力/
うんどんこん /運鈍根/
うんなん /雲南/
うんなんしょう /雲南省/
うんぬん /云々/云云/
うんの /海野/
うんのう /蘊奥/雲衲/暈ノウ;(サンズイに「翁」)/
うんのじゅうざ /海野十三/
うんぱん /運搬/雲版/
うんぱんかのう /運搬可能/
うんぱんき /運搬機/
うんぱんぐ /運搬具/
うんぱんしゅだん /運搬手段/
うんぱんちゅう /運搬中/
うんぱんよう /運搬用/
うんぱんりょく /運搬力/
うんぴつ /運筆/
うんぴょう /雲表/
うんぷう /雲風/
うんぷてんぷ /運否天賦/
うんぼ /雲母/
うんまかせ /運任せ/
うんむ /雲霧/
うんめい /運命/
うんめいあい /運命愛/
うんめいきょうどうたい /運命共同体;一蓮托生/
うんめいてき /運命的/
うんめいとうげ /運命峠/
うんめいろん /運命論/
うんめん /温麺/
うんも /雲母/
うんもじょう /雲母状/
うんゆ /運輸/
うんゆぎょうせい /運輸行政/
うんゆしょう /運輸省;NB:2001年1月の中央省庁再編で国土交通省に再編された/
うんゆせいさく /運輸政策/
うんゆだいじん /運輸大臣/
うんゆとうけい /運輸統計/
うんよう /運用/
うんようえき /運用益/
うんようかいし /運用開始/
うんようかのう /運用可能/
うんようかんきょう /運用環境/
うんようかんり /運用管理/
うんようかんりしゃ /運用管理者/
うんようがかり /運用掛/
うんようきゅうし /運用休止/
うんようけいけん /運用経験/
うんようけいたい /運用形態/
うんようしゃ /運用者/
うんようしゅうりょう /運用終了/
うんようじ /運用時/
うんようじかん /運用時間/
うんようじっけん /運用実験/
うんようじっせき /運用実績/
うんようじゅつ /運用術/
うんようじょう /運用上/
うんようじょうたい /運用状態/
うんようすう /運用数/
うんようせい /運用性/
うんようぞん /運用損/
うんようたいせい /運用体制/
うんようちゅう /運用中/
うんようていし /運用停止/
うんようてき /運用的/
うんようばしょ /運用場所/
うんようばんごう /運用番号/
うんようひ /運用費/
うんようひょう /運用表/
うんようほう /運用法/
うんようほうこくしょ /運用報告書/
うんようほうしん /運用方針/
うんようほうほう /運用方法/
うんようほんぶ /運用本部/
うんようめん /運用面/
うんようよう /運用用/
うんようりょく /運用力/
うんりゅう /雲竜/
うんりゅうがた /雲龍型/
うんりょう /雲量/
え /絵/画/江/餌/重/柄;handle/会/得;取り柄/荏;荏胡麻/枝/恵;知恵/慧;智慧(=知恵)/衣/依;帰依/榎/笑;笑顔/衛/回/囘;「回」の旧字/會;「会」の旧字/惠;「恵」の旧字(人名用漢字)/畫;「画」の旧字/繪;「絵」の旧字/衞;「衛」の旧字(人名用漢字)/懷;「懐」の旧字(人名用漢字)/猥;(ワイ) 呉音/杖;?/
え> /得;(ア行下一・下二 未然・連用形)得手,得難い,得具足/
えーがた /Ａ型/A型/
えーがたかんえん /Ａ型肝炎;[医]/A型肝炎;[医]hepatitis A/
えーきゅう /Ａ級/A級/
えーきゅうせんぱん /Ａ級戦犯/
えーげかい /エーゲ海/
えーげぶんめい /エーゲ文明/
えーた /η;eta/Η;Eta/
えーばん /Ａ判/A判/
えーびーがた /ＡＢ型/AB型/
えーびーしーじゅん /ABC順/
えーぶいきき /ＡＶ機器/AV機器/
えーぶいじょゆう /ＡＶ女優/AV女優/
えーめん /Ａ面/A面/
えあわせ /絵合わせ/絵合/
えい /英/映/影/鋭/永/泳/詠/衛/営/栄/郢;楚の都/嬰;(音楽の)sharp/纓;冠の紐/瓔;首飾り/珱;「瓔」の異体字/穎;ほさき/頴;「穎」の異体字/潁;潁川(中国の河川名)/洩;漏洩/曳;曳航/曵;「曳」の異体字/睿;≒叡/叡;叡智/瑛;美瑛町/暎;「映」の異体字/盈;み・ちる/楹;(はしら)/贏/瀛/瑩;(みがき)/塋;(はか)/蠑;蠑螺/榮;「栄」の旧字(人名用漢字)/營;「営」の旧字/裔;末裔/翳;陰翳/咏;≒詠/殪;たお・す/縊/衞;「衛」の旧字(人名用漢字)/娃;?/衡;?/頴娃/海鷂魚/
えい> /英;[略語]イギリス.-軍,-詩/嬰;嬰ロ短調/
えいい /鋭意/営為/衛尉/嬰イ/栄位/
えいいしっぴつちゅう /鋭意執筆中/
えいいたんちょう /嬰イ短調/
えいいち /栄一/英一/榮一/詠一/
えいいちょうちょう /嬰イ長調/
えいいちろう /英一郎/栄一郎/
えいいどりょく /鋭意努力/
えいいん /影印/
えいえい /営々/営営/英英/永々/
えいえいじしょ /英英辞書/
えいえいじてん /英英辞典/
えいえん /永遠/永延;年号(987-989)/
えいえんせい /永遠性/
えいえんふめつ /永遠不滅/
えいおうしつ /英王室/
えいおおもじ /英大文字/
えいおん /嬰音/
えいか /詠歌/穎果/
えいかいわ /英会話/
えいかいわかんけい /英会話関係/
えいかいわがっこう /英会話学校/
えいかいわきょうざい /英会話教材/
えいかいわきょうしつ /英会話教室/
えいかく /鋭角/
えいかくさんかくけい /鋭角三角形/
えいかくさんかっけい /鋭角三角形/
えいかくてき /鋭角的/
えいかん /栄冠/永観;年号(983-985)/
えいかんたい /英艦隊/
えいが /映画/栄華/栄画/
えいがおんがく /映画音楽/
えいがおんがくとくしゅう /映画音楽特集/
えいがか /映画化/
えいがかい /映画界/
えいがかけん /映画化権/
えいがかん /映画館/
えいがかんけい /映画関係/
えいがかんしょう /映画鑑賞/映画観賞/
えいがかんとく /映画監督/
えいがかんめい /映画館名/
えいががいしゃ /映画会社/
えいががっこう /映画学校/
えいがく /英学/栄学/
えいがげいじゅつ /映画芸術/
えいがげきじょう /映画劇場/
えいがさい /映画祭/
えいがさくひん /映画作品/
えいがさっか /映画作家/
えいがざっし /映画雑誌/
えいがし /映画史/映画誌/
えいがしじょう /映画史上/
えいがしゅだいきょく /映画主題曲/
えいがしょう /映画賞/
えいがじたい /映画自体/
えいがじょうえいかい /映画上映会/
えいがじょゆう /映画女優/
えいがじん /映画人/
えいがじんこう /映画人口/
えいがせいさく /映画制作/
えいがせいさくしゃ /映画製作者/
えいがぜんたい /映画全体/
えいがだいぜんしゅう /映画大全集/
えいがてき /映画的/
えいがないえいが /映画内映画/
えいがはいゆう /映画俳優/
えいがばん /映画版/
えいがひょう /映画評/
えいがひょうろん /映画評論/
えいがひょうろんか /映画評論家/
えいがびじゅつ /映画美術/
えいがぶもん /映画部門/
えいがむら /映画村/
えいがめい /映画名/
えいがものがたり /栄花物語/栄華物語/
えいがや /映画屋/
えいがよう /映画用/
えいがらん /映画欄/
えいき /鋭気;†鋭い気勢。「-を挫く」/英気;†立ち働く気力。「-を養う」/永記/盈虧/
えいきごう /嬰記号;♯/
えいきち /栄吉/永吉/
えいきゅう /永久;年号(1113-1118)/
えいきゅうかいいん /永久会員/
えいきゅうきかん /永久機関/
えいきゅうけつばん /永久欠番/
えいきゅうし /永久歯/
えいきゅうしゅうしょく /永久就職/
えいきゅうじしゃく /永久磁石/
えいきゅうだつもう /永久脱毛/
えいきゅうついほう /永久追放/
えいきゅうていし /永久停止/
えいきゅうてき /永久的/
えいきゅうとうど /永久凍土/
えいきゅうほうき /永久放棄/
えいきゅうほしょう /永久保証/
えいきゅうほぞん /永久保存/
えいきゅうほぞんばん /永久保存版/
えいきょ /盈虚/
えいきょう /影響/永享;年号(1429-1441)/
えいきょうか /影響下/
えいきょうだい /影響大/
えいきょうちょうさ /影響調査/
えいきょうど /影響度/
えいきょうりょく /影響力/
えいきょく /郢曲/
えいぎょう /営業/
えいぎょうあんない /営業案内/
えいぎょういん /営業員/
えいぎょううんてん /営業運転/
えいぎょうか /営業課/
えいぎょうかいし /営業開始/
えいぎょうかちょう /営業課長/
えいぎょうかつどう /営業活動/
えいぎょうかんりか /営業管理課/
えいぎょうがい /営業外/
えいぎょうがいしゅうえき /営業外収益/
えいぎょうがいひよう /営業外費用/
えいぎょうがわ /営業側/
えいぎょうきそく /営業規則/
えいぎょうきゅうし /営業休止/
えいぎょうきょか /営業許可/
えいぎょうきょてん /営業拠点/
えいぎょうきろ /営業キロ;business kilometre/
えいぎょうけい /営業系/
えいぎょうけいすう /営業係数/営業系数/
えいぎょうけいたい /営業形態/
えいぎょうけん /営業権/
えいぎょうこうい /営業行為/
えいぎょうさき /営業先/
えいぎょうざいさん /営業財産/
えいぎょうしゃ /営業車/営業者/
えいぎょうしゅ /営業主/
えいぎょうしゅうにゅう /営業収入/
えいぎょうしゅうりょう /営業終了/
えいぎょうしゅうりょうご /営業終了後/
えいぎょうしょ /営業所/
えいぎょうしょく /営業職/
えいぎょうしょすう /営業所数/
えいぎょうしょとく /営業所得/
えいぎょうしょめい /営業所名/
えいぎょうじ /営業時/
えいぎょうじかん /営業時間/
えいぎょうじかんがい /営業時間外/
えいぎょうじかんない /営業時間内/
えいぎょうじょう /営業上/
えいぎょうじょうと /営業譲渡/
えいぎょうせいさく /営業政策/
えいぎょうせん /営業線/
えいぎょうそんしつ /営業損失/
えいぎょうたんとう /営業担当/
えいぎょうたんとうしゃ /営業担当者/
えいぎょうちゅう /営業中/
えいぎょうていし /営業停止/
えいぎょうていししょぶん /営業停止処分/
えいぎょうてき /営業的/
えいぎょうてん /営業店/
えいぎょうにっすう /営業日数/
えいぎょうねんど /営業年度/
えいぎょうばたけ /営業畑/
えいぎょうひ /営業費/
えいぎょうひみつ /営業秘密/
えいぎょうび /営業日/
えいぎょうぶ /営業部/
えいぎょうぶちょう /営業部長/
えいぎょうぶもん /営業部門/
えいぎょうほうこくしょ /営業報告書/
えいぎょうほんぶ /営業本部/
えいぎょうぼうがい /営業妨害/
えいぎょうまん /営業マン/
えいぎょうめん /営業面/
えいぎょうめんきょ /営業免許/
えいぎょうよう /営業用/
えいぎょうりえき /営業利益/
えいぎょうりょく /営業力/
えいぎょうれっしゃ /営業列車/
えいぎん /詠吟/
えいぐん /英軍/
えいけい /英系/鋭形/
えいけつ /英傑/永訣/
えいけん /英検/
えいげつ /盈月;満ちゆく月。⇔虧月/
えいげん /永源/
えいげんじ /永源寺/
えいこ /栄枯/栄子/英子/映子/瑛子/永子/暎子/江威子/
えいこう /栄光/曳航/曳行/栄孝/栄幸/営口/曳光/
えいこうき /曳航機/
えいこうだん /曳光弾/
えいこく /英国/
えいこくかいぐん /英国海軍/
えいこくがた /英国型/
えいこくがわ /英国側/
えいこくき /英国旗/
えいこくきかく /英国規格/
えいこくこうくう /英国航空/
えいこくこうし /英国公使/
えいこくこっきょうかい /英国国教会/
えいこくご /英国語/
えいこくしき /英国式/
えいこくしゃ /英国車/
えいこくじん /英国人/
えいこくせい /英国製/
えいこくない /英国内/
えいこくばん /英国版/英国盤/
えいこくぶつりがっかい /英国物理学会/
えいこくみん /英国民/
えいこくりゅう /英国流/
えいこくりょう /英国領/
えいこさくけん /永小作権/
えいこせいすい /栄枯盛衰/
えいこもじ /英小文字/
えいこん /英魂/
えいご /英語/英五;人名/
えいごあんない /英語案内/
えいごいがい /英語以外/
えいごう /永劫/
えいごうかいき /永劫回帰/
えいごか /英語科/英語化/
えいごかいわ /英語会話/
えいごがく /英語学/
えいごがくしゅう /英語学習/
えいごがっこう /英語学校/
えいごきじ /英語記事/
えいごきょういく /英語教育/
えいごきょういくばんぐみ /英語教育番組/
えいごきょうし /英語教師/
えいごきょく /英語局/
えいごけん /英語圏/
えいごけんてい /英語検定/
えいごげき /英語劇/
えいごじしょ /英語辞書/
えいごじてん /英語辞典/
えいごじん /英語人/
えいごだい /英語題/
えいごてき /英語的/
えいごとうろん /英語討論/
えいごにゅうりょく /英語入力/
えいごのうりょく /英語能力/
えいごはつおん /英語発音/
えいごばん /英語版/
えいごひょうき /英語表記/
えいごひょうげん /英語表現/
えいごひょうじ /英語表示/
えいごふう /英語風/
えいごぶん /英語文/
えいごぶんか /英語文化/
えいごほうそう /英語放送/
えいごめい /英語名/
えいごめいしょう /英語名称/
えいごめん /英語面/
えいごやく /英語訳/
えいごよう /英語用/
えいごりょく /英語力/
えいごろんぶん /英語論文/
えいさい /英才/栄西/穎才;≒英才 (NB:「穎」は穂先)/
えいさいきょういく /英才教育/
えいさく /栄作/英作/栄策/
えいさくぶん /英作文/
えいさつ /縊殺/
えいざぶろう /栄三郎/
えいざん /叡山/
えいざんでんしゃ /叡山電車/
えいざんでんてつ /叡山電鉄/
えいざんほんせん /叡山本線/
えいし /英紙/英詩/英資/衛士;†guard/衛視;†国会の守衛/英姿/詠史/
えいしき /英式;British/
えいしゃ /映写/泳者/営舎/影写;なぞって写す/
えいしゃき /映写機/
えいしゃく /栄爵/
えいしゃぼん /影写本/
えいしゃまく /映写幕/
えいしゅ /英主/
えいしゅう /瀛州;三神山の一/
えいしゅつ /映出/詠出/
えいしゅん /英俊/
えいしょ /英書/営所/
えいしょう /詠唱/永正;年号(1504-1521)/永承;年号(1046-1053)/
えいしょうぼん /影照本/影鈔本/
えいしょく /栄職/
えいしん /栄進/詠進/
えいじ /英字/嬰児/英二/英治/栄治/英司/栄二/英次/英志/栄次/英史/鋭二/永治;年号(1141-1142)/英嗣/永二/英児/
えいじし /英字紙/
えいじしんぶん /英字新聞/
えいじつ /永日/
えいじにゅうりょく /英字入力/
えいじへんかん /英字変換/
えいじゅ /衛戍/
えいじゅう /永住/
えいじゅうけん /永住権/
えいじゅうしゃ /永住者/
えいじゅびょういん /衛戍病院/
えいじょく /栄辱/
えいじよう /英字用/
えいじろう /英辞郎;英語辞書名。www.eijiro.jp/栄次郎;人名/
えいじん /英人/
えいすう /英数/
えいすうこく /英数国/
えいすうじ /英数字/
えいすうもじ /英数文字/
えいすけ /英介/英輔/栄介/
えいせい /衛生;†hygiene.「公衆-」/衛星;†satellite.「通信-」/永世;†permanent.「-名人」/永生;†long life/永逝;die/衞生;「衛」旧字/衞星;「衛」旧字/
えいせいか /衛生科/
えいせいかいせん /衛星回線/
えいせいかん /衛星間/
えいせいかんきょう /衛生環境/
えいせいかんり /衛生管理/
えいせいかんりしゃ /衛生管理者/
えいせいがく /衛生学/
えいせいきどう /衛星軌道/
えいせいきょく /衛生局/
えいせいぎょうせい /衛生行政/
えいせいけんさぎし /衛生検査技師;国家資格/
えいせいこう /衛生工/
えいせいこうがく /衛生工学/
えいせいこうほう /衛星航法/
えいせいこく /衛星国/
えいせいし /衛生士/
えいせいじょう /衛生上/
えいせいじょうたい /衛生状態/
えいせいせつび /衛生設備/
えいせいぞう /衛星像/
えいせいだい /衛星第/
えいせいだいいち /衛星第一/
えいせいだいに /衛星第二/
えいせいちゅうけい /衛星中継/
えいせいちゅうりつ /永世中立/
えいせいつうしん /衛星通信/
えいせいてき /衛生的/
えいせいてれび /衛星テレビ/
えいせいでんわ /衛星電話/
えいせいとうき /衛生陶器/
えいせいとし /衛星都市/
えいせいなまちゅうけい /衛星生中継/
えいせいひ /衛生費/
えいせいへい /衛生兵/
えいせいほうそう /衛星放送/
えいせいめいじん /永世名人/
えいせいめん /衛生面/
えいせん /曳船/鋭尖/
えいぜん /営繕/
えいそ /永祚;年号(989-990)/
えいそう /営巣/詠草/営倉/
えいぞう /映像;image/影像;絵姿/営造/栄三/英三/栄蔵/
えいぞうか /映像化/
えいぞうかいろ /映像回路/
えいぞうきき /映像機器/
えいぞうきょうりょく /映像協力/
えいぞうぎじゅつ /映像技術/
えいぞうけんきゅうかい /映像研究会/
えいぞうけんきゅうしょ /映像研究所/
えいぞうさい /映像祭/
えいぞうさくひん /映像作品/
えいぞうさっか /映像作家/
えいぞうしゅつりょく /映像出力/
えいぞうしりょう /映像資料/
えいぞうしんごう /映像信号/
えいぞうしんごうよう /映像信号用/
えいぞうじょうほう /映像情報/
えいぞうせいさくぶ /映像制作部/
えいぞうせかい /映像世界/
えいぞうそうち /映像装置/
えいぞうたいしょう /映像大賞/
えいぞうたんし /映像端子/
えいぞうてき /映像的/
えいぞうてんじ /映像展示/
えいぞうとくてん /映像特典/
えいぞうとし /映像都市/
えいぞうはいしん /映像配信/
えいぞうはくぶつかん /映像博物館/
えいぞうひょうげん /映像表現/
えいぞうぶつ /営造物/
えいぞうぶんか /映像文化/
えいぞうぶんぽう /映像文法/
えいぞうよう /映像用/
えいぞうようひん /映像用品/
えいぞうりょく /映像力/
えいぞうろん /映像論/
えいぞく /永続/
えいぞくか /永続化/
えいぞくせい /永続性/
えいぞくてき /永続的/
えいた /英太/
えいたい /永代/
えいたいくよう /永代供養/
えいたつ /栄達/英達/
えいたろう /英太郎/栄太郎/永太朗/
えいたん /詠嘆/詠歎/
えいたんご /英単語/
えいだ /栄田/英田/
えいだい /永代/英題/
えいだいさんぎょう /永大産業;[企業名]/
えいだつ /穎脱/
えいだん /英断/営団/帝都高速度交通営団;NB:現・東京メトロ ※abbrev/
えいだんえき /営団駅/
えいだんぎんざせん /営団銀座線;NB:現・東京メトロ銀座線/
えいだんしゃ /営団車/
えいだんちかてつ /営団地下鉄;NB:現・東京メトロ/
えいだんちよだ /営団千代田/
えいだんちよだせん /営団千代田線;NB:現・東京メトロ千代田線/
えいだんとうざいせん /営団東西線;NB:現・東京メトロ東西線/
えいだんなんぼくせん /営団南北線;NB:現・東京メトロ南北線/
えいだんひびやせん /営団日比谷線;NB:現・東京メトロ日比谷線/
えいだんゆうらくちょうせん /営団有楽町線;NB:現・東京メトロ有楽町線/
えいち /英知/叡智/英智/叡知/睿智/
えいちしゅっぱん /英知出版;[出版社名]/
えいちだいがく /英知大学/
えいちょう /永長;年号(1096-1097)/
えいてい /営庭/
えいてん /栄転/栄典/
えいでん /叡電/営田/
えいでんでまちやなぎ /叡電出町柳/
えいと /嬰ト/
えいとう /衛陶/
えいとく /永徳;年号(1381-1384)/
えいとたんちょう /嬰ト短調/
えいとちょうちょう /嬰ト長調/
えいどう /泳動/栄道/
えいどく /英独/
えいに /嬰ニ/
えいにたんちょう /嬰ニ短調/
えいにち /英日/
えいにちょうちょう /嬰ニ長調/
えいにん /永仁;年号(1293-1299)/
えいねん /永年/
えいねんきんぞく /永年勤続/
えいのう /営農/
えいは /嬰ハ/
えいはたんちょう /嬰ハ短調/
えいはちょうちょう /嬰ハ長調/
えいはつ /映発/
えいばん /英盤/
えいびん /鋭敏/
えいふう /英風/
えいふく /永福/
えいふくちょう /永福町/
えいふつ /英仏/
えいふつかいきょう /英仏海峡/
えいぶつ /詠物/
えいぶん /英文/叡聞/
えいぶんか /英文科/
えいぶんかいしゃく /英文解釈/
えいぶんかいせつしょ /英文解説書/
えいぶんがく /英文学/
えいぶんがくせんしゅう /英文学専修/
えいぶんざっし /英文雑誌/
えいぶんし /英文誌/
えいぶんしゅっぱんぶつ /英文出版物/
えいぶんせつめい /英文説明/
えいぶんひょうき /英文表記/
えいぶんぽう /英文法/
えいぶんめい /英文名/
えいへ /嬰ヘ/
えいへい /衛兵/
えいへいじ /永平寺/
えいへたんちょう /嬰ヘ短調/
えいへちょうちょう /嬰ヘ長調/
えいべい /英米/
えいべいぐん /英米軍/
えいべいじん /英米人/
えいべいぶんがく /英米文学/
えいべいほう /英米法/
えいべいりょうこく /英米両国/
えいべつ /永別/
えいほ /嬰ホ/
えいほう /泳法/永保;年号(1081-1084)/鋭鋒/英法/
えいほたんちょう /嬰ホ短調/
えいほちょうちょう /嬰ホ長調/
えいぽんど /英ポンド/
えいまい /英邁/
えいまん /永万;年号(1165-1166)/
えいみ /詠美/
えいみん /永眠/
えいめい /英明;brilliant/英名;English name/
えいめいかん /穎明館/
えいもじ /英文字/
えいもじひょうき /英文字表記/
えいもり /栄森/
えいもん /営門/
えいや /永夜/
えいやく /英訳/
えいゆう /英雄/
えいゆうぐんぞう /英雄群像/
えいゆうし /英雄視/
えいゆうしゅぎ /英雄主義;heroism/
えいゆうしんわ /英雄神話/
えいゆうじだい /英雄時代;heroic age/
えいゆうすうはい /英雄崇拝;hero-worship/
えいゆうたん /英雄譚;heroic(n.)/
えいゆうてき /英雄的/
えいゆうでん /英雄伝/
えいゆうでんせつ /英雄伝説/
えいゆうれつでん /英雄列伝/
えいよ /栄誉/
えいよう /栄養;nourriture/栄耀;glory/営養;=栄養/
えいようえいが /栄耀栄華/
えいようか /栄養価/
えいようかけいさん /栄養価計算/
えいようがく /栄養学/
えいようがくしゃ /栄養学者/
えいようき /栄養期/
えいようきかん /栄養器官/
えいようきのうしょくひん /栄養機能食品/
えいようきょうゆ /栄養教諭;[新語]/
えいようげん /栄養源/
えいようざい /栄養剤/
えいようし /栄養士/栄養枝/
えいようしっちょう /栄養失調/
えいようしどうかんり /栄養指導管理/
えいようしょうがい /栄養障害/
えいようしょく /栄養食/
えいようじょうたい /栄養状態/
えいようせいしょく /栄養生殖/
えいようそ /栄養素/
えいようたい /栄養体/
えいようてき /栄養的/
えいようはんしょく /栄養繁殖/
えいようふりょう /栄養不良/
えいようぶつ /栄養物;nutrition/
えいようぶん /栄養分/
えいようほきゅう /栄養補給/
えいようほきゅうしょくひん /栄養補給食品/
えいようほじょしょくひん /栄養補助食品/
えいようまんてん /栄養満点/
えいようりょう /栄養量/
えいらく /永楽/
えいらん /英蘭/
えいり /営利/鋭利/絵入り/栄利/
えいりか /営利化/
えいりかつどう /営利活動/
えいりきぎょう /営利企業/
えいりきょうげんぼん /絵入狂言本/
えいりこうい /営利行為/
えいりしゅぎ /営利主義/
えいりじぎょう /営利事業/
えいりせい /営利性/
えいりだんたい /営利団体/
えいりてき /営利的/
えいりほうじん /営利法人/
えいりもくてき /営利目的/
えいりもくてきりよう /営利目的利用/
えいりゃく /永暦;年号(1160-1161)/
えいりょ /叡慮/
えいりょう /英領/
えいりりよう /営利利用/
えいりん /映倫/営林/英鈴/
えいりんしょ /営林署;国有林の保護、監督を行う官庁/
えいりんしょちょう /営林署長/
えいれい /英霊/
えいれんぽう /英連邦/
えいろ /嬰ロ/
えいろく /永禄;年号(1558-1570)/
えいろたんちょう /嬰ロ短調/
えいろちょうちょう /嬰ロ長調/
えいろんぶん /英論文/
えいわ /英和/永和;年号(1375-1379)/
えいわじしょ /英和辞書/
えいわじてん /英和辞典/
えいわたいやくしゅうちんじしょ /英和対訳袖珍辞書/
えいわだいじてん /英和大辞典/
えいわちゅうじてん /英和中辞典/
えいん /会陰/
えいんせっかい /会陰切開/
えいんぶ /会陰部/
えいんれっしょう /会陰裂傷/
えうぽまちあか /エウポマチア科/Eupomatiaceae/
ええた /η/Η/
えかき /絵描き/絵書き/
えかきうた /絵書き歌/
えがお /笑顔/
えがきて /描き手/
えがしら /江頭/
えがたい /得難い/
えがみ /江上/
えがら /絵柄/
えがわ /江川/
えがわすぐる /江川卓/
えき /駅/液/益/役/疫;疫病/腋;わき/掖;≒腋/繹;演繹/懌;≒悦/驛;「駅」の旧字/易;貿易/蜴;蜥蜴(せきえき,トカゲ)/亦;また/奕;博奕/依帰/伯;佐伯,?/
えきあつぷれす /液圧プレス/
えきあんない /駅案内/
えきいん /駅員/
えきいんはいちえき /駅員配置駅/
えきうら /駅裏/
えきうり /駅売り/
えきえき /液液/
えきおん /液温/
えきか /液化/腋窩;わきのくぼみ/腋下;わきのした/液果;berry.⇔乾果/腋花;[園芸]axillary flower/
えきかかりいん /駅係員/
えきかがす /液化ガス/
えきかせきゆがす /液化石油ガス/
えきかちっそ /液化窒素/
えきかてんねんがす /液化天然ガス;liquefied natural gas(LNG)/
えきかん /駅間/
えきかんきょり /駅間距離/
えきが /腋芽/
えきがく /疫学/易学/
えきがくしゃ /疫学者/
えきがくてき /疫学的/
えきがくてきちょうさ /疫学的調査/
えきがわ /駅側/
えきき /疫鬼/
えききょう /易経/
えききん /益金/
えきぎゅう /役牛/
えきけん /益軒/
えきげしゃ /駅下車/
えきこうない /駅構内/
えきごと /駅毎/
えきざい /液剤/
えきしせつ /駅施設/
えきしゃ /駅舎/易者/
えきしゃあと /駅舎跡/
えきしゃさんゆう /益者三友/
えきしゅう /腋臭/
えきしゅうしょう /腋臭症/
えきしゅうへん /駅周辺/
えきしゅうへんちず /駅周辺地図/
えきしょう /液晶/
えきしょうがめん /液晶画面/
えきしょうてれび /液晶テレビ/
えきしょうでぃすぷれい /液晶ディスプレイ/
えきしょうぱねる /液晶パネル/
えきしょうひょうじ /液晶表示/
えきしょうもにたー /液晶モニター/
えきじたい /駅自体/
えきじゅう /液汁/益獣/
えきじょう /液状/
えきじょうか /液状化;地盤の-/
えきじょうかげんしょう /液状化現象/
えきす /越幾斯/
えきすう /駅数/
えきせい /液性/易姓;「-革命」/駅制;[律令制]/腋生;[植物]axillary/
えきせいかくめい /易姓革命/
えきせん /易占/
えきぜんぶ /駅全部/
えきそう /液相/
えきたい /液体/
えきたいくうき /液体空気;liquid air/
えきたいさんそ /液体酸素/
えきたいじょう /液体状/
えきたいせんざい /液体洗剤/
えきたいちっそ /液体窒素/
えきたいにんげん /液体人間/
えきたいねんりょう /液体燃料/
えきたいひりょう /液体肥料/
えきだん /易断/
えきちく /役畜/
えきちゅう /液中/益虫/
えきちょう /駅長/益鳥/
えきちょうあて /駅長宛/
えきちょうしつ /駅長室/
えきてい /駅逓/
えきてき /液滴/
えきてきか /液滴化/
えきでん /駅伝/驛傳/
えきでんたいかい /駅伝大会/
えきとう /駅頭/
えきどめ /駅止/駅止め/
えきない /駅内/
えきね /駅寝/
えきばいてん /駅売店/
えきばしゃ /駅馬車/
えきひ /液肥/
えきひょうじ /駅表示/
えきびょう /疫病/
えきびょうがみ /疫病神;やくびょうがみ?/
えきびる /駅ビル/
えきふ /役夫/
えきふきん /駅付近/
えきべつ /駅別/
えきべん /駅弁/液便/
えきべんぎょうしゃ /駅弁業者/
えきべんだいがく /駅弁大学;[口]戦後に粗製濫造された大学の賤称/
えきべんや /駅弁屋/
えきほう /液胞/
えきほんや /駅本屋/
えきまえ /駅前/
えきまえさいかいはつ /駅前再開発/
えきまえしょうてんがい /駅前商店街/
えきまえどおり /駅前通り/
えきまえひろば /駅前広場/
えきまえりょかん /駅前旅館/
えきむ /役務/
えきめい /駅名/
えきめいかいしょう /駅名改称/
えきめいばん /駅名板/
えきめいひょう /駅名標/駅名票/駅名表/
えきめいひょうじ /駅名表示/
えきもれ /液漏れ/
えきや /駅家/
えきゆう /益友/
えきらん /液卵;加工用の割った卵/
えきり /疫痢/
えきりようしゃ /駅利用者/
えきりんぼん /易林本/
えきれい /液冷/疫癘/
えきろ /駅路/
えぎ /江木/
えぎぬ /絵絹/
えぎょう /エ行/え行/
えくさ /exa;[SI接頭語]E,10^18/
えくすおーじゃん /XO醤/
えくぼ /靨/
えぐち /江口/
えぐみ /絵組/絵組み/刳味;タケノコ独特の-/
えけい /恵瓊/
えげ /会下/
えこ /依怙/
えこう /回向/
えこじ /依怙地/
えこだ /江古田/
えことば /絵詞/
えこひいき /依怙贔屓/
えこん /慧根/
えこんて /絵コンテ/
えごうらい /絵高麗/
えごころ /絵心/
えごのり /恵胡海苔/
えごま /荏胡麻/
えごよみ /絵暦/
えさ /餌/
えさか /江坂/
えさかてん /江坂店/
えさき /江崎/
えさぎ /餌木/
えさし /江刺/江差/枝幸/江指/
えさしおいわけ /江差追分/
えさだい /餌代/
えさづり /餌釣り/
えさば /餌場/
えさばこ /餌箱/
えさや /餌屋/
えさん /恵山/
えざ /会座/
えざき /江崎/
えざきぐりこ /江崎グリコ;[企業名]/
えざきれおな /江崎玲於奈/
えざら /絵皿/
えざわ /江沢/江澤/
えし /絵師/壊死/画師/
えしき /会式/
えしゃく /会釈/
えしゃじょうり /会者定離/
えじ /衛士/江地/
えじき /餌食/
えじぷと /埃及;Egypt/
えじぷとご /エジプト語;Egyptian/
えじぷとじん /エジプト人/
えじま /江島/江嶋/
えすえすせいやく /エスエス製薬;[企業名]/
えすえぬひ /ＳＮ比/SN比;signal-to-noise ratio/
えすえふしょうせつ /ＳＦ小説/SF小説/
えすがた /絵姿/
えすきもーけん /エスキモー犬/
えすきょく /Ｓ極/S極;south pole. 「方位磁石の-」/
えすさいず /Ｓサイズ/Sサイズ/
えすしき /S式;symbol-expression/
えすじ /Ｓ字/
えすせき /Ｓ席/
えすは /Ｓ波;横波/
えすびーしょくひん /エスビー食品;[企業名] NB:1992年7月以降の表記/ヱスビー食品;[企業名] NB:登記上の表記/
えず /絵図/
えずみ /江角/
えずめん /絵図面/
えずりこ /江釣子/
えせ /似非/似而非/
えそ /壊疽;[医]gangrene/狗母魚;lizard fish/
えそらごと /絵空事/
えぞ /蝦夷/
えぞいわな /蝦夷岩魚/
えぞう /絵像/
えぞえ /江副/
えぞしか /蝦夷鹿/
えぞち /蝦夷地/
えぞまつ /蝦夷松/
えぞら /江面/
えた /穢多/
えたい /得体/
えたじま /江田島/
えだ /枝/江田/荏田/
えだうち /枝打ち/
えだかり /枝刈り/
えだがり /枝刈り/
えだがわ /枝川/
えだがわり /枝変わり;[植物]bud variation. 枝単位の突然変異/
えだきりばさみ /枝切り鋏/
えだげ /枝毛/
えだじょう /枝状/
えだずみ /枝炭/
えだせん /枝線/
えだち /役/
えだなみ /枝並/
えだにく /枝肉/
えだにょう /支繞/
えだの /枝野;姓/
えだは /枝葉/
えだばり /枝針/
えだばん /枝番/
えだぶり /枝振り/
えだまつ /枝松/
えだまめ /枝豆/
えだみち /岐路/枝道/
えだわかれ /枝分かれ/枝わかれ/
えだん /エ段/
えち /乢/
えちがわ /愛知川/
えちご /越後/
えちごこうつう /越後交通/
えちごじし /越後獅子/
えちごせん /越後線/
えちごや /越後屋/
えちごゆざわ /越後湯沢/
えちごゆざわえき /越後湯沢駅/
えちぜん /越前/
えちぜんかいがん /越前海岸/
えちぜんがに /越前蟹/
えちぜんみさき /越前岬/
えちぜんやき /越前焼/
えっか /越夏;⇔越冬/
えっきょう /越境/
えっきょうしゃ /越境者/
えっくすおーじゃん /XO醤/
えっくすきゃく /Ｘ脚/X脚/
えっくすじく /Ｘ軸/X軸/
えっくすせん /Ｘ線/
えっくすせんしょくたい /X染色体;[生物]X-chromosome/Ｘ染色体;[生物]X-chromosome/
えっけん /謁見/越権/
えっけんこうい /越権行為/
えっしゅう /越州;越前・越中・越後/
えっせいしゅう /エッセイ集/
えっそ /越訴/
えっちゅう /越中/
えっちゅうおわらぶし /越中おわら節;[民謡]/
えっちゅうじま /越中島/
えっちゅうだいもんえき /越中大門駅/
えっちゅうふんどし /越中褌/
えっとう /越冬/
えっとうたい /越冬隊/
えっとうち /越冬地/
えっふぇるとう /エッフェル塔;la tour Eiffel/
えっぷく /悦服/
えっぺい /閲兵/
えっぺいしき /閲兵式/
えつ /悦;-に入る/閲;閲覧/咽;嗚咽/噎;む・せる/謁;謁見/粤;(中国南部の少数民族)/戉;≒鉞/越;優越/鉞;斧鉞/斉魚/
えつお /悦夫/
えつけ /絵付け/
えつこ /悦子/英津子/恵津子/えつ子/絵津子/
えつじ /悦司/悦次/
えつたろう /悦太郎/
えつづみ /兄鼓;大鼓/
えつどく /閲読/
えつなん /越南;Vietnam/
えつねん /越年/
えつねんそう /越年草/
えつもくしょう /悦目抄/
えつや /悦也/悦哉/
えつよ /悦代/
えつらく /悦楽/
えつらん /閲覧/
えつらんかのう /閲覧可能/
えつらんきょひ /閲覧拒否/
えつらんしつ /閲覧室/
えつらんしゃ /閲覧者/
えつらんせいきゅう /閲覧請求/
えつり /桟/
えつれき /閲歴/
えつろう /悦朗/
えづくり /絵作り/
えづけ /餌付け/
えづら /絵面/
えて /得手/
えてかって /得手勝手/
えてき /絵的/
えてこう /猿公/エテ公/猿猴;えんこう?/
えてして /得てして/
えてふえて /得手不得手/
えてんらく /越天楽;雅楽の曲名/
えでほん /絵手本/
えと /干支/江渡;姓/
えとう /江藤/衛藤/江頭/恵藤/
えとき /絵解き/
えとく /会得/
えとり /餌取り/
えとるりあご /エトルリア語;Etruscan/
えとるりあじん /エトルリア人;Etruscan/
えとろふ /択捉/
えど /江戸/穢土/
えどえ /江戸絵/
えどおもて /江戸表/
えどがろう /江戸家老;[日本史]⇔国家老/
えどがわ /江戸川/
えどがわく /江戸川区/
えどがわくみん /江戸川区民/
えどがわじょし /江戸川女子/
えどがわばし /江戸川橋/
えどがわらんぽ /江戸川乱歩/
えどがわらんぽしょう /江戸川乱歩賞/
えどき /江戸期/
えどくら /江戸蔵/
えどことば /江戸言葉/
えどこもん /江戸小紋/
えどご /江戸語/
えどさき /江戸崎/
えどさんざ /江戸三座/
えどざき /江戸崎/
えどじだい /江戸時代/
えどじだいこうき /江戸時代後期/
えどじょう /江戸城/
えどっこ /江戸っ子/
えどてん /江戸展/
えどばくふ /江戸幕府/
えどひがん /江戸彼岸/
えどふう /江戸風/
えどぶんがく /江戸文学/
えどま /江戸間/
えどまえ /江戸前/
えどむらさき /江戸紫/
えどや /江戸屋/
えな /恵那;地名/胞衣/絵奈/
えなが /柄長/
えなさん /恵那山;地名,/
えなざくら /恵那櫻/
えなつ /江夏/
えなみ /榎並/
えなめるがわ /エナメル革/
えなめるしつ /エナメル質;[解剖]enamel. 歯の表面/
えなめるせん /エナメル線/
えなり /江成/
えなんじ /淮南子;劉安/
えに /縁/
えにし /縁/
えにっき /絵日記/
えにわ /恵庭/
えぬえちけいほーる /ＮＨＫホール/
えぬかっけい /Ｎ角形/
えぬきょう /Ｎ響/
えぬきょく /Ｎ極/N極;north pole. 「方位磁針の-」/
えぬこ /Ｎ個/
えぬじげん /Ｎ次元/
えぬま /江沼/
えねるぎーぐん /エネルギー群/
えねるぎーげん /エネルギー源/
えねるぎーこうりつ /エネルギー効率/
えねるぎーしょう /エネルギー省/
えねるぎーせいさく /エネルギー政策/
えねるぎーそんしつ /エネルギー損失/
えねるぎーもんだい /エネルギー問題/
えの /榎/
えのき /榎/榎木/
えのきたけ /榎茸/
えのきだ /榎田/
えのきど /榎戸/
えのぐ /絵の具/絵具/
えのぐざら /絵の具皿/
えのこ /狗/
えのしま /江ノ島/江の島/
えのしません /江ノ島線/
えのぞの /榎園/
えのでん /江の電/
えのと /榎戸/
えのもと /榎本/
えはがき /絵葉書/絵はがき/
えはた /江畑/江幡/
えはだ /絵肌/
えはら /江原/荏原/
えばた /江端/
えばら /江原/荏原/
えばらこ /桧原湖/
えひめ /愛媛/
えひめけん /愛媛県/
えひめしんぶんしゃ /愛媛新聞社;[企業名]/
えひめだい /愛媛大/
えひめだいがく /愛媛大学/
えび /海老/蝦;=海老/蛯;=海老/鰕;=海老/葡萄;ぶどう。「-色」/
えびいも /蝦芋/海老芋/
えびいろ /葡萄色/
えびお /海老尾/
えびがため /海老固め/
えびがに /海老蟹;ざりがに/
えびさわ /海老沢/海老澤/
えびじゃこ /海老雑魚/
えびす /恵比須;豊漁神 (地名:姫路など)/恵比寿;≒恵比須 (地名:東京)/夷;語源:中国人以外の民族/戎;(≒夷) 語源:古代中国・北西部の異民族/蛭子/胡/狄;語源:古代中国・北方の異民族/貊;語源:古代中国・東北部のツングース族/
えびすがお /恵比寿顔/
えびすぐさ /恵比須草/夷草/
えびすこう /恵比須講/
えびすこうじょう /恵比寿工場/
えびすごころ /夷心/
えびすさま /恵比寿様/
えびすちょう /恵比寿町/
えびすのうお /恵比須の魚/
えびすばし /戎橋/
えびすほうこう /恵比寿方向/
えびすほうめん /恵比寿方面/
えびすや /蛭子屋/
えびせんべい /海老煎餅/
えびぞり /海老反り/
えびちゃ /海老茶/葡萄茶/
えびちゃいろ /海老茶色/
えびづか /海老塚/
えびづる /蝦蔓/
えびてん /エビ天/海老天/
えびな /海老名/蝦名/蛯名/
えびなし /海老名市/
えびね /恵比根/
えびはら /海老原/蛯原/
えびふらい /海老フライ/
えびら /箙/
えふ /衛府;[律令制]内裏の警備担当/
えふだ /絵札/
えふで /絵筆/
えぶっし /絵仏師/
えぷろんすがた /エプロン姿/
えべ /江辺/
えべつ /江別/
えべつえき /江別駅/
えほう /吉方/恵方;縁起の良い方角/
えほうまき /恵方巻/恵方巻き/
えほん /絵本/
えほんさっか /絵本作家/
えぼうしょ /絵奉書/
えぼし /烏帽子/
えぼしおや /烏帽子親/
えぼだい /えぼ鯛/
えぽ /ＥＰＯ/
えぽきしじゅし /エポキシ樹脂/
えま /絵馬/絵麻/江馬/
えまき /絵巻/
えまきもの /絵巻物/
えみ /笑み/恵美/絵美/映見/江見/栄美/恵実/笑/江民/
えみか /恵美香/
えみこ /恵美子/絵美子/英美子/江美子/栄美子/絵己子/
えみし /蝦夷/
えみや /江美弥;名/円宮;名/
えみり /恵美里/
えむかえ /江迎/
えむさいず /Ｍサイズ/Mサイズ/
えむら /江村/
えめらるどいろ /エメラルド色/
えもじ /絵文字/
えもじじゅくご /絵文字熟語/
えもと /江本/絵本/柄本/
えもの /獲物/得物/
えものがたり /絵物語/
えもん /衛門/衣紋/衣文/
えもんかけ /衣紋掛け/衣紋掛/
えもんふ /衛門府/
えやみ /瘧;マラリアなどの間欠熱/疫病み;流行病/
えよう /栄耀;-栄華/
えようえいが /栄耀栄華/
えら /鰓/腮/江良/
えらーおん /エラー音/
えらーしょり /エラー処理/
えらーりつ /エラー率/
えらあな /鰓孔;[生物]gill slit/
えらこきゅう /鰓呼吸/
えらさ /偉さ/
えらびかた /選び方/
えらぶた /鰓蓋;opercle/
えらぶつ /豪物/偉物/
えり /襟;=衿/衿;=襟/絵里/恵理/絵理/恵里/恵利/英理/愛理/衣里;名/江利/絵莉/枝里/惠理/愛莉/衣理/
えりあか /襟垢/
えりあし /襟足/
えりうら /襟裏/
えりか /恵理香/絵里花/惠理香/江利香/
えりかざり /襟飾り/
えりがみ /襟髪/
えりくび /襟首/
えりぐり /襟刳り/
えりこ /えり子/恵理子/絵理子/江梨子/恵里子/江里子/英理子/英里子/江利子/絵梨子/悦吏子;名/
えりごのみ /選り好み/えり好み/
えりさ /恵利沙/
えりさき /襟先;[服飾]/
えりしょう /襟章/衿章/
えりすぐり /選りすぐり/
えりぜきゅう /エリゼ宮;フランスの大統領官邸。elysee.fr/
えりぜに /撰り銭/
えりだぬすざ /エリダヌス座;Eridanus(Eri)/
えりな /江理奈/
えりぬき /選り抜き/
えりはば /襟幅;[服飾]/
えりまき /襟巻/
えりまきとかげ /襟巻蜥蜴/
えりまわり /襟周り;[服飾]/襟回り/
えりみ /恵里美/
えりもと /襟元/
えりもみさき /襟裳岬/
えるえるきょうしつ /LL教室/
えるえるさいず /ＬＬサイズ/LLサイズ/
えるさいず /Ｌサイズ/Lサイズ/
えるびうむ /Er/Erbium/
えれつ /エ列/え列/
えろがぞう /エロ画像/
えろほん /エロ本/
えん /円/縁/塩/園/苑/宴/艶/焉;(助字)終焉/嫣;嫣然/篶;(細竹)すず/鉛;鉛直/沿;沿岸/堰;(せき)堰堤/偃;偃月/焔;火焔/閻;閻魔/炎;火炎/煙;禁煙/烟;「煙」の異体字/厭;厭戦/魘;うな・される/黶;あざ/燕;(つばめ)海燕/嚥;嚥下/臙;臙脂/讌;うたげ/捐;義捐金/悁/援;援助/媛;(ひめ)才媛/湲/爰;ここに/猿;野猿/遠;遠方/袁;袁紹/轅;ながえ/薗;「園」の旧字(人名用漢字)/延;延長/筵;むしろ/蜒;蚰蜒/奄;気息奄々/掩;掩護射撃/淹;い・れる/閹;閹官(=宦官)/宛;あて/怨;怨恨/鴛;鴛鴦/婉;婉曲/蜿;蜿々/冤;冤罪/寃;「冤」の異体字/簷;のき/檐;のき/掾/櫞;枸櫞酸/演;演説/垣;かき/鳶;とび/淵;深淵/衍;敷衍/艷;「艶」の旧字/鹽;「塩」の旧字/圓;「円」の旧字(人名用漢字)/圜/渕;「淵」の異体字1/渊;「淵」の異体字2/覃/閼/¥/
えんあん /塩安;塩化アンモニウム/
えんい /遠位/
えんいた /縁板/
えんいん /遠因/延引/援引/
えんう /煙雨/
えんうり /円売り/
えんうん /煙雲/
えんうんどう /円運動/
えんえい /遠泳/
えんえき /演繹/
えんえきぎ /演繹木/
えんえきけい /演繹系/
えんえきたいけい /演繹体系/
えんえきてき /演繹的/
えんえきほう /演繹法/
えんえきろんりがく /演繹論理学/
えんえん /延々;endless/炎々;-と燃える/奄々;気息-/蜿蜒;-長蛇の列/蜿々;≒蜿蜒/延延/炎炎/奄奄;気息-/蜿蜿;≒蜿蜒/
えんお /厭悪/
えんおう /鴛鴦;おしどり/延応;年号(1239-1240)/閻王/
えんか /演歌/塩化/嚥下/円貨/煙火;(主に[法])花火/艶歌/円価/怨歌/煙霞/縁家/烟霞/
えんか> /塩化;[化学]chloride/
えんかあえん /塩化亜鉛/
えんかい /宴会/沿海/延会/遠海/
えんかいおう /塩化硫黄/
えんかいがかり /宴会係/
えんかいげい /宴会芸/
えんかいしゅう /沿海州/
えんかいしょく /鉛灰色/
えんかいじょう /宴会場/
えんかいもくてき /宴会目的/
えんかいや /宴会屋/
えんかいよう /宴会用/
えんかかしゅ /演歌歌手/
えんかきん /塩化金;[化学]AuCl,AuCl2/
えんかぎん /塩化銀;[化学]AgCl. フイルム原料/
えんかく /沿革/遠隔/
えんかくいりょう /遠隔医療;[医]/
えんかくかんし /遠隔監視/
えんかくさよう /遠隔作用/
えんかくそうさ /遠隔操作/
えんかくそくてい /遠隔測定;telemetry/
えんかくち /遠隔地/
えんかくりょく /遠隔力/
えんかけい /演歌系/
えんかすいぎん /塩化水銀;[化学]HgCl2,Hg2Cl2/
えんかすいそ /塩化水素;[化学]HCl/
えんかちょう /演歌調/
えんかつ /円滑/
えんかつか /円滑化/
えんかつせい /円滑性/
えんかてつ /塩化鉄;[化学]FeCl2,FeCl3/
えんかどう /塩化銅;[化学]CuCl,CuCl2/
えんかびにる /塩化ビニル;vinyl chloride/
えんかびにるじゅし /塩化ビニル樹脂/
えんかぶつ /塩化物/
えんかぶもん /演歌部門/
えんかる /遠軽/
えんかわ /圓川;姓/
えんかわせ /円為替/
えんかん /円環/煙管/鉛管/
えんかんぎょ /塩乾魚/
えんかんさん /円換算/
えんかんじょう /円環状/
えんかんすう /円関数/
えんがい /塩害/円外/円買い/煙害/円蓋/鉛害/掩蓋/
えんがく /縁覚/
えんがる /遠軽/
えんがわ /縁側/
えんがん /沿岸/遠眼/
えんがんぎょ /沿岸魚;littoral fish/
えんがんぎょぎょう /沿岸漁業/
えんがんけいびたい /沿岸警備隊/
えんがんちいき /沿岸地域/
えんがんぶ /沿岸部/
えんがんゆうしょう /沿岸湧昇/
えんき /延期/塩基/円規/
えんきごう /円記号;¥/
えんきど /塩基度;basicity/
えんきどう /円軌道/
えんきはいれつ /塩基配列/
えんきゅう /延久;年号(1069-1074)/円球/円丘/
えんきょう /延享;年号(1744-1748)/燕京/延慶;年号(1308-1311)/円鏡/
えんきょく /婉曲/
えんきょくひょうげん /婉曲表現/
えんきょり /遠距離/
えんきょりこうげき /遠距離攻撃/
えんきょりじゅしん /遠距離受信/
えんきょりつうがくしゃ /遠距離通学者/
えんきょりつうきん /遠距離通勤/
えんきょりつうきんしゃ /遠距離通勤者/
えんきょりれんあい /遠距離恋愛/
えんきり /縁切り/
えんきりでら /縁切寺/縁切り寺/
えんきん /遠近/
えんきんかん /遠近感/
えんきんほう /遠近法/
えんきんりょうよう /遠近両用/
えんぎ /演技/縁起/演義;†わかりやすく・面白く書く。『三国志-』/延喜;年号(901-23)/演戯;†play. 『ガラス玉-』(Hesse)/
えんぎかい /演技会/
えんぎしき /延喜式/
えんぎしょ /縁起書/
えんぎせい /演技性/
えんぎなおし /縁起直し/
えんぎは /演技派/
えんぎもの /縁起物/
えんぎょ /塩魚/
えんぎりょく /演技力/
えんくう /円空/
えんぐみ /縁組/
えんぐらふ /円グラフ/
えんぐん /援軍/
えんけい /円形/遠景/燕京/冤刑/
えんけいきょうぎじょう /円形競技場/
えんけいげきじょう /円形劇場/
えんけいだつもうしょう /円形脱毛症;[医]/
えんけいだんめん /円形断面/
えんけいひょうしき /円形標識/
えんけん /偃蹇/
えんげ /嚥下/
えんげい /園芸/演芸/園藝/
えんげいか /園芸家/
えんげいざっし /園芸雑誌/
えんげいしゅ /園芸種/
えんげいじょう /演芸場/
えんげいたいしょう /演芸大賞/
えんげいてん /園芸店/
えんげいひんしゅ /園芸品種/
えんげいぶ /園芸部/
えんげいめい /園芸名/
えんげいよう /園芸用/
えんげき /演劇/
えんげきかつどう /演劇活動/
えんげきかんけい /演劇関係/
えんげきさい /演劇祭/
えんげきしゅうだん /演劇集団/
えんげきてき /演劇的/
えんげきぶ /演劇部/
えんげきよう /演劇用/
えんげきりろん /演劇理論/
えんげきろん /演劇論/
えんげつ /偃月/
えんげつとう /偃月刀/
えんげるけいすう /エンゲル係数;[経済]Engel's coefficient. (食費÷消費支出)/
えんげん /淵源/延元;年号(1336-1340)/怨言/
えんこ /縁故/円弧/塩湖/⌒;arc/
えんこう /援交;[新語]援助交際/円光/猿猴/
えんこうきんこう /遠交近攻/
えんこうじばん /円光寺版/
えんこうるい /円口類/
えんこく /遠国/
えんこけい /円弧形/
えんこさい /縁故債;≒私募債/
えんこじょう /円弧上/
えんこん /怨恨/
えんご /援護/縁語/掩護/婉語/
えんごか /援護下/
えんごく /遠国/
えんごさく /延胡索/
えんごしゃげき /援護射撃/掩護射撃/
えんさ /怨嗟/
えんさき /縁先/
えんさつ /円札/
えんさん /塩酸/演算;えんざん/
えんさんし /演算子/
えんざ /円座/宴座/縁座/縁坐;=縁座/円坐;=円座/
えんざい /冤罪/寃罪/
えんざん /演算/塩山/遠山/圓山/鉛槧/
えんざんか /演算化/
えんざんかいすう /演算回数/
えんざんかいろ /演算回路/
えんざんき /演算器/演算機/
えんざんきごう /演算記号/
えんざんけっか /演算結果/
えんざんごさ /演算誤差/
えんざんし /演算子/
えんざんしき /演算式/
えんざんじかん /演算時間/
えんざんじゅんい /演算順位/
えんざんじゅんじょ /演算順序/
えんざんすう /演算数/
えんざんせいど /演算精度/
えんざんせいのう /演算性能/
えんざんそうち /演算装置/
えんざんそくど /演算速度/
えんざんのうりょく /演算能力/
えんざんぶ /演算部/
えんざんほう /演算法/
えんざんめい /演算名/
えんざんりょう /演算量/
えんし /遠視/艶姿/
えんしつ /煙室/
えんしゃ /演者/園舎/
えんしゃっかん /円借款/
えんしゅう /演習/遠州/円周/怨讐/円宗/
えんしゅうおおはし /遠州大橋/
えんしゅうかく /円周角;[数学]「共通の弧の-は等しい/
えんしゅうしえん /演習支援/
えんしゅうしつ /演習室/
えんしゅうしょ /演習書/
えんしゅうじょう /演習場/円周上/
えんしゅうてつどう /遠州鉄道/
えんしゅうべん /遠州弁/
えんしゅうもんだい /演習問題/
えんしゅうりつ /円周率/
えんしゅうりん /演習林/
えんしゅつ /演出/
えんしゅついと /演出意図/
えんしゅつか /演出家/
えんしゅつしゃ /演出者/
えんしゅつじ /演出時/
えんしゅつじょう /演出上/
えんしゅつてき /演出的/
えんしゅつほう /演出法/
えんしゅつめん /演出面/
えんしょ /炎暑/艶書/縁書/
えんしょう /炎症/延焼/艶笑/袁紹;人名,三国志/円生/煙硝/遠称/
えんしょうじ /円勝寺/
えんしょく /炎色/焔色/怨色/
えんしょくせい /演色性/
えんしょくはんのう /炎色反応/
えんしん /延伸/遠心/円心/円唇/
えんしんか /延伸化/円唇化;[音声学](lip-)rounding/
えんしんかじょ /遠心花序/
えんしんしき /遠心式/
えんしんせい /遠心性/
えんしんせいしんけい /遠心性神経/
えんしんちゅうぞうき /遠心鋳造機/
えんしんてき /遠心的/
えんしんぶぶん /延伸部分/
えんしんぶんり /遠心分離/
えんしんぶんりき /遠心分離機/遠心分離器/
えんしんぼいん /円唇母音;[音声学]round vowel/
えんしんりょく /遠心力/
えんじ /園児/臙脂;dark red/燕脂;=臙脂/衍字/槐;姓/
えんじいろ /臙脂色/
えんじたち /園児達/
えんじつてん /遠日点/
えんじて /演じ手/
えんじゃ /演者/縁者/
えんじゃく /燕雀/
えんじゅ /槐/
えんじゅく /円熟/
えんじゅくみ /円熟味/
えんじゅつ /演述/
えんじゅんれつ /円順列/
えんじょ /援助/
えんじょう /炎上/円状/遠城/
えんじょうじ /円城寺/
えんじょがく /援助額/
えんじょきん /援助金/
えんじょこうさい /援助交際/
えんじょこく /援助国/
えんじょだんたい /援助団体/
えんじょひ /援助費/
えんじょぶっし /援助物資/
えんじん /猿人/円陣/遠人/煙塵/厭人/閹人/
えんじんおん /エンジン音/
えんすい /円錐/塩水/鉛錘/
えんすいかじょ /円錐花序/
えんすいがた /円錐型/
えんすいきょくせん /円錐曲線/
えんすいけい /円錐形/
えんすいこ /塩水湖/
えんすいこう /塩水港/
えんすいじょう /円錐状/
えんすいずほう /円錐図法/
えんすいだい /円錐台/
えんすいめん /円錐面/
えんずい /延髄/
えんずいぎり /延髄斬/
えんせい /遠征/延性/厭世/縁生/
えんせいがい /袁世凱/
えんせいさき /遠征先/
えんせいしゅぎ /厭世主義;pesimism/
えんせいたい /遠征隊/
えんせいちゅう /遠征中/
えんせいてき /厭世的/
えんせいひ /遠征費/
えんせき /縁石/宴席/遠赤/塩析/遠戚/
えんせきがいせん /遠赤外線/
えんせきもんだい /円積問題/
えんせん /沿線/厭戦/塩泉/
えんせんじゅうみん /沿線住民/
えんせんじんこう /沿線人口/
えんせんず /円線図/
えんせんぜんたい /沿線全体/
えんせんちいき /沿線地域/
えんぜつ /演説/演舌/
えんぜつしゅう /演説集/
えんぜつほう /演説法/
えんぜん /艶然;にっこり/嫣然;≒艶然/婉然;しなやか/宛然;あたかも/
えんそ /塩素;Cl/遠祖/塩酢;[文語]不可欠な調味料・食品/Cl/Chlorine/
えんそう /演奏/燕巣/
えんそうか /演奏家/
えんそうかい /演奏会/
えんそうかいけいしき /演奏会形式/
えんそうかいし /演奏開始/
えんそうかつどう /演奏活動/
えんそうかのう /演奏可能/
えんそうきかい /演奏機会/
えんそうきごう /演奏記号/
えんそうきょく /演奏曲/
えんそうきょくもく /演奏曲目/
えんそうぎじゅつ /演奏技術/
えんそうけいしき /演奏形式/
えんそうけいたい /演奏形態/
えんそうけん /演奏権/
えんそうこうか /演奏効果/
えんそうご /演奏後/
えんそうしゃ /演奏者/
えんそうしゃめい /演奏者名/
えんそうしゅうりょうご /演奏終了後/
えんそうじ /演奏時/
えんそうじかん /演奏時間/
えんそうじたい /演奏自体/
えんそうじょう /演奏上/
えんそうじょうほう /演奏情報/
えんそうせいぎょ /演奏制御/
えんそうちゅう /演奏中/
えんそうないよう /演奏内容/
えんそうのうりょく /演奏能力/
えんそうば /円相場/
えんそうひょうげん /演奏表現/
えんそうふのう /演奏不能/
えんそうほう /演奏法/
えんそうようしき /演奏様式/
えんそうりょく /演奏力/
えんそうりょこう /演奏旅行/
えんそうれい /演奏例/
えんそうれんしゅう /演奏練習/
えんそく /遠足/
えんそくこ /堰塞湖/
えんそけい /塩素系/
えんそけいさっきんざい /塩素系殺菌剤/
えんそけいひょうはくざい /塩素系漂白剤/
えんそさん /塩素酸/
えんそしょうどく /塩素消毒/
えんそひょうはく /塩素漂白/
えんぞう /塩蔵;-ワカメ,-昆布/円蔵/
えんた /遠田/苑田/
えんたい /延滞/掩体/淹滞/
えんたいきん /延滞金/
えんたいぜい /延滞税;delinquency tax. 現行14.6%/
えんたいぶん /延滞分/
えんたいりそく /延滞利息/
えんたいりょう /延滞料/
えんたく /円卓/
えんたくかいぎ /円卓会議/
えんたくものがたり /円卓物語/
えんたん /鉛丹/
えんたんい /円単位/
えんたんいろ /鉛丹色;minium/
えんだ /遠田/苑田/
えんだい /演題/遠大/演台/縁台/円台/
えんだか /円高/
えんだかさえきかんげん /円高差益還元/
えんだて /円建て/
えんだま /円玉/
えんだん /縁談/演壇/
えんち /園地/遠地/園池;†(いけ)/
えんちくでんち /鉛蓄電池/
えんちてん /遠地点/
えんちゃく /延着/
えんちゅう /円柱/
えんちゅうじょう /円柱状/
えんちゅうめん /円柱面/
えんちょう /延長;年号(923-931)/園長/円頂/
えんちょううんてん /延長運転/
えんちょうきかんちゅう /延長期間中/
えんちょうきゅう /円頂丘/
えんちょうくかん /延長区間/
えんちょうけいかく /延長計画/
えんちょうこうじ /延長工事/
えんちょうこくい /円頂黒衣/
えんちょうじょう /延長上/
えんちょうせん /延長線/延長戦/
えんちょうせんじょう /延長線上/
えんちょうぜんはん /延長前半/
えんちょうぶ /延長部/
えんちょうぶぶん /延長部分/
えんちょく /鉛直/
えんちょくこうぞう /鉛直構造/
えんちょくせん /鉛直線/
えんちょくほうこう /鉛直方向/
えんちん /遠沈/
えんつづき /縁続き/
えんてい /園庭;garden/堰堤;dam/園丁;gardener/
えんてつ /遠鉄/
えんてつでんしゃ /遠鉄電車/
えんてん /炎天/遠点/
えんてんか /炎天下/
えんてんかつだつ /円転滑脱/
えんでん /塩田/
えんとう /円筒/遠投/遠島/円頭/煙筒/
えんとうけい /円筒形/円筒型/
えんとうじょう /円筒状/
えんとうずほう /円筒図法/
えんとく /延徳;年号(1489-1492)/
えんとつ /煙突/
えんど /塩度/
えんどう /遠藤/沿道/豌豆/羨道;墓室に通じる地下道/筵道/
えんどうしゅうさく /遠藤周作/
えんどうまめ /豌豆豆/
えんどおい /縁遠い/
えんどく /鉛毒/煙毒/
えんどる /円ドル/
えんない /園内/円内/
えんないあんない /園内案内/
えんにち /縁日/
えんにゅう /衍入/
えんにょう /延繞;[部首]/
えんねつ /炎熱/
えんねん /延年/
えんのう /延納/
えんのぎょうじゃ /役行者/
えんのした /縁の下/
えんのすけ /猿之助/
えんば /焉馬/
えんばく /燕麦/
えんばん /円盤/円板/鉛版/
えんばんがた /円盤型/
えんばんじょう /円盤状/
えんばんなげ /円盤投げ;陸上競技/
えんばんぶ /円盤部/
えんぱく /延泊/鉛白/
えんぱくかのう /延泊可能/
えんぱくぶん /延泊分/
えんぱくりょうきん /延泊料金/
えんぱつ /延発/
えんび /燕尾/塩ビ/
えんびかん /塩ビ管/
えんびふく /燕尾服/
えんぴ /猿臂/円匙/
えんぴつ /鉛筆/
えんぴつけずり /鉛筆削り/
えんぶ /演舞;†(dance)「-場」/演武;†「空手の-」/円舞;rondeau/
えんぶきょく /円舞曲/
えんぶん /塩分/延文;年号(1356-1361)/艶聞/艶文/
えんぶんのうど /塩分濃度/
えんぶんれん /遠文連/
えんぷく /艶福/
えんぷん /円墳/
えんへんこう /円偏光/
えんべつ /遠別/
えんぺい /掩蔽/援兵/
えんぺん /縁辺/
えんぺんたいざ /縁辺胎座/
えんぼう /遠望/遠謀/怨望/
えんぼうしんりょ /遠謀深慮/
えんぽう /遠方/延宝;年号(1673-1681)/演報/
えんぽうば /遠方場/
えんぽん /円本/艶本/
えんま /閻魔/絵馬/
えんまがお /閻魔顔/
えんまく /煙幕/
えんまだいおう /閻魔大王/
えんまちょう /閻魔帳/
えんまん /円満/
えんまんかいけつ /円満解決/
えんまんぐそく /円満具足/
えんみらい /遠未来/
えんむ /煙霧/
えんむすび /縁結び/
えんめい /延命/艶名/
えんめいこうじ /延命工事/
えんめいちりょう /延命治療/
えんもく /演目/
えんもくとじ /鳶目兎耳/
えんや /塩冶/艶冶/
えんやす /円安/
えんゆ /縁由/
えんゆう /円融/
えんゆうかい /園遊会/宴遊会/
えんゆうさんだい /円融三諦/
えんゆうてんのう /円融天皇/
えんゆうむげ /円融無碍/
えんよう /援用/遠洋/艶容/
えんようぎょぎょう /遠洋漁業/
えんようこうかい /遠洋航海/
えんらい /遠来/遠雷/
えんらく /猿楽/円楽/宴楽/
えんらくちょう /猿楽町/
えんり /厭離/
えんりえど /厭離穢土/
えんりゃく /延暦;年号(782-806)/
えんりゃくじ /延暦寺/
えんりゅう /淹留/
えんりょ /遠慮/
えんりょがち /遠慮勝ち/
えんりん /園林/
えんる /遠流/
えんるい /塩類;[化学]salt/縁類/
えんれい /艶麗/延齢/
えんれいそう /延齢草/
えんろ /遠路/
お /尾/御/汚/緒/小/雄/牡/男/悪;悪寒/苧;hemp/麻;hemp/於/唹/淤;どろ/嗚;(擬声語.「鳴」とは別字)/塢;どて/乎;(呉音)乎古止点/生;(人名読み)/和;(人名読み)/夫;(人名読み)/央;(人名読み)/将;(人名読み)/勇;(人名読み)/郎;(人名読み)/朗;(人名読み)/穂;(人名読み)/桜;?/織;?/
お> /御/牡/
おーがた /Ｏ型/O型/
おーきゃく /Ｏ脚/O脚/
おーすとらりあ /濠太剌利;Australia/
おーすとらりあさん /オーストラリア産/
おーすとらりあじん /オーストラリア人/
おーすとらりあたいりく /オーストラリア大陸/
おーすとりあ /墺太利;Austria/
おーすとりあじん /オーストリア人/
おーすとろねしあごぞく /オーストロネシア語族;[言語]Austronesian/
おーとましゃ /オートマ車/
おーとむぎ /オート麦/
おーなーめい /オーナー名/
おーぷんかかく /オープン価格/
おーぷんせん /オープン戦;非公式試合/
おーむ /Ω/王蟲/
おーやんふぃふぃ /欧陽菲菲/
おーるすたーせん /オールスター戦/
おーれ /ＯＲＥ/
おあ /∪/∨/
おあいそ /お愛想/
おあいて /お相手/御相手/
おあいにくさま /御生憎様/
おあがり /お上がり/
おあげ /お揚げ/
おあし /御足/
おあじ /お味/
おあずかり /お預り/お預/
おあずけ /お預け/
おあそび /お遊び/
おあふとう /オアフ島/
おあらため /お改め/
おい /甥/笈/追/老い/及/
おいうち /追い討ち/追い打ち/追い撃ち/追討ち/追打ち/追撃ち/
おいえ /尾家/
おいえげい /お家芸/御家芸/御家藝/
おいえそうどう /御家騒動/
おいえりゅう /御家流/
おいおい /追い追い/追々/
おいかぜ /追い風/追風/
おいかわ /及川/追川/生川/
おいがつお /追い鰹/
おいけ /御池/
おいこし /追い越し/追越/追越し/
おいこしえき /追越駅/
おいこししゃせん /追越車線/
おいこみ /追い込み/追込/追込み/
おいこみうま /追い込み馬/追込み馬/
おいこん /追いコン/
おいごえ /追い肥/追肥/
おいさき /老い先/生い先/
おいしゃ /お医者/
おいしゃさま /お医者様/
おいしゃさん /お医者さん/
おいしょう /追証;追証拠金/
おいしょうこきん /追証拠金/
おいしんぼ /美味しんぼ/
おいせん /追い銭/追銭;盗人に-/
おいそぎ /お急ぎ/
おいたち /生い立ち/生立ち/
おいたて /追立て/
おいだき /追い炊き/追い焚/追炊き/
おいだし /追い出し/追出し/追出/
おいだしこんぱ /追い出しコンパ/
おいち /尾市/お市/
おいっこ /甥っ子/
おいつ /老津/
おいつおわれつ /追いつ追われつ/
おいて /於て/追風/於/
おいてきぼり /置いてきぼり/
おいてけぼり /置いてけ堀;ひどいや/
おいで /お出で/御出で/
おいとま /御暇/お暇/
おいのこぶみ /笈の小文;芭蕉/
おいのり /お祈り/
おいはぎ /追剥/追い剥ぎ/
おいはま /生浜/追浜/
おいばね /追羽根/
おいばらい /追い払い/
おいべ /及部/
おいぼし /追星;[生物]/
おいぼれ /老いぼれ/
おいまつ /老松/
おいまわし /追廻/追い回し;使い走り/追回し/
おいみどり /老緑/
おいめ /負い目/
おいめい /甥姪/
おいらく /老いらく/
おいらせ /奥入瀬/
おいらん /花魁/
おいろ /御色/
おいろけ /お色気/
おいろなおし /お色直し/御色直し/
おいわ /お岩;四谷怪談/
おいわい /お祝い/御祝/御祝い/
おいわけ /追分/
おいわけちょう /追分町/
おいわけぶし /追分節;[民謡]江差-/
おう /王/欧/翁/黄/横/皇;皇女/凰;鳳凰/惶;おそ・れる/応;応用/應;「応」の旧字(人名用漢字)/央;中央/怏/殃;余殃/泱/秧;さなえ/鞅;むながい/鴎;鴎外/嘔;嘔吐/歐;「欧」の旧字/殴;殴打/毆;「殴」の旧字/甌/謳;謳歌/奥/奧;「奥」の旧字(人名用漢字)/襖;ふすま/墺;墺太利(Austria)/懊;懊悩/澳;オキ/押;押収/鴨;かも/閘;閘門(こうもん)/往;往復/徃;「往」の異体字/旺;旺盛/枉;ま・げる/汪/桜;桜花/櫻;「桜」の旧字(人名用漢字)/嚶;嚶鳴/罌;罌粟/鸚;鸚鵡/凹;凹凸/媼;おうな/鴬;「鶯」の異体字/泓;ふかい/浤/瓮/蓊/鏖;鏖殺/姶/邑;(呉音) むら/悒;(呉音) 悒鬱/
おうあ /欧亜/歐亞/
おうあん /応安;年号(1368-1375)/
おうあんせき /王安石;1021-86/
おうい /王位/横位/王威/
おういけいしょう /王位継承/
おういけいしょうしゃ /王位継承者/
おういせん /王位戦/
おういつ /横溢/汪溢;=横溢/
おういん /押印/押韻/桜蔭/
おういんこうこう /桜蔭高校/
おういんご /欧印語/
おういんし /押韻詩;⇔無韻詩/
おうう /奥羽/
おううせん /奥羽線/
おううん /桜雲/
おうえ /黄衣/
おうえい /応永;年号(1394-1428)/
おうえん /応援/
おうえんえんぜつ /応援演説/
おうえんか /応援歌/
おうえんせき /応援席/
おうえんだん /応援団/
おうえんだんいん /応援団員/
おうえんだんちょう /応援団長/
おうえんぶ /応援部/
おうえんぶいん /応援部員/
おうえんよう /応援用/
おうお /大魚/
おうおう /往々;-にして/怏々;-として楽しまず/汪々;水・度量が広い/怏怏/
おうか /桜花/謳歌/押下/応化/欧化/王化/櫻花;「桜」旧字/
おうかがい /お伺い/
おうかく /旺角/凹角/
おうかくまく /横隔膜/横膈膜;本来の表記/
おうかざい /横架材;[建築]梁・桁・棟木など/
おうかしゅぎ /欧化主義/
おうかしょう /桜花賞/
おうかしょうぐみ /桜花賞組/
おうかしょうば /桜花賞馬/
おうかじ /押下時/
おうかっしょく /黄褐色/
おうからんまん /桜花爛漫/
おうかん /王冠/往還/
おうが /横臥/
おうがい /鴎外/
おうがく /王学;陽明学/
おうがた /凹型/
おうき /嘔気/応器/
おうきゅう /応急/王宮/
おうきゅうきゅうごしょち /応急救護処置/
おうきゅうしゅうり /応急修理/
おうきゅうしょち /応急処置/
おうきゅうそち /応急措置/
おうきゅうたいさく /応急対策/
おうきゅうてあて /応急手当/
おうきゅうてき /応急的/
おうぎ /扇/奥義;極意。「おくぎ」ともいう/奥儀;=奥義/横議;勝手に論議すること/
おうぎがた /扇形/
おうぎがやつ /扇ヶ谷/
おうぎさわ /扇沢/
おうぎし /王羲之;人名/
おうぎしょ /奥義書/
おうぎじょう /扇状/
おうぎや /扇谷/
おうぎょく /黄玉/
おうけ /王家/
おうけつ /甌穴/
おうけとり /お受け取り/
おうけん /王権/
おうけんしんじゅせつ /王権神授説/
おうげ /応化/
おうこ /往古/
おうこう /横行/王侯;王と諸侯/王公;王族と公族/王后;queen/往航;⇔復航/
おうこうかっぼ /横行闊歩/
おうこうかっぽ /横行闊歩/
おうこうきぞく /王侯貴族/
おうこく /王国/
おうご /朷/鶯語/
おうごん /黄金/
おうごんかいがん /黄金海岸;地名,/
おうごんかぶ /黄金株;株主総会の決議に拒否権を有する種類株/
おうごんき /黄金期/
おうごんきょう /黄金郷/
おうごんしゅうかん /黄金週間/
おうごんじだい /黄金時代/
おうごんすう /黄金数/
おうごんちゅう /黄金虫/
おうごんでんせつ /黄金伝説/
おうごんひ /黄金比/
おうごんもんじょ /黄金文書/
おうごんりつ /黄金律/
おうさか /逢坂/
おうさだはる /王貞治/
おうさつ /応札/殴殺;殴り殺す/鏖殺;みなごろし/
おうさま /王様/
おうざ /王座/
おうざけってい /王座決定/
おうざけっていせん /王座決定戦/
おうざせん /王座戦/
おうざだっかい /王座奪回/
おうざだっしゅ /王座奪取/
おうざてんらく /王座転落/
おうざとういつせん /王座統一戦/
おうざぼうえい /王座防衛/
おうし /雄牛/牡牛/横死/黄紙/
おうしかん /欧氏管/
おうしき /黄鐘/
おうしきちょう /黄鐘調/
おうしざ /牡牛座;Taurus(Tau),(4.20-5.20)/
おうしつ /王室/
おうしゃ /王者/
おうしゃじょう /王舎城;Rajagrha/
おうしゅ /応手/
おうしゅう /欧州/押収/応酬/奥州/欧洲/歐洲/歐州/
おうしゅうかいどう /奥州街道;千住-白河/
おうしゅうかっこく /欧州各国/
おうしゅうきょうどうたい /欧州共同体;European Community(EC)/
おうしゅうぎかい /欧州議会;European Parliament, Parlement Europeen/
おうしゅうけい /欧州系/
おうしゅうしじょう /欧州市場/
おうしゅうしゃ /欧州車/
おうしゅうしょこく /欧州諸国/
おうしゅうしよう /欧州仕様/
おうしゅうせい /欧州製/
おうしゅうせんしゅけん /欧州選手権/
おうしゅうぜい /欧州勢/
おうしゅうなみ /欧州並/
おうしゅうばん /欧州版/
おうしゅうふじわら /奥州藤原/
おうしゅうふじわらし /奥州藤原氏/
おうしゅうほうめん /欧州方面/
おうしゅうれんごう /欧州連合;European Union(EU),Union Europeen(UE) europa.eu.int/
おうしょ /押書/
おうしょう /王将/応召/応鐘;[音楽]/鞅掌;多忙/
おうしょうかい /王将会/
おうしょうぎむ /応召義務/
おうしょうくん /王昭君/
おうしょうせん /王将戦/
おうしょく /黄色/応嘱/
おうしょくじんしゅ /黄色人種/
おうしん /往診;⇔宅診/往信;⇔返信/
おうじ /王子/皇子;天皇の息子/往時/王寺/往事;昔のこと/王地/欧字/
おうじえき /王子駅/王寺駅/
おうじさま /王子様/
おうじせいし /王子製紙;[企業名]/
おうじせん /王子線/
おうじつ /往日/
おうじつせい /横日性/
おうじゃ /王者/
おうじゃく /往昔;=おうせき/
おうじやま /皇子山/
おうじゅ /応需/
おうじゅく /黄熟/
おうじゅほうしょう /黄綬褒章/
おうじょ /王女/皇女/
おうじょう /往生/王城/応情/
おうじょうぎわ /往生際/
おうじょうけん /応情研/応用情報学研究センター;※abbrev/
おうじょさま /王女様/
おうじん /応身/
おうじんてんのう /応神天皇/
おうす /御薄;薄茶/
おうすい /王水/
おうすう /応数/
おうせ /逢瀬/
おうせい /旺盛/王政/王制/応制/黄精/
おうせいふっこ /王政復古/
おうせいもう /黄青盲/
おうせき /往昔/
おうせつ /応接/
おうせつしつ /応接室/
おうせつせっと /応接セット/
おうせつま /応接間/
おうせん /応戦/横線/鏖戦/
おうせんこぎって /横線小切手/
おうぜん /汪然/
おうぜんじ /王禅寺/
おうそ /応訴/
おうそう /押送/
おうそうじ /大掃除;おおそうじ/
おうそうだん /応相談/
おうぞく /王族/
おうた /御歌/桜多/
おうたい /応対/黄体/横隊/
おうたいほるもん /黄体ホルモン;[生物]progesterone. 女性ホルモンの一/
おうたどころ /御歌所/
おうだ /殴打/
おうだく /応諾/黄濁/
おうだつ /横奪/
おうだん /横断/黄疸/応談/黄胆/黄丹/
おうだんか /応談可/
おうだんきょう /横断橋/
おうだんけんさく /横断検索/
おうだんちゅう /横断中/
おうだんてき /横断的/
おうだんほこうしゃ /横断歩行者/
おうだんほどう /横断歩道/
おうだんまく /横断幕/
おうだんめん /横断面/
おうち /樗/楝/お家/相知/邑智/欒/尾内/
おうちゃく /横着/
おうちゃくもの /横着者/
おうちょう /王朝/応長;年号(1311-1312)/
おうちょうじだい /王朝時代;奈良・平安/
おうちょうぶんがく /王朝文学/
おうて /追手/王手/
おうてい /奥底/
おうてき /横笛/
おうてっこう /黄鉄鉱/
おうてひしゃ /王手飛車/
おうてびしゃ /王手飛車/
おうてん /横転/
おうでん /応電/
おうでんけん /応電研/
おうと /嘔吐/王都/
おうとう /応答/桜桃/鴨東/王統/王党/櫻桃/
おうとうかんすう /応答関数/
おうとうき /桜桃忌;6／13/
おうとうきょくせん /応答曲線/
おうとうしゃ /応答者/
おうとうしゅっぱん /桜桃出版;[出版社名]/
おうとうしょぼう /桜桃書房/
おうとうしんごう /応答信号/
おうとうじかん /応答時間/
おうとうせい /応答性/
おうとうそくど /応答速度/
おうとうてき /応答的/
おうとうぶん /応答文/
おうとうや /応答野/
おうとく /応徳;年号(1084-1087)/
おうとつ /凹凸/
おうど /黄土/王土/
おうどいろ /黄土色/
おうどう /王道/横道/黄銅/黄道/横動/
おうどうこう /黄銅鉱/黄道光/
おうどうざひょう /黄道座標/
おうどうたい /黄道帯/
おうどうらくど /王道楽土/
おうな /媼/嫗/
おうなつ /押捺/
おうに /黄丹/
おうにん /応仁/
おうにんのらん /応仁の乱/
おうねつびょう /黄熱病/
おうねん /往年/
おうのう /懊悩/応能/
おうはん /黄斑/凹版/往反/
おうばい /黄梅/
おうばく /黄檗/黄蘗/
おうばくさん /黄檗山/
おうばくし /黄蘗紙/
おうばくしゅう /黄檗宗/
おうばくばん /黄檗版/
おうばん /黄幡;[陰陽道]八将神の一。羅ゴ星/
おうばんが /凹版画/
おうばんぶるまい /椀飯振舞/椀飯振舞い/椀飯振る舞い/
おうひ /王妃/奥秘/応否/横披/横被/
おうびゃく /黄白/
おうびりん /桜美林/
おうびりんこうこう /桜美林高校/
おうびりんだいがく /桜美林大学/
おうふ /王父/
おうふう /欧風/
おうふく /往復/
おうふくきっぷ /往復切符/
おうふくこうくうけん /往復航空券/
おうふくじかん /往復時間/
おうふくじょうしゃけん /往復乗車券/
おうふくにじかん /往復二時間/
おうふくはがき /往復葉書/
おうふくはん /往復半/
おうふくびんた /往復ビンタ/
おうふくよう /往復用/
おうふくわり /往復割/
おうふくわりびき /往復割引/
おうふくわりびききっぷ /往復割引切符/
おうぶつ /応物/応用物理;※abbrev/
おうぶん /欧文/応分/
おうぶんし /欧文誌/
おうぶんしゃ /旺文社;[出版社名]/
おうぶんしゃぶんこ /旺文社文庫/
おうへい /横柄/
おうへん /黄変/応変;臨機-/往返/往反;=往返/王偏/
おうべい /欧米/
おうべいがた /欧米型/
おうべいけい /欧米系/
おうべいしき /欧米式/
おうべいしょこく /欧米諸国/
おうべいじん /欧米人/
おうべいば /欧米馬/
おうべいれっきょう /欧米列強/
おうほう /応報/王法/往訪/応保;年号(1161-1163)/應報;「応」旧字/
おうぼ /応募/王母/
おうぼう /横暴/王法/
おうぼきかん /応募期間/
おうぼけん /応募券/
おうぼさくひん /応募作品/
おうぼしかく /応募資格/
おうぼしめきり /応募締切/
おうぼしめきりご /応募締切後/
おうぼしゃ /応募者/
おうぼしゃしめい /応募者氏名/
おうぼしゃぜんいん /応募者全員/
おうぼしゃたすう /応募者多数/
おうぼしゃりまわり /応募者利回り/
おうぼしょるい /応募書類/
おうぼしょるいざいちゅう /応募書類在中/
おうぼじょうきょう /応募状況/
おうぼすう /応募数/
おうぼそうすう /応募総数/
おうぼたすう /応募多数/
おうぼないよう /応募内容/
おうぼはがき /応募葉書/
おうぼばこ /応募箱/
おうぼほうほう /応募方法/
おうぼよう /応募用/
おうぼようこう /応募要項/
おうぼようし /応募用紙/
おうぼりゆう /応募理由/
おうま /逢魔/お馬/黄麻/
おうまがとき /逢魔が刻/
おうまし /黄麻紙/
おうみ /近江/青海/
おうみいまずえき /近江今津駅/
おうみいまづ /近江今津/
おうみいまづえき /近江今津駅/
おうみしおつ /近江塩津/
おうみしおつかん /近江塩津間/
おうみしおづ /近江塩津/
おうみしま /青海島;地名,山口県/
おうみじ /近江路/
おうみちょうしじょう /近江町市場/
おうみてつどう /近江鉄道/
おうみはちまん /近江八幡/
おうみまいこ /近江舞子/
おうむ /鸚鵡/雄武/王蟲;[アニメ]『風の谷のナウシカ』/
おうむがい /鸚鵡貝/
おうむがえし /鸚鵡返し/おうむ返し/
おうむしんりきょう /オウム真理教/
おうむちょう /雄武町/
おうむびょう /鸚鵡病/オウム病/
おうめ /青梅/
おうめい /王命/
おうめえき /青梅駅/
おうめかいどう /青梅街道/
おうめし /青梅市/
おうめしゃこ /青梅車庫/
おうめせん /青梅線/
おうめとっかい /青梅特快/
おうめん /凹面/
おうめんきょう /凹面鏡/
おうもう /王莽;BC45-AD23/
おうもんきん /横紋筋/
おうゆう /鴎友/
おうゆうがくえん /鴎友学園/
おうよう /応用/鷹揚/應用;旧字/
おうよう> /応用;-科学,-数学/
おうようおんきょう /応用音響/
おうようか /応用可/
おうようかいせき /応用解析/
おうようかがく /応用科学/
おうようかがくか /応用化学科/
おうようかんれん /応用関連/
おうようがっかい /応用学会/
おうようきのう /応用機能/
おうようぎじゅつ /応用技術/
おうようぎじゅつぶ /応用技術部/
おうようけんきゅう /応用研究/
おうようけんきゅうしつ /応用研究室/
おうようけんきゅうじょ /応用研究所/
おうようげんごがく /応用言語学/
おうようしゅう /欧陽脩;1007-72/
おうようしんりがく /応用心理学;applied psychology/
おうようじょう /応用上/
おうようじょうほう /応用情報/
おうようじょうほうがく /応用情報学/
おうようすうがく /応用数学/
おうようすうがくか /応用数学科/
おうようすうがっか /応用数学科/
おうようすうり /応用数理/
おうようせい /応用性/
おうようせいひん /応用製品/
おうようせいめい /応用生命/
おうようそう /応用層/
おうようてき /応用的/
おうようてきのうりょく /応用的能力/
おうようでんし /応用電子/
おうようはんい /応用範囲/
おうようびじゅつ /応用美術/
おうようぶつり /応用物理/
おうようぶつりがく /応用物理学/
おうようぶつりがっか /応用物理学科/
おうようぶつりがっかい /応用物理学会/
おうようぶんや /応用分野/
おうようへん /応用編/
おうようめい /王陽明;(1472-1528) 大儒/
おうようめん /応用面/
おうようもんだい /応用問題/
おうようりきがく /応用力学/
おうようりょういき /応用領域/
おうようりょく /応用力/
おうようれい /応用例/
おうら /邑楽/
おうらい /往来/
おうらいもの /往来物/
おうりつ /王立/
おうりつがっかい /王立学会/
おうりゅう /横流/
おうりょう /横領/押領;統率/
おうりょうき /応量器/
おうりょうざい /横領罪/
おうりょうし /押領使/
おうりょく /応力/
おうりょくこう /鴨緑江;地名/
おうりょくしょく /黄緑色/
おうりょくど /応力度/
おうりん /黄燐/
おうれつ /横列/
おうれつか /横裂果/
おうれん /黄蓮/黄連/
おうれんあか /オウレン亜科/Coptidoideae/
おうれんず /凹レンズ;concave lens/
おうろ /往路/欧露/
おうわ /応和;年号(961-964)/
おえ /小江/汚穢/
おえかき /お絵描き/お絵かき/お絵書き/
おえつ /嗚咽/
おえどにほんばし /お江戸日本橋;古謡.「♪-七つ立ち」/
おえらがた /お偉方/御偉方/
おお /大/多/夛;「多」の異体字/
おお> /大/
おおあえ /大饗/
おおあかじ /大赤字/
おおあきない /大商い;大きな商い。主に株式市場で使う。/
おおあきんど /大商人;seth/
おおあさ /大朝/大麻/
おおあざ /大字/
おおあし /大足/
おおあじ /大味/
おおあせ /大汗/
おおあたま /大頭;bighead/巨頭/
おおあたり /大当り/大当たり/
おおあな /大穴/
おおあね /大姉/
おおあばれ /大暴れ/
おおあま /大甘/
おおあまのおうじ /大海人皇子/
おおあみ /大網/
おおあみえき /大網駅/
おおあめ /大雨/
おおあめけいほう /大雨警報/
おおあめこうずいけいほう /大雨洪水警報/
おおあめちゅういほう /大雨注意報/
おおあらい /大洗/
おおあり /大有り/
おおありくい /大蟻食;ant bear/
おおあれ /大荒れ/
おおあわ /粱/
おおあわて /大慌て/
おおい /覆い;cover/大井/大飯/大炊/
おおいえ /大家/
おおいがわ /大井川/
おおいがわてつどう /大井川鉄道/
おおいけ /大池/
おおいけいば /大井競馬/
おおいし /大石/
おおいしだ /大石田/
おおいずみ /大泉/
おおいずみがくえん /大泉学園/
おおいずみがくえんちょう /大泉学園町/
おおいそ /大磯/
おおいそがし /大忙し/
おおいそぎ /大急ぎ/
おおいた /大分/大板/
おおいたかん /大分間/
おおいたけん /大分県/
おおいたけんみん /大分県民/
おおいたこうつう /大分交通/
おおいたし /大分市/
おおいたしない /大分市内/
おおいたたいかい /大分大会/
おおいただい /大分大/
おおいただいがく /大分大学/
おおいたべん /大分弁/
おおいたほうそう /大分放送/
おおいち /大市/
おおいちばん /大一番/
おおいちもんじ /大一文字/
おおいちょう /大銀杏/大井町/大堰町/
おおいと /大糸/
おおいとせん /大糸線/
おおいど /大井戸/
おおいなる /大いなる/
おおいに /大いに/
おおいぬざ /大犬座;Canis Major(CMa)/
おおいのかみ /大炊頭/
おおいばり /大威張り/
おおいまち /大井町/
おおいまちせん /大井町線/
おおいまちほうめん /大井町方面/
おおいむさしのかん /大井武蔵野館/
おおいり /大入り/大入/
おおいりぶくろ /大入り袋/大入袋/
おおいわ /大岩/
おおう /奥羽/
おおうえ /大上/
おおうずまき /大渦巻/
おおうそ /大嘘/大ウソ/
おおうたどころ /大歌所;[律令制]/
おおうだ /大宇陀/
おおうち /大内/
おおうちがり /大内刈り/
おおうちどおり /大内通/
おおうちばん /大内版/
おおうちやま /大内山/
おおうつし /大写し/
おおうなばら /大海原/
おおうほんせん /奥羽本線/
おおうら /大浦/
おおうらてんしゅどう /大浦天主堂/
おおうらわざ /大裏技/
おおうりだし /大売り出し/大売出し/
おおえ /大江/大兄/
おおえけんざぶろう /大江健三郎;作家。『万延元年のフットボール』/
おおえせんり /大江千里/
おおえちょう /大江町/
おおえど /大江戸/
おおえどせん /大江戸線/
おおえどそうさもう /大江戸捜査網/
おおえどはなび /大江戸花火/
おおえのき /大榎/
おおえのちさと /大江千里;月みれば ちぢに物こそ かなしけれ わが身ひとつの 秋にはあらねど/
おおえのまさふさ /大江匡房;(1041-1111) 『江談抄』/
おおえやま /大江山/
おおおか /大岡/
おおおかえちぜん /大岡越前/
おおおかさばき /大岡裁き;人情的な裁定/
おおおかやま /大岡山/
おおおかやまえき /大岡山駅/
おおおく /大奥/
おおおくさま /大奥様/
おおおじ /大叔父;祖父母の弟/大伯父;祖父母の兄/従祖父/
おおおとこ /大男/
おおおば /大叔母;祖父母の妹/大伯母;祖父母の姉/従祖母/
おおおみ /大臣/
おおおやぶん /大親分/
おおおんな /大女/
おおかがみ /大鏡;作品名/
おおかじ /大火事/大鍛冶/
おおかぜ /大風/
おおかた /大方;-片付いた/大片;人名?/
おおかたびら /大帷子/
おおかながい /大金貝/大金書/
おおかぶぬし /大株主/
おおかべ /大壁/
おおかみ /狼/大神/
おおかみうお /狼魚/
おおかみおとこ /狼男/
おおかみおんな /狼女/
おおかみざ /狼座;Lupus(Lup)/
おおかみしょうねん /狼少年/
おおかめ /狼/
おおかれ /多かれ/
おおかれすくなかれ /多かれ少なかれ/
おおかわ /大川/大河/大鼓;おおつづみ/大革;おおつづみ/
おおかわかん /大川間/
おおかわぐち /大川口/
おおかわこうぎょう /大川興業;[企業名]/
おおかわばた /大川畑/
おおかわら /大河原/
おおかん /大缶/
おおかんだ /大神田/
おおが /大賀/大鋸/
おおがい /頁;[部首]「顔」/大貝/
おおがえし /大返し/
おおがかり /大掛かり/大掛り/大がかり/
おおがき /大垣/大柿/大書/
おおがきえき /大垣駅/
おおがきほうめん /大垣方面/
おおがきやこう /大垣夜行/
おおがけ /大駆/
おおがた /大型/大形;=大型/大方;地名/大潟;地名,秋田/
おおがたうちゅうせん /大型宇宙船/
おおがたえいが /大型映画/
おおがたえいぞう /大型映像/
おおがたか /大型化/
おおがたかぶ /大型株/
おおがたかもつ /大型貨物/
おおがたかもつしゃ /大型貨物車/
おおがたかんせつぜい /大型間接税/
おおがたき /大型機/
おおがたきかい /大型機械/
おおがたきょうたい /大型筐体/
おおがたぎょ /大型魚/
おおがたけいさんき /大型計算機/
おおがたけいさんきせんたー /大型計算機センター/
おおがたけん /大型犬/
おおがたけんいん /大型牽引/
おおがたさんきゃく /大型三脚/
おおがたしゃ /大型車/
おおがたしゃりょう /大型車両/
おおがたしょてん /大型書店/
おおがたじどう /大型自動/
おおがたじどうにりん /大型自動二輪/
おおがたじゅう /大型獣/
おおがたじょうようしゃ /大型乗用車/
おおがたせん /大型船/
おおがたせんしゅ /大型選手/
おおがたせんぱく /大型船舶/
おおがたちゅうしゃじょう /大型駐車場/
おおがたつりぐてん /大型釣具店/
おおがたてん /大型店/
おおがたとくしゅ /大型特殊/
おおがたにりん /大型二輪/
おおがたはんようき /大型汎用機/
おおがたば /大型馬/
おおがたひこうき /大型飛行機/
おおがたぼん /大型本/
おおがたまど /大型窓/
おおがためんきょ /大型免許/
おおがたれんきゅう /大型連休/
おおがち /大勝ち/
おおがね /大金/大鐘/
おおがねもち /大金持ち/大金持/
おおがみ /大神/
おおがめ /鰲/
おおがら /大柄/
おおがらす /大鴉/
おおがわら /大河原/
おおき /大木/大城/
おおきい /大きい/
おおきさ /大きさ/
おおきさいのみや /皇太后宮/
おおきすめらみこと /太上天皇/
おおきた /大北/
おおきど /大木戸/
おおきな /大きな/
おおきに /大きに/
おおきみ /大君/
おおきめ /大き目/大きめ/
おおぎ /扇;おうぎ/青木/仰木/
おおぎがた /扇型/
おおぎがはら /扇ヶ原/
おおぎし /大岸/
おおぎたに /扇谷/
おおぎばし /扇橋/
おおぎまち /扇町/
おおぎまちこうえん /扇町公園/
おおぎみ /大宜味/
おおぎょう /大仰/大形;≒大仰/
おおぎり /大喜利/大切り/
おおく /多く/
おおくずれ /大崩れ/
おおくち /大口/
おおくちばかま /大口袴/
おおくに /大国/
おおくにぬしのかみ /大国主神/
おおくにぬしのみこと /大国主命/
おおくび /衽/
おおくびえ /大首絵/
おおくぼ /大久保/大窪/
おおくぼえき /大久保駅/
おおくぼどおり /大久保通り/
おおくま /大熊/大隈/逢隈/
おおくまざ /大熊座/
おおくましげのぶ /大隈重信/
おおくら /大倉/大蔵/
おおくらしょう /大蔵省;NB:2001年1月の中央省庁再編で財務省に再編された/
おおくらしょうしょうけん /大蔵省証券/
おおくらだいじん /大蔵大臣/
おおくらやま /大倉山/
おおくり /お送り/
おおくわ /大桑/
おおぐい /大食い;痩せの-/大喰い/
おおぐし /大串/
おおぐす /大楠/
おおぐち /大口/
おおぐちこうにゅう /大口購入/
おおぐちさいけんしゃ /大口債権者/
おおぐちしゅっししゃ /大口出資者/
おおぐまざ /大熊座;Ursa Major(UMa)/
おおぐれ /大暮/
おおぐろ /大黒/
おおけが /大怪我;(当て字)/大けが/大ケガ/
おおげさ /大袈裟/大げさ/
おおげんか /大喧嘩/
おおこうち /大河内/
おおこし /大越;人名/
おおこめ /大米/
おおご /大胡/大湖/
おおごえ /大声/大越;地名,福岡県/
おおごし /大腰/
おおごしょ /大御所/
おおごしょじだい /大御所時代;1804-30/
おおごと /大事/
おおごま /大駒/
おおごんはくぶつかん /黄金博物館/
おおさ /大佐/
おおさか /大阪/大坂;†/逢坂;※仮名遣い「おうさか」/
おおさかいかだいがく /大阪医科大学/
おおさかいがい /大阪以外/
おおさかいだい /大阪医大/
おおさかいちりつだいがく /大阪市立大学/
おおさかうめだ /大阪梅田/
おおさかえき /大阪駅/
おおさかえきまえ /大阪駅前/
おおさかおうしょう /大阪王将/
おおさかかん /大阪間/
おおさかかんじょうせん /大阪環状線/
おおさかがいこくごだいがく /大阪外国語大学;www.osaka-gaidai.ac.jp/
おおさかがくいん /大阪学院/
おおさかがす /大阪ガス;[企業名]www.osakagas.co.jp/大阪瓦斯;[企業名]/
おおさかがわ /大阪側/
おおさかきたこう /大阪北港/
おおさかきゅうじょう /大阪球場/
おおさかきょういくだい /大阪教育大/
おおさかきょういくだいがく /大阪教育大学/
おおさかきんこう /大阪近郊/
おおさかぎじゅつ /大阪技術/
おおさかくうこう /大阪空港/
おおさかけい /大阪系/
おおさかけいざいだいがく /大阪経済大学/
おおさかげいだい /大阪芸大/
おおさかげいにん /大阪芸人/
おおさかこう /大阪港/大阪校/
おおさかこうえん /大阪公演/
おおさかこうぎょうだいがく /大阪工業大学/
おおさかこうせいねんきん /大阪厚生年金/
おおさかこうだい /大阪工大/
おおさかこうべかん /大阪神戸間/
おおさかこくさいくうこう /大阪国際空港/
おおさかこくさいこうりゅう /大阪国際交流/
おおさかこくぜいきょく /大阪国税局/
おおさかさやま /大阪狭山/
おおさかさんぎょうだい /大阪産業大/
おおさかさんぎょうだいがく /大阪産業大学/
おおさかさんだい /大阪産大/
おおさかし /大阪市/
おおさかしえい /大阪市営/
おおさかしがい /大阪市街/
おおさかしこう /大阪市交/
おおさかししゃ /大阪支社/
おおさかしだい /大阪市大/
おおさかしちかてつ /大阪市地下鉄/
おおさかしてん /大阪支店/
おおさかしでん /大阪市電/
おおさかしない /大阪市内/
おおさかしゃかいぶ /大阪社会部/
おおさかしょうぎょうだいがく /大阪商業大学/
おおさかしょうけんとりひきじょ /大阪証券取引所;大証/
おおさかしょうちくざ /大阪松竹座/
おおさかしょてん /大阪書店/
おおさかしりつだいがく /大阪市立大学/
おおさかじぎょうしょ /大阪事業所/
おおさかじょう /大阪城/
おおさかじょうこうえん /大阪城公園/
おおさかじん /大阪人/
おおさかせめんと /大阪セメント/
おおさかせん /大阪線/
おおさかたいいくだいがく /大阪体育大学/
おおさかたいかい /大阪大会/
おおさかだい /大阪大/
おおさかだいがく /大阪大学/
おおさかちかてつ /大阪地下鉄/
おおさかちほう /大阪地方/
おおさかちゃく /大阪着/
おおさかてき /大阪的/
おおさかてん /大阪店/
おおさかでんつうだい /大阪電通大/
おおさかとういん /大阪桐蔭/
おおさかなんば /大阪難波/
おおさかなんぶ /大阪南部/
おおさかにほんばし /大阪日本橋/
おおさかねやがわ /大阪寝屋川/
おおさかはい /大阪杯/
おおさかはつ /大阪発/
おおさかばしょ /大阪場所/
おおさかばん /大阪版/
おおさかばんぱく /大阪万博/
おおさかふ /大阪府/
おおさかふう /大阪風/
おおさかふけい /大阪府警/
おおさかふだい /大阪府大/
おおさかふみん /大阪府民/
おおさかふりつ /大阪府立/
おおさかふりつだい /大阪府立大/
おおさかふりつだいがく /大阪府立大学/
おおさかべん /大阪弁/
おおさかほうめん /大阪方面/
おおさかほか /大阪他/
おおさかほんしゃ /大阪本社/
おおさかみやげ /大阪土産/
おおさかめいぶつ /大阪名物/
おおさかやま /逢坂山/
おおさかわん /大阪湾/
おおさき /大崎/
おおさこ /大迫/
おおさじ /大匙/大さじ/
おおさと /大里/大郷/
おおさま /王様/
おおさめ /お納め/
おおさわ /大沢/大澤/
おおさわぎ /大騒ぎ/
おおさわの /大沢野/
おおさんしょううお /大山椒魚/
おおさんばし /大棧橋/大桟橋/
おおざけ /大酒/
おおざけのみ /大酒飲み/
おおざっぱ /大雑把/
おおざと /大里/
おおざはた /大座畑/
おおざら /大皿/
おおし /凡/
おおしお /大潮/大塩/
おおしおへいはちろう /大塩平八郎/
おおしか /大鹿/
おおしけ /大時化/
おおしげ /大重/
おおしこうちのみつね /凡河内躬恒;心あてに 折らばや折らむ 初霜の おきまどはせる 白菊の花/
おおしごと /大仕事/
おおした /大下/
おおしば /大柴/大芝/
おおしま /大島/大嶋/
おおしましょうせんこうせん /大島商船高専/
おおしまちょう /大島町/
おおしまつむぎ /大島紬/
おおしまぶし /大島節;[民謡]伊豆/
おおしみず /大清水/
おおしょうぎ /大将棋/
おおしょうぶ /大勝負/
おおしろ /大城/
おおじ /大路/祖父/王寺/
おおじか /大鹿/麋/
おおじしん /大地震/
おおじだい /大時代/
おおじぬし /大地主/
おおじま /大島/
おおじょたい /大所帯/大世帯/
おおす /大須/
おおすか /大須賀/
おおすが /大須賀/
おおすぎ /大杉/
おおすぎさかえ /大杉栄;(1885-1923) アナーキスト/
おおすじ /大筋/
おおすず /大鈴/
おおすみ /大隅/大住/大角/
おおすみせん /大隅線/
おおすみはんとう /大隅半島/
おおず /大洲/
おおずもう /大相撲/
おおずわ /大諏訪/
おおせ /大瀬/仰せ/
おおせいだされしょ /被仰出書/
おおせざき /大瀬崎/
おおせと /大瀬戸/
おおぜい /大勢/
おおぜき /大関/
おおぜきしょうしん /大関昇進/
おおぜきじん /大関陣/
おおそうじ /大掃除/
おおそうじちゅう /大掃除中/
おおそうどう /大騒動/
おおそが /大曽我/
おおそこ /大底/
おおそと /大外/
おおそとがり /大外刈り/大外刈/
おおそとわく /大外枠/
おおそね /大曽根;姓/
おおその /大園/
おおぞこ /大底/
おおぞね /大曽根/
おおぞら /大空/
おおぞん /大損/
おおた /太田;(ふとい)/大田;(おおきい)/
おおたいさん /太田胃散/
おおたか /大高/大鷹/
おおたがき /大田垣/
おおたがわ /太田川/
おおたがわばし /太田川橋/
おおたき /大滝/大多喜/大瀧/王滝/
おおたきむら /王滝村/
おおたく /大田区/
おおたくたいいくかん /大田区体育館/
おおたくひがしゆきがや /大田区東雪谷/
おおたぐろ /太田黒/
おおたけ /大竹/大嶽/大武/大丈/
おおたけしのぶ /大竹しのぶ/
おおたし /太田市/
おおたしゅっぱん /太田出版;[出版社名]/
おおたち /大立/
おおたちまわり /大立ち回り;-を演じる/大立回り/
おおたてもの /大立者/
おおたなんぽ /大田南畝;(1749-1823) =蜀山人/
おおたに /大谷/
おおたにやき /大谷焼/
おおたひろみ /太田裕美/
おおたま /大玉/
おおたわら /大田原/
おおたわらし /大田原市/
おおだ /大田/
おおだい /大台/
おおだいこ /大太鼓/
おおだか /大高/
おおだけ /大岳/
おおだこ /大凧/大ダコ/
おおだすかり /大助かり/
おおだち /大立/大館/
おおだて /大館/
おおだてもの /大立者/大立て者/
おおだな /大店/
おおだま /大玉/
おおだんな /大旦那/
おおち /邑智/
おおちがい /大違い/
おおっぴら /大っぴら/
おおつ /大津/
おおつえ /大津絵/
おおつか /大塚/大束/
おおつかあきら /大塚明/
おおつかえき /大塚駅/
おおつかかん /大塚間/
おおつかさ /大学寮;[律令制]/
おおつかせいやく /大塚製薬;[企業名]/
おおつが /大津賀/
おおつき /大月/大槻/大附/大津寄;姓/大規/
おおつきしょてん /大月書店;[出版社名]マルクス主義。www.otsukishoten.co.jp/
おおつごもり /大晦/大晦日/
おおつし /大津市/
おおつしがい /大津市街/
おおつしない /大津市内/
おおつせん /大津線/
おおつち /大槌/
おおつちわん /大槌湾/
おおつなみ /大津波/
おおつの /大角/
おおつぶ /大粒/
おおつぼ /大坪/大壺/
おおつま /大妻/
おおつまこうこう /大妻高校/
おおつまじょしだい /大妻女子大/
おおつやま /大津山/
おおつる /大鶴/
おおづ /大津/
おおづかみ /大掴み/
おおづくり /大作り/
おおづつ /大筒/
おおづな /大綱/
おおづめ /大詰め/大詰/
おおて /大手/
おおてい /大体/
おおてきぎょう /大手企業/
おおてぎんこう /大手銀行/
おおてしてつ /大手私鉄/
おおてしゅっぱんしゃ /大手出版社/
おおてしょうよう /大手商用/
おおてしょてん /大手書店/
おおてしんぶん /大手新聞/
おおてすーぱー /大手スーパー/
おおてすじ /大手筋/
おおてせきゆがいしゃ /大手石油会社/
おおてでんきがいしゃ /大手電気会社/
おおてまち /大手町/
おおてみんてつ /大手民鉄/
おおてもん /大手門/
おおてら /大寺/
おおてりょこうがいしゃ /大手旅行会社/
おおてる /大照/
おおてんじょう /大天井/
おおで /大手/
おおでき /大出来/
おおとう /大塔/大任/
おおとかげ /大蜥蜴/
おおとね /大利根/
おおとの /大殿/
おおとのごもり /大殿籠り;[文語]貴人が寝ること/
おおとのさま /大殿様/
おおとも /大伴/大友/
おおともい /弁/
おおともいのつかさ /弁官;[律令制]文書官/
おおともそうりん /大友宗麟/
おおとものやかもち /大伴家持;717?-785/
おおとよ /大豊/
おおとり /大鳥/鳳/鴻/鵬/
おおとりい /大鳥居/
おおとりじんじゃ /大鳥神社/
おおとりじんじゃまえ /大鳥神社前/
おおとろ /大トロ/
おおど /大戸/
おおどう /大胴;おおつづみ/
おおどうぐ /大道具/
おおどおり /大通り/大通/
おおどけい /大時計/
おおどころ /大所/
おおどしま /大年増/
おおどまり /大泊/
おおな /大名/
おおなえ /大苗/
おおなかぐろ /大中黒/
おおなかとみのよしのぶ /大中臣能宣;みかきもり 衛士のたく火の 夜はもえ 昼は消えつつ 物をこそ思へ/
おおなき /大泣き/
おおなた /大鉈/大ナタ/
おおなべ /大鍋/
おおなみ /大波/大浪/
おおなみこなみ /大波小波/
おおなめ /大滑/
おおなめまつり /大嘗祭/
おおなんじ /大汝/
おおにえ /大嘗/
おおにぎわい /大賑わい/
おおにし /大西/
おおにしまち /大西町/
おおにた /大仁田/
おおにもつ /大荷物/
おおにわ /大庭/
おおにんずう /大人数/
おおぬき /大貫/
おおぬま /大沼/
おおぬまこうえん /大沼公園/
おおね /大根/
おおねじめ /大根占/
おおねた /大ネタ/
おおねだ /大根田/
おおの /大野/
おおのくに /大乃国/
おおのじょう /大野城/
おおのみ /大野見/
おおのやすまろ /太安万侶;古事記/
おおはさ /大迫/
おおはざま /大間/
おおはし /大橋/
おおはしきょせん /大橋巨泉/
おおはしゃぎ /大はしゃぎ/
おおはじ /大恥/
おおはずれ /大外れ/大ハズレ/
おおはた /大畑/大畠/
おおはたせん /大畑線/
おおはなび /大花火/
おおはば /大幅/
おおはばげん /大幅減/
おおはばげんぜい /大幅減税/
おおはばぞう /大幅増/
おおはばだか /大幅高/
おおはばねびき /大幅値引き/
おおはばひきさげ /大幅引下げ/
おおはばへんこう /大幅変更/
おおはばやす /大幅安/
おおはま /大浜/大濱/
おおはやり /大流行/大流行り/
おおはら /大原/
おおはらい /大祓/
おおはらえ /大祓/
おおはらさんぜんいん /大原三千院/
おおはらそうどう /大原騒動/
おおはらの /大原野/
おおはらほうめん /大原方面/
おおはり /大梁/
おおはる /大治/
おおば /大葉/大場/大庭/大羽/祖母/
おおばか /大馬鹿/大バカ/
おおばかもの /大馬鹿者/大莫迦者/
おおばかやろう /大馬鹿野郎/
おおばくち /大博打;一世一代の-/
おおばけ /大化け/
おおばこ /大箱/車前;[植物]plantain/車前草;=車前/大葉子;=車前/
おおばたけ /大畠/
おおばな /大花/
おおばやし /大林/
おおばん /大判/大番/大盤/大版/
おおばんくるわせ /大番狂わせ/
おおばんぶるまい /大盤振る舞い/大盤振舞/大盤振舞い/
おおばんやき /大判焼/
おおばんよう /大判用/
おおひさ /大久/
おおひと /大仁/
おおひとちょう /大仁町/
おおひやき /大樋焼/
おおひら /大平/大衡/
おおひらだい /大平台/
おおひらちょう /大平町/
おおひらむら /大衡村/
おおひろ /大広/
おおひろま /大広間/
おおびき /大引/
おおびけ /大引け/
おおびゃくしょう /大百姓/
おおびん /大瓶/大壜/
おおふか /大深/
おおふく /大福/
おおふな /大船/
おおふなえき /大船駅/
おおふなと /大船渡/
おおふなとせん /大船渡線/
おおふね /大舟/
おおふろしき /大風呂敷/
おおぶ /大府/
おおぶえき /大府駅/
おおぶくろ /大袋/
おおぶたい /大舞台/
おおぶち /大渕/大淵/
おおぶね /大船/
おおぶり /大振り;†「HR狙いの-」「-の器」/大降り;†「-の雨」/
おおぶろしき /大風呂敷/
おおべや /大部屋/
おおほ /大穂/
おおほり /大堀/大濠/
おおほりこうえん /大濠公園/
おおほん /大本/
おおぼうしょ /大奉書/
おおぼけ /大歩危;地名,徳島/大ボケ/大ぼけ/
おおぼけこぼけ /大歩危小歩危;地名,徳島/
おおぼし /大星/
おおぼね /大骨/
おおぼら /大ボラ/
おおぽか /大ポカ/
おおま /大間/
おおまえ /大前/
おおまか /大まか/
おおまがき /大間書/
おおまがとき /大禍時/
おおまがり /大曲/
おおまがりかん /大曲間/
おおまがりせん /大曲線/
おおまき /大蒔/
おおまけ /大負け/
おおまじめ /大真面目/
おおまた /大股/
おおまち /大町/
おおまちえき /大町駅/
おおまちがい /大間違い/
おおまつ /大松/
おおまと /大的/
おおまど /大窓/
おおまぬけ /大間抜け/大間抜/
おおまま /大間々/
おおまみゅうだ /大豆生田;人名/
おおまゆ /大眉/
おおまわり /大回り/
おおまんどころ /大政所/
おおみ /大見/大身/
おおみえ /大見得/
おおみか /大甕/
おおみかみ /大御神/
おおみき /大御酒/
おおみしま /大三島/
おおみず /大水/
おおみそか /大晦日/
おおみぞ /大溝/
おおみだし /大見出し/
おおみち /大道/
おおみつ /大光/
おおみなと /大湊/
おおみなとせん /大湊線/
おおみね /大峰/
おおみや /大宮/
おおみやえき /大宮駅/
おおみやえきまえ /大宮駅前/
おおみやかん /大宮間/
おおみやこうじょう /大宮工場/
おおみやごしょ /大宮御所/
おおみやし /大宮市/
おおみやすんどころ /大御息所/
おおみやせん /大宮線/
おおみやちょう /大宮町/
おおみよ /大御代/
おおみら /薤/
おおみわじんじゃ /大神神社/
おおむ /御/
おおむかし /大昔/
おおむぎ /大麦/
おおむこう /大向こう/大向う/
おおむた /大牟田/
おおむね /概ね/概/大棟;[建築]寄棟 >—< で — を形成する棟/大旨;=概(ね)/
おおむら /大村/
おおむらさき /大紫/
おおむらじ /大連/
おおむらせん /大村線/
おおむらわん /大村湾/
おおむろ /大室/
おおめ /大目;-に見る/多め/多目/
おおめし /大飯/
おおめしぐらい /大飯食らい/
おおめだま /大目玉/
おおめつけ /大目付/
おおもじ /大文字/
おおもじえいじ /大文字英字/
おおもじえいすうじ /大文字英数字/
おおもじか /大文字化/
おおもじこもじ /大文字小文字/
おおもと /大本/大元/
おおもときょう /大本教/
おおもの /大物/
おおものかしゅ /大物歌手/
おおものかん /大物感/
おおものじょせい /大物女性/
おおもめ /大揉め/
おおもも /大桃/
おおもり /大盛り/大盛/大森/
おおもりえき /大森駅/
おおもりく /大森区/
おおもん /大門/
おおや /大家/大屋/大谷/大矢/大宅/
おおやかず /大矢数/
おおやぎ /大八木/大谷木/
おおやけ /公/大宅/
おおやけごと /公事/
おおやけど /大火傷/
おおやしろ /大社;出雲大社/
おおやしろづくり /大社造り;[建築]=たいしゃづくり/大社造;[建築]=たいしゃづくり/
おおやす /大保/
おおやすうり /大安売り/大安売/
おおやち /大矢知/
おおやね /大屋根;[建築]/
おおやの /大矢野/
おおやま /大山/
おおやまえき /大山駅/
おおやまぐち /大山口/
おおやまざき /大山崎/
おおやまだ /大山田/
おおやまちょう /大山町/
おおやまと /大日本/大倭/
おおやまねこ /大山猫/
おおやままち /大山町/
おおやまやすはる /大山康晴/
おおやん /欧陽/
おおゆ /大湯/
おおゆか /大床/
おおゆき /大雪/
おおゆきけいほう /大雪警報/
おおゆきちゅういほう /大雪注意報/
おおゆみ /大弓/
おおよう /大様/
おおよせ /大寄/大寄せ/
おおよそ /凡そ/大凡/
おおよど /大淀/
おおよろこび /大喜び/
おおよわり /大弱り/
おおらか /大らか;generous/多らか;<rare>/
おおわ /大輪/
おおわき /大脇/
おおわく /大枠/大和久/
おおわざ /大技/
おおわし /大鷲/
おおわだ /大和田/大輪田/
おおわだちょう /大和田町/
おおわだばく /大和田獏/
おおわに /大鰐/
おおわらい /大笑い/
おおわらわ /大童/
おおん /御/
おおんべ /大嘗;=おおにえ/
おか /丘/岡/陸/岳/陵/阜/峻/崗/
おかあさま /お母様/お母さま/御母様/
おかあさん /お母さん/
おかあちゃん /お母ちゃん/
おかい /小粥/汚怪/
おかいあげ /お買い上げ/お買上/お買上げ/
おかいけい /お会計/
おかいどく /お買い得/
おかいもの /お買い物/
おかうち /岡内/
おかえ /岡江/
おかえくみこ /岡江久美子/
おかえし /お返し/御返し/
おかえり /お帰り/
おかお /お顔/
おかかえ /お抱え/御抱え;-料理人/
おかがき /岡垣/
おかがきちょう /岡垣町/
おかがみ /岡上/
おかくら /岡倉/
おかくらてんしん /岡倉天心;(1862-1913) 『茶の本』/
おかぐら /御神楽/
おかげ /お陰/お蔭;=お陰/御陰/御蔭/
おかげさま /お蔭様/御蔭様/
おかげん /お加減/御加減/
おかさか /岡坂/
おかさん /岡三/
おかさんしょうけん /岡三証券;[企業名]www.okasan.co.jp/
おかざき /岡崎/丘咲/
おかざきえき /岡崎駅/
おかざきし /岡崎市/
おかざわ /岡澤/
おかざわちょう /岡沢町/
おかし /お菓子/
おかしま /岡島/
おかしや /お菓子屋/
おかしら /尾頭;鯛の-付き/
おかしらつき /尾頭付き/尾頭付/
おかじま /岡島/岡嶋/
おかじょうき /陸蒸気/
おかず /御数/御菜/
おかせっけい /岡設計/
おかぞえ /岡添/
おかた /お方/御方/岡田/
おかたに /岡谷/
おかだ /岡田/
おかだい /岡大/
おかだいぞう /岡田以蔵/
おかだけいすけ /岡田啓介/
おかだせん /岡多線/
おかだま /丘珠/
おかだや /岡田屋/
おかちまち /御徒町/
おかって /お勝手/
おかっぴき /岡っ引き/
おかつ /雄勝/
おかづり /陸釣/
おかと /岡登/
おかど /尾角;姓/
おかどちがい /御門違い/お門違い/
おかどめ /岡留/
おかね /お金/
おかねもうけ /お金儲け/
おかねもち /お金持ち/
おかの /岡野/
おかのり /陸海苔/
おかはし /岡橋/
おかはち /岡八/
おかはら /岡原/
おかはる /岡原/
おかばしょ /岡場所/
おかばやし /岡林/
おかひさ /岡久/
おかひじき /陸鹿尾菜/
おかひら /岡平/
おかふじ /岡藤/
おかぶ /雄株;⇔雌株/お株;-を奪う/御株/
おかべ /岡部/
おかべちょう /岡部町/
おかぼ /陸稲/
おかぼれ /岡惚れ;≒片想い/傍惚れ;≒片想い/
おかま /御釜/お釜/
おかまい /御構い/
おかみ /御上/女将;旅館の-/お上/岡見/お内儀;(店|ウチ)の-/御内儀/傍見/
おかみさん /お内儀さん/
おかむら /岡村/
おかむろ /岡室/
おかめ /傍目;-八目/お亀;お多福/阿亀;=お亀/
おかめはちもく /傍目八目/岡目八目/
おかもち /岡持/岡持ち/
おかもと /岡本/岡元/
おかもとあやこ /岡本綾子/
おかもときどう /岡本綺堂;(1872-1939) 作家。『半七捕物帳』/
おかや /岡谷/
おかやす /岡安/
おかやすこう /岡安高/
おかやま /岡山/
おかやまえき /岡山駅/
おかやまえきまえ /岡山駅前/
おかやまかん /岡山間/
おかやまがわ /岡山側/
おかやまくうこう /岡山空港/
おかやまけん /岡山県/
おかやまけんじん /岡山県人/
おかやまし /岡山市/
おかやまじょう /岡山城/
おかやまだい /岡山大/
おかやまだいがく /岡山大学/
おかやまちほう /岡山地方/
おかやまひがし /岡山東/
おかやまべん /岡山弁/
おかやまめいぶつ /岡山名物/
おかゆ /お粥/小粥/
おからだ /お身体/
おかわり /お代わり/お変わり/お代り/お変り/
おかん /悪寒/お燗/お母ん/惡寒;「悪」旧字/
おかんがえ /お考え/
おかんじょう /お勘定/
おかんむり /御冠/
おが /男鹿/大鋸/
おがい /小粥/
おがくず /大鋸屑/
おがさ /小笠/
おがさか /小賀坂/
おがさはら /小笠原/
おがさわら /小笠原/
おがさわらきんかい /小笠原近海/
おがさわらしょとう /小笠原諸島/
おがさわらりゅう /小笠原流/
おがた /緒方/尾形/小方/小形/緒形/
おがたけん /緒形拳/
おがたけんざん /尾形乾山;(1663-1743) 陶工。兄は光琳/
おがたこうりん /尾形光琳/
おがつ /雄勝/
おがの /小鹿野/
おがはんとう /男鹿半島/
おがひき /大鋸挽き/
おがみ /尾上/男神/
おがや /小萱/
おがゆ /小粥/
おがら /麻幹/
おがわ /小川/小河/緒川/尾川/尾河/
おがわえき /緒川駅/
おがわちょう /小川町/
おがわな /小川名/
おがわまち /小川町/
おがわみめい /小川未明;(1882-1961)作家 NB:正しくは「おがわびめい」/
おき /沖/隠岐/燠;暖炉の-/熾;=燠/澳;≒沖/置き/起き/お気/興;(人名用)/煕;(人名用)/熈;(人名用)/
おきあい /沖合/沖合い/
おきあいぎょぎょう /沖合漁業/
おきあがりこぼし /起き上がり小法師/
おきあじ /沖鰺/
おきあみ /置網/置き網/沖醤蝦/
おきあゆ /置鮎;姓/
おきいし /置き石/置石/
おきうお /沖魚/
おきかえ /置き換え/置換え/
おきかた /置き方/
おきがけ /起き掛け/
おきがさ /置き傘/
おきがる /御気軽/お気軽/
おきくら /沖倉/
おきぐすり /置き薬/
おきこうぎょう /沖工業;[企業名]/
おきことば /沖言葉/
おきご /置き碁/
おきごたつ /置き炬燵/
おきさわら /沖鰆;宗太鰹のこと/
おきざり /置き去り/
おきじ /置字/置き字;漢文の読まない字/
おきす /沖洲/
おきそ /小木曽/
おきた /沖田/小木田/
おきたそうじ /沖田総司/
おきたま /置賜/
おきち /お吉/
おきつ /興津/
おきつうしん /沖通信/
おきつち /置き土/
おきつのり /興津海苔/
おきづき /お気付き/
おきづけ /沖漬;タコの-/沖漬け/
おきて /掟/諚/沖手/
おきてがき /掟書/
おきてがみ /置き手紙/置手紙/
おきてぬぐい /置き手拭い/
おきでんき /沖電気/
おきでんきこうぎょう /沖電気工業;[企業名]/
おきとちょう /置戸町/
おきどけい /置時計/置き時計/
おきどこ /置床;ポータブル床の間/置き床/
おきどころ /置き所/
おきな /翁/奥菜/
おきなあめ /翁飴/
おきなか /沖中/
おきなかし /沖仲仕/沖仲士;?/
おきなごうし /翁格子/
おきなわ /沖縄/沖繩/
おきなわかいはつちょう /沖縄開発庁;NB:2001年1月の中央省庁再編で内閣府に再編された/
おきなわけん /沖縄県/
おきなわけんえいてつどう /沖縄県営鉄道/
おきなわこくぜいじむしょ /沖縄国税事務所/
おきなわご /沖縄語/
おきなわさん /沖縄産/
おきなわし /沖縄市/
おきなわしょとう /沖縄諸島;地名,Okinawa Isles/
おきなわじん /沖縄人/
おきなわすいさん /沖縄水産/
おきなわせん /沖縄戦;[世界史]1945/
おきなわふう /沖縄風/
おきなわふじつう /沖縄富士通/
おきなわべん /沖縄弁/
おきなわほうげん /沖縄方言/
おきなわほんとう /沖縄本島/
おきなわほんとうない /沖縄本島内/
おきなわみんよう /沖縄民謡/
おきなわもの /沖縄物/
おきなわりょうりや /沖縄料理屋/
おきにいり /お気に入り/
おきぬけ /起き抜け/
おきのしま /隠岐島/沖ノ島/
おきのとりしま /沖ノ鳥島/
おきのどく /お気の毒/
おきのどくさま /お気の毒様/お気の毒さま/
おきば /置き場/置場/
おきばしょ /置き場所/置場所/
おきひ /置き肥/置肥/
おきび /熾火/燠火/
おきふじ /沖藤/
おきぶみ /置文/
おきまつしま /沖松島/
おきまり /お決まり/御決まり/御決り/
おきみ /沖美/
おきみやげ /置き土産/置土産/
おきめ /沖目/
おきもじ /御気文字/
おきもち /お気持ち/お気持/
おきもと /沖本/
おきもの /置物/置き物/
おきゃく /お客/
おきゃくさま /お客様/御客様/お客さま/
おきゃくさん /お客さん/
おきゃん /御侠/お侠/
おきや /置屋/置き屋/
おきゅう /お灸/
おきょう /お経/
おきらく /お気楽/
おきわすれ /置き忘れ/置忘れ/
おきわたし /沖渡し/
おぎ /荻/小城/小木/尾木/蒹/
おぎうえ /荻上/
おぎえぶし /荻江節;三味線/
おぎくぼ /荻窪/
おぎくぼかん /荻窪間/
おぎしま /荻島/
おぎそ /小木曽/
おぎた /荻田/小木田/
おぎつ /荻津/
おぎにしき /小城錦/
おぎの /荻野/荻布/
おぎのしき /オギノ式/荻野式;避妊法/
おぎのめ /荻野目/荻目/
おぎのめようこ /荻野目洋子/
おぎはら /荻原/
おぎゅう /荻生/
おぎゅうそらい /荻生徂徠/
おぎょう /オ行/お行/
おぎょうぎ /お行儀/
おぎろ /頤/
おぎわら /荻原/
おく /奥/億;10^8/邑久;地名,岡山県/尾久;地名,東京都北区/屋;家屋/憶;憶測/臆;臆病/檍;もちのき/奧;「奥」の旧字(人名用漢字)/
おく> /奥;奥二重,奥多摩/
おくい /奥井/奥居/
おくいし /奥医師/
おくいずも /奥出雲/
おくいぶき /奥伊吹/
おくいり /奥入;源氏物語の注釈書。定家/
おくう /屋烏;-の愛/
おくえん /億円/
おくか /奥処/屋下;屋下に屋を架す/
おくかい /億回/
おくかわ /奥川/
おくがい /屋外/
おくがいよう /屋外用/
おくがき /奥書/
おくがた /奥方/
おくきょうと /奥京都/
おくぎ /奥義;「おうぎ」ともいう/奥儀;「おうぎ」ともいう/
おくこ /億個/
おくさがみ /奥相模/
おくさき /奥崎/
おくさま /奥様/
おくさわ /奥沢/奥澤/
おくさん /奥さん/
おくざしき /奥座敷/
おくしが /奥志賀/
おくしゃ /屋舎/
おくしょん /億ション;[俗]億単位の分譲マンション/
おくしり /奥尻/
おくしりとう /奥尻島/
おくじょう /屋上/
おくじょうおく /屋上屋/
おくじょうていえん /屋上庭園;roof garden/
おくじょちゅう /奥女中/
おくすり /お薬/
おくせ /奥瀬/
おくせつ /憶説/臆説/
おくそく /憶測/臆測/
おくそこ /奥底/
おくただみ /奥只見/
おくたに /奥谷/
おくたま /奥多摩/
おくたまえき /奥多摩駅/
おくたまほうめん /奥多摩方面/
おくたんい /億単位/
おくだ /奥田/
おくだいら /奥平/
おくだて /奥立/
おくだん /臆断/
おくち /奥地/お口/
おくちょう /億兆/
おくつ /奥津/
おくつき /奥つ城/
おくづけ /奥付/
おくて /奥手;「-な娘」/晩生;[植物]late.「-の品種」/晩稲;⇔早稲/
おくで /奥出/
おくでら /奥寺/
おくでん /奥伝/
おくとね /奥利根/
おくとみ /奥富/
おくど /奥土/
おくない /屋内/奥内/
おくないしせつ /屋内施設/
おくないはいせん /屋内配線/
おくないぷーる /屋内プール/
おくなが /奥永/
おくに /御国/阿国/お国/
おくにがら /お国柄/
おくにことば /御国言葉/
おくにし /奥西;姓/
おくにじまん /御国自慢/お国自慢/
おくにっかわ /奥新川/
おくにっこう /奥日光/
おくになまり /御国訛り/お国訛り/
おくにん /億人/
おくぬき /奥貫/
おくねん /億年/
おくの /奥野/奥乃/
おくのいん /奥の院/
おくのて /奥の手/
おくのと /奥能登/
おくのほそみち /奥の細道/
おくのま /奥の間/
おくはら /奥原/
おくば /奥歯/
おくひだ /奥飛騨/
おくびょう /臆病/
おくびょうかぜ /臆病風/
おくびょうもの /臆病者/
おくぶ /奥部/
おくほ /奥穂/
おくほうこう /奥方向/
おくほたかだけ /奥穂高岳;地名/
おくぼいん /奥母音/
おくまつしま /奥松島/
おくまん /億万/
おくまんちょうじゃ /億万長者/
おくみ /衽/袵/
おくみかわ /奥三河/
おくみの /奥美濃/
おくみのちほう /奥美濃地方/
おくむら /奥村/
おくめ /奥目/
おくめん /臆面/
おくもと /奥本/納本/
おくやま /奥山/
おくやみ /お悔やみ/
おくゆき /奥行/奥行き/
おくゆきかん /奥行感/
おくら /御蔵/憶良;人名/お蔵/
おくらいり /お蔵入り/
おくり /送り/
おくりあし /送り足;[相撲]/
おくりあしばらい /送り足払い/
おくりおおかみ /送り狼/
おくりかた /送り方/
おくりかな /送り仮名/
おくりがな /送り仮名/
おくりさき /送り先/贈り先/
おくりじょう /送り状/
おくりたおし /送り倒し/
おくりだし /送り出し/
おくりて /送り手/
おくりな /諡/贈り名/
おくりぬし /送り主/贈り主/送主/
おくりばんと /送りバント;[野球]sacrifice bunt/
おくりび /送り火/
おくりむかえ /送り迎え/
おくりもと /送り元/
おくりもの /贈り物/贈物/贈りもの/饋/賻/
おくれ /遅れ/
おくれげ /後れ毛/
おくれじかん /遅れ時間/
おくればせ /遅れ馳せ/遅馳/
おくればせながら /遅ればせながら/
おくわざ /奥技/
おぐさ /小草/
おぐし /小串/御髪/
おぐち /小口/尾口/
おぐに /小国/
おぐにまち /小国町/
おぐま /小熊/
おぐら /小倉/小椋/
おぐらあん /小倉餡/
おぐらけい /小椋佳/
おぐらしきし /小倉色紙/
おぐらやま /小倉山/
おぐり /小栗/
おぐりはんがん /小栗判官/
おぐるま /小車/
おぐろ /小黒/
おけ /桶/
おけいこ /お稽古/
おけがやぬま /桶ケ谷沼/
おけがわ /桶川/
おけがわし /桶川市/
おけしょう /お化粧/
おけつ /悪血/
おけと /置戸/
おけどう /桶胴;太鼓/
おけはざま /桶狭間/
おけや /桶屋/
おけら /螻蛄;[昆虫]「-になる」(=無一文)/朮;[植物]/
おける /於ける/
おげひん /お下品/
おげれつ /お下劣/
おげんき /お元気/御元気/
おこ /痴;foolish. 「-がましい」/烏滸;=痴/お子/
おこう /お香/汚行/
おこうでん /御香典/
おこえ /御声/
おこげ /お焦げ/御焦げ/
おこころ /御心/
おこさま /お子様/お子さま/
おこさまらんち /お子様ランチ/
おこさん /お子さん/
おこし /お越し/小越/
おこぜ /虎魚/
おこたえ /お答え/御答え/
おこたち /御子達/
おこちゃま /お子ちゃま/
おこっぺ /興部/
おこっぺちょう /興部町/
おこと /お琴/お箏/
おことてん /乎古止点/
おことば /御言葉/
おことわり /お断り/お断わり/
おこない /行い/行ない/
おこのぎ /小此木/
おこのみ /お好み/
おこのみやき /お好み焼き/
おこのみやきや /お好み焼き屋/
おこぼれ /お零れ;-に与る/
おこめ /お米/御米/
おこめけん /お米券/
おこり /瘧;malaria/起り/
おこりいし /瘧石/
おこりかた /怒り方/
おこりんぼう /怒りん坊/
おこわ /御強;赤飯/
おごうりかん /小郡間/
おごおり /小郡/
おごおりし /小郡市/
おごおりちょう /小郡町/
おごし /生越;姓/
おごせ /越生/
おごそか /厳か/
おごと /雄琴/
おごのり /於胡海苔/海髪海苔/
おごり /奢り/驕り/傲り/
おさ /長/筬;織機の-/通事/訳語/
おさいせん /お賽銭/
おさいふ /お財布/
おさいほう /お裁縫/
おさえ /抑え/押さえ/押え/
おさえかた /押さえ方/押え方/
おさえこみ /抑え込み/
おさえどころ /押え所/押さえ所/
おさえめ /抑え目/
おさか /小坂/尾坂/苧坂/
おさかな /お魚/
おさがり /お下がり/御下がり/御下り/
おさき /御先/お先/
おさきに /お先に/
おさきぼう /御先棒/
おさきまっくら /お先真っ暗/御先真っ暗/
おさぎ /兎/
おさくひん /御作品/
おさけ /お酒/
おさけび /雄叫び/
おさげ /お下げ/御下げ;髪型/
おさげがみ /お下げ髪/
おさしみ /お刺身/
おさそい /お誘い/
おさたがき /御沙汰書/
おさたけ /尾佐竹/
おさだ /長田/
おさだまり /御定まり/
おさだみほ /長田美穂/
おさだめがき /御定書/
おさつ /お札/
おさと /お里/御里;-が知れる/長都/
おさな /幼/
おさない /小山内/長内/幼い/
おさないころ /幼い頃/
おさないみえこ /小山内美江子/
おさながお /幼顔/
おさなご /幼子/幼な子/
おさなごころ /幼心/
おさなさ /幼さ/
おさなづま /幼妻/
おさなともだち /幼友達/
おさななじみ /幼馴染/幼馴染み/幼なじみ/
おさなものがたり /幼物語/
おさふね /長船/
おさべ /長部/
おさまり /収まり;-がつかない/納まり;部材の-/
おさみ /修美/
おさむ /修/治/理/収/治虫/納/
おさめ /納め/
おさめこみ /納込/
おさめつくるつかさ /修理職/
おさめふだ /納め札/
おさら /お皿/
おさらぎ /大仏;姓/大佛;姓/
おさらぎじろう /大佛次郎;(1897-1973) 作家/大仏次郎;※新字表記/
おさる /お猿/
おさわがせ /お騒がせ/
おさん /お産/
おさんかた /御三方/
おさんぽ /お散歩/
おざ /尾座/
おざき /尾崎/小崎/尾前/
おざきこうよう /尾崎紅葉/
おざきなおみち /尾崎直道/
おざきまさし /尾崎将司/
おざきゆたか /尾崎豊/
おざく /小作/
おざさ /小笹/
おざしき /お座敷/御座敷/
おざしきうた /御座敷唄/
おざなり /御座なり/
おざわ /小沢/小澤/尾沢/
おざわりゅう /小沢流/
おし /唖;dumb/鴛鴦/御師/押し/鴛/忍;(人名用)/
おしあい /押合い/押し合い/
おしあいへしあい /押し合い圧し合い/押合い圧し合い/
おしあいまつり /押し合い祭り/押合い祭り/
おしあげ /押上/
おしあげかん /押上間/
おしあげせん /押上線/
おしあわせ /お幸せ/
おしい /押井/
おしいれ /押入/押し入れ/
おしうり /押し売り/押売り/押売/
おしえ /押絵/教え/
おしえかた /教え方/
おしえご /教え子/
おしお /押尾/
おしおき /お仕置き/御仕置/
おしか /牡鹿/
おしかく /押角/
おしかけ /押し掛け/
おしかせん /男鹿線/
おしかた /押方/
おしかり /御叱り/お叱り/
おしかわ /押川/
おしがし /押し貸し/
おしがた /押型/押し型/
おしがみ /押紙/
おしき /折敷/
おしきせ /御仕着せ/
おしきり /押切/
おしくま /押熊/
おしくも /惜しくも/
おしくらまんじゅう /押し競饅頭;押されて泣くな/
おしげ /惜しげ/
おしこみ /押し込み/押込み/
おしこみごうとう /押し込み強盗/押込み強盗/
おしごと /お仕事/
おしずし /押し寿司/押し鮨/押鮨/
おしずもう /押し相撲/
おしたおし /押し倒し/
おしだ /押田/
おしだし /押し出し/
おしち /お七;八百屋-/
おしちや /御七夜/お七夜/
おしつけ /押し付け/
おして /押手/
おしどり /鴛鴦/鴦/
おしながき /お品書き/
おしなべて /押し並べて/
おしね /晩稲/
おしの /忍野/
おしのはっかい /忍野八海/
おしのび /御忍び/
おしのむら /忍野村/
おしはらい /お支払い/
おしば /押し葉/押葉/
おしばい /お芝居/
おしばこ /押し箱/押箱/
おしばな /押し花/押花/
おしぴん /押しピン;pushpin/
おしぶち /押縁/押し縁;[建築]/
おしべ /雄蕊/
おしほり /押堀/
おしぼたん /押しボタン;push button/押ボタン/
おしぼり /御絞り/
おしま /渡島/小島/
おしまい /御仕舞い/お仕舞い/御仕舞/
おしまずき /几/
おしまはんとう /渡島半島/
おしみ /惜しみ/
おしみず /押水/
おしむぎ /押し麦/押麦/
おしむらくは /惜しむらくは/
おしめ /押し目;-買い/襁褓;オムツ/押目/御湿;=襁褓/襁/繦/
おしめがい /押し目買い;[相場]/
おしめり /お湿り/御湿り/
おしもんどう /押し問答/押問答/
おしゃか /お釈迦/御釈迦/
おしゃかさま /御釈迦様/
おしゃく /お酌/御酌/
おしゃべり /お喋り/
おしゃまんべ /長万部/
おしゃらく /御洒落/
おしゃれ /お洒落/御洒落/おシャレ/
おしゅう /汚臭/
おしょう /和尚/
おしょうがつ /お正月/
おしょく /汚職/
おしょくぎいん /汚職議員/
おしょくじ /お食事/御食事/
おしょくじかい /お食事会/
おしょくじけん /お食事券/汚職事件/
おしらせ /お知らせ/
おしり /お尻/
おしるこ /お汁粉/
おしろ /お城/
おしろい /白粉/
おしろいばな /白粉花/
おしわり /押割り/
おしん /悪心/
おしんこ /御新香/お新香/
おじ /叔父;†父・母の弟/伯父;†父・母の兄/小父;†よその年配男性/老翁/祖父/
おじい /お爺/
おじいさん /お爺さん/お祖父さん/
おじいちゃん /お爺ちゃん/
おじおば /叔父叔母/
おじか /牡鹿/小値賀/
おじかせん /男鹿線/
おじかん /お時間/
おじき /叔父貴/伯父貴/
おじぎ /御辞儀/
おじぎそう /含羞草/御辞儀草/
おじけ /怖気/
おじさま /叔父様;†父母の弟/伯父様;†父母の兄/小父様;†よその年配男性(オジサン)/
おじさん /叔父さん;†父母の弟/伯父さん;†父母の兄/小父さん;†よその年配男性(オジサン)/
おじま /小島/尾島/
おじまちょう /小島町/
おじゃま /お邪魔/御邪魔/
おじゃまむし /お邪魔虫/
おじゅう /御重;重箱/
おじゅけん /お受験;[新語]名門幼稚園・小学校の受験/
おじょう /御嬢/お嬢/
おじょうさま /お嬢様/御嬢様/
おじょうさん /お嬢さん/御嬢さん/
おじょうさんそだち /御嬢さん育ち/
おじょうず /御上手/お上手/
おじょうちゃん /お嬢ちゃん/
おじょく /汚辱/
おじろ /尾白/
おす /雄/牡/お酢/♂/
おす> /牡/雄;-犬,-虎/
おすい /汚水/
おすいかん /汚水管/
おすいしょり /汚水処理/
おすいぬ /雄犬/オス犬/牡犬/
おすいもじ /御推文字/
おすいもの /お吸い物/
おすうし /雄牛/
おすうま /牡馬/
おすかぶ /雄株/
おすがた /御姿/
おすき /お好き/
おすごし /お過ごし/
おすし /お寿司/
おすすめ /お勧め/お薦め/
おすそわけ /お裾分け/御裾分け/おすそ分け/
おすたかやま /御巣鷹山/
おすだ /小須田/
おすとめす /雄と雌/
おすねこ /雄猫/牡猫/オス猫/
おすまい /お住い/
おすまし /御澄まし/
おすまんご /オスマン語;Osmanli/
おすみ /お済み/
おすみうむ /Os/Osmian/
おすみつき /お墨付き/御墨付/御墨付き/
おすめす /雄雌/牡牝/
おず /小津/
おせ /尾瀬/
おせいぼ /お歳暮/御歳暮/
おせおせ /押せ押せ/
おせき /お席/
おせざき /大瀬崎/
おせじ /お世辞/御世辞/
おせち /御節/
おせちりょうり /御節料理/
おせっかい /お節介/御節介/
おせつ /お説/
おせわ /お世話/御世話/
おせわさま /お世話様/御世話様/
おせん /汚染/
おせんげん /汚染源/
おせんじょうきょう /汚染状況/
おせんすい /汚染水/
おせんち /おセンチ;[口](皮肉で) sentimental/
おせんちたい /汚染地帯/
おせんどじょう /汚染土壌/
おせんぶっしつ /汚染物質/
おぜ /尾瀬/小瀬;人名/
おぜき /尾関/小関/
おぜぬま /尾瀬沼/
おぜん /お膳/御膳/
おぜんだて /お膳立て/御膳立て/
おそ /遅/悪阻/獺;かわうそ/遲;「遅」の旧字/
おそ> /遅;遅番,遅便,遅咲き/
おそあがり /遅上がり/
おそい /襲/
おそうざい /お惣菜/
おそうしき /お葬式/御葬式/
おそうじ /お掃除/
おそうまれ /遅生まれ/遅生れ/
おそかれはやかれ /遅かれ早かれ/
おそくとも /遅くとも/
おそざき /遅咲き/
おそざくら /遅桜/
おそし /遅し/
おそぢえ /遅知恵/
おそで /遅出/
おそなえ /お供え/御供え/
おそなえもち /御供え餅/
おそなえもの /お供え物/御供え物/
おそね /遅寝/
おそば /御側/遅場/
おそばん /遅番/遅版/
おそびん /遅便;⇔早便/
おそまき /遅蒔き/
おそまつ /お粗末/御粗末/
おそまつさま /御粗末様/お粗末様/お粗末さま/
おそめ /遅め/遅目/お染;「鳥辺山心中」の人物/
おそらく /恐らく/
おそらくは /恐らくは/
おそる /惶/
おそるおそる /恐る恐る/
おそるべき /恐るべき/
おそるべし /恐るべし/
おそれ /虞;(悪いことの起こる可能性)「風俗を害する虞」/恐れ/畏れ;awe/
おそれげ /恐れ気/
おそれざん /恐山/
おそれる /惶/
おそろい /お揃い/
おそん /汚損/
おぞうに /お雑煮/
おぞけ /怖気;-づく/
おぞんそう /オゾン層/
おた /織田/
おたから /お宝/御宝/
おたがい /お互い/
おたがいさま /お互い様/御互い様/
おたく /お宅/御宅/
おたけび /雄叫び/
おたじま /小田島/小田嶋/
おたずね /お尋ね/
おたずねもの /お尋ね者/
おたち /お発ち/
おたちだい /お立ち台/御立ち台/
おたっし /お達し/御達し/
おたな /御店/
おたねにんじん /御種人参/
おたのしみ /お楽しみ/
おたのしみぶくろ /お楽しみ袋/
おたび /御旅/
おたふく /お多福/阿多福/
おたべ /小田部/
おたま /お玉/御玉/
おたまじゃくし /御玉杓子/蝌蚪/
おたまや /霊屋/
おたまやした /霊屋下/
おため /御為;-ごかし/
おためごかし /御為倒し/
おためし /お試し/
おたより /お便り/
おたり /小谷/
おたる /小樽/
おたるえき /小樽駅/
おたるし /小樽市/
おたるしょうかだいがく /小樽商科大学/
おたんじょうび /お誕生日/
おだ /小田/織田/纓田/
おだい /お題/お代/御題/御代;-は要らぬ/小田井/
おだいじに /お大事に/
おだいじん /お大尽/
おだいとう /尾岱沼/
おだいば /御台場;地名/
おだいもく /御題目/
おだいら /小平/
おだうらくさい /織田有楽斎/
おだか /小高/尾高/
おだかしょう /尾高賞/
おだかずまさ /小田和正/
おだがわ /小田川/
おだきゅう /小田急/
おだきゅうえんせん /小田急沿線/
おだきゅうしゃりょう /小田急車両/
おだきゅうしんじゅく /小田急新宿/
おだきゅうしんじゅくえき /小田急新宿駅/
おだきゅうじこくひょう /小田急時刻表/
おだきゅうせん /小田急線/
おだきゅうせんえんせん /小田急線沿線/
おだきゅうせんない /小田急線内/
おだきゅうたません /小田急多摩線/
おだぎ /小田木/
おだぎり /小田切/小田桐/
おだく /汚濁/
おだくら /小田倉/
おだけ /雄竹/織田家/
おだしま /小田嶋/
おだじま /小田島/小田嶋/尾田島/
おだて /煽て/
おだなか /小田中/
おだに /小谷/
おだのぶなが /織田信長/
おだのぶひで /織田信秀/
おだぶつ /御陀仏/お陀仏/
おだべ /小田部/
おだまき /苧環/
おだまきむし /小田巻蒸し/苧環蒸し/
おだまり /お黙り/
おだやか /穏やか/
おだわら /小田原/
おだわらかん /小田原間/
おだわらがた /小田原方/
おだわらじょう /小田原城/
おだわらせん /小田原線;小田急/
おだわらぢょうちん /小田原提灯/
おだわらひょうじょう /小田原評定/
おだわらほうめん /小田原方面/
おだん /オ段/
おち /越智/落ち/落/越知/尾知/彼方/遠/
おちあい /落合/
おちあゆ /落ち鮎/
おちいし /落石/
おちうお /落ち魚/落魚/
おちうど /落人/
おちえ /御知恵/
おちおち /落ち落ち/
おちかた /遠方;over there/落ち方;how it falls/落方/墜ち方/
おちから /お力/御力/
おちからぞえ /お力添え/
おちくぼものがたり /落窪物語/
おちぐち /落ち口/
おちけん /落研/
おちこち /遠近/彼方此方/
おちこぼれ /落ちこぼれ/落ち零れ/
おちこみ /落ち込み/落ちこみ/
おちご /御稚児/
おちち /お乳/
おちつき /落ち着き/落着き/
おちど /落ち度/落度/越度;=落ち度 NB:「落(ち)度」はこの当て字/
おちば /落葉/落ち葉/
おちばいろ /落葉色/
おちばたき /落ち葉焚き/落葉焚き/
おちびと /落人/
おちぼ /落穂/落ち穂/
おちぼひろい /落穂拾い/
おちみず /落水/落ち水/
おちむしゃ /落ち武者/落武者/
おちめ /落ち目/
おちゃ /お茶/御茶/
おちゃうけ /御茶請け/お茶請け/
おちゃかい /お茶会/
おちゃがし /お茶菓子/
おちゃくみ /お茶汲み/
おちゃしつ /お茶室/
おちゃだい /お茶代/お茶大/
おちゃっぱ /お茶っ葉/
おちゃづけ /お茶漬け/お茶漬/
おちゃづけのり /御茶漬海苔/
おちゃのこ /御茶の子;茶菓子。「-さいさい」/
おちゃのこさいさい /御茶の子さいさい/
おちゃのま /お茶の間/御茶乃間/
おちゃのみず /お茶の水/御茶ノ水/御茶の水/
おちゃのみずじょしだいがく /お茶の水女子大学/
おちゃのみば /お茶飲み場/
おちゃめ /お茶目/
おちゅうげん /御中元/お中元/
おちゅうしゃ /お注射/
おちょうし /お銚子/
おちょうしもの /お調子者/
おちょこ /御猪口/お猪口/
おちょぼぐち /おちょぼ口/
おぢや /小千谷/
おっか /屋下;屋下に屋を架す/
おっかあ /おっ母/
おっかけ /追っかけ/追っ掛け/
おっかさん /おっ母さん/
おっきな /大っきな/
おっくう /億劫/
おっくご /オック語;langue d'oc/
おっくすふぉーどだいがく /オックスフォード大学;Oxford University. www.ox.ac.uk/
おっそ /越訴/
おって /追手/追っ手/追って/
おってがき /追而書/
おっと /夫/良人/
おっとう /おっ父/
おっとせい /膃肭臍/
おっとりがたな /押っ取り刀/
おっぱま /追浜/
おっぱまえき /追浜駅/
おっぽ /尾っぽ/
おつ /乙/榲;(すぎ)/膃;膃肭臍(おっとせい)/
おつあん /乙案/
おつうじ /お通じ/
おつかい /お使い/
おつかれさま /お疲れ様/お疲れさま/御疲れ様/
おつがわ /乙川/
おつがわえき /乙川駅/
おつき /御付き;付き人/
おつきあい /お付き合い/
おつきさま /お月様/お月さま/
おつくり /御造り;お刺身/お造り/御作り/お作り/
おつけ /御付け;味噌汁/
おつげ /お告げ/御告げ/
おつざいよう /乙剤用/
おつしゅ /乙種/
おつじ /尾辻/
おつたえ /お伝え/
おつつ /現/
おつとめ /お勤め/御勤め/
おつにょう /乙繞/
おつぼね /お局/
おつぼねさま /お局様/
おつや /お通夜/御通夜/
おつゆ /御汁/
おつり /お釣り/お釣/御釣り/
おづ /小津/
おづき /小月/
おづつ /尾筒/
おづやすじろう /小津安二郎/
おて /お手/御手/
おてあげ /お手上げ/御手上げ/お手あげ/
おてあらい /御手洗/お手洗い/お手洗/
おてあわせ /お手合わせ/
おていれ /お手入れ/
おてかず /お手数/
おてがみ /お手紙/御手紙/
おてがる /お手軽/
おてごろ /お手頃/
おてすう /お手数/御手数/
おてだま /お手玉/
おてつき /御手付き/
おてつだい /お手伝い/
おてて /お手々/
おてなみはいけん /お手並み拝見/御手並拝見/
おてのもの /お手の物/御手の物/
おてほん /お手本/
おてま /お手間/
おてまえ /お点前/
おてもち /お手持ち/
おてもと /お手元/お手許/
おてもり /お手盛り/
おてら /お寺/
おてん /汚点/
おてんき /お天気/
おてんとうさま /お天道様/
おてんとさま /お天道様/御天道様/
おてんば /お転婆/御転婆/
おでい /汚泥/
おでいしょり /汚泥処理/
おでいはっせいりょう /汚泥発生量/
おでかけ /お出かけ/お出掛け/
おでかけまえ /お出かけ前/
おでき /御出来/
おでし /御弟子/
おでら /小寺/
おでん /御田/
おでんだね /おでん種/
おでんわ /お電話/
おと /音/乙/彼方/遠/
おとあわせ /音合わせ/音合せ/
おといあわせ /お問い合わせ/
おといち /音一/
おといれ /音入れ/
おとうさま /お父様/御父様/
おとうさん /お父さん/
おとうす /音薄/
おとうちゃん /お父ちゃん/
おとうと /弟/
おとうとでし /弟弟子/
おとうとぶん /弟分/
おとうとよめ /弟嫁/
おとおし /御通し/お通し/
おとおんかい /音音階/
おとかず /音数/
おとかわ /乙川/
おとかんきょう /音環境;sound environment/
おとがい /頤/
おとがめ /お咎め/
おとき /御斎/
おとぎ /御伽/
おとぎぞうし /御伽草子/
おとぎばなし /おとぎ話/お伽話/御伽話/
おとぎりそう /弟切草/
おとぎりそうもく /オトギリソウ目/Dilleniales/Guttiferales/Hypericales/
おとぎりそうもくぐん /オトギリソウ目群/Hypericales/
おとく /お得/
おとくい /お得意/
おとくいさま /お得意様/
おとくうかん /音空間/
おとくに /乙訓/
おとくよう /お徳用/
おとけんしゅつ /音検出/
おとこ /男/漢/♂/
おとこあいて /男相手/
おとこあそび /男遊び/
おとこうぞう /音構造/
おとこうん /男運;⇔女運/
おとこえし /男郎花/
おとこおとこ /男男/
おとこおや /男親/
おとこおんな /男女/
おとこかんけい /男関係/
おとこがみ /男神/
おとこがわ /男側/
おとこきょうだい /男兄弟/
おとこぎ /男気;きっぷ/侠気/
おとこぎみ /男君/
おとこぎらい /男嫌い/
おとこぐせ /男癖/
おとこぐみ /男組/
おとこぐるい /男狂い/
おとこげ /男気;おとこっけ/
おとこげいしゃ /男芸者/
おとこことば /男言葉/
おとこごころ /男心/
おとこごろし /男殺し/
おとこざか /男坂/
おとこざかり /男盛り/
おとこしゃかい /男社会/
おとこしゅう /男衆/
おとこじゅく /男塾/
おとこじょたい /男所帯/
おとこずき /男好き/
おとこたち /男達/
おとこだて /男伊達/
おとこっけ /男っ気/
おとこっぷり /男っ振り/
おとこで /男手/
おとこともだち /男友達/
おとこどうし /男同士/
おとこども /男共/
おとこなき /男泣き/
おとこなまえ /男名前/
おとこのこ /男の子/男のコ/
おとこのひと /男の人/
おとこばら /男腹/
おとこひとり /男一人/
おとこべや /男部屋/
おとこべんじょ /男便所/
おとこまえ /男前/
おとこまさり /男勝り/男勝/
おとこみこ /男御子/
おとこみち /男道/
おとこみょうり /男冥利/
おとこもじ /男文字/
おとこもの /男物/
おとこやく /男役/
おとこやま /男山/
おとこやもめ /男鰥/
おとこゆ /男湯/
おとさた /音沙汰/
おとし /御年/御歳/お年/落し/お歳/落とし/
おとしあな /落とし穴/落し穴/陥穽/
おとしかた /落し方/
おとしがけ /落とし掛け/落し掛け/落とし懸け/落し懸け/
おとしがみ /落し紙/
おとしげき /音刺激/
おとしご /落とし子/落し子/
おとしごろ /お年頃/
おとしだね /落とし胤/落し胤/
おとしだま /お年玉/御年玉/おとし玉/
おとしどころ /落とし所/落し所/
おとしなちょう /音更町/
おとしぬし /落とし主/落し主/
おとしぶた /落とし蓋/落し蓋/
おとしぶみ /落し文/落とし文/落書/
おとしまえ /落とし前/落し前/
おとしもの /落とし物/落し物/
おとしより /お年寄り/
おとしんごう /音信号/
おとじたい /音自体/
おとじょうほう /音情報/
おとじろう /音二郎/
おとずれ /訪れ/
おとせってい /音設定/
おとそ /お屠蘇/
おとそしき /音組織/
おとだ /音田/
おとだし /音出し/
おとっつぁん /お父っつぁん/
おとつい /一昨日/
おとつづみ /弟鼓;小鼓/
おとづくり /音作り/
おとてき /音的/
おとと /弟/
おととい /一昨日/
おととし /一昨年/
おととび /音飛び/
おととり /音取り/音取/
おとどけ /お届け/
おとどけさき /お届先/お届け先/
おとどまち /大殿町/
おとな /大人/
おとながい /大人買い;[口]子供が小遣いでちびちび買うようなものを、経済力のある大人がまとめ買いすること/
おとなけいかく /大人計画/
おとなげ /大人気/
おとなし /音無/音無し/
おとなせんよう /大人専用/
おとなたち /大人達/
おとなひとり /大人一人/
おとなむけ /大人向け/
おとなよう /大人用/
おとなり /お隣/お隣り/御隣/
おとなりさん /お隣さん/
おとにゅうりょく /音入力/
おとは /乙葉;名/
おとひと /弟/
おとひめ /乙姫/
おとひめさま /乙姫様/
おとふけ /音更/
おとふじ /乙藤/
おとべ /乙部/
おとべちょう /乙部町/
おとべつ /音別/
おとむすめ /乙娘/
おとめ /乙女/少女/夫婦/夫妻;めおと/
おとめご /少女子/乙女子/
おとめごころ /乙女心/
おとめざ /乙女座;Virgo(Vir),(8.23-9.22)/
おとめじゅく /乙女塾/
おとめたい /乙女隊/
おとめたち /乙女達/
おとも /お供/御供/お伴/御伴/
おともだち /お友達/お友だち/
おともれ /音洩れ/
おとよめ /弟嫁/
おとり /囮/劣り/
おとりあつかい /お取り扱い/お取扱い/
おとりおき /お取り置き/
おとりこみちゅう /お取り込み中/
おとりそうさ /囮捜査/
おとりはからい /お取り計らい/お取計らい/
おとりひき /お取り引き/
おとりよせ /お取り寄せ/お取寄せ/
おとろえ /衰え/
おとわ /音羽/
おとわや /音羽屋/
おとわやま /音羽山/
おどき /男時;good time ⇔女時/
おどけ /戯け/
おどし /縅/脅し/
おどしもんく /脅し文句/
おどしゃ /御土砂/
おどり /踊り/
おどりぐい /踊り食い;白魚の-/
おどりこ /踊り子/
おどりじ /踊り字;「々」「ゝ」など/
おどりて /踊り手/
おどりねんぶつ /踊り念仏/
おどりば /踊り場/
おどれ /己/
おどろ /棘/
おどろき /驚き/愕き/駭き/
おな /女/
おない /小内/尾内/
おないぎ /御内儀;おかみさん/
おないどし /同い年/同い歳/
おなか /お腹/御中/
おなかま /お仲間/
おなが /尾長/翁長/
おながざる /尾長猿/
おながどり /尾長鶏/
おながれ /お流れ/御流れ/
おながわ /女川/
おなご /女子/
おなさけ /御情け/
おなじ /同じ/々;漢字/ゝ;ひらがな/ゞ;ひらがな、濁点つき/ヽ;カタカナ/ヾ;カタカナ、濁点つき。「スヾ(スズ)」/〃;文単位/仝;同上/
おなじく /同じく/々/
おなじみ /お馴染/お馴染み/
おなはま /小名浜/
おなべ /小鍋/
おなまえ /お名前/御名前/
おなみ /男波/
おなみだちょうだい /お涙頂戴/
おなもみ /葹/
おなやみ /お悩み/
おなり /御成/
おなりもん /御成門/
おなれそめ /御馴染/
おなんどいろ /御納戸色/
おに /鬼/
おに> /鬼;鬼娘,鬼教官,鬼部長/
おにあい /お似合い/
おにいさま /お兄様/
おにいさん /お兄さん/
おにいた /鬼板/
おにいちゃん /お兄ちゃん/
おにうだ /鬼生田/
おにおこぜ /鬼虎魚/
おにかわ /鬼可愛/
おにがしま /鬼ヶ島/
おにがらやき /鬼殻焼/
おにがわ /鬼皮/
おにがわら /鬼瓦/
おにきょうかん /鬼教官/
おにぎり /お握り/御握り/
おにく /お肉/尾肉;鯨のおいしい部分/
おにぐも /鬼蜘蛛/
おにぐるま /鬼車/
おにけいじ /鬼刑事/
おにこうべ /鬼首/
おにころし /鬼殺し;やたら強い安酒/
おにご /鬼子/
おにごっこ /鬼ごっこ/
おにごろし /鬼殺し/
おにざわ /鬼沢/
おにし /鬼石/
おにたいじ /鬼退治/
おにっこ /鬼っ子;親に似ない子/
おにつか /鬼束/鬼塚/
おにづか /鬼塚/
おにはは /鬼母/
おにば /鬼歯/
おにばば /鬼婆/
おにひとで /鬼海星/
おにび /鬼火/
おにへい /鬼平/
おにへいはんかちょう /鬼平犯科帳/
おにぼし /鬼星/
おにまる /鬼丸/
おにまろ /鬼磨呂/
おにみそ /鬼味噌;やたら塩っぱい/
おにむすめ /鬼娘/
おにもつ /お荷物/
おにゆり /鬼百合/
おによめ /鬼嫁/
おにわばん /御庭番/
おにわやき /御庭焼/
おぬま /小沼/
おね /尾根/
おねうち /お値打ち/
おねえ /お姉/
おねえさま /お姉さま/お姉様/
おねえさん /お姉さん/
おねえちゃん /お姉ちゃん/
おねがい /お願い/
おねじ /雄螺子/
おねせん /尾根線/
おねだん /お値段/
おねてん /尾根点/
おねば /大根葉/
おねみち /尾根道/
おの /斧/己/小野/尾野/
おのうえ /尾上/
おのうえおんせんえき /小野上温泉駅/
おのえ /尾上/
おのお /小野尾/
おのおか /小野岡/
おのおの /各々/各各/各/
おのおのがた /各々方/
おのかわ /小野川/
おのが /己が/
おのがくえん /小野学園/
おのがじし /己がじし/
おのがみ /小野上/
おのがわ /小野川/
おのがわこ /小野川湖/
おのき /小野木/
おのぎ /小野木/
おのこ /男子/男/男の子/
おのさと /小野里/
おのざき /小野崎/
おのざわ /小野沢/
おのず /自ず/
おのずか /小野塚/
おのずから /自ら/自ずから/
おのずと /自ずと/自と/
おのそっき /小野測器/
おのぞみ /お望み/
おのだ /小野田/
おのだか /小野高/
おのだせめんと /小野田セメント/
おのだせん /小野田線/
おのづか /小野塚/
おのでら /小野寺/
おののいもこ /小野妹子;遣隋使/
おののこまち /小野小町;平安時代の歌人。美人の代名詞/
おののたかむら /小野篁/
おののとうふう /小野道風;894-966/
おのぼりさん /お上りさん/
おのみ /尾の身/
おのみち /尾道/
おのむら /小野村/
おのやま /小野山/
おのれ /己/
おは /尾羽/
おはぎ /御萩;餅/
おはぐろ /鉄漿/御歯黒/お歯黒/
おはぐろどぶ /御歯黒溝;吉原の-/
おはこ /十八番/
おはこびさん /お運びさん/
おはし /お箸/御箸/
おはせ /小長谷/生長谷/
おはだ /お肌/
おはち /御鉢/お鉢/
おはつ /お初/御初/
おはな /お花/お鼻/
おはなし /お話/
おはなしちゅう /お話中/
おはなばたけ /御花畑;高山植物の花が咲く場所。単なる花畑ではない。/
おはなみ /お花見/
おはやし /お囃子/
おはやめ /お早め/
おはよう /お早う/
おはら /小原/大原/尾原/
おはらい /御祓い/お祓い/御祓/
おはらいばこ /お払い箱/
おはらぶし /おはら節;[民謡]鹿児島-/
おはらりゅう /小原流;生け花/
おはりこ /御針子/
おば /叔母;†父母の妹/伯母;†父母の姉/尾羽/小場/小母;†よその年配女性/
おばあ /お婆/
おばあさん /お婆さん/お祖母さん/
おばあちゃん /お婆ちゃん/
おばか /おバカ/
おばけ /お化け/尾羽毛;鯨の尾の部分/
おばけやしき /お化け屋敷/
おばさま /叔母様;†父母の妹/伯母様;†父母の姉/小母様;†よその年配女性(オバサン)/
おばさん /叔母さん;†父母の妹/伯母さん;†父母の姉/小母さん;†よその年配女性(オバサン)/
おばしま /欄/
おばすて /姨捨/
おばすてやま /姨捨山/
おばた /小幡/小畑/小俣/
おばたやま /小畑山/
おばな /雄花/尾花;すすき/
おばなざわ /尾花沢/
おばね /尾羽/
おばま /小浜/
おばまおんせん /小浜温泉/
おばません /小浜線/
おばら /小原/
おばらりゅうかいかん /小原流会館/
おひきうけ /お引受け/
おひきたて /お引き立て/
おひさしぶり /お久しぶり/お久し振り/
おひさま /お日様/お日さま/御日様/
おひざもと /お膝元/御膝下/
おひたき /御火焚/
おひたし /お浸し/御浸し/
おひつ /御櫃/お櫃/
おひつじ /牡羊/
おひつじざ /牡羊座;Aries(Ari),(3.21-4.19)/
おひと /御人/お人/
おひとかた /お一方/
おひとがら /お人柄/
おひとつ /お一つ/
おひとよし /御人好し/お人好し/
おひとり /お一人/
おひとりさま /お一人様/
おひなさま /御雛様/
おひねり /御捻り;小銭を包んで芸人に投げる/お捻り/
おひま /お暇/御暇/
おひめさま /お姫様/
おひゃくど /御百度/
おひや /御冷や/
おひら /御平/
おひらき /お開き/御開き/
おひる /お昼/
おひるころ /お昼頃/
おひるどき /お昼時/
おひるね /お昼寝/
おひるまえ /お昼前/
おひるやすみ /お昼休み/
おひれ /尾鰭/尾ひれ/
おひろめ /お披露目/御披露目/
おび /帯/飫肥;地名/小尾/帶;「帯」の旧字(人名用漢字)/
おびあげ /帯揚げ/
おびいた /帯板/
おびえ /怯え/
おびかわ /帯川/帯革/
おびがき /帯書/
おびがね /帯金/
おびがみ /帯紙/
おびきおく /帯記憶/
おびきん /帯筋;[建築]hoop. ⇔主筋/
おびぎょうれつ /帯行列/
おびぐらふ /帯グラフ/
おびこうこく /帯広告/
おびした /帯下/
おびじ /帯地/
おびじめ /帯締め/
おびじょう /帯状/
おびつ /小櫃/帯津/
おびと /首/
おびとけ /帯解/
おびどめ /帯留め/
おびなた /大日方/
おびなど /帯等/
おびのこ /帯鋸/
おびはば /帯幅/
おびばんぐみ /帯番組/
おびひろ /帯広/
おびひろえき /帯広駅/
おびひろはくようこうこう /帯広柏葉高校/
おびふう /帯封/
おびぶん /帯文/
おびまくら /帯枕/
おびもの /佩物/
おびら /小平/
おびれ /尾鰭/
おふぃすがい /オフィス街/
おふかい /オフ会/
おふく /御福/
おふくろ /お袋/御袋/
おふせ /御布施/
おふせっといんさつ /オフセット印刷/
おふたかた /御二方/
おふたり /お二人/御二人/
おふだ /御札/
おふでさき /御筆先/
おふみ /御文/
おふゆ /雄冬/
おふる /お古/
おふれ /御触れ/お触れ/
おふれがき /御触書/
おふろ /お風呂/
おふろあがり /お風呂上がり/
おふろば /お風呂場/
おぶき /小吹/
おぶくろ /尾袋/
おぶさ /綬/
おぶし /男節;背肉で作った鰹節/雄節/
おぶじぇくとしこう /オブジェクト指向/
おぶせ /小布施/
おぶち /小渕/尾駮/
おぶちざわ /小淵沢/
おぶつ /汚物/
おぶね /小舟/
おぷしょんとりひき /オプション取引/
おへや /お部屋/
おへんじ /お返事/御返事/
おへんろ /お遍路/
おべんきょう /お勉強/
おべんとう /お弁当/
おべんとうばこ /お弁当箱/
おぺ /手術/
おぺらかしゅ /オペラ歌手/
おぺらざ /オペラ座;l'Opera. www.opera-de-paris.fr/
おほ /凡/
おほしさま /お星様/お星さま/
おぼう /お坊/
おぼうさん /お坊さん/
おぼえ /覚え/憶え/
おぼえがき /覚書/覚え書き/
おぼえず /覚えず/
おぼこむすめ /おぼこ娘/
おぼし /男星/思し/
おぼしめし /思し召し/
おぼっちゃま /御坊ちゃま/お坊ちゃま/
おぼっちゃん /御坊ちゃん/お坊ちゃん/
おぼつかな /覚束無/
おぼろ /朧/朦;≒朧/
おぼろぐも /朧雲/
おぼろげ /朧げ/
おぼろづき /朧月/
おぼろづきよ /朧月夜/
おぼろづくよ /朧月夜/
おぼろどうふ /朧豆腐/
おぼろよ /朧夜/
おぼん /お盆/
おぼんやすみ /お盆休み/
おまい /御前/
おまいり /お参り/御参り/
おまえ /お前/御前/
おまえさま /御前様/
おまえさん /御前さん/お前さん/
おまえざき /御前崎/
おまえざきおき /御前崎沖/
おまえたち /御前達/お前達/
おまかせ /お任せ/
おまけ /御負け/
おまけつき /オマケ付き/おまけ付き/
おまごさん /お孫さん/
おまた /小俣/尾又/尾股/
おまち /雄町/お待ち/
おまちがい /お間違い/
おまちどおさま /御待ち遠様/
おまつり /御祭/お祭り/御祭り/
おまつりさわぎ /お祭り騒ぎ/御祭騒ぎ/
おまな /御真魚/
おまもり /お守り/御守り/
おまる /御虎子/
おまわり /お巡り/
おまわりさん /お巡りさん;犬の-/
おまんま /御飯/
おみ /臣/麻績/尾美/御神/
おみあい /お見合い/
おみあし /御御足/
おみおくり /お見送り/
おみおつけ /御御御付け/
おみがわ /小見川/
おみき /御神酒/お神酒/
おみくじ /御神籤/
おみくろん /ο;omicron/Ο;Omicron/
おみこし /御神輿/お神輿/
おみごと /お見事/御見事/
おみず /お水/御水/
おみずとり /御水取り;東大寺二月堂の行事/
おみせ /お店/御店/
おみそれ /御見逸れ/御見逸/
おみつもり /御見積/
おみとおし /お見通し/御見通し/
おみな /嫗;老婆/女;美女/
おみなえし /女郎花/
おみぬぐい /御身拭い;仏像等の掃除/
おみね /小峰/
おみまい /お見舞い/お見舞/御見舞/御見舞い/
おみみ /お耳/
おみむら /麻績村;姓/
おみや /御宮/お宮/
おみやげ /お土産/御土産/
おみやまいり /お宮参り/
おみわたり /御神渡り/
おむかい /お向かい/
おむかえ /御迎え/
おむこさん /お婿さん/
おむすび /お結び/御結び/
おむつ /繦/御襁褓/
おむな /嫗/
おむろ /御室/
おめ /御目;-にか[かけ]る/お目/
おめあて /お目当て/お目あて/
おめい /汚名/
おめいこう /御命講/
おめいし /お名刺/
おめいばんかい /汚名挽回;※汚名返上あるいは名誉挽回の誤り/
おめいへんじょう /汚名返上/
おめえ /御前;(要ルビ)/
おめえさん /御前さん;(要ルビ)/
おめが /ω;omega/Ω;Omega/
おめがね /御眼鏡;-に適う/お眼鏡/
おめざめ /お目覚め/
おめし /御召/
おめしもの /御召物/
おめしれっしゃ /御召列車;天皇用/
おめずおくせず /怖めず臆せず/
おめつけ /御目付け/
おめどおり /御目通り/
おめみえ /お目見え/御目見得/
おめもじ /御目文字/
おめんじょう /御免状/
おも /主/面/重/
おもい /思い/想い/重茂;地名,岩手/思/
おもいあがり /思い上がり;-も甚だしい/
おもいいれ /思い入れ/
おもいおもい /思い思い/
おもいかねのかみ /思兼神/
おもいがわ /思川/
おもいきや /思いきや/
おもいきり /思い切り/
おもいこみ /思い込み/
おもいすごし /思い過ごし/思い過し/
おもいだしわらい /思い出し笑い/
おもいちがい /思い違い/
おもいっきり /思いっきり/思いっ切り/
おもいつき /思い付き/
おもいで /思い出/想い出/
おもいでづくり /思い出作り/
おもいでばなし /思い出話/
おもいどおり /思い通り/
おもいなし /思い做し/
おもいのたけ /思いの丈/
おもいのほか /思いの外/
おもいびと /思い人/
おもいもの /思い者/
おもいやり /思いやり/思い遣り/
おもうさま /思う様/
おもうしこみ /お申し込み/お申込み/
おもうぞんぶん /思う存分/
おもうつぼ /思う壺/思う壷;「壺」異体字/
おもおも /重々/重重;-と/
おもかげ /面影/俤/於母影;(1889)新声社の訳詩集/
おもかじ /面舵/
おもがい /羈/面繋/面懸/
おもがわり /面変り/
おもげぎょ /本懸魚/
おもご /面河/
おもさ /重さ/
おもざし /面差し/
おもし /重石/重し;-をする/
おもしろ /面白/
おもしろい /面白い/
おもしろさ /面白さ/
おもしろはんぶん /面白半分/
おもしろみ /面白み/面白味/
おもしろやま /面白山/
おもしろやまこうげん /面白山高原/
おもしろやまこうげんえき /面白山高原駅/
おもたに /面谷/
おもだか /面高/沢瀉/
おもだかもく /オモダカ目/Alismatales/
おもだかもくぐん /オモダカ目群/
おもだち /面立ち/
おもち /お餅/
おもちかえり /お持ち帰り/
おもちゃ /玩具/
おもちゃばこ /玩具箱;toybox/おもちゃ箱/
おもちゃや /おもちゃ屋/玩具屋/
おもづかい /主遣い;人形浄瑠璃の-/
おもづら /羈/
おもて /表/面/
おもて> /表;-革,-街道,-舞台/
おもてあみ /表編み/
おもてうら /表裏/
おもてかいどう /表街道/
おもてかた /表方/
おもてかんばん /表看板/
おもてがえ /表替え/
おもてがき /表書き/表書/
おもてがまえ /表構え/
おもてがわ /表側/
おもてぐち /表口/
おもてぐみ /表組/
おもてけい /表罫/
おもてげんかん /表玄関/
おもてごう /表郷/
おもてさく /表作/
おもてさんどう /表参道/
おもてさんどうえき /表参道駅/
おもてさんどうこうさてん /表参道交差点/
おもてさんどうてん /表参道店/
おもてざしき /表座敷/
おもてざた /表沙汰/表ざた/
おもてじ /表地/
おもてせんけ /表千家/
おもてだな /表店/
おもてどおり /表通り/
おもてにほん /表日本/
おもてはく /表拍/
おもてぶた /表蓋/
おもてぶたい /表舞台/
おもてまんざ /表万座/
おもてみごろ /表身頃/
おもてむき /表向き/表向/
おもてめい /表銘/
おもてもん /表門/表紋/
おもてやま /表山/
おもてろっこう /表六甲/
おもと /御許/万年青;[植物]/
おもな /主な/
おもなが /面長/
おもに /重荷/主に/
おもの /御物;食事/佩物/
おものがわ /雄物川/
おもばば /重馬場/
おもぶき /趣/
おもみ /重み/重味/
おもみけいすう /重み係数/
おもむき /趣/趣き/
おもむけ /趣/
おもむろ /徐/
おもむろに /徐に/
おもめ /重め/
おももち /面持ち/面持/
おもや /母屋/
おもゆ /重湯/
おもらし /お漏らし/
おもり /錘/重り/お守り/
おもわ /面輪/
おもわく /思惑/思わく/
おもわくうり /思惑売り/
おもわくがい /思惑買い/
おもわすれ /面忘れ/
おもわず /思わず/
おもわせぶり /思わせ振り/
おもわれびと /思われ人/
おや /親/
おや> /親;親猫,親猿,親羊/
おやいし /親石;[建築]/首石;[建築]=親石/
おやいず /小柳津/
おやいづ /小柳津/
おやいで /小柳出/
おやいぬ /親犬/
おやいも /親芋/
おやおもい /親思い/
おやかぎ /親鍵/
おやかく /親核/
おやかた /親方/お館/
おやかたさま /お館様/
おやかためい /親方名/
おやかぶ /親株/
おやがいしゃ /親会社/
おやがかり /親掛かり/親掛り/
おやがみ /祖神/
おやがめ /親亀/
おやがわり /親代わり/親代り/
おやき /親機/親器/
おやきじ /親記事/
おやきゅうだん /親球団/
おやきょうだい /親兄弟/
おやきょく /親局/
おやぎ /親木/
おやぎみ /親君/
おやく /お役/御役/
おやくごめん /御役御免/お役御免/お役ご免/
おやくしょ /お役所/
おやくしょしごと /お役所仕事/
おやくそく /お約束/御約束/
おやくそくどおり /お約束通り/お約束どおり/御約束通り/
おやくにん /お役人/
おやけ /小宅/
おやこ /親子/母子/父子/母娘/父娘/親娘/
おやこうこう /親孝行/
おやこうこうもの /親孝行者/
おやこかん /親子間/
おやこかんけい /親子関係/
おやこたか /親子鷹/
おやこづれ /親子連れ/
おやこどん /親子丼/
おやこどんぶり /親子丼/
おやこなべ /親子鍋/
おやご /親御/
おやごころ /親心/
おやざと /親里/
おやしお /親潮/
おやしおいき /親潮域/
おやしらず /親不知/親知らず;=親不知/
おやじ /親父/親爺;=親父/親仁;=親父/親字;親文字/
おやじしん /親自身/
おやすみ /お休み/
おやせたい /親世帯/
おやたち /親達/
おやだ /親田/
おやだいだい /親代代/親代々/
おやだま /親玉/
おやつ /御八つ/
おやつだい /おやつ代/
おやといがいこくじん /御雇外国人/
おやど /御宿/
おやどけい /親時計/
おやどり /親鳥/
おやなぎ /小柳/
おやにらみ /親睨/
おやねこ /親猫/
おやばか /親馬鹿/親バカ/
おやばなれ /親離れ/
おやばら /親腹/
おやばれ /親バレ/
おやひとりこひとり /親一人子一人/
おやふこう /親不孝/
おやふこうもの /親不孝者/
おやぶね /親船/
おやぶん /親分/
おやぶんこぶん /親分子分/
おやぶんやく /親分役/
おやべ /小矢部/
おやぼね /親骨;扇の-/
おやま /小山/雄山/尾山/女形/御山/お山/女方/
おやまえき /小山駅/
おやまかん /小山間/
おやまこうじょう /小山工場/
おやまし /小山市/
おやまだ /小山田/
おやまのたいしょう /御山の大将/
おやまゆうえんち /小山遊園地/
おやみ /小止み/
おやむすめ /親娘/
おやもじ /親文字/
おやもと /親元/
おやゆずり /親譲り/
おやゆび /親指/拇/
おやゆびがわ /親指側/
おやゆびくん /親指君/
おゆ /お湯/
おゆうぎ /お遊戯/
おゆずり /御譲り/
おゆび /拇/
おゆるし /お許し/
おゆわり /お湯割り/御湯割り/
およぎ /泳ぎ/
およずれ /妖/
およずれごと /妖言/
およそ /凡そ/
およばずながら /及ばず乍ら/
およばれ /御呼ばれ/
および /及び/及/指/御呼び/お呼び/
およびごし /及び腰/
およめ /お嫁/
およめさん /お嫁さん/
およろこび /お喜び/お慶び/
おら /己/
おらんだ /和蘭;Olanda/
おらんだご /オランダ語;ベルギーでも使われる/
おらんだじん /オランダ人/
おり /檻;cage/澱;沈殿物/折/織;textile/折り/織り/
おりーぶいろ /オリーブ色;olive green/
おりーぶゆ /オリーブ油/
おりあい /折り合い/折合い/
おりあしく /折悪しく/
おりいと /織り糸/織糸/
おりお /折尾/
おりおえき /折尾駅/
おりおり /折々/折折/
おりおんざ /オリオン座;Orion(Ori)/
おりおんせいうん /オリオン星雲/
おりかえし /折り返し/
おりかえしちてん /折り返し地点/
おりかえしてん /折り返し点/
おりかさ /折笠/織笠/
おりかた /折形/
おりかも /氈/
おりから /折柄/
おりがさ /織笠/
おりがみ /折り紙/折紙/
おりがみざいく /折り紙細工/
おりがみつき /折り紙付き;便利さは-/
おりき /織機/
おりきど /折木戸/
おりくち /降り口/下り口/
おりくちしのぶ /折口信夫;民俗学者。別名釈迢空。『古代研究』/
おりぐち /降り口/下り口/
おりけい /折罫/
おりこみ /折込/折り込み;新聞の-/折込み/
おりこみこうこく /折り込み広告/折込み広告/
おりこみずみ /織り込み済み/織込み済み/
おりごとう /オリゴ糖;oligo saccharide.整腸作用がある/
おりしげ /折茂/
おりしも /折しも/
おりじなるきょく /オリジナル曲/
おりじなるばん /オリジナル版/
おりた /織田/
おりたたみ /折り畳み/折畳み/
おりたて /折立/
おりちょう /折丁/
おりづめ /折詰/折り詰め/折詰め/
おりづる /折り鶴/折鶴/
おりど /折戸/折り戸/
おりどしき /折戸式/
おりはし /折橋/
おりはら /折原/織原/
おりば /降り場/
おりばこ /折箱/折り箱/
おりひめ /織姫/
おりひめぼし /織姫星/
おりふし /折節/
おりべ /織部/
おりべやき /織部焼/
おりほん /折本/
おりめ /折り目/折目/織り目/織目/
おりも /織茂/折茂/
おりもと /織元/
おりもの /織物/下り物/
おりものきじ /織物生地/
おりもん /織文/
おりや /織屋/
おりやま /折山/
おりょうり /お料理/
おりよく /折良く;副詞/折よく/
おりんぴっくき /オリンピック旗;Olympic flag/
おりんぴっくしゅもく /オリンピック種目/
おるすばん /お留守番/
おるせーびじゅつかん /オルセー美術館;Musee d'Orsay. www.musee-orsay.fr/
おるどびすき /オルドビス紀;[地質年代]Ordovician. 5100-4390万年前/
おれ /俺/折れ/
おれい /御礼/お礼/
おれいきん /お礼金/
おれいごえ /お礼肥/
おれいまいり /御礼参り/
おれおれさぎ /おれおれ詐欺;[新語]/
おれくぎ /折れ釘/
おれくち /折れ口/
おれさま /俺様/オレ様/
おれじしん /俺自身/
おれせん /折れ線/折線/
おれせんぐらふ /折れ線グラフ/
おれたち /俺達/
おれっち /俺っち/
おれつ /オ列/お列/
おれめ /折れ目/
おれら /俺等/俺ら/
おれんじいろ /オレンジ色/
おれんち /俺んち/俺ん家/
おろ /悪露/疎/
おろおぼえ /疎覚え/
おろか /愚か/疎か/
おろかもの /愚か者/
おろし /卸/颪/卸し/下ろし/
おろし> /卸;-価格,-正味/
おろしうり /卸売/卸売り/
おろしうりかかく /卸売価格;wholesale price/
おろしうりがいしゃ /卸売会社/
おろしうりぎょう /卸売業/
おろしうりしじょう /卸売市場/
おろしうりてん /卸売店/
おろしうりぶっかしすう /卸売物価指数;[経済]Wholesale Price Index(WPI)/
おろしかかく /卸価格/
おろしがね /下ろし金/
おろししょう /卸商/
おろしそうば /卸相場/
おろしたて /下ろし立て/
おろしどんや /卸問屋/
おろしね /卸値/
おろしまち /卸町/
おろそか /疎か/
おろち /大蛇/
おわ /尾羽/
おわい /汚穢/
おわいや /汚穢屋/
おわかれ /お別れ/
おわかれかい /お別れ会/
おわせ /尾鷲/
おわだ /小和田/
おわだまさこ /小和田雅子/
おわび /お詫び/
おわらい /お笑い/
おわらいぐさ /お笑い種/お笑い草/
おわらいげいにん /お笑い芸人/
おわらぶし /おわら節;[民謡]越中-/
おわり /尾張/終/終わり/終り/
おわりあさひ /尾張旭/
おわりいちのみや /尾張一宮/
おわりこまき /尾張小牧/
おわりごろ /終頃/
おわりね /終値/
おわん /お碗/
おん /恩/音/温/御/怨;怨念/穏;穏健/隠;(呉音)隠密/遠;(呉音)久遠/園;(呉音)/瘟;瘟疫/穩;「穏」の旧字/隱;「隠」の旧字/
おん> /御/
おんあい /恩愛/
おんあつ /音圧/
おんあつさ /音圧差/
おんあつち /音圧値/
おんあつひ /音圧比/
おんあつぶんぷ /音圧分布/
おんあつれべる /音圧レベル/
おんい /恩威/
おんいき /音域/
おんいん /音韻/
おんいんかん /音韻間/
おんいんがく /音韻学/
おんいんし /音韻史/
おんいんじょう /音韻上/
おんいんじょうほう /音韻情報/
おんいんせい /音韻性/
おんいんたいけい /音韻体系/
おんいんてき /音韻的/
おんいんにんしき /音韻認識/
おんいんへんか /音韻変化/
おんいんほうそく /音韻法則/
おんいんろん /音韻論/
おんえい /恩栄/
おんえん /恩怨/
おんか /音価/恩化/恩仮/恩暇/
おんかい /音階/
おんかいれんしゅう /音階練習/
おんかく /温覚/
おんかた /御方/
おんかみ /御神/御髪/
おんかん /音感/
おんが /遠賀;地名/温雅/音画/
おんがえし /恩返し/
おんがく /音楽/
おんがくあいこうしゃ /音楽愛好者/
おんがくいがい /音楽以外/
おんがくいん /音楽院/
おんがくえいが /音楽映画/
おんがくえんそう /音楽演奏/
おんがくおんきょう /音楽音響/
おんがくか /音楽家/音楽科/音楽化/
おんがくかい /音楽会/音楽界/
おんがくかつどう /音楽活動/
おんがくかん /音楽館/音楽観/
おんがくかんけい /音楽関係/
おんがくかんけいしゃ /音楽関係者/
おんがくかんしょう /音楽鑑賞/
おんがくかんとく /音楽監督/
おんがくがく /音楽学/
おんがくがくいん /音楽学院/
おんがくがくしゃ /音楽学者/
おんがくがくぶ /音楽学部/
おんがくがっかい /音楽学会/
おんがくがっこう /音楽学校;conservatoire/
おんがくがわ /音楽側/
おんがくきき /音楽機器/
おんがくきょういく /音楽教育/
おんがくきょうし /音楽教師/
おんがくきょうしつ /音楽教室/
おんがくぎょうかい /音楽業界/
おんがくけい /音楽系/
おんがくけいしき /音楽形式/
おんがくけいたい /音楽携帯/
おんがくけんきゅう /音楽研究/
おんがくげいじゅつ /音楽芸術/
おんがくげき /音楽劇/
おんがくこうぎょう /音楽工業/
おんがくこうぼう /音楽工房/
おんがくさい /音楽祭/
おんがくさいせいき /音楽再生機/
おんがくさくひん /音楽作品/
おんがくさんぎょう /音楽産業/
おんがくざっし /音楽雑誌/
おんがくし /音楽史;history/音楽誌;magazine/
おんがくしこう /音楽指向/
おんがくしじょう /音楽市場/
おんがくしつ /音楽室/
おんがくしゅう /音楽集/
おんがくしゅうだん /音楽集団/
おんがくしゅっぱん /音楽出版/
おんがくしゅっぱんしゃ /音楽出版社/
おんがくしょう /音楽賞/
おんがくしょしんしゃ /音楽初心者/
おんがくしょり /音楽処理/
おんがくしんごう /音楽信号/
おんがくしんりがく /音楽心理学/
おんがくじたい /音楽自体/
おんがくじてん /音楽辞典/
おんがくじむしょ /音楽事務所/
おんがくじょうきょう /音楽状況/
おんがくじょうほう /音楽情報/
おんがくじょうほうかがく /音楽情報科学/
おんがくじょうほうけんさく /音楽情報検索/
おんがくじょうほうしょり /音楽情報処理/
おんがくずかん /音楽図鑑/
おんがくせい /音楽性/
おんがくせいかつ /音楽生活/
おんがくせいさく /音楽制作/
おんがくぜんしゅう /音楽全集/
おんがくそざい /音楽素材/
おんがくたい /音楽隊/
おんがくたいけん /音楽体験/
おんがくたんとう /音楽担当/
おんがくだいがく /音楽大学/
おんがくちかく /音楽知覚/
おんがくづくり /音楽作り/
おんがくてき /音楽的/
おんがくてききそ /音楽的基礎/
おんがくてきこうぞう /音楽的構造/
おんがくてきしゅほう /音楽的手法/
おんがくどう /音楽堂/
おんがくにんち /音楽認知/
おんがくのとも /音楽之友/音樂之友/
おんがくのともしゃ /音楽之友社/
おんがくは /音楽派/
おんがくはいしん /音楽配信/
おんがくばたけ /音楽畑/
おんがくばんぐみ /音楽番組/
おんがくひょうろんか /音楽評論家/
おんがくびがく /音楽美学/
おんがくふう /音楽風/
おんがくぶ /音楽部/
おんがくぶんか /音楽文化/
おんがくへん /音楽編/音楽篇/
おんがくほんらい /音楽本来/
おんがくや /音楽屋/
おんがくよう /音楽用/
おんがくようご /音楽用語/
おんがくりかい /音楽理解/
おんがくりょうほう /音楽療法;[精医]musicotherapy/
おんがくりょこう /音楽旅行/
おんがくりょだん /音楽旅団/
おんがくりろん /音楽理論/
おんがくれき /音楽歴/
おんがくろん /音楽論/
おんがぐん /遠賀郡/
おんがっか /音学家/
おんがっかい /音楽会/
おんがっかん /音楽館/
おんがな /音仮名/
おんがん /温顔/
おんき /遠忌/恩紀/
おんきごう /音記号/
おんきゅう /恩給/
おんきゅうしょうしょ /恩給証書/
おんきょう /音響/音強/
おんきょうかん /音響管/
おんきょうがいしょう /音響外傷/
おんきょうがく /音響学/
おんきょうがっかい /音響学会/
おんきょうがっかいし /音響学会誌/
おんきょうきき /音響機器/
おんきょうぎじゅつ /音響技術/
おんきょうくうかん /音響空間/
おんきょうけい /音響系/
おんきょうけん /音響研/
おんきょうげんしょう /音響現象/
おんきょうこうか /音響効果/
おんきょうこうがく /音響工学/
おんきょうごうせい /音響合成/
おんきょうしんごう /音響信号/
おんきょうしんごうしょり /音響信号処理/
おんきょうしんり /音響心理/
おんきょうじゅしん /音響受信/
おんきょうじょう /音響上/
おんきょうじょうほう /音響情報/
おんきょうせっけい /音響設計/
おんきょうせっけいがっか /音響設計学科/
おんきょうせつび /音響設備/
おんきょうつうしん /音響通信/
おんきょうてき /音響的/
おんきょうとくせい /音響特性/
おんきょうふか /音響負荷/
おんきょうぶ /音響部/
おんきょうぶんせき /音響分析/
おんぎ /恩義/音義/御義/恩誼/
おんぎょう /隠形/
おんぎょく /音曲/
おんくん /音訓/
おんくんさくいん /音訓索引/
おんぐう /恩遇/
おんぐすとろーむ /Å;angstrom,(10^-10)m/
おんぐん /音群/
おんけい /恩恵/音型/
おんけいてき /恩恵的/
おんけつ /温血/
おんけつどうぶつ /温血動物/
おんけん /穏健/
おんけんは /穏健派/
おんげん /音源/
おんげんいがい /音源以外/
おんげんいち /音源位置/
おんげんがわ /音源側/音現側/
おんげんすう /音源数/
おんげんばん /音源版/
おんげんぶ /音源部/
おんげんぶぶん /音源部分/
おんげんほうこう /音源方向/
おんげんほうしき /音源方式/
おんげんよう /音源用/
おんこ /恩顧/
おんこう /温厚/音高/音効/恩光/恩幸/
おんこうとくじつ /温厚篤実/
おんこうろん /音講論/
おんこちしん /温故知新/
おんこちしんしょ /温故知新書/
おんごく /遠国/
おんさ /音叉/
おんさく /音作/
おんさん /音産/
おんざ /穏座/
おんし /恩師/恩賜;天子から賜る/音詩/恩旨;天子の考え/恩私/
おんししょう /恩賜賞/
おんしっぷ /温湿布;⇔冷湿布/
おんしつ /音質/温室/
おんしつかいぜん /音質改善/
おんしつかいぜんこうか /音質改善効果/
おんしつこうか /温室効果/
おんしつこうかがす /温室効果ガス/
おんしつこうじょう /音質向上/
おんしつさ /音質差/
おんしつさいばい /温室栽培/
おんしつそだち /温室育ち/
おんしつてき /音質的/
おんしつど /温湿度/
おんしつどけい /温湿度計/
おんしつめん /音質面/
おんしつれっか /音質劣化/
おんしゃ /御社/恩赦/音写/
おんしゃく /恩借/
おんしゅう /温州/恩讐/恩讎/
おんしょう /温床/恩賞/恩詔/恩奨/
おんしょうかた /恩賞方/
おんしょうちょう /音象徴;[言語]sound symbolism/
おんしょく /音色/温色;≒暖色/慍色;むっとした顔色/
おんしょくすう /音色数/
おんしょくはいれつ /音色配列/
おんしょくめい /音色名/
おんしらず /恩知らず/
おんしん /音信/
おんしんふつう /音信不通/
おんじ /陰地/音字/遠志/
おんじき /飲食/
おんじゃく /温石/
おんじゃくめん /温石綿/
おんじゅ /飲酒/
おんじゅうとんこう /温柔敦厚/
おんじゅかい /飲酒戒/
おんじゅく /御宿/
おんじゅつ /恩恤/
おんじゅん /温順/音順/
おんじょう /音声/音場/温情/恩情/音情/
おんじょうかいせき /音場解析/
おんじょうかん /音場感/
おんじょうけん /音情研/
おんじょうさいせい /音場再生/
おんじょうしゅぎ /温情主義;paternalism/
おんじょうせいぎょ /音場制御/
おんじょうない /音場内/
おんじん /恩人/
おんすい /温水/
おんすいき /温水機/
おんすいぷーる /温水プール/
おんすいよく /温水浴/
おんすう /音数/
おんすうりつ /音数律/
おんず /音図/
おんせい /音声/
おんせいか /音声化/
おんせいかいせき /音声解析/
おんせいかんけい /音声関係/
おんせいがく /音声学/
おんせいがくてき /音声学的/
おんせいきかん /音声器官/
おんせいきごう /音声記号/
おんせいきょうちょう /音声強調/
おんせいきりかえ /音声切換/
おんせいくかん /音声区間/
おんせいけん /音声研/
おんせいけんきゅう /音声研究/
おんせいけんきゅうかい /音声研究会/
おんせいげんご /音声言語/
おんせいげんごしょり /音声言語処理/
おんせいごうせい /音声合成/
おんせいごうせいそうち /音声合成装置/
おんせいさんぷる /音声サンプル/
おんせいしゅうろく /音声収録/
おんせいしゅつりょく /音声出力/
おんせいしょり /音声処理/
おんせいしんごう /音声信号/
おんせいしんごうしょり /音声信号処理/
おんせいじょうほう /音声情報/
おんせいじょうほうしょり /音声情報処理/
おんせいせいせい /音声生成/
おんせいたいいき /音声帯域/
おんせいたいおう /音声対応/
おんせいたじゅう /音声多重/
おんせいたじゅうほうそう /音声多重放送/
おんせいちかく /音声知覚/
おんせいてき /音声的/
おんせいでんたつ /音声伝達/
おんせいにゅうりょく /音声入力/
おんせいにゅうりょくたんし /音声入力端子/
おんせいにんしき /音声認識/
おんせいにんしきそうち /音声認識装置/
おんせいは /音声波/
おんせいはけい /音声波形/
おんせいひょうき /音声表記/
おんせいひんしつ /音声品質/
おんせいふごうか /音声符号化/
おんせいぶ /音声部/
おんせいぶぶん /音声部分/
おんせいぶんせき /音声分析/
おんせいりかい /音声理解/
おんせき /恩錫/
おんせつ /音節/
おんせつこうぞう /音節構造/
おんせつすう /音節数/
おんせつちょう /音節長/
おんせつもじ /音節文字/
おんせん /温泉/音線/音栓/
おんせんえき /温泉駅/
おんせんかんこうち /温泉観光地/
おんせんがい /温泉街/
おんせんじょうほう /温泉情報/
おんせんじるし /温泉印/
おんせんたまご /温泉卵/
おんせんち /温泉地/
おんせんつあー /温泉ツアー/
おんせんぷーる /温泉プール/
おんせんほう /音線法/
おんせんまーく /温泉マーク/
おんせんまんじゅう /温泉饅頭/
おんせんやど /温泉宿/
おんせんよくじょう /温泉浴場/
おんせんりょうほう /温泉療法;[医]/
おんせんりょかん /温泉旅館/
おんせんりょこう /温泉旅行/
おんそ /音素/
おんそく /音速/音束;sound flux/
おんそくいか /音速以下/
おんそくひこう /音速飛行/
おんそぐん /音素群/
おんそたんい /音素単位/
おんそてき /音素的;phonemic/
おんそめい /音素名/
おんそもじ /音素文字/
おんそれつ /音素列/
おんそろん /音素論/
おんぞ /御衣/
おんぞう /音像/
おんぞうえく /怨憎会苦/
おんぞうし /御曹司/御曹子/
おんぞうていい /音像定位/
おんぞん /温存/
おんぞんりょうほう /温存療法;[医]/
おんた /音多;音声多重/
おんたい /御大/温帯/恩貸/
おんたいしょう /御大将/
おんたいせい /温帯性/
おんたいちいき /温帯地域/
おんたいちほう /温帯地方/
おんたいていきあつ /温帯低気圧/
おんたく /恩沢/
おんたけ /御岳/
おんたけさんえき /御嶽山駅/
おんだ /恩田/音田/
おんだい /音大/
おんだいせい /音大生/
おんだいそつ /音大卒/
おんだん /温暖/
おんだんか /温暖化/
おんだんかさよう /温暖化作用/
おんだんき /温暖期/
おんだんぜんせん /温暖前線;⇔寒冷前線/
おんち /音痴/恩地/
おんちく /音蓄/
おんちくけい /音蓄系/
おんちけん /音知研/
おんちゅう /御中/音注/
おんちょう /恩寵/温調;†温度調節/音調;†tone.「詩の-」/音長/
おんつう /音通/
おんてい /音程/温低/
おんていかん /音程感/
おんていがい /音程外/
おんていぶん /音程分/
おんてき /怨敵/
おんてん /恩典/温点/
おんでこざ /鬼太鼓座;[固有名詞]www.ondekoza.com/
おんと /音吐/
おんとう /穏当/温湯/
おんとろうろう /音吐朗朗/音吐朗々/
おんど /温度/音頭/音戸;地名,広島県安芸郡/
おんどかしょう /温度過昇/
おんどかんかく /温度感覚;[生理]冷覚と温覚/
おんどかんり /温度管理/
おんどく /音読/
おんどけい /温度計/
おんどこ /温床;おんしょう./
おんどこうばい /温度勾配/
おんどさ /温度差/
おんどしつど /温度湿度/
おんどじょうしょう /温度上昇/
おんどせってい /温度設定/
おんどちょうせつ /温度調節/
おんどてん /温度点/
おんどとり /音頭取り;乾杯の-/
おんどはんい /温度範囲/
おんどへんか /温度変化/
おんどほしょう /温度補償/
おんどほせい /温度補正/
おんどやくそう /温度躍層/
おんどり /雄鶏/雄鳥/
おんどる /温突/
おんな /女/恩納/恩名/音奈/♀/
おんなあそび /女遊び/
おんない /恩愛/
おんなうん /女運;⇔男運/
おんなおや /女親/
おんなかんけい /女関係/
おんながた /女形/女方/
おんながみ /女神/
おんながわ /女側/
おんなきょうし /女教師/
おんなきょうだい /女姉妹/
おんなぎみ /女君/
おんなぎらい /女嫌い/
おんなぐせ /女癖/
おんなぐるい /女狂い/
おんなけいず /婦系図/
おんなげいしゃ /女芸者/
おんなことば /女言葉/
おんなこども /女子供/
おんなころしあぶらのじごく /女殺油地獄;(1721)近松門左衛門/
おんなごころ /女心/
おんなごろし /女殺し/
おんなさんのみや /女三の宮;[源氏物語]/
おんなざか /女坂/
おんなざかり /女盛り/
おんなざちょう /女座長/
おんなししょ /女四書/
おんなしまい /女姉妹/
おんなしゃかい /女社会/
おんなしゅう /女衆/
おんなしゅじん /女主人/
おんなじ /同じ/
おんなじしん /女自身/
おんなじょたい /女所帯;⇔男所帯/
おんなずき /女好き/
おんなずもう /女相撲/
おんなせんし /女戦士/
おんなそうばし /女相場師/
おんなたいこ /女太鼓;女性幇間/
おんなたち /女達/
おんなたらし /女たらし/女誑し/女誑/
おんなだいがく /女大学/
おんなだて /女伊達/
おんなっけ /女っ気/
おんなっぷり /女っ振り/
おんなで /女手/
おんなともだち /女友達/
おんなどうし /女同士/
おんなどうらく /女道楽/
おんなども /女共/
おんななまえ /女名前/
おんなにのみや /女二の宮;[源氏物語]/
おんなのこ /女の子/女のコ/
おんなのひと /女の人/
おんなばら /女腹/
おんなばん /女版/
おんなひとり /女一人/
おんなへん /女偏;「媚」の偏/
おんなべや /女部屋/
おんなべんごし /女弁護士/
おんなべんじょ /女便所/
おんなみこ /女御子/
おんなみや /女宮/
おんなめ /妾/
おんなもじ /女文字/
おんなもの /女物/
おんなやく /女役/
おんなやもめ /女寡/
おんなゆ /女湯/
おんにん /穏忍/
おんねつ /温熱/
おんねつかんきょう /温熱環境/
おんねつりょうほう /温熱療法;[医]/
おんねん /怨念/
おんのじ /御の字/
おんはいすい /温排水/
おんば /音場/穏婆/
おんばこうか /音場効果/
おんばしらまつり /御柱祭;諏訪大社/
おんばひがさ /乳母日傘/
おんばん /音盤/
おんぱ /音波/恩波/
おんひ /音飛/
おんひょう /音標/
おんび /音尾/
おんびき /音引き/
おんびん /穏便/音便/
おんびんけい /音便形/
おんぴょう /音表/
おんぴょうもじ /音標文字/
おんぶきごう /音部記号;[音楽]ト音記号・ヘ音記号等/
おんぷ /音符;note/音譜;score/♪;quaver/
おんぷう /温風/
おんべつ /音別/
おんぼう /御坊/隠亡/
おんみ /御身/
おんみつ /隠密/
おんみつどうしん /隠密同心/
おんみつり /隠密裏/隠密裡/
おんみょう /陰陽/
おんみょうじ /陰陽師/
おんみょうどう /陰陽道/
おんめい /音名/恩名/恩命/
おんもと /御許/
おんもの /佩物;「おびもの」の転/
おんやく /音訳/
おんやさい /温野菜/
おんよう /陰陽/温容/恩養/
おんようけ /陰陽家;諸子百家/
おんようじ /陰陽師/
おんようどう /陰陽道/
おんよく /温浴/
おんよみ /音読/音読み/
おんり /遠離/厭離/
おんりえど /厭離穢土/
おんりつ /音律/
おんりょう /音量/怨霊/温良/
おんりょうちょうせい /音量調整/
おんりょうちょうせつ /音量調節/
おんる /遠流/
おんれい /御礼/恩礼/
おんれつ /音列/
おんわ /温和;†のどか。「-な気候」/穏和;†おだやか。「-な表現」/
か /蚊/化/可/下/日/歌/課/果/価/過/花/火/仮/夏/香/家/貨/科;科目/萪;(植物名)/蝌;蝌蚪(かと,おたまじゃくし)/箇/個/个/ヵ;小さなカタカナの「カ」/ヶ;「個」の略字/稼;稼動/嫁;よめ/靴;軍靴/訛;なまり/譌;「訛」の異体字/寡;寡婦/廈;大廈/厦;「廈」の異体字/賈;≒価/價;「価」の旧字(人名用漢字)/佳;佳作/掛;(慣用音)/卦/菓;菓子/夥;夥多/踝;くるぶし/顆;顆粒/華;華麗/嘩;喧嘩/譁;「嘩」の異体字/崋;崋山/暇;ひま/蝦;えび/霞;かすみ/葭;あし/遐;(とお・い)/假;「仮」の旧字/渦;うず/禍;舌禍/咼/堝;坩堝(かんか,るつぼ)/窩;眼窩/蝸;蝸牛/加;加算/伽;閼伽/迦;釈迦/跏;結跏趺坐/嘉;嘉慶/賀;年賀/架;架橋/茄;(慣用音) 茄子/袈;(漢音) 袈裟/枷;かせ/珈;珈琲/痂;かさぶた/笳;あしぶえ/何;幾何/河;河川/珂/苛;過酷/荷;出荷/呵;呵責/柯;爛柯/渮/舸/訶;摩訶不思議/軻/哥;うた/謌;「歌」の異体字/禾;のぎ/馨;かお・る/啝/戈;ほこ。干戈/罅;ひび/鹿;しか/耶;(疑問の助詞)/彼;(指示代名詞) か・の/墟;?/苟;?/
か> /可/過;過払い,過塩素酸,過冷却/加;加鉛,加糖/
かーきいろ /カーキ色;khaki/
かーどがいしゃ /カード会社/
かーどけっさい /カード決済/
かーどしき /カード式/
かーどはさん /カード破産/
かーびんじゅう /カービン銃;carbine/
かーぼんし /カーボン紙/
かーようひん /カー用品/
かあ /母/
かあさま /母様/
かあさん /母さん/
かあちゃん /母ちゃん/
かあつ /加圧/
かあつき /加圧器/
かあつすい /加圧水/
かあつすいがたげんしろ /加圧水型原子炉;PWR/
かい /会/回/解/貝/怪/快/甲斐/下位/改/階/界/海/塊;かたまり/隗;-より始めよ/櫂;oar/開/下意/歌意/戒/械;機械/誡;訓誡(=訓戒)/壊;破壊/懐;懐紙/壞;「壊」の旧字(人名用漢字)/懷;「懐」の旧字(人名用漢字)/皆;皆勤/偕;偕老同穴/揩;(ぬぐう)/楷;楷書/諧;諧謔/悔;悔悟/晦;韜晦/誨;教誨/魁;さきがけ/瑰;≒魁/傀;傀儡/嵬/槐;えんじゅ/介;介護/芥;あくた/价/畍;「界」の異体字/疥;疥癬/蟹;かに/蠏;「蟹」の異体字/廨;(役所)/懈;懈惰/觧;「解」の異体字/邂;邂逅/囘;「回」の異体字/廻;廻船問屋/徊;徘徊/茴;茴香(ういきょう)/蛔;蛔虫/迴;(めぐる)/灰;灰燼/恢;恢復/詼;(たわむれる)/絵;絵画/繪;「絵」の旧字/會;「会」の旧字/獪;老獪/拐;誘拐/枴;(おうご)/潰;潰滅/乖;乖離/喙;容喙/丐;(こう)/匯;(めぐる)/咼/夬;(わける)/恠;「怪」の異体字/椢;(くぬぎ)/榿;(はんのき)/褂;(うちかけ)/峡/醢;ひしお/街;まち/買い/飼/飼い/交い/垣;(熟字訓)垣間/χ;chi/Χ;Chi/
かい> /開/改/皆/怪;怪魚,怪事件,怪人物/下位;-領域,-互換性,-20%/
かいあく /改悪/
かいあげ /買い上げ/買上げ/
かいあわせ /貝合わせ/貝合せ/
かいい /怪異/階位/会意/魁偉/海尉/介意/
かいいき /海域/
かいいきがい /海域外/
かいいぬ /飼い犬;よく手を噛む/飼犬/
かいいもじ /会意文字;「日」+「月」＝「明」/
かいいれ /買入れ/買い入れ/買入/
かいいれさいむ /買入債務/
かいいれしょうきゃく /買入れ消却/
かいいん /会員/開院/海員/改印/
かいいんいがい /会員以外/
かいいんか /会員課/
かいいんかーど /会員カード/
かいいんかかく /会員価格/
かいいんかくしゃ /会員各社/
かいいんかん /会員間/
かいいんかんゆう /会員勧誘/
かいいんがい /会員外/
かいいんがっこう /海員学校/
かいいんきやく /会員規約/
かいいんけん /会員権/
かいいんし /会員誌/
かいいんしかく /会員資格/
かいいんしゅべつ /会員種別/
かいいんしょう /会員証/
かいいんしょうかい /会員紹介/
かいいんすう /会員数/
かいいんせい /会員制/
かいいんせいど /会員制度/
かいいんせんよう /会員専用/
かいいんせんようでんわ /会員専用電話/
かいいんぜんいん /会員全員/
かいいんそしき /会員組織/
かいいんとうろく /会員登録/
かいいんとくてん /会員特典/
かいいんとどけ /改印届/
かいいんどうし /会員同士/
かいいんないがい /会員内外/
かいいんはんばい /会員販売/
かいいんばんごう /会員番号/
かいいんぼ /会員簿/
かいいんぼしゅう /会員募集/
かいいんめいぼ /会員名簿/
かいいんゆうし /会員有志/
かいいんよう /会員用/
かいいんりょうきん /会員料金/
かいいんわりびき /会員割引/
かいう /海芋/
かいうん /開運/海運/海雲/
かいうんぎょう /海運業/
かいうんこく /海運国/
かいえい /開映/
かいえいまえ /開映前/
かいえき /改易/
かいえだ /海江田/
かいえん /開演/開園/海塩/怪演/海燕/開宴/快演/海淵/
かいえんじかん /開演時間/
かいえんたい /海援隊/
かいえんちゅう /開演中/
かいえんばん /開円板/
かいえんまえ /開演前/
かいおうせい /海王星/
かいおうせいきどう /海王星軌道/
かいおうまる /海王丸/
かいおき /買い置き/
かいおん /快音/回音/開音;[音声学]open sound/介音/
かいおんじ /海音寺/
かいおんせつ /開音節/
かいか /開花;†blossom.「才能が-する」/階下/開架;⇔閉架。「-図書」/開化;†civilise.「文明-」/怪火/開果/槐花/
かいかい /開会/恢恢;ゆったり。「天網-」/
かいかいあいさつ /開会挨拶/
かいかいいん /会会員/
かいかいしき /開会式/
かいかいしきちょくご /開会式直後/
かいかいせんげん /開会宣言/
かいかいそう /下位階層/
かいかえ /買い替え/買い換え/買換え/買替え/
かいかく /改革/開核/
かいかくあん /改革案/
かいかくがわ /改革側/
かいかくど /開角度/
かいかくは /改革派/
かいかくろせん /改革路線/
かいかけ /買掛/
かいかけきん /買掛金/
かいかけちょう /買掛帳/
かいかしき /開架式/
かいかた /買い方/買方/
かいかつ /快活/開豁/
かいかつどう /会活動/
かいかてんのう /開化天皇/
かいかわ /會川/
かいかん /快感/会館/開館/開巻/會舘/会舘/開管/怪漢/快漢/
かいかんがわ /会館側/
かいかんげんそく /快感原則;[精医]Lustprinzip/
かいかんじ /怪幹事/
かいが /絵画/怪訝/繪畫;旧字/
かいがい /海外/
かいがいあて /海外宛/
かいがいえんせい /海外遠征/
かいがいかつどう /海外活動/
かいがいきんむ /海外勤務/
かいがいけいけん /海外経験/
かいがいけしょうひん /海外化粧品/
かいがいけんしゅう /海外研修/
かいがいさいしんじょうほう /海外最新情報/
かいがいさくひん /海外作品/
かいがいしじょう /海外市場/
かいがいしてん /海外支店/
かいがいしゅっちょう /海外出張/
かいがいしゅっちょうちゅう /海外出張中/
かいがいしゅぼば /海外種牡馬/
かいがいしんしゅつ /海外進出/
かいがいじょうほう /海外情報/
かいがいじんじ /海外人事/
かいがいせい /海外製/
かいがいせいかつ /海外生活/
かいがいせいさん /海外生産/
かいがいせいひん /海外製品/
かいがいそうきん /海外送金/
かいがいつあー /海外ツアー/
かいがいてんかい /海外展開/
かいがいとうし /海外投資/
かいがいとうぼう /海外逃亡/
かいがいとくはいん /海外特派員/
かいがいとこう /海外渡航/
かいがいねん /下位概念;subordinate concept./
かいがいはけん /海外派遣/
かいがいはっけん /海外発券/
かいがいはっそう /海外発送/
かいがいはっちゅう /海外発注/
かいがいはつ /海外発/
かいがいはへい /海外派兵/
かいがいばん /海外版/海外盤/
かいがいふにん /海外赴任/
かいがいぶもん /海外部門/
かいがいぶんがく /海外文学/
かいがいへん /海外編/
かいがいほうそう /海外放送;NHKの-/
かいがいほうろう /海外放浪/
かいがいぼうえき /海外貿易/
かいがいむけ /海外向け/海外向/
かいがいもの /海外物/
かいがいよう /海外用/
かいがいりゅうがく /海外留学/
かいがいりょこう /海外旅行/
かいがいりょこうしゃ /海外旅行者/
かいがいりょこうほけん /海外旅行保険/
かいがいりょこうよう /海外旅行用/
かいがいろけ /海外ロケ/
かいがく /開学/
かいがさくひん /絵画作品/
かいがてき /絵画的/
かいがてん /絵画展/
かいがね /胛/
かいがもり /貝ヶ森/貝が森/
かいがら /貝殻/
かいがらぶし /貝殻節;[民謡]鳥取。「カワイヤノー」/
かいがん /海岸/開眼/
かいがんきょく /海岸局/
かいがんせん /海岸線/
かいがんぞい /海岸沿い/海岸沿/
かいがんだんきゅう /海岸段丘/
かいがんどおり /海岸通/
かいがんぶ /海岸部/
かいがんへいや /海岸平野;[地理]coastal plain/
かいき /回帰/怪奇/会期/開基/会規/快気/回忌/皆既/買い気/改軌/買気/回歸/
かいきいわい /快気祝い/快気祝/
かいきえん /怪気炎/
かいきがた /回帰型/
かいききょくせん /回帰曲線/
かいきげっしょく /皆既月食/
かいきげんしょう /怪奇現象/
かいきげんそう /怪奇幻想/
かいきしゅ /下位機種/
かいきしょうせつ /怪奇小説/
かいきしょうせつしゅう /怪奇小説集/
かいきしょく /皆既食/
かいきせん /回帰線/
かいきだいさくせん /怪奇大作戦/
かいきちゅう /会期中/
かいきてき /回帰的/
かいきてきていぎ /回帰的定義/
かいきにっしょく /皆既日食/皆既日蝕/
かいきぶんせき /回帰分析/
かいきへん /怪奇編/
かいきゃく /開脚/
かいきゅう /階級/懐旧/海丘/開球/
かいきゅういしき /階級意識/
かいきゅうかん /階級間/
かいきゅうこうぞう /階級構造/
かいきゅうさべつ /階級差別/
かいきゅうしょう /階級章/
かいきゅうせい /階級制/
かいきゅうせいとう /階級政党/
かいきゅうたいりつ /階級対立/
かいきゅうてき /階級的/
かいきゅうとうそう /階級闘争/
かいきゅうべつ /階級別/
かいきょ /快挙/開渠/
かいきょう /海峡/海況/回教/開胸;[医]-(手)術,-心マッサージ/開経/懐郷/契経/
かいきょうせん /海峡線/
かいきょうと /回教徒/
かいきょうれき /回教暦;イスラム暦/
かいきょく /開局/
かいきょくしんせい /開局申請/
かいきょくじ /開局時/
かいきょくねんがっぴ /開局年月日/
かいきり /買い切り/買切り/
かいきん /解禁/皆勤/開襟/
かいきんしょう /皆勤賞/
かいきんび /解禁日/
かいぎ /会議/懐疑/海技/回議/解義/
かいぎあんない /会議案内/
かいぎし /海技士;国家資格。航海・機関・通信・電気通信の４種/
かいぎしつ /会議室/
かいぎしゅぎ /懐疑主義/
かいぎしゅっせきしゃ /会議出席者/
かいぎしょ /会議所/
かいぎしりょう /会議資料/
かいぎじたい /会議自体/
かいぎじょう /会議場/
かいぎじろく /会議事録/
かいぎたい /会議体/
かいぎだいがっこう /海技大学校;国交省。www.mtc.ac.jp/
かいぎちゅう /会議中/
かいぎてき /懐疑的/
かいぎないよう /会議内容/
かいぎは /懐疑派/
かいぎばしょ /会議場所/
かいぎひ /会議費/
かいぎめい /会議名/
かいぎゃく /諧謔/詼謔/
かいぎゃくみ /諧謔味/
かいぎょ /海魚/怪魚/
かいぎょう /開業/改行/
かいぎょうい /開業医/
かいぎょういち /改行位置/
かいぎょういちへんこう /改行位置変更/
かいぎょうご /改行後/
かいぎょうしきん /開業資金/
かいぎょうしょにち /開業初日/
かいぎょうじ /開業時/
かいぎょうちゅう /開業中/
かいぎょうとうしょ /開業当初/
かいぎょうとうじ /開業当時/
かいぎょうび /開業日/
かいぎょうまえ /開業前/改行前/
かいぎょうもじ /改行文字/
かいぎょく /買玉;[相場]/買い玉;[相場]buying account/
かいぎろく /会議録/
かいぎろん /懐疑論;scepticism/
かいく /海区/化育/皆苦/
かいくうかん /解空間;space of solution/開空間;open space/
かいくかん /開区間/
かいくん /回訓/
かいぐ /戒具/
かいぐい /買い食い/
かいぐさ /飼い草/飼草/
かいぐん /海軍/
かいぐんきち /海軍基地/
かいぐんしょう /海軍省/
かいぐんしょうさ /海軍少佐/
かいぐんだいがっこう /海軍大学校/
かいぐんだいじん /海軍大臣/
かいぐんよびがくせい /海軍予備学生/
かいけい /会計/海景/塊茎/会稽;-の恥/快慶/
かいけいか /会計科/
かいけいかんさ /会計監査/
かいけいがく /会計学/
かいけいきかん /会計期間/
かいけいきじゅん /会計基準/
かいけいぎょうむ /会計業務/
かいけいけんさ /会計検査/
かいけいけんさいん /会計検査院/
かいけいけんさかん /会計検査官/
かいけいざん /会稽山/
かいけいし /会計士/
かいけいしょり /会計処理/
かいけいせいど /会計制度/
かいけいねんど /会計年度/
かいけいのはじ /会稽の恥/
かいけいほう /会計法/
かいけいほうこく /会計報告/
かいけいほうこくしょ /会計報告書/
かいけいりろん /階型理論;theory of types/
かいけおんせん /皆生温泉/
かいけつ /解決/快傑/怪傑/魁傑/
かいけつあん /解決案/
かいけつかてい /解決過程/
かいけつさく /解決策/
かいけつしゅだん /解決手段/
かいけつずみ /解決済み/
かいけつびょう /壊血病/
かいけつふかのう /解決不可能/
かいけつへん /解決編/解決篇/
かいけつほう /解決法/
かいけつほうほう /解決方法/
かいけはい /買気配/買い気配/
かいけん /会見/改憲/懐剣/開顕/海研/
かいけんじょう /会見場/
かいけんは /改憲派/
かいけんろん /改憲論/
かいげつ /海月/
かいげん /開眼/改元/戒厳/
かいげんしょう /怪現象/
かいげんじ /甲斐源氏/
かいげんれい /戒厳令/
かいげんれいか /戒厳令下/
かいこ /解雇/蚕/回顧;ふりかえる。「-展」/懐古;なつかしむ。「-趣味」/蠶;「蚕」の旧字/廻顧/回雇;?/蚕儚;?/解顧;?/
かいこう /開講/開校/開口/開港/邂逅/改稿/海溝/回航/海港/回行/怪光/開高;姓/海口;中国の都市/蟹行/開項/
かいこういちばん /開口一番/
かいこうおん /開口音/
かいこうかもく /開講科目/
かいこうがた /海溝型/
かいこうきねんび /開校記念日/
かいこうしき /開講式/
かいこうしゃ /偕行社/
かいこうしょうがい /開口障害/
かいこうしょく /灰黄色/
かいこうたけし /開高健/
かいこうたん /開口端/
かいこうび /開講日/
かいこうぶ /開口部/
かいこうめん /開口面/
かいこうもんじ /蟹行文字/
かいこうりつ /開口率/
かいこく /開国/戒告/会告/海国/回国/廻国;=回国/
かいこくへいだん /海国兵談;林子平(1791)/
かいこくらん /会告欄/
かいこくろん /開国論/
かいこしゅぎしゃ /懐古主義者/
かいこしゅみ /懐古趣味/
かいこだな /蚕棚/
かいこちょう /回顧調/
かいこてき /懐古的/
かいこてん /回顧展/
かいことば /買い言葉/買言葉/
かいこは /懐古派/
かいこま /甲斐駒/
かいころく /回顧録/
かいこん /開墾/開梱/悔恨/塊根/
かいこんち /開墾地/
かいご /介護/悔悟/開悟/下位語/戒護/改悟/諧語/解語/
かいごう /会合/改号/開合;[言語]開音と合音/蟹螯/
かいごうしゅうき /会合周期/
かいごかんせい /下位互換性/
かいごきゅうぎょう /介護休業/
かいごけん /介護犬/
かいごし /介護士/
かいごしせつ /介護施設/
かいごにん /介護人/
かいごふくしし /介護福祉士/
かいごほうしゅう /介護報酬/
かいごほけん /介護保険/
かいごほけんほう /介護保険法/
かいごほけんりょう /介護保険料/
かいごよう /介護用/
かいごようひん /介護用品/
かいごろし /飼い殺し/
かいさ /階差/海佐/
かいさい /開催/快哉/皆済/
かいさいあんない /開催案内/
かいさいきかん /開催期間/
かいさいきかんちゅう /開催期間中/
かいさいきかんない /開催期間内/
かいさいきじつ /開催期日/
かいさいきねん /開催記念/
かいさいけいけん /開催経験/
かいさいこく /開催国/
かいさいしんせい /開催申請/
かいさいじ /開催時/
かいさいじき /開催時期/
かいさいじゅんび /開催準備/
かいさいじょうけん /開催条件/
かいさいせきにんしゃ /開催責任者/
かいさいち /開催地/
かいさいちゅう /開催中/
かいさいちゅうし /開催中止/
かいさいちょくぜん /開催直前/
かいさいつうち /開催通知/
かいさいと /下位サイト/
かいさいとし /開催都市/
かいさいにちじ /開催日時/
かいさいにっすう /開催日数/
かいさいにってい /開催日程/
かいさいねん /開催年/
かいさいばしょ /開催場所/
かいさいび /開催日/
かいさいようこう /開催要項/
かいさいよてい /開催予定/
かいさく /開削/快作;masterpiece/改作;remake/開作;cultivate.「荒野の-」/怪作;horrible piece/開鑿;=開削/
かいさつ /改札/開札/
かいさつがかり /改札係/
かいさつき /改札機/
かいさつぐち /改札口/
かいさん /解散/海産/開山;寺院の建立/
かいさんかい /解散会/
かいさんき /開山忌/
かいさんけん /解散権/
かいさんご /解散後/
かいさんじ /解散時/
かいさんじょうたい /解散状態/
かいさんせいきゅう /解散請求;[法]住民が地方議会の解散を請求すること・する権利。<地方自治法/
かいさんせつ /解散説/
かいさんぶつ /海産物/
かいさんめいれい /解散命令/
かいざい /介在/
かいざいく /貝細工/
かいざいはいれつ /介在配列/
かいざいりょう /買い材料/
かいざん /改竄/海山/開山;山開き/買い残/改ざん/
かいざんじけん /改竄事件/
かいし /開始/会誌/海士/懐紙/海市;蜃気楼/怪死/戒師/会試;科挙の二次試験/界紙/芥子/
かいしいち /開始位置/
かいしいらい /開始以来/
かいしき /開式/解式/下意識/
かいしきごう /開始記号/
かいしきねん /開始記念/
かいしぎょう /開始行/
かいしご /開始後/
かいしじ /開始時/
かいしじかん /開始時間/
かいしじこく /開始時刻/
かいしじてん /開始時点/
かいしたん /開始端/
かいしち /開始値/
かいしちょくご /開始直後/
かいしつ /開室/
かいしつび /開室日/
かいしてん /開始点/
かいしとうしょ /開始当初/
かいしねん /開始年/
かいしひづけ /開始日付/
かいしび /開始日/
かいしまえ /開始前/
かいしめ /買占め/
かいしめい /会誌名/
かいしゃ /会社/膾炙;人口に-する(=広く愛される)/會社;「会」旧字/
かいしゃあんない /会社案内/
かいしゃいん /会社員/
かいしゃいんせいかつ /会社員生活/
かいしゃかん /会社間/
かいしゃかんけい /会社関係/
かいしゃかんけいしゃ /会社関係者/
かいしゃがいよう /会社概要/
かいしゃがえり /会社帰り/
かいしゃがわ /会社側/
かいしゃく /解釈/介錯/解釋/
かいしゃくかいけん /解釈改憲;F15やM1は陸海空その他の戦力ではありません/
かいしゃくかのう /解釈可能/
かいしゃくがく /解釈学/
かいしゃくけい /解釈系/
かいしゃくしゃ /解釈者/
かいしゃくじっこう /解釈実行/
かいしゃくほう /解釈法/
かいしゃくほうほう /解釈方法/
かいしゃくろん /解釈論/
かいしゃけいえい /会社経営/
かいしゃこうせい /会社更生/
かいしゃこうせいほう /会社更生法/
かいしゃしゃかい /会社社会/
かいしゃしゃちょう /会社社長/
かいしゃしょうかい /会社紹介/
かいしゃじたい /会社自体/
かいしゃじん /会社人/
かいしゃせい /会社製/
かいしゃせいかつ /会社生活/
かいしゃせいり /会社整理/
かいしゃせつめいかい /会社説明会/
かいしゃせん /会社線/
かいしゃぜんたい /会社全体/
かいしゃそしき /会社組織/
かいしゃぞう /開写像/
かいしゃたんい /会社単位/
かいしゃづとめ /会社勤め/
かいしゃない /会社内/
かいしゃないぶ /会社内部/
かいしゃにんげん /会社人間/
かいしゃほう /会社法/
かいしゃほうもん /会社訪問/
かいしゃめい /会社名/
かいしゃもち /会社もち/
かいしゃやくいん /会社役員/
かいしゃろく /会社録/
かいしゅ /拐取/
かいしゅう /回収/改修;repair.「ビルの-工事」/改宗;convert.「ムスリムへの-」/会衆/回收;「収」旧字/
かいしゅうがく /回収額/
かいしゅうこうじ /改修工事/
かいしゅうこうじちゅう /改修工事中/
かいしゅうごう /開集合/
かいしゅうさき /回収先/
かいしゅうしゃ /回収車/
かいしゅうちゅう /改修中/回収中/
かいしゅうばこ /回収箱/
かいしゅうばしょ /回収場所/
かいしゅうりつ /回収率/
かいしゅん /回春/改悛/悔悛;≒改悛/買春/
かいしゅんびょういん /回春病院/
かいしょ /開所/楷書/甲斐性;=かいしょう/会所/回書/
かいしょう /解消/改称/快勝/甲斐性/海象;maritime phenomena/海商/海将/介紹/海嘯/会商/海相/回章/廻章/
かいしょうかん /解消感/
かいしょうぎじゅつ /解消技術/
かいしょうさく /解消策/
かいしょうなし /甲斐性無し/
かいしょうほう /解消法/
かいしょく /会食/快食;-快眠/解職/海食/
かいしょくがい /海食崖/
かいしょくせいきゅう /解職請求/
かいしょくだい /海食台/
かいしょくどう /海食洞/
かいしょしき /開所式/
かいしょたい /楷書体/
かいしよてい /開始予定/
かいしろ /垣代/
かいしん /会心;†satisfaction.「-の笑み|一撃」/改心;†reform.「犯罪者の-」/回診;「医師の-」/回心;†[宗教]convert.「キリスト教に-」/快心;†pleasant.「-の出来事」/改新/開進/海進;[地学]marine transgression/改進/戒心/
かいしんげき /快進撃/
かいじ /開示/海事/海自;[略語]海上自衛隊/怪事/甲斐路/解字/快事/
かいじがく /解字学/
かいじけん /怪事件/
かいじさいけん /開示債権/
かいじじょうほう /開示情報/
かいじせいきゅう /開示請求/
かいじせいきゅうけん /開示請求権/
かいじつ /会日;会合のある日/晦日;月の末日/
かいじむきょく /会事務局/
かいじゃり /海砂利/
かいじゅ /槐樹/解呪/
かいじゅう /怪獣;monster/海獣;sea animal/懐柔/晦渋/
かいじゅうえいが /怪獣映画/
かいじゅうご /怪獣語/
かいじゅうさく /懐柔策/
かいじゅうだいひゃっか /怪獣大百科/
かいじゅうめい /怪獣名/
かいじゅんびかい /会準備会/
かいじょ /解除/介助/
かいじょう /会場/海上/開場/階上/開錠/開城/塊状/階乗/回状/廻状/塊上/階状/解錠/
かいじょうあんないず /会場案内図/
かいじょううけつけ /会場受付/
かいじょうえ /戒定慧;[仏教]/
かいじょうかさい /海上火災/
かいじょうかさいほけん /海上火災保険/
かいじょうがい /会場外/
かいじょうがかり /会場係/
かいじょうがわ /会場側/
かいじょうけん /海上権/
かいじょうげんていひん /会場限定品/
かいじょうこうえん /海上公園/
かいじょうこうつう /海上交通/
かいじょうごえい /海上護衛/
かいじょうしょうとつよぼうほう /海上衝突予防法/
かいじょうじ /開場時/
かいじょうじえいたい /海上自衛隊/
かいじょうじかん /開場時間/
かいじょうじゅう /会場中/
かいじょうじゅんび /会場準備/
かいじょうせいり /会場整理/
かいじょうぜんたい /会場全体/
かいじょうだい /会場代/
かいじょうていいん /会場定員/
かいじょうない /会場内/
かいじょうひ /会場費/
かいじょうふきん /会場付近/
かいじょうほあんだいがっこう /海上保安大学校;www.jcga.ac.jp/
かいじょうほあんちょう /海上保安庁/
かいじょうほう /怪情報/
かいじょうほけん /海上保険/
かいじょうぼうえい /海上防衛/
かいじょうまえ /会場前/開場前/
かいじょうめい /会場名/
かいじょうゆそうろ /海上輸送路/
かいじょけん /介助犬/解除権/
かいじょしゃ /介助者/
かいじょじょうけん /解除条件/
かいじり /海尻/
かいじん /怪人/海神/海人/灰燼;燃え滓。「-に帰す」/灰塵;灰とチリ。取るに足りぬもの/
かいじんぶつ /怪人物/
かいすい /海水/
かいすいおん /海水温/
かいすいおんど /海水温度/
かいすいぎ /海水着/
かいすいぎょ /海水魚/
かいすいちゅう /海水中/
かいすいぱんつ /海水パンツ;swim trunks/
かいすいめん /海水面/
かいすいよく /海水浴/
かいすいよくきゃく /海水浴客/
かいすいよくじょう /海水浴場/
かいすう /回数/階数/
かいすうけん /回数券/
かいすうじゅん /回数順/
かいず /海図/海津/
かいずか /貝塚;※仮名遣い「かいづか」/
かいせ /貝瀬/
かいせい /改正/快晴/回生/開成/海星/改姓/改製;remake/海棲/魁星;Dubhe/
かいせいあん /改正案/開盛庵/
かいせいいぜん /改正以前/
かいせいきてい /改正規定/
かいせいげんあん /改正原案/
かいせいこうこう /開成高校/
かいせいご /改正後/
かいせいごう /改正号/
かいせいしっこう /回生失効/
かいせいしゃ /偕成社;[出版社名]www.kaiseisha.co.jp/
かいせいじ /改正時/回生時/
かいせいじょうほう /改正情報/
かいせいせいどう /回生制動/
かいせいそう /海成層/
かいせいてん /改正点/
かいせいでんりゅう /回生電流/
かいせいでんりょく /回生電力/
かいせいばん /改正版/
かいせいび /改正日/
かいせいほう /改正法/
かいせいまえ /改正前/
かいせき /解析/懐石/会席/階席/
かいせきかい /解析解/
かいせきかんすう /解析関数/
かいせきがく /解析学/
かいせきき /解析器/
かいせききかがく /解析幾何学/
かいせききかん /解析機関/
かいせきぎ /解析木/
かいせきぎじゅつ /解析技術/
かいせきぎほう /解析技法/
かいせきけい /解析系/
かいせきけいかく /解析計画/
かいせきけっか /解析結果/
かいせきけんきゅうしつ /解析研究室/
かいせきしゃ /解析者/
かいせきしゅほう /解析手法/
かいせきしんごう /解析信号/
かいせきじ /解析時/
かいせきじょう /解析上/
かいせきせつぞく /解析接続/
かいせきたいしょう /解析対象/
かいせきちゅう /解析中/
かいせきてき /解析的/
かいせきてじゅん /解析手順/
かいせきほう /解析法/
かいせきほうほう /解析方法/
かいせきぼん /解析本/
かいせきりきがく /解析力学/
かいせきりょうり /懐石料理/会席料理/
かいせきろん /解析論/
かいせつ /解説/開設/回折/回雪/
かいせつかい /解説会/
かいせつきじ /解説記事/
かいせつげんしょう /回折現象/
かいせつこうし /回折格子/
かいせつしゃ /解説者/
かいせつしゃたち /解説者達/
かいせつしゅう /解説集/
かいせつしょ /解説書/
かいせつじま /回折縞/
かいせつじん /解説陣/
かいせつず /解説図/
かいせつてき /解説的/
かいせつとうしょ /開設当初/
かいせつふよう /解説不要/
かいせつぶん /解説文/
かいせつぶんしょ /解説文書/
かいせつへん /解説編/
かいせつぼん /解説本/
かいせつめい /解説名/
かいせつもくろく /解説目録/
かいせつらん /解説欄/
かいせつりつ /会設立/
かいせつりつじゅんびかい /会設立準備会/
かいせつりつそうかい /会設立総会/
かいせん /回線/海鮮/開戦/改選/海戦/開栓/会戦/回旋/疥癬/廻船/回戦/界線/回船/
かいせんいじょう /回線異常/
かいせんいちば /海鮮市場/
かいせんきほんりょうきん /回線基本料金/
かいせんこうかん /回線交換/
かいせんご /開栓後/
かいせんじじょう /回線事情/
かいせんすう /回線数/
かいせんせんようりょう /回線専用料/
かいせんぜんや /開戦前夜/
かいせんそくど /回線速度/
かいせんだい /回線代/
かいせんだん /回線断/
かいせんちゅう /改選中/
かいせんでんわ /回線電話/
かいせんどんや /廻船問屋/
かいせんひ /回線費/
かいせんひんしつ /回線品質/
かいせんへんけい /回旋変形/
かいせんもう /回線網/
かいせんりょうきん /回線料金/
かいせんりよう /回線利用/
かいぜいやくしょ /改税約書/
かいぜつ /快絶/
かいぜん /改善/
かいぜんあん /改善案/
かいぜんいけん /改善意見/
かいぜんかのう /改善可能/
かいぜんかんこく /改善勧告/
かいぜんこうか /改善効果/
かいぜんこうもく /改善項目/
かいぜんさく /改善策/
かいぜんしゅほう /改善手法/
かいぜんていあん /改善提案/
かいぜんてん /改善点/
かいぜんど /改善度/
かいぜんまえ /改善前/
かいぜんめいれい /改善命令;公取委の-/
かいぜんやく /改善薬/
かいぜんようきゅう /改善要求/
かいぜんりつ /改善率/
かいそ /改組/開祖/海鼠;ナマコ/
かいそう /階層/改装/回想/海藻/海草/快走/回送/会葬/改葬/下位層/回漕/潰走/海曹/回走/
かいそううちゅう /階層宇宙/
かいそううんてん /回送運転/
かいそうか /階層化/階層下/
かいそうかん /階層間/
かいそうかんけい /階層関係/
かいそうがた /階層型/
かいそうき /回想記/
かいそうこうじ /改装工事/
かいそうこうぞう /階層構造/
かいそうご /改装後/
かいそうごと /階層毎/
かいそうしゃ /回送車/
かいそうじ /回送時/
かいそうせい /階層性/
かいそうちゅう /改装中/回送中/階層中/
かいそうてき /階層的/
かいそうてきこうぞう /階層的構造/
かいそうでんしゃ /回送電車/
かいそうない /階層内/
かいそうば /買相場/
かいそうばなし /回想話/
かいそうひ /改装費/
かいそうべつ /階層別/
かいそうめい /階層名/
かいそうれっしゃ /回送列車/
かいそうろく /回想録/
かいそく /快速/会則/快足/
かいそくうんてん /快速運転/
かいそくか /快速化/
かいそくきゅうこう /快速急行/
かいそくじゅんきゅう /快速準急/
かいそくせん /快速線/
かいそくつうか /快速通過/
かいそくていしゃ /快速停車/
かいそくていしゃえき /快速停車駅/
かいそくでんしゃ /快速電車/
かいそくとっきゅう /快速特急/
かいそくば /快速馬/
かいそくよう /快速用/
かいそくれっしゃ /快速列車/
かいそしき /下位組織/
かいそん /海村;⇔山村/海損/
かいぞう /改造/解像/海象;I am the walrus, goo-goo-goo-joob!/海三/
かいぞうあん /改造案/
かいぞうき /改造機/
かいぞうきじ /改造記事/
かいぞうこうじ /改造工事/
かいぞうご /改造後/
かいぞうしゃ /改造車/
かいぞうしゃけん /改造車検/
かいぞうしゅじゅつ /改造手術/
かいぞうてん /改造点/
かいぞうど /解像度/
かいぞうどてき /解像度的/
かいぞうないかく /改造内閣/
かいぞうにんげん /改造人間/
かいぞうばん /改造版/
かいぞうひ /改造費/
かいぞうほう /改造法/
かいぞうよう /改造用/
かいぞうりょう /改造量/
かいぞうりょく /解像力/
かいぞうれき /改造歴/
かいぞえ /介添/介添え/
かいぞく /海賊/回族;中国のイスラム教徒/
かいぞくおとこ /海賊男/
かいぞくせん /海賊船/
かいぞくてき /海賊的/
かいぞくばん /海賊版/海賊盤/
かいぞくばんたいさく /海賊版対策/
かいぞめ /買い初め/
かいぞん /買い損/
かいた /海田/頴田/
かいたい /解体/懐胎/戒体/拐帯/
かいたいぎょう /解体業/
かいたいぎょうしゃ /解体業者/
かいたいこうじ /解体工事/
かいたいさぎょう /解体作業/
かいたいしゅうり /解体修理/
かいたいしんしょ /解体新書/
かいたいせつび /解体設備/
かいたいち /海田市/
かいたいや /解体屋/
かいたく /開拓/
かいたくし /開拓史/
かいたくしゃ /開拓者/
かいたくしゃせいしん /開拓者精神/
かいたくじだい /開拓時代/
かいたくち /開拓地/
かいたくのうみん /開拓農民/
かいたん /海単/
かいだ /開田/海田/貝田/改田/快打/
かいだい /改題/解題/海内/開題/
かいだか /階高/
かいだく /快諾/
かいだこ /貝蛸/
かいだこうげん /開田高原/
かいだし /買い出し/買出し/
かいだて /階建/買建/階建て/買い建て;[相場]/買建て;[相場]/
かいだめ /買いだめ/買い溜め/買い貯め;?/
かいだん /階段/会談;meeting/怪談;chilly story/解団;disband/戒壇/快談;agreable conversation/
かいだんきょうしつ /階段教室/
かいだんご /会談後/
かいだんし /快男子/
かいだんしつ /階段室/
かいだんじ /快男児/
かいだんじょう /階段状/
かいだんのぼり /階段登り/
かいだんばなし /怪談話/
かいだんふきん /階段付近/
かいだんよこ /階段横/
かいち /嘉一/垣内/
かいちく /改築/
かいちくあん /改築案/
かいちくこうじ /改築工事/
かいちくじ /改築時/
かいちくまえ /改築前/
かいちゅう /海中/回虫/懐中;pocket.「-時計」/改鋳/蛔虫;=回虫/界中/蛔蟲/懷中;旧字/
かいちゅうこうえん /海中公園/
かいちゅうでんとう /懐中電灯/
かいちゅうどけい /懐中時計/
かいちゅうもん /買い注文/
かいちょう /会長/快調/階調;tone/開帳/海鳥/怪鳥;「-ロック」/開庁;官庁の業務開始/回腸/開張;[法]=開帳。「賭博-」/諧調;harmony/
かいちょうおん /海潮音/
かいちょうしつ /会長室/
かいちょうせき /灰長石;anorthite/
かいちょく /回勅/
かいちん /開陳/
かいつう /開通/
かいつういらい /開通以来/
かいつうご /開通後/
かいつうしき /開通式/
かいつうじょうほう /開通情報/
かいつうとうしょ /開通当初/
かいつうび /開通日/
かいつうぶぶん /開通部分/
かいつうまえ /開通前/
かいつうよていび /開通予定日/
かいつけ /買い付け/買付/買付け/
かいつぶり /鳰/
かいづ /海津/
かいづか /貝塚/
かいづかし /貝塚市/
かいて /買い手/買手/
かいてい /改訂;†「本の-」/改定;†「法律の-」/海底/開廷/階梯/海程/
かいていかざん /海底火山/
かいていぐんかん /海底軍艦/
かいていこう /改訂稿/
かいていさぎょう /改訂作業/改定作業/
かいていしんでん /海底神殿/
かいていじ /改訂時/
かいていじしんけい /海底地震計/
かいていだいにはん /改訂第二版/
かいていちけい /海底地形/
かいていてつづき /改定手続/改定手続き/
かいていにまんり /海底二万里/
かいていばん /改訂版/改定版;価格-/
かいていぶん /改訂文/
かいていほうほう /改定方法/
かいていゆでん /海底油田/
かいていりれき /改訂履歴/
かいてき /快適/会的/
かいてきか /快適化/
かいてきくうかん /快適空間/
かいてきせい /快適性/
かいてしじょう /買い手市場/買手市場/
かいてん /回転/開店/廻転/廻天/廻轉/
かいてんいか /回転以下/
かいてんいき /回転域/
かいてんいす /回転椅子/
かいてんいわい /開店祝/開店祝い/
かいてんうんどう /回転運動/
かいてんおん /回転音/
かいてんかく /回転角/
かいてんかくそくど /回転角速度/
かいてんきゅうぎょう /開店休業/
かいてんけい /回転計/回転系/
かいてんさ /回転差/
かいてんざひょうけい /回転座標系/
かいてんし /回転子/
かいてんしき /回転式/
かいてんしきん /回転資金/
かいてんじ /回転時/開店時/
かいてんじかい /回転磁界/
かいてんじく /回転軸/
かいてんじくほうこう /回転軸方向/
かいてんじょ /回転所/
かいてんじょうきょう /回転状況/
かいてんすう /回転数/
かいてんすうけい /回転数計/
かいてんすうせいぎょ /回転数制御/
かいてんすしや /回転寿司屋/
かいてんずし /回転寿司/
かいてんせいのう /回転性能/
かいてんせんい /回転遷移/
かいてんそくど /回転速度/
かいてんたい /回転体/
かいてんたいしょう /回転対称/
かいてんちゅう /回転中/
かいてんちょくご /開店直後/
かいてんていすう /回転定数/
かいてんとう /回転灯/
かいてんどあ /回転ドア/
かいてんはんけい /回転半径/
かいてんば /回転刃/回転場/
かいてんばん /回転板/
かいてんび /開店日/
かいてんぶぶん /回転部分/
かいてんほうこう /回転方向/
かいてんほうほう /回転方法/
かいてんまえ /開店前/
かいてんまど /回転窓/
かいてんめん /回転面/
かいてんもくば /回転木馬/
かいてんやき /回転焼/
かいてんよく /回転翼/
かいてんりつ /回転率/
かいてんりょう /回転量/
かいてんりょく /回転力/
かいてんれいき /回転励起/
かいてんろ /回転炉/
かいでん /皆伝/海田/
かいでんぱ /怪電波/
かいと /垣内/
かいとう /回答;†response.「質問への-」/解答;†answer.「問題の-例」/解凍;†defrost.「(食品|アーカイブ)の-」/怪盗/会頭/快投;[野球]wonderful pitching/開頭;[医]craniotomy/快刀;「-乱麻」/解糖;[化学]glycolysis/解党/快盗/灰陶/海濤/
かいとうあん /回答案/
かいとういがい /回答以外/
かいとうきかん /回答期間/
かいとうぐん /解答群;†「次の-から選べ」/回答群;†「調査に寄せられた-」/
かいとうけっか /回答結果/
かいとうけん /解答権/
かいとうご /解凍後/
かいとうしだい /回答次第/
かいとうしゃ /回答者;†「アンケートの-」/解答者;†「クイズの-」/
かいとうしゃこじん /回答者個人/
かいとうしゃすう /回答者数/
かいとうしゃぜんいん /回答者全員/
かいとうしゃちゅう /回答者中/
かいとうしゅう /回答集;†「よくある質問と-」/解答集;†「ワークブックの-」/
かいとうしょ /回答書/
かいとうじ /解凍時/
かいとうすう /回答数/
かいとうせき /解答席/
かいとうちゅう /解凍中/
かいとうない /回答内/
かいとうぶん /回答文/
かいとうもと /回答元/
かいとうようし /解答用紙;†answer sheet.「テストの-」/回答用紙;†response sheet.「アンケートの-」/
かいとうらん /解答欄;†「テストの-」/回答欄;†「アンケートの-」/
かいとうらんま /快刀乱麻;-を断つ/
かいとうれい /解答例;†「試験問題の-」/回答例;†「調査票の-」/
かいとり /買取/買い取り/買取り/貝取/貝取り/
かいとりかかく /買取価格/買い取り価格/買取り価格/
かいとりて /買取手/
かいとりや /買取屋/買い取り屋/買取り屋/
かいど /開度/灰土/
かいどう /街道;甲州-/海道;東-/海堂/会堂;hall/会同;meeting/海棠;[植物]aronia/怪童/皆藤/
かいどうあと /街道跡/
かいどうすじ /街道筋/海道筋;(東)海道の道筋/
かいどうぞい /街道沿い/
かいどき /買い時/
かいどく /解読/買い得/買得/回読/会読/
かいどくのうりょく /解読能力/
かいどくふかのう /解読不可能/
かいどくほうほう /解読方法/
かいどくほん /解読本/
かいどくぼん /解読本/
かいどくよう /解読用/
かいどり /飼鳥/
かいな /腕/
かいなげ /腕挙げ/
かいなで /掻い撫で;通り一遍/
かいなひねり /腕捻り/
かいなん /海難/海南/
かいなんきゅうじょ /海難救助/
かいなんしんぱんちょう /海難審判庁/
かいなんじこ /海難事故/
かいなんとう /海南島/
かいにゅう /介入/
かいにゅうけん /介入権/
かいにん /解任/懐妊/
かいにんじょう /解任状/
かいにんそう /海仁草/海人草/
かいぬし /飼い主/買主/飼主/買い主/
かいぬま /貝沼;姓/海沼/
かいね /買値/買い値/
かいねこ /飼い猫/飼猫/
かいねんきん /皆年金/
かいのう /戒能/
かいは /会派/
かいはい /改廃/
かいはく /灰白/
かいはくしつ /灰白質/
かいはくしょく /灰白色/
かいはつ /開発/解発;elicitation/
かいはついっか /開発一課/
かいはついん /解発因/
かいはつえんじょ /開発援助/
かいはつか /開発課/
かいはつかんきょう /開発環境/
かいはつがいしゃ /開発会社/
かいはつがわ /開発側/
かいはつき /開発機/
かいはつきかくぶ /開発企画部/
かいはつきかん /開発期間/
かいはつきぼ /開発規模/
かいはつきょういく /開発教育/
かいはつきょうそう /開発競争/
かいはつきょか /開発許可/
かいはつきょく /開発局/
かいはつぎじゅつ /開発技術/
かいはつぎじゅつしゃ /開発技術者/
かいはつぎょうしゃ /開発業者/
かいはつぎょうむ /開発業務/
かいはつぐるーぷ /開発グループ/
かいはつけいかく /開発計画/
かいはつけんきゅうしつ /開発研究室/
かいはつけんきゅうじょ /開発研究所/
かいはつげんご /開発言語/
かいはつげんば /開発現場/
かいはつこうがく /開発工学/
かいはつこうがくか /開発工学科/
かいはつこうてい /開発工程/
かいはつこうりつ /開発効率/
かいはつさぎょう /開発作業/
かいはつしえん /開発支援/
かいはつしきん /開発資金/
かいはつしつ /開発室/
かいはつしゃ /開発者/
かいはつしゃかん /開発者間/
かいはつしゃがわ /開発者側/
かいはつしゅだん /開発手段/
かいはつしゅほう /開発手法/
かいはつしょう /開発省/
かいはつしょく /開発職/
かいはつじ /開発時/
かいはつじかん /開発時間/
かいはつじぎょう /開発事業/
かいはつじぎょうぶ /開発事業部/
かいはつじじょう /開発事情/
かいはつじっけんしつ /開発実験室/
かいはつじょう /開発上/
かいはつじょうきょう /開発状況/
かいはつじん /開発陣/
かいはつすいしん /開発推進/
かいはつすいしんか /開発推進課/
かいはつすいしんしつ /開発推進室/
かいはつすいしんぶ /開発推進部/
かいはつせいさく /開発製作/
かいはつぞう /開発像/
かいはつたいしょう /開発対象/
かいはつたんとう /開発担当/
かいはつたんとうしゃ /開発担当者/
かいはつだいいちぶ /開発第一部/
かいはつだいさんぶ /開発第三部/
かいはつだんかい /開発段階/
かいはつち /開発値/
かいはつちーむ /開発チーム/
かいはつちゅう /開発中/
かいはつちゅうし /開発中止/
かいはつとうかつぶ /開発統括部/
かいはつとうしょ /開発当初/
かいはつとじょう /開発途上/
かいはつとじょうこく /開発途上国/
かいはつとちゅう /開発途中/
かいはつのうりょく /開発能力/
かいはつひ /開発費/
かいはつぶ /開発部/
かいはつぶかいはつか /開発部開発課/
かいはつぶだい /開発部第/
かいはつぶもん /開発部門/
かいはつほう /開発法/
かいはつほうしき /開発方式/
かいはつほうほう /開発方法/
かいはつほうほうろん /開発方法論/
かいはつほんぶ /開発本部/
かいはつめん /開発面/
かいはつもくてき /開発目的/
かいはつもと /開発元/
かいはつよう /開発用/
かいはつよういん /開発要員/
かいはつりょう /開発量/
かいはつりょく /開発力/
かいはら /開原/
かいはん /改版;revise/開板;publish/解版;⇔組版/
かいば /海馬/飼い葉/飼葉/
かいばおけ /飼い葉桶/飼葉桶/
かいばしら /貝柱/
かいばつ /海抜/皆伐/
かいばら /柏原/海原/貝原/開原/
かいばらえきけん /貝原益軒/
かいばん /改版/改番/
かいばんさぎょう /改版作業/
かいひ /回避/会費/開扉/海彼;overseas/廻避;=回避/
かいひぎむ /回避義務/
かいひこうどう /回避行動/
かいひさく /回避策/
かいひせい /会費制/
かいひちょうしゅう /会費徴収/
かいひてき /回避的/
かいひどうさ /回避動作/
かいひなど /会費等/
かいひにゅうきん /会費入金/
かいひば /回避馬/
かいひふく /開被覆/
かいひほう /回避法/
かいひほうほう /回避方法/
かいひむりょう /会費無料/
かいひょう /開票/海氷;sea ice/解氷;ice-out/界標/回表/
かいひょうけっか /開票結果/
かいひょうさぎょう /開票作業/
かいひょうじょ /開票所/
かいひょうじょうほう /開票情報/
かいひょうせっちけん /界標設置権/
かいひょうそくほう /開票速報/
かいひょうりつ /開票率/
かいひよう /回避用/
かいひりょく /回避力/
かいひん /海浜/
かいひんまくはり /海浜幕張/
かいひんまくはりえき /海浜幕張駅/
かいひんりょくち /海浜緑地/
かいび /快美/
かいびかえ /買い控え/
かいびゃく /開闢/
かいふ /開府/回付/海部;人名/
かいふう /開封/海風/
かいふうそう /懐風藻;日本の漢詩集/
かいふうちょくご /開封直後/
かいふうつうち /開封通知/
かいふかい /快不快/
かいふき /貝吹/
かいふく /回復/開腹;laparotomy/快復;病気が-する/恢復;=回復/開福/
かいふくき /回復期/
かいふくきちょう /回復基調/
かいふくご /回復後/
かいふくざい /回復剤/
かいふくしゅじゅつ /開腹手術/
かいふくじ /回復時/
かいふくじゅつ /開腹術;[医]laparotomy/
かいふくじゅもん /回復呪文/
かいふくそち /回復措置/
かいふくとうき /回復登記/
かいふくふのう /回復不能/
かいふくほう /回復法/
かいふくりつ /回復率/
かいふくりょく /回復力/
かいぶったい /怪物体/
かいぶつ /怪物/
かいぶつせいむ /開物成務/
かいぶつたち /怪物達/
かいぶん /灰分/回文;たけやぶやけた/回分;(助数詞)/怪聞/
かいぶんしょ /怪文書/
かいぶんだけ /開聞岳/
かいぶんるい /下位分類;subclass/
かいへい /開閉/海兵/開平/皆兵/
かいへいおん /開閉音/
かいへいき /開閉器/
かいへいたい /海兵隊/
かいへいだん /海兵団/
かいへき /界壁/
かいへん /改変;†change.「ファイルの-」/改編;†reform.「組織の-」/海辺/壊変;disintegrate/貝偏;[部首]「賭」/拐騙/
かいへんき /改編期/
かいへんこうい /改変行為/
かいへんぶぶん /改変部分/
かいべくとる /解ベクトル/
かいべん /快便/快弁/
かいぺーじ /改ページ/改頁/
かいぺいじ /改頁/
かいほ /海保/
かいほう /開放;†(open)「ドアを開放する」/解放;†(liberate)「(人質|メモリ)を解放する」/会報/解法;solution.「問題の-」/介抱/快方/回報/海法;marine law/海北;人名/開法;「平方根の-」/開方;=開法/海堡/快報;good news/戒法/懐抱/壊崩/改封/潰崩/廻報;=回報/
かいほううんどう /解放運動/
かいほうかん /開放感;†(openness)「吹き抜けの-」/解放感;†(liberation)「週末の-」/
かいほうがた /開放型/解放型;?/
かいほうく /開放区/
かいほうぐん /解放軍/開放軍;?/
かいほうけい /開放系/
かいほうけいざい /開放経済/
かいほうげん /開放弦;open string/解放弦;?/
かいほうこうざ /開放講座/
かいほうさく /開放策/
かいほうじ /開放時/
かいほう