package jp.gr.java_conf.noboru.android.droidcube;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;

public class DroidCube extends Activity {

	public static final String TAG = "DroidCube";

	public static final int FIRST_ID = Menu.FIRST;

	public static final String GL_DRAW = "GL_DRAW";

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle icicle) {
		Log.d(TAG, "onCreate start");

		super.onCreate(icicle);
		setContentView(R.layout.main);
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		Log.d(TAG, "onCreateOptionsMenu start");

		boolean res = super.onCreateOptionsMenu(menu);
		menu.add(0, FIRST_ID, Menu.NONE, "画面遷移");
		return res;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		Log.d(TAG, "onOptionsItemSelected start");

		Intent i = new Intent(this, GameMain.class);
		switch (item.getItemId()) {
		case FIRST_ID:
			i = i.putExtra(GL_DRAW, GameMain.FIRST);
			break;
		default:
			i = null;
		}
		if (i != null) {
			this.startActivity(i);
		}
		return super.onOptionsItemSelected(item);
	}
}