package org.dyndns.nuda.tools.util.filter;

import java.util.ArrayList;
import java.util.List;

public class AutoReplacementFilter implements ReplacementFilter {

	@Override
	public void init() {
		
	}
	
	private static ReplacementFilter ME = null;
	private static List<ReplacementFilter> filters = new ArrayList<ReplacementFilter>();
	
	
	public static ReplacementFilter getInstance() {
		if(ME == null) {
			ME = new AutoReplacementFilter();
		}
		return ME;
	}
	
	private AutoReplacementFilter() {
		filters.add(new YenReplacementFilter());
		filters.add(new KakkoLReplacementFilter());
		filters.add(new KakkoRReplacementFilter());
		filters.add(new DotReplacementFilter());
		filters.add(new DollerReplacementFilter());
	}

	@Override
	public String replace(String source) {
		String tmp = source;
		for(ReplacementFilter filter : filters) {
			tmp = filter.replace(tmp);
		}
		return tmp;
	}

	@Override
	public String repair(String replacement) {
		String tmp = replacement;
		for(ReplacementFilter filter : filters) {
			tmp = filter.repair(tmp);
		}
		return tmp;
	}

}
