package org.dyndns.nuda.tools.plugin.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import org.dyndns.nuda.dynamic.compiler.ClassFileManager;
import org.dyndns.nuda.dynamic.compiler.CompileEngine;
import org.dyndns.nuda.dynamic.compiler.CompileTask;
import org.dyndns.nuda.dynamic.compiler.SourceBean;

public class CompilerTest {
	public static void main(String[] args) {
		
		System.setProperty(CompileTask.SYS_PROP_CLASS_PATH, "C:\\WorkSpace2\\CommonTools\\bin");
		System.setProperty(CompileTask.APP_PROP_CLASS_PATH, "E:\\【201312 INSTOK様業務】\\common-tools\\bin");
		System.setProperty(CompileTask.APP_PROP_SOURCE_PATH, "E:\\【201312 INSTOK様業務】\\common-tools\\src0");
		
		System.setProperty(CompileTask.APP_REVERT, "revert");

		File file = new File("E:\\【201312 INSTOK様業務】\\common-tools\\src\\org\\dyndns\\nuda\\test\\Test.java");
		
		StringBuilder b = new StringBuilder();
		
		readFileContent(b, file);
		
		SourceBean sBean = new SourceBean();
		sBean.setPackageName("org.dyndns.nuda.test");
		sBean.setSimpleClassName("Test");
		sBean.setSourceCode(b.toString());
		
		CompileEngine engine = CompileEngine.getInstance(sBean);
		
		engine = engine.compile();
		
		try {
			TestIF testIf = (TestIF) ClassFileManager.loadClass("org.dyndns.nuda.test.Test").newInstance();
			System.out.println(testIf.getString());
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private static void readFileContent(StringBuilder b, File file) {
		try {
			FileInputStream fis = null;
			InputStreamReader isr = null;
			BufferedReader br = null;
			try {
				fis = new FileInputStream(file);
				isr = new InputStreamReader(fis);
				br = new BufferedReader(isr);
				
				
				while(br.ready()) {
					b.append(br.readLine()).append("\n");
				}
				
			} finally {
				if(fis != null) {
					fis.close();
				}
				if(isr != null) {
					isr.close();
				}
				if(br != null) {
					br.close();
				}
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
