package org.dyndns.nuda.profile;

import org.dyndns.nuda.plugin.PluginDescription;
import org.dyndns.nuda.tools.util.StringUtil;

/**
 * シンプルなプロファイラです
 * 
 * @author nkoseki
 * 
 */
@PluginDescription(name="SimpleProfiler")
public class SimpleProfiler implements Profiler {

	@Override
	public void init() {
		ProfilerRepository.setProfiler(this);
	}

	/**
	 * アプリケーションの開始から終了までのJavaヒープ領域の空きメモリサイズとターンアラウンド時間を計測し, 結果を
	 * 標準出力へ出力します. <br />
	 */
	@Override
	public void reserveProfiler() {
		final long freeMem = Runtime.getRuntime().freeMemory();
		final long time = System.currentTimeMillis();
		Runtime.getRuntime().addShutdownHook(new Thread() {
			
			@Override
			public void run() {
				long freeMemResult = Runtime.getRuntime().freeMemory();
				long endTime = System.currentTimeMillis() - time;
				String message =
					StringUtil.format(
						"before[{}] after[{}] diff[{}] time[{} s]",
						freeMem,
						freeMemResult,
						freeMem - freeMemResult,
						((double) endTime / 1000));
				System.out.println(message);
			}
			
		});
	}
}
