package org.dyndns.nuda.dynamic.compiler.resolver;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.dyndns.nuda.dynamic.compiler.SourceBean;

/**
 * DAO(DataAccessObject)をコンパイルソースとするJavaSourceのためのリゾルバクラスです
 * 
 * @author nkoseki
 * 
 */
public class DAOBeanSourceResolver extends ClassSourceResolver {
	
	private Object	target	= null;
	
	public DAOBeanSourceResolver(final Object target) {
		this.target = target;
	}
	
	@Override
	public boolean accept(final Object target) {
		if (target instanceof Class<?>) {
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public SourceBean resolve() {
		// Class<?> targetClass = (Class<?>) this.target;
		
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		
		pw.close();
		SourceBean bean = new SourceBean();
		bean.setSourceCode(sw.toString());
		bean.setSimpleClassName("");
		bean.setPackageName("");
		
		return bean;
	}
	
	@Override
	public void setTarget(final Object target) {
		this.target = target;
	}
	
	@Override
	public Object getTarget() {
		return this.target;
	}

	@Override
	public void init() {
		AutoResolver.addResolver(this);
	}
	
}
