//
//  MSTextView_Private.h
//  Okusa
//
//  Created by 木谷 洋 on 12/03/20.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "MSPager.h"
#import "MSPageFormat.h"
#import "MSLayoutBlock.h"
#import "MSLayoutBlockManager.h"

@interface MSTextView ()
- (void)_resetCaretTimer:(id)notif;
- (void)_tickCaretTimer:(NSTimer*)timer;
- (BOOL)_shouldDrawCaret;
- (NSRect)_referenceCaretRect;
- (void)updateCaretRect;
- (void)_memoryCaretHeightIfNeed;
- (void)memoryScrollRegion;
- (void)scrollToReferenceIndex:(NSUInteger)index;
- (void)deleteCharactersInRange:(NSRange)range;
- (void)pasteAttributedString:(NSAttributedString*)aStr;
- (void)_copySelectionTo:(NSPasteboard*)pboard;
- (NSArray*)availablePboardClasses;
- (NSArray*)acceptableDraggingTypes;
- (void)_moveTextInRange:(NSRange)range
                      to:(NSUInteger)index;
@end


@interface MSTextView (Action)
- (void)deselect:(id)sender;
@end

