//
//  MSPageFormat.m
//  Manuscript
//
//  Created by 二鏡 on 12/02/11.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import "MSPageFormat.h"
static CGFloat cBoxPadding = 2.0; // 枠線分の幅二つ分

@implementation MSPageFormat
@synthesize spacingMode = spacingMode_, padding = padding_, fontName = fontName_, fontSize = fontSize_, boxCount = boxCount_, showsGrid;

+ (NSSet *)keyPathsForValuesAffectingValueForKey:(NSString *)key
{
    if([key isEqualToString: @"font"])
        return [NSSet setWithObjects: @"fontName", @"fontSize", nil];
    if([key isEqualToString: @"boxSize"])
        return [NSSet setWithObjects: @"fontSize", nil];
    if([key isEqualToString: @"boundingWidth"])
        return [NSSet setWithObjects: @"boxSize", nil];
    if([key isEqualToString: @"lineMarkBorder"])
        return [NSSet setWithObjects: @"boxSize", @"boxCount", nil];

    return [super keyPathsForValuesAffectingValueForKey: key];
}

- (id)initWithSpacingMode:(eLineSpacingMode)aMode
                  padding:(NSSize)aPadding
                 fontName:(NSString*)aName
                 fontSize:(CGFloat)aSize
                 boxCount:(NSUInteger)aCount;
{
    spacingMode_ = aMode;
    padding_ = aPadding;
    fontName_ = [aName copy];
    fontSize_ = aSize;
    boxCount_ = aCount;
    self.showsGrid = YES;
    
    return self;
}

- (CGFloat)boundingWidth
{
    CGFloat val = self.boxSize;
    switch(spacingMode_)
    {
        case eLineSpacingMode_None:
            break;
        case eLineSpacingMode_Half:
            val *= 1.5;
            break;
        case eLineSpacingMode_Full:
            val *= 2.0;
            break;
    }
    return val;
}

- (CGFloat)boxSize
{
    return fontSize_+cBoxPadding;
}

- (NSFont*)font
{
    return [NSFont fontWithName: fontName_ size:fontSize_];
}

- (CGFloat)interline
{
    return self.boundingWidth - self.boxSize;
}

- (CGFloat)lineMarkBorder
{
    const CGFloat cBoxSize = fontSize_+cBoxPadding;
    return (boxCount_-1)*cBoxSize;
}

- (NSSize)standardSizeForNewWindow
{
    CGFloat w = self.boundingWidth*20+padding_.width*2;
    CGFloat h = self.boxSize*(boxCount_+2)+padding_.height*2;
    return NSMakeSize(w,h);
}

- (NSAttributedString*)formatString:(NSString*)string
{
    id attr = [NSDictionary dictionaryWithObjectsAndKeys: [self font], NSFontAttributeName,
               [NSColor blackColor], NSForegroundColorAttributeName, 
               nil];
    
    id ret = [[NSAttributedString alloc] initWithString: string
                                             attributes: attr];
    return ret;
}

- (BOOL)validateBoxCount:(id *)ioValue error:(NSError **)outError
{
    if( *ioValue == nil )
    {
        // nilは現在値に戻す
        *ioValue = [NSNumber numberWithInt: self.boxCount];
        return YES;
    }
    return YES;
}

- (BOOL)validateFontSize:(id *)ioValue error:(NSError **)outError
{
    if( *ioValue == nil )
    {
        // nilは現在値に戻す
        *ioValue = [NSNumber numberWithInt: self.fontSize];
        return YES;
    }
    return YES;
}
@end

