//
//  MSLayoutBlock.h
//  Manuscript
//
//  Created by 二鏡 on 12/03/02.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import <Foundation/Foundation.h>
#import "CompiledAttributedString.h"
#import "VTLogicalLineContainer.h"

/*
 * 特定の範囲の属性文字列と、対応する行オブジェクトを保持するコンテナオブジェクト
 * 外側でオフセットされた行を保持するオーナーであり、自前ではレイアウト能力を持たない
 * また文字列の範囲はリロケータブルであり、他のパラグラフとの連携によってオフセットが移動する
 * 正しいレンジを指していることは外部に依存する
 */

@interface MSLayoutBlock : NSObject
{
    CompiledAttributedString *src_;
    NSArray *lines_;
    NSUInteger characterLocation_;
    NSUInteger lineOffset_;
}

- (id)initWithAttributedString:(NSAttributedString*)aString;
- (CompiledAttributedString*)string;

@property (nonatomic, readwrite,copy) NSArray *lines;
@property (nonatomic,readwrite) NSUInteger lineOffset; // cache offset
@property (nonatomic,readwrite) NSUInteger characterLocation;
@property (readonly) NSUInteger characterLength;
@property (readonly) NSRange characterRange;
@property (readonly) BOOL isClosed; // 改行終端か

- (NSUInteger)convertCharacterIndexToLocal:(NSUInteger)globalIndex;
- (NSUInteger)convertCharacterIndexToGlobal:(NSUInteger)blockLocalIndex;
- (VTLogicalLineContainer*)lineAtCharacterIndex:(NSUInteger)blockLocal;
- (NSUInteger)lineIndexAtCharacterIndex:(NSUInteger)blockLocal;
@end
