//
//  _CharacterAttributePredicate.h
//  Manuscript
//
//  Created by 二鏡 on 11/07/26.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#ifndef VTKit__CharacterAttributePredicate_h
#define VTKit__CharacterAttributePredicate_h

typedef enum
{
    cFixedWidth = 1,            // 固定幅とする文字＝全角
    cStrongBreak = 1 << 1,      // 明示的改行文字
    cWeakBreak = 1 << 2,        // そこで切っても不自然にならない文字=全角や空白、分断記号など
    cHeadProhibition = 1 << 3,  // 行頭禁則
    cTailProhibition = 1 << 4,  // 行末禁則
} eCharacterAttributeType;

class CharacterAttributePredicate
{
protected:
    inline bool isFixedWidth(uint8 c) { return c & cFixedWidth; }
    inline bool isStrongBreak(uint8 c) { return c & cStrongBreak; }
    inline bool isWeakBreak(uint8 c) { return c & cWeakBreak; }
    inline bool isHeadProhibition(uint8 c) { return c & cHeadProhibition; }
    inline bool isTailProhibition(uint8 c) { return c & cTailProhibition; }
};

#endif
