//
//  NSTextInputClientSupport.h
//  Manuscript
//
//  Created by 二鏡 on 12/02/10.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#ifndef VTKit_NSTextInputClientSupport_h
#define VTKit_NSTextInputClientSupport_h

#import <Cocoa/Cocoa.h>

// selectionやundoを構造化するためのクラス
class NSTextInputClient_Trait 
{
    NSAttributedString *undoBuffer;
    
public:
    // direct insert
    NSRange markedRange;
    NSRange selectedRange;
    // 選択範囲を向き付きで指示するためのロケーター
    CFIndex selectionAnchor,selectionLocator;
    
    NSTextInputClient_Trait()
    {
        selectedRange = NSMakeRange(0,0);
        markedRange = NSMakeRange(NSNotFound,0); // unmark状態
        selectionAnchor = -1;
    }
    
    inline NSAttributedString *get_undo_buffer() const
    {
        return undoBuffer;
    }
    
    inline void set_undo_buffer(NSAttributedString *aStr)
    {
        if(undoBuffer == aStr)
            return;
        [undoBuffer release];
        undoBuffer = [aStr copy];
    }
    
    inline bool has_marked_text() const
    {
        return markedRange.location != NSNotFound;
    }
    
    inline bool is_selected_range_nonzero() const
    {
        return selectedRange.length != 0;
    }
    
    inline bool is_selected_range_zero() const
    {
        return selectedRange.length == 0;
    }
    
    inline bool is_selected_range_at_head() const
    {
        return selectedRange.location == 0;
    }
    
    inline NSUInteger get_head_of_selection() const
    {
        return selectedRange.location;
    }
    
    inline NSUInteger get_tail_of_selection() const
    {
        return NSMaxRange(selectedRange);
    }
    
    inline NSRange get_zero_range_from_selection_head() const
    {
        return NSMakeRange(selectedRange.location,0);
    }

    inline NSRange get_zero_range_from_selection_tail() const
    {
        return NSMakeRange(NSMaxRange(selectedRange),0);
    }

    // insert/setMarkedにおいてreplacementRangeを補正する
    inline NSRange replacement_range_for_request(NSRange replacementRange) const
    {
        // 補正不要
        if(replacementRange.location != NSNotFound)
            return replacementRange;
        
        if(this->has_marked_text())
            return markedRange;
        else
            return selectedRange;
    }
    
    inline void reset_selection_anchor()
    {
        selectionAnchor = -1;
    }
    
    inline void set_anchor_to_head_of_selection()
    {
        selectionAnchor = selectedRange.location;
    }
    
    inline void set_anchor_to_tail_of_selection()
    {
        selectionAnchor = NSMaxRange(selectedRange);
    }
    
    inline bool has_valid_selection_anchor() const
    {
        return selectionAnchor != -1;
    }
    
    // selectionAnchor/selectionLocatorからなるrangeをつくる
    // selectedRangeに直接代入しないのは、@property selectedRangeを経由したいから
    inline NSRange get_anchored_range() const
    {
        CFIndex a = selectionAnchor;
        CFIndex b = selectionLocator;
        return a<b? NSMakeRange(a,b-a) : NSMakeRange(b,a-b);
    }
};

#endif
