//
//  MSPreferencesPanelController.m
//  Manuscript
//
//  Created by 二鏡 on 12/03/23.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "MSPreferencesPanelController.h"
#import "MSFontServices.h"

@interface MSPreferencesPanelController ()

@end

static id _si = nil;

@implementation MSPreferencesPanelController
@synthesize fontName;
+ (id)sharedPanel
{
    if(_si == nil)
        _si = [[self alloc] initWithWindowNibName: @"Preferences"];
    return _si;
}

- (id)initWithWindow:(NSWindow *)window
{
    self = [super initWithWindow: window];
    if(self)
    {
        self.fontName = [MSFontServices defaultFontDisplayName];
    }
    return self;
}

- (IBAction)showFontPanel:(id)sender
{
    id fontManager = [NSFontManager sharedFontManager];
    [fontManager setTarget: self];
    id panel = [NSFontPanel sharedFontPanel];
    [panel makeKeyAndOrderFront: self];
}
     
- (void)changeFont:(id)sender
{
    id font = [MSFontServices defaultFont];
    id fontManager = [NSFontManager sharedFontManager];
    font = [fontManager convertFont: font];
    id family = [font familyName];
    CFStringRef face = CTFontCopyName((CTFontRef)font, kCTFontStyleNameKey);
    [MSFontServices registerDefaultFontWithName: family 
                                           face: (id)face
                                           size: [font pointSize]];
    CFRelease(face);
    
    self.fontName = [MSFontServices defaultFontDisplayName];
}

- (void)windowWillClose:(id)sender
{
    id panel = [NSFontPanel sharedFontPanel];
    [panel orderOut: self];
}
@end
