//
//  ECLayerProxy.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/02.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECLayer.h"

@interface ECLayerProxy : NSObject
{
    ECLayer *target;
    BOOL keepAspect; // user defaultsのキャッシュ
    NSMutableSet *forceKeys;
}
@property (nonatomic,assign) ECLayer *target;
// targetが変更された時に「更新されたフリをする」キー
- (void)registerForceKeys:(NSSet*)keys;

// partial
@property (readwrite) CGFloat x;
@property (readwrite) CGFloat y;
@property (readwrite) CGFloat width;
@property (readwrite) CGFloat height;

@end
// x,y,width,heightに関するkeepAspectはこのレベルで補正

@interface ECLayerProxy (QCLayer)
- (BOOL)isCompositionLayer;
@end

