//
//  ECPostEffectEditorPanelController.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/28.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>
#import "ECCompositionSampleView.h"

@interface ECCompositionEditorPanelController : NSWindowController
{
    IBOutlet QCCompositionParameterView *parameterView;
    IBOutlet QCCompositionPickerView *pickerView;
    IBOutlet ECCompositionSampleView *sampleView;
    IBOutlet NSPopover *popover;
    ECQCCompositionItem *filter;
    BOOL hasProtocol;
    
    BOOL allowsSimulate;
    BOOL simulating;
    struct {
        CGFloat passed;
        NSTimer *timer;
    } simulation;
}
@property (readwrite,copy) ECQCCompositionItem *filter;
@property (readwrite,copy) NSString *compositionName;
@property (readonly) BOOL hasProtocol;
@property (readwrite) BOOL allowsSimulate;
+ (id)sharedPostEffectEditor;

- (void)setProtocol:(NSString*)aProtocol; // QC Protocolを設定
- (NSInteger)startModal;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;
- (IBAction)detach:(id)sender;
- (IBAction)showComposition:(id)sender;
- (IBAction)simulate:(id)sender;
- (void)loadScene:(ECScene*)scene
       layerIndex:(NSUInteger)index;

@end
