//
//  ECLongOperationPanelController.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/04.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface ECLongOperationPanelController : NSWindowController
{
    void (^cancelHandler)();
    IBOutlet NSProgressIndicator *progress;
}
+ (id)sharedPanel;
// プログレスは設定項目が多いので直接叩くことにする
@property (readonly) NSProgressIndicator *progress;
@property (readwrite) BOOL canStop;
@property (readwrite,copy) NSString *durationString;
@property (readwrite,copy) NSString *title;

- (void)beginWithCancelHandler:(void (^)())handler; 
// cancelアクションが来ると駆動される
// その中で外からモーダルを手動で止める前提の設計
// なぜならば、強制停止してもすぐにオペレーションが停まるとは限らないため、
// モーダルの停止タイミングはパネル側から把握しようがない
// オペレーションが無事成功した場合はabortで強制的に落とす
// その場合ハンドラは駆動されない
@end
