//
//  ECImageBrowserWindowController.h
//  SceneRenderProto
//
//  Created by 二鏡 on 11/11/15.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <CoreData/CoreData.h>
#import "DirectoryObserver.h"

@interface ECImageBrowserWindowController : NSWindowController
{
    IBOutlet NSPathControl *navigator;
    IBOutlet NSArrayController *itemsController;
    NSURL *currentFolder;
    DirectoryObserver *observer;
    
    NSManagedObjectModel *model;
    NSManagedObjectContext *sourceContext;
}
+ (id)sharedBrowser;
- (NSArray*)sortDescriptors;
- (void)openFolder:(NSURL*)folderURL;
- (IBAction)runOpenPanel:(id)sender;
- (IBAction)navigatorChange:(id)sender;
@end
