#include "tsk.h"
#include "it3_debug.h"
#include "it3_common.h"
#include <depend.h>

#include "kernel.h"
#include "que_ctl.h"


#define	ISVALID_TSKID(tskid)	((0 < (tskid)) && ((tskid) < TNUM_TSK))
#define	ISVALID_TSKPRI(tskpri)	((0 < (tskpri)) || ((tskpri) < TNUM_TSK))

#define	NCT						(0)

static const T_TCB tcb_initializer = {0};


/**
 * @brief	^XNNpXbh֐
 * @param	p_arg			Xbḧ
 * @desc	tskidŎw肳IDԍ^XNApk_ctskŎw肳^XNɊÂĐB
 */
static void task_crt_function(void *p_arg)
{
	T_TCB *p_tcb = (T_TCB *)p_arg;
	ID tskid;
	FP task;
	VP arg;

	IT3_ASSERT(p_tcb);

	depend_EnterCriticalSection();

	tskid = p_tcb->tskid;
	task = p_tcb->task;
	arg = p_tcb->arg;

	depend_LeaveCriticalSection();

	IT3_ASSERT(ISVALID_TSKID(tskid));
	IT3_ASSERT(task);
	IT3_ASSERT(arg);


	IT3_LOG1("task start.[tskid:%d]", tskid);
	(task)(arg);
	IT3_LOG1("task end.[tskid:%d]", tskid);

	/* ^XNI */
	depend_DestoryTask(tskid);
}

#if 0
/*--------------------------------------------------------------------------*/
/*                     TCB IsԂɂ                         */
/*--------------------------------------------------------------------------*/
ER end_func_set(ID tskid)
{
	T_TCB *p_tcb;
//	UH i;
//	UW *sp;
//	FP TaskStart;

	/*-------------------- p[^G[ ---------------------*/
	if((tskid < 0) || (TNUM_TSK <= tskid ))
	{
		/* hc͈͊O */
		return E_ID;
	}

	if(TSK_SELF == tskid)
	{
		/* ^XN̎w */
		return E_ID;
	}

	p_tcb = &(tcb[tskid]);

	if(NCT == p_tcb->tskstat)
	{
		/* ^XNo^ */
		return E_NOEXS;
	}

	p_tcb->pri		= p_tcb->endpri;
	p_tcb->tskstat	= TTS_DMT;
	p_tcb->tskwait	= 0;
	p_tcb->wid		= 0;
	p_tcb->next		= NULL;
	p_tcb->prev		= NULL;
	p_tcb->wfmode	= 0;
	p_tcb->waiptn	= 0;
	p_tcb->wupcnt	= 0;
	p_tcb->suscnt	= 0;
	p_tcb->tmout	= 0;
	p_tcb->arg		= NULL;
	/*p_tcb->sp		= p_tcb->stack;*//*	'94.01.30	c/o	*/
//	p_tcb->susmask	= FREE;

	/*------------------ WX^X^bN̐ݒ -------------------*/
	sp = (UW *)tcb->sp;

	sp--;	*sp = (UW)TaskStart;		/*	PR		*//* <- v82 */
	sp--;	*sp = 0x40000000;			/*	SR		*/
	sp--;	*sp = (UW)tcb->end_func;	/*	PC		*/

	sp--;	*sp = 0x00000000;			/*	R0		*/
	sp--;	*sp = 0x00000000;			/*	R1		*/
	sp--;	*sp = 0x00000000;			/*	R2		*/
	sp--;	*sp = 0x00000000;			/*	R3		*/
	sp--;	*sp = 0x00000000;			/*	R4		*/
	sp--;	*sp = 0x00000000;			/*	R5		*/
	sp--;	*sp = 0x00000000;			/*	R6		*/
	sp--;	*sp = 0x00000000;			/*	R7		*/

	sp--;	*sp = FPSCR_DEF;			/*	FPSCR	*//* add FPSCR */

	sp--;	*sp = 0x00000000;			/*	R8		*/
	sp--;	*sp = 0x00000000;			/*	R9		*/
	sp--;	*sp = 0x00000000;			/*	R10		*/
	sp--;	*sp = 0x00000000;			/*	R11		*/
	sp--;	*sp = 0x00000000;			/*	MACL	*/
	sp--;	*sp = 0x00000000;			/*	R12		*/
	sp--;	*sp = 0x00000000;			/*	MACH	*/
	sp--;	*sp = 0x00000000;			/*	R13		*/
	sp--;	*sp = 0x00000000;			/*	GBR		*/
	sp--;	*sp = 0x00000000;			/*	R14		*/

	/*------------------ FPUWX^X^bN̐ݒ ----------------*/
	sp--;	*sp = 0x00000000;			/*	FPUL	*/
	sp--;	*sp = FPSCR_DEF;			/*	FPSCR	*/
	sp--;	*sp = 0x00000000;			/*	FR15	*/
	sp--;	*sp = 0x00000000;			/*	FR14	*/
	sp--;	*sp = 0x00000000;			/*	FR13	*/
	sp--;	*sp = 0x00000000;			/*	FR12	*/
	sp--;	*sp = 0x00000000;			/*	FR11	*/
	sp--;	*sp = 0x00000000;			/*	FR10	*/
	sp--;	*sp = 0x00000000;			/*	FR9		*/
	sp--;	*sp = 0x00000000;			/*	FR8		*/
	sp--;	*sp = 0x00000000;			/*	FR7		*/
	sp--;	*sp = 0x00000000;			/*	FR6		*/
	sp--;	*sp = 0x00000000;			/*	FR5		*/
	sp--;	*sp = 0x00000000;			/*	FR4		*/
	sp--;	*sp = 0x00000000;			/*	FR3		*/
	sp--;	*sp = 0x00000000;			/*	FR2		*/
	sp--;	*sp = 0x00000000;			/*	FR1		*/
	sp--;	*sp = 0x00000000;			/*	FR0		*/
	sp--;	*sp = 0x00000000;			/*	XF15	*/
	sp--;	*sp = 0x00000000;			/*	XF14	*/
	sp--;	*sp = 0x00000000;			/*	XF13	*/
	sp--;	*sp = 0x00000000;			/*	XF12	*/
	sp--;	*sp = 0x00000000;			/*	XF11	*/
	sp--;	*sp = 0x00000000;			/*	XF10	*/
	sp--;	*sp = 0x00000000;			/*	XF9		*/
	sp--;	*sp = 0x00000000;			/*	XF8		*/
	sp--;	*sp = 0x00000000;			/*	XF7		*/
	sp--;	*sp = 0x00000000;			/*	XF6		*/
	sp--;	*sp = 0x00000000;			/*	XF5		*/
	sp--;	*sp = 0x00000000;			/*	XF4		*/
	sp--;	*sp = 0x00000000;			/*	XF3		*/
	sp--;	*sp = 0x00000000;			/*	XF2		*/
	sp--;	*sp = 0x00000000;			/*	XF1		*/
	sp--;	*sp = 0x00000000;			/*	XF0		*/

	tcb->sp = (VB *)sp;

	return E_OK;
}
#endif

#if 0 // TODO
void add_rdq(T_TCB *p_tcb)
{
	IT3_ASSERT(p_tcb);

	lst_insert(&(rdq[p_tcb->tskpri]), (T_LST *)p_tcb);
}

void del_rdq(T_TCB *p_tcb)
{
	IT3_ASSERT(p_tcb);

	lst_delete((T_LST *)p_tcb);
}
#endif

/**
 * @brief	^XNVXȅ
 */
ER tsk_initialize(void)
{
	INT cnt;

	/* TCB̏ */
	for(cnt = 0;cnt < TNUM_TSK;cnt++)
	{
		tcb[cnt] = tcb_initializer;
	}

	/* RDQ̏ */
	for(cnt = 0;cnt < TNUM_TSK;cnt++)
	{
		lst_init(&(rdq[cnt]));
	}

	return E_OK;
}

/**
 * @brief	^XNVXȅI
 */
void tsk_terminate(void)
{
}

ER kernel_cre_tsk(T_TCB *p_tcb)
{
	ER result;
	T_DEPEND_CTSK ctsk;
	int ret;

	IT3_ASSERT(p_tcb);

	ctsk.stksz = p_tcb->stksz;
	ctsk.p_func = task_crt_function;
	ctsk.p_param = p_tcb;

	ret = depend_CreateTask(p_tcb->tskid, &ctsk);
	if(0 == ret)
	{
		result = E_OK;
	}
	else
	{
		result = E_SYS;
	}

	return result;
}

/*
 * @brief	^XNID𓾂
 * @param	p_tskid	^XNIDi[obt@̃AhX
 * @return	߂l
 * @retval	E_OK	擾
 * @retval	E_OKȊO	擾s
 */
ER kernel_tsk_get_self_tskid(ID *p_tskid)
{
	ER result;
	T_TCB *p_tcb;

	IT3_ASSERT(ISVALID_PTR(p_tskid));

	p_tcb = (T_TCB *)depend_GetParam();
	if(p_tcb)
	{
		*p_tskid = p_tcb->tskid;

		result = E_OK;
	}
	else
	{
		result = E_CTX;
	}

	return result;
}

/**
 * @brief	TCB𓾂
 */
ER tsk_get_tcb(ID tskid, T_TCB** pp_tcb)
{
	ER result;
	T_TCB *p_tcb;

	IT3_ASSERT(ISVALID_TSKID(tskid) || (TSK_SELF == tskid));
	IT3_ASSERT(ISVALID_PTR(pp_tcb));

	if(TSK_SELF == tskid)
	{
		p_tcb = (T_TCB *)depend_GetParam();
	}
	else
	{
		p_tcb = &(tcb[tskid]);
	}

	if(ISVALID_PTR(p_tcb))
	{
		*pp_tcb = p_tcb;
		result = E_OK;
	}
	else
	{
		result = E_CTX;
	}

	return result;
}

/**
 * @brief	fBXpb`܂ő҂
 */
void tsk_wait_dispatch(void)
{
	T_TCB *p_tcb;

	p_tcb = (T_TCB *)depend_GetParam();
	if(p_tcb)
	{
		IT3_LOG1("Sleep task[tskid:%d].Wake up kernel.", p_tcb->tskid);

		depend_SwitchTask(0);
	}
	else
	{
		/* ̐̓^XNȂi܂J[ljA
			؂ւKv	*/
	}

}

/**
 * @brief	^XNfBXpb`
 */
void tsk_dispatch(void)
{
	INT cnt;
	T_LST *p_rdq;
	T_TCB *p_tcb = NULL;

//J[lfobOp
#if 0
	for(cnt = 0;cnt < (sizeof(rdq) / sizeof(rdq[0]));cnt++)
	{
		p_rdq = &(rdq[cnt]);

		IT3_LOG1("rdq[%d]", cnt);

		p_tcb = p_rdq->head;
		while(p_tcb)
		{
			IT3_LOG2("  ID:%d, NAME:%s", p_tcb->tskid, p_tcb->name);
			p_tcb = p_tcb->next;

			if(p_tcb == p_rdq->head)
			{
				break;
			}
		}

		IT3_LOG("  NULL");
	}
#endif /* 0 */
//J[lfobOp

	/* fB[L[AɋN^XN擾 */
	for(cnt = 0;cnt < (sizeof(rdq) / sizeof(rdq[0]));cnt++)
	{
		p_rdq = &(rdq[cnt]);

		if(! lst_empty(p_rdq))
		{
			p_tcb = (T_TCB *)(p_rdq->p_next);
			break;
		}
	}

	if(p_tcb)							/* s\^XN?	*/
	{
		IT3_LOG1("Wake up task.[tskid:%d]", p_tcb->tskid);
		depend_SwitchTask(p_tcb->tskid);
	}

	depend_sleep(1);
}

void tsk_wait_delete(T_LST *p_wtsklst)
{
	IT3_ASSERT(p_wtsklst);
}

void tsk_wait_release(T_TCB *p_tcb, ER ercd)
{
	IT3_ASSERT(p_tcb);
	IT3_ASSERT(0 != p_tcb->tskid);

	lst_delete((T_LST *)p_tcb);

	IT3_ASSERT(p_tcb->p_wercd);

	*(p_tcb->p_wercd) = ercd;

	if(p_tcb->tskstat & TTS_SUS)
	{
		/* d҂ */
		p_tcb->tskstat = TTS_SUS;				/* ^XNԂ SUSPEND 	*/
	}
	else
	{
		p_tcb->tskstat = TTS_RDY;				/* ^XNԂ READY  */
		p_tcb->tskwait = 0;
		p_tcb->wid = 0;

		/* bZ[W҂ */
		add_rdq(p_tcb);						/* RDQ  TCB Ȃ */
	}
}

/*
 * ==========================================================================
 * rst_tsk
 *y@\z
 *	TCBԂɖ߂
 *yz
 *		ID		tskid			^XNID
 *y߂lz
 *		E_OK		I
 *		E_IDOVR		ID͈͊O
 *		E_NOEXS		IuWFNg݂ĂȂ(tskid̃^XN݂Ȃ)
 *		E_NODMT		^XNDORMANTłȂ(tskid̃^XNDORMANTłȂ)
 *		E_OBJ		IuWFNgԃG[
 *yz
 *	tskidŎꂽ^XNTCBԂɖ߂B
 * ==========================================================================
 */
ER rst_tsk(ID tskid )
{
	ER result;

	if(ISVALID_TSKID(tskid))
	{
		T_TCB *p_tcb;

		p_tcb = &(tcb[tskid]);

		if(NCT != p_tcb->tskstat)
		{
			p_tcb->tskpri		= p_tcb->itskpri;
			p_tcb->tskstat	= TTS_DMT;
			p_tcb->tskwait	= 0;
			p_tcb->wid		= 0;
			p_tcb->next		= NULL;
			p_tcb->prev		= NULL;
//			p_tcb->wfmode	= 0;
//			p_tcb->waiptn	= 0;
			p_tcb->wupcnt	= 0;
			p_tcb->suscnt	= 0;
			p_tcb->tmout	= 0;
			p_tcb->arg		= NULL;
//			p_tcb->susmask	= FREE;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/**
 * cre_tsk
 * @brief	^XN𐶐
 * @param	tskid	^XNID
 * @param	pk_ctsk	^XÑ|C^
 * @return	G[R[h
 * @retval	E_OK		I
 * @retval	E_IDOVR		sIDԍ
 * @retval	E_NOMEM		s
 * @retval	E_RSATR		\񑮐
 * @retval	E_PAR		p[^G[
 * @retval	E_OBJ		IuWFNgԃG[
 *
 *	tskidŎw肳IDԍ^XNApk_ctskŎw肳^XN
 *	ɊÂĐB
 */
ER cre_tsk(ID tskid, T_CTSK *pk_ctsk)
{
	ER result;

	if(ISVALID_TSKID(tskid))				/* ^XNID͈͓?			*/
	{
		if(ISVALID_PTR(pk_ctsk))
		{
			T_TCB *p_tcb;
			T_TCBTMO *p_tcbtmo;

			p_tcb = &(tcb[tskid]);

			depend_EnterCriticalSection();

			if(0 == p_tcb->tskid)
			{
				*p_tcb = tcb_initializer;

				lst_init(&(p_tcb->lst));

				p_tcb->tskid	= tskid;

				p_tcb->exinf = pk_ctsk->exinf;
				p_tcb->tskatr = pk_ctsk->tskatr;
				p_tcb->task = pk_ctsk->task;
				p_tcb->itskpri = pk_ctsk->itskpri;
				p_tcb->stksz = pk_ctsk->stksz;

				p_tcb->tskpri = pk_ctsk->itskpri;
				p_tcb->tskstat = TTS_DMT;
				p_tcb->tskwait = 0;
				p_tcb->wid = 0;
				p_tcb->wupcnt = 0;
				p_tcb->suscnt = 0;

				p_tcb->p_wercd = NULL;
//				p_tcb->wfmode = 0;
//				p_tcb->waiptn = 0;


//				p_tcb->pri		= pk_ctsk->itskpri;
//				p_tcb->sts		= TTS_DMT;
//				p_tcb->wid		= 0;
				p_tcb->next		= NULL;
				p_tcb->prev		= NULL;

				p_tcb->tmout	= 0;
				p_tcb->arg		= NULL;

//				p_tcb->sta_func	= pk_ctsk->task;
//				p_tcb->end_func	= NULL;
//				p_tcb->stack	= stack + pk_ctsk->stksz;

//				p_tcb->endpri	= 0x1;
//				p_tcb->susmask	= FREE;
//				p_tcb->ipri		= pk_ctsk->itskpri;

//				p_tcb->size		= pk_ctsk->stksz / 1024;
//				p_tcb->r_size	= p_tcb->size;
//				p_tcb->scp		= (UW*)(stack + pk_ctsk->stksz);

//				strncpy(p_tcb->name, pk_ctsk->name, sizeof(p_tcb->name) - 1);

				p_tcbtmo		= &(tcbtmoq[tskid]);

				p_tcbtmo->tskid	= tskid;
				p_tcbtmo->sts	= 0;
				p_tcbtmo->next	= p_tcbtmo->prev = 0;
				p_tcbtmo->tmout	= 0;
				p_tcbtmo->tcb	= p_tcb;

				/* ^XN */
				kernel_cre_tsk(p_tcb);

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/**
 * @brief	^XN̍폜
 */
ER del_tsk(ID tskid)
{
	ER result;

	if(ISVALID_TSKID(tskid))
	{
		T_TCB *p_tcb;

		p_tcb = &(tcb[tskid]);

		depend_EnterCriticalSection();

		if(0 != p_tcb->tskid)
		{
			if(TTS_DMT == p_tcb->tskstat)
			{
				*p_tcb = tcb_initializer;

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/**
 * sta_tsk
 *
 * @brief	^XNN
 *
 * @param	tskid	^XNID
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_IDOVR	ID͈͊O(Cvgˑ)
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(tskid̃^XN݂Ȃ)
 * @retval	E_NODMT	^XNDORMANTłȂ(tskid̃^XNDORMANTłȂ)
 * @retval	E_OBJ	IuWFNgԃG[
 *
 * tskidŎꂽ^XNNB
 */
ER sta_tsk(ID tskid, INT stacd)
{
	ER result;

	if(ISVALID_TSKID(tskid))
	{
		T_TCB *p_tcb;

		p_tcb = &(tcb[tskid]);

		depend_EnterCriticalSection();

		if(0 != p_tcb->tskid)
		{
			if(TTS_DMT == p_tcb->tskstat)
			{
				rst_tsk(tskid);								/* TCB Ԃɖ߂		*/

				p_tcb->tskstat = TTS_RDY;						/* ^XNԂ READY ɂ	*/
				p_tcb->tskwait = 0;
				p_tcb->wid = 0;
				add_rdq(p_tcb);								/* TCB  RDQ ɂȂ		*/

				/* fBXpb`܂ő҂ */
				tsk_wait_dispatch();

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/**
 * @brief	^XN𐳏I
 */
void ext_tsk(void)
{
	ER ercd;									/* Ăяo֐̖߂l	*/
	T_TCB *p_tcb;

	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK == ercd)
	{
		depend_EnterCriticalSection();

		del_rdq(p_tcb);								/* RDQ  TCB O		*/

		p_tcb->tskstat = TTS_DMT;
		p_tcb->tskwait = 0;
		p_tcb->wid = 0;

	//	DSPENA = ON;								/* fBXpb`		*/

		depend_LeaveCriticalSection();

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}
}

/**
 * @brief	^XN̏Iƍ폜
 */
void exd_tsk(void)
{
	ER ret;
	T_TCB *p_tcb;

	ret = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK == ret)
	{
		depend_EnterCriticalSection();
		del_rdq(p_tcb);								/* RDQ  TCB O */

		p_tcb->tskstat = NCT;

//		DSPENA = ON;	/* fBXpb` */

		depend_LeaveCriticalSection();

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}
}


/**
 * @brief	^XNIɈُI
 */
ER ter_tsk(ID tskid)
{
	ER ercd;									/* Ăяo֐̖߂l	*/
	UINT tsksts;
	UINT waists;
	T_TCB *p_tcb;

	/*==============*/
	/* `FbN */
	/*==============*/
	if(! ISVALID_TSKID(tskid))		/* ^XNID͈͊O?		*/
	{
		return E_ID;
	}

	if(TSK_SELF == tskid)
	{
		/* ^XN̎w */
		return E_ID;
	}

	/*************/
	/* TCB擾 */
	/*************/
	ercd = tsk_get_tcb(tskid, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	tsksts = p_tcb->tskstat;				/* ^XN̏				*/
	waists = p_tcb->tskwait;				/* ҂̎				*/

	if(NCT == tsksts)
	{
		/* ^XNo^ */
		return E_NOEXS;
	}

	if(TTS_DMT == tsksts)
	{
		/* ^XN DORMANT ł */
		return E_OBJ;
	}

	/*------------------ TCB ǗubNO -----------------*/
	if(TTS_RDY == tsksts)
	{
		/* ^XN READY ̏ꍇ */
		del_rdq( p_tcb );			/* RDQ  TCB O */
	}
	else if(( tsksts == TTS_WAI )||( tsksts == TTS_WAS ))
	{
		/* ^XN WAIT or WAIT-SUSPEND ̏ꍇ  */

		switch(waists)
		{
			case WTIM:	/* ԑ҂ */
			case TTW_DLY:	/* Ԍoߑ҂ */
				del_timq( p_tcb );	/* TIMQ  TCB O */
				break;

			case TTW_FLG:	/* CxgtO҂ */
//				del_flgq(NULL, p_tcb);				/* FLGQ  TCB O */
				lst_delete((T_LST *)p_tcb);
				break;

			case TTW_SEM:  /* Z}tH҂ */
//				del_semq(NULL, p_tcb);				/* SEMQ  TCB O */
				lst_delete((T_LST *)p_tcb);
				break;

			case TTW_MBX:	/* bZ[W҂ */
//				del_mbxq(NULL, p_tcb);				/* MBXQ  TCB O */
				lst_delete((T_LST *)p_tcb);
				break;

			case (WTIM | TTW_FLG):	/* CxgtO҂ */
//				del_flgq(NULL, p_tcb);				/* FLGQ  TCB O */
				lst_delete((T_LST *)p_tcb);
				{
					T_TCBTMO *tcbtmo = &tcbtmoq[tcb->tskid];
//					del_timq(tcbtmo);				/* TIMQ  TCB O */
					tcbtmo->sts = 0;
				}
				break;

			default:	/* P҂ */
				break;
		}
	}
	else
	{
		/* ^XN SUSPEND ̏ꍇ */
	}
#if 0
	/*---------------------- I̗L ---------------------*/
	if(p_tcb->end_func != NULL )
	{
		/* I[`o^Ă */

		end_func_set(p_tcb->tskid);		/* TCB IsԂɂ */

		add_rdq( p_tcb );			/* TCB  RDQ Ȃ */
		tcb->sts = TTS_RDY;			/* ^XNԂ READY ɂ */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}
	else
	{
		/* I[`o^ĂȂ */
		tcb->sts = TTS_DMT;
	}
#endif
	return E_OK;
}

/* fBXpb`֎~ */
ER dis_dsp(void)
{
//	DSPENA = OFF;			/* fBXpb`֎~	*/
	return E_OK;
}

/* fBXpb` */
ER ena_dsp(void)
{
//	DSPENA = ON;			/* fBXpb`	*/
	return E_OK;
}

/* ^XNDxύX */
ER chg_pri(ID tskid, PRI tskpri)
{
	ER result;

	result = ichg_pri(tskid, tskpri);
	if(E_OK == result)
	{
		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return result;
}

/* ^XNDxύX (^XNƗp) */
ER ichg_pri(ID tskid, PRI tskpri)
{
	ER result;

	if(ISVALID_TSKID(tskid) || (TSK_SELF == tskid))
	{
		if(ISVALID_TSKPRI(tskpri) || (TPRI_INI == tskpri))
		{
			ER ret;
			T_TCB *p_tcb;

			ret = tsk_get_tcb(tskid, &p_tcb);
			if(E_OK == ret)
			{
				depend_EnterCriticalSection();

				if(0 != p_tcb->tskid)
				{
					if(TPRI_INI == tskpri)
					{
						tskpri = p_tcb->itskpri;
					}

					if(TTS_RDY == p_tcb->tskstat)
					{
						del_rdq(p_tcb);
						p_tcb->tskpri = tskpri;
						add_rdq(p_tcb);
					}
					else
					{
						p_tcb->tskpri = tskpri;
					}

					result = E_OK;
				}
				else
				{
					result = E_OBJ;
				}

				depend_LeaveCriticalSection();
			}
			else
			{
				result = (E_CTX == ret) ? E_ID : ret;
			}
		}
		else
		{
			result = E_PAR;
		}

	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* ^XÑfBL[] */
ER rot_rdq(PRI tskpri)
{
	ER result;

	if(ISVALID_TSKPRI(tskpri) || (TPRI_RUN == tskpri))
	{
		ER ret = E_OK;

		if(TPRI_RUN == tskpri)
		{
			T_TCB *p_tcb;

			ret = tsk_get_tcb(TSK_SELF, &p_tcb);
			if(E_OK == ret)
			{
				tskpri = p_tcb->tskpri;
			}
		}

		if(E_OK == ret)
		{
			T_LST *p_rdq;

			p_rdq = &(rdq[tskpri]);

			if(p_rdq->p_next)
			{
				T_TCB *p_tcb;

				p_rdq->p_prev = p_rdq->p_next;
				p_rdq->p_next = (p_rdq->p_next)->p_next;

				ret = tsk_get_tcb(TSK_SELF, &p_tcb);
				if(E_OK == ret)
				{
					/* fBXpb`܂ő҂ */
					tsk_wait_dispatch();

					result = E_OK;
				}
				else
				{
					result = ret;
				}
			}
			else
			{
				result = E_PAR;
			}
		}
		else
		{
			result = ret;
		}
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/* ^XÑfBL[](^XNƗp) */
ER irot_rdq(PRI tskpri)
{
	return E_NOSPT;
}

/* ^XN̑҂ԉ */
ER rel_wai(ID tskid)
{
	return E_NOSPT;

}

/* ^XN̑҂ԉ(^XNƗp) */
ER irel_wai(ID tskid)
{
	return E_NOSPT;
}

/* ^XNID𓾂 */
ER get_tid(ID *p_tskid)
{
	return kernel_tsk_get_self_tskid(p_tskid);
}

ER ref_tsk(T_RTSK *pk_rtsk, ID tskid)
{
	ER result;

	if(ISVALID_TSKID(tskid) || (TSK_SELF == tskid))
	{
		if(ISVALID_PTR(pk_rtsk))
		{
			ER ret;
			T_TCB *p_tcb;

			ret = tsk_get_tcb(tskid, &p_tcb);
			if(E_OK == ret)
			{
				depend_EnterCriticalSection();

				pk_rtsk->exinf = p_tcb->exinf;
				pk_rtsk->tskpri = p_tcb->tskpri;
				pk_rtsk->tskstat = p_tcb->tskstat;

				pk_rtsk->tskwait = p_tcb->tskwait;
				pk_rtsk->wid = p_tcb->wid;
				pk_rtsk->wupcnt = p_tcb->wupcnt;
				pk_rtsk->suscnt = p_tcb->suscnt;

				depend_LeaveCriticalSection();

				result = E_OK;
			}
			else
			{
				result = ret;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* ^XN҂Ԃֈڍs */
ER sus_tsk(ID tskid)
{
	ER result;

	if(ISVALID_TSKID(tskid))
	{
		ER ret;
		T_TCB *p_tcb;

		ret = tsk_get_tcb(tskid, &p_tcb);
		if(E_OK == ret)
		{
			depend_EnterCriticalSection();

			if(0 != p_tcb->tskid)
			{
				if(TTS_DMT != p_tcb->tskstat)
				{
					result = E_OK;

					if(TTS_RDY == p_tcb->tskstat)
					{
						del_rdq(p_tcb);
						p_tcb->tskstat = TTS_SUS;
						p_tcb->tskwait = 0;
						p_tcb->wid = 0;
					}
					else if(TTS_WAI == p_tcb->tskstat)
					{
						p_tcb->tskstat = TTS_SUS;
						p_tcb->tskwait = 0;
						p_tcb->wid = 0;
					}
					else if((TTS_SUS == p_tcb->tskstat) || (TTS_WAS == p_tcb->tskstat))
					{
						if(p_tcb->suscnt < TMAX_SUSCNT)
						{
							(p_tcb->suscnt)++;
						}
						else
						{
							result = E_QOVR;
						}
					}
					else
					{
						// not action.
					}

					if(E_OK == result)
					{
						tsk_wait_dispatch();
					}
				}
				else
				{
					result = E_OBJ;
				}
			}
			else
			{
				result = E_NOEXS;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = ret;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER isus_tsk(ID tskid)
{
	return E_NOSPT;
}

/* ҂Ԃ̃^XNĊJ */
ER rsm_tsk(ID tskid)
{
	ER result;

	if(ISVALID_TSKID(tskid))
	{
		T_TCB *p_tcb;

		p_tcb = &(tcb[tskid]);

		depend_EnterCriticalSection();

		if(0 != p_tcb->tskid)
		{
			if((TTS_DMT != p_tcb->tskstat) && (TTS_SUS & p_tcb->tskstat))
			{
				if(0 < p_tcb->suscnt)
				{
					(p_tcb->suscnt)--;
				}
				else
				{
					p_tcb->tskstat &= ~(TTS_SUS);	/* SUSPEND  */

					if(TTS_WAI != (p_tcb->tskstat & TTS_WAI))
					{
						p_tcb->tskstat = TTS_RDY;			/* ^XNԂ READY ɂ */
						p_tcb->tskwait = 0;
						p_tcb->wid = 0;
						add_rdq(p_tcb);					/* RDQ  TCB Ȃ	*/

						/* fBXpb`܂ő҂ */
						tsk_wait_dispatch();
					}
				}

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = (TSK_SELF != tskid) ? E_ID : E_OBJ;
	}

	return result;
}

ER irsm_tsk(ID tskid)
{
	return E_NOSPT;
}

ER frsm_tsk(ID tskid)
{
	return E_NOSPT;
}

ER ifrsm_tsk(ID tskid)
{
	return E_NOSPT;
}

/* ^XNN҂Ԃֈڍs */
ER slp_tsk(void)
{
	return tslp_tsk(TMO_FEVR);
}

ER tslp_tsk(TMO tmout)
{
	ER result;
	ER ret;
	T_TCB *p_tcb;

	if(ISVALID_TMOUT(tmout))
	{
		ret = tsk_get_tcb(TSK_SELF, &p_tcb);
		if(E_OK == ret)
		{
			depend_EnterCriticalSection();

			IT3_ASSERT(0 != p_tcb->tskid);
			IT3_ASSERT(TTS_RUN == p_tcb->tskstat);

			if(0 < p_tcb->wupcnt)
			{
				(p_tcb->wupcnt)--;
			}
			else
			{
				del_rdq(p_tcb);

				p_tcb->tskstat = TTS_WAI;

				if(TMO_FEVR == tmout)
				{
					p_tcb->tskwait = 0;
					p_tcb->wid = 0;
				}
				else
				{
					p_tcb->tskwait = WTIM;
					p_tcb->wid = 0;

					p_tcb->tmout = timq.time + tmout;
					add_timq(p_tcb);
				}

				/* fBXpb`܂ő҂ */
				tsk_wait_dispatch();
			}

			depend_LeaveCriticalSection();

			result = E_OK;
		}
		else
		{
			result = ret;
		}
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/* ^XN̋N */
ER wup_tsk(ID tskid)
{
	ER result;

	if(ISVALID_TSKID(tskid))
	{
		T_TCB *p_tcb;

		p_tcb = &(tcb[tskid]);

		depend_EnterCriticalSection();

		if(0 != p_tcb->tskid)
		{
			if(TTS_DMT == p_tcb->tskstat)
			{
				result = E_OK;

				if(TTS_WAI == p_tcb->tskstat)
				{
					if(WTIM == p_tcb->tskwait)	/* ԑ҂? */
					{
						del_timq(p_tcb);					/* TIMQTCBO */
					}
					else
					{
						p_tcb->tskstat = TTS_RDY;				/* ^XNԂREADY */
						add_rdq(p_tcb);						/* TCBRDQɂȂ  */
					}
				}
				else if(TTS_WAS == p_tcb->tskstat)			/* d҂ */
				{
					if(WTIM == p_tcb->tskwait)	/* ԑ҂? */
					{
						del_timq(p_tcb);					/* TIMQTCBO */
					}
					else
					{
						p_tcb->tskstat = TTS_SUS;				/* ^XNԂSUSPEND */
					}
				}
				else
				{
					if(p_tcb->wupcnt < TMAX_WUPCNT)
					{
						(p_tcb->wupcnt)++;
					}
					else
					{
						result = E_QOVR;
					}
				}

				if(E_OK == result)
				{
					/* fBXpb`܂ő҂ */
					tsk_wait_dispatch();
				}
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = (TSK_SELF != tskid) ? E_ID : E_OBJ;
	}

	return result;
}

ER iwup_tsk(ID tskid)
{
	return E_NOSPT;
}

/* ^XN̋Nv𖳌 */
ER can_wup(INT *p_wupcnt, ID tskid)
{
	ER result;

	if(ISVALID_TSKID(tskid) || (TSK_SELF == tskid))
	{
		if(ISVALID_PTR(p_wupcnt))
		{
			ER ret;
			T_TCB *p_tcb;

			ret = tsk_get_tcb(tskid, &p_tcb);
			if(E_OK == ret)
			{
				depend_EnterCriticalSection();

				if(0 != p_tcb->tskid)
				{
					if(TTS_DMT != p_tcb->tskstat)
					{
						*p_wupcnt = p_tcb->wupcnt;
						p_tcb->wupcnt = 0;

						result = E_OK;
					}
					else
					{
						result = E_OBJ;
					}
				}
				else
				{
					result = E_NOEXS;
				}

				depend_LeaveCriticalSection();
			}
			else
			{
				result = (E_CTX == ret) ? E_ID : ret;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/*
 * =============================================================================
 * W֐̎
 * =============================================================================
 */
#if 0
/*
 * --------------------------------------------------------------------------
 * ^XN莞ԑ҂Ԃֈڍs
 * --------------------------------------------------------------------------
 */
ER wai_tsk(TMO tmout)
{
	ER ercd;									/* Ăяo֐̖߂l	*/
	T_TCB *p_tcb;

//	if( DSPENA == OFF )		/* fBXpb`֎~ */
//	{
//		return( E_CTX );
//	}

	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	if(0 != p_tcb->wupcnt)						/* Nv?			*/
	{
		/* NvL[COĂ */
		(p_tcb->wupcnt)--;
	}
	else
	{
		/* NvL[COĂȂ */
		del_rdq(p_tcb);							/* TCBRDQ O      */
		p_tcb->tskstat = TTS_WAI;				/* ^XNԂ͎ԑ҂ */
		p_tcb->tskwait = WTIM;				/* ^XNԂ͎ԑ҂ */
		p_tcb->wid = 0;
		p_tcb->tmout = timq.time + tmout;		/* ^CAEgݒ */
		add_timq(p_tcb);						/* ԑ҂sɂȂ   */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return E_OK;
}

/* ^XN̏Ԃ */
ER tsk_sts(UINT *p_tskstat, PRI *p_tskpri, ID tskid)
{
	ER result;

	/*==============*/
	/* `FbN */
	/*==============*/
	if(ISVALID_TSKID(tskid))
	{
		ER ret;
		T_TCB *p_tcb;

		ret = tsk_get_tcb(tskid, &p_tcb);
		if(E_OK == ret)
		{
			if(NCT != p_tcb->sts)
			{
				if(p_tskstat)
				{
					/*----------------- ^XN̏ԁADx𓾂 ------------------*/
					if((TTS_RDY == p_tcb->sts) && (TSK_SELF == tskid))
					{
						*p_tskstat = TTS_RUN;
					}
					else
					{
						*p_tskstat = (p_tcb->sts & 0x00ff);
					}
				}

				if(p_tskpri)
				{
					*p_tskpri  = p_tcb->pri;
				}

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = ret;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}
#endif
