/**
 * @brief	EʐM@\iZ}tHj
 *
 * @author	nikarana
 * @date	2012/11/23
 */

#include "sem.h"
#include "it3_debug.h"
#include "it3_common.h"
#include "lst.h"

#include "kernel.h"

#include "que_ctl.h"

#define	ISVALID_SEMID(semid)	((0 < (semid)) && ((semid) < TNUM_SEM))
#define	ISVALID_SEMCNT(semcnt, maxsem)	((0 < (semcnt)) && ((semcnt) < (maxsem)))
#define	ISVALID_SEMATR(sematr)	(TRUE)		/* ̓`FbNȂ */

/* Z}tHǗubN(SEMCB) */
typedef struct S_SEMCB
{
	ID			semid;							/**< Z}tHID					*/

	VP			exinf;							/**< g					*/
	ATR			sematr;							/**< Z}tH				*/
	INT			maxsem;							/**< Z}tH̍ől				*/

	INT			semcnt;							/**< Z}tHJE^				*/
	T_LST		wtsklst;						/**< ҂^XNXg				*/


	T_TCB		*head;							/**< 擪TCBւ̃|C^			*/
	VH			wtskmode;						/**< ҂					*/
	ID			tskid;							/**< Z}Ă^XN		*/
	VB			dmy[6];							/**< _~[						*/
} T_SEMCB;

static const T_SEMCB semcb_initializer = {0};

static T_SEMCB semcbs[TNUM_SEM];

#if	defined(__cplusplus)
extern "C" {
#endif	/* defined(__cplusplus) */

static void CreateCriticalSection(void)
{

}

static void EnterCriticalSection(void)
{

}

static void LeaveCriticalSection(void)
{

}

/* Z}tH҂L[Ƀ^XNǉ */
static void add_semq(T_SEMCB *p_semcb, T_TCB *p_tcb)
{
	IT3_ASSERT(p_semcb);
	IT3_ASSERT(p_tcb);

	if(TA_TPRI & p_semcb->sematr)
	{
		T_LST *p_insert_pos;

		p_insert_pos = p_semcb->wtsklst.p_next;

		while(&(p_semcb->wtsklst) != p_insert_pos)
		{
			if(p_tcb->tskpri < ((T_TCB *)p_insert_pos)->tskpri)
			{
				break;
			}

			p_insert_pos = p_insert_pos->p_next;
		}

		lst_insert(p_insert_pos, (T_LST *)p_tcb);
	}
	else
	{
		lst_insert(&(p_semcb->wtsklst), (T_LST *)p_tcb);
	}


#if 0
	T_SEMCB *p_semq;
	T_TCB *toptcb, *endtcb, *nextcb, *pretcb;

	p_semq = &(semcbs[p_tcb->wid]);

	toptcb = semcbs->head;
	if(NULL != toptcb)
	{
		/*-------------------- ̃^XN --------------------*/

		if( semcbs->wtskmode == TA_TFIFO )	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endtcb       = toptcb->prev;
			p_tcb->prev = endtcb;
			p_tcb->next = toptcb;
			toptcb->prev = p_tcb;
			endtcb->next = p_tcb;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endtcb = toptcb->prev;
			nextcb = toptcb;

			do
			{
				if( p_tcb->pri < nextcb->pri )
				{

					pretcb = nextcb->prev;

					p_tcb->prev = pretcb;
					p_tcb->next = nextcb;
					nextcb->prev = p_tcb;
					pretcb->next = p_tcb;

					if( nextcb == toptcb )
					{
						p_semq->head = p_tcb;
					}
					break;
				}

				nextcb = nextcb->next;

			} while((nextcb != toptcb) && (p_semq->head != NULL));

			if(nextcb == toptcb)
			{
				p_tcb->prev = endtcb;
				p_tcb->next = toptcb;
				toptcb->prev = p_tcb;
				endtcb->next = p_tcb;
			}
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_semq->head = p_tcb;
		p_tcb->next = p_tcb;
		p_tcb->prev = p_tcb;
	}

	return;
#endif
}

/* Z}tH҂L[^XN폜 */
static void del_semq(T_SEMCB *p_semcb, T_TCB *p_tcb)
{
	IT3_ASSERT(p_tcb);

	lst_delete((T_LST *)p_tcb);

#if 0
	T_SEMCB *p_semq;
	T_TCB *pretcb, *nextcb;

	p_semq = &(semcbs[p_tcb->wid]);

	pretcb = p_tcb->prev;
	if(pretcb != p_tcb)
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = p_tcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;

		if( p_semq->head == p_tcb )
		{
			p_semq->head = nextcb;
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		semcbs->head = NULL;
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
#endif
}

ER sem_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_SEM;cnt++)
	{
		semcbs[cnt] = semcb_initializer;
	}

	return E_OK;
}

void sem_terminate(void)
{
}

/**
 * @brief	Z}tH
 *
 * @param	semid	Z}tHID
 * @param	pk_csem	Z}tH
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_NOMEM	s(ǗubNp̗̈悪mۂłȂ)
 * @retval	E_ID	sIDԍ(semids邢͗płȂ)
 * @retval	E_RSATR	\񑮐(sematrs邢͗płȂ)
 * @retval	E_OBJ	IuWFNg̏Ԃs(IDԍ̃Z}tHɑ)
 * @retval	E_OACV	IuWFNgANZXᔽ([U^XN̔ssemid<(-4), Cvgˑ)
 * @retval	E_PAR	p[^G[(pk_csems, isemcnt, maxsem܂͕s)
 * @retval	EN_OBJNO	Ώۃm[hŃANZXłȂIuWFNgԍw
 * @retval	EN_CTXID	^XNƗ邢̓fBXpb`֎~Ԃ̃^XN甭sꂽVXeR[őm[h̃IuWFNgw
 */
ER cre_sem(ID semid, T_CSEM *pk_csem)
{
	ER result;

	if(ISVALID_SEMID(semid))
	{
		if(ISVALID_PTR(pk_csem) && ISVALID_SEMCNT(pk_csem->isemcnt, pk_csem->maxsem))
		{
			if(ISVALID_SEMATR(pk_csem->sematr))
			{
				T_SEMCB *p_semcb;

				p_semcb = &(semcbs[semid]);

				if(0 == p_semcb->semid)
				{
					*p_semcb = semcb_initializer;

					p_semcb->semid = semid;

					p_semcb->exinf = pk_csem->exinf;
					p_semcb->sematr = pk_csem->sematr;
					p_semcb->maxsem = pk_csem->maxsem;

					p_semcb->semcnt = pk_csem->isemcnt;
					lst_init(&(p_semcb->wtsklst));

					p_semcb->head		= NULL;					/* 擪TCBւ̃|C^		*/
					p_semcb->wtskmode	= pk_csem->sematr;		/* ҂					*/
					p_semcb->tskid		= 0;					/* Z}Ă^XN	*/

					result = E_OK;
				}
				else
				{
					result = E_OBJ;
				}
			}
			else
			{
				result = E_RSATR;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/**
 * @brief	Z}tH폜
 *
 * @param	semid	Z}tHID
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_ID	sIDԍ(semids邢͗płȂ)
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(semid̃Z}tH݂Ȃ)
 * @retval	E_OACV	IuWFNgANZXᔽ([U^XN̔ssemid<(-4), Cvgˑ)
 * @retval	EN_OBJNO	Ώۃm[hŃANZXłȂIuWFNgԍw
 * @retval	EN_CTXID	^XNƗ邢̓fBXpb`֎~Ԃ̃^XN甭sꂽVXeR[őm[h̃IuWFNgw
 */
ER del_sem(ID semid)
{
	ER result;

	if(ISVALID_SEMID(semid))
	{
		T_SEMCB *p_semcb;

		p_semcb = &(semcbs[semid]);

		if(0 != p_semcb->semid)
		{
			T_TCB *p_tcb;

			/*----- ҂Ă^XN̑҂ -----*/
			while(! lst_empty(&(p_semcb->wtsklst)))
			{
				p_tcb = (T_TCB *)(p_semcb->wtsklst.p_next);

				del_semq(p_semcb, p_tcb);						/* SEMQ  TCB O */

				/* G[R[h҂IuWFNg̍폜 */
				*(p_tcb->p_wercd) = E_DLT;

				p_tcb->tskstat &= ~(TTS_WAI);
				p_tcb->tskwait &= ~(TTW_SEM);
				if(! (TTS_SUS & p_tcb->tskstat))
				{
					p_tcb->tskstat = TTS_RDY;				/* ^XNԂ READY  */
					p_tcb->tskwait = 0;
					p_tcb->wid = 0;
					add_rdq(p_tcb);						/* RDQ  TCB Ȃ */
				}
			}

			/*-----  -----*/
			p_semcb->semcnt		= 1;
			p_semcb->wtskmode	= TA_TFIFO;
			p_semcb->tskid		= 0;

			*p_semcb = semcb_initializer;

			/* fBXpb`܂ő҂ */
			tsk_wait_dispatch();

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/**
 * @brief	Z}tHԋp
 *
 * @param	semid	Z}tHID
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_ID	sIDԍ(semids邢͗płȂ)
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(semid̃Z}tH݂Ȃ)
 * @retval	E_OACV	IuWFNgANZXᔽ([U^XN̔ssemid<(-4), Cvgˑ)
 * @retval	E_QOVR	L[CO܂̓lXg̃I[o[t[(L[COsemcnt̃I[o[t[)
 * @retval	EN_OBJNO	Ώۃm[hŃANZXłȂIuWFNgԍw
 * @retval	EN_CTXID	^XNƗ邢̓fBXpb`֎~Ԃ̃^XN甭sꂽVXeR[őm[h̃IuWFNgw
 */
ER sig_sem(ID semid)
{
	ER result;

	result = isig_sem(semid);
	if(E_OK == result)
	{
		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return result;
}

/**
 * @brief	Z}tHԋpi^XNƗj
 *
 * @param	semid	Z}tHID
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_ID	sIDԍ(semids邢͗płȂ)
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(semid̃Z}tH݂Ȃ)
 * @retval	E_OACV	IuWFNgANZXᔽ([U^XN̔ssemid<(-4), Cvgˑ)
 * @retval	E_QOVR	L[CO܂̓lXg̃I[o[t[(L[COsemcnt̃I[o[t[)
 * @retval	EN_OBJNO	Ώۃm[hŃANZXłȂIuWFNgԍw
 * @retval	EN_CTXID	^XNƗ邢̓fBXpb`֎~Ԃ̃^XN甭sꂽVXeR[őm[h̃IuWFNgw
 */
ER isig_sem(ID semid)
{
	ER result;

	if(ISVALID_SEMID(semid))
	{
		T_SEMCB *p_semcb;

		p_semcb = &(semcbs[semid]);

		depend_EnterCriticalSection();

		if(0 != p_semcb->semid)
		{
			if(lst_empty(&(p_semcb->wtsklst)))
			{
				if(p_semcb->semcnt < p_semcb->maxsem)
				{
					(p_semcb->semcnt)++;

					result = E_OK;
				}
				else
				{
					result = E_QOVR;
				}
			}
			else
			{
				tsk_wait_release((T_TCB *)(p_semcb->wtsklst.p_next), E_OK);

				result = E_OK;
			}
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_ID;
	}

	return result;

#if 0
	ER ercd;
	T_SEMCB *p_semq;
	T_TCB *p_tcb;

	/*-------------------- p[^G[ ---------------------*/
	if(! ISVALID_SEMID(semid))
	{
		/* ID͈͊O */
		return E_ID;
	}

	p_semq = &(semcbs[semid]);
	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	/* ݂̃^XNɃZ}tHlĂȂA	*/
	/* ȂŐI							*/
	if(p_semq->tskid != p_tcb->tskid)				/* ɃZ}tHlς?	*/
	{
		return E_OK;
	}

	if(NULL == p_semq->head)
	{
		/*----------------- Z}tH҂̃^XNȂ ------------------*/

		/*if( p_semq->semcnt == 1 ){*/
			/*printf( "[os] sig_sem(%d)(tskid %d) error semcnt > 1\n",*/
						/*semid, TSK_SELF );*/
			/*return( E_OK );*/
		/*}*/

		(p_semq->semcnt)++;			/* L[CO */

		p_semq->tskid = 0;			/* Z}Ă^XN͂Ȃ */

		if(p_semq->maxsem < p_semq->semcnt)	/* L[CÕI[ot[? */
		{
			(p_semq->semcnt)--;
			return E_QOVR;
		}
	}
	else
	{
		/*------------------ ҂^XNɎ^ -------------------*/
		p_tcb = p_semq->head;						/* 擪̃Z}҂^XN  */

		del_semq(p_semq, p_tcb);						/* SEMQ  TCB O  */

		if(p_tcb->tskstat & TTS_SUS)
		{
			/* d҂ */
			p_tcb->tskstat = TTS_SUS;				/* ^XNԂ SUSPEND 	*/
		}
		else
		{
			p_tcb->tskstat = TTS_RDY;				/* ^XNԂ READY  */
			p_tcb->tskwait = 0;
			p_tcb->wid = 0;

			/* bZ[W҂ */
			add_rdq(p_tcb);						/* RDQ  TCB Ȃ */
		}

		p_semq->tskid = p_tcb->tskid;	/* Z}Ă^XNL^Ă */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return E_OK;
#endif
}

/**
 * @brief	Z}tHl
 *
 * @param	semid	Z}tHID
 * @return	G[R[h
 * @retval
 */
ER wai_sem(ID semid)
{
	return twai_sem(semid, TMO_FEVR);
}

/**
 * @brief	Z}tHl(|[O)
 */
ER preq_sem(ID semid)
{
	return twai_sem(semid, TMO_POL);
}

/**
 * @brief	Z}tHl(^CAEgL)
 */
ER twai_sem(ID semid, TMO tmout)
{
	ER result;

	if(ISVALID_SEMID(semid))
	{
		if(ISVALID_TMOUT(tmout))
		{
			T_SEMCB *p_semcb;

			p_semcb = &(semcbs[semid]);

			depend_EnterCriticalSection();

			if(0 < p_semcb->semcnt)						/* ? */
			{
				(p_semcb->semcnt)--;

				result = E_OK;
			}
			else
			{
				if(TMO_POL != tmout)
				{
					ER ret;
					T_TCB *p_tcb;

					ret = tsk_get_tcb(TSK_SELF, &p_tcb);
					if(E_OK == ret)
					{
						lst_delete((T_LST *)p_tcb);	/* rdqO */

						p_tcb->p_wercd = &result;
						p_tcb->tskstat = TTS_WAI;
						p_tcb->tskwait = TTW_SEM;
						p_tcb->wid = semid;		/* Z}hcݒ                  */

// TODO						tsk_go_wait(p_tcb);
					}
					else
					{
						result = ret;
					}
				}
				else
				{
					result = E_TMOUT;
				}

#if 0 // u
				ER ret;
				T_TCB *p_tcb;

				ret = tsk_get_tcb(TSK_SELF, &p_tcb);
				if(E_OK == ret)
				{
					del_rdq(p_tcb);			/* RDQ  TCB O             */

					p_tcb->tskstat = TTS_WAI;
					p_tcb->tskwait = TTW_SEM;
					p_tcb->wid = semid;		/* Z}hcݒ                  */

					add_semq(p_semcb, p_tcb);		/* SEMQ  TCB Ȃ            */

					/* fBXpb`܂ő҂ */
					tsk_wait_dispatch();

					result = E_OK;
				}
				else
				{
					result = ret;
				}
#endif
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;

#if 0 // wai_sem
	ER ercd;									/* Ăяo֐̖߂l	*/
	T_SEMCB *p_semq;
	T_TCB *p_tcb;


//	if( DSPENA == OFF )	{		/* fBXpb`֎~ */
//		return( E_CTX );
//	}

	/*-------------------- p[^G[ ---------------------*/
	if((semid < 0) || (TNUM_SEM <= semid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_semq = &semcbs[semid];
	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	if(0 < p_semq->semcnt)						/* ? */
	{
		(p_semq->semcnt)--;
		p_semq->tskid = p_tcb->tskid;	/* Z}Ă^XNL^ */

		return E_OK;
	}
	else
	{
		/* Ȃ҂ɂ */

		if(p_semq->tskid == p_tcb->tskid )	/* ^XNő҂ƂƂĂ? */
		{
			/* ɃZ}tHmۂĂ^XN */
			/* ēxZ}tHl悤ƂĂȂA*/
			/* ҂ƂȂ */
			return E_OK;
		}

		del_rdq(p_tcb);			/* RDQ  TCB O             */

		p_tcb->sts = ((TTW_SEM << 8) | TTS_WAI);	/* ^XNԂ WAITiZ}҂j */
		p_tcb->tskstat = TTS_WAI;
		p_tcb->tskwait = TTW_SEM;
		p_tcb->wid = semid;		/* Z}hcݒ                  */

		add_semq(p_tcb);		/* SEMQ  TCB Ȃ            */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return E_OK;
#endif

#if 0 /* preq_sem */

	ER ercd;
	T_SEMCB *p_semq;
	T_TCB *p_tcb;

	/*-------------------- p[^G[ ---------------------*/
	if(! ISVALID_SEMID(semid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_semq = &(semcbs[semid]);

	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	if(0 < p_semq->semcnt)						/* ? */
	{
		(p_semq->semcnt)--;
		p_semq->tskid = p_tcb->tskid;
	}
	else
	{
		/* Ȃ */
		return E_TMOUT;
	}

	return E_OK;
#endif
}

/**
 * @brief	Z}tHԎQ
 *
 * @param	pk_rsem	Z}tHԂԂpPbgAhX
 * @param	semid	Z}tHID
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_ID	sIDԍ(semids邢͗płȂ)
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(semid̃Z}tH݂Ȃ)
 * @retval	E_OACV	IuWFNgANZXᔽ([U^XN̔ssemid<(-4), Cvgˑ)
 * @retval	E_PAR	p[^G[(^[p[^p̃pPbgAhXgpłȂl)
 * @retval	EN_OBJNO	Ώۃm[hŃANZXłȂIuWFNgԍw
 * @retval	EN_CTXID	^XNƗ邢̓fBXpb`֎~Ԃ̃^XN甭sꂽVXeR[őm[h̃IuWFNgw
 * @retval	EN_RPAR	vm[hʐMpPbgŃT|[gĂȂ͈͂̒l^[p[^ƂĕԂꂽ(exinf, wtsk, semcntvm[hŕ\łl͈̔͊O)
 */
ER ref_sem(T_RSEM *pk_rsem, ID semid)
{
	ER result;

	if(ISVALID_SEMID(semid))
	{
		if(ISVALID_PTR(pk_rsem))
		{
			T_SEMCB *p_semcb;

			EnterCriticalSection();

			p_semcb = &(semcbs[semid]);

			if(0 != p_semcb->semid)
			{
				pk_rsem->exinf = p_semcb->exinf;
				pk_rsem->wtsk = (lst_empty(&(p_semcb->wtsklst))) ? FALSE : ((T_TCB *)(p_semcb->wtsklst.p_next))->tskid;
				pk_rsem->semcnt = p_semcb->semcnt;

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}

			LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

#if 0
/*--------------------------------------------------------------------------*/
/*             ^XN̎ĂZ}iIpj           */
/*--------------------------------------------------------------------------*/
ER edel_sem(ID semid)
{
	ER ercd;
	T_SEMCB *p_semq;
	T_TCB *p_tcb;

	/*-------------------- p[^G[ ---------------------*/
	if((semid < 0) || (TNUM_SEM <= semid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_semq = &(semcbs[semid]);

	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	if(p_semq->tskid != p_tcb->tskid)
	{
		/* ^XNZ}lĂȂꍇ */
		return E_OBJ;
	}

	if(p_semq->head == NULL)
	{
		/*- Z}tH҂̃^XNȂ -*/
		p_semq->semcnt = 1;
		p_semq->tskid = 0;
	}
	else
	{
		/*- ҂^XNɎ^ -*/

		p_tcb = p_semq->head;					/* 擪̃Z}҂^XN  */
		del_semq(p_semq, p_tcb);						/* SEMQ  TCB O  */
		add_rdq(p_tcb);							/* RDQ  TCB Ȃ */
		p_tcb->tskstat = TTS_RDY;					/* ^XNԂ READY  */
		p_tcb->tskwait = 0;
		p_tcb->wid = 0;
		p_semq->tskid = p_tcb->tskid;			/* ^XNL^ */
	}

	/* fBXpb`܂ő҂ */
	tsk_wait_dispatch();

	return E_OK;
}

/*--------------------------------------------------------------------------*/
/*	Z}tHɑ΂M( ʃ^XNŊlZ}tHɑ΂ĂL )	*/
/*--------------------------------------------------------------------------*/
ER fsig_sem(ID semid)
{
	T_SEMCB *p_semq;
	T_TCB *p_tcb;

	/*-------------------- p[^G[ ---------------------*/
	if((semid < 0) || (TNUM_SEM <= semid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_semq = &(semcbs[semid]);

	if(NULL == p_semq->head)
	{
		/*----------------- Z}tH҂̃^XNȂ ------------------*/
		(p_semq->semcnt)++;						/* L[CO */

		p_semq->tskid = 0;					/* Z}Ă^XN͂Ȃ */

		if(0 == p_semq->semcnt)					/* L[CÕI[ot[ */
		{
			(semcbs->semcnt)--;
			return E_QOVR;
		}
	}
	else
	{
		/*------------------ ҂^XNɎ^ -------------------*/
		p_tcb = semcbs->head;						/* 擪̃Z}҂^XN  */

		del_semq(p_semq, p_tcb);						/* SEMQ  TCB O  */

		if(p_tcb->tskstat & TTS_SUS)
		{
			/* d҂ */
			p_tcb->tskstat = TTS_SUS;				/* ^XNԂ SUSPEND  */
		}
		else
		{
			/* bZ[W҂ */
			p_tcb->tskstat = TTS_RDY;				/* ^XNԂ READY  */
			p_tcb->tskwait = 0;
			p_tcb->wid = 0;
			add_rdq(p_tcb);						/* RDQ  TCB Ȃ */
		}

		p_semq->tskid = p_tcb->tskid;	/* Z}Ă^XNL^Ă */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return E_OK;
}
#endif

#if	defined(__cplusplus)
}
#endif	/* defined(__cplusplus) */
