#include <stdio.h>
#include <string.h>

#include "kernel.h"

#include "tsk.h"

extern T_LST rdq[];

/* fBL[Ƀ^XNǉ */
ER add_rdq(T_TCB *p_tcb)
{
	lst_insert(&(rdq[p_tcb->tskpri]), (T_LST *)p_tcb);

	return E_OK;
}

/* fBL[^XN폜 */
void del_rdq(T_TCB *p_tcb)
{
	lst_delete((T_LST *)p_tcb);
}

#if 0 // move to flg.c
/*--------------------------------------------------------------------------*/
/*                 CxgtO҂L[Ƀ^XNǉ                   */
/*--------------------------------------------------------------------------*/
void add_flgq(T_FLGCB *p_flgcb, T_TCB *p_tcb)
{

	if(TA_TPRI & p_flgcb->flgatr)
	{
		T_LST *p_insert_pos;

		p_insert_pos = p_flgcb->wtsklst.p_next;

		while(&(p_flgcb->wtsklst) != p_insert_pos)
		{
			if(p_tcb->tskpri < ((T_TCB *)p_insert_pos)->tskpri)
			{
				break;
			}

			p_insert_pos = p_insert_pos->p_next;
		}

		lst_insert(p_insert_pos, (T_LST *)p_tcb);
	}
	else
	{
		lst_insert(&(p_flgcb->wtsklst), (T_LST *)p_tcb);
	}

#if 0 // T_LSTֈڍŝŎĝ߂
	T_FLGCB *p_flgq;
	T_TCB *toptcb, *endtcb, *nextcb, *pretcb;

	p_flgq = &flgq[addtcb->wid];

	toptcb = p_flgq->head;
	if(NULL != toptcb)
	{
		/*-------------------- ̃^XN --------------------*/
		if( p_flgq->wtskmode == TA_TFIFO )	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endtcb       = toptcb->prev;
			addtcb->prev = endtcb;
			addtcb->next = toptcb;
			toptcb->prev = addtcb;
			endtcb->next = addtcb;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endtcb = toptcb->prev;
			nextcb = toptcb;

			do
			{
				if( addtcb->pri < nextcb->pri )
				{
					pretcb = nextcb->prev;

					addtcb->prev = pretcb;
					addtcb->next = nextcb;
					nextcb->prev = addtcb;
					pretcb->next = addtcb;

					if( nextcb == toptcb )
					{
						p_flgq->head = addtcb;
					}

					break;
				}

				nextcb = nextcb->next;
			} while((nextcb != toptcb) && (p_flgq->head != NULL));

			if( nextcb == toptcb )
			{
				addtcb->prev = endtcb;
				addtcb->next = toptcb;
				toptcb->prev = addtcb;
				endtcb->next = addtcb;
			}
		}

		(p_flgq->wtskcnt)++;				/* ҂^XNZ */
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_flgq->head   = addtcb;
		addtcb->next = addtcb;
		addtcb->prev = addtcb;

		p_flgq->wtskcnt = 1;					/* ҂^XN͂P */
	}

	return;
#endif
}

/*--------------------------------------------------------------------------*/
/*                CxgtO҂L[^XN폜                  */
/*--------------------------------------------------------------------------*/
void del_flgq(T_FLGCB *p_flgcb, T_TCB *p_tcb)
{
	lst_delete((T_LST *)p_tcb);

#if 0 // T_LSTֈڍŝŎĝ߂
	T_FLGCB	*p_flgq;
	T_TCB	*pretcb, *nextcb;

	p_flgq = &flgq[deltcb->wid];

	if( (pretcb = deltcb->prev) != deltcb )
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = deltcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;
		if( p_flgq->head == deltcb )
		{
			p_flgq->head = nextcb;
		}

		( p_flgq->wtskcnt )--;		/* ҂^XNZ */
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_flgq->head = NULL;

		p_flgq->wtskcnt = 0;			/* ҂^XN͂O */
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
#endif
}
#endif

#if 0 // move to sem.c
/*--------------------------------------------------------------------------*/
/*                    Z}tH҂L[Ƀ^XNǉ                      */
/*--------------------------------------------------------------------------*/
void add_semq( T_TCB *addtcb )
{
	T_SEMCB *p_semq;
	T_TCB *toptcb, *endtcb, *nextcb, *pretcb;

	p_semq = &(semq[addtcb->wid]);

	toptcb = semq->head;
	if(NULL != toptcb)
	{
		/*-------------------- ̃^XN --------------------*/

		if( semq->wtskmode == TA_TFIFO )	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endtcb       = toptcb->prev;
			addtcb->prev = endtcb;
			addtcb->next = toptcb;
			toptcb->prev = addtcb;
			endtcb->next = addtcb;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endtcb = toptcb->prev;
			nextcb = toptcb;

			do
			{
				if( addtcb->pri < nextcb->pri )
				{

					pretcb = nextcb->prev;

					addtcb->prev = pretcb;
					addtcb->next = nextcb;
					nextcb->prev = addtcb;
					pretcb->next = addtcb;

					if( nextcb == toptcb )
					{
						p_semq->head = addtcb;
					}
					break;
				}

				nextcb = nextcb->next;

			} while((nextcb != toptcb) && (p_semq->head != NULL));

			if(nextcb == toptcb)
			{
				addtcb->prev = endtcb;
				addtcb->next = toptcb;
				toptcb->prev = addtcb;
				endtcb->next = addtcb;
			}
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_semq->head = addtcb;
		addtcb->next = addtcb;
		addtcb->prev = addtcb;
	}

	return;
}

/*--------------------------------------------------------------------------*/
/*                   Z}tH҂L[^XN폜                     */
/*--------------------------------------------------------------------------*/
void del_semq( T_TCB *deltcb )
{
	T_SEMCB *p_semq;
	T_TCB *pretcb, *nextcb;

	p_semq = &(semq[deltcb->wid]);

	pretcb = deltcb->prev;
	if(pretcb != deltcb)
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = deltcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;

		if( p_semq->head == deltcb )
		{
			p_semq->head = nextcb;
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		semq->head = NULL;
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
}
#endif
#if 0 // move to msg.c
/*--------------------------------------------------------------------------*/
/*                   bZ[W҂L[Ƀ^XNǉ                     */
/*--------------------------------------------------------------------------*/
void add_mbxq(T_TCB *addtcb)
{
	T_MBXCB *p_mbxq;
	T_TCB *toptcb, *endtcb, *nextcb, *pretcb;

	p_mbxq = &(mbxq[addtcb->wid]);

	toptcb = p_mbxq->head;
	if(NULL != toptcb)
	{
		/*-------------------- ̃^XN --------------------*/
		if(p_mbxq->wtskmode == TA_TFIFO)	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endtcb       = toptcb->prev;
			addtcb->prev = endtcb;
			addtcb->next = toptcb;
			toptcb->prev = addtcb;
			endtcb->next = addtcb;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endtcb = toptcb->prev;
			nextcb = toptcb;

			do
			{
				if( addtcb->pri < nextcb->pri )
				{
					pretcb = nextcb->prev;

					addtcb->prev = pretcb;
					addtcb->next = nextcb;
					nextcb->prev = addtcb;
					pretcb->next = addtcb;

					if( nextcb == toptcb )
					{
						p_mbxq->head = addtcb;
					}
					break;
				}

				nextcb = nextcb->next;

			} while( (nextcb != toptcb)&&(mbxq->head != NULL) );

			if( nextcb == toptcb )
			{
				addtcb->prev = endtcb;
				addtcb->next = toptcb;
				toptcb->prev = addtcb;
				endtcb->next = addtcb;
			}
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		mbxq->head   = addtcb;
		addtcb->next = addtcb;
		addtcb->prev = addtcb;
	}

	return;
}

/*--------------------------------------------------------------------------*/
/*                  bZ[W҂L[^XN폜                    */
/*--------------------------------------------------------------------------*/
void del_mbxq(T_TCB *deltcb)
{
	T_MBXCB *p_mbxq;
	T_TCB *pretcb, *nextcb;

	p_mbxq = &(mbxq[deltcb->wid]);

	pretcb = deltcb->prev;
	if(pretcb != deltcb)
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = deltcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;
		if(p_mbxq->head == deltcb)
		{
			mbxq->head = nextcb;
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		mbxq->head = NULL;
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
}
#endif
#if 0 // move to msg.c
/*--------------------------------------------------------------------------*/
/*                   bZ[WL[ɃbZ[Wǉ                     */
/*--------------------------------------------------------------------------*/
void add_msg(ID mbxid, T_MSG *addmsg)
{
	T_MBXCB *p_mbxq;
	T_MSG *topmsg, *endmsg, *nexmsg, *premsg;

	p_mbxq = &(mbxq[mbxid]);

	topmsg = mbxq->msg;
	if(topmsg != NULL)
	{
		/*-------------------- ̃bZ[W --------------------*/
		if( mbxq->wmsgmode == TA_TFIFO )	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endmsg       = topmsg->pk_prev;
			addmsg->pk_prev = endmsg;
			addmsg->pk_next = topmsg;
			topmsg->pk_prev = addmsg;
			endmsg->pk_next = addmsg;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endmsg = topmsg->pk_prev;
			nexmsg = topmsg;

			do
			{
				if( tcb[addmsg->tskid].pri < tcb[nexmsg->tskid].pri )
				{
					premsg = nexmsg->pk_prev;

					addmsg->pk_prev = premsg;
					addmsg->pk_next = nexmsg;
					nexmsg->pk_prev = addmsg;
					premsg->pk_next = addmsg;

					if( nexmsg == topmsg )
					{
						mbxq->msg = addmsg;
					}

					break;
				}

				nexmsg = nexmsg->pk_next;

			} while( (nexmsg != topmsg)&&(mbxq->msg != NULL) );

			if( nexmsg == topmsg )
			{
				addmsg->pk_prev = endmsg;
				addmsg->pk_next = topmsg;
				topmsg->pk_prev = addmsg;
				endmsg->pk_next = addmsg;
			}
		}
	}
	else
	{
		/*-------------------- ̃bZ[WȂ --------------------*/
		mbxq->msg    = addmsg;
		addmsg->pk_next = addmsg;
		addmsg->pk_prev = addmsg;
	}

	return;
}

/*--------------------------------------------------------------------------*/
/*                  bZ[WL[烁bZ[W폜                    */
/*--------------------------------------------------------------------------*/
void del_msg(ID mbxid, T_MSG *delmsg)
{
	T_MBXCB *p_mbxq;
	T_MSG *premsg, *nexmsg;

	p_mbxq = &(mbxq[mbxid]);

	premsg = delmsg->pk_prev;
	if(premsg != delmsg )
	{
		/*-------------------- ̃bZ[W --------------------*/
		nexmsg       = delmsg->pk_next;
		premsg->pk_next = nexmsg;
		nexmsg->pk_prev = premsg;

		if(p_mbxq->msg == delmsg)
		{
			mbxq->msg = nexmsg;
		}
	}
	else
	{
		/*-------------------- ̃bZ[WȂ --------------------*/
		p_mbxq->msg = NULL;
	}

	delmsg->pk_next  = NULL;
	delmsg->pk_prev  = NULL;

	return;
}
#endif

/*--------------------------------------------------------------------------*/
/*                     ^C}҂L[Ƀ^XNǉ                       */
/*--------------------------------------------------------------------------*/
void add_timq(T_TCB *addtcb)
{
	T_TIMQ *p_timq;
	T_TCB *toptcb, *endtcb, *pretcb, *nextcb;

	p_timq = &(timq);

	toptcb = p_timq->head;
	/*-------------------- ̃^XN --------------------*/
	if(toptcb != NULL )
	{
		endtcb = toptcb->prev;
		nextcb = toptcb;

		do
		{
			if(addtcb->tmout < nextcb->tmout)
			{
				pretcb = nextcb->prev;

				addtcb->prev = pretcb;
				addtcb->next = nextcb;
				nextcb->prev = addtcb;
				pretcb->next = addtcb;

				if(nextcb == toptcb)
				{
					p_timq->head = addtcb;
				}

				break;
			}

			nextcb = nextcb->next;

		} while( (nextcb != toptcb)&&(p_timq->head != NULL) );

		if( nextcb == toptcb )
		{
			addtcb->prev = endtcb;
			addtcb->next = toptcb;
			toptcb->prev = addtcb;
			endtcb->next = addtcb;
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_timq->head   = addtcb;
		addtcb->next = addtcb;
		addtcb->prev = addtcb;
	}

	return;
}


/*--------------------------------------------------------------------------*/
/*                  bZ[W҂L[^XN폜                    */
/*--------------------------------------------------------------------------*/
void del_timq(T_TCB *deltcb)
{
	T_TIMQ *p_timq;
	T_TCB *pretcb, *nextcb;

	p_timq = &timq;

	pretcb = deltcb->prev;
	if(pretcb != deltcb )
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = deltcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;

		if( p_timq->head == deltcb )
		{
			p_timq->head = nextcb;
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_timq->head = NULL;
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
}

#if 0
/*--------------------------------------------------------------------------*/
/*                           fBXpb`vL                           */
/*--------------------------------------------------------------------------*/
ER		dispatch( errcode )
REG ER		errcode;
{
		DISPATCH = ON;
		return( errcode );
}
/*--------------------------------------------------------------------------*/
/*                         Ɏs^XN                         */
/*--------------------------------------------------------------------------*/
//#include "irqdef.h"
UH		next_tsk()
{
	T_RDQ	*rdq;

	if( DISPATCH == OFF )	return( OFF );	/* fBXpb`vȂ */
	if( DSPENA == OFF )		return( OFF );	/* fBXpb`֎~	*/

	rdq = &RDQ[ 0 ];

	while(1){
		if( rdq->head != NULL )	break;
		rdq++;
	}
	DISPATCH = OFF;

	if( rdq->head == NOW_TCB )	return( OFF );	/* XCb`OKvȂ */

	NEXT_TCB = rdq->head;			/* s^XN TCB AhX */
	return( ON );
}
#endif

/*--------------------------------------------------------------------------*/
/*                      _^C}i10msɂPNj                    */
/*--------------------------------------------------------------------------*/
void os_timer(void)
{
	T_TCB *p_tcb;
	T_TIMQ *p_timq;

//	os_cyc(1);
//	os_alm(1);

	p_timq = &timq;

	(p_timq->time)++;		/* ^C}JEgAbvi10msPʁj */

	p_tcb = p_timq->head;

	while(NULL != p_tcb)	/* ^C}҂̃^XN */
	{
		if(p_tcb->tmout <= p_timq->time)			/* ^CAEg */
		{
			del_timq(p_tcb);					/* TIMQ  TCB O */

			if(TTW_FLG & p_tcb->tskwait)	/* CxgtO҂ */
			{
				T_TCBTMO *tcbtmo = (T_TCBTMO *)p_tcb;	/* tricky! */
				p_tcb = tcbtmo->tcb;	/* TCB ̖{ */

				tcbtmo->sts = 0;

// TODO				del_flgq(p_tcb);		/* FLGQ  TCB O */

//				((T_TSKCTX *)p_tcb->sp)->r0 = E_TMOUT;
				/* G[R[h|[Os܂̓^CAEg */
			}

			if(p_tcb->tskstat & TTS_SUS )
			{
				/* d҂ */
				p_tcb->tskstat = TTS_SUS;		/* ^XNԂ SUSPEND  */
			}
			else
			{
				/* ԑ҂ */
// TODO				add_rdq(p_tcb);					/* RDQ  TCB Ȃ */
				p_tcb->tskstat = TTS_RDY;			/* ^XNԂ READY  */
			}

//			DISPATCH = ON;
		}
		else
		{
			break;
		}
	}

	return;
}
